<?php
defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');

/**
 * @property $db
 */
class Customerapiv2 extends CI_Controller
{
    use \App\ShiftsData\AddressesFromShiftTrait;

    public function __construct()
    {
        parent::__construct();
        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400'); // cache for 1 day
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper('date');
        $this->load->model('cabmodel');
        $this->load->model('common');
        $this->load->library('smsnotifier');
        $this->load->library('sendfirebase');
        $this->load->library("statusintigration");
        /*log_message("info", json_encode(array(
            "uri_string"   => current_url(),
            "query_params" => $_REQUEST,
        )));*/
    }
    public function index()
    {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }
    public function driverLogin()
    {
        $response = array();
        $response = array("status" =>"0", "data" => "Not Found");
        if (isset($_POST)) {
            $mobile = isset($_POST["mobile"]) ? $_POST["mobile"] : '';
            $pwd    = isset($_POST["password"]) ? $_POST["password"] : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            $imei   = isset($_POST["imei"]) ? $_POST["imei"] : '';
            $phone   = isset($_POST["mobile_number"]) ? $_POST["mobile_number"] : '';
            if ($mobile != "") {
                $password = password_hash($pwd,PASSWORD_DEFAULT);
                /*check for customer login*/
                $whr = array("d.phone" => $mobile, "d.password" => $password, "d.status" => 1);
                $this->db->select('d.*,u.mobile_no,u.default_currency as currency');
                $this->db->from('tb_customers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql     = $this->db->get();
                $numrows = $sql->num_rows();
                $insdata = array("mobile" => $mobile, "password" => $pwd, "imei" => $imei, "status" => $numrows);
                $res     = $this->db->insert("tb_employee_login_logs", $insdata);
                if ($numrows > 0) {
                    $id = $sql->row()->id;
                    if ($gcm_id != "" && $imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei, "gcm_id" => $gcm_id));
                    } else if ($imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei));
                    }
                    $data = $sql->row_array();
                    $data['child_id'] = "";
                    $countrytimezone = "Asia/Singapore";
                    $chkcntry = $this->db->select("cntry_timezone")->get_where("tbl_country_master",array("country_code"=>$data['country']),1,0);
                    if($chkcntry->num_rows()>0){
                        $countrytimezone = $chkcntry->row()->cntry_timezone;
                    }
                    $data['timezone'] = $countrytimezone;
                    $response = array("status" => 2, "data" => $data);
                } else {
                    $cust = $this->db->query("
                        SELECT id,name,countrycode,parent_id,user_id
                        FROM tb_customer_logins
                        WHERE
                              (code = ? OR email_id = ?)
                              AND password = ?
                              AND status = 1
                    ", [
                        $mobile,
                        $mobile,
                        $pwd
                    ]);

                    if ($cust->num_rows() > 0) {
                        $custchild = $cust->row()->id;
                        $custname  = $cust->row()->name;
                        $custid = $cust->row()->parent_id;
                        $cntrycode = $cust->row()->countrycode;
                        $whr = array("d.id" => $custid, "d.status" => 1);
                        $this->db->select('d.*,u.mobile_no,u.default_currency as currency');
                        $this->db->from('tb_customers d');
                        $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                        $this->db->where($whr);
                        $this->db->limit(1);
                        $sql = $this->db->get();
                        $numrows = $sql->num_rows();
                        $insdata = array("mobile" => $mobile, "password" => $pwd, "imei" => $imei, "status" => $numrows);
                        $res = $this->db->insert("tb_employee_login_logs", $insdata);
                        if ($numrows > 0) {
                            $id = $sql->row()->id;
                            if ($gcm_id != "" && $imei != "") {
                                $upd = $this->db->where("id", $id)->update("tb_customer_logins", array("imei" => $imei, "gcm_id" => $gcm_id));
                            } else if ($imei != "") {
                                $upd = $this->db->where("id", $id)->update("tb_customer_logins", array("imei" => $imei));
                            }
                            $data = $sql->row_array();
                            $data['name'] = $custname;
                            $data['child_id'] = $custchild;
                            $countrytimezone = "Asia/Singapore";
                            $chkcntry = $this->db->select("cntry_timezone")->get_where("tbl_country_master",array("country_code"=>$cntrycode),1,0);
                            if($chkcntry->num_rows()>0){
                                $countrytimezone = $chkcntry->row()->cntry_timezone;
                            }
                            $data['timezone'] = $countrytimezone;
                            $response = array("status" => 2, "data" => $data);
                        }
                    } else {
                        $response = array("status" => 0, "data" => "Not Found");
                    }
                }
            } else {
                $response = array("status" =>"0", "data" => "Not Found");
            }
        }
        echo json_encode($this->printable($response));
    }

    public function customershipments()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $ord_id = isset($_POST['search']) ? $_POST['search'] : '';
        $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
        if($curtz == ""){
            $curtz = "Asia/Singapore";
        }
        if ($cust_id > 0 && $user_id > 0) {

            $refs = [];
            if ($ord_id != "") {
                $refs = $this->getordersbyrefid($ord_id);
            }
            $query = $this->db
                ->select([
                    's.id as shift_id',
                    's.user_id',
                    "convertToClientTZ(s.startdate,'$curtz') as stime",
                    "convertToClientTZ(s.enddate,'$curtz') as etime",
                    "s.trip_type,convertToClientTZ(s.startdate,'$curtz') as startdate",
                    "convertToClientTZ(s.enddate,'$curtz') as enddate",
                    's.splace',
                    's.eplace',
                    's.scity',
                    's.dcity',
                    's.slat',
                    's.slng',
                    's.elat',
                    's.elng',
                    's.shipmentid',
                    'e.order_id',
                    'SUM(e.shipment_weight) as shipweight',
                    'SUM(e.shipment_volume) as shipvolume',
                    'SUM(e.no_of_pkgs) as numpkgs',
                    'e.pkgitemid as material',
                    'e.order_id'
                ])
                ->from('tb_shifts s,tb_shiporder_stops o,tb_employee e')
                ->where('s.id = o.shipment_id')
                ->where('s.id = e.shift_id')
                ->where([
                    'e.customer_id' => $cust_id,
                    's.user_id' => $user_id,
                    's.status' => 1
                ]);
            if (!empty($refs)) {
                $query->where_in('e.order_id', $refs);
            }else{
                $query->group_start()->or_where([
                    's.shipmentid' => $ord_id,
                    'e.order_id' => $ord_id
                ])->group_end();
            }

            $query = $query
                ->group_by('s.id')
                ->order_by('s.id', 'DESC')
                ->get();
            $res = array();
            if ($query->num_rows() > 0) {
                $i = 0;
                foreach ($query->result_array() as $d) {
                    [$pickup, $drop] = $this->addressesFromShift($d);
                    $d["splace"] = $pickup;
                    $d["eplace"] = $drop;
                    $qry = $this->db->select([
                            'id',
                            'transit_status'
                        ])->where([
                            'shift_id' => $d['shift_id'],
                            'status' => 1
                        ])
                        ->from('tb_trips')
                        ->order_by('id', 'DESC')
                        ->limit(1)
                        ->get();

                    if($qry->num_rows() == 0){
                        $d['id'] = 0;
                        $d['sno'] = $i;
                        $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                        $d['distance']  = $dist['disttext'];
                        $d['duration']  = $dist['duratext'];
                        $d['startdate'] = strtotime($d['startdate']);
                        $d['enddate'] = strtotime($d['enddate']);
                        $d['astatus'] = "";
                        $d['pod'] = "";
                        $d['signature'] = "";
                        $d['ref_id'] = $this->getrefsbyorder($d['order_id']);
                        $d['recent_status'] = "1";
                        $res['trips'][] = $d;
                        $i++;
                    } else {
                        $sts = $qry->row()->transit_status;
                        $d['id'] = $qry->row()->id;
                        $d['sno'] = $i;
                        $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                        $d['distance']  = $dist['disttext'];
                        $d['duration']  = $dist['duratext'];
                        $d['startdate'] = strtotime($d['startdate']);
                        $d['enddate']   = strtotime($d['enddate']);
                        $d['astatus'] = $sts;
                        $d['ref_id'] = $this->getrefsbyorder($d['order_id']);
                        $d['recent_status'] = "3";
                        $res['trips'][] = $d;
                        $i++;
                    }
                }
                $response = array("status" =>"1", "data" => $res);
            } else {
                $response = array("status" =>"0", "data" => "Not Found");
            }
        } else {
            $response = array("status" =>"0", "data" => "Something went wrong,please try again!");
        }
        echo json_encode($this->printable($response));
    }

    /**
     * @param $ordid
     * @return string
     */
    public function getrefsbyorder($ordid): string
    {
        $res = "";
        if ($ordid != "") {
            $chk = $this->db
                ->select('r.ref_value')
                ->where('o.id = r.order_id')
                ->where('o.order_id', $ordid)
                ->from('tb_orders o,tb_order_references r')
                ->get();
            if ($chk->num_rows() > 0) {
                foreach ($chk->result() as $rf) {
                    $res .= ", ".$rf->ref_value;
                }
            }
        }
        return $res;
    }

    /**
     * @param $refid
     * @return array
     */
    public function getordersbyrefid($refid): array
    {
        $res = array();
        if ($refid != "") {
            $chk = $this->db
                ->select('o.order_id')
                ->where('o.id = r.order_id')
                ->where('r.ref_value', $refid)
                ->from('tb_orders o,tb_order_references r')
                ->get();

            if($chk->num_rows()>0){
                foreach($chk->result() as $rf){
                    $res[] = $rf->order_id;
                }
            }
        }
        return $res;
    }

    /**
     * @param $ship_id
     * @return array
     */
    private function getvehdriverbyship($ship_id): array
    {
        $response = array();
        $gettrip = $this->db->query("
            SELECT id, vehicle_id, driver_id
            FROM tb_trips
            WHERE
                shift_id = ?
                AND status = 1
            ORDER BY id DESC
        ", [
            $ship_id
        ]);
        if ($gettrip->num_rows() > 0) {
            $response['trip'] = $gettrip->row()->id;
            $driverid = $gettrip->row()->driver_id;
            $driver = $this->db->select('name,contact_num')->get_where('tb_truck_drivers',array('id'=>$driverid),1,0);
            $response['drivername'] = $driver->row()->name;
            $response['drivermobile'] = $driver->row()->contact_num;
            $vehicleid = $gettrip->row()->vehicle_id;
            $vehicle = $this->db->select('register_number')->get_where('tb_trucks_data',array('id'=>$vehicleid),1,0);
            $response['vehicleno'] = $vehicle->row()->register_number;
        }else{
            $response['trip'] = 0;
            $qry = $this->db->query("
                SELECT v.register_number,d.name,d.contact_num
                FROM tb_shft_veh v,tbl_assigned_drivers a,tb_truck_drivers d
                WHERE
                    v.shft_id = ?
                    AND v.vehicle_id = a.vehicle_id
                    AND a.driver_id = d.id
                    AND v.status = 1
                    AND a.status = 1
                ORDER BY v.id DESC
                LIMIT 1
            ", [
                $ship_id
            ]);
            if($qry->num_rows()>0){
                $response['drivername'] = $qry->row()->name;
                $response['drivermobile'] = $qry->row()->contact_num;
                $response['vehicleno'] = $qry->row()->register_number;
            }else{
                $response['drivername'] = "";
                $response['drivermobile'] = "";
                $response['vehicleno'] = "";
            }
        }
        return $response;
    }

    /**
     * @param $trip_id
     * @return array
     */
    function getvehdriverbytrip($trip_id): array
    {
        $response = array();
        $gettrip = $this->db->query("
            SELECT id,vehicle_id,driver_id
            FROM tb_trips
            WHERE
                id = ?
                AND status = 1
            ORDER BY id DESC
        ", [
            $trip_id
        ]);
        if ($gettrip->num_rows() > 0) {
            $response['trip'] = $gettrip->row()->id;
            $driverid = $gettrip->row()->driver_id;
            $driver = $this->db->select('name,contact_num')->get_where('tb_truck_drivers',array('id'=>$driverid),1,0);
            $response['drivername'] = $driver->row()->name;
            $response['drivermobile'] = $driver->row()->contact_num;
            $vehicleid = $gettrip->row()->vehicle_id;
            $vehicle = $this->db->select('register_number')->get_where('tb_trucks_data',array('id'=>$vehicleid),1,0);
            $response['vehicleno'] = $vehicle->row()->register_number;
        }
        return $response;
    }

    public function customershipstops()
    {
        $response = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = $_POST['cust_id'] ?? 0;
        $user_id = $_POST['user_id'] ?? 0;
        $ord_id = $_POST['ord_id'] ?? '';
        $trip_id = $_POST['trip_id'] ?? 0;
        $ship_id = $_POST['shift_id'] ?? '';
        $curtz = $_POST['timezone'] ?? '';
        if($curtz == ""){
            $curtz = "Asia/Singapore";
        }
        log_message('error', " customershipstops data " . json_encode($_POST));
        if ($ship_id > 0 && $user_id > 0) {
            $trip = $trip_id;
            $drivername = $drivermobile = $vehicleno = null;
            if($trip == 0){
                $details = $this->getvehdriverbyship($ship_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }else{
                $details = $this->getvehdriverbytrip($trip_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }
            $curstatus = array('lat'=>null,'lng'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            if($trip > 0){
                $lat = $lng = null;
                $liveloc = $this->db->select('latitude,longitude')->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                if($liveloc->num_rows()>0){
                    $lat = $liveloc->row()->latitude;
                    $lng = $liveloc->row()->longitude;
                }
                $curstatus = array('lat'=>$lat,'lng'=>$lng,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            }
            $query  = $this->db->query("
                SELECT id, stopname, plat, plng, stopcity, stoptype, ordernumber, convertToClientTZ(startdate,?) as startdate ,convertToClientTZ(enddate,?) as enddate, weight, volume
                FROM tb_shiporder_stops
                WHERE shipment_id = ?
                ORDER BY ordernumber ASC
            ", [
                $curtz,
                $curtz,
                $ship_id
            ]);
            $result = array();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $res) {
                    $stop_id = $res->id;
                    $emp = $this->db->query("
                        SELECT id,order_id
                        FROM tb_employee
                        WHERE
                            (stop_id = ? OR drop_stopid = ?)
                            AND shift_id = ?
                            AND status = 1
                    ", [
                        $stop_id,
                        $stop_id,
                        $ship_id
                    ]);
                    if ($emp->num_rows() > 0) {
                        $whr      = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                        $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        $status   = "N";
                        if ($statuses->num_rows() > 0) {
                            $status = "S";
                            $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                            $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if ($gateout_details->num_rows() >= $emp->num_rows()) {
                                $status = "C";
                            }
                        }
                        $stopname = "";
                        if (strlen($res->stopcity) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                        }
                        if (strlen($res->stopname) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                        }
                        $result[] = array('id' => $stop_id, 'name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'status' => $status, 'order_id' => $emp->row()->order_id);
                    }
                }
                $data = array('result'=>$result,'livedata'=>$curstatus);
                $response = array("status"=>1,"data"=>$data);
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }

    public function getstopstatus($whr,$curtz)
    {
        $res = array();
        $this->db->select("s.id,convertToClientTZ(s.createdon,'".$curtz."') as createdon,t.status_name,s.status_id");
        $this->db->from('tb_stop_status s');
        $this->db->join('tb_status_master t', 's.status_id=t.id', 'INNER');
        $this->db->where($whr);
        $this->db->order_by('s.createdon', 'DESC');
        $this->db->limit(1);
        $chkrecent = $this->db->get();
        if ($chkrecent->num_rows() > 0) {
            $res['name']      = $chkrecent->row()->status_name;
            $res['id']        = $chkrecent->row()->id;
            $res['createdon'] = $chkrecent->row()->createdon;
            $res['status_id'] = $chkrecent->row()->status_id;
        }
        return $res;
    }

    public function customerstopdetails()
    {
        if (isset($_POST)) {
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
            if ($stop_id > 0 && $shift_id > 0) {
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if($curtz == ""){
                    $curtz = "Asia/Singapore";
                }
                $trip = $trip_id;
                $drivername = $drivermobile = $vehicleno = "";
                if($trip == 0){
                    $details = $this->getvehdriverbyship($shift_id);
                    if(!empty($details)){
                        $trip = $details['trip'];
                        $drivername = $details['drivername'];
                        $drivermobile = $details['drivermobile'];
                        $vehicleno = $details['vehicleno'];
                    }
                }else{
                    $details = $this->getvehdriverbytrip($trip_id);
                    if(!empty($details)){
                        $trip = $details['trip'];
                        $drivername = $details['drivername'];
                        $drivermobile = $details['drivermobile'];
                        $vehicleno = $details['vehicleno'];
                    }
                }
                $curstatus = array('lat'=>null,'lng'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
                if($trip > 0){
                    $lat = $lng = null;
                    $liveloc = $this->db->select('latitude,longitude')->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                    if($liveloc->num_rows()>0){
                        $lat = $liveloc->row()->latitude;
                        $lng = $liveloc->row()->longitude;
                    }
                    $curstatus = array('lat'=>$lat,'lng'=>$lng,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
                }
                $query  = $this->db->query("
                    SELECT *
                    FROM (
                        SELECT
                            e.id, convertToClientTZ(e.startdate, ?) as startdate, convertToClientTZ(e.enddate, ?) as enddate,
                            e.phone, e.stop_id, e.pickup, e.plat, e.plng, e.`drop`, e.drop_city, e.pickup_city, e.dlat, e.dlng,
                            convertToClientTZ(e.pickup_datetime,?) as pickup_datetime, convertToClientTZ(e.drop_datetime,?) as drop_datetime,
                            e.name, e.material_id, e.shipment_weight, e.shipment_volume, 'P' as ship_type, e.customer_id, e.vendor_id, e.stop_order as priority,
                            e.order_id, e.capacity, c.name as customer_name, v.name as carrier_name, m.material as material_name, e.accepted
                        FROM `tb_employee` e
                            JOIN tb_vendors v ON v.id = e.vendor_id
                            JOIN tb_customers c ON c.id = e.customer_id
                            JOIN tb_materials m ON m.id = e.material_id
                        WHERE
                            e.shift_id = ?
                            AND e.status=1
                            AND e.stop_id = ?
                        UNION
                        SELECT
                            e.id, convertToClientTZ(e.startdate,?) as startdate, convertToClientTZ(e.enddate,?) as enddate,
                            e.phone, e.drop_stopid as stop_id, e.pickup, e.plat, e.plng, e.`drop`, e.drop_city, e.pickup_city, e.dlat, e.dlng,
                            convertToClientTZ(e.pickup_datetime,?) as pickup_datetime, convertToClientTZ(e.drop_datetime,?) as drop_datetime,
                            e.name, e.material_id, e.shipment_weight, e.shipment_volume, 'D' as ship_type, e.customer_id, e.vendor_id, e.drop_order as priority,
                            e.order_id, e.capacity, c.name as customer_name, v.name as carrier_name, m.material as material_name, e.accepted
                        FROM `tb_employee` e
                            JOIN tb_vendors v ON v.id = e.vendor_id
                            JOIN tb_customers c ON c.id = e.customer_id
                            JOIN tb_materials m ON m.id = e.material_id
                        WHERE
                            e.shift_id = ?
                            AND e.status = 1
                            AND e.drop_stopid =?
                    ) ORDER BY priority
                ", [
                    $curtz,
                    $curtz,
                    $curtz,
                    $curtz,
                    $shift_id,
                    $stop_id,
                    $curtz,
                    $curtz,
                    $curtz,
                    $curtz,
                    $shift_id,
                    $stop_id
                ]);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $i => $res) {
                        $status   = 'N';
                        $statusid = '0';
                        $check_in = '';
                        $reason   = '';
                        $whr = array('stop_id' => $res->id);
                        $getsts = $this->getstopstatus($whr,$curtz);
                        if (!empty($getsts)) {
                            $status   = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason   = $getsts['name'];
                        }
                        $sts        = $anystatus        = 0;
                        $chkpodsign = $this->db->query("
                            SELECT id
                            FROM tb_pod_uploads
                            WHERE
                                shipment_id = ?
                                AND stop_id = ?
                                AND doc_type IN ?
                            GROUP BY doc_type
                            ORDER BY createdon DESC
                        ", [
                            $shift_id,
                            $stop_id,
                            [1, 3]
                        ]);
                        if ($chkpodsign->num_rows() >= 2) {
                            $anystatus = 1;
                        }
                        if ($i == 0) {
                            $anystatus = 1;
                        }
                        if ($trip > 0) {
                            $chk = $this->db->select('id,status')->get_where('tb_trip_employee', array('employee_id' => $res->id, 'trip_id' => $trip, 'stop_id' => $stop_id), 1, 0);
                            if ($chk->num_rows() > 0) {
                                if ($chk->row()->status == 1) {
                                    $sts = 1;
                                }
                            }
                            if ($sts != 1) {
                                $chk1 = $this->db->select('id')->get_where('tb_stop_status', array('stop_id' => $res->id, 'trip_id' => $trip), 1, 0);
                                if ($chk1->num_rows() > 0) {
                                    $sts = 0;
                                } else {
                                    $sts = 2;
                                }
                            }
                        }
                        $material   = $res->name;
                        $materialid = $this->db->select('material')->get_where('tb_materials', array('id' => $res->material_id), 1, 0);
                        if ($materialid->num_rows() > 0) {
                            $material = $materialid->row()->material;
                        }
                        $drop = "";
                        if (strlen($res->drop_city) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop_city)) . " - ";
                        }
                        if (strlen($res->drop) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop));
                        }
                        $pickup = "";
                        if (strlen($res->pickup_city) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup_city)) . " - ";
                        }
                        if (strlen($res->pickup) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup));
                        }
                        $result[] = array('id' => $res->id, 'name' => $res->name, 'pickup' => $pickup, 'drop' => $drop, 'phone' => $res->phone, 'plat' => $res->plat, 'plng' => $res->plng, 'dlat' => $res->dlat, 'dlng' => $res->dlng, 'capacity' => $res->capacity, 'ship_type' => $res->ship_type, 'shipment_weight' => $res->shipment_weight, 'shipment_volume' => $res->shipment_volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->priority, 'status' => $status, 'status_id' => $statusid, 'check_in' => $check_in, 'reason' => $reason, 'milestone' => $sts, 'exists_status' => $anystatus, 'material' => $material, 'order_id' => $res->order_id, "accepted" => $res->accepted);
                    }
                    $data = array('result'=>$result,'livedata'=>$curstatus);
                    $response = array("status" => 1, "data" => $data);
                } else {
                    $response = array("status" => 0, "data" => "Not Found");
                }
            } else {
                $response = array("status" => 0, "data" => "Insufficient Input Data");
            }
        } else {
            $response = array("status" => 0, "data" => "Insufficient Input Data");
        }
        echo json_encode($response);
    }
    public function customerstopsinmap()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $ship_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : '';
        if ($ship_id > 0 && $user_id > 0) {
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $trip = $trip_id;
            $drivername = $drivermobile = $vehicleno = null;
            if($trip == 0){
                $details = $this->getvehdriverbyship($ship_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }else{
                $details = $this->getvehdriverbytrip($trip_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }
            $curstatus = array('lat'=>null,'lng'=>null,'speed'=>null,'timestamp'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            if($trip > 0){
                $lat = $lng = $speed = $timestamp = $bearing = null;
                $liveloc = $this->db->select("latitude,longitude,speed,bearing,convertToClientTZ(timestamp,'".$curtz."') as timestamp")->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                if($liveloc->num_rows()>0){
                    $lat = $liveloc->row()->latitude;
                    $lng = $liveloc->row()->longitude;
                    $speed = $liveloc->row()->speed;
                    $timestamp = date("d M, h:i A",strtotime($liveloc->row()->timestamp));
                    $bearing = $liveloc->row()->bearing;
                }
                $curstatus = array('lat'=>$lat,'lng'=>$lng,'speed'=>$speed,'timestamp'=>$timestamp,'bearing'=>$bearing,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            }

            $query = $this->db->query("
                SELECT splace, eplace, scity, dcity, convertToClientTZ(startdate, ?) as startdate, convertToClientTZ(enddate, ?) as enddate
                FROM tb_shifts
                WHERE
                    id = ?
                    and user_id = ?
                ORDER BY id DESC
                LIMIT 1
            ", [
                $curtz,
                $curtz,
                $ship_id,
                $user_id
            ]);
            $enddate = "";
            $res = array();
            if ($query->num_rows() > 0) {
                $d = $query->row_array();
                [$pickup, $drop] = $this->addressesFromShift($d);
                $enddate = $query->row()->enddate;
                $curstatus["stime"] = $d['startdate'];
                $curstatus["splace"] = $pickup;
                $curstatus["eplace"] = $drop;
                $curstatus["avgspeed"] = 10;

                $query  = $this->db->query("
                    SELECT id, stopname, plat, plng, stopcity, stoptype, ordernumber, convertToClientTZ(startdate, ?) as startdate, convertToClientTZ(enddate, ?) as enddate, weight, volume
                    from tb_shiporder_stops
                    WHERE shipment_id = ?
                    ORDER BY ordernumber ASC
                ", [
                    $curtz,
                    $curtz,
                    $ship_id
                ]);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $stop_id = $res->id;
                        $stoplegs = array();
                        $emp = $this->db->query("
                            SELECT *
                            FROM (
                                SELECT
                                    id, pickup, plat, plng, `drop`, drop_city, pickup_city, dlat, dlng, convertToClientTZ(pickup_datetime, ?) as pickup_datetime,
                                    convertToClientTZ(drop_datetime, ?) as drop_datetime, name, shipment_weight, shipment_volume, stop_order,
                                    order_id, pkgitemid as material, 'P' as ship_type, accepted
                                FROM tb_employee
                                WHERE
                                    stop_id = ?
                                    AND shift_id = ?
                                    AND status = 1
                                UNION
                                SELECT
                                    id, pickup, plat, plng, `drop`, drop_city, pickup_city, dlat, dlng, convertToClientTZ(pickup_datetime, ?) as pickup_datetime,
                                    convertToClientTZ(drop_datetime, ?) as drop_datetime, name, shipment_weight, shipment_volume, stop_order,
                                    order_id, pkgitemid as material, 'P' as ship_type, accepted
                                FROM tb_employee
                                WHERE
                                    drop_stopid = ?
                                    AND shift_id = ?
                                    AND status = 1
                            ) P
                            WHERE accepted = 1
                            ORDER BY stop_order ASC
                        ", [
                            $curtz,
                            $curtz,
                            $stop_id,
                            $ship_id,
                            $curtz,
                            $curtz,
                            $stop_id,
                            $ship_id,
                        ]);
                        if($emp->num_rows() > 0){
                            foreach($emp->result_array() as $res1){
                                $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$res1['id'],'status'=>1);
                                $lstatus = "N";
                                $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if($legdetails->num_rows() > 0) {
                                    $lstatus = "S";
                                    $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$res1['id'],'status_id'=>1,'status'=>1);
                                    $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                    if($legdetails->num_rows()>0){
                                        $lstatus = "C";
                                    }
                                }
                                $res1['leg_status'] = $lstatus;
                                $stoplegs[] = $res1;
                            }
                        }
                        $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                        $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        $status   = "N";
                        if($statuses->num_rows() > 0){
                            $status = "S";
                            $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                            $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if($gateout_details->num_rows() > 0) {
                                $status = "C";
                            }
                        }
                        $stopname = "";
                        if (strlen($res->stopcity) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                        }
                        if (strlen($res->stopname) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                        }
                        $result[] = array('stop_id' => $stop_id, 'stop_name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'stop_status' => $status,'stoplegs'=>$stoplegs);
                    }
                }
                $res1 = $this->getStartEndPoints($ship_id);
                $data = array('result'=>$result,'livedata'=>$curstatus,"endpoints"=>$res1,"enddate"=>strtotime($enddate));
                $response = array("status"=>1,"data"=>$data);
            }else{
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($this->printable($response));
    }

    public function customershipstatuses()
    {
        $response = array("status"=>"0", "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data1  = array();
            $status = 0;
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : null;
            $cust_id = isset($_POST["cust_id"]) ? $_POST["cust_id"] : null;
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : null;
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : null;
            if ($trip_id != null && $shift_id != null) {
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if($curtz == ""){
                    $curtz = "Asia/Singapore";
                }
                $qry = $this->db->query("
                    SELECT
                        s.latitude, s.longitude, convertToClientTZ(s.createdon, ?) as createdon, m.status_name
                    FROM tb_stop_status s, tb_status_master m
                    WHERE
                        s.status_id = m.id
                        AND s.trip_id = ?
                    ORDER BY s.createdon ASC
                ", [
                    $curtz,
                    $trip_id
                ]);
                $response = array("status" =>"1", "data" => $data1);
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $placename = getLocationName($res->latitude, $res->longitude);
                        $data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));
                    }
                    $response = array("status" =>"1", "data" => $data1);
                }
            }
        }
        echo json_encode($this->printable($response));
    }

    public function shipmentstatushistory()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $ship_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : '';
        if ($ship_id > 0 && $user_id > 0) {
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $query  = $this->db->query("
                SELECT
                    id, stopname, plat, plng, stopcity, stoptype, ordernumber, convertToClientTZ(startdate, ?) as startdate
                FROM tb_shiporder_stops
                WHERE
                    shipment_id = ?
                ORDER BY ordernumber ASC
            ", [
                $curtz,
                $ship_id
            ]);
            $result = array();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $res) {
                    $stop_id = $res->id;
                    $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                    $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                    $status   = "N";
                    if($statuses->num_rows() > 0){
                        $status = "S";
                        $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                        $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        if($gateout_details->num_rows() > 0) {
                            $status = "C";
                        }
                    }
                    $stopname = "";
                    if (strlen($res->stopcity) > 0) {
                        $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                    }
                    if (strlen($res->stopname) > 0) {
                        $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                    }
                    $chkpod = $this->db->query("
                        SELECT imgpath, doc_type, hash
                        FROM tb_pod_uploads
                        WHERE
                            shipment_id = ?
                            AND stop_id IS NULL
                        LIMIT 1
                    ", [
                        $ship_id
                    ]);
                    $img = "";
                    if($chkpod->num_rows()>0){
                        $img = base_url() . 'downloadEpod/safelink/' . $chkpod->row()->hash. '.epod';
                    }
                    $result[] = array('title' => $stopname, 'sub_title' => "Stop", 'date' => strtotime($res->startdate), 'status' => $status,'type'=>$res->stoptype,'image'=>$img);
                    $hstatus = array();

                    $emp = $this->db->query("
                        SELECT *
                        FROM (
                            SELECT
                                id, pickup, plat, plng, `drop`, drop_city, pickup_city, dlat, dlng, convertToClientTZ(pickup_datetime, ?) as pickup_datetime,
                                convertToClientTZ(drop_datetime, ?) as drop_datetime, name, shipment_weight, shipment_volume, stop_order,
                                order_id, pkgitemid as material, 'P' as ship_type, accepted
                            FROM tb_employee
                            WHERE
                                stop_id = ?
                                AND shift_id = ?
                                AND status = 1
                            UNION
                            SELECT
                                id, pickup, plat, plng, `drop`, drop_city, pickup_city, dlat, dlng, convertToClientTZ(pickup_datetime, ?) as pickup_datetime,
                                convertToClientTZ(drop_datetime, ?) as drop_datetime, name, shipment_weight, shipment_volume, stop_order,
                                order_id, pkgitemid as material, 'P' as ship_type, accepted
                            FROM tb_employee
                            WHERE
                                drop_stopid = ?
                                AND shift_id = ?
                                AND status = 1
                        ) P
                        WHERE accepted = 1
                        ORDER BY stop_order ASC
                    ", [
                        $curtz,
                        $curtz,
                        $stop_id,
                        $ship_id,
                        $curtz,
                        $curtz,
                        $stop_id,
                        $ship_id
                    ]);
                    if($emp->num_rows() > 0){
                        foreach($emp->result_array() as $res1){
                            $stopdetailid = $res1['id'];
                            $chkpod = $this->db->query("
                                SELECT imgpath, doc_type, hash
                                FROM tb_pod_uploads
                                WHERE
                                    stop_id = ?
                                    OR stop_detail_id = ?
                                LIMIT 1
                            ", [
                                $stop_id,
                                $stopdetailid
                            ]);
                            $img = "";
                            if($chkpod->num_rows()>0){
                                $img = base_url() . 'downloadEpod/safelink/' . $chkpod->row()->hash. '.epod';
                            }
                            $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$stopdetailid,'status'=>1);
                            $lstatus = "N";
                            $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if($legdetails->num_rows() > 0) {
                                $lstatus = "S";
                                $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$stopdetailid,'status_id'=>1,'status'=>1);
                                $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if($legdetails->num_rows()>0){
                                    $lstatus = "C";
                                }
                            }
                            if($res1['ship_type'] == 'P'){
                                $stopdetname = $res1['pickup_city'];
                                $ptime = $res1['pickup_datetime'];
                            }else{
                                $stopdetname = $res1['drop'];
                                $ptime = $res1['drop_datetime'];
                            }
                            $stopdetail = array('title' => $stopdetname, 'sub_title' => "Stop Details", 'date' => strtotime($ptime), 'status' => $lstatus,'type'=>$res1['ship_type'],'image'=>$img);
                            $result[] = $stopdetail;
                            $qry = $this->db->query("
                                SELECT
                                    s.status_id, s.latitude, s.longitude,
                                    convertToClientTZ(s.createdon, ?) as createdon, m.status_name
                                FROM tb_stop_status s, tb_status_master m
                                WHERE
                                    s.status_id = m.id
                                    AND s.trip_id = ?
                                    AND (
                                        s.stop_id = ?
                                        OR s.stop_detail_id = ?
                                    )
                                ORDER BY s.createdon ASC
                            ", [
                                $curtz,
                                $trip_id,
                                $stop_id,
                                $stopdetailid
                            ]);
                            if ($qry->num_rows() > 0) {
                                foreach ($qry->result() as $rw) {
                                    $placename = getLocationName($rw->latitude, $rw->longitude);
                                    $stsname = $rw->status_name;
                                    if($stsname == "Pickup Or Drop"){
                                        if($res1['ship_type'] == 'P'){
                                            $stsname = "Pickup";
                                        }else{
                                            $stsname = "Drop";
                                        }
                                    }
                                    $sstatus = "N";
                                    if($rw->status_id > 1){
                                        $sstatus = "S";
                                    }
                                    if($rw->status_id == 1){
                                        $sstatus = "C";
                                    }
                                    $hstatus = array('title' => $stsname, 'sub_title' => $placename, 'date' => strtotime($rw->createdon), 'status' => $sstatus,'type'=>$res1['ship_type'],'image'=>"");
                                    $result[] = $hstatus;
                                }
                            }
                        }
                    }
                }
                $response = array("status"=>1,"data"=>$result);
            }else{
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }

    public function setuserfeedback(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
        $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
        $feedback = isset($_POST['feedback']) ? $_POST['feedback'] : '';
        $rating = isset($_POST['rating']) ? $_POST['rating'] : 3;
        $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
        if($curtz == ""){
            $curtz = "Asia/Singapore";
        }
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $curdt = $getactual['datetime'];
        if($cust_id != "" && $feedback != ""){
            $arr = array('trip_id'=>$trip_id, 'ship_id'=>$ship_id, 'stop_id'=>$stop_id, 'stop_detail_id'=>$stop_id, 'noted_by'=>$cust_id, 'user_type'=>1, 'feedback'=>$feedback, 'feedback_type'=>$rating, 'status'=>1, 'created_on'=>$curdt);
            $ins = $this->db->insert("tb_trip_feebacks",$arr);
            $response = array("status"=>1,"data"=>"Success");
        }
        echo json_encode($response);
    }
    public function orderquote(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $data = (array)$post;
            $customerid = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $uid = isset($_POST['user_id']) ? $_POST['user_id'] : 1;
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $consigneeName = isset($post->consigneeName) ? $post->consigneeName : "";
            $consigneePhone = isset($post->consigneePhone) ? $post->consigneePhone : "";
            $consigneeEmail = isset($post->consigneeEmail) ? $post->consigneeEmail : "";
            $consigneeCode = isset($post->consigneeCode) ? $post->consigneeCode : "";
            $consignorName = isset($post->consignorName) ? $post->consignorName : "";
            $consignorPhone = isset($post->consignorPhone) ? $post->consignorPhone : "";
            $consignorEmail = isset($post->consignorEmail) ? $post->consignorEmail : "";
            $consignorCode = isset($post->consignorCode) ? $post->consignorCode : "";
            $pickupDate = isset($post->pickupDate) ? $post->pickupDate : "";
            $getactual1 = getdatetimebytimezone(DFLT_TZ,$pickupDate,$curtz);
            $pickupDate = $getactual1['date'];
            $pickupCity = isset($post->pickupCity) ? $post->pickupCity : "";
            $pickupAddressLine1 = isset($post->pickupAddressLine1) ? $post->pickupAddressLine1 : "";
            $pickupCompany = isset($post->pickupCompany) ? $post->pickupCompany : "";
            $pickupCountry = $data['pickup_country'] = isset($post->pickupCountry) ? $post->pickupCountry : "";
            $pickupPin = isset($post->pickupPin) ? $post->pickupPin : "";
            $dropDate = isset($post->dropDate) ? $post->dropDate : "";
            $getactual1 = getdatetimebytimezone(DFLT_TZ,$dropDate,$curtz);
            $dropDate = $getactual1['date'];
            $dropCity = isset($post->dropCity) ? $post->dropCity : "";
            $dropAddressLine1 = isset($post->dropAddressLine1) ? $post->dropAddressLine1 : "";
            $dropCompany = isset($post->dropCompany) ? $post->dropCompany : "";
            $dropCountry = $data['drop_country'] = isset($post->dropCountry) ? $post->dropCountry : "";
            $dropPin = isset($post->dropPin) ? $post->dropPin : "";
            $quantity = $data['quantity'] = isset($post->quantity) ? $post->quantity : 0;
            $weight = $data['weight'] = isset($post->weight) ? $post->weight : 0;
            $volume = $data['volume'] = isset($post->volume) ? $post->volume : 0;
            $shipmentOption = isset($post->shipmentOption) ? $post->shipmentOption : 0;
            if($shipmentOption == "0"){ $shipmentOption = "TL"; }else{ $shipmentOption = "LTL"; }
            $data['transportmode'] = $shipmentOption;
            $valueOfGoods = isset($post->valueOfGoods) ? $post->valueOfGoods : 0;
            $cargos = $data['detail_cargo'] = isset($post->cargoes) ? $post->cargoes : array();
            $addOns = $data['add_ons'] = isset($post->addOns) ? $post->addOns : array();
            $plat = isset($post->plat) ? $post->plat : "";
            $plng = isset($post->plng) ? $post->plng : "";
            $dlat = isset($post->dlat) ? $post->dlat : "";
            $dlng = isset($post->dlng) ? $post->dlng : "";
            /*$curtz = date_default_timezone_get();*/
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
            $curdt = $getactual['datetime'];
            /* check consignor */
            $vend = array('name'=>$consignorName,'mobile'=>$consignorPhone);
            $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
            if($chkvend->num_rows()>0){
                $vendorid = $chkvend->row()->id;
            }else{
                $vendarr = array('name'=>$consignorName,'mobile'=>$consignorPhone, 'location'=>$pickupCity, 'address'=>$pickupCity, 'code'=>$consignorPhone, 'email'=>$consignorEmail, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
                $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
            }
            $ord = "ORDER_".time();
            $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickupDate, 'delivery_datetime'=>$dropDate, 'pickup_company'=>$pickupCompany, 'delivery_company'=>$dropCompany, 'pickup_country'=>$pickupCountry, 'delivery_country'=>$dropCountry, 'pickup_city'=>$pickupCity, 'delivery_city'=>$dropCity, 'pickup_pincode'=>$pickupPin, 'delivery_pincode'=>$dropPin, 'pickup_address1'=>$pickupAddressLine1, 'delivery_address1'=>$dropAddressLine1, 'quantity'=>$quantity, 'weight'=>$weight, 'volume'=>$volume, 'goods_value'=>$valueOfGoods, 'transport_mode'=>$shipmentOption, 'dedicated_vehicle'=>0, 'vehicle_type'=>"", 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$consigneeName, 'customer_code'=>$consigneeCode, 'customer_area'=>$pickupCity, 'customer_phone'=>$consigneePhone, 'customer_email'=>$consigneeEmail, 'vendor_name'=>$consignorName, 'vendor_code'=>$consignorCode, 'vendor_area'=>$pickupCity, 'vendor_phone'=>$consignorPhone, 'vendor_email'=>$consignorEmail, 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'is_created'=>1, 'createdon'=>$curdt,"created_source"=>"driverapiv1/orderquote");
            $orderid = $this->common->insertTableData("tb_orders",$orddata);
            /* insert into cargo types */
            if(count($cargos)>0){
                foreach($cargos as $ct){
                    if($ct != ""){
                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
                    }
                }
            }
            /* insert into cargo details */
            $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>1, 'length'=>$weight, 'width'=>$weight, 'height'=>$weight, 'weight'=>$weight, 'quantity'=>$quantity, 'status'=>1, 'createdon'=>$curdt);
            $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
            /* insert into add ons */
            if(count($addOns)>0){
                foreach($addOns as $dc){
                    if($dc != ""){
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
            /*$this->load->helper('shiporder_helper');
            $res = sendorderotp($data);*/
            $result['status'] = 1;
            $basecost = $totalcost = 15000;
            $accessorial = $special_services = array();
            /*if(isset($res['qryres']['costdetails'])){
                if(count($res['qryres']['costdetails']) > 0){
                    foreach($res['qryres']['costdetails'] as $actcost){
                        $totalcost += $actcost['costdetamount'];
                        if($actcost['associd'] == ""){
                            $basecost = $actcost['costdetamount'];
                        }else{
                            $accessorial[] = array('id'=>$actcost['associd'],'cost'=>$actcost['costdetamount']);
                        }
                    }
                }
            }
            if(isset($res['qrydata']['specialservices'])){
                if(count($res['qrydata']['specialservices']) > 0){
                    foreach($res['qrydata']['specialservices'] as $rs){
                        $chk = 0.00;
                        if(!empty($accessorial)){
                            foreach($accessorial as $ac){
                                if($ac['id'] == $rs['serviceid']){
                                    $chk = $ac['cost'];
                                }
                            }
                        }
                        $special_services[] = array('service_name'=>explode('_', $rs['serviceid'])[1],'service_cost'=>$chk);
                    }
                }
            }*/
            // $special_services[] = array('service_name'=>'CARGO INSURANCE','service_cost'=>'4000');
            // $special_services[] = array('service_name'=>'CARGO INSURANCE2','service_cost'=>'5000');
            // $special_services[] = array('service_name'=>'CARGO INSURANCE3','service_cost'=>'6000');
            $rateitem = "2 X ".$basecost;
            $result['data'] = array('base_rate' => $basecost,'base_rate_item'=>$rateitem,'order_id'=>$ord,'special_services'=>$special_services);
            $response = $result;
        }
        echo json_encode($response);
    }
    public function bookorderquote(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            /*$post = json_decode($_POST['data']);
            $data = (array)$post;*/
            $post = $_POST;
            $cust_id = isset($post['cust_id']) ? $post['cust_id'] : '';
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $orderid = isset($post['order_id']) ? $post['order_id'] : '';
            $response = array("status"=>1,"data"=>array("status"=>"Booking Complete","order_id"=>$orderid));
        }
        echo json_encode($response);
    }
    public function quickbook(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $post = json_decode($_POST['data']);
            $data = (array)$post;
            $customerid = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $uid = isset($_POST['user_id']) ? $_POST['user_id'] : 1;
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $consigneeName = isset($post->consigneeName) ? $post->consigneeName : "";
            $consigneePhone = isset($post->consigneePhone) ? $post->consigneePhone : "";
            $consigneeEmail = isset($post->consigneeEmail) ? $post->consigneeEmail : "";
            $consigneeCode = isset($post->consigneeCode) ? $post->consigneeCode : "";
            if($consigneeName == ""){
                $where = array("id"=>$customerid);
                $custdetails = $this->common->gettblrowdata($where,"name,phone,code,email_id","tb_customers",0,0);
                if(count($custdetails)>0){
                    $consigneeName = $custdetails['name'];
                    $consigneePhone = $custdetails['phone'];
                    $consigneeEmail = $custdetails['email_id'];
                    $consigneeCode = $custdetails['code'];
                }
            }
            $consignorName = isset($post->consignorName) ? $post->consignorName : "";
            $consignorPhone = isset($post->consignorPhone) ? $post->consignorPhone : "";
            $consignorEmail = isset($post->consignorEmail) ? $post->consignorEmail : "";
            $consignorCode = isset($post->consignorCode) ? $post->consignorCode : "";
            $pickupDate = isset($post->pickupDate) ? $post->pickupDate : "";
            $getactual1 = getdatetimebytimezone(DFLT_TZ,$pickupDate,$curtz);
            $pickupDate = $getactual1['date'];

            $pickupCity = isset($post->pickupCity) ? $post->pickupCity : "";
            $pickupAddressLine1 = isset($post->pickupAddressLine1) ? $post->pickupAddressLine1 : "";
            $pickupCompany = isset($post->pickupCompany) ? $post->pickupCompany : "";
            $pickupCountry = $data['pickup_country'] = isset($post->pickupCountry) ? $post->pickupCountry : "";
            $pickupPin = isset($post->pickupPin) ? $post->pickupPin : "";
            $dropDate = isset($post->dropDate) ? $post->dropDate : "";
            $getactual1 = getdatetimebytimezone(DFLT_TZ,$dropDate,$curtz);
            $dropDate = $getactual1['date'];
            $dropCity = isset($post->dropCity) ? $post->dropCity : "";
            $dropAddressLine1 = isset($post->dropAddressLine1) ? $post->dropAddressLine1 : "";
            $dropCompany = isset($post->dropCompany) ? $post->dropCompany : "";
            $dropCountry = $data['drop_country'] = isset($post->dropCountry) ? $post->dropCountry : "";
            $dropPin = isset($post->dropPin) ? $post->dropPin : "";
            $quantity = $data['quantity'] = isset($post->quantity) ? $post->quantity : 0;
            $weight = $data['weight'] = isset($post->weight) ? $post->weight : 0;
            $volume = $data['volume'] = isset($post->volume) ? $post->volume : 0;
            $shipmentOption = isset($post->shipmentOption) ? $post->shipmentOption : 0;
            if($shipmentOption == "0"){ $shipmentOption = "TL"; }else{ $shipmentOption = "LTL"; }
            $data['transportmode'] = $shipmentOption;
            $valueOfGoods = isset($post->valueOfGoods) ? $post->valueOfGoods : 0;
            $cargos = $data['detail_cargo'] = isset($post->cargoes) ? $post->cargoes : array();
            $addOns = $data['add_ons'] = isset($post->addOns) ? $post->addOns : array();
            $plat = isset($post->plat) ? $post->plat : "";
            $plng = isset($post->plng) ? $post->plng : "";
            $dlat = isset($post->dlat) ? $post->dlat : "";
            $dlng = isset($post->dlng) ? $post->dlng : "";
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
            $curdt = $getactual['datetime'];
            /* check consignor */
            /*$vend = array('name'=>$consignorName,'code'=>$consignorPhone);
            $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
            if($chkvend->num_rows()>0){
                $vendorid = $chkvend->row()->id;
            }else{
                $vendarr = array('name'=>$consignorName,'mobile'=>$consignorPhone, 'location'=>$pickupCity, 'address'=>$pickupCity, 'code'=>$consignorPhone, 'email'=>$consignorEmail, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
                $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
            }*/
            $vendorid = 0;
            $ord = "ORDER_".time();
            $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickupDate, 'delivery_datetime'=>$dropDate, 'pickup_company'=>$pickupCompany, 'delivery_company'=>$dropCompany, 'pickup_country'=>$pickupCountry, 'delivery_country'=>$dropCountry, 'pickup_city'=>$pickupCity, 'delivery_city'=>$dropCity, 'pickup_pincode'=>$pickupPin, 'delivery_pincode'=>$dropPin, 'pickup_address1'=>$pickupAddressLine1, 'delivery_address1'=>$dropAddressLine1, 'quantity'=>$quantity, 'weight'=>$weight, 'volume'=>$volume, 'goods_value'=>$valueOfGoods, 'transport_mode'=>$shipmentOption, 'dedicated_vehicle'=>0, 'vehicle_type'=>"", 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$consigneeName, 'customer_code'=>$consigneeCode, 'customer_area'=>$pickupCity, 'customer_phone'=>$consigneePhone, 'customer_email'=>$consigneeEmail, 'vendor_name'=>$consignorName, 'vendor_code'=>$consignorCode, 'vendor_area'=>$pickupCity, 'vendor_phone'=>$consignorPhone, 'vendor_email'=>$consignorEmail, 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'is_created'=>1, 'createdon'=>$curdt,"created_source"=>"driverapiv1/quickbook");
            $orderid = $this->common->insertTableData("tb_orders",$orddata);
            /* insert into cargo types */
            if(count($cargos)>0){
                foreach($cargos as $ct){
                    if($ct != ""){
                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
                    }
                }
            }else{
                $ins = array('cargo_type'=>"General Cargo", 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
            }
            /* insert into cargo details */
            $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>1, 'length'=>$weight, 'width'=>$weight, 'height'=>$weight, 'weight'=>$weight, 'quantity'=>$quantity, 'status'=>1, 'createdon'=>$curdt);
            $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
            /* insert into add ons */
            if(count($addOns)>0){
                foreach($addOns as $dc){
                    if($dc != ""){
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
            /*$this->load->helper('shiporder_helper');
            $res = sendorderotp($data);*/
            $result['status'] = 1;
            $basecost = $totalcost = 15000;
            $accessorial = $special_services = array();
            /*if(isset($res['qryres']['costdetails'])){
                if(count($res['qryres']['costdetails']) > 0){
                    foreach($res['qryres']['costdetails'] as $actcost){
                        $totalcost += $actcost['costdetamount'];
                        if($actcost['associd'] == ""){
                            $basecost = $actcost['costdetamount'];
                        }else{
                            $accessorial[] = array('id'=>$actcost['associd'],'cost'=>$actcost['costdetamount']);
                        }
                    }
                }
            }
            if(isset($res['qrydata']['specialservices'])){
                if(count($res['qrydata']['specialservices']) > 0){
                    foreach($res['qrydata']['specialservices'] as $rs){
                        $chk = 0.00;
                        if(!empty($accessorial)){
                            foreach($accessorial as $ac){
                                if($ac['id'] == $rs['serviceid']){
                                    $chk = $ac['cost'];
                                }
                            }
                        }
                        $special_services[] = array('service_name'=>explode('_', $rs['serviceid'])[1],'service_cost'=>$chk);
                    }
                }
            }*/
            $rateitem = "2 X ".$basecost;
            $result['data'] = array('base_rate' => $basecost,'base_rate_item'=>$rateitem,'order_id'=>$ord,'special_services'=>$special_services);
            $response = $result;
        }
        echo json_encode($response);
    }
    public function setreceivedgoods(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
            $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
            $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
            $packages = isset($_POST['packages']) ? $_POST['packages'] : 0;
            $weight = isset($_POST['weight']) ? $_POST['weight'] : 0;
            $volume = isset($_POST['volume']) ? $_POST['volume'] : 0;
            $remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
            $logdate = $getactual['datetime'];
            if($cust_id != "" && $ship_id != ""){
                $arr = array('trip_id'=>$trip_id, 'ship_id'=>$ship_id, 'stop_id'=>$stop_id, 'stop_detail_id'=>$stop_id, 'noted_by'=>$cust_id, 'user_type'=>1, 'packages'=>$packages, 'weight'=>$weight, 'volume'=>$volume, 'feedback'=>$remarks, 'status'=>1, 'created_on'=>$curdt);
                $ins = $this->db->insert("tb_trip_feebacks",$arr);
                $response = array("status"=>1,"data"=>"Success");
            }
            $response = array("status"=>1,"data" =>"Updated Successfully!");
        }
        echo json_encode($response);
    }
    public function customerOrders()
    {
        $response  = array("status" =>"0", "data" => "Something went wrong!");
        if(isset($_POST)){
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : "";
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : "";
            $search = isset($_POST['search']) ? $_POST['search'] : "";
            if($cust_id != "" && $user_id != ""){
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if($curtz == ""){
                    $curtz = "Asia/Singapore";
                }

                $bindings = [
                    $curtz,
                    $curtz,
                    $curtz,
                    $curtz,
                    $curtz,
                    $cust_id
                ];
                $whr = "";
                if($search != ""){
                    $whr .= " AND (o.id like '%?%' OR o.order_id like '%?%') ";
                    $bindings[] = $search;
                    $bindings[] = $search;
                }
                $orders_qry = $this->db->query("
                    SELECT
                        o.id, o.order_id, convertToClientTZ(o.pickup_datetime, ?) as pickup_datetime, convertToClientTZ(o.pickup_endtime, ?) as pickup_endtime,
                        convertToClientTZ(o.delivery_datetime, ?) as delivery_datetime, convertToClientTZ(o.drop_endtime, ?) as drop_endtime,
                        o.pickup_company, o.delivery_company, o.pickup_country, o.delivery_country, o.pickup_city, o.delivery_city, o.pickup_pincode, o.delivery_pincode,
                        o.plat, o.plng, o.dlat, o.dlng, o.`status`, UNIX_TIMESTAMP(convertToClientTZ(o.createdon, ?)) AS createdon,o.vendor_id, v.name as vendor_name
                    FROM tb_orders o
                    LEFT JOIN tb_vendors v ON v.id = o.vendor_id
                    WHERE
                        o.`status`!='0'
                        AND o.customer_id = ?
                        $whr
                    ORDER BY status DESC
                ", $bindings);
                $orders = [];
                foreach($orders_qry->result_array() as $row){
                    if($row["status"]=="2"){
                        $chksts = $this->db->query("
                            SELECT t.status
                            FROM tb_trips t, tb_employee e
                            WHERE
                                t.shift_id = e.shift_id
                                AND e.order_id = ?
                            GROUP BY e.shift_id
                            LIMIT 1
                        ", [
                            $row['order_id']
                        ]);
                        if($chksts->num_rows()>0){
                            $sts = $chksts->row()->status;
                            if($sts == 0){
                                $row["status"] = 3;
                            }
                        }else{
                            $row["status"] = 1;
                        }
                    }
                    $row['ref_id'] = $this->getrefsbyorder($row['order_id']);
                    $orders[] = $row;
                }
                $response =  (array("status"=>"1","data"=>$orders));
            }
        }
        echo json_encode($this->printable($response));
    }
    function array_sort($array, $on, $order=SORT_ASC)
    {
        $new_array = array();
        $sortable_array = array();
        if (count($array) > 0) {
            foreach ($array as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if ($k2 == $on) {
                            $sortable_array[$k] = $v2;
                        }
                    }
                } else {
                    $sortable_array[$k] = $v;
                }
            }
            switch ($order) {
                case SORT_ASC:
                    asort($sortable_array);
                break;
                case SORT_DESC:
                    arsort($sortable_array);
                break;
            }
            foreach ($sortable_array as $k => $v) {
                $new_array[$k] = $array[$k];
            }
        }
        return $new_array;
    }

    public function getCustomerOrderDetails()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
        if($curtz == ""){
            $curtz = "Asia/Singapore";
        }
        $lstatus="N";
        if(strlen($order_id)>0){
            $altrord = "ORDER_".$order_id;
            $query2 = $this->db->query("
                SELECT
                    shift_id, stop_id, drop_stopid, vendor_id, order_id
                FROM tb_employee
                WHERE
                    order_id = ?
                    OR order_id = ?
            ", [
                $order_id,
                $altrord
            ]);
            if($query2->num_rows()>0){
                $actordid = $query2->row()->order_id;
                $stops = [];
                $shift_id = 0;
                $vendor_id = "";
                foreach($query2->result() as $row2){
                    $stops[] = $row2->stop_id;
                    $stops[] = $row2->drop_stopid;
                    $shift_id = $row2->shift_id;
                    if($row2->vendor_id != "" && $row2->vendor_id != "0"){
                        $vendor_id = $row2->vendor_id;
                    }
                }
                if($shift_id!=0){
                    $carrier_name = "";
                    if ($vendor_id != ""){
                        $carrier = $this->db->query("
                            SELECT name
                            FROM tb_vendors
                            WHERE id = ?
                        ", [
                            $vendor_id
                        ]);
                        if($carrier->num_rows()>0){
                            $carrier_name = $carrier->row()->name;
                        }
                    }else{
                        $carrier = $this->db->query("
                            SELECT v.name
                            FROM tb_vendors v, tb_shifts s
                            WHERE
                                s.id = ?
                                AND v.id = s.vendor_id
                        ", [
                                $shift_id
                        ]);
                        if($carrier->num_rows()>0){
                            $carrier_name = $carrier->row()->name;
                        }
                    }
                    $last_update = "";
                    $timelines = [];
                    foreach($stops as $stop){
                        $query = $this->db->query("
                            SELECT
                                latitude, longitude, imgpath, convertToClientTZ(createdon, ?) as createdon,hash
                            FROM tb_pod_uploads
                            WHERE
                                stop_id = ''
                                AND status='1'
                        ", [
                            $curtz,
                            $stop
                        ]);
                        foreach($query->result() as $row){
                            $loc = getLocationName($row->latitude, $row->longitude);
                            $timelines[] = array('title' => "POD/Document", 'sub_title' => $loc, 'date' => strtotime($row->createdon), 'status' => $lstatus,'type'=>"1",'image'=> base_url() . 'downloadEpod/safelink/' . $row->hash. '.epod');
                        }
                        $lstatus="N";
                        $ostatus = "NOT STARTED";
                        $chksts = $this->db->query("
                            SELECT status
                            FROM tb_trips
                            WHERE shift_id = ?
                            LIMIT 1
                        ", [
                            $shift_id
                        ]);
                        if($chksts->num_rows()>0){
                            $sts = $chksts->row()->status;
                            if($sts == 0){
                                $lstatus="C";
                                $ostatus = "DELIVERED";
                            }else{
                                $lstatus="S";
                                $ostatus = "STARTED";
                            }
                            $query1 = $this->db->query("
                                SELECT
                                    ss.status_id, ss.latitude, ss.longitude, convertToClientTZ(ss.createdon,?) as createdon, sm.status_name
                                FROM tb_stop_status ss, tb_status_master sm
                                WHERE
                                    ss.stop_id = ?
                                    AND ss.status='1'
                                    AND ss.status_id = sm.id
                                ORDER BY ss.id ASC
                            ", [
                                $curtz,
                                $stop
                            ]);
                            foreach($query1->result() as $row1){
                                $loc = getLocationName($row1->latitude, $row1->longitude);
                                $ostatus1 = $row1->status_name;
                                $timelines[] = array('title' => $ostatus1, 'sub_title' => $loc, 'date' => strtotime($row1->createdon), 'status' => $lstatus,'type'=>"1",'image'=>"");
                                $last_update = strtotime($row1->createdon);
                            }
                        }else{
                            $query1 = $this->db->query("
                                SELECT
                                    ss.status_id, ss.latitude, ss.longitude, convertToClientTZ(ss.createdon, ?) as createdon, sm.status_name
                                FROM tb_stop_status ss, tb_status_master sm
                                WHERE
                                    ss.stop_id = ?
                                    AND ss.status = '1'
                                    AND ss.status_id = sm.id
                                ORDER BY ss.id ASC
                            ", [
                                $curtz,
                                $stop
                            ]);
                            foreach($query1->result() as $row1){
                                $loc = getLocationName($row1->latitude, $row1->longitude);
                                $ostatus1 = $row1->status_name;
                                $timelines[] = array('title' => $ostatus1, 'sub_title' => $loc, 'date' => strtotime($row1->createdon), 'status' => $lstatus,'type'=>"1",'image'=>"");
                                $last_update = strtotime($row1->createdon);
                            }
                        }
                    }
                    $timelines = $this->array_sort($timelines,"date");
                    $lstatus="N";
                    $act_timelines=[];
                    foreach($timelines as $i=>$timeline){
                        if($i!=0){
                            $lstatus = $timelines[$i-1]["status"];
                        }
                        if(strlen($timeline["image"])>0){
                            $timeline["status"]==$lstatus;
                            $act_timelines[] = $timeline;
                        }else{
                            $act_timelines[] = $timeline;
                        }
                    }
                    $result = array();
                    if($lstatus=="S"){
                        $result = $this->getStartEndPoints($shift_id);
                    }
                    $query = $this->db->query("
                        SELECT
                            s.id as shift_id, s.user_id, convertToClientTZ(s.startdate, ?) as stime, convertToClientTZ(s.enddate, ?) as etime, s.trip_type,
                            convertToClientTZ(s.startdate, ?) as startdate, convertToClientTZ(s.enddate, ?) as enddate, s.splace, s.eplace, s.scity, s.dcity,
                            s.slat, s.slng, s.elat, s.elng, s.shipmentid, SUM(e.shipment_weight) as shipweight, SUM(e.shipment_volume) as shipvolume, SUM(e.no_of_pkgs) as numpkgs, e.pkgitemid as material,e.order_id
                        FROM
                            tb_shifts s,
                            tb_shiporder_stops o,
                            tb_employee e
                        WHERE
                            s.id = o.shipment_id
                            AND e.shift_id = ?
                            AND s.id = e.shift_id
                        GROUP BY s.id
                        ORDER BY s.id DESC
                        LIMIT 3
                    ", [
                        $curtz,
                        $curtz,
                        $curtz,
                        $curtz,
                        $shift_id
                    ]);
                    $trip = array();
                    $customerOrder = array("carrier_name"=>$carrier_name,"tracking_number"=>$order_id,"status"=>$ostatus,"last_updated"=>$last_update,"data"=>$act_timelines,"result"=>$result,"trip"=>"");
                    if ($query->num_rows() > 0) {
                        $i = 0;
                        foreach ($query->result_array() as $d) {
                            $chstops = $this->db->select("address")->order_by("ordernumber","ASC")->get_where("tb_shiporder_stops",array("shipment_id"=>$d['shift_id']));
                            if($chstops->num_rows()>0){
                                $l=0;
                                $k = ($chstops->num_rows()-1);
                                foreach($chstops->result() as $stp){
                                    if($l == 0){
                                        $d["saddress"] = $stp->address;
                                    }
                                    if($k == $l){
                                        $d["daddress"] = $stp->address;
                                    }
                                    $l++;
                                }
                            }
                            [$pickup, $drop] = $this->addressesFromShift($d);
                            $d["splace"] = $pickup;
                            $d["eplace"] = $drop;
                            $qry = $this->db->query("
                                SELECT
                                    id, convertToClientTZ(stime, ?) as stime, transit_status
                                FROM tb_trips
                                WHERE shift_id = ?
                                ORDER BY id DESC
                                LIMIT 1
                            ", [
                                $curtz,
                                $d['shift_id']
                            ]);
                            if($qry->num_rows() == 0){
                                $d['id'] = "0";
                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance']  = $dist['disttext'];
                                $d['duration']  = $dist['duratext'];
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate']   = strtotime($d['enddate']);
                                $d['astatus'] = "";
                                $d['pod'] = "";
                                $d['signature'] = "";
                                $d['ref_id'] = $this->getrefsbyorder($actordid);
                                $trip = $d;
                                $customerOrder["trip"] = $trip;
                                $i++;
                            } else {
                                $sts = $qry->row()->transit_status;
                                $d['id'] = $qry->row()->id;
                                $stime = $qry->row()->stime;
                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance']  = $dist['disttext'];
                                $d['duration']  = $dist['duratext'];
                                $d['startdate'] = strtotime($stime);
                                $d['enddate'] = strtotime($d['enddate']);
                                $eta = getEDAofShipmentbyord($order_id);
                                if($eta['time'] != ""){
                                    $d['enddate'] = strtotime($eta['time']);
                                }
                                $d['astatus'] = $sts;
                                $d['ref_id'] = $this->getrefsbyorder($actordid);
                                $trip = $d;
                                $customerOrder["trip"] = $trip;
                                $i++;
                            }
                        }
                    }
                    $response =  array("status"=>"1","data"=>$customerOrder);
                }else{
                    $response =  array("status"=>"0","data"=>"Invalid Order Id");
                }
            }else{
                $response =  array("status"=>"0","data"=>"Invalid Order Id");
            }
        }else{
            $response =  array("status"=>"0","data"=>"Invalid Order Id");
        }
        echo json_encode($this->printable($response));
    }
    private function printable($array){
        $ret=[];
        foreach($array as $key=>$value){
            if(is_array($value)){
                $ret[$key] = $this->printable($value);
            }else{
                if(!isset($value) || $value==null){
                    $value = "";
                }
                $ret[$key] = "$value";
            }
        }
        return $ret;
    }

    private function getStartEndPoints($shift_id){
        $result = [];
        $sql = $this->db->query("
            SELECT start_imei
            FROM tb_trips
            WHERE
                shift_id = ?
                AND status='1'
            ORDER BY id DESC
            LIMIT 1
        ", [
            $shift_id
        ]);
        if($sql->num_rows()>0){
            $imei = $sql->row()->start_imei;
            $row = $this->db->query("
                SELECT latitude, longitude
                FROM tb_rtdrive_locations
                WHERE mobileimei = ?
                ORDER BY `timestamp` DESC
                LIMIT 1
            ", [
                $imei
            ]);
            if($row->num_rows()>0){
                $result[] = array('plat' => $row->row()->latitude, 'plng' => $row->row()->longitude,'stop_name'=>'');
            }
        }
        $shift = $this->db->query("
            SELECT elat, elng, dcity
            FROM tb_shifts
            WHERE id = ?
        ", [
            $shift_id
        ]);
        if($shift->num_rows()>0){
            $result[] = array('plat' => $shift->row()->elat, 'plng' => $shift->row()->elng,'stop_name'=>$shift->row()->dcity);
        }
        return $result;
    }

    public function customerprofile(){
        $response = array("status" =>"0", "data" => "Not Found");
        $cust_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $type = isset($_POST['type']) ? $_POST['type'] : 0;
        if($cust_id > 0){
            if($type == "0"){
                $qry = $this->db->select("name,phone,location,address,country,pincode,email_id,company_code")->get_where("tb_customers",array("id"=>$cust_id),1,0);
                if($qry->num_rows()>0){
                    $res = $qry->row();
                    $data = array("name"=>$res->name,"phone"=>$res->phone,"city"=>$res->location,"address"=>$res->address,"country"=>$res->country,"pincode"=>$res->pincode,"email"=>$res->email_id,"company"=>$res->company_code);
                    $response = array("status" =>"1", "data" => $data);
                }
            }else{
                $qry = $this->db->select("name,code as phone,city as location,address,countrycode as country,zipcode as pincode,email_id,'' as company_code")->get_where("tb_customer_logins",array("id"=>$cust_id),1,0);
                if($qry->num_rows()>0){
                    $res = $qry->row();
                    $data = array("name"=>$res->name,"phone"=>$res->phone,"city"=>$res->location,"address"=>$res->address,"country"=>$res->country,"pincode"=>$res->pincode,"email"=>$res->email_id,"company"=>$res->company_code);
                    $response = array("status" =>"1", "data" => $data);
                }
            }
        }
        echo json_encode($this->printable($response));
    }

    public function customernotifys(){
        $response = array("status" =>"0", "data" => "Not Found");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        if($cust_id > 0){
            $qry = $this->db->select("id")->get_where("tb_firebase_notifications",array("user_id"=>$cust_id,"notify_type"=>"Customer","msg_status"=>0));
            $notecount = $qry->num_rows();
            if($notecount == 0){
                $notecount = "0";
            }
            $response = array("status" =>"1", "data" => $notecount);
        }
        echo json_encode($this->printable($response));
    }

    public function customernoteshipments()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $ord_id = isset($_POST['search']) ? $_POST['search'] : '';
        if ($cust_id > 0 && $user_id > 0) {
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            $whr = "";

            $bindings = [
                $curtz,
                $curtz,
                $curtz,
                $curtz,
                $cust_id,
                $user_id
            ];
            if ($ord_id != "") {
                $refs = $this->getordersbyrefid($ord_id);
                if(!empty($refs)){
                    $bindings[] = $refs;
                    $gords = implode("','",$refs);
                    $whr .= " AND e.order_id IN ? ";
                }else{
                    $bindings[] = $ord_id;
                    $bindings[] = $ord_id;
                    $whr .= " AND (s.shipmentid = ? OR e.order_id = ?)";
                }
            }

            /*log_message("error",$sql);*/
            $query = $this->db->query("
                SELECT
                    s.id as shift_id, s.user_id, convertToClientTZ(s.startdate, ?) as stime, convertToClientTZ(s.enddate, ?) as etime, s.trip_type,
                    convertToClientTZ(s.startdate, ?) as startdate, convertToClientTZ(s.enddate, ?) as enddate, s.splace, s.eplace, s.scity, s.dcity,
                    s.slat, s.slng, s.elat, s.elng, s.shipmentid, e.order_id, SUM(e.shipment_weight) as shipweight, SUM(e.shipment_volume) as shipvolume,
                    SUM(e.no_of_pkgs) as numpkgs, e.pkgitemid as material, e.order_id, t.id, t.status, t.transit_status
                FROM
                    tb_shifts s,
                    tb_employee e,
                    tb_trips t,
                    tb_stop_status v
                WHERE
                    s.id = e.shift_id
                    AND s.id = t.shift_id
                    AND e.customer_id = ?
                    AND s.user_id = ?
                    AND s.status = 1
                    AND t.transit_status = 1 $whr
                GROUP BY s.id
                ORDER BY s.id DESC
            ", $bindings);
            $res = array();
            if ($query->num_rows() > 0) {
                $i = 0;
                foreach ($query->result_array() as $d) {
                    [$pickup, $drop] = $this->addressesFromShift($d);
                    $d["splace"] = $pickup;
                    $d["eplace"] = $drop;
                    $sts = $d['transit_status'];
                    $d['id'] = $d['id'];
                    $d['sno'] = $i;
                    $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                    $d['distance']  = $dist['disttext'];
                    $d['duration']  = $dist['duratext'];
                    $d['startdate'] = strtotime($d['startdate']);
                    $d['enddate']   = strtotime($d['enddate']);
                    $d['astatus'] = $sts;
                    $d['ref_id'] = $this->getrefsbyorder($d['order_id']);
                    $chksts = $this->db->select("stop_type,status_id")->order_by("id","DESC")->get_where("tb_stop_status",array("trip_id"=>$d['id']),1,0);
                    $stsid = $chksts->row()->status_id;
                    if($chksts->row()->status_id == 1 && $chksts->row()->stop_type == "D"){
                        $stsid = "5";
                    }
                    if($d['status'] == '0'){
                        $stsid = "6";
                    }
                    $d['recent_status'] = $stsid;
                    $res['trips'][] = $d;
                    $i++;
                }
                /*update notifys as read*/
                $updwhr = array("user_id"=>$cust_id,"notify_type"=>"Customer");
                $upd = $this->db->where($updwhr)->update("tb_firebase_notifications",array("msg_status"=>1));
                $response = array("status" =>"1", "data" => $res);
            } else {
                $response = array("status" =>"0", "data" => "Not Found");
            }
        } else {
            $response = array("status" =>"0", "data" => "Something went wrong,please try again!");
        }
        echo json_encode($this->printable($response));
    }

    public function set_fcm_id()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $fcm_id = isset($_POST['fcm_id']) ? $_POST['fcm_id'] : 0;
        $type = isset($_POST['type']) ? $_POST['type'] : 0;
        if ($cust_id > 0 && $fcm_id != "") {
            if($type == "0"){
                $upd = $this->db->where("id", $cust_id)->update("tb_customers", array("gcm_id" => $fcm_id));
            }else{
                $upd = $this->db->where("id", $cust_id)->update("tb_customer_logins", array("gcm_id" => $fcm_id));
            }
            $response = array("status" =>"1", "data" => "Updated Successfully!");
        } else {
            $response = array("status" =>"0", "data" => "Something went wrong,please try again!");
        }
        echo json_encode($this->printable($response));
    }

    public function loginetnuser()
    {
        $curdt = date("Y-m-d H:i:s");
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $input = json_decode(file_get_contents("php://input"), true);
            $post = $input;
            $data = (array)$post['data'];
            $billingAddressLine1 = isset($data['billingAddressLine1']) ? $data['billingAddressLine1'] : "";
            $billingAddressLine2 = isset($data['billingAddressLine2']) ? $data['billingAddressLine2'] : "";
            $billingCity = isset($data['billingCity']) ? $data['billingCity'] : "";
            $billingCountry = isset($data['billingCountry']) ? $data['billingCountry'] : "SG";
            $billingPostalCode = isset($data['billingPostalCode']) ? $data['billingPostalCode'] : "";
            $code = $ref = isset($data['code']) ? $data['code'] : "";
            $organization = isset($data['organization']) ? $data['organization'] : "";
            if(isset($organization->ref)){
                $ref = $organization->ref;
            }
            $companyName = isset($data['companyName']) ? $data['companyName'] : "";
            $country = isset($data['country']) ? $data['country'] : "";
            $email = isset($data['email']) ? $data['email'] : "";
            $firstName = isset($data['firstName']) ? $data['firstName'] : "";
            $lastName = isset($data['lastName']) ? $data['lastName'] : "";
            $fullName = isset($data['fullName']) ? $data['fullName'] : "";
            $id = isset($data['id']) ? $data['id'] : "";
            $password = isset($data['password']) ? $data['password'] : "";
            $phoneNumber = isset($data['phoneNumber']) ? $data['phoneNumber'] : "";
            $roleName = isset($data['roleName']) ? $data['roleName'] : "";
            $shipperId = isset($data['shipperId']) ? $data['shipperId'] : "";
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            $imei   = isset($_POST["imei"]) ? $_POST["imei"] : '';
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            if ($ref != "" && $firstName != ""){
                $qry = $this->db->select("id,lmv_id")->get_where("tb_etn_customers",array("code"=>$ref),1,0);
                if ($qry->num_rows() > 0) {
                    $custid = $qry->row()->lmv_id;
                }else{
                    $arr = array('lmv_id'=>0, 'etn_id'=>$id, 'first_name'=>$firstName, 'last_name'=>$lastName, 'full_name'=>$fullName, 'code'=>$ref, 'mobile'=>$phoneNumber, 'emailid'=>$email, 'password'=>$password, 'role_name'=>$roleName, 'shipperid'=>$shipperId, 'country'=>$country, 'company'=>$companyName, 'billingaddress1'=>$billingAddressLine1, 'billingaddress2'=>$billingAddressLine2, 'billingcity'=>$billingCity, 'billingcountry'=>$billingCountry, 'billingpostalcode'=>$billingPostalCode, 'status'=>1, 'created_at'=>$curdt);
                    $etnid = $this->common->insertTableData("tb_etn_customers",$arr);
                    $qry = $this->db->select("id")->get_where("tb_customers",array("code"=>$ref),1,0);
                    if ($qry->num_rows() > 0) {
                        $custid = $qry->row()->id;
                        $updarr = array("lmv_id"=>$custid);
                        $whrarr = array("id"=>$etnid);
                        $updqry = $this->db->set($updarr)->where($whrarr)->update("tb_etn_customers");
                    }else{
                        $pwd = password_hash($password,PASSWORD_DEFAULT);
                        $usr = $this->db->query("
                            SELECT
                                u.id, u.company_code, u.branch_code
                            FROM tb_users u, tbl_country_master c
                            WHERE
                                u.country_code = c.country_code
                                AND c.country_name = ?
                                AND u.status = 'Active'
                                AND c.status = 1
                            LIMIT 1
                        ", [
                            $companyName
                        ]);
                        $user_id = 5;
                        $company_code = "SGKN";
                        $branch_code = "SGTGA";
                        if($usr->num_rows()>0){
                            $user_id = $usr->row()->id;
                            $company_code = $usr->row()->company_code;
                            $branch_code = $usr->row()->branch_code;
                        }
                        $custarr = array('name'=>$firstName, 'phone'=>$phoneNumber, 'location'=>$billingCity, 'address'=>$billingAddressLine1, 'pincode'=>$billingPostalCode, 'code'=>$ref, 'country'=>$country, 'password'=>$pwd, 'user_id'=>$user_id,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                        $custid = $this->common->insertTableData("tb_customers",$custarr);
                        /*party master*/
                        $partytypeid = 1;
                        $qry = $this->db->select("id")->get_where("tbl_party_types",array("name"=>"CUSTOMER","branch_code"=>$branch_code,"status"=>1),1,0);
                        if($qry->num_rows()>0){
                            $partytypeid = $qry->row()->id;
                        }
                        $partyarr = array('party_type_id'=>$partytypeid, 'name'=>$firstName,  'email'=>$firstName, 'mobile'=>$phoneNumber, 'location_id'=>$billingCity, 'address'=>$billingAddressLine1, 'pincode'=>$billingPostalCode,'country'=>$country, 'user_id'=>$user_id,'code'=>$ref, 'company_code'=>$company_code, 'branch_code'=>$branch_code, 'customer_code'=>$ref, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
                        $partyid = $this->common->insertTableData("tbl_party_master",$partyarr);
                        $updarr = array("lmv_id"=>$custid);
                        $whrarr = array("id"=>$etnid);
                        $updqry = $this->db->set($updarr)->where($whrarr)->update("tb_etn_customers");
                    }
                }
                $whr = array("d.id" => $custid, "d.status" => 1);
                $this->db->select('d.*,u.mobile_no,u.default_currency as currency');
                $this->db->from('tb_customers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                $numrows = $sql->num_rows();
                $insdata = array("mobile" => $phoneNumber, "password" => $password, "imei" => $imei, "status" => $numrows);
                $res = $this->db->insert("tb_employee_login_logs", $insdata);
                if ($numrows > 0) {
                    $id = $sql->row()->id;
                    if ($gcm_id != "" && $imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei, "gcm_id" => $gcm_id));
                    } else if ($imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei));
                    }
                    $resdata = $sql->row_array();
                    $resdata['child_id'] = "";
                    $countrytimezone = "Asia/Singapore";
                    $chkcntry = $this->db->select("cntry_timezone")->get_where("tbl_country_master",array("country_code"=>$data['country']),1,0);
                    if($chkcntry->num_rows()>0){
                        $countrytimezone = $chkcntry->row()->cntry_timezone;
                    }
                    $resdata['timezone'] = $countrytimezone;
                    $response = array("status" => 2, "data" => $resdata);
                }
            }
        }
        echo json_encode($this->printable($response));
    }

    public function quick_book(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $orderid = "0";
            $post1 = json_decode(file_get_contents("php://input"), true);
            $post = $post1['data'];
            $addOns = $data['add_ons'] = isset($post['addons']) ? $post['addons'] : array();
            $contacts = isset($post['contacts']) ? $post['contacts'] : array();
            $routings = isset($post['routings']) ? $post['routings'] : array();
            $vehicle = isset($post['vehicle']) ? $post['vehicle'] : array();
            $uid = isset($post1['user_id']) ? $post1['user_id'] : "";
            $customerid = isset($post1['customer_id']) ? $post1['customer_id'] : "";
            $curtz = isset($post1['timezone']) ? $post1['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            if($customerid != "" && $uid != ""){
	            if(!empty($contacts)){
		            $consigneeName = isset($contacts['CONSIGNEE']['fullName']) ? $contacts['CONSIGNEE']['fullName'] : "";
		            $consigneePhone = isset($contacts['CONSIGNEE']['phoneNo']) ? $contacts['CONSIGNEE']['phoneNo'] : "";
		            $consigneeEmail = isset($contacts['CONSIGNEE']['email']) ? $contacts['CONSIGNEE']['email'] : "";
		            $consigneeCode = isset($contacts['CONSIGNEE']['code']) ? $contacts['CONSIGNEE']['code'] : "";
		            if($consigneeName == ""){
		                $where = array("id"=>$customerid);
		                $custdetails = $this->common->gettblrowdata($where,"name,phone,code,email_id","tb_customers",0,0);
		                if(count($custdetails)>0){
		                    $consigneeName = $custdetails['name'];
		                    $consigneePhone = $custdetails['phone'];
		                    $consigneeEmail = $custdetails['email_id'];
		                    $consigneeCode = $custdetails['code'];
		                }
		            }
		            $consignorName = isset($contacts['CONSIGNOR']['fullName']) ? $contacts['CONSIGNOR']['fullName'] : "";
		            $consignorPhone = isset($contacts['CONSIGNOR']['phoneNo']) ? $contacts['CONSIGNOR']['phoneNo'] : "";
		            $consignorEmail = isset($contacts['CONSIGNOR']['email']) ? $contacts['CONSIGNOR']['email'] : "";
		            $consignorCode = isset($contacts['CONSIGNOR']['code']) ? $contacts['CONSIGNOR']['code'] : "";
		            $vehicletype = isset($vehicle['title']) ? $vehicle['title'] : "";
		            $pickupDate = isset($routings['PICK_UP']['fromDateTime']) ? $routings['PICK_UP']['fromDateTime'] : date("Y-m-d H:i:s");
		            $getactual1 = getdatetimebytimezone(DFLT_TZ,$pickupDate,$curtz);
		            $pickupDate = $getactual1['datetime'];
		            $pickupendDate = isset($routings['PICK_UP']['toDateTime']) ? $routings['PICK_UP']['toDateTime'] : date("Y-m-d H:i:s");
		            $getactual1 = getdatetimebytimezone(DFLT_TZ,$pickupendDate,$curtz);
		            $pickupendDate = $getactual1['datetime'];
		            $pickupCity = isset($routings['PICK_UP']['district']) ? $routings['PICK_UP']['district'] : "";
		            $pickupAddressLine1 = isset($routings['PICK_UP']['addressLine1']) ? $routings['PICK_UP']['addressLine1'] : "";
		            $pickupCompany = isset($routings['PICK_UP']['company']) ? $routings['PICK_UP']['company'] : "";
		            $pickupCountry = $data['pickup_country'] = isset($routings['PICK_UP']['country']) ? $routings['PICK_UP']['country'] : "";
		            $pickupPin = isset($routings['PICK_UP']['portalCode']) ? $routings['PICK_UP']['portalCode'] : "";
		            $plat = isset($routings['PICK_UP']['latitude']) ? $routings['PICK_UP']['latitude'] : "";
		            $plng = isset($routings['PICK_UP']['longitude']) ? $routings['PICK_UP']['longitude'] : "";
		            $dropDate = isset($routings['DELIVERY']['fromDateTime']) ? $routings['DELIVERY']['fromDateTime'] : date("Y-m-d H:i:s");
		            $getactual1 = getdatetimebytimezone(DFLT_TZ,$dropDate,$curtz);
		            $dropDate = $getactual1['datetime'];
		            $dropendDate = isset($routings['DELIVERY']['toDateTime']) ? $routings['DELIVERY']['toDateTime'] : date("Y-m-d H:i:s");
		            $getactual1 = getdatetimebytimezone(DFLT_TZ,$dropendDate,$curtz);
		            $dropendDate = $getactual1['datetime'];
		            $dropCity = isset($routings['DELIVERY']['district']) ? $routings['DELIVERY']['district'] : "";
		            $dropAddressLine1 = isset($routings['DELIVERY']['addressLine1']) ? $routings['DELIVERY']['addressLine1'] : "";
		            $dropCompany = isset($routings['DELIVERY']['company']) ? $routings['DELIVERY']['company'] : "";
		            $dropCountry = $data['drop_country'] = isset($routings['DELIVERY']['country']) ? $routings['DELIVERY']['country'] : "";
		            $dropPin = isset($routings['DELIVERY']['portalCode']) ? $routings['DELIVERY']['portalCode'] : "";
		            $dlat = isset($routings['DELIVERY']['latitude']) ? $routings['DELIVERY']['latitude'] : "";
		            $dlng = isset($routings['DELIVERY']['longitude']) ? $routings['DELIVERY']['longitude'] : "";
		            $quantity = $data['quantity'] = isset($post->quantity) ? $post->quantity : 1;
		            $weight = $data['weight'] = isset($post->weight) ? $post->weight : 1;
		            $volume = $data['volume'] = isset($post->volume) ? $post->volume : 1;
		            $shipmentOption = isset($post->shipmentOption) ? $post->shipmentOption : 0;
		            if($shipmentOption == "0"){ $shipmentOption = "TL"; }else{ $shipmentOption = "LTL"; }
		            $data['transportmode'] = $shipmentOption;
		            $valueOfGoods = isset($post->valueOfGoods) ? $post->valueOfGoods : 0;
		            $cargos = $data['detail_cargo'] = isset($post->cargoes) ? $post->cargoes : array();
		            $addOns = $data['add_ons'] = isset($post->addOns) ? $post->addOns : array();
		            $logdate = date('Y-m-d H:i:s');
		            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
		            $curdt = $getactual['datetime'];
		            $vendorid = 0;
		            $ord = "ORDER_".time();
		            $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickupDate, 'pickup_endtime'=>$pickupendDate, 'delivery_datetime'=>$dropDate, 'drop_endtime'=>$dropendDate, 'pickup_company'=>$pickupCompany, 'delivery_company'=>$dropCompany, 'pickup_country'=>$pickupCountry, 'delivery_country'=>$dropCountry, 'pickup_city'=>$pickupCity, 'delivery_city'=>$dropCity, 'pickup_pincode'=>$pickupPin, 'delivery_pincode'=>$dropPin, 'pickup_address1'=>$pickupAddressLine1, 'delivery_address1'=>$dropAddressLine1, 'quantity'=>$quantity, 'weight'=>$weight, 'volume'=>$volume, 'goods_value'=>$valueOfGoods, 'transport_mode'=>$shipmentOption, 'dedicated_vehicle'=>0, 'vehicle_type'=>$vehicletype, 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$consigneeName, 'customer_code'=>$consigneeCode, 'customer_area'=>$pickupCity, 'customer_phone'=>$consigneePhone, 'customer_email'=>$consigneeEmail, 'vendor_name'=>$consignorName, 'vendor_code'=>$consignorCode, 'vendor_area'=>$pickupCity, 'vendor_phone'=>$consignorPhone, 'vendor_email'=>$consignorEmail, 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'is_created'=>1, 'createdon'=>$curdt,"created_source"=>"customerapiv2/quick_book");
		            $orderid = $this->common->insertTableData("tb_orders",$orddata);
		            /* insert into cargo types */
		            if(count($cargos)>0){
		                foreach($cargos as $ct){
		                    if($ct != ""){
		                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
		                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
		                    }
		                }
		            }else{
		                $ins = array('cargo_type'=>"General Cargo", 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
		                $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
		            }
		            /* insert into cargo details */
		            $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>1, 'length'=>$weight, 'width'=>$weight, 'height'=>$weight, 'weight'=>$weight, 'quantity'=>$quantity, 'status'=>1, 'createdon'=>$curdt);
		            $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
		            /* insert into add ons */
		            if(count($addOns)>0){
		                foreach($addOns as $dc){
		                    if($dc != ""){

		                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
		                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
		                    }
		                }
		            }
		        }
		    }
            $response = array("status" => 1, "data" => $orderid);
        }
        echo json_encode($this->printable($response));
    }
    public function booking(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $post1 = json_decode(file_get_contents("php://input"), true);
            $post = $post1['data'];
            $prices = isset($post['prices']) ? $post['prices'] : array();
            $order_id = isset($post1['order_id']) ? $post1['order_id'] : "";
            $uid = isset($post1['user_id']) ? $post1['user_id'] : "";
            $customerid = isset($post1['customer_id']) ? $post1['customer_id'] : "";
            $curtz = isset($post1['timezone']) ? $post1['timezone'] : '';
            if($curtz == ""){
                $curtz = "Asia/Singapore";
            }
            if($customerid != "" && $uid != ""){
	            if(!empty($prices)){
	            	$res = $prices[0];
		            $vehicletype = isset($res['rateType']) ? $res['rateType'] : "";
		            $pricecat = isset($res['bookingPriceCategories']) ? $res['bookingPriceCategories'] : array();
		            $rate = isset($res['rate']) ? $res['rate'] : array();
		            $currency = "SGD";
		            $price = 0;
		            $buyrate = 0;
		            $fleetSize = 0;
		            $ref = $ref1 = "";
		            $carriercmp = $carriername = $carrierref = $carriernum = "";
		            if(!empty($pricecat)){
		            	$currency = $pricecat[0]['currency']['code'];
		            	$price = $pricecat[0]['totalPrice'];
		            	$buyrate = $pricecat[0]['buyRate'];
		            }
		            if(!empty($rate)){
		            	$fleetSize = $rate['fleetSize'];
		            	$ref = $rate['ref'];
		            	if(isset($rate['offering'])){
							$carriercmp = $carriername = $rate['offering']['companyName'];
							$carrierref = $rate['offering']['ref'];
							$carriernum = $rate['offering']['registrationNumber'];
		            	}

		            	if(isset($rate['lane'])){
							$ref1 = $rate['lane']['ref'];
		            	}
		            }
	            }
	        }
        }
        echo json_encode($response);
    }
}
