<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customerpreferences extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model('common');
        $this->load->model('Uniqlomodel');
        $this->load->helper('drop_down');
        $this->load->helper('log_helper');
        if (!checkUrlAccessForUser('CUSTOMERPREFERENCES')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('preferred_state');
        $data['sub_title'] = $this->lang->line('general_search');
        $company_code = $this->session->userdata('company_code');

        $where['tc.status'] = 1;
        $whr = array();
        /*if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $city = $this->input->post('city',TRUE);
            $state = $this->input->post('state',TRUE);
            $pincode = $this->input->post('pincode',TRUE);
            $fdate = $this->input->post('fromdate',TRUE);
            $edate = $this->input->post('todate',TRUE);
            $searchcarrier_id = $this->input->post('searchcarrier_id',TRUE);
            if (isset($city) && $city != "") {
                $whr['tc.city'] = $city;
            }
            if (isset($state) && $state != "") {
                $whr['tc.state'] = $state;
            }
            if (isset($pincode) && $pincode != "") {
                $whr['tc.pincode'] = $pincode;
            }

            if (isset($fdate) && $fdate != "") {
                $where["DATE(tc.createdon) >="] = $fdate;
            }
            if (isset($edate) && $edate != "") {
                $where["DATE(tc.createdon) <="] = $edate;
            }
            if (isset($searchcarrier_id) && $searchcarrier_id != "") {
                $whr['tc.carrier_id'] = $searchcarrier_id;
            }
        } else*/if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $city = $this->input->post('city',TRUE);
            $state = $this->input->post('state',TRUE);
            $pincode = $this->input->post('pincode',TRUE);
            $searchcarrier_id = $this->input->post('searchcarrier_id');
            $fdate = $this->input->post('fromdate',TRUE);
            $edate = $this->input->post('todate',TRUE);

            if (isset($fdate) && $fdate != "") {
                $from_date_obj = DateTime::createFromFormat('d-m-Y', $fdate);
                if ($from_date_obj !== false) {
                    $where["DATE(tc.createdon) >="] = $from_date_obj->format('Y-m-d');
                }
            }
            if (isset($edate) && $edate != "") {
                $to_date_obj = DateTime::createFromFormat('d-m-Y', $edate);
                if ($to_date_obj !== false) {
                    $where["DATE(tc.createdon) <="] = $to_date_obj->format('Y-m-d');
                }
            }
            
            if (isset($city) && $city != "") {
                $whr['tc.city'] = $city;
            }

            if (isset($state) && $state != "") {
                $whr['tc.state'] = $state;
            }
            if (isset($pincode) && $pincode != "") {
                $whr['tc.pincode'] = $pincode;
            }


            if (isset($searchcarrier_id) && $searchcarrier_id != "") {
                $whr['tc.carrier_id'] = $searchcarrier_id;
            }
        }


        $data['vendors'] = $this->common->gettbldata(
            array('status' => '1', 'company_code' => $this->session->userdata('company_code'),),
            "id,name",
            "tb_vendors",
            0,
            0
        );
        $preference=[];
        /*if (!empty($_POST)) {
            $preference = $this->Uniqlomodel->customerpreferencedata($where, $whr);
        }*/
        $preference = $this->Uniqlomodel->customerpreferencedata($where, $whr);
        $data['preferences'] = $preference;
        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpreferences outbound data for customerpreferences/index: " . json_encode($data)
        );

        $this->newtemplate->dashboard("customerpreferences/index", $data);
    }

    public function add()
    {
        $data['page_title'] = $this->lang->line('preferred_state');
        $data['sub_title'] = $this->lang->line('general_add');
        $data['vendors'] = $this->common->gettbldata(
            array('status' => '1', 'company_code' => $this->session->userdata('company_code'),),
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpreferences|add outbound data for customerpreferences/add: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpreferences/add", $data);
        $this->load->view("customerpreferences/add", $data);
    }


    public function insertpreferencerules()
    {
        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $res = array(
            'city' => $city,
            'state' => $state,
            'pincode' => $pincode,
            'user_id' => $this->session->userdata('user_id'),
            'carrier_id' => $carrier_id,
            'createdby' => $this->session->userdata('user_id'),
            'createdon' => date('Y-m-d H:i:s'),
            'updatedby' => $this->session->userdata('user_id'),
            'updatedon' => date('Y-m-d H:i:s'),
            'user_type' => 0,
            'status' => 1,

        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpreferences insertpreferencerules inserted data in a tb_carrier_prefer_rule: " . json_encode($res)
        );

        $result = $this->common->insertTableData('tb_carrier_prefer_rule', $res);

        log_error(
            UNIQLO_LOG_PREFIX . "Customerpreferences insertpreferencerules outbound data: " . json_encode($result)
        );

        echo json_encode($result);
    }

    public function edit($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Customerpreferences|edit inbound data: " . $id);

        $user_id = $this->session->userdata('user_id');
        $data['user_id'] = $user_id;
        $data['page_title'] = $this->lang->line('preferred_state');
        $data['sub_title'] = $this->lang->line('general_edit');
        $where1 = array(
            'id' => $id
        );

        $table1 = "tb_carrier_prefer_rule";
        $edit_data = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $data['vendors'] = $this->common->gettbldata(
            array('status' => '1', 'company_code' => $this->session->userdata('company_code'),),
            "id,name",
            "tb_vendors",
            0,
            0
        );
        $data['vendor'] = $this->common->gettblrowdata(
            array('id' => $edit_data['carrier_id']),
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpreferences|edit outbound data for customerpreferences/editpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpreferences/edit", $data);
        $this->load->view("customerpreferences/edit", $data);
    }

    public function updatepreferencerule()
    {
        $id = $this->input->post('id',TRUE);
        if (isset($id)) {
            $user_id = $this->session->userdata('user_id');
            $post = $this->input->post(NULL,TRUE);
            extract($post);
            $res = array(
                'carrier_id' => $carrier_id,
                'city' => $city,
                'state' => $state,
                'pincode' => $pincode,
                'updatedby' => $this->session->userdata('user_id'),
                'updatedon' => date('Y-m-d H:i:s'),

            );

            $table = 'tb_carrier_prefer_rule';
            $whr = array(
                'id' => $id
            );
            $result = $this->common->updatetbledata($table, $res, $whr);

            log_error(
                UNIQLO_LOG_PREFIX . "Customerpreferences updatepreferencerule outbound data: " . json_encode($result)
            );

            echo json_encode($result);
        }
    }

    public function view($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Customerpreferences|view inbound data: " . $id);

        $user_id = $this->session->userdata('user_id');
        $data['user_id'] = $user_id;
        $data['page_title'] = $this->lang->line('preferred_state');
        $data['sub_title'] = $this->lang->line('general_view');
        $where1 = array(
            'id' => $id
        );

        $table1 = "tb_carrier_prefer_rule";
        $edit_data = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_data'] = $edit_data;
        $data['vendor'] = $this->common->gettblrowdata(
            array('id' => $edit_data['carrier_id']),
            "id,name",
            "tb_vendors",
            0,
            0
        );

        log_error(
            UNIQLO_LOG_PREFIX .
            "Customerpreferences|view outbound data for customerpreferences/viewpincode: " . json_encode($data)
        );

        //$this->newtemplate->dashboard("customerpreferences/view", $data);
        $this->load->view("customerpreferences/view", $data);
    }

    public function delete($id)
    {
        $table = "tb_carrier_prefer_rule";
        $result = $this->Uniqlomodel->delete($id, $table);
        if ($result) {
            log_error(UNIQLO_LOG_PREFIX . "Customerpreferences|delete outbound data: 1");

            echo "1";
        } else {
            log_error(UNIQLO_LOG_PREFIX . "Customerpreferences|delete outbound data: 0");

            echo "0";
        }
    }


    public function checkduplicatedata()
    {
        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $whr = array();
        $where = array();
        /*if (isset($city) && $city != "") {
           $where['tc.city'] = $city;
       }
       if (isset($state) && $state != "") {
           $where['tc.state'] = $state;
       }*/
        if (isset($pincode) && $pincode != "") {
            $where['tc.pincode'] = $pincode;
        }
        if (isset($id) && $id != "") {
            $where['tc.id !='] = $id;
        }
        if (isset( $carrier_id) &&  $carrier_id != "") {

             $where['tc.carrier_id'] =  $carrier_id;
         }
		 $where['tc.status='] = 1;   
        $table = 'tb_carrier_prefer_rule';
        $result = $this->Uniqlomodel->checkdupdata($where, $whr, $table);

        log_error(UNIQLO_LOG_PREFIX . "Customerpreferences checkduplicatedata outbound data: " . count($result));

        echo count($result);
    }

    public function deleteById()
    {
        if($_SERVER['REQUEST_METHOD'] === 'POST') {
            $tableName = $this->input->post('table',TRUE);
            $idArray   = $this->input->post('deleteids',TRUE);
            $this->common->deleteStatus($idArray,$tableName);
        }
    }

}
