<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Customers extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        if (!$this->session->has_userdata('user_id')) {
            redirect('login');
        }
    }
    public function index()
    {
        $data['page_title']   = "Customers";
        $data['sub_title']    = "view";
        $data["table_search"] = $whr = "";
        $limit = 10;
        if ($_GET) {
            $data["table_search"] = $s = $_GET["table_search"];
            $whr = " AND (name like '%" . $s . "%' OR phone like '%" . $s . "%' OR email like '%" . $s . "%')";
        }
        $bindings = [];
        if(in_array($this->session->userdata('business_type'), ['Country Admin'])){
            $user = $this->session->userdata('user_id');
            $bindings[] = $user;
            $tot = "SELECT id,name,phone,location,email_id,status FROM tb_customers where user_id = ?";
        }else{
            if(!empty($this->session->userdata('country_user_ids'))){
                $bindings[] = $this->session->userdata('country_user_ids');
                $tot = "SELECT id,name,phone,location,email_id,status FROM tb_customers where user_id in ?";
            }else{
                $tot = "SELECT id,name,phone,location,email_id,status FROM tb_customers LIMIT 0";
            }
        }
        $total = $this->db->query($tot, $bindings)->num_rows();
        $val   = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        if ($val == "" || $val == null || $val == '0') {
            $val = 0;
        }
        $this->load->library('pagination');
        $config['base_url'] = base_url('customers/index');
        if (strlen($data["table_search"]) > 0) {
            $config['suffix'] = '?' . http_build_query(array("table_search" => $data["table_search"]), '', "&amp;");
        }
        $config['total_rows'] = $total;
        $config['per_page']   = $limit;
        $this->pagination->initialize($config);
        $data["links"] = $this->pagination->create_links();
        $val = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["custdata"] = $this->db->query("$tot limit $val,$limit");
        $this->settemplate->dashboard('customers/view', $data);
    }
    public function add($id = '')
    {
        $data['page_title'] = "Customers";
        $data["id"]         = $id;
        if ($id != '') {
            if (!$this->isIDExists($id)) {
                $this->session->set_flashdata('error', 'Invalid ID to edit Customer.');
                redirect('customers/index');
            }
            $data['sub_title'] = "edit";
            $data["custdata"]  = $this->db->where("id", $id)->get("tb_customers")->row();
        } else {
            $data['sub_title'] = "add";
        }
        $data['cmp_branch'] = $this->db->get_where("tb_branch_master", array("status" => 1));
        $this->settemplate->dashboard('customers/add', $data);
    }
    public function save($id = '')
    {
        $data             = $this->input->post();
        $data["user_id"]  = $this->session->userdata("user_id");
        $pwd              = $data['password'];
        $data['password'] = password_hash($pwd, PASSWORD_DEFAULT);
        if(isset($data['code'])){
            if($data['code'] == ""){
                $data['code'] = $data['phone'];
            }
        }
        if ($id == '') {
            $this->db->insert("tb_customers", $data);
        } else {
            $this->db->where("id", $id)->update("tb_customers", $data);
        }
        redirect('customers/index');
    }
    public function delete($id = '')
    {
        if ($id != '') {
            $tbl = "tb_customers";
            $whr = array('id'=>$id);
            $doc = $this->db->select("id")->get_where($tbl,$whr,1,0);
            if($doc->num_rows() > 0){
                $set = array('status'=>0);
                $whr = array('id'=>$id);
                $upd =  $this->db->where($whr)->update($tbl,$set);
            }
        } else {
            $this->session->set_flashdata('error', 'Invalid ID to delete Customer.');
        }
        redirect('customers/index');
    }
    public function active($id = '')
    {
        if ($id != '') {
            $tbl = "tb_customers";
            $whr = array('id'=>$id);
            $doc = $this->db->select("id")->get_where($tbl,$whr,1,0);
            if($doc->num_rows() > 0){
                $set = array('status'=>1);
                $whr = array('id'=>$id);
                $upd =  $this->db->where($whr)->update($tbl,$set);
            }
        } else {
            $this->session->set_flashdata('error', 'Invalid ID to delete Customer.');
        }
        redirect('customers/index');
    }
    public function isIDExists($id)
    {
        if ($this->db->where("id", $id)->get("tb_customers")->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function regenaratemp($id)
    {
        $data              = $this->db->select("name,phone,password")->where("id", $id)->get("tb_customers")->row_array();
        $params            = array();
        $pwd               = $data["password"];
        $pwd               = (($pwd));
        $params['mobile']  = $data["phone"];
        $params['module']  = "Customer Password Confirmation";
        $params['message'] = "Dear " . $data["name"] . ", Your " . $data["phone"] . " as LoginID and Password is " . $pwd . ", You can login into our RT TMS Shipment APP for more details";
        $params['user_id'] = $this->session->userdata("user_id");
        $this->load->library("sms");
        $res = $this->sms->send($params);
    }
}
