<?php defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('cabmodel');
        if (!checkUrlAccessForUser('DASHBOARD')) {
            redirect("Forbiddenaccess");
        }
    }

	public function index(): void
    {
		$this->livecabdetails();
	}

	public function livecabdetails(): void
    {
    	$data['page_title'] = $this->lang->line('dashboard_page_title');
		$data['sub_title'] = $this->lang->line('vehicles_live_track_details');
		$this->settemplate->dashboard("cabreports/livecabdetails",$data);
	}

	public function ajaxdashboard(): void
    {
        $this->load->library('livetrackservice');

        $this->livetrackservice
            ->setUserData([
                'userid' => $this->session->userdata('user_id'),
                'curtz' => $this->session->userdata("usr_tzone")['timezone']
            ]);

        $data = [
            "vehicles" => $this->livetrackservice->getLiveCabDetailsData(),
            "vshiftsdata" => $this->livetrackservice->getVshiftsData()
        ];

        echo $this->load->view("cabreports/livecabdetails2",$data,TRUE);
	}

	public function changestatus(): void
    {
		$trip_id=$_POST["trip_id"];
		$emp_id=$_POST["emp_id"];
		$status=$_POST["status"];
		$this->db->where(array("trip_id"=>$trip_id,"employee_id"=>$emp_id))->update("tb_trip_employee",array("status"=>$status,"absent_reason"=>"Updated by Transport Team"));
		$this->ajaxdashboard();
	}

	function ajax_shifttripdetails()
	{
		$shiftid =  isset($_POST['shiftid'])?$_POST['shiftid']:'';
		$tripid =  isset($_POST['tripid'])?$_POST['tripid']:'';
		$temp = array();
		$result['emplist'] = array();
		if($shiftid!="" && $tripid!=""){
			$trips = $this->db->query(
				"SELECT t.id AS tripid, t.vehicle_id, d.name, d.contact_num, s.stime, s.etime,
				s.splace, s.eplace, v.register_number
				FROM tb_trips AS t, tb_shifts AS s, tb_truck_drivers AS d, tb_shft_veh AS v
				WHERE t.driver_id = d.id AND s.id = t.shift_id AND v.shft_id = s.id AND s.id = ?
				AND t.id = ? AND t.status = 1 AND t.vehicle_id = v.vehicle_id AND v.status = 1
				ORDER BY v.id DESC
				LIMIT 1",
				[$shiftid, $tripid]
			);
			/*log_message("error","1".$this->db->last_query());*/
			$temp["employee"]=array();
			$temp["driver"]=$temp["time"]=$temp["trip"]="";
			$veh = "";
			if($trips->num_rows()>0){
				$t = $trips->row();
				$temp["vdriver"]= "<b>Driver : </b>".$t->name." - ".$t->contact_num;
				$temp["driver"]=$t->name." - ".$t->contact_num;
				$temp["trip"]=explode(",",$t->splace)[0]." - ".explode(",",$t->eplace)[0];
				$temp["vehicle"]="<a href='".base_url()."cab/track/".encryptIt($temp["driver"],$temp["trip"])."' target='_blank'>$t->register_number</a>";
				$veh = $t->register_number;
			}
			$emp = $this->db->query(
				"SELECT e.id, e.name, e.phone, e.pickup, e.drop, e.assoc_id, e.ship_type
				FROM tb_employee AS e, tb_shft_veh AS vh, tb_shft_veh_emp AS ve
				WHERE vh.shft_id = ? AND ve.shft_veh_id = vh.id AND e.id = ve.emp_id
				AND vh.status = 1 AND ve.status = 1 AND vh.register_number = ?
				ORDER BY ve.priority ASC",
				[$shiftid, $veh]
			);
			/*log_message("error","1".$this->db->last_query());*/
			if($emp->num_rows()>0){
				$temp["employee"] = array();
				foreach($emp->result() as $emps){
					$checkattend = $this->db->select("status")->get_where("tb_trip_employee",array("trip_id"=>$tripid,"employee_id"=>$emps->id),1,0);
					$pickdrop = $emps->pickup;
					if($emps->ship_type == 'D'){
						$pickdrop = $emps->drop;
					}
					if($checkattend->num_rows() > 0){
						if($checkattend->row()->status == "1"){
							$temp["employee"][]="<span style='color:black;'>".$pickdrop."<br/>".$emps->name." - (".$emps->phone.") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>".$emps->ship_type."</span> </span>";
						}else{
							$temp["employee"][]="<span style='color:red;'>".$pickdrop."<br/>".$emps->name." - (".$emps->phone.") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>".$emps->ship_type."</span> </span>";
						}
					}else{
						$temp["employee"][]="<span style='color:black;'>".$pickdrop."<br/>".$emps->name." - (".$emps->phone.") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>".$emps->ship_type."</span> </span>";
					}
				}
			}
		}
		$result['emplist'] = $temp;
		echo json_encode($result);
	}

	function ajax_shiftdetails()
	{
		$shiftid =  isset($_POST['shiftid'])?$_POST['shiftid']:'';
		$vehicle =  isset($_POST['tripid'])?$_POST['tripid']:'';
		$temp = array();
		$result['emplist'] = array();
		if($shiftid!="" && $vehicle !=""){
			$trips = $this->db->query(
				"SELECT d.name, d.contact_num, s.stime, s.etime, s.splace, s.eplace, v.register_number
				FROM tb_shifts AS s, tb_shft_veh AS v, tb_trucks_data AS t,
				tb_truck_drivers AS d, tbl_assigned_drivers AS a
				WHERE s.id = v.shft_id AND s.id = ? AND s.status = 1 AND t.register_number = v.register_number
				AND v.register_number = ? AND a.vehicle_id = t.id AND d.id = a.driver_id AND v.status = 1
				ORDER BY v.id DESC
				LIMIT 1",
				[$shiftid, $vehicle]
			);
			$temp["employee"]=array();
			$temp["driver"]=$temp["time"]=$temp["trip"]="";
			if($trips->num_rows()>0){
				$t = $trips->row();
				$temp["vdriver"]= "<b>Driver : </b>".$t->name." - ".$t->contact_num;
				$temp["driver"]=$t->name." - ".$t->contact_num;
				$temp["trip"]=explode(",",$t->splace)[0]." - ".explode(",",$t->eplace)[0];
				$temp["vehicle"]="<a href='".base_url()."cab/track/".encryptIt($temp["driver"],$temp["trip"])."' target='_blank'>$t->register_number</a>";
			}
			$emp = $this->db->query(
				"SELECT s.id, e.name, e.phone, e.pickup, e.drop, e.assoc_id, e.status, e.ship_type
				FROM tb_shifts AS s, tb_shft_veh AS sh, tb_shft_veh_emp AS ve, tb_employee AS e
				WHERE s.id = sh.shft_id AND sh.id = ve.shft_veh_id AND e.id = ve.emp_id
				AND s.status = 1 AND sh.register_number = ? AND s.id = ? AND ve.status = 1 AND sh.status = 1
				ORDER BY ve.priority ASC",
				[$vehicle, $shiftid]
			);
			if($emp->num_rows()>0){
				$temp["employee"] = array();
				foreach($emp->result() as $emps){
					$pickdrop = $emps->pickup;
					if($emps->ship_type == 'D'){
						$pickdrop = $emps->drop;
					}
					if($emps->status == "1"){
						$temp["employee"][]="<span style='color:black;'>".$pickdrop."<br/>".$emps->name." - (".$emps->phone.") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>".$emps->ship_type."</span> </span>";
					}else{
						$temp["employee"][]="<span style='color:red;'>".$pickdrop."<br/>".$emps->name." - (".$emps->phone.") <span style='border-radius: 15px;padding: 5px;border: 1px solid LightGreen;-moz-border-radius:15px;background-color: orange;'>".$emps->ship_type."</span> </span>";
					}
				}
			}
		}
		$result['emplist'] = $temp;
		echo json_encode($result);
	}

	public function zones()
	{
		$data["table_search"] = $whr = "";
		if ($_GET) {
			$data["table_search"] = $s = $_GET["table_search"];
			$escapedSearch = $this->db->escape_like_str($s);
			$whr = " AND (zone_name LIKE '%{$escapedSearch}%' OR splace LIKE '%{$escapedSearch}%' OR eplace LIKE '%{$escapedSearch}%') ";
		}
		$user = $this->session->userdata('user_id');
		$data['page_title'] = "Dashboard";
		$data['sub_title'] = "Zones";
		$data["zonedata"] = $this->db->query("SELECT * FROM tb_shift_zones WHERE user_id = ? {$whr}", [$user]);
		$this->settemplate->dashboard("zones/zonesview", $data);
	}

	public function zoneadd($id = null) {
		$user = $this->session->userdata('user_id');
		$data['page_title'] = "Dashboard";
		$data['sub_title'] = "Add Zone";
		$data["id"] = $id;
		if ($id == null) {
			$data["type"] = "add";
			if ($_POST) {
				$this->form_validation->set_rules('zone_name', 'Zone Name', 'trim|required|strip_tags');
				$this->form_validation->set_rules('splace', 'Start Position', 'trim|required|strip_tags');
				$this->form_validation->set_rules('eplace', 'End Position', 'trim|required|strip_tags');
				if ($this->form_validation->run() == FALSE) {
					$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
					$this->zoneadd('');
				} else {
					$post = $_POST;
					$whr=array("zone_name"=>$post['zone_name'],"user_id"=>$user);
					$chkexists = $this->cabmodel->getTableData("tb_shift_zones",$whr,"id");
					unset($post['submit']);
					if(count($chkexists) == 0){
						$post["user_id"] = $user;
						$post["createdon"]=$post["updatedon"]=date('Y-m-d H:i:s');
						$res = $this->db->insert("tb_shift_zones",$post);
						$post["id"] = $this->db->insert_id();
					}else{
						$post["updatedon"]=date('Y-m-d H:i:s');
						$id = $chkexists[0]['id'];
						$this->db->where("id", $id)->update("tb_shift_zones", $post);
					}
				}
				redirect("dashboard/zones");
			}
		} else {

			$data["type"] = "edit";
			$data["zone"] = $this->db->query("SELECT * FROM tb_shift_zones WHERE id = ?", [$id]);
			if ($data["zone"]->num_rows() == 0) {
				redirect("dashboard/zoneadd");
			}
			if ($_POST) {
			$this->form_validation->set_rules('zone_name', 'Zone Name', 'trim|required|strip_tags');
			$this->form_validation->set_rules('splace', 'Start Position', 'trim|required|strip_tags');
			$this->form_validation->set_rules('eplace', 'End Position', 'trim|required|strip_tags');
			$data["type"] = "add";
			if ($this->form_validation->run() == FALSE) {
				$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
				$this->zoneadd($id);
			} else {
				$post = $_POST;
				$chkexists = $this->cabmodel->getTableData("tb_shift_zones",$whr=array("zone_name"=>$post['zone_name'],"user_id"=>$user,"id <>"=>$id),"id");
				unset($post['submit']);
				if(count($chkexists) == 0){
					$post["updatedon"]=date('Y-m-d h:i:s');
					$post["user_id"] = $user;
					$this->db->where("id", $id)->update("tb_shift_zones", $post);
					redirect("dashboard/zones");
				}
			}
		}
	}
	$this->settemplate->dashboard("zones/add", $data);
}
	public function zonedelete($id = null) {
		if ($id == null) {
			redirect("dashboard/zones");
		} else {
			$chkstatus = $this->db->get_where("tb_shift_zones",array("id"=>$id),1,0);
			if($chkstatus->num_rows() >0){
				if($chkstatus->row()->status == 'Active'){
					$whr = array("status" => 'Inactive');
				}else{
					$whr = array("status" => 'Active');
				}
				$this->db->where("id", $id)->update("tb_shift_zones", $whr);
			}
			redirect("dashboard/zones");
		}
	}

	/*
	* @unused
	*/
	function updateShftVehs(){
		$user = $this->session->userdata('user_id');
		$this->db->query(
			"UPDATE tb_shft_veh AS h
			SET vehicle_id = (SELECT id
				FROM tb_trucks_data
				WHERE register_number = h.register_number AND user_id = ? AND status = 'Active'
				LIMIT 1)
			WHERE h.user_id = ? AND (h.vehicle_id = '' OR h.vehicle_id = 0 OR h.vehicle_id IS NULL)",
			[$user, $user]
		);
		echo "done";
	}
	function delayedTrips(){
		$user = $this->session->userdata('user_id');
		$data["page_title"]="Dashboard";
		$data["sub_title"]="Delayed Trips";
		$data["trips"] = $this->db->query(
			"SELECT h.id, d.register_number, LEFT(h.splace, 20) AS splace, LEFT(h.eplace, 20) AS eplace,
			h.startdate, p.stime, ROUND(TIMESTAMPDIFF(MINUTE, h.startdate, p.stime) / 60, 2) AS late,
			v.name, v.mobile
			FROM tb_trips AS p, tb_trip_summary AS s, tb_shifts AS h, tb_trucks_data AS d
			JOIN tb_vendor_vehicles AS vv ON vv.vehicle_id = d.id
			JOIN tb_vendors AS v ON v.id = vv.vendor_id
			WHERE p.id = s.trip_id AND p.shift_id = h.id AND p.status = 0
			AND s.user_id IN (?) AND DATE_FORMAT(s.end_time, '%H.%i') > h.etime
			AND p.trip_type != 2 AND p.vehicle_id = d.id AND s.ship_delay > 0",
			[$user]
		);
		$this->settemplate->dashboard("delayedTrips",$data);
	}
}
