<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
include 'DeliveryDocument.php';

use Mpdf\Mpdf;
use Mpdf\Output\Destination;

class DeliveryDocumentCron extends DeliveryDocument
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper("log_helper");
    }

    public function generateDocuments(): void
    {
        $orderIds = $this->DeliveryDocumentModel->getStopStatusOrderIds();
        if (empty($orderIds)) {
            return;
        }
        $OrdersDataByStopStatusIds = $this->DeliveryDocumentModel->getOrdersDataWithIds($orderIds);
        $customerIds = $this->DeliveryDocumentModel->getCustomersForEpodDocuments();
        if (!empty($customerIds)) {
            $epodOrdersIds = $this->DeliveryDocumentModel->getStopStatusOrderIdsByCustomerIds($customerIds);
            $ePODCustomerOrdersData = $this->DeliveryDocumentModel->getOrdersDataWithePODIds($epodOrdersIds);
            $allOrdersData = array_merge($OrdersDataByStopStatusIds, $ePODCustomerOrdersData);
            $OrdersDataWitUniqueId = array_unique(array_column($allOrdersData, 'id'));
            $ordersData = array_intersect_key($allOrdersData, $OrdersDataWitUniqueId);
            $finalOrderIds = [];
            if (!empty($ordersData)) {
                foreach ($ordersData as $orderId) {
                    $finalOrderIds[] = $orderId['id'];
                }
            }
            $orderIds = $finalOrderIds;
        } else {
            $ordersData =  $OrdersDataByStopStatusIds;
        }
        $ordersPartyNames = $this->DeliveryDocumentModel->getOrderPartyData(['Customer', 'Consignee', 'Shipper', 'Carrier'], 0, $orderIds);
        $shiftIds = array_unique(array_column($ordersData, 'shift_id'));
        $milestoneStatuses = $this->DeliveryDocumentModel->getMilestoneStatusesByShiftIds($shiftIds);
        $podUploadsWithDetails = $this->DeliveryDocumentModel->getPodUploadsWithDetailsByOrderIds($orderIds);
        $vehiclesData = $this->DeliveryDocumentModel->getVehicleData(0, $orderIds);
        $cargoDetails = $this->DeliveryDocumentModel->getCargoDetails(0, $orderIds);
        $transportCodes = array_unique(array_column($ordersData, 'transport_mode'));
        $transportModes = $this->DeliveryDocumentModel->getOrderTransportModeByCodes($transportCodes);
        $manifestIds = $this->DeliveryDocumentModel->getManifestIdByOrderIds($orderIds);
        $showCarrierCondition = $this->DeliveryDocumentModel->checkShowCarrierCondition($orderIds);
        $emailQueue = $uniqueBookingIds = [];
        foreach ($ordersData as $eachOrderData) {
            if (!in_array($eachOrderData['order_id'], $uniqueBookingIds)) {
                $uniqueBookingIds[] = $eachOrderData['order_id'];
                $emailIds = [];
                $showCarrier = false;
                if (isset($showCarrierCondition[$eachOrderData['id']]) && in_array(strtolower($showCarrierCondition[$eachOrderData['id']]), ['yes', 'y'])) {
                    $showCarrier = true;
                }
                if ($eachOrderData['customer_email_id'] != '') {
                    $emailIds[] = $eachOrderData['customer_email_id'];
                }
                if ($eachOrderData['branch_email_id'] != '') {
                    $emailIds[] = $eachOrderData['branch_email_id'];
                }
                if (!empty($emailIds)) {
                    $addresses = self::getAddress($eachOrderData);
                    $partyNames = $ordersPartyNames[$eachOrderData['id']] ?? [];
                    $carrierName = $partyNames['carrier'] ?? '';
                    $checkCustomer = $partyNames['Customer'] ?? "";
                    if ($checkCustomer === "") {
                        $customerDetails = $this->DeliveryDocumentModel->getOrderCustomerName($eachOrderData['id'], '')[$eachOrderData['order_id']];
                        $partyNames['Customer'] = $customerDetails['customerName'] ?? "";
                    }
                    $eachOrderMilestoneStatuses = $milestoneStatuses[$eachOrderData['id']] ?? [];
                    $customStatusesByCarrierName = [];
                    if ($carrierName != "" && !empty($eachOrderMilestoneStatuses)) {
                        $customStatusesByCarrierName = $this->statusremappingservice->getCustomStatusesByCarrierName($carrierName, $eachOrderData['company_code']);
                    }
                    $statuses = self::parseStatuses($eachOrderMilestoneStatuses, ($customStatusesByCarrierName));
                    $orderDetails = [
                        'orderData' => $eachOrderData,
                        'shipperAddress' => $addresses['pickup_address'],
                        'consigneeAddress' => $addresses['delivery_address'],
                        'epods' => $podUploadsWithDetails[$eachOrderData['id']] ?? [],
                        'partyNames' => $partyNames,
                        'vehicleData' => $vehiclesData[$eachOrderData['id']] ?? [],
                        'cargoDetails' => $cargoDetails[$eachOrderData['id']] ?? [],
                        'transportMode' => $transportModes[$eachOrderData['transport_mode']] ?? '',
                        'statuses' => $this->statusremappingservice->getCompanySpecificOrderStatuses($statuses ?? [], $eachOrderData['company_code']),
                        'timeZone' => $eachOrderData['cntry_timezone'],
                        'manifestId' => $manifestIds[$eachOrderData['id']] ?? '',
                        'showCarrier' => $showCarrier
                    ];
                    $getRegisterNumber = $vehiclesData[$eachOrderData['id']] ?? [];
                    $vehicleNumber = $getRegisterNumber['register_number'] ?? "";
                    $getEmailBodyData = $this->getEmailBody(
                        ['order_id' => $eachOrderData['order_id'],
                            'shipmentid' => $eachOrderData['shipmentid'],
                            'order_references' => $eachOrderData['order_references'],
                            'pickup_address' => $addresses['pickup_address'],
                            'delivery_address' => $addresses['delivery_address'],
                            'register_number' => $vehicleNumber,
                            'statuses' => $orderDetails['statuses'],
                            'company_code' => $eachOrderData['company_code']
                        ]);
                    $filename = self::getPdfFileLocation($orderDetails, $eachOrderData['order_id']);
                    $emailQueue[] = [
                        'order_id' => $eachOrderData['order_id'],
                        'file_name' => $filename,
                        'email_ids' => implode("????????", $emailIds),
                        'is_sent' => 0,
                        'is_email_body' => $getEmailBodyData['is_email_body'],
                        'email_body' => $getEmailBodyData['email_body']
                    ];
                }
            }
        }
        $existingRecords = $this->DeliveryDocumentModel->selectExistingRecords($uniqueBookingIds);
        $uniqueEmailQueue = [];
        if (!empty($existingRecords)) {
            foreach ($emailQueue as $eacEmailQueue) {
                if (!in_array($eacEmailQueue['order_id'], $existingRecords)) {
                    $uniqueEmailQueue[] = $eacEmailQueue;
                }
            }
            $emailQueue = $uniqueEmailQueue;
        }
        if (!empty($emailQueue)) {
            $this->db->insert_batch('delivery_documents_email_queue', $emailQueue);
        }
    }

    private function getPdfFileLocation(array $orderData, string $bookingId): string
    {
        $pdf = new Mpdf([
            'tempDir' => FCPATH . 'assets/tmp',
            'default_font_size' => 8,
            'format' => 'A4-L',
            'autoScriptToLang' => true,
            'autoLangToFont' => true
        ]);
        $pdf->WriteHTML($this->load->view('deliverydocument/deliverydocument', $orderData, true));
        $filename = 'Delivery_Document_' . $bookingId . '.pdf';
        $filepath = "./assets/tmp/" . $filename;
        $pdf->Output($filepath, Destination::FILE);
        return $filename;
    }

    private function insertOrUpdate(array $emailQueue)
    {
        $getAllLegIds = $this->common->gettbldata(['shift_leg_id'=>$shiftLegId,'status'=>'1'],"id","delivery_documents_email_queue",0,0);
    }

    public function getEmailBody(array $data): array
    {
        $companyCode = $data['company_code'];
        if ($companyCode == 'SGKN') {
            $emailBody = "Dear Value Customer,<br>
                        Delivery Document for Booking ID: " . $data['order_id'] . " and KN Trip No: " . $data['shipmentid'] . "<br>
                        Order reference No: " . $data['order_references'] . "     Vehicle No: " . $data['register_number'] . "; <br>
                       <br>
                        <div>
                            <table>
                                <tr style='border: 1px solid black'>
                                    <th style='border: 1px solid black'>From</th>
                                    <th style='border: 1px solid black'>To</th>
                                </tr>
                                <tr>
                                    <td style='border: 1px solid black'>" . $data['pickup_address'] . "</td>
                                    <td style='border: 1px solid black'>" . $data['delivery_address'] . "</td>
                                </tr>
                            </table>
                        </div>
                        <br>
                        <div>
                            <table style='border: 1px solid black'>
                                <tr style='border: 1px solid black'>
                                    <th style='border: 1px solid black'>Status Code</th>
                                    <th style='border: 1px solid black'>Event Description</th>
                                    <th style='border: 1px solid black'>Date</th>
                                    <th style='border: 1px solid black'></th>
                                    <th style='border: 1px solid black'>General Location</th>
                                </tr>";
            foreach ($data['statuses'] as $status) {
                $emailBody .= "
                                <tr style='border: 1px solid black'>
                                    <td style='border: 1px solid black'>" . $status['status_code'] . "</td>
                                    <td style='border: 1px solid black'>" . $status['status_name'] . "</td>
                                    <td style='border: 1px solid black'>" . date("d M Y H:i", strtotime($status['date'])) . "</td>
                                    <td style='border: 1px solid black'> </td>
                                    <td style='border: 1px solid black'>" . $status['location'] . "</td>
                                </tr>";
            }
            $emailBody .= "</table>
                            </div>";

            $isEmailBody = 1;
        } else {
            $emailBody = "";
            $isEmailBody = 0;
        }
        return ['email_body' => $emailBody,
            'is_email_body' => $isEmailBody];

    }
}
