<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class DeliveryDocumentEmailCron extends CI_Controller
{
    private const THKN_COMPANY_CODE = "THKN";
    private const VNKN_COMPANY_CODE = "VNKN";
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['DeliveryDocumentModel']);
        $this->load->library(['PhpMailerLibrary']);
    }

    public function index(): void
    {
        $emailStatuses = $poAndDqReferences = [];
        $queuedRecords = $this->DeliveryDocumentModel->getQueuedRecordsForEmail();
        foreach ($queuedRecords as $eachRow) {
            $bookingIds[] = $eachRow['order_id'];
        }
        if (!empty($bookingIds ?? [])) {
            $poAndDqReferences = $this->DeliveryDocumentModel->getReferencesByBookingIds($bookingIds);
            $customerDetails = $this->DeliveryDocumentModel->getCustomerCodeByBookingIds($bookingIds);
        }
        foreach ($queuedRecords as $eachRecord) {
            $emailIds = explode("????????", $eachRecord['email_ids']);
            if (!empty($emailIds)) {
                $emailStatuses[] = self::sendDeliveryDocumentMail($eachRecord['file_name'], $eachRecord['order_id'], $emailIds, ['poAndDqReferences' => $poAndDqReferences, 'customerDetails' => $customerDetails ?? []], $eachRecord['is_email_body'], $eachRecord['email_body'] ?? "");
            }
        }
        if (!empty($emailStatuses)) {
            $this->db->update_batch('delivery_documents_email_queue', $emailStatuses, 'order_id');
        }
    }

    private function sendDeliveryDocumentMail(string $filename, string $bookingId, array $mailIds, array $additionalData, int $isEmailBody, string $emailBody): array
    {
        $emailStatus = [
            'order_id' => $bookingId,
            'file_name' => $filename,
            'is_sent' => 0,
            'is_failed' => 0,
            'status_message' => null,
            'is_email_body' => $isEmailBody,
            'email_body' => $emailBody
        ];
        $poAndDqReferences = $additionalData['poAndDqReferences'];
        $customerDetails = $additionalData['customerDetails'];
        $customerCode = $customerDetails[$bookingId]['customerCode'] ?? "";
        $references = $poAndDqReferences[$bookingId]['reference'] ?? '';
        $companyCode = $poAndDqReferences[$bookingId]['companyCode'] ?? '';
        $branchCode = $poAndDqReferences[$bookingId]['branchCode'] ?? '';
        if (checkAccessConditions('SUBJECT_WITH_CUSTOMER_NAME', $companyCode)) {
            $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
            $subject = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
        } elseif (in_array($companyCode, [SELF::THKN_COMPANY_CODE,SELF::VNKN_COMPANY_CODE])) {
            $subject = "Kuehne + Nagel Delivery Document - " . $bookingId . " " . $references;
        } else {
            $subject = "Delivery Document - " . $bookingId . " " . $references;
        }
        if ($isEmailBody == 1) {
            $message = $emailBody . "<br><br>";
            $message .= "<p style='color:red;'>This is an auto email and please do not reply</p>";
            $message .= "Thank you for using Kuehne + Nagel Road Logistics.<br><br><br><br>";
            $message .= "Best Regards,<br>";
            $message .= "Kuehne + Nagel Road Logistics.";
         } elseif ($companyCode === SELF::THKN_COMPANY_CODE) {
            $message = "Dear Value Customer,";
            $message .= "<p style='color:red;'>Please do not reply this email.</p>";
            $message .= "Your shipment [Delivery Document of " . $bookingId . "] has been delivered by Kuehne + Nagel Road Logistics.";
            $message .= "For more details, please click on attachment or reach out to our control tower staff at <u style='cursor:pointer;'>knbkk.svkonekt@kuehne-nagel.com</u>.<br><br>";
            $message .= "Thank you for using Kuehne + Nagel Road Logistics.<br><br><br><br>";
            $message .= "Best Regards,<br>";
            $message .= "Kuehne + Nagel Road Logistics.";
        } elseif ( $companyCode === SELF::VNKN_COMPANY_CODE ) {
            $message = "Dear Value Customer,";
            $message .= "<p style='color:red;'>Please do not reply this email.</p>";
            $message .= "Your shipment [Delivery Document of " . $bookingId . "] has been delivered by Kuehne + Nagel Road Logistics Vietnam.";
            $message .= "For more details, please click on attachment or reach out to our Road Logistics Customer Care Team at <u style='cursor:pointer;'>knsgn.road.customercare@kuehne-nagel.com</u>.<br><br>";
            $message .= "Thank you for using Kuehne + Nagel Road Logistics Vietnam.<br><br><br><br>";
            $message .= "Best Regards,<br>";
            $message .= "Kuehne + Nagel Road Logistics Vietnam.";
        } else {
            $message = "Hi Team,<br>";
            $message .= "Attached is the Delivery Document of " . $bookingId . "<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
        }
        $attachmentPath = sprintf('%s/assets/tmp/%s', FCPATH, $filename);
        $ccMailId = isset($mailIds[1]) ? [$mailIds[1]] : [];
        if ($companyCode === 'PHKN') {
            $ccMailId = array_merge($ccMailId, [
                'm.sivakumar@kuehne-nagel.com',
                'joel.padua@kuehne-nagel.com',
                'florylie-joy.gumboc@kuehne-nagel.com',
                'angelie.omes@kuehne-nagel.com',
            ]);
            if (checkAccessConditions('RELATED_2_SENDING_MAIL_TOKNIDS_FOR_POD', $customerCode)) {
                $bccMailIds = ['sol.ignacio@kuehne-nagel.com'];
                if ($branchCode == "PHCEB") {
                    $ccMailId = array_merge($ccMailId, [
                        'yvonne.he@Kuehne-Nagel.com',
                        'angela.gimoros@kuehne-nagel.com',
                    ]);
                }
                //log_message("error", "DeliveryDocumentEmailCron - bcc mail Ids - " . json_encode($bccMailIds));
                //log_message("error", "DeliveryDocumentEmailCron - cc mail Ids - " . json_encode($ccMailId));
            }
        }
        try {
            if ($this->phpmailerlibrary->sendmail($mailIds[0], $subject, $message, $ccMailId, [$attachmentPath], $bccMailIds ?? [])) {
                $emailStatus['is_sent'] = 1;
            } else {
                $emailStatus['status_message'] = "email failed for " . $subject;
                $emailStatus['is_failed'] = 1;
            }
        } catch (Exception $e) {
            log_message("error", "delivery document email failed - " . $e->getMessage());
        }
        return $emailStatus;
    }
}
