<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Department extends CI_Controller {

    public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_id') == ''){
			redirect('login');
        }
		$this->load->library('form_validation');
        $this->load->model('common');
        if (!checkUrlAccessForUser('DEPARTMENT')) {
            redirect("Forbiddenaccess");
        }
	}

    public function index()	{
		$data['page_title'] = $this->lang->line('department');
        $data['sub_title'] = $this->lang->line('department');
        //$where = array('status'=>1);
        $where = array();
        if($this->input->post('company_code')){
            $where['company_code'] = $this->input->post('company_code');
        }
        if($this->input->post('branch_code')){
            $where['branch_code'] = $this->input->post('branch_code');
        }
        if($this->input->post('department_code')){
            $where['department_code'] = $this->input->post('department_code');
        }
        $data['departments'] = $this->common->gettbldata($where,'*','tb_department_master',0,0);
		$this->newtemplate->dashboard("department/index", $data);
    }

    public function checkBranchCode($branch_code){
        if(empty($branch_code)){
            $this->form_validation->set_message('checkBranchCode','Branch Code  Required');
            return FALSE;
        } else {
            $where = array('branch_code'=>$branch_code);
            $branch = $this->common->gettblrowdata($where,'branch_code','tb_branch_master',0,0);
            if(empty($branch)){
                $this->form_validation->set_message('checkBranchCode',"This Branch Code Not Existed");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function checkCompanyCode($company_code){
        if(empty($company_code)){
            $this->form_validation->set_message('checkCompanyCode','Company Code  Required');
            return FALSE;
        } else {
            $where = array('company_code'=>$company_code);
            $company_code = $this->common->gettblrowdata($where,'company_code','tb_company_master',0,0);
            if(empty($company_code)){
                $this->form_validation->set_message('checkCompanyCode',"Company Code not exist");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function checkDepartmentCode($department_code){
        if(empty($department_code)){
            $this->form_validation->set_message('checkDepartmentCode','Department Code  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('department_code'=>$department_code,'company_code'=>$this->input->post('company_code'));
            if($id){
                $where['id !='] = $id;
            }
            $department = $this->common->gettblrowdata($where,'department_code','tb_department_master',0,0);
            if(empty($department)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkDepartmentCode',"Already This Department Code Existed");
                return FALSE;
            }
        }
    }

    public function add()   {
        $data['page_title'] = $this->lang->line('department');
        $data['sub_title'] = $this->lang->line('department');
		$company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        if(!empty($post)){
			
            $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
            $this->form_validation->set_rules('department_code', 'Department Code', 'required|callback_checkDepartmentCode');
            if ($this->form_validation->run() == false) {
                $data['error']['company_code'] = form_error('company_code');
                $data['error']['department_code'] = form_error('department_code');
                $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->newtemplate->dashboard('department/add', $data);
            } else {
                $array['company_code'] = $this->input->post('company_code');
                $array['branch_code'] = $this->input->post('branch_code');
                $array['department_code'] = $this->input->post('department_code');
                $array['department_name'] = $this->input->post('department_name');
                $array['description'] = $this->input->post('description');
                $array['status'] = $this->input->post('status');
                $array['updatedon'] = date('Y-m-d H:i:s');
                $array['createdon'] = date('Y-m-d H:i:s');
                $this->common->insertTableData('tb_department_master',$array);
                redirect('department');
            }
        } else {
            $this->newtemplate->dashboard('department/add', $data);
        }
    }

    public function edit($id) {
        $data['page_title'] = $this->lang->line('department');
        $data['sub_title'] = $this->lang->line('department');
        $data['department'] = $this->common->gettblrowdata(array('id'=>$id),'id,status,company_code,branch_code,department_code,department_name,description','tb_department_master',0,0);
		$post = array();
        $post = $this->input->post(NULL,TRUE);
        if(isset($data['department']['id'])) {
            if(!empty($post)){

                $this->form_validation->set_rules('company_code', 'Company Code', 'required|callback_checkCompanyCode');
				$this->form_validation->set_rules('department_code', 'Department Code', 'required|callback_checkDepartmentCode');
                if ($this->form_validation->run() == false) {
                    $data['error']['company_code'] = form_error('company_code');
                    $data['error']['department_code'] = form_error('department_code');
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                    $this->newtemplate->dashboard('department/add', $data);
                } else {
                    $array['company_code'] = $this->input->post('company_code');
                    $array['branch_code'] = $this->input->post('branch_code');
                    $array['department_code'] = $this->input->post('department_code');
                    $array['department_name'] = $this->input->post('department_name');
                    $array['description'] = $this->input->post('description');
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $array['status'] = $this->input->post('status');
                    $this->common->updatetbledata('tb_department_master',$array,array('id'=>$id));
                    redirect('department');
                }
            } else {
                $this->newtemplate->dashboard('department/edit', $data);
            }
        } else {
            show_error('The Department you are trying to Edit does not exist.');
        }
    }

    public function deletedepartment($id){
		if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(array('id'=>$id),'id','tb_department_master',0,0);
			if($chk){
				$upd = $this->common->updatetbledata('tb_department_master',array('status'=>0),array('id'=>$id));
				if($upd){
					echo "1";
				}else{
					echo "0";
				}
			}else{
				echo "0";
			}
		}
    }

    public function view($id){
        $data['page_title'] = $this->lang->line('department');
        $data['sub_title'] = $this->lang->line('department');
        $data['department'] = $this->common->gettblrowdata(array('id'=>$id),'id,status,company_code,branch_code,department_code,department_name,description','tb_department_master',0,0);
        $this->newtemplate->dashboard('department/view', $data);
    }

}

