<?php defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";
class Driver extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id')) {
        } else {
            redirect("login");
        }
        $this->load->library("pagination");
        $this->load->library('sms');
        $this->load->model('common');
        $this->load->model('user_model');
        if (! checkUrlAccessForUser('DRIVER')) {
            redirect("Forbiddenaccess");
        }
    }
    public function index($id = null)
    {

        if ($id != "") {
            $this->driverlist($id);
        } else {
            $this->driverlist();
        }
    }
    
    public function driverlist($id = null)
    {
        $user_id          = $this->session->userdata('user_id');
        $escapedUserId    = $this->db->escape($user_id);
        $company_code     = $this->session->userdata('company_code');
        $permission       = checkuserpermissions();
        $user_role_id     = (int) $this->session->userdata('user_role_id');
        $where            = $where2            = $where3            = '';
        $excel_uploaddata = $driverlist = [];
        $children         = [];
        $list_type        = 0;

        if ($id == "01") {
            $filedata         = @file_get_contents("assets/ordertemplate/driverexceldata.txt");
            $excel_uploaddata = @json_decode($filedata);

            if (! empty($excel_uploaddata)) {
                $list_type = 1;
                @file_put_contents("assets/ordertemplate/driverexceldata.txt", "");
                addordertologs($filedata);
            }
        }

        $vehicle_id              = "";
        $cidBasedVehiclesDrivers = checkAccessConditions('CID_BASED_VEHICLES_DRIVERS', $company_code);
        if ($cidBasedVehiclesDrivers) {
            $vendorsIds = [];
            if ($user_role_id === 3) {
                $userId = $this->session->userdata('id');
                $vendor = $this->db->query("SELECT code FROM tb_vendors WHERE id = ? AND status=?", [$userId, 1]);
                if ($vendor->num_rows() > 0) {
                    $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE code = ? AND company_code = ? AND status=?", [$vendor->row()->code, $company_code, 1]);
                }
            } else {
                $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE company_code = ? AND status=?", [$company_code, 1]);
            }
            if ($vendorsList->num_rows() > 0) {
                $vendorsIds = array_column($vendorsList->result_array(), 'id');
                if ($vendorsIds) {
                    $where .= " AND v.id  IN (" . implode(',', $vendorsIds) . ")";
                }
            }
        } elseif (in_array("drivers", $permission)) {
            $escapedCompanyCode = $this->db->escape($company_code);
            $where .= " AND ttd.company_code = {$escapedCompanyCode} ";
        } elseif ($this->session->userdata("business_type") === "Carrier") {
            $id        = $this->session->userdata("id");
            $escapedId = $this->db->escape($id);

            $vendor          = $this->db->query("select id, name, code, parent_id from tb_vendors where id = {$escapedId} and status=1");
            $carrierParentId = $vendor->row_array()['parent_id'];

            if (! is_null($carrierParentId)) {
                $where .= " AND ttd.vendor_id = {$escapedId} ";
                $where3 = " AND ttd.vendor_id = {$escapedId} ";
            } else {
                $this->load->model('Vendors');
                $children  = $this->Vendors->getChildren($id);
                $vendorIds = implode(', ', $children);

                $where .= " AND ttd.vendor_id IN ( {$vendorIds} ) ";
                $where3 = " AND ttd.vendor_id IN ( {$vendorIds} ) ";
            }
            $where .= " OR (ttd.vendor_id = 0 AND ttd.user_id = {$escapedUserId} )";
        } else {
            $escapedUserId = $this->db->escape($user_id);
            if (checkAccessConditions('COMPANY_CODE_WISE_GROUP_MASTERS', $company_code)) {
                $where .= " AND (ttd.company_code = '" . $this->session->userdata("company_code") . "' OR `ttd`.`user_id` IN (SELECT u.id FROM tb_users u WHERE u.company_indv_name = '" . $this->session->userdata("company_code") . "' AND u.status='Active'))";
            } else {
                $where .= " AND ttd.user_id = {$escapedUserId} ";
            }
        }

        if ($cidBasedVehiclesDrivers) {
            if ($user_role_id === 2) {
                $where .= " OR (ttd.vendor_id = 0 AND ttd.user_id = {$escapedUserId} )";
            } elseif ($this->session->userdata("business_type") == "Carrier") {
                $id          = $this->session->userdata("id");
                $escapedId   = $this->db->escape($id);
                $carrierCode = $this->session->userdata('carrier_code');
                if (checkAccessConditions('CARRIER_CID_BASED_VEHICLES_DRIVERS_LIST', $carrierCode)) {
                    $where .= " AND ttd.vendor_id = {$escapedId}";
                } else {
                    $where .= " AND ttd.vendor_id = {$escapedId} OR (ttd.vendor_id = 0 AND ttd.user_id = {$escapedUserId} )";
                }
            }
        } elseif ($this->session->userdata("business_type") == "Carrier" && empty($children)) {
            $id        = $this->session->userdata("id");
            $escapedId = $this->db->escape($id);
            $where .= " AND ttd.vendor_id = {$escapedId} OR (ttd.vendor_id = 0 AND ttd.user_id = {$escapedUserId} AND ttd.status = 'Active')";
            $where3 = " AND ttd.vendor_id = {$escapedId} ";
        }

        if ($_POST) {
            if (! empty($this->input->post('driver_name', true))) {
                $escapedDriverName = $this->db->escape_like_str($this->input->post('driver_name', true));
                $where .= " AND ttd.name LIKE '%{$escapedDriverName}%' ";
            }
            if (! empty($this->input->post('vehcilenumber', true))) {
                $vehicle_id = $this->input->post('vehcilenumber', true);
            }
            if (! empty($this->input->post('carrier_name', true))) {
                $escapedCarrierName = $this->db->escape_like_str($this->input->post('carrier_name', true));
                $where2 .= " AND v.name LIKE '%{$escapedCarrierName}%' ";
            }
        }

        if ($vehicle_id != "") {
            $escapedCompanyCode = $this->db->escape_like_str($company_code);

            $driversdata = $this->db->query(
                "SELECT ttd.id, ttd.name, ttd.vendor_id, ttd.age,
				    ttd.contact_num, ttd.driving_since, ttd.track_type, ttd.status, v.name as vendor_name
				FROM tb_vehicles_drivers AS tvd
                    LEFT JOIN tb_truck_drivers AS ttd ON ttd.id = tvd.driver_id
                    LEFT JOIN tb_vendors v ON v.id = ttd.vendor_id
                    LEFT JOIN tb_trucks_data AS td ON tvd.vehicle_id = td.id
				WHERE td.register_number = ? AND ttd.company_code LIKE ? {$where3} {$where2}
				  AND ttd.status = 'Active' AND td.status = 1 AND tvd.status = 1
				ORDER BY ttd.id DESC",
                [$vehicle_id, "%{$escapedCompanyCode}%"]
            );
        } else {
            $driversdata = $this->db->query(
                "SELECT ttd.id, ttd.name, IF(tvd.status IS NULL, 0, ttd.vendor_id) as vendor_id, ttd.age,
                    ttd.contact_num, ttd.driving_since, ttd.track_type, ttd.status, IF(tvd.status IS NULL AND ttd.vendor_id IS NULL, '', v.name) as vendor_name
                FROM tb_truck_drivers AS ttd
                    LEFT JOIN tb_vehicles_drivers AS tvd ON ttd.id = tvd.driver_id AND tvd.status = 1
                    LEFT JOIN tb_vendors v ON v.id = ttd.vendor_id
                    LEFT JOIN tb_trucks_data AS td ON tvd.vehicle_id = td.id AND td.status = 1
                WHERE ttd.status = 'Active' {$where} {$where2}
                GROUP BY ttd.id
                ORDER BY ttd.id DESC"
            );
        }
        $drivers = $driversdata ? $driversdata->result_array() : [];

        foreach ($drivers as $row) {
            $driverlist[] = [
                "id"            => $row['id'],
                "name"          => $row['name'],
                "carrier"       => $row['vendor_name'],
                "age"           => $row['age'],
                "contact_num"   => $row['contact_num'],
                "driving_since" => $row['driving_since'],
                "track_type"    => $row['track_type'],
                "status"        => $row['status'],
            ];
        }

        $data["drivers"]          = $driverlist;
        $data["page_title"]       = $this->lang->line('drivers');
        $data["page_sub"]         = $this->lang->line('view_driver');
        $data['list_type']        = $list_type;
        $data['excel_uploaddata'] = $excel_uploaddata;

        $this->newtemplate->dashboard('driver/view', $data);
    }

    public function add()
    {
        $company_code         = $this->session->userdata('company_code');
        $branch_code          = $this->session->userdata('branch_code');
        $user_id              = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code']  = $branch_code;
        $data['user_id']      = $user_id;
        $data["page_title"]   = $this->lang->line('drivers');
        $data["page_sub"]     = $this->lang->line('add_driver');
        $cun_code             = $this->session->userdata("usr_tzone")['country'];
        $where                = ["user_id" => $user_id, "company_code" => $company_code, "branch_code" => $branch_code, "country_code" => $cun_code];
        $table                = "tb_document_types";
        $add_type             = $this->common->gettbldata($where, 'type_name', $table, 0, 0);
        $data["add_proof"]    = $add_type;
        $this->load->view('driver/add', $data);
    }
    public function edit($id)
    {
        $company_code       = $this->session->userdata('company_code');
        $branch_code        = $this->session->userdata('branch_code');
        $user_id            = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('drivers');
        $data["page_sub"]   = $this->lang->line('edit_driver');
        $data["driver"]     = $this->db->where(["id" => $id])->get("tb_truck_drivers");
        $cun_code           = $this->session->userdata("usr_tzone")['country'];
        $where              = ["user_id" => $user_id, "company_code" => $company_code, "branch_code" => $branch_code, "country_code" => $cun_code];
        $table              = "tb_document_types";
        $add_type           = $this->common->gettbldata($where, 'type_name', $table, 0, 0);
        $data["add_proof"]  = $add_type;
        if ($data["driver"]->num_rows() > 0) {
            $data["driver"] = $data["driver"]->row();
            $this->load->view('driver/edit', $data);
        } else {
            redirect('driver');
        }
    }

    public function check_driver_mobile(string $mobile): bool
    {
        $post    = $this->input->post(null, true);
        $rowId   = $post['id'] ?? 0;
        $numRows = $this->user_model->checkDriverMobileExistsOrNot(['number' => $mobile, 'id' => $rowId]);
        if ($numRows > 0) {
            $this->form_validation->set_message('check_driver_mobile', 'Mobile Number is already exists to another driver!');
            return false;
        }
        return true;
    }

    public function update($id)
    {
        $data["page_title"] = $this->lang->line('drivers');
        $data["page_sub"]   = $this->lang->line('edit_driver');
        $user_id            = $this->session->userdata("user_id");
        $data               = $this->input->post(null, true);
        $this->form_validation->set_rules('contact_num', 'Contact Number', 'required|min_length[6]|callback_check_driver_mobile');
        if ($this->form_validation->run() == false) {
            $this->edit($id);
        } else {
            if ($id != "" && $user_id != "") {
                unset($data["submit"]);
                unset($data["save"]);
                unset($data["con_password"]);

                if (isset($data['driving_since'])) {
                    if ($data['driving_since'] == "") {
                        $data['driving_since'] = 0;
                    }
                }
                if (isset($data['age'])) {
                    if ($data['age'] == "") {
                        $data['age'] = 40;
                    }
                }
                $data["updatedon"] = date("Y-m-d H:i:s");
                $trktype           = 0;
                $track_subscribe   = "";
                $chkexists         = $this->db->select("track_type,track_subscribe")->get_where("tb_truck_drivers", ["id" => $id], 1, 0);
                if ($chkexists->num_rows() > 0) {
                    $trktype         = $chkexists->row()->track_type;
                    $track_subscribe = $chkexists->row()->track_subscribe;
                }
                $data["user_id"] = $data["createdby"] = $this->session->userdata("user_id");
                if ($this->session->userdata("business_type") == "Carrier") {
                    $vid               = $this->session->userdata("id");
                    $data["vendor_id"] = $vid;
                }
                $pwd              = $data["password"];
                $data["password"] = password_hash($pwd, PASSWORD_DEFAULT);
                if (isset($data['id'])) {
                    unset($data['id']);
                }
                $upd = $this->db->where(["id" => $id])->update("tb_truck_drivers", $data);
                /*check driver track type*/
                if (isset($data['track_type'])) {
                    if ($trktype == "0") {
                        if ($data['track_type'] == "1" && $data['contact_num'] != "") {
                            $ttype['mobile']    = $data['contact_num'];
                            $ttype['vendor_id'] = $data['track_vendor'];
                            $ttype['curtz']     = $this->session->userdata("usr_tzone")['timezone'];
                            $tracksubscribe     = $this->getdrivertrackactivate($ttype);
                        }
                    } else {
                        if ($data['track_type'] == "1" && $data['contact_num'] != "" && $track_subscribe == "") {
                            $ttype['mobile']    = $data['contact_num'];
                            $ttype['vendor_id'] = $data['track_vendor'];
                            $ttype['curtz']     = $this->session->userdata("usr_tzone")['timezone'];
                            $tracksubscribe     = $this->getdrivertrackactivate($ttype);
                        }
                    }
                }
            }
            redirect('driver');
        }
    }
    public function view($id)
    {
        $data["page_title"] = $this->lang->line('drivers');
        $data["page_sub"]   = $this->lang->line('edit_driver');
        $data["driver"]     = $this->db->where(["id" => $id])->get("tb_truck_drivers");
        $data["driver"]     = $data["driver"]->row();
        $this->load->view('driver/single_view', $data);
    }
    public function save()
    {
        $post = $this->input->post(null, true);
        unset($post['save']);
        $data = $post;
        unset($data["con_password"]);
        $this->form_validation->set_rules('contact_num', 'Contact Number', 'required|min_length[6]|callback_checkmobile');
        if ($this->form_validation->run() === false) {
            $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
            $this->add();
        } else {
            $contactNum = (string) $this->input->post('contact_num', true);
            $checkExistingDriver = $this->common->gettblrowdata(['contact_num' => $contactNum], 'id', 'tb_truck_drivers', 1, 0);
            if (! empty($checkExistingDriver)) {
                $this->add();
            }
            unset($data["submit"]);
            $user_id = $this->session->userdata("user_id");
            if ($user_id != "") {
                $data["createdon"] = date("Y-m-d H:i:s");
                $pwd               = $data['password'];
                $data["password"]  = password_hash($pwd, PASSWORD_DEFAULT);
                $data["user_id"]   = $data["createdby"]   = $data["updatedby"]   = $this->session->userdata("user_id");
                if ($this->session->userdata("business_type") == "Carrier") {
                    $id                = $this->session->userdata("id");
                    $data["vendor_id"] = $data["updatedby"] = $id;
                }
                if (isset($data['driving_since'])) {
                    if ($data['driving_since'] == "") {
                        $data['driving_since'] = 0;
                    }
                }
                if (isset($data['age'])) {
                    if ($data['age'] == "") {
                        $data['age'] = 40;
                    }
                }
                $this->db->insert("tb_truck_drivers", $data);

                /*check driver track type*/
                if (isset($data['track_type'])) {
                    if ($data['track_type'] == "1" && $data['contact_num'] != "") {
                        $ttype['mobile']    = $data['contact_num'];
                        $ttype['vendor_id'] = $data['track_vendor'];
                        $ttype['curtz']     = $this->session->userdata("usr_tzone")['timezone'];
                        $tracksubscribe     = $this->getdrivertrackactivate($ttype);
                    }
                }
                $params            = [];
                $params['mobile']  = $data["contact_num"];
                $params['module']  = "Driver Account Confirmation";
                $params['message'] = "Dear " . $data["name"] . ", You have been added as a Driver with " . $data["contact_num"] . " as LoginID and Password is " . $pwd . " You can login into our svkonekt LMV APP for more details";
                $params['user_id'] = $this->session->userdata("user_id");
                $this->sms->send($params);

                redirect('driver');

            }
        }
    }

    public function getdrivertrackactivate($sim)
    {
        $status = "FAIL";
        if ($sim['mobile'] > 0) {
            $apiqry = $this->db->query(
                "SELECT v.authkey, a.apiurl, a.requesttype, a.requestdata, a.response
                FROM tb_tracking_vendors AS v, tb_vendor_apis AS a
                WHERE v.id = a.vendor_id AND v.id = ? AND a.apiname = 'Subscribe' AND a.status = 1
                LIMIT 1",
                [$sim['vendor_id']]
            );
            if ($apiqry->num_rows() > 0) {
                $chk = $this->db->select("id,track_subscribe")->get_where("tb_truck_drivers", ["contact_num" => $sim['mobile'], "track_vendor" => $sim['vendor_id']], 1, 0);
                if ($chk->num_rows() > 0) {
                    $sts = $chk->row()->track_subscribe;
                    $did = $chk->row()->id;
                    if ($sts == "PENDING" || $sts == "") {
                        $post['authkey']   = $apiqry->row()->authkey;
                        $post['url']       = $apiqry->row()->apiurl;
                        $post['reqtype']   = $apiqry->row()->requesttype;
                        $post['data']      = ["phoneNumber" => $sim['mobile']];
                        $getdriverlocation = getdriverlocationbysms($post);
                        if (! empty($getdriverlocation)) {
                            if ($getdriverlocation['success'] == "true") {
                                if (! empty($getdriverlocation['data'])) {
                                    $cst    = isset($getdriverlocation['data']['status']) ? $getdriverlocation['data']['status'] : "";
                                    $upd    = $this->db->where(["id" => $did])->update("tb_truck_drivers", ["track_subscribe" => $cst]);
                                    $status = $cst;
                                }
                            }
                        }
                    }
                }
            }
        }
        return $status;
    }

    public function delete($id = null)
    {
        if ($id == null) {
            redirect("driver");
        } else {
            $chk = $this->db->select('status')->get_where('tb_truck_drivers', ["id" => $id]);
            if ($chk->num_rows() > 0) {
                $curdt = date("Y-m-d H:i:s");
                $uid   = $this->session->userdata("user_id");
                $utype = 1;
                if ($this->session->userdata('business_type') == "Carrier") {
                    $uid   = $this->session->userdata("id");
                    $utype = 2;
                }
                $status = $chk->row()->status;
                if ($status == "Active") {
                    $sts = "Inactive";
                    /*remove from all sources*/
                    $upd   = $this->db->where(["driver_id" => $id])->update("tbl_assigned_drivers", ["status" => 0]);
                    $upd   = $this->db->where(["driver_id" => $id])->update("tb_vehicles_drivers", ["status" => 0]);
                    $logdt = ['user_id' => $uid, 'user_type' => $utype, 'activity_id' => 0, 'action_name' => "Vehicle Delete", 'child_id' => 0, 'device_type' => 1, 'description' => "Vehicle Delete " . $id, 'status' => 1, 'createdon' => $curdt];
                    $ins   = $this->db->insert("tb_user_activities", $logdt);
                } else {
                    $sts   = "Active";
                    $logdt = ['user_id' => $uid, 'user_type' => $utype, 'activity_id' => 0, 'action_name' => "Vehicle Delete", 'child_id' => 0, 'device_type' => 1, 'description' => "Vehicle Active " . $id, 'status' => 1, 'createdon' => $curdt];
                    $ins   = $this->db->insert("tb_user_activities", $logdt);
                }
                $upd = $this->db->where("id", $id)->update("tb_truck_drivers", ["status" => $sts]);
            }
            redirect("driver");
        }
    }
    public function checkTrip()
    {
        $post = $this->input->post(null, true);
        if (isset($post["vehicle_id"]) && strlen($post["vehicle_id"]) > 0) {
            $vehicle_id = $post["vehicle_id"];
            $driver_id  = $post["driver_id"];
            $trips      = $this->db->query(
                "SELECT id FROM tb_trips WHERE vehicle_id = ? AND driver_id = ? AND status = 1",
                [$vehicle_id, $driver_id]
            );
            if ($trips->num_rows() > 0) {
                echo "1";
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function checkmobile(string $mobile): bool
    {
        $numRows = $this->user_model->checkDriverMobileExistsOrNot(['number' => $mobile, 'id' => 0]);
        if ($numRows > 0) {
            $this->form_validation->set_message('checkmobile', 'Mobile Number is already Exist!');
            return false;
        }
        return true;
    }
    public function regenaratePassword($id)
    {
        $data              = $this->db->select("name,contact_num,password")->where("id", $id)->get("tb_truck_drivers")->row_array();
        $params            = [];
        $pwd               = (($data["password"]));
        $params['mobile']  = $data["contact_num"];
        $params['module']  = "Driver Account Confirmation";
        $params['message'] = "Dear " . $data["name"] . ", Your " . $data["contact_num"] . " as LoginID and Password is " . $pwd . ", You can login into our svkonekt LMV APP for more details";
        $params['user_id'] = $this->session->userdata("user_id");
        $this->sms->send($params);
    }

    public function assign($id = null)
    {
        if ($id != null) {
            $data["page_sub"] = "Assign Driver";
            $userid           = $this->session->userdata('user_id');
            if ($this->session->userdata('business_type') == "Carrier") {
                $vid            = $this->session->userdata('id');
                $data["trucks"] = $this->db->where(["vendor_id" => $vid, "status" => "Active"])->order_by('register_number')->get("tb_trucks_data");
            } else {
                $permission = checkuserpermissions();
                if (in_array("vehicles", $permission)) {
                    $company_code = $this->session->userdata('company_code');
                    $this->db->select('ttd.id,ttd.register_number')->from('tb_trucks_data ttd');
                    $this->db->join('tb_vendor_vehicles tvv', 'ttd.id=tvv.vehicle_id', 'LEFT');
                    $this->db->join('tb_vendors tv', 'tvv.vendor_id=tv.id', 'LEFT');
                    $this->db->where("tv.company_code", $company_code);
                    $this->db->where("ttd.status", 'Active');
                    $this->db->where("ttd.register_number <>", 'DUMMYVEHICLE');
                    $this->db->order_by('ttd.register_number');
                    $data["trucks"] = $this->db->get();
                    //$data["trucks"] = $this->db->where(array("company_code" => $company_code, "status"=>"Active", "register_number <>"=>"DUMMYVEHICLE"))->get("tb_trucks_data");
                } else {
                    $data["trucks"] = $this->db->where(["user_id" => $userid, "status" => "Active", "register_number <>" => "DUMMYVEHICLE"])->order_by('register_number')->get("tb_trucks_data");
                }
            }
            $data["driver"] = $this->db->where(["id" => $id])->get("tb_truck_drivers")->row();
            echo $this->load->view("driver/assign", $data, true);
        }
    }
    public function deassign($id = null)
    {
        if ($id != "") {
            $curdt      = date("Y-m-d H:i:s");
            $vehicle_id = $vehid = 0;
            $chk        = $this->db->select("vehicle_id")->get_where("tbl_assigned_drivers", ["driver_id" => $id, "status" => 1], 1, 0);
            if ($chk->num_rows() > 0) {
                $vehicle_id = $vehid = $chk->row()->vehicle_id;
            }
            $upd = $this->db->where(["driver_id" => $id, "status" => 1])->update("tbl_assigned_drivers", ["status" => 0, "to_time" => $curdt]);
            if ($vehicle_id == 0) {
                $row = $this->db->select("id,vehicle_id")->get_where("tb_vehicles_drivers", ["driver_id" => $id, "status" => 1], 1, 0);
                if ($row->num_rows() > 0) {
                    $vehicle_id = $row->row()->vehicle_id;
                }
            }
            $upd = $this->db->where(["driver_id" => $id, "status" => "1"])->update("tb_vehicles_drivers", ["status" => "0"]);
            if ($vehicle_id != 0) {
                $rows = $this->db->select("id")->order_by("id", "asc")->get_where("tbl_assigned_drivers", ["status" => 1, "vehicle_id" => $vehicle_id], 1, 0);
                if ($rows->num_rows() == 0) {
                    $last = $this->db->select("vehicle_id,driver_id,imei")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["status" => 1, "vehicle_id" => $vehicle_id], 1, 0);
                    if ($last->num_rows() > 0) {
                        $data["driver_id"]  = $last->row()->driver_id;
                        $data["vehicle_id"] = $last->row()->vehicle_id;
                        $data["imei"]       = $last->row()->imei;
                        $data["status"]     = 1;
                        $data["from_time"]  = $data["to_time"]  = $curdt;
                        $row1               = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $data["driver_id"], "vehicle_id" => $data["vehicle_id"], "status" => 1], 1, 0);
                        if ($row1->num_rows() == 0) {
                            $ins = $this->db->insert("tbl_assigned_drivers", $data);
                        }
                    }
                }
                if ($vehid != 0) {
                    if ($vehicle_id != $vehid) {
                        $rows = $this->db->select("id")->order_by("id", "asc")->get_where("tbl_assigned_drivers", ["status" => 1, "vehicle_id" => $vehid], 1, 0);
                        if ($rows->num_rows() == 0) {
                            $last = $this->db->select("vehicle_id,driver_id,imei")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["status" => 1, "vehicle_id" => $vehid], 1, 0);
                            if ($last->num_rows() > 0) {
                                $data["driver_id"]  = $last->row()->driver_id;
                                $data["vehicle_id"] = $last->row()->vehicle_id;
                                $data["imei"]       = $last->row()->imei;
                                $data["status"]     = 1;
                                $data["from_time"]  = $data["to_time"]  = $curdt;
                                $row1               = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $data["driver_id"], "vehicle_id" => $data["vehicle_id"], "status" => 1], 1, 0);
                                if ($row1->num_rows() == 0) {
                                    $ins = $this->db->insert("tbl_assigned_drivers", $data);
                                }
                            }
                        }
                    }
                }
            }
        }
        echo 1;
    }

    public function assigndriver(): void
    {
        $vendorId    = 0;
        $currentDate = date('Y-m-d H:i:s');
        $userRoleId  = $this->session->userdata('user_role_id');
        $post        = $this->input->post(null, true);
        if (isset($post)) {
            $data["driver_id"]  = $post["id"] ?? "";
            $data["vehicle_id"] = $post["truck"] ?? "";
            if ($data["driver_id"] != "" && $data["vehicle_id"] != "") {
                $removePreviousDrivers = $post["remove_previous_drivers"] ?? "";
                $data["user_id"]       = $this->session->userdata("user_id");
                $data["created_on"]    = $data["from_time"]    = $data["to_time"]    = $currentDate;
                if ($userRoleId === "2" || $userRoleId === "3") {
                    $getVendorDetails = $this->db->query("SELECT vendor_id FROM tb_trucks_data WHERE id = ?", [$data['vehicle_id']]);
                    if ($getVendorDetails->num_rows() > 0) {
                        $vendorId = $getVendorDetails->row()->vendor_id;
                    }
                    if ($vendorId > 0) {
                        $this->common->updatetbledata("tb_truck_drivers", ['vendor_id' => $vendorId], ['id' => $data['driver_id']]);
                    }
                }
                $data['mobile_no'] = $data['imei'] = "";
                $getDriverDetails  = $this->db->query("SELECT contact_num FROM tb_truck_drivers WHERE id = ?", [$data['driver_id']]);
                if ($getDriverDetails->num_rows() > 0) {
                    $data["mobile_no"] = $getDriverDetails->row()->contact_num;
                }
                if ($removePreviousDrivers === "1") {
                    $this->common->updatetbledata("tb_vehicles_drivers", ['status' => '0'], ['vehicle_id' => $data['vehicle_id']]);
                    $this->common->updatetbledata("tbl_assigned_drivers", ['status' => '0'], ['vehicle_id' => $data['vehicle_id']]);
                }
                $checkAssignedDriverExists = $this->db->query("SELECT id FROM tbl_assigned_drivers WHERE vehicle_id = ? AND status = ?", [$data['vehicle_id'], 1]);
                if ($checkAssignedDriverExists->num_rows() == 0) {
                    $this->common->insertTableData("tbl_assigned_drivers", $data);
                }
                $this->common->insertTableData("tb_vehicles_drivers", ["vehicle_id" => $data["vehicle_id"], "driver_id" => $data["driver_id"], "imei" => $data["imei"], "status" => "1", "createdon" => $currentDate]);
            }
            redirect("driver");
        }
    }

    public function report($id = null)
    {
        
        $config          = [];
        $user_id         = $this->session->userdata('user_id');
        $data["drivers"] = $this->db->where(["createdby" => $user_id, "status" => "Active"])->get("tb_truck_drivers");
        if ($id == null) {
            redirect("driver/report/all");
        } else if ($id == "all") {
            $data["name"] = "All Drivers";
            $sql          = "SELECT a.*, t.register_number
                FROM tbl_assigned_drivers a, tb_trucks_data t
                WHERE t.id = a.vehicle_id
                ORDER BY a.to_time DESC";
            $config["base_url"] = base_url() . "driver/report/all";
        } else {
            $data["name"] = $this->db->query(
                "SELECT name FROM tb_truck_drivers WHERE id = ?",
                [$id]
            )->row()->name;
            $escapedId = $this->db->escape($id);
            $sql       = "SELECT a.*, t.register_number
                FROM tbl_assigned_drivers a, tb_trucks_data t
                WHERE t.id = a.vehicle_id AND a.driver_id = {$escapedId}
                ORDER BY a.to_time DESC";
            if ($this->db->query($sql)->num_rows() == 0) {
                $this->report();
            }
            $config["base_url"] = base_url() . "driver/report/" . $id;
        }
        $config["total_rows"]  = $this->db->query($sql)->num_rows();
        $config["per_page"]    = 10;
        $config["uri_segment"] = 4;
        $this->pagination->initialize($config);
        $page               = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $escapedPage        = $this->db->escape($page);
        $escapedPerPage     = $this->db->escape($config['per_page']);
        $sql                = $sql . " LIMIT {$escapedPage}, {$escapedPerPage} ";
        $data["reports"]    = $this->db->query($sql);
        $data["links"]      = $this->pagination->create_links();
        $data["page_title"] = "Drivers";
        $data["page_sub"]   = " Reports";
        $this->settemplate->dashboard("driver/report", $data);
    }
    
    public function vehicleassign($id = null)
    {
        if ($id != null) {
            $data["page_sub"]     = "Assign Driver";
            $userid               = $this->session->userdata('user_id');
            $assign_vehicle       = $vehicle_driver       = $final_vehicles       = [];
            $getassignvehicledata = $this->common->gettbldata(['driver_id' => $id, 'status' => '1'], 'vehicle_id,status,driver_id', 'tbl_assigned_drivers', 0, 0);

            if (count($getassignvehicledata) > 0) {
                foreach ($getassignvehicledata as $row) {
                    $assign_vehicle[] = [
                        "vehicle_id" => $row['vehicle_id'],
                        "driver_id"  => $row['driver_id'],
                        "status"     => "Primary",
                    ];
                }
            }

            $getvehicledriverdata = $this->common->gettbldata(['driver_id' => $id, 'status' => '1'], 'vehicle_id,status,driver_id', 'tb_vehicles_drivers', 0, 0);

            foreach ($getvehicledriverdata as $row) {
                $vehicle_driver[] = [
                    "vehicle_id" => $row['vehicle_id'],
                    "driver_id"  => $row['driver_id'],
                    "status"     => "Secondary",
                ];
            }

            $vehicle_list = array_unique(array_merge($vehicle_driver, $assign_vehicle), SORT_REGULAR);

            foreach ($vehicle_list as $vehicleslist) {
                $vid                                                       = $vehicleslist['vehicle_id'];
                $final_vehicles[$vehicleslist['vehicle_id']]['vehicle_id'] = $vehicleslist['vehicle_id'];
                $final_vehicles[$vehicleslist['vehicle_id']]['driver_id']  = $vehicleslist['driver_id'];
                $final_vehicles[$vehicleslist['vehicle_id']]['status']     = $vehicleslist['status'];

                $getvehicledata = $this->common->gettbldata(['id' => $vid, 'status' => 'Active'], 'truck_number,register_number', 'tb_trucks_data', 0, 0);

                foreach ($getvehicledata as $row) {
                    $final_vehicles[$vehicleslist['vehicle_id']]['truck_number']    = $row['truck_number'];
                    $final_vehicles[$vehicleslist['vehicle_id']]['register_number'] = $row['register_number'];
                }
            }

            $data["vehicleassign_list"] = $final_vehicles;
        }
        $data["driver"] = $this->db->where(["id" => $id])->get("tb_truck_drivers")->row();
        echo $this->load->view("driver/vehicleassign", $data, true);
    }

    public function deassignveh($id = null, $vehicle_id = null)
    {
        $id         = $_GET['id'];
        $vehicle_id = $_GET['vehicle_id'];

        if ($id != "" && $vehicle_id != "") {
            $curdt = date("Y-m-d H:i:s");

            $this->common->updatetbledata("tbl_assigned_drivers", ["status" => 0, "to_time" => $curdt],
                ["driver_id" => $id, "vehicle_id" => $vehicle_id, "status" => 1]);

            $this->common->updatetbledata("tb_vehicles_drivers", ["status" => 0, "updatedon" => $curdt],
                ["driver_id" => $id, "vehicle_id" => $vehicle_id, "status" => 1]);

            $this->common->updatetbledata("tb_truck_drivers", ["vendor_id" => 0, "updatedon" => $curdt],
                ["id" => $id, "status" => 1]);
        }

        echo 1;
    }

    public function uploaddriverexcel()
    {
        if ($this->session->userdata('company_code') == "SG") {$company_code = "SGKN";} else { $company_code = $this->session->userdata('company_code');}
        $data["company_code"] = $company_code;
        $data["branch_code"]  = $branch_code  = $this->session->userdata('branch_code');
        $data["createdon"]    = date("Y-m-d H:i:s");
        $data["user_id"]      = $data["createdby"]      = $this->session->userdata('user_id');
        if ($this->session->userdata("business_type") == "Carrier") {
            $id                = $this->session->userdata("id");
            $data["vendor_id"] = $id;
        }

        try {
            if ($_FILES['import_file']['size'] > 0) {
                $inputFilename = $_FILES['import_file']['tmp_name'];

                $objPHPExcel = PHPExcel_IOFactory::load($inputFilename);
                $sheetData   = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                for ($i = 2; $i <= count($sheetData); $i++) {

                    $data['name']                = $driverame                = isset($sheetData[$i]['A']) ? $sheetData[$i]['A'] : "";
                    $data['age']                 = $age                 = isset($sheetData[$i]['B']) ? $sheetData[$i]['B'] : "40";
                    $data['contact_num']         = $contact_num         = isset($sheetData[$i]['C']) ? $sheetData[$i]['C'] : "";
                    $password                    = isset($sheetData[$i]['D']) ? $sheetData[$i]['D'] : "";
                    $data['city']                = isset($sheetData[$i]['E']) ? $sheetData[$i]['E'] : "";
                    $data['imei']                = isset($sheetData[$i]['F']) ? $sheetData[$i]['F'] : "";
                    $data['driving_licence_num'] = $lic_no = isset($sheetData[$i]['G']) ? $sheetData[$i]['G'] : "";
                    $data['driver_type']         = $drivertype         = isset($sheetData[$i]['H']) ? $sheetData[$i]['H'] : "";
                    $data['driving_since']       = $driverexp       = isset($sheetData[$i]['J']) ? $sheetData[$i]['J'] : "0";
                    $data["password"]            = password_hash($password, PASSWORD_DEFAULT);

                    $line_no = $i - 1;
                    if ($data['name'] != "" && $data['city'] != "" && $password != "" && $data['contact_num'] != "") {

                        $gettruckdata = $this->db->select('id')->get_where("tb_truck_drivers", ['contact_num' => $contact_num, 'company_code' => $company_code, 'status' => 'Active']);
                        if ($gettruckdata->num_rows() > 0) {
                            $excel_sorders[] = ['line_no' => $line_no, 'driverame' => $driverame, 'contact_num' => $contact_num, 'status' => 'Already Driver Exists'];

                        } else {
                            if ($age > 18) {
                                $ins             = $this->db->insert("tb_truck_drivers", $data);
                                $excel_sorders[] = ['line_no' => $line_no, 'driverame' => $driverame, 'contact_num' => $contact_num, 'status' => 'Success'];
                            } else {
                                $excel_sorders[] = ['line_no' => $line_no, 'driverame' => $driverame, 'contact_num' => $contact_num, 'status' => 'Age is below 18 Years'];
                            }
                        }

                    } else {
                        $excel_sorders[] = ['line_no' => $line_no, 'driverame' => $driverame, 'contact_num' => $contact_num, 'status' => 'Failed'];
                    }

                }
            }

            if (! empty($excel_sorders)) {
                @file_put_contents("assets/ordertemplate/driverexceldata.txt", json_encode($excel_sorders));
            }

            redirect('driver/index/01');
        } catch (\Exception $e) {
            echo $e->getMessage();
        }

    }
}
