<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ELOGOTMSTSRWB extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(['log', 'user_language','user']);
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }

        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
        self::setBrowserLang($this);
    }
    private static function setBrowserLang(CI_Controller $CI): void
    {
        $clientLangHeader = $CI->input->get_request_header('Accept-Language');
        log_info('Client browser lang_headers ' . json_encode($clientLangHeader, JSON_PRETTY_PRINT));
        $detectedBrowserLang = browsersLanguageDetection($clientLangHeader);
        log_info('final Lang to returned :: ' . $detectedBrowserLang);
        if (!$CI->session->has_userdata('site_lang')) {
            $CI->session->set_userdata('site_lang', $detectedBrowserLang);
        }
    }
    public function index(): void
    {
        $orderId = $this->input->get('id');
        if ($orderId) {
            $parts = explode('.', $orderId);
            if (count($parts) > 0) {
                $domain = $parts[0];
                $usernamePassword = $this->db->select("url,username, password")->from("int_cred")->where(["domain" => $domain, "object" => "Cloud_Order"])->limit(1)->get();
                
                if ($usernamePassword->num_rows() > 0) {
                    $row = $usernamePassword->row();
                    $otmUrl = $row->url;
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                }
            } else {
                log_message("error", "No dot found in the orderId.");
            }
            //log_message("error", "orderId:".$orderId);
        $url = $otmUrl. $orderId;
       // log_message("error", "url:".$url);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($otmUserName . ':' . $otmPassword)
            ),
        ));
        $response = curl_exec($curl);
        
        curl_close($curl);
        if ($response === false || !($data = json_decode($response, true))) {
            $this->session->set_flashdata('error', 'Failed to fetch data from API');
        } else {
            $this->session->set_userdata('api_response', $data);
            if (isset($data['OrderRelease'])) {
                $statusValues = [];
                if (isset($data['OrderRelease']['orderReleaseStatus'])) {
                    foreach ($data['OrderRelease']['orderReleaseStatus'] as $status) {
                        $statusValue = explode(".", $status['orderReleaseStatusBeanData']['statusValueGid']);
                        $statusValues[] = end($statusValue);
                    }
                    $data['statusValues'] = $statusValues;
                    $this->session->set_userdata('statusValues', $statusValues);
                }
            }
            $this->load->view('ELOGOTMSTSRWB', $data);
        }
        } else {
            log_message("error", "No orderId provided.");
            $this->load->view('ELOGOTMSTSRWB', true);
        }
    }
    
    public function fetchDataFromAPI() : void
    {
        $input = $this->input->get('orderId');
        //log_message("error", "input: " . $input);
        $orderId = null;
        if (strpos($input, 'http') === 0 || strpos($input, 'https') === 0) {
            $urlParts = parse_url($input);
            parse_str($urlParts['query'], $queryParams);
            $orderId = $queryParams['id'] ?? null;
            $baseUrl = $urlParts['scheme'] . '://' . $urlParts['host'] . $urlParts['path'];
            $url = $baseUrl . '?id=' . $orderId;
        } else {
            $orderId = $input;
            $url =  OTM_RELEASEXID_URL. $orderId;
        }
        
        //log_message("error", "url: " . $url);
    
        if ($orderId) {
            //log_message("error", "orderId: " . $orderId);
            $parts = explode('.', $orderId);
            /*log_message("error", "parts: " . json_encode($parts));
            log_message("error", "count: " . count($parts));*/
            if (count($parts) > 1) {
                $domain = implode('/', array_slice($parts, 0, -1));
                $orderIdPart = $parts[count($parts) - 1];
                $usernamePassword = $this->db->select("username, password")->from("int_cred")->where(["domain" => $domain, "object" => "Cloud_Order"])->limit(1)->get();
                //log_message("error","Qry:".$this->db->last_query());
                if ($usernamePassword->num_rows() > 0) {
                    $row = $usernamePassword->row();
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                } else {
                    log_message("error", "No credentials found for domain: " . $domain);
                    return;
                }
            } else {
                log_message("error", "Invalid orderId format.");
                return;
            }
            $curl = curl_init();
            /*log_message("error","url:".$url);
            log_message("error","otmUserName:".$otmUserName);
            log_message("error","otmPassword:".$otmPassword);*/
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic ' . base64_encode($otmUserName . ':' . $otmPassword)
                ),
            ));
    
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            //log_message("error", "response:".$response);
    
            if ($response === false || !($data = json_decode($response, true))) {
                $this->session->set_flashdata('error', 'Failed to fetch data from API');
            } else {
                $this->session->set_userdata('api_response', $data);
                if (isset($data['OrderRelease'])) {
                    $statusValues = [];
                    if (isset($data['OrderRelease']['orderReleaseStatus'])) {
                        foreach ($data['OrderRelease']['orderReleaseStatus'] as $status) {
                            $statusValue = explode(".", $status['orderReleaseStatusBeanData']['statusValueGid']);
                            $statusValues[] = end($statusValue);
                        }
                        $data['statusValues'] = $statusValues;
                        $this->session->set_userdata('statusValues', $statusValues);
                    }
                }
                echo json_encode($data);
            }
        } else {
            log_message("error", "No orderId provided.");
        }
    }
    public function generateStatusXml() : void 
    {
        $requestData = json_decode(file_get_contents('php://input'), true);
        //log_message("error", "Generated Status XML: " . json_encode($requestData));
        // Extract required data from $requestData
        $status = $requestData['status'];
        $statusCodes =['ORG_GATEIN' => '0490','ORG_PICKUP' => '0500','ORG_GATEOUT' =>'1080','DEST_GATEIN' => '4300','DEST_DELIVERED' => '3000','DEST_GATEOUT' =>'2320'];
        $statusXid = isset($statusCodes[$status]) ? $statusCodes[$status] : '';
        $api_response = $_SESSION['api_response'];
        //log_message("error", "api_response: " . json_encode($api_response));
        if (isset($api_response['orderReleaseXid'])) {
            $orderRelease = $api_response['orderReleaseXid'];
            if($api_response['domainName']){
                $usernamePassword = $this->db->select("url, username, password")->from("int_cred")->where(["domain" => $api_response['domainName'], "object" => "Cloud_Event"])->limit(1)->get();
                //log_message("error", "Qry: " . $this->db->last_query());
                if($usernamePassword->num_rows() > 0 ) {
                    $row = $usernamePassword->row();
                    $otmUrl = $row->url;
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                }
            }   
        }
        //log_message("error", "Generated Status XML: " . $url);
        $date =  Date("Ymdhis");
        $timeZone = getTimeZoneFromIpAddress();
        $timeZoneObj = new DateTimeZone($timeZone);
        $now = new DateTime("now", $timeZoneObj);
        $offset = $now->getOffset() / 3600; // Get offset in hours
        // Format offset to ±HH:MM
        $offsetString = sprintf("%+03d:00", $offset);
        $xml = '<otm:Transmission xmlns:otm="http://xmlns.oracle.com/apps/otm/transmission/v6.4" xmlns:gtm="http://xmlns.oracle.com/apps/gtm/transmission/v6.4">';
        $xml .= '<otm:TransmissionHeader>';
        $xml .= '<otm:Version>6.5.2.1-20231208</otm:Version>';
        $xml .= '<otm:TransmissionCreateDt>';
        $xml .= '<otm:GLogDate>' . $date . '</otm:GLogDate>';
        $xml .= '<otm:TZId>' . $timeZone . '</otm:TZId>';
        $xml .= '<otm:TZOffset>' . $offsetString . '</otm:TZOffset>';
        $xml .= '</otm:TransmissionCreateDt>';
        $xml .= '<otm:TransactionCount>1</otm:TransactionCount>';
        $xml .= '<otm:SenderHostName>>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderHostName>';
        $xml .= '<otm:SenderSystemID>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderSystemID>';
        $xml .= '<otm:UserName>'. $otmUserName .'</otm:UserName>';
        $xml .= '<otm:Password>'. $otmPassword .'</otm:Password>';
        $xml .= '<otm:SenderTransmissionNo>' . 'E' . $date . '</otm:SenderTransmissionNo>';
        $xml .= '<otm:ReferenceTransmissionNo>1</otm:ReferenceTransmissionNo>';
        $xml .= '</otm:TransmissionHeader>';
        $xml .= '<otm:TransmissionBody>';
        $xml .= '<otm:GLogXMLElement>';
        $xml .= '<otm:TransactionHeader>';
        $xml .= '<otm:SenderTransactionId>' . 'E' . $date . '</otm:SenderTransactionId>';
        $xml .= '</otm:TransactionHeader>';
        $xml .= '<otm:TransOrderStatus>';
        $xml .= '<otm:ReleaseGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $api_response['domainName'] . '</otm:DomainName>';
        $xml .= '<otm:Xid>' . $api_response['orderReleaseXid'] . '</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:ReleaseGid>';
        $xml .= '<otm:StatusLevel>ORDER</otm:StatusLevel>';
        $xml .= '<otm:OrderRefnum>';
        $xml .= '<otm:OrderRefnumQualifierGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>GLOG</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:OrderRefnumQualifierGid>';
        $xml .= '<otm:OrderRefnumValue>' . $api_response['orderReleaseXid'] . '</otm:OrderRefnumValue>';
        $xml .= '</otm:OrderRefnum>';
        $xml .= '<otm:StatusCodeGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $api_response['domainName'] . '</otm:DomainName>';
        $xml .= '<otm:Xid>' . $statusXid .'</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:StatusCodeGid>';
        $xml .= '<otm:StatusReasonCodeGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $api_response['domainName'] . '</otm:DomainName>';
        $xml .= '<otm:Xid>1000</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:StatusReasonCodeGid>';
        $xml .= '<otm:TimeZoneGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>Local</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:TimeZoneGid>';
        $xml .= '<otm:EventDt>';
        $xml .= '<otm:GLogDate>' . $date . '</otm:GLogDate>';
        $xml .= '<otm:TZId>' . $timeZone . '</otm:TZId>';
        $xml .= '<otm:TZOffset>' . $offsetString . '</otm:TZOffset>';
        $xml .= '</otm:EventDt>';
        $xml .= '<otm:ResponsiblePartyGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>CARRIER</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:ResponsiblePartyGid>';
        $xml .= '<otm:ReportingUser>APAC/DEMOA.BSCYADAV</otm:ReportingUser>';
        $xml .= '</otm:TransOrderStatus>';
        $xml .= '</otm:GLogXMLElement>';
        $xml .= '</otm:TransmissionBody>';
        $xml .= '</otm:Transmission>';
        log_message("error", "Generated XML: " . $xml);
        $ch = curl_init();
        //log_message("error", "otmUrl.".$otmUrl);
        curl_setopt($ch, CURLOPT_URL, $otmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
        //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: text/xml'
        ));
        curl_setopt($ch, CURLOPT_USERPWD, "$otmUserName:$otmPassword"); // This adds Basic Auth
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        log_message('error', 'Response from server11: ' . $response);
        if ($response === false) {
            log_message('error', 'cURL error: ' . curl_error($ch));
        } else {
            log_message('error', 'Response from server: ' . $response);
        }
        curl_close($ch);
        echo  $response;
        
    }
    
    function encryptCryptoLibPassword($pwd="CHANGEME0125")
{
        require_once './application/third_party/cryptolib-php/src/CryptoLib.php';
        $encryption = new \MrShan0\CryptoLib\CryptoLib();
        $pwd        = $encryption->encryptPlainTextWithRandomIV($pwd, ENCRYPTION_KEY);
        echo $pwd;
}
   
}
