<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ELOGSTSRWB extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('string');
         $this->load->model('common');
		 $this->load->library('ElogOrder');
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }

        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
    }
     public function index(): void
    {
        $orderId = $this->input->get('id');
        log_message('error', 'orderId in index: ' . $orderId);
        $data= $this->elogorder->fetchingElogOrderData($orderId);
        if($data) {
            $this->load->view('ELOGSTSRWB', $data);
        }
	}
	 public function fetchDataFromAPI() : void
    {
        $orderId = $this->input->get('orderId');
        log_message("error","orderid in fetchdatafromapi" . $orderId);
        $data = $this->elogorder->fetchingElogOrderData($orderId);
        if ($data) {
            echo json_encode($data);
        } else {
            echo json_encode([]);
        }
    }
}