<?php if (!defined('BASEPATH')) {exit('No direct script access allowed');}

class Ebooking extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
    }
    public function index()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Data";
        $uid = $this->session->userdata("user_id");
        $data["party_types"] = $this->db->query("SELECT id as `val`,name as `text` FROM tbl_party_types WHERE status = '1' AND user_id = '$uid'")->result_array();
        $this->settemplate->dashboard("ebook/ebook", $data);
    }
    public function search()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $result = array();
		$data["pickup_location"] = $pickup_location = isset($_POST["pickup_location"]) ? $_POST["pickup_location"] : "";
		$data["pickup_date"] = $pickup_date = isset($_POST["pickup_date"]) ? $_POST["pickup_date"] : "";
		$data["pickup_city"] = $pickup_city = isset($_POST["pickup_city"]) ? $_POST["pickup_city"] : "";
		$data["pickup_country"] = $pickup_country = isset($_POST["pickup_country"]) ? $_POST["pickup_country"] : "";
		$data["pickup_postal_code"] = $pickup_postal_code = isset($_POST["pickup_postal_code"]) ? $_POST["pickup_postal_code"] : "";
		$data["drop_location"] = $drop_location = isset($_POST["drop_location"]) ? $_POST["drop_location"] : "";
		$data["drop_date"] = $drop_date = isset($_POST["drop_date"]) ? $_POST["drop_date"] : "";
		$data["drop_city"] = $drop_city = isset($_POST["drop_city"]) ? $_POST["drop_city"] : "";
        $curtz = date_default_timezone_get();
        if($data['pickup_date'] != ""){
            $getactual = getdatetimebytimezone(DFLT_TZ,$data['pickup_date'],$curtz);
            $data['pickup_date'] = $getactual['date'];
        }
        if($data['drop_date'] != ""){
            $getactual = getdatetimebytimezone(DFLT_TZ,$data['drop_date'],$curtz);
            $data['drop_date'] = $getactual['date'];
        }
		$data["drop_country"] = $drop_country = isset($_POST["drop_country"]) ? $_POST["drop_country"] : "";
		$data["drop_postal_code"] = $drop_postal_code = isset($_POST["drop_postal_code"]) ? $_POST["drop_postal_code"] : "";
		$str = "";
        if(isset($_POST)){
        	$s1=[];
        	if(strlen($pickup_location)>0){
        		$s1[] = "pickup_company like '%$pickup_location%'";
        	}
        	if(strlen($pickup_city)>0){
        		$s1[] = "pickup_city like '%$pickup_city%'";
        	}
        	if(strlen($drop_location)>0){
        		$s1[] = "delivery_company like '%$drop_location%'";
        	}
        	if(strlen($drop_city)>0){
        		$s1[] = "delivery_city like '%$drop_city%'";
        	}
        	if(strlen($pickup_date)>0){
        		$s1[] = "pickup_datetime like '%$pickup_date%'";
        	}
        	if(strlen($drop_date)>0){
        		$s1[] = "delivery_datetime like '%$drop_date%'";
        	}
        	if(strlen($pickup_postal_code)>0){
        		$s1[] = "pickup_pincode like '%$pickup_postal_code%'";
        	}
        	if(strlen($drop_postal_code)>0){
        		$s1[] = "delivery_pincode like '%$drop_postal_code%'";
        	}
        	if(count($s1)>0)
        		$str = "AND (".implode(" OR ", $s1).")";
        }
        $res = $this->db->query("SELECT id,order_id,pickup_city,delivery_city,convertToClientTZ(pickup_datetime,'".$curtz."') as pickup_datetime,weight,volume,quantity,transport_mode FROM tb_orders WHERE user_id = '$uid' AND status =1 $str ORDER BY pickup_datetime DESC");
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        $data["orders"] = $result;
        $this->settemplate->dashboard("ebook/ebooking_search", $data);
    }
    public function itemMaster()
    {
        $data["page_title"] = "E-Booking"; 
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $data["data"] = $this->db->query("SELECT im.*,st.unit_name FROM tbl_item_master im LEFT JOIN tbl_shipunit_types st ON st.id = im.unit_id WHERE im.status = '1' AND im.user_id = '$uid'");
        $this->load->view("ebook/item_master", $data);
    }
    public function locationMaster()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $data["data"] = $this->db->query("SELECT lm.*,cm.country_name as country,cm.country_code FROM tbl_location_master lm,tbl_country_master cm WHERE lm.status = '1' AND lm.user_id = '$uid' AND cm.id = lm.country_id");
        $this->load->view("ebook/location_master", $data);
    }
    public function deleteorderid($id = null){
       if($id != ""){
        $qry = $this->db->where(array("id"=>$id))->update("tb_orders",array("status"=>0));
       }
        redirect("Ebooking/search");
    }
    public function addLocation(){
        $id = isset($_POST["id"])?$_POST["id"] : "";
        $data = isset($_POST["data"])?$_POST["data"] : [];
        $uid = $this->session->userdata("user_id");
        if(count($data)>0){
            if(strlen($id)==0){
                $country = $data[3];
                $country_code = $data[4];
                if(strlen($country)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE country_name = '$country' OR country_code = '$country'");
                    $country_id = 0;
                    if($rows->num_rows()>0){
                        $country_id = $rows->row()->id;
                    }else{
                        $ins = $this->db->insert("tbl_country_master",array("country_name"=>$country,"country_code"=>$country_code,"user_id"=>$uid));
                        $country_id = $this->db->insert_id();
                    }
                    $row["country_id"] = $country_id;
                    if(strlen($data[0])>0 && strlen($data[2])>0){
                        $row["company"] = $data[0];
                        $row["name"] = $data[1];
                        $row["city_name"] = $data[2];
                        $row["pincode"] = $data[5];
                        $row["latitude"] = $data[6]; 
                        $row["longitude"] = $data[7];
                        $row["user_id"] = $uid;
                        $ins = $this->db->insert("tbl_location_master",$row);
                    }
                }
            }else{
                $country = $data[3];
                $country_code = $data[4];
                if(strlen($country)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_country_master WHERE country_name = '$country' OR country_code = '$country'");
                    $country_id = 0;
                    if($rows->num_rows()>0){
                        $country_id = $rows->row()->id;
                    }else{
                        $ins = $this->db->insert("tbl_country_master",array("country_name"=>$country,"country_code"=>$country_code,"user_id"=>$uid));
                        $country_id = $this->db->insert_id();
                    }
                    $row["country_id"] = $country_id;
                    if(strlen($data[0])>0 && strlen($data[2])>0){
                        $row["company"] = $data[0];
                        $row["name"] = $data[1];
                        $row["city_name"] = $data[2];
                        $row["pincode"] = $data[5];
                        $row["latitude"] = $data[6];
                        $row["longitude"] = $data[7];
                        $row["user_id"] = $uid;
                        $ins = $this->db->where("id",$id)->update("tbl_location_master",$row);
                    }
                }
            }
        }
        $this->locationMaster();
    }
    public function deleteLocation(){
        $id = isset($_POST["id"])?$_POST["id"] : "";
        if(strlen($id)>0){
            $upd = $this->db->where(array("id"=>$id))->update("tbl_location_master",array("status"=>"0"));
        }
        $this->locationMaster();
    }
    public function addItem()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        $data = isset($_POST["data"])?$_POST["data"] : [];
        $uid = $this->session->userdata("user_id");
        if(count($data)>0){
            if(strlen($id)==0){
                $unit = $data[0];
                if(strlen($unit)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name = '$unit'");
                    $unit_id = 0;
                    if($rows->num_rows()>0){
                        $unit_id = $rows->row()->id;
                    }else{
                        $this->db->insert("tbl_shipunit_types",array("unit_name"=>$unit,"user_id"=>$uid));
                        $unit_id = $this->db->insert_id();
                    }
                    $row["unit_id"] = $unit_id;
                    if(strlen($data[1])>0 && strlen($data[2])>0 && strlen($data[3])>0 && strlen($data[4])>0){
                        $row["length"] = $data[1];
                        $row["width"] = $data[2];
                        $row["height"] = $data[3];
                        $row["weight"] = $data[4];
                        $row["volume"] = $data[5];
                        $row["user_id"] = $uid;
                        $ins = $this->db->insert("tbl_item_master",$row);
                    }
                }
            }else{
                $unit = $data[0];
                if(strlen($unit)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name = '$unit'");
                    $unit_id = 0;
                    if($rows->num_rows()>0){
                        $unit_id = $rows->row()->id;
                    }else{
                        $ins = $this->db->insert("tbl_shipunit_types",array("unit_name"=>$unit,"user_id"=>$uid));
                        $unit_id = $this->db->insert_id();
                    }
                    $row["unit_id"] = $unit_id;
                    if(strlen($data[1])>0 && strlen($data[2])>0 && strlen($data[3])>0 && strlen($data[4])>0){
                        $row["length"] = $data[1];
                        $row["width"] = $data[2];
                        $row["height"] = $data[3];
                        $row["weight"] = $data[4];
                        $row["volume"] = $data[5];
                        $row["user_id"] = $uid;
                        $upd = $this->db->where("id",$id)->update("tbl_item_master",$row);
                    }
                }
            }
        }
        $this->itemMaster();
    }
    public function deleteItem()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        if(strlen($id)>0){
            $upd = $this->db->where(array("id"=>$id))->update("tbl_item_master",array("status"=>"0"));
        }
        $this->itemMaster();
    }
    public function addService()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        $data = isset($_POST["data"])?$_POST["data"] : [];
        $uid = $this->session->userdata("user_id");
        if(count($data)>0){
            if(strlen($id)==0){
                if(strlen($data[0])>0){
                    $row["addon_name"] = $data[0];
                    $row["description"] = $data[1];
                    $row["user_id"] = $uid;
                    $ins = $this->db->insert("tbl_addon_types",$row);
                }
            }else{
                if(strlen($data[0])>0){
                    $row["addon_name"] = $data[0];
                    $row["description"] = $data[1];
                    $row["user_id"] = $uid;
                    $ins = $this->db->where("id",$id)->update("tbl_addon_types",$row);
                }
            }
        }
        $this->serviceMaster();
    }
    public function deleteService()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        if(strlen($id)>0){
            $upd = $this->db->where(array("id"=>$id))->update("tbl_addon_types",array("status"=>"0"));
        }
        $this->serviceMaster();
    }
    public function addParty()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        $data = isset($_POST["data"]) ? $this->input->post("data",true) : [];
        $uid = $this->session->userdata("user_id");
        if(count($data)>0){
            if(strlen($id)==0){
                $party = $data[1];
                if(strlen($party)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_party_types WHERE name = '".$party."' AND user_id='$uid' ");
                    if($rows->num_rows()>0){
                        $unit_id = $rows->row()->id;
                    }else{
                        $ins = $this->db->insert("tbl_party_types",array("name"=>$party,"user_id"=>$uid));
                        $unit_id = $this->db->insert_id();
                    }
                    $row["party_type_id"] = $unit_id;
                    if(strlen($data[0])>0){
                        $chkexists = $this->db->query("SELECT id FROM tbl_party_master WHERE mobile = '".$data[2]."' AND user_id='$uid' ");
                        if($chkexists->num_rows() == 0){
                            $row["name"] = $data[0];
                            $row["mobile"] = $data[2];
                            $row["email"] = $data[3];
                            $row["location_id"] = $data[4];
                            $row["user_id"] = $uid;
                            $row["company_code"] = $this->session->userdata("company_code");
                            $row["branch_code"] = $this->session->userdata("branch_code");
                            $row["status"] = 1;
                            $ins = $this->db->insert("tbl_party_master",$row);
                        }else{
                            $upd = $this->db->where(array("id"=>$chkexists->row()->id))->set(array("party_type_id"=>$unit_id,"status"=>1))->update("tbl_party_master");
                        }
                    }
                } 
            }else{
                $party = $data[1];
                if(strlen($party)>0){
                    $rows = $this->db->query("SELECT id FROM tbl_party_types WHERE name = '".$party."' AND user_id='$uid'");
                    if($rows->num_rows()>0){
                        $unit_id = $rows->row()->id;
                    }else{
                        $ins = $this->db->insert("tbl_party_types",array("name"=>$party,"user_id"=>$uid));
                        $unit_id = $this->db->insert_id();
                    }
                    $row["party_type_id"] = $unit_id;
                    if(strlen($data[0])>0){
                        $chkexists = $this->db->query("SELECT id FROM tbl_party_master WHERE id != $id AND mobile = '".$data[2]."'");
                        if($chkexists->num_rows() == 0){
                            $row["name"] = $data[0];
                            $row["mobile"] = $data[2];
                            $row["email"] = $data[3];
                            $row["location_id"] = $data[4];
                            $row["user_id"] = $uid;
                            $row["company_code"] = $this->session->userdata("company_code");
                            $row["branch_code"] = $this->session->userdata("branch_code");
                            $row["status"] = 1;
                            $upd = $this->db->where(array("id"=>$id))->update("tbl_party_master",$row);
                        }else{
                            $row["name"] = $data[0];
                            $row["mobile"] = $data[2];
                            $row["email"] = $data[3];
                            $row["location_id"] = $data[4];
                            $row["user_id"] = $uid;
                            $row["company_code"] = $this->session->userdata("company_code");
                            $row["branch_code"] = $this->session->userdata("branch_code");
                            $row["status"] = 1;
                            $upd = $this->db->where(array("id"=>$chkexists->row()->id))->set($row)->update("tbl_party_master");
                        }
                    }
                }
            }
        }
        $this->partyMaster();
    }
    public function deleteParty()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        if(strlen($id)>0){
            $upd = $this->db->where(array("id"=>$id))->update("tbl_party_master",array("status"=>"0"));
        }
        $this->partyMaster();
    }
    public function addRemarks()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        $data = isset($_POST["data"])?$_POST["data"] : [];
        $uid = $this->session->userdata("user_id");
        if(count($data)>0){
            if(strlen($id)==0){
                if(strlen($data[0])>0){
                    $row["name"] = $data[0];
                    $row["description"] = $data[1];
                    $row["user_id"] = $uid;
                    $ins = $this->db->insert("tbl_remark_types",$row);
                }
            }else{
                if(strlen($data[0])>0){
                    $row["name"] = $data[0];
                    $row["description"] = $data[1];
                    $row["user_id"] = $uid;
                    $upd = $this->db->where("id",$id)->update("tbl_remark_types",$row);
                }
            }
        }
        $this->remarkMaster();
    }
    public function deleteRemarks()
    {
        $id = isset($_POST["id"])?$_POST["id"] : "";
        if(strlen($id)>0){
            $upd = $this->db->where(array("id"=>$id))->update("tbl_remark_types",array("status"=>"0"));
        }
        $this->remarkMaster();
    }
    public function serviceMaster()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $data["data"] = $this->db->query("SELECT * FROM tbl_addon_types WHERE status = '1' AND user_id = '$uid'");
        $this->load->view("ebook/service_master", $data);
    }
    public function partyMaster()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $data["data"] = $this->db->query("SELECT pm.*,pt.name as party_type,lm.name as location_name FROM tbl_party_master pm LEFT JOIN tbl_party_types pt ON pt.id = pm.party_type_id LEFT JOIN tbl_location_master lm ON lm.id = pm.location_id WHERE pm.status = '1' AND pm.user_id = '$uid'");
        $this->load->view("ebook/party_master", $data);
    }
    public function remarkMaster()
    {
        $data["page_title"] = "E-Booking";
        $data['sub_title']  = "Search";
        $uid = $this->session->userdata("user_id");
        $data["data"] = $this->db->query("SELECT * FROM tbl_remark_types WHERE status = '1' AND user_id = '$uid'");
        $this->load->view("ebook/remark_master", $data);
    }
}
