<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";


class Ecotransitreport extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('common');
		$this->load->model('orderrevenuesmodel');
        if (!checkUrlAccessForUser('ECOTRANSITREPORT')) {
            redirect("Forbiddenaccess");
        }
	}
	public function index(){
		$final['page_title']=$this->lang->line('ecotransit');
		$final['sub_title']=$this->lang->line('eco_report');
		$user_id=$this->session->userdata('user_id');
		if($this->input->post('searchType')!=''){
			$sql = "SELECT id,order_id,pickup_country,delivery_country,pickup_pincode,delivery_pincode,transport_mode,shift_id FROM tb_orders  WHERE user_id='".$user_id."'" ;
			$fromdate   = date( 'Y-m-d', strtotime($this->input->post('fromdate')));
			$sql.= " AND DATE_FORMAT(createdon,'%Y-%m-%d') >= '".$fromdate."' ";
			$todate = date( 'Y-m-d', strtotime( $this->input->post('todate') ) );
			$sql.= " AND DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' ";
			$bookingid = $this->input->post('bookingid')  ;
			if ($bookingid!='') {
				$cids = "'" . implode ( "', '", $bookingid) . "'";
				$get_data = $this->db->query("SELECT id FROM `tb_customers` where code IN ($cids)");
				$ids = array();
				if($get_data->num_rows() > 0){
					foreach ($get_data->result() as $get_data_f) {
						$ids[] = $get_data_f->id ;
					}
				}
				$cidsNew = "'" . implode ( "', '", $ids) . "'";
				$sql.= " AND customer_id IN ($cidsNew) " ;
			}
			$sql.=" order by id DESC" ;
			$query	=	$this->db->query($sql);
			$res	=	$query->result_array();
		 }
		 if($this->input->post('searchType')=='Search'){
			 $final['orders'] = array() ;
			foreach ($res as $data){
				$shft_id = $data['shift_id'] ;
				$orderId = $data['id'] ;
				$sqlFuel = "SELECT  t2.fuel_type,t2.vehicle_emission FROM  tb_shft_veh  as t1 INNER JOIN tb_trucks_data as t2 ON (t1.vehicle_id=t2.id) where t1.shft_id='".$shft_id."' AND t1.status='1' " ;
				$query1	=	$this->db->query($sqlFuel);
				$resFuel	=	$query1->row_array();
				if($resFuel==''){
					$fuel_type = '' ;
				}else{
					$fuel_type = strtolower($resFuel['fuel_type']) ;
				}
				$sqlTons = "SELECT if(lower(t1.secondweight_uom) = 'tons',SUM(t1.second_weight),0) as weightTons,if(lower(t1.secondweight_uom) = 'kg',SUM(t1.second_weight),0) as weightKg FROM `tb_cargo_details` as t1 INNER JOIN tb_order_cargodetails as t2 ON (t1.id=t2.cargo_id) WHERE t2.order_id='".$orderId."' AND lower(t1.secondweight_uom) IN ('tons','kg') AND t2.status='1' group by lower(t1.secondweight_uom)";
				$query2	=	$this->db->query($sqlTons);
				$weightTons	=	$query2->row_array();
				if(!empty($weightTons['weightTons'])){
					$weight_tons = intval($weightTons['weightTons'])*1000 ;
				}else{
					$weight_tons = 0 ;
				}
				if(!empty($weightTons['weightKg'])){
					$weight_kg = intval($weightTons['weightKg']) ;
				}else{
					$weight_kg = 0 ;
				}
				$totalWeight = $weight_tons+$weight_kg ;
				$weight = '' ;
				$unit = '' ;
				if($weight_tons>0 && $weight_kg>0){
					$weight = $totalWeight ;
					$unit = 'kg';
				}
				if($weight_tons>0 && $weight_kg==0){
					$weight = intval($weightTons['weightTons']) ;
					$unit = 'ton';
				}
				if($weight_tons==0 && $weight_kg>0){
					$weight = intval($weightTons['weightKg']);
					$unit = 'kg';
				}
				$class_type = '' ;
				if($data['transport_mode']=='TL' || $data['transport_mode']=='FTL' ){
					$transport_mode = 'FTL' ;
					if($resFuel==''){
						$class_type = '' ;
					}else{
						$class_type = strtolower($resFuel['vehicle_emission']) ;
					}
				}else{
					$this->db->select('weight_range_from,weight_range_to,class_type');
					$this->db->from("tb_vehicle_emission_data");
					$query = $this->db->get();
					$res = $query->result_array();
					foreach($res as $row){
						if($row['weight_range_from'] < $totalWeight && $row['weight_range_to'] >= $totalWeight){
							$class_type = $row['class_type'] ;
						}
					}
					$transport_mode = $data['transport_mode'] ;
				}
				$pickCountry = getCountryCode(ucwords(strtolower($data['pickup_country']))) ;
				if($pickCountry==''){
					$pickCountry = $data['pickup_country'] ;
				}
				$deliCountry = getCountryCode(ucwords(strtolower($data['delivery_country']))) ;
				if($deliCountry==''){
					$deliCountry = $data['delivery_country'] ;
				}
				$data['origin_location_code'] = $pickCountry.$data['pickup_pincode'] ;
				$data['origin_location_country'] = $pickCountry ;
				$data['main_vehicle_type'] = $class_type ;
				$data['main_allocation_method'] = $transport_mode ;
				$data['main_fuel_type'] = $fuel_type ;
				$data['destination_location_country'] = $deliCountry ;
				$data['destination_location_code'] = $deliCountry.$data['delivery_pincode'] ;
				$data['freight_weight'] = $weight ;
				$data['weight_unit'] = $unit ;
				$final['orders'][] = $data ;
			}
			$this->newtemplate->dashboard( 'ecotransitreport/index',$final);
		}else if($this->input->post('searchType')=='Export'){
			$this->load->helper('new_helper');
			$filename	=	'Eco-Transit-Report.csv';
			header("Content-Description: File Transfer");
			header("Content-Disposition: attachment; filename=$filename");
			header("Content-Type: application/csv; ");
			$file	=	fopen('php://output','w');
			$header	=	array("shipment_id","origin_location_type","origin_location_code","origin_location_country","main_transport_mode","main_vehicle_type","main_allocation_method","main_fuel_type","destination_location_type","destination_location_code","destination_location_country","freight_weight","weight_unit");
			fputcsv($file, $header);
			foreach ($res as $data){
				$shft_id = $data['shift_id'] ;
				$orderId = $data['id'] ;
				$sqlFuel = "SELECT  t2.fuel_type,t2.vehicle_emission FROM  tb_shft_veh  as t1 INNER JOIN tb_trucks_data as t2 ON (t1.vehicle_id=t2.id) where t1.shft_id='".$shft_id."' AND t1.status='1' " ;
				$query1	=	$this->db->query($sqlFuel);
				$resFuel	=	$query1->row_array();
				if($resFuel==''){
					$fuel_type = '' ;
				}else{
					$fuel_type = strtolower($resFuel['fuel_type']) ;
				}
				$sqlTons = "SELECT if(lower(t1.secondweight_uom) = 'tons',SUM(t1.second_weight),0) as weightTons,if(lower(t1.secondweight_uom) = 'kg',SUM(t1.second_weight),0) as weightKg FROM `tb_cargo_details` as t1 INNER JOIN tb_order_cargodetails as t2 ON (t1.id=t2.cargo_id) WHERE t2.order_id='".$orderId."' AND lower(t1.secondweight_uom) IN ('tons','kg') AND t2.status='1' group by lower(t1.secondweight_uom)";
				$query2	=	$this->db->query($sqlTons);
				$weightTons	=	$query2->row_array();
				if(!empty($weightTons['weightTons'])){
					$weight_tons = intval($weightTons['weightTons'])*1000 ;
				}else{
					$weight_tons = 0 ;
				}
				if(!empty($weightTons['weightKg'])){
					$weight_kg = intval($weightTons['weightKg']) ;
				}else{
					$weight_kg = 0 ;
				}
				$totalWeight = $weight_tons+$weight_kg ;
				$weight = '' ;
				$unit = '' ;
				if($weight_tons>0 && $weight_kg>0){
					$weight = $totalWeight ;
					$unit = 'kg';
				}
				if($weight_tons>0 && $weight_kg==0){
					$weight = intval($weightTons['weightTons']) ;
					$unit = 'ton';
				}
				if($weight_tons==0 && $weight_kg>0){
					$weight = intval($weightTons['weightKg']);
					$unit = 'kg';
				}
				$class_type = '' ;
				if($data['transport_mode']=='TL' || $data['transport_mode']=='FTL' ){
					$transport_mode = 'FTL' ;
					if($resFuel==''){
						$class_type = '' ;
					}else{
						$class_type = strtolower($resFuel['vehicle_emission']) ;
					}
				}else{
					$this->db->select('weight_range_from,weight_range_to,class_type');
					$this->db->from("tb_vehicle_emission_data");
					$query = $this->db->get();
					$res = $query->result_array();
					foreach($res as $row){
						if($row['weight_range_from'] < $totalWeight && $row['weight_range_to'] >= $totalWeight){
							$class_type = $row['class_type'] ;
						}
					}
					$transport_mode = $data['transport_mode'] ;
				}
				$pickCountry = getCountryCode(ucwords(strtolower($data['pickup_country']))) ;
				if($pickCountry==''){
					$pickCountry = $data['pickup_country'] ;
				}
				$deliCountry = getCountryCode(ucwords(strtolower($data['delivery_country']))) ;
				if($deliCountry==''){
					$deliCountry = $data['delivery_country'] ;
				}
				fputcsv($file,array($data['order_id'],'zip-code',$pickCountry.$data['pickup_pincode'],$pickCountry,'Truck',$class_type,$transport_mode,$fuel_type,'zip-code',$deliCountry.$data['delivery_pincode'],$deliCountry,$weight,$unit));
			}
			fclose($file);
			exit;
		}else{
			$final['orders']  = array() ;
			$this->newtemplate->dashboard( 'ecotransitreport/index',$final);
		}
	}
	public function getbusinesscid()
    {
		$post = $this->input->post(null,true);
		if(isset($post['searchTerm']) && !empty($post['searchTerm'])){
			$cid = $post['searchTerm'] ;
			$get_data = $this->db->query("SELECT code,id FROM `tb_customers` where code is not null and code !='' and code != 0 and code like '%$cid%'");
			$data = array();
			if($get_data->num_rows() > 0){
				foreach ($get_data->result() as $get_data_f) {
					$data[] = array("id"=>$get_data_f->code, "text"=>$get_data_f->code); ;
				}
			}
			echo json_encode($data);
		}
    }
}
