<?php
defined('BASEPATH') or exit('No direct script access allowed');

class EdiTransactionsCleaner extends CI_Controller
{
    private const limit = 100000;
    private const deleteOlderThan = "5 DAY";
    private const tableName = "tb_etn_edi_transactions";
    private const timezone = 'Europe/Vienna';

    public function index(): void
    {
        date_default_timezone_set(self::timezone);

        $this->db->query(sprintf('
            DELETE FROM %s
            WHERE created_on < (NOW() - INTERVAL %s)
            AND ((edi_id != 8 OR edi_id != 9) AND bounded_type != 2)
            LIMIT %d
        ', self::tableName, self::deleteOlderThan, self::limit));
    }


    public function optimizeTable(): void
    {
        $this->db->query(sprintf('OPTIMIZE TABLE %s', self::tableName));
    }
}
