<?php if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

use App\Generators\RandomString;

class Employee extends CI_Controller {
	public function __Construct() {
		parent::__Construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
	}
	public function index($pageval = '') {
		$data['page_title'] = "Shipments/Shipment Stops";
		$this->settemplate->dashboard('employee', $data);
	}

	function getemps(){
		$uid=$this->session->userdata("user_id");
		$data=array();
		$start=$_GET["start"];
		$length=$_GET["length"];
		$search=$_GET["search"];
		$order=$_GET["order"];
		$sql="select * from tb_employee where status=1 and user_id=$uid";
		$qr=$this->db->query($sql);
		if($_GET){
			$s=isset($search["value"])?$search["value"]:"";
			if($s!=""){
				$sql.=" and (name like '%".$s."%' or assoc_id like '%".$s."%' or phone like '%".$s."%' or pickup like '%".$s."%' or address like '%".$s."%')";
			}
			$o=isset($order["0"]["column"])?$order["0"]["column"]:"";
			$so=isset($order["0"]["dir"])?$order["0"]["dir"]:"";
			if($o!=""){
				if($o=="0")
					$sql.=" order by id $so";
				else if($o=="1")
					$sql.=" order by name $so";
				else if($o=="2")
					$sql.=" order by assoc_id $so";
				else if($o=="3")
					$sql.=" order by phone $so";
				else if($o=="4")
					$sql.=" order by pickup $so";
				else if($o=="5")
					$sql.=" order by `drop` $so";
				else if($o=="6")
					$sql.=" order by address $so";
			}

		}
		$qr=$this->db->query($sql);
		$tot=$qr->num_rows();
		$sql.=" limit $start,$length";
		$qr1=$this->db->query($sql);
		if($qr1->num_rows()>0){
			$data["recordsTotal"]=$tot;
			$data["recordsFiltered"]=$tot;
			foreach($qr1->result() as $row){
				$d=array();
				$status = getempstatus($row->id);
				$sts = "NEW";
				$sts1 = "";
				if(!empty($status['tripsts'])){
					if($status['tripsts']['status'] == 1){
						if($row->ship_type == "P"){
							$sts1 = "Picked Up";
						}else{
							$sts1 = "Dropped";
						}
					}
					$sts = $sts1.' - '.$status['tripsts']['pd_status'];
				}
				$d['id']='<span class="showstophistory" style="color:#3c8dbc;cursor:pointer;" id="'.$row->id.'" >'.$row->assoc_id.'</span>';
				$d['name']=$row->name;
				$d['phone']=$row->phone;
				$d['pickup']=$row->pickup;
				$d['drop']=$row->drop;
				$d['address']=$row->address;
				$d['content']=$row->shipment_weight.'/'.$row->shipment_volume;;
				$d['ship_type']=$row->ship_type;
				$d['status']=$sts;
				$d['actions']='<button class="btn btn-success btn-xs" onclick="moveurl(\'Are you Sure want to modify this record?\',\''.base_url().'employee/addnewemployee/'.$row->id.'\')" title="edit"><i class="fa fa-edit "></i></button> <button class="btn btn-danger btn-xs" onclick="moveurl(\'Are you Sure want to delete this record?\',\''.base_url().'employee/del_emp/'.$row->id.'\')" title="delete"><i class="fa fa-close"></i></button>';
				$data["data"][]=$d;
			}
		}
		echo json_encode($data);
	}
	function getempschedules($userid) {
		$query = $this->db->query("select CONCAT(splace,' [',stime,'] -',eplace,' [',etime,']') as rootName,v.id from tb_shifts s,tb_shft_veh v where s.user_id=" . $userid . " AND s.status='1' AND v.status='1' ");
		return $query;
	}
	function mainqueryemp($whr, $perpage, $currentpage, $routename) {
		if ($routename != '') {
			$sql = "select * from tb_employee,tb_sch_emp where $whr limit $currentpage,$perpage";
			$sql_download = "select * from tb_employee,tb_sch_emp where $whr ";
			$this->session->set_userdata('empdownload', $sql_download);
			return $query = $this->db->query($sql);

		} else {
			$sql = "select * from tb_employee where $whr limit $currentpage,$perpage";
			$sql_download = "select * from tb_employee where $whr ";
			$this->session->set_userdata('empdownload', $sql_download);
			return $query = $this->db->query($sql);
		}
	}
	function addnewemployee($emp_id = 0) {
		$data['page_title'] = "Add Shipment/Shipment Stop";
		$data['empName'] = "";
		$data['phone'] = "";
		$data['pickup'] = "";
		$data['emailid'] = "";
		$data['plat'] = "";
		$data['plng'] = "";
		$data['assoc_id'] = "0";
		$data['password'] = "";
		$data['drop'] = "";
		$data['dlat'] = "";
		$data['dlng'] = "";
		$data['address'] = "";
		$data["id"]="";
		$data["img"]="";
		$data['emp_id'] = 0;
		$data["capacity"] = 0;
		$data["material_id"] = "";
		$data["information"] = "";
		$data["shipment_weight"] = 0;
		$data["shipment_volume"] = 0;
		$data["customer_id"]="";
		$data["ship_type"] = "D";
		$data["shift_id"] = 0;
		$data["stop_order"] = 0;
		if ($emp_id > 0) {
			$emplo = $this->db->get_where('tb_employee', array('id' => $emp_id))->row_array();
			$data["id"]=$emp_id;
			$data['empName'] = $emplo['name'];
			$data['phone'] = $emplo['phone'];
			$data['pickup'] = $emplo['pickup'];
			$data['emailid'] = $emplo['emailid'];
			$data['plat'] = $emplo['plat'];
			$data['plng'] = $emplo['plng'];
			$data['dlat'] = $emplo['dlat'];
			$data['dlng'] = $emplo['dlng'];
			$data['assoc_id'] = $emplo['assoc_id'];
			$data['password'] = $emplo['password'];
			$data['drop'] = $emplo['drop'];
			$data['address'] = $emplo['address'];
			$data['emp_id'] = $emp_id;
			$data["img"]=$emplo['img'];
			$data["capacity"]=$emplo['capacity'];
			$data["material_id"]=$emplo['material_id'];
			$data["information"]=$emplo['information'];
			$data["shipment_weight"] = $emplo['shipment_weight'];
			$data["shipment_volume"] = $emplo['shipment_volume'];
			$data["ship_type"] = $emplo['ship_type'];
			$data["customer_id"]=$emplo['customer_id'];
			$data["shift_id"]=$emplo['shift_id'];
			$data["stop_order"]=$emplo['stop_order'];
		}
		$whr = array('status' => '1','user_id'=>$this->session->userdata('user_id'));
		$data["customers"] = $this->db->get_where('tb_customers', $whr)->result();
		$data['materials'] = $this->db->get_where('tb_materials', array('status' => 'Active'))->result();
		$data['shipments'] = $this->db->select('id,splace,eplace,shipment_name,startdate')->get_where('tb_shifts', $whr)->result();
		$this->settemplate->dashboard('addnewemployee', $data);
	}
	function removeImageEmp($id=null){
		if($this->db->where("id",$id)->update("tb_employee",array("img"=>"")))
		redirect("employee/addnewemployee/".$id);
	}
	function emp_save($id=null) {
		if($id!=null){
			$data['name'] = $this->input->post('empName');
			$data['assoc_id'] = $this->input->post('assoc_id');
			$data['phone'] = $this->input->post('phone');
			$data['pickup'] = $this->input->post('pickup');
			$data['emailid'] = $this->input->post('emailid');
			$data['drop'] = $this->input->post('drop');
			$data['dlat'] = $this->input->post('dlat');
			$data['dlng'] = $this->input->post('dlng');
			$data['plat'] = $this->input->post('plat');
			$data['plng'] = $this->input->post('plng');
			$data['address'] = $this->input->post('address');
			$data['capacity'] = $this->input->post('capacity');
			$data['material_id'] = $this->input->post('material_id');
			$data['information'] = $this->input->post('information');
			$data["shipment_weight"] = $this->input->post('shipment_weight');
			$data["shipment_volume"] = $this->input->post('shipment_volume');
			$data["ship_type"] = $this->input->post('ship_type');
			$data["customer_id"]=$this->input->post('customer_id');
			$data['shift_id'] = $this->input->post('shift_id');
			$data['stop_order'] = $this->input->post('stop_order');
			$config = array(
				'upload_path'   => './assets/employee/',
				'allowed_types' => 'jpg|jpeg|png|gif',
				'overwrite'     => 1,
			);
	       	$image1=$this->input->post('img');
			if(isset($_FILES)){
				if(!empty($_FILES)){
					$this->load->library('upload');
					$this->upload->initialize($config);
			       	if (!$this->upload->do_upload('img'))
			       	{
						//$this->session->set_flashdata('error_msg', "Image format unsupported!");
			       	}else{
						$original_size=getimagesize($_FILES['img']['tmp_name']);
						$actualWidth = $original_size[0];
						$actualHeight = $original_size[1];
						//print_r($resize_settings);
						$name=$_FILES['img']['name'];
						$maxHeight=340;
						$maxWidth=340;
						if($actualWidth>$maxWidth || $actualHeight>$maxHeight)
						{
							$config['image_library'] = 'gd2';
							$config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
							$config['maintain_ratio'] = TRUE;
							$config['new_image'] = './assets/employee';
							$config['width'] = $maxWidth;
							$config['height'] = $maxHeight;
							$config['overwrite'] = TRUE;
							$data['img']=$this->upload->file_name;
							$this->load->library('image_lib', $config);
							$this->image_lib->initialize($config);
							$this->image_lib->resize();
						}else{
							$config['image_library'] = 'gd2';
							$config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
							$config['maintain_ratio'] = TRUE;
							$config['new_image'] = './assets/employee';
							$config['overwrite'] = TRUE;
							$data['img']=$this->upload->file_name;
							$this->load->library('image_lib', $config);
							$this->image_lib->initialize($config);
							$this->image_lib->resize();
						}
			       	}
		       	}
	        }
			$sql=$this->db->query("select id from tb_employee where id='".$id."' and status='1'")->num_rows();
			if ($sql == 0) {
				$this->session->set_flashdata('success_msg', "Shipment Stop does not Exist!");
			} else {
				$data['user_id'] = $this->session->userdata('user_id');
				$this->db->where("id",$id)->update("tb_employee", $data);
				$this->session->set_flashdata('success_msg', "Shipment Stop Updated Successfully");
			}
		}else{
			$data['name'] = $this->input->post('empName');
			$data['shift_id'] = trim($this->input->post('shift_id'));
			if($data['shift_id'] != ""){
			$data['phone'] = $this->input->post('phone');
			$data['password'] = RandomString::generate(10);
			$data['pickup'] = $this->input->post('pickup');
			$data['emailid'] = $this->input->post('emailid');
			$data['drop'] = $this->input->post('drop');
			$data['dlat'] = $this->input->post('dlat');
			$data['dlng'] = $this->input->post('dlng');
			$data['plat'] = $this->input->post('plat');
			$data['plng'] = $this->input->post('plng');
			$data['address'] = $this->input->post('address');
			$data['capacity'] = $this->input->post('capacity');
			$data['material_id'] = $this->input->post('material_id');
			$data['information'] = $this->input->post('information');
			$data["shipment_weight"] = $this->input->post('shipment_weight');
			$data["shipment_volume"] = $this->input->post('shipment_volume');
			$data["ship_type"] = $this->input->post('ship_type');
			$data["customer_id"]=$this->input->post('customer_id');
			$data["stop_order"]=$this->input->post('stop_order');
			$curdt = date('Y-m-d H:i:s');
			$data["createdon"]=$curdt;
			$config = array(
			'upload_path'   => './assets/employee/',
			'allowed_types' => 'jpg|jpeg|png|gif',
			'overwrite'     => 1,
			);
	       	$image1=$this->input->post('img');
	       	if(isset($_FILES['img'])){
				$this->load->library('upload');
				$this->upload->initialize($config);
		       	if (!$this->upload->do_upload('img'))
		       	{
					//$this->session->set_flashdata('error_msg', "Image format unsupported!");
		       	}else{
					$original_size=getimagesize($_FILES['img']['tmp_name']);
					$actualWidth = $original_size[0];
					$actualHeight = $original_size[1];
					//print_r($resize_settings);
					$name=$_FILES['img']['name'];
					$maxHeight=340;
					$maxWidth=340;
					if($actualWidth>$maxWidth || $actualHeight>$maxHeight)
					{
						$config['image_library'] = 'gd2';
						$config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
						$config['maintain_ratio'] = TRUE;
						$config['new_image'] = './assets/employee';
						$config['width'] = $maxWidth;
						$config['height'] = $maxHeight;
						$config['overwrite'] = TRUE;
						$data['img']=$this->upload->file_name;
						$this->load->library('image_lib', $config);
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
					}else{
						$config['image_library'] = 'gd2';
						$config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
						$config['maintain_ratio'] = TRUE;
						$config['new_image'] = './assets/employee';
						$config['overwrite'] = TRUE;
						$data['img']=$this->upload->file_name;
						$this->load->library('image_lib', $config);
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
					}
		       	}
	        }
			/*$sql=$this->db->query("select id from tb_employee where assoc_id='".$data["assoc_id"]."' AND status='1'")->num_rows();
			if ($sql > 0) {
				$this->session->set_flashdata('success_msg', "Shipment ID Already Exist!");
			} else {*/
				$data['user_id'] = $this->session->userdata('user_id');
				$this->db->insert("tb_employee", $data);
				$lsid=$this->db->insert_id();
				/* check shipment have vehicle then add it into shft_veh_emp */
				$chk = $this->db->select('id')->get_where('tb_shft_veh',array('shft_id'=>$data['shift_id'],'status'=>1));
				if($chk->num_rows() > 0){
					$shftvehemp = array('user_id'=>$data['user_id'], 'shft_veh_id'=>$chk->row()->id, 'emp_id'=>$lsid, 'priority'=>$data["stop_order"], 'pickup_time'=>$curdt, 'created_on'=>$curdt, 'updated_on'=>$curdt, 'status'=>1, 'drop_time'=>$curdt);
					$ins = $this->db->insert('tb_shft_veh_emp',$shftvehemp);
				}
				adddefaltsos($lsid);
				$this->session->set_flashdata('success_msg', "Shipment Stop Added Successfully");
			/*}*/
		}else{
			$this->session->set_flashdata('success_msg', "Shipment Id should not be null");
		}
		}
		redirect('employee');
	}
	function del_emp($emp_id) {
		$this->db->where("id",$emp_id)->update("tb_employee", array('status' => '0'));
		$this->session->set_flashdata('success_msg', "Shipment Deleted Successfully");
		redirect('employee');
	}
	function downloadEmployee() {
		ini_set('memory_limit', '16M');

		//load our new PHPExcel library
		$this->load->library('excel');
		//activate worksheet number 1
		$this->excel->setActiveSheetIndex(0);
		//name the worksheet
		$this->excel->getActiveSheet()->setTitle('ShipmentList');
		//set cell A1 content with some text
		$this->excel->getActiveSheet()->setCellValue('A1', 'S.no');
		$this->excel->getActiveSheet()->setCellValue('B1', 'Full Name');
		$this->excel->getActiveSheet()->setCellValue('C1', 'Associate ID');
		$this->excel->getActiveSheet()->setCellValue('D1', 'Contact Number');
		$this->excel->getActiveSheet()->setCellValue('E1', 'Pickup Location');
		$this->excel->getActiveSheet()->setCellValue('F1', 'Pickup Lattitude');
		$this->excel->getActiveSheet()->setCellValue('G1', 'Pickup Longitude');
		$this->excel->getActiveSheet()->setCellValue('H1', 'Droping Location');
		$this->excel->getActiveSheet()->setCellValue('I1', 'Droping Lattitude');
		$this->excel->getActiveSheet()->setCellValue('J1', 'Droping Longitude');
		$this->excel->getActiveSheet()->setCellValue('K1', 'Address');
		$this->excel->getActiveSheet()->setCellValue('L1', 'Email');
		$rid = 0;
		$rowcount = 2;
		$tsno = 1;
		$temp = array();
		$query = $this->session->userdata('empdownload');
		$employee = $this->db->query($query);
		if ($employee->num_rows() > 0) {
			foreach ($employee->result() as $empl) {
				$result['assoc_id'] = $empl->assoc_id;
				$result['name'] = $empl->name;
				$result['phone'] = $empl->phone;
				$result['pickup'] = $empl->pickup;
				$result['plat'] = $empl->plat;
				$result['plng'] = $empl->plng;
				$result['drop'] = $empl->drop;
				$result['dlat'] = $empl->dlat;
				$result['dlng'] = $empl->dlng;
				$result['address'] = $empl->address;
				$result['emailid'] = $empl->emailid;
				array_push($temp, $result);

			}
			foreach ($temp as $data) {

				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(0, $rowcount, $tsno);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(1, $rowcount, $data['name']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(2, $rowcount, $data['assoc_id']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(3, $rowcount, $data['phone']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(4, $rowcount, $data['pickup']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(5, $rowcount, $data['plat']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(6, $rowcount, $data['plng']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(7, $rowcount, $data['drop']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(8, $rowcount, $data['dlat']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(9, $rowcount, $data['dlng']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(10, $rowcount, $data['address']);
				$this->excel->getActiveSheet()->setCellValueByColumnAndRow(11, $rowcount, $data['emailid']);
				$tsno++;
				$rowcount++;
			}

			$filename = 'ShipmentList.xls'; //save our workbook as this file name
			header('Content-Type: application/vnd.ms-excel'); //mime type
			header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
			header('Cache-Control: max-age=0'); //no cache
			$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
			//force user to download the Excel file without writing it to server's HD
			//ob_end_clean();
			ob_start();
			$objWriter->save('php://output');
		}
	}
	function showvehicles() {
		$data['page_title'] = "Shipments";
		$data['sub_title'] = "Assign Vehicle to Shift";
/*		$sessuid = $this->session->userdata('user_id');
$whr="gpsstatus=1 and user_id=".$sessuid;
$this->load->library('pagination');
$config["base_url"] = base_url() . "employee/showvehicles";
$sql="select count(id) as countrows from tb_trucks_data where $whr";
$query_count=$this->db->query($sql);
//echo $query_count->row()->countrows;
//exit;
$config["total_rows"] = $query_count->row()->countrows;
$config["per_page"] = 15;
$config["uri_segment"] = 3;
$config['display_pages'] = TRUE;
$this->pagination->initialize($config);
$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
$query = $this->mainqueryveh($whr,$config["per_page"], $page);
$data['query'] =$query;
$data["links"] = $this->pagination->create_links();*/
		$user = $this->session->userdata('user_id');
		$sql = "select id,stime,etime,splace,eplace from tb_shifts where user_id=" . $user;
		$shifts = $this->db->query($sql);
		$data['shifts'] = array();
		foreach ($shifts->result() as $key) {
			$rowres['id'] = $key->id;
			$rowres['stime'] = $key->stime;
			$rowres['splace'] = $key->splace;
			$rowres['etime'] = $key->etime;
			$rowres['eplace'] = $key->eplace;
			array_push($data['shifts'], $rowres);
		}
		//$this->settemplate->dashboard('schedules/vehicleslist',$data);
		$this->settemplate->dashboard('shift/vehs', $data);
	}
	function mainqueryveh($whr, $perpage, $currentpage) {
		$sql = "select id,register_number,imei,phone,status from tb_trucks_data where $whr limit $currentpage,$perpage";
		$sql_download = "select id as rowid from tb_trucks_data where $whr ";
		/*$this->session->set_userdata('vehdownload', $sql_download);*/
		return $query = $this->db->query($sql);
	}
	function vehschedules($imei = '') {
		$data['page_title'] = "Vehicles Schedules";
		$sessuid = $this->session->userdata('user_id');
		$sql = "select register_number,id as rowid from tb_trucks_data where gpsstatus=1 and  id='" . $imei . "' and user_id=" . $sessuid;
		$data['query'] = $this->db->query($sql);

		$scheduleq = "select id,rootName,from,to,sloc,eloc from tb_schedule where user_id=" . $sessuid;
		$data['schedule'] = $this->db->query($scheduleq);

		$emp = "select id,name,phone,address from tb_employee where user_id=" . $sessuid;
		$data['employee'] = $this->db->query($emp);

		$data['empName'] = "";
		$data['phone'] = "";
		$data['lat'] = "";
		$data['password'] = "";
		$data['lng'] = "";
		$data['address'] = "";
		$data['emp_id'] = 0;

		$this->settemplate->dashboard('schedules/schvehicles', $data);
		//	$this->settemplate->dashboardtemp('schvehicles/sch_vehicles',$data);
	}
	function route_status() {
		$status = $this->input->post('stats');
		$sche_id = $this->input->post('sche_id');
		$imei = $this->input->post('imei');
		$pdate = date('Y-m-d H:i:s');
		if ($this->session->userdata('user_id') == 3309) {
			$sql = "select id from tb_veh_sch where truck='" . $imei . "'";
		} else {
			$sql = "select id from tb_veh_sch where truck='" . $imei . "' and sch_id=$sche_id";
		}
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			//$query_up=$this->db->query("update tb_veh_sch set status=$status,truck='$imei' where sch_id=$sche_id");
			$query_up = $this->db->query("update tb_veh_sch set status=$status,sch_id=$sche_id,sdate='$pdate',edate='$pdate' where  truck='$imei'");
			if ($status == 0) {
				echo 0;
			} else {
				echo 1;
			}

		} else {
			$insertarray = array('sch_id' => $sche_id, 'truck' => $imei, 'status' => $status, 'edate' => $pdate, 'edate' => $pdate);
			$this->db->insert('tb_veh_sch', $insertarray);
			echo 1;
		}
	}
	function vehheads() {
		$date = date('Y-m-d H:i:s');
		$imei = $this->input->post('imei');
		$empl_id = $this->input->post('empl_id');
		$stats = $this->input->post('stats');
		$sql = "select id from tb_emp_vehicle where emp_id=" . $empl_id . " and imei='" . $imei . "'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			$query_veh = $this->db->query("update tb_emp_vehicle set status=$stats,updated_on='" . $date . "' where emp_id=" . $empl_id . " and imei='" . $imei . "'");
			if ($stats == 0) {
				echo "0";
			} else {
				echo "1";
			}

		} else {
			$insert = array('emp_id' => $empl_id, 'imei' => $imei, 'status' => $stats, 'created_on' => $date);
			$this->db->insert('tb_emp_vehicle', $insert);
			echo "1";
		}
	}
	function updateemployeeroute() {
		$emp_id = $this->input->get_post('emp_id');
		$sch_id = $this->input->get_post('sch_id');
		if ($sch_id > 0) {
			$query = $this->db->query("select id from tb_sch_emp where emp_id=$emp_id");
			if ($query->num_rows() > 0) {
				$sql = "update tb_sch_emp set sch_id=$sch_id,emp_id=$emp_id,status=1 where emp_id=$emp_id";
				$this->db->query($sql);
				echo 1;
			} else {
				$data['emp_id'] = $emp_id;
				$data['sch_id'] = $sch_id;
				$data['status'] = 1;
				$data['start_date'] = date('Y-m-d H:i:s');
				$this->db->insert('tb_sch_emp', $data);
				echo 1;
			}
		} else {
			$query = $this->db->query("select id from tb_sch_emp where emp_id=$emp_id");
			if ($query->num_rows() > 0) {
				$sql = "update tb_sch_emp set status=0 where emp_id=$emp_id";
				$this->db->query($sql);
				echo 0;
			}
		}
	}
	//dhanu added
	function isintvs($route, $imei) {
		$query = $this->db->query("select id from tb_veh_sch where sch_id=$route and truck='$imei'");
		$num_rows = $query->num_rows();
		if ($num_rows > 0) {
			return true;
		} else {
			return false;
		}

	}
	function isintev($route, $imei) {
		$query = $this->db->query("select id from tb_emp_vehicle where emp_id=$route and imei='$imei'");
		$num_rows = $query->num_rows();
		if ($num_rows > 0) {
			return true;
		} else {
			return false;
		}

	}
	function gettn($imei) {
		return '';
	}

	function empsch() {
		$user = $this->session->userdata('user_id');
		$data['page_title'] = "Shipment Schedules";
		$sql = "select id,stime,etime,splace,eplace from tb_shifts where user_id=" . $user;
		$shifts = $this->db->query($sql);
		$rowres = array();
		$this->load->model("empmodel");
		$data['shifts'] = array();
		foreach ($shifts->result() as $key) {
			$rowres['id'] = $key->id;
			$rowres['stime'] = $key->stime;
			$rowres['splace'] = $this->empmodel->getshftpos($key->splace);
			$rowres['etime'] = $key->etime;
			$rowres['eplace'] = $this->empmodel->getshftpos($key->eplace);
			array_push($data['shifts'], $rowres);
		}
		//print_r($data['shifts']);
		$this->settemplate->dashboard("shift_veh_emp", $data);
	}
	function loadVehs() {
		$data['id'] = $_POST['id'];
		$time = array();
		$time = $this->get_shft_time($data['id']);
		$data['stime'] = $time[0];
		$data['etime'] = $time[1];
		$user = $this->session->userdata('user_id');
		$sql = "select id,truck_type,truck_capacity,register_number,phone from tb_trucks_data where user_id=$user and status = 'Active'";
		$vehs = $this->db->query($sql);
		$rowres = array();
		$data['vehs'] = array();
		foreach ($vehs->result() as $key) {
			$rowres['id'] = $key->id;
			$rowres['truck_type'] = ($key->truck_type != 94) ? getTruckType($key->truck_type):'Truck';
			$rowres['capacity'] = $key->truck_capacity;
			$rowres['imei'] = $key->register_number;
			$rowres['register_number'] = $key->register_number;
			$rowres['phone'] = $key->phone;
			array_push($data['vehs'], $rowres);
		}
		$sql = "select id,register_number,route_id from tb_shft_veh where shft_id=" . $data['id'] . " and status=1";
		$vehs1 = $this->db->query($sql);
		$rowres1 = array();
		$data['cvehs'] = array();
		foreach ($vehs1->result() as $key) {
			$rowres1['imei'] = $key->register_number;
			$rowres1['id'] = $key->id;
			$rowres1['route_id'] = $key->route_id;
			array_push($data['cvehs'], $rowres1);
		}
		$this->load->view('loadvehs.php', $data);
	}
	function addshftrow($imei, $shft_id) {
		$user = $this->session->userdata('user_id');
		$this->load->model("empmodel");
		$sql = "select id from tb_shft_veh where shft_id=$shft_id and register_number='" . $imei . "'";
		$veh = $this->db->query($sql);
		if ($veh->num_rows() > 0) {

			$data = array('status' => 1, "updated_on" => date("Y-m-d H:i:s"));
			$this->db->where(array('user_id' => $user, 'shft_id' => $shft_id, 'register_number' => $imei, 'status' => 0));
			$this->db->update('tb_shft_veh', $data);
		} else {
			$data = array('user_id' => $user, 'shft_id' => $shft_id, 'register_number' => $imei, 'status' => 1, "updated_on" => date("Y-m-d H:i:s"));
			$this->empmodel->addtable('tb_shft_veh', $data);
		}
	}
	function time2Str($time) {
		$hr = $time[0] . $time[1];
		$mn = $time[3] . $time[4];
		return $hr * 60 + $mn;
	}
	function matchtimings($time, $time1) {
		//echo $this->time2Str($time[0]).$this->time2Str($time1[0]);
		if ($this->time2Str($time[0]) == $this->time2Str($time1[0]) || $this->time2Str($time[1]) == $this->time2Str($time1[1])) {
			return true;
		} else {
			return false;
		}

	}
	function get_shft_time($shft_id) {
		$user = $this->session->userdata('user_id');
		$sql = "select stime,etime from tb_shifts where user_id=" . $user . " and id=" . $shft_id;
		$shifts = $this->db->query($sql);
		$time[0]=$time[1]=0;
		foreach ($shifts->result() as $sr) {
			$time[0] = $sr->stime;
			$time[1] = $sr->etime;
		}
		return $time;
	}
	function loadshft2veh() {
		$user = $this->session->userdata('user_id');
		$data['page_title'] = "Shipment Schedules";
		$sql = "select id,stime,etime,splace,eplace from tb_shifts where user_id=" . $user;
		$shifts = $this->db->query($sql);
		$rowres = array();
		$this->load->model("empmodel");
		$data['shifts'] = array();
		foreach ($shifts->result() as $key) {
			$rowres['id'] = $key->id;
			$rowres['stime'] = $key->stime;
			$rowres['splace'] = $this->empmodel->getshftpos($key->splace);
			$rowres['etime'] = $key->etime;
			$rowres['eplace'] = $this->empmodel->getshftpos($key->eplace);
			array_push($data['shifts'], $rowres);
		}
		$this->load->view('loadshft', $data);
	}
	function shftvehs() {
		$user = $this->session->userdata('user_id');
		$shft_id = $_POST['shft'];
		$sql = "select imei from tb_shft_veh where user_id=" . $user . " and shft_id=" . $shft_id . " and status=1";
		$res = $this->db->query($sql);
		$data['id'] = $shft_id;
		$rows = array();
		$data['veh'] = array();
		if ($res->num_rows() > 0) {
			foreach ($res->result() as $rs) {
				$rows['imei'] = $rs->imei;
				$rows['reg'] = $this->get_Reg($rs->imei);
				array_push($data['veh'], $rows);
			}
		}
		$this->load->view('loadshftvehs', $data);
	}
	function getshftvehid($shft, $veh) {
		$sql = "select id from tb_shft_veh where shft_id=$shft and register_number='$veh' and status=1";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			return $query->row()->id;
		} else {
			return 0;
		}

	}

	function getshftvehidbyroute($shft, $veh,$routeid) {
		$sql = "select id from tb_shft_veh where shft_id=$shft and register_number='$veh' and route_id=$routeid and status=1";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			return $query->row()->id;
		} else {
			return 0;
		}
	}
	function loademps() {
		$user = $this->session->userdata('user_id');
		$data['shft_id'] = $shftid =  $_POST['shft'];
		$data['veh'] = $_POST['veh'];
		$data['route_id'] = $_POST['route_id'];
		$time = $this->get_shft_time($data['shft_id']);
		$data['stime'] = $time[0];
		$data['etime'] = $time[1];
		$shft_veh_id = $this->getshftvehidbyroute($data['shft_id'], $data['veh'],$data['route_id']);
		$data['id'] = $shft_veh_id;
		$emp = "select id,name,assoc_id,pickup,`drop`,ship_type,shift_id from tb_employee where user_id='" . $user."' and status=1 and shift_id='".$shftid."'";
		$emps = $this->db->query($emp);
		$rowres = array();
		$data['emps'] = array();
		foreach ($emps->result() as $key) {
			$rowres['id'] = $key->id;
			$rowres['name'] = $key->name;
			$rowres['assoc_id'] = $key->assoc_id;
			$rowres['pickup'] = $key->pickup;
			$rowres['drop'] = $key->drop;
			$rowres['type'] = $key->ship_type;
			array_push($data['emps'], $rowres);
		}
		$sql = "select emp_id,priority,pickup_time from tb_shft_veh_emp where shft_veh_id=$shft_veh_id and status=1 order by id asc";
		//echo $sql;
		$vehs1 = $this->db->query($sql);
		$rowres1 = array();
		$data['cemps'] = array();
		foreach ($vehs1->result() as $key) {
			$rowres1['id'] = $key->emp_id;
			$rowres1['priority'] = $key->priority;
			$rowres1['pickup_time'] = $key->pickup_time;
			array_push($data['cemps'], $rowres1);
		}
		$this->load->view('loademps.php', $data);
	}


	function exchangemps(){
		$userid           = $this->session->userdata('user_id');
		$data["shft"]=$_POST["shft"];$data["veh"]=$_POST["veh"];$data["route_id"]=$_POST["route_id"];
       	$whr = array("user_id" => $userid,"status"=>'Active');
        $data["trucks"]   = $this->db->where($whr)->get("tb_trucks_data");
		$this->load->view('changevehs.php', $data);
	}

	function get_Reg($imei) {
		$trucks = $this->db->query("select register_number from tb_trucks_data where imei='" . $imei . "'");
		$res = "";
		if($trucks->num_rows() > 0){
			$row = $trucks->row();
			$res = $row->register_number;
		}
		return $res;
		/*$user = $this->session->userdata('user_id');
		$sql = "select * from tb_trucks_data where imei='" . $imei . "' and gpsstatus=1";
		$shifts = $this->db->query($sql);
		$time = array();
		foreach ($shifts->result() as $sr) {
			$time[0] = $sr->stime;
			$time[1] = $sr->etime;
		}
		return $time;*/
	}
	function createshift() {
		$stime = isset($_REQUEST['stime']) ? $_REQUEST['stime'] : '';
		$etime = isset($_REQUEST['etime']) ? $_REQUEST['etime'] : '';
		$splace = isset($_REQUEST['splace']) ? $_REQUEST['splace'] : '';
		$eplace = isset($_REQUEST['eplace']) ? $_REQUEST['eplace'] : '';
		$slat = isset($_REQUEST['slat']) ? $_REQUEST['slat'] : '';
		$slng = isset($_REQUEST['slng']) ? $_REQUEST['slng'] : '';
		$elat = isset($_REQUEST['elat']) ? $_REQUEST['elat'] : '';
		$elng = isset($_REQUEST['elng']) ? $_REQUEST['elng'] : '';
		$stime=date("Y.M",strtotime($stime));
		$etime=date("Y.M",strtotime($etime));

		$user = $this->session->userdata('user_id');
		$this->load->model("empmodel");
		$tbshiftplace = array("pos" => $splace, "lat" => $slat, "lng" => $slng);
		$sid = $this->empmodel->insert("tb_shft_place", $tbshiftplace);
		$tbshiftplace1 = array("pos" => $eplace, "lat" => $elat, "lng" => $elng);
		$eid = $this->empmodel->insert("tb_shft_place", $tbshiftplace1);
		$tbshitf = array("stime" => $stime, "etime" => $etime, "splace" => $sid, "eplace" => $eid, "status" => 1, "user_id" => $user);
		$this->empmodel->addtable("tb_shifts", $tbshitf);
		echo "1";
	}
	function asn_shft2veh() {
		$vehs = isset($_REQUEST['vehs']) ? $_REQUEST['vehs'] : array();
		$items = isset($_REQUEST['items']) ? $_REQUEST['items'] : array();
		$stat = isset($_REQUEST['move']) ? $_REQUEST['move'] : 0;
		/*print_r($_POST);
		exit;*/
		$ost = $_POST['ost'];
		$oet = $_POST['oet'];
		$shft = $_POST['shft'];
		$unchecked = array();
		//print_r($items);
		if (count($items) > 0) {
			for ($i = 0; $i < count($items); $i++) {
				if (!in_array($items[$i], $vehs)) {
					array_push($unchecked, $items[$i]);
				} else {
					unset($vehs[array_search($items[$i], $vehs)]);
					//$vehs=array_diff($vehs,$items[$i]);
				}
			}
		}
		$c=0;
		if (count($vehs) > 0) {
			foreach ($vehs as $vs) {
				if($c==0&&$stat==1){
					$last_updated_veh=$this->getlastupdatedveh($shft);
					if($last_updated_veh[0]!="" && $last_updated_veh[1]!=""){
						$arr["vehicle"]=$last_updated_veh[0];
						$arr["truck"]=$vs;
						$arr["route_id"]=$last_updated_veh[1];
						$arr["shift"]=$shft;
						$this->changevehicle_array($arr);
					}
				}
				$this->add2shftvah($shft, $vs, $ost, $oet, "true");
				$c++;
			}
		}
		if (count($unchecked) > 0) {
			foreach ($unchecked as $uc) {
				$this->add2shftvah($shft, $uc, $ost, $oet, "false");
			}
		}
	}
	function getlastupdatedveh($shft=0){
		$veh=array("","");
		if($shft>0){
			$sql=$this->db->query("select register_number,route_id from tb_shft_veh where shft_id=".$shft." and status=1 order by id desc limit 1");
			if($sql->num_rows()>0){
				$veh[0]=$sql->row()->register_number;
				$veh[1]=$sql->row()->route_id;
			}
		}
		return $veh;
	}
	function add2shftvah($id, $imei, $ost, $oet, $bool) {
		$user = $this->session->userdata('user_id');
		if ($bool == "false") {
			$data = array('status' => 0, 'register_number' => $imei, "updated_on" => date("Y-m-d H:i:s"));
			$this->db->where(array('register_number' => $imei, 'status' => 1, 'shft_id' => $id));
			$this->db->update('tb_shft_veh', $data);
		} else {
			$sql = "select DISTINCT shft_id from tb_shft_veh where register_number='$imei' and user_id=$user and status=1";
			//echo $sql;
			$vehs = $this->db->query($sql);
			if ($vehs->num_rows() > 0) {
				foreach ($vehs->result() as $vs) {
					$time = array();
					$time1 = array($ost, $oet);
					$nsi = $vs->shft_id;
					$time = $this->get_shft_time($nsi);
					if ($this->matchtimings($time1, $time)) {
						$data = array('status' => 0, "updated_on" => date("Y-m-d H:i:s"));
						$this->db->where(array('register_number' => $imei, 'shft_id' => $nsi));
						$this->db->update('tb_shft_veh', $data);
					}
					//echo $this->db->last_query();
				}
				$this->addshftrow($imei, $id);
			} else {
				$this->addshftrow($imei, $id);
			}
		}
	}
	function asn_shftveh2emp() {
		$vehs = isset($_REQUEST['emps']) ? $_REQUEST['emps'] : array();
		$items = isset($_REQUEST['items']) ? $_REQUEST['items'] : array();
		$priority = isset($_REQUEST['priority']) ? $_REQUEST['priority'] : array();
		$routeid = isset($_REQUEST['route_id']) ? $_REQUEST['route_id'] : 0;
		$dt=date("Y-m-d H:i:s");
		$vehs1=array();
		if(count($vehs)>0){
			$vehs1=$vehs;
		}
		$shft = $_POST['shft'];
		$unchecked = array();
		$emp = $_POST['veh'];
		$svid = $this->getshftvehidbyroute($shft, $emp,$routeid);
		if(empty($vehs)){
			$setarr = array("status"=>0,"updated_on"=>$dt);
			$warr = array("shft_veh_id"=>$svid);
			$res = $this->db->set($setarr)->where($warr)->update("tb_shft_veh_emp");
			sendShiftRemainder($svid);
			return true;
		}
		if (count($items) > 0) {
			for ($i = 0; $i < count($items); $i++) {
				if (!in_array($items[$i], $vehs)) {
					array_push($unchecked, $items[$i]);
				} else {
					unset($vehs[array_search($items[$i], $vehs)]);
					//$vehs=array_diff($vehs,$items[$i]);
				}
			}
		}

		$priority_vals=array();
		if(count($priority) > 0){
			foreach($priority as $p){
				$parts=explode("@@", $p);
				$pval=substr($parts[0], 8);
				if($parts[1]!=""){
					array_push($priority_vals, array($pval,$parts[1]));
				}
			}
		}
		/*print_r($vehs1);*/
		/*$pickup_time_vals=array();
		if(count($pickup_time) > 0){
			foreach($pickup_time as $p){
				$parts=explode("@@", $p);
				$pval=substr($parts[0], 11);
				if($parts[1]!=""){
					if(in_array($pval, $vehs1))
						array_push($pickup_time_vals, array($pval,date("H:i",strtotime($parts[1]))));
				}
			}
		}
		array_multisort(array_map('strtotime', array_column($pickup_time_vals, 1)), SORT_ASC, $pickup_time_vals);*/
		if (count($vehs) > 0) {
			foreach ($vehs as $vs) {

				$this->add2shftvahempbyroute($shft,$svid, $vs, $routeid, "true");
			}
		}
		if (count($unchecked) > 0) {
			foreach ($unchecked as $uc) {
				$this->add2shftvahempbyroute($shft,$svid, $uc, $routeid, "false");
			}
		}
		$i=1;$t=0;
		/*if(count($pickup_time_vals)>0){
			foreach($pickup_time_vals as $pv){

				if($i>1){
					if($t==$pv[1]){
						$i--;
					}
				}
				$this->chagepriprity($svid,$pv[0],$i,$pv[1]);
				$i++;
				$t=$pv[1];
			}
		}*/
		if(count($priority_vals)>0){
			foreach($priority_vals as $pv){

				if($i>1){
					if($t==$pv[1]){
						$i--;
					}
				}
				$this->chagepriprity($svid,$pv[0],$pv[1]);
				$i++;
				$t=$pv[1];
			}
		}

	}

	function add2shftvahempbyroute($shft,$id, $eid, $routeid, $bool) {

		$user = $this->session->userdata('user_id');
		$reg=$this->db->where("id",$id)->get("tb_shft_veh")->row()->register_number;
		if ($bool == "false") {
			//sendRemainder($shft,$eid,$reg,'0');
			$date=date("Y-m-d H:i:s");
			$this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='".$date."' where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1' and v.route_id=".$routeid." and e.status='1'");
		} else {
			//sendRemainder($shft,$eid,$reg,'1');
			$this->load->model("empmodel");
			$sql=$this->db->query("select e.id from tb_shft_veh_emp e,tb_shft_veh v where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1' and e.status='1'");
			//echo $this->db->last_query();exit;
			if ($sql->num_rows() > 0) {
				$date=date("Y-m-d H:i:s");
				//$this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='".$date."' where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.route_id=".$routeid." and v.status='1' and e.status='1'");
				$this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='".$date."' where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1'");
				//echo $this->db->last_query();exit;
				$sql1 = "select id from tb_shft_veh_emp where shft_veh_id=$id and emp_id='" . $eid . "' and user_id=$user";
				$veh = $this->db->query($sql1);
				if ($veh->num_rows() > 0) {
					$data = array('status' => 1, "updated_on" => date("Y-m-d H:i:s"));
					$this->db->where(array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid));
					$this->db->update('tb_shft_veh_emp', $data);
				} else {
					$data = array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid, 'status' => 1, "updated_on" => date("Y-m-d H:i:s"));
					$this->empmodel->addtable('tb_shft_veh_emp', $data);
				}
			} else {
				$data = array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid, 'status' => 1, "updated_on" => date("Y-m-d H:i:s"));
				$this->empmodel->addtable('tb_shft_veh_emp', $data);
			}
		}
	}

	function chagepriprity($svid,$emp,$priority){
		//log_message('error',$svid.",".$emp.",".$priority);
		$user = $this->session->userdata('user_id');
		$where = array("shft_veh_id"=>$svid,"emp_id"=>$emp,"user_id"=>$user);
		$setval = array("updated_on"=>date("Y-m-d H:i:s"),"priority"=>$priority);
		$this->db->where($where)->update("tb_shft_veh_emp",$setval);
		//echo $this->db->last_query();
	}
	function add2shftvahemp($shft,$id, $eid, $bool) {
		$user = $this->session->userdata('user_id');
		if ($bool == "false") {
			$date=date("Y-m-d H:i:s");
			$this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='".$date."' where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1' and e.status='1'");
		} else {
			$this->load->model("empmodel");
			$sql=$this->db->query("select e.id from tb_shft_veh_emp e,tb_shft_veh v where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1' and e.status='1'");
			if ($sql->num_rows() > 0) {
				$date=date("Y-m-d H:i:s");
				$this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='".$date."' where e.shft_veh_id=v.id and v.shft_id=".$shft." and e.emp_id=".$eid." and v.status='1' and e.status='1'");
				$sql1 = "select id from tb_shft_veh_emp where shft_veh_id=$id and emp_id='" . $eid . "' and user_id=$user";
				$veh = $this->db->query($sql1);
				if ($veh->num_rows() > 0) {
					$data = array('status' => 1, "updated_on" => date("Y-m-d H:i:s"));
					$this->db->where(array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid));
					$this->db->update('tb_shft_veh_emp', $data);
				} else {
					$data = array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid, 'status' => 1, "updated_on" => date("Y-m-d H:i:s"));
					$this->empmodel->addtable('tb_shft_veh_emp', $data);
				}
			} else {
				$data = array('user_id' => $user, 'shft_veh_id' => $id, 'emp_id' => $eid, 'status' => 1, "updated_on" => date("Y-m-d H:i:s"));
				$this->empmodel->addtable('tb_shft_veh_emp', $data);
			}
		}
	}
	public function savedata() {
		if ($_POST) {
			$data = $_POST;
			foreach($data as $d){
				$em=getEmployee($d['C']);
				$emp=$em->id;
				$veh=getVehicle($d['B']);
				$svid=$this->getshftvehid($d['A'], $d['B']);
				if($svid!=""&&$veh!=""&&$em!=""){
					$this->add2shftvahemp($d['A'],$svid, $emp, "true");
					$this->chagepriprity($svid,$emp,$d['D']);
				}
			}
		}
		echo '1';
	}
	public function upload(){
		$data = array();
		$data["status"] = "";
		if ($_FILES["file"]["error"] == 4) {
			$this->session->set_flashdata('error_msg', "Please Select File before Submitting.");
		} else if ($_FILES) {
			$file = $_FILES['file'];
			//load the excel library
			$ext = pathinfo($file["name"], PATHINFO_EXTENSION);
			if ($ext == "xls" || $ext == "xlsx") {
				$this->load->library('excel');
				//read file from path
				try {
					$objPHPExcel = @PHPExcel_IOFactory::load($file["tmp_name"]);
					//get only the Cell Collection
					$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
					//extract to a PHP readable array format
					if (count($objPHPExcel->setActiveSheetIndex(0)->toArray()[0]) == "11") {
						$data["arr_data"]=array();
						foreach ($cell_collection as $cell) {
							$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
							$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
							$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
							//header will/should be in row 1 only.
							if ($row == 1) {
								$data["header"][$row][$column] = $data_value;
							} else {
								$data["arr_data"][$row][$column] = $data_value;
							}
						}
						$this->parse($data["arr_data"]);
					} else {
						$this->session->set_flashdata('error_msg', "Uploaded File contains invalid data, Please choose appropiate File.");
					}
				} catch (Exception $ex) {
					$this->session->set_flashdata('error_msg', "Some Problem occured!, Please Try Again Later.");
				}

			} else {
				$this->session->set_flashdata('error_msg', "Uploaded File is in not valid Format, Please choose appropiate File.");
			}
		}

		redirect("employee");
	}
	function parse($data){
		$i=0;
		if(count($data)>0){
			foreach($data as $d){
				$user = $this->session->userdata('user_id');
				$chkqry = $this->db->select("id")->get_where("tb_employee",array("phone"=>$d['C']),1,0);
				if($chkqry->num_rows() == 0){
					$this->db->query("INSERT INTO `tb_employee` VALUES ('', '".$d['B']."', '".$d['D']."', '".@$d['E']."', '".@$d['F']."', '".$d['G']."', '".@$d['H']."', '".@$d['I']."', '".$d['A']."', '".$d['C']."', '".$d['J']."', '".@$d['K']."', ".$user.", RandomString::generate(10), '1','',NOW())");
				}else{
					$this->db->query("UPDATE `tb_employee` SET assoc_id='".$d['B']."',pickup='".$d['D']."',drop='".$d['G']."',name='".$d['A']."',status=1 WHERE id='".$chkqry->row()->id."'");
				}
				$i++;
			}
			if(count($data)==$i)
				$this->session->set_flashdata('success_msg', "All Shipments are added sucessfully!");
			else
				$this->session->set_flashdata('success_msg', "$i Shipment are added!,Please Check them once.");
		}else{
			$this->session->set_flashdata('success_msg', "No data found in the file.");
		}
	}

	public function addsoscontact($empid)
	{
		$data = array();
		$data['page_title'] = 'Shipment SOS Contacts';
		$data['sub_title'] = 'Shipment SOS Contacts';
		$data['btnsub'] = "Add";
		$data['contactper'] = "";
		$data['contactnum'] = "";
		$data['contactper2'] = "";
		$data['contactnum2'] = "";
		$data['contactper3'] = "";
		$data['contactnum3'] = "";
		$data['emp_id'] = $empid;
		if($empid != "")
		{
			$data['btnsub'] = "Update";
			$empdata = $this->db->select('*')->get_where('tb_emp_sos_contacts',array('emp_id'=>$empid),1,0);
			if($empdata->num_rows() > 0){
				$empdata = $empdata->row();
				$data['contactper'] = $empdata->contact_name1;
				$data['contactnum'] = $empdata->contact_num1;
				$data['contactper2'] = $empdata->contact_name2;
				$data['contactnum2'] = $empdata->contact_num2;
				$data['contactper3'] = $empdata->contact_name3;
				$data['contactnum3'] = $empdata->contact_num3;
				$data['emp_id'] = $empdata->emp_id;
			}
		}
		$this->settemplate->dashboard('empsoscontact',$data);
	}

	public function storesoscontact($id = NULL)
	{
		$data = array();
		$dt = date('Y-m-d H:i:s');
		$input = $_POST;
		$data['emp_id'] = $id;
		$data['contact_num1'] = $input['contactnumber'];
		$data['contact_name1'] = $input['contactperson'];
		$data['contact_num2'] = $input['contactnumber2'];
		$data['contact_name2'] = $input['contactperson2'];
		$data['contact_num3'] = $input['contactnumber3'];
		$data['contact_name3'] = $input['contactperson3'];
		$data['status'] = 1;
		$data['updatedon'] = $dt;
		if(isset($_POST['admininsert']) && $_POST['admininsert'] == "Submit")
		{
			$checkemp = $this->db->select('id')->get_where("tb_emp_sos_contacts",array("emp_id"=>$id),1,0);
			if($checkemp->num_rows() == 0){
				$data['createdon'] = $dt;
				$this->db->insert("tb_emp_sos_contacts",$data);
				$res = $this->db->insert_id();
				$succ = "Added Successfully!";
				$this->session->set_flashdata('success_msg', $succ);
			}else{
				$sid = $checkemp->row()->id;
				$whr = array('id'=>$sid);
				$this->db->set($data)->where($whr)->update("tb_emp_sos_contacts");
				$succ = "Updated Successfully!";
				$this->session->set_flashdata('success_msg', $succ);
			}
		}
		redirect('employee');
	}
	function deletesve(){
		if($_POST){
			$shift=$_POST["shft"];
			$veh=$_POST["veh"];
			$route_id=$_POST["route_id"];
			$this->db->where(array("shft_id"=>$shift,"status"=>'1',"route_id"=>$route_id,"register_number"=>$veh))->update("tb_shft_veh",array("updated_on"=>date("Y-m-d H:i:s"),"status"=>'0'));
		}
	}

	function getstophistory($id){
		$res = $result = array();
		$whr = array('s.stop_id'=>$id);
		$this->db->select('s.id,s.createdon,t.status_name');
		$this->db->from('tb_stop_status s');
		$this->db->join('tb_status_master t','s.status_id=t.id','INNER');
		$this->db->where($whr);
		$this->db->order_by('s.createdon','DESC');
		$chkrecent = $this->db->get();
		if($chkrecent->num_rows() > 0){
			foreach ($chkrecent->result() as $re) {
				$result[] = array('name'=>$re->status_name,'id'=>$re->id,'createdon'=>$re->createdon);
			}
		}
		$res['data'] = $result;
		echo $this->load->view("stop_history", $res,TRUE);
	}
}
