<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Etnuserauth extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        $this->load->model('common');
        $this->load->helper('auth');
    }

    public function createUser()
    {

        $post = file_get_contents('php://input');
        $data                   = array("status" => 200, "message" => "Success");
        $input                  = json_decode($post);
        $roleName               = $input->user->roleName;
        $password               = $input->password;
        $referenceNo            = $input->referenceNo;
        $area                   = $input->user->area;
        $lastName               = $input->user->lastName;
        $country                = $input->user->country;
        $countryOfIncorporation = $input->user->countryOfIncorporation;
        $firstName              = $input->user->firstName;
        $phoneNumber            = $input->user->phoneNumber;
        $id                     = $input->user->id;
        $email                  = $input->user->email;
        $registrationNumber     = $input->user->organization->registrationNumber;
        $companyName            = $input->user->organization->companyName;
        $companyid              = $input->user->organization->id;
        $user                   = $this->getCountry($country);
        //auth_helper.php
        $password               = decryptAES256($password);
        if ($user != null) {
            if ($roleName == "ROLE_KNS") {
                $partyId  = $this->createParty($user, $input);
                $customer = array("partner_id" => 0, "name" => implode(" ", [$firstName, $lastName]), "phone" => $referenceNo, "code" => $referenceNo, "country" => $user['country_code'], "state" => "", "street" => "", "location" => $area, "pincode" => "", "address" => "", "fax" => null, "img" => null, "email_id" => $email, "password" => password_hash($password, PASSWORD_DEFAULT), "user_id" => $user['id'], "status" => 0, "gcm_id" => null, "imei" => null, "cid" => null, "parent_id" => 0, "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "involved_party" => 0, "kn_login" => 0, "online" => 0, "Tarifftype" => 0, "sendto_knlogin" => 0, "quote_module_id" => $id, 'partyid' => $partyId, 'createdon' => date('Y-m-d H:i:s'));
                $this->db->insert("tb_customers", $customer);
                $data = array("status" => 200, "message" => "Success");
            } else if ($roleName == "ROLE_KNC") {
                $partyId = $this->createParty($user, $input);
                $vendor  = array("name" => implode(" ", [$firstName, $lastName]), "mobile" => $referenceNo, "location" => $area, "address" => "", "pincode" => "", "country" => $user['country_code'], "password" => password_hash($password, PASSWORD_DEFAULT), "email" => $email, "code" => $referenceNo, "offering_type" => "", "carrier_grade" => "", "effective_date" => null, "expiry_date" => null, "service_id" => null, "service_name" => null, "fcm_token" => null, "user_id" => $user['id'], "custid" => null, "partyid" => $partyId, "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "company_name" => null, "online" => 0, "auto_accept" => 0, "quote_module_id" => $id, "status" => 0, 'created_on' => date('Y-m-d H:i:s'));
                $this->db->insert("tb_vendors", $vendor);
                $data = array("status" => 200, "message" => "Success");
            } else if ($roleName == "ROLE_KNA") {
                $data = $this->createAdmin($user, $input);
            }
        } else if ($roleName == "ROLE_KNA") {
            $data = $this->createAdmin($user, $input);
        } else {
            $data = array("status" => 400, "message" => "User admin not found in TMS!");
        }
        echo json_encode($data);
    }
    public function createParty($user, $input)
    {
        $roleName               = $input->user->roleName;
        $password               = $input->password;
        $referenceNo            = $input->referenceNo;
        $area                   = $input->user->area;
        $lastName               = $input->user->lastName;
        $country                = $input->user->country;
        $countryOfIncorporation = $input->user->countryOfIncorporation;
        $firstName              = $input->user->firstName;
        $phoneNumber            = $input->user->phoneNumber;
        $id                     = $input->user->id;
        $email                  = $input->user->email;
        $registrationNumber     = $input->user->organization->registrationNumber;
        $companyName            = $input->user->organization->companyName;
        $companyid              = $input->user->organization->id;
        //auth_helper.php
        $password               = decryptAES256($password);
        $party                  = array(
            "name"               => implode(" ", [$firstName, $lastName]),
            "email"              => $email,
            "mobile"             => $referenceNo,
            "user_id"            => $user['id'],
            "code"               => $referenceNo,
            "partyindetifier"    => $referenceNo,
            "customeridentifier" => $referenceNo,
            "company_code"       => $user['company_code'],
            "branch_code"        => $user['branch_code'],
            "address"            => $area,
            "country"            => $countryOfIncorporation,
            "state"              => null,
            "street"             => $area,
            "pincode"            => "",
            "street_2"           => null,
            "street_3"           => null,
            "building"           => null,
            "house_number"       => null,
            "status"             => 1,
            'created_on'         => date('Y-m-d H:i:s'),
        );
        if ($roleName == "ROLE_KNS") {
            $parties = $this->db->where(array("name" => "Shipper", "user_id" => $user['id'], "status" => "1"))->get("tbl_party_types");
            if ($parties->num_rows() > 0) {
                $partyTypeId            = $parties->row()->id;
                $party['party_type_id'] = $partyTypeId;
            } else {
                $this->db->insert("tbl_party_types", array("name" => "Shipper", "user_id" => $user['id'], "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "status" => "1", 'created_on' => date('Y-m-d H:i:s')));
                $partyTypeId            = $this->db->insert_id();
                $party['party_type_id'] = $partyTypeId;
            }
            $this->db->insert("tbl_party_master", $party);
            return $this->db->insert_id();
        } else if ($roleName == "ROLE_KNC") {
            $parties = $this->db->where(array("name" => "Carrier", "user_id" => $user['id'], "status" => "1"))->get("tbl_party_types");
            if ($parties->num_rows() > 0) {
                $partyTypeId            = $parties->row()->id;
                $party['party_type_id'] = $partyTypeId;
            } else {
                $this->db->insert("tbl_party_types", array("name" => "Carrier", "user_id" => $user['id'], "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "status" => "1", 'created_on' => date('Y-m-d H:i:s')));
                $partyTypeId            = $this->db->insert_id();
                $party['party_type_id'] = $partyTypeId;
            }
            $this->db->insert("tbl_party_master", $party);
            return $this->db->insert_id();
        }
        return null;
    }
    public function updateParty($user, $input, $partyId)
    {
        $roleName               = $input->user->roleName;
        $lastName               = $input->user->lastName;
        $country                = $input->user->country;
        $billingAddressLine1    = $input->user->billingAddressLine1;
        $billingAddressLine2    = $input->user->billingAddressLine2;
        $companyName            = $input->user->companyName;
        $password               = $input->user->password;
        $billingCountry         = $input->user->billingCountry;
        $id                     = $input->user->id;
        $email                  = $input->user->email;
        $area                   = $input->user->area;
        $active                 = $input->user->active;
        $countryOfIncorporation = $input->user->countryOfIncorporation;
        $genericRates           = $input->user->genericRates;
        $firstName              = $input->user->firstName;
        $phoneNumber            = $input->user->phoneNumber;
        $billingPostalCode      = $input->user->billingPostalCode;
        $roleName               = $input->user->roleName;
        $billingCity            = $input->user->billingCity;
        $registrationNumber     = $input->user->organization->registrationNumber;
        $companyName            = $input->user->organization->companyName;
        $companyid              = $input->user->organization->id;
        //auth_helper.php
        $password               = decryptAES256($password);
        $party                  = array(
            "name"         => implode(" ", [$firstName, $lastName]),
            "email"        => $email,
            "mobile"       => $phoneNumber,
            "user_id"      => $user['id'],
            "company_code" => $user['company_code'],
            "branch_code"  => $user['branch_code'],
            "address"      => $area,
            "country"      => $countryOfIncorporation,
            "state"        => null,
            "street"       => $area,
            "pincode"      => $billingPostalCode,
            "street_2"     => $billingAddressLine1,
            "street_3"     => $billingAddressLine2,
            "building"     => null,
            "house_number" => null,
            "status"       => 1,
        );
        if ($roleName == "ROLE_KNS") {
            $parties = $this->db->where(array("name" => "Shipper", "user_id" => $user['id'], "status" => "1"))->get("tbl_party_types");
            if ($parties->num_rows() > 0) {
                $partyTypeId            = $parties->row()->id;
                $party['party_type_id'] = $partyTypeId;
            } else {
                $this->db->insert("tbl_party_types", array("name" => "Shipper", "user_id" => $user['id'], "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "status" => "1", 'created_on' => date('Y-m-d H:i:s')));
                $partyTypeId            = $this->db->insert_id();
                $party['party_type_id'] = $partyTypeId;
            }
            $this->db->where("id", $partyId)->update("tbl_party_master", $party);
        } else if ($roleName == "ROLE_KNC") {
            $parties = $this->db->where(array("name" => "Carrier", "user_id" => $user['id'], "status" => "1"))->get("tbl_party_types");
            if ($parties->num_rows() > 0) {
                $partyTypeId            = $parties->row()->id;
                $party['party_type_id'] = $partyTypeId;
            } else {
                $this->db->insert("tbl_party_types", array("name" => "Carrier", "user_id" => $user['id'], "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "status" => "1", 'created_on' => date('Y-m-d H:i:s')));
                $partyTypeId            = $this->db->insert_id();
                $party['party_type_id'] = $partyTypeId;
            }
            $this->db->where("id", $partyId)->update("tbl_party_master", $party);
        }
    }
    public function createAdmin($user, $input)
    {
        $firstName   = $input->user->firstName;
        $lastName    = $input->user->lastName;
        $password    = $input->password;
        $branch_code = $input->branchCode;
        $referenceNo = $input->referenceNo;
        $email       = $input->user->email;
        $area        = $input->user->area;
        $id          = $input->user->id;
        $countryCode = $input->user->country;
        $countryCode = $input->user->country;
        //auth_helper.php
        $password    = decryptAES256($password);
        $data        = array("status" => 400, "message" => "Failed!");
        if ($user != null) {
            $user_login = array("user_id" => $user['id'], "name" => implode(" ", [$firstName, $lastName]), "mobile_no" => $referenceNo, "business_type" => "Quote Module Admin", "emailid" => $email, "password" => password_hash($password, PASSWORD_DEFAULT), "company_code" => $user['company_code'], "branch_code" => $user['branch_code'], "user_code" => "Quote Module Admin", "attorney_number" => null, "attorney_date" => null, "signpath" => null, "quote_module_id" => null, "status" => 0, "quote_module_id" => $id, 'created_at' => date('Y-m-d H:i:s'));
            $this->db->insert("tb_user_logins", $user_login);
            $data = array("status" => 200, "message" => "Success!");
        } else {
            $countries = $this->db->select("id,country_name,country_code,currency")->where(array("phone_code" => $countryCode, 'status' => '1'))->get("tbl_country_master");
            if ($countries->num_rows() > 0) {
                $country      = $countries->row_array();
                $company_code = $country['country_code'] . "SVK";
                $users        = $this->db->select("id")->where(array("country_code" => $country['country_code'], 'status' => 'Active'))->get("tb_users");
                $insertId     = null;
                if ($users->num_rows() > 0) {
                    $insertId = $users->row()->id;

                    $user_login = array("user_id" => $insertId, "name" => implode(" ", [$firstName, $lastName]), "mobile_no" => $referenceNo, "business_type" => "Quote Module Admin", "emailid" => $email, "password" => password_hash($password, PASSWORD_DEFAULT), "company_code" => $company_code, "branch_code" => $branch_code, "user_code" => "Quote Module Admin", "attorney_number" => null, "attorney_date" => null, "signpath" => null, "quote_module_id" => null, "status" => 0, "quote_module_id" => $id, 'created_at' => date('Y-m-d H:i:s'));
                    $this->db->insert("tb_user_logins", $user_login);
                } else {
                    $tb_user = array("country_code" => $country['country_code'], "name" => implode(" ", [$firstName, $lastName]), "business_type" => "Truck_Owner", "mobile_no" => $referenceNo, "password" => password_hash($password, PASSWORD_DEFAULT), "emailid" => $email, "map_type" => 0, "status_datetime_type" => null, "domain_name" => $branch_code, "location_id" => "1646", "company_indv_name" => $country_code, "gcm_id" => null, "address" => $area, "head_office" => null, "gstin" => null, "usr_country" => $country['id'], "crm_id" => null, "parent_id" => 0, "company_code" => $company_code, "branch_code" => "AUWA", "alternate_number" => null, "carrier_mail_template" => null, "customer_mail_template" => null, "default_currency" => $country['currency'], "online" => 0, "alternate_mails" => null, "cc_mails" => null, "createdby" => 1, "attorney_number" => null, "attorney_date" => null, "signpath" => null, "quote_module_id" => $id, "status" => "Inactive", 'createdon' => date('Y-m-d H:i:s'));
                    $this->db->insert("tb_users", $tb_user);
                    $insertId = $this->db->insert_id();
                }
                if ($insertId != null) {

                    $countryAdmins  = $this->db->where(array("country_code" => $country['country_code'], "status" => "1"))->get("tb_admin_users");
                    $countryAdminId = null;
                    if ($countryAdmins->num_rows() > 0) {
                        $countryAdminId = $countryAdmins->row()->id;
                    } else {
                        $adminUser = array("name" => implode(" ", [$firstName, $lastName]), "business_type" => "Country Admin", "company_code" => $company_code, "company_indv_name" => "Kuehne + Nagel", "mobile_no" => $referenceNo, "password" => password_hash($password, PASSWORD_DEFAULT), "emailid" => $email, "country_code" => $country['country_code'], "quote_module_id" => $id, 'createdon' => date('Y-m-d H:i:s'));
                        $this->db->insert("tb_admin_users", $adminUser);
                        $countryAdminId = $this->db->insert_id();
                    }
                    if ($countryAdminId != null) {
                        $mappings = $this->db->where(array("admin_user_id" => $countryAdminId, "user_id" => $insertId))->get("tb_user_mappings");
                        if ($mappings->num_rows() > 0) {
                            $mappingId = $mappings->row()->id;
                            $this->db->where(array("id" => $mappingId))->update("tb_user_mappings", array("status" => "1"));
                        } else {
                            $mapping = array("admin_user_id" => $countryAdminId, "user_id" => $insertId, 'created_on' => date('Y-m-d H:i:s'));
                            $this->db->insert("tb_user_mappings", $mapping);
                        }
                    }
                }
                $data = array("status" => 200, "message" => "Success!");
            } else {
                $data = array("status" => 400, "message" => "Country code not available in TMS!");
            }
        }
        return $data;
    }

    public function updateUser()
    {

        $post = file_get_contents('php://input');
        $data                   = array("status" => 400, "message" => "User not avaialble to update!");
        $input                  = json_decode($post);
        $roleName               = $input->user->roleName;
        $lastName               = $input->user->lastName;
        $country                = $input->user->country;
        $billingAddressLine1    = $input->user->billingAddressLine1;
        $billingAddressLine2    = $input->user->billingAddressLine2;
        $companyName            = $input->user->companyName;
        $password               = $input->user->password;
        $billingCountry         = $input->user->billingCountry;
        $id                     = $input->user->id;
        $email                  = $input->user->email;
        $area                   = $input->user->area;
        $active                 = $input->user->active;
        $countryOfIncorporation = $input->user->countryOfIncorporation;
        $genericRates           = $input->user->genericRates;
        $firstName              = $input->user->firstName;
        $phoneNumber            = $input->user->phoneNumber;
        $billingPostalCode      = $input->user->billingPostalCode;
        $roleName               = $input->user->roleName;
        $billingCity            = $input->user->billingCity;
        $registrationNumber     = $input->user->organization->registrationNumber;
        $companyName            = $input->user->organization->companyName;
        $companyid              = $input->user->organization->id;
        //auth_helper.php
        $password               = decryptAES256($password);
        $user                   = $this->getCountry($country);
        if ($user != null) {
            if ($roleName == "ROLE_KNS") {
                $customer = array("partner_id" => 0, "name" => implode(" ", [$firstName, $lastName]), "state" => "", "street" => $billingAddressLine1, "location" => $area, "pincode" => $billingPostalCode, "address" => implode(", ", [$billingAddressLine1, $billingCity, $countryOfIncorporation]), "email_id" => $email);
                $this->db->where("quote_module_id", $id)->update("tb_customers", $customer);
                $customer = $this->db->where("quote_module_id", $id)->get("tb_customers")->row();
                $this->updateParty($user, $input, $customer->partyid);
                $data = array("status" => 200, "message" => "Success");
            } else if ($roleName == "ROLE_KNC") {
                $vendor = array("name" => implode(" ", [$firstName, $lastName]), "location" => $area, "address" => implode(", ", [$billingAddressLine1, $billingCity, $countryOfIncorporation]), "pincode" => $billingPostalCode, "email" => $email);
                $this->db->where("quote_module_id", $id)->update("tb_vendors", $vendor);
                $customer = $this->db->where("quote_module_id", $id)->get("tb_vendors")->row();
                $this->updateParty($user, $input, $customer->partyid);
                $data = array("status" => 200, "message" => "Success");
            } else if ($roleName == "ROLE_KNA") {
                $data       = array("status" => 400, "message" => "Admin not avaialble to update!");
                $adminUsers = $this->db->where(array("quote_module_id" => $id))->get("tb_admin_users");
                if ($adminUsers->num_rows() > 0) {
                    $adminUser = array("name" => implode(" ", [$firstName, $lastName]), "business_type" => "Country Admin", "company_code" => $company_code, "company_indv_name" => "Kuehne + Nagel", "emailid" => $email);
                    $this->db->where(array("quote_module_id" => $id))->update("tb_admin_users", $adminUser);
                }
                $users = $this->db->where(array("quote_module_id" => $id))->get("tb_users");
                if ($users->num_rows() > 0) {
                    $tb_user = array("country_code" => $country->country_code, "name" => implode(" ", [$firstName, $lastName]), "business_type" => "Truck_Owner", "emailid" => $email, "address" => implode(", ", [$billingAddressLine1, $billingCity, $countryOfIncorporation, $billingPostalCode]));
                    $this->db->where(array("quote_module_id" => $id))->update("tb_users", $tb_user);
                    $data = array("status" => 200, "message" => "Success");
                }
                $userLogins = $this->db->where(array("quote_module_id" => $id))->get("tb_user_logins");
                if ($userLogins->num_rows() > 0) {
                    $user_login = array("name" => implode(" ", [$firstName, $lastName]), "emailid" => $email);
                    $this->db->where(array("quote_module_id" => $id))->update("tb_user_logins", $user_login);
                    $data = array("status" => 200, "message" => "Success");
                }
            }
        }
        echo json_encode($data);
    }

    public function activateUser()
    {

        $post = file_get_contents('php://input');
        $input       = json_decode($post);
        $countryCode = $input->countryCode;
        $userId      = $input->userId;
        $roleName    = $input->roleName;
        $data        = array("status" => 400, "message" => "User not avaialble to activate!");
        if ($roleName == "ROLE_KNS") {
            $customer = array("status" => '1');
            $this->db->where("quote_module_id", $userId)->update("tb_customers", $customer);
            $data = array("status" => 200, "message" => "Success");
        } else if ($roleName == "ROLE_KNC") {
            $vendor = array("status" => '1');
            $this->db->where("quote_module_id", $userId)->update("tb_vendors", $vendor);
            $data = array("status" => 200, "message" => "Success");
        } else if ($roleName == "ROLE_KNA") {
            $data  = array("status" => 400, "message" => "Admin not avaialble to activate!");
            $users = $this->db->where(array("quote_module_id" => $userId))->get("tb_users");
            if ($users->num_rows() > 0) {
                $tb_user = array("status" => 'Active');
                $this->db->where(array("quote_module_id" => $id))->update("tb_users", $tb_user);
                $data = array("status" => 200, "message" => "Success");
            }
            $userLogins = $this->db->where(array("quote_module_id" => $userId))->get("tb_user_logins");
            if ($userLogins->num_rows() > 0) {
                $user_login = array("status" => '1');
                $this->db->where(array("quote_module_id" => $userId))->update("tb_user_logins", $user_login);
                $data = array("status" => 200, "message" => "Success");
            }
        }
        echo json_encode($data);
    }

    public function updatePassword()
    {

        $post = file_get_contents('php://input');
        $input       = json_decode($post);
        $countryCode = $input->countryCode;
        $id          = $input->userId;
        $password    = $input->newPassword;
        $roleName    = $input->roleName;
        //auth_helper.php
        $password    = decryptAES256($password);
        $data        = array("status" => 400, "message" => "User not avaialble to update password!");
        if ($roleName == "ROLE_KNS") {
            $customer = ["password" => password_hash($password, PASSWORD_DEFAULT)];
            $this->db->where("quote_module_id", $id)->update("tb_customers", $customer);
            $data = array("status" => 200, "message" => "Success");
        } else if ($roleName == "ROLE_KNC") {
            $vendor = ["password" => password_hash($password, PASSWORD_DEFAULT)];
            $this->db->where("quote_module_id", $id)->update("tb_vendors", $vendor);
            $data = array("status" => 200, "message" => "Success");
        } else if ($roleName == "ROLE_KNA") {
            $data  = array("status" => 400, "message" => "Admin not avaialble to update password!");
            $users = $this->db->where(array("quote_module_id" => $id))->get("tb_users");
            if ($users->num_rows() > 0) {
                $tb_user = ["password" => password_hash($password, PASSWORD_DEFAULT)];
                $this->db->where(array("quote_module_id" => $id))->update("tb_users", $tb_user);
                $data = array("status" => 200, "message" => "Success");
            }
            $userLogins = $this->db->where(array("quote_module_id" => $id))->get("tb_user_logins");
            if ($userLogins->num_rows() > 0) {
                $user_login = ["password" => password_hash($password, PASSWORD_DEFAULT)];
                $this->db->where(array("quote_module_id" => $id))->update("tb_user_logins", $user_login);
                $data = array("status" => 200, "message" => "Success");
            }
        }
        echo json_encode($data);
    }

    public function getCountry($countryCode)
    {
        $countries = $this->db->select("id,country_name,country_code,currency")->where(array("phone_code" => $countryCode, 'status' => '1'))->get("tbl_country_master");
        $user      = null;
        if ($countries->num_rows() > 0) {
            $country = $countries->row_array();
            $users   = $this->db->select("id,country_code,company_code,branch_code")->where(array("country_code" => $country['country_code'], 'status' => 'Active', 'quote_module_id !=' => null))->get("tb_users");
            if ($users->num_rows() > 0) {
                $user             = $users->row_array();
                $user['currency'] = $country['currency'];
                $user['table']    = "tb_users";
            } else {
                $users          = $this->db->select("id,country_code,company_code,branch_code")->where(array("country_code" => $country['country_code'], 'status' => 'Active'))->get("tb_users");
                $countryUserIds = [];
                foreach ($users->result() as $row) {
                    $countryUserIds[] = $row->id;
                }
                $userLogins = $this->db->select("id,user_id,company_code,branch_code")->where(array('quote_module_id !=' => null, 'status' => '1'))->where_in('user_id', $countryUserIds)->get("tb_user_logins");
                if ($userLogins->num_rows() > 0) {
                    $userLogin            = $userLogins->row_array();
                    $user['id']           = $userLogin['user_id'];
                    $user['company_code'] = $userLogin['company_code'];
                    $user['branch_code']  = $userLogin['branch_code'];
                    $user['country_code'] = $country['country_code'];
                    $user['currency']     = $country['currency'];
                    $user['table']        = "tb_user_logins";
                } else {
                    if ($users->num_rows() > 0) {
                        $user             = $users->row_array();
                        $user['currency'] = $country['currency'];
                        $user['table']    = "tb_users";
                    }
                }
            }
        }
        return $user;
    }
}
