<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\ApiRequest\DataPreprocessing\BadRequestException;
use Zebra\Client;
use Zebra\Zpl\Builder;
use Zebra\Zpl\GdDecoder;
use Zebra\Zpl\Image;

class Etnxdocapiv1 extends CI_Controller
{
    public function __construct()
    {
        header('Content-Type: application/json');
        parent::__construct();
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $this->load->model('common');
        $this->load->helper('log_helper');
    }

    public function index()
    {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }

    /* user login */
    public function login()
    {
        $data = [
            'status' => '0'
        ];
        $response = [];
        $msg = "Please enter login details";
        if (isset($_POST)) {
            $post = $this->input->post();
            $mobile_no = $post['mobile_no'] ?? "";
            $password = $post['password'] ?? "";
            $password = decryptAES256($password);
            if (!in_array("", [$mobile_no, $response])) {
                $allUsersData = $this->common->gettbldata("mobile_no ='" . $mobile_no . "' AND mobile_no != 'appadmin' AND status ='Active'", "id,country_code,password,company_indv_name,business_type,company_code,branch_code,map_type", "tb_users", 0, 0);
                foreach ($allUsersData as $eachRow) {
                    $usersData[$eachRow['id']] = $eachRow;
                }
                $userRowId = $this->checkUserPassword($password, $allUsersData);
                if ($userRowId > 0) {
                    $userData = $usersData[$userRowId];
                    $cmpcode = $userData['company_code'];
                    $response = [
                        'user_id' => $userData['id'],
                        'name' => $userData['company_indv_name'],
                        'company_code' => $userData['company_code'],
                        'branch_code' => $userData['branch_code'],
                        'country_code' => substr($cmpcode, 0, 2)
                    ];
                    $msg = "Login Success";
                    $data = [
                        'status' => '1',
                        'data' => $response,
                        'message' => $msg
                    ];
                } else {
                    if ($mobile_no != "Caitlin.Cooney") {
                        $user = $this->db->query(
                            "SELECT u.id,u.country_code,u.company_indv_name,u.business_type,u.company_code,u.branch_code,u.map_type,l.id as childid FROM tb_users u,tb_user_logins l WHERE u.id=l.user_id AND (l.emailid='" . $mobile_no . "' OR l.mobile_no='" . $mobile_no . "') AND l.password='" . $password . "' AND u.status='Active' AND l.status=1 LIMIT 1"
                        );
                        $allUsersData = $this->common->getjointbldata(
                            "tb_users u",
                            "tb_user_logins l",
                            "u.id = l.user_id",
                            "( l.emailid='" . $mobile_no . "' OR l.mobile_no='" . $mobile_no . "' ) AND u.status ='Active' AND l.status =1",
                            "u.id,u.country_code,u.company_indv_name,u.business_type,u.company_code,u.branch_code,u.map_type,l.id as childid,l.password",
                            0,
                            0
                        );
                        foreach ($allUsersData as $eachRow) {
                            $usersData[$eachRow['id']] = $eachRow;
                        }
                        $userRowId = $this->checkUserPassword($password, $allUsersData);
                        if ($userRowId > 0) {
                            $userData = $usersData[$userRowId];
                            $cmpcode = $usersData['country_code'];
                            $response = [
                                'user_id' => $usersData['id'],
                                'name' => $usersData['company_indv_name'],
                                'company_code' => $usersData['company_code'],
                                'branch_code' => $usersData['branch_code'],
                                'country_code' => $cmpcode
                            ];
                            $msg = "Login Success";
                            $data = [
                                'status' => '1',
                                'data' => $response,
                                'message' => $msg
                            ];
                        } else {
                            $msg = "User doesn't exist";
                            $data = [
                                'status' => '0',
                                'message' => $msg
                            ];
                        }
                    }
                }
            } else {
                $data = [
                    'status' => '0',
                    'message' => "Mobile number or password cannot be empty!"
                ];
            }
        } else {
            $data = [
                'status' => '0',
                'message' => "No input data received!"
            ];
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    private function checkUserPassword(string $password, array $userData): int
    {
        if(empty($userData)){
            return 0;
        }
        foreach ($userData as $eachRow) {
            $rowId = $eachRow['id'];
            $encryptedPassword = $eachRow['password'];
            if (password_verify($password, $encryptedPassword)) {
                return $rowId;
            }
        }
        return 0;
    }

    /* home screen orders list */
    public function getorderdetailsfromamzedi()
    {
        if (isset($_POST)) {
            $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "UKKN";
            if ($company_code == "UKKN") {
                $response = $this->ordersForUK($_POST);
            } else {
                $response = $this->ordersForAU($_POST);
            }
        }
        $response = $this->printable($response);
        echo json_encode($response);
    }

    public function ordersForAU($post)
    {
        $data = $order_details = array();
        $response = array(
            "status" => 0,
            "data" => $data
        );
        $total_quantity = $total_volume = $total_weight = 0;
        $user_id = isset($post['user_id']) ? $post['user_id'] : 0;
        $search_text = isset($post['search_text']) ? $post['search_text'] : "";
        if ($user_id != "" && $user_id != '0') {
            $orderids = array();
            if ($search_text != "") {
                $where = " reference_id='CTR' AND ref_value LIKE '%" . $search_text . "%' AND status=1 ";
                $searchorder = $this->common->gettbldata($where, "order_id", "tb_order_references", 0, 0);
                if (count($searchorder) > 0) {
                    foreach ($searchorder as $sr) {
                        $orderids[] = $sr['order_id'];
                    }
                } else {
                    $where = " order_id LIKE '%" . $search_text . "%' AND user_id=$user_id AND trip_sts=0 AND parent_id='0' AND status!=0 ";
                    $searchorder1 = $this->common->gettbldata($where, "id", "tb_orders", 0, 0);
                    if (count($searchorder1) > 0) {
                        foreach ($searchorder1 as $sr1) {
                            $orderids[] = $sr1['id'];
                        }
                    }
                }
            }
            $queryBuilder = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,sum(o.quantity) as quantity,sum(o.weight) as weight,sum(o.volume) as volume,oref.ref_value FROM tb_orders o
JOIN tb_order_references oref ON oref.order_id = o.id AND oref.reference_id = 'CTR'
WHERE o.parent_id=0 AND o.user_id = %s AND o.status <> 0 AND o.trip_sts = 0 %s
GROUP BY oref.ref_value";
            $query = "";
            if (!empty($orderids)) {
                $order_ids = implode(",", $orderids);
                $query = sprintf($queryBuilder, $user_id, "AND o.id IN ($order_ids)");
            } else {
                $query = sprintf($queryBuilder, $user_id, "");
            }
            $getorderdetails = $this->db->query($query)->result_array();
            if (!empty($getorderdetails)) {
                foreach ($getorderdetails as $res) {
                    $total_quantity = $res['quantity'];
                    $total_volume = $res['volume'];
                    $total_weight = $res['weight'];
                    $recent_status = 0;
                    $pickup_date = $res['pickup_datetime'];
                    if ($pickup_date != "") {
                        $pickup_date = strtotime($pickup_date);
                    }
                    $delivery_date = $res['delivery_datetime'];
                    if ($delivery_date != "") {
                        $delivery_date = strtotime($delivery_date);
                    }
                    $container_id = $res['ref_value'];
                    $ordstatus = array();
                    // Commented by dhanu due to currently not using container statuses for AU
                    // $checkStatus = $this->db->query("SELECT id,status_code FROM `tb_order_status` WHERE order_id = '".$res['id']."' AND status = 1 ORDER BY FIELD(status_code,'RY', 'ON', 'ED', 'ER') DESC limit 1");
                    $ordstatus['ARRIVED'] = false;
                    $ordstatus['OPEN'] = false;
                    $ordstatus['CLOSED'] = false;
                    $ordstatus['DEPARTED'] = false;
                    // if($checkStatus->num_rows()>0){
                    // if($checkStatus->row()->status_code == "RY"){
                    // $ordstatus['OPEN'] = true;
                    // }else if($checkStatus->row()->status_code == "ON"){
                    // $ordstatus['CLOSED'] = true;
                    // }else if($checkStatus->row()->status_code == "ED"){
                    // $ordstatus['DEPARTED'] = true;
                    // }else if($checkStatus->row()->status_code == "ER"){

                    // }
                    // }else{
                    // $ordstatus['ARRIVED'] = true;
                    // }
                    $consignee = "";

                    // Commented by dhanu due to currently not using consignee name
                    // $consign = $this->db->query("SELECT m.name FROM tb_order_parties p,tbl_party_master m,tbl_party_types t WHERE p.party_id=m.id AND p.party_type=t.id AND p.order_id='".$res['id']."' AND t.name='Consignee' LIMIT 1");
                    // if($consign->num_rows()>0){
                    // $consignee = $consign->row()->name;
                    // }
                    $order_details[] = array(
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'container_id' => $container_id,
                        'pickup_city' => $res['pickup_city'],
                        'delivery_city' => $res['delivery_city'],
                        'total_quantity' => round($total_quantity),
                        'total_volume' => $total_volume,
                        'total_weight' => $total_weight,
                        'pickup_date' => $pickup_date,
                        'delivery_date' => $delivery_date,
                        'delivery_country' => $res['delivery_country'],
                        'pickup_country' => $res['pickup_country'],
                        'status' => $ordstatus,
                        'consignee_name' => $consignee
                    );
                }
            }
        }
        $response = array(
            "status" => 1,
            "data" => $order_details
        );
        return $response;
    }

    public function ordersForUK($post)
    {
        $data = $order_details = array();
        $response = array(
            "status" => 0,
            "data" => $data
        );
        $total_quantity = $total_volume = $total_weight = 0;
        $user_id = isset($post['user_id']) ? $post['user_id'] : 0;
        $search_text = isset($post['search_text']) ? $post['search_text'] : "";
        if ($user_id != "" && $user_id != '0') {
            $orderids = array();
            if ($search_text != "") {
                $where = " reference_id='CTR' AND ref_value LIKE '%" . $search_text . "%' AND status=1 ";
                $searchorder = $this->common->gettbldata($where, "order_id", "tb_order_references", 0, 0);
                if (count($searchorder) > 0) {
                    foreach ($searchorder as $sr) {
                        $orderids[] = $sr['order_id'];
                    }
                } else {
                    $where = " order_id LIKE '%" . $search_text . "%' AND user_id=$user_id AND trip_sts=0 AND parent_id='0' AND status!=0 ";
                    $searchorder1 = $this->common->gettbldata($where, "id", "tb_orders", 0, 0);
                    if (count($searchorder1) > 0) {
                        foreach ($searchorder1 as $sr1) {
                            $orderids[] = $sr1['id'];
                        }
                    }
                }
            }
            if (!empty($orderids)) {
                $order_ids = implode(",", $orderids);
                $uwhr = " id IN($order_ids) AND user_id=$user_id AND trip_sts=0 AND parent_id='0' AND status!=0 ";
            } else {
                $uwhr = array(
                    'user_id' => $user_id,
                    'status <>' => '0',
                    'trip_sts' => '0',
                    'parent_id' => '0'
                );
            }
            $getorderdetails = $this->common->gettbldata(
                $uwhr,
                'id,order_id,pickup_datetime,delivery_datetime,pickup_country,delivery_country,pickup_city,delivery_city,quantity,weight,volume',
                'tb_orders',
                0,
                0
            );
            if (!empty($getorderdetails)) {
                foreach ($getorderdetails as $res) {
                    $total_quantity = $res['quantity'];
                    $total_volume = $res['volume'];
                    $total_weight = $res['weight'];
                    $recent_status = 0;
                    $pickup_date = $res['pickup_datetime'];
                    if ($pickup_date != "") {
                        $pickup_date = strtotime($pickup_date);
                    }
                    $delivery_date = $res['delivery_datetime'];
                    if ($delivery_date != "") {
                        $delivery_date = strtotime($delivery_date);
                    }
                    $container_id = $res['order_id'];
                    $cnwhr = array(
                        'order_id' => $res['id'],
                        'reference_id' => "CTR",
                        'status' => 1
                    );
                    $containernum = $this->common->gettblrowdata($cnwhr, "ref_value", "tb_order_references", 0, 0);
                    if (count($containernum) > 0) {
                        $container_id = $containernum['ref_value'];
                    }
                    $ordstatus = array();
                    $checkStatus = $this->db->query(
                        "SELECT id,status_code FROM `tb_order_status` WHERE order_id = '" . $res['id'] . "' AND status = 1 ORDER BY FIELD(status_code,'RY', 'ON', 'ED', 'ER') DESC limit 1"
                    );
                    $ordstatus['ARRIVED'] = false;
                    $ordstatus['OPEN'] = false;
                    $ordstatus['CLOSED'] = false;
                    $ordstatus['DEPARTED'] = false;
                    if ($checkStatus->num_rows() > 0) {
                        if ($checkStatus->row()->status_code == "RY") {
                            $ordstatus['OPEN'] = true;
                        } else {
                            if ($checkStatus->row()->status_code == "ON") {
                                $ordstatus['CLOSED'] = true;
                            } else {
                                if ($checkStatus->row()->status_code == "ED") {
                                    $ordstatus['DEPARTED'] = true;
                                } else {
                                    if ($checkStatus->row()->status_code == "ER") {
                                    }
                                }
                            }
                        }
                    } else {
                        $ordstatus['ARRIVED'] = true;
                    }
                    $consignee = "";
                    /*
                     * //Commented by dhanu due to currently not using consignee name
                     * $consign = $this->db->query("SELECT m.name FROM tb_order_parties p,tbl_party_master m,tbl_party_types t WHERE p.party_id=m.id AND p.party_type=t.id AND p.order_id='".$res['id']."' AND t.name='Consignee' LIMIT 1");
                     * if($consign->num_rows()>0){
                     * $consignee = $consign->row()->name;
                     * }
                     */
                    $order_details[] = array(
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'container_id' => $container_id,
                        'pickup_city' => $res['pickup_city'],
                        'delivery_city' => $res['delivery_city'],
                        'total_quantity' => round($total_quantity),
                        'total_volume' => $total_volume,
                        'total_weight' => $total_weight,
                        'pickup_date' => $pickup_date,
                        'delivery_date' => $delivery_date,
                        'delivery_country' => $res['delivery_country'],
                        'pickup_country' => $res['pickup_country'],
                        'status' => $ordstatus,
                        'consignee_name' => $consignee
                    );
                }
            }
        }
        $response = array(
            "status" => 1,
            "data" => $order_details
        );
        return $response;
    }

    /* get cargos by order_id / order_id and pallet_id */
    public function getcargoslist_fromorder()
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cargos = array();
        if (isset($_POST)) {
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : "UKKN";
            $container_id = isset($_POST['container_id']) ? $_POST['container_id'] : "";
            if ($order_id == "") {
                $order_id = 0;
            }
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            if ($pallet_id == "") {
                $pallet_id = 0;
            }
            $summary = array();
            $chksuborders = array();
            $totalqty = $totalscannedqty = $totalsavedpallet = $totalclosedpallet = $totalallowcatedqty = 0;
            if ($order_id != "0") {
                if ($company_code == "UKKN") {
                    $chkparent = $this->common->gettblrowdata(array(
                                                                  "id" => $order_id,
                                                                  "parent_id <>" => 0,
                                                                  "status <>" => 0
                                                              ), "id,parent_id", "tb_orders", 0, 0);
                    if (count($chkparent) > 0) {
                        $order_id = $chkparent['parent_id'];
                    }
                    $whr = " AND oc.order_id ='" . $order_id . "' ";
                    $chksuborders = $this->getsuborders($order_id);
                    if (!empty($chksuborders)) {
                        $whr = " AND oc.order_id IN ($order_id," . implode(',', $chksuborders) . ") ";
                    }
                    $getcargos = $this->db->query(
                        "SElECT oc.id,oc.cargo_id,oc.order_id,oc.quantity,oc.scanned_quantity,oc.quantity_type,oc.qr_code,oc.pallet_name,oc.pallet_close,oc.status,oc.reference_order_num,cd.cargo_type FROM tb_order_cargodetails oc,tb_cargo_details cd WHERE oc.cargo_id=cd.id $whr AND (oc.pallet_name IS NULL OR oc.pallet_name !='') GROUP BY oc.id"
                    );
                } else {
                    $orders = [];
                    // get all order_ids based on container id
                    if (strlen($container_id) > 0) {
                        $query = $this->db->query(
                            "SELECT oref.order_id FROM tb_orders o JOIN tb_order_references oref ON oref.order_id = o.id AND oref.ref_value = '$container_id' AND oref.reference_id='CTR' WHERE o.parent_id=0 AND o.status <> 0 AND o.trip_sts = 0"
                        );
                        if ($query->num_rows() > 0) {
                            foreach ($query->result() as $res) {
                                $orders[] = $res->order_id;
                            }
                        }
                    }
                    // if container_id is coming then get cargoes based on container id only
                    if (count($orders) > 0) {
                        $orderids = implode(",", $orders);
                        $getcargos = $this->db->query(
                            "SElECT oc.id,oc.cargo_id,oc.order_id,oc.quantity,oc.scanned_quantity,oc.quantity_type,oc.pallet_name,oc.pallet_close,oc.qr_code,oc.status,oc.reference_order_num,cd.cargo_type FROM tb_order_cargodetails oc,tb_cargo_details cd WHERE oc.cargo_id=cd.id AND oc.order_id in ($orderids) AND (oc.pallet_name IS NULL OR oc.pallet_name!='') AND oc.status!=0 GROUP BY oc.id"
                        );
                    } else {
                        $getcargos = $this->db->query(
                            "SElECT oc.id,oc.cargo_id,oc.order_id,oc.quantity,oc.scanned_quantity,oc.quantity_type,oc.pallet_name,oc.pallet_close,oc.qr_code,oc.status,oc.reference_order_num,cd.cargo_type FROM tb_order_cargodetails oc,tb_cargo_details cd WHERE oc.cargo_id=cd.id AND oc.order_id ='" . $order_id . "' AND (oc.pallet_name IS NULL OR oc.pallet_name!='') AND oc.status!=0 GROUP BY oc.id"
                        );
                    }
                }
                if ($company_code == "UKKN") {
                    if ($getcargos->num_rows() > 0) {
                        $totalqty = $totalscannedqty = $totalsavedpallet = $totalclosedpallet = $totalallowcatedqty = 0;
                        foreach ($getcargos->result() as $res2) {
                            if ($res2->pallet_name == "") {
                                $totalqty += $res2->quantity;
                            }
                            if ($res2->pallet_close == '1' && $res2->pallet_name != "") {
                                $totalsavedpallet += 1;
                            } elseif ($res2->pallet_close == '0' && $res2->pallet_name != "") {
                                $totalclosedpallet += 1;
                            }
                            $scanned_quantity = 0;
                            $allocated_quantity = 0;
                            $cargo_id = $res2->cargo_id;
                            $cargo_type = $res2->cargo_type;
                            if ($res2->pallet_name == "") {
                                $innrcargo = $this->db->query(
                                    "SELECT ic.pallet_id,ic.quantity FROM tb_inner_cargo ic,tb_order_cargodetails oc WHERE ic.pallet_id=oc.id AND ic.cargo_id='" . $cargo_id . "' $whr AND ic.status=1 GROUP BY ic.id"
                                );
                                if ($innrcargo->num_rows() > 0) {
                                    foreach ($innrcargo->result_array() as $res1) {
                                        if ($res1['quantity'] == "") {
                                            $res1['quantity'] = 0;
                                        }
                                        $scanned_quantity += $res1['quantity'];
                                        if ($res1['pallet_id'] == $pallet_id) {
                                            $allocated_quantity += $res1['quantity'];
                                        }
                                    }
                                }
                                $scanned_quantity = round($scanned_quantity);
                                $totalscannedqty += $scanned_quantity;
                            }
                            $total_quantity = round($res2->quantity);
                            if ($pallet_id == "0") {
                                if ($scanned_quantity != $total_quantity) {
                                    if ($res2->pallet_name == "" && $res2->status == 1) {
                                        $cargos[] = array(
                                            'id' => $res2->id,
                                            'scanned_quantity' => $scanned_quantity,
                                            'cargo_type' => $cargo_type,
                                            'qr_code' => $res2->qr_code,
                                            'total_quantity' => $total_quantity,
                                            'allocated_quantity' => $allocated_quantity,
                                            "reference_num" => $res2->reference_order_num,
                                            "order_id" => $res2->order_id
                                        );
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if ($getcargos->num_rows() > 0) {
                        $totalqty = $totalscannedqty = $totalsavedpallet = $totalclosedpallet = $totalallowcatedqty = 0;
                        foreach ($getcargos->result() as $res2) {
                            $totalqty += $res2->quantity;
                            if ($res2->pallet_close == '1' && $res2->pallet_name != "") {
                                $totalsavedpallet += 1;
                            } elseif ($res2->pallet_close == '0' && $res2->pallet_name != "") {
                                $totalclosedpallet += 1;
                            }
                            $scanned_quantity = $allocated_quantity = 0;
                            $scanned_quantity = $res2->scanned_quantity;
                            if ($scanned_quantity == "") {
                                $scanned_quantity = 0;
                            }
                            /* $scanned_quantity += $scanned_quantity; */
                            $allocated_quantity = $res2->scanned_quantity;
                            if ($allocated_quantity == "") {
                                $allocated_quantity = 0;
                            }
                            /* $allocated_quantity += $res2->scanned_quantity; */
                            $cargo_id = $res2->cargo_id;
                            $cargo_type = $res2->cargo_type;
                            /*
                             * $innrcargo = $this->db->query("SELECT ic.pallet_id,ic.quantity FROM tb_inner_cargo ic,tb_order_cargodetails oc WHERE ic.pallet_id=oc.id AND ic.cargo_id='".$cargo_id."' AND ic.status=1 GROUP BY ic.id");
                             * if($innrcargo->num_rows() >0){
                             * foreach($innrcargo->result_array() as $res1){
                             * if($res1['quantity'] == ""){ $res1['quantity'] = 0; }
                             * $scanned_quantity += $res1['quantity'];
                             * if($res1['pallet_id'] == $pallet_id){
                             * $allocated_quantity += $res1['quantity'];
                             * }
                             * }
                             * }
                             */
                            $scanned_quantity = round($scanned_quantity);
                            $totalscannedqty += $scanned_quantity;
                            $total_quantity = round($res2->quantity);
                                $cargos[] = array(
                                    'id' => $res2->id,
                                    'scanned_quantity' => $scanned_quantity,
                                    'cargo_type' => $cargo_type,
                                    'qr_code' => $res2->qr_code,
                                    'total_quantity' => $total_quantity,
                                    'allocated_quantity' => $allocated_quantity,
                                    "reference_num" => $res2->reference_order_num,
                                    "order_id" => $res2->order_id
                                );
                        }
                    }
                }
                if ($totalqty == "") {
                    $totalqty = '0';
                }
                if ($totalscannedqty == "") {
                    $totalscannedqty = '0';
                }
                if ($totalsavedpallet == "") {
                    $totalsavedpallet = '0';
                }
                if ($totalclosedpallet == "") {
                    $totalclosedpallet = '0';
                }
                if ($totalallowcatedqty == "") {
                    $totalallowcatedqty = '0';
                }
                $summary = array(
                    "total_quantity" => $totalqty,
                    "scanned_quantity" => $totalscannedqty,
                    "total_saved_pallets" => $totalsavedpallet,
                    "total_closed_pallets" => $totalclosedpallet,
                    "total_allocated_quantity" => $totalallowcatedqty
                );
                if ($pallet_id != "0") {
                    $totalallowcatedqty = 0;
                    $cargos = array();
                    $checkpallet = $this->db->query(
                        "SELECT id,quantity,scanned_quantity,quantity_type,qr_code FROM tb_order_cargodetails WHERE id='" . $pallet_id . "' AND order_id='" . $order_id . "' AND pallet_name IS NOT NULL AND pallet_close ='1' AND status ='1'"
                    );
                    if ($checkpallet->num_rows() > 0) {
                        $getcargos = $this->db->query(
                            "SElECT oc.id,oc.cargo_id,oc.quantity,oc.scanned_quantity,oc.quantity_type,oc.qr_code,oc.reference_order_num,cd.cargo_type.oc.order_id FROM tb_order_cargodetails oc,tb_cargo_details cd WHERE oc.cargo_id=cd.id AND oc.order_id ='" . $order_id . "' AND oc.pallet_name IS NULL"
                        );
                        if ($company_code == "UKKN") {
                            $whr = " AND oc.order_id ='" . $order_id . "' ";
                            if (!empty($chksuborders)) {
                                $whr = " AND oc.order_id IN ($order_id," . implode(',', $chksuborders) . ") ";
                            }
                        } else {
                            $whr = " AND oc.order_id ='" . $order_id . "' ";
                        }
                        if ($getcargos->num_rows() > 0) {
                            foreach ($getcargos->result() as $res) {
                                $scanned_quantity = 0;
                                $allocated_quantity = 0;
                                $cargo_id = $res->cargo_id;
                                $cargo_type = $res->cargo_type;
                                $innrcargo = $this->db->query(
                                    "SELECT ic.pallet_id,ic.quantity FROM tb_inner_cargo ic,tb_order_cargodetails oc WHERE ic.pallet_id=oc.id AND ic.cargo_id='" . $cargo_id . "' $whr AND ic.status=1 GROUP BY ic.id"
                                );
                                if ($innrcargo->num_rows() > 0) {
                                    foreach ($innrcargo->result_array() as $res1) {
                                        if ($res1['quantity'] == "") {
                                            $res1['quantity'] = 0;
                                        }
                                        $scanned_quantity += $res1['quantity'];
                                        if ($res1['pallet_id'] == $pallet_id) {
                                            $allocated_quantity += $res1['quantity'];
                                        }
                                    }
                                }
                                $scanned_quantity = round($scanned_quantity);
                                $allocated_quantity = round($allocated_quantity);
                                $totalallowcatedqty += $allocated_quantity;
                                $total_quantity = round($res->quantity);
                                if ($scanned_quantity == 0 || ($scanned_quantity != $total_quantity)) {
                                    $cargos[] = array(
                                        'id' => $res->id,
                                        'scanned_quantity' => $scanned_quantity,
                                        'cargo_type' => $cargo_type,
                                        'qr_code' => $res->qr_code,
                                        'total_quantity' => $total_quantity,
                                        'allocated_quantity' => $allocated_quantity,
                                        "reference_num" => $res->reference_order_num,
                                        "order_id" => $res->order_id
                                    );
                                }
                            }
                        }
                    }
                    if ($totalallowcatedqty == "") {
                        $totalallowcatedqty = '0';
                    }
                    $summary = array(
                        "total_quantity" => $totalqty,
                        "scanned_quantity" => $totalscannedqty,
                        "total_saved_pallets" => $totalsavedpallet,
                        "total_closed_pallets" => $totalclosedpallet,
                        "total_allocated_quantity" => $totalallowcatedqty
                    );
                }
            } else {
                $message = "No Request Data";
            }
        }
        $respdata = array(
            "cargoes" => $cargos,
            "summary" => $summary
        );
        $data = array(
            'status' => '1',
            'data' => $respdata
        );
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function getpalletslist_fororder()
    {
        $data = array(
            'status' => '0'
        );
        $result = array();
        if (isset($_POST)) {
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            if ($order_id == "") {
                $order_id = 0;
            }
            if ($order_id != 0) {
                $whr = " AND order_id ='" . $order_id . "' ";
                $chksuborders = $this->getsuborders($order_id);
                if (!empty($chksuborders)) {
                    $whr = " AND order_id IN ($order_id," . implode(',', $chksuborders) . ") ";
                }
                $getpalletname = $this->db->query(
                    "SElECT id,order_id,pallet_name FROM tb_order_cargodetails WHERE pallet_name IS NOT NULL AND pallet_close ='1' $whr AND status=1 ORDER BY id DESC"
                );
                if ($getpalletname->num_rows() > 0) {
                    foreach ($getpalletname->result() as $res) {
                        $result[] = array(
                            'pallet_name' => $res->pallet_name,
                            'pallet_id' => $res->id,
                            'order_id' => $res->order_id
                        );
                    }
                }
            }
            $data = array(
                'status' => '1',
                'data' => $result
            );
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function savepalletcargo_fororder()
    {
        $pallets = $singlepallet = array();
        $data = array(
            'status' => '0',
            'data' => array()
        );
        if (isset($_POST)) {
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
            $container_id = isset($_POST['container_id']) ? $_POST['container_id'] : "";
            if ($order_id == "") {
                $order_id = 0;
            }
            $cdate = date('Y-m-d H:i:s');
            $user_id = 1;
            if ($order_id != "0") {
                $getuserid = $this->db->select("user_id")->get_where("tb_orders", array(
                    'id' => $order_id
                ));
                if ($getuserid->num_rows() > 0) {
                    $user_id = $getuserid->row()->user_id;
                }
                $handling_unit = 1;
                if ($container_id != "") {
                    $seq = getNextPalletSeq($order_id);
                    $pallet_name = date("Md") . "-" . $container_id . "-" . $seq;
                    $pallet_name = strtoupper($pallet_name);
                    $chk_handling_unit = $this->db->select("id")->get_where("tbl_shipunit_types", array(
                        'unit_name' => $pallet_name,
                        'status' => '1'
                    ));
                    if ($chk_handling_unit->num_rows() > 0) {
                        $handling_unit = $chk_handling_unit->row()->id;
                    } else {
                        $handling_insarr = array(
                            'unit_name' => $pallet_name,
                            'description' => $pallet_name,
                            'user_id' => $user_id,
                            'status' => '1',
                            'created_at' => $cdate
                        );
                        $handling_unit = $this->common->insertTableData("tbl_shipunit_types", $handling_insarr);
                    }
                    $cargo_ins = array(
                        'cargo_type' => $pallet_name,
                        'handling_unit' => $handling_unit,
                        'length' => '0',
                        'width' => '0',
                        'height' => '0',
                        'weight' => '0',
                        'volumetric_weight' => '0',
                        'volweight_uom' => 'M',
                        'ldm' => '0',
                        'volume' => '0',
                        'quantity' => '0',
                        'status' => '1',
                        'createdby' => $user_id,
                        'createdon' => $cdate
                    );
                    $cargo_id = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
                    $chkexistsornot = $this->db->select("id")->get_where("tb_order_cargodetails", array(
                        'pallet_name' => $pallet_name,
                        'order_id' => $order_id,
                        'status' => '1'
                    ));
                    if ($chkexistsornot->num_rows() == 0) {
                        $ins = array(
                            'order_id' => $order_id,
                            'handling_unit' => $handling_unit,
                            'cargo_id' => $cargo_id,
                            'length' => '0',
                            'width' => '0',
                            'height' => '0',
                            'weight' => '0',
                            'volumetric_weight' => '0',
                            'volweight_uom' => 'M',
                            'ldm' => '0',
                            'volume' => '0',
                            'quantity' => '0',
                            'pallet_name' => $pallet_name,
                            'pallet_close' => '1',
                            'status' => '1',
                            'createdon' => $cdate
                        );
                        $pallet_id = $this->common->insertTableData("tb_order_cargodetails", $ins);
                        $singlepallet = array(
                            'pallet_name' => $pallet_name,
                            'pallet_id' => $pallet_id,
                            'order_id' => $order_id
                        );
                        $getallpallets = $this->db->query(
                            "SElECT id,order_id,pallet_name FROM tb_order_cargodetails WHERE id != '" . $pallet_id . "' AND pallet_name IS NOT NULL AND pallet_close ='1' AND status=1 ORDER BY id DESC"
                        );
                        if ($getallpallets->num_rows() > 0) {
                            foreach ($getallpallets->result() as $res) {
                                $pallets[] = array(
                                    'pallet_name' => $res->pallet_name,
                                    'pallet_id' => $res->id,
                                    'order_id' => $res->order_id
                                );
                            }
                        }
                        $result = array(
                            'pallets' => $pallets,
                            'pallet' => $singlepallet
                        );
                        $data = array(
                            'status' => '1',
                            'data' => $result
                        );
                    } else {
                        $data = array(
                            'status' => '0',
                            'message' => "Pallet Name already exists!"
                        );
                    }
                } else {
                    $data = array(
                        'status' => '0',
                        'message' => "Container id should not be empty!"
                    );
                }
            } else {
                $data = array(
                    'status' => '0',
                    'message' => "Order ID should not be 0!"
                );
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    /**
     * @throws BadRequestException
     */
    public function submit_pallet()
    {
        $start = microtime(true);
        $data = array(
            'status' => '0',
            'message' => 'Failed',
            'data' => ''
        );
        $cdate = date('Y-m-d H:i:s');
        if (isset($_POST)) {
            log_message("error", "submit_pallet " . json_encode($_POST));
            $action = $_POST['action'] ?? 'print';

            if (!in_array($action, ['print', 'zpl'])) {
                $action = 'print';
            }

            $order_id = $_POST['order_id'] ?? "0";
            $pallet_id = $_POST['pallet_id'] ?? "0";
            $company_code = $_POST['company_code'] ?? "UKKN";
            $cargoes = $_POST['cargoes'] ?? [];
            if (isset($_POST['rePrint']) && $_POST['rePrint'] == "true") {
                return $this->rePrintLabel($cargoes, $order_id, $action);
            }
            if ($order_id == "") {
                $order_id = 0;
            }
            if ($pallet_id == "") {
                $pallet_id = 0;
            }
            $cargo_detail_id = 0;
            if ($order_id != "0" && $pallet_id != "0") {
                $postcargo1 = json_decode($cargoes, true);
                $data = $this->saveordlinepallet($order_id, $pallet_id, $postcargo1);
            } else {
                if ($order_id != "0") {
                    $postcargo1 = json_decode($cargoes, true);
                    $data = $this->saveordlinewithoutpallet($order_id, $postcargo1);

                    if (isset($data['labeldata'])) {
                        $labels = $this->generatelabeldata($data['labeldata']);
                        $user_id = isset($data['user_id']) ? $data['user_id'] : "";
                        unset($data['labeldata']);
                        unset($data['user_id']);
                        if ($labels != "") {
                            $labelpath = "./assets/aucargolabel/" . $labels;
                            $data['data'] = $labelpath;
                            $data['zpl'] = '';
                            switch($action) {
                                case 'zpl':
                                    $zplFile = $this->generateZPLLabel($labels);
                                    $data['zpl'] = (string) $zplFile;
                                break;
                                case 'print':
                                default:
                                    $chkprint = $this->printLabel($labels, $user_id);
                            }
                        }
                    }
                    /* $data = array('status'=>'0','message'=>'Order and Pallet Should not be 0!'); */
                }
            }
        } else {
            throw new BadRequestException("POST data should not be empty.");
        }
        $data = $this->printable($data);
        echo json_encode($data);
        log_message("error", "[LabelPrinting] Etnxdocapiv1 > submit_pallet > label print response time  :: " . (microtime(true) - $start));
    }

    private function rePrintLabel($cargoData, $orderId, $action)
    {
        $data = [
            'status' => '0',
            'message' => 'Failed',
            'data' => ""
        ];
        $this->load->helper('aulabel_helper');
        $getLabelData = appLabelRePrint($cargoData, $orderId);
        if (!empty($getLabelData['endUrl'])) {
            $data = [
                'status' => '1',
                'message' => 'Success',
                'user_id' => $getLabelData['userId']
            ];
            switch ($action) {
                case 'zpl':
                    $zplFile = $this->generateZPLLabel($getLabelData['endUrl']);
                    $data['zpl'] = (string)$zplFile;
                    break;
                case 'print':
                default:
                    $data['data'] = "./assets/aucargolabel/" . $getLabelData['endUrl'];
                 $chkprint = $this->printLabel($getLabelData['endUrl'], $getLabelData['userId']);
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }


    /**
     * @throws BadRequestException
     */
    public function printLabel($label, $userid)
    {
        ini_set('max_execution_time', '300');

        $printerIP = null;
        $printerPort = null;
        $printType = "WebSocket";
        $printerSerialNumber = null;

        if ($userid != "") {
            $userPrinters = $this->common->gettblrowdata(array(
                                                       "user_id" => $userid,
                                                       "status" => 1
                                                   ), "printerip, printerport, print_type, serial_number", "tb_user_printers", 0, 0);
            if (!empty($userPrinters)) {
                $printerIP = $userPrinters['printerip'];
                $printerPort = $userPrinters['printerport'];
                $printType = $userPrinters['print_type'];
                $printerSerialNumber = $userPrinters['serial_number'];
            }
        } else {
            throw new BadRequestException("User Id cannot be empty.");
        }
        if ($printType == "WebSocket" && $printerIP != null && $printerPort != null) {
            try {
                $start = microtime(true);
                $zpl = $this->generateZPLLabel($label);
                $client = new Client($printerIP, $printerPort);
                $client->send($zpl);
                log_message("error", "[LabelPrinting][zpl_socket_duration]Etnxdocapiv1 > printLabel > The time it took for the ZPL file to be sent to the WebSocket :: " . (microtime(true) - $start));
            } catch (Exception $e) {
                log_message("error", "Etnxdocapiv1 > printLabel > print job failed :: " . $e->getMessage());
                return $e->getMessage();
            }
        } elseif ($printType == "ZebraCloud" && $printerSerialNumber != null) {
            try {
                $start = microtime(true);
                $zpl = $this->generateZPLLabel($label);
                $printStatus = $this->sendZebraCloudPrint($zpl, $printerSerialNumber);
                log_message("error", "[LabelPrinting][zpl_ZebraCloud_duration]Etnxdocapiv1 > printLabel > The time it took for the ZPL file to be sent to the ZebraCloud :: " . (microtime(true) - $start));
            } catch (Exception $e) {
                log_message("error", "Etnxdocapiv1 > printLabel > print job failed :: " . $e->getMessage());
                return $e->getMessage();
            }
        }
    }

    /**
     * @param $zpl
     * @param $printerSerialNumber
     * @return bool
     */
    private function sendZebraCloudPrint($zpl, $printerSerialNumber): bool
    {
        $zebraCloudAPIKey = ZEBRA_API_KEY;
        $zebraCloudTenantId = "8372a7f9c09d5084a5cf07e3d0eeac8a";
        $tempFilePath = tempnam(sys_get_temp_dir(),"ZPL");
        $tempFilePointer = fopen($tempFilePath,"w+");
        fwrite($tempFilePointer, $zpl->toZpl(true));
        fclose($tempFilePointer);

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.zebra.com/v2/devices/printers/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array(
                'sn' => $printerSerialNumber,
                'zpl_file' => new CURLFILE($tempFilePath)
            ),
            CURLOPT_HTTPHEADER => array(
                'apikey: '.$zebraCloudAPIKey,
                'tenant: '.$zebraCloudTenantId,
                'Content-Type: multipart/form-data'
            ),
        ));
        if (ENVIRONMENT !== "development") {
            curl_setopt($curl, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
        }
        $response = curl_exec($curl);
        curl_close($curl);

        $responseArray = json_decode($response,TRUE);
        unlink($tempFilePath);
        if (isset($responseArray["status"]) && $responseArray["status"] == "SUCCESS") {
            return true;
        } else {
            log_message("error", "Etnxdocapiv1 > sendZebraCloudPrint > print job failed :: " . $response);
            return false;
        }
    }

    /**
     * @param $label
     * @return Builder
     * @throws ImagickException
     */
    private function generateZPLLabel($label): Builder
    {
        $path = './assets/aucargolabel/';
        $labelPath = $path . $label;
        $convertedImagePath = $path . pathinfo($labelPath)['filename'] . '.png';
        $im = new Imagick();
        $im->setResolution(180, 180);
        $im->readImage($labelPath);
        $im->setImageFormat('png');
        $im->setImageCompression(Imagick::COMPRESSION_JPEG);
        $im->setImageCompressionQuality(100);
        $im->writeImage($convertedImagePath);
        $im->clear();
        $im->destroy();
        $decoder = GdDecoder::fromPath($convertedImagePath);
        $image = new Image($decoder);
        $zpl = new Builder();
        $zpl->fo(10, 10)
            ->gf($image)
            ->fs();
        return $zpl;
    }

    public function saveordlinewithoutpallet($order_id, $postcargo1)
    {
        $data = array(
            'status' => '0',
            'message' => 'Failed',
            'data' => ""
        );
        $cdate = date('Y-m-d H:i:s');
        $postcargo = $postcargo1;
        $eachcargo = array();
        if (!empty($postcargo)) {
            $user_id = 1;
            $getuserid = $this->db->select("user_id")->get_where("tb_orders", array(
                'id' => $order_id
            ));
            if ($getuserid->num_rows() > 0) {
                $user_id = $getuserid->row()->user_id;
            }
            foreach ($postcargo as $row) {
                /* log_message("error","1 - ".$row['id']); */
                $cargo_row_id = $row['id'];
                $order_id = $row['order_id'];
                $allocated_quantity = $row['allocated_quantity'];
                $cargo_type = $row['cargo_type'];
                $qr_code = $row['qr_code'];
                $scanned_quantity = $row['scanned_quantity'];
                $total_quantity = $row['total_quantity'];
                if ($total_quantity < $scanned_quantity) {
                    $data = array(
                        'status' => '0',
                        'message' => 'Scanned Quantity is greater than total quantity',
                        'data' => ''
                    );
                } else {
                    $getcargodetails = $this->db->select(
                        "id,cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,scanned_quantity,cargo_content,qr_code"
                    )->get_where("tb_order_cargodetails", array(
                        'id' => $cargo_row_id,
                        'order_id' => $order_id,
                        'status' => '1'
                    ));
                    if ($getcargodetails->num_rows() > 0) {
                        $cargo_detail_id = $getcargodetails->row()->cargo_id;
                        $lineqty = $getcargodetails->row()->quantity;
                        $scanqty = $getcargodetails->row()->scanned_quantity;
                        if ($scanqty == "") {
                            $scanqty = 0;
                        }
                        $rem = ($scanned_quantity - $scanqty);
                        $cargodt = array(
                            'order_id' => $order_id,
                            'pallet_id' => $cargo_row_id,
                            'cargo_id' => $cargo_detail_id,
                            'scan_qty' => $rem,
                            'barcode_no' => $qr_code,
                            'qty' => $lineqty,
                            'weight' => $getcargodetails->row()->weight,
                            'cargo_content' => $getcargodetails->row()->cargo_content,
                            'cargo_type' => 'CTN'
                        );
                        $length_unit = "m";
                        $width_unit = "m";
                        $height_unit = "m";
                        $volweight_uom = $getcargodetails->row()->volweight_uom;
                        $qr_code = $getcargodetails->row()->qr_code;
                        $weight_unit = "kg";
                        $volume_unit = "cbm";
                        $quantity_type = $getcargodetails->row()->quantity_type;
                        $getdimensions = $this->db->select(
                            "cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit"
                        )->get_where("tb_cargo_details", array(
                            'id' => $cargo_detail_id,
                            'status' => '1'
                        ));
                        if ($getdimensions->num_rows() > 0) {
                            $length_unit = $getdimensions->row()->length_unit;
                            $width_unit = $getdimensions->row()->width_unit;
                            $height_unit = $getdimensions->row()->height_unit;
                            $volweight_uom = $getdimensions->row()->volweight_uom;
                            $weight_unit = $getdimensions->row()->weight_unit;
                            $volume_unit = $getdimensions->row()->volume_unit;
                            $quantity_type = $getdimensions->row()->cargo_type;
                            $cargodt['cargo_type'] = $getdimensions->row()->cargo_type;
                        }
                        $cargodt['qr_code'] = $qr_code;
                        $eachcargo[] = $cargodt;
                        $handling_unit = $getcargodetails->row()->handling_unit;
                        $length = $getcargodetails->row()->length;
                        $width = $getcargodetails->row()->width;
                        $height = $getcargodetails->row()->height;
                        $weight = $getcargodetails->row()->weight;
                        $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                        $ldm = $getcargodetails->row()->ldm;
                        $volume = $getcargodetails->row()->volume;
                        $total_quantity = $getcargodetails->row()->quantity;
                        $cargo_content = $getcargodetails->row()->cargo_content;
                        if ($quantity_type == "") {
                            $quantity_type = 'CTN';
                        }
                        /*
                         * $inner_cargo = array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$cargo_row_id,'cargo_type'=>$quantity_type,'goods_description'=>$cargo_content,'quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity,'length'=>$length,'length_unit'=>$length_unit,'width'=>$width,'width_unit'=>$width_unit,'height'=>$height,'height_unit'=>$height_unit,'weight'=>$weight,'weight_unit'=>$weight_unit,'volume'=>$volume,'volume_unit'=>$volume_unit,'stackable'=>'0','qr_code'=>$qr_code,'status'=>'1','createdby'=>$user_id,'createdon'=>$cdate);
                         * $chkinner = $this->db->select("id,quantity")->get_where("tb_inner_cargo",array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$cargo_row_id,'qr_code'=>$qr_code,'status'=>'1'));
                         * if($chkinner->num_rows() >0){
                         * $inner_id = $chkinner->row()->id;
                         * $allocated_quantity = ($chkinner->row()->quantity + $allocated_quantity);
                         * $inner_qry = $this->db->where(array('id'=>$inner_id))->update("tb_inner_cargo",array('quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity));
                         * }else{
                         * $inner_qry = $this->common->insertTableData("tb_inner_cargo",$inner_cargo);
                         * }
                         */
                        /*
                         * if($inner_qry){
                         * $gettotaldim = $this->db->query("SElECT sum(scanned_quantity) as total_squantity FROM tb_inner_cargo WHERE pallet_id='".$cargo_row_id."' AND status='1'");
                         * if($gettotaldim->num_rows() >0){
                         * $upd_car = array();
                         * $scanqty = $gettotaldim->row()->total_squantity;
                         */
                        /* $scanqty = ($scanqty + $scanned_quantity); */
                        $upd_car['scanned_quantity'] = $scanned_quantity;
                        if ($total_quantity == $scanned_quantity) {
                            $upd_car['pallet_close'] = 0;
                        }
                        $upd_outer = $this->db->where(array(
                                                          'id' => $cargo_row_id
                                                      ))->update("tb_order_cargodetails", $upd_car);
                        /*
                         * }
                         * }
                         */
                    }
                }
            }
            $data = array(
                'status' => '1',
                'message' => 'Success',
                'labeldata' => $eachcargo,
                'user_id' => $user_id
            );
        } else {
            $data = array(
                'status' => '0',
                'message' => 'Cargos Should not be empty!',
                'data' => ''
            );
        }
        return $data;
    }

    public function generatelabeldata($labeldata)
    {
        $labels = array();
        $labelpdf = "";
        if (!empty($labeldata)) {
            foreach ($labeldata as $rs) {
                if ($rs['scan_qty'] == 1) {
                    $labels[] = $rs;
                } else {
                    for ($i = 0; $i < $rs['scan_qty']; $i++) {
                        $ki = $rs;
                        $ki['scan_qty'] = 1;
                        $labels[] = $ki;
                    }
                }
            }
        }

        if (!empty($labels)) {
            $labelpdf = $this->generatebarcodepdf($labels);
        }
        return $labelpdf;
    }

    public function generatebarcodepdf($cargos)
    {
        $data = array();
        $sendurl = "";
        require 'vendor/autoload.php';
        $reference = $shipmentnumber = $communication_reference = $date = "";
        $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = $data['delivery_ins'] = "";
        $drop_details = $shipper_details = array();
        $order_id = $cargos[0]['order_id'];
        if ($order_id != "" && !empty($cargos)) {
            $select = "id,order_id,pickup_datetime,delivery_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,vendor_id";
            $chkorder = $this->common->gettblrowdata(array(
                                                         'id' => $order_id
                                                     ), $select, "tb_orders", 0, 0);
            if (count($chkorder) > 0) {
                $shipmentnumber = $chkorder['order_id'];
                $chekparty = $this->db->query(
                    "SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type"
                );
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                            "id" => $ptype
                        ),                                              1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = array(
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                );
                            } else {
                                if ($chktype->row()->name == "Shipper") {
                                    $shipper_details = array(
                                        'id' => $rr->id,
                                        'name' => $rr->name,
                                        'phone' => $rr->mobile,
                                        'email' => $rr->email,
                                        'fax' => $rr->fax,
                                        'party_id' => $rr->code
                                    );
                                }
                            }
                        }
                    }
                }
                $data['carrier_name'] = "Kuehne Nagel";
                $carrier_details = $this->common->gettblrowdata(array(
                                                                    'id' => $chkorder['vendor_id']
                                                                ), 'name', 'tb_vendors', 0, 0);
                if (count($carrier_details) > 0) {
                    $data['carrier_name'] = $carrier_details['name'];
                }
                $data['carrier_name'] = (strtoupper(
                        $data['carrier_name']
                    ) == "BORDER EXPRESS") ? "BEX" : $data['carrier_name'];
                $data['carrier_new_name'] = "";
                /*
                 * Carrier image and beside name code
                 */
                if (strtoupper($data['carrier_name']) == "BEX") {
                    $data['carrier_img'] = "BEX.jpg";
                    $data['carrier_new_name'] = "REGIONAL";
                } elseif (strtoupper($data['carrier_name']) == "BONDS TRANSPORT") {
                    $data['carrier_img'] = "Bonds.jpg";
                    $data['carrier_new_name'] = "METRO";
                } elseif (strtoupper($data['carrier_name']) == "BONDS DC") {
                    $data['carrier_img'] = "DC.jpg";
                    $data['carrier_new_name'] = "DC";
                } else {
                    $data['carrier_img'] = "";
                }
                /*
                 * delivery instructions
                 */
                $where = array(
                    "order_id" => $order_id,
                    'status' => '1',
                    'reference_id' => 'ORD_DLVINST'
                );
                $select = "order_id,ref_value";
                $table = "tb_order_references";
                $data_ref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (!empty($data_ref)) {
                    $data['delivery_ins'] = $data_ref['ref_value'];
                }

                $data['delivery_date'] = date('d/m/Y', strtotime($chkorder['delivery_datetime']));
                $data['pickup_date'] = date('d/m/Y', strtotime($chkorder['pickup_datetime']));
                $shipper_details['name'] = $chkorder['pickup_company'];
                $shipper_details['street'] = $chkorder['pickup_address1'];
                $shipper_details['state'] = $chkorder['pickup_address2'];
                $shipper_details['city'] = $chkorder['pickup_city'];
                $shipper_details['country'] = $chkorder['pickup_country'];
                $shipper_details['pincode'] = $chkorder['pickup_pincode'];
                $data['consignment_no'] = $shipmentnumber;
                $consign = $this->common->gettblrowdata(array(
                                                            'order_row_id' => $order_id
                                                        ), 'consignment_note', 'tb_order_details', 0, 0);
                if (count($consign) > 0) {
                    $data['consignment_no'] = $consign['consignment_note'];
                }
                $drop_details['name'] = $chkorder['delivery_company'];
                $drop_details['street'] = $chkorder['delivery_address1'];
                $drop_details['state'] = $chkorder['delivery_address2'];
                $drop_details['city'] = $chkorder['delivery_city'];
                $drop_details['country'] = $chkorder['delivery_country'];
                $drop_details['pincode'] = $chkorder['delivery_pincode'];
                $data['container_no'] = '';
                $reference = $this->common->gettblrowdata(array(
                                                              'order_id' => $order_id,
                                                              'reference_id' => 'CTR'
                                                          ), 'ref_value', 'tb_order_references', 0, 0);
                if (!empty($reference)) {
                    $data['container_no'] = $reference['ref_value'];
                }
                $data['drop_details'] = $drop_details;
                $data['shipper_details'] = $shipper_details;
                $data['reference'] = $reference;
                $data['shipmentnumber'] = $shipmentnumber;
                $data['cargos'] = $cargos;
                $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
                $mpdf = new \Mpdf\Mpdf([
                                           'mode' => 'utf-8',
                                           'format' => [
                                               112.0,
                                               152.0
                                           ],
                                           'tempDir' => FCPATH . 'assets/tmp',
                                           'margin_left' => 0,
                                           'margin_right' => 0,
                                           'margin_top' => 0,
                                           'margin_bottom' => 0,
                                           'margin_header' => 0,
                                           'margin_footer' => 0
                                       ]);
                
                $store_timings = $this->storetimings($data);
                if (!empty($store_timings)) {
                    $data['store_timings'] = $store_timings;
                }
                
                $html = "";
                $i = 1;
                $barcodestart = "0001";
                $data['count'] = count($cargos);
                $auqr_arr = array();
                foreach ($cargos as $cargo) {
                    if (!in_array($cargo['qr_code'], $auqr_arr)) {
                        $auqr_arr[] = $cargo['qr_code'];
                        $rcent = $this->db->query(
                            "SELECT bar_code FROM tb_order_cargo_labels WHERE bar_code LIKE '" . $data['consignment_no'] . "%' AND order_id=$order_id ORDER BY id DESC LIMIT 1"
                        );
                        if ($rcent->num_rows() > 0) {
                            $newbarcode1 = $rcent->row()->bar_code;
                            $getlasts4 = substr($newbarcode1, -4);
                            $getlasts4++;
                            $inc_length = strlen($getlasts4);
                            $getlast4 = $getlasts4;
                            if ($inc_length == 1) {
                                $getlast4 = "000" . $getlast4;
                            } else {
                                if ($inc_length == 2) {
                                    $getlast4 = "00" . $getlast4;
                                } else {
                                    if ($inc_length == 3) {
                                        $getlast4 = "0" . $getlast4;
                                    }
                                }
                            }
                            $newbarcode = $data['consignment_no'] . "" . $getlast4;
                            $getlast4 = "";
                        } else {
                            $newbarcode = $data['consignment_no'] . "" . $barcodestart;
                        }
                        $data['weight'] = $cargo['weight'];
                        $data['cargo_type'] = $cargo['cargo_type'];
                        $data['cargo_content'] = $cargo['cargo_content'];
                        $request_data = array(
                            'order_id' => $cargo['order_id'],
                            'cargo_id' => $cargo['pallet_id']
                        );

                        $data['barcode_no'] = $newbarcode;
                        $curtz = "Australia/Sydney";
                        $data['label_create_date'] = getdatetimebytimezone($curtz, date('Y-m-d H:i:s'), DFLT_TZ)['datetime'];
                        $data['caseid'] = $cargo['qr_code'];
                        /* check and add in tb_order_cargo_labels */
                        /* $routeinfo = $this->common->gettblrowdata(array(
                             'postalcode' => $drop_details['pincode'],
                             'status' => 1,
                             'type' => 2
                         ), 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);*/

                        $routeinfo['routing_code'] = "";
                        if ($data['carrier_name'] == 'BONDS TRANSPORT') {
                            $routeinfo = $this->common->gettblrowdata(array(
                                                                          'correct_zip' => $drop_details['pincode'],
                                                                          'status' => 1,
                                                                          'carrier_name' => 'Bonds'
                                                                      ), 'headport', 'tb_au_carrier_headports', 0, 0);
                            $routeinfo['routing_code'] = $routeinfo['headport'] ?? '';
                        } else {
                            $routeinfo = $this->common->gettblrowdata(
                                array(
                                    'postalcode' => $drop_details['pincode'],
                                    'suburb' => $drop_details['city'],
                                    'state' => $drop_details['state'],
                                    'status' => 1,
                                    'type' => 2
                                ),
                                'routing_code',
                                'tb_au_carrier_postalcodes',
                                0,
                                0
                            );
                        }
                        $data['routecode'] = !empty($routeinfo['routing_code']) ? $routeinfo['routing_code'] : ' ';
                        $insarray = array(
                            'cargo_id' => $cargo['cargo_id'],
                            'order_id' => $cargo['order_id'],
                            'pallet_id' => $cargo['pallet_id'],
                            'bar_code' => $newbarcode,
                            'status' => 1
                        );
                        $ins = $this->common->insertTableData("tb_order_cargo_labels", $insarray);
                        /* Get total number of cartons per order and carton serial number */
                        $get_cargo_qty = $this->gettotalcargos($request_data);
                        $data['qty'] = $get_cargo_qty['carton_qty'];
                        $data['no'] = $get_cargo_qty['carton_num'];
                        $html .= $this->load->view('orders/aulabel', $data, true);
                        $i++;
                    }
                }
                /* Scanned status updation if all cartons scanned */
                $scaninfo = $this->common->gettblrowdata(
                    array(
                        'order_id' => $order_id
                    ),
                    "sum(quantity) tot_qty,sum(scanned_quantity) tot_scan_qty",
                    "tb_order_cargodetails",
                    0,
                    0
                );
                if (!empty($scaninfo)) {
                    $code = '2491';
                    $statusinfo = $this->common->gettblrowdata(array(
                                                                   "status_code" => $code,
                                                                   'status' => 1
                                                               ), 'id', 'tb_status_master', 0, 0);
                    if (!empty($statusinfo) && round($scaninfo['tot_qty']) == round($scaninfo['tot_scan_qty'])) {
                        $dt = date('Y-m-d H:i:s');
                        $status_id = $statusinfo['id'];
                        $innr_array = array(
                            'order_id' => $order_id,
                            'status_id' => $status_id,
                            'status_code' => $code,
                            'status' => 1,
                            'updatedon' => $dt
                        );
                        $check_array = array(
                            'order_id' => $order_id,
                            'status_id' => $status_id,
                            'status_code' => $code,
                            'status' => 1
                        );
                        $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                        if ($chk_qry->num_rows() == 0) {
                            $innr_array['createdon'] = $dt;
                            $innr_array['status_date'] = $dt;
                            $stsins = $this->db->insert('tb_order_status', $innr_array);
                        }
                    }
                }
                $data1['labelcontent'] = $html;
                $sendurl = $shipmentnumber . "_" . $data['consignment_no'] . "_" . date('YmdHis') . ".pdf";
                $labelpdf = "./assets/aucargolabel/" . $sendurl;
                $output = $this->load->view('orders/order_label', $data1, true);
                $mpdf->WriteHTML($output);
                $mpdf->Output($labelpdf, 'F');
            }
        }
        return $sendurl;
    }

    private function storetimings($data)
    {
        $store_code = 0;
        $get_data = array();
        if (!empty($data) && isset($data['drop_details']) && !empty($data['drop_details'])) {
            if (isset($data['order_id']) && !empty($data['order_id'])) {
                $reference = $this->common->gettblrowdata(array(
                                                              'order_id' => $data['order_id'],
                                                              'reference_id' => 'COI'
                                                          ), 'ref_value', 'tb_order_references', 0, 0);
                if (!empty($reference)) {
                    $store_code = $reference['ref_value'];
                }
            }

            $where = array(
                'city' => isset($data['drop_details']['city']) ? $data['drop_details']['city'] : '',
                'state' => isset($data['drop_details']['state']) ? $data['drop_details']['state'] : '',
                'post_code' => isset($data['drop_details']['pincode']) ? $data['drop_details']['pincode'] : '',
                'name' => isset($data['drop_details']['name']) ? $data['drop_details']['name'] : '',
                'status' => 1
            );
            if (!empty($store_code)) {
                $where['store_code'] = $store_code;
            }
            $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
            if (!empty($store_data) && !empty($store_data['dock_hours'])) {
                $get_data = $store_data;
            } else {
                unset($where['city']);
                unset($where['name']);
                $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                if (!empty($store_data) && !empty($store_data['dock_hours'])) {
                    $get_data = $store_data;
                } else {
                    unset($where['state']);
                    $store_data = $this->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
                    if (!empty($store_data) && !empty($store_data['dock_hours'])) {
                        $get_data = $store_data;
                    }
                }
            }
        }
        return $get_data;
    }


    /* Get total number of cartons per order and carton serial number */
    public function gettotalcargos($res_arr)
    {
        $data = array(
            'carton_num' => 1,
            'carton_qty' => 1
        );
        $order_id = $res_arr['order_id'];
        $cargo_id = $res_arr['cargo_id'];
        $this->load->model('aulabelmodel');
        $res = $this->aulabelmodel->getcargolabelsorted($order_id);
        if (!empty($res)) {
            $final_res = array_column($res, 'id');
            $carton_num = array_search($cargo_id, $final_res, true);
            $carton_num++;
            $data ['carton_num'] = !empty($carton_num) ? $carton_num : 1;
        }
        $getCargoIds=$this->common->gettblrowdata(
            ['order_id' => $order_id,'status' => 1],
            "count(id) idCount", "tb_order_cargodetails", 0, 0);
        $data['carton_qty'] = !empty($getCargoIds['idCount']) ? $getCargoIds['idCount'] : 1;
        return $data;
    }

    public function saveordlinepallet($order_id, $pallet_id, $postcargo1)
    {
        $data = array(
            'status' => '0',
            'message' => 'Failed',
            'data' => ""
        );
        $cdate = date('Y-m-d H:i:s');
        $postcargo = $postcargo1;
        if (!empty($postcargo)) {
            $user_id = 1;
            $getuserid = $this->db->select("user_id")->get_where("tb_orders", array(
                'id' => $order_id
            ));
            if ($getuserid->num_rows() > 0) {
                $user_id = $getuserid->row()->user_id;
            }
            /* log_message("error","1st - ".json_encode($postcargo)); */
            /*
             * $getpallet_cargo_id = $this->db->select("cargo_id")->get_where("tb_order_cargodetails",array('id'=>$pallet_id,'status'=>'1'));
             * if($getpallet_cargo_id->num_rows() >0){
             * $cargo_detail_id = $getpallet_cargo_id->row()->cargo_id;
             * }
             */
            foreach ($postcargo as $row) {
                $cargo_row_id = $row['id'];
                $allocated_quantity = $row['allocated_quantity'];
                $cargo_type = $row['cargo_type'];
                $qr_code = $row['qr_code'];
                $scanned_quantity = $row['scanned_quantity'];
                $total_quantity = $row['total_quantity'];
                if ($total_quantity < $scanned_quantity) {
                    $data = array(
                        'status' => '0',
                        'message' => 'Scanned Quantity is greater than total quantity',
                        'data' => ''
                    );
                } else {
                    $getcargodetails = $this->db->select(
                        "cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,cargo_content,qr_code"
                    )->get_where("tb_order_cargodetails", array(
                        'id' => $cargo_row_id,
                        'status' => '1'
                    ));
                    /* log_message("error","3rd ".$this->db->last_query()); */
                    if ($getcargodetails->num_rows() > 0) {
                        $cargo_detail_id = $getcargodetails->row()->cargo_id;
                        $length_unit = "m";
                        $width_unit = "m";
                        $height_unit = "m";
                        $volweight_uom = $getcargodetails->row()->volweight_uom;
                        $qr_code = $getcargodetails->row()->qr_code;
                        $weight_unit = "kg";
                        $volume_unit = "cbm";
                        $quantity_type = $getcargodetails->row()->quantity_type;
                        $getdimensions = $this->db->select(
                            "cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit"
                        )->get_where("tb_cargo_details", array(
                            'id' => $cargo_detail_id,
                            'status' => '1'
                        ));
                        if ($getdimensions->num_rows() > 0) {
                            $length_unit = $getdimensions->row()->length_unit;
                            $width_unit = $getdimensions->row()->width_unit;
                            $height_unit = $getdimensions->row()->height_unit;
                            $volweight_uom = $getdimensions->row()->volweight_uom;
                            $weight_unit = $getdimensions->row()->weight_unit;
                            $volume_unit = $getdimensions->row()->volume_unit;
                            $quantity_type = $getdimensions->row()->cargo_type;
                        }
                        $handling_unit = $getcargodetails->row()->handling_unit;
                        $length = $getcargodetails->row()->length;
                        $width = $getcargodetails->row()->width;
                        $height = $getcargodetails->row()->height;
                        $weight = $getcargodetails->row()->weight;
                        $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                        $ldm = $getcargodetails->row()->ldm;
                        $volume = $getcargodetails->row()->volume;
                        $total_quantity = $getcargodetails->row()->quantity;
                        $cargo_content = $getcargodetails->row()->cargo_content;
                        if ($quantity_type == "") {
                            $quantity_type = 'CTN';
                        }
                        $inner_cargo = array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $pallet_id,
                            'cargo_type' => $quantity_type,
                            'goods_description' => $cargo_content,
                            'quantity' => $allocated_quantity,
                            'scanned_quantity' => $allocated_quantity,
                            'length' => $length,
                            'length_unit' => $length_unit,
                            'width' => $width,
                            'width_unit' => $width_unit,
                            'height' => $height,
                            'height_unit' => $height_unit,
                            'weight' => $weight,
                            'weight_unit' => $weight_unit,
                            'volume' => $volume,
                            'volume_unit' => $volume_unit,
                            'stackable' => '0',
                            'qr_code' => $qr_code,
                            'status' => '1',
                            'createdby' => $user_id,
                            'createdon' => $cdate
                        );
                        $chkinner = $this->db->select("id")->get_where("tb_inner_cargo", array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $pallet_id,
                            'qr_code' => $qr_code,
                            'status' => '1'
                        ));
                        /* log_message("error","1st ".$this->db->last_query()); */
                        if ($chkinner->num_rows() > 0) {
                            $inner_qry = $chkinner->row()->id;
                            /* $inner_qry = $this->db->where(array('id'=>$inner_id))->update("tb_inner_cargo",array('quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity)); */
                        } else {
                            $inner_qry = $this->common->insertTableData("tb_inner_cargo", $inner_cargo);
                            /* log_message("error","2nd ".$this->db->last_query()); */
                        }
                        if ($inner_qry) {
                            if ($total_quantity == $scanned_quantity) {
                                $upd = $this->db->where(array(
                                                            'id' => $cargo_row_id
                                                        ))->update("tb_order_cargodetails", array(
                                    'scanned_quantity' => $scanned_quantity,
                                    'status' => '0'
                                ));
                            } else {
                                $upd = $this->db->where(array(
                                                            'id' => $cargo_row_id
                                                        ))->update("tb_order_cargodetails", array(
                                    'scanned_quantity' => $scanned_quantity
                                ));
                            }
                            $gettotaldim = $this->db->query(
                                "SElECT sum(quantity) as total_quantity,sum(scanned_quantity) as total_squantity,sum(length) as total_length,sum(width) as total_width,sum(height) as total_height,sum(weight) as total_weight,sum(volume) as total_volume FROM tb_inner_cargo WHERE pallet_id='" . $pallet_id . "' AND  status='1'"
                            );
                            if ($gettotaldim->num_rows() > 0) {
                                $upd_car = array(
                                    'quantity' => $gettotaldim->row()->total_quantity,
                                    'scanned_quantity' => $gettotaldim->row()->total_squantity,
                                    'length' => $gettotaldim->row()->total_length,
                                    'width' => $gettotaldim->row()->total_width,
                                    'height' => $gettotaldim->row()->total_height,
                                    'weight' => $gettotaldim->row()->total_weight,
                                    'volume' => $gettotaldim->row()->total_volume
                                );
                                $upd_outer = $this->db->where(array(
                                                                  'id' => $pallet_id
                                                              ))->update("tb_order_cargodetails", $upd_car);
                            }
                        }
                    }
                }
            }
            $data = array(
                'status' => '1',
                'message' => 'Success',
                'data' => ''
            );
        } else {
            $data = array(
                'status' => '0',
                'message' => 'Cargos Should not be empty!',
                'data' => ''
            );
        }
        return $data;
    }

    public function close_pallet()
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cdate = date('Y-m-d H:i:s');
        if (isset($_POST)) {
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            $cargoes = isset($_POST['cargoes']) ? $_POST['cargoes'] : array();
            if ($order_id == "") {
                $order_id = 0;
            }
            if ($pallet_id == "") {
                $pallet_id = 0;
            }
            $cargo_detail_id = 0;
            if ($order_id != "0" && $pallet_id != "0") {
                $postcargo1 = json_decode($cargoes, true);
                $data = $this->closeordlinepallet($order_id, $pallet_id, $postcargo1);
            } else {
                $postcargo1 = json_decode($cargoes, true);
                $data = $this->closeordlinewithoutpallet($order_id, $postcargo1);
                /* $data = array('status'=>'0','message'=>'Order and Pallet Should not be 0!'); */
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function closeordlinewithoutpallet($order_id, $postcargo1)
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cdate = date('Y-m-d H:i:s');
        $postcargo = $postcargo1;
        if (!empty($postcargo)) {
            $user_id = 1;
            $getuserid = $this->db->select("user_id")->get_where("tb_orders", array(
                'id' => $order_id
            ));
            if ($getuserid->num_rows() > 0) {
                $user_id = $getuserid->row()->user_id;
            }
            foreach ($postcargo as $row) {
                $cargo_row_id = $row['id'];
                $allocated_quantity = $row['allocated_quantity'];
                $cargo_type = $row['cargo_type'];
                $qr_code = $row['qr_code'];
                $scanned_quantity = $row['scanned_quantity'];
                $total_quantity = $row['total_quantity'];
                if ($total_quantity < $scanned_quantity) {
                    $data = array(
                        'status' => '0',
                        'message' => 'Scanned Quantity is greater than total quantity'
                    );
                } else {
                    $getcargodetails = $this->db->select(
                        "cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,cargo_content,qr_code"
                    )->get_where("tb_order_cargodetails", array(
                        'id' => $cargo_row_id,
                        'order_id' => $order_id,
                        'status' => '1'
                    ));
                    if ($getcargodetails->num_rows() > 0) {
                        $cargo_detail_id = $getcargodetails->row()->cargo_id;
                        $length_unit = "m";
                        $width_unit = "m";
                        $height_unit = "m";
                        $volweight_uom = $getcargodetails->row()->volweight_uom;
                        $qr_code = $getcargodetails->row()->qr_code;
                        $weight_unit = "kg";
                        $volume_unit = "cbm";
                        $quantity_type = $getcargodetails->row()->quantity_type;
                        $getdimensions = $this->db->select(
                            "cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit"
                        )->get_where("tb_cargo_details", array(
                            'id' => $cargo_detail_id,
                            'status' => '1'
                        ));
                        if ($getdimensions->num_rows() > 0) {
                            $length_unit = $getdimensions->row()->length_unit;
                            $width_unit = $getdimensions->row()->width_unit;
                            $height_unit = $getdimensions->row()->height_unit;
                            $volweight_uom = $getdimensions->row()->volweight_uom;
                            $weight_unit = $getdimensions->row()->weight_unit;
                            $volume_unit = $getdimensions->row()->volume_unit;
                            $quantity_type = $getdimensions->row()->cargo_type;
                        }
                        $handling_unit = $getcargodetails->row()->handling_unit;
                        $length = $getcargodetails->row()->length;
                        $width = $getcargodetails->row()->width;
                        $height = $getcargodetails->row()->height;
                        $weight = $getcargodetails->row()->weight;
                        $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                        $ldm = $getcargodetails->row()->ldm;
                        $volume = $getcargodetails->row()->volume;
                        $total_quantity = $getcargodetails->row()->quantity;
                        $cargo_content = $getcargodetails->row()->cargo_content;
                        if ($quantity_type == "") {
                            $quantity_type = 'CTN';
                        }
                        $inner_cargo = array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $cargo_row_id,
                            'cargo_type' => $quantity_type,
                            'goods_description' => $cargo_content,
                            'quantity' => $allocated_quantity,
                            'scanned_quantity' => $allocated_quantity,
                            'length' => $length,
                            'length_unit' => $length_unit,
                            'width' => $width,
                            'width_unit' => $width_unit,
                            'height' => $height,
                            'height_unit' => $height_unit,
                            'weight' => $weight,
                            'weight_unit' => $weight_unit,
                            'volume' => $volume,
                            'volume_unit' => $volume_unit,
                            'stackable' => '0',
                            'qr_code' => $qr_code,
                            'status' => '1',
                            'createdby' => $user_id,
                            'createdon' => $cdate
                        );
                        $chkinner = $this->db->select("id,quantity")->get_where("tb_inner_cargo", array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $cargo_row_id,
                            'qr_code' => $qr_code,
                            'status' => '1'
                        ));
                        if ($chkinner->num_rows() > 0) {
                            $inner_id = $chkinner->row()->id;
                            $allocated_quantity = ($chkinner->row()->quantity + $allocated_quantity);
                            $inner_qry = $this->db->where(array(
                                                              'id' => $inner_id
                                                          ))->update("tb_inner_cargo", array(
                                'quantity' => $allocated_quantity,
                                'scanned_quantity' => $allocated_quantity
                            ));
                        } else {
                            $inner_qry = $this->db->insert("tb_inner_cargo", $inner_cargo);
                        }
                        if ($inner_qry) {
                            $gettotaldim = $this->db->query(
                                "SElECT sum(scanned_quantity) as total_squantity FROM tb_inner_cargo WHERE pallet_id='" . $cargo_row_id . "' AND  status='1'"
                            );
                            if ($gettotaldim->num_rows() > 0) {
                                $upd_car = array();
                                $scanqty = $gettotaldim->row()->total_squantity;
                                $upd_car['scanned_quantity'] = $scanqty;
                                if ($total_quantity == $scanqty) {
                                    $upd_car['pallet_close'] = 0;
                                }
                                $upd_outer = $this->db->where(array(
                                                                  'id' => $cargo_row_id
                                                              ))->update("tb_order_cargodetails", $upd_car);
                            }
                        }
                    }
                }
            }
            $data = array(
                'status' => '1',
                'message' => 'Success'
            );
        } else {
            /*
             * $upd_car = array('pallet_close'=>'0');
             * $upd_outer = $this->db->where(array('id'=>$cargo_row_id))->update("tb_order_cargodetails",$upd_car);
             * if($upd_outer){
             * $data = array('status'=>'1','message'=>'Success.');
             * }else{
             */
            $data = array(
                'status' => '0',
                'message' => 'Cargos Should not be empty!'
            );
            /* } */
        }
        return $data;
    }

    public function closeordlinepallet($order_id, $pallet_id, $postcargo1)
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cdate = date('Y-m-d H:i:s');
        $postcargo = $postcargo1;
        if (!empty($postcargo)) {
            $user_id = 1;
            $getuserid = $this->db->select("user_id")->get_where("tb_orders", array(
                'id' => $order_id
            ));
            if ($getuserid->num_rows() > 0) {
                $user_id = $getuserid->row()->user_id;
            }
            foreach ($postcargo as $row) {
                $cargo_row_id = $row['id'];
                $allocated_quantity = $row['allocated_quantity'];
                $cargo_type = $row['cargo_type'];
                $qr_code = $row['qr_code'];
                $scanned_quantity = $row['scanned_quantity'];
                $total_quantity = $row['total_quantity'];
                if ($total_quantity < $scanned_quantity) {
                    $data = array(
                        'status' => '0',
                        'message' => 'Scanned Quantity is greater than total quantity'
                    );
                } else {
                    $getcargodetails = $this->db->select(
                        "cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,cargo_content,qr_code"
                    )->get_where("tb_order_cargodetails", array(
                        'id' => $cargo_row_id,
                        'status' => '1'
                    )); /* 'order_id'=>$order_id, */
                    if ($getcargodetails->num_rows() > 0) {
                        $cargo_detail_id = $getcargodetails->row()->cargo_id;
                        $length_unit = "m";
                        $width_unit = "m";
                        $height_unit = "m";
                        $volweight_uom = $getcargodetails->row()->volweight_uom;
                        $qr_code = $getcargodetails->row()->qr_code;
                        $weight_unit = "kg";
                        $volume_unit = "cbm";
                        $quantity_type = $getcargodetails->row()->quantity_type;
                        $getdimensions = $this->db->select(
                            "cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit"
                        )->get_where("tb_cargo_details", array(
                            'id' => $cargo_detail_id,
                            'status' => '1'
                        ));
                        if ($getdimensions->num_rows() > 0) {
                            $length_unit = $getdimensions->row()->length_unit;
                            $width_unit = $getdimensions->row()->width_unit;
                            $height_unit = $getdimensions->row()->height_unit;
                            $volweight_uom = $getdimensions->row()->volweight_uom;
                            $weight_unit = $getdimensions->row()->weight_unit;
                            $volume_unit = $getdimensions->row()->volume_unit;
                            $quantity_type = $getdimensions->row()->cargo_type;
                        }
                        $handling_unit = $getcargodetails->row()->handling_unit;
                        $length = $getcargodetails->row()->length;
                        $width = $getcargodetails->row()->width;
                        $height = $getcargodetails->row()->height;
                        $weight = $getcargodetails->row()->weight;
                        $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                        $ldm = $getcargodetails->row()->ldm;
                        $volume = $getcargodetails->row()->volume;
                        $total_quantity = $getcargodetails->row()->quantity;
                        $cargo_content = $getcargodetails->row()->cargo_content;
                        if ($quantity_type == "") {
                            $quantity_type = 'CTN';
                        }
                        $inner_cargo = array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $pallet_id,
                            'cargo_type' => $quantity_type,
                            'goods_description' => $cargo_content,
                            'quantity' => $allocated_quantity,
                            'scanned_quantity' => $allocated_quantity,
                            'length' => $length,
                            'length_unit' => $length_unit,
                            'width' => $width,
                            'width_unit' => $width_unit,
                            'height' => $height,
                            'height_unit' => $height_unit,
                            'weight' => $weight,
                            'weight_unit' => $weight_unit,
                            'volume' => $volume,
                            'volume_unit' => $volume_unit,
                            'stackable' => '0',
                            'qr_code' => $qr_code,
                            'status' => '1',
                            'createdby' => $user_id,
                            'createdon' => $cdate
                        );
                        $chkinner = $this->db->select("id")->get_where("tb_inner_cargo", array(
                            'cargo_id' => $cargo_detail_id,
                            'pallet_id' => $pallet_id,
                            'qr_code' => $qr_code,
                            'status' => '1'
                        ));
                        if ($chkinner->num_rows() > 0) {
                            $inner_qry = $chkinner->row()->id;
                            /* $inner_qry = $this->db->where(array('id'=>$inner_id))->update("tb_inner_cargo",array('quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity)); */
                        } else {
                            $inner_qry = $this->db->insert("tb_inner_cargo", $inner_cargo);
                        }
                        if ($inner_qry) {
                            if ($total_quantity == $scanned_quantity) {
                                $this->db->where(array(
                                                     'id' => $cargo_row_id
                                                 ))->update("tb_order_cargodetails", array(
                                    'scanned_quantity' => $scanned_quantity,
                                    'status' => '0'
                                ));
                            } else {
                                $this->db->where(array(
                                                     'id' => $cargo_row_id
                                                 ))->update("tb_order_cargodetails", array(
                                    'scanned_quantity' => $scanned_quantity
                                ));
                            }
                            $gettotaldim = $this->db->query(
                                "SElECT sum(quantity) as total_quantity,sum(scanned_quantity) as total_squantity,sum(length) as total_length,sum(width) as total_width,sum(height) as total_height,sum(weight) as total_weight,sum(volume) as total_volume FROM tb_inner_cargo WHERE pallet_id='" . $pallet_id . "' AND  status='1'"
                            );
                            if ($gettotaldim->num_rows() > 0) {
                                $upd_car = array(
                                    'quantity' => $gettotaldim->row()->total_quantity,
                                    'scanned_quantity' => $gettotaldim->row()->total_squantity,
                                    'length' => $gettotaldim->row()->total_length,
                                    'width' => $gettotaldim->row()->total_width,
                                    'height' => $gettotaldim->row()->total_height,
                                    'weight' => $gettotaldim->row()->total_weight,
                                    'volume' => $gettotaldim->row()->total_volume,
                                    'pallet_close' => '0'
                                );
                                $upd_outer = $this->db->where(array(
                                                                  'id' => $pallet_id
                                                              ))->update("tb_order_cargodetails", $upd_car);
                            }
                        }
                    }
                }
            }
            $data = array(
                'status' => '1',
                'message' => 'Success'
            );
        } else {
            $upd_car = array(
                'pallet_close' => '0'
            );
            $upd_outer = $this->db->where(array(
                                              'id' => $pallet_id
                                          ))->update("tb_order_cargodetails", $upd_car);
            if ($upd_outer) {
                $data = array(
                    'status' => '1',
                    'message' => 'Success.'
                );
            } else {
                $data = array(
                    'status' => '0',
                    'message' => 'Cargos Should not be empty!'
                );
            }
        }
        return $data;
    }

    public function setcontainerstatus()
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cdate = date('Y-m-d H:i:s');
        if (isset($_POST)) {
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
            $status = isset($_POST['status']) ? $_POST['status'] : "";
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            if ($order_id != "" && $status != "") {
                $status_id = 0;
                $status_code = "";
                if ($status == "ARRIVED") {
                    $status_code = 'RY';
                }
                if ($status == "OPEN") {
                    $status_code = 'ON';
                }
                if ($status == "CLOSED") {
                    $status_code = 'ED';
                }
                if ($status == "DEPARTED") {
                    $status_code = 'ER';
                }
                if ($status_code != "") {
                    $getstatusid = $this->db->select("id")->get_where("tb_status_master", array(
                        'status_code' => $status_code
                    ));
                    if ($getstatusid->num_rows() > 0) {
                        $status_id = $getstatusid->row()->id;
                    }
                }
                if ($status_id != "" && $status_id != "0") {
                    $chkstatus = array(
                        'order_id' => $order_id,
                        'status_id' => $status_id,
                        'status_code' => $status_code,
                        'status' => '1'
                    );
                    $getstatusid = $this->db->select("id")->get_where("tb_order_status", $chkstatus);
                    if ($getstatusid->num_rows() == 0) {
                        $lattitude = $longitude = "";
                        /* $country_code = "UK"; */
                        if ($user_id != "") {
                            $getloc = $this->db->select('country_code,lat,lng')->get_where("tb_users", array(
                                'id' => $user_id
                            ));
                            if ($getloc->num_rows() > 0) {
                                $lattitude = $getloc->row()->lat;
                                $longitude = $getloc->row()->lng;
                                /* $country_code = $getloc->row()->country_code; */
                            }
                        }
                        /*
                         * $cnt_timezone = "Europe/London";
                         * $timezone = $this->common->gettblrowdata(array('country_code'=>$country_code,'status'=>'1'),'cntry_timezone','tbl_country_master',0,0);
                         * if(count($timezone)>0){
                         * $cnt_timezone = $timezone['cntry_timezone'];
                         * }
                         * $today = new DateTime("now", new DateTimeZone($cnt_timezone));
                         */
                        /*
                         * $tz = DFLT_TZ;
                         * $tz_obj = new DateTimeZone($tz);
                         * $todaytm = new DateTime("now", $tz_obj);
                         * $dttm_formatted = $todaytm->format('Y-m-d H:i:s');
                         */
                        $statusarr = array(
                            'order_id' => $order_id,
                            'status_id' => $status_id,
                            'latitude' => $lattitude,
                            'longitude' => $longitude,
                            'status_code' => $status_code,
                            'status' => '1',
                            'status_date' => $cdate
                        );
                        $ins = $this->common->insertTableData("tb_order_status", $statusarr);
                        if ($ins > 0) {
                            /* send to amazon */
                            $booking_id = $order_id;
                            $getstatusid1 = $this->db->select("order_id")->get_where("tb_orders", array(
                                'id' => $order_id
                            ));
                            if ($getstatusid1->num_rows() > 0) {
                                $booking_id = $getstatusid1->row()->order_id;
                            }
                            $this->load->library("amazonstatusintegration");
                            $postdata = array(
                                "shipment_id" => 0,
                                "trip_id" => 0,
                                "driver_id" => 0,
                                "vehicle_id" => 0,
                                "order_id" => $booking_id,
                                "user_id" => $user_id,
                                "stop_id" => '',
                                "latitude" => $lattitude,
                                "longitude" => $longitude,
                                "curtz" => 'Europe/London',
                                "hrs" => '+01:00',
                                "web" => $cdate,
                                "status_code" => $status_code,
                                "ord_id" => $order_id
                            );
                            $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                            $order_details = array();
                            if ($user_id != "") {
                                $getorderdetails = $this->common->gettbldata(
                                    array(
                                        'user_id' => $user_id,
                                        'parent_id' => 0,
                                        'status <>' => '0',
                                        'trip_sts' => '0'
                                    ),
                                    'id,order_id,pickup_datetime,delivery_datetime,pickup_country,delivery_country,pickup_city,delivery_city,quantity,weight,volume,parent_id',
                                    'tb_orders',
                                    0,
                                    0
                                );
                                if (!empty($getorderdetails)) {
                                    foreach ($getorderdetails as $res) {
                                        $total_quantity = $res['quantity'];
                                        $total_volume = $res['weight'];
                                        $total_weight = $res['volume'];
                                        /*
                                         * $getordercargocount= $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $res['id'] . "' AND status ='1'");
                                         * if($getordercargocount->num_rows() >0){
                                         * $total_quantity = $getordercargocount->row()->total_quantity;
                                         * $total_volume = $getordercargocount->row()->total_volume;
                                         * $total_weight = $getordercargocount->row()->total_weight;
                                         * }
                                         */
                                        $recent_status = 0;
                                        $pickup_date = $res['pickup_datetime'];
                                        if ($pickup_date != "") {
                                            $pickup_date = strtotime($pickup_date);
                                        }
                                        $delivery_date = $res['delivery_datetime'];
                                        if ($delivery_date != "") {
                                            $delivery_date = strtotime($delivery_date);
                                        }
                                        $container_id = $res['order_id'];
                                        $containernum = $this->db->query(
                                            "SElECT ref_value FROM tb_order_references WHERE order_id ='" . $res['id'] . "' AND reference_id='CTR' ORDER BY id DESC LIMIT 1"
                                        );
                                        if ($containernum->num_rows() > 0) {
                                            $container_id = $containernum->row()->ref_value;
                                        }
                                        $ordstatus = array();
                                        $checkStatus = $this->db->query(
                                            "SELECT id,status_code FROM `tb_order_status` WHERE order_id = '" . $res['id'] . "' AND status_id != 0 AND status = 1 ORDER BY FIELD(status_code,'RY', 'ON', 'ED', 'ER') DESC limit 1"
                                        );
                                        $ordstatus['ARRIVED'] = false;
                                        $ordstatus['OPEN'] = false;
                                        $ordstatus['CLOSED'] = false;
                                        $ordstatus['DEPARTED'] = false;
                                        if ($checkStatus->num_rows() > 0) {
                                            if ($checkStatus->row()->status_code == "RY") {
                                                $ordstatus['OPEN'] = true;
                                            } else {
                                                if ($checkStatus->row()->status_code == "ON") {
                                                    $ordstatus['CLOSED'] = true;
                                                } else {
                                                    if ($checkStatus->row()->status_code == "ED") {
                                                        $ordstatus['DEPARTED'] = true;
                                                    } else {
                                                        if ($checkStatus->row()->status_code == "ER") {
                                                        }
                                                    }
                                                }
                                            }
                                        } else {
                                            $ordstatus['ARRIVED'] = true;
                                        }
                                        /*
                                         * $ordstatus['ARRIVED'] = true;
                                         * $ordstatus['OPEN'] = true;
                                         * $ordstatus['CLOSED'] = true;
                                         * $ordstatus['DEPARTED'] = true;
                                         * $sts = '';
                                         * $chksts = $this->db->select('id,status_code')->get_where('tb_order_status',array('order_id'=>$res['id'],"status"=>1));
                                         * if($chksts->num_rows()>0){
                                         * $sts = "";
                                         * foreach($chksts->result_array() as $chkst){
                                         * if($chkst['status_code'] == "RY"){
                                         * $ordstatus['ARRIVED'] = false;
                                         * $sts = 'RY';
                                         * }
                                         * if($chkst['status_code'] == "ON"){
                                         * if($sts == 'RY'){
                                         * $ordstatus['OPEN'] = false;
                                         * $sts = 'ON';
                                         * }
                                         * }else{
                                         * if($sts == 'RY'){
                                         * $ordstatus['OPEN'] = true;
                                         * }
                                         * }
                                         * if($chkst['status_code'] == "ED"){
                                         * if($sts == 'ON'){
                                         * $ordstatus['CLOSED'] = false;
                                         * $sts = 'ED';
                                         * }
                                         * }else{
                                         * if($sts == 'ON'){
                                         * $ordstatus['CLOSED'] = true;
                                         * }else{
                                         * $ordstatus['CLOSED'] = false;
                                         * }
                                         * }
                                         * if($chkst['status_code'] == "ER"){
                                         * if($sts == 'ED'){
                                         * $ordstatus['DEPARTED'] = false;
                                         * }
                                         * }else{
                                         * if($sts == 'ED'){
                                         * $ordstatus['DEPARTED'] = true;
                                         * }else{
                                         * $ordstatus['DEPARTED'] = false;
                                         * }
                                         * }
                                         * }
                                         * }else{
                                         * $ordstatus['OPEN'] = false;
                                         * $ordstatus['CLOSED'] = false;
                                         * $ordstatus['DEPARTED'] = false;
                                         * }
                                         */
                                        $order_details[] = array(
                                            'order_row_id' => $res['id'],
                                            'order_id' => $res['order_id'],
                                            'container_id' => $container_id,
                                            'pickup_city' => $res['pickup_city'],
                                            'delivery_city' => $res['delivery_city'],
                                            'total_quantity' => round($total_quantity),
                                            'total_volume' => $total_volume,
                                            'total_weight' => $total_weight,
                                            'pickup_date' => $pickup_date,
                                            'delivery_date' => $delivery_date,
                                            'delivery_country' => $res['delivery_country'],
                                            'pickup_country' => $res['pickup_country'],
                                            'status' => $ordstatus
                                        );
                                    }
                                }
                            }
                            $data = array(
                                'status' => '1',
                                'data' => $order_details,
                                'message' => 'Success'
                            );
                        } else {
                            $data = array(
                                'status' => '0',
                                'message' => 'Status updation failed',
                                'data' => array()
                            );
                        }
                    } else {
                        $data = array(
                            'status' => '0',
                            'message' => 'Already Status existed',
                            'data' => array()
                        );
                    }
                } else {
                    $data = array(
                        'status' => '0',
                        'message' => 'Status updation failed',
                        'data' => array()
                    );
                }
            } else {
                $data = array(
                    'status' => '0',
                    'message' => 'Status updation failed',
                    'data' => array()
                );
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function updatestatusbymanifest()
    {
        $status = '0';

        if (isset($_POST)) {
            $manifest_no = isset($_POST['manifest_no']) ? $_POST['manifest_no'] : "";
            if ($manifest_no != "") {
                $orders = $this->common->gettbldata(array(
                                                        'ref_value' => $manifest_no,
                                                        'reference_id' => 'MN'
                                                    ), 'order_id', 'tb_order_references', 0, 0);
                if (!empty($orders)) {
                    $code = '2490';
                    $select = "id,status_code";
                    $table = "tb_status_master";
                    $where = array(
                        "status_code" => $code,
                        'status' => 1
                    ); // goods loaded by delivery
                    $statusinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (!empty($statusinfo)) {
                        $status_id = $statusinfo['id'];
                        $stop_type = 'P';
                        $createdon = date('Y-m-d H:i:s');
                        $stop_id = 0;
                        $stop_detail_id = 0;
                        foreach ($orders as $ord) {
                            /*
                             * $order = $this->common->gettblrowdata(array('id'=>$ord['order_id']),'id,shift_id,trip_id','tb_orders',0,0);
                             * $innr_array=array('order_id'=>$order['id'],'shipment_id'=>$order['shift_id'],'stop_id'=>$stop_id,'stop_detail_id'=>$stop_detail_id,'stop_type'=>$stop_type,'trip_id'=>$order['trip_id'],'status_id'=>$status_id,'status_code'=>$code,'status'=>1,'createdon'=>$createdon);
                             * $check_array=array('order_id'=>$order['id'],'shipment_id'=>$order['shift_id'],'stop_id'=>$stop_id,'stop_detail_id'=>$stop_detail_id,'stop_type'=>$stop_type,'trip_id'=>$order['trip_id'],'status_id'=>$status_id,'status_code'=>$code);
                             * $chk_qry = $this->db->select("id")->get_where('tb_stop_status',$check_array);
                             * if($chk_qry->num_rows() == 0){
                             * $stsins = $this->db->insert('tb_stop_status',$innr_array);
                             * }else{
                             * $stsins = $this->db->where_in("id",array("id"=>$chk_qry->row()->id))->update("tb_stop_status",$innr_array);
                             * }
                             */
                            $curtz = $this->session->userdata("usr_tzone")['timezone'];
                            $status_date = getdatetimebytimezone($curtz, $createdon, DFLT_TZ);
                            $createdon = $status_date['datetime'];
                            $innr_array = array(
                                'order_id' => $ord['order_id'],
                                'status_id' => $status_id,
                                'status_code' => $code,
                                'status' => 1,
                                'status_date' => $createdon,
                                'createdon' => $createdon,
                                'updatedon' => $createdon
                            );
                            $check_array = array(
                                'order_id' => $ord['order_id'],
                                'status_id' => $status_id,
                                'status_code' => $code
                            );
                            $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                            if ($chk_qry->num_rows() == 0) {
                                $stsins = $this->db->insert('tb_order_status', $innr_array);
                                /* log_message('error',json_encode($innr_array)); */
                            } else {
                                $stsins = $this->db->where_in("id", array(
                                    "id" => $chk_qry->row()->id
                                ))
                                    ->update("tb_order_status", $innr_array);
                            }
                            $status = '1';
                            $orderinfo = $this->common->gettblrowdata(
                                array(
                                    'id' => $ord['order_id']
                                ),
                                'id,plat,plng,dlat,dlng,vendor_id,shift_id,user_id',
                                'tb_orders',
                                0,
                                0
                            );
                            if (!empty($orderinfo['shift_id'])) {
                                $this->driver_creation($orderinfo);
                            }
                        }
                    }
                }
            }
        }
        $data = array(
            'status' => $status
        );
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function driver_creation($order)
    {
        $vehicle_id = $driver_id = $sloc = '';
        $ordid = $order['id'];
        $userid = $order['user_id'];
        $shift_id = $order['shift_id'];
        $plat = $order['plat'];
        $plng = $order['plng'];
        $dlat = $order['dlat'];
        $dlng = $order['dlng'];
        $vendor_id = $order['vendor_id'];
        $curdt = date('Y-m-d H:i:s');
        if ($vendor_id == 310) {
            $vehicle_name = "BORDERVEHICLE";
            $driver_name = "BORDERdriver";
        } else {
            $vehicle_name = "BONDSVEHICLE";
            $driver_name = "BONDSdriver";
        }
        $where = array(
            'truck_number' => 'VEHICLE',
            'register_number' => $vehicle_name,
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_trucks_data";
        $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($chkemp) == 0) {
            $inn_arr = array(
                'truck_number' => 'VEHICLE',
                'truck_type' => 1,
                'register_number' => $vehicle_name,
                'route' => 'VEHICLE',
                'user_id' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $vehicle_id = $this->common->insertTableData("tb_trucks_data", $inn_arr);
        } else {
            $vehicle_id = $chkemp['id'];
        }
        $where = array(
            'name' => $driver_name,
            'user_id' => $userid
        );
        $select = "id";
        $table = "tb_truck_drivers";
        $dricheck = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($dricheck) == 0) {
            $inn_arr = array(
                'name' => $driver_name,
                'password' => 'TVRJek5EVTI=',
                'user_id' => $userid,
                'createdby' => $userid,
                'status' => 'Active',
                'createdon' => $curdt
            );
            $driver_id = $this->common->insertTableData("tb_truck_drivers", $inn_arr);
        } else {
            $driver_id = $dricheck['id'];
        }

        if ($vehicle_id != "" && $driver_id != "") {
            $stid = 10;
            $stcode = "0212";
            $chqry = $this->db->select("id")->get_where("tb_trips", array(
                'shift_id' => $shift_id,
                'vehicle_id' => $vehicle_id,
                'driver_id' => $driver_id
            ),                                          1, 0);
            if ($chqry->num_rows() == 0) {
                $latitude = $plat;
                $longitude = $plng;
                $triparr = array(
                    'shift_id' => $shift_id,
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'stime' => $curdt,
                    'splace' => "",
                    'eplace' => "",
                    'start_reading' => 0,
                    'end_reading' => 0,
                    'created_on' => $curdt,
                    'updated_on' => $curdt,
                    'status' => 1,
                    'trip_type' => 0,
                    'transit_status' => 0,
                    "plat" => $latitude,
                    "plng" => $longitude
                );
                $tripid = $this->common->insertTableData('tb_trips', $triparr);
                $insarry = array(
                    "shipment_id" => $shift_id,
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "",
                    "trip_id" => $tripid,
                    "status_id" => $stid,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "status" => 1,
                    "reason" => "From ASN order data",
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stcode,
                    "createdon" => $curdt,
                    'loc_name' => $sloc
                );
                $ins = $this->db->insert("tb_stop_status", $insarry);
                /* update orders table */
                $ordwhr = array(
                    "shift_id" => $shift_id
                );
                $ordset = array(
                    "trip_id" => $tripid
                );
                $upd = $this->db->set($ordset)
                    ->where($ordwhr)
                    ->update("tb_orders");
            }
            $where = array(
                'shft_id' => $shift_id,
                'user_id' => $userid,
                "status" => 1
            );
            $select = "id";
            $table = "tb_shft_veh";
            $shiftcheck = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($shiftcheck) > 0) {
                $upd = $this->db->where(array(
                                            "shft_id" => $shift_id
                                        ))->update("tb_shft_veh", array(
                    "vehicle_id" => $vehicle_id
                ));
            }
            $where = array(
                'vendor_id' => $vendor_id,
                'vehicle_id' => $vehicle_id,
                "status" => 1
            );
            $select = "id";
            $table = "tb_vendor_vehicles";
            $ven_veh_check = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($ven_veh_check) == 0) {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'vendor_id' => $vendor_id,
                    'status' => 1,
                    'createdon' => $curdt
                );
                $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr);
            }
            $chk = $this->db->select("id,driver_id,status")
                ->order_by("id", "DESC")
                ->get_where("tb_vehicles_drivers", array(
                    "vehicle_id" => $vehicle_id
                ));
            if ($chk->num_rows() > 0) {
                if ($driver_id == $chk->row()->driver_id) {
                    $upd = $this->db->where(array(
                                                "id" => $chk->row()->id
                                            ))
                        ->update("tb_vehicles_drivers", array(
                            "status" => 1
                        ));
                } else {
                    $arr = array(
                        'vehicle_id' => $vehicle_id,
                        'driver_id' => $driver_id,
                        'imei' => "",
                        'status' => 1,
                        'createdon' => $curdt,
                        'updatedon' => $curdt
                    );
                    $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                }
            } else {
                $arr = array(
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'imei' => "",
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt
                );
                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
            }
            $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                "driver_id" => $driver_id,
                "vehicle_id" => $vehicle_id
            ),                                          1, 0);
            if ($chk11->num_rows() > 0) {
                $upd = $this->db->where(array(
                                            "id" => $chk11->row()->id
                                        ))
                    ->update("tbl_assigned_drivers", array(
                        "status" => "1",
                        'updated_on' => $curdt
                    ));
            } else {
                $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                    "driver_id <>" => $driver_id,
                    "vehicle_id" => $vehicle_id,
                    "status" => 1
                ),                                           1, 0);
                if ($chk111->num_rows() == 0) {
                    $ins = $this->common->insertTableData("tbl_assigned_drivers", array(
                        "vehicle_id" => $vehicle_id,
                        "user_id" => $userid,
                        "driver_id" => $driver_id,
                        "mobile_no" => $driver_id,
                        "from_time" => $curdt,
                        "to_time" => $curdt,
                        "status" => "1",
                        'created_on' => $curdt
                    ));
                } else {
                    $upd = $this->db->where(array(
                                                "id" => $chk111->row()->id
                                            ))
                        ->update("tbl_assigned_drivers", array(
                            "driver_id" => $driver_id,
                            'updated_on' => $curdt
                        ));
                }
            }
        }
    }

    public function printable($array)
    {
        $ret = [];
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $ret[$key] = $this->printable($value);
            } else {
                if (!isset($value) || $value == null) {
                    $value = "";
                }
                $ret[$key] = "$value";
            }
        }
        return $ret;
    }

    /* sub orders by order */
    public function getsuborders($id)
    {
        $ref1 = $this->db->query("SELECT id FROM tb_orders WHERE parent_id=$id AND status!=0");
        $resp = array();
        if ($ref1->num_rows() > 0) {
            foreach ($ref1->result() as $hi) {
                $resp[] = $hi->id;
            }
        }
        return $resp;
    }

    public function checkforupdates()
    {
        $data = array(
            'status' => '0',
            'data' => array()
        );
        $cdate = date('Y-m-d H:i:s');
        if (isset($_POST)) {
            $version_name = isset($_POST['version_name']) ? $_POST['version_name'] : "";
            if ($version_name != "") {
                $appdir = "./mobileappversion";
                $files = array();
                if ($handle = opendir($appdir)) {
                    while (false !== ($file = readdir($handle))) {
                        if (preg_match("/^.*\.(apk)$/i", $file)) {
                            $fpath = $appdir . '/' . $file;
                            if (file_exists($fpath)) {
                                $files[filemtime($fpath)] = $fpath;
                            }
                        }
                    }
                    closedir($handle);
                    // sort
                    ksort($files);
                    // find the last modification
                    $reallyLastModified = end($files);
                    foreach ($files as $file) {
                        $lastModified = date('F d Y, H:i:s', filemtime($file));
                        if (strlen($file) - strpos($file, ".apk") == 4) {
                            if ($file == $reallyLastModified) {
                                // do stuff for the real last modified file
                                $latestapp = $reallyLastModified;
                                $chkexists = str_replace($appdir . "/", "", $latestapp);
                                $chkversion = str_replace(".apk", "", $chkexists);
                                if ($chkversion != $version_name) {
                                    $new = str_replace("./", "", $latestapp);
                                    $data = array(
                                        'status' => '1',
                                        'data' => base_url() . $new
                                    );
                                }
                            }
                            /* echo "<tr><td><input type=\"checkbox\" name=\"box[]\"></td><td><a href=\"$file\" target=\"_blank\">$file</a></td><td>$lastModified</td></tr>"; */
                        }
                    }
                }
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    /**
     * uniqlo services (user scan for order to send docket label)
     *
     *
     *
     * @param Array Post request data
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function getuniqloscandata()
    {
        $data = array(
            'status' => '0',
            'message' => 'Failed',
            'data' => ''
        );
        $cdate = date('Y-m-d H:i:s');
        $post = $this->input->post(null, true);
        if (isset($post)) {
            $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
            $user_id = isset($post['user_id']) ? $post['user_id'] : "0";
            $reprint = isset($post['reprint']) ? $post['reprint'] : "0";
            if ($order_id != "0" && $order_id != "") {
                $ordid = "";
                $orefs = $this->common->gettblrowdata(
                    array("reference_id" => 'PO', "ref_value" => $order_id, "status" => 1),
                    "id,order_id",
                    "tb_order_references",
                    0,
                    0
                );
                if (count($orefs) > 0) {
                    $ordid = $orefs['order_id'];
                } else {
                    $orefs2 = $this->common->gettblrowdata(
                        array("reference_id" => 'XSR', "ref_value" => $order_id, "status" => 1),
                        "id,order_id",
                        "tb_order_references",
                        0,
                        0
                    );
                    if (count($orefs2) > 0) {
                        $ordid = $orefs2['order_id'];
                    } else {
                        $orefs1 = $this->common->gettblrowdata(
                            array("reference_id" => 'DQ', "ref_value" => $order_id, "status" => 1),
                            "id,order_id",
                            "tb_order_references",
                            0,
                            0
                        );
                        if (count($orefs1) > 0) {
                            $ordid = $orefs1['order_id'];
                        }
                    }
                }
                if ($ordid != "") {
                    $refs = $this->common->gettblrowdata(
                        array("order_id" => $ordid, "reference_id" => 'AWB', "ref_value <>" => '', "status" => 1),
                        "id,ref_value",
                        "tb_order_references",
                        0,
                        0
                    );
                    if (count($refs) > 0) {
                        $docket = $refs['ref_value'];
                        /*check print done or not*/
                        $chkwhr = array("id" => $ordid, "is_created" => 2);
                        $chkprint = $this->common->gettblrowdata($chkwhr, "id", "tb_orders", 0, 0);
                        $isprinted = count($chkprint);
                        if (($reprint == '1') || ($isprinted == '0')) {
                            $this->load->library("uniqloediservices");
                            /*send docket label to MFT folder for SL*/
                            $senddocket = $this->uniqloediservices->senddocketnumber($ordid);
                            if (!empty($senddocket)) {
                                /*printing docket label*/
                                $ordinfo = array("order_id" => $ordid);
                                $lbl = $this->uniqloediservices->generatedocketlabel($ordinfo);
                                if ($lbl != "") {
                                    $sentprint = $this->printdocketLabel($lbl);
                                    $updwhr = array("id" => $ordid);
                                    $updset = array("is_created" => 2);
                                    $upd = $this->common->updatetbledata("tb_orders", $updset, $updwhr);
                                    $data = array(
                                        'status' => 1,
                                        'message' => 'AWB Number: ' . $docket . ', Scanning Done!',
                                        'data' => $docket
                                    );
                                } else {
                                    /*send notification if not docket number for scanned order*/
                                    $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where(
                                        "tb_users",
                                        array("id" => $senddocket['user_id'], "emailid !=" => ""),
                                        1,
                                        0
                                    );
                                    if ($getusermail->num_rows() > 0) {
                                        $receivemail = $getusermail->row()->emailid;
                                        $receivename = $getusermail->row()->name;
                                        $receivecc = $getusermail->row()->cc_mails;
                                        $this->load->library('email');
                                        $this->email->to($receivemail, $receivename);
                                        if ($receivecc != "") {
                                            $this->email->cc($receivecc);
                                        }
                                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                                        $this->email->subject(
                                            'eTN: ' . $order_id . ' Shipment is not assigned to carrier,trying to scan for this order'
                                        );
                                        $this->email->set_mailtype('html');
                                        $data1['order_num'] = $order_id;
                                        $data1['docket'] = $docket;
                                        $body = $this->load->view('mail_forms/docketmail', $data1, true);
                                        $this->email->message($body);
                                        $sendmail = $this->email->send();
                                    }
                                    $data = array(
                                        'status' => 0,
                                        'message' => 'AWB Number: ' . $docket . ', Something went wrong,please try again',
                                        'data' => $docket
                                    );
                                }
                            }
                        } else {
                            $data = array(
                                'status' => 2,
                                'message' => 'AWB Number: ' . $docket . ', Print done already!,do you want to Re-Print again',
                                'data' => $docket
                            );
                        }
                    } else {
                        /*send notification if not docket number for scanned order*/
                        $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where(
                            "tb_users",
                            array(
                                "id" => $user_id,
                                "emailid !=" => ""
                            ),
                            1,
                            0
                        );
                        if ($getusermail->num_rows() > 0) {
                            $receivemail = $getusermail->row()->emailid;
                            $receivename = $getusermail->row()->name;
                            $receivecc = $getusermail->row()->cc_mails;
                            $this->load->library('email');
                            $this->email->to($receivemail, $receivename);
                            if ($receivecc != "") {
                                $this->email->cc($receivecc);
                            }
                            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                            $this->email->subject(
                                'eTN: ' . $order_id . ' Shipment is not assigned to carrier,trying to scan for this order'
                            );
                            $this->email->set_mailtype('html');
                            $data1['order_num'] = $order_id;
                            $data1['docket'] = "";
                            $data1['page_title'] = "Docket not found";
                            $body = $this->load->view('mail_forms/docketmail', $data1, true);
                            $this->email->message($body);
                            $sendmail = $this->email->send();
                        }
                        $data = array(
                            'status' => 0,
                            'message' => 'Shipment is not assigned to any carrier,please create the trip and try it once',
                            'data' => ""
                        );
                    }
                } else {
                    $data = array(
                        'status' => 0,
                        'message' => 'Order number is not available in svkonekt',
                        'data' => ""
                    );
                }
            }
        }
        $data = $this->printable($data);

        log_error(UNIQLO_LOG_PREFIX . "getuniqloscandata outbound data: " . implode(', ', $data));

        echo json_encode($data);
    }

    /**
     * print label robgridley/zebra library
     *
     *
     *
     * @param String Image path
     * @return    Boolean
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function printdocketLabel($label)
    {
        log_error(UNIQLO_LOG_PREFIX . "printdocketLabel inbound data: " . $label);

        ini_set('max_execution_time', '300');
        $pipaddr = UNIQLO_PRINTER_IP;
        $pport = PRINTING_SERVICE_DEFAULT_PORT;
        try {
            $labelpath = "./assets/swiftlog/docketlabel/" . $label;
            $newimgpath = './assets/swiftlog/eTNLabel.png';
            $im = new Imagick();
            $im->setResolution(360, 360);
            $im->readImage($labelpath);
            $im->setImageFormat('jpeg');
            $im->setImageCompression(Imagick::COMPRESSION_JPEG);
            $im->setImageCompressionQuality(100);
            $im->writeImage($newimgpath);
            $im->clear();
            $im->destroy();
            $decoder = GdDecoder::fromPath($newimgpath);
            $image = new Image($decoder);
            $zpl = new Builder(); /* $zpl = Zebra Printer Label */
            $zpl->fo(10, 10)
                ->gf($image)
                ->fs();
            $client = new Client($pipaddr, $pport);
            $client->send($zpl);

            log_error(
                UNIQLO_LOG_PREFIX . "Docker label printed successfully"
            );
        } catch (Exception $e) {
            log_error(
                UNIQLO_LOG_PREFIX .
                "Error with printing docker label: " . $e->getMessage()
            );

            return $e->getMessage();
        }
    }

    /**
     * @throws BadRequestException
     * @throws JsonException
     */
    public function sendLogsToBackend(): void
    {
        $postLogData = $this->input->post('data', true) ?? '';
        if (empty($postLogData)) {
            throw new BadRequestException("POST data should not be empty.");
        }
        $decodedLogData = json_decode($postLogData, true, 512, JSON_THROW_ON_ERROR);
        if (!isset($decodedLogData['logs']) || empty($decodedLogData['logs'])) {
            throw new BadRequestException("POST data should not be empty.");
        }
        foreach ($decodedLogData['logs'] as $logData) {
            if (!empty($logData["timeStamp"]) && !empty($logData["message"])) {
                log_message('error', "XDocMobileAppLogs > timeStamp: " . $logData["timeStamp"] . ", message: " . $logData['message']);
            }
        }
        echo json_encode(['status' => 1], JSON_THROW_ON_ERROR);
    }
}
