<?php
defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');
class Etruckapi extends CI_Controller
{
    use \App\ShiftsData\AddressesFromShiftTrait;

    public function __construct()
    {
        parent::__construct();
        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400'); // cache for 1 day
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper('date');
        $this->load->library(['uuid','statusintigration','sendfirebase','smsnotifier']);
        $this->load->model(['common','cabmodel']);
    }
    public function index()
    {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }
    public function driverLogin()
    {
        $response = array();
        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {
            $mobile = isset($_POST["mobile"]) ? $_POST["mobile"] : '';
            $pwd    = isset($_POST["password"]) ? $_POST["password"] : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            $imei   = isset($_POST["imei"]) ? $_POST["imei"] : '';
            $phone   = isset($_POST["mobile_number"]) ? $_POST["mobile_number"] : '';
            if ($mobile != "") {
                $password = password_hash($pwd, PASSWORD_DEFAULT);

                $curdt   = date('Y-m-d H:i:s');
                /*check for customer login*/
                $whr = array("d.phone" => $mobile, "d.password" => $password, "d.status" => 1);
                $this->db->select('d.*,u.mobile_no');
                $this->db->from('tb_customers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                $numrows =  $sql->num_rows();
                $insdata = array("mobile" => $mobile, "password" => $pwd, "imei" => $imei, "status" => $numrows);
                $res = $this->db->insert("tb_employee_login_logs", $insdata);
                if ($numrows > 0) {
                    $id = $sql->row()->id;
                    if ($gcm_id != "" && $imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei, "gcm_id" => $gcm_id));
                    } else if ($imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_customers", array("imei" => $imei));
                    }
                    $data = $sql->row_array();
                    $response = array("status" => 2, "data" => $data);
                }else{
                    $response = array("status" => 0, "data" => "Not Found");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        echo json_encode($response);
    }
    public function getDriverData()
    {
        $response = array();
        $response = array("status" => 0, "data" => "Not Found");
        /*log_message('error',json_encode($_POST));*/
        if (isset($_POST)) {
            $curdt   = date('Y-m-d H:i:s');
            $id = isset($_POST["id"]) ? $_POST["id"] : '';
            $user_id = isset($_POST["password"]) ? $_POST["user_id"] : '';
            $gcm_id  = isset($_POST["gcm_id"]) ? $_POST["gcm_id"] : '';
            $imei    = isset($_POST["imei"]) ? $_POST["imei"] : '';
            if ($user_id != "" || $id != "") {
                $qry = $this->db->query("SELECT t.register_number,t.id from tbl_assigned_drivers a,tb_trucks_data t,tb_truck_drivers d where a.driver_id=$id AND t.id=a.vehicle_id AND a.status=1 AND d.status='Active' AND d.id=a.driver_id AND t.status='Active' ORDER BY a.id DESC LIMIT 1");
                $veh    = "";
                $veh_id = "";
                if ($qry->num_rows() > 0) {
                    $veh    = $qry->row()->register_number;
                    $veh_id = $qry->row()->id;
                }
                if ($gcm_id != "" && $imei != "") {
                    $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei, "gcm_id" => $gcm_id, 'updatedon' => $curdt));
                } else if ($imei != "") {
                    $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei, 'updatedon' => $curdt));
                }
                $whr = array("d.id" => $id, "d.status" => "Active");
                $this->db->select('d.*,u.mobile_no');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql    = $this->db->get();
                $data   = $sql->row_array();
                $veh    = "";
                $veh_id = "";
                if ($qry->num_rows() > 0) {
                    $veh    = $qry->row()->register_number;
                    $veh_id = $qry->row()->id;
                }
                $data['vehicle']    = $veh;
                $data['vehicle_id'] = $veh_id;
                $data['trip_id']    = "";
                if ($veh_id != "") {
                    $whr  = array("vehicle_id" => $veh_id, "driver_id" => $id, "status" => "1");
                    $trip = $this->db->select('id')->order_by('id','DESC')->get_where("tb_trips",$whr,1,0);
                    if ($trip->num_rows() > 0) {
                        $data['trip_id'] = $trip->row()->id;
                    }
                }
                $response = array("status" => 1, "data" => $data);
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        echo json_encode($response);
    }
    /* after clicked on accept in shipment stops screen */
    public function startTrip()
    {
        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $data["shift_id"]      = isset($post->shift_id) ? $post->shift_id : '';
            $data["vehicle_id"]    = isset($post->vehicle_id) ? $post->vehicle_id : '';
            $data["trip_type"]     = isset($post->trip_type) ? $post->trip_type : 0;
            $data["driver_id"]     = isset($post->driver_id) ? $post->driver_id : '';
            $data["splace"]        = isset($post->splace) ? $post->splace : '';
            $data["eplace"]        = isset($post->eplace) ? $post->eplace : '';
            $data["start_reading"] = isset($post->odemeter) ? $post->odemeter : '0';
            $imei = isset($post->imei) ? $post->imei : '';
            $data["stime"] = $data["created_on"] = date("Y-m-d H:i:s");
            $arr = array("id" => $data["driver_id"], "imei" => $imei, "status" => 'Active');
            /*$arr = array("id"=>$data["driver_id"],"status"=>'Active');*/
            $chkqry = $this->db->select("id")->get_where("tb_truck_drivers", $arr)->num_rows();
            if ($chkqry > 0) {
                /*commented code for stop duplicate shifts */
                /* here need to send SHIPMENT_CONFIRM status to otm */
                $data["start_imei"] = $imei;
                $ins = $this->db->insert("tb_trips", $data);
                $id = $this->db->insert_id();
                $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $data["driver_id"], "trip_id" => $id, "imei" => $imei, "createdon" => $data["created_on"]));
                $shift = $this->db->select('order_id')->order_by('id','DESC')->where(array("shift_id" => $data["shift_id"],'ship_type'=>'P'))->get("tb_employee")->row();
                $postdata = array(
                    "shipment_id" => $data["shift_id"],
                    "trip_id"     => $id,
                    "driver_id"   => $data["driver_id"],
                    "order_id"    => $shift->order_id,
                );
                $sts = $this->statusintigration->shipmentconfirm($postdata);
                $stime = $this->db->select('stime,etime')->limit(1)->where("id", $data["shift_id"])->get("tb_shifts");
                if ($id > 0) {
                    $empdata            = array();
                    $empdata["trip_id"] = $id;
                    $response           = array("status" => 1, "data" => array($empdata));
                } else {
                    $response = array("status" => 0, "data" => "Failed to Start");
                }
            } else {
                $response = array("status" => 3, "data" => "Please re-login to continue");
            }
        }
        echo json_encode($response);
    }

    public function sendTripAlert($trip = null)
    {
        $result = array();
        if ($trip != null) {
            $q    = $this->db->query("select employee_id from tb_trip_employee where trip_id=$trip");
            $emps = array();
            if ($q->num_rows() > 0) {
                foreach ($q->result() as $qr) {
                    array_push($emps, $qr->employee_id);
                }
            }
            $result = $this->sendFirstAlert($trip, $emps);
        }
        return $result;
    }
    public function sendFirstAlert($trip = null, $emps = array())
    {
        $result = array();
        $tt     = $this->db->query("select t.driver_id,t.vehicle_id,sv.id,sv.register_number from tb_trips t,tb_shft_veh sv where t.id=$trip and sv.vehicle_id=t.vehicle_id and sv.shft_id=t.shift_id and sv.status=1 order by sv.id desc limit 1");
        if ($tt->num_rows() > 0) {
            $t           = $tt->row();
            $driver      = $t->driver_id;
            $vehicle_id      = $t->vehicle_id;
            $shft_veh_id = $t->id;
            $reg         = $t->register_number;
            if (count($emps) == 0) {
                $arr  = array("shft_veh_id" => $shft_veh_id, "status" => 1);
                $sql2 = $this->db->select("priority,user_id")->group_by("priority")->order_by("priority", "asc")->get_where("tb_shft_veh_emp", $arr, 1, 0);
            } else {
                $sql2 = $this->db->select("priority,user_id")->where("shft_veh_id", $shft_veh_id)->where("status", 1)->where_not_in("emp_id", $emps)->group_by("priority")->order_by("priority", "asc")->limit(1)->get("tb_shft_veh_emp");
            }
            if ($sql2->num_rows() > 0) {
                //check and send sms to all emp.
                $chksent = $this->db->select('id')->get_where('tb_tripfirst_alerts', array('trip_id' => $trip))->num_rows();
                $user_id = $sql2->row()->user_id;
                if ($chksent == 0) {
                    $this->db->select('d.contact_num');
                    $this->db->from('tb_truck_drivers d');
                    $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
                    $this->db->where('t.id', $trip);
                    $this->db->limit(1);
                    $drivermobile = $this->db->get();
                    $drivernum    = "";
                    if ($drivermobile->num_rows() > 0) {
                        $drivernum = $drivermobile->row()->contact_num;
                    }
                    $link   = $this->getLink($driver, $trip);
                    $msql1  = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1";
                    $mquery = $this->db->query($msql1);
                    $ecnt   = $mquery->num_rows();
                    if ($ecnt > 0) {
                        $sntdata = array('trip_id' => $trip, 'module' => 'Truck Auto Arrival Alert Once', 'message' => $drivernum, 'sent_count' => $ecnt, 'created_on' => date('Y-m-d H:i:s'));
                        $sendres = $this->db->insert('tb_tripfirst_alerts', $sntdata);
                        foreach ($mquery->result() as $rw) {
                            $result['sms_data'][] = $this->sendBulkAlert($trip, $rw->emp_id, $rw->phone, $rw->name, $drivernum, $reg, $link, $user_id);
                        }
                    }
                }
                $sql1 = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1 and priority=" . $sql2->row()->priority;
                $query = $this->db->query($sql1);
                if ($query->num_rows() > 0) {
                    $link = $this->getLink($driver, $trip);
                    foreach ($query->result() as $emps) {
                        $res = $this->db->select('id')->get_where("tb_trip_alerts", array("trip_id" => $trip, "emp_id" => $emps->emp_id))->num_rows();
                         if ($res == 0) {
                            $distance                = $this->getDist($vehicle_id, $emps->plat, $emps->plng);
                            $result['pickup_data'][] = $this->sendAlert($trip, $emps->emp_id, $emps->phone, $emps->name, $distance, $reg, $link, $user_id);
                        }
                    }
                }
            }
        }
        return $result;
    }
    public function getLink($driver, $trip)
    {
        $link1 = base_url() . "cab/track/" . encryptIt($driver, $trip);
        $this->load->library('googleshortener');
        $link = $this->googleshortener->shorten($link1);
        return $link["id"];
    }
    public function getDist($vehicle_id, $lat, $lng)
    {
        $rr    = array('0', '0');
        $imei1 = $this->db->select("latitude,longitude")->get_where("tb_trucks_data", array('id' => $vehicle_id), 1, 0);
        if ($imei1->num_rows() > 0) {
            $mbl = $imei1->row();
            if ($lat > 0 && $lng > 0 && $mbl->latitude > 0 && $mbl->longitude > 0) {
                $d = array();
            }
            $dist = distancemetrixship($lat, $lng, $mbl->latitude, $mbl->longitude);
            $d['distance'] = $dist['disttext'];
            $d['duration'] = $dist['duratext'];
            $rr[0] = $d['distance'];
            $rr[1] = $d['duration'];
        }
        return $rr;
    }
    public function sendBulkAlert($trip, $emp, $mobile, $name, $drivernum, $veh, $link, $user_id)
    {
        $result = array();
        if ($drivernum != "") {
            $drivernum = "(" . $drivernum . ")";
        }
        $senddate = date('Y-m-d H:i:s');
        $message  = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " is started now,track your truck by " . $link;
        $smsdata  = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $senddate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message"                => $message,
            "id"                     => $sentid);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert Once", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));
        /*$sendack = $this->smsnotifier->driverarrivalsms($smsdata);*/
        return $result;
    }
    public function sendAlert($trip, $emp, $mobile, $name, $distance, $veh, $link, $user_id)
    {
        $result = array();
        $this->db->select('d.contact_num');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
        $this->db->where('t.id', $trip);
        $this->db->limit(1);
        $drivermobile = $this->db->get();
        $drivernum    = "";
        if ($drivermobile->num_rows() > 0) {
            $drivernum = "(" . $drivermobile->row()->contact_num . ")";
        }
        $senddate = date('Y-m-d H:i:s');
        $message  = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " will be reached in " . $distance[1] . ", it is in distance " . $distance[0] . ",track your truck by " . $link;
        $smsdata  = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $senddate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message"                => $message,
            "id"                     => $sentid);
        $datas = array(
            "emp_id"     => $emp,
            "trip_id"    => $trip,
            "mobile"     => $mobile,
            "message"    => $message,
            "created_on" => $senddate,
        );
        $this->db->insert("tb_trip_alerts", $datas);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));
        /*$sendack = $this->smsnotifier->driverarrivalsms($smsdata);*/
        return $result;
    }

    public function closeTrip()
    {
        if ($_POST) {
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"]        = $_POST["trip_id"];
            $this->db->query("update tb_shifts s,tb_trips t set s.status=0 where t.id=" . $data["id"] . " and t.shift_id=s.id");
            $data1["end_imei"]    = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
            $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '';
            $shipment_id          = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : '';
            $data1["etime"]       = $data1["updated_on"]       = date("Y-m-d H:i:s");
            $data1["status"]      = '0';
            $res = $this->db->where($data)->update("tb_trips", $data1);
            if ($res) {
                $shift = $this->db->select('order_id')->order_by('id','DESC')->where(array("shift_id" => $shipment_id,'ship_type'=>'P'))->get("tb_employee")->row();
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id"     => $data["id"],
                    "driver_id"   => $data["driver_id"],
                    "stop_id"     => '',
                    "order_id"    => $shift->order_id
                );
                $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id);
                if ($stop_closed) {
                    $sts = $this->statusintigration->shipmentdeliveredpartially($postdata);
                }
                $this->autoAbsent($data["id"]);
                $this->generatesummary($data["id"]);
                echo json_encode(array("status" => 1, "data" => "Closed Sucessfully"));
            } else {
                echo json_encode(array("status" => 0, "data" => "Failed to Close"));
            }
        } else {
            echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }
    public function autoAbsent($trip)
    {
        $date = date("Y-m-d H:i:s");
    }
    public function closeTripfromweb()
    {
        ob_start();
        if ($_POST) {
            $data1             = array();
            $data              = array();
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"]        = $_POST["trip_id"];
            $this->db->query("update tb_shifts s,tb_trips t set s.status=0 where t.id=" . $data["id"] . " and t.shift_id=s.id");
            $data1["end_imei"]    = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
            $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '';
            $data1["etime"]       = $data1["updated_on"]       = date("Y-m-d H:i:s");
            $data1["status"]      = '0';
            $res                  = $this->db->where($data)->update("tb_trips", $data1);
            if ($res) {
                $this->generatesummary($data["id"]);
                redirect("dashboard/livecabdetails");
            } else {
                redirect("dashboard/livecabdetails");
            }
        } else {
            redirect("dashboard/livecabdetails");
        }
    }
    public function getstopstatus($whr)
    {
        $res = array();
        $this->db->select('s.id,s.createdon,t.status_name,s.status_id');
        $this->db->from('tb_stop_status s');
        $this->db->join('tb_status_master t', 's.status_id=t.id', 'INNER');
        $this->db->where($whr);
        $this->db->order_by('s.createdon', 'DESC');
        $this->db->limit(1);
        $chkrecent = $this->db->get();
        if ($chkrecent->num_rows() > 0) {
            $res['name']      = $chkrecent->row()->status_name;
            $res['id']        = $chkrecent->row()->id;
            $res['createdon'] = $chkrecent->row()->createdon;
            $res['status_id'] = $chkrecent->row()->status_id;
        }
        return $res;
    }
    public function updateempsts($sts, $stopid, $tripid)
    {
        $curdt = date('Y-m-d H:i:s');
        $data  = array('shipment_id' => 0, 'stop_id' => $stopid, 'trip_id' => $tripid, 'status_id' => $sts, 'status' => 1, 'createdon' => $curdt);
        $insrt = $this->db->insert('tb_stop_status', $data);
        return true;
    }
    public function checkLatLng($emp)
    {
        $sql = $this->db->select("plat,plng")->get_where("tb_employee", array("id" => $emp), 1, 0);
        if ($sql->num_rows() > 0) {
            $res = $sql->row();
            if ($res->plat == "" || $res->plng == "") {
                return "true";
            } else {
                return "false";
            }
        } else {
            return "false";
        }
    }

    public function generatesummary($tripid = null)
    {
        if ($tripid != "") {
            $dist      = 0;
            $trip_type = 0;
            $totalemp  = 0;
            $sql       = $this->db->get_where("tb_trips", array("id" => $tripid, "status" => 0), 1, 0);
            $this->db->from('tb_trips')
                ->join('tb_shifts', 'tb_shifts.id = tb_trips.shift_id');
            $sql1 = $this->db->get();
            if ($sql->num_rows() > 0) {
                $emp1 = $this->db->query("select e.name,te.stime as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight from tb_employee e,tb_trip_employee te,tb_materials m where te.employee_id=e.id and m.id=e.material_id and te.trip_id=" . $tripid);
                $emp       = $this->db->query("SELECT IFNULL(t.truck_capacity,0) AS capacity, IFNULL(SUM( IF( e.status = '1', 1, 0 ) ),0) AS attcnt, count(e.employee_id) AS totcnt FROM tb_trips p, tb_trip_employee e, tb_trucks_data t WHERE p.vehicle_id = t.id AND p.status =0 AND e.trip_id = p.id AND p.id=" . $tripid);
                $start     = $sql->row()->stime;
                $end       = $sql->row()->etime;
                $imei      = $sql->row()->start_imei;
                $eimei     = $sql->row()->end_imei;
                $driverid  = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime     = $sql1->row()->startdate;
                $etime     = $sql1->row()->enddate;
                $shift          = $sql->row()->shift_id;
                $odometer_start = $sql->row()->start_reading;
                $odometer_end   = $sql->row()->end_reading;
                $trip_type      = $sql->row()->trip_type;
                $trucks_query   = $this->db->query("select * from tb_trucks_data where id=$vehicleid");
                $data           = array();
                $regg           = $this->db->query("select t.register_number,td.name,td.contact_num from tbl_assigned_drivers d,tb_truck_drivers td,tb_trucks_data t where d.driver_id=$driverid AND d.driver_id=td.id and d.status=1 and t.id=d.vehicle_id");
                if ($regg->num_rows() > 0) {
                    $reg                 = $regg->row()->register_number;
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num']  = $regg->row()->contact_num;
                } else {
                    $reg                 = "";
                    $data['driver_name'] = "";
                    $data['driver_num']  = "";
                }
                $data["trip"] = $dt = $this->db->query("SELECT s.user_id,s.startdate,s.enddate,s.eplace,s.trip_type,e.pickup as splace,e.plat as slat,e.plng as slng FROM tb_shifts s,tb_shft_veh v,tb_shft_veh_emp ve,tb_employee e where s.id=v.shft_id and v.id=ve.shft_veh_id and ve.emp_id=e.id and s.id=" . $shift . " and v.vehicle_id=" . $vehicleid . " and ve.status=1 and v.status=1 order by ve.priority asc limit 1")->row();
                $sql2         = $this->db->query("select latitude,longitude,timestamp from tb_rtdrive_locations where mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag         = 0;
                $lat          = $lng          = 0;
                $wflag        = 0;
                $dist         = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a    = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $uid          = 0;
                $cab_capacity = 0;
                $attendemp    = 0;
                $totalemp     = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $cab_capacity = $emp->row()->capacity;
                    $attendemp    = $emp->row()->attcnt;
                 }
                $uids = $this->cabmodel->getuserbytrip(array("t.id" => $tripid));
                if ($uids->num_rows() > 0) {
                    $uid = $uids->row()->user_id;
                }
                $data["noofemp"] = $totalemp;
                $arr             = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'createdon' => date('Y-m-d H:i:s'));
                $chktrip         = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0)->num_rows();
                if ($chktrip == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                $data["trip_id"]   = $tripid;
                $driver_late_query = $this->db->query("SELECT s.etime as setime,t.etime as tetime,s.empshift_start,s.trip_type FROM tb_trips t,tb_shifts s where t.id=$tripid and t.shift_id=s.id");
                $driver_late       = 0;
                $shifttime         = 0;
                if ($driver_late_query->num_rows() > 0) {
                    $setime    = date("Y-m-d H:i:s", strtotime($driver_late_query->row()->setime));
                    $tetime    = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($driver_late_query->row()->tetime))));
                    $to_time   = strtotime($setime);
                    $from_time = strtotime($tetime);
                    if ($from_time > $to_time) {
                        $driver_late = round(abs($from_time - $to_time) / 60, 2);
                    }
                    $ttype = $driver_late_query->row()->trip_type;
                    if ($ttype != 2) {
                        $shti      = $driver_late_query->row()->empshift_start;
                        $shifttime = date('H:i A', strtotime($shti));
                    } else {
                        $shifttime = "Empty";
                    }
                }
                $data["driver_late"]     = $driver_late;
                $data["empshifttime"]    = $shifttime;
                $data["distance"]        = $dist;
                $data["stime"]           = $stime;
                $data["etime"]           = $etime;
                $data["simei"]           = $imei;
                $data["eimei"]           = $eimei;
                $data["odometer"]        = $odometer_end - $odometer_start;
                $data["page_title"]      = "Trip Report";
                $data["capasity"]        = $emp->result_array();
                $data["employees"]       = $emp1;
                $data["trip_type"]       = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"]    = $trucks_query->row()->truck_weight;
                $data["truck_volume"]    = $trucks_query->row()->truck_volume;
                $data["ep"]              = geteplacebyid($uid);
                $this->load->library('email');
                $getusermail = $this->db->select("name,emailid")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                }
                $this->email->to($receivemail, $receivename);
                //$this->email->cc('bewithdhanu@gmail.com,kambhamramachandra@gmail.com');
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                if ($trip_type == 1) {
                    $this->email->subject('Trucks Return Trip Status');
                } else if ($trip_type == 2) {
                    $this->email->subject('Trucks Empty Trip Status');
                } else {
                    $this->email->subject('Trucks Trip Status');
                }
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/basicreport', $data, true);
                $this->email->message($body);
                $this->email->send();
                $insertdata    = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $data['capasity']["0"]["capacity"], 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $data['capasity']["0"]["attcnt"], 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => date('Y-m-d H:i:s'));
                $repotmaildata = $this->db->insert('tb_trips_mails', $insertdata);
                echo json_encode(array("status" => 1, "data" => $data));
            }
        }
    }

    public function savePickup($emp, $lat, $lng)
    {
        $data         = array();
        $data["plat"] = $lat;
        $data["plng"] = $lng;
        $loc          = getLocationName($lat, $lng);
        if (strlen($loc) > 0) {
            $type    = 'P';
            $emptype = $this->db->select('ship_type')->get_where('tb_employee', array('id' => $emp), 1, 0);
            if ($emptype->num_rows() > 0) {
                $type = $emptype->row()->ship_type;
            }
            if ($type == 'P') {
                $data["pickup"] = $data["address"] = $loc;
            } else {
                $data["dlat"] = $lat;
                $data["dlng"] = $lng;
                $data['drop'] = $data["address"] = $loc;
            }
        }
        $res = $this->db->where("id", $emp)->update("tb_employee", $data);
    }
    public function poduploads()
    {
        $curdt    = date('Y-m-d H:i:s');
        $response = array("status" => 0, "data" => "Upload Failed!");
        if (isset($_POST)) {
            $latitude         = isset($_POST['latitude']) ? $_POST['latitude'] : null;
            $longitude        = isset($_POST['longitude']) ? $_POST['longitude'] : null;
            $status_id        = isset($_POST['status_id']) ? $_POST['status_id'] : null;
            $trip_id          = isset($_POST['trip_id']) ? $_POST['trip_id'] : null;
            $shipment_id      = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : null;
            $stop_id          = isset($_POST['stop_id']) ? $_POST['stop_id'] : null;
            $stop_detail_id   = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : null;
            $stop_detail_type = isset($_POST['stop_detail_type']) ? $_POST['stop_detail_type'] : null;
            $driver_id        = isset($_POST['driver_id']) ? $_POST['driver_id'] : null;
            $pdfName = $fileName = "";
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = array(
                        'upload_path'   => NEW_POD_PATH,
                        'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                        'overwrite'     => true,
                    );
                    $file_name = $_FILES['file_name']['name'];
                    $file_ext= @strtolower(end(explode('.',$_FILES['file_name']['name'])));
                    $expensions= array("jpeg","jpg","png","gif","pdf");
                    if(in_array($file_ext,$expensions) === false){
                        $response = array("status" => 0, "data" => "Image Format Not Allowed");
                    }else{
                        if($file_ext == "pdf"){
                            $imgtype = "pdf";
                            $this->load->library('upload', $config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname  = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                            }
                        }else{
                            $fileName = date('dmyhis').''.$file_name;
                            $filePath = NEW_POD_PATH.$fileName;
                            $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if($file_ext == "png"){
                                $top = imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            }else{
                                $top = imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if($file_ext == "jpg" || $file_ext == "jpeg"){
                                    $imgtype = "jpeg";
                                }else{
                                    $imgtype = $file_ext;
                                }
                            }
                            header('Content-Type: image/jpeg');
                            imagejpeg($top,$filePath,$quality);
                            imagedestroy($top);
                        }
                        if($fileName != ""){
                            $imageSize = filesize(NEW_POD_PATH.$fileName);
                            $newUuid = $this->uuid->v4();
                            $filedata = ['stop_id' => $stop_id, "shipment_id" => $shipment_id, 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_id, 'imgpath' => $fileName, 'status' => 1, 'createdon' => $curdt, 'stop_detail_id' => $stop_detail_id, 'filesize' => $imageSize, 'hash' => $newUuid];
                            $res = $this->db->insert("tb_pod_uploads", $filedata);
                            $id = $this->db->insert_id();
                            if ($res) {
                                $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                            } else {
                                $response = array("status" => 0, "data" => "Something went wrong,please try again!");
                            }
                            $shift = $this->db->select('txnid')->where(array("id" => $shipment_id))->get("tb_shifts")->row();
                            if($stop_id != ""){
                                $legs = $this->db->query("select order_id from tb_employee where (stop_id='$stop_id' OR drop_stopid='$stop_id') LIMIT 1")->row();
                                $stop = $this->db->select('txncode')->where(array("id" => $stop_id))->get("tb_shiporder_stops")->row();
                            }else{
                                $stop = $this->db->select('id,txncode')->order_by('ordernumber','ASC')->get_where("tb_shiporder_stops",array("shipment_id" => $shipment_id),1,0)->row();
                                $stop_id = $stop->id;
                                $legs = $this->db->query("select order_id from tb_employee where (stop_id='$stop_id' OR drop_stopid='$stop_id') LIMIT 1")->row();
                            }
                            $cnt = $this->db->select('id')->get_where('tb_pod_uploads',array('trip_id'=>$trip_id))->num_rows();
                            if($cnt == 0){
                                $cntstr = "001";
                            }else{
                                $cntstr = "00".$cnt;
                                if($cnt > 9){
                                    $cntstr = "0".$cnt;
                                }
                            }
                            $imgtype = isset($imgtype) ? $imgtype : 'png';
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id"     => $trip_id,
                                "driver_id"   => $driver_id,
                                "stop_id"     => $stop_id,
                                "order_id"    => $legs->order_id,
                                "txn_id"      => $shift->txnid,
                                "txn_code"    => $stop->txncode,
                                "file_name"   => $fileName,
                                "file_type"   => $imgtype,
                                "inc_id"   => $cntstr,
                                'pod_type' => $status_id
                            );
                            $sts = $this->statusintigration->orderrealesestatusapi($postdata);
                        }else{
                            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }
    public function saveAsPdf($image = '')
    {
        $file = NEW_POD_PATH . $image;
        $ext  = pathinfo($file, PATHINFO_EXTENSION);
        $name = pathinfo($file, PATHINFO_FILENAME);
        $pdf  = new FPDF();
        $pdf->AddPage();
        $ext = "";
        if (strtolower($ext) == "png") {
            $ext = "PNG";
        } else if (strtolower($ext) == "jpg") {
            $ext = "JPG";
        } else if (strtolower($ext) == "jpeg") {
            $ext = "JPEG";
        } else if (strtolower($ext) == "gif") {
            $ext = "GIF";
        }
        if (!file_exists(NEW_POD_PATH)) {
            mkdir(NEW_POD_PATH, 0710, true);
        }
        $pdf->Image($file, 10, 10, 190, 0, $ext);
        $pdf->Output(NEW_POD_PATH . $name . ".pdf", 'F');
        return $name . ".pdf";
    }
    public function stopsstatuses()
    {
        $response      = array("status" => 0, "data" => "Something went wrong!");
        $data          = array('status' => 1);
        $result['yes'] = array();
        $result['no']  = array();
        $res           = $this->db->select('id,status_name,status_type')->order_by('id', 'ASC')->get_where("tb_status_master", $data);
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $r) {
                if ($r->status_type == 'yes') {
                    $result['yes'][] = array('id' => $r->id, 'status_name' => $r->status_name);
                } else {
                    $result['no'][] = array('id' => $r->id, 'status_name' => $r->status_name);
                }
            }
            $response = array("status" => 1, "data" => $result);
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    public function shipdashboard()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        if ($driver_id > 0) {
            $acc_whr   = array('driver_id' => $driver_id, 'status' => 1);
            $com_whr   = array('driver_id' => $driver_id, 'status' => 0);
            $rej_whr   = array('driver_id' => $driver_id, 'status' => 2);
            $accepted  = $this->db->select('id')->get_where('tb_trips', $acc_whr)->num_rows();
            $rejected  = $this->db->select('id')->get_where('tb_trips', $rej_whr)->num_rows();
            $completed = $this->db->select('id')->get_where('tb_trips', $com_whr)->num_rows();
            $data      = array('accepted' => $accepted, 'rejected' => $rejected, 'completed' => $completed);
            $response  = array("status" => 1, "data" => $data);
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    public function getshipments()
    {
        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            /* ''=> new, 0=> accepted , 1=> in-transit, 2=> completed */
            $driver = isset($_POST["driver_id"]) ? $_POST["driver_id"] : "";
            $imei   = isset($_POST["imei"]) ? $_POST["imei"] : "";
            $type   = isset($_POST["type"]) ? $_POST["type"] : "";
            if ($driver != "" && $imei != "") {
                $whr = array("id" => $driver, "status" => "Active");
                $res = $this->db->select("id,user_id")->get_where("tb_truck_drivers", $whr, 1, 0);
                if ($res->num_rows() > 0) {
                    $upd = $this->db->where(array("id" => $driver))->update("tb_truck_drivers", array("imei" => $imei));
                    $chkdri = $this->db->select("id")->get_where("tbl_assigned_drivers", array("driver_id" => $driver), 1, 0);
                    if ($chkdri->num_rows() > 0) {
                        $upd = $this->db->where(array("driver_id" => $driver))->update("tbl_assigned_drivers", array("imei" => $imei));
                    }
                    $resqry = $res->row();
                    $uid    = $resqry->user_id;
                    if ($type == "") {
                        $sql = "select '' as id,s.id as shift_id,s.user_id,s.stime,s.etime,s.trip_type,s.startdate,s.enddate,s.splace,s.eplace,s.scity,s.dcity,s.slat,s.slng,s.elat,s.elng,s.shipmentid,v.id as shift_veh_id,a.vehicle_id,a.imei,IFNULL((SELECT SUM(e.shipment_weight) from tb_shft_veh_emp h,tb_employee e WHERE h.shft_veh_id=v.id and h.status='1' and e.id=h.emp_id and e.status=1),'0') as shipweight,
                    IFNULL((SELECT transit_status FROM tb_trips WHERE driver_id=d.id AND shift_id=s.id AND status=1 ORDER BY id DESC ORDER BY `shift_veh_id` ASC LIMIT 1),'N') AS astatus from tbl_assigned_drivers a,tb_shft_veh v,tb_shifts s,tb_trucks_data t,tb_truck_drivers d
                        where a.driver_id=$driver and v.register_number = t.register_number and t.id=a.vehicle_id and v.status=1 and v.user_id=$uid and s.status=1 and d.id=a.driver_id and s.id=v.shft_id and a.status=1 and t.user_id=$uid GROUP BY v.id";
                        //echo $sql;
                    } else if ($type == 0) {
                        $sql = "select s.id as shift_id,t.id,s.user_id,s.stime,s.etime,s.trip_type,s.startdate,s.enddate,s.splace,s.eplace,s.scity,s.dcity,s.slat,s.slng,s.elat,s.elng,s.shipmentid,v.id as shift_veh_id,t.vehicle_id,t.start_imei as imei,IFNULL((SELECT SUM(e.shipment_weight) from tb_shft_veh_emp h,tb_employee e WHERE h.shft_veh_id=v.id and h.status='1' and e.id=h.emp_id and e.status=1),'0') as shipweight,t.transit_status AS astatus from tb_shifts s,tb_shft_veh v,tb_trips t where s.id=t.shift_id AND s.id=v.shft_id AND t.driver_id=$driver and v.vehicle_id=t.vehicle_id and v.user_id=$uid and v.status=1 and s.status=1 AND t.status != 2 AND t.transit_status=0 GROUP BY v.id";
                    } else if ($type == 1) {
                        $sql = "select s.id as shift_id,t.id,s.user_id,s.stime,s.etime,s.trip_type,s.startdate,s.enddate,s.splace,s.scity,s.dcity,s.eplace,s.slat,s.slng,s.elat,s.elng,s.shipmentid,v.id as shift_veh_id,t.vehicle_id,t.start_imei as imei, IFNULL((SELECT SUM(e.shipment_weight) from tb_shft_veh_emp h,tb_employee e WHERE h.shft_veh_id=v.id and h.status='1' and e.id=h.emp_id and e.status=1),'0') as shipweight,t.transit_status AS astatus from tb_shifts s,tb_shft_veh v,tb_trips t where s.id=t.shift_id AND s.id=v.shft_id AND t.driver_id=$driver and v.vehicle_id=t.vehicle_id and v.user_id=$uid and v.status=1 and s.status=1 AND t.status != 2 AND t.transit_status=1 GROUP BY v.id";
                    } else {
                        $sql = "select s.id as shift_id,t.id,s.user_id,s.stime,s.etime,s.trip_type,s.startdate,s.enddate,s.splace,s.eplace,s.scity,s.dcity,s.slat,s.slng,s.elat,s.elng,s.shipmentid,v.id as shift_veh_id,t.vehicle_id,t.start_imei as imei,IFNULL((SELECT SUM(e.shipment_weight) from tb_shft_veh_emp h,tb_employee e WHERE h.shft_veh_id=v.id and h.status='1' and e.id=h.emp_id and e.status=1),'0') as shipweight,'2' AS astatus from tb_shifts s,tb_shft_veh v,tb_trips t where s.id=t.shift_id AND s.id=v.shft_id AND t.driver_id=$driver and v.vehicle_id=t.vehicle_id and t.status=0 and v.user_id=$uid GROUP BY v.id";
                    }
                    $query = $this->db->query($sql);
                    $res   = array();
                    if ($query->num_rows() > 0) {
                        $i                = 0;
                        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', array('status' => 1))->result_array();
                        $pod              = "";
                        $signature        = "";
                        foreach ($query->result_array() as $d) {
                            list($pickup, $drop) = $this->addressesFromShift($d);
                            $d["splace"] = $pickup;
                            $d["eplace"] = $drop;
                            if ($type == "") {
                                if ($d['astatus'] == 'N') {
                                    $chkreject = $this->db->select('id')->order_by('id', 'DESC')->get_where('tb_stop_status', array('status_id' => 6, 'shipment_id' => $d['id'], 'driver_id' => $driver, 'vehicle_id' => $d['vehicle_id']), 1, 0);
                                    if ($chkreject->num_rows() == 0) {
                                        $d['sno']       = $i;
                                        $dist = distance($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                        $d['distance']  = round($dist, 2) . " KM";
                                        $d['duration']  = round((($dist / 40) * 60), 2) . " min";
                                        $d['startdate'] = strtotime($d['startdate']);
                                        $d['enddate']   = strtotime($d['enddate']);
                                        if ($d['astatus'] == 'N') {
                                            $d['astatus'] = '';
                                        }
                                        $d['pod']       = $pod;
                                        $d['signature'] = $signature;
                                        $res['trips'][] = $d;
                                    }
                                    if (empty($res['trips'])) {
                                        $res['trips'] = array();
                                    }
                                    $i++;
                                } else {
                                    $res['trips'] = array();
                                }
                            } else {
                                $chkdoc = $this->db->query('select id,doc_type from tb_pod_uploads where doc_type in(1,3) and trip_id=' . $d['id']);
                                $docs   = array('1', '3');
                                if ($chkdoc->num_rows() > 0) {
                                    foreach ($chkdoc->result() as $doc) {
                                        if (in_array('1', $docs)) {
                                            $signature = 1;
                                        }
                                        if (in_array('3', $docs)) {
                                            $pod = 1;
                                        }
                                    }
                                }
                                $d['pod']       = $pod;
                                $d['signature'] = $signature;
                                $d['sno']       = $i;
                                $dist           = distance($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance']  = round($dist, 2) . " KM";
                                $d['duration']  = round((($dist / 40) * 60), 2) . " min";
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate']   = strtotime($d['enddate']);
                                if ($d['astatus'] == 'N') {
                                    $d['astatus'] = '';
                                }
                                $res['trips'][] = $d;
                                $i++;
                            }
                        }
                        $response = array("status" => 1, "data" => $res);
                    } else {
                        $response = array("status" => 0, "data" => "Not Found");
                    }
                } else {
                    $response = array("status" => 2, "data" => "Imei Changed!");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        echo json_encode($response);
    }
    public function getshipmentstops()
    {
        if (isset($_POST)) {
            $shft_veh_id = isset($_POST["shift_veh_id"]) ? $_POST["shift_veh_id"] : "";
            $shft_id     = isset($_POST["shift_id"]) ? $_POST["shift_id"] : ""; //this is a trip id not shift id
            if ($shft_veh_id != "" && $shft_id != "") {
                $trip    = 0;
                $gettrip = $this->db->query("select t.id FROM tb_trips t,tb_shft_veh v WHERE t.shift_id=v.shft_id AND v.id=" . $shft_veh_id . " AND v.status=1 AND t.status=1 group by v.id");
                if ($gettrip->num_rows() > 0) {
                    $trip = $gettrip->row()->id;
                }
                $sql = "select * from tb_shiporder_stops where shipment_id=$shft_id order by ordernumber asc";
                $query  = $this->db->query($sql);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $stop_id = $res->id;
                        $emp = $this->db->query("SELECT id,order_id FROM tb_employee WHERE (stop_id='$stop_id' OR drop_stopid='$stop_id') AND shift_id = $shft_id AND status=1"); /* AND accepted=1*/
                        if ($emp->num_rows() > 0) {
                            $whr      = array("stop_id" => $stop_id, "shipment_id" => $shft_id);
                            $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            $status   = "N";
                            if ($statuses->num_rows() > 0) {
                                $status = "S";
                                $whr = array("stop_id" => $stop_id, "shipment_id" => $shft_id, "status_id" => "1", "status" => "1");
                                $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                $actual_details  = $this->db->query("SELECT id FROM tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND shift_id = $shft_id AND status=1");
                                if ($gateout_details->num_rows() >= $actual_details->num_rows()) {
                                    $status = "C";
                                }
                            }
                            $stopname = "";
                            if (strlen($res->stopcity) > 0) {
                                $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                            }
                            if (strlen($res->stopname) > 0) {
                                $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                            }
                            $result[] = array('id' => $stop_id, 'name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'status' => $status, 'order_id'=>$emp->row()->order_id);
                        }
                    }
                    echo json_encode(array("status" => 1, "data" => $result));
                } else {
                    echo json_encode(array("status" => 0, "data" => "Not Found"));
                }
            } else {
                echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
            }
        } else {
            echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }
    public function checkprvstopstatus()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $shift_id      = isset($_POST["shift_id"]) ? $_POST["shift_id"] : "";
            $stop_id       = isset($_POST["stop_id"]) ? $_POST["stop_id"] : "";
            $previous_stop = isset($_POST["previous_stop"]) ? $_POST["previous_stop"] : "";
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            if ($stop_id != "") {
                if ($previous_stop != "") {
                    $chkdet = $this->db->query("select id from tb_stop_status where shipment_id=$shift_id AND stop_id=$previous_stop AND status_id=1"); /*AND trip_id=$trip_id */
                    if ($chkdet->num_rows() == 0) {
                        $response = array("status" => 1, "data" => 0);
                    } else {
                        $response = array("status" => 1, "data" => 1);
                    }
                } else {
                    $response = array("status" => 1, "data" => 1);
                }
            }
        }
        echo json_encode($response);
    }
    public function shipmentstopdetails($type = "0")
    {
        if (isset($_POST)) {
            $shft_veh_id = isset($_POST["shift_veh_id"]) ? $_POST["shift_veh_id"] : '';
            $shift_id    = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
            $stop_id     = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
            if ($shft_veh_id > 0) {
                $trip    = 0;
                $gettrip = $this->db->query("select t.id FROM tb_trips t,tb_shft_veh v WHERE t.shift_id=v.shft_id AND v.id=" . $shft_veh_id . " AND v.status=1 AND t.status=1 group by v.id");
                if ($gettrip->num_rows() > 0) {
                    $trip = $gettrip->row()->id;
                }
                $sql = "SELECT e.id,e.startdate,e.enddate,e.phone,e.stop_id,e.pickup,e.plat,e.plng,e.`drop`,e.drop_city,e.pickup_city,e.dlat,e.dlng,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'P' as ship_type,e.customer_id,e.vendor_id,e.stop_order as priority,e.order_id,e.capacity,c.name as customer_name,c.phone as custphone,v.name as carrier_name,m.material as material_name,e.accepted FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id where e.shift_id=$shift_id AND e.status=1 AND e.stop_id='$stop_id' UNION SELECT e.id,e.startdate,e.enddate,e.phone,e.drop_stopid as stop_id,e.pickup,e.plat,e.plng,e.`drop`,e.drop_city,e.pickup_city,e.dlat,e.dlng,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'D' as ship_type,e.customer_id,e.vendor_id,e.drop_order as priority,e.order_id,e.capacity,c.name as customer_name,c.phone as custphone,v.name as carrier_name,m.material as material_name,e.accepted FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id where e.shift_id=$shift_id AND e.status=1 AND e.drop_stopid ='$stop_id'";
                if ($type == "1") {
                    $sql = "SELECT * FROM ($sql) P WHERE accepted = 1 ORDER BY priority";
                } else {
                    $sql = "SELECT * FROM ($sql) P ORDER BY priority";
                }
                $query  = $this->db->query($sql);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $i => $res) {
                        $status   = 'N';
                        $statusid = '0';
                        $check_in = '';
                        $reason   = '';
                        $whr      = array('stop_id' => $res->id);
                        $custname = $res->customer_name;
                        $custmobi = $res->custphone;
                        $getsts   = $this->getstopstatus($whr);
                        if (!empty($getsts)) {
                            $status   = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason   = $getsts['name'];
                        }
                        $sts        = $anystatus        = 0;
                        $chkpodsign = $this->db->query("SELECT id FROM tb_pod_uploads WHERE shipment_id='$shift_id' AND stop_id='$stop_id' AND doc_type IN(1,3) GROUP BY doc_type ORDER BY createdon DESC");
                        if ($chkpodsign->num_rows() >= 2) {
                            $anystatus = 1;
                        }
                        if ($i == 0) {
                            $anystatus = 1;
                        }
                        if ($trip > 0) {
                            $chk = $this->db->select('id,status')->get_where('tb_trip_employee', array('employee_id' => $res->id, 'trip_id' => $trip, 'stop_id' => $stop_id), 1, 0);
                            if ($chk->num_rows() > 0) {
                                if ($chk->row()->status == 1) {
                                    $sts = 1;
                                }
                            }
                            if ($sts != 1) {
                                $chk1 = $this->db->select('id')->get_where('tb_stop_status', array('stop_id' => $res->id, 'trip_id' => $trip), 1, 0);
                                if ($chk1->num_rows() > 0) {
                                    $sts = 0;
                                } else {
                                    $sts = 2;
                                }
                            }
                        }
                        $material   = $res->name;
                        $materialid = $this->db->select('material')->get_where('tb_materials', array('id' => $res->material_id), 1, 0);
                        if ($materialid->num_rows() > 0) {
                            $material = $materialid->row()->material;
                        }
                        $drop = "";
                        if (strlen($res->drop_city) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop_city)) . " - ";
                        }
                        if (strlen($res->drop) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop));
                        }
                        $pickup = "";
                        if (strlen($res->pickup_city) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup_city)) . " - ";
                        }
                        if (strlen($res->pickup) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup));
                        }
                        $result[] = array('id' => $res->id, 'name' => $res->name, 'pickup' => $pickup, 'drop' => $drop, 'phone' => $res->phone, 'plat' => $res->plat, 'plng' => $res->plng, 'dlat' => $res->dlat, 'dlng' => $res->dlng, 'capacity' => $res->capacity, 'ship_type' => $res->ship_type, 'shipment_weight' => $res->shipment_weight, 'shipment_volume' => $res->shipment_volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->priority, 'status' => $status, 'status_id' => $statusid, 'check_in' => $check_in, 'reason' => $reason, 'milestone' => $sts, 'exists_status' => $anystatus, 'material' => $material, 'order_id' => $res->order_id, "accepted" => $res->accepted,'customer'=>$custname,'customerphone'=>$custmobi);
                    }
                    echo json_encode(array("status" => 1, "data" => $result));
                } else {
                    echo json_encode(array("status" => 0, "data" => "Not Found"));
                }
            } else {
                echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
            }
        } else {
            echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }
    public function setShipstopStatus()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data  = array();
            $curdt = date('Y-m-d H:i:s');
            $latitude  = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $data["trip_id"] = isset($_POST["trip_id"]) ? $_POST["trip_id"] : '';
            $shipment_id         = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $stop_id             = isset($_POST['stop_id']) ? $_POST["stop_id"] : '0';
            $data["employee_id"] = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_type           = isset($_POST["stop_type"]) ? $_POST["stop_type"] : '';
            $driver_id           = isset($_POST["driver_id"]) ? $_POST["driver_id"] : '';
            $employee_id         = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_detail_type    = isset($_POST["stop_detail_type"]) ? $_POST["stop_detail_type"] : '';
            $status_type         = isset($_POST["status_type"]) ? $_POST["status_type"] : '';
            $pdfName = $fileName = "";
            $file_upload_flag = false;
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = array(
                        'upload_path'   => NEW_POD_PATH,
                        'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                        'overwrite'     => true,
                    );
                    $file_name = $_FILES['file_name']['name'];
                    $file_ext= @strtolower(end(explode('.',$_FILES['file_name']['name'])));
                    $expensions= array("jpeg","jpg","png","gif","pdf");
                    if(in_array($file_ext,$expensions) === false){
                    }else{
                        if($file_ext == "pdf"){
                            $imgtype = "pdf";
                            $this->load->library('upload', $config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname  = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                            }
                        }else{
                            $fileName = date('dmyhis').''.$file_name;
                            $filePath = NEW_POD_PATH.$fileName;
                            $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if($file_ext == "png"){
                                $top = imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            }else{
                                $top = imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if($file_ext == "jpg" || $file_ext == "jpeg"){
                                    $imgtype = "jpeg";
                                }else{
                                    $imgtype = $file_ext;
                                }
                            }
                            header('Content-Type: image/jpeg');
                            imagejpeg($top,$filePath,$quality);
                            imagedestroy($top);
                        }
                        $imageSize = filesize(NEW_POD_PATH.$fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = ['shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_type, 'imgpath' => $fileName, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $file_upload_flag = true;
                        $id = $this->db->insert_id();
                    }
                }
            }
            if ($data["employee_id"] != "" && $data["trip_id"] != "") {
                $vehicle      = $driver      = 0;
                $checkintrans = $this->db->select("id,vehicle_id,driver_id")->get_where("tb_trips", array('id' => $data["trip_id"], 'transit_status' => 1), 1, 0);
                if ($checkintrans->num_rows() == 0) {
                    $update    = $this->db->set(array('transit_status' => 1))->where(array('id' => $data["trip_id"]))->update("tb_trips");
                    $checktrip = $this->db->select("id,vehicle_id,driver_id")->get_where("tb_trips", array('id' => $data["trip_id"]), 1, 0);
                    if ($checktrip->num_rows() > 0) {
                        $vehicle = $checktrip->row()->vehicle_id;
                        $driver  = $checktrip->row()->driver_id;
                    }
                } else {
                    $vehicle = $checkintrans->row()->vehicle_id;
                    $driver  = $checkintrans->row()->driver_id;
                }
                $tdata['employee_id']  = $data['employee_id'];
                $tdata['trip_id']      = $data['trip_id'];
                $tdata['stop_id']      = $stop_id;
                $data["status"]        = $status_type;
                $data["absent_reason"] = $stsreason = $data["pd_status"] = isset($_POST["status"]) ? $_POST["status"] : '';
                $data["stime"]         = $data["created_on"]         = $data["check_in"]         = $curdt;
                $chksts                = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'status' => $data["status"]);
                $checksts = $this->db->select("id")->get_where("tb_stop_status", $chksts, 1, 0);
                if ($checksts->num_rows() > 0) {
                    $updstsarr = array('latitude' => $latitude, 'longitude' => $longitude);
                    $stswhr    = array('id' => $checksts->row()->id);
                    $upd       = $this->db->where($stswhr)->update('tb_stop_status', $updstsarr);
                } else {
                    $data1 = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => $data["status"], 'vehicle_id' => $vehicle, 'driver_id' => $driver, 'createdon' => $curdt);
                    $insrt = $this->db->insert('tb_stop_status', $data1);
                }
                $shift = $this->db->query("select order_id from tb_employee where (stop_id=$stop_id OR drop_stopid=$stop_id) LIMIT 1")->row();
                $cnt = $this->db->select('id')->get_where('tb_pod_uploads',array('trip_id'=>$data["trip_id"]))->num_rows();
                if($cnt == 0){
                    $cntstr = "001";
                }else{
                    $cntstr = "00".$cnt;
                    if($cnt > 9){
                        $cntstr = "0".$cnt;
                    }
                }
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id"     => $data["trip_id"],
                    "driver_id"   => $driver_id,
                    "stop_id"     => $stop_id,
                    "order_id"    => $shift->order_id,
                    "inc_id"    => $cntstr,
                    "pod_type" => $status_type
                );
                if ($stsreason == 8) {
                    $sts = $this->statusintigration->shipcollectcancel($postdata);
                } else if ($stsreason == 4) {
                    $sts = $this->statusintigration->shipmentintransit($postdata);
                } else if ($stsreason == 1) {
                    if ($stop_detail_type == "D") {
                        $sts = $this->statusintigration->shipmentdelivered($postdata);
                        if ($file_upload_flag == true) {
                            $stop = $this->db->select('txncode')->where(array("id" => $stop_id))->get("tb_shiporder_stops")->row();
                            $postdata["txn_code"]  = $stop->txncode;
                            $postdata["file_name"] = $fileName; /*$pdfName;*/
                            $postdata["file_type"] = isset($imgtype) ? $imgtype : 'png';
                            $sts = $this->statusintigration->orderrealesestatusapi($postdata);
                        }
                        $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, $stop_id);
                        if ($stop_closed) {
                            $sts = $this->statusintigration->shipmentdeliveredpartially($postdata);
                        }
                    }
                } else if ($stsreason == 3) {
                    $sts = $this->statusintigration->shipmentgateout($postdata);
                }
                /* Here send driver action status send to otm */
                $sql = $this->db->select("id")->where($tdata)->get("tb_trip_employee");
                if ($sql->num_rows() > 0) {
                    $id = $sql->row()->id;
                    if ($data["status"] == 1 && $stsreason == 1) {
                        $empdt = array('status' => 1, 'absent_reason' => 'Closed', 'pd_status' => 'Closed', 'updated_on' => $curdt);
                        $upd   = $this->db->where(array('id' => $id))->update('tb_trip_employee', $empdt);
                    }
                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                } else {
                    if ($data['status'] == '1') {
                        $chkltlng = $this->checkLatLng($data["employee_id"]);
                        if ($chkltlng == "true") {
                            $lat = $latitude;
                            $lng = $longitude;
                            $this->savePickup($data["employee_id"], $lat, $lng);
                        }
                    }
                    if (($stsreason == 1 && $data["status"] == 1) || ($data["status"] == 0)) {
                        if ($stsreason == 1) {
                            $data['absent_reason'] = 'Closed';
                        } else if ($stsreason == 0) {
                            $data['absent_reason'] = 'Cancelled';
                        }
                        $data["stop_id"] = $stop_id;
                        $res             = $this->db->insert("tb_trip_employee", $data);
                        $id              = $this->db->insert_id();
                        $smsdata         = array();
                        if ($id > 0) {
                            $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                            if ($data["status"] == 1) {
                                /*$this->latereport($data["trip_id"], $data["employee_id"], $id);*/
                                $result = array();
                                $result = $this->sendTripAlert($data["trip_id"]);
                                if (!empty($result)) {
                                    if (isset($result['sms_data'])) {
                                        $smsdata = $result['sms_data'];
                                    }
                                    if (isset($result['pickup_data'])) {
                                        $pickdata = $result['pickup_data'];
                                    }
                                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => $smsdata, "pickup_data" => $pickdata);
                                }
                            }
                            $response = array("status" => 1, "data" => "Updated Status!");
                        } else {
                            $response = array("status" => 0, "data" => "Failed to Set Shipment Status");
                        }
                    } else {
                        $response = array("status" => 1, "data" => "Updated Status!");
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function isStopUnitsPartiallyPicked($shipment_id = '', $stop_id = '')
    {
        if ($stop_id != '') {
            $driver_entered = $this->db->query("SELECT ship_units FROM tb_shiporder_stops WHERE id = $stop_id")->row()->ship_units;
            if (strlen($driver_entered) > 0) {
                $total_units = 0;
                $sdet = $this->db->query("SELECT no_of_pkgs from tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND status='1'");
                foreach ($sdet->result() as $row) {
                    $total_units += $row->no_of_pkgs;
                }
                if ($total_units != $driver_entered) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {
            $stops = $this->db->query("SELECT id FROM tb_shiporder_stops WHERE shipment_id = $shipment_id");
            $total_units = $driver_entered_total = 0;
            foreach ($stops->result() as $stop) {
                $stop_id = $stop->id;
                $driver_entered = $this->db->query("SELECT ship_units FROM tb_shiporder_stops WHERE id = $stop_id")->row()->ship_units;
                if (strlen($driver_entered) > 0) {
                    $driver_entered_total += $driver_entered;
                    $total_units = 0;
                    $sdet = $this->db->query("SELECT no_of_pkgs from tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND status='1'");
                    foreach ($sdet->result() as $row) {
                        $total_units += $row->no_of_pkgs;
                    }
                } else {
                    return true;
                }
            }
            if ($total_units != $driver_entered_total) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function getshipstatuses()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data1  = array();
            $status = 0;
            $data["trip_id"] = isset($_POST["trip_id"]) ? $_POST["trip_id"] : null;
            $shipment_id     = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : null;
            $stop_id         = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
            $stop_detail_id  = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
            if ($data["trip_id"] != null) {
                $sq["trip_id"] = $data["trip_id"];
                if ($stop_id != null) {
                    $sq["stop_id"] = $stop_id;
                }
                if ($stop_detail_id != null) {
                    $sq["stop_detail_id"] = $stop_detail_id;
                }
                $sq["doc_type"] = 1;
                $sign_sign = $this->db->select('id')->get_where('tb_pod_uploads', $sq, 1, 0);
                if ($sign_sign->num_rows() > 0) {
                    $sq["doc_type"] = 3;
                    $pod_sign       = $this->db->select('id')->get_where('tb_pod_uploads', $sq, 1, 0);
                    if ($pod_sign->num_rows() > 0) {
                        $status = 1;
                    }
                }
                $ww = "";
                if ($stop_id != null) {
                    $ww = " AND s.stop_id = $stop_id";
                }
                if ($stop_detail_id != null) {
                    $ww .= " AND s.stop_detail_id = $stop_detail_id";
                }
                $qry      = $this->db->query('SELECT s.latitude,s.longitude,s.createdon,m.status_name FROM tb_stop_status s,tb_status_master m WHERE s.status_id=m.id AND s.trip_id=' . $data["trip_id"] . "$ww");
                $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $placename = getLocationName($res->latitude, $res->longitude);
                        $data1[]   = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));
                    }
                    $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                }
            }
        }
        echo json_encode($response);
    }
    public function setShipReject()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $post        = json_decode($_POST['data']);
            $data        = array();
            $curdt       = date('Y-m-d H:i:s');
            $trip_id     = isset($post->trip_id) ? $post->trip_id : 0;
            $latitude    = isset($post->latitude) ? $post->latitude : '';
            $longitude   = isset($post->longitude) ? $post->longitude : '';
            $reason      = isset($post->reason) ? $post->reason : '';
            $type        = isset($post->type) ? $post->type : '1';
            $vehicle_id  = isset($post->vehicle_id) ? $post->vehicle_id : '';
            $driver_id   = isset($post->driver_id) ? $post->driver_id : '';
            $shipment_id = isset($post->shipment_id) ? $post->shipment_id : 0;
            $status      = 6;
            if ($type == '1') {
                $chktrip = $this->db->select('id')->get_where('tb_trips', array('id' => $trip_id, 'status !=' => 0));
                if ($chktrip->num_rows() > 0) {
                    $whr = array('id' => $trip_id);
                    $set = array('status' => 2, 'updated_on' => $curdt);
                    $upd = $this->db->set($set)->where($whr)->update('tb_trips');
                }
                $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
            }
            if ($type == '0') {
                $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
            }
            $shift = $this->db->select('order_id')->order_by('id','DESC')->where(array("shift_id" => $shipment_id,'ship_type'=>'P'))->get("tb_employee")->row();
            $postdata = array(
                "shipment_id" => $shipment_id,
                "trip_id"     => $trip_id,
                "driver_id"   => $driver_id,
                "stop_id"     => "",
                "order_id"    => $shift->order_id,
            );
            $sts = $this->statusintigration->shipmentreject($postdata);
            $qry      = $this->db->insert('tb_stop_status', $addstatus);
            $response = array("status" => 1, "data" => "Updated");
        }
        echo json_encode($response);
    }
    public function setshipAbort()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data  = array();
            $curdt = date('Y-m-d H:i:s');
            $latitude  = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $shipment_id = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $trip_id     = isset($_POST['trip_id']) ? $_POST["trip_id"] : 0;
            $driver_id  = isset($_POST['driver_id']) ? $_POST["driver_id"] : '0';
            $vehicle_id = isset($_POST['vehicle_id']) ? $_POST["vehicle_id"] : '0';
            $reason = isset($_POST['reason']) ? $_POST["reason"] : '';
            $pdfName = $fileName = "";
            if (isset($_FILES)) {
                if (isset($_FILES['photo']['name'])) {
                    $config = array(
                        'upload_path'   => NEW_POD_PATH,
                        'allowed_types' => 'jpg|gif|png|pdf',
                        'overwrite'     => true,
                    );
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('photo')) {
                        $imgname  = $this->upload->data();
                        $fileName = $imgname['photo'];
                        $imageSize = filesize(NEW_POD_PATH.$fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = array('shipment_id' => $shipment_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 3, 'imgpath' => $fileName, 'status' => 1, 'createdon' => $curdt);
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $id = $this->db->insert_id();
                    }
                }
            }
            $shift = $this->db->select('order_id')->order_by('id','DESC')->where(array("shift_id" => $shipment_id,'ship_type'=>'P'))->get("tb_employee")->row();
            $postdata = array(
                "shipment_id" => $shipment_id,
                "trip_id"     => $trip_id,
                "driver_id"   => $driver_id,
                "stop_id"     => "",
                "order_id"    => $shift->order_id,
            );
            $sts = $this->statusintigration->shipmentabort($postdata);
            $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => 6, 'latitude' => $latitude, 'longitude' => $longitude, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
            $qry       = $this->db->insert('tb_stop_status', $addstatus);

            if ($qry) {
                $this->db->where('id', $shipment_id)->limit(1);
                $this->db->update('tb_shifts', ['aborted' => 1]);
            }

            $response  = array("status" => 1, "data" => "Updated");
        }
        echo json_encode($response);
    }
    public function rescheduleShift()
    {
        if (isset($_POST)) {
            $post            = json_decode($_POST['data']);
            $shift_id        = isset($post->shift_id) ? $post->shift_id : "";
            $vehicle_id      = isset($post->vehicle_id) ? $post->vehicle_id : "";
            $trip_type       = isset($post->trip_type) ? $post->trip_type : "";
            $driver_id       = isset($post->driver_id) ? $post->driver_id : "";
            $imei            = isset($post->imei) ? $post->imei : "";
            $user_id         = isset($post->user_id) ? $post->user_id : "";
            $splace          = isset($post->splace) ? $post->splace : "";
            $eplace          = isset($post->eplace) ? $post->eplace : "";
            $reschedule_date = isset($post->reschedule_date) ? $post->reschedule_date : "";
            $reason          = isset($post->reason) ? $post->reason : "";
            $check           = isset($post->check) ? $post->check : "";
            if (strlen($reschedule_date) > 0 && strlen($shift_id) > 0 && strlen($vehicle_id) > 0 && strlen($user_id) > 0) {
                $vendor = $this->db->query("SELECT v.* FROM tb_vendor_vehicles vv LEFT JOIN tb_vendors v ON v.id=vv.vendor_id WHERE vv.status='1' AND vv.vehicle_id=$vehicle_id")->row();
                $user   = $this->db->query("SELECT * FROM tb_users WHERE id=$user_id")->row();
                $driver = $this->db->query("SELECT * FROM tb_truck_drivers WHERE id=$driver_id")->row();
                $shift  = $this->db->where(array("id" => $shift_id))->get("tb_shifts")->row();
                $this->load->library('email');
                $this->email->from("svkonekt@kuehne-nagel.com", "svkonekt");
                if (strlen($vendor->email) > 0) {
                    //$this->email->to($vendor->email, $vendor->name);
                }
                if (strlen($user->emailid) > 0) {
                    //$this->email->to($user->emailid, $user->name);
                }
                $this->email->to("external.dhan.k@kuehne-nagel.com", $user->name);
                $this->email->subject('Shift reschedule requested');
                $this->email->set_mailtype('html');
                $this->email->message("
                    Hi,<br><br>
                    Your shift has been reschedule by driver<br><br>
                    <table style=\"border: 1px solid #f4f4f4;width: 100%;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Shipment Id</th>
                            <th>Start Place</th>
                            <th>End Place</th>
                            <th>All materials are swapped in good condition</th>
                            <th>Actual Date</th>
                            <th>Re-scheduling Date</th>
                            <th>Re-scheduling reason</th>
                        </tr>
                        <tr>
                            <td>" . $shift->shipmentid . "</td>
                            <td>" . $splace . "</td>
                            <td>" . $eplace . "</td>
                            <td>" . $check . "</td>
                            <td>" . $shift->startdate . "</td>
                            <td>" . $reschedule_date . "</td>
                            <td>" . $reason . "</td>
                        </tr>
                    </tbody></table><br>
                    Driver Details:<br>
                    <table style=\"border: 1px solid #f4f4f4;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Driver</th>
                            <th>Mobile</th>
                        </tr>
                        <tr>
                            <td>" . $driver->name . "</td>
                            <td>" . $driver->contact_num . "</td>
                        </tr>
                    </tbody></table><br>
                    <a href='" . base_url() . "' target='_blank' title='Click here to Accept/Reject this request'>Click here</a> to Accept/Reject this request<br><br>
                    Thanks,<br>
                    Support Team,<br>
                    Return Trucks.
                ");
                $this->email->send();
                $smsObj  = new sendsms("alerts.sinfini.com/api/", "115948kz7517216zm1sl", "RTRUCK");
                $message = "Your shipment-" . $shift->shipmentid . " has been reschedule by driver,please check this at " . base_url() . "";
                $res     = $smsObj->send_sms("9052440146", $message, SITEURL, "xml");
                echo json_encode(array("status" => "1", "message" => "Status updated sucessfully!"));
            } else {
                echo json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
            }
        } else {
            echo json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
        }
    }

    public function stopdetailsaccept()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post     = array();
        if (isset($_POST)) {
            $post                  = $_POST;
            $shipment_stop_details = $post["shipment_stop_details"];
            $shift_veh_id          = $post["shift_veh_id"];
            $shift_id              = $post["shift_id"];
            $stop_id               = $post["stop_id"];
            $driver_id             = $post["driver_id"];
            $trip_id               = $post["trip_id"];
            $aa                    = json_decode($shipment_stop_details);
            $sql = $this->db->query("UPDATE `tb_employee` e set e.accepted = 0 where e.shift_id=$shift_id AND e.status=1 AND e.stop_id='$stop_id'");
            foreach ($aa as $stop_detail_id) {
                $data = array(
                    "shift_veh_id"     => $shift_veh_id,
                    "shipment_id"      => $shift_id,
                    "shipment_stop_id" => $stop_id,
                    "stop_detail_id"   => $stop_detail_id,
                    "trip_id"          => $trip_id,
                    "driver_id"        => $driver_id,
                    "created_at"       => date("Y-m-d H:i:s"),
                );
                $this->db->query("UPDATE tb_employee set accepted = 1 WHERE id = $stop_detail_id");
            }
            $trip    = $this->db->query("SELECT id from tb_trips where shift_id =$shift_id AND status = 1");
            $trip_id = null;
            if ($trip->num_rows() > 0) {
                $trip_id = $trip->row()->id;
            }
            if ($trip_id != null) {
                $this->db->query("DELETE from tb_trip_employee where trip_id = $trip_id");
                $emp = $this->db->query("SELECT e.* from tb_employee e JOIN tb_shft_veh_emp sve ON sve.emp_id = e.id AND sve.status = '1' JOIN tb_shft_veh sv ON sv.id = sve.shft_veh_id AND sv.status = '1' JOIN tb_shifts s ON s.id = sv.shft_id AND s.status = '1' WHERE (e.accepted is null or e.accepted = '' or e.accepted = '0') AND s.id = " . $shift_id);
                foreach ($emp->result() as $row) {
                    $te["trip_id"]       = $trip_id;
                    $te["stop_id"]       = $row->stop_id;
                    $te["employee_id"]   = $row->id;
                    $te["status"]        = "0";
                    $te["absent_reason"] = "Driver Rejected";
                    $this->db->insert("tb_trip_employee", $te);
                }
            }
            $stps = $this->db->select('id')->where(array("shipment_id" => $shift_id, "status" => "1"))->get("tb_shiporder_stops");
            foreach ($stps->result() as $row) {
                $stp_id   = $row->id;
				$shift = $this->db->query("select order_id from tb_employee where (stop_id=$stp_id OR drop_stopid=$stp_id) LIMIT 1")->row();
                $postdata = array(
                    "shipment_id" => $shift_id,
                    "trip_id"     => $trip_id,
                    "driver_id"   => $driver_id,
                    "stop_id"     => $stp_id,
                    "order_id"    => $shift->order_id
                );
                $det_count = $this->db->select('id')->where(array("shift_id" => $shift_id, "status" => "1"))->where("(stop_id = $stp_id or drop_stopid = $stp_id)")->get("tb_employee");
                $act_det   = $this->db->select('id')->where(array("shift_id" => $shift_id, "status" => "1", "accepted" => "1"))->where("(stop_id = $stp_id or drop_stopid = $stp_id)")->get("tb_employee");
                if ($det_count->num_rows() == $act_det->num_rows()) {
                    $sts = $this->statusintigration->shipmentcollected($postdata);
                } else {
                    $act_det = $this->db->select('id')->where(array("shift_id" => $shift_id, "stop_id" => $stp_id, "status" => "1", "accepted" => "0"))->get("tb_employee");
                    if ($det_count->num_rows() == $act_det->num_rows()) {
                        $sts = $this->statusintigration->shipnotcollected($postdata);
                    }
                }
            }
        }
        $response = array("status" => 1, "data" => $post);
        echo json_encode($response);
    }
    public function getvehicledrivers()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post     = array();
        if (isset($_POST)) {
            $data       = array();
            $post       = $_POST;
            $driver_id  = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            if ($vehicle_id != "") {
                $qry   = "SELECT d.id,d.name,d.contact_num FROM tb_vehicles_drivers v,tb_truck_drivers d WHERE v.driver_id=d.id AND d.status='Active' AND v.status=1 AND v.vehicle_id=$vehicle_id AND v.driver_id !=$driver_id";
                $query = $this->db->query($qry);
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $data[] = array('id' => $res->id, 'name' => $res->name, 'mobile' => $res->contact_num);
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }
    public function assigndriver()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post     = array();
        $curdt    = date("Y-m-d H:i:s");
        if (isset($_POST)) {
            $post        = $_POST;
            $driver_id   = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id  = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            $assigdriver = isset($post["assigned_driver_id"]) ? $post["assigned_driver_id"] : 0;
            $trip_id     = isset($post["trip_id"]) ? $post["trip_id"] : 0;
            if ($assigdriver != 0 && strlen($assigdriver) > 0) {
                $driver = $this->db->where('name,contact_num,user_id')->get_where("tb_truck_drivers", array("id" => $assigdriver), 1, 0);
                if ($driver->num_rows() > 0) {
                    $name = $driver->row()->name;
                    $mobile_no = $driver->row()->contact_num;
                    $imei = '';
                    $user_id   = $driver->row()->user_id;
                    if ($user_id != 0 && strlen($user_id) > 0) {
                        /* update trip driver */
                        $upd = $this->db->where(array("id" => $trip_id))->update("tb_trips", array("driver_id" => $assigdriver));
                        $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $assigdriver, "trip_id" => $trip_id, "imei" => $imei, "createdon" => $curdt));
                        $assigned = $this->db->where(array("vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "status" => "1"))->update("tbl_assigned_drivers", array("status" => 0));
                        $chk      = $this->db->select('id')->get_where('tbl_assigned_drivers', array("vehicle_id" => $vehicle_id, "driver_id" => $assigdriver), 1, 0);
                        if ($chk->num_row() > 0) {
                            $existid = $chk->row()->id;
                            $ins     = $this->db->where(array("id" => $existid))->update("tbl_assigned_drivers", array("imei" => $imei, "user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "from_time" => $curdt, "to_time" => $curdt));
                        } else {
                            $ins = $this->db->insert("tbl_assigned_drivers", array("vehicle_id" => $vehicle_id, "driver_id" => $assigdriver, "imei" => $imei, "user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "created_on" => $curdt, "from_time" => $curdt, "to_time" => $curdt));
                        }
                        $veh        = $this->db->select('register_number')->get_where('tb_trucks_data', array('id' => $vehicle_id), 1, 0)->row()->register_number;
                        $message    = "Dear " . $name . ",You are assigned to " . $veh . ", please login to do the shipping";
                        $notifydata = array("title" => "Change Driver To Trip", "message" => $message, "emp_id" => $assigdriver, 'type' => 'Driver');
                        $fire_ret   = @$this->sendfirebase->sendSinglePush($notifydata);
                        $response   = array("status" => 1, "data" => []);
                    } else {
                        $response = array("status" => 0, "data" => []);
                    }
                } else {
                    $response = array("status" => 0, "data" => []);
                }
            } else {
                $response = array("status" => 0, "data" => []);
            }
        } else {
            $response = array("status" => 0, "data" => []);
        }
        echo json_encode($response);
    }
    public function getpickupshipunit()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post     = array();
        if (isset($_POST)) {
            $data = array();
            $post       = $_POST;
            $driver_id  = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            $trip_id    = isset($post["trip_id"]) ? $post["trip_id"] : 0;
            $shift_id   = isset($post["shift_id"]) ? $post["shift_id"] : 0;
            $stop_id    = isset($post["stop_id"]) ? $post["stop_id"] : 0;
            $ship_units = isset($post["ship_units"]) ? $post["ship_units"] : 0;
            if ($trip_id != "" && $stop_id != "") {
                $upd = $this->db->where(array("shipment_id" => $shift_id, "id" => $stop_id))->update("tb_shiporder_stops", array("ship_units" => $ship_units));
                $response = array("status" => 1, "data" => $post);
            }
        }
        echo json_encode($response);
    }
    public function customershipments()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $ord_id = isset($_POST['search']) ? $_POST['search'] : '';
        if ($cust_id > 0 && $user_id > 0) {
            $whr = "";
            $whr1 = " ORDER BY s.id DESC LIMIT 3";
            if($ord_id != ""){
                $whr .= " AND (s.shipmentid='".$ord_id."' OR e.order_id='".$ord_id."')";
                $whr1 = " ORDER BY s.id DESC ";
            }
            $sql = "SELECT s.id as shift_id,s.user_id,s.stime,s.etime,s.trip_type,s.startdate,s.enddate,s.splace,s.eplace,s.scity,s.dcity,s.slat,s.slng,s.elat,s.elng,s.shipmentid,SUM(e.shipment_weight) as shipweight,SUM(e.shipment_volume) as shipvolume,SUM(e.no_of_pkgs) as numpkgs,e.pkgitemid as material,e.order_id FROM tb_shifts s,tb_shiporder_stops o,tb_employee e WHERE s.id=o.shipment_id AND e.customer_id=$cust_id and s.user_id = $user_id AND s.id=e.shift_id AND s.status=1 $whr GROUP BY s.id $whr1";
            $query = $this->db->query($sql);
            $res = array();
            if ($query->num_rows() > 0) {
                $i = 0;
                foreach ($query->result_array() as $d) {
                    list($pickup, $drop) = $this->addressesFromShift($d);
                    $d["splace"] = $pickup;
                    $d["eplace"] = $drop;
                    $qry = $this->db->query("SELECT id,transit_status FROM tb_trips WHERE shift_id='".$d['shift_id']."' AND status=1 ORDER BY id DESC LIMIT 1");
                    if($qry->num_rows() == 0){
                        $d['id'] = 0;
                        $d['sno'] = $i;
                        $dist = distance($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                        $d['distance']  = round($dist, 2) . " KM";
                        $d['duration']  = round((($dist / 40) * 60), 2) . " min";
                        $d['startdate'] = strtotime($d['startdate']);
                        $d['enddate']   = strtotime($d['enddate']);
                        $d['astatus'] = "";
                        $d['pod'] = "";
                        $d['signature'] = "";
                        $res['trips'][] = $d;
                        $i++;
                    } else {
                        $sts = $qry->row()->transit_status;
                        $d['id'] = $qry->row()->id;
                        $d['sno'] = $i;
                        $dist = distance($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                        $d['distance']  = round($dist, 2) . " KM";
                        $d['duration']  = round((($dist / 40) * 60), 2) . " min";
                        $d['startdate'] = strtotime($d['startdate']);
                        $d['enddate']   = strtotime($d['enddate']);
                        $d['astatus'] = $sts;
                        $res['trips'][] = $d;
                        $i++;
                    }
                }
                $response = array("status" => 1, "data" => $res);
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    function getvehdriverbyship($ship_id){
        $response = array();
        $gettrip = $this->db->query("select id,vehicle_id,driver_id FROM tb_trips WHERE shift_id=$ship_id AND status=1 order by id DESC");
        if ($gettrip->num_rows() > 0) {
            $response['trip'] = $gettrip->row()->id;
            $driverid = $gettrip->row()->driver_id;
            $driver = $this->db->select('name,contact_num')->get_where('tb_truck_drivers',array('id'=>$driverid),1,0);
            $response['drivername'] = $driver->row()->name;
            $response['drivermobile'] = $driver->row()->contact_num;
            $vehicleid = $gettrip->row()->vehicle_id;
            $vehicle = $this->db->select('register_number')->get_where('tb_trucks_data',array('id'=>$vehicleid),1,0);
            $response['vehicleno'] = $vehicle->row()->register_number;
        }else{
            $response['trip'] = 0;
            $qry = $this->db->query("SELECT v.register_number,d.name,d.contact_num FROM tb_shft_veh v,tbl_assigned_drivers a,tb_truck_drivers d WHERE v.shft_id=$ship_id AND v.vehicle_id=a.vehicle_id AND a.driver_id=d.id AND v.status=1 AND a.status=1 ORDER BY v.id DESC LIMIT 1");
            if($qry->num_rows()>0){
                $response['drivername'] = $qry->row()->name;
                $response['drivermobile'] = $qry->row()->contact_num;
                $response['vehicleno'] = $qry->row()->register_number;
            }else{
                $response['drivername'] = "";
                $response['drivermobile'] = "";
                $response['vehicleno'] = "";
            }
        }
        return $response;
    }
    function getvehdriverbytrip($trip_id){
        $response = array();
        $gettrip = $this->db->query("select id,vehicle_id,driver_id FROM tb_trips WHERE id=$trip_id AND status=1 order by id DESC");
        if ($gettrip->num_rows() > 0) {
            $response['trip'] = $gettrip->row()->id;
            $driverid = $gettrip->row()->driver_id;
            $driver = $this->db->select('name,contact_num')->get_where('tb_truck_drivers',array('id'=>$driverid),1,0);
            $response['drivername'] = $driver->row()->name;
            $response['drivermobile'] = $driver->row()->contact_num;
            $vehicleid = $gettrip->row()->vehicle_id;
            $vehicle = $this->db->select('register_number')->get_where('tb_trucks_data',array('id'=>$vehicleid),1,0);
            $response['vehicleno'] = $vehicle->row()->register_number;
        }
        return $response;
    }
    public function customershipstops()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $ord_id = isset($_POST['ord_id']) ? $_POST['ord_id'] : '';
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $ship_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : '';
        if ($ship_id > 0 && $user_id > 0) {
            $trip = $trip_id;
            $drivername = $drivermobile = $vehicleno = null;
            if($trip == 0){
                $details = $this->getvehdriverbyship($ship_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }else{
                $details = $this->getvehdriverbytrip($trip_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }
            $curstatus = array('lat'=>null,'lng'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            if($trip > 0){
                $lat = $lng = null;
                $liveloc = $this->db->select('latitude,longitude')->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                if($liveloc->num_rows()>0){
                    $lat = $liveloc->row()->latitude;
                    $lng = $liveloc->row()->longitude;
                }
                $curstatus = array('lat'=>$lat,'lng'=>$lng,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            }
            $sql = "select * from tb_shiporder_stops where shipment_id=$ship_id order by ordernumber asc";
            $query  = $this->db->query($sql);
            $result = array();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $res) {
                    $stop_id = $res->id;
                    $emp = $this->db->query("SELECT id,order_id FROM tb_employee WHERE (stop_id='$stop_id' OR drop_stopid='$stop_id') AND shift_id = $ship_id AND status=1"); /* AND accepted=1*/
                    if ($emp->num_rows() > 0) {
                        $whr      = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                        $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        $status   = "N";
                        if ($statuses->num_rows() > 0) {
                            $status = "S";
                            $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                            $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if ($gateout_details->num_rows() >= $emp->num_rows()) {
                                $status = "C";
                            }
                        }
                        $stopname = "";
                        if (strlen($res->stopcity) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                        }
                        if (strlen($res->stopname) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                        }
                        $result[] = array('id' => $stop_id, 'name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'status' => $status, 'order_id' => $emp->row()->order_id);
                    }
                }
                $data = array('result'=>$result,'livedata'=>$curstatus);
                $response = array("status"=>1,"data"=>$data);
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    public function customerstopdetails()
    {
        if (isset($_POST)) {
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
            if ($stop_id > 0 && $shift_id > 0) {
                $trip = $trip_id;
                $drivername = $drivermobile = $vehicleno = "";
                if($trip == 0){
                    $details = $this->getvehdriverbyship($shift_id);
                    if(!empty($details)){
                        $trip = $details['trip'];
                        $drivername = $details['drivername'];
                        $drivermobile = $details['drivermobile'];
                        $vehicleno = $details['vehicleno'];
                    }
                }else{
                    $details = $this->getvehdriverbytrip($trip_id);
                    if(!empty($details)){
                        $trip = $details['trip'];
                        $drivername = $details['drivername'];
                        $drivermobile = $details['drivermobile'];
                        $vehicleno = $details['vehicleno'];
                    }
                }
                $curstatus = array('lat'=>null,'lng'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
                if($trip > 0){
                    $lat = $lng = null;
                    $liveloc = $this->db->select('latitude,longitude')->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                    if($liveloc->num_rows()>0){
                        $lat = $liveloc->row()->latitude;
                        $lng = $liveloc->row()->longitude;
                    }
                    $curstatus = array('lat'=>$lat,'lng'=>$lng,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
                }
                $sql = "SELECT e.id,e.startdate,e.enddate,e.phone,e.stop_id,e.pickup,e.plat,e.plng,e.`drop`,e.drop_city,e.pickup_city,e.dlat,e.dlng,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'P' as ship_type,e.customer_id,e.vendor_id,e.stop_order as priority,e.order_id,e.capacity,c.name as customer_name,v.name as carrier_name,m.material as material_name,e.accepted FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id WHERE e.shift_id=$shift_id AND e.status=1 AND e.stop_id='$stop_id' UNION SELECT e.id,e.startdate,e.enddate,e.phone,e.drop_stopid as stop_id,e.pickup,e.plat,e.plng,e.`drop`,e.drop_city,e.pickup_city,e.dlat,e.dlng,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'D' as ship_type,e.customer_id,e.vendor_id,e.drop_order as priority,e.order_id,e.capacity,c.name as customer_name,v.name as carrier_name,m.material as material_name,e.accepted FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id WHERE e.shift_id=$shift_id AND e.status=1 AND e.drop_stopid ='$stop_id'";
                    $sql = "SELECT * FROM ($sql) P ORDER BY priority"; /* accepted = 1 */
                $query  = $this->db->query($sql);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $i => $res) {
                        $status   = 'N';
                        $statusid = '0';
                        $check_in = '';
                        $reason   = '';
                        $whr      = array('stop_id' => $res->id);
                        $getsts   = $this->getstopstatus($whr);
                        if (!empty($getsts)) {
                            $status   = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason   = $getsts['name'];
                        }
                        $sts        = $anystatus        = 0;
                        $chkpodsign = $this->db->query("SELECT id FROM tb_pod_uploads WHERE shipment_id='$shift_id' AND stop_id='$stop_id' AND doc_type IN(1,3) GROUP BY doc_type ORDER BY createdon DESC");
                        if ($chkpodsign->num_rows() >= 2) {
                            $anystatus = 1;
                        }
                        if ($i == 0) {
                            $anystatus = 1;
                        }
                        if ($trip > 0) {
                            $chk = $this->db->select('id,status')->get_where('tb_trip_employee', array('employee_id' => $res->id, 'trip_id' => $trip, 'stop_id' => $stop_id), 1, 0);
                            if ($chk->num_rows() > 0) {
                                if ($chk->row()->status == 1) {
                                    $sts = 1;
                                }
                            }
                            if ($sts != 1) {
                                $chk1 = $this->db->select('id')->get_where('tb_stop_status', array('stop_id' => $res->id, 'trip_id' => $trip), 1, 0);
                                if ($chk1->num_rows() > 0) {
                                    $sts = 0;
                                } else {
                                    $sts = 2;
                                }
                            }
                        }
                        $material   = $res->name;
                        $materialid = $this->db->select('material')->get_where('tb_materials', array('id' => $res->material_id), 1, 0);
                        if ($materialid->num_rows() > 0) {
                            $material = $materialid->row()->material;
                        }
                        $drop = "";
                        if (strlen($res->drop_city) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop_city)) . " - ";
                        }
                        if (strlen($res->drop) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop));
                        }
                        $pickup = "";
                        if (strlen($res->pickup_city) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup_city)) . " - ";
                        }
                        if (strlen($res->pickup) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup));
                        }
                        $result[] = array('id' => $res->id, 'name' => $res->name, 'pickup' => $pickup, 'drop' => $drop, 'phone' => $res->phone, 'plat' => $res->plat, 'plng' => $res->plng, 'dlat' => $res->dlat, 'dlng' => $res->dlng, 'capacity' => $res->capacity, 'ship_type' => $res->ship_type, 'shipment_weight' => $res->shipment_weight, 'shipment_volume' => $res->shipment_volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->priority, 'status' => $status, 'status_id' => $statusid, 'check_in' => $check_in, 'reason' => $reason, 'milestone' => $sts, 'exists_status' => $anystatus, 'material' => $material, 'order_id' => $res->order_id, "accepted" => $res->accepted);
                    }
                    $data = array('result'=>$result,'livedata'=>$curstatus);
                    $response = array("status" => 1, "data" => $data);
                } else {
                    $response = array("status" => 0, "data" => "Not Found");
                }
            } else {
                $response = array("status" => 0, "data" => "Insufficient Input Data");
            }
        } else {
            $response = array("status" => 0, "data" => "Insufficient Input Data");
        }
        echo json_encode($response);
    }
    public function customerstopsinmap()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $ship_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : '';
        if ($ship_id > 0 && $user_id > 0) {
            $trip = $trip_id;
            $drivername = $drivermobile = $vehicleno = null;
            if($trip == 0){
                $details = $this->getvehdriverbyship($ship_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }else{
                $details = $this->getvehdriverbytrip($trip_id);
                if(!empty($details)){
                    $trip = $details['trip'];
                    $drivername = $details['drivername'];
                    $drivermobile = $details['drivermobile'];
                    $vehicleno = $details['vehicleno'];
                }
            }
            $curstatus = array('lat'=>null,'lng'=>null,'speed'=>null,'timestamp'=>null,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            if($trip > 0){
                $lat = $lng = $speed = $timestamp = $bearing = null;
                $liveloc = $this->db->select('latitude,longitude,speed,bearing,timestamp')->order_by('timestamp','DESC')->get_where('tb_rtdrive_locations',array('trip_id'=>$trip),1,0);
                if($liveloc->num_rows()>0){
                    $lat = $liveloc->row()->latitude;
                    $lng = $liveloc->row()->longitude;
                    $speed = $liveloc->row()->speed;
                    $timestamp = $liveloc->row()->timestamp;
                    $bearing = $liveloc->row()->bearing;
                }
                $curstatus = array('lat'=>$lat,'lng'=>$lng,'speed'=>$speed,'timestamp'=>$timestamp,'bearing'=>$bearing,'vehicle'=>$vehicleno,'drivername'=>$drivername,'drivermobile'=>$drivermobile);
            }
            $sql = "SELECT splace,eplace,scity,dcity,startdate,enddate FROM tb_shifts WHERE id=$ship_id and user_id = $user_id ORDER BY id DESC LIMIT 1";
            $query = $this->db->query($sql);
            $res = array();
            if ($query->num_rows() > 0) {
                $d = $query->row_array();
                list($pickup, $drop) = $this->addressesFromShift($d);
                $curstatus["stime"] = $d['startdate'];
                $curstatus["splace"] = $pickup;
                $curstatus["eplace"] = $drop;
                $curstatus["avgspeed"] = 10;
                $sql = "select * from tb_shiporder_stops where shipment_id=$ship_id ORDER BY ordernumber ASC";
                $query  = $this->db->query($sql);
                $result = array();
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $stop_id = $res->id;
                        $stoplegs = array();
                        $sql = "SELECT id,pickup,plat,plng,`drop`,drop_city,pickup_city,dlat,dlng,pickup_datetime,drop_datetime,name,shipment_weight,shipment_volume,stop_order,order_id,pkgitemid as material,'P' as ship_type,accepted FROM tb_employee WHERE stop_id='$stop_id' AND shift_id = $ship_id AND status=1 UNION SELECT id,pickup,plat,plng,`drop`,drop_city,pickup_city,dlat,dlng,pickup_datetime,drop_datetime,name,shipment_weight,shipment_volume,stop_order,order_id,pkgitemid as material,'P' as ship_type,accepted FROM tb_employee WHERE drop_stopid='$stop_id' AND shift_id = $ship_id AND status=1";
                        $emp = $this->db->query("SELECT * FROM ($sql) P WHERE accepted = 1 ORDER BY stop_order ASC");
                        if($emp->num_rows() > 0){
                            foreach($emp->result_array() as $res1){
                                $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$res1['id'],'status'=>1);
                                $lstatus = "N";
                                $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if($legdetails->num_rows() > 0) {
                                    $lstatus = "S";
                                    $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$res1['id'],'status_id'=>1,'status'=>1);
                                    $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                    if($legdetails->num_rows()>0){
                                        $lstatus = "C";
                                    }
                                }
                                $res1['leg_status'] = $lstatus;
                                $stoplegs[] = $res1;
                            }
                        }
                        $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                        $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        $status   = "N";
                        if($statuses->num_rows() > 0){
                            $status = "S";
                            $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                            $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if($gateout_details->num_rows() > 0) {
                                $status = "C";
                            }
                        }
                        $stopname = "";
                        if (strlen($res->stopcity) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                        }
                        if (strlen($res->stopname) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                        }
                        $result[] = array('stop_id' => $stop_id, 'stop_name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'stop_status' => $status,'stoplegs'=>$stoplegs);
                    }
                }
                $data = array('result'=>$result,'livedata'=>$curstatus);
                $response = array("status"=>1,"data"=>$data);
            }else{
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    public function customershipstatuses()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data1  = array();
            $status = 0;
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : null;
            $cust_id = isset($_POST["cust_id"]) ? $_POST["cust_id"] : null;
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : null;
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : null;
            if ($trip_id != null && $shift_id != null) {
                $qry = $this->db->query("SELECT s.latitude,s.longitude,s.createdon,m.status_name FROM tb_stop_status s,tb_status_master m WHERE s.status_id=m.id AND s.trip_id=$trip_id ORDER BY s.createdon ASC");
                $response = array("status" => 1, "data" => $data1);
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $placename = getLocationName($res->latitude, $res->longitude);
                        $data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));
                    }
                    $response = array("status" => 1, "data" => $data1);
                }
            }
        }
        echo json_encode($response);
    }
    public function shipmentstatushistory()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $ship_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : '';
        if ($ship_id > 0 && $user_id > 0) {
            $sql = "select * from tb_shiporder_stops where shipment_id=$ship_id ORDER BY ordernumber ASC";
            $query  = $this->db->query($sql);
            $result = array();
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $res) {
                    $stop_id = $res->id;
                    $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id);
                    $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                    $status   = "N";
                    if($statuses->num_rows() > 0){
                        $status = "S";
                        $whr = array("stop_id" => $stop_id, "shipment_id" => $ship_id, "status_id" => "1", "status" => "1");
                        $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        if($gateout_details->num_rows() > 0) {
                            $status = "C";
                        }
                    }
                    $stopname = "";
                    if (strlen($res->stopcity) > 0) {
                        $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                    }
                    if (strlen($res->stopname) > 0) {
                        $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                    }
                    $chkpod = $this->db->query("SELECT imgpath,doc_type,hash FROM tb_pod_uploads WHERE shipment_id=$ship_id AND stop_id=null LIMIT 1");
                    $img = "";
                    if($chkpod->num_rows()>0){
                        $img = base_url()."downloadEpod/safelink/".$chkpod->row()->hash.'.epod';
                    }
                    $result[] = array('title' => $stopname, 'sub_title' => "Stop", 'date' => strtotime($res->startdate), 'status' => $status,'type'=>$res->stoptype,'image'=>$img);
                    $hstatus = array();
                    $sql = "SELECT id,pickup,plat,plng,`drop`,drop_city,pickup_city,dlat,dlng,pickup_datetime,drop_datetime,name,shipment_weight,shipment_volume,stop_order,order_id,pkgitemid as material,'P' as ship_type,accepted FROM tb_employee WHERE stop_id='$stop_id' AND shift_id = $ship_id AND status=1 UNION SELECT id,pickup,plat,plng,`drop`,drop_city,pickup_city,dlat,dlng,pickup_datetime,drop_datetime,name,shipment_weight,shipment_volume,stop_order,order_id,pkgitemid as material,'P' as ship_type,accepted FROM tb_employee WHERE drop_stopid='$stop_id' AND shift_id = $ship_id AND status=1";
                    $emp = $this->db->query("SELECT * FROM ($sql) P WHERE accepted = 1 ORDER BY stop_order ASC");
                    if($emp->num_rows() > 0){
                        foreach($emp->result_array() as $res1){
                            $stopdetailid = $res1['id'];
                            $chkpod = $this->db->query("SELECT imgpath,doc_type,hash FROM tb_pod_uploads WHERE (stop_id=$stop_id OR stop_detail_id=$stopdetailid) LIMIT 1");
                            $img = "";
                            if($chkpod->num_rows()>0){
                                $img = base_url()."downloadEpod/safelink/".$chkpod->row()->hash;
                            }
                            $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$stopdetailid,'status'=>1);
                            $lstatus = "N";
                            $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if($legdetails->num_rows() > 0) {
                                $lstatus = "S";
                                $whr = array("shipment_id" => $ship_id,"stop_id" => $stop_id, "stop_detail_id"=>$stopdetailid,'status_id'=>1,'status'=>1);
                                $legdetails = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if($legdetails->num_rows()>0){
                                    $lstatus = "C";
                                }
                            }
                            if($res1['ship_type'] == 'P'){
                                $stopdetname = $res1['pickup_city'];
                                $ptime = $res1['pickup_datetime'];
                            }else{
                                $stopdetname = $res1['drop'];
                                $ptime = $res1['drop_datetime'];
                            }
                            $stopdetail = array('title' => $stopdetname, 'sub_title' => "Stop Details", 'date' => strtotime($ptime), 'status' => $lstatus,'type'=>$res1['ship_type'],'image'=>$img);
                            $result[] = $stopdetail;
                            $qry = $this->db->query("SELECT s.status_id,s.latitude,s.longitude,s.createdon,m.status_name FROM tb_stop_status s,tb_status_master m WHERE s.status_id=m.id AND s.trip_id=$trip_id AND (s.stop_id=$stop_id OR s.stop_detail_id=$stopdetailid) ORDER BY s.createdon ASC");
                            if ($qry->num_rows() > 0) {
                                foreach ($qry->result() as $rw) {
                                    $placename = getLocationName($rw->latitude, $rw->longitude);
                                    $stsname = $rw->status_name;
                                    if($stsname == "Pickup Or Drop"){
                                        if($res1['ship_type'] == 'P'){
                                            $stsname = "Pickup";
                                        }else{
                                            $stsname = "Drop";
                                        }
                                    }
                                    $sstatus = "N";
                                    if($rw->status_id > 1){
                                        $sstatus = "S";
                                    }
                                    if($rw->status_id == 1){
                                        $sstatus = "C";
                                    }
                                    $hstatus = array('title' => $stsname, 'sub_title' => $placename, 'date' => strtotime($rw->createdon), 'status' => $sstatus,'type'=>$res1['ship_type'],'image'=>"");
                                    $result[] = $hstatus;
                                }
                            }
                        }
                    }
                }
                $response = array("status"=>1,"data"=>$result);
            }else{
                $response = array("status" => 0, "data" => "Not Found");
            }
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }
    public function setdriverfeedback(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
        $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
        $feedback = isset($_POST['feedback']) ? $_POST['feedback'] : '';
        $curdt = date('Y-m-d H:i:s');
        if($driver_id != "" && $feedback != ""){
            $arr = array('trip_id'=>$trip_id, 'ship_id'=>$ship_id, 'stop_id'=>$stop_id, 'stop_detail_id'=>$stop_id, 'noted_by'=>$driver_id, 'user_type'=>0, 'feedback'=>$feedback, 'status'=>1, 'created_on'=>$curdt);
            $ins = $this->db->insert("tb_trip_feebacks",$arr);
            $response = array("status"=>1,"data"=>"Success");
        }
        echo json_encode($response);
    }
    public function setuserfeedback(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
        $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
        $feedback = isset($_POST['feedback']) ? $_POST['feedback'] : '';
        $curdt = date('Y-m-d H:i:s');
        if($cust_id != "" && $feedback != ""){
            $arr = array('trip_id'=>$trip_id, 'ship_id'=>$ship_id, 'stop_id'=>$stop_id, 'stop_detail_id'=>$stop_id, 'noted_by'=>$cust_id, 'user_type'=>1, 'feedback'=>$feedback, 'status'=>1, 'created_on'=>$curdt);
            $ins = $this->db->insert("tb_trip_feebacks",$arr);
            $response = array("status"=>1,"data"=>"Success");
        }
        echo json_encode($response);
    }
    public function orderquote(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $data = (array)$post;
            $customerid = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $uid = isset($_POST['user_id']) ? $_POST['user_id'] : 1;
            $consigneeName = isset($post->consigneeName) ? $post->consigneeName : "";
            $consigneePhone = isset($post->consigneePhone) ? $post->consigneePhone : "";
            $consigneeEmail = isset($post->consigneeEmail) ? $post->consigneeEmail : "";
            $consigneeCode = isset($post->consigneeCode) ? $post->consigneeCode : "";
            $consignorName = isset($post->consignorName) ? $post->consignorName : "";
            $consignorPhone = isset($post->consignorPhone) ? $post->consignorPhone : "";
            $consignorEmail = isset($post->consignorEmail) ? $post->consignorEmail : "";
            $consignorCode = isset($post->consignorCode) ? $post->consignorCode : "";
            $pickupDate = isset($post->pickupDate) ? $post->pickupDate : "";
            $pickupCity = isset($post->pickupCity) ? $post->pickupCity : "";
            $pickupAddressLine1 = isset($post->pickupAddressLine1) ? $post->pickupAddressLine1 : "";
            $pickupCompany = isset($post->pickupCompany) ? $post->pickupCompany : "";
            $pickupCountry = $data['pickup_country'] = isset($post->pickupCountry) ? $post->pickupCountry : "";
            $pickupPin = isset($post->pickupPin) ? $post->pickupPin : "";
            $dropDate = isset($post->dropDate) ? $post->dropDate : "";
            $dropCity = isset($post->dropCity) ? $post->dropCity : "";
            $dropAddressLine1 = isset($post->dropAddressLine1) ? $post->dropAddressLine1 : "";
            $dropCompany = isset($post->dropCompany) ? $post->dropCompany : "";
            $dropCountry = $data['drop_country'] = isset($post->dropCountry) ? $post->dropCountry : "";
            $dropPin = isset($post->dropPin) ? $post->dropPin : "";
            $quantity = $data['quantity'] = isset($post->quantity) ? $post->quantity : 0;
            $weight = $data['weight'] = isset($post->weight) ? $post->weight : 0;
            $volume = $data['volume'] = isset($post->volume) ? $post->volume : 0;
            $shipmentOption = isset($post->shipmentOption) ? $post->shipmentOption : 0;
            if($shipmentOption == "0"){ $shipmentOption = "TL"; }else{ $shipmentOption = "LTL"; }
            $data['transportmode'] = $shipmentOption;
            $valueOfGoods = isset($post->valueOfGoods) ? $post->valueOfGoods : 0;
            $cargos = $data['detail_cargo'] = isset($post->cargoes) ? $post->cargoes : array();
            $addOns = $data['add_ons'] = isset($post->addOns) ? $post->addOns : array();
            $plat = isset($post->plat) ? $post->plat : "";
            $plng = isset($post->plng) ? $post->plng : "";
            $dlat = isset($post->dlat) ? $post->dlat : "";
            $dlng = isset($post->dlng) ? $post->dlng : "";
            $curdt = date('Y-m-d H:i:s');
            /* check consignor */
            $vend = array('name'=>$consignorName,'mobile'=>$consignorPhone);
            $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
            if($chkvend->num_rows()>0){
                $vendorid = $chkvend->row()->id;
            }else{
                $vendarr = array('name'=>$consignorName,'mobile'=>$consignorPhone, 'location'=>$pickupCity, 'address'=>$pickupCity, 'code'=>$consignorPhone, 'email'=>$consignorEmail, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
                $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
            }
            $company_code = $branch_code = "";
            $chkusr = $this->db->select("company_code,branch_code")->get_where("tb_users",array("id"=>$uid),1,0);
            if($chkusr->num_rows()>0){
                $company_code = $chkusr->row()->company_code;
                $branch_code = $chkusr->row()->branch_code;
            }
            $ord = $company_code.time();
            $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickupDate, 'delivery_datetime'=>$dropDate, 'pickup_company'=>$pickupCompany, 'delivery_company'=>$dropCompany, 'pickup_country'=>$pickupCountry, 'delivery_country'=>$dropCountry, 'pickup_city'=>$pickupCity, 'delivery_city'=>$dropCity, 'pickup_pincode'=>$pickupPin, 'delivery_pincode'=>$dropPin, 'pickup_address1'=>$pickupAddressLine1, 'delivery_address1'=>$dropAddressLine1, 'quantity'=>$quantity, 'weight'=>$weight, 'volume'=>$volume, 'goods_value'=>$valueOfGoods, 'transport_mode'=>$shipmentOption, 'dedicated_vehicle'=>0, 'vehicle_type'=>"", 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$consigneeName, 'customer_code'=>$consigneeCode, 'customer_area'=>$pickupCity, 'customer_phone'=>$consigneePhone, 'customer_email'=>$consigneeEmail, 'vendor_name'=>$consignorName, 'vendor_code'=>$consignorCode, 'vendor_area'=>$pickupCity, 'vendor_phone'=>$consignorPhone, 'vendor_email'=>$consignorEmail, 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'createdon'=>$curdt,"created_source"=>1,"company_code"=>$company_code,"branch_code"=>$branch_code,"modeoftransport"=>1);
            $orderid = $this->common->insertTableData("tb_orders",$orddata);
            /* insert into cargo types */
            if(count($cargos)>0){
                foreach($cargos as $ct){
                    if($ct != ""){
                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
                    }
                }
            }
            /* insert into cargo details */
            $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>1, 'length'=>$weight, 'width'=>$weight, 'height'=>$weight, 'weight'=>$weight, 'quantity'=>$quantity, 'status'=>1, 'createdon'=>$curdt);
            $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
            /* insert into add ons */
            if(count($addOns)>0){
                foreach($addOns as $dc){
                    if($dc != ""){
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
           /* $this->load->helper('shiporder_helper');
            $res = sendorderotp($data);*/
            $result['status'] = 1;
            $basecost = $totalcost = 15000;
            $accessorial = $special_services = array();
            /*if(isset($res['qryres']['costdetails'])){
                if(count($res['qryres']['costdetails']) > 0){
                    foreach($res['qryres']['costdetails'] as $actcost){
                        $totalcost += $actcost['costdetamount'];
                        if($actcost['associd'] == ""){
                            $basecost = $actcost['costdetamount'];
                        }else{
                            $accessorial[] = array('id'=>$actcost['associd'],'cost'=>$actcost['costdetamount']);
                        }
                    }
                }
            }
            if(isset($res['qrydata']['specialservices'])){
                if(count($res['qrydata']['specialservices']) > 0){
                    foreach($res['qrydata']['specialservices'] as $rs){
                        $chk = 0.00;
                        if(!empty($accessorial)){
                            foreach($accessorial as $ac){
                                if($ac['id'] == $rs['serviceid']){
                                    $chk = $ac['cost'];
                                }
                            }
                        }
                        $special_services[] = array('service_name'=>explode('_', $rs['serviceid'])[1],'service_cost'=>$chk);
                    }
                }
            }*/
            $special_services[] = array('service_name'=>'CARGO INSURANCE','service_cost'=>'4000');
            $special_services[] = array('service_name'=>'CARGO INSURANCE2','service_cost'=>'5000');
            $special_services[] = array('service_name'=>'CARGO INSURANCE3','service_cost'=>'6000');
            $rateitem = "2 X ".$basecost;
            $result['data'] = array('base_rate' => $basecost,'base_rate_item'=>$rateitem,'order_id'=>$ord,'special_services'=>$special_services);
            $response = $result;
        }
        echo json_encode($response);
    }
    public function bookorderquote(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            /*$post = json_decode($_POST['data']);
            $data = (array)$post;*/
            $post = $_POST;
            $cust_id = isset($post['cust_id']) ? $post['cust_id'] : '';
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $orderid = isset($post['order_id']) ? $post['order_id'] : '';
            $response = array("status"=>1,"data"=>array("status"=>"Booking Complete","order_id"=>$orderid));
        }
        echo json_encode($response);
    }
    public function quickbook(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $post = json_decode($_POST['data']);
            $data = (array)$post;
            $customerid = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $uid = isset($_POST['user_id']) ? $_POST['user_id'] : 1;
            $consigneeName = isset($post->consigneeName) ? $post->consigneeName : "";
            $consigneePhone = isset($post->consigneePhone) ? $post->consigneePhone : "";
            $consigneeEmail = isset($post->consigneeEmail) ? $post->consigneeEmail : "";
            $consigneeCode = isset($post->consigneeCode) ? $post->consigneeCode : "";
            if($consigneeName == ""){
                $where = array("id"=>$customerid);
                $custdetails = $this->common->gettblrowdata($where,"name,phone,code,email_id","tb_customers",0,0);
                if(count($custdetails)>0){
                    $consigneeName = $custdetails['name'];
                    $consigneePhone = $custdetails['phone'];
                    $consigneeEmail = $custdetails['email_id'];
                    $consigneeCode = $custdetails['code'];
                }
            }
            $consignorName = isset($post->consignorName) ? $post->consignorName : "";
            $consignorPhone = isset($post->consignorPhone) ? $post->consignorPhone : "";
            $consignorEmail = isset($post->consignorEmail) ? $post->consignorEmail : "";
            $consignorCode = isset($post->consignorCode) ? $post->consignorCode : "";
            $pickupDate = isset($post->pickupDate) ? $post->pickupDate : "";
            $pickupCity = isset($post->pickupCity) ? $post->pickupCity : "";
            $pickupAddressLine1 = isset($post->pickupAddressLine1) ? $post->pickupAddressLine1 : "";
            $pickupCompany = isset($post->pickupCompany) ? $post->pickupCompany : "";
            $pickupCountry = $data['pickup_country'] = isset($post->pickupCountry) ? $post->pickupCountry : "";
            $pickupPin = isset($post->pickupPin) ? $post->pickupPin : "";
            $dropDate = isset($post->dropDate) ? $post->dropDate : "";
            $dropCity = isset($post->dropCity) ? $post->dropCity : "";
            $dropAddressLine1 = isset($post->dropAddressLine1) ? $post->dropAddressLine1 : "";
            $dropCompany = isset($post->dropCompany) ? $post->dropCompany : "";
            $dropCountry = $data['drop_country'] = isset($post->dropCountry) ? $post->dropCountry : "";
            $dropPin = isset($post->dropPin) ? $post->dropPin : "";
            $quantity = $data['quantity'] = isset($post->quantity) ? $post->quantity : 0;
            $weight = $data['weight'] = isset($post->weight) ? $post->weight : 0;
            $volume = $data['volume'] = isset($post->volume) ? $post->volume : 0;
            $shipmentOption = isset($post->shipmentOption) ? $post->shipmentOption : 0;
            if($shipmentOption == "0"){ $shipmentOption = "TL"; }else{ $shipmentOption = "LTL"; }
            $data['transportmode'] = $shipmentOption;
            $valueOfGoods = isset($post->valueOfGoods) ? $post->valueOfGoods : 0;
            $cargos = $data['detail_cargo'] = isset($post->cargoes) ? $post->cargoes : array();
            $addOns = $data['add_ons'] = isset($post->addOns) ? $post->addOns : array();
            $plat = isset($post->plat) ? $post->plat : "";
            $plng = isset($post->plng) ? $post->plng : "";
            $dlat = isset($post->dlat) ? $post->dlat : "";
            $dlng = isset($post->dlng) ? $post->dlng : "";
            $curdt = date('Y-m-d H:i:s');
            /* check consignor */
            /*$vend = array('name'=>$consignorName,'code'=>$consignorPhone);
            $chkvend = $this->db->select('id')->get_where("tb_vendors",$vend,1,0);
            if($chkvend->num_rows()>0){
                $vendorid = $chkvend->row()->id;
            }else{
                $vendarr = array('name'=>$consignorName,'mobile'=>$consignorPhone, 'location'=>$pickupCity, 'address'=>$pickupCity, 'code'=>$consignorPhone, 'email'=>$consignorEmail, 'password'=>'TVRJek5EVTI=', 'user_id'=>$uid, 'status'=>1,'created_on'=>$curdt);
                $vendorid = $this->common->insertTableData("tb_vendors",$vendarr);
            }*/
            $vendorid = 0;
            $company_code = $branch_code = "";
            $chkusr = $this->db->select("company_code,branch_code")->get_where("tb_users",array("id"=>$uid),1,0);
            if($chkusr->num_rows()>0){
                $company_code = $chkusr->row()->company_code;
                $branch_code = $chkusr->row()->branch_code;
            }
            $ord = $company_code.time();
            $orddata = array('order_id'=>$ord, 'pickup_datetime'=>$pickupDate, 'delivery_datetime'=>$dropDate, 'pickup_company'=>$pickupCompany, 'delivery_company'=>$dropCompany, 'pickup_country'=>$pickupCountry, 'delivery_country'=>$dropCountry, 'pickup_city'=>$pickupCity, 'delivery_city'=>$dropCity, 'pickup_pincode'=>$pickupPin, 'delivery_pincode'=>$dropPin, 'pickup_address1'=>$pickupAddressLine1, 'delivery_address1'=>$dropAddressLine1, 'quantity'=>$quantity, 'weight'=>$weight, 'volume'=>$volume, 'goods_value'=>$valueOfGoods, 'transport_mode'=>$shipmentOption, 'dedicated_vehicle'=>0, 'vehicle_type'=>"", 'user_id'=>$uid, 'customer_id'=>$customerid, 'vendor_id'=>$vendorid, 'customer_name'=>$consigneeName, 'customer_code'=>$consigneeCode, 'customer_area'=>$pickupCity, 'customer_phone'=>$consigneePhone, 'customer_email'=>$consigneeEmail, 'vendor_name'=>$consignorName, 'vendor_code'=>$consignorCode, 'vendor_area'=>$pickupCity, 'vendor_phone'=>$consignorPhone, 'vendor_email'=>$consignorEmail, 'plat'=>$plat, 'plng'=>$plng, 'dlat'=>$dlat, 'dlng'=>$dlng, 'status'=>1, 'createdon'=>$curdt,"created_source"=>1,"company_code"=>$company_code,"branch_code"=>$branch_code,"modeoftransport"=>1);
            $orderid = $this->common->insertTableData("tb_orders",$orddata);
            /* insert into cargo types */
            if(count($cargos)>0){
                foreach($cargos as $ct){
                    if($ct != ""){
                        $ins = array('cargo_type'=>$ct, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
                    }
                }
            }else{
                $ins = array('cargo_type'=>"General Cargo", 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                $cargotype = $this->common->insertTableData("tb_order_cargotypes",$ins);
            }
            /* insert into cargo details */
            $cargodetails = array('order_id'=>$orderid, 'handling_unit'=>1, 'length'=>$weight, 'width'=>$weight, 'height'=>$weight, 'weight'=>$weight, 'quantity'=>$quantity, 'status'=>1, 'createdon'=>$curdt);
            $cargo_details = $this->common->insertTableData("tb_order_cargodetails",$cargodetails);
            /* insert into add ons */
            if(count($addOns)>0){
                foreach($addOns as $dc){
                    if($dc != ""){
                        $ins = array('service_type'=>'original document return', 'addon_name'=>$dc, 'order_id'=>$orderid, 'status'=>1, 'createdon'=>$curdt);
                        $cargotype = $this->common->insertTableData("tb_order_addons",$ins);
                    }
                }
            }
            /*$this->load->helper('shiporder_helper');
            $res = sendorderotp($data);*/
            $response = array("status"=>1,"data" =>array("status"=>"Booking Complete","order_id"=>$ord));
        }
        echo json_encode($response);
    }
    public function setreceivedgoods(){
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
            $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
            $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
            $packages = isset($_POST['packages']) ? $_POST['packages'] : 0;
            $weight = isset($_POST['weight']) ? $_POST['weight'] : 0;
            $volume = isset($_POST['volume']) ? $_POST['volume'] : 0;
            $remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
            $curdt = date('Y-m-d H:i:s');
            if($cust_id != "" && $ship_id != ""){
                $arr = array('trip_id'=>$trip_id, 'ship_id'=>$ship_id, 'stop_id'=>$stop_id, 'stop_detail_id'=>$stop_id, 'noted_by'=>$cust_id, 'user_type'=>1, 'packages'=>$packages, 'weight'=>$weight, 'volume'=>$volume, 'feedback'=>$remarks, 'status'=>1, 'created_on'=>$curdt);
                $ins = $this->db->insert("tb_trip_feebacks",$arr);
                $response = array("status"=>1,"data"=>"Success");
            }
            $response = array("status"=>1,"data" =>"Updated Successfully!");
        }
        echo json_encode($response);
    }
    public function customerOrders()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $cust_id = isset($_POST['cust_id']) ? $_POST['cust_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            if($cust_id != "" && $user_id != ""){
                $orders_qry = $this->db->query("SELECT o.id, o.order_id, o.pickup_datetime, o.pickup_endtime, o.delivery_datetime, o.drop_endtime, o.pickup_company, o.delivery_company, o.pickup_country, o.delivery_country, o.pickup_city, o.delivery_city, o.pickup_pincode, o.delivery_pincode, o.plat, o.plng, o.dlat, o.dlng, o.`status`, UNIX_TIMESTAMP(o.createdon) AS createdon,o.vendor_id, v.name as vendor_name FROM tb_orders o LEFT JOIN tb_vendors v ON v.id = o.vendor_id WHERE o.`status`!='0' AND o.customer_id = '$cust_id' order by status DESC");
                $orders = [];
                foreach($orders_qry->result_array() as $i=>$row){
                    if($row["status"]=="2"){
                        $row["status"] = $this->db->query("SELECT IF(count(ss.id)>0,3,2) as new_status FROM tb_order_cargodetails cd LEFT JOIN tb_stop_status ss ON ss.stop_detail_id = cd.stop_detail_id WHERE cd.order_id = '".$row['id']."'")->row()->new_status;
                    }
                    if($i<3){
                        $row["status"] = "3";
                    }
                    $orders[] = $row;
                }
                $response =  (array("status"=>"1","data"=>$orders));
            }
        }
        echo json_encode($response);
    }
    function array_sort($array, $on, $order=SORT_ASC)
    {
        $new_array = array();
        $sortable_array = array();
        if (count($array) > 0) {
            foreach ($array as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if ($k2 == $on) {
                            $sortable_array[$k] = $v2;
                        }
                    }
                } else {
                    $sortable_array[$k] = $v;
                }
            }
            switch ($order) {
                case SORT_ASC:
                    asort($sortable_array);
                break;
                case SORT_DESC:
                    arsort($sortable_array);
                break;
            }
            foreach ($sortable_array as $k => $v) {
                $new_array[$k] = $array[$k];
            }
        }
        return $new_array;
    }

    public function uploadcostomes()
    {
        $response  = array("status" => 0, "data" => "Something went wrong!");
        if(isset($_POST)){
            $curdt = date('Y-m-d H:i:s');
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
            $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : 0;
            $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : 0;
            if($trip_id != "" && $user_id != ""){
                $fileName = "";
                $file_upload_flag = false;
                if (isset($_FILES)) {
                	foreach($_FILES as $k=>$FILE){
	                    if (isset($FILE['name'])) {
	                        $config = array(
	                            'upload_path'   => NEW_POD_PATH,
	                            'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
	                            'overwrite'     => true,
	                        );
	                        $file_name = $FILE['name'];
	                        $file_ext= @strtolower(end(explode('.',$FILE['name'])));
	                        $expensions= array("jpeg","jpg","png","gif","pdf");
	                        if(in_array($file_ext,$expensions) === false){
	                        }else{
	                            if($file_ext == "pdf"){
	                                $imgtype = "pdf";
	                                $this->load->library('upload', $config);
	                                $ff = 'file_name'.$k;
	                                if ($this->upload->do_upload($ff)) {
	                                    $imgname  = $this->upload->data();
	                                    $imgtype = $imgname['image_type'];
	                                    $fileName = $imgname['file_name'];
	                                }
	                            }else{
	                                $fileName = date('dmyhis').''.$file_name;
	                                $filePath = NEW_POD_PATH.$fileName;
	                                $imgsize = getimagesize($FILE['tmp_name']);
	                                $top_width = $imgsize[0];
	                                $top_height = $imgsize[1];
	                                $quality = 100;
	                                if($file_ext == "png"){
	                                    $top = imagecreatefrompng($FILE['tmp_name']);
	                                    $imgtype = "png";
	                                }else{
	                                    $top = imagecreatefromjpeg($FILE['tmp_name']);
	                                    if($file_ext == "jpg" || $file_ext == "jpeg"){
	                                        $imgtype = "jpeg";
	                                    }else{
	                                        $imgtype = $file_ext;
	                                    }
	                                }
	                                header('Content-Type: image/jpeg');
	                                imagejpeg($top,$filePath,$quality);
	                                imagedestroy($top);
	                            }
	                        }
	                    }
	                }
                }
                $chk = $this->db->select('shift_id,vehicle_id')->get_where('tb_trips',array('id'=>$trip_id),1,0);
                $shipment_id = $vehicle_id = 0;
                if($chk->num_rows()>0){
                    $shipment_id = $chk->row()->shift_id;
                    $vehicle_id = $chk->row()->vehicle_id;
                }
                $filedata = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 2, 'imgpath' => $fileName, 'status' => 1, 'createdon' => $curdt);
                $res = $this->db->insert("tb_pod_uploads", $filedata);
                $file_upload_flag = true;
                $id = $this->db->insert_id();
                /*store in status also */
                $stsdata = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id'=>5, 'latitude' => $latitude, 'longitude' => $longitude, 'status'=>1, 'reason'=>'Out Of Border', 'vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'createdon'=>$curdt);
                $res = $this->db->insert("tb_stop_status", $stsdata);
                $response =  (array("status"=>"1","data"=>array()));
            }
        }
        echo json_encode($response);
    }
}
