<?php

if (! defined('BASEPATH')) {
  exit('No direct script access allowed');
}

class ExcelimportGeotier extends CI_Controller
{

  private $min_max_keys = [];

  public function __Construct()
  {
    parent::__Construct();

    if ($this->session->userdata('user_id') == '') {
      redirect('login');
    }
    if (! isset($_SESSION['XL_MAX_COLS']) && ! isset($_SESSION['XL_MAX_ROWS'])) {
      $this->session->set_userdata('XL_MAX_COLS', 80);
      $this->session->set_userdata('XL_MAX_ROWS', 200);
    }
    $this->load->model("common");
    $this->load->helper("generic");
    $this->load->model("KNrategeotiermodel");
  }

  public function index()
  {
    $data["page_title"] = "Import Geotier Data";
    $this->settemplate->dashboard("geotier/home", $data);
  }

  public function geotierdata()
  {
    $XL_MAX_COLS = $this->session->userdata('XL_MAX_COLS');
    ini_set('max_execution_time', 1000);
    ini_set('memory_limit', '3072M');
    require_once APPPATH . "/third_party/PHPExcel.php";
    require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

    $data                 = [];
    $data['page_title']   = $this->lang->line('geo_tier');
    $data['sub_title']    = $this->lang->line('general_add');
    $company_code         = $this->session->userdata('company_code');
    $branch_code          = $this->session->userdata('branch_code');
    $user_id              = $this->session->userdata('user_id');
    $data['company_code'] = $company_code;
    $data['branch_code']  = $branch_code;
    $data['user_id']      = $user_id;
    $data['geo_master']   = $this->common->gettbldata(['status' => 1], 'id,name', 'tb_geo_master', 0, 0);

    $company_code = $this->session->userdata('company_code');
    if ($company_code == 'RUKN') {
      $list = [
        "SELECT",
        'DISTANCE',
        'WEIGHT',
        'VOLUME',
        'DURATION',
        'QUANTITY',
        'LDM',
        'VOLUMETRIC WEIGHT',
        'ACTUAL WEIGHT',
        'ACTUAL VOLUME',
      ];
    } else {
      $list = [
        "SELECT",
        'DISTANCE',
        'WEIGHT',
        'VOLUME',
        'DURATION'
      ];
    }

    $data['geo_uom1units'] = $list;
    $data['currencies']    = $this->KNrategeotiermodel->getcurrency();
    $where1                = [
      'status'       => 1,
      'company_code' => $company_code
    ];
    $data['veh_type']      = $this->common->gettbldata($where1, '`id`, `trucktype`', 'tb_trucktypes', 0, 0);

    if (isset($_FILES['import_file'])) {
      $ext = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
      if ($ext == "xls" || $ext == "xlsx") {
        $path        = $_FILES['import_file']['tmp_name'];
        $objPHPExcel = PHPExcel_IOFactory::load($path);
        $sheetData   = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
        for ($i = 1; $i <= $XL_MAX_COLS; $i++) {
          $__min_max_key[] = 'geotierMin' . $i;
          $__min_max_key[] = 'geotiermax' . $i;
        }
        $this->min_max_keys = [
          'geotierFrom',
          'geotierTo',
          'geotierMinimum',
        ];
        $this->min_max_keys = array_merge($this->min_max_keys, $__min_max_key);
        $this->session->unset_userdata('MAX_COLUMNS');
        $this->session->unset_userdata('MAX_ROWS');
        $data['genralinfo']   = $this->getgeninfo($sheetData);
        $data['min_max_vals'] = $this->getminmaxval($sheetData);
        $data['rates_array']  = $this->getrates($sheetData);

        $this->newtemplate->dashboard("geotier/importgeo", $data);
      }
    }
  }

  /* get only general info data */
  private function getgeninfo($sheetData)
  {
    $genralinfo = [];
    if (! empty($sheetData)) {
      for ($i = 2; $i < 9; $i++) {
        $genralinfo[] = trim($sheetData[$i]['B']??"");
      }
    }
    if (! empty($genralinfo)) {
      $geninfo_keys = [
        'geotiername',
        'geotierHierarchy',
        'geotierUOM',
        'geotierUOMunit',
        'geotierCurrency',
        'geotierVehicleType',
        'marginal_cost'
      ];
      $genralinfo   = array_combine($geninfo_keys, $genralinfo);
    }

    return $genralinfo;
  }

  /* get only minimum maximum values */
  private function getminmaxval($sheetData)
  {
    $XL_MAX_COLS = $this->session->userdata('XL_MAX_COLS');
    ini_set('memory_limit', '3072M');
    $min_max_val_arr = [];
    if (! empty($sheetData)) {
      for ($i = 11; $i < 12; $i++) {
        $min_max_vals = $sheetData[$i]??[];
      }
    }
    $max_cols_count = (count($min_max_vals) - 3) / 2;
    $this->session->set_userdata('MAX_COLUMNS', $max_cols_count);
    if (! empty($min_max_vals)) {
      $count_val = count($min_max_vals);
      if ($count_val < $XL_MAX_COLS * 2 + 3) {
        for ($j = $count_val; $j < $XL_MAX_COLS * 2 + 3; $j++) {
          $min_max_vals[$j] = "";
        }
      }

      $min_max_vals   = array_slice($min_max_vals, 0, $XL_MAX_COLS * 2 + 3);
      $min_max_valarr = array_combine($this->min_max_keys, $min_max_vals);
      if (! empty($min_max_valarr)) {
        $min_max_val_arr = $min_max_valarr;
      }
    }

    return $min_max_val_arr;
  }

  /* get rates */
  private function getrates($sheetData)
  {
    $XL_MAX_COLS = $this->session->userdata('XL_MAX_COLS');
    ini_set('memory_limit', '3072M');
    $final_rates_arr = [];
    if (! empty($sheetData)) {
      $count_sheet_val = count($sheetData);
      for ($i = 12; $i <= $count_sheet_val; $i++) {
        $rates_arr = $sheetData[$i]??[];
        $count_val = count($rates_arr);
        if ($count_val < $XL_MAX_COLS * 2 + 3) {
          for ($j = $count_val; $j < $XL_MAX_COLS * 2 + 3; $j++) {
            $rates_arr[$j] = "";
          }
        }
        $rates_arr      = array_slice($rates_arr, 0, $XL_MAX_COLS * 2 + 3);
        $rates_finalarr = array_combine($this->min_max_keys, $rates_arr);
        if (! empty($rates_finalarr)) {
          $final_rates_arr[] = $rates_finalarr;
        }
      }
    }

    $this->session->set_userdata('MAX_ROWS', count($final_rates_arr));

    return $final_rates_arr;
  }

  public function adddeliverytermdata()
  {
    $status = 1;
    if (! empty($_POST['geterm_details'])) {
      foreach ($_POST['geterm_details'] as $data) {
        $termid               = $data['termid']??"";
        $termname             = $data['termname']??"";
        $incoterms            = $data['incoterms']??"";
        $details              = [
          'term_id'  => $termid,
          'name'     => $termname,
          'incoterm' => $incoterms,
          'status'   => $status
        ];
        $details['createdon'] = date('Y-m-d H:i:s');
        $table                = 'tb_delivery_terms';
        $this->common->insertTableData($table, $details);
      }
    }
    redirect('geotier');
  }

  public function generate_drop_down1()
  {
    $type         = $this->input->post('type', true);
    $selecteddata = $this->input->post('selecteddata', true);
    $this->load->helper('drop_down_helper');
    $response = get_measurement_units($type, $selecteddata);

    echo $response;
  }

  public function generate_drop_down()
  {
    $type = $this->input->post('type', true);
    $this->load->helper('drop_down_helper');
    $response = get_measurement_units($type, 'SELECT');

    echo $response;
  }

  function get_min_max_records_count()
  {
    $XL_MAX_COLS    = $this->session->userdata('XL_MAX_COLS');
    $min_max_prices = [];
    for ($y = 1; $y <= $XL_MAX_COLS; $y++) {
      for ($i = 1; $i <= $XL_MAX_COLS + 1; $i++) {
        $minimum  = $uom2_min = $uom2_max = "";
        $uom1_min = $this->input->post('uom1_' . $y . '_min');
        $uom1_max = $this->input->post('uom1_' . $y . '_max');
        if ($i == 1) {
          $minimum = $this->input->post('minimum_1');
        } else {
          $uom2_min = $this->input->post('uom2_min_c' . $i);
          $uom2_max = $this->input->post('uom2_max_c' . $i);
        }
        $cost = $this->input->post('result_r' . $y . '_c' . $i);
        if ($uom1_min != "" && $uom1_max != "" && is_numeric($uom2_min) && is_numeric($uom2_max) && is_numeric($cost)) {
          $min_max_prices[] = [
            "uom1_min" => $uom1_min,
            'uom1_max' => $uom1_max,
            'uom2_min' => $uom2_min,
            'uom2_max' => $uom2_max,
            'cost'     => $cost
          ];
        }
        if (is_numeric($minimum) && ($i == 1) && $uom1_min != "" && $uom1_max != "" && is_numeric($cost)) {
          $min_max_prices[] = [
            "geo_from"        => $uom1_min,
            'geo_to'          => $uom1_max,
            "billing_minimum" => $minimum,
            'cost'            => $cost
          ];
        }
      }
    }

    echo (sizeof($min_max_prices) > 0) ? 2 : 1;
  }

  public function checkgeotireid()
  {
    $post     = $this->input->post();
    $tier_id  = $post['tier_id']??0;
    $where    = ['geo_tier_id' => $tier_id];
    $get_data = $this->common->gettblrowdata($where, 'geo_tier_id', 'tb_geo_tier', 0, 0);
    echo empty($get_data) ? 2 : 1;
  }

  public function exchangeidgen()
  {
    $year = date('y');
    $week = date('W');
    $this->load->model("Knratemodel");
    $res = $this->Knratemodel->getlastid([], 'geo_tier_id', 'tb_geo_tier', 'id');
    if (! empty($res)) {
      $get_id   = $res['geo_tier_id'];
      $get_id_c = strlen($get_id);
      if ($get_id_c > 7) {
        $previous_weeknumber = substr($get_id, 4, 2);
        $get_id1             = substr($get_id, 6);
        $get_id2             = ltrim($get_id1, 0);
        if ($previous_weeknumber < $week) {
          $id1 = '0001';
        } else {
          $i_id = $get_id2;
          $i_id++;
          $id1 = self::getId($i_id);
        }
      } else {
        $id1 = '0001';
      }

      $gen_id = "GT" . $year . $week . $id1;
      $chk    = $this->common->gettblrowdata(['geo_tier_id' => $gen_id], 'geo_tier_id', 'tb_geo_tier', 0, 0);
      if (! empty($chk)) {
        $iid = $id1;
        $iid++;
        $ii_d   = self::getId($iid);
        $gen_id = "GT" . $year . $week . $ii_d;
      }
    } else {
      $i_id   = 1;
      $id1    = '000' . $i_id;
      $gen_id = "GT" . $year . $week . $id1;
    }

    return $gen_id;
  }

  public function tierinsertdata()
  {
    $XL_MAX_COLS = $this->session->userdata('XL_MAX_COLS');
    ini_set('memory_limit', '3072M');
    $user_id       = $this->session->userdata('user_id');
    $geo_tier_id   = $this->exchangeidgen();
    $tier_name     = $this->input->post('tier_name');
    $uom1          = $this->input->post('uom1');
    $uom1_m        = $this->input->post('uom1_m');
    $company_code  = $this->input->post('company_code');
    $curr          = $this->input->post('curr');
    $branch_code   = $this->input->post('branch_code');
    $mr_cost       = $this->input->post('mr_cost');
    $vehicle_type  = $this->input->post('vehicle_type');
    $geo_hierarchy = $this->input->post('geo_hierarchy');
    if ($company_code == '') {
      $company_code = $this->session->userdata('company_code');
    }
    if ($branch_code == '') {
      $branch_code = $this->session->userdata('branch_code');
    }
    $tier = [
      'geo_tier_id'   => $geo_tier_id,
      'geo_tier_name' => $tier_name??"",
      'company_code'  => $company_code??"",
      'branch_code'   => $branch_code??"",
      'uom1'          => $uom1??"",
      'unit_measure1' => $uom1_m??"",
      'currency'      => $curr??"",
      'vehicle_type'  => $vehicle_type??0,
      'geo_hierarchy' => isset($geo_hierarchy) ? strtoupper($geo_hierarchy) : 0,
      'marginal_cost' => isset($mr_cost) ? ($mr_cost == 'on') ? '1' : '0' : '0',
      'user_id'       => $user_id??0,
      'status'        => 1
    ];
    if ($this->common->insertTableData('tb_geo_tier', $tier)) {
      $rate_tier_last_inserted_id = $this->db->insert_id();
      $min_max_prices             = [];
      $totalrecords               = $this->input->post('totalrecords');
      // row
      for ($y = 0; $y <= $totalrecords; $y++) {
        // cell
        for ($i = 0; $i <= $XL_MAX_COLS + 2; $i++) {
          $uom2_min = $uom2_max = $minimum = "";
          $uom1_min = $this->input->post('uom1_' . $y . '_min');
          $uom1_max = $this->input->post('uom1_' . $y . '_max');
          $uom1_min = trim($uom1_min);
          $uom1_max = trim($uom1_max);
          if ($i == 0) {
            $minimum = $this->input->post('minimum_1');
          } else {
            $uom2_min = $this->input->post('uom2_min_c' . $i);
            $uom2_max = $this->input->post('uom2_max_c' . $i);
          }
          if (! is_numeric($uom2_min)) {
            $uom2_min = floatval(str_replace(',', '', $uom2_min));
          }
          if (! is_numeric($uom2_max)) {
            $uom2_max = floatval(str_replace(',', '', $uom2_max));
          }
          $co   = $this->input->post('result_r' . $y . '_c' . $i);
          $cost = floatval(str_replace(',', '', $co));
          
          $minimum = (is_numeric($minimum) && $minimum > 0) ? $minimum : 0.001;
          if (is_numeric($minimum) && ($i == 0) && ! is_null($uom1_min) && ! is_null($uom1_max) && $uom1_min != "" && $uom1_max != "") {
            $main_ind         = [
              "geo_from"     => $uom1_min,
              'geo_to'       => $uom1_max,
              'uom1_min'     => 0,
              'uom1_max'     => 0,
              "uom1_minimum" => $minimum,
              'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0.001,
              'geo_tier_id'  => $rate_tier_last_inserted_id,
              'user_id'      => $user_id,
              'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
            ];
            $min_max_prices[] = $main_ind;
          } elseif (($uom2_max > $uom2_min) && is_numeric($uom2_min) && is_numeric($uom2_max) && $uom1_min != "" && $uom1_max != "") {
            $min_max_prices[] = [
              "geo_from"     => $uom1_min,
              'geo_to'       => $uom1_max,
              'uom1_min'     => $uom2_min,
              'uom1_max'     => $uom2_max,
              "uom1_minimum" => 0,
              'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0,
              'geo_tier_id'  => $rate_tier_last_inserted_id,
              'user_id'      => $user_id,
              'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
            ];
          }
        }
      }

      if (sizeof($min_max_prices) > 0) {
        $this->db->insert_batch('tb_geo_tier_sheet', $min_max_prices);
      }
    }

    echo json_encode(["status" => 1, "message" => "Records added successfully"]);
  }

  private static function getId($i_id): string
  {
    switch (strlen($i_id)) {
      case '1':
        $id1 = "000" . $i_id;
        break;
      case '2':
        $id1 = "00" . $i_id;
        break;
      case '3':
        $id1 = "0" . $i_id;
        break;
      case '4':
      default:
        $id1 = $i_id;
        break;
    }

    return $id1;
  }
}

