<?php

use App\Generators\RandomString;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Excelimportachievaorders extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->userId = $this->session->userdata('user_id');
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $this->load->model(['common', 'bpartners']);
        $this->load->library('altovaordercreation');
    }

    public function index()
    {
        echo "Achieva Orders Upload";
    }

    public function uploadexcel()
    {
        ini_set("max_input_time", 2000);
        ini_set("max_execution_time", 2000);
        ini_set("max_input_vars", 20000);
        ini_set("upload_max_size", "2048M");
        ini_set("post_max_size", 0);
        ini_set("memory_limit", "2048M");
        $data = $errorLine = $message = $finalData = $allPickupCodes = $allDeliveryCodes = $allShipperConsigneeCodes = $value = $data["finalData"] = $checkValues = [];
        if (isset($_FILES['import_file'])) {
            $extension = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            if ($extension === "xls" || $extension === "xlsx") {
                $path = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cellCollection = $objPHPExcel->getActiveSheet()->getCellCollection();
                foreach ($cellCollection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $dataValue = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    if ($row == 1) {
                        $data["header"][$row][$column] = $dataValue;
                    } elseif ($row > 1) {
                        $data['finalData'][$row][$column] = $dataValue;
                    }
                }
                $data['orderDetails'] = [];
                $row = 2;
                $excelData = [];
                $checkDeliveryNote = "";
                foreach ($data['finalData'] as $value[$row]) {
                    $deliveryNote = $value[$row]['K'] ?? "";
                    if ($checkDeliveryNote != $deliveryNote) {
                        if ($deliveryNote != "") {
                            $checkDeliveryNote = $deliveryNote;
                            $value[$row]['row'] = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        } else {
                            $value[$row]['row'] = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        }
                    } else {
                        $value[$row]['row'] = $row;
                        $excelData[$checkDeliveryNote][] = $value[$row];
                        $row++;
                    }
                }
                if (!empty($excelData)) {
                    foreach ($excelData as $eachArray) {
                        $allPickupCodes[] = $eachArray['0']['D'] ?? "";
                        $allDeliveryCodes[] = $eachArray['0']['E'] ?? "";
                        $allShipperConsigneeCodes[] = $eachArray['0']['C'] ?? "";
                        $allShipperConsigneeCodes[] = $eachArray['0']['F'] ?? "";
                        $finalData[] = $eachArray;
                    }
                }
                $masterData = $this->getAllMasterDataDetails($allPickupCodes ?? [], $allDeliveryCodes ?? [], $allShipperConsigneeCodes ?? []);
                if (!empty($finalData)) {
                    for ($i = 0, $iMax = count($finalData); $i < $iMax; $i++) {
                        $data['reference'] = $cargoDetails = [];
                        $rowNumber = $finalData[$i]['0']['row'] ?? "";
                        $mainRowNumber = $rowNumber;
                        $service = $finalData[$i]['0']['A'] ?? "";
                        $checkValues[] = ['value' => $service, 'message' => 'Service empty on line: ' . $rowNumber, 'errorLine' => 'service' . $rowNumber];
                        $customerCode = $finalData[$i]['0']['B'] ?? "";
                        $checkValues[] = ['value' => $customerCode, 'message' => 'Customer Code empty on line: ' . $rowNumber, 'errorLine' => 'customerId' . $rowNumber];
                        $shipperCode = $finalData[$i]['0']['C'] ?? "";
                        $checkValues[] = ['value' => $shipperCode, 'message' => 'Shipper Code empty on line: ' . $rowNumber, 'errorLine' => 'shipperCode' . $rowNumber];
                        $pickupCode = $finalData[$i]['0']['D'] ?? "";
                        $checkValues[] = ['value' => $pickupCode, 'message' => 'Pickup Code empty on line: ' . $rowNumber, 'errorLine' => 'pickupId' . $rowNumber];
                        $deliveryCode = $finalData[$i]['0']['E'] ?? "";
                        $checkValues[] = ['value' => $deliveryCode, 'message' => 'Delivery Code empty on line: ' . $rowNumber, 'errorLine' => 'dropId' . $rowNumber];
                        $consigneeCode = $finalData[$i]['0']['F'] ?? "";
                        $checkValues[] = ['value' => $consigneeCode, 'message' => 'Consignee Code empty on line: ' . $rowNumber, 'errorLine' => 'consigneeCode' . $rowNumber];
                        $consigneeName = $finalData[$i]['0']['G'] ?? "";
                        $checkValues[] = ['value' => $consigneeName, 'message' => 'Consignee Name empty on line: ' . $rowNumber, 'errorLine' => 'consigneeName' . $rowNumber];
                        $date = $finalData[$i]['0']['H'] ?? "";
                        $finalDate = date('Y-m-d');
                        if ($date != "") {
                            $unixDate = ($date - 25569) * 86400;
                            $excelDate = 25569 + ($unixDate / 86400);
                            $unixDate = ($excelDate - 25569) * 86400;
                            $finalDate =  gmdate("Y-m-d", $unixDate);
                        }
                        $dateCycle = $finalData[$i]['0']['I'] ?? "";
                        $deliveryNote = $finalData[$i]['0']['K'] ?? "";
                        $checkValues[] = ['value' => $deliveryNote, 'message' => 'Delivery Note empty on line: ' . $rowNumber, 'errorLine' => 'deliveryNote' . $rowNumber];
                        $quantity = $finalData[$i]['0']['L'] ?? "";
                        $checkValues[] = ['value' => $quantity, 'message' => 'Quantity empty on line: ' . $rowNumber, 'errorLine' => 'quantity' . $rowNumber];
                        $package = $finalData[$i]['0']['M'] ?? "";
                        $checkValues[] = ['value' => $package, 'message' => 'Package empty on line: ' . $rowNumber, 'errorLine' => 'cargoType' . $rowNumber];
                        $tripNumber = $finalData[$i]['0']['N'] ?? "";
                        $checkValues[] = ['value' => $tripNumber, 'message' => 'Trip No empty on line: ' . $rowNumber, 'errorLine' => 'tripNumber' . $rowNumber];
                        $route = $finalData[$i]['0']['O'] ?? "";
                        $checkValues[] = ['value' => $route, 'message' => 'Route empty on line: ' . $rowNumber, 'errorLine' => 'route' . $rowNumber];
                        $driver = $finalData[$i]['0']['P'] ?? "";
                        $checkValues[] = ['value' => $driver, 'message' => 'Driver empty on line: ' . $rowNumber, 'errorLine' => 'driver' . $rowNumber];
                        $vehicleNumber = $finalData[$i]['0']['Q'] ?? "";
                        $checkValues[] = ['value' => $vehicleNumber, 'message' => 'Vehicle Number empty on line: ' . $rowNumber, 'errorLine' => 'vehicleNumber' . $rowNumber];
                        $carrier = $finalData[$i]['0']['R'] ?? "";
                        $checkValues[] = ['value' => $carrier, 'message' => 'Carrier empty on line: ' . $rowNumber, 'errorLine' => 'carrier' . $rowNumber];
                        foreach ($checkValues as $res) {
                            if ($res['value'] == "") {
                                $message[] = $res['message'];
                                $errorLine[] = $res['errorLine'];
                            }
                        }
                        $pickupDetails = $masterData['pickupDetails'];
                        $pickupId = $pickupDetails[$pickupCode]['code'] ?? '';
                        $pickupRowId = $pickupDetails[$pickupCode]['id'] ?? 0;
                        $pickupName = $pickupDetails[$pickupCode]['name'] ?? '';
                        $pickupCity = $pickupDetails[$pickupCode]['city'] ?? '';
                        $pickupStreet = $pickupDetails[$pickupCode]['street'] ?? '';
                        $pickupState = $pickupDetails[$pickupCode]['state'] ?? '';
                        $pickupCountry = $pickupDetails[$pickupCode]['country'] ?? '';
                        $pickupPincode = $pickupDetails[$pickupCode]['pincode'] ?? '';
                        $pickupPhone = $pickupDetails[$pickupCode]['mobile'] ?? '';
                        $pickupFax = $pickupDetails[$pickupCode]['fax'] ?? '';
                        $pickupEmail = $pickupDetails[$pickupCode]['email'] ?? '';
                        $pickupLatitude = $pickupDetails[$pickupCode]['latitude'] ?? '';
                        $pickupLongitude = $pickupDetails[$pickupCode]['longitude'] ?? '';

                        $deliveryDetails = $masterData['deliveryDetails'];
                        $dropId = $deliveryDetails[$deliveryCode]['code'] ?? '';
                        $dropRowId = $deliveryDetails[$deliveryCode]['id'] ?? '';
                        $dropName = $deliveryDetails[$deliveryCode]['name'] ?? '';
                        $dropStreet = $deliveryDetails[$deliveryCode]['street'] ?? '';
                        $dropCity = $deliveryDetails[$deliveryCode]['city'] ?? '';
                        $dropState = $deliveryDetails[$deliveryCode]['state'] ?? '';
                        $dropCountry = $deliveryDetails[$deliveryCode]['country'] ?? '';
                        $dropPincode = $deliveryDetails[$deliveryCode]['pincode'] ?? '';
                        $dropPhone = $deliveryDetails[$deliveryCode]['mobile'] ?? '';
                        $dropFax = $deliveryDetails[$deliveryCode]['fax'] ?? '';
                        $dropEmail = $deliveryDetails[$deliveryCode]['email'] ?? '';
                        $dropLatitude = $deliveryDetails[$deliveryCode]['latitude'] ?? '';
                        $dropLongitude = $deliveryDetails[$deliveryCode]['longitude'] ?? '';
                        $shipperRowId = 0;
                        $shipperConsigneeDetails = $masterData['shipperConsigneeDetails'];
                        $shipperConsigneeIds = $masterData['shipperConsigneeIds'];
                        if ($shipperCode != "") {
                            if ($shipperCode != $pickupId) {
                                if (!in_array($shipperCode, $shipperConsigneeDetails, true)) {
                                    $shipperCode = $pickupId;
                                } else {
                                    $shipperRowId = $shipperConsigneeIds[$shipperCode] ?? 0;
                                }
                            }
                        } else {
                            $shipperCode = $pickupId;
                        }
                        $shipperRowId = $shipperRowId > 0 ? $shipperRowId : $pickupRowId;
                        $consigneeRowId = 0;
                        if ($consigneeCode != "") {
                            if ($consigneeCode != $dropId) {
                                if (!in_array($consigneeCode, $shipperConsigneeDetails, true)) {
                                    $consigneeCode = $dropId;
                                } else {
                                    $consigneeRowId = $shipperConsigneeIds[$consigneeCode] ?? 0;
                                }
                            }
                        } else {
                            $consigneeCode = $dropId;
                        }
                        if ($consigneeRowId == 0) {
                            $consigneeRowId = $dropRowId;
                        }
                        $stackable = 'off';
                        $cargoDetails[] = ['cargoType' => $package, 'goodsDescription' => '', 'length' => '1', 'width' => '1', 'height' => '1', 'weight' => '1', 'quantity' => $quantity, 'volume' => '1', 'stackable' => $stackable, 'CargoRowNumber' => $rowNumber];
                        if (strtoupper($dateCycle) == "AM") {
                            $earlyPickup = $finalDate . " 8:00:00";
                            $latePickup = $finalDate . " 10:00:00";
                            $earlyDrop = $finalDate . " 10:01:00";
                            $lateDrop = $finalDate . " 13:00:00";
                        } else {
                            $earlyPickup = $finalDate . " 13:00:00";
                            $latePickup = $finalDate . " 15:00:00";
                            $earlyDrop = $finalDate . " 15:01:00";
                            $lateDrop = $finalDate . " 19:00:00";
                        }
                        $data['orderDetails'][] = [
                            'service' => $service,
                            'customerId' => $customerCode,
                            'shipperCode' => $shipperCode,
                            'consigneeCode' => $consigneeCode,
                            'dateCycle' => $dateCycle,
                            'deliveryNote' => $deliveryNote,
                            'quantity' => $quantity,
                            'package' => $package,
                            'pickupId' => $pickupId,
                            'pickupName' => $pickupName,
                            'pickupStreet' => $pickupStreet,
                            'pickupCity' => $pickupCity,
                            'pickupState' => $pickupState,
                            'pickupCountry' => $pickupCountry,
                            'pickupPincode' => $pickupPincode,
                            'earlyPickup' => $earlyPickup,
                            'latePickup' => $latePickup,
                            'pickupPhone' => $pickupPhone,
                            'pickupFax' => $pickupFax,
                            'pickupEmail' => $pickupEmail,
                            'pickupRowId' => $pickupRowId,
                            'dropId' => $dropId,
                            'dropName' => $dropName,
                            'dropStreet' => $dropStreet,
                            'dropCity' => $dropCity,
                            'dropState' => $dropState,
                            'dropCountry' => $dropCountry,
                            'dropPincode' => $dropPincode,
                            'earlyDrop' => $earlyDrop,
                            'lateDrop' => $lateDrop,
                            'dropPhone' => $dropPhone,
                            'dropFax' => $dropFax,
                            'dropEmail' => $dropEmail,
                            'dropRowId' => $dropRowId,
                            'mainRowNumber' => $mainRowNumber,
                            'companyCode' => $this->companyCode,
                            'branchCode' => $this->branchCode,
                            'involvedParties' => [],
                            'vehicleNumber' => $vehicleNumber,
                            'carrier' => $carrier,
                            'driver' => $driver,
                            'route' => $route,
                            'tripNumber' => $tripNumber,
                            'pickupLatitude' => $pickupLatitude,
                            'pickupLongitude' => $pickupLongitude,
                            'dropLatitude' => $dropLatitude,
                            'dropLongitude' => $dropLongitude,
                            'shipperRowId' => $shipperRowId,
                            'consigneeRowId' => $consigneeRowId,
                            'cargoDetails' => $cargoDetails
                        ];
                    }
                }
            }
        }
        $getAchievaCustomer = $this->common->gettblrowdata(['name' => 'ACHIEVA TECHNOLOGY SDN BHD', 'status' => '1', 'company_code' => $this->companyCode], "id,code", "tb_customers", 0, 0);
        $data['achievaCustomer'] = $getAchievaCustomer['code'];
        $data['customerRowId'] = $getAchievaCustomer['id'];
        $data['errorLine'] = $errorLine;
        $data["message"] = $message;
        $data["companyCode"] = $this->companyCode;
        $data["userId"] = $this->userId;
        $data["branchCode"] = $this->branchCode;
        $data["pageTitle"] = "Import Achieva Orders";
        $this->settemplate->dashboard("smtcorders/achievaordersimport", $data);
    }

    private function getAllMasterDataDetails(array $allPickupCodes, array $allDeliveryCodes, array $allShipperConsigneeCodes): array
    {
        if (!empty($allShipperConsigneeCodes)) {
            $getAllShipperConsigneeDetails = $this->common->gettbldata("code IN (" . implode(',', $allShipperConsigneeCodes) . ") AND company_code = '" . $this->companyCode . "' AND status = '1'", "id,code", "tbl_party_master", 0, 0);
            foreach ($getAllShipperConsigneeDetails as $eachLine) {
                $shipperConsigneeDetails[] = $eachLine['code'];
                $shipperConsigneeIds[$eachLine['code']] = $eachLine['id'];
            }
        }
        if (!empty($allPickupCodes)) {
            $getAllPickupCodes = $this->common->gettbldata("code IN (" . implode(',', $allPickupCodes) . ") AND company_code = '" . $this->companyCode . "' AND status = '1'", "id,name,email,mobile,code,location_id,country,state,street,pincode,fax,party_type_id,latitude,longitude", "tbl_party_master", 0, 0);
            foreach ($getAllPickupCodes as $eachLine) {
                $pickupDetails[$eachLine['code']] = [
                    'id' => $eachLine['id'],
                    'name' => $eachLine['name'],
                    'email' => $eachLine['email'],
                    'mobile' => $eachLine['mobile'],
                    'code' => $eachLine['code'],
                    'city' => $eachLine['location_id'],
                    'country' => $eachLine['country'],
                    'state' => $eachLine['state'],
                    'street' => $eachLine['street'],
                    'pincode' => $eachLine['pincode'],
                    'fax' => $eachLine['fax'],
                    'party_type_id' => $eachLine['party_type_id'],
                    'latitude' => $eachLine['latitude'],
                    'longitude' => $eachLine['longitude']
                ];
            }
        }
        if (!empty($allDeliveryCodes)) {
            $getAllDeliveryCodes = $this->common->gettbldata("code IN (" . implode(',', $allDeliveryCodes) . ") AND company_code = '" . $this->companyCode . "' AND status = '1'", "id,name,email,mobile,code,location_id,country,state,street,pincode,fax,party_type_id,latitude,longitude", "tbl_party_master", 0, 0);
            foreach ($getAllDeliveryCodes as $eachLine) {
                $deliveryDetails[$eachLine['code']] = [
                    'id' => $eachLine['id'],
                    'name' => $eachLine['name'],
                    'email' => $eachLine['email'],
                    'mobile' => $eachLine['mobile'],
                    'code' => $eachLine['code'],
                    'city' => $eachLine['location_id'],
                    'country' => $eachLine['country'],
                    'state' => $eachLine['state'],
                    'street' => $eachLine['street'],
                    'pincode' => $eachLine['pincode'],
                    'fax' => $eachLine['fax'],
                    'party_type_id' => $eachLine['party_type_id'],
                    'latitude' => $eachLine['latitude'],
                    'longitude' => $eachLine['longitude']
                ];
            }
        }
        return ['deliveryDetails' => $deliveryDetails ?? [], 'pickupDetails' => $pickupDetails ?? [], 'shipperConsigneeIds' => $shipperConsigneeIds ?? [], 'shipperConsigneeDetails' => $shipperConsigneeDetails ?? []];
    }

    public function addOrdersData()
    {
        $orders = $excelFailOrders = $ordersList = $dummyArray = [];
        $j = 0;
        $post = $this->input->post(null, true);
        if (!empty($post['orders'])) {
            for ($i = 0, $iMax = count($post['orders']); $i < $iMax; $i++) {
                $firstCustomer = $post['orders'][$i]['customerId'] ?? "";
                $firstPickup = $post['orders'][$i]['pickupId'] ?? "";
                $firstDrop = $post['orders'][$i]['dropId'] ?? "";
                $firstTripNumber = $post['orders'][$i]['tripNumber'] ?? "";
                $firstEarlyPickup = $post['orders'][$i]['earlyPickup'] ?? "";
                if (!in_array($post['orders'][$i]['deliveryNote'], $dummyArray, true)) {
                    for ($k = 0, $kMax = count($post['orders']); $k < $kMax; $k++) {
                        $currentCustomer = $post['orders'][$k]['customerId'] ?? "";
                        $currentPickup = $post['orders'][$k]['pickupId'] ?? "";
                        $currentDrop = $post['orders'][$k]['dropId'] ?? "";
                        $currentTripNumber = $post['orders'][$k]['tripNumber'] ?? "";
                        $currentEarlyPickup = $post['orders'][$k]['earlyPickup'] ?? "";
                        if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop && $firstTripNumber == $currentTripNumber && strtotime($firstEarlyPickup) == strtotime($currentEarlyPickup)) {
                            $ordersList[] = $post['orders'][$k] ?? "";
                            $dummyArray[] = $post['orders'][$k]['deliveryNote'] ?? "";
                        }
                    }
                }
            }
        }
        $pickupTypeId = $deliveryTypeId = $shipperTypeId = $consigneeTypeId = 0;
        $getAllPartyTypesIds = $this->common->gettbldata("name IN ('Shipper', 'Consignee', 'Pickup', 'Delivery') AND company_code = '" . $this->companyCode . "' AND status = '1'", "id,name", "tbl_party_types", 0, 0);
        foreach ($getAllPartyTypesIds as $eachLine) {
            $partyTypeName = strtoupper($eachLine['name']);
            if ($partyTypeName == "PICKUP") {
                $pickupTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "DELIVERY") {
                $deliveryTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "SHIPPER") {
                $shipperTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "CONSIGNEE") {
                $consigneeTypeId = $eachLine['id'];
            }
        }
        if (!empty($ordersList)) {
            for ($i = 0, $iMax = count($ordersList); $i < $iMax; $i++) {
                $ordersList[$i]['pickupTypeId'] = $pickupTypeId;
                $ordersList[$i]['deliveryTypeId'] = $deliveryTypeId;
                $ordersList[$i]['shipperTypeId'] = $shipperTypeId;
                $ordersList[$i]['consigneeTypeId'] = $consigneeTypeId;
                $data = $ordersList[$i];
                $firstCustomer = $ordersList[$j]['customerId'] ?? "";
                $firstPickup = $ordersList[$j]['pickupId'] ?? "";
                $firstDrop = $ordersList[$j]['dropId'] ?? "";
                $firstCustomerReference = $ordersList[$j]['deliveryNote'] ?? "";
                $firstTripNumber = $ordersList[$j]['tripNumber'] ?? "";
                $firstEarlyPickup = $ordersList[$j]['earlyPickup'] ?? "";
                if ($i == 0) {
                    $ordersData = $this->insertAcheiveOrders($data);
                    if (!empty($ordersData)) {
                        $orders[] = $ordersData['orders'] ?? [];
                        $excelFailOrders = $ordersData['excelFailOrders'] ?? [];
                    }
                } else {
                    $currentCustomer = $ordersList[$i]['customerId'] ?? "";
                    $currentPickup = $ordersList[$i]['pickupId'] ?? "";
                    $currentDrop = $ordersList[$i]['dropId'] ?? "";
                    $currentCustomerReference = $ordersList[$i]['deliveryNote'] ?? "";
                    $currentTripNumber = $ordersList[$i]['tripNumber'] ?? "";
                    $currentEarlyPickup = $ordersList[$i]['earlyPickup'] ?? "";
                    if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop && strtotime($currentEarlyPickup) == strtotime($firstEarlyPickup)) {
                        if ($firstTripNumber == $currentTripNumber) {
                            $currentCargo = $ordersList[$i]['cargoDetails'] ?? [];
                            $this->updateReferenceForOrorder(['firstReference' => $firstCustomerReference, 'currentReference' => $currentCustomerReference, 'cargo' => $currentCargo]);
                        } else {
                            $j = $i;
                            $ordersData = $this->insertAcheiveOrders($data);
                            if (!empty($ordersData)) {
                                $orders[] = $ordersData['orders'] ?? [];
                                $excelFailOrders = $ordersData['excelFailOrders'] ?? [];
                            }
                        }
                    } else {
                        $j = $i;
                        $ordersData = $this->insertAcheiveOrders($data);
                        if (!empty($ordersData)) {
                            $orders[] = $ordersData['orders'] ?? [];
                            $excelFailOrders = $ordersData['excelFailOrders'] ?? [];
                        }
                    }
                }
            }
        }

        $excelSuccessOrders = $this->createTripForOrders($orders);
        if (!empty($excelFailOrders) && !empty($excelSuccessOrders)) {
            $excelOrders = array_merge($excelFailOrders, $excelSuccessOrders);
        } elseif (!empty($excelSuccessOrders)) {
            $excelOrders = $excelSuccessOrders;
        } elseif (!empty($excelFailOrders)) {
            $excelOrders = $excelFailOrders;
        }
        if (!empty($excelOrders)) {
            @file_put_contents(
                $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/ordertemplate/clexceluploaddata.txt",
                json_encode($excelOrders)
            );
        }
        redirect('smtcorders/orderslist/02');
    }

    public function insertAcheiveOrders(array $data): array
    {
        $companyCode = $data['companyCode'] ?? "";
        $branchCode = $data['branchCode'] ?? "";
        $shipmentNumber = $data['deliveryNote'] ?? "";
        $deliveryNote = $shipmentNumber;
        if (($this->bpartners->checkDeliveryNoteForAchievaOrders(['deliveryNote' => $deliveryNote, 'userId' => $this->userId])) > 0) {
            return [];
        }
        $noBookingIds = $excelFailOrders = [];
        $service = $data['service'] ?? "";
        $serviceId = $product = $incoterm = "";
        if ($service != "") {
            $serviceId = $this->bpartners->getServiceForMDTExcel($service, $companyCode, $branchCode);
        }
        $earlyPickup = $data['earlyPickup'] ?? "";
        $latePickup = $data['latePickup'] ?? "";
        $earlyDelivery = $data['earlyDrop'] ?? "";
        $lateDelivery = $data['lateDrop'] ?? "";
        $customerRowId = $data['customerRowId'] ?? "";
        $tripNumber = $data['tripNumber'] ?? "";
        $route = $data['route'] ?? "";
        $driver = $data['driver'] ?? "";
        $vehcileNumber = $data['vehicleNumber'] ?? "";
        $carrier = $data['carrier'] ?? "";
        $ePickup = $currentDate = date('Y-m-d H:i:s');
        if ($earlyPickup != "") {
            $ePickup = date('Y-m-d H:i:s', strtotime($earlyPickup));
        }
        if ($latePickup != "") {
            $lPickup = date('Y-m-d H:i:s', strtotime($latePickup));
        } else {
            $lPickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($ePickup)));
        }
        if ($earlyDelivery != "") {
            $eDelivery = date('Y-m-d H:i:s', strtotime($earlyDelivery));
        } else {
            $eDelivery = date('Y-m-d H:i:s', strtotime('+3 hour', strtotime($currentDate)));
        }
        if ($lateDelivery != "") {
            $lDelivery = date('Y-m-d H:i:s', strtotime($lateDelivery));
        } else {
            $lDelivery = date('Y-m-d H:i:s', strtotime('+4 hour', strtotime($currentDate)));
        }
        $logDate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logDate, $this->currentTimeZone);
        $currentDate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $ePickup, $this->currentTimeZone);
        $ePickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $lPickup, $this->currentTimeZone);
        $lPickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $eDelivery, $this->currentTimeZone);
        $eDelivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $lDelivery, $this->currentTimeZone);
        $lDelivery = $getldelivery['datetime'];


        $customerCode = $data['customerId'] ?? "";
        $pickupId = $data['pickupId'] ?? "";
        $pickupRowId = $data['pickupRowId'] ?? 0;
        $pickupName = $data['pickupName'] ?? "";
        $pickupStreet = $data['pickupStreet'] ?? "";
        $pickupCity = $data['pickupCity'] ?? "";
        $pickupState = $data['pickupState'] ?? "";
        $pickupCountry = $data['pickupCountry'] ?? "";
        $pickupPincode = $data['pickupPincode'] ?? "";
        $pickupTypeId = $data['pickupTypeId'] ?? 0;
        $pickupLatitude = $data['pickupLatitude'] ?? "";
        $pickupLongitude = $data['pickupLongitude'] ?? "";
        $address = $pickupStreet . ',' . $pickupCity . ',' . $pickupCountry;

        $dropId = $data['dropId'] ?? "";
        $dropRowId = $data['dropRowId'] ?? 0;
        $dropName = $data['dropName'] ?? "";
        $dropStreet = $data['dropStreet'] ?? "";
        $dropCity = $data['dropCity'] ?? "";
        $dropState = $data['dropState'] ?? "";
        $dropCountry = $data['dropCountry'] ?? "";
        $dropPincode = $data['dropPincode'] ?? "";
        $dropLatitude = $data['dropLatitude'] ?? "";
        $dropLongitude = $data['dropLongitude'] ?? "";
        $daddress = $dropStreet . ',' . $dropCity . ',' . $dropCountry;
        $shipperRowId = $data['shipperRowId'] ?? 0;
        $consigneeRowId = $data['consigneeRowId'] ?? 0;
        $deliveryTypeId = $data['deliveryTypeId'] ?? 0;
        $shipperTypeId = $data['shipperTypeId'] ?? 0;
        $consigneeTypeId = $data['consigneeTypeId'] ?? 0;

        $endDate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $transportMode = "LTL";
        $getTransportMode = $this->common->gettblrowdata(['code' => $transportMode, 'status' => '1'], "id,name", "tb_transportmode", 0, 0);
        $transportModeId = $getTransportMode['id'] ?? 1;
        $transportModeName = $getTransportMode['name'] ?? "Less Than TruckLoad";
        $shipid = "SVK" . time();
        if ($shipmentNumber == "") {
            $shipmentNumber = $shipid;
        }
        $shipmentArray = [
            'unitspec' => 1,
            'shipid' => $shipid,
            'txnid' => $shipmentNumber,
            'trucktype' => $transportModeName,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickupId,
            'carrier' => '0',
            'insertuserdate' => $currentDate,
            'enddate' => $endDate,
            'insdate' => $currentDate,
            'upddate' => $currentDate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $currentDate,
            'transport_mode' => $transportMode,
            'domainname' => $branchCode,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $transportModeId
        ];
        $checkShipmentId = $this->common->gettblrowdata(['shipid' => $shipid, 'status' => '1'], "id", "tb_shipments", 0, 0);
        if (!empty($checkShipmentId)) {
            $shipmentRowId = $checkShipmentId['id'];
            $this->common->updatetbledata("tb_shipments", $shipmentArray, ['id' => $shipmentRowId]);
        } else {
            $shipmentArray['createdon'] = $currentDate;
            $shipmentRowId = $this->common->insertTableData("tb_shipments", $shipmentArray);
        }
        if ($pickupLatitude != "" && $pickupLongitude != "" && $dropLatitude != "" && $dropLongitude != "") {
            $lat1 = $pickupLatitude;
            $lng1 = $pickupLongitude;
            $lat2 = $dropLatitude;
            $lng2 = $dropLongitude;
        } else {
            $add1 = implode(",", [$pickupStreet, $pickupCity, $pickupCountry, $pickupPincode]);
            $add2 = implode(",", [$dropStreet, $dropCity, $dropCountry, $dropPincode]);
            $loc = getlatlngsbyplace($add1);
            $lat1 = $loc[0] ?? null;
            $lng1 = $loc[1] ?? null;
            $loc = getlatlngsbyplace($add2);
            $lat2 = $loc[0] ?? null;
            $lng2 = $loc[1] ?? null;
        }
        $goodsValue = "0.00";
        $childId = 0;
        if ($this->session->userdata('childid')) {
            $childId = $this->session->userdata('childid');
        }
        $ins = [
            'shipment_id' => $shipmentRowId,
            'customer_id' => $customerRowId,
            'drop_custid' => $dropId,
            'drop_partyid' => $dropId,
            'product' => $product,
            'goods_value' => $goodsValue,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'pickup_datetime' => $ePickup,
            'delivery_datetime' => $eDelivery,
            'pickup_endtime' => $lPickup,
            'drop_endtime' => $lDelivery,
            'createdon' => $currentDate,
            'user_id' => $this->userId,
            'sub_uid' => $childId,
            'pickup_custid' => $pickupId,
            'pickup_partyid' => $pickupId,
            'pickup_country' => $pickupCountry,
            'pickup_city' => $pickupCity,
            'pickup_pincode' => $pickupPincode,
            'pickup_company' => $pickupName,
            'pickup_address1' => $pickupStreet,
            'pickup_address2' => $pickupState,
            'delivery_country' => $dropCountry,
            'delivery_city' => $dropCity,
            'delivery_pincode' => $dropPincode,
            'delivery_company' => $dropName,
            'delivery_address1' => $dropStreet,
            'delivery_address2' => $dropState,
            'transport_mode' => $transportMode,
            'plat' => $lat1,
            'plng' => $lng1,
            'dlat' => $lat2,
            'dlng' => $lng2,
            'modeoftransport' => $transportModeId,
            'created_source' => '4',
            'shipper_id' => $shipperRowId,
            'consignee_id' => $consigneeRowId
        ];
        $orderId = $this->common->insertTableData("tb_orders", $ins);
        if ($orderId == 0) {
            if (in_array($deliveryNote, $noBookingIds)) {
            } else {
                $noBookingIds[] = $deliveryNote;
                $excelFailOrders[] = ['order_id' => '0', 'customer_id' => $customerCode, 'delivery_note' => '', 'booking_id' => 'DQ-' . $deliveryNote, 'trip_id' => '-', 'status' => 'Fail'];
            }
        } else {
            $getCountry = $this->common->gettblrowdata(['id' => $this->userId], "country_code,company_code", "tb_users", 0, 0);
            $countryCode = $getCountry['country_code'];
            $companyCode = $getCountry['company_code'];
            $generateOrderIdArray = ["user_id" => $this->userId, "order_id" => $orderId, "country_code" => $countryCode, "company_code" => $companyCode];
            $bookingId = generatebookingid($generateOrderIdArray);
            makeorderinvolvedpartiestype($customerRowId, $orderId, "CUSTOMER", $this->userId, $companyCode);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickupCity, 'pickupState' => $pickupState, 'pickupCountry' => $pickupCountry, 'dropCity' => $dropCity, 'dropState' => $dropState, 'dropCountry' => $dropCountry, 'companyCode' => $companyCode, 'branchCode' => $branchCode, 'orderRowId' => $orderId, 'date' => $currentDate]);
            $this->common->updatetbledata("tb_orders", ['order_id' => $bookingId], ['id' => $orderId]);
            $this->common->insertTableData("tb_order_details", ['service' => $serviceId, 'delivery_term' => "", 'incoterm' => $incoterm, 'purchase_order' => '0', 'notify_party' => '0', 'lane_reference' => '0', 'distance' => '0', 'temperature_control' => '0', 'valorance_insurance' => '0', 'high_cargo_value' => '0', 'customs_required' => '0', 'order_id' => $bookingId, 'order_row_id' => $orderId, 'createdon' => $currentDate, 'shipper_id' => $pickupRowId, 'order_type' => '']);
            if ($pickupRowId > 0) {
                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'party_id' => $pickupRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $pickupTypeId]);
                $shipperAddress = ['order_id' => $orderId, 'party_master_id' => $pickupRowId, 'location_id' => $pickupCity, 'street' => $pickupStreet, 'state' => $pickupState, 'address' => $address, 'pincode' => $pickupPincode, 'country' => $pickupCountry, 'user_id' => $this->userId];
                $checkShipperAddress = $this->common->gettblrowdata(['order_id' => $orderId, 'party_master_id' => $pickupRowId, 'status' => '1'], "id", "tbl_orderparty_address", 0, 0);
                if (!empty($checkShipperAddress)) {
                    $shipperAddressId = $checkShipperAddress['id'];
                    $this->common->updatetbledata("tbl_orderparty_address", $shipperAddress, ['id' => $shipperAddressId]);
                } else {
                    $shipperAddress['createdon'] = $currentDate;
                    $this->common->insertTableData("tbl_orderparty_address", $shipperAddress);
                }
            }
            if ($dropRowId != 0) {
                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'party_id' => $dropRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $deliveryTypeId]);
                $dropAddress = ['order_id' => $orderId, 'party_master_id' => $dropRowId, 'location_id' => $dropCity, 'street' => $dropStreet, 'state' => $dropState, 'address' => $daddress, 'pincode' => $dropPincode, 'country' => $dropCountry, 'user_id' => $this->userId];
                $checkDropAddress = $this->common->gettblrowdata(['order_id' => $orderId, 'party_master_id' => $dropRowId, 'status' => '1'], "id", "tbl_orderparty_address", 0, 0);
                if (!empty($checkDropAddress)) {
                    $dropAddressId = $checkDropAddress['id'];
                    $this->common->updatetbledata("tbl_orderparty_address", $dropAddress, ['id' => $dropAddressId]);
                } else {
                    $dropAddress['createdon'] = $currentDate;
                    $this->common->insertTableData("tbl_orderparty_address", $dropAddress);
                }
            }
            if ($shipmentNumber != "") {
                $this->common->insertTableData('tb_order_references', ['order_id' => $orderId, 'reference_id' => 'DQ', 'ref_value' => $shipmentNumber, 'createdon' => $currentDate]);
            }
            if ($shipperTypeId > 0) {
                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'party_id' => $shipperRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $shipperTypeId]);
            }
            if ($consigneeTypeId > 0) {
                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'party_id' => $consigneeRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $consigneeTypeId]);
            }
            $cargo = $data['cargoDetails'] ?? [];
            if (!empty($cargo)) {
                foreach ($cargo as $car) {
                    $cargoType = $car['cargoType'] ?? "";
                    $goodsDescription = $car['goodsDescription'] ?? "";
                    $quantity = $car['quantity'] ?? "";
                    $length = $car['length'] ?? "";
                    $lengthUom = $car['lengthUom'] ?? "m";
                    $width = $car['width'] ?? "";
                    $widthUom = $car['widthUom'] ?? "m";
                    $height = $car['height'] ?? "";
                    $heightUom = $car['heightUom'] ?? "m";
                    $weight = $car['weight'] ?? "";
                    $weightUom = $car['weightUom'] ?? "kg";
                    $volume = $car['volume'] ?? "";
                    $volumeUom = $car['volumeUom'] ?? "cbm";
                    $stackable = $car['stackable'] ?? "";
                    if ($stackable == 'on') {
                        $stackable = 1;
                    } else {
                        $stackable = 0;
                    }
                    $cargoRowId = $this->common->insertTableData(
                        "tb_cargo_details",
                        ['cargo_type' => $cargoType, 'goods_description' => $goodsDescription, 'quantity' => $quantity, 'length' => $length, 'length_unit' => $lengthUom, 'width' => $width, 'width_unit' => $widthUom, 'height' => $height, 'height_unit' => $heightUom, 'weight' => $weight, 'weight_unit' => $weightUom, 'volume' => $volume, 'volume_unit' => $volumeUom, 'stackable' => $stackable, 'createdby' => $this->userId, 'createdon' => $currentDate]
                    );
                    $getHandlingUnit = $this->common->gettblrowdata(['unit_name' => $cargoType, 'status' => '1'], "id", "tbl_shipunit_types", 0, 0);
                    if (!empty($getHandlingUnit)) {
                        $handlingUnit = $getHandlingUnit['id'];
                    } else {
                        $handlingunit_ar = ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $this->userId, 'created_at' => $currentDate, 'status' => '1'];
                        $handlingUnit = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                    }
                    $this->common->insertTableData("tb_order_cargodetails", ['order_id' => $orderId, 'quantity' => $quantity, 'cargo_id' => $cargoRowId, 'status' => '1', 'createdon' => $currentDate, 'cargo_content' => $goodsDescription, 'quantity_type' => $cargoType, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'handling_unit' => $handlingUnit]);
                }
            }
            $cargoForShipment = [];
            $totalVolume = $totalWeight = $totalQuantity = 0;
            $getCargos = $this->common->gettbldata(['order_id' => $orderId, 'status' => '1'], "quantity_type,weight,volume,quantity", "tb_order_cargodetails", 0, 0);
            foreach ($getCargos as $eachLine) {
                $cargoForShipment[] = $eachLine['quantity_type'];
                $totalVolume += $eachLine['volume'];
                $totalWeight += $eachLine['weight'];
                $totalQuantity += $eachLine['quantity'];
            }
            if (!empty($cargoForShipment)) {
                $unitSpec = implode(',', $cargoForShipment);
            }
            $this->common->updatetbledata("tb_shipments", ['unitspec' => $unitSpec ?? "1", 'txncode' => $bookingId], ['id' => $shipmentRowId]);
            $this->common->updatetbledata("tb_orders", ['volume' => $totalVolume, 'weight' => $totalWeight, 'quantity' => $totalQuantity], ['id' => $orderId]);
            $orders = ['orderId' => $orderId, 'bookingId' => $bookingId, 'carrier' => $carrier, 'vehicleNumber' => $vehcileNumber, 'driver' => $driver, 'route' => $route, 'tripNumber' => $tripNumber, 'customerId' => $customerCode, 'earlyPickup' => $ePickup];
            $response = ['orders' => $orders, 'excelFailOrders' => $excelFailOrders];
            try {
                $this->altovaordercreation->sendOrderToAltova($orderId);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
            }
        }
        return $response ?? [];
    }

    public function updateReferenceForOrorder(array $data): void
    {
        $currentDate = date('Y-m-d H:i:s');
        if ($data['firstReference'] != "" && $data['firstReference'] != '0') {
            $getOrder = $this->common->gettblrowdata(['ref_value' => $data['firstReference'], 'status' => '1'], "order_id", "tb_order_references", 0, 0);
            if (!empty($getOrder)) {
                $orderId = $getOrder['order_id'];
                if ($orderId > 0) {
                    $checkCurrentReference = $this->common->gettblrowdata(['ref_value' => $data['currentReference'], 'order_id' => $orderId, 'status' => '1'], "id", "tb_order_references", 0, 0);
                    if (empty($checkCurrentReference)) {
                        $this->common->insertTableData("tb_order_references", ['order_id' => $orderId, 'reference_id' => 'DQ', 'ref_value' => $data['currentReference'], 'status' => '1', 'createdon' => $currentDate]);
                    }
                    $cargo = $data['cargo'];
                    if (!empty($cargo[0])) {
                        $cargoType = $cargo[0]['cargoType'];
                        $length = $cargo[0]['length'] == "" ? 0 : $cargo[0]['length'];
                        $width = $cargo[0]['width'] == "" ? 0 : $cargo[0]['width'];
                        $height = $cargo[0]['height'] == "" ? 0 : $cargo[0]['height'];
                        $weight = $cargo[0]['weight'] == "" ? 0 : $cargo[0]['weight'];
                        $volume = $cargo[0]['volume'] == "" ? 0 : $cargo[0]['volume'];
                        $quantity = $cargo[0]['quantity'] == "" ? 0 : $cargo[0]['quantity'];

                        $stackable = 0;
                        $upperCaseStackable = strtoupper($cargo[0]['stackable']);
                        if (in_array($upperCaseStackable, ['ON', '1'])) {
                            $stackable = 1;
                        }
                        if ($cargoType != "") {
                            $chkhandling_unit = $this->common->gettblrowdata(['unit_name' => $cargoType, 'status' => '1'], "id", "tbl_shipunit_types", 0, 0);
                            if (!empty($chkhandling_unit)) {
                                $handlingUnitId = $chkhandling_unit['id'];
                            } else {
                                $handlingUnitId = $this->common->insertTableData("tbl_shipunit_types", ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $this->userId, 'status' => '1', 'created_at' => $currentDate]);
                            }

                            $cargo_id = $this->common->insertTableData("tb_cargo_details", ['cargo_type' => $cargoType, 'handling_unit' => $cargoType, 'handlingunit_id' => $handlingUnitId, 'length' => $length, 'length_unit' => 'm', 'width' => $width, 'height' => $height, 'height_unit' => 'm', 'weight' => $weight, 'weight_unit' => 'kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'quantity' => $quantity, 'stackable' => $stackable, 'status' => '1', 'createdon' => $currentDate]);
                            $chkcargo = $this->common->gettblrowdata(['quantity_type' => $cargoType, 'status' => '1', 'order_id' => $orderId], "id,quantity", "tb_order_cargodetails", 0, 0);
                            if (!empty($chkcargo)) {
                                $orderCargoRowId = $chkcargo['id'];
                                $orderCargoQuantity = $chkcargo['quantity'];
                                $originalQuantity = $orderCargoQuantity + $quantity;
                                $this->common->updatetbledata("tb_order_cargodetails", ['quantity' => $originalQuantity], ["id" => $orderCargoRowId]);
                            } else {
                                $this->common->insertTableData("tb_order_cargodetails", ['order_id' => $orderId, 'cargo_id' => $cargo_id, 'handling_unit' => $handlingUnitId, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $quantity, 'quantity_type' => $cargoType, 'status' => '1', 'createdon' => $currentDate]);
                            }
                        }
                    }
                }
            }
        }
    }

    public function createTripForOrders(array $orders): array
    {
        $dummyArray = $noBookingIds = $excelSuccessOrders = $orderDetails = [];
        if (!empty($orders)) {
            for ($i = 0, $iMax = count($orders); $i < $iMax; $i++) {
                $vendorForTrip = $orders[$i]['carrier'];
                $vehicleForTrip = $orders[$i]['vehicleNumber'];
                $driverForTrip = $orders[$i]['driver'];
                $routeForTrip = $orders[$i]['route'];
                $tripForTrip = $orders[$i]['tripNumber'];
                $tripForEarlyPickup = $ordersList[$i]['earlyPickup'] ?? "";
                if (!in_array($orders[$i]['orderId'], $dummyArray, true)) {
                    for ($k = 0, $kMax = count($orders); $k < $kMax; $k++) {
                        $vendorCode = $orders[$k]['carrier'];
                        $registerNumber = $orders[$k]['vehicleNumber'];
                        $tripNumber = $orders[$k]['tripNumber'];
                        $driver = $orders[$k]['driver'];
                        $route = $orders[$k]['route'];
                        $earlyPickup = $ordersList[$k]['earlyPickup'] ?? "";
                        if ($tripForTrip == $tripNumber && $routeForTrip == $route && $driverForTrip == $driver && $vehicleForTrip == $registerNumber && $vendorForTrip == $vendorCode && strtotime($earlyPickup) == strtotime($tripForEarlyPickup)) {
                            $orderDetails[] = $orders[$k];
                            $dummyArray[] = $orders[$k]['orderId'];
                        }
                    }
                }
            }
        }
        $j = 0;
        for ($i = 0, $iMax = count($orderDetails); $i < $iMax; $i++) {
            if ($j == '0') {
                $orderForTrip = $orderDetails[0]['orderId'];
                $vendorForTrip = $orderDetails[0]['carrier'];
                $vehicleForTrip = $orderDetails[0]['vehicleNumber'];
                $driverForTrip = $orderDetails[0]['driver'];
                $routeForTrip = $orderDetails[0]['route'];
                $bookingForTrip = $orderDetails[0]['bookingId'];
                $tripForTrip = $orderDetails[0]['tripNumber'];
                $tripForEarlyPickup = $orderDetails[0]['earlyPickup'];
            } else {
                $orderForTrip = $orderDetails[$j]['orderId'];
                $vendorForTrip = $orderDetails[$j]['carrier'];
                $vehicleForTrip = $orderDetails[$j]['vehicleNumber'];
                $driverForTrip = $orderDetails[$j]['driver'];
                $routeForTrip = $orderDetails[$j]['route'];
                $bookingForTrip = $orderDetails[$j]['bookingId'];
                $tripForTrip = $orderDetails[$j]['tripNumber'];
                $tripForEarlyPickup = $orderDetails[$j]['earlyPickup'];
            }

            $orderId = $orderDetails[$i]['orderId'];
            $bookingId = $orderDetails[$i]['bookingId'];
            $vendorCode = $orderDetails[$i]['carrier'];
            $registerNumber = $orderDetails[$i]['vehicleNumber'];
            $tripNumber = $orderDetails[$i]['tripNumber'];
            $driver = $orderDetails[$i]['driver'];
            $route = $orderDetails[$i]['route'];
            $customerCode = $orderDetails[$i]['customerId'];
            $earlyPickup = $orderDetails[$i]['earlyPickup'];
            $countCode = substr($this->companyCode, 0, 2);
            $year = date('y');
            $week = date('W');
            $seq_num = 000001;
            if ($bookingForTrip != "") {
                $seq_num = substr($bookingForTrip, -6);
            }
            $shipmentId = "T" . $countCode . $week . $year . $seq_num;
            $logdate = date('Y-m-d H:i:s');
            $getActualDate = getdatetimebytimezone(DFLT_TZ, $logdate, $this->currentTimeZone);
            $currentDate = $getActualDate['datetime'];
            $vendorDetails = $this->common->gettblrowdata(['code' => $vendorCode, 'status' => '1'], "id,name", "tb_vendors", 0, 0);
            $vendorId = $vendorDetails['id'] ?? 0;
            if ($vendorId == 0) {
                continue;
            }
            $vehicleDetails = $this->common->gettblrowdata(['register_number' => $registerNumber, 'status' => 'Active', 'vendor_id' => $vendorId], "id,truck_type", "tb_trucks_data", 0, 0);
            $vehicleId = $vehicleDetails['id'] ?? 0;
            $vehicleTypeId = $vehicleDetails['truck_type'] ?? 1;
            if ($vehicleId == 0) {
                $checkVehicleWithoutVendor = $this->common->gettblrowdata(['register_number' => $registerNumber, 'status' => 'Active'], "id", "tb_trucks_data", 0, 0);
                if (!empty($checkVehicleWithoutVendor)) {
                    $vehicleId = $checkVehicleWithoutVendor['id'];
                    $this->common->updatetbledata("tb_trucks_data", ["vendor_id" => $vendorId], ['id' => $vehicleId]);
                } else {
                    $vehicleId = $this->common->insertTableData("tb_trucks_data", ['truck_number' => $registerNumber, 'length' => '0', 'breadth' => '0', 'truck_capacity' => '1', 'truck_type' => '1', 'register_number' => $registerNumber, 'route' => $registerNumber, 'user_id' => $this->userId, 'vendor_id' => $vendorId, 'status' => 'Active', 'createdon' => $currentDate]);
                }
            }
            $driverId = 0;
            if ($driver != "") {
                $driverDetails = $this->common->gettblrowdata(['name' => $driver], "id", "tb_truck_drivers", 0, 0);
                if (!empty($driverDetails)) {
                    $driverId = $driverDetails['id'];
                } else {
                    $password = RandomString::generate(10);
                    $hashPassword = password_hash($password, PASSWORD_DEFAULT);
                    $mobile = time();
                    $driverId = $this->common->insertTableData("tb_truck_drivers", ['name' => $driver, 'password' => $hashPassword, 'contact_num' => $mobile, 'createdby' => $this->userId, 'user_id' => $this->userId, 'vendor_id' => $vendorId, 'status' => 'Active', 'company_code' => $this->companyCode, 'branch_code' => $this->branchCode, 'createdon' => $currentDate]);
                }
            }
            $sid = $orderId;
            if ($shipmentId != "" && $vendorId > 0 && $orderId > 0) {
                $order = $this->common->gettblrowdata(["id" => $orderId], "*", "tb_orders", 0, 0);
                if (empty($order)) {
                    continue;
                }
                $checkShiftId = $order['shift_id'];
                $bookingId = $order['order_id'];
                if ($checkShiftId > 0) {
                    continue;
                }
                $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                $pickup = $order['pickup_address1'];
                if ($pickup == "") {
                    $pickup = $order['pickup_city'];
                }
                $delivery = $order['delivery_address1'];
                if ($delivery == "") {
                    $delivery = $order['delivery_city'];
                }
                $address = $dropaddr = "";
                if ($order['pickup_address1'] != "") {
                    $address .= $order['pickup_address1'];
                    $dropaddr .= $order['delivery_address1'];
                }
                if ($order['pickup_company'] != "") {
                    $address .= ", " . $order['pickup_company'];
                    $dropaddr .= ", " . $order['delivery_company'];
                }
                if ($order['pickup_country'] != "") {
                    $address .= ", " . $order['pickup_country'];
                    $dropaddr .= ", " . $order['delivery_country'];
                }
                if ($order['pickup_city'] != "") {
                    $address .= ", " . $order['pickup_city'];
                    $dropaddr .= ", " . $order['delivery_city'];
                }
                if ($order['pickup_pincode'] != "") {
                    $address .= ", " . $order['pickup_pincode'];
                    $dropaddr .= ", " . $order['delivery_pincode'];
                }
                $plat = $order['plat'];
                $plng = $order['plng'];
                $dlat = $order['dlat'];
                $dlng = $order['dlng'];
                if ($i == '0') {
                    $shipment = $this->common->gettblrowdata(["shipmentid" => $shipmentId], "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type", "tb_shifts", 0, 0);
                    if (empty($shipment)) {
                        $customerId = $order['customer_id'];
                        $transportMode = $order['transport_mode'];
                        $weight = $order['weight'];
                        $volume = $order['volume'];
                        $uniqueId = $shipmentId;
                        if ($vehicleTypeId != '' && $vehicleTypeId != 0) {
                            $getVehicleType = $this->common->gettblrowdata(["id" => $vehicleTypeId], "trucktype", "tb_trucktypes", 0, 0);
                            if (!empty($getVehicleType)) {
                                $vehicleType = $getVehicleType['trucktype'];
                            } else {
                                $vehicleType = $order['vehicle_type'];
                            }
                        } else {
                            $vehicleType = $order['vehicle_type'];
                        }
                        $startDate = $order['pickup_datetime'];
                        $startTime = date('H:i', strtotime($startDate));
                        $endDate = $order['delivery_datetime'];
                        $endTime = date('H:i', strtotime($endDate));
                        $shiftId = $this->common->insertTableData("tb_shifts", [
                            'user_id' => $this->userId,
                            'stime' => $startTime,
                            'etime' => $endTime,
                            'splace' => $order['pickup_city'],
                            'slat' => $plat,
                            'slng' => $plng,
                            'eplace' => $order['delivery_city'],
                            'elat' => $dlat,
                            'elng' => $dlng,
                            'scity' => $order['pickup_city'],
                            'dcity' => $order['delivery_city'],
                            'zone_id' => 1,
                            'empshift_start' => $startTime,
                            'empshift_end' => $endTime,
                            'trip_type' => 0,
                            'startdate' => $startDate,
                            'enddate' => $endDate,
                            'shipment_name' => 'Boxes',
                            'shipment_id' => 0,
                            'transport_mode' => $transportMode,
                            'customer_id' => $customerId,
                            'vendor_id' => $vendorId,
                            'carrier_type' => 0,
                            'shipmentid' => $uniqueId,
                            'txnid' => $uniqueId,
                            'weight' => $weight,
                            'volume' => $volume,
                            'units' => $order['quantity'],
                            'domainname' => 'INFD',
                            'vehicle_type' => $vehicleType,
                            'company_code' => $this->companyCode,
                            'branch_code' => $this->branchCode,
                            'status' => 1
                        ]);
                    } else {
                        $shiftId = $shipment['id'];
                    }
                } else {
                    if ($tripForTrip == $tripNumber && $routeForTrip == $route && $driverForTrip == $driver && $vehicleForTrip == $registerNumber && $vendorForTrip == $vendorCode && strtotime($earlyPickup) == strtotime($tripForEarlyPickup)) {
                        $getShiftData = $this->common->gettblrowdata(['id' => $orderForTrip], "shift_id,shipmentid", "tb_orders", 0, 0);
                        $shiftId = $getShiftData['shift_id'] ?? 0;
                        $uniqueId = $getShiftData['shipmentid'] ?? "";
                    } else {
                        $j = $i;
                        $bookingForTrip = $orderDetails[$j]['bookingId'];
                        if ($bookingForTrip != "" && $bookingForTrip != '') {
                            $sequenceNumber = substr($bookingForTrip, -6);
                        }
                        $shipmentId = $uniqueId = "T" . $countCode . $week . $year . $sequenceNumber;
                        $shipment = $this->common->gettblrowdata(["shipmentid" => $shipmentId], "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type", "tb_shifts", 0, 0);
                        if (empty($shipment)) {
                            $weight = $order['weight'];
                            $volume = $order['volume'];
                            $uniqueId = $shipmentId;
                            if ($vehicleTypeId != '' && $vehicleTypeId != 0) {
                                $getVehicleType = $this->common->gettblrowdata(["id" => $vehicleTypeId], "trucktype", "tb_trucktypes", 0, 0);
                                if (!empty($getVehicleType)) {
                                    $vehicleType = $getVehicleType['trucktype'];
                                } else {
                                    $vehicleType = $order['vehicle_type'];
                                }
                            } else {
                                $vehicleType = $order['vehicle_type'];
                            }
                            $startDate = $order['pickup_datetime'];
                            $startTime = date('H:i', strtotime($startDate));
                            $endDate = $order['delivery_datetime'];
                            $endTime = date('H:i', strtotime($endDate));
                            $shiftId = $this->common->insertTableData("tb_shifts", [
                                'user_id' => $this->userId,
                                'stime' => $startTime,
                                'etime' => $endTime,
                                'splace' => $order['pickup_city'],
                                'slat' => $plat,
                                'slng' => $plng,
                                'eplace' => $order['delivery_city'],
                                'elat' => $dlat,
                                'elng' => $dlng,
                                'scity' => $order['pickup_city'],
                                'dcity' => $order['delivery_city'],
                                'zone_id' => 1,
                                'empshift_start' => $startTime,
                                'empshift_end' => $endTime,
                                'trip_type' => 0,
                                'startdate' => $startDate,
                                'enddate' => $endDate,
                                'shipment_name' => 'Boxes',
                                'shipment_id' => 0,
                                'transport_mode' => $transportMode,
                                'customer_id' => $customerId,
                                'vendor_id' => $vendorId,
                                'carrier_type' => 0,
                                'shipmentid' => $uniqueId,
                                'txnid' => $uniqueId,
                                'weight' => $weight,
                                'volume' => $volume,
                                'units' => $order['quantity'],
                                'domainname' => 'INFD',
                                'vehicle_type' => $vehicleType,
                                'company_code' => $this->companyCode,
                                'branch_code' => $this->branchCode,
                                'status' => 1
                            ]);
                        } else {
                            $shiftId = $shipment['id'];
                        }
                    }
                }
                $capacity = $order['weight'];
                if ($capacity == "") {
                    $capacity = "0";
                }
                $this->common->updatetbledata("tb_orders", ['vendor_id' => $vendorId, 'shift_id' => $shiftId, "shipmentid" => $uniqueId], ["id" => $orderId]);
                makeorderinvolvedpartiestype($vendorId, $orderId, "CARRIER", $this->userId, $this->companyCode);
                if (in_array($bookingId, $noBookingIds)) {
                } else {
                    $noBookingIds[] = $bookingId;
                    $excelSuccessOrders[] = ['order_id' => $orderId, 'customer_id' => $customerCode ?? "", 'booking_id' => $bookingId, 'trip_id' => $uniqueId, 'delivery_note' => '', 'status' => 'Success'];
                }
                $employeeId = $this->common->insertTableData("tb_employee", [
                    'assoc_id' => $uniqueId,
                    'pickup' => $pickup,
                    'plat' => $plat,
                    'plng' => $plng,
                    'drop' => $delivery,
                    'dlat' => $dlat,
                    'dlng' => $dlng,
                    'pickup_city' => $order['pickup_city'],
                    'drop_city' => $order['delivery_city'],
                    'pickup_datetime' => $order['pickup_datetime'],
                    'drop_datetime' => $order['delivery_datetime'],
                    'name' => 'Boxes',
                    'phone' => $order['customer_phone'],
                    'address' => $address,
                    'emailid' => $order['customer_email'],
                    'user_id' => $this->userId,
                    'status' => 1,
                    'createdon' => $currentDate,
                    'material_id' => 0,
                    'capacity' => $capacity,
                    'information' => $order['customer_comments'],
                    'shipment_weight' => $order['weight'],
                    'shipment_volume' => $order['volume'],
                    'ship_type' => 'P',
                    'customer_id' => $order['customer_id'],
                    'vendor_id' => $vendorId,
                    'shipment_id' => 0,
                    'startdate' => $order['pickup_datetime'],
                    'enddate' => $order['delivery_datetime'],
                    'shift_id' => $shiftId,
                    'stop_order' => 1,
                    'drop_order' => 0,
                    'basic_stop' => 0,
                    'stop_id' => 0,
                    'drop_stopid' => 0,
                    'order_id' => $order['order_id'],
                    'pkgitemid' => 'BOXES',
                    'no_of_pkgs' => $order['quantity'],
                    'domainname' => 'INFD'
                ]);
                if ($employeeId > 0) {
                    if ($stops_units->num_rows() > 1) {
                        $odata = $stops_units->row_array();
                        $this->common->updatetbledata("tb_order_cargodetails", ['stop_detail_id' => $employeeId], ["id" => $odata['id']]);
                    }
                    $this->common->updatetbledata("tb_orders", ['status' => 2], ['id' => $orderId]);
                    $checkStop = $this->common->gettblrowdata(["shipment_id" => $shiftId, "stopcity" => $order['pickup_city'], "stoptype" => "P"], "id", "tb_shiporder_stops", 0, 0);
                    if (empty($checkStop)) {
                        $pickupStopId = $this->common->insertTableData("tb_shiporder_stops", [
                            'stopname' => $order['pickup_city'],
                            'plat' => $plat,
                            'plng' => $plng,
                            'stopcity' => $order['pickup_city'],
                            'address' => $address,
                            'stoptype' => 'P',
                            'stopstatus' => 0,
                            'shipment_id' => $shiftId,
                            'ordernumber' => 1,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['pickup_endtime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $currentDate
                        ]);
                    } else {
                        $pickupStopId = $checkStop['id'];
                    }
                    $chkstop = $this->common->gettblrowdata(["shipment_id" => $shiftId, "stopcity" => $order['delivery_city'], "stoptype" => "D"], "id", "tb_shiporder_stops", 0, 0);
                    if (empty($chkstop)) {
                        $dropStopId = $this->common->insertTableData("tb_shiporder_stops", [
                            'stopname' => $order['delivery_city'],
                            'plat' => $dlat,
                            'plng' => $dlng,
                            'stopcity' => $order['delivery_city'],
                            'address' => $dropaddr,
                            'stoptype' => 'D',
                            'stopstatus' => 0,
                            'shipment_id' => $shiftId,
                            'ordernumber' => 2,
                            'startdate' => $order['delivery_datetime'],
                            'enddate' => $order['drop_endtime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $currentDate
                        ]);
                    } else {
                        $dropStopId = $chkstop['id'];
                    }
                    $this->common->updatetbledata("tb_employee", ['stop_id' => $pickupStopId, 'drop_stopid' => $dropStopId], ['id' => $employeeId]);
                    $checkShiftVeh = $this->common->gettblrowdata(["shft_id" => $shiftId], "id", "tb_shft_veh", 0, 0);
                    if (!empty($checkShiftVeh)) {
                        $shiftVehId = $checkShiftVeh['id'];
                        $checkShiftVehEmp = $this->common->gettblrowdata(["shft_veh_id" => $shiftVehId, "status" => 1], "id", "tb_shft_veh_emp", 0, 0);
                        if (empty($checkShiftVehEmp)) {
                            $getEmployee = $this->common->gettbldata(["shift_id" => $shiftId, 'status' => '1'], "id,pickup_datetime,drop_datetime", "tb_employee", 0, 0);
                            if (!empty($getEmployee)) {
                                $priority = 1;
                                foreach ($getEmployee as $eachRow) {
                                    $this->common->insertTableData("tb_shft_veh_emp", ["user_id" => $this->userId, "shft_veh_id" => $shiftVehId, "emp_id" => $eachRow['id'], "priority" => $priority, "pickup_time" => $eachRow['pickup_datetime'], 'created_on' => $currentDate, 'updated_on' => $currentDate, "status" => 1, "drop_time" => $eachRow['drop_datetime']]);
                                    $priority++;
                                }
                            }
                        } else {
                            $checkShiftVehEmp = $this->common->gettblrowdata(["shft_veh_id" => $shiftVehId, "emp_id" => $employeeId, "status" => 1], "id", "tb_shft_veh_emp", 0, 0);
                            if (!empty($checkShiftVehEmp)) {
                                $this->common->insertTableData("tb_shft_veh_emp", ["user_id" => $this->userId, "shft_veh_id" => $checkShiftVehEmp['id'], "emp_id" => $employeeId, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $currentDate, 'updated_on' => $currentDate, "status" => 1, "drop_time" => $order['delivery_datetime']]);
                            }
                        }
                    } else {
                        if ($vehicleId > 0) {
                            $shiftVehId = $this->common->insertTableData("tb_shft_veh", ['user_id' => $this->userId, 'route_id' => 0, 'shft_id' => $shiftId, 'carrier_id' => $vendorId, 'vehicle_id' => $vehicleId, 'register_number' => $registerNumber, 'status' => 1]);
                            $getEmployee = $this->common->gettbldata(["shift_id" => $shiftId, 'status' => '1'], "id,pickup_datetime,drop_datetime", "tb_employee", 0, 0);
                            if (!empty($getEmployee)) {
                                $priority = 1;
                                foreach ($getEmployee as $eachRow) {
                                    $this->common->insertTableData("tb_shft_veh_emp", ["user_id" => $this->userId, "shft_veh_id" => $shiftVehId, "emp_id" => $eachRow['id'], "priority" => $priority, "pickup_time" => $eachRow['pickup_datetime'], 'created_on' => $currentDate, 'updated_on' => $currentDate, "status" => 1, "drop_time" => $eachRow['drop_datetime']]);
                                    $priority++;
                                }
                            }
                        }
                        if ($vehicleId > 0 && $driverId > 0) {
                            $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["vehicle_id" => $vehicleId]);
                            if ($chk->num_rows() > 0) {
                                if ($driverId == $chk->row()->driver_id) {
                                    $this->common->updatetbledata("tb_vehicles_drivers", ["status" => 1], ["id" => $chk->row()->id]);
                                } else {
                                    $this->common->insertTableData("tb_vehicles_drivers", ['vehicle_id' => $vehicleId, 'driver_id' => $driverId, 'imei' => "", 'status' => 1, 'createdon' => $currentDate, 'updatedon' => $currentDate]);
                                }
                            } else {
                                $this->common->insertTableData("tb_vehicles_drivers", ['vehicle_id' => $vehicleId, 'driver_id' => $driverId, 'imei' => "", 'status' => 1, 'createdon' => $currentDate, 'updatedon' => $currentDate]);
                            }
                            $checkAssignedDrivers = $this->common->gettblrowdata(["driver_id" => $driverId, "vehicle_id" => $vehicleId, 'status' => '1'], "id", "tbl_assigned_drivers", 0, 0);
                            if (!empty($checkAssignedDrivers)) {
                                $this->common->updatetbledata("tbl_assigned_drivers", ["status" => 1], ["id" => $checkAssignedDrivers['id']]);
                            } else {
                                $checkAssignedDrivers = $this->common->gettblrowdata(["driver_id  <>" => $driverId, "vehicle_id" => $vehicleId, 'status' => '1'], "id", "tbl_assigned_drivers", 0, 0);
                                if (empty($checkAssignedDrivers)) {
                                    $this->common->insertTableData("tbl_assigned_drivers", ["vehicle_id" => $vehicleId, "user_id" => $this->userId, "driver_id" => $driverId, "mobile_no" => $driverId, "imei" => "", "from_time" => $currentDate, "to_time" => $currentDate, "status" => "1", 'created_on' => $currentDate]);
                                } else {
                                    $this->common->updatetbledata("tbl_assigned_drivers", ["driver_id" => $driverId, 'status' => '1', 'updated_on' => $currentDate], ["id" => $checkAssignedDrivers['id']]);
                                }
                            }
                        }
                    }
                    $checkStopStatus = $this->common->gettblrowdata(["shipment_id  <>" => $shiftId, "status_id" => '9', 'status' => '1'], "id", "tb_stop_status", 0, 0);
                    if (empty($checkStopStatus)) {
                        $this->common->insertTableData("tb_stop_status", ["shipment_id" => $shiftId, "stop_id" => 0, "order_id" => $orderId, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $currentDate]);
                    }
                }
            }
        }
        return $excelSuccessOrders;
    }
}

?>
