<?php
use App\Generators\RandomString;

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Excelimportclorders extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->model(["Orderrevenuesmodel","bpartners"]);
        $this->load->library('Ratemanagement');
        $this->load->library(['Vatcalculationtorate', 'altovaordercreation']);
    }

    public function index()
    {
        echo "Upload CL Data";
    }
    
    public function insertordertrips(){
        ini_set("max_input_time",2000);
        ini_set("max_execution_time",900);
        ini_set("max_input_vars",20000);
        ini_set("upload_max_size","2048M");
        ini_set("post_max_size",0);
        ini_set("memory_limit","2048M");
        $orders_list = $nobooking_ids = $excel_forders = $excel_sorders = $trip_array = $post = array();
        $cdate = date('Y-m-d H:i:s');
        $user_id     = $this->session->userdata('user_id');
        $company_code= $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $post = $this->input->post(NULL,TRUE);
        if(!empty($post['orders']))
        {
            foreach ($post['orders'] as $order) {
                $delivery_note = $order['delivery_note'] ?? "";
                $service = $order['service'] ?? "";
                $company_code = $order['company_code'] ?? $company_code;
                $branch_code = $order['branch_code'] ?? $branch_code;
                $department_code = $order['department_code'] ?? "";
                $customer_id = $order['customer_id'] ?? "";
                $pickup_id = $order['pickup_id'] ?? "";
                $pickup_name = $order['pickup_name'] ?? "";
                $pickup_street = $order['pickup_street'] ?? "";
                $pickup_city = $order['pickup_city'] ?? "";
                $pickup_state = $order['pickup_state'] ?? "";
                $pickup_country = $order['pickup_country'] ?? "";
                $pickup_pincode = $order['pickup_pincode'] ?? "";
                $early_pickups = $order['early_pickup'] ?? "";
                if ($early_pickups != "" && $early_pickups != "0000-00-00 00:00:00") {
                    $epickup = getdatetimebytimezone(DFLT_TZ, $early_pickups, $curtz);
                    $early_pickup = $epickup['datetime'];
                }
                $late_pickups = $order['late_pickup'] ?? "";
                if ($late_pickups != "" && $late_pickups != "0000-00-00 00:00:00") {
                    $lpickup = getdatetimebytimezone(DFLT_TZ, $late_pickups, $curtz);
                    $late_pickup = $lpickup['datetime'];
                }
                $pickup_phone = $order['pickup_phone'] ?? "";
                $drop_id = $order['drop_id'] ?? "";
                $drop_name = $order['drop_name'] ?? "";
                $drop_street = $order['drop_street'] ?? "";
                $drop_city = $order['drop_city'] ?? "";
                $drop_state = $order['drop_state'] ?? "";
                $drop_country = $order['drop_country'] ?? "";
                $drop_pincode = $order['drop_pincode'] ?? "";
                $early_drops = $order['early_drop'] ?? "";
                if ($early_drops != "" && $early_drops != "0000-00-00 00:00:00") {
                    $earlydrop = getdatetimebytimezone(DFLT_TZ, $early_drops, $curtz);
                    $early_drop = $earlydrop['datetime'];
                }
                $late_drops = $order['late_drop'] ?? "";
                if ($late_drops != "" && $late_drops != "0000-00-00 00:00:00") {
                    $latedrop = getdatetimebytimezone(DFLT_TZ, $late_drops, $curtz);
                    $late_drop = $latedrop['datetime'];
                }
                $drop_phone = $order['drop_phone'] ?? "";
                $cargo_type = $order['cargo_type'] ?? "";
                $weight = $order['weight'] ?? "";
                $volume = $order['volume'] ?? "";
                $quantity = $order['quantity'] ?? "";
                $trip_no = $order['trip_no'] ?? "";
                $driver = $order['driver'] ?? "";
                $vehicle_no = $order['vehicle_no'] ?? "";
                $carrier = $order['carrier'] ?? "";
                $pickup_address = $pickup_street.",".$pickup_city.",".$pickup_state;
                $pickup_info = ['code' => $pickup_id, 'name' => $pickup_name, 'street' => $pickup_street, 'city' => $pickup_city, 'state' => $pickup_state, 'country' => $pickup_country, 'pincode' => $pickup_pincode, 'phone' =>$pickup_phone, 'address' => $pickup_address, 'department_code' => $department_code];
                $getshipperLatlng = $this->db->query("SELECT latitude, longitude FROM tbl_party_master WHERE code = ? AND company_code = ? AND branch_code = ?", [$pickup_id, $company_code, $branch_code]);
                if ($getshipperLatlng->num_rows() > 0) {
                    $pickupLatitude = $getshipperLatlng->row()->latitude;
                    $pickupLongitude = $getshipperLatlng->row()->longitude;
                }
                $pickup = $this->chkpartytypes($pickup_info, 'Shipper');
                $pickup_master_id = $pickup['party_master_id'] ?? 0;
                $pickup_master_code = $pickup['party_master_code'] ?? 0;
                $pickup_party_id = $pickup['party_type_id'] ?? 0;
                if($pickup_master_id == 0){
                    if(in_array($customer_id.$delivery_note, $nobooking_ids)){
                    }else{
                        $nobooking_ids[] = $customer_id.$delivery_note;
                        $excel_forders[] = array('order_id'=>'0','booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$delivery_note,'trip_id'=>'-','status'=>'Fail');
                    }
                }
                $drop_address = $drop_street.",".$drop_city.",".$drop_state;
                $drop_info = ['code' => $drop_id, 'name' => $drop_name, 'street' => $drop_street, 'city' => $drop_city, 'state' => $drop_state, 'country' => $drop_country, 'pincode' => $drop_pincode, 'phone' => $drop_phone, 'address' => $drop_address, 'department_code' => $department_code];
                $getdropLatlng = $this->db->query("SELECT latitude, longitude FROM tbl_party_master WHERE code = ? AND company_code = ? AND branch_code = ?", [$drop_id, $company_code, $branch_code]);
                if ($getdropLatlng->num_rows() > 0) {
                    $dropLatitude = $getdropLatlng->row()->latitude;
                    $dropLongitude = $getdropLatlng->row()->longitude;
                }
                $drop = $this->chkpartytypes($drop_info, 'Consignee');
                $drop_master_id = $drop['party_master_id'] ?? 0;
                $drop_master_code = $drop['party_master_code'] ?? 0;
                $drop_party_id = $drop['party_type_id'] ?? 0;
                if ($drop_master_id == 0) {
                    if (in_array($customer_id . $delivery_note, $nobooking_ids)) {
                    } else {
                        $nobooking_ids[] = $customer_id . $delivery_note;
                        $excel_forders[] = ['order_id' => '0', 'booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $delivery_note, 'trip_id' => '-', 'status' => 'Fail'];
                    }
                }
                if ($pickup_master_id > 0 && $drop_master_id > 0) {
                    if ($pickupLatitude != "" && $pickupLongitude != "" && $dropLatitude != "" && $dropLongitude != "") {
                        $lat1 = $pickupLatitude;
                        $lng1 = $pickupLongitude;
                        $lat2 = $dropLatitude;
                        $lng2 = $dropLongitude;
                    } else {
                        $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                        $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
                        $data = getlatlngsbyplace($add1);
                        $lat1 = $data[0] ?? null;
                        $lng1 = $data[1] ?? null;
                        $data = getlatlngsbyplace($add2);
                        $lat2 = $data[0] ?? null;
                        $lng2 = $data[1] ?? null;
                    }
                    $shipment_id      = "SVK" . time();
                    $enddate          = date( 'Y-m-d H:i:s', strtotime( "+1 day" ) );
                    $getTransportModeWithCompanyCode = $this->common->gettblrowdata(['code' => 'LTL', 'company_code' => $company_code, 'status' => '1'], "id,name", "tb_transportmode", 0, 0);
                    if (!empty($getTransportModeWithCompanyCode)) {
                        $transportModeId = $getTransportModeWithCompanyCode['id'];
                        $transportModeName = $getTransportModeWithCompanyCode['name'];
                    } else {
                        $getTransportMode = $this->common->gettblrowdata(['code' => 'LTL', 'status' => '1'], "id,name", "tb_transportmode", 0, 0);
                        if (!empty($getTransportMode)) {
                            $transportModeId = $getTransportMode['id'];
                            $transportModeName = $getTransportMode['name'];
                        }
                    }
                    $ship_arr   = array(
                        'shipid'           => $shipment_id,
                        'txnid'            => $shipment_id,
                        'trucktype'        => $transportModeName ?? "",
                        'pickupcnt'        => '1',
                        'dropcnt'          => '1',
                        'unitspec'         => 1,
                        'insertusr'        => $pickup_master_code,
                        'carrier'          => '0',
                        'insertuserdate'   => $cdate,
                        'enddate'          => $enddate,
                        'insdate'          => $cdate,
                        'upddate'          => $cdate,
                        'reason'           => 'SHIPMENT',
                        'purpose'          => 'SEND INTEGRATION',
                        'ship_object'      => 'SHIPMENT',
                        'logdate'          => $cdate,
                        'transport_mode'   => 'LTL',
                        'domainname'       => $branch_code,
                        'company_code'     => $company_code,
                        'branch_code'      => $branch_code,
                        'product'          => '',
                        'freight_term'     => '60',
                        'freight_termname' => 'Free of Charge',
                        'incoterm'         => '',
                        'modeoftransport'  => $transportModeId ?? 0,
                        'createdon'        => $cdate,
                    );
                    $shipment_row_id           = $this->common->insertTableData("tb_shipments",$ship_arr);
                    $childid      = 0;
                    if ( $this->session->userdata( 'childid' ) ) {
                        $childid = $this->session->userdata( 'childid' );
                    }
                    $logdate      = date( 'Y-m-d H:i:s' );
                    $getactual    = getdatetimebytimezone( DFLT_TZ, $logdate, $curtz );
                    $logdate      = $getactual['datetime'];
                    $customer_row_id = 0;
                    $getcustomer_rowid = $this->common->gettblrowdata(array('code'=>$customer_id,'user_id'=>$user_id,'status'=>'1'),"id","tb_customers",0,0);
                    if(!empty($getcustomer_rowid)){
                        $customer_row_id = $getcustomer_rowid['id'];
                    }
                    $orderinfo    = array(
                        'shipment_id'       => $shipment_row_id,
                        'customer_id'       => $customer_row_id,
                        'product'           => '',
                        'pickup_datetime'   => $early_pickup,
                        'delivery_datetime' => $early_drop,
                        'pickup_endtime'    => $late_pickup,
                        'drop_endtime'      => $late_drop,
                        'goods_value'       => '0.00',
                        'company_code'      => $company_code,
                        'branch_code'       => $branch_code,
                        'createdon'         => $cdate,
                        'drop_custid'       => $drop_master_code,
                        'drop_partyid'      => $drop_master_code,
                        'user_id'           => $user_id,
                        'sub_uid'           => $childid,
                        'pickup_custid'     => $pickup_master_code,
                        'pickup_partyid'    => $pickup_master_code,
                        'pickup_country'    => $pickup_country,
                        'pickup_city'       => $pickup_city,
                        'pickup_pincode'    => $pickup_pincode,
                        'pickup_company'    => $pickup_name,
                        'pickup_address1'   => $pickup_street,
                        'pickup_address2'   => $pickup_state,
                        'delivery_country'  => $drop_country,
                        'delivery_city'     => $drop_city,
                        'delivery_pincode'  => $drop_pincode,
                        'delivery_company'  => $drop_name,
                        'delivery_address1' => $drop_street,
                        'delivery_address2' => $drop_state,
                        'is_created'        => '1',
                        'plat'              => $lat1,
                        'plng'              => $lng1,
                        'dlat'              => $lat2,
                        'dlng'              => $lng2,
                        'transport_mode'    => '',
                        'created_source'    => '4',
                        'createdon'         => $logdate
                    );
                    $order_id    = $this->common->insertTableData( "tb_orders", $orderinfo );
                    if($order_id == 0){
                        if(in_array($customer_id.$delivery_note, $nobooking_ids)){
                        }else{
                            $nobooking_ids[] = $customer_id.$delivery_note;
                            $excel_forders[] = array('order_id'=>'0','booking_id'=>'-','customer_id'=>$customer_id,'delivery_note'=>$delivery_note,'trip_id'=>'-','status'=>'Fail');
                        }
                    }else{
                        $service_id = "";
                        $servs = explode('-',$service);
                        if(!empty($servs)){
                            $serv_id = isset($servs[0]) ? $servs[0] : "";
                            $serv_name = isset($servs[1]) ? $servs[1] : "";
                            $service_id = trim($serv_id);
                            $service_name = trim($serv_name);
                            $swhr = " company_code LIKE '".$company_code."' ";
                            $service_ar = $this->Orderrevenuesmodel->checkservicemaster_withname($swhr,$service_name,$service_id,$service);
                            if(!empty($service_ar)){
                                $service_id = $service_ar['id'];
                            }
                        }
                        $country_code = $this->session->userdata( "usr_tzone" )['phone_code'];
                        $company_code = $this->session->userdata( "company_code" );
                        $get_country = $this->common->gettblrowdata(array('id'=>$user_id),"country_code,company_code","tb_users",0,0);
                        if(!empty($get_country)){
                            $country_code  = $get_country['country_code'];
                            $company_code  = $get_country['company_code'];
                        }
                        $genord       = array( "user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code );
                        $booking_id   = generatebookingid( $genord );
                        $details      = array(
                            'shipper_id'      => $pickup_master_id,
                            'service'         => $service_id,
                            'delivery_term'   => '',
                            'incoterm'        => '',
                            /*'purchase_order'  => $porder,*/
                            'notify_party'    =>'',
                            'department_code' => $department_code,
                            'createdon'       => $cdate,
                            'order_row_id'    => $order_id,
                            'order_id'        => $booking_id,
                            'order_type'      => '',
                        );
                        $this->common->insertTableData( 'tb_order_details', $details );
                        if(in_array($customer_id.$delivery_note, $nobooking_ids)){
                        }else{
                            $excel_sorders[] = array('order_id'=>$order_id,'booking_id'=>$booking_id,'customer_id'=>$customer_id,'delivery_note'=>$delivery_note,'trip_id'=>'-','status'=>'Success');
                        }
                        $invtypes     = makeorderinvolvedpartiestype( $customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
                        $upd          = $this->db->where( array( 'id' => $order_id ) )->update( "tb_orders", array( 'order_id' => $booking_id ) );
                        /*order address insertion*/
                        $shipper_address    = array( 'order_id' => $order_id, 'party_master_id' => $pickup_master_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id );
                        $chk_shipperaddress = $this->common->gettblrowdata(array( 'order_id' => $order_id, 'party_master_id' => $pickup_master_id, 'status' => '1' ),"id","tbl_orderparty_address",0,0);
                        if ( !empty($chk_shipperaddress)) {
                            $shipperadd_id = $chk_shipperaddress['id'];
                            $upd_add = $this->common->updatetbledata("tbl_orderparty_address",$shipper_address,array( 'id' => $shipperadd_id ) );
                        } else {
                            $shipper_address['createdon'] = $cdate;
                            $shipperadd_id = $this->common->insertTableData("tbl_orderparty_address", $shipper_address);
                        }
                        $delivery_address    = array( 'order_id' => $order_id, 'party_master_id' => $drop_master_id, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id );
                        $chk_deliveryaddress = $this->common->gettblrowdata(array( 'order_id' => $order_id, 'party_master_id' => $drop_master_id, 'status' => '1' ),"id","tbl_orderparty_address",0,0);
                        if ( !empty($chk_deliveryaddress) ) {
                            $dropadd_id = $chk_deliveryaddress['id'];
                            $upd_add = $this->common->updatetbledata("tbl_orderparty_address",$delivery_address,array( 'id' => $dropadd_id ) );
                        } else {
                            $delivery_address['createdon'] = $cdate;
                            $dropadd_id = $this->common->insertTableData("tbl_orderparty_address", $delivery_address);
                        }
                        /*Insert cargo */
                        $cargo_details = ['cargo_type' => $cargo_type, 'quantity' => $quantity, 'length' => '1', 'length_unit' => 'm', 'width' => '1', 'width_unit' => 'm', 'height' => '1', 'height_unit' => 'm', 'weight' => $weight, 'weight_unit' => 'Kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'second_weight' => '0', 'second_volume' => '0', 'createdby' => $user_id, 'createdon' => $cdate];
                        $cargo_id = $this->common->insertTableData("tb_cargo_details", $cargo_details);
                        $gethandling_unit = $this->common->gettblrowdata(array('unit_name' => $cargo_type), "id", "tbl_shipunit_types", 0, 0);
                        $handling_unit = "";
                        if (!empty($gethandling_unit)) {
                            $handling_unit = $gethandling_unit['id'];
                        } else {
                            $handlingunit_ar = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                            $handling_unit = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                        }
                        $order_cargo = ['order_id' => $order_id, 'quantity' => $quantity, 'cargo_id' => $cargo_id, 'status' => '1', 'createdon' => $cdate, 'cargo_content' => $cargo_type, 'quantity_type' => $cargo_type, 'length' => '1', 'width' => '1', 'height' => '1', 'weight' => $weight, 'volume' => $volume, 'second_weight' => '0', 'second_volume' => '0', 'handling_unit' => $handling_unit];
                        $order_cargo_id = $this->common->insertTableData("tb_order_cargodetails", $order_cargo);
                        $unitspec = "BOX";
                        $updship = $this->db->where(['id' => $shipment_row_id])->update("tb_shipments", array('unitspec' => $unitspec, 'txncode' => $booking_id));
                        $total_weight = $total_volume = $total_quantity = 1;
                        $getordercargodetails = $this->Orderrevenuesmodel->getallordercargodetails($order_id);
                        if (!empty($getordercargodetails)) {
                            $total_volume = $getordercargodetails['total_volume'];
                            $total_weight = $getordercargodetails['total_weight'];
                            $total_quantity = $getordercargodetails['total_quantity'];
                        }
                        $upd_order = $this->common->updatetbledata("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $quantity], ['id' => $order_id]);
                        if ( $delivery_note != "" ) {
                            $ins_ref = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $delivery_note, 'createdon' => $cdate];
                            $ins     = $this->common->insertTableData( 'tb_order_references', $ins_ref );
                        }
                        /*ORDER PARTIES INSERTION */
                        $shipper_party = ['order_id' => $order_id, 'order_number' => $booking_id, 'party_id' => $pickup_master_id, 'party_type' => $pickup_party_id, 'status' => '1', 'createdon' => $cdate];
                        $ins = $this->common->insertTableData('tb_order_parties', $shipper_party);
                        $drop_party = ['order_id' => $order_id, 'order_number' => $booking_id, 'party_id' => $drop_master_id, 'party_type' => $drop_party_id, 'status' => '1', 'createdon' => $cdate];
                        $ins = $this->common->insertTableData('tb_order_parties', $drop_party);
                        $earlypickupdate = date('Y-m-d', strtotime($early_pickup));
                        $trip_array[] = ['order_id' => $order_id, 'booking_id' => $booking_id, 'carrier' => $carrier, 'vehicle_no' => $vehicle_no, 'driver' => $driver, 'trip_no' => $trip_no, 'early_pickup' => $earlypickupdate];
                    }
                }
                try {
                    $this->altovaordercreation->sendOrderToAltova($order_id);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
                }
            }
        }
        if(!empty($trip_array)){
            $trip = $this->maketripfororders($trip_array);
            if(!empty($excel_sorders)){
                for ($s=0, $sMax = count($excel_sorders); $s < $sMax; $s++) {
                    $order_id = $excel_sorders[$s]['order_id'];
                    if($order_id >0){
                        $getshipmentid = $this->common->gettblrowdata(array('id'=>$order_id),"shipmentid","tb_orders",0,0);
                        if(!empty($getshipmentid)){
                            $excel_sorders[$s]['trip_id'] = $getshipmentid['shipmentid'];
                        }
                    }
                }
            }
        }
        $excel_orders = array_merge($excel_forders,$excel_sorders);
        if(!empty($excel_orders)){
            @file_put_contents("assets/ordertemplate/clexceluploaddata.txt", json_encode($excel_orders));
        }
        redirect('orders/orderslist/02');
    }
   
    public function maketripfororders($orders_list){
        $dummy_array = $newlist = array();
        $countryid = $this->session->userdata("usr_tzone")['phone_code'];
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if(!empty($orders_list)){
            foreach ($orders_list as $iValue) {
                $first_order       = isset($iValue['order_id']) ? $iValue['order_id'] : "";
                $first_booking     = isset($iValue['booking_id']) ? $iValue['booking_id'] : "";
                $first_carrier     = isset($iValue['carrier']) ? $iValue['carrier'] : "";
                $first_vehicle     = isset($iValue['vehicle_no']) ? $iValue['vehicle_no'] : "";
                $first_driver      = isset($iValue['driver']) ? $iValue['driver'] : "";
                $first_tripno      = isset($iValue['trip_no']) ? $iValue['trip_no'] : "";
                $first_earlypickup = isset($iValue['early_pickup']) ? $iValue['early_pickup'] : "";
                if(!in_array($iValue['booking_id'],$dummy_array)){
                    for($k=0, $kMax = count($orders_list); $k< $kMax; $k++){
                        $current_order     = isset($orders_list[$k]['order_id']) ? $orders_list[$k]['order_id'] : "";
                        $current_booking   = isset($orders_list[$k]['booking_id']) ? $orders_list[$k]['booking_id'] : "";
                        $current_carrier   = isset($orders_list[$k]['carrier']) ? $orders_list[$k]['carrier'] : "";
                        $current_vehicle   = isset($orders_list[$k]['vehicle_no']) ? $orders_list[$k]['vehicle_no'] : "";
                        $current_driver    = isset($orders_list[$k]['driver']) ? $orders_list[$k]['driver'] : "";
                        $current_tripno    = isset($orders_list[$k]['trip_no']) ? $orders_list[$k]['trip_no'] : "";
                        $earlypickup    = isset($orders_list[$k]['early_pickup']) ? $orders_list[$k]['early_pickup'] : "";
                        $strtotime1 = strtotime($first_earlypickup);
                        $strtotime2 = strtotime($earlypickup);
                        if($strtotime2 == $strtotime1 && $current_carrier == $first_carrier && $first_tripno == $current_tripno && $current_driver == $first_driver && $current_vehicle == $first_vehicle){
                            $newlist[]    = isset($orders_list[$k]) ? $orders_list[$k] : "";
                            $dummy_array[] =isset($orders_list[$k]['booking_id']) ? $orders_list[$k]['booking_id'] : "";
                        }

                    }
                }
            }
        }
        if(!empty($newlist)){
            $j =0;
            for($i=0, $iMax = count($newlist); $i< $iMax; $i++){
                if($j == '0'){
                    $order_forshift  = $newlist[0]['order_id'];
                    $vendor_forship  = $newlist[0]['carrier'];
                    $vehicle_forship = $newlist[0]['vehicle_no'];
                    $driver_forship  = $newlist[0]['driver'];
                    $pickup_forship  = $newlist[0]['early_pickup'];
                    $booking_forship = $newlist[0]['booking_id'];
                    $trip_forship    = $newlist[0]['trip_no'];
                }else{
                    $order_forshift  = $newlist[$j]['order_id'];
                    $vendor_forship  = $newlist[$j]['carrier'];
                    $vehicle_forship = $newlist[$j]['vehicle_no'];
                    $driver_forship  = $newlist[$j]['driver'];
                    $pickup_forship  = $newlist[$j]['early_pickup'];
                    $booking_forship = $newlist[$j]['booking_id'];
                    $trip_forship    = $newlist[$j]['trip_no'];
                }
                $order_id        = $newlist[$i]['order_id'];
                $booking_id      = $newlist[$i]['booking_id'];
                $vendor_code     = $newlist[$i]['carrier'];
                $register_number = $newlist[$i]['vehicle_no'];
                $trip_no         = $newlist[$i]['trip_no'];
                $driver          = $newlist[$i]['driver'];
                $early_pickup    = $newlist[$i]['early_pickup'];
                $count_code=substr($company_code, 0, 2);
                $txnid = time();
                $year=date('y');
                $week=date('W');
                $seq_num=000001;
                if($booking_forship != "" && $booking_forship != ''){
                    $seq_num=substr($booking_forship, -6);
                }
                $shipid = $txnid = "T".$count_code.$week.$year.$seq_num;
                $response = $vendor_id = $vehicle_id = $driver_id = 0;
                $user_id = $userid = $this->session->userdata('user_id');
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $logdate = date('Y-m-d H:i:s');
                $tpvehicle_type = 1;
                $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                $curdt = $getactual['datetime'];
                $where  = array('code'=>$vendor_code,'status'=>'1');
                $select = "id,name";
                $table = "tb_vendors";
                $vendor_name  = "";
                $vendor_details = $this->common->gettblrowdata($where,$select,$table,0,0);
                if(count($vendor_details)>0){
                    $vendor_id = $vendor_details['id'];
                    $vendor_name = $vendor_details['name'];
                }
                if($vendor_id != 0){
                    $vslt = "id";
                    $vwhr = array('register_number'=>$register_number,'status'=>'Active','vendor_id'=>$vendor_id);
                    $vtbl = "tb_trucks_data";
                    $vehicle_details = $this->common->gettblrowdata($vwhr,$vslt,$vtbl,0,0);
                    if(count($vehicle_details)>0){
                        $vehicle_id = $vehicle_details['id'];
                    }else{
                        $vwhr = array('register_number'=>$register_number,'status'=>'Active');
                        $v1details = $this->common->gettblrowdata($vwhr,$vslt,$vtbl,0,0);
                        if(count($v1details) >0){
                            $vehicle_id = $v1details['id'];
                            $tablename = "tb_trucks_data";
                            $set = array("vendor_id"=>$vendor_id);
                            $whr = array('id'=>$vehicle_id);
                            $upd = $this->common->updatetbledata($tablename,$set,$whr);
                        }else{
                            $instable = "tb_trucks_data";
                            $insdata = array('truck_number'=>$register_number,'length'=>'0','breadth'=>'0','truck_capacity'=>'1','truck_type'=>'1','register_number'=>$register_number,'route'=>$register_number,'user_id'=>$user_id,'vendor_id'=>$vendor_id,'status'=>'Active','createdon'=>$logdate);
                            $vehicle_id = $this->common->insertTableData($instable,$insdata);
                        }
                    }
                    if($vehicle_id != 0){
                        if($driver != ""){
                            $dwhr = array('name'=>$driver);
                            $dslt = "id";
                            $dtbl = "tb_truck_drivers";
                            $driverdetails = $this->common->gettblrowdata($dwhr,$dslt,$dtbl,0,0);
                            if(count($driverdetails)>0){
                                $driver_id = $driverdetails['id'];
                            }else{
                                $dinstable = "tb_truck_drivers";
                                $pwd = RandomString::generate(10);
                                $password=password_hash($pwd, PASSWORD_DEFAULT);
                                $mobile = time();
                                $dinsdata = array('name'=>$driver,'password'=>$password,'contact_num'=>$mobile,'createdby'=>$user_id,'user_id'=>$user_id,'vendor_id'=>$vendor_id,'status'=>'Active','company_code'=>$company_code,'branch_code'=>$branch_code,'createdon'=>$logdate);
                                $driver_id = $this->common->insertTableData($dinstable,$dinsdata);
                            }
                        }
                        $sid = $order_id;
                        if($shipid != "" && $vendor_id > 0 && $order_id >0){
                            $where = array("id"=>$order_id);
                            $select = "*";
                            $table = "tb_orders";
                            $order = $this->common->gettblrowdata($where,$select,$table,0,0);
                            if(count($order)>0){
                                $shift_idchk = $order['shift_id'];
                                if($shift_idchk == 0){
                                    $whr = "oc.order_id = '$sid'";
                                    $stops_units = $this->Orderrevenuesmodel->checkhandlingunit_fororder($whr);
                                    $pickup = $order['pickup_address1'];
                                    if($pickup == ""){ $pickup = $order['pickup_city']; }
                                    $delivery = $order['delivery_address1'];
                                    if($delivery == ""){ $delivery = $order['delivery_city']; }
                                    $address = $dropaddr = "";
                                    if($order['pickup_address1'] != ""){
                                        $address .= $order['pickup_address1'];
                                        $dropaddr .= $order['delivery_address1'];
                                    }
                                    if($order['pickup_company'] != ""){
                                        $address .= ", ".$order['pickup_company'];
                                        $dropaddr .= ", ".$order['delivery_company'];
                                    }
                                    if($order['pickup_country'] != ""){
                                        $address .= ", ".$order['pickup_country'];
                                        $dropaddr .= ", ".$order['delivery_country'];
                                    }
                                    if($order['pickup_city'] != ""){
                                        $address .= ", ".$order['pickup_city'];
                                        $dropaddr .= ", ".$order['delivery_city'];
                                    }
                                    if($order['pickup_pincode'] != ""){
                                        $address .= ", ".$order['pickup_pincode'];
                                        $dropaddr .= ", ".$order['delivery_pincode'];
                                    }
                                    $plat = $order['plat'];
                                    $plng = $order['plng'];
                                    $dlat = $order['dlat'];
                                    $dlng = $order['dlng'];
                                    if($i == '0'){
                                        $where = array("shipmentid"=>$shipid);
                                        $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                        $table = "tb_shifts";
                                        $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);
                                        if(count($shipment)==0){
                                            $curdt = $logdate;
                                            $splace = $order['pickup_address1'];
                                            $eplace = $order['delivery_address1'];
                                            $pickup_city = $order['pickup_city'];
                                            $delivery_city = $order['delivery_city'];
                                            $customer_id = $order['customer_id'];
                                            $transport_mode= $order['transport_mode'];
                                            $weight= $order['weight'];
                                            $volume= $order['volume'];
                                            $txnid = $shipid;
                                            if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                                $vtwhere = array("id"=>$tpvehicle_type);
                                                $vtselect = "trucktype";
                                                $vttable = "tb_trucktypes";
                                                $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                                if(count($vtorder)>0){
                                                    $vehicle_type = $vtorder['trucktype'];
                                                }else{
                                                    $vehicle_type = $order['vehicle_type'];
                                                }
                                            }else{
                                                $vehicle_type = $order['vehicle_type'];
                                            }
                                            $startdate = $order['pickup_datetime'];
                                            $starttime = date('H:i',strtotime($startdate));
                                            $enddate = $order['delivery_datetime'];
                                            $endtime = date('H:i',strtotime($enddate));
                                            $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code, 'status'=>1);
                                            $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                                        }else{
                                            $ship_id = $shipment['id'];
                                        }
                                    }else{
                                        if($trip_forship == $trip_no && strtotime($pickup_forship) == strtotime($early_pickup) && $driver_forship == $driver && $vehicle_forship == $register_number && $vendor_forship == $vendor_code){
                                            $ship_id = $txnid = "0";
                                            $getshiftdata = $this->common->gettblrowdatasubusers(array('id'=>$order_forshift),"shift_id,shipmentid","tb_orders",0,0);
                                            if(!empty($getshiftdata)){
                                                $ship_id = $getshiftdata['shift_id'];
                                                $txnid   = $getshiftdata['shipmentid'];
                                            }
                                        }else{
                                            $j =$i;
                                            $booking_forship = $newlist[$j]['booking_id'];
                                            $seq_num = 000001;
                                            if($booking_forship != "" && $booking_forship != ''){
                                                $seq_num=substr($booking_forship, -6);
                                            }
                                            $shipid = $txnid= "T".$count_code.$week.$year.$seq_num;
                                            $where = array("shipmentid"=>$shipid);
                                            $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                            $table = "tb_shifts";
                                            $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);
                                            if(empty($shipment)){
                                                $curdt = $logdate;
                                                $splace = $order['pickup_address1'];
                                                $eplace = $order['delivery_address1'];
                                                $pickup_city = $order['pickup_city'];
                                                $delivery_city = $order['delivery_city'];
                                                $customer_id = $order['customer_id'];
                                                $transport_mode= $order['transport_mode'];
                                                $weight= $order['weight'];
                                                $volume= $order['volume'];
                                                $txnid = $shipid;
                                                if($tpvehicle_type!='' && $tpvehicle_type != 0){
                                                    $vtwhere = array("id"=>$tpvehicle_type);
                                                    $vtselect = "trucktype";
                                                    $vttable = "tb_trucktypes";
                                                    $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);
                                                    if(count($vtorder)>0){
                                                        $vehicle_type = $vtorder['trucktype'];
                                                    }else{
                                                        $vehicle_type = $order['vehicle_type'];
                                                    }
                                                }else{
                                                    $vehicle_type = $order['vehicle_type'];
                                                }
                                                $startdate = $order['pickup_datetime'];
                                                $starttime = date('H:i',strtotime($startdate));
                                                $enddate = $order['delivery_datetime'];
                                                $endtime = date('H:i',strtotime($enddate));
                                                $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>'Boxes', 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$txnid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$order['quantity'],'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$company_code,'branch_code'=>$branch_code, 'status'=>1);
                                                $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                                            }else{
                                                $ship_id = $shipment['id'];
                                            }
                                        }
                                    }
                                    $capacity = $order['weight'];
                                    if($capacity == ""){
                                        $capacity = "0";
                                    }
                                    $upddt = array('vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$txnid);
                                    $updwhr = array("id"=>$order_id);
                                    $upd = $this->common->updatetbledata("tb_orders",$upddt,$updwhr);
                                    $invtypes = makeorderinvolvedpartiestype($vendor_id,$order_id,"CARRIER", $userid, $company_code);
                                    $insarr = array('assoc_id'=>$txnid, 'pickup'=>$pickup, 'plat'=>$plat,
                                        'plng'=>$plng, 'drop'=>$delivery,'dlat'=>$dlat, 'dlng'=>$dlng,
                                        'pickup_city'=>$order['pickup_city'], 'drop_city'=>$order['delivery_city'],
                                        'pickup_datetime'=>$order['pickup_datetime'], 'drop_datetime'=>$order['delivery_datetime'],
                                        'name'=>'Boxes', 'phone'=>$order['customer_phone'],
                                        'address'=>$address,'emailid'=>$order['customer_email'],
                                        'user_id'=>$userid, 'status'=>1,
                                        'createdon'=>$curdt, 'material_id'=>0,
                                        'capacity'=>$capacity,
                                        'information'=>$order['customer_comments'],
                                        'shipment_weight'=>$order['weight'],
                                        'shipment_volume'=>$order['volume'],
                                        'ship_type'=>'P', 'customer_id'=>$order['customer_id'],
                                        'vendor_id'=>$vendor_id, 'shipment_id'=>0, 'startdate'=>$order['pickup_datetime'],
                                        'enddate'=>$order['delivery_datetime'], 'shift_id'=>$ship_id, 'stop_order'=>1,
                                        'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>0, 'drop_stopid'=>0, 'order_id'=>$order['order_id'],
                                        'pkgitemid'=>'BOXES', 'no_of_pkgs'=>$order['quantity'], 'domainname'=>'INFD');
                                    $detail_id = $this->common->insertTableData("tb_employee",$insarr);
                                    if($detail_id > 0 ){
                                        if($stops_units->num_rows()>1){
                                            $odata=$stops_units->row();
                                            $upd = $this->common->updatetbledata("tb_order_cargodetails",array('stop_detail_id'=>$detail_id),array('id'=>$odata->id));
                                        }
                                        /*update orders table*/
                                        $updwhr = array('id'=>$order_id);
                                        $setwhr = array('status'=>2);
                                        $ins = $this->db->where($updwhr)->update("tb_orders",$setwhr);
                                        /*insert stops records */
                                        $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'],"stoptype"=>"P");
                                        $select = "id";
                                        $table = "tb_shiporder_stops";
                                        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
                                        if(count($chkstop) == 0){
                                            $insarr = array('stopname'=>$order['pickup_city'], 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$order['pickup_city'], 'address'=>$address, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['delivery_datetime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
                                            $pickupstop_id = $this->common->insertTableData("tb_shiporder_stops",$insarr);
                                        }else{
                                            $pickupstop_id = $chkstop['id'];
                                        }
                                        $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D");
                                        $select = "id";
                                        $table = "tb_shiporder_stops";
                                        $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);
                                        if(count($chkstop) == 0){
                                            $insarr = array('stopname'=>$order['delivery_city'], 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$order['delivery_city'], 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$order['delivery_datetime'], 'enddate'=>$order['delivery_datetime'], 'weight'=>$order['weight'], 'volume'=>$order['volume'], 'shipmentstopid'=>0, 'ship_units'=>$order['quantity'], 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);
                                            $dropstop_id = $this->common->insertTableData("tb_shiporder_stops",$insarr);
                                        }else{
                                            $dropstop_id = $chkstop['id'];
                                        }
                                        $setarr = array('stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id);
                                        $setwhr = array('id'=>$detail_id);
                                        $upd = $this->db->where($setwhr)->update("tb_employee",$setarr);
                                        $chk1 = $this->common->gettblrowdata(array("shft_id"=>$ship_id),"id","tb_shft_veh",0,0);
                                        if(!empty($chk1)){
                                            $shftvehid = $chk1['id'];
                                            $chk = $this->common->gettblrowdata(array("shft_veh_id"=>$shftvehid,"status"=>1),"id","tb_shft_veh_emp",0,0);
                                            if(!empty($chk)){
                                                $getEmployeeData = $this->common->gettbldata(['shift_id' => $ship_id], "id,pickup_datetime,drop_datetime", "tb_employee", 0, 0);
                                                $priorityCounter = 1;
                                                foreach ($getEmployeeData as $eachEmployeeRow) {
                                                    $shiftVehicleData = [
                                                        "user_id" => $userid,
                                                        "shft_veh_id" => $shftvehid,
                                                        "emp_id" => $eachEmployeeRow['id'],
                                                        "priority" => $priorityCounter,
                                                        "pickup_time" => $eachEmployeeRow['pickup_datetime'],
                                                        'created_on' => $curdt,
                                                        'updated_on' => $curdt,
                                                        "status" => 1,
                                                        "drop_time" => $eachEmployeeRow['drop_datetime']
                                                    ];
                                                    $this->common->insertTableData("tb_shft_veh_emp", $shiftVehicleData);
                                                    $priorityCounter++;
                                                }
                                            }else{
                                                $chkemp = $this->common->gettbldata(array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),"id","tb_shft_veh_emp",0,0);
                                                if(!empty($chkemp)){
                                                    $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"priority"=>3,"pickup_time"=>$order['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$order['delivery_datetime']);
                                                    $ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);
                                                }
                                            }
                                        }else{
                                            if($vehicle_id != ""){
                                                $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                                                $arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$veh_num, 'status'=>1);
                                                $shftvehid = $this->common->insertTableData("tb_shft_veh",$arr);
                                                $getemp = $this->common->gettbldata(array("shift_id"=>$ship_id),"id,pickup_datetime,drop_datetime","tb_employee",0,0);
                                                if(!empty($getemp)){
                                                    $pri = 1;
                                                    foreach($getemp as $gt){
                                                        $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt['id'],"priority"=>$pri,"pickup_time"=>$gt['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt['drop_datetime']);
                                                        $ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);
                                                        $pri++;
                                                    }
                                                }
                                            }
                                            if($vehicle_id != "" && $driver_id != ""){
                                                $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id));
                                                if($chk->num_rows() >0){
                                                    if($driver_id == $chk->row()->driver_id){
                                                        $upd = $this->common->updatetbledata("tb_vehicles_drivers",array('status'=>'1'),array("id"=>$chk->row()->id));
                                                    }else{
                                                        $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                                                        $ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
                                                    }
                                                }else{
                                                    $arr = array('vehicle_id'=>$vehicle_id, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
                                                    $ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
                                                }
                                                $chk11 = $this->common->gettblrowdata(array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id), "id", "tbl_assigned_drivers", 0, 0);
                                                if(!empty($chk11)){
                                                    $upd = $this->common->updatetbledata("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt),array("id"=>$chk11['id']));
                                                }else{
                                                    $chk111 = $this->common->gettblrowdata(array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1), "id", "tbl_assigned_drivers", 0, 0);
                                                    if(empty($chk111)){
                                                        $ins = $this->common->insertTableData("tbl_assigned_drivers",array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$driver_id,"imei"=>"","from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt));
                                                    }else{
                                                        $upd = $this->common->updatetbledata("tbl_assigned_drivers",array("driver_id"=>$driver_id,'updated_on'=>$curdt),array("id"=>$chk111['id']));
                                                    }
                                                }
                                            }
                                        }
                                        $response = 1;
                                        /* update status */
                                        $chk = $this->common->gettblrowdata(array("shipment_id"=>$ship_id,"status_id"=>9), "id", "tb_stop_status", 0, 0);
                                        if(!empty($chk)){
                                            $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                            $logdate = date('Y-m-d H:i:s');
                                            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
                                            $curdt1 = $getactual['datetime'];
                                            $ins = array("shipment_id"=>$ship_id,"stop_id"=>0,"order_id"=>$order_id,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status"=>1,"status_code"=>"0100","reason"=>"Coming from E-Booking","createdon"=>$curdt1);
                                            $insqry = $this->common->insertTableData("tb_stop_status",$ins);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    public function chkpartytypes($data,$type)
    {
        $cdate = date('Y-m-d H:i:s');
        $party_master_id = $party_master_code = $party_type_id = 0;
        $user_id       = $this->session->userdata('user_id');
        $company_code  = $this->session->userdata('company_code');
        $branch_code   = $this->session->userdata('branch_code');
        $country_code  = $this->session->userdata( "usr_tzone" )['phone_code'];
        $year          = date( 'y' );
        $week          = date( 'W' );
        $gettypeid = $this->common->gettblrowdata(array('name'=>$type,'status'=>'1','company_code'=>$company_code),"id","tbl_party_types",0,0);
        if(!empty($gettypeid)){
            $party_type_id = $gettypeid['id'];
        }else{
            $gettypeids = $this->common->gettblrowdata(array('name'=>$type,'status'=>'1','company_code'=>$company_code),"id","tbl_party_types",0,0);
            if(!empty($gettypeids)){
                $party_type_id = $gettypeids['id'];
            }
        }
        if($data['code'] != ""){
            $chk_details = $this->common->gettblrowdata(array('code'=>$data['code'],'company_code'=>$company_code,'status'=>'1'),"id,code","tbl_party_master",0,0);
            if(!empty($chk_details)){
                $party_master_id   = $chk_details['id'];
                $party_master_code = $chk_details['code'];
            }else{
                $party_master_code = $data['code'];
                $insarr = array('party_type_id'=>$party_type_id,'name'=>$data['name'],'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$data['phone'],'user_id'=>$user_id,'code'=>$data['code'],'company_code'=>$company_code,'branch_code'=>$branch_code,'department_code'=>$data['department_code'],'location_id'=>$data['city'],'address'=>$data['address'],'country'=>$data['country'],'state'=>$data['state'],'street'=>$data['street'],'pincode'=>$data['pincode'],'status'=>'1','created_on'=>$cdate);
                $party_master_id    = $this->common->insertTableData( "tbl_party_master", $insarr );
            }
        }else{
            $chk_details = $this->common->gettblrowdata(array('name'=>$data['name'],'location_id'=>$data['city'],'state'=>$data['state'],'country'=>$data['country'],'street'=>$data['street'],'pincode'=>$data['pincode'],'company_code'=>$company_code,'status'=>'1'),"id,code","tbl_party_master",0,0);
            if(!empty($chk_details)){
                $party_master_id   = $chk_details['id'];
                $party_master_code = $chk_details['code'];
            }else{
                $insarr = array('party_type_id'=>$party_type_id,'name'=>$data['name'],'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$data['phone'],'user_id'=>$user_id,'code'=>'0','company_code'=>$company_code,'branch_code'=>$branch_code,'department_code'=>$data['department_code'],'location_id'=>$data['city'],'address'=>$data['address'],'country'=>$data['country'],'state'=>$data['state'],'street'=>$data['street'],'pincode'=>$data['pincode'],'status'=>'1','created_on'=>$cdate);
                $party_master_id    = $this->common->insertTableData( "tbl_party_master", $insarr );
                $party_master_code  = $country_code . $year . $week . $party_master_id;
                $upd                = $this->common->updatetbledata( "tbl_party_master", array('code'=>$party_master_code), array('id'=>$party_master_id) );
            }
        }
        $info = array('party_master_id'=>$party_master_id,'party_master_code'=>$party_master_code,'party_type_id'=>$party_type_id);
        return $info;
    }

    public function cladddata(){
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $curtz        = $this->session->userdata("usr_tzone")['timezone'];
        ini_set("max_input_time",2000);
        ini_set("max_execution_time",2000);
        ini_set("max_input_vars",20000);
        ini_set("upload_max_size","2048M");
        ini_set("post_max_size",0);
        ini_set("memory_limit","2048M");
        $all_data = array();
        $data =  $errorline= $message  = $order_details = array();
        if (isset($_FILES['import_file'])) {
            $ext = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            $value = [];
            $val = [];
            if ($ext == "xls" || $ext == "xlsx") {
                $path = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arr_data"]=array();
                foreach ($cell_collection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    $newdtat[] = $column;
                    if ($row == 1) {
                        $data["header"][$row][$column] = $data_value;
                    } else if($row > 1){
                        $data["arr_data"][$row][$column] = $data_value;
                    }
                }
                $row = 3;
                $arr=[];
                $sno="";
                foreach ($data["arr_data"] as $value[$row]) {
                    $dno1          = isset($value[$row]['A']) ? $value[$row]['A'] : "";
                    $custid        = isset($value[$row]['D']) ? $value[$row]['D'] : "";
                    $delivery_note = $dno1.$custid;
                    if($sno != $delivery_note){
                        if($delivery_note != ""){
                            $sno                = $delivery_note;
                            $value[$row]['row'] = $row;
                            $arr[$sno][]        = $value[$row];
                            $row++;
                        }else{
                            $value[$row]['row'] = $row;
                            $arr[$sno][]        = $value[$row];
                            $row++;
                        }
                    }else{
                        $value[$row]['row']     = $row;
                        $arr[$sno][]            = $value[$row];
                        $row++;
                    }
                }
                $arrdata = array();
                if(!empty($arr)){
                    foreach($arr as $ar){
                        $arrdata[] = $ar;
                    }
                }
                if (!empty($arrdata)) {
                    for ($i = 0, $iMax = count($arrdata); $i < $iMax; $i++) {
                        $rowno = $arrdata[$i]['0']['row'] ?? "";
                        $mainrowno = $rowno;
                        $delivery_note = $arrdata[$i]['0']['A'] ?? "";
                        $trip_seq = $arrdata[$i]['0']['B'] ?? "";
                        $trip_maxseq = $arrdata[$i]['0']['C'] ?? "";
                        $customer_id = $arrdata[$i]['0']['D'] ?? "";
                        $service = $arrdata[$i]['0']['E'] ?? "";
                        $customer_ref = $arrdata[$i]['0']['F'] ?? "";
                        $vehicle = $arrdata[$i]['0']['G'] ?? "";
                        $driver = $arrdata[$i]['0']['H'] ?? "";
                        $carrier = $arrdata[$i]['0']['I'] ?? "";
                        $pickup_date = $arrdata[$i]['0']['J'] ?? "";
                        $pickup_time = $arrdata[$i]['0']['K'] ?? "";
                        $pickup_id = $arrdata[$i]['0']['L'] ?? "";
                        $pickup_name = $arrdata[$i]['0']['M'] ?? "";
                        $pickup_number = $arrdata[$i]['0']['N'] ?? "";
                        $pickup_street = $arrdata[$i]['0']['O'] ?? "";
                        $pickup_city = $arrdata[$i]['0']['P'] ?? "";
                        $pickup_state = $arrdata[$i]['0']['Q'] ?? "";
                        $pickup_postalcode = $arrdata[$i]['0']['R'] ?? "";
                        $pickup_country = $arrdata[$i]['0']['S'] ?? "";
                        $delivery_date = $arrdata[$i]['0']['T'] ?? "";
                        $delivery_time = $arrdata[$i]['0']['U'] ?? "";
                        $delivery_code = $arrdata[$i]['0']['V'] ?? "";
                        $delivery_name = $arrdata[$i]['0']['W'] ?? "";
                        $delivery_number = $arrdata[$i]['0']['X'] ?? "";
                        $delivery_street = $arrdata[$i]['0']['Y'] ?? "";
                        $delivery_city = $arrdata[$i]['0']['Z'] ?? "";
                        $delivery_state = $arrdata[$i]['0']['AA'] ?? "";
                        $delivery_postalcode = $arrdata[$i]['0']['AB'] ?? "";
                        $delivery_country = $arrdata[$i]['0']['AC'] ?? "";
                        $weight = $arrdata[$i]['0']['AD'] ?? "";
                        $volume = $arrdata[$i]['0']['AE'] ?? "";
                        $carton = $arrdata[$i]['0']['AF'] ?? "";
                        if ($carton == "") {
                            $carton = "BOX";
                        }
                        $quantity = $arrdata[$i]['0']['AG'] ?? "";
                        $validateValues = [
                            'quantity' => [
                                'message' => 'Quantity ',
                                'value' => $quantity,
                            ],
                            'delivery_note' => [
                                'message' => 'Delivery Note ',
                                'value' => $delivery_note,
                            ],
                            'journey_sequence' => [
                                'message' => 'Journey Sequence ',
                                'value' => $trip_seq,
                            ],
                            'journey_maxsequence' => [
                                'message' => 'Journey Max. Sequence ',
                                'value' => $trip_maxseq,
                            ],
                            'customer_id' => [
                                'message' => 'Customer ID ',
                                'value' => $customer_id,
                            ],
                            'service' => [
                                'message' => 'Service ',
                                'value' => $service,
                            ],
                            'customer_ref' => [
                                'message' => 'Customer Reference ',
                                'value' => $customer_ref,
                            ],
                            'vehicle' => [
                                'message' => 'Vehicle ',
                                'value' => $vehicle,
                            ],
                            'driver' => [
                                'message' => 'Driver ',
                                'value' => $driver,
                            ],
                            'carrier' => [
                                'message' => 'Carrier ',
                                'value' => $carrier,
                            ],
                            'pickup_date' => [
                                'message' => 'Pickup Date ',
                                'value' => $pickup_date,
                            ],
                            'pickup_time' => [
                                'message' => 'Pickup Time ',
                                'value' => $pickup_time,
                            ],
                            'pickup_id' => [
                                'message' => 'Pickup ID ',
                                'value' => $pickup_id,
                            ],
                            'pickup_name' => [
                                'message' => 'Pickup Name ',
                                'value' => $pickup_name,
                            ],
                            'pickup_number' => [
                                'message' => 'Pickup Number ',
                                'value' => $pickup_number,
                            ],
                            'pickup_street' => [
                                'message' => 'Pickup Street ',
                                'value' => $pickup_street,
                            ],
                            'pickup_city' => [
                                'message' => 'Pickup City ',
                                'value' => $pickup_city,
                            ],
                            'pickup_state' => [
                                'message' => 'Pickup State ',
                                'value' => $pickup_state,
                            ],
                            'pickup_postalcode' => [
                                'message' => 'Pickup Postal Code ',
                                'value' => $pickup_postalcode,
                            ],
                            'pickup_country' => [
                                'message' => 'Pickup Country ',
                                'value' => $pickup_country,
                            ],
                            'delivery_date' => [
                                'message' => 'Delivery Date ',
                                'value' => $delivery_date,
                            ],
                            'delivery_time' => [
                                'message' => 'Delivery Time ',
                                'value' => $delivery_time,
                            ],
                            'delivery_code' => [
                                'message' => 'Delivery Code ',
                                'value' => $delivery_code,
                            ],
                            'delivery_name' => [
                                'message' => 'Delivery Name ',
                                'value' => $delivery_name,
                            ],
                            'delivery_number' => [
                                'message' => 'Delivery Number ',
                                'value' => $delivery_number,
                            ],
                            'delivery_street' => [
                                'message' => 'Delivery Street ',
                                'value' => $delivery_street,
                            ],
                            'delivery_city' => [
                                'message' => 'Delivery City ',
                                'value' => $delivery_city,
                            ],
                            'delivery_state' => [
                                'message' => 'Delivery State ',
                                'value' => $delivery_state,
                            ],
                            'delivery_postalcode' => [
                                'message' => 'Delivery Postal Code ',
                                'value' => $delivery_postalcode,
                            ],
                            'delivery_country' => [
                                'message' => 'Delivery Country ',
                                'value' => $delivery_country,
                            ],
                            'weight' => [
                                'message' => 'Weight ',
                                'value' => $weight,
                            ],
                            'volume' => [
                                'message' => 'Volume ',
                                'value' => $volume,
                            ],
                        ];
                        foreach ($validateValues as $key => $values) {
                            if ($values['value'] == "" || !is_numeric($values['value'])) {
                                $message[] = $values['message'] .'empty on line: '. $rowno;
                                $errorLine[] = $key . $rowno;
                            }
                        }
                        $edate = date('Y-m-d');
                        $current_date = $date  = date('d');
                        $current_mnth = $month = date('m');
                        $current_year = $year  = date('Y');
                        if($pickup_date != ""){
                            if(strlen($pickup_date) == '8'){
                                $div_dates = str_split($pickup_date,4);
                                if(!empty($div_dates)){
                                    $year =isset($div_dates[0]) ? $div_dates[0] : $current_year;
                                    $divdates = isset($div_dates[1]) ? $div_dates[1] : "";
                                    if(strlen($divdates) == '4'){
                                        $second_divs = str_split($divdates,2);
                                        $month = isset($second_divs[0]) ? $second_divs[0] : $current_mnth;
                                        $date  = isset($second_divs[1]) ? $second_divs[1] : $current_date;
                                        $edate = $year."-".$month."-".$date;
                                    }
                                }
                            }

                        }
                        $current_time = $early_ptime = date('H:i:s');
                        if(strlen($pickup_time) == '4'){
                            $div_times = str_split($pickup_time,2);
                            $hour = isset($div_times[0]) ? $div_times[0] : "";
                            $minutes = isset($div_times[1]) ? $div_times[1] : "";
                            $early_ptime = $hour.":".$minutes.":00";
                        }
                        $early_pickup = $edate . " " . $early_ptime;
                        $late_pickup = date( 'Y-m-d H:i:s', strtotime( '+1 hour', strtotime( $early_pickup ) ) );
                        $ddate = date('Y-m-d',strtotime('+3 days',strtotime(date('Y-m-d'))));
                        if($delivery_date != ""){
                            if(strlen($delivery_date) == '8'){
                                $div_dates = str_split($delivery_date,4);
                                if(!empty($div_dates)){
                                    $dyear =isset($div_dates[0]) ? $div_dates[0] : $current_year;
                                    $divdates = isset($div_dates[1]) ? $div_dates[1] : "";
                                    if(strlen($divdates) == '4'){
                                        $second_divs = str_split($divdates,2);
                                        $dmonth = isset($second_divs[0]) ? $second_divs[0] : $current_mnth;
                                        $didate  = isset($second_divs[1]) ? $second_divs[1] : $current_date;
                                        $ddate = $dyear."-".$dmonth."-".$didate;
                                    }
                                }
                            }

                        }
                        $early_dtime = date('H:i:s');
                        if(strlen($delivery_time) == '4'){
                            $div_times = str_split($delivery_time,2);
                            $hour = isset($div_times[0]) ? $div_times[0] : "";
                            $minutes = isset($div_times[1]) ? $div_times[1] : "";
                            $early_ptime = $hour.":".$minutes.":00";
                        }
                        $early_delivery = $ddate . " " . $early_ptime;
                        $late_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($early_delivery)));
                        $order_details[] = [
                            'delivery_note' => $delivery_note,
                            'trip_no' => $trip_seq,
                            'trip_maxseq' => $trip_maxseq,
                            'customer_id' => $customer_id,
                            'service' => $service,
                            'customer_ref' => $customer_ref,
                            'vehicle_no' => $vehicle,
                            'driver' => $driver,
                            'carrier' => $carrier,
                            'pickup_date' => $pickup_date,
                            'pickup_time' => $pickup_time,
                            'pickup_id' => $pickup_id,
                            'pickup_name' => $pickup_name,
                            'pickup_phone' => $pickup_number,
                            'pickup_street' => $pickup_street,
                            'pickup_city' => $pickup_city,
                            'pickup_state' => $pickup_state,
                            'pickup_pincode' => $pickup_postalcode,
                            'pickup_country' => $pickup_country,
                            'delivery_date' => $delivery_date,
                            'delivery_time' => $delivery_time,
                            'drop_id' => $delivery_code,
                            'drop_name' => $delivery_name,
                            'drop_phone' => $delivery_number,
                            'drop_street' => $delivery_street,
                            'drop_city' => $delivery_city,
                            'drop_state' => $delivery_state,
                            'drop_pincode' => $delivery_postalcode,
                            'drop_country' => $delivery_country,
                            'weight' => $weight,
                            'volume' => $volume,
                            'cargo_type' => $carton,
                            'quantity' => $quantity,
                            'early_pickup' => $early_pickup,
                            'late_pickup' => $late_pickup,
                            'early_drop' => $early_delivery,
                            'late_drop' => $late_delivery,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'rowno' => $rowno
                        ];
                    }
                }
            }
        }
        $data['errorline']     = $errorline;
        $data["message"]       = $message;
        $data["order_details"] = $order_details;
        $data["page_title"]    = "Import Orders";
        $this->settemplate->dashboard("orders/climport",$data);
    }

    public function uploadmilkrunexcel(): void
    {
        ini_set("max_input_time", 2000);
        ini_set("max_execution_time", 2000);
        ini_set("max_input_vars", 20000);
        ini_set("upload_max_size", "2048M");
        ini_set("post_max_size", 0);
        ini_set("memory_limit", "2048M");
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $data = $errorLine = $message = $finalData = $allShipperCodes = $allConsigneeCodes = $shipperConsigneeDetails = $allShipperConsigneeCodes = $pickupDetails = $deliveryDetails = $value = $data["finalData"] = $checkvalues = [];
        if (isset($_FILES['import_file'])) {
            $extension = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            if ($extension === "xls" || $extension === "xlsx") {
                $path = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cellCollection = $objPHPExcel->getActiveSheet()->getCellCollection();
                foreach ($cellCollection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $dataValue = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    if ($row == 1) {
                        $data["header"][$row][$column] = $dataValue;
                    } elseif ($row > 1) {
                        $data['finalData'][$row][$column] = $dataValue;
                    }
                }
                $data['order_details'] = [];
                $row = 3;
                $excelData = [];
                $checkDeliveryNote = "";
                foreach ($data['finalData'] as $value[$row]) {
                    $deliveryNote = $value[$row]['I'] ?? "";
                    if ($checkDeliveryNote != $deliveryNote) {
                        if ($deliveryNote != "") {
                            $checkDeliveryNote = $deliveryNote;
                            $value[$row]['row'] = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        } else {
                            $value[$row]['row'] = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        }
                    } else {
                        $value[$row]['row'] = $row;
                        $excelData[$checkDeliveryNote][] = $value[$row];
                        $row++;
                    }
                }
                if (!empty($excelData)) {
                    foreach ($excelData as $eachArray) {
                        $allShipperCodes[] = $eachArray['0']['B'] ?? "";
                        $allConsigneeCodes[] = $eachArray['0']['D'] ?? "";
                        $finalData[] = $eachArray;
                    }
                }
                if (!empty($allShipperCodes)) {
                    $getAllPickupDetails = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,location_id,country,state,street,pincode,party_types,latitude,longitude,fax FROM tbl_party_master where code IN ? AND company_code LIKE ? AND status =?", [$allShipperCodes, $companyCode, 1]);
                    foreach ($getAllPickupDetails->result_array() as $eachData) {
                        $pickupDetails[$eachData['code']] = [
                            'id' => $eachData['id'],
                            'name' => $eachData['name'],
                            'email' => $eachData['email'],
                            'mobile' => $eachData['mobile'],
                            'code' => $eachData['code'],
                            'city' => $eachData['location_id'],
                            'country' => $eachData['country'],
                            'state' => $eachData['state'],
                            'street' => $eachData['street'],
                            'pincode' => $eachData['pincode'],
                            'fax' => $eachData['fax'],
                            'party_type_id' => $eachData['party_type_id'],
                            'latitude' => $eachData['latitude'],
                            'longitude' => $eachData['longitude']
                        ];
                    }
                }
                if (!empty($allConsigneeCodes)) {
                    $getAllDeliveryDetails = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,location_id,country,state,street,pincode,party_types,latitude,longitude,fax FROM tbl_party_master where code IN ? AND company_code LIKE ? AND status =?", [$allConsigneeCodes, $companyCode, 1]);
                    foreach ($getAllDeliveryDetails->result_array() as $eachData) {
                        $deliveryDetails[$eachData['code']] = [
                            'id' => $eachData['id'],
                            'name' => $eachData['name'],
                            'email' => $eachData['email'],
                            'mobile' => $eachData['mobile'],
                            'code' => $eachData['code'],
                            'city' => $eachData['location_id'],
                            'country' => $eachData['country'],
                            'state' => $eachData['state'],
                            'street' => $eachData['street'],
                            'pincode' => $eachData['pincode'],
                            'fax' => $eachData['fax'],
                            'party_type_id' => $eachData['party_type_id'],
                            'latitude' => $eachData['latitude'],
                            'longitude' => $eachData['longitude']
                        ];
                    }
                }
                if (!empty($finalData)) {
                    for ($i = 0, $iMax = count($finalData); $i < $iMax; $i++) {
                        $data['cargo_details'] = $data['reference'] = [];
                        $rowNumber = $finalData[$i]['0']['row'] ?? "";
                        $mainRowNumber = $rowNumber;
                        $service = $finalData[$i]['0']['A'] ?? "";
                        $checkvalues[] = ['value' => $service, 'message' => 'Service empty on line: ' . $rowNumber, 'errorline' => 'service' . $rowNumber];
                        $shipperCode = $finalData[$i]['0']['B'] ?? "";
                        $checkvalues[] = ['value' => $shipperCode, 'message' => 'Shipper Code empty on line: ' . $rowNumber, 'errorline' => 'shipper_id' . $rowNumber];
                        $customerCode = $finalData[$i]['0']['C'] ?? "";
                        $checkvalues[] = ['value' => $customerCode, 'message' => 'Customer Code empty on line: ' . $rowNumber, 'errorline' => 'customer_id' . $rowNumber];
                        $consigneeCode = $finalData[$i]['0']['D'] ?? "";
                        $checkvalues[] = ['value' => $consigneeCode, 'message' => 'Consignee Code empty on line: ' . $rowNumber, 'errorline' => 'consignee_id' . $rowNumber];

                        $divisionReference = $finalData[$i]['0']['E'] ?? "";
                        $checkvalues[] = ['value' => $divisionReference, 'message' => 'Div Ref empty on line: ' . $rowNumber, 'errorline' => 'reference_value' . $rowNumber];
                        $date = $finalData[$i]['0']['F'] ?? "";
                        $dateCycle = $finalData[$i]['0']['G'] ?? "";
                        $deliveryNote = $finalData[$i]['0']['I'] ?? "";
                        $checkvalues[] = ['value' => $deliveryNote, 'message' => 'Delivery Note empty on line: ' . $rowNumber, 'errorline' => 'delivery_note' . $rowNumber];
                        $departmentName = $finalData[$i]['0']['K'] ?? "";
                        $checkvalues[] = ['value' => $departmentName, 'message' => 'Department Name empty on line: ' . $rowNumber, 'errorline' => 'dept_name' . $rowNumber];
                        $quantity = $finalData[$i]['0']['L'] ?? "";
                        $checkvalues[] = ['value' => $quantity, 'message' => 'Quantity empty on line: ' . $rowNumber, 'errorline' => 'quantity' . $rowNumber];
                        $package = $finalData[$i]['0']['M'] ?? "";
                        $checkvalues[] = ['value' => $package, 'message' => 'Package empty on line: ' . $rowNumber, 'errorline' => 'cargo_type' . $rowNumber];
                        $tripNumber = $finalData[$i]['0']['N'] ?? "";
                        $checkvalues[] = ['value' => $tripNumber, 'message' => 'Trip No empty on line: ' . $rowNumber, 'errorline' => 'trip_no' . $rowNumber];
                        $route = $finalData[$i]['0']['O'] ?? "";
                        $checkvalues[] = ['value' => $route, 'message' => 'Route empty on line: ' . $rowNumber, 'errorline' => 'route' . $rowNumber];
                        $driver = $finalData[$i]['0']['P'] ?? "";
                        $checkvalues[] = ['value' => $driver, 'message' => 'Driver empty on line: ' . $rowNumber, 'errorline' => 'driver' . $rowNumber];
                        $vehicleNumber = $finalData[$i]['0']['Q'] ?? "";
                        $checkvalues[] = ['value' => $vehicleNumber, 'message' => 'Vehicle Number empty on line: ' . $rowNumber, 'errorline' => 'vehicle_no' . $rowNumber];
                        $carrier = $finalData[$i]['0']['R'] ?? "";
                        $checkvalues[] = ['value' => $carrier, 'message' => 'Carrier empty on line: ' . $rowNumber, 'errorline' => 'carrier' . $rowNumber];
                        foreach ($checkvalues as $res) {
                            if ($res['value'] == "") {
                                $message[] = $res['message'];
                                $errorLine[] = $res['errorline'];
                            }
                        }
                        $pickupId = $pickupDetails[$shipperCode]['code'] ?? '';
                        $pickupRowId = $pickupDetails[$shipperCode]['id'] ?? 0;
                        $pickupName = $pickupDetails[$shipperCode]['name'] ?? '';
                        $pickupCity = $pickupDetails[$shipperCode]['city'] ?? '';
                        $pickupStreet = $pickupDetails[$shipperCode]['street'] ?? '';
                        $pickupState = $pickupDetails[$shipperCode]['state'] ?? '';
                        $pickupCountry = $pickupDetails[$shipperCode]['country'] ?? '';
                        $pickupPincode = $pickupDetails[$shipperCode]['pincode'] ?? '';
                        $pickupPhone = $pickupDetails[$shipperCode]['mobile'] ?? '';
                        $pickupFax = $pickupDetails[$shipperCode]['fax'] ?? '';
                        $pickupEmail = $pickupDetails[$shipperCode]['email'] ?? '';
                        $pickupLatitude = $pickupDetails[$shipperCode]['latitude'] ?? '';
                        $pickupLongitude = $pickupDetails[$shipperCode]['longitude'] ?? '';

                        $dropId = $deliveryDetails[$consigneeCode]['code'] ?? '';
                        $dropRowId = $deliveryDetails[$consigneeCode]['id'] ?? '';
                        $dropName = $deliveryDetails[$consigneeCode]['name'] ?? '';
                        $dropStreet = $deliveryDetails[$consigneeCode]['street'] ?? '';
                        $dropCity = $deliveryDetails[$consigneeCode]['city'] ?? '';
                        $dropState = $deliveryDetails[$consigneeCode]['state'] ?? '';
                        $dropCountry = $deliveryDetails[$consigneeCode]['country'] ?? '';
                        $dropPincode = $deliveryDetails[$consigneeCode]['pincode'] ?? '';
                        $dropPhone = $deliveryDetails[$consigneeCode]['mobile'] ?? '';
                        $dropFax = $deliveryDetails[$consigneeCode]['fax'] ?? '';
                        $dropEmail = $deliveryDetails[$consigneeCode]['email'] ?? '';
                        $dropLatitude = $deliveryDetails[$consigneeCode]['latitude'] ?? '';
                        $dropLongitude = $deliveryDetails[$consigneeCode]['longitude'] ?? '';

                        $data['reference'] = [];
                        if ($divisionReference != "") {
                            $data['reference'][] = ['reference_id' => 'Div', 'reference_name' => 'Division', 'reference_value' => $divisionReference, 'rowno' => $rowNumber];
                        }
                        $stackable = 'off';
                        $data['cargo_details'][] = ['cargo_type' => $package, 'goods_description' => '', 'length' => '1', 'width' => '1', 'height' => '1', 'weight' => '1', 'quantity' => $quantity, 'volume' => '1', 'stackable' => $stackable, 'rowno' => $rowNumber];
                        $data['order_details'][] = [
                            'service' => $service,
                            'customer_id' => $customerCode,
                            'shipper_code' => $shipperCode,
                            'consignee_code' => $consigneeCode,
                            'div_ref' => $divisionReference,
                            'date' => $date,
                            'date_cycle' => $dateCycle,
                            'delivery_note' => $deliveryNote,
                            'quantity' => $quantity,
                            'package' => $package,
                            'pickup_id' => $pickupId,
                            'pickup_name' => $pickupName,
                            'pickup_street' => $pickupStreet,
                            'pickup_city' => $pickupCity,
                            'pickup_state' => $pickupState,
                            'pickup_country' => $pickupCountry,
                            'pickup_pincode' => $pickupPincode,
                            'early_pickup' => "",
                            'late_pickup' => "",
                            'pickup_phone' => $pickupPhone,
                            'pickup_fax' => $pickupFax,
                            'pickup_email' => $pickupEmail,
                            'pickup_row_id' => $pickupRowId,
                            'drop_id' => $dropId,
                            'drop_name' => $dropName,
                            'drop_street' => $dropStreet,
                            'drop_city' => $dropCity,
                            'drop_state' => $dropState,
                            'drop_country' => $dropCountry,
                            'drop_pincode' => $dropPincode,
                            'early_drop' => "",
                            'late_drop' => "",
                            'drop_phone' => $dropPhone,
                            'drop_fax' => $dropFax,
                            'drop_email' => $dropEmail,
                            'drop_row_id' => $dropRowId,
                            'rowno' => $mainRowNumber,
                            'company_code' => $companyCode,
                            'branch_code' => $branchCode,
                            'department_code' => '',
                            'reference' => $data['reference'],
                            'cargo_details' => $data['cargo_details'],
                            'involved_parties' => [],
                            'vehicle_no' => $vehicleNumber,
                            'carrier' => $carrier,
                            'driver' => $driver,
                            'route' => $route,
                            'trip_no' => $tripNumber,
                            'dept_name' => $departmentName,
                            'pickup_latitude' => $pickupLatitude,
                            'pickup_longitude' => $pickupLongitude,
                            'drop_latitude' => $dropLatitude,
                            'drop_longitude' => $dropLongitude,
                        ];
                    }
                }
            }
        }
        $data['errorline'] = $errorLine;
        $data["message"] = $message;
        $data["page_title"] = "Import Orders";
        $this->settemplate->dashboard("orders/milkrun", $data);
    }

    public function addorderswithtripsdata(): void
    {
        $orders = $excelFailOrders = $ordersList = $dummyArray = $customersList = $allCustomers = [];
        $j = 0;
        $companyCode = $this->session->userdata('company_code');
        if (!empty($_POST['orders'])) {
            for ($i = 0, $iMax = count($_POST['orders']); $i < $iMax; $i++) {
                $firstCustomer = $_POST['orders'][$i]['customer_id'] ?? "";
                $firstPickup = $_POST['orders'][$i]['pickup_id'] ?? "";
                $firstDrop = $_POST['orders'][$i]['drop_id'] ?? "";
                $firstTripNumber = $_POST['orders'][$i]['trip_no'] ?? "";
                if (!in_array($_POST['orders'][$i]['delivery_note'], $dummyArray, true)) {
                    for ($k = 0, $kMax = count($_POST['orders']); $k < $kMax; $k++) {
                        $currentCustomer = $_POST['orders'][$k]['customer_id'] ?? "";
                        $currentPickup = $_POST['orders'][$k]['pickup_id'] ?? "";
                        $currentDrop = $_POST['orders'][$k]['drop_id'] ?? "";
                        $currentTripNumber = $_POST['orders'][$k]['trip_no'] ?? "";
                        if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop && $firstTripNumber == $currentTripNumber) {
                            $ordersList[] = $_POST['orders'][$k] ?? "";
                            $customersList[] = $_POST['orders'][$k]['customer_id'] ?? "";
                            $dummyArray[] = $_POST['orders'][$k]['delivery_note'] ?? "";
                        }
                    }
                }
            }
        }
        if (!empty($customersList)) {
            $getCustomerDetails = $this->db->query("SELECT id,code FROM tb_customers where code IN ? AND company_code LIKE ? AND status =? ORDER BY id DESC", [$customersList, $companyCode, '1']);
            foreach ($getCustomerDetails->result_array() as $singleCustomer) {
                $allCustomers[$singleCustomer['code']] = $singleCustomer['id'];
            }
        }
        $shipperTypeId = $partyTypeId = 0;
        $getAllPartyTypesIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND status =? AND company_code LIKE ? GROUP BY name", [['Shipper', 'Consignee'], 1, $companyCode]);
        foreach ($getAllPartyTypesIds->result_array() as $eachLine) {
            $partyTypeName = strtoupper($eachLine['name']);
            if ($partyTypeName == "SHIPPER") {
                $shipperTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "CONSIGNEE") {
                $partyTypeId = $eachLine['id'];
            }
        }
        if (!empty($ordersList)) {
            for ($i = 0, $iMax = count($ordersList); $i < $iMax; $i++) {
                $ordersList[$i]['shipper_type_id'] = $shipperTypeId;
                $ordersList[$i]['party_type_id'] = $partyTypeId;
                $data = $ordersList[$i];
                $firstCustomer = $ordersList[$j]['customer_id'] ?? "";
                $firstPickup = $ordersList[$j]['pickup_id'] ?? "";
                $firstDrop = $ordersList[$j]['drop_id'] ?? "";
                $firstCustomerReference = $ordersList[$j]['delivery_note'] ?? "";
                $firstTripNumber = $ordersList[$j]['trip_no'] ?? "";
                $currentTripNumber = $ordersList[$i]['trip_no'] ?? "";
                if ($i == '0') {
                    $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                    if (!empty($ordersData)) {
                        $orders[] = $ordersData['orders'] ?? [];
                        $excelFailOrders = $ordersData['excel_forders'] ?? [];
                    }
                } else {
                    $currentCustomer = $ordersList[$i]['customer_id'] ?? "";
                    $currentPickup = $ordersList[$i]['pickup_id'] ?? "";
                    $currentDrop = $ordersList[$i]['drop_id'] ?? "";
                    $currentCustomerReference = $ordersList[$i]['delivery_note'] ?? "";
                    $currentDepartmentName = $ordersList[$i]['deptname'] ?? "";
                    if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop) {
                        if ($firstTripNumber == $currentTripNumber) {
                            $currentCargo = $ordersList[$i]['cargo_details'] ?? [];
                            $this->updatecust_reffororder($firstCustomerReference, $currentCustomerReference, $currentDepartmentName, $currentCargo);
                        } else {
                            $j = $i;
                            $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                            if (!empty($ordersData)) {
                                $orders[] = $ordersData['orders'] ?? [];
                                $excelFailOrders = $ordersData['excel_forders'] ?? [];
                            }
                        }
                    } else {
                        $j = $i;
                        $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                        if (!empty($ordersData)) {
                            $orders[] = $ordersData['orders'] ?? [];
                            $excelFailOrders = $ordersData['excel_forders'] ?? [];
                        }
                    }
                }
            }
        }
        $excelSuccessOrders = $this->tripordershipment($orders);
        if (!empty($excelFailOrders) && !empty($excelSuccessOrders)) {
            $excelOrders = array_merge($excelFailOrders, $excelSuccessOrders);
        } else {
            if (!empty($excelSuccessOrders)) {
                $excelOrders = $excelSuccessOrders;
            } else {
                if (!empty($excelFailOrders)) {
                    $excelOrders = $excelFailOrders;
                }
            }
        }
        if (!empty($excelOrders)) {
            @file_put_contents(
                $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/ordertemplate/clexceluploaddata.txt",
                json_encode($excelOrders)
            );
        }
        redirect('orders/orderslist/02');
    }

    public function insertcust_reffororder($data, $allCustomers): array
    {
        $userId = $this->session->userdata('user_id');
        $companyCode = $data['company_code'] ?? "";
        $branchCode = $data['branch_code'] ?? "";
        $shipmentNumber = $data['delivery_note'] ?? "";
        $deliveryNote = $shipmentNumber;
        $checkDeliveryNote = $this->db->query("SELECT r.id FROM tb_order_references r,tb_orders o WHERE r.reference_id LIKE ? AND r.ref_value = ? AND r.status =? AND r.order_id=o.id AND o.status > ? AND o.user_id = ?", ['DQ', $deliveryNote, 1, 0, $userId]);
        if ($checkDeliveryNote->num_rows() > 0) {
            return [];
        }
        $noBookingIds = $excelFailOrders = [];
        $departmentode = $data['department_code'] ?? "";
        $service = $data['service'] ?? "";
        if ($companyCode == "") {
            $companyCode = $this->session->userdata("company_code");
        }
        if ($branchCode == "") {
            $branchCode = $this->session->userdata("branch_code");
        }
        $serviceId = $product = $incoterm = "";
        if ($service != "") {
            $serviceId = $this->bpartners->getServiceForMDTExcel($service, $companyCode, $branchCode);
        }
        $earlyPickup = $data['early_pickup'] ?? "";
        $latePickup = $data['late_pickup'] ?? "";
        $earlyDelivery = $data['early_drop'] ?? "";
        $lateDelivery = $data['late_drop'] ?? "";
        $customerId = $data['customer_id'] ?? "";
        $tripNumber = $data['trip_no'] ?? "";
        $route = $data['route'] ?? "";
        $driver = $data['driver'] ?? "";
        $vehcileNumber = $data['vehicle_no'] ?? "";
        $carrier = $data['carrier'] ?? "";
        $departmentName = $data['deptname'] ?? "";
        $customerRowId = 0;
        if ($customerId != "") {
            $customerRowId = $allCustomers[$customerId] ?? 0;
            if ($customerRowId == 0) {
                $getcustomerid = $this->db->query("SELECT id FROM tb_customers WHERE code LIKE ? AND company_code LIKE ? AND status = ? ORDER BY id DESC", [$customerId, $companyCode, 1]);
                if ($getcustomerid->num_rows() > 0) {
                    $customerRowId = $getcustomerid->row()->id;
                }
            }
        }
        $currentDate = $ePickup = date('Y-m-d H:i:s');
        if ($earlyPickup != "") {
            $ePickup = date('Y-m-d H:i:s', strtotime($earlyPickup));
        }
        if ($latePickup != "") {
            $lPickup = date('Y-m-d H:i:s', strtotime($latePickup));
        } else {
            $lPickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($ePickup)));
        }
        if ($earlyDelivery != "") {
            $eDelivery = date('Y-m-d H:i:s', strtotime($earlyDelivery));
        } else {
            $eDelivery = date('Y-m-d H:i:s', strtotime('+3 hour', strtotime($currentDate)));
        }
        if ($lateDelivery != "") {
            $lDelivery = date('Y-m-d H:i:s', strtotime($lateDelivery));
        } else {
            $lDelivery = date('Y-m-d H:i:s', strtotime('+4 hour', strtotime($currentDate)));
        }
        $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $logDate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logDate, $userTimeZone);
        $logDate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $ePickup, $userTimeZone);
        $ePickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $lPickup, $userTimeZone);
        $lPickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $eDelivery, $userTimeZone);
        $eDelivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $lDelivery, $userTimeZone);
        $lDelivery = $getldelivery['datetime'];

        $pickupId = $data['pickup_id'] ?? "";
        $pickupRowId = $data['pickup_row_id'] ?? 0;
        $pickupName = $data['pickup_name'] ?? "";
        $pickupStreet = $data['pickup_street'] ?? "";
        $pickupCity = $data['pickup_city'] ?? "";
        $pickupState = $data['pickup_state'] ?? "";
        $pickupCountry = $data['pickup_country'] ?? "";
        $pickupPincode = $data['pickup_pincode'] ?? "";
        $shipperTypeId = $data['shipper_type_id'] ?? 0;
        $pickupLatitude = $data['pickup_latitude'] ?? "";
        $pickupLongitude = $data['pickup_longitude'] ?? "";
        $address = $pickupStreet . ',' . $pickupCity . ',' . $pickupCountry;
        $dropId = $data['drop_id'] ?? "";
        $dropRowId = $data['drop_row_id'] ?? 0;
        $dropName = $data['drop_name'] ?? "";
        $dropStreet = $data['drop_street'] ?? "";
        $dropCity = $data['drop_city'] ?? "";
        $dropState = $data['drop_state'] ?? "";
        $dropCountry = $data['drop_country'] ?? "";
        $dropPincode = $data['drop_pincode'] ?? "";
        $dropLatitude = $data['drop_latitude'] ?? "";
        $dropLongitude = $data['drop_longitude'] ?? "";
        $daddress = $dropStreet . ',' . $dropCity . ',' . $dropCountry;
        $partyTypeId = $data['party_type_id'] ?? 0;
        $endDate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $transportModeId = 1;
        $transportModeName = "Less Than TruckLoad";
        $transportMode = "LTL";
        $getTransportMode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $transportMode . "'");
        if ($getTransportMode->num_rows() > 0) {
            $transportModeId = $getTransportMode->row()->id;
            $transportModeName = $getTransportMode->row()->name;
        }
        $shipid = "SVK" . time();
        if ($shipmentNumber == "") {
            $shipmentNumber = $shipid;
        }
        $shipmentArray = [
            'unitspec' => 1,
            'shipid' => $shipid,
            'txnid' => $shipmentNumber,
            'trucktype' => $transportModeName,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickupId,
            'carrier' => '0',
            'insertuserdate' => $currentDate,
            'enddate' => $endDate,
            'insdate' => $currentDate,
            'upddate' => $currentDate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $currentDate,
            'transport_mode' => $transportMode,
            'domainname' => $branchCode,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $transportModeId
        ];
        $checkShipmentId = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipid . "'");
        if ($checkShipmentId->num_rows() > 0) {
            $shipmentRowId = $checkShipmentId->row()->id;
            $this->db->where(['id' => $shipmentRowId])->update("tb_shipments", $shipmentArray);
        } else {
            $shipmentArray['createdon'] = $currentDate;
            $shipmentRowId = $this->common->insertTableData("tb_shipments", $shipmentArray);
        }
        if ($pickupLatitude != "" && $pickupLongitude != "" && $dropLatitude != "" && $dropLongitude != "") {
            $lat1 = $pickupLatitude;
            $lng1 = $pickupLongitude;
            $lat2 = $dropLatitude;
            $lng2 = $dropLongitude;
        } else {
            $add1 = implode(",", [$pickupStreet, $pickupCity, $pickupCountry, $pickupPincode]);
            $add2 = implode(",", [$dropStreet, $dropCity, $dropCountry, $dropPincode]);
            $loc = getlatlngsbyplace($add1);
            $lat1 = $loc[0] ?? null;
            $lng1 = $loc[1] ?? null;
            $loc = getlatlngsbyplace($add2);
            $lat2 = $loc[0] ?? null;
            $lng2 = $loc[1] ?? null;
        }
        $goodsValue = "0.00";
        $childId = 0;
        if ($this->session->userdata('childid')) {
            $childId = $this->session->userdata('childid');
        }
        $ins = [
            'shipment_id' => $shipmentRowId,
            'customer_id' => $customerRowId,
            'drop_custid' => $dropId,
            'drop_partyid' => $dropId,
            'product' => $product,
            'goods_value' => $goodsValue,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'pickup_datetime' => $ePickup,
            'delivery_datetime' => $eDelivery,
            'pickup_endtime' => $lPickup,
            'drop_endtime' => $lDelivery,
            'createdon' => $currentDate,
            'user_id' => $userId,
            'sub_uid' => $childId,
            'pickup_custid' => $pickupId,
            'pickup_partyid' => $pickupId,
            'pickup_country' => $pickupCountry,
            'pickup_city' => $pickupCity,
            'pickup_pincode' => $pickupPincode,
            'pickup_company' => $pickupName,
            'pickup_address1' => $pickupStreet,
            'pickup_address2' => $pickupState,
            'delivery_country' => $dropCountry,
            'delivery_city' => $dropCity,
            'delivery_pincode' => $dropPincode,
            'delivery_company' => $dropName,
            'delivery_address1' => $dropStreet,
            'delivery_address2' => $dropState,
            'transport_mode' => $transportMode,
            'plat' => $lat1,
            'plng' => $lng1,
            'dlat' => $lat2,
            'dlng' => $lng2,
            'modeoftransport' => $transportModeId,
            'created_source' => '4',
            'createdon' => $logDate,
        ];
        $orderId = $this->common->insertTableData("tb_orders", $ins);
        if ($orderId == 0) {
            if (in_array($deliveryNote, $noBookingIds, true)) {
            } else {
                $noBookingIds[] = $deliveryNote;
                $excelFailOrders[] = ['order_id' => '0', 'customer_id' => $customerId, 'delivery_note' => '', 'booking_id' => 'DQ-' . $deliveryNote, 'trip_id' => '-', 'status' => 'Fail'];
            }
        } else {
            if ($userId != "") {
                $getCountry = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $userId]);
                $countryCode = $getCountry->row()->country_code;
                $companyCode = $getCountry->row()->company_code;
                $generateOrderIdArray = ["user_id" => $userId, "order_id" => $orderId, "country_code" => $countryCode, "company_code" => $companyCode];
                $bookingId = generatebookingid($generateOrderIdArray);
                makeorderinvolvedpartiestype($customerRowId, $orderId, "CUSTOMER", $userId, $companyCode);
                $this->db->where(['id' => $orderId])->update("tb_orders", ['order_id' => $bookingId]);
                $details = ['service' => $serviceId, 'department_code' => $departmentode, 'delivery_term' => "", 'incoterm' => $incoterm, 'purchase_order' => '0', 'notify_party' => '0', 'lane_reference' => '0', 'distance' => '0', 'temperature_control' => '0', 'valorance_insurance' => '0', 'high_cargo_value' => '0', 'customs_required' => '0', 'order_id' => $bookingId, 'order_row_id' => $orderId, 'createdon' => $currentDate, 'order_type' => ''];
                $this->db->insert("tb_order_details", $details);
                if ($pickupRowId > 0) {
                    $orderParties = ['order_id' => $orderId, 'party_id' => $pickupRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $shipperTypeId];
                    $this->db->insert("tb_order_parties", $orderParties);
                    $shipperAddress = ['order_id' => $orderId, 'party_master_id' => $pickupRowId, 'location_id' => $pickupCity, 'street' => $pickupStreet, 'state' => $pickupState, 'address' => $address, 'pincode' => $pickupPincode, 'country' => $pickupCountry, 'user_id' => $userId];
                    $checkShipperAddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $pickupRowId]);
                    if ($checkShipperAddress->num_rows() > 0) {
                        $shipperAddressId = $checkShipperAddress->row()->id;
                        $this->db->where(['id' => $shipperAddressId])->update("tbl_orderparty_address", $shipperAddress);
                    } else {
                        $shipperAddress['createdon'] = $currentDate;
                        $this->common->insertTableData("tbl_orderparty_address", $shipperAddress);
                    }
                }
                if ($dropRowId > 0) {
                    $orderParties = ['order_id' => $orderId, 'party_id' => $dropRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $partyTypeId];
                    $this->db->insert("tb_order_parties", $orderParties);
                    $dropAddress = ['order_id' => $orderId, 'party_master_id' => $dropRowId, 'location_id' => $dropCity, 'street' => $dropStreet, 'state' => $dropState, 'address' => $daddress, 'pincode' => $dropPincode, 'country' => $dropCountry, 'user_id' => $userId];
                    $checkDropAddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $dropRowId]);
                    if ($checkDropAddress->num_rows() > 0) {
                        $dropAddressId = $checkDropAddress->row()->id;
                        $this->db->where(['id' => $dropAddressId])->update("tbl_orderparty_address", $dropAddress);
                    } else {
                        $dropAddress['createdon'] = $currentDate;
                        $this->common->insertTableData("tbl_orderparty_address", $dropAddress);
                    }
                }
                if ($shipmentNumber != "") {
                    $referenceInsertArray = ['order_id' => $orderId, 'reference_id' => 'DQ', 'ref_value' => $shipmentNumber, 'createdon' => $currentDate];
                    $this->db->insert('tb_order_references', $referenceInsertArray);
                }
            }
            if ($departmentName != "") {
                $div_reference = ['order_id' => $orderId, 'ref_value' => $departmentName, 'reference_id' => 'DIV', 'status' => '1', 'createdon' => $currentDate];
                $this->db->insert("tb_order_references", $div_reference);
            }
            $cargo = $data['cargo_details'] ?? [];
            foreach ($cargo as $car) {
                $cargoType = $car['cargo_type'] ?? "";
                $goodsDescription = $car['goods_description'] ?? "";
                $quantity = $car['quantity'] ?? "";
                $length = $car['length'] ?? "";
                $lengthUom = $car['length_uom'] ?? "m";
                $width = $car['width'] ?? "";
                $widthUom = $car['width_uom'] ?? "m";
                $height = $car['height'] ?? "";
                $heightUom = $car['height_uom'] ?? "m";
                $weight = $car['weight'] ?? "";
                $weightUom = $car['weight_uom'] ?? "kg";
                $volume = $car['volume'] ?? "";
                $volumeUom = $car['volume_uom'] ?? "cbm";
                $stackable = $car['stackable'] ?? "";
                if ($stackable == 'on') {
                    $stackable = 1;
                } else {
                    $stackable = 0;
                }
                $cargoDetails = ['cargo_type' => $cargoType, 'goods_description' => $goodsDescription, 'quantity' => $quantity, 'length' => $length, 'length_unit' => $lengthUom, 'width' => $width, 'width_unit' => $widthUom, 'height' => $height, 'height_unit' => $heightUom, 'weight' => $weight, 'weight_unit' => $weightUom, 'volume' => $volume, 'volume_unit' => $volumeUom, 'stackable' => $stackable, 'createdby' => $userId, 'createdon' => $currentDate];
                $cargoRowId = $this->common->insertTableData("tb_cargo_details", $cargoDetails);
                $getHandlingUnit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargoType . "'");
                $handlingUnit = "";
                if ($getHandlingUnit->num_rows() > 0) {
                    $handlingUnit = $getHandlingUnit->row()->id;
                } else {
                    $handlingunit_ar = ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $userId, 'created_at' => $currentDate, 'status' => '1'];
                    $handlingUnit = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                }
                $orderCargo = ['order_id' => $orderId, 'quantity' => $quantity, 'cargo_id' => $cargoRowId, 'status' => '1', 'createdon' => $currentDate, 'cargo_content' => $goodsDescription, 'quantity_type' => $cargoType, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'handling_unit' => $handlingUnit];
                $this->db->insert("tb_order_cargodetails", $orderCargo);
            }
            $cargoForShipmet = [];
            $getCargos = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='" . $orderId . "'");
            if ($getCargos->num_rows() > 0) {
                foreach ($getCargos->result() as $res) {
                    $cargoForShipmet[] = $res->quantity_type;
                }
            }
            $unitSpec = "1";
            if (!empty($cargoForShipmet)) {
                $unitSpec = implode(',', $cargoForShipmet);
            }
            $this->db->where(['id' => $shipmentRowId])->update("tb_shipments", ['unitspec' => $unitSpec, 'txncode' => $bookingId]);
            $totalWeight = $totalVolume = $totalQuantity = 0;
            $getTotalDimensions = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $orderId . "'");
            if ($getTotalDimensions->num_rows() > 0) {
                $totalVolume = $getTotalDimensions->row()->total_volume;
                $totalWeight = $getTotalDimensions->row()->total_weight;
                $totalQuantity = $getTotalDimensions->row()->total_quantity;
            }
            $this->db->where(['id' => $orderId])->update("tb_orders", ['volume' => $totalVolume, 'weight' => $totalWeight, 'quantity' => $totalQuantity]);
            $reference = $data['reference'] ?? [];
            if (!empty($reference)) {
                foreach ($reference as $ref) {
                    $referenceId = $ref['reference_id'] ?? "";
                    $referenceName = $ref['reference_name'] ?? "";
                    $referenceValue = $ref['reference_value'] ?? "";
                    $getReferenceId = $this->db->select('id')->get_where("tb_reference_master", ['name' => $referenceId]);
                    if ($getReferenceId->num_rows() > 0) {
                        $this->db->insert('tb_order_references', ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                    } else {
                        $this->db->insert('tb_reference_master', ['name' => $referenceId, 'description' => $referenceName, 'status' => '1', 'createdon' => $currentDate]);
                        $this->db->insert('tb_order_references', ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                    }
                }
            }
            $orders = ['order_id' => $orderId, 'booking_id' => $bookingId, 'carrier' => $carrier, 'vehicle_no' => $vehcileNumber, 'driver' => $driver, 'route' => $route, 'trip_no' => $tripNumber];
            $response = ['orders' => $orders, 'excel_forders' => $excelFailOrders];
            try {
                $this->altovaordercreation->sendOrderToAltova($orderId);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
            }
        }
        return $response ?? [];
    }

    public function updatecust_reffororder($past_ref, $new_ref, $new_deptname, $cargo)
    {
        $order_id = 0;
        $user_id = $this->session->userdata('user_id');
        $cdate = date('Y-m-d H:i:s');
        if ($past_ref != "" && $past_ref != '0') {
            $getdata = $this->common->gettblrowdata(['ref_value' => $past_ref, 'status' => '1'], "order_id", "tb_order_references", 0, 0);
            if (!empty($getdata)) {
                $order_id = $getdata['order_id'];
                if ($order_id != "0") {
                    $ref_ar = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $new_ref, 'status' => '1', 'createdon' => $cdate];
                    $chk1 = $this->common->gettblrowdata(['ref_value' => $new_ref, 'order_id' => $order_id, 'status' => '1'], "id", "tb_order_references", 0, 0);
                    if (empty($chk1)) {
                        $ref_ins = $this->common->insertTableData("tb_order_references", $ref_ar);
                    }

                    $dept_ar = ['order_id' => $order_id, 'reference_id' => 'DIV', 'ref_value' => $new_deptname, 'status' => '1', 'createdon' => $cdate];
                    $chk2 = $this->common->gettblrowdata(['ref_value' => $new_deptname, 'order_id' => $order_id, 'status' => '1'], "id", "tb_order_references", 0, 0);
                    if (empty($chk2)) {
                        $dept_ins = $this->common->insertTableData("tb_order_references", $dept_ar);
                    }
                    if (!empty($cargo[0])) {
                        $cargo_type = $cargo[0]['cargo_type'];
                        $length = $cargo[0]['length'];
                        if ($length == "") {
                            $length = 0;
                        }
                        $width = $cargo[0]['width'];
                        if ($width == "") {
                            $width = 0;
                        }
                        $height = $cargo[0]['height'];
                        if ($height == "") {
                            $height = 0;
                        }
                        $weight = $cargo[0]['weight'];
                        if ($weight == "") {
                            $weight = 0;
                        }
                        $volume = $cargo[0]['volume'];
                        if ($volume == "") {
                            $volume = 0;
                        }
                        $quantity = $cargo[0]['quantity'];
                        if ($quantity == "0" || $quantity == "") {
                            $quantity = 1;
                        }
                        $stackable = 0;
                        $stack = strtoupper($cargo[0]['stackable']);
                        if ($stack == "" || $stack == 'OFF' || $stack == '0') {
                            $stackable = 0;
                        } else {
                            if ($stack == "ON" && $stack == '1') {
                                $stackable = 1;
                            }
                        }
                        $handling_unit_id = 0;
                        if ($cargo_type != "") {
                            $chkhandling_unit = $this->common->gettblrowdata(['unit_name' => $cargo_type, 'status' => '1'], "id", "tbl_shipunit_types", 0, 0);
                            if (!empty($chkhandling_unit)) {
                                $handling_unit_id = $chkhandling_unit['id'];
                            } else {
                                $handling_ar = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'status' => '1', 'created_at' => $cdate];
                                $handling_unit_id = $this->common->insertTableData("tbl_shipunit_types", $handling_ar);
                            }

                            $cargo_ins = ['cargo_type' => $cargo_type, 'handling_unit' => $cargo_type, 'handlingunit_id' => $handling_unit_id, 'length' => $length, 'length_unit' => 'm', 'width' => $width, 'height' => $height, 'height_unit' => 'm', 'weight' => $weight, 'weight_unit' => 'kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'quantity' => $quantity, 'stackable' => $stackable, 'status' => '1', 'createdon' => $cdate];
                            $cargo_id = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
                            $chkcargo = $this->common->gettblrowdata(['quantity_type' => $cargo_type, 'status' => '1', 'order_id' => $order_id], "id,quantity", "tb_order_cargodetails", 0, 0);
                            if (!empty($chkcargo)) {
                                $order_cargo_row_id = $chkcargo['id'];
                                $order_cargo_quantity = $chkcargo['quantity'];
                                $original_quantity = $order_cargo_quantity + $quantity;
                                $upd = $this->common->updatetbledata("tb_order_cargodetails", ['quantity' => $original_quantity], ["id" => $order_cargo_row_id]);
                            } else {
                                $order_cargo = ['order_id' => $order_id, 'cargo_id' => $cargo_id, 'handling_unit' => $handling_unit_id, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $quantity, 'quantity_type' => $cargo_type, 'status' => '1', 'createdon' => $cdate];
                                $order_argo_id = $this->common->insertTableData("tb_order_cargodetails", $order_cargo);
                            }
                        }
                    }
                }
            }
        }
    }

    public function tripordershipment($orders)
    {
        $dummy_array = $nobooking_ids = $excel_sorders = [];
        $countryid = $this->session->userdata("usr_tzone")['phone_code'];
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if (!empty($orders)) {
            for ($i = 0, $iMax = count($orders); $i < $iMax; $i++) {
                $order_forshift = $orders[$i]['order_id'];
                $vendor_forship = $orders[$i]['carrier'];
                $vehicle_forship = $orders[$i]['vehicle_no'];
                $driver_forship = $orders[$i]['driver'];
                $route_forship = $orders[$i]['route'];
                $booking_forship = $orders[$i]['booking_id'];
                $trip_forship = $orders[$i]['trip_no'];
                if (!in_array($orders[$i]['order_id'], $dummy_array)) {
                    for ($k = 0, $kMax = count($orders); $k < $kMax; $k++) {
                        $order_id = $orders[$k]['order_id'];
                        $booking_id = $orders[$k]['booking_id'];
                        $vendor_code = $orders[$k]['carrier'];
                        $register_number = $orders[$k]['vehicle_no'];
                        $trip_no = $orders[$k]['trip_no'];
                        $driver = $orders[$k]['driver'];
                        $route = $orders[$k]['route'];
                        if ($trip_forship == $trip_no && $route_forship == $route && $driver_forship == $driver && $vehicle_forship == $register_number && $vendor_forship == $vendor_code) {
                            $ord[] = $orders[$k];
                            $dummy_array[] = $orders[$k]['order_id'];
                        }
                    }
                }
            }
        }
        $j = 0;
        for ($i = 0, $iMax = count($ord); $i < $iMax; $i++) {
            if ($j == '0') {
                $order_forshift = $ord[0]['order_id'];
                $vendor_forship = $ord[0]['carrier'];
                $vehicle_forship = $ord[0]['vehicle_no'];
                $driver_forship = $ord[0]['driver'];
                $route_forship = $ord[0]['route'];
                $booking_forship = $ord[0]['booking_id'];
                $trip_forship = $ord[0]['trip_no'];
            } else {
                $order_forshift = $ord[$j]['order_id'];
                $vendor_forship = $ord[$j]['carrier'];
                $vehicle_forship = $ord[$j]['vehicle_no'];
                $driver_forship = $ord[$j]['driver'];
                $route_forship = $ord[$j]['route'];
                $booking_forship = $ord[$j]['booking_id'];
                $trip_forship = $ord[$j]['trip_no'];
            }

            $order_id = $ord[$i]['order_id'];
            $booking_id = $ord[$i]['booking_id'];
            $vendor_code = $ord[$i]['carrier'];
            $register_number = $ord[$i]['vehicle_no'];
            $trip_no = $ord[$i]['trip_no'];
            $driver = $ord[$i]['driver'];
            $route = $ord[$i]['route'];
            $count_code = substr($company_code, 0, 2);

            $txnid = time();
            $year = date('y');
            $week = date('W');
            $seq_num = 000001;
            if ($booking_forship != "" && $booking_forship != '') {
                $seq_num = substr($booking_forship, -6);
            }
            $shipid = $txnid = "T" . $count_code . $week . $year . $seq_num;

            $response = 0;
            $user_id = $this->session->userdata('user_id');
            $userid = $this->session->userdata('user_id');
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $logdate = date('Y-m-d H:i:s');
            $tpvehicle_type = 1;
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $input = $this->input->post(null, true);
            $where = ['code' => $vendor_code, 'status' => '1'];
            $select = "id,name";
            $table = "tb_vendors";
            $vendor_id = 0;
            $vendor_name = "";
            $vendor_details = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($vendor_details) > 0) {
                $vendor_id = $vendor_details['id'];
                $vendor_name = $vendor_details['name'];
            }
            if ($vendor_id != 0) {
                $vslt = "id";
                $vwhr = ['register_number' => $register_number, 'status' => 'Active', 'vendor_id' => $vendor_id];
                $vtbl = "tb_trucks_data";
                $vehicle_details = $this->common->gettblrowdata($vwhr, $vslt, $vtbl, 0, 0);
                if (count($vehicle_details) > 0) {
                    $vehicle_id = $vehicle_details['id'];
                } else {
                    $vwhr = ['register_number' => $register_number, 'status' => 'Active'];
                    $v1details = $this->common->gettblrowdata($vwhr, $vslt, $vtbl, 0, 0);
                    if (count($v1details) > 0) {
                        $vehicle_id = $v1details['id'];
                        $tablename = "tb_trucks_data";
                        $set = ["vendor_id" => $vendor_id];
                        $whr = ['id' => $vehicle_id];
                        $upd = $this->common->updatetbledata($tablename, $set, $whr);
                    } else {
                        $instable = "tb_trucks_data";
                        $insdata = ['truck_number' => $register_number, 'length' => '0', 'breadth' => '0', 'truck_capacity' => '1', 'truck_type' => '1', 'register_number' => $register_number, 'route' => $register_number, 'user_id' => $user_id, 'vendor_id' => $vendor_id, 'status' => 'Active', 'createdon' => $logdate];
                        $vehicle_id = $this->common->insertTableData($instable, $insdata);
                    }
                }
            }
            $driver_id = 0;
            if ($driver != "") {
                $dwhr = ['name' => $driver];
                $dslt = "id";
                $dtbl = "tb_truck_drivers";
                $driverdetails = $this->common->gettblrowdata($dwhr, $dslt, $dtbl, 0, 0);
                if (count($driverdetails) > 0) {
                    $driver_id = $driverdetails['id'];
                } else {
                    $dinstable = "tb_truck_drivers";
                    $pwd = RandomString::generate(10);
                    $password = password_hash($pwd, PASSWORD_DEFAULT);
                    $mobile = time();
                    $dinsdata = ['name' => $driver, 'password' => $password, 'contact_num' => $mobile, 'createdby' => $user_id, 'user_id' => $user_id, 'vendor_id' => $vendor_id, 'status' => 'Active', 'company_code' => $company_code, 'branch_code' => $branch_code, 'createdon' => $logdate];
                    $vehicle_id = $this->common->insertTableData($dinstable, $dinsdata);
                }
            }
            $sid = $order_id;
            if ($shipid != "" && $vendor_id > 0 && $order_id > 0) {
                $where = ["id" => $order_id];
                $select = "*";
                $table = "tb_orders";
                $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($order) > 0) {
                    $shift_idchk = $order['shift_id'];
                    $booking_id = $order['order_id'];
                    $customer_code = $order['customer_id'];
                    $getcustomercode = $this->common->gettblrowdata(['id' => $customer_code], "code", "tb_customers", 0, 0);
                    if (!empty($getcustomercode)) {
                        $customer_code = $getcustomercode['code'];
                    }
                    if ($shift_idchk == 0) {
                        $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                        $pickup = $order['pickup_address1'];
                        if ($pickup == "") {
                            $pickup = $order['pickup_city'];
                        }
                        $delivery = $order['delivery_address1'];
                        if ($delivery == "") {
                            $delivery = $order['delivery_city'];
                        }
                        $address = $dropaddr = "";
                        if ($order['pickup_address1'] != "") {
                            $address .= $order['pickup_address1'];
                            $dropaddr .= $order['delivery_address1'];
                        }
                        if ($order['pickup_company'] != "") {
                            $address .= ", " . $order['pickup_company'];
                            $dropaddr .= ", " . $order['delivery_company'];
                        }
                        if ($order['pickup_country'] != "") {
                            $address .= ", " . $order['pickup_country'];
                            $dropaddr .= ", " . $order['delivery_country'];
                        }
                        if ($order['pickup_city'] != "") {
                            $address .= ", " . $order['pickup_city'];
                            $dropaddr .= ", " . $order['delivery_city'];
                        }
                        if ($order['pickup_pincode'] != "") {
                            $address .= ", " . $order['pickup_pincode'];
                            $dropaddr .= ", " . $order['delivery_pincode'];
                        }
                        $plat = $order['plat'];
                        $plng = $order['plng'];
                        $dlat = $order['dlat'];
                        $dlng = $order['dlng'];
                        if ($i == '0') {
                            $where = ["shipmentid" => $shipid];
                            $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                            $table = "tb_shifts";
                            $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($shipment) == 0) {
                                $curdt = $logdate;
                                $splace = $order['pickup_address1'];
                                $eplace = $order['delivery_address1'];
                                $pickup_city = $order['pickup_city'];
                                $delivery_city = $order['delivery_city'];
                                $customer_id = $order['customer_id'];
                                $transport_mode = $order['transport_mode'];
                                $weight = $order['weight'];
                                $volume = $order['volume'];
                                $txnid = $shipid;
                                if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                    $vtwhere = ["id" => $tpvehicle_type];
                                    $vtselect = "trucktype";
                                    $vttable = "tb_trucktypes";
                                    $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                    if (count($vtorder) > 0) {
                                        $vehicle_type = $vtorder['trucktype'];
                                    } else {
                                        $vehicle_type = $order['vehicle_type'];
                                    }
                                } else {
                                    $vehicle_type = $order['vehicle_type'];
                                }
                                $startdate = $order['pickup_datetime'];
                                $starttime = date('H:i', strtotime($startdate));
                                $enddate = $order['delivery_datetime'];
                                $endtime = date('H:i', strtotime($enddate));
                                $insarr = [
                                    'user_id' => $userid,
                                    'stime' => $starttime,
                                    'etime' => $endtime,
                                    'splace' => $order['pickup_city'],
                                    'slat' => $plat,
                                    'slng' => $plng,
                                    'eplace' => $order['delivery_city'],
                                    'elat' => $dlat,
                                    'elng' => $dlng,
                                    'scity' => $order['pickup_city'],
                                    'dcity' => $order['delivery_city'],
                                    'zone_id' => 1,
                                    'empshift_start' => $starttime,
                                    'empshift_end' => $endtime,
                                    'trip_type' => 0,
                                    'startdate' => $startdate,
                                    'enddate' => $enddate,
                                    'shipment_name' => 'Boxes',
                                    'shipment_id' => 0,
                                    'transport_mode' => $transport_mode,
                                    'customer_id' => $customer_id,
                                    'vendor_id' => $vendor_id,
                                    'carrier_type' => 0,
                                    'shipmentid' => $txnid,
                                    'txnid' => $txnid,
                                    'weight' => $weight,
                                    'volume' => $volume,
                                    'units' => $order['quantity'],
                                    'domainname' => 'INFD',
                                    'vehicle_type' => $vehicle_type,
                                    'company_code' => $company_code,
                                    'branch_code' => $branch_code,
                                    'status' => 1
                                ];
                                $this->db->insert("tb_shifts", $insarr);
                                $ship_id = $this->db->insert_id();
                            } else {
                                $ship_id = $shipment['id'];
                            }
                        } else {
                            if ($trip_forship == $trip_no && $route_forship == $route && $driver_forship == $driver && $vehicle_forship == $register_number && $vendor_forship == $vendor_code) {
                                $ship_id = $txnid = "0";
                                $getshiftdata = $this->db->select("shift_id,shipmentid")->get_where("tb_orders", ['id' => $order_forshift]);
                                if ($getshiftdata->num_rows() > 0) {
                                    $ship_id = $getshiftdata->row()->shift_id;
                                    $txnid = $getshiftdata->row()->shipmentid;
                                }
                            } else {
                                $j = $i;
                                $booking_forship = $ord[$j]['booking_id'];
                                if ($booking_forship != "" && $booking_forship != '') {
                                    $seq_num = substr($booking_forship, -6);
                                }
                                $shipid = $txnid = "T" . $count_code . $week . $year . $seq_num;
                                $where = ["shipmentid" => $shipid];
                                $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                $table = "tb_shifts";
                                $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                                if (count($shipment) == 0) {
                                    $curdt = $logdate;
                                    $splace = $order['pickup_address1'];
                                    $eplace = $order['delivery_address1'];
                                    $pickup_city = $order['pickup_city'];
                                    $delivery_city = $order['delivery_city'];
                                    $customer_id = $order['customer_id'];
                                    $transport_mode = $order['transport_mode'];
                                    $weight = $order['weight'];
                                    $volume = $order['volume'];
                                    $txnid = $shipid;
                                    if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                        $vtwhere = ["id" => $tpvehicle_type];
                                        $vtselect = "trucktype";
                                        $vttable = "tb_trucktypes";
                                        $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                        if (count($vtorder) > 0) {
                                            $vehicle_type = $vtorder['trucktype'];
                                        } else {
                                            $vehicle_type = $order['vehicle_type'];
                                        }
                                    } else {
                                        $vehicle_type = $order['vehicle_type'];
                                    }
                                    $startdate = $order['pickup_datetime'];
                                    $starttime = date('H:i', strtotime($startdate));
                                    $enddate = $order['delivery_datetime'];
                                    $endtime = date('H:i', strtotime($enddate));
                                    $insarr = [
                                        'user_id' => $userid,
                                        'stime' => $starttime,
                                        'etime' => $endtime,
                                        'splace' => $order['pickup_city'],
                                        'slat' => $plat,
                                        'slng' => $plng,
                                        'eplace' => $order['delivery_city'],
                                        'elat' => $dlat,
                                        'elng' => $dlng,
                                        'scity' => $order['pickup_city'],
                                        'dcity' => $order['delivery_city'],
                                        'zone_id' => 1,
                                        'empshift_start' => $starttime,
                                        'empshift_end' => $endtime,
                                        'trip_type' => 0,
                                        'startdate' => $startdate,
                                        'enddate' => $enddate,
                                        'shipment_name' => 'Boxes',
                                        'shipment_id' => 0,
                                        'transport_mode' => $transport_mode,
                                        'customer_id' => $customer_id,
                                        'vendor_id' => $vendor_id,
                                        'carrier_type' => 0,
                                        'shipmentid' => $txnid,
                                        'txnid' => $txnid,
                                        'weight' => $weight,
                                        'volume' => $volume,
                                        'units' => $order['quantity'],
                                        'domainname' => 'INFD',
                                        'vehicle_type' => $vehicle_type,
                                        'company_code' => $company_code,
                                        'branch_code' => $branch_code,
                                        'status' => 1
                                    ];
                                    $this->db->insert("tb_shifts", $insarr);
                                    $ship_id = $this->db->insert_id();
                                } else {
                                    $ship_id = $shipment['id'];
                                }
                            }
                        }


                        /*update order table*/
                        $capacity = $order['weight'];
                        if ($capacity == "") {
                            $capacity = "0";
                        }
                        $upddt = ['vendor_id' => $vendor_id, 'shift_id' => $ship_id, "shipmentid" => $txnid];
                        $updwhr = ["id" => $order_id];
                        $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                        $invtypes = makeorderinvolvedpartiestype($vendor_id, $order_id, "CARRIER", $userid, $company_code);
                        if (in_array($booking_id, $nobooking_ids)) {
                        } else {
                            $nobooking_ids[] = $booking_id;
                            $excel_sorders[] = ['order_id' => $order_id, 'customer_id' => $customer_code, 'booking_id' => $booking_id, 'trip_id' => $txnid, 'delivery_note' => '', 'status' => 'Success'];
                        }
                        $insarr = [
                            'assoc_id' => $txnid,
                            'pickup' => $pickup,
                            'plat' => $plat,
                            'plng' => $plng,
                            'drop' => $delivery,
                            'dlat' => $dlat,
                            'dlng' => $dlng,
                            'pickup_city' => $order['pickup_city'],
                            'drop_city' => $order['delivery_city'],
                            'pickup_datetime' => $order['pickup_datetime'],
                            'drop_datetime' => $order['delivery_datetime'],
                            'name' => 'Boxes',
                            'phone' => $order['customer_phone'],
                            'address' => $address,
                            'emailid' => $order['customer_email'],
                            'user_id' => $userid,
                            'status' => 1,
                            'createdon' => $curdt,
                            'material_id' => 0,
                            'capacity' => $capacity,
                            'information' => $order['customer_comments'],
                            'shipment_weight' => $order['weight'],
                            'shipment_volume' => $order['volume'],
                            'ship_type' => 'P',
                            'customer_id' => $order['customer_id'],
                            'vendor_id' => $vendor_id,
                            'shipment_id' => 0,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['delivery_datetime'],
                            'shift_id' => $ship_id,
                            'stop_order' => 1,
                            'drop_order' => 0,
                            'basic_stop' => 0,
                            'stop_id' => 0,
                            'drop_stopid' => 0,
                            'order_id' => $order['order_id'],
                            'pkgitemid' => 'BOXES',
                            'no_of_pkgs' => $order['quantity'],
                            'domainname' => 'INFD'
                        ];
                        $ins = $this->db->insert("tb_employee", $insarr);
                        $detail_id = $this->db->insert_id();
                        if ($detail_id > 0) {
                            if ($stops_units->num_rows() > 1) {
                                $odata = $stops_units->row();
                                $upd = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                            }
                            /*update orders table*/
                            $updwhr = ['id' => $order_id];
                            $setwhr = ['status' => 2];
                            $ins = $this->db->where($updwhr)->update("tb_orders", $setwhr);
                            /*insert stops records */
                            $where = ["shipment_id" => $ship_id, "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = [
                                    'stopname' => $order['pickup_city'],
                                    'plat' => $plat,
                                    'plng' => $plng,
                                    'stopcity' => $order['pickup_city'],
                                    'address' => $address,
                                    'stoptype' => 'P',
                                    'stopstatus' => 0,
                                    'shipment_id' => $ship_id,
                                    'ordernumber' => 1,
                                    'startdate' => $order['pickup_datetime'],
                                    'enddate' => $order['pickup_endtime'],
                                    'weight' => $order['weight'],
                                    'volume' => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units' => $order['quantity'],
                                    'txncode' => 'NP',
                                    'status' => 1,
                                    'created_on' => $curdt
                                ];
                                $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                                $pickupstop_id = $this->db->insert_id();
                            } else {
                                $pickupstop_id = $chkstop['id'];
                            }
                            $where = ["shipment_id" => $ship_id, "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = [
                                    'stopname' => $order['delivery_city'],
                                    'plat' => $dlat,
                                    'plng' => $dlng,
                                    'stopcity' => $order['delivery_city'],
                                    'address' => $dropaddr,
                                    'stoptype' => 'D',
                                    'stopstatus' => 0,
                                    'shipment_id' => $ship_id,
                                    'ordernumber' => 2,
                                    'startdate' => $order['delivery_datetime'],
                                    'enddate' => $order['drop_endtime'],
                                    'weight' => $order['weight'],
                                    'volume' => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units' => $order['quantity'],
                                    'txncode' => 'NP',
                                    'status' => 1,
                                    'created_on' => $curdt
                                ];
                                $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                                $dropstop_id = $this->db->insert_id();
                            } else {
                                $dropstop_id = $chkstop['id'];
                            }
                            /*update pickupstop and drop stop id into details/tb_employee table */
                            $setarr = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id];
                            $setwhr = ['id' => $detail_id];
                            $ins = $this->db->where($setwhr)->update("tb_employee", $setarr);
                            $chk1 = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $ship_id], 1, 0);
                            if ($chk1->num_rows() > 0) {
                                $shftvehid = $chk1->row()->id;
                                $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                                if ($chk->num_rows() == 0) {
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                    if ($chkemp->num_rows() == 0) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                        $ins = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            } else {
                                if ($vehicle_id != "") {
                                    $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                                    $arr = ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $veh_num, 'status' => 1];
                                    $ins = $this->db->insert("tb_shft_veh", $arr);
                                    $shftvehid = $this->db->insert_id();
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                }
                                if ($vehicle_id != "" && $driver_id != "") {
                                    $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["vehicle_id" => $vehicle_id]);
                                    if ($chk->num_rows() > 0) {
                                        if ($driver_id == $chk->row()->driver_id) {
                                            $upd = $this->db->where(["id" => $chk->row()->id])->update("tb_vehicles_drivers", ["status" => 1]);
                                        } else {
                                            $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                            $ins = $this->db->insert("tb_vehicles_drivers", $arr);
                                        }
                                    } else {
                                        $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                        $ins = $this->db->insert("tb_vehicles_drivers", $arr);
                                    }
                                    $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $driver_id, "vehicle_id" => $vehicle_id], 1, 0);
                                    if ($chk11->num_rows() > 0) {
                                        $upd = $this->db->where(["id" => $chk11->row()->id])->update("tbl_assigned_drivers", ["status" => "1", 'updated_on' => $curdt]);
                                    } else {
                                        $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1], 1, 0);
                                        if ($chk111->num_rows() == 0) {
                                            $ins = $this->db->insert("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => "", "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt]);
                                        } else {
                                            $upd = $this->db->where(["id" => $chk111->row()->id])->update("tbl_assigned_drivers", ["driver_id" => $driver_id, 'updated_on' => $curdt]);
                                        }
                                    }
                                }
                            }
                            $response = 1;
                            /* update status */
                            $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $ship_id, "status_id" => 9], 1, 0);
                            if ($chk->num_rows() == 0) {
                                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                $logdate = date('Y-m-d H:i:s');
                                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                                $curdt1 = $getactual['datetime'];
                                $ins = ["shipment_id" => $ship_id, "stop_id" => 0, "order_id" => $order_id, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                                $insqry = $this->db->insert("tb_stop_status", $ins);
                            }
                        }
                    }
                }
            }
        }
        return $excel_sorders;
    }
}

?>
