<?php

use App\Generators\RandomString;

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Excelimportorders extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['bpartners', 'common']);
        $this->load->library(['Ratemanagement', 'exchangerate', 'Vatcalculationtorate', 'altovaordercreation']);
    }

    public function index()
    {
        echo "Import Ebooking";
    }

    public function uploadsgexcel(): void
    {
        ini_set("max_input_time", 2000);
        ini_set("max_execution_time", 2000);
        ini_set("max_input_vars", 20000);
        ini_set("upload_max_size", "2048M");
        ini_set("post_max_size", 0);
        ini_set("memory_limit", "2048M");
        $companyCode = $this->session->userdata('company_code');
        $data        = $errorLine        = $message        = $finalData        = $allPickupCodes        = $allDeliveryCodes        = $shipperConsigneeDetails        = $allShipperConsigneeCodes        = $pickupDetails        = $deliveryDetails        = $shipperConsigneeIds        = $value        = $data["finalData"]        = $checkvalues        = [];
        if (isset($_FILES['import_file'])) {
            $extension = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            if ($extension === "xls" || $extension === "xlsx") {
                $path           = $_FILES['import_file']['tmp_name'];
                $objPHPExcel    = PHPExcel_IOFactory::load($path);
                $cellCollection = $objPHPExcel->getActiveSheet()->getCellCollection();
                foreach ($cellCollection as $cell) {
                    $column    = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row       = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $dataValue = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    if ($row == 1) {
                        $data["header"][$row][$column] = $dataValue;
                    } elseif ($row > 1) {
                        $data['finalData'][$row][$column] = $dataValue;
                    }
                }
                $data['order_details'] = [];
                $row                   = 3;
                $excelData             = [];
                $checkDeliveryNote     = "";
                foreach ($data['finalData'] as $value[$row]) {
                    $deliveryNote = $value[$row]['K'] ?? "";
                    if ($checkDeliveryNote != $deliveryNote) {
                        if ($deliveryNote != "") {
                            $checkDeliveryNote               = $deliveryNote;
                            $value[$row]['row']              = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        } else {
                            $value[$row]['row']              = $row;
                            $excelData[$checkDeliveryNote][] = $value[$row];
                            $row++;
                        }
                    } else {
                        $value[$row]['row']              = $row;
                        $excelData[$checkDeliveryNote][] = $value[$row];
                        $row++;
                    }
                }
                if (! empty($excelData)) {
                    foreach ($excelData as $eachArray) {
                        $allPickupCodes[]           = $eachArray['0']['B'] ?? "";
                        $allDeliveryCodes[]         = $eachArray['0']['D'] ?? "";
                        $allShipperConsigneeCodes[] = $eachArray['0']['E'] ?? "";
                        $allShipperConsigneeCodes[] = $eachArray['0']['F'] ?? "";
                        $finalData[]                = $eachArray;
                    }
                }
                if (! empty($allShipperConsigneeCodes)) {
                    $getAllShipperConsigneeDetails = $this->db->query("SELECT id,code FROM tbl_party_master where code IN ? AND company_code LIKE ? AND status =?", [$allShipperConsigneeCodes, $companyCode, 1]);
                    foreach ($getAllShipperConsigneeDetails->result_array() as $eachData) {
                        $shipperConsigneeDetails[]              = $eachData['code'];
                        $shipperConsigneeIds[$eachData['code']] = $eachData['id'];
                    }
                }
                if (! empty($allPickupCodes)) {
                    $getAllPickupDetails = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,location_id,country,state,street,pincode,party_types,latitude,longitude,fax FROM tbl_party_master where code IN ? AND company_code LIKE ? AND status =?", [$allPickupCodes, $companyCode, 1]);
                    foreach ($getAllPickupDetails->result_array() as $eachData) {
                        $pickupDetails[$eachData['code']] = [
                            'id'            => $eachData['id'],
                            'name'          => $eachData['name'],
                            'email'         => $eachData['email'],
                            'mobile'        => $eachData['mobile'],
                            'code'          => $eachData['code'],
                            'city'          => $eachData['location_id'],
                            'country'       => $eachData['country'],
                            'state'         => $eachData['state'],
                            'street'        => $eachData['street'],
                            'pincode'       => $eachData['pincode'],
                            'fax'           => $eachData['fax'],
                            'party_type_id' => $eachData['party_type_id'],
                            'latitude'      => $eachData['latitude'],
                            'longitude'     => $eachData['longitude'],
                        ];
                    }
                }
                if (! empty($allDeliveryCodes)) {
                    $getAllDeliveryDetails = $this->db->query("SELECT id,party_type_id,name,email,mobile,code,location_id,country,state,street,pincode,party_types,latitude,longitude,fax FROM tbl_party_master where code IN ? AND company_code LIKE ? AND status =?", [$allDeliveryCodes, $companyCode, 1]);
                    foreach ($getAllDeliveryDetails->result_array() as $eachData) {
                        $deliveryDetails[$eachData['code']] = [
                            'id'            => $eachData['id'],
                            'name'          => $eachData['name'],
                            'email'         => $eachData['email'],
                            'mobile'        => $eachData['mobile'],
                            'code'          => $eachData['code'],
                            'city'          => $eachData['location_id'],
                            'country'       => $eachData['country'],
                            'state'         => $eachData['state'],
                            'street'        => $eachData['street'],
                            'pincode'       => $eachData['pincode'],
                            'fax'           => $eachData['fax'],
                            'party_type_id' => $eachData['party_type_id'],
                            'latitude'      => $eachData['latitude'],
                            'longitude'     => $eachData['longitude'],
                        ];
                    }
                }
                if (! empty($finalData)) {
                    for ($i = 0, $iMax = count($finalData); $i < $iMax; $i++) {
                        $data['cargo_details'] = $data['reference'] = [];
                        $rowNumber             = $finalData[$i]['0']['row'] ?? "";
                        $mainRowNumber         = $rowNumber;
                        $service               = $finalData[$i]['0']['A'] ?? "";
                        $checkvalues[]         = ['value' => $service, 'message' => 'Service empty on line: ' . $rowNumber, 'errorline' => 'service' . $rowNumber];
                        $pickupCode            = $finalData[$i]['0']['B'] ?? "";
                        $checkvalues[]         = ['value' => $pickupCode, 'message' => 'Pickup Code empty on line: ' . $rowNumber, 'errorline' => 'pickup_id' . $rowNumber];
                        $customerCode          = $finalData[$i]['0']['C'] ?? "";
                        $checkvalues[]         = ['value' => $customerCode, 'message' => 'Customer Code empty on line: ' . $rowNumber, 'errorline' => 'customer_id' . $rowNumber];
                        $deliveryCode          = $finalData[$i]['0']['D'] ?? "";
                        $checkvalues[]         = ['value' => $deliveryCode, 'message' => 'Delivery Code empty on line: ' . $rowNumber, 'errorline' => 'drop_id' . $rowNumber];
                        $shipperCode           = $finalData[$i]['0']['E'] ?? "";
                        $checkvalues[]         = ['value' => $shipperCode, 'message' => 'Shipper Code empty on line: ' . $rowNumber, 'errorline' => 'shipper_code' . $rowNumber];
                        $consigneeCode         = $finalData[$i]['0']['F'] ?? "";
                        $checkvalues[]         = ['value' => $consigneeCode, 'message' => 'Consignee Code empty on line: ' . $rowNumber, 'errorline' => 'consignee_code' . $rowNumber];
                        $divisionReference     = $finalData[$i]['0']['G'] ?? "";
                        $checkvalues[]         = ['value' => $divisionReference, 'message' => 'Div Ref empty on line: ' . $rowNumber, 'errorline' => 'reference_value' . $rowNumber];
                        $date                  = $finalData[$i]['0']['H'] ?? "";
                        $dateCycle             = $finalData[$i]['0']['I'] ?? "";
                        $deliveryNote          = $finalData[$i]['0']['K'] ?? "";
                        $checkvalues[]         = ['value' => $deliveryNote, 'message' => 'Delivery Note empty on line: ' . $rowNumber, 'errorline' => 'delivery_note' . $rowNumber];
                        $departmentName        = $finalData[$i]['0']['M'] ?? "";
                        $checkvalues[]         = ['value' => $departmentName, 'message' => 'Department Name empty on line: ' . $rowNumber, 'errorline' => 'dept_name' . $rowNumber];
                        $quantity              = $finalData[$i]['0']['N'] ?? "";
                        $checkvalues[]         = ['value' => $quantity, 'message' => 'Quantity empty on line: ' . $rowNumber, 'errorline' => 'quantity' . $rowNumber];
                        $package               = $finalData[$i]['0']['O'] ?? "";
                        $checkvalues[]         = ['value' => $package, 'message' => 'Package empty on line: ' . $rowNumber, 'errorline' => 'cargo_type' . $rowNumber];
                        $tripNumber            = $finalData[$i]['0']['P'] ?? "";
                        $checkvalues[]         = ['value' => $tripNumber, 'message' => 'Trip No empty on line: ' . $rowNumber, 'errorline' => 'trip_no' . $rowNumber];
                        $route                 = $finalData[$i]['0']['Q'] ?? "";
                        $checkvalues[]         = ['value' => $route, 'message' => 'Route empty on line: ' . $rowNumber, 'errorline' => 'route' . $rowNumber];
                        $driver                = $finalData[$i]['0']['R'] ?? "";
                        $checkvalues[]         = ['value' => $driver, 'message' => 'Driver empty on line: ' . $rowNumber, 'errorline' => 'driver' . $rowNumber];
                        $vehicleNumber         = $finalData[$i]['0']['S'] ?? "";
                        $checkvalues[]         = ['value' => $vehicleNumber, 'message' => 'Vehicle Number empty on line: ' . $rowNumber, 'errorline' => 'vehicle_no' . $rowNumber];
                        $carrier               = $finalData[$i]['0']['T'] ?? "";
                        $checkvalues[]         = ['value' => $carrier, 'message' => 'Carrier empty on line: ' . $rowNumber, 'errorline' => 'carrier' . $rowNumber];
                        foreach ($checkvalues as $res) {
                            if ($res['value'] == "") {
                                $message[]   = $res['message'];
                                $errorLine[] = $res['errorline'];
                            }
                        }
                        $pickupId        = $pickupDetails[$pickupCode]['code'] ?? '';
                        $pickupRowId     = $pickupDetails[$pickupCode]['id'] ?? 0;
                        $pickupName      = $pickupDetails[$pickupCode]['name'] ?? '';
                        $pickupCity      = $pickupDetails[$pickupCode]['city'] ?? '';
                        $pickupStreet    = $pickupDetails[$pickupCode]['street'] ?? '';
                        $pickupState     = $pickupDetails[$pickupCode]['state'] ?? '';
                        $pickupCountry   = $pickupDetails[$pickupCode]['country'] ?? '';
                        $pickupPincode   = $pickupDetails[$pickupCode]['pincode'] ?? '';
                        $pickupPhone     = $pickupDetails[$pickupCode]['mobile'] ?? '';
                        $pickupFax       = $pickupDetails[$pickupCode]['fax'] ?? '';
                        $pickupEmail     = $pickupDetails[$pickupCode]['email'] ?? '';
                        $pickupLatitude  = $pickupDetails[$pickupCode]['latitude'] ?? '';
                        $pickupLongitude = $pickupDetails[$pickupCode]['longitude'] ?? '';

                        $dropId        = $deliveryDetails[$deliveryCode]['code'] ?? '';
                        $dropRowId     = $deliveryDetails[$deliveryCode]['id'] ?? '';
                        $dropName      = $deliveryDetails[$deliveryCode]['name'] ?? '';
                        $dropStreet    = $deliveryDetails[$deliveryCode]['street'] ?? '';
                        $dropCity      = $deliveryDetails[$deliveryCode]['city'] ?? '';
                        $dropState     = $deliveryDetails[$deliveryCode]['state'] ?? '';
                        $dropCountry   = $deliveryDetails[$deliveryCode]['country'] ?? '';
                        $dropPincode   = $deliveryDetails[$deliveryCode]['pincode'] ?? '';
                        $dropPhone     = $deliveryDetails[$deliveryCode]['mobile'] ?? '';
                        $dropFax       = $deliveryDetails[$deliveryCode]['fax'] ?? '';
                        $dropEmail     = $deliveryDetails[$deliveryCode]['email'] ?? '';
                        $dropLatitude  = $deliveryDetails[$deliveryCode]['latitude'] ?? '';
                        $dropLongitude = $deliveryDetails[$deliveryCode]['longitude'] ?? '';
                        $shipperRowId  = 0;
                        if ($shipperCode != "") {
                            if ($shipperCode != $pickupId) {
                                if (! in_array($shipperCode, $shipperConsigneeDetails)) {
                                    $shipperCode = $pickupId;
                                } else {
                                    $shipperRowId = $shipperConsigneeIds[$shipperCode] ?? 0;
                                }
                            }
                        } else {
                            $shipperCode = $pickupId;
                        }
                        if ($shipperRowId == 0) {
                            $shipperRowId = $pickupRowId;
                        }
                        $consigneeRowId = 0;
                        if ($consigneeCode != "") {
                            if ($consigneeCode != $dropId) {
                                if (! in_array($consigneeCode, $shipperConsigneeDetails)) {
                                    $consigneeCode = $dropId;
                                } else {
                                    $consigneeRowId = $shipperConsigneeIds[$consigneeCode] ?? 0;
                                }
                            }
                        } else {
                            $consigneeCode = $dropId;
                        }
                        if ($consigneeRowId == 0) {
                            $consigneeRowId = $dropRowId;
                        }
                        $data['reference'] = [];
                        if ($divisionReference != "") {
                            $data['reference'][] = ['reference_id' => 'Div', 'reference_name' => 'Division', 'reference_value' => $divisionReference, 'rowno' => $rowNumber];
                        }
                        $stackable               = 'off';
                        $data['cargo_details'][] = ['cargo_type' => $package, 'goods_description' => '', 'length' => '1', 'width' => '1', 'height' => '1', 'weight' => '1', 'quantity' => $quantity, 'volume' => '1', 'stackable' => $stackable, 'rowno' => $rowNumber];
                        $data['order_details'][] = [
                            'service'          => $service,
                            'customer_id'      => $customerCode,
                            'shipper_code'     => $shipperCode,
                            'consignee_code'   => $consigneeCode,
                            'div_ref'          => $divisionReference,
                            'date'             => $date,
                            'date_cycle'       => $dateCycle,
                            'delivery_note'    => $deliveryNote,
                            'quantity'         => $quantity,
                            'package'          => $package,
                            'pickup_id'        => $pickupId,
                            'pickup_name'      => $pickupName,
                            'pickup_street'    => $pickupStreet,
                            'pickup_city'      => $pickupCity,
                            'pickup_state'     => $pickupState,
                            'pickup_country'   => $pickupCountry,
                            'pickup_pincode'   => $pickupPincode,
                            'early_pickup'     => "",
                            'late_pickup'      => "",
                            'pickup_phone'     => $pickupPhone,
                            'pickup_fax'       => $pickupFax,
                            'pickup_email'     => $pickupEmail,
                            'pickup_row_id'    => $pickupRowId,
                            'drop_id'          => $dropId,
                            'drop_name'        => $dropName,
                            'drop_street'      => $dropStreet,
                            'drop_city'        => $dropCity,
                            'drop_state'       => $dropState,
                            'drop_country'     => $dropCountry,
                            'drop_pincode'     => $dropPincode,
                            'early_drop'       => "",
                            'late_drop'        => "",
                            'drop_phone'       => $dropPhone,
                            'drop_fax'         => $dropFax,
                            'drop_email'       => $dropEmail,
                            'drop_row_id'      => $dropRowId,
                            'rowno'            => $mainRowNumber,
                            'company_code'     => 'INFD',
                            'branch_code'      => 'AIRTEL',
                            'department_code'  => '',
                            'reference'        => $data['reference'],
                            'cargo_details'    => $data['cargo_details'],
                            'involved_parties' => [],
                            'vehicle_no'       => $vehicleNumber,
                            'carrier'          => $carrier,
                            'driver'           => $driver,
                            'route'            => $route,
                            'trip_no'          => $tripNumber,
                            'dept_name'        => $departmentName,
                            'pickup_latitude'  => $pickupLatitude ?? "",
                            'pickup_longitude' => $pickupLongitude ?? "",
                            'drop_latitude'    => $dropLatitude ?? "",
                            'drop_longitude'   => $dropLongitude ?? "",
                            'shipper_row_id'   => $shipperRowId,
                            'consignee_row_id' => $consigneeRowId,
                        ];
                    }
                }
            }
        }
        $data['errorline']  = $errorLine;
        $data["message"]    = $message;
        $data["page_title"] = "Import Orders";
        $this->settemplate->dashboard("smtcorders/sgimport", $data);
    }

    public function checkpartytypes(string $code, string $partyType, int $chk): array
    {
        $data        = $partiesArray        = $partyNames        = [];
        $userId      = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $partyTypeId = 0;
        if ($chk == "1") {
            $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", ["name" => $partyType, "user_id" => $userId, 'company_code' => $companyCode], 1, 0);
            if ($checkPartyType->num_rows() > 0) {
                $partyTypeId = $checkPartyType->row()->id;
            } else {
                $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", ["name" => $partyType, 'company_code' => $companyCode], 1, 0);
                if ($checkPartyType->num_rows() > 0) {
                    $partyTypeId = $checkPartyType->row()->id;
                }
            }
        }
        $checkPartyMaster = $this->common->gettblrowdata(['code' => $code, 'company_code' => $companyCode, 'status' => '1'], "id,party_type_id,name,email,mobile,code,location_id,country,state,street,pincode,party_types,fax", "tbl_party_master", 0, 0);
        if (! empty($checkPartyMaster)) {
            $dbPartyTypeId = $checkPartyMaster['party_type_id'];
            $dbPartyTypes  = $checkPartyMaster['party_types'];
            $masterId      = $checkPartyMaster['id'];
            $data          = ['id' => $checkPartyMaster['id'], 'name' => $checkPartyMaster['name'], 'email' => $checkPartyMaster['email'], 'mobile' => $checkPartyMaster['mobile'], 'code' => $checkPartyMaster['code'], 'city' => $checkPartyMaster['location_id'], 'country' => $checkPartyMaster['country'], 'state' => $checkPartyMaster['state'], 'street' => $checkPartyMaster['street'], 'pincode' => $checkPartyMaster['pincode'], 'fax' => $checkPartyMaster['fax'], 'party_type_id' => $partyTypeId];
            if ($chk == "1") {
                if ($dbPartyTypeId > 0) {
                    $getPartyType = $this->common->gettblrowdata(['id' => $dbPartyTypeId, 'status' => '1'], "name", "tbl_party_types", 0, 0);
                    if (! empty($getPartyType)) {
                        $name = strtoupper($getPartyType['name']);
                        if ($partyType == $name) {
                        } else {
                            if ($dbPartyTypes != "") {
                                if ($dbPartyTypes != "") {
                                    $partiesArray = explode(',', $dbPartyTypes);
                                }
                                if (! empty($partiesArray)) {
                                    array_unique($partiesArray);
                                    $partyTypeNames = $this->bpartners->getpartytypenamesbyids($partiesArray, $companyCode, $userId);
                                    if (! empty($partyTypeNames)) {
                                        foreach ($partyTypeNames as $res) {
                                            $partyNames[] = strtoupper($res);
                                        }
                                        if (in_array($partyType, $partyNames)) {
                                        } else {
                                            $partiesArray[]     = $partyTypeId;
                                            $toUpdatePartyTypes = implode(",", $partiesArray);
                                            if ($toUpdatePartyTypes != "") {
                                                $this->common->updatetbledata("tbl_party_master", ['party_types' => $toUpdatePartyTypes], ['id' => $masterId]);
                                            }
                                        }
                                    }
                                }
                            } else {
                                $toUpdatePartyTypes = $partyTypeId . "," . $dbPartyTypeId;
                                if ($toUpdatePartyTypes != "") {
                                    $this->common->updatetbledata("tbl_party_master", ['party_types' => $toUpdatePartyTypes], ['id' => $masterId]);
                                }
                            }
                        }
                    }
                }
            }
        }
        return $data;
    }

    public function addsgorderdata(): void
    {
        $orders = $excelFailOrders = $ordersList = $dummyArray = $customersList = $allCustomers = [];
        $j      = 0;
        if (! empty($_POST['orders'])) {
            for ($i = 0, $iMax = count($_POST['orders']); $i < $iMax; $i++) {
                $firstCustomer   = $_POST['orders'][$i]['customer_id'] ?? "";
                $firstPickup     = $_POST['orders'][$i]['pickup_id'] ?? "";
                $firstDrop       = $_POST['orders'][$i]['drop_id'] ?? "";
                $firstTripNumber = $_POST['orders'][$i]['trip_no'] ?? "";
                if (! in_array($_POST['orders'][$i]['delivery_note'], $dummyArray)) {
                    for ($k = 0, $kMax = count($_POST['orders']); $k < $kMax; $k++) {
                        $currentCustomer   = $_POST['orders'][$k]['customer_id'] ?? "";
                        $currentPickup     = $_POST['orders'][$k]['pickup_id'] ?? "";
                        $currentDrop       = $_POST['orders'][$k]['drop_id'] ?? "";
                        $currentTripNumber = $_POST['orders'][$k]['trip_no'] ?? "";
                        if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop && $firstTripNumber == $currentTripNumber) {
                            $ordersList[]    = $_POST['orders'][$k] ?? "";
                            $customersList[] = $_POST['orders'][$k]['customer_id'] ?? "";
                            $dummyArray[]    = $_POST['orders'][$k]['delivery_note'] ?? "";
                        }
                    }
                }
            }
        }
        if (! empty($customersList)) {
            $getCustomerDetails = $this->db->query("SELECT id,code FROM tb_customers where code IN ? AND company_code LIKE ? AND status =? ORDER BY id DESC", [$customersList, 'SGKN', '1']);
            foreach ($getCustomerDetails->result_array() as $singleCustomer) {
                $allCustomers[$singleCustomer['code']] = $singleCustomer['id'];
            }
        }
        $shipperTypeId       = $partyTypeId       = $shipperPartyTypeId1       = $partyTypeId1       = 0;
        $getAllPartyTypesIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND status =? AND company_code LIKE ? GROUP BY name", [['Shipper', 'Consignee', 'Pickup', 'Delivery'], 1, 'SGKN']);
        foreach ($getAllPartyTypesIds->result_array() as $eachLine) {
            $partyTypeName = strtoupper($eachLine['name']);
            if ($partyTypeName == "PICKUP") {
                $shipperTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "DELIVERY") {
                $partyTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "SHIPPER") {
                $shipperPartyTypeId1 = $eachLine['id'];
            } elseif ($partyTypeName == "CONSIGNEE") {
                $partyTypeId1 = $eachLine['id'];
            }
        }
        $shipperTypeId       = $partyTypeId       = $shipperPartyTypeId1       = $partyTypeId1       = 0;
        $getAllPartyTypesIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND status =? AND company_code LIKE ? GROUP BY name", [['Shipper', 'Consignee', 'Pickup', 'Delivery'], 1, 'SGKN']);
        foreach ($getAllPartyTypesIds->result_array() as $eachLine) {
            $partyTypeName = strtoupper($eachLine['name']);
            if ($partyTypeName == "PICKUP") {
                $shipperTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "DELIVERY") {
                $partyTypeId = $eachLine['id'];
            } elseif ($partyTypeName == "SHIPPER") {
                $shipperPartyTypeId1 = $eachLine['id'];
            } elseif ($partyTypeName == "CONSIGNEE") {
                $partyTypeId1 = $eachLine['id'];
            }
        }

        if (! empty($ordersList)) {
            for ($i = 0, $iMax = count($ordersList); $i < $iMax; $i++) {
                $ordersList[$i]['shipper_type_id']   = $shipperTypeId;
                $ordersList[$i]['party_type_id']     = $partyTypeId;
                $ordersList[$i]['shipper_party_id1'] = $shipperPartyTypeId1;
                $ordersList[$i]['party_type_id1']    = $partyTypeId1;
                $data                                = $ordersList[$i];
                $firstCustomer                       = $ordersList[$j]['customer_id'] ?? "";
                $firstPickup                         = $ordersList[$j]['pickup_id'] ?? "";
                $firstDrop                           = $ordersList[$j]['drop_id'] ?? "";
                $firstCustomerReference              = $ordersList[$j]['delivery_note'] ?? "";
                $firstTripNumber                     = $ordersList[$j]['trip_no'] ?? "";
                $currentTripNumber                   = $ordersList[$i]['trip_no'] ?? "";
                if ($i == '0') {
                    $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                    if (! empty($ordersData)) {
                        $orders[]        = $ordersData['orders'] ?? [];
                        $excelFailOrders = $ordersData['excel_forders'] ?? [];
                    }
                } else {
                    $currentCustomer          = $ordersList[$i]['customer_id'] ?? "";
                    $currentPickup            = $ordersList[$i]['pickup_id'] ?? "";
                    $currentDrop              = $ordersList[$i]['drop_id'] ?? "";
                    $currentCustomerReference = $ordersList[$i]['delivery_note'] ?? "";
                    $currentDepartmentName    = $ordersList[$i]['deptname'] ?? "";
                    if ($currentCustomer == $firstCustomer && $currentPickup == $firstPickup && $currentDrop == $firstDrop) {
                        if ($firstTripNumber == $currentTripNumber) {
                            $currentCargo = $ordersList[$i]['cargo_details'] ?? [];
                            $this->updatecust_reffororder($firstCustomerReference, $currentCustomerReference, $currentDepartmentName, $currentCargo);
                        } else {
                            $j          = $i;
                            $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                            if (! empty($ordersData)) {
                                $orders[]        = $ordersData['orders'] ?? [];
                                $excelFailOrders = $ordersData['excel_forders'] ?? [];
                            }
                        }
                    } else {
                        $j          = $i;
                        $ordersData = $this->insertcust_reffororder($data, $allCustomers);
                        if (! empty($ordersData)) {
                            $orders[]        = $ordersData['orders'] ?? [];
                            $excelFailOrders = $ordersData['excel_forders'] ?? [];
                        }
                    }
                }
            }
        }       
        $excelSuccessOrders = $this->sgtripordershipment($orders);        
        if (! empty($excelFailOrders) && ! empty($excelSuccessOrders)) {
            $excelOrders = array_merge($excelFailOrders, $excelSuccessOrders);
        } else {
            if (! empty($excelSuccessOrders)) {
                $excelOrders = $excelSuccessOrders;
            } else {
                if (! empty($excelFailOrders)) {
                    $excelOrders = $excelFailOrders;
                }
            }
        }        
        if (! empty($excelOrders)) {            
            @file_put_contents(
                $_SERVER['DOCUMENT_ROOT'] . "/svkonekt_test/assets/ordertemplate/clexceluploaddata.txt",
                json_encode($excelOrders)
            );
        }
        redirect('smtcorders/orderslist/02');
    }

    public function insertcust_reffororder($data, $allCustomers): array
    {
        $userId            = $this->session->userdata('user_id');
        $companyCode       = $data['company_code'] ?? "";
        $branchCode        = $data['branch_code'] ?? "";
        $shipmentNumber    = $data['delivery_note'] ?? "";
        $deliveryNote      = $shipmentNumber;
        $checkDeliveryNote = $this->db->query("SELECT r.id FROM tb_order_references r,tb_orders o WHERE r.reference_id LIKE ? AND r.ref_value = ? AND r.status =? AND r.order_id=o.id AND o.status > ? AND o.user_id = ?", ['DQ', $deliveryNote, 1, 0, $userId]);
        if ($checkDeliveryNote->num_rows() > 0) {
            return [];
        }
        $noBookingIds  = $excelFailOrders  = [];
        $departmentode = $data['department_code'] ?? "";
        $service       = $data['service'] ?? "";
        if ($companyCode == "") {
            $companyCode = $this->session->userdata("company_code");
        }
        if ($branchCode == "") {
            $branchCode = $this->session->userdata("branch_code");
        }
        $serviceId = $product = $incoterm = "";
        if ($service != "") {
            $serviceId = $this->bpartners->getServiceForMDTExcel($service, $companyCode, $branchCode);
        }
        $earlyPickup    = $data['early_pickup'] ?? "";
        $latePickup     = $data['late_pickup'] ?? "";
        $earlyDelivery  = $data['early_drop'] ?? "";
        $lateDelivery   = $data['late_drop'] ?? "";
        $customerId     = $data['customer_id'] ?? "";
        $tripNumber     = $data['trip_no'] ?? "";
        $route          = $data['route'] ?? "";
        $driver         = $data['driver'] ?? "";
        $vehcileNumber  = $data['vehicle_no'] ?? "";
        $carrier        = $data['carrier'] ?? "";
        $departmentName = $data['deptname'] ?? "";
        $customerRowId  = 0;
        if ($customerId != "") {
            $customerRowId = $allCustomers[$customerId] ?? 0;
            if ($customerRowId == 0) {
                $getcustomerid = $this->db->query("SELECT id FROM tb_customers WHERE code LIKE ? AND company_code LIKE ? AND status = ? ORDER BY id DESC", [$customerId, $companyCode, 1]);
                if ($getcustomerid->num_rows() > 0) {
                    $customerRowId = $getcustomerid->row()->id;
                }
            }
        }
        $currentDate = $ePickup = date('Y-m-d H:i:s');
        if ($earlyPickup != "") {
            $ePickup = date('Y-m-d H:i:s', strtotime($earlyPickup));
        }
        if ($latePickup != "") {
            $lPickup = date('Y-m-d H:i:s', strtotime($latePickup));
        } else {
            $lPickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($ePickup)));
        }
        if ($earlyDelivery != "") {
            $eDelivery = date('Y-m-d H:i:s', strtotime($earlyDelivery));
        } else {
            $eDelivery = date('Y-m-d H:i:s', strtotime('+3 hour', strtotime($currentDate)));
        }
        if ($lateDelivery != "") {
            $lDelivery = date('Y-m-d H:i:s', strtotime($lateDelivery));
        } else {
            $lDelivery = date('Y-m-d H:i:s', strtotime('+4 hour', strtotime($currentDate)));
        }
        $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $logDate      = date('Y-m-d H:i:s');
        $getactual    = getdatetimebytimezone(DFLT_TZ, $logDate, $userTimeZone);
        $logDate      = $getactual['datetime'];
        $getpickup    = getdatetimebytimezone(DFLT_TZ, $ePickup, $userTimeZone);
        $ePickup      = $getpickup['datetime'];
        $getlpickup   = getdatetimebytimezone(DFLT_TZ, $lPickup, $userTimeZone);
        $lPickup      = $getlpickup['datetime'];
        $getdelivery  = getdatetimebytimezone(DFLT_TZ, $eDelivery, $userTimeZone);
        $eDelivery    = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $lDelivery, $userTimeZone);
        $lDelivery    = $getldelivery['datetime'];

        $pickupId        = $data['pickup_id'] ?? "";
        $pickupRowId     = $data['pickup_row_id'] ?? 0;
        $pickupName      = $data['pickup_name'] ?? "";
        $pickupStreet    = $data['pickup_street'] ?? "";
        $pickupCity      = $data['pickup_city'] ?? "";
        $pickupState     = $data['pickup_state'] ?? "";
        $pickupCountry   = $data['pickup_country'] ?? "";
        $pickupPincode   = $data['pickup_pincode'] ?? "";
        $shipperTypeId   = $data['shipper_type_id'] ?? 0;
        $pickupLatitude  = $data['pickup_latitude'] ?? "";
        $pickupLongitude = $data['pickup_longitude'] ?? "";
        $address         = $pickupStreet . ',' . $pickupCity . ',' . $pickupCountry;
        $shipperRowId    = 0;
        if ($pickupRowId > 0) {
            $shipperRowId = $pickupRowId;
        } else {
            if ($pickupId != "") {
                $pickup_info = $this->checkpartytypes($pickupId, 'PICKUP', '0');
                if (! empty($pickup_info)) {
                    $shipperRowId  = $pickup_info['id'];
                    $shipperTypeId = $pickup_info['party_type_id'];
                }
            }
        }

        $dropId          = $data['drop_id'] ?? "";
        $dropRowId       = $data['drop_row_id'] ?? 0;
        $dropName        = $data['drop_name'] ?? "";
        $dropStreet      = $data['drop_street'] ?? "";
        $dropCity        = $data['drop_city'] ?? "";
        $dropState       = $data['drop_state'] ?? "";
        $dropCountry     = $data['drop_country'] ?? "";
        $dropPincode     = $data['drop_pincode'] ?? "";
        $dropLatitude    = $data['drop_latitude'] ?? "";
        $dropLongitude   = $data['drop_longitude'] ?? "";
        $daddress        = $dropStreet . ',' . $dropCity . ',' . $dropCountry;
        $shipperCode     = $data['shipper_code'] ?? "";
        $consigneeCode   = $data['consignee_code'] ?? "";
        $shipperRowId1   = $data['shipper_row_id'] ?? 0;
        $partyRowId1     = $data['consignee_row_id'] ?? 0;
        $partyTypeId     = $data['party_type_id'] ?? 0;
        $shipperPartyId1 = $data['shipper_party_id1'] ?? 0;
        $partyTypeId1    = $data['party_type_id1'] ?? 0;
        if ($consigneeCode == "") {
            $consigneeCode = $dropId;
        }
        if ($shipperCode == "") {
            $shipperCode = $pickupId;
        }
        if ($dropRowId == 0) {
            if ($dropId != "") {
                $drop_info = $this->checkpartytypes($dropId, 'DELIVERY', '0');
                if (! empty($drop_info)) {
                    $dropRowId   = $drop_info['id'];
                    $partyTypeId = $drop_info['party_type_id'];
                }
            }
        }
        if ($shipperRowId1 == 0) {
            if ($shipperCode != "") {
                $shipperInfo   = $this->checkpartytypes($shipperCode, 'SHIPPER', '0');
                $shipperRowId1 = $shipperInfo['id'];
            }
        }
        if ($partyRowId1 == 0) {
            if ($consigneeCode != "") {
                $consigneeInfo = $this->checkpartytypes($consigneeCode, 'CONSIGNEE', '0');
                $partyRowId1   = $consigneeInfo['id'];
            }
        }
        $endDate           = date('Y-m-d H:i:s', strtotime("+1 day"));
        $transportModeId   = 1;
        $transportModeName = "Less Than TruckLoad";
        $transportMode     = "LTL";
        $getTransportMode  = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $transportMode . "'");
        if ($getTransportMode->num_rows() > 0) {
            $transportModeId   = $getTransportMode->row()->id;
            $transportModeName = $getTransportMode->row()->name;
        }
        $shipid = "SVK" . time();
        if ($shipmentNumber == "") {
            $shipmentNumber = $shipid;
        }
        $shipmentArray = [
            'unitspec'         => 1,
            'shipid'           => $shipid,
            'txnid'            => $shipmentNumber,
            'trucktype'        => $transportModeName,
            'pickupcnt'        => '1',
            'dropcnt'          => '1',
            'insertusr'        => $pickupId,
            'carrier'          => '0',
            'insertuserdate'   => $currentDate,
            'enddate'          => $endDate,
            'insdate'          => $currentDate,
            'upddate'          => $currentDate,
            'reason'           => 'SHIPMENT',
            'purpose'          => 'SEND INTEGRATION',
            'ship_object'      => 'SHIPMENT',
            'logdate'          => $currentDate,
            'transport_mode'   => $transportMode,
            'domainname'       => $branchCode,
            'company_code'     => $companyCode,
            'branch_code'      => $branchCode,
            'product'          => $product,
            'freight_term'     => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm'         => $incoterm,
            'modeoftransport'  => $transportModeId,
        ];
        $checkShipmentId = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipid . "'");
        if ($checkShipmentId->num_rows() > 0) {
            $shipmentRowId = $checkShipmentId->row()->id;
            $this->db->where(['id' => $shipmentRowId])->update("tb_shipments", $shipmentArray);
        } else {
            $shipmentArray['createdon'] = $currentDate;
            $shipmentRowId              = $this->common->insertTableData("tb_shipments", $shipmentArray);
        }
        if ($pickupLatitude != "" && $pickupLongitude != "" && $dropLatitude != "" && $dropLongitude != "") {
            $lat1 = $pickupLatitude ?? "";
            $lng1 = $pickupLongitude ?? "";
            $lat2 = $dropLatitude ?? "";
            $lng2 = $dropLongitude ?? "";
        } else {
            $add1 = implode(",", [$pickupStreet, $pickupCity, $pickupCountry, $pickupPincode]);
            $add2 = implode(",", [$dropStreet, $dropCity, $dropCountry, $dropPincode]);
            $loc  = getlatlngsbyplace($add1);
            $lat1 = $loc[0] ?? null;
            $lng1 = $loc[1] ?? null;
            $loc  = getlatlngsbyplace($add2);
            $lat2 = $loc[0] ?? null;
            $lng2 = $loc[1] ?? null;
        }
        $goodsValue = "0.00";
        $childId    = 0;
        if ($this->session->userdata('childid')) {
            $childId = $this->session->userdata('childid');
        }
        $ins = [
            'shipment_id'       => $shipmentRowId,
            'customer_id'       => $customerRowId,
            'drop_custid'       => $dropId,
            'drop_partyid'      => $dropId,
            'product'           => $product,
            'goods_value'       => $goodsValue,
            'company_code'      => $companyCode,
            'branch_code'       => $branchCode,
            'pickup_datetime'   => $ePickup,
            'delivery_datetime' => $eDelivery,
            'pickup_endtime'    => $lPickup,
            'drop_endtime'      => $lDelivery,
            'createdon'         => $currentDate,
            'user_id'           => $userId,
            'sub_uid'           => $childId,
            'pickup_custid'     => $pickupId,
            'pickup_partyid'    => $pickupId,
            'pickup_country'    => $pickupCountry,
            'pickup_city'       => $pickupCity,
            'pickup_pincode'    => $pickupPincode,
            'pickup_company'    => $pickupName,
            'pickup_address1'   => $pickupStreet,
            'pickup_address2'   => $pickupState,
            'delivery_country'  => $dropCountry,
            'delivery_city'     => $dropCity,
            'delivery_pincode'  => $dropPincode,
            'delivery_company'  => $dropName,
            'delivery_address1' => $dropStreet,
            'delivery_address2' => $dropState,
            'transport_mode'    => $transportMode,
            'plat'              => $lat1,
            'plng'              => $lng1,
            'dlat'              => $lat2,
            'dlng'              => $lng2,
            'modeoftransport'   => $transportModeId,
            'created_source'    => '4',
            'createdon'         => $logDate,
            'shipper_id'        => $shipperRowId1,
            'consignee_id'      => $partyRowId1,
        ];
        $orderId = $this->common->insertTableData("tb_orders", $ins);
        if ($orderId == 0) {
            if (in_array($deliveryNote, $noBookingIds)) {
            } else {
                $noBookingIds[]    = $deliveryNote;
                $excelFailOrders[] = ['order_id' => '0', 'customer_id' => $customerId, 'delivery_note' => '', 'booking_id' => 'DQ-' . $deliveryNote, 'trip_id' => '-', 'status' => 'Fail'];
            }
        } else {
            if ($userId != "") {
                $getCountry           = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $userId]);
                $countryCode          = $getCountry->row()->country_code;
                $companyCode          = $getCountry->row()->company_code;
                $generateOrderIdArray = ["user_id" => $userId, "order_id" => $orderId, "country_code" => $countryCode, "company_code" => $companyCode];
                $bookingId            = generatebookingid($generateOrderIdArray);
                makeorderinvolvedpartiestype($customerRowId, $orderId, "CUSTOMER", $userId, $companyCode);
                insertOrdersRefFileLineIdentifier(['pickupCity' => $pickupCity, 'pickupState' => $pickupState, 'pickupCountry' => $pickupCountry, 'dropCity' => $dropCity, 'dropState' => $dropState, 'dropCountry' => $dropCountry, 'companyCode' => $companyCode, 'branchCode' => $branchCode, 'orderRowId' => $orderId, 'date' => $currentDate]);
                $this->db->where(['id' => $orderId])->update("tb_orders", ['order_id' => $bookingId]);
                $details = ['service' => $serviceId, 'department_code' => $departmentode, 'delivery_term' => "", 'incoterm' => $incoterm, 'purchase_order' => '0', 'notify_party' => '0', 'lane_reference' => '0', 'distance' => '0', 'temperature_control' => '0', 'valorance_insurance' => '0', 'high_cargo_value' => '0', 'customs_required' => '0', 'order_id' => $bookingId, 'order_row_id' => $orderId, 'createdon' => $currentDate, 'shipper_id' => $shipperRowId, 'order_type' => ''];
                $this->db->insert("tb_order_details", $details);
                if ($shipperRowId != 0) {
                    $orderParties = ['order_id' => $orderId, 'party_id' => $shipperRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $shipperTypeId];
                    $this->db->insert("tb_order_parties", $orderParties);
                    $shipperAddress      = ['order_id' => $orderId, 'party_master_id' => $shipperRowId, 'location_id' => $pickupCity, 'street' => $pickupStreet, 'state' => $pickupState, 'address' => $address, 'pincode' => $pickupPincode, 'country' => $pickupCountry, 'user_id' => $userId];
                    $checkShipperAddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $shipperRowId]);
                    if ($checkShipperAddress->num_rows() > 0) {
                        $shipperAddressId = $checkShipperAddress->row()->id;
                        $this->db->where(['id' => $shipperAddressId])->update("tbl_orderparty_address", $shipperAddress);
                    } else {
                        $shipperAddress['createdon'] = $currentDate;
                        $this->common->insertTableData("tbl_orderparty_address", $shipperAddress);
                    }
                }
                if ($dropRowId != 0) {
                    $orderParties = ['order_id' => $orderId, 'party_id' => $dropRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $partyTypeId];
                    $this->db->insert("tb_order_parties", $orderParties);
                    $dropAddress      = ['order_id' => $orderId, 'party_master_id' => $dropRowId, 'location_id' => $dropCity, 'street' => $dropStreet, 'state' => $dropState, 'address' => $daddress, 'pincode' => $dropPincode, 'country' => $dropCountry, 'user_id' => $userId];
                    $checkDropAddress = $this->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $dropRowId]);
                    if ($checkDropAddress->num_rows() > 0) {
                        $dropAddressId = $checkDropAddress->row()->id;
                        $this->db->where(['id' => $dropAddressId])->update("tbl_orderparty_address", $dropAddress);
                    } else {
                        $dropAddress['createdon'] = $currentDate;
                        $this->common->insertTableData("tbl_orderparty_address", $dropAddress);
                    }
                }
                if ($shipmentNumber != "") {
                    $referenceInsertArray = ['order_id' => $orderId, 'reference_id' => 'DQ', 'ref_value' => $shipmentNumber, 'createdon' => $currentDate];
                    $this->db->insert('tb_order_references', $referenceInsertArray);
                }
            }
            if ($shipperPartyId1 > 0) {
                $orderParties = ['order_id' => $orderId, 'party_id' => $shipperRowId1, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $shipperPartyId1];
                $this->db->insert("tb_order_parties", $orderParties);
            }
            if ($partyTypeId1 > 0) {
                $orderParties = ['order_id' => $orderId, 'party_id' => $partyRowId1, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $partyTypeId1];
                $this->db->insert("tb_order_parties", $orderParties);
            }
            if ($departmentName != "") {
                $div_reference = ['order_id' => $orderId, 'ref_value' => $departmentName, 'reference_id' => 'DIV', 'status' => '1', 'createdon' => $currentDate];
                $this->db->insert("tb_order_references", $div_reference);
            }
            $cargo = $data['cargo_details'] ?? [];
            if (! empty($cargo)) {
                foreach ($cargo as $car) {
                    $cargoType        = $car['cargo_type'] ?? "";
                    $goodsDescription = $car['goods_description'] ?? "";
                    $quantity         = $car['quantity'] ?? "";
                    $length           = $car['length'] ?? "";
                    $lengthUom        = $car['length_uom'] ?? "m";
                    $width            = $car['width'] ?? "";
                    $widthUom         = $car['width_uom'] ?? "m";
                    $height           = $car['height'] ?? "";
                    $heightUom        = $car['height_uom'] ?? "m";
                    $weight           = $car['weight'] ?? "";
                    $weightUom        = $car['weight_uom'] ?? "kg";
                    $volume           = $car['volume'] ?? "";
                    $volumeUom        = $car['volume_uom'] ?? "cbm";
                    $stackable        = $car['stackable'] ?? "";
                    if ($stackable == 'on') {
                        $stackable = 1;
                    } else {
                        $stackable = 0;
                    }
                    $cargoDetails    = ['cargo_type' => $cargoType, 'goods_description' => $goodsDescription, 'quantity' => $quantity, 'length' => $length, 'length_unit' => $lengthUom, 'width' => $width, 'width_unit' => $widthUom, 'height' => $height, 'height_unit' => $heightUom, 'weight' => $weight, 'weight_unit' => $weightUom, 'volume' => $volume, 'volume_unit' => $volumeUom, 'stackable' => $stackable, 'createdby' => $userId, 'createdon' => $currentDate];
                    $cargoRowId      = $this->common->insertTableData("tb_cargo_details", $cargoDetails);
                    $getHandlingUnit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargoType . "'");
                    $handlingUnit    = "";
                    if ($getHandlingUnit->num_rows() > 0) {
                        $handlingUnit = $getHandlingUnit->row()->id;
                    } else {
                        $handlingunit_ar = ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $userId, 'created_at' => $currentDate, 'status' => '1'];
                        $handlingUnit    = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                    }
                    $orderCargo = ['order_id' => $orderId, 'quantity' => $quantity, 'cargo_id' => $cargoRowId, 'status' => '1', 'createdon' => $currentDate, 'cargo_content' => $goodsDescription, 'quantity_type' => $cargoType, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'handling_unit' => $handlingUnit];
                    $this->db->insert("tb_order_cargodetails", $orderCargo);
                }
            }
            $cargoForShipmet = [];
            $getCargos       = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='" . $orderId . "'");
            if ($getCargos->num_rows() > 0) {
                foreach ($getCargos->result() as $res) {
                    $cargoForShipmet[] = $res->quantity_type;
                }
            }
            $unitSpec = "1";
            if (! empty($cargoForShipmet)) {
                $unitSpec = implode(',', $cargoForShipmet);
            }
            $this->db->where(['id' => $shipmentRowId])->update("tb_shipments", ['unitspec' => $unitSpec, 'txncode' => $bookingId]);
            $totalWeight        = $totalVolume        = $totalQuantity        = 0;
            $getTotalDimensions = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $orderId . "'");
            if ($getTotalDimensions->num_rows() > 0) {
                $totalVolume   = $getTotalDimensions->row()->total_volume;
                $totalWeight   = $getTotalDimensions->row()->total_weight;
                $totalQuantity = $getTotalDimensions->row()->total_quantity;
            }
            $this->db->where(['id' => $orderId])->update("tb_orders", ['volume' => $totalVolume, 'weight' => $totalWeight, 'quantity' => $totalQuantity]);
            $reference = $data['reference'] ?? [];
            if (! empty($reference)) {
                foreach ($reference as $ref) {
                    $referenceId    = $ref['reference_id'] ?? "";
                    $referenceName  = $ref['reference_name'] ?? "";
                    $referenceValue = $ref['reference_value'] ?? "";
                    $getReferenceId = $this->db->select('id')->get_where("tb_reference_master", ['name' => $referenceId]);
                    if ($getReferenceId->num_rows() > 0) {
                        $this->db->insert('tb_order_references', ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                    } else {
                        $this->db->insert('tb_reference_master', ['name' => $referenceId, 'description' => $referenceName, 'status' => '1', 'createdon' => $currentDate]);
                        $this->db->insert('tb_order_references', ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                    }
                }
            }
            $orders   = ['order_id' => $orderId, 'booking_id' => $bookingId, 'carrier' => $carrier, 'vehicle_no' => $vehcileNumber, 'driver' => $driver, 'route' => $route, 'trip_no' => $tripNumber];
            $response = ['orders' => $orders, 'excel_forders' => $excelFailOrders];
            try {
                $this->altovaordercreation->sendOrderToAltova($orderId);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
            }
        }
        return $response;
    }

    public function updatecust_reffororder($past_ref, $new_ref, $new_deptname, $cargo)
    {
        $order_id = 0;
        $user_id  = $this->session->userdata('user_id');
        $cdate    = date('Y-m-d H:i:s');
        if ($past_ref != "" && $past_ref != '0') {
            $getdata = $this->common->gettblrowdata(['ref_value' => $past_ref, 'status' => '1'], "order_id", "tb_order_references", 0, 0);
            if (! empty($getdata)) {
                $order_id = $getdata['order_id'];
                if ($order_id != "0") {
                    $ref_ar = ['order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $new_ref, 'status' => '1', 'createdon' => $cdate];
                    $chk1   = $this->common->gettblrowdata(['ref_value' => $new_ref, 'order_id' => $order_id, 'status' => '1'], "id", "tb_order_references", 0, 0);
                    if (empty($chk1)) {
                        $ref_ins = $this->common->insertTableData("tb_order_references", $ref_ar);
                    }

                    $dept_ar = ['order_id' => $order_id, 'reference_id' => 'DIV', 'ref_value' => $new_deptname, 'status' => '1', 'createdon' => $cdate];
                    $chk2    = $this->common->gettblrowdata(['ref_value' => $new_deptname, 'order_id' => $order_id, 'status' => '1'], "id", "tb_order_references", 0, 0);
                    if (empty($chk2)) {
                        $dept_ins = $this->common->insertTableData("tb_order_references", $dept_ar);
                    }
                    if (! empty($cargo[0])) {
                        $cargo_type = $cargo[0]['cargo_type'];
                        $length     = $cargo[0]['length'];
                        if ($length == "") {
                            $length = 0;
                        }
                        $width = $cargo[0]['width'];
                        if ($width == "") {
                            $width = 0;
                        }
                        $height = $cargo[0]['height'];
                        if ($height == "") {
                            $height = 0;
                        }
                        $weight = $cargo[0]['weight'];
                        if ($weight == "") {
                            $weight = 0;
                        }
                        $volume = $cargo[0]['volume'];
                        if ($volume == "") {
                            $volume = 0;
                        }
                        $quantity = $cargo[0]['quantity'];
                        if ($quantity == "0" || $quantity == "") {
                            $quantity = 1;
                        }
                        $stackable = 0;
                        $stack     = strtoupper($cargo[0]['stackable']);
                        if ($stack == "" || $stack == 'OFF' || $stack == '0') {
                            $stackable = 0;
                        } else {
                            if ($stack == "ON" && $stack == '1') {
                                $stackable = 1;
                            }
                        }
                        $handling_unit_id = 0;
                        if ($cargo_type != "") {
                            $chkhandling_unit = $this->common->gettblrowdata(['unit_name' => $cargo_type, 'status' => '1'], "id", "tbl_shipunit_types", 0, 0);
                            if (! empty($chkhandling_unit)) {
                                $handling_unit_id = $chkhandling_unit['id'];
                            } else {
                                $handling_ar      = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'status' => '1', 'created_at' => $cdate];
                                $handling_unit_id = $this->common->insertTableData("tbl_shipunit_types", $handling_ar);
                            }

                            $cargo_ins = ['cargo_type' => $cargo_type, 'handling_unit' => $cargo_type, 'handlingunit_id' => $handling_unit_id, 'length' => $length, 'length_unit' => 'm', 'width' => $width, 'height' => $height, 'height_unit' => 'm', 'weight' => $weight, 'weight_unit' => 'kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'quantity' => $quantity, 'stackable' => $stackable, 'status' => '1', 'createdon' => $cdate];
                            $cargo_id  = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
                            $chkcargo  = $this->common->gettblrowdata(['quantity_type' => $cargo_type, 'status' => '1', 'order_id' => $order_id], "id,quantity", "tb_order_cargodetails", 0, 0);
                            if (! empty($chkcargo)) {
                                $order_cargo_row_id   = $chkcargo['id'];
                                $order_cargo_quantity = $chkcargo['quantity'];
                                $original_quantity    = $order_cargo_quantity + $quantity;
                                $upd                  = $this->common->updatetbledata("tb_order_cargodetails", ['quantity' => $original_quantity], ["id" => $order_cargo_row_id]);
                            } else {
                                $order_cargo   = ['order_id' => $order_id, 'cargo_id' => $cargo_id, 'handling_unit' => $handling_unit_id, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $quantity, 'quantity_type' => $cargo_type, 'status' => '1', 'createdon' => $cdate];
                                $order_argo_id = $this->common->insertTableData("tb_order_cargodetails", $order_cargo);
                            }
                        }
                    }
                }
            }
        }
    }

    public function sgtripordershipment($orders)
    {
        $dummy_array  = $nobooking_ids  = $excel_sorders  = [];
        $countryid    = $this->session->userdata("usr_tzone")['phone_code'];
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        if (! empty($orders)) {
            for ($i = 0, $iMax = count($orders); $i < $iMax; $i++) {
                $order_forshift  = $orders[$i]['order_id'];
                $vendor_forship  = $orders[$i]['carrier'];
                $vehicle_forship = $orders[$i]['vehicle_no'];
                $driver_forship  = $orders[$i]['driver'];
                $route_forship   = $orders[$i]['route'];
                $booking_forship = $orders[$i]['booking_id'];
                $trip_forship    = $orders[$i]['trip_no'];
                if (! in_array($orders[$i]['order_id'], $dummy_array)) {
                    for ($k = 0, $kMax = count($orders); $k < $kMax; $k++) {
                        $order_id        = $orders[$k]['order_id'];
                        $booking_id      = $orders[$k]['booking_id'];
                        $vendor_code     = $orders[$k]['carrier'];
                        $register_number = $orders[$k]['vehicle_no'];
                        $trip_no         = $orders[$k]['trip_no'];
                        $driver          = $orders[$k]['driver'];
                        $route           = $orders[$k]['route'];
                        if ($trip_forship == $trip_no && $route_forship == $route && $driver_forship == $driver && $vehicle_forship == $register_number && $vendor_forship == $vendor_code) {
                            $ord[]         = $orders[$k];
                            $dummy_array[] = $orders[$k]['order_id'];
                        }
                    }
                }
            }
        }
        $j = 0;
        for ($i = 0, $iMax = count($ord); $i < $iMax; $i++) {
            if ($j == '0') {
                $order_forshift  = $ord[0]['order_id'];
                $vendor_forship  = $ord[0]['carrier'];
                $vehicle_forship = $ord[0]['vehicle_no'];
                $driver_forship  = $ord[0]['driver'];
                $route_forship   = $ord[0]['route'];
                $booking_forship = $ord[0]['booking_id'];
                $trip_forship    = $ord[0]['trip_no'];
            } else {
                $order_forshift  = $ord[$j]['order_id'];
                $vendor_forship  = $ord[$j]['carrier'];
                $vehicle_forship = $ord[$j]['vehicle_no'];
                $driver_forship  = $ord[$j]['driver'];
                $route_forship   = $ord[$j]['route'];
                $booking_forship = $ord[$j]['booking_id'];
                $trip_forship    = $ord[$j]['trip_no'];
            }

            $order_id        = $ord[$i]['order_id'];
            $booking_id      = $ord[$i]['booking_id'];
            $vendor_code     = $ord[$i]['carrier'];
            $register_number = $ord[$i]['vehicle_no'];
            $trip_no         = $ord[$i]['trip_no'];
            $driver          = $ord[$i]['driver'];
            $route           = $ord[$i]['route'];
            $count_code      = substr($company_code, 0, 2);

            $txnid   = time();
            $year    = date('y');
            $week    = date('W');
            $seq_num = 000001;
            if ($booking_forship != "" && $booking_forship != '') {
                $seq_num = substr($booking_forship, -6);
            }
            $shipid = $txnid = "T" . $count_code . $week . $year . $seq_num;

            $response       = 0;
            $user_id        = $this->session->userdata('user_id');
            $userid         = $this->session->userdata('user_id');
            $curtz          = $this->session->userdata("usr_tzone")['timezone'];
            $logdate        = date('Y-m-d H:i:s');
            $tpvehicle_type = 1;
            $getactual      = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt          = $getactual['datetime'];
            $input          = $this->input->post(null, true);
            $where          = ['code' => $vendor_code, 'status' => '1'];
            $select         = "id,name";
            $table          = "tb_vendors";
            $vendor_id      = 0;
            $vendor_name    = "";
            $vendor_details = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($vendor_details) > 0) {
                $vendor_id   = $vendor_details['id'];
                $vendor_name = $vendor_details['name'];
            }
            if ($vendor_id != 0) {
                $vslt            = "id";
                $vwhr            = ['register_number' => $register_number, 'status' => 'Active', 'vendor_id' => $vendor_id];
                $vtbl            = "tb_trucks_data";
                $vehicle_details = $this->common->gettblrowdata($vwhr, $vslt, $vtbl, 0, 0);
                if (count($vehicle_details) > 0) {
                    $vehicle_id = $vehicle_details['id'];
                } else {
                    $vwhr      = ['register_number' => $register_number, 'status' => 'Active'];
                    $v1details = $this->common->gettblrowdata($vwhr, $vslt, $vtbl, 0, 0);
                    if (count($v1details) > 0) {
                        $vehicle_id = $v1details['id'];
                        $tablename  = "tb_trucks_data";
                        $set        = ["vendor_id" => $vendor_id];
                        $whr        = ['id' => $vehicle_id];
                        $upd        = $this->common->updatetbledata($tablename, $set, $whr);
                    } else {
                        $instable   = "tb_trucks_data";
                        $insdata    = ['truck_number' => $register_number, 'length' => '0', 'breadth' => '0', 'truck_capacity' => '1', 'truck_type' => '1', 'register_number' => $register_number, 'route' => $register_number, 'user_id' => $user_id, 'vendor_id' => $vendor_id, 'status' => 'Active', 'createdon' => $logdate];
                        $vehicle_id = $this->common->insertTableData($instable, $insdata);
                    }
                }
            }
            $driver_id = 0;
            if ($driver != "") {
                $dwhr          = ['name' => $driver];
                $dslt          = "id";
                $dtbl          = "tb_truck_drivers";
                $driverdetails = $this->common->gettblrowdata($dwhr, $dslt, $dtbl, 0, 0);
                if (count($driverdetails) > 0) {
                    $driver_id = $driverdetails['id'];
                } else {
                    $dinstable  = "tb_truck_drivers";
                    $pwd        = RandomString::generate(10);
                    $password   = password_hash($pwd, PASSWORD_DEFAULT);
                    $mobile     = time();
                    $dinsdata   = ['name' => $driver, 'password' => $password, 'contact_num' => $mobile, 'createdby' => $user_id, 'user_id' => $user_id, 'vendor_id' => $vendor_id, 'status' => 'Active', 'company_code' => $company_code, 'branch_code' => $branch_code, 'createdon' => $logdate];
                    $vehicle_id = $this->common->insertTableData($dinstable, $dinsdata);
                }
            }
            $sid = $order_id;
            if ($shipid != "" && $vendor_id > 0 && $order_id > 0) {
                $where  = ["id" => $order_id];
                $select = "*";
                $table  = "tb_orders";
                $order  = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (count($order) > 0) {
                    $shift_idchk     = $order['shift_id'];
                    $booking_id      = $order['order_id'];
                    $customer_code   = $order['customer_id'];
                    $getcustomercode = $this->common->gettblrowdata(['id' => $customer_code], "code", "tb_customers", 0, 0);
                    if (! empty($getcustomercode)) {
                        $customer_code = $getcustomercode['code'];
                    }
                    if ($shift_idchk == 0) {
                        $stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                        $pickup      = $order['pickup_address1'];
                        if ($pickup == "") {
                            $pickup = $order['pickup_city'];
                        }
                        $delivery = $order['delivery_address1'];
                        if ($delivery == "") {
                            $delivery = $order['delivery_city'];
                        }
                        $address = $dropaddr = "";
                        if ($order['pickup_address1'] != "") {
                            $address .= $order['pickup_address1'];
                            $dropaddr .= $order['delivery_address1'];
                        }
                        if ($order['pickup_company'] != "") {
                            $address .= ", " . $order['pickup_company'];
                            $dropaddr .= ", " . $order['delivery_company'];
                        }
                        if ($order['pickup_country'] != "") {
                            $address .= ", " . $order['pickup_country'];
                            $dropaddr .= ", " . $order['delivery_country'];
                        }
                        if ($order['pickup_city'] != "") {
                            $address .= ", " . $order['pickup_city'];
                            $dropaddr .= ", " . $order['delivery_city'];
                        }
                        if ($order['pickup_pincode'] != "") {
                            $address .= ", " . $order['pickup_pincode'];
                            $dropaddr .= ", " . $order['delivery_pincode'];
                        }
                        $plat = $order['plat'];
                        $plng = $order['plng'];
                        $dlat = $order['dlat'];
                        $dlng = $order['dlng'];
                        if ($i == '0') {
                            $where    = ["shipmentid" => $shipid];
                            $select   = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                            $table    = "tb_shifts";
                            $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($shipment) == 0) {
                                $curdt          = $logdate;
                                $splace         = $order['pickup_address1'];
                                $eplace         = $order['delivery_address1'];
                                $pickup_city    = $order['pickup_city'];
                                $delivery_city  = $order['delivery_city'];
                                $customer_id    = $order['customer_id'];
                                $transport_mode = $order['transport_mode'];
                                $weight         = $order['weight'];
                                $volume         = $order['volume'];
                                $txnid          = $shipid;
                                if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                    $vtwhere  = ["id" => $tpvehicle_type];
                                    $vtselect = "trucktype";
                                    $vttable  = "tb_trucktypes";
                                    $vtorder  = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                    if (count($vtorder) > 0) {
                                        $vehicle_type = $vtorder['trucktype'];
                                    } else {
                                        $vehicle_type = $order['vehicle_type'];
                                    }
                                } else {
                                    $vehicle_type = $order['vehicle_type'];
                                }
                                $startdate = $order['pickup_datetime'];
                                $starttime = date('H:i', strtotime($startdate));
                                $enddate   = $order['delivery_datetime'];
                                $endtime   = date('H:i', strtotime($enddate));
                                $insarr    = [
                                    'user_id'        => $userid,
                                    'stime'          => $starttime,
                                    'etime'          => $endtime,
                                    'splace'         => $order['pickup_city'],
                                    'slat'           => $plat,
                                    'slng'           => $plng,
                                    'eplace'         => $order['delivery_city'],
                                    'elat'           => $dlat,
                                    'elng'           => $dlng,
                                    'scity'          => $order['pickup_city'],
                                    'dcity'          => $order['delivery_city'],
                                    'zone_id'        => 1,
                                    'empshift_start' => $starttime,
                                    'empshift_end'   => $endtime,
                                    'trip_type'      => 0,
                                    'startdate'      => $startdate,
                                    'enddate'        => $enddate,
                                    'shipment_name'  => 'Boxes',
                                    'shipment_id'    => 0,
                                    'transport_mode' => $transport_mode,
                                    'customer_id'    => $customer_id,
                                    'vendor_id'      => $vendor_id,
                                    'carrier_type'   => 0,
                                    'shipmentid'     => $txnid,
                                    'txnid'          => $txnid,
                                    'weight'         => $weight,
                                    'volume'         => $volume,
                                    'units'          => $order['quantity'],
                                    'domainname'     => 'INFD',
                                    'vehicle_type'   => $vehicle_type,
                                    'company_code'   => $company_code,
                                    'branch_code'    => $branch_code,
                                    'status'         => 1,
                                ];
                                $this->db->insert("tb_shifts", $insarr);
                                $ship_id = $this->db->insert_id();
                            } else {
                                $ship_id = $shipment['id'];
                            }
                        } else {
                            if ($trip_forship == $trip_no && $route_forship == $route && $driver_forship == $driver && $vehicle_forship == $register_number && $vendor_forship == $vendor_code) {
                                $ship_id      = $txnid      = "0";
                                $getshiftdata = $this->db->select("shift_id,shipmentid")->get_where("tb_orders", ['id' => $order_forshift]);
                                if ($getshiftdata->num_rows() > 0) {
                                    $ship_id = $getshiftdata->row()->shift_id;
                                    $txnid   = $getshiftdata->row()->shipmentid;
                                }
                            } else {
                                $j               = $i;
                                $booking_forship = $ord[$j]['booking_id'];
                                if ($booking_forship != "" && $booking_forship != '') {
                                    $seq_num = substr($booking_forship, -6);
                                }
                                $shipid   = $txnid   = "T" . $count_code . $week . $year . $seq_num;
                                $where    = ["shipmentid" => $shipid];
                                $select   = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                                $table    = "tb_shifts";
                                $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                                if (count($shipment) == 0) {
                                    $curdt          = $logdate;
                                    $splace         = $order['pickup_address1'];
                                    $eplace         = $order['delivery_address1'];
                                    $pickup_city    = $order['pickup_city'];
                                    $delivery_city  = $order['delivery_city'];
                                    $customer_id    = $order['customer_id'];
                                    $transport_mode = $order['transport_mode'];
                                    $weight         = $order['weight'];
                                    $volume         = $order['volume'];
                                    $txnid          = $shipid;
                                    if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                                        $vtwhere  = ["id" => $tpvehicle_type];
                                        $vtselect = "trucktype";
                                        $vttable  = "tb_trucktypes";
                                        $vtorder  = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                                        if (count($vtorder) > 0) {
                                            $vehicle_type = $vtorder['trucktype'];
                                        } else {
                                            $vehicle_type = $order['vehicle_type'];
                                        }
                                    } else {
                                        $vehicle_type = $order['vehicle_type'];
                                    }
                                    $startdate = $order['pickup_datetime'];
                                    $starttime = date('H:i', strtotime($startdate));
                                    $enddate   = $order['delivery_datetime'];
                                    $endtime   = date('H:i', strtotime($enddate));
                                    $insarr    = [
                                        'user_id'        => $userid,
                                        'stime'          => $starttime,
                                        'etime'          => $endtime,
                                        'splace'         => $order['pickup_city'],
                                        'slat'           => $plat,
                                        'slng'           => $plng,
                                        'eplace'         => $order['delivery_city'],
                                        'elat'           => $dlat,
                                        'elng'           => $dlng,
                                        'scity'          => $order['pickup_city'],
                                        'dcity'          => $order['delivery_city'],
                                        'zone_id'        => 1,
                                        'empshift_start' => $starttime,
                                        'empshift_end'   => $endtime,
                                        'trip_type'      => 0,
                                        'startdate'      => $startdate,
                                        'enddate'        => $enddate,
                                        'shipment_name'  => 'Boxes',
                                        'shipment_id'    => 0,
                                        'transport_mode' => $transport_mode,
                                        'customer_id'    => $customer_id,
                                        'vendor_id'      => $vendor_id,
                                        'carrier_type'   => 0,
                                        'shipmentid'     => $txnid,
                                        'txnid'          => $txnid,
                                        'weight'         => $weight,
                                        'volume'         => $volume,
                                        'units'          => $order['quantity'],
                                        'domainname'     => 'INFD',
                                        'vehicle_type'   => $vehicle_type,
                                        'company_code'   => $company_code,
                                        'branch_code'    => $branch_code,
                                        'status'         => 1,
                                    ];
                                    $this->db->insert("tb_shifts", $insarr);
                                    $ship_id = $this->db->insert_id();
                                } else {
                                    $ship_id = $shipment['id'];
                                }
                            }
                        }

                        /*update order table*/
                        $capacity = $order['weight'];
                        if ($capacity == "") {
                            $capacity = "0";
                        }
                        $upddt    = ['vendor_id' => $vendor_id, 'shift_id' => $ship_id, "shipmentid" => $txnid];
                        $updwhr   = ["id" => $order_id];
                        $upd      = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                        $invtypes = makeorderinvolvedpartiestype($vendor_id, $order_id, "CARRIER", $userid, $company_code);
                        if (in_array($booking_id, $nobooking_ids)) {
                        } else {
                            $nobooking_ids[] = $booking_id;
                            $excel_sorders[] = ['order_id' => $order_id, 'customer_id' => $customer_code, 'booking_id' => $booking_id, 'trip_id' => $txnid, 'delivery_note' => '', 'status' => 'Success'];
                        }
                        $insarr = [
                            'assoc_id'        => $txnid,
                            'pickup'          => $pickup,
                            'plat'            => $plat,
                            'plng'            => $plng,
                            'drop'            => $delivery,
                            'dlat'            => $dlat,
                            'dlng'            => $dlng,
                            'pickup_city'     => $order['pickup_city'],
                            'drop_city'       => $order['delivery_city'],
                            'pickup_datetime' => $order['pickup_datetime'],
                            'drop_datetime'   => $order['delivery_datetime'],
                            'name'            => 'Boxes',
                            'phone'           => $order['customer_phone'],
                            'address'         => $address,
                            'emailid'         => $order['customer_email'],
                            'user_id'         => $userid,
                            'status'          => 1,
                            'createdon'       => $curdt,
                            'material_id'     => 0,
                            'capacity'        => $capacity,
                            'information'     => $order['customer_comments'],
                            'shipment_weight' => $order['weight'],
                            'shipment_volume' => $order['volume'],
                            'ship_type'       => 'P',
                            'customer_id'     => $order['customer_id'],
                            'vendor_id'       => $vendor_id,
                            'shipment_id'     => 0,
                            'startdate'       => $order['pickup_datetime'],
                            'enddate'         => $order['delivery_datetime'],
                            'shift_id'        => $ship_id,
                            'stop_order'      => 1,
                            'drop_order'      => 0,
                            'basic_stop'      => 0,
                            'stop_id'         => 0,
                            'drop_stopid'     => 0,
                            'order_id'        => $order['order_id'],
                            'pkgitemid'       => 'BOXES',
                            'no_of_pkgs'      => $order['quantity'],
                            'domainname'      => 'INFD',
                        ];
                        $ins       = $this->db->insert("tb_employee", $insarr);
                        $detail_id = $this->db->insert_id();
                        if ($detail_id > 0) {
                            if ($stops_units->num_rows() > 1) {
                                $odata = $stops_units->row();
                                $upd   = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                            }
                            /*update orders table*/
                            $updwhr = ['id' => $order_id];
                            $setwhr = ['status' => 2];
                            $ins    = $this->db->where($updwhr)->update("tb_orders", $setwhr);
                            /*insert stops records */
                            $where   = ["shipment_id" => $ship_id, "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                            $select  = "id";
                            $table   = "tb_shiporder_stops";
                            $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = [
                                    'stopname'       => $order['pickup_city'],
                                    'plat'           => $plat,
                                    'plng'           => $plng,
                                    'stopcity'       => $order['pickup_city'],
                                    'address'        => $address,
                                    'stoptype'       => 'P',
                                    'stopstatus'     => 0,
                                    'shipment_id'    => $ship_id,
                                    'ordernumber'    => 1,
                                    'startdate'      => $order['pickup_datetime'],
                                    'enddate'        => $order['pickup_endtime'],
                                    'weight'         => $order['weight'],
                                    'volume'         => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units'     => $order['quantity'],
                                    'txncode'        => 'NP',
                                    'status'         => 1,
                                    'created_on'     => $curdt,
                                ];
                                $ins           = $this->db->insert("tb_shiporder_stops", $insarr);
                                $pickupstop_id = $this->db->insert_id();
                            } else {
                                $pickupstop_id = $chkstop['id'];
                            }
                            $where   = ["shipment_id" => $ship_id, "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                            $select  = "id";
                            $table   = "tb_shiporder_stops";
                            $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                            if (count($chkstop) == 0) {
                                $insarr = [
                                    'stopname'       => $order['delivery_city'],
                                    'plat'           => $dlat,
                                    'plng'           => $dlng,
                                    'stopcity'       => $order['delivery_city'],
                                    'address'        => $dropaddr,
                                    'stoptype'       => 'D',
                                    'stopstatus'     => 0,
                                    'shipment_id'    => $ship_id,
                                    'ordernumber'    => 2,
                                    'startdate'      => $order['delivery_datetime'],
                                    'enddate'        => $order['drop_endtime'],
                                    'weight'         => $order['weight'],
                                    'volume'         => $order['volume'],
                                    'shipmentstopid' => 0,
                                    'ship_units'     => $order['quantity'],
                                    'txncode'        => 'NP',
                                    'status'         => 1,
                                    'created_on'     => $curdt,
                                ];
                                $ins         = $this->db->insert("tb_shiporder_stops", $insarr);
                                $dropstop_id = $this->db->insert_id();
                            } else {
                                $dropstop_id = $chkstop['id'];
                            }
                            /*update pickupstop and drop stop id into details/tb_employee table */
                            $setarr = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id];
                            $setwhr = ['id' => $detail_id];
                            $ins    = $this->db->where($setwhr)->update("tb_employee", $setarr);
                            $chk1   = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $ship_id], 1, 0);
                            if ($chk1->num_rows() > 0) {
                                $shftvehid = $chk1->row()->id;
                                $chk       = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                                if ($chk->num_rows() == 0) {
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                    if ($chkemp->num_rows() == 0) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                        $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            } else {
                                if ($vehicle_id != "") {
                                    $veh_num   = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                                    $arr       = ['user_id' => $userid, 'route_id' => 0, 'shft_id' => $ship_id, 'carrier_id' => $vendor_id, 'vehicle_id' => $vehicle_id, 'register_number' => $veh_num, 'status' => 1];
                                    $ins       = $this->db->insert("tb_shft_veh", $arr);
                                    $shftvehid = $this->db->insert_id();
                                    $getemp    = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $ship_id]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                }
                                if ($vehicle_id != "" && $driver_id != "") {
                                    $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where("tb_vehicles_drivers", ["vehicle_id" => $vehicle_id]);
                                    if ($chk->num_rows() > 0) {
                                        if ($driver_id == $chk->row()->driver_id) {
                                            $upd = $this->db->where(["id" => $chk->row()->id])->update("tb_vehicles_drivers", ["status" => 1]);
                                        } else {
                                            $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                            $ins = $this->db->insert("tb_vehicles_drivers", $arr);
                                        }
                                    } else {
                                        $arr = ['vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt];
                                        $ins = $this->db->insert("tb_vehicles_drivers", $arr);
                                    }
                                    $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $driver_id, "vehicle_id" => $vehicle_id], 1, 0);
                                    if ($chk11->num_rows() > 0) {
                                        $upd = $this->db->where(["id" => $chk11->row()->id])->update("tbl_assigned_drivers", ["status" => "1", 'updated_on' => $curdt]);
                                    } else {
                                        $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1], 1, 0);
                                        if ($chk111->num_rows() == 0) {
                                            $ins = $this->db->insert("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => "", "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt]);
                                        } else {
                                            $upd = $this->db->where(["id" => $chk111->row()->id])->update("tbl_assigned_drivers", ["driver_id" => $driver_id, 'updated_on' => $curdt]);
                                        }
                                    }
                                }
                            }
                            $response = 1;
                            /* update status */
                            $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $ship_id, "status_id" => 9], 1, 0);
                            if ($chk->num_rows() == 0) {
                                $curtz     = $this->session->userdata("usr_tzone")['timezone'];
                                $logdate   = date('Y-m-d H:i:s');
                                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                                $curdt1    = $getactual['datetime'];
                                $ins       = ["shipment_id" => $ship_id, "stop_id" => 0, "order_id" => $order_id, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                                $insqry    = $this->db->insert("tb_stop_status", $ins);
                            }
                        }
                    }
                }
            }
        }
        /*   }    */
        return $excel_sorders;
    }

    public function checkDecimalAmount_ForVn($amount)
    {
        $sts = 0;
        if (strpos($amount, ".") !== false) {
            $amount_arr = explode('.', $amount);
            $decimal    = isset($amount_arr[1]) ? $amount_arr[1] : "0";
            if ($decimal == 0) {
                $sts = 1;
            } else {
                $sts = 0;
            }
        } else {
            $sts = 1;
        }
        return $sts;
    }

    public function ordercost()
    {
        ini_set('max_execution_time', 300);
        $cdate = date('Y-m-d H:i:s');
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $all_data = [];
        $data     = $errorline     = $message     = $rev_ids     = $suces_arr     = $failure_arr     = $all_orders     = $result     = [];
        if (isset($_FILES['import_costfile'])) {
            $ext   = pathinfo($_FILES['import_costfile']['name'], PATHINFO_EXTENSION);
            $value = [];
            $val   = [];
            if ($ext == "xls" || $ext == "xlsx") {
                $path             = $_FILES['import_costfile']['tmp_name'];
                $objPHPExcel      = PHPExcel_IOFactory::load($path);
                $cell_collection  = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arr_data"] = [];
                foreach ($cell_collection as $cell) {
                    $column     = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row        = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    $newdtat[]  = $column;
                    if ($row == 1) {
                        if ($data_value != "") {
                            $mainheader[$column] = $data_value;
                        }
                    }
                    if ($row == 2) {
                        $data["header"][$row][$column] = $data_value;
                    } else {
                        if ($row > 2) {
                            $data["arr_data"][$row][$column] = $data_value;
                        }
                    }
                }
                $row                 = 3;
                $arr                 = [];
                $sno                 = "";
                $currency            = $this->session->userdata("usr_tzone")['currency'];
                $user_id             = $this->session->userdata('user_id');
                $session_currency    = $this->session->userdata("usr_tzone")['currency'];
                $session_companycode = $this->session->userdata('company_code');
                $i                   = 0;
                foreach ($data["arr_data"] as $value[$row]) {
                    $shipment_id = isset($value[$row]['A']) ? $value[$row]['A'] : "";
                    $shipment_id = $shipment_id . $i;
                    if ($sno != $shipment_id) {
                        if ($shipment_id != "") {
                            $sno                = $shipment_id;
                            $value[$row]['row'] = $row;
                            $arr[$sno][]        = $value[$row];
                            $row++;
                        } else {
                            $value[$row]['row'] = $row;
                            $arr[$sno][]        = $value[$row];
                            $row++;
                        }
                    } else {
                        $value[$row]['row'] = $row;
                        $arr[$sno][]        = $value[$row];
                        $row++;
                    }
                    $i++;
                }
                $arrdata = [];
                if (! empty($arr)) {
                    foreach ($arr as $ar) {
                        $arrdata[] = $ar;
                    }
                }
                if (! empty($arrdata)) {
                    for ($i = 0, $iMax = count($arrdata); $i < $iMax; $i++) {
                        $rev_cust_ids = $ven_cust_ids = $rev_internal_bus = $cost_internal_bus = [];
                        $rowno        = isset($arrdata[$i]['0']['row']) ? $arrdata[$i]['0']['row'] : "";
                        $mainrowno    = $rowno;
                        $order_id     = isset($arrdata[$i]['0']['A']) ? $arrdata[$i]['0']['A'] : "";
                        if ($order_id != "") {
                            $order_row_id   = 0;
                            $getorderrow_id = $this->db->select("id")->get_where("tb_orders", ['order_id' => $order_id]);
                            if ($getorderrow_id->num_rows() > 0) {
                                $order_row_id = $getorderrow_id->row()->id;
                            }
                            $all_orders[] = ['id' => $order_row_id, 'booking_id' => $order_id];
                            $customer     = isset($arrdata[$i]['0']['B']) ? $arrdata[$i]['0']['B'] : "";
                            $vendor       = isset($arrdata[$i]['0']['C']) ? $arrdata[$i]['0']['C'] : "";
                            $revenu_ibu   = isset($arrdata[$i]['0']['D']) ? $arrdata[$i]['0']['D'] : "";
                            $rev_bujfr    = isset($arrdata[$i]['0']['E']) ? $arrdata[$i]['0']['E'] : "";
                            $cost_ibu     = isset($arrdata[$i]['0']['F']) ? $arrdata[$i]['0']['F'] : "";
                            $cost_bujfr   = isset($arrdata[$i]['0']['G']) ? $arrdata[$i]['0']['G'] : "";
                            $x            = 'H';
                            $y            = 'H';
                            for ($j = 0; $j <= 15; $j++) {
                                $charge = isset($mainheader[$x]) ? $mainheader[$x] : "";
                                $x++;
                                $x++;
                                $x++;
                                $x++;
                                if ($charge != "") {
                                    $sell = isset($arrdata[$i]['0'][$y]) ? $arrdata[$i]['0'][$y] : "";
                                    $y++;
                                    $sell_currency = isset($arrdata[$i]['0'][$y]) ? $arrdata[$i]['0'][$y] : "";
                                    $y++;
                                    $buy = isset($arrdata[$i]['0'][$y]) ? $arrdata[$i]['0'][$y] : "";
                                    $y++;
                                    $buy_currency = isset($arrdata[$i]['0'][$y]) ? $arrdata[$i]['0'][$y] : "";
                                    $y++;
                                    if ($customer != "") {
                                        /* Revenue */
                                        if ($sell != "") {
                                            $sell_amount = ltrim($sell, ' $ ');
                                            $sell_chk    = 1;
                                            if ($session_companycode == "VNKN") {
                                                if ($session_currency == $sell_currency) {
                                                    $sell_chk = $this->checkDecimalAmount_ForVn($sell_amount);
                                                    if ($sell_chk == 0) {
                                                        $sts           = "Revenue Failed for this order because of decimal amount -'" . $sell_amount . " " . $sell_currency . "'";
                                                        $failure_arr[] = ['decimal' => '1', 'type' => '0', 'order_id' => $order_row_id, 'status' => $sts, 'amount' => $sell_amount, 'bu_jfr' => ''];
                                                    }
                                                }
                                            }
                                            $revenue_id = 0;
                                            if ($sell_chk == '1') {
                                                $getcharge = $this->db->select("id,description")->get_where("tb_charge_codes", ['charge_code' => $charge, 'status' => '1']);
                                                if ($getcharge->num_rows() > 0) {
                                                    $charge_id      = $getcharge->row()->id;
                                                    $charge_desc    = $getcharge->row()->description;
                                                    $local_amount   = 0;
                                                    $local_currency = $session_currency;
                                                    if ($session_currency == $sell_currency) {
                                                        $local_currency = $sell_currency;
                                                        $local_amount   = $sell_amount;
                                                    }
                                                    $charge_ar = ['revenue_id' => $revenue_id, 'charge_code' => $charge_id, 'description' => $charge_desc, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => '1', 'amount' => $sell_amount, 'currency' => $sell_currency, 'createdon' => $cdate, 'local_amount' => $local_amount, 'local_currency' => $local_currency, 'source_created' => 'CU - Excel Upload'];
                                                    $this->db->insert("tb_charges", $charge_ar);
                                                    $rev_cust_ids[] = $this->db->insert_id();
                                                }
                                            }
                                        }
                                    } else {
                                        if ($revenu_ibu != "") {
                                            if ($sell != "") {
                                                $sell_amount = ltrim($sell, ' $ ');
                                                $sell_ibuchk = 1;
                                                if ($session_companycode == "VNKN") {
                                                    if ($session_currency == $sell_currency) {
                                                        $sell_ibuchk = $this->checkDecimalAmount_ForVn($sell_amount);
                                                        if ($sell_ibuchk == 0) {
                                                            $sts           = "Internal BU(REV) Failed for this order because of decimal amount -'" . $sell_amount . " " . $sell_currency . "'";
                                                            $failure_arr[] = ['decimal' => '1', 'type' => '0', 'order_id' => $order_row_id, 'status' => $sts, 'amount' => $sell_amount, 'bu_jfr' => $rev_bujfr];
                                                        }
                                                    }
                                                }
                                                $revenue_id = 0;
                                                if ($sell_ibuchk == "1") {
                                                    $getcharge = $this->db->select("id,description")->get_where("tb_charge_codes", ['charge_code' => $charge, 'status' => '1']);
                                                    if ($getcharge->num_rows() > 0) {
                                                        $charge_id      = $getcharge->row()->id;
                                                        $charge_desc    = $getcharge->row()->description;
                                                        $local_amount   = 0;
                                                        $local_currency = $session_currency;
                                                        if ($session_currency == $sell_currency) {
                                                            $local_currency = $sell_currency;
                                                            $local_amount   = $sell_amount;
                                                        }
                                                        $charge_ar = ['revenue_id' => $revenue_id, 'charge_code' => $charge_id, 'description' => $charge_desc, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => '1', 'amount' => $sell_amount, 'currency' => $sell_currency, 'createdon' => $cdate, 'local_amount' => $local_amount, 'local_currency' => $local_currency, 'source_created' => 'CU - Excel Upload'];
                                                        $this->db->insert("tb_charges", $charge_ar);
                                                        $rev_internal_bus[] = $this->db->insert_id();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if ($vendor != "") {
                                        if ($buy != "") {
                                            $buy_amount = ltrim($buy, ' $ ');
                                            $buy_chk    = 1;
                                            if ($session_companycode == "VNKN") {
                                                if ($session_currency == $buy_currency) {
                                                    $buy_chk = $this->checkDecimalAmount_ForVn($buy_amount);
                                                    if ($buy_chk == 0) {
                                                        $sts           = "Cost Failed for this order because of decimal amount -'" . $buy_amount . " " . $buy_currency . "'";
                                                        $failure_arr[] = ['decimal' => '1', 'type' => '1', 'order_id' => $order_row_id, 'status' => $sts, 'amount' => $buy_amount, 'bu_jfr' => ''];
                                                    }
                                                }
                                            }
                                            $revenue_id = 0;
                                            if ($buy_chk == '1') {
                                                $getcharge = $this->db->select("id,description")->get_where("tb_charge_codes", ['charge_code' => $charge, 'status' => '1']);
                                                if ($getcharge->num_rows() > 0) {
                                                    $charge_id      = $getcharge->row()->id;
                                                    $charge_desc    = $getcharge->row()->description;
                                                    $local_amount   = 0;
                                                    $local_currency = $session_currency;
                                                    if ($session_currency == $buy_currency) {
                                                        $local_currency = $buy_currency;
                                                        $local_amount   = $buy_amount;
                                                    }
                                                    $charge_ar      = ['revenue_id' => $revenue_id, 'charge_code' => $charge_id, 'description' => $charge_desc, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => '1', 'amount' => $buy_amount, 'currency' => $buy_currency, 'createdon' => $cdate, 'local_amount' => $local_amount, 'local_currency' => $local_currency, 'source_created' => 'CU - Excel Upload'];
                                                    $ins            = $this->db->insert("tb_charges", $charge_ar);
                                                    $ven_cust_ids[] = $this->db->insert_id();
                                                }
                                            }
                                        }
                                    } else {
                                        if ($cost_ibu != "") {
                                            if ($buy != "") {
                                                $buy_amount = ltrim($buy, ' $ ');
                                                $buy_ibuchk = 1;
                                                if ($session_companycode == "VNKN") {
                                                    if ($session_currency == $buy_currency) {
                                                        $buy_ibuchk = $this->checkDecimalAmount_ForVn($buy_amount);
                                                        if ($buy_ibuchk == 0) {
                                                            $sts           = "Internal BU(Cost) Failed for this order because of decimal amount -'" . $buy_amount . " " . $buy_currency . "'";
                                                            $failure_arr[] = ['decimal' => '1', 'type' => '1', 'order_id' => $order_row_id, 'status' => $sts, 'amount' => $buy_amount, 'bu_jfr' => $cost_bujfr];
                                                        }
                                                    }
                                                }
                                                $revenue_id = 0;
                                                if ($buy_ibuchk == '1') {
                                                    $getcharge = $this->db->select("id,description")->get_where("tb_charge_codes", ['charge_code' => $charge, 'status' => '1']);
                                                    if ($getcharge->num_rows() > 0) {
                                                        $charge_id      = $getcharge->row()->id;
                                                        $charge_desc    = $getcharge->row()->description;
                                                        $local_amount   = 0;
                                                        $local_currency = $session_currency;
                                                        if ($session_currency == $buy_currency) {
                                                            $local_currency = $buy_currency;
                                                            $local_amount   = $buy_amount;
                                                        }
                                                        $charge_ar           = ['revenue_id' => $revenue_id, 'charge_code' => $charge_id, 'description' => $charge_desc, 'quantity_unit' => '1', 'value' => '1', 'rate_id' => '1', 'amount' => $buy_amount, 'currency' => $buy_currency, 'createdon' => $cdate, 'local_amount' => $local_amount, 'local_currency' => $local_currency, 'source_created' => 'CU - Excel Upload'];
                                                        $ins                 = $this->db->insert("tb_charges", $charge_ar);
                                                        $cost_internal_bus[] = $this->db->insert_id();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (! empty($rev_cust_ids)) {
                                $getCustomerNameAndCode = $this->getPartyNameAndCode($customer, $session_companycode, $user_id, 'Customer');
                                if (! empty($getCustomerNameAndCode)) {
                                    $customer_name   = $getCustomerNameAndCode['name'];
                                    $customer        = $getCustomerNameAndCode['party_code'];
                                    $recipient_role  = 'Customer';
                                    $debtor_jfr      = "";
                                    $gettotal_amount = $this->db->query("SELECT sum(amount) as amount,currency FROM tb_charges WHERE id IN (" . implode(',', $rev_cust_ids) . ")");
                                    if ($gettotal_amount->num_rows() > 0) {
                                        $total_amount = $gettotal_amount->row()->amount;
                                        $currency     = $gettotal_amount->row()->currency;
                                    } else {
                                        $total_amount = 0;
                                        $currency     = "";
                                    }
                                    $foreign_currency = "";
                                    if ($session_currency == $currency) {
                                    } else {
                                        $foreign_currency = $currency;
                                        $currency         = $session_currency;
                                    }
                                    $rev_ar     = ['type' => '0', 'order_id' => $order_row_id, 'recipient_role' => 'Customer', 'recipient_code' => $customer, 'recipient_name' => $customer_name, 'debtor_jfr' => $debtor_jfr, 'amount' => $total_amount, 'currency' => $currency, 'foreign_currency' => $foreign_currency, 'createdon' => $cdate, 'user_id' => $user_id, 'source_created' => 'CU - Excel Upload'];
                                    $ins        = $this->db->insert("tb_reveneus", $rev_ar);
                                    $revenue_id = $this->db->insert_id();
                                    $rev_ids[]  = $revenue_id;
                                    $this->db->where_in('id', $rev_cust_ids)->update("tb_charges", ['revenue_id' => $revenue_id]);
                                    if ($foreign_currency != "") {
                                        $info                 = ['exchange_rate_id' => '0', 'from_currency' => $foreign_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id, 'revenue_id' => $revenue_id];
                                        $exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
                                        if ($exchange_rate_amount > 0) {
                                            $this->exchangerate->updatelocalamout_byexchangerate($revenue_id, $exchange_rate_amount, $foreign_currency);
                                        }
                                    }
                                }
                            }
                            if (! empty($rev_internal_bus)) {
                                $getCustomerNameAndCode = $this->getPartyNameAndCode($revenu_ibu, $session_companycode, $user_id, 'Customer');
                                if (! empty($getCustomerNameAndCode)) {
                                    $customer_name   = $getCustomerNameAndCode['name'];
                                    $customer        = $getCustomerNameAndCode['party_code'];
                                    $recipient_role  = 'Internal BU';
                                    $debtor_jfr      = "";
                                    $gettotal_amount = $this->db->query("SELECT sum(amount) as amount,currency FROM tb_charges WHERE id IN (" . implode(',', $rev_internal_bus) . ")");
                                    if ($gettotal_amount->num_rows() > 0) {
                                        $total_amount = $gettotal_amount->row()->amount;
                                        $currency     = $gettotal_amount->row()->currency;
                                    } else {
                                        $total_amount = 0;
                                        $currency     = "";
                                    }
                                    $revenue_bu_jfr = "";
                                    if ($rev_bujfr != "") {
                                        if (strpos($rev_bujfr, '-') !== false) {
                                            if (strlen($rev_bujfr) == "15") {
                                                $revenue_bu_jfr = $rev_bujfr;
                                            } else {
                                                $failure_arr[] = ['decimal' => '0', 'bu_jfr' => $rev_bujfr, 'type' => '0', 'order_id' => $order_row_id];
                                            }
                                        } else {
                                            if (strlen($rev_bujfr) == "16") {
                                                $revenue_bu_jfr = $rev_bujfr;
                                            } else {
                                                $failure_arr[] = ['decimal' => '0', 'bu_jfr' => $rev_bujfr, 'type' => '0', 'order_id' => $order_row_id];
                                            }
                                        }
                                    }
                                    $foreign_currency = "";
                                    if ($session_currency == $currency) {
                                    } else {
                                        $foreign_currency = $currency;
                                        $currency         = $session_currency;
                                    }
                                    $rev_ar     = ['type' => '0', 'order_id' => $order_row_id, 'recipient_role' => 'Internal BU', 'recipient_code' => $revenu_ibu, 'recipient_name' => $customer_name, 'debtor_jfr' => $debtor_jfr, 'bu_jfr' => $revenue_bu_jfr, 'amount' => $total_amount, 'currency' => $currency, 'foreign_currency' => $foreign_currency, 'createdon' => $cdate, 'user_id' => $user_id];
                                    $ins        = $this->db->insert("tb_reveneus", $rev_ar);
                                    $revenue_id = $this->db->insert_id();
                                    $rev_ids[]  = $revenue_id;
                                    $this->db->where_in('id', $rev_internal_bus)->update("tb_charges", ['revenue_id' => $revenue_id]);
                                    if ($foreign_currency != "") {
                                        $info                 = ['exchange_rate_id' => '0', 'from_currency' => $foreign_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id, 'revenue_id' => $revenue_id];
                                        $exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
                                        if ($exchange_rate_amount > 0) {
                                            $this->exchangerate->updatelocalamout_byexchangerate($revenue_id, $exchange_rate_amount, $foreign_currency);
                                        }
                                    }
                                }
                            }
                            if (! empty($ven_cust_ids)) {
                                $getCarrierNameAndCode = $this->getPartyNameAndCode($vendor, $session_companycode, $user_id, 'Vendor');
                                if (! empty($getCarrierNameAndCode)) {
                                    $vendor_name     = $getCarrierNameAndCode['name'];
                                    $vendor          = $getCarrierNameAndCode['party_code'];
                                    $gettotal_amount = $this->db->query("SELECT sum(amount) as amount,currency FROM tb_charges WHERE id IN (" . implode(',', $ven_cust_ids) . ")");
                                    if ($gettotal_amount->num_rows() > 0) {
                                        $total_amount = $gettotal_amount->row()->amount;
                                        $currency     = $gettotal_amount->row()->currency;
                                    } else {
                                        $total_amount = 0;
                                        $currency     = "";
                                    }
                                    $foreign_currency = "";
                                    if ($session_currency == $currency) {
                                    } else {
                                        $foreign_currency = $currency;
                                        $currency         = $session_currency;
                                    }
                                    $recipient_role = 'Carrier';
                                    $debtor_jfr     = "";
                                    $cost_ar        = ['type' => '1', 'order_id' => $order_row_id, 'recipient_role' => 'Carrier', 'recipient_code' => $vendor, 'recipient_name' => $vendor_name, 'debtor_jfr' => $debtor_jfr, 'amount' => $total_amount, 'currency' => $currency, 'foreign_currency' => $foreign_currency, 'createdon' => $cdate, 'user_id' => $user_id, 'source_created' => 'CU - Excel Upload'];
                                    $ins            = $this->db->insert("tb_reveneus", $cost_ar);
                                    $cost_id        = $this->db->insert_id();
                                    $rev_ids[]      = $cost_id;
                                    $this->db->where_in('id', $ven_cust_ids)->update("tb_charges", ['revenue_id' => $cost_id]);
                                    if ($foreign_currency != "") {
                                        $info                 = ['exchange_rate_id' => '0', 'from_currency' => $foreign_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id, 'revenue_id' => $cost_id];
                                        $exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
                                        if ($exchange_rate_amount > 0) {
                                            $this->exchangerate->updatelocalamout_byexchangerate($cost_id, $exchange_rate_amount, $foreign_currency);
                                        }
                                    }
                                }
                            }
                            if (! empty($cost_internal_bus)) {
                                $getCarrierNameAndCode = $this->getPartyNameAndCode($cost_ibu, $session_companycode, $user_id, 'Vendor');
                                if (! empty($getCarrierNameAndCode)) {
                                    $vendor_name     = $getCarrierNameAndCode['name'];
                                    $vendor          = $getCarrierNameAndCode['party_code'];
                                    $gettotal_amount = $this->db->query("SELECT sum(amount) as amount,currency FROM tb_charges WHERE id IN (" . implode(',', $cost_internal_bus) . ")");
                                    if ($gettotal_amount->num_rows() > 0) {
                                        $total_amount = $gettotal_amount->row()->amount;
                                        $currency     = $gettotal_amount->row()->currency;
                                    } else {
                                        $total_amount = 0;
                                        $currency     = "";
                                    }
                                    $foreign_currency = "";
                                    if ($session_currency == $currency) {
                                    } else {
                                        $foreign_currency = $currency;
                                        $currency         = $session_currency;
                                    }
                                    $recipient_role = 'Internal BU';
                                    $debtor_jfr     = "";
                                    $cost_bu_jfr    = "";
                                    if ($cost_bujfr != "") {
                                        if (strpos($cost_bujfr, '-') !== false) {
                                            if (strlen($cost_bujfr) == "15") {
                                                $cost_bu_jfr = $cost_bujfr;
                                            } else {
                                                $failure_arr[] = ['decimal' => '0', 'bu_jfr' => $cost_bujfr, 'type' => '1', 'order_id' => $order_row_id];
                                            }
                                        } else {
                                            if (strlen($cost_bujfr) == "16") {
                                                $cost_bu_jfr = $cost_bujfr;
                                            } else {
                                                $failure_arr[] = ['decimal' => '0', 'bu_jfr' => $cost_bujfr, 'type' => '1', 'order_id' => $order_row_id];
                                            }
                                        }
                                    }
                                    $cost_ar   = ['type' => '1', 'order_id' => $order_row_id, 'recipient_role' => 'Internal BU', 'recipient_code' => $cost_ibu, 'recipient_name' => $vendor_name, 'debtor_jfr' => $debtor_jfr, 'bu_jfr' => $cost_bu_jfr, 'amount' => $total_amount, 'currency' => $currency, 'foreign_currency' => $foreign_currency, 'createdon' => $cdate, 'user_id' => $user_id];
                                    $ins       = $this->db->insert("tb_reveneus", $cost_ar);
                                    $cost_id   = $this->db->insert_id();
                                    $rev_ids[] = $cost_id;
                                    $this->db->where_in('id', $cost_internal_bus)->update("tb_charges", ['revenue_id' => $cost_id]);
                                    if ($foreign_currency != "") {
                                        $info                 = ['exchange_rate_id' => '0', 'from_currency' => $foreign_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id, 'revenue_id' => $cost_id];
                                        $exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
                                        if ($exchange_rate_amount > 0) {
                                            $this->exchangerate->updatelocalamout_byexchangerate($cost_id, $exchange_rate_amount, $foreign_currency);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $this->vatcalculationtorate->updatevattorevenues($rev_ids);
        }
        $result = [];
        if (! empty($all_orders)) {
            $result = $this->checkorderschargesdata($all_orders, $failure_arr);
        }
        if (! empty($result)) {
            @file_put_contents("assets/ordertemplate/charges_exceluploaddata.txt", json_encode($result));
            $this->session->set_flashdata('success_msg', 'Charges Uploaded Successfully');
            if ($session_companycode == "SGKN") {
                redirect('smtcorders/orderslist/03');
            } else {
                redirect('orders/orderslist/03');
            }
        } else {
            $this->session->set_flashdata('success_msg', 'Charges Uploaded Successfully');
            redirect("orders");
        }
    }

    public function checkorderschargesdata($orders, $failure)
    {
        $response         = [];
        $orderids         = [];
        $session_currency = $this->session->userdata("usr_tzone")['currency'];
        $total_revenue    = $total_cost    = 0;
        $rev_jfr          = $cost_jfr          = $rev_failure          = $cst_failure          = "";
        $revbujfr         = $costbujfr         = [];
        $rev_bu_frs       = $cost_bu_jfrs       = "";
        if (! empty($orders)) {
            foreach ($orders as $ord) {
                if ($ord['id'] > 0) {
                    if (in_array($ord['id'], $orderids)) {
                    } else {
                        $orderids[]   = $ord['id'];
                        $gettotal_rev = $this->common->gettblrowdata(['order_id' => $ord['id'], 'type' => '0', 'status' => '1'], "sum(amount) as total_amount,debtor_jfr", 'tb_reveneus', 0, 0);
                        if (! empty($gettotal_rev)) {
                            $total_revenue = $gettotal_rev['total_amount'];
                            $rev_jfr       = $gettotal_rev['debtor_jfr'];
                        }
                        $gettotal_cost = $this->common->gettblrowdata(['order_id' => $ord['id'], 'type' => '1', 'status' => '1'], "sum(amount) as total_amount,debtor_jfr", 'tb_reveneus', 0, 0);
                        if (! empty($gettotal_rev)) {
                            $total_cost = $gettotal_cost['total_amount'];
                            $cost_jfr   = $gettotal_cost['debtor_jfr'];
                        }
                        $getbu_jfr = $this->common->gettbldata(["order_id" => $ord['id'], "type" => '0', "recipient_role" => 'Internal BU', "status" => '1'], "bu_jfr", "tb_reveneus", 0, 0);
                        if (! empty($getbu_jfr)) {
                            foreach ($getbu_jfr as $rev) {
                                if ($rev['bu_jfr'] != "") {
                                    $revbujfr[] = $rev['bu_jfr'];
                                }
                            }
                        }
                        if (! empty($revbujfr)) {
                            $rev_bu_jfrs = implode(',<br>', $revbujfr);
                        }
                        $getcostbu_jfr = $this->common->gettbldata(["order_id" => $ord['id'], "type" => '1', "recipient_role" => 'Internal BU', "status" => '1'], "bu_jfr", "tb_reveneus", 0, 0);
                        if (! empty($getcostbu_jfr)) {
                            foreach ($getcostbu_jfr as $cst) {
                                if ($cst['bu_jfr'] != "") {
                                    $costbujfr[] = $cst['bu_jfr'];
                                }
                            }
                        }
                        if (! empty($costbujfr)) {
                            $cost_bu_jfrs = implode(',<br>', $costbujfr);
                        }
                        $rev_failure = $cst_failure = "";
                        if (! empty($failure)) {
                            foreach ($failure as $ff) {
                                $decimal = isset($ff['decimal']) ? $ff['decimal'] : 0;
                                if ($ff['type'] == "0") {
                                    $t_type = "REV";
                                } else {
                                    $t_type = "COST";
                                }
                                $final_bujfr = isset($ff['bu_jfr']) ? $ff['bu_jfr'] : "";
                                $simplear    = ['bu_jfr' => $final_bujfr, 'type' => $ff['type'], 'order_id' => $ff['order_id']];
                                if ($ord['id'] == $simplear['order_id']) {
                                    if ($decimal == '1') {
                                        $status = $ff['status'];
                                        if ($t_type == "REV") {
                                            $rev_failure = $status;
                                        } else {
                                            if ($t_type == "COST") {
                                                $cst_failure = $status;
                                            }
                                        }
                                    }
                                    if ($decimal == "0") {
                                        if ($t_type == "REV") {
                                            if ($rev_failure != "") {
                                                $rev_failure .= " and ";
                                            }
                                            $rev_failure .= "Bu jfr (" . $simplear['bu_jfr'] . ") is not in correct Format";
                                        } else {
                                            if ($t_type == "COST") {
                                                if ($cst_failure != "") {
                                                    $cst_failure .= " and ";
                                                }
                                                $cst_failure .= "Bu jfr (" . $simplear['bu_jfr'] . ") is not in correct Format";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        $response[] = ['booking_id' => $ord['booking_id'], 'total_revenue' => $total_revenue, 'rev_debtor_jfr' => $rev_jfr, 'rev_bu_jfrs' => $rev_bu_jfrs, 'total_cost' => $total_cost, 'cost_jfr' => $cost_jfr, 'cost_bu_jfrs' => $cost_bu_jfrs, 'rev_failure' => $rev_failure, 'cst_failure' => $cst_failure];
                    }
                }
            }
        }
        return $response;
    }

    public function orderbooking(): void
    {
        ini_set('max_execution_time', 300);
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $purchaseOrderDetails = $countries = $atsParties = $data = $errorline = $message = $value = [];
        if (isset($_FILES['import_file'])) {
            $companyCode = $this->session->userdata('company_code');
            $extension   = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            if ($extension === "xls" || $extension === "xlsx") {
                $path              = $_FILES['import_file']['tmp_name'];
                $objPHPExcel       = PHPExcel_IOFactory::load($path);
                $cellCollection    = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arraydata"] = [];
                foreach ($cellCollection as $cell) {
                    $column    = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row       = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $dataValue = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    if ($row == 2) {
                        $data["header"][$row][$column] = mb_strtoupper($dataValue ?? "");
                    } elseif ($row > 2) {
                        $data["arraydata"][$row][$column] = mb_strtoupper($dataValue ?? "");
                    }
                }
                $data['ord_details'] = $checkvalues = [];
                $finalData           = $this->getFinalDataFromNormalExcelUpload($data);
                if (! empty($finalData)) {
                    for ($i = 0, $iMax = count($finalData); $i < $iMax; $i++) {
                        $rowNumber      = $finalData[$i]['0']['row'] ?? "";
                        $mainRowNumber  = $rowNumber;
                        $deliveryNote   = $finalData[$i]['0']['A'] ?? "";
                        $checkvalues[]  = ['value' => $deliveryNote, 'message' => 'Delivery Note empty on line: ' . $rowNumber, 'errorline' => 'delivery_note' . $rowNumber];
                        $product        = $finalData[$i]['0']['B'] ?? "";
                        $checkvalues[]  = ['value' => $product, 'message' => 'Product empty on line: ' . $rowNumber, 'errorline' => 'product' . $rowNumber];
                        $deliveryTerms  = $finalData[$i]['0']['C'] ?? "";
                        $checkvalues[]  = ['value' => $deliveryTerms, 'message' => 'Delievry terms empty on line: ' . $rowNumber, 'errorline' => 'delivery_terms' . $rowNumber];
                        $incoterms      = $finalData[$i]['0']['D'] ?? "";
                        $checkvalues[]  = ['value' => $incoterms, 'message' => 'Incoterms empty on line: ' . $rowNumber, 'errorline' => 'incoterms' . $rowNumber];
                        $service        = $finalData[$i]['0']['E'] ?? "";
                        $checkvalues[]  = ['value' => $service, 'message' => 'Service empty on line: ' . $rowNumber, 'errorline' => 'service' . $rowNumber];
                        $companyCode    = $finalData[$i]['0']['F'] ?? "";
                        $checkvalues[]  = ['value' => $companyCode, 'message' => 'Company Code empty on line: ' . $rowNumber, 'errorline' => 'Company_code' . $rowNumber];
                        $branchCode     = $finalData[$i]['0']['G'] ?? "";
                        $checkvalues[]  = ['value' => $branchCode, 'message' => 'Branch Code empty on line: ' . $rowNumber, 'errorline' => 'branch_code' . $rowNumber];
                        $departmentCode = $finalData[$i]['0']['H'] ?? "";
                        $checkvalues[]  = ['value' => $departmentCode, 'message' => 'Department Code empty on line: ' . $rowNumber, 'errorline' => 'department_code' . $rowNumber];
                        $customerId     = $finalData[$i]['0']['I'] ?? "";
                        $checkvalues[]  = ['value' => $customerId, 'message' => 'Customer Id empty on line: ' . $rowNumber, 'errorline' => 'customer_id' . $rowNumber];
                        $orderType      = $finalData[$i]['0']['J'] ?? "";
                        $checkvalues[]  = ['value' => $orderType, 'message' => 'Booking Type empty on line: ' . $rowNumber, 'errorline' => 'order_type' . $rowNumber];
                        $transportMode  = $finalData[$i]['0']['K'] ?? "";
                        $checkvalues[]  = ['value' => $transportMode, 'message' => 'Transport Mode empty on line: ' . $rowNumber, 'errorline' => 'transport_mode' . $rowNumber];
                        $pickupId       = $finalData[$i]['0']['L'] ?? "";
                        $checkvalues[]  = ['value' => $pickupId, 'message' => 'Pickup ID empty on line: ' . $rowNumber, 'errorline' => 'pickup_id' . $rowNumber];
                        $pickupName     = $finalData[$i]['0']['M'] ?? "";
                        $checkvalues[]  = ['value' => $pickupName, 'message' => 'Pickup Name empty on line: ' . $rowNumber, 'errorline' => 'pickup_name' . $rowNumber];
                        $pickupStreet   = $finalData[$i]['0']['N'] ?? "";
                        $checkvalues[]  = ['value' => $pickupStreet, 'message' => 'Pickup Street empty on line: ' . $rowNumber, 'errorline' => 'pickup_street' . $rowNumber];
                        $pickupCity     = $finalData[$i]['0']['O'] ?? "";
                        $checkvalues[]  = ['value' => $pickupCity, 'message' => 'Pickup City empty on line: ' . $rowNumber, 'errorline' => 'pickup_city' . $rowNumber];
                        $pickupState    = $finalData[$i]['0']['P'] ?? "";
                        $checkvalues[]  = ['value' => $pickupState, 'message' => 'Pickup State empty on line: ' . $rowNumber, 'errorline' => 'pickup_state' . $rowNumber];
                        $pickupCountry  = $finalData[$i]['0']['Q'] ?? "";
                        $checkvalues[]  = ['value' => $pickupCountry, 'message' => 'Pickup Country empty on line: ' . $rowNumber, 'errorline' => 'pickup_country' . $rowNumber];
                        $pickupPincode  = $finalData[$i]['0']['R'] ?? "";
                        $checkvalues[]  = ['value' => $pickupPincode, 'message' => 'Pickup Pincode empty on line: ' . $rowNumber, 'errorline' => 'pickup_pincode' . $rowNumber];
                        $earlyPickup    = $finalData[$i]['0']['S'] ?? "";
                        if ($earlyPickup != "") {
                            $unixDate    = @($earlyPickup - 25569) * 86400;
                            $excelDate   = @(25569 + ($unixDate / 86400));
                            $unixDate    = @($excelDate - 25569) * 86400;
                            $earlyPickup = gmdate("Y-m-d H:i:s", (int) round($unixDate));
                        }
                        $checkvalues[] = ['value' => $earlyPickup, 'message' => 'Early Pickup empty/invalid on line: ' . $rowNumber, 'errorline' => 'early_pickup' . $rowNumber, 'date' => '1'];
                        $latePickup    = $finalData[$i]['0']['T'] ?? "";
                        if ($latePickup != "") {
                            $unixDate   = @($latePickup - 25569) * 86400;
                            $excelDate  = @(25569 + ($unixDate / 86400));
                            $unixDate   = @($excelDate - 25569) * 86400;
                            $latePickup = gmdate("Y-m-d H:i:s", (int) round($unixDate));
                        }
                        $checkvalues[]   = ['value' => $latePickup, 'message' => 'Late Pickup empty/invalid on line: ' . $rowNumber, 'errorline' => 'late_pickup' . $rowNumber, 'date' => '1'];
                        $pickupPhone     = $finalData[$i]['0']['U'] ?? "";
                        $checkvalues[]   = ['value' => $pickupPhone, 'message' => 'Pickup Phone empty on line: ' . $rowNumber, 'errorline' => 'pickup_phone' . $rowNumber];
                        $pickupFax       = $finalData[$i]['0']['V'] ?? "";
                        $checkvalues[]   = ['value' => $pickupFax, 'message' => 'Pickup Fax empty on line: ' . $rowNumber, 'errorline' => 'pickup_fax' . $rowNumber];
                        $pickupEmail     = $finalData[$i]['0']['W'] ?? "";
                        $checkvalues[]   = ['value' => $pickupEmail, 'message' => 'Pickup Email empty on line: ' . $rowNumber, 'errorline' => 'pickup_email' . $rowNumber];
                        $pickupExtension = $finalData[$i]['0']['X'] ?? "";
                        $checkvalues[]   = ['value' => $pickupExtension, 'message' => 'Pickup Extension empty on line: ' . $rowNumber, 'errorline' => 'pickup_extension' . $rowNumber];
                        $dropId          = $finalData[$i]['0']['Y'] ?? "";
                        $checkvalues[]   = ['value' => $dropId, 'message' => 'Delivery ID empty on line: ' . $rowNumber, 'errorline' => 'drop_id' . $rowNumber];
                        $dropName        = $finalData[$i]['0']['Z'] ?? "";
                        $checkvalues[]   = ['value' => $dropName, 'message' => 'Delivery Name empty on line: ' . $rowNumber, 'errorline' => 'drop_name' . $rowNumber];
                        $dropStreet      = $finalData[$i]['0']['AA'] ?? "";
                        $checkvalues[]   = ['value' => $dropStreet, 'message' => 'Delivery Street empty on line: ' . $rowNumber, 'errorline' => 'drop_street' . $rowNumber];
                        $dropCity        = $finalData[$i]['0']['AB'] ?? "";
                        $checkvalues[]   = ['value' => $dropCity, 'message' => 'Delivery City empty on line: ' . $rowNumber, 'errorline' => 'drop_city' . $rowNumber];
                        $dropState       = $finalData[$i]['0']['AC'] ?? "";
                        $checkvalues[]   = ['value' => $dropState, 'message' => 'Delivery State empty on line: ' . $rowNumber, 'errorline' => 'drop_state' . $rowNumber];
                        $dropCountry     = $finalData[$i]['0']['AD'] ?? "";
                        $checkvalues[]   = ['value' => $dropCountry, 'message' => 'Delivery Country empty on line: ' . $rowNumber, 'errorline' => 'drop_country' . $rowNumber];
                        $dropPincode     = $finalData[$i]['0']['AE'] ?? "";
                        $checkvalues[]   = ['value' => $dropCountry, 'message' => 'Delivery Pincode empty on line: ' . $rowNumber, 'errorline' => 'drop_pincode' . $rowNumber];
                        $earlyDrop       = $finalData[$i]['0']['AF'] ?? "";
                        if ($earlyDrop != "") {
                            $unixDate  = @($earlyDrop - 25569) * 86400;
                            $excelDate = @(25569 + ($unixDate / 86400));
                            $unixDate  = @($excelDate - 25569) * 86400;
                            $earlyDrop = gmdate("Y-m-d H:i:s", (int) round($unixDate));
                        }
                        $checkvalues[] = ['value' => $earlyDrop, 'message' => 'Early Delivery empty/invalid on line: ' . $rowNumber, 'errorline' => 'early_drop' . $rowNumber, 'date' => '1'];
                        $lateDrop      = $finalData[$i]['0']['AG'] ?? "";
                        if ($lateDrop != "") {
                            $unixDate  = @($lateDrop - 25569) * 86400;
                            $excelDate = @(25569 + ($unixDate / 86400));
                            $unixDate  = @($excelDate - 25569) * 86400;
                            $lateDrop  = gmdate("Y-m-d H:i:s", (int) round($unixDate));
                        }
                        $checkvalues[]         = ['value' => $lateDrop, 'message' => 'Late Delivery empty/invalid on line: ' . $rowNumber, 'errorline' => 'late_drop' . $rowNumber, 'date' => '1'];
                        $dropPhone             = $finalData[$i]['0']['AH'] ?? "";
                        $checkvalues[]         = ['value' => $dropPhone, 'message' => 'Delivery Phone empty on line: ' . $rowNumber, 'errorline' => 'drop_phone' . $rowNumber];
                        $dropFax               = $finalData[$i]['0']['AI'] ?? "";
                        $checkvalues[]         = ['value' => $dropFax, 'message' => 'Delivery Fax empty on line: ' . $rowNumber, 'errorline' => 'drop_fax' . $rowNumber];
                        $dropEmail             = $finalData[$i]['0']['AJ'] ?? "";
                        $checkvalues[]         = ['value' => $dropEmail, 'message' => 'Delivery Email empty on line: ' . $rowNumber, 'errorline' => 'drop_email' . $rowNumber];
                        $dropExtension         = $finalData[$i]['0']['AK'] ?? "";
                        $checkvalues[]         = ['value' => $dropExtension, 'message' => 'Delivery Extension empty on line: ' . $rowNumber, 'errorline' => 'drop_extension' . $rowNumber];
                        $cargo                 = "";
                        $data['cargo_details'] = $data['parties'] = $data['reference'] = [];
                        for ($j = 0, $jMax = count($finalData[$i]); $j < $jMax; $j++) {
                            $cargoRowNumber = $finalData[$i][$j]['row'] ?? "";
                            if ($companyCode == 'RUKN') {
                                $cargoBypassCondition = true;
                            } else {
                                $cargoBypassCondition = isset($finalData[$i][$j]['AL']);
                            }
                            if ($cargoBypassCondition) {
                                $cargoType          = $finalData[$i][$j]['AL'] ?? "";
                                $goodsDescription   = $finalData[$i][$j]['AM'] ?? "";
                                $quantity           = $finalData[$i][$j]['AN'] ?? "";
                                $length             = $finalData[$i][$j]['AO'] ?? "";
                                $width              = $finalData[$i][$j]['AP'] ?? "";
                                $height             = $finalData[$i][$j]['AQ'] ?? "";
                                $weight             = $finalData[$i][$j]['AR'] ?? "";
                                $secondWeight       = $finalData[$i][$j]['AS'] ?? "";
                                $volume             = $finalData[$i][$j]['AT'] ?? "";
                                $secondVolume       = $finalData[$i][$j]['AU'] ?? "";
                                $stackable          = $finalData[$i][$j]['AV'] ?? "";
                                $checkvalues[]      = ['value' => $cargoType, 'message' => 'Cargo type empty on line: ' . $cargoRowNumber, 'errorline' => 'cargo_type' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $goodsDescription, 'message' => 'Goods description empty on line: ' . $cargoRowNumber, 'errorline' => 'goods_desc' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $quantity, 'message' => 'Cargo Quantity empty on line: ' . $cargoRowNumber, 'errorline' => 'quantity' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $length, 'message' => 'Cargo length empty on line: ' . $cargoRowNumber, 'errorline' => 'length' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $width, 'message' => 'Cargo width empty on line: ' . $cargoRowNumber, 'errorline' => 'width' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $height, 'message' => 'Cargo height empty on line: ' . $cargoRowNumber, 'errorline' => 'height' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $weight, 'message' => 'Cargo Actual weight empty on line: ' . $cargoRowNumber, 'errorline' => 'weight' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $secondWeight, 'message' => 'Cargo weight empty on line: ' . $cargoRowNumber, 'errorline' => 'secondweight' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $volume, 'message' => 'Cargo Actual volume empty on line: ' . $cargoRowNumber, 'errorline' => 'volume' . $cargoRowNumber];
                                $checkvalues[]      = ['value' => $secondVolume, 'message' => 'Cargo volume empty on line: ' . $cargoRowNumber, 'errorline' => 'secondvolume' . $cargoRowNumber];
                                $innercargo_details = [];
                                if ($companyCode == 'RUKN') {
                                    $innerCargoBypassCondition = ($goodsDescription != "" || $cargoType != "" || $quantity != "" || $secondWeight != "" || $weight != "" || $volume != "" || $secondVolume != "");
                                } else {
                                    $innerCargoBypassCondition = ($cargoType != "");
                                }
                                if ($innerCargoBypassCondition) {
                                    $cargo = "";
                                    for ($a = $j, $aMax = count($finalData[$i]); $a < $aMax; $a++) {
                                        $rowNumber1 = $finalData[$i][$a]['row'] ?? "";
                                        if (isset($finalData[$i][$a]['AW'])) {
                                            $mainCargo = $finalData[$i][$a]['AL'] ?? "";
                                            if ($cargo == "" || $mainCargo == "") {
                                                $innerCargoType        = $finalData[$i][$a]['AW'] ?? "";
                                                $innerGoodsDescription = $finalData[$i][$a]['AX'] ?? "";
                                                $innerQuantity         = $finalData[$i][$a]['AY'] ?? "";
                                                $innerLength           = $finalData[$i][$a]['AZ'] ?? "";
                                                $innerWidth            = $finalData[$i][$a]['BA'] ?? "";
                                                $innerHeight           = $finalData[$i][$a]['BB'] ?? "";
                                                $innerWeight           = $finalData[$i][$a]['BC'] ?? "";
                                                $innerVolume           = $finalData[$i][$a]['BD'] ?? "";
                                                $innerStackable        = $finalData[$i][$a]['BE'] ?? "";
                                                $checkvalues[]         = ['value' => $innerCargoType, 'message' => 'Inner Cargo type empty on line: ' . $rowNumber1, 'errorline' => 'innercargo_type' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerGoodsDescription, 'message' => 'Inner Cargo Goods description empty on line: ' . $rowNumber1, 'errorline' => 'innergoods_desc' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerLength, 'message' => 'Inner Cargo Length empty on line: ' . $rowNumber1, 'errorline' => 'innerlength' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerWidth, 'message' => 'Inner Cargo Width empty on line: ' . $rowNumber1, 'errorline' => 'innerwidth' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerHeight, 'message' => 'Inner Cargo Height empty on line: ' . $rowNumber1, 'errorline' => 'innerheight' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerWeight, 'message' => 'Inner Cargo Weight empty on line: ' . $rowNumber1, 'errorline' => 'innerweight' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerQuantity, 'message' => 'Inner Cargo Quantity empty on line: ' . $rowNumber1, 'errorline' => 'innerquantity' . $rowNumber1];
                                                $checkvalues[]         = ['value' => $innerVolume, 'message' => 'Inner Cargo Volume empty on line: ' . $rowNumber1, 'errorline' => 'innervolume' . $rowNumber1];
                                                if ($innerCargoType != "") {
                                                    if ($mainCargo != "") {
                                                        $cargo = $mainCargo;
                                                    }
                                                    $innercargo_details[] = ['innercargo_type' => $innerCargoType, 'innergoods_description' => $innerGoodsDescription, 'innerlength' => $innerLength, 'innerwidth' => $innerWidth, 'innerheight' => $innerHeight, 'innerweight' => $innerWeight, 'innerquantity' => $innerQuantity, 'volume' => $innerVolume, 'innerrowno' => $rowNumber1, 'innerstackable' => $innerStackable];
                                                }
                                            } else {
                                                if ($mainCargo != "") {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    $data['cargo_details'][] = [
                                        'cargo_type'         => $cargoType,
                                        'goods_description'  => $goodsDescription,
                                        'length'             => $length,
                                        'width'              => $width,
                                        'height'             => $height,
                                        'weight'             => $weight,
                                        'quantity'           => $quantity,
                                        'volume'             => $volume,
                                        'stackable'          => $stackable,
                                        'secondweight'       => $secondWeight,
                                        'secondvolume'       => $secondVolume,
                                        'rowno'              => $cargoRowNumber,
                                        'innercargo_details' => $innercargo_details,
                                    ];
                                }
                            }
                            if (isset($finalData[$i][$j]['BF'])) {
                                $partyId       = $finalData[$i][$j]['BF'] ?? "";
                                $partyName     = $finalData[$i][$j]['BG'] ?? "";
                                $partyType     = $finalData[$i][$j]['BH'] ?? "";
                                $street        = $finalData[$i][$j]['BI'] ?? "";
                                $city          = $finalData[$i][$j]['BJ'] ?? "";
                                $state         = $finalData[$i][$j]['BK'] ?? "";
                                $country       = $finalData[$i][$j]['BL'] ?? "";
                                $pincode       = $finalData[$i][$j]['BM'] ?? "";
                                $contact       = $finalData[$i][$j]['BN'] ?? "";
                                $email         = $finalData[$i][$j]['BO'] ?? "";
                                $fax           = $finalData[$i][$j]['BP'] ?? "";
                                $checkvalues[] = ['value' => $partyId, 'message' => 'Party Id empty on line: ' . $rowNumber, 'errorline' => 'party_id' . $rowNumber];
                                $checkvalues[] = ['value' => $partyType, 'message' => 'Party Type empty on line: ' . $rowNumber, 'errorline' => 'party_type' . $rowNumber];
                                $checkvalues[] = ['value' => $partyName, 'message' => 'Party Name empty on line: ' . $rowNumber, 'errorline' => 'party_name' . $rowNumber];
                                $checkvalues[] = ['value' => $city, 'message' => 'City empty on line: ' . $rowNumber, 'errorline' => 'city' . $rowNumber];
                                $checkvalues[] = ['value' => $country, 'message' => 'Country empty on line: ' . $rowNumber, 'errorline' => 'country' . $rowNumber];
                                $checkvalues[] = ['value' => $street, 'message' => 'Street empty on line: ' . $rowNumber, 'errorline' => 'street' . $rowNumber];
                                $checkvalues[] = ['value' => $contact, 'message' => 'Contact is empty on line: ' . $rowNumber, 'errorline' => 'contact' . $rowNumber];
                                $checkvalues[] = ['value' => $email, 'message' => 'Email is empty on line: ' . $rowNumber, 'errorline' => 'email' . $rowNumber];
                                $checkvalues[] = ['value' => $fax, 'message' => 'Fax is empty on line: ' . $rowNumber, 'errorline' => 'fax' . $rowNumber];
                                $checkvalues[] = ['value' => $pincode, 'message' => 'Pincode is empty on line: ' . $rowNumber, 'errorline' => 'pincode' . $rowNumber];
                                $checkvalues[] = ['value' => $state, 'message' => 'State is empty on line: ' . $rowNumber, 'errorline' => 'state' . $rowNumber];
                                if ($partyId != "") {
                                    $data['parties'][] = [
                                        'party_id'   => $partyId,
                                        'party_name' => $partyName,
                                        'party_type' => $partyType,
                                        'city'       => $city,
                                        'country'    => $country,
                                        'street'     => $street,
                                        'phone'      => $contact,
                                        'email'      => $email,
                                        'fax'        => $fax,
                                        'rowno'      => $cargoRowNumber,
                                        'pincode'    => $pincode,
                                        'state'      => $state,
                                    ];
                                }
                            }
                            if (isset($finalData[$i][$j]['BQ'])) {
                                $x = 'BQ';
                                $y = "BQ";
                                for ($l = '0'; $l < 5; $l++) {
                                    if ($y != "") {
                                        $referenceId = $finalData[$i][$j][$y] ?? "";
                                        $y++;
                                        $y++;
                                        $y++;
                                        if ($referenceId != "") {
                                            $x++;
                                            $referenceName = $finalData[$i][$j][$x] ?? "";
                                            $x++;
                                            $referenceValue = $finalData[$i][$j][$x] ?? "";
                                            $x++;

                                            if ($referenceId != "") {
                                                $data['reference'][] = ['reference_id' => $referenceId, 'reference_name' => $referenceName, 'reference_value' => $referenceValue, 'rowno' => $rowNumber];

                                                $checkvalues[] = ['value' => $referenceName, 'message' => 'Reference Name empty on line: ' . $rowNumber, 'errorline' => 'reference_name' . $rowNumber];
                                                $checkvalues[] = ['value' => $referenceValue, 'message' => 'Reference Value empty on line: ' . $rowNumber, 'errorline' => 'reference_value' . $rowNumber];
                                            }
                                        } else {
                                            $x++;
                                            $x++;
                                            $x++;
                                        }
                                    }
                                }
                            }
                        }
                        $data['vas'] = [];
                        if (isset($finalData[$i]['0']['CF'])) {
                            $l = 0;
                            $x = 'CF';
                            $y = "CF";
                            for ($l = '0'; $l < 5; $l++) {
                                if ($y != "") {
                                    $vasId = $finalData[$i]['0'][$y] ?? "";
                                    $y++;
                                    $y++;
                                    if ($vasId != "") {
                                        $x++;
                                        $vasValue = $finalData[$i]['0'][$x] ?? "";
                                        $x++;
                                        if ($vasId != "") {
                                            $checkvalues[] = ['value' => $vasValue, 'message' => 'VAS Value empty on line: ' . $rowNumber, 'errorline' => 'vas_value' . $rowNumber];

                                            if ($companyCode == 'RUKN') {
                                                $getVasName = $this->common->gettblrowdata(['vas_id' => $vasId, 'company_code' => $companyCode], "vas_name", 'tb_vas_master', 0, 0);
                                            } else {
                                                $getVasName = $this->common->gettblrowdata(['vas_id' => $vasId, 'company_code!=' => $companyCode], "vas_name", 'tb_vas_master', 0, 0);
                                            }

                                            $vasName = "";
                                            if (! empty($getVasName)) {
                                                $vasName       = $getVasName['vas_name'];
                                                $data['vas'][] = ['vas_id' => $vasId, 'vas_name' => $vasName, 'vas_value' => $vasValue, 'rowno' => $rowNumber];
                                            }
                                        }
                                    } else {
                                        $x++;
                                        $x++;
                                    }
                                }
                            }
                        }
                        $driverPickupInstructions   = $finalData[$i]['0']['CP'] ?? "";
                        $driverDeliveryInstructions = $finalData[$i]['0']['CQ'] ?? "";
                        $purchaseOrder              = $finalData[$i]['0']['CR'] ?? "";
                        $notifyParty                = $finalData[$i]['0']['CS'] ?? "";
                        $goodsValue                 = $finalData[$i]['0']['CT'] ?? "";
                        $laneReference              = $finalData[$i]['0']['CU'] ?? "";
                        $customsRequired            = $finalData[$i]['0']['CV'] ?? "";
                        $highCargoValue             = $finalData[$i]['0']['CW'] ?? "";
                        $adValorence                = $finalData[$i]['0']['CX'] ?? "";
                        $temperatueControl          = $finalData[$i]['0']['CY'] ?? "";
                        $checkvalues[]              = ['value' => $driverPickupInstructions, 'message' => 'driver Pickup Instructions empty on line: ' . $rowNumber, 'errorline' => 'driver_pkup_inst' . $rowNumber];
                        $checkvalues[]              = ['value' => $driverDeliveryInstructions, 'message' => 'driver Delivery Instructions empty on line: ' . $rowNumber, 'errorline' => 'driver_dly_inst' . $rowNumber];
                        $checkvalues[]              = ['value' => $purchaseOrder, 'message' => 'Purchase Order empty on line: ' . $rowNumber, 'errorline' => 'purchase_order' . $rowNumber];
                        $checkvalues[]              = ['value' => $notifyParty, 'message' => 'Notify Paty empty on line: ' . $rowNumber, 'errorline' => 'notify_party' . $rowNumber];
                        $checkvalues[]              = ['value' => $goodsValue, 'message' => 'Goods Value empty on line: ' . $rowNumber, 'errorline' => 'goods_value' . $rowNumber];
                        $checkvalues[]              = ['value' => $laneReference, 'message' => 'Lane Reference empty on line: ' . $rowNumber, 'errorline' => 'lane_reference' . $rowNumber];
                        $checkvalues[]              = ['value' => $customsRequired, 'message' => 'Customs Required empty on line: ' . $rowNumber, 'errorline' => 'customs_req' . $rowNumber];
                        $checkvalues[]              = ['value' => $highCargoValue, 'message' => 'High Cargo Value empty on line: ' . $rowNumber, 'errorline' => 'high_cvalue' . $rowNumber];
                        $checkvalues[]              = ['value' => $adValorence, 'message' => 'Ad Valorence empty on line: ' . $rowNumber, 'errorline' => 'ad_valorence' . $rowNumber];
                        $checkvalues[]              = ['value' => $temperatueControl, 'message' => 'Temperature Control Value empty on line: ' . $rowNumber, 'errorline' => 'temp_control' . $rowNumber];
                        foreach ($checkvalues as $res) {
                            $value = $res['value'];
                            if ($value == "") {
                                $message[]   = $res['message'];
                                $errorLine[] = $res['errorline'];
                            } else {
                                $checkDate = $res['date'] ?? 0;
                                if ($checkDate === "1") {
                                    if (strstr($value, '1970-01-01')) {
                                        $message[]   = $res['message'];
                                        $errorLine[] = $res['errorline'];
                                    }
                                }
                            }
                        }
                        if ($purchaseOrder != "") {
                            $purchaseOrderDetails[] = $customerId . "_" . $purchaseOrder;
                        }
                        $atsParties[]           = ["name" => $pickupName, "street" => $pickupStreet, "city" => $pickupCity, "zipcode" => $pickupPincode, "country" => $pickupCountry, "type" => "shipper"];
                        $atsParties[]           = ["name" => $dropName, "street" => $dropStreet, "city" => $dropCity, "zipcode" => $dropPincode, "country" => $dropCountry, "type" => "consignee"];
                        $deliverynote_details[] = $customerId . "_" . $deliveryNote;
                        $data['ord_details'][]  = [
                            'pickup_id'        => $pickupId,
                            'pickup_name'      => $pickupName,
                            'pickup_street'    => $pickupStreet,
                            'customer_id'      => $customerId,
                            'pickup_city'      => $pickupCity,
                            'pickup_state'     => $pickupState,
                            'pickup_country'   => $pickupCountry,
                            'pickup_pincode'   => $pickupPincode,
                            'early_pickup'     => $earlyPickup,
                            'late_pickup'      => $latePickup,
                            'pickup_phone'     => $pickupPhone,
                            'pickup_fax'       => $pickupFax,
                            'pickup_email'     => $pickupEmail,
                            'drop_id'          => $dropId,
                            'drop_name'        => $dropName,
                            'drop_street'      => $dropStreet,
                            'drop_city'        => $dropCity,
                            'drop_state'       => $dropState,
                            'drop_country'     => $dropCountry,
                            'drop_pincode'     => $dropPincode,
                            'early_drop'       => $earlyDrop,
                            'late_drop'        => $lateDrop,
                            'drop_phone'       => $dropPhone,
                            'drop_fax'         => $dropFax,
                            'drop_email'       => $dropEmail,
                            'product'          => $product,
                            'delivery_terms'   => $deliveryTerms,
                            'incoterms'        => $incoterms,
                            'service'          => $service,
                            'company_code'     => $companyCode,
                            'branch_code'      => $branchCode,
                            'department_code'  => $departmentCode,
                            'delivery_note'    => $deliveryNote,
                            'purchase_order'   => $purchaseOrder,
                            'notify_party'     => $notifyParty,
                            'goods_value'      => $goodsValue,
                            'lane_reference'   => $laneReference,
                            'customs_req'      => $customsRequired,
                            'high_cvalue'      => $highCargoValue,
                            'ad_valorence'     => $adValorence,
                            'temp_control'     => $temperatueControl,
                            'cargo_details'    => $data['cargo_details'],
                            'involved_parties' => $data['parties'],
                            'reference'        => $data['reference'],
                            'rowno'            => $mainRowNumber,
                            'transport_mode'   => $transportMode,
                            'order_type'       => $orderType,
                            'vas'              => $data['vas'],
                            'pickup_extension' => $pickupExtension,
                            'drop_extension'   => $dropExtension,
                            'driver_pkup_inst' => $driverPickupInstructions,
                            'driver_dly_inst'  => $driverDeliveryInstructions,
                        ];
                    }
                }
            }
        }
        $getCountriesList = $this->common->gettbldata(["status" => '1'], "country_name", "tbl_country_master", 0, 0);
        if (! empty($getCountriesList)) {
            foreach ($getCountriesList as $row) {
                $countries[] = strtoupper($row['country_name']);
            }
        }
        $duplicatePuchaseOrders = [];
        if (! empty($purchaseOrderDetails)) {
            $poountValues = array_count_values($purchaseOrderDetails);
            foreach ($poountValues as $key => $value) {
                if ($value > 1) {
                    $duplicatePuchaseOrders[] = $key;
                }
            }
        }
        $duplicateDeliveryNotes = [];
        if (! empty($deliverynote_details)) {
            $dqCountValues = array_count_values($deliverynote_details);
            foreach ($dqCountValues as $key => $value) {
                if ($value > 1) {
                    $duplicateDeliveryNotes[] = $key;
                }
            }
        }
        $data['errorline']                = $errorline;
        $data["message"]                  = $message;
        $data["page_title"]               = "Import Orders";
        $data['porder_details']           = $purchaseOrderDetails;
        $data['purchaseduplicate_values'] = ($companyCode != "PHKN") ? $duplicatePuchaseOrders : [];
        $data['deliveryduplicate_values'] = $duplicateDeliveryNotes;
        $data['countries']                = $countries;
        $data['ats_parties']              = $atsParties;
        $this->settemplate->dashboard("orders/importbooking", $data);
    }

    public function getMasterDataForNormalExcelUpload(array $orders): array
    {
        $allCustomerIds      = $allPickupIds      = $allDropIds      = $dbCustomerIds      = $dbPickupIds      = $dbDropIds      = [];
        $shipperTypeId       = $consigneeTypeId       = 0;
        $sessionCompanyCode  = $this->session->userdata("company_code");
        $getAllPartyTypesIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND status =? AND company_code LIKE ? GROUP BY name", [['Shipper', 'Consignee'], 1, $sessionCompanyCode]);
        foreach ($getAllPartyTypesIds->result_array() as $eachLine) {
            $partyTypeName = strtoupper($eachLine['name']);
            if ($partyTypeName == "SHIPPER") {
                $shipperTypeId = $eachLine['id'];
            } else {
                $consigneeTypeId = $eachLine['id'];
            }
        }
        foreach ($orders as $eachOrderData) {
            $allCustomerIds[] = mb_strtoupper($eachOrderData['customer_id'] ?: 0);
            $allPickupIds[]   = mb_strtoupper($eachOrderData['pickup_id'] ?: 0);
            $allDropIds[]     = mb_strtoupper($eachOrderData['drop_id'] ?: 0);
        }
        if (! empty($allCustomerIds)) {
            $getCustomerDetails = $this->db->query("SELECT id,code FROM tb_customers WHERE CODE IN ? AND status = ? AND company_code = ?", [$allCustomerIds, 1, $sessionCompanyCode]);
            foreach ($getCustomerDetails->result_array() as $eachRow) {
                $dbCustomerIds[$eachRow['code']] = $eachRow['id'];
            }
        }
        if (! empty($allPickupIds)) {
            $getPickupDetails = $this->db->query("SELECT id,code,latitude, longitude FROM tbl_party_master WHERE code IN ? AND company_code = ? AND status = ?", [$allPickupIds, $sessionCompanyCode, '1']);
            foreach ($getPickupDetails->result_array() as $eachRow) {
                $dbPickupIds[$eachRow['code']] = ['id' => $eachRow['id'], 'latitude' => $eachRow['latitude'], 'longitude' => $eachRow['longitude'], 'partytype' => $shipperTypeId];
            }
        }
        if (! empty($allDropIds)) {
            $getDropDetails = $this->db->query("SELECT id,code,latitude, longitude FROM tbl_party_master WHERE code IN ? AND company_code = ? AND status = ?", [$allDropIds, $sessionCompanyCode, '1']);
            foreach ($getDropDetails->result_array() as $eachRow) {
                $dbDropIds[$eachRow['code']] = ['id' => $eachRow['id'], 'latitude' => $eachRow['latitude'], 'longitude' => $eachRow['longitude'], 'partytype' => $consigneeTypeId];
            }
        }
        $response = ['shipperTypeId' => $shipperTypeId, 'consigneeTypeId' => $consigneeTypeId, 'dbCustomerIds' => $dbCustomerIds, 'dbPickupIds' => $dbPickupIds, 'dbDropIds' => $dbDropIds];
        return $response;
    }

    public function getServiceDeliveryTermsAndOrderTypeFromExcelData(string $service, string $deliveryTerms, int $customerRowId, string $orderType, string $sessionCompanyCode): array
    {
        $serviceId = $termId = 0;
        $typeName  = "";
        if ($customerRowId > 0) {
            if ($service != "") {
                $servicesArray = explode('-', $service);
                if (! empty($servicesArray)) {
                    $enteredServiceId = trim($servicesArray[0]) ?? "";
                    $serviceName      = trim($servicesArray[1]) ?? "";
                    if ($enteredServiceId != "" && $serviceName != "") {
                        $getService = $this->db->query("SELECT id FROM tb_service_master WHERE ( name  LIKE ? OR service_id LIKE ? ) AND company_code LIKE ? AND status = ?", ['%' . $serviceName . '%', $enteredServiceId, $sessionCompanyCode, 1]);
                        if ($getService->num_rows() > 0) {
                            $serviceId = $getService->row()->id;
                        } else {
                            $getService = $this->db->query("SELECT id FROM tb_service_master WHERE (name LIKE ? OR service_id LIKE ? ) AND ( company_code = ? OR company_code IS NULL) AND status = ? ", [$serviceName, $enteredServiceId, '', '1']);
                            if ($getService->num_rows() > 0) {
                                $serviceId = $getService->row()->id;
                            }
                        }
                    } else {
                        if ($enteredServiceId != "") {
                            $getService = $this->db->query("SELECT id FROM tb_service_master WHERE (name LIKE ? OR service_id LIKE ? ) AND company_code = ? AND status = ? ", ['%' . $enteredServiceId . '%', $enteredServiceId, $sessionCompanyCode, '1']);
                            if ($getService->num_rows() > 0) {
                                $serviceId = $getService->row()->id;
                            } else {
                                $getService = $this->db->query("SELECT id FROM tb_service_master WHERE (name LIKE ? OR service_id LIKE ? ) AND (company_code = ? OR company_code IS NULL ) AND status = ? ", ['%' . $enteredServiceId . '%', $enteredServiceId, '', '1']);
                                if ($getService->num_rows() > 0) {
                                    $serviceId = $getService->row()->id;
                                }
                            }
                        }
                    }
                }
            }
            $termId = "";
            if ($sessionCompanyCode == 'RUKN') {
                if ($deliveryTerms != "") {
                    $getTerms = $this->db->query("SELECT term_id FROM tb_delivery_terms WHERE name LIKE ? AND term_id IN ?", ['%' . $deliveryTerms . '%', ['10', '12', '82']]);
                    if ($getTerms->num_rows() > 0) {
                        $termId = $getTerms->row()->term_id;
                    }
                }
            } else {
                if ($deliveryTerms != "") {
                    $terms = explode(' ', $deliveryTerms, 2);
                    if (! empty($terms)) {
                        $termId             = $terms[0] ?? "";
                        $secondTerms        = $terms[1] ?? "";
                        $deliveryTermsArray = [];
                        if ($secondTerms != "") {
                            $deliveryTermsArray = explode('-', $secondTerms);
                        } else {
                            $termName = $termId;
                        }
                        if (! empty($deliveryTermsArray)) {
                            $termName = trim($deliveryTermsArray[0]) ?? "";
                            $incoterm = trim($deliveryTermsArray[1]) ?? "";
                            if ($termName != "" && $termId != "" && $incoterm != "") {
                                $getTerms = $this->db->query("SELECT term_id FROM tb_delivery_terms WHERE name LIKE ? AND term_id LIKE ? AND incoterm LIKE ?", ['%' . $termName . '%', $termId, $incoterm]);
                                if ($getTerms->num_rows() > 0) {
                                    $termId = $getTerms->row()->term_id;
                                }
                            }
                        }
                    }
                }
            }
            if ($orderType != "") {
                $type = $this->db->query("SELECT id FROM tb_order_types WHERE customer_id=? AND type_name LIKE ? AND status = ?", [$customerRowId, $orderType, 1]);
                if ($type->num_rows() > 0) {
                    $typeName = $type->row()->id;
                } else {
                    $type = $this->db->query("SELECT id FROM tb_order_types WHERE ( type_name LIKE ? OR ordtype_code LIKE ? ) AND company_code LIKE ? AND status = ?", [$orderType, $orderType, $sessionCompanyCode, '1']);
                    if ($type->num_rows() > 0) {
                        $typeName = $type->row()->id;
                    }
                }
            }
        }
        $response = ['serviceId' => $serviceId, 'termId' => $termId, 'typeName' => $typeName];
        return $response;
    }

    public function getFinalDataFromNormalExcelUpload(array $data): array
    {
        $row               = 3;
        $excelData         = [];
        $checkDeliveryNote = "";
        $indexValue        = 0;
        foreach ($data["arraydata"] as $value[$row]) {
            $indexValue++;
            $deliveryNote       = $value[$row]['A'] ?? "";
            $customerId         = $value[$row]['I'] ?? "";
            $recentDeliveryNote = $deliveryNote . $customerId;
            if ($checkDeliveryNote != $recentDeliveryNote) {
                if ($recentDeliveryNote != "") {
                    $checkDeliveryNote               = $recentDeliveryNote . $indexValue;
                    $value[$row]['row']              = $row;
                    $excelData[$checkDeliveryNote][] = $value[$row];
                    $row++;
                } else {
                    $value[$row]['row']              = $row;
                    $excelData[$checkDeliveryNote][] = $value[$row];
                    $row++;
                }
            } else {
                $value[$row]['row']              = $row;
                $excelData[$checkDeliveryNote][] = $value[$row];
                $row++;
            }
        }
        $finalData = [];
        foreach ($excelData as $eachRowData) {
            $finalData[] = $eachRowData;
        }
        return $finalData;
    }

    public function addorderdata(): void
    {
        ini_set("max_input_time", 2000);
        ini_set("max_execution_time", 2000);
        ini_set("max_input_vars", 20000);
        ini_set("upload_max_size", "2048M");
        ini_set("post_max_size", 0);
        ini_set("memory_limit", "2048M");
        $excel_orders       = $excelSuccessOrders       = $excelFailOrders       = $noBookingIds       = [];
        $dropLatitude = $dropLongitude = $pickupLatitude = $pickupLongitude = "";
        $currentDate        = date('Y-m-d H:i:s');
        $year               = date('y');
        $week               = date('W');
        $userId             = $this->session->userdata('user_id');
        $currentTimeZone    = $this->session->userdata("usr_tzone")['timezone'];
        $sessionCompanyCode = $this->session->userdata('company_code');
        $getCountry         = $this->db->select('country_code,company_code')->get_where("tb_users", ['id' => $userId]);
        $countryCode        = $getCountry->row()->country_code;
        $response           = [];
        if (! empty($_POST['orders'])) {
            $response        = $this->getMasterDataForNormalExcelUpload($_POST['orders']);
            $shipperTypeId   = $response['shipperTypeId'] ?? 0;
            $consigneeTypeId = $response['consigneeTypeId'] ?? 0;
            $dbCustomerIds   = $response['dbCustomerIds'] ?? [];
            $dbPickupIds     = $response['dbPickupIds'] ?? [];
            $dbDropIds       = $response['dbDropIds'] ?? [];
            foreach ($_POST['orders'] as $data) {
                $additonalDetails           = $referenceArray           = [];
                $companyCode                = mb_strtoupper($data['company_code'] ?? "");
                $branchCode                 = mb_strtoupper($data['branch_code'] ?? "");
                $departmentCode             = mb_strtoupper($data['department_code'] ?? "");
                $purchaseOrder              = mb_strtoupper($data['purchase_order'] ?? "");
                $driverPickupInstructions   = mb_strtoupper($data['driver_pkup_inst'] ?? "");
                $driverDeliveryInstructions = mb_strtoupper($data['driver_dly_inst'] ?? "");
                $product                    = mb_strtoupper($data['product'] ?? "");
                $service                    = mb_strtoupper($data['service'] ?? "");
                $deliveryTerms              = mb_strtoupper($data['delivery_terms'] ?? "");
                $orderType                  = mb_strtoupper($data['order_type'] ?? "");
                $customerId                 = mb_strtoupper($data['customer_id'] ?? "");
                $customerRowId              = 0;
                if ($customerId != "") {
                    $customerRowId = $dbCustomerIds[$customerId] ?? 0;
                }
                $mastersResponse = $this->getServiceDeliveryTermsAndOrderTypeFromExcelData(
                    $service,
                    $deliveryTerms,
                    $customerRowId,
                    $orderType,
                    $sessionCompanyCode
                );
                $serviceId          = $mastersResponse['serviceId'] ?? 0;
                $termId             = $mastersResponse['termId'] ?? 0;
                $typeName           = $mastersResponse['typeName'] ?? "";
                $incoterm           = mb_strtoupper($data['incoterms'] ?? "");
                $shipmentNumber     = mb_strtoupper($data['delivery_note'] ?? "");
                $notifyParty        = mb_strtoupper($data['notify_party'] ?? "");
                $goodsValue         = mb_strtoupper($data['goods_value'] ?? "0.00");
                $laneReference      = mb_strtoupper($data['lane_reference'] ?? "");
                $distance           = mb_strtoupper($data['distance'] ?? "");
                $customsRequired    = mb_strtoupper($data['customs_req'] ?? "");
                $highValueCargo     = mb_strtoupper($data['high_cvalue'] ?? "");
                $adValorenceIns     = mb_strtoupper($data['ad_valorence'] ?? "");
                $temperatureControl = mb_strtoupper($data['temp_control'] ?? "");
                $earlyPickup        = mb_strtoupper($data['early_pickup'] ?? "");
                $latePickup         = mb_strtoupper($data['late_pickup'] ?? "");
                $earlyDelivery      = mb_strtoupper($data['early_drop'] ?? "");
                $lateDelivery       = mb_strtoupper($data['late_drop'] ?? "");
                $transportMode      = mb_strtoupper($data['transport_mode'] ?? "");
                if ($customerRowId > 0) {
                    $currentDate = $ePickup = date('Y-m-d H:i:s');
                    if ($earlyPickup != "") {
                        $ePickup = date('Y-m-d H:i:s', strtotime($earlyPickup));
                    }
                    if ($latePickup != "") {
                        $lPickup = date('Y-m-d H:i:s', strtotime($latePickup));
                    } else {
                        $lPickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($ePickup)));
                    }
                    $eDelivery = date('Y-m-d H:i:s');
                    if ($earlyDelivery != "") {
                        $eDelivery = date('Y-m-d H:i:s', strtotime($earlyDelivery));
                    } else {
                        $eDelivery = date('Y-m-d H:i:s', strtotime('+3 hour', strtotime($currentDate)));
                    }
                    if ($lateDelivery != "") {
                        $lDelivery = date('Y-m-d H:i:s', strtotime($lateDelivery));
                    } else {
                        $lDelivery = date('Y-m-d H:i:s', strtotime('+4 hour', strtotime($currentDate)));
                    }

                    $pickupId       = mb_strtoupper($data['pickup_id'] ?: "0");
                    $pikupName      = mb_strtoupper($data['pickup_name'] ?? "");
                    $pikupStreet    = mb_strtoupper($data['pickup_street'] ?? "");
                    $pikupCity      = mb_strtoupper($data['pickup_city'] ?? "");
                    $pikupState     = mb_strtoupper($data['pickup_state'] ?? "");
                    $pikupCountry   = mb_strtoupper($data['pickup_country'] ?? "");
                    $pikupPincode   = mb_strtoupper($data['pickup_pincode'] ?? "");
                    $pikupFax       = mb_strtoupper($data['pickup_fax'] ?? "");
                    $pikupEmail     = mb_strtoupper($data['pickup_email'] ?? "");
                    $pikupPhone     = mb_strtoupper($data['pickup_phone'] ?? "");
                    $pikupExtension = mb_strtoupper($data['pickup_extension'] ?? "");
                    $address        = $pikupStreet . ',' . $pikupCity . ',' . $pikupCountry;
                    $masterData     = ['party_type_id' => $shipperTypeId, 'name' => $pikupName, 'mobile' => $pikupPhone, 'street' => $pikupStreet, 'location_id' => $pikupCity, 'state' => $pikupState, 'pincode' => $pikupPincode, 'code' => $pickupId, 'customeridentifier' => $pickupId, 'country' => $pikupCountry, 'email' => $pikupEmail, 'fax' => $pikupFax, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'address' => $address, 'extension' => $pikupExtension];
                    if ($pickupId != "0") {
                        $shipperRowId = $dbPickupIds[$pickupId]['id'] ?? 0;
                        if ((int) $shipperRowId === 0) {
                            $masterData['created_on'] = $currentDate;
                            $masterData['user_id']    = $userId;
                            $shipperRowId             = $this->common->insertTableData("tbl_party_master", $masterData);
                            if ($shipperRowId > 0) {
                            } else {
                                if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                                } else {
                                    $noBookingIds[]    = $customerId . $shipmentNumber;
                                    $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                                }
                            }
                        } else {
                            $pickupLatitude  = $dbPickupIds[$pickupId]['latitude'] ?? "";
                            $pickupLongitude = $dbPickupIds[$pickupId]['longitude'] ?? "";
                        }
                    } else {
                        if ($companyCode == 'RUKN') {
                            $checkAddress = $this->db->query("SELECT id,latitude,longitude FROM tbl_party_master WHERE name = ? AND location_id = ? AND country = ? AND street = ? AND pincode = ? AND status =? AND company_code = ?", [$pikupName, $pikupCity, $pikupCountry, $pikupStreet, $pikupPincode, 1, $companyCode]);
                        } else {
                            $checkAddress = $this->db->query("SELECT id,latitude,longitude FROM tbl_party_master WHERE name = ? AND location_id = ? AND country = ? AND street = ? AND pincode = ? AND status =? AND user_id = ?", [$pikupName, $pikupCity, $pikupCountry, $pikupStreet, $pikupPincode, 1, $userId]);
                        }
                        if ($checkAddress->num_rows() > 0) {
                            $shipperRowId    = $checkAddress->row()->id;
                            $pickupLatitude  = $checkAddress->row()->latitude ?? "";
                            $pickupLongitude = $checkAddress->row()->longitude ?? "";
                        } else {
                            $shipperRowId = $this->common->insertTableData("tbl_party_master", $masterData);
                            if ($shipperRowId > 0) {
                            } else {
                                if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                                } else {
                                    $noBookingIds[]    = $customerId . $shipmentNumber;
                                    $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                                }
                            }
                            $shipperId = $countryCode . $year . $week . $shipperRowId;
                            $this->common->updatetbledata("tbl_party_master", ['code' => $shipperId, 'customeridentifier' => $shipperId], ['id' => $shipperRowId]);
                        }
                    }
                    $dropId        = mb_strtoupper($data['drop_id'] ?: 0);
                    $dropName      = mb_strtoupper($data['drop_name'] ?? "");
                    $dropStreet    = mb_strtoupper($data['drop_street'] ?? "");
                    $dropCity      = mb_strtoupper($data['drop_city'] ?? "");
                    $dropState     = mb_strtoupper($data['drop_state'] ?? "");
                    $dropCountry   = mb_strtoupper($data['drop_country'] ?? "");
                    $dropPincode   = mb_strtoupper($data['drop_pincode'] ?? "");
                    $dropFax       = mb_strtoupper($data['drop_fax'] ?? "");
                    $dropEmail     = mb_strtoupper($data['drop_email'] ?? "");
                    $dropPhone     = mb_strtoupper($data['drop_phone'] ?? "");
                    $dropExtension = mb_strtoupper($data['drop_extension'] ?? "");
                    $daddress      = $dropStreet . ',' . $dropCity . ',' . $dropCountry;

                    $dropData      = ['party_type_id' => $consigneeTypeId, 'name' => $dropName, 'mobile' => $dropPhone, 'street' => $dropStreet, 'location_id' => $dropCity, 'state' => $dropState, 'pincode' => $dropPincode, 'code' => $dropId, 'customeridentifier' => $dropId, 'country' => $dropCountry, 'email' => $dropEmail, 'fax' => $dropFax, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'address' => $daddress, 'extension' => $dropExtension];
                    $getDropLatLng = $this->db->query("SELECT latitude, longitude FROM tbl_party_master WHERE code = ? AND company_code = ? AND branch_code = ?", [$dropId, $companyCode, $branchCode]);
                    if ($getDropLatLng->num_rows() > 0) {
                        $dropLatitude  = $getDropLatLng->row()->latitude ?? "";
                        $dropLongitude = $getDropLatLng->row()->longitude ?? "";
                    }
                    if ($dropId != '0') {
                        $dropRowId = $dbDropIds[$dropId]['id'] ?? 0;
                        if ((int) $dropRowId === 0) {
                            $dropData['user_id']    = $userId;
                            $dropData['created_on'] = $currentDate;
                            $dropRowId              = $this->common->insertTableData("tbl_party_master", $dropData);
                        }
                        if ($dropRowId > 0) {
                        } else {
                            if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                            } else {
                                $noBookingIds[]    = $customerId . $shipmentNumber;
                                $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                            }
                        }
                    } else {
                        if ($companyCode == 'RUKN') {
                            $checkAddress = $this->db->query("SELECT id,latitude,longitude FROM tbl_party_master WHERE name = ? AND location_id = ? AND country = ? AND street = ? AND pincode = ? AND status = ? AND company_code = ?", [$dropName, $dropCity, $dropCountry, $dropStreet, $dropPincode, 1, $companyCode]);
                        } else {
                            $checkAddress = $this->db->query("SELECT id,latitude,longitude FROM tbl_party_master WHERE name = ? AND location_id = ? AND country = ? AND street = ? AND pincode = ? AND status = ? AND user_id = ?", [$dropName, $dropCity, $dropCountry, $dropStreet, $dropPincode, 1, $userId]);
                        }
                        if ($checkAddress->num_rows() > 0) {
                            $dropRowId = $checkAddress->row()->id;
                        } else {
                            $dropRowId = $this->common->insertTableData("tbl_party_master", $dropData);
                            if ($dropRowId > 0) {
                            } else {
                                if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                                } else {
                                    $noBookingIds[]    = $customerId . $shipmentNumber;
                                    $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                                }
                            }
                            $dropId = $countryCode . $year . $week . $dropRowId;
                            $this->common->updatetbledata("tbl_party_master", ['code' => $dropId, 'customeridentifier' => $dropId], ['id' => $dropRowId]);
                        }
                    }
                    $shipRowId = 0;
                    $enddate   = date('Y-m-d H:i:s', strtotime("+1 day"));
                    $tid       = 1;
                    $tname     = $tcode     = "";
                    if ($transportMode == 'Full truck load') {
                        $transportMode = 'FTL';
                    }
                    if ($transportMode == 'Less than Truckload') {
                        $transportMode = "LTL";
                    }
                    $getTransportMode = $this->db->query("SELECT id,code,name FROM tb_transportmode WHERE (code LIKE ? OR name LIKE ? )", [$transportMode, $transportMode]);
                    if ($getTransportMode->num_rows() > 0) {
                        $tid   = $getTransportMode->row()->id;
                        $tcode = $getTransportMode->row()->code;
                        $tname = $getTransportMode->row()->name;
                    }
                    if ($shipmentNumber == "") {
                        $shipmentNumber = "SVK" . time();
                    }
                    $additonalDetails[] = ['value' => $temperatureControl, 'type' => '1'];
                    $additonalDetails[] = ['value' => $adValorenceIns, 'type' => '2'];
                    $additonalDetails[] = ['value' => $highValueCargo, 'type' => '3'];
                    $additonalDetails[] = ['value' => $customsRequired, 'type' => '4'];
                    $additonalDetails[] = ['value' => $distance, 'type' => '5'];
                    $additonalDetails[] = ['value' => $laneReference, 'type' => '6'];
                    $additonalDetails[] = ['value' => $goodsValue, 'type' => '7'];
                    foreach ($additonalDetails as $eachDetail) {
                        if (is_numeric($eachDetail['value'])) {
                            if ($eachDetail['value'] > 0) {
                                $value = $eachDetail['value'];
                                switch ($value) {
                                    case "1":
                                        $temperatureControl = $value;
                                        break;
                                    case "2":
                                        $adValorenceIns = $value;
                                        break;
                                    case "3":
                                        $highValueCargo = $value;
                                        break;
                                    case "4":
                                        $customsRequired = $value;
                                        break;
                                    case "5":
                                        $distance = $value;
                                        break;
                                    case "6":
                                        $laneReference = $value;
                                        break;
                                    case "7":
                                        $goodsValue = $value;
                                        break;
                                    default:
                                        $temperatureControl = $adValorenceIns = $highValueCargo = $customsRequired = $distance = $laneReference = $goodsValue = 0;
                                }
                            }
                        }
                    }
                    $temperatureControl   = $temperatureControl ?: 0;
                    $adValorenceIns       = $adValorenceIns ?: 0;
                    $highValueCargo       = $highValueCargo ?: 0;
                    $customsRequired      = $customsRequired ?: 0;
                    $distance             = $distance ?: 0;
                    $laneReference        = $laneReference ?: 0;
                    $goodsValue           = $goodsValue ?: "0.00";
                    $shipid               = "SVK" . time();
                    $getDeliveryNoteCount = $this->db->query("SELECT count(id) as dqcount FROM tb_order_references WHERE reference_id = ? AND ref_value LIKE ?", ['DQ', $shipid . '%']);
                    if ($getDeliveryNoteCount->num_rows() > 0) {
                        $appendval = $getDeliveryNoteCount->row()->dqcount;
                        $shipid    = $shipid . $appendval;
                    }
                    if ($shipmentNumber == "") {
                        $shipmentNumber = $shipid;
                    }
                    $shipmentArray = [
                        'unitspec'         => 1,
                        'shipid'           => $shipid,
                        'txnid'            => $shipid,
                        'trucktype'        => $tname,
                        'pickupcnt'        => '1',
                        'dropcnt'          => '1',
                        'insertusr'        => $pickupId,
                        'carrier'          => '0',
                        'insertuserdate'   => $currentDate,
                        'enddate'          => $enddate,
                        'insdate'          => $currentDate,
                        'upddate'          => $currentDate,
                        'reason'           => 'SHIPMENT',
                        'purpose'          => 'SEND INTEGRATION',
                        'ship_object'      => 'SHIPMENT',
                        'logdate'          => $currentDate,
                        'transport_mode'   => $tcode,
                        'domainname'       => $branchCode,
                        'company_code'     => $companyCode,
                        'branch_code'      => $branchCode,
                        'product'          => $product,
                        'freight_term'     => '60',
                        'freight_termname' => 'Free of Charge',
                        'incoterm'         => $incoterm,
                        'modeoftransport'  => $tid,
                    ];
                    $checkShipId = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE ?", [$shipid]);
                    if ($checkShipId->num_rows() > 0) {
                        $shipRowId = $checkShipId->row()->id;
                        $this->common->updatetbledata("tb_shipments", $shipmentArray, $shipRowId);
                    } else {
                        $shipmentArray['createdon'] = $currentDate;
                        $shipRowId                  = $this->common->insertTableData("tb_shipments", $shipmentArray);
                        if ($shipRowId == 0) {
                            if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                            } else {
                                $noBookingIds[]    = $customerId . $shipmentNumber;
                                $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                            }
                        }
                    }
                    if ($pickupLatitude != "" && $pickupLongitude != "" && $dropLatitude != "" && $dropLongitude != "") {
                        $lat1 = $pickupLatitude;
                        $lng1 = $pickupLongitude;
                        $lat2 = $dropLatitude;
                        $lng2 = $dropLongitude;
                    } else {
                        $add1 = implode(",", [$pikupStreet, $pikupCity, $pikupCountry, $pikupPincode]);
                        $add2 = implode(",", [$dropStreet, $dropCity, $dropCountry, $dropPincode]);
                        $loc  = getlatlngsbyplace($add1);
                        $lat1 = $loc[0] ?? null;
                        $lng1 = $loc[1] ?? null;
                        $loc  = getlatlngsbyplace($add2);
                        $lat2 = $loc[0] ?? null;
                        $lng2 = $loc[1] ?? null;
                    }

                    $logDate      = date('Y-m-d H:i:s');
                    $getactual    = getdatetimebytimezone(DFLT_TZ, $logDate, $currentTimeZone);
                    $logDate      = $getactual['datetime'];
                    $getpickup    = getdatetimebytimezone(DFLT_TZ, $ePickup, $currentTimeZone);
                    $ePickup      = $getpickup['datetime'];
                    $getlpickup   = getdatetimebytimezone(DFLT_TZ, $lPickup, $currentTimeZone);
                    $lPickup      = $getlpickup['datetime'];
                    $getdelivery  = getdatetimebytimezone(DFLT_TZ, $eDelivery, $currentTimeZone);
                    $eDelivery    = $getdelivery['datetime'];
                    $getldelivery = getdatetimebytimezone(DFLT_TZ, $lDelivery, $currentTimeZone);
                    $lDelivery    = $getldelivery['datetime'];
                    $childId      = 0;
                    if ($this->session->userdata('childid')) {
                        $childId = $this->session->userdata('childid');
                    }
                    $orderId = 0;
                    if ($companyCode == 'RUKN') {
                        $chkOrder = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.customer_id=? AND o.company_code LIKE ? AND o.status > ? AND o.id=r.order_id AND r.reference_id LIKE ? AND r.ref_value = ? AND r.status= ?", [$customerRowId, $companyCode, 0, 'DQ', $shipmentNumber, 1]);
                    } else {
                        $chkOrder = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.customer_id=? AND o.user_id LIKE ? AND o.status > ? AND o.id=r.order_id AND r.reference_id LIKE ? AND r.ref_value = ? AND r.status= ?", [$customerRowId, $userId, 0, 'DQ', $shipmentNumber, 1]);
                    }
                    if ($chkOrder->num_rows() == 0) {
                        $orderInfo = [
                            'shipment_id'       => $shipRowId,
                            'customer_id'       => $customerRowId,
                            'drop_custid'       => $dropId,
                            'drop_partyid'      => $dropId,
                            'product'           => $product,
                            'goods_value'       => $goodsValue,
                            'company_code'      => $companyCode,
                            'branch_code'       => $branchCode,
                            'pickup_datetime'   => $ePickup,
                            'delivery_datetime' => $eDelivery,
                            'pickup_endtime'    => $lPickup,
                            'drop_endtime'      => $lDelivery,
                            'createdon'         => $currentDate,
                            'user_id'           => $userId,
                            'sub_uid'           => $childId,
                            'pickup_custid'     => $pickupId,
                            'pickup_partyid'    => $pickupId,
                            'pickup_country'    => $pikupCountry,
                            'pickup_city'       => $pikupCity,
                            'pickup_pincode'    => $pikupPincode,
                            'pickup_company'    => $pikupName,
                            'pickup_address1'   => $pikupStreet,
                            'delivery_country'  => $dropCountry,
                            'delivery_city'     => $dropCity,
                            'delivery_pincode'  => $dropPincode,
                            'delivery_company'  => $dropName,
                            'delivery_address1' => $dropStreet,
                            'transport_mode'    => $tcode,
                            'pickup_address2'   => $pikupState,
                            'delivery_address2' => $dropState,
                            'plat'              => $lat1,
                            'plng'              => $lng1,
                            'dlat'              => $lat2,
                            'dlng'              => $lng2,
                            'modeoftransport'   => $tid,
                            'created_source'    => '4',
                            'createdon'         => $logDate,
                        ];
                        $orderId = $this->common->insertTableData("tb_orders", $orderInfo);
                        if ($orderId == 0) {
                            if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                            } else {
                                $noBookingIds[]    = $customerId . $shipmentNumber;
                                $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                            }
                        }
                        if ($orderId > 0) {
                            $genord    = ["user_id" => $userId, "order_id" => $orderId, "country_code" => $countryCode, "company_code" => $companyCode];
                            $bookingId = generatebookingid($genord);
                            if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                            } else {
                                $excelSuccessOrders[] = ['booking_id' => $bookingId, 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Success'];
                            }
                            $this->common->updatetbledata("tb_orders", ['order_id' => $bookingId], ['id' => $orderId]);
                            makeorderinvolvedpartiestype($customerRowId, $orderId, "CUSTOMER", $userId, $companyCode);
                            insertOrdersRefFileLineIdentifier(['pickupCity' => $pikupCity, 'pickupState' => $pikupState, 'pickupCountry' => $pikupCountry, 'dropCity' => $dropCity, 'dropState' => $dropState, 'dropCountry' => $dropCountry, 'companyCode' => $companyCode, 'branchCode' => $branchCode, 'orderRowId' => $orderId, 'date' => $currentDate]);
                            $details = [
                                'service'             => $serviceId,
                                'department_code'     => $departmentCode,
                                'delivery_term'       => $termId,
                                'incoterm'            => $incoterm,
                                'notify_party'        => $notifyParty,
                                'lane_reference'      => $laneReference,
                                'distance'            => $distance,
                                'temperature_control' => $temperatureControl,
                                'valorance_insurance' => $adValorenceIns,
                                'high_cargo_value'    => $highValueCargo,
                                'customs_required'    => $customsRequired,
                                'order_id'            => $bookingId,
                                'order_row_id'        => $orderId,
                                'createdon'           => $currentDate,
                                'shipper_id'          => $shipperRowId,
                                'order_type'          => $typeName,
                            ];
                            $this->common->insertTableData("tb_order_details", $details);
                            if ($shipperRowId != 0) {
                                $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $shipperRowId, 'location_id' => $pikupCity, 'street' => $pikupStreet, 'state' => $pikupState, 'address' => $address, 'pincode' => $pikupPincode, 'country' => $pikupCountry, 'user_id' => $userId]);
                                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'order_number' => $bookingId, 'party_id' => $shipperRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $shipperTypeId]);
                            }
                            if ($dropRowId != 0) {
                                $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderId, 'party_master_id' => $dropRowId, 'location_id' => $dropCity, 'street' => $dropStreet, 'state' => $dropState, 'address' => $daddress, 'pincode' => $dropPincode, 'country' => $dropCountry, 'user_id' => $userId]);
                                $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'order_number' => $bookingId, 'party_id' => $dropRowId, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $consigneeTypeId]);
                            }
                            $cargo = $data['cargo_details'] ?? [];
                            if (! empty($cargo)) {
                                foreach ($cargo as $car) {
                                    $cargoType        = mb_strtoupper($car['cargo_type'] ?? "");
                                    $goodsDescription = mb_strtoupper($car['goods_description'] ?? "");
                                    $quantity         = mb_strtoupper($car['quantity'] ?? "0");
                                    $length           = mb_strtoupper($car['length'] ?? "0.00");
                                    $lengthUom        = mb_strtoupper($car['length_uom'] ?? "m");
                                    $width            = mb_strtoupper($car['width'] ?? "0.00");
                                    $widthUom         = mb_strtoupper($car['width_uom'] ?? "m");
                                    $height           = mb_strtoupper($car['height'] ?? "0.00");
                                    $heightUom        = mb_strtoupper($car['height_uom'] ?? "m");
                                    $weight           = mb_strtoupper($car['weight'] ?? "0.00");
                                    $secondweight     = mb_strtoupper($car['secondweight'] ?? "0.00");
                                    $secondvolume     = mb_strtoupper($car['secondvolume'] ?? "0.00");
                                    $weightUom        = mb_strtoupper($car['weight_uom'] ?? "kg");
                                    $volume           = mb_strtoupper($car['volume'] ?? "0.00");
                                    $volumeUom        = mb_strtoupper($car['volume_uom'] ?? "cbm");
                                    $stackable        = mb_strtoupper($car['stackable'] ?? "");
                                    if ($stackable == 'on') {
                                        $stackable = 1;
                                    } else {
                                        $stackable = 0;
                                    }
                                    $length       = $length ?: '0.00';
                                    $width        = $width ?: '0.00';
                                    $height       = $height ?: '0.00';
                                    $weight       = $weight ?: '0.00';
                                    $volume       = $volume ?: '0.00';
                                    $secondvolume = $secondvolume ?: '0.00';
                                    $secondweight = $secondweight ?: '0.00';
                                    $cargoRowId   = $this->common->insertTableData(
                                        "tb_cargo_details",
                                        [
                                            'cargo_type'        => $cargoType,
                                            'goods_description' => $goodsDescription,
                                            'quantity'          => $quantity,
                                            'length'            => $length,
                                            'length_unit'       => $lengthUom,
                                            'width'             => $width,
                                            'width_unit'        => $widthUom,
                                            'height'            => $height,
                                            'height_unit'       => $heightUom,
                                            'weight'            => $weight,
                                            'weight_unit'       => $weightUom,
                                            'volume'            => $volume,
                                            'volume_unit'       => $volumeUom,
                                            'stackable'         => $stackable,
                                            'second_weight'     => $secondweight,
                                            'secondweight_uom'  => $weightUom,
                                            'second_volume'     => $secondvolume,
                                            'secondvolume_uom'  => $volumeUom,
                                            'createdby'         => $userId,
                                            'createdon'         => $currentDate,
                                        ]
                                    );
                                    $getHandlingUnit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE ? AND status = ?", [$cargoType, 1]);
                                    if ($getHandlingUnit->num_rows() > 0) {
                                        $handlingUnit = $getHandlingUnit->row()->id;
                                    } else {
                                        $handlingUnit = $this->common->insertTableData("tbl_shipunit_types", ['unit_name' => $cargoType, 'description' => $cargoType, 'user_id' => $userId, 'created_at' => $currentDate, 'status' => '1']);
                                    }
                                    $cargo = ['order_id' => $orderId, 'quantity' => $quantity, 'cargo_id' => $cargoRowId, 'status' => '1', 'createdon' => $currentDate, 'cargo_content' => $goodsDescription, 'quantity_type' => $cargoType, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'second_weight' => $secondweight, 'second_volume' => $secondvolume, 'handling_unit' => $handlingUnit];
                                    $this->common->insertTableData("tb_order_cargodetails", $cargo);
                                    $innercargo_details = $car['innercargo_details'] ?? [];
                                    if (! empty($innercargo_details)) {
                                        foreach ($innercargo_details as $inner) {
                                            $innercargoType   = mb_strtoupper($inner['innercargo_type'] ?? "");
                                            $goodsDescription = mb_strtoupper($inner['innergoods_description'] ?? "");
                                            $quantity         = mb_strtoupper($inner['innerquantity'] ?? "0");
                                            $length           = mb_strtoupper($inner['innerlength'] ?? "0.00");
                                            $lengthUom        = mb_strtoupper($inner['innerlength_uom'] ?? "m");
                                            $width            = mb_strtoupper($inner['innerwidth'] ?? "0.00");
                                            $widthUom         = mb_strtoupper($inner['innerwidth_uom'] ?? "m");
                                            $height           = mb_strtoupper($inner['innerheight'] ?? "0.00");
                                            $heightUom        = mb_strtoupper($inner['innerheight_uom'] ?? "m");
                                            $weight           = mb_strtoupper($inner['innerweight'] ?? "0.00");
                                            $weightUom        = mb_strtoupper($inner['innerweight_uom'] ?? "kg");
                                            $volume           = mb_strtoupper($inner['innervolume'] ?? "0.00");
                                            $volumeUom        = mb_strtoupper($inner['innervolume_uom'] ?? "cbm");
                                            $stackable        = mb_strtoupper($inner['innerstackable'] ?? "");
                                            if ($stackable == 'on') {
                                                $stackable = 1;
                                            } else {
                                                $stackable = 0;
                                            }
                                            $length = $length ?: '0.00';
                                            $width  = $width ?: '0.00';
                                            $height = $height ?: '0.00';
                                            $weight = $weight ?: '0.00';
                                            $volume = $volume ?: '0.00';
                                            $this->common->insertTableData(
                                                "tb_inner_cargo",
                                                [
                                                    'cargo_id'          => $cargoRowId,
                                                    'cargo_type'        => $innercargoType,
                                                    'goods_description' => $goodsDescription,
                                                    'quantity'          => $quantity,
                                                    'length'            => $length,
                                                    'length_unit'       => $lengthUom,
                                                    'width'             => $width,
                                                    'width_unit'        => $widthUom,
                                                    'height'            => $height,
                                                    'height_unit'       => $heightUom,
                                                    'weight'            => $weight,
                                                    'weight_unit'       => $weightUom,
                                                    'volume'            => $volume,
                                                    'volume_unit'       => $volumeUom,
                                                    'stackable'         => $stackable,
                                                    'createdby'         => $userId,
                                                    'createdon'         => $currentDate,
                                                ]
                                            );
                                        }
                                    }
                                }
                            }
                            $cargo_forship = [];
                            $getcargos     = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id = ? AND status = ?", [$orderId, 1]);
                            foreach ($getcargos->result_array() as $res) {
                                $cargo_forship[] = $res['quantity_type'];
                            }
                            $unitspec = "1";
                            if (! empty($cargo_forship)) {
                                $unitspec = implode(',', $cargo_forship);
                            }
                            $this->common->updatetbledata("tb_shipments", ['unitspec' => $unitspec, 'txncode' => $bookingId], ['id' => $shipRowId]);
                            $total_weight = $total_volume = $total_quantity = 0;
                            $gettotal     = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id=? AND status = ?", [$orderId, 1]);
                            if ($gettotal->num_rows() > 0) {
                                $total_volume   = $gettotal->row()->total_volume;
                                $total_weight   = $gettotal->row()->total_weight;
                                $total_quantity = $gettotal->row()->total_quantity;
                            }
                            $this->common->updatetbledata("tb_orders", ['volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity], ['id' => $orderId]);
                            $involved_parties = $data['involved_parties'] ?? [];
                            foreach ($involved_parties as $inv) {
                                $partyId     = mb_strtoupper($inv['party_id'] ?? "0");
                                $partyName   = mb_strtoupper($inv['party_name'] ?? "");
                                $partyType   = mb_strtoupper($inv['party_type'] ?? "");
                                $city        = mb_strtoupper($inv['city'] ?? "");
                                $country     = mb_strtoupper($inv['country'] ?? "");
                                $address     = mb_strtoupper($inv['address'] ?? "");
                                $pincode     = mb_strtoupper($inv['pincode'] ?? "0");
                                $phone       = mb_strtoupper($inv['phone'] ?? "0");
                                $email       = mb_strtoupper($inv['email'] ?? "");
                                $street      = mb_strtoupper($inv['street'] ?? "");
                                $state       = mb_strtoupper($inv['state'] ?? "");
                                $fax         = mb_strtoupper($inv['fax'] ?? "");
                                $partyTypeId = $party_master_id = 0;
                                $checkType   = $this->db->query("SELECT id FROM tbl_party_types WHERE name = ? AND company_code = ? AND status = ?", [$partyType, $companyCode, 1]);
                                if ($checkType->num_rows() > 0) {
                                    $partyTypeId = $checkType->row()->id;
                                } else {
                                    $partyTypeId = $this->common->insertTableData("tbl_party_types", ['company_code' => $companyCode, 'branch_code' => $branchCode, 'name' => $partyType, 'user_id' => $userId, 'created_on' => $currentDate, 'status' => '1']);
                                }
                                $paddres        = $street . ',' . $city . ',' . $state;
                                $checkPartyType = $this->db->query("SELECT id FROM tbl_party_master WHERE code LIKE ? AND status =?", [$partyId, 1]);
                                if ($checkPartyType->num_rows() > 0) {
                                    $party_master_id = $checkPartyType->row()->id;
                                } else {
                                    $party_master_id = $this->common->insertTableData("tbl_party_master", ['customeridentifier' => $partyId, 'code' => $partyId, 'party_type_id' => $partyTypeId, 'name' => $partyName, 'street' => $street, 'pincode' => $pincode, 'location_id' => $city, 'country' => $country, 'state' => $state, 'mobile' => $phone, 'fax' => $fax, 'email' => $email, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'created_on' => $currentDate, 'address' => $paddres]);
                                }
                                if ($party_master_id > 0) {
                                    $this->common->insertTableData("tb_order_parties", ['order_id' => $orderId, 'party_id' => $party_master_id, 'status' => '1', 'createdon' => $currentDate, 'party_type' => $partyTypeId]);
                                }
                            }
                            $referenceArray[] = ['referenceId' => 'DQ', 'referenceValue' => $shipmentNumber];
                            $referenceArray[] = ['referenceId' => 'PO', 'referenceValue' => $purchaseOrder];
                            $referenceArray[] = ['referenceId' => 'ORD_PIKINST', 'referenceValue' => $driverPickupInstructions];
                            $referenceArray[] = ['referenceId' => 'ORD_DLVINST', 'referenceValue' => $driverDeliveryInstructions];
                            foreach ($referenceArray as $eachReferenceIds) {
                                if ($eachReferenceIds['referenceValue'] != "") {
                                    $this->common->insertTableData("tb_order_references", ['reference_id' => $eachReferenceIds['referenceId'], 'ref_value' => $eachReferenceIds['referenceValue'], 'order_id' => $orderId, 'createdon' => $currentDate]);
                                }
                            }
                            if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $companyCode)) {
                                $ins_ref     = ['order_id' => $orderId, 'reference_id' => 'STS'];
                                $checkSTSRef = $this->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                                if (count($checkSTSRef) == 0) {
                                    $ins_ref['ref_value'] = "Pending";
                                    $this->common->insertTableData("tb_order_references", $ins_ref);
                                }
                            }
                            $reference = $data['reference'] ?? [];
                            if (! empty($reference)) {
                                foreach ($reference as $ref) {
                                    $referenceId    = mb_strtoupper($ref['reference_id'] ?? "");
                                    $referenceName  = mb_strtoupper($ref['reference_name'] ?? "");
                                    $referenceValue = mb_strtoupper($ref['reference_value'] ?? "");
                                    $getReference   = $this->db->query("SELECT id FROM tb_reference_master WHERE name = ? AND status = ?", [$referenceId, 1]);
                                    if ($getReference->num_rows() > 0) {
                                        $this->common->insertTableData("tb_order_references", ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                                    } else {
                                        $this->common->insertTableData("tb_reference_master", ['name' => $referenceId, 'description' => $referenceName, 'status' => '1', 'createdon' => $currentDate]);
                                        $this->common->insertTableData("tb_order_references", ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => $currentDate]);
                                    }
                                }
                            }
                            $vascodes = $data['vascodes'] ?? [];
                            if (! empty($vascodes)) {
                                foreach ($vascodes as $vas) {
                                    $vasId    = mb_strtoupper($vas['vas_id'] ?? "");
                                    $vasValue = mb_strtoupper($vas['vas_value'] ?? "");
                                    if ($companyCode == 'RUKN') {
                                        $getVasDetails = $this->db->query("SELECT id FROM tb_vas_master WHERE vas_id = ? AND company_code = ? AND status = ?", [$vasId, $companyCode, '1']);
                                    } else {
                                        $getVasDetails = $this->db->query("SELECT id FROM tb_vas_master WHERE vas_id = ? AND company_code != ? AND status = ?", [$vasId, $companyCode, '1']);
                                    }
                                    if ($getVasDetails->num_rows() > 0) {
                                        $vasRowId      = $getVasDetails->row()->id;
                                        $checkOrderVas = $this->db->query("SELECT id,quantity FROM tb_order_vas WHERE order_id =? AND vas_id = ? AND status = ?", [$orderId, $orderId, 1]);
                                        if ($checkOrderVas->num_rows() == 0) {
                                            $this->common->insertTableData('tb_order_vas', ['order_id' => $orderId, 'vas_id' => $vasRowId, 'quantity' => $vasValue, 'user_id' => $userId, 'status' => '1', 'createdon' => $currentDate]);
                                        } else {
                                            $rowId          = $checkOrderVas->row()->id;
                                            $quantity       = $checkOrderVas->row()->quantity;
                                            $total_quantity = $quantity + $vasValue;
                                            $this->common->updatetbledata("tb_order_vas", ['quantity' => $total_quantity], ['id' => $rowId]);
                                        }
                                    }
                                }
                            }
                            $pickupInfo   = $dropInfo   = [];
                            $shipmentName = "BOXES";
                            if (! empty($orderId) && ! empty($customerRowId)) {
                                $customerInfo = $this->common->gettblrowdata(['id' => $customerRowId], "phone,email_id", 'tb_customers', 0, 0);
                                if ($customerInfo) {
                                    $customerEmail = $customerInfo['email_id'];
                                    $customerPhone = $customerInfo['phone'];
                                }
                                $totalWeight     = $totalVolume     = $totalQuantity     = 0;
                                $getCargoDetails = $this->common->gettblrowdata(['order_id' => $orderId], "SUM(weight) as total_weight,SUM(volume) as total_volume,SUM(quantity) as total_quantity", 'tb_order_cargodetails', 0, 0);
                                if ($getCargoDetails) {
                                    $totalVolume   = $getCargoDetails['total_volume'];
                                    $totalWeight   = $getCargoDetails['total_weight'];
                                    $totalQuantity = $getCargoDetails['total_quantity'];
                                }
                                $pickupInfo['country']       = trim($pikupCountry);
                                $pickupInfo['order_country'] = trim($pikupCountry);
                                $pickupInfo['order_city']    = trim($pikupCity);
                                $pickupInfo['order_zipcode'] = trim($pikupPincode);
                                $pickupInfo['state']         = trim($pikupState);
                                $pickupInfo['city']          = trim($pikupCity);
                                $pickupInfo['region']        = trim($pikupStreet);
                                $pickupInfo['zipcode']       = trim($pikupPincode);
                                $pickupInfo['stoptype']      = "P";
                                $dropInfo['country']         = trim($dropCountry);
                                $dropInfo['order_country']   = trim($dropCountry);
                                $dropInfo['order_city']      = trim($dropCity);
                                $dropInfo['order_zipcode']   = trim($dropPincode);
                                $dropInfo['state']           = trim($dropState);
                                $dropInfo['city']            = trim($dropCity);
                                $dropInfo['region']          = trim($dropStreet);
                                $dropInfo['zipcode']         = trim($dropPincode);
                                $dropInfo['stoptype']        = "D";
                                $pickupGeoCode               = checkgeocode($pickupInfo);
                                $dropGeoCode                 = checkgeocode($dropInfo);
                                if (! empty($pickupGeoCode) && ! empty($dropGeoCode)) {
                                    $pickupGeoCode['stoptype']      = "P";
                                    $dropGeoCode['stoptype']        = "D";
                                    $pickupGeoCode['order_country'] = trim($pikupCountry);
                                    $pickupGeoCode['order_city']    = trim($pikupCity);
                                    $pickupGeoCode['order_zipcode'] = trim($pikupPincode);
                                    $dropGeoCode['order_country']   = trim($dropCountry);
                                    $dropGeoCode['order_city']      = trim($dropCity);
                                    $dropGeoCode['order_zipcode']   = trim($dropPincode);
                                    $pickupGeoCode['cargo']         = $cargo;
                                    $dropGeoCode['cargo']           = $cargo;
                                    $pickupRoute                    = getcust_routeautomate($customerRowId, $pickupGeoCode);
                                    $dropRoute                      = getcust_routeautomate($customerRowId, $dropGeoCode);
                                    if (! empty($pickupRoute) && ! empty($dropRoute)) {
                                        $orderInfo['id']             = $orderId;
                                        $orderInfo['order_id']       = $bookingId;
                                        $orderInfo['shipment_name']  = $shipmentName;
                                        $orderInfo['customer_phone'] = $customerPhone;
                                        $orderInfo['customer_email'] = $customerEmail;
                                        $orderInfo['volume']         = $totalVolume;
                                        $orderInfo['weight']         = $totalWeight;
                                        $orderInfo['quantity']       = $totalQuantity;
                                        $orderInfo['quantity']       = $totalQuantity;
                                        $shipment                    = createshipmentbyorder($pickupRoute, $orderInfo);
                                    } else {
                                        $pickupInfo['cargo'] = $cargo;
                                        $dropInfo['cargo']   = $cargo;
                                        $pickupRoute1        = getcust_routeautomate($customerRowId, $pickupInfo);
                                        $dropRoute1          = getcust_routeautomate($customerRowId, $dropInfo);
                                        if (! empty($pickupRoute1) && ! empty($dropRoute1)) {
                                            $orderInfo['id']             = $orderId;
                                            $orderInfo['order_id']       = $bookingId;
                                            $orderInfo['shipment_name']  = $shipmentName;
                                            $orderInfo['customer_phone'] = $customerPhone;
                                            $orderInfo['customer_email'] = $customerEmail;
                                            $orderInfo['volume']         = $totalVolume;
                                            $orderInfo['weight']         = $totalWeight;
                                            $orderInfo['quantity']       = $totalQuantity;
                                            $orderInfo['quantity']       = $totalQuantity;
                                            $shipment                    = createshipmentbyorder($pickupRoute1, $orderInfo);
                                        }
                                    }
                                } else {
                                    $pickupInfo['cargo'] = $cargo;
                                    $dropInfo['cargo']   = $cargo;
                                    $pickupRoute1        = getcust_routeautomate($customerRowId, $pickupInfo);
                                    $dropRoute1          = getcust_routeautomate($customerRowId, $dropInfo);
                                    if (! empty($pickupRoute1) && ! empty($dropRoute1)) {
                                        $orderInfo['id']             = $orderId;
                                        $orderInfo['order_id']       = $bookingId;
                                        $orderInfo['shipment_name']  = $shipmentName;
                                        $orderInfo['customer_phone'] = $customerPhone;
                                        $orderInfo['customer_email'] = $customerEmail;
                                        $orderInfo['volume']         = $totalVolume;
                                        $orderInfo['weight']         = $totalWeight;
                                        $orderInfo['quantity']       = $totalQuantity;
                                        $orderInfo['quantity']       = $totalQuantity;
                                        $shipment                    = createshipmentbyorder($pickupRoute1, $orderInfo);
                                    }
                                }
                            }

                            $codOrderInfo = [
                                'pickup'          => strtoupper($pikupCountry),
                                'pickup_state'    => strtoupper($pikupState),
                                'pickup_city'     => strtoupper($pikupCity),
                                'pickup_pincode'  => $pikupPincode,
                                'drop'            => strtoupper($dropCountry),
                                'drop_state'      => strtoupper($dropState),
                                'drop_city'       => strtoupper($dropCity),
                                'drop_pincode'    => $dropPincode,
                                'customer_id'     => $customerId,
                                'service'         => $serviceId,
                                'product'         => $product,
                                'user_id'         => $userId,
                                'company_code'    => $companyCode,
                                'order_type'      => $typeName,
                                'order_id'        => $orderId,
                                'customer_row_id' => $customerRowId,
                            ];
                            $this->ratemanagement->addrecodfororderinsertion($codOrderInfo);
                        }
                        try {
                            $this->altovaordercreation->sendOrderToAltova($orderId);
                        } catch (Exception $ex) {
                            log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
                        }
                    }
                } else {
                    if (in_array($customerId . $shipmentNumber, $noBookingIds)) {
                    } else {
                        $noBookingIds[]    = $customerId . $shipmentNumber;
                        $excelFailOrders[] = ['booking_id' => '-', 'customer_id' => $customerId, 'delivery_note' => $shipmentNumber, 'status' => 'Fail'];
                    }
                }
                $excel_orders = array_merge($excelFailOrders, $excelSuccessOrders);
                if (! empty($excel_orders)) {
                    @file_put_contents("assets/ordertemplate/exceluploaddata.txt", json_encode($excel_orders));
                }
            }
            redirect('orders/orderslist/01');
        }
    }

    public function getPartyNameAndCode(string $code, string $companyCode, int $userId, string $partyType): array
    {
        $permission = checkuserpermissions();
        $sql        = "SELECT p.name, p.code FROM tbl_party_master p ";
        if ($partyType == "Customer") {
            $sql .= "INNER JOIN tb_customers c ON c.code = p.code ";
        } else {
            $sql .= "INNER JOIN tb_vendors c ON c.code = p.code ";
        }
        $sql .= "AND c.company_code = p.company_code ";
        $sql .= "AND c.status = ? ";
        $sql .= "WHERE ( p.code = ?  OR p.name LIKE ? ) ";
        if (in_array("businesspartners", $permission)) {
            $sql .= "AND p.company_code LIKE ? ";
        } else {
            $sql .= "AND p.user_id = ? ";
        }
        $sql .= "AND p.status = ? ORDER BY p.id DESC";
        if (in_array("businesspartners", $permission)) {
            $getDetails = $this->db->query($sql, [1, $code, $code, $companyCode, 1]);
        } else {
            $getDetails = $this->db->query($sql, [1, $code, $code, $userId, 1]);
        }
        if ($getDetails->num_rows() > 0) {
            $data['name']       = $getDetails->row()->name;
            $data['party_code'] = $getDetails->row()->code;
        }
        return $data ?? [];
    }
}
