<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class FinancialReport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('aquaticamodel');
        $this->load->model('common');
        $this->load->model('FinancialReportModel');
        if (!checkUrlAccessForUser('FINANCIALREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    /* Revene List page */
    public function index()
    {
        $data = $finacial_data = $order_data = $finacialdata = $no_recordsdata = $recordsdata = array();
        $userid = $this->session->userdata("user_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $business_type = $this->session->userdata('business_type');
        $data["cus_list"] = $whr = $data["book_list"] = array();
        $lr_num = $cust_reference_num =  "NA";
        $staus_fin = "";
        /* get Customer List in Search box */
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if($company_code != "RUKN"){
        $cus_list_r = $this->db->query('SELECT name,code FROM tb_customers WHERE status=1 AND company_code="'.$company_code.'" AND branch_code="'.$branch_code.'" AND code !="" ORDER BY  name ASC');
       }else{
        $cus_list_r = $this->db->query('SELECT name,code FROM tb_customers WHERE status=1 AND company_code="'.$company_code.'"  AND code !="" ORDER BY  name ASC');
       }
        //
        if ($cus_list_r->num_rows() > 0) {
            $data["cus_list"] = $cus_list_r->result_array();
        }
        /* advanced search order id */
        $order_id_list = $this->db->query("SELECT r.order_id as idr ,o.order_id  FROM `tb_reveneus` r LEFT JOIN tb_orders o ON o.id=r.order_id and o.company_code='".$company_code."' and o.status!=0 GROUP BY  r.order_id");
        if ($order_id_list->num_rows() > 0) {
            $data["book_list"] = $order_id_list->result_array();
        }
        $data["page_title"] = $this->lang->line('financial_report');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["company_code"] = $company_code;

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }
        if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $post = $_POST;
        }
        if (! empty($post)) {
            $r_type = 0;
           /* 111 means no revenue or cost */
           /*If ALL get all records like no billing and billing records*/
           if (isset($post['revene_type']) && $post['revene_type'] != "") {
                $r_type = $post['revene_type'];
                if($r_type == '111' || $r_type == 'ALL'){
                    $no_recordsdata = $this->getorderswithnobill($post);
                }
            }
            if($r_type != "111"){
                $whr = $this->searchorders($post);
                $company_code = $this->session->userdata('company_code');
                $whr_ids=$ids=$whr_id=array();
                if($company_code == "RUKN"){
                    $whr_id = $this->common->gettbldata(array('company_code'=>$company_code), 'id','tb_users', 0, 0);
                    foreach($whr_id as $ids){
                        $whr_ids[]=$ids['id'];
                    }
                }else{
                    $whr['r.user_id']=$userid;
                }
                
                $recordsdata = $this->FinancialReportModel->getsearchdata($whr,$whr_ids);
                if($r_type == "ALL"){
                    $finacialdata = array_merge($no_recordsdata,$recordsdata);
                }else{
                    $finacialdata = $recordsdata;
                }
           }else{
            $finacialdata = $no_recordsdata;
           }
        }
        /* get Revene data Revene Table */

        if (! empty($finacialdata)) {
            foreach ($finacialdata as $res) {
                /* order data get */
                $whr_or = array(
                    'o.id' => $res['order_id']
                );
                $order_data = $this->FinancialReportModel->getorderdata($whr_or);
                /* get reference value */
                // customer
                if ($business_type == 'Customer') {
                    $lr_ref_no = $this->FinancialReportModel->getreferenceorderdetails($res['order_id'], 'BN');
                } else {
                    // admin
                    $lr_ref_no = $this->FinancialReportModel->getreferenceorderdetails($res['order_id'], 'PO');
                }
                if ($lr_ref_no->num_rows() > 0) {
                    $lr_num = $lr_ref_no->row()->ref_value;
                }
                $cust_ref_no = $this->FinancialReportModel->getreferenceorderdetails($res['order_id'], 'DQ');
                if ($cust_ref_no->num_rows() > 0) {
                    $cust_reference_num = $cust_ref_no->row()->ref_value;
                }
                if (isset($res['invoice_status']) && $res['invoice_status'] != "") {
                    if ($res['invoice_status'] == 0) {
                        $staus_fin = "To Be Billed";
                    } else if ($res['invoice_status'] == 1) {
                        $staus_fin = "Ready To Billed";
                    } else if ($res['invoice_status'] == 2) {
                        $staus_fin = "Billed";
                    } else {
                        $staus_fin = "";
                    }
                }

                /* get Good description */
               /* $qry = $this->db->query("SELECT o.cargo_content FROM tb_order_cargodetails o WHERE o.order_id ='" . $order_data['order_id'] . "' AND o.status='1'");*/
               $qry = $this->db->query("SELECT c.goods_description as cargo_content FROM tb_cargo_details c,tb_order_cargodetails o where o.order_id='".$res['order_id']."' AND o.cargo_id=c.id AND o.status='1' AND c.status='1'");
                $cargo_content = '';
                $title = "";
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $row) {
                        if ($row->cargo_content != '') {
                            $out = strlen($row->cargo_content) > 32 ? substr($row->cargo_content, 0, 31) . "..." : $row->cargo_content;
                            $cargo_content .= $out . ',';
                            $title .= $row->cargo_content . ',';
                        } else {
                            $cargo_content = '';
                        }
                    }
                }
                $cargo_content = rtrim($cargo_content, ',');
                $title = rtrim($title, ',');
                $cargo_content_arr = [];
                $cargo_content_arr = explode(',', $cargo_content);
                $array_tmp = $array_new = [];
                foreach ($cargo_content_arr as $k => $v) {
                    $index = $v;
                    $array_tmp[$index][] = $v;
                }
                foreach ($array_tmp as $k => $v) {
                    if (count($v) > 1) {
                        foreach ($v as $k2 => $v2) {
                            $array_new[] = $v2;
                        }
                    }
                }
                if (count($array_new)) {
                    $get_cargo_content = $array_new[0];
                    if (in_array($get_cargo_content, $cargo_content_arr)) {
                        $key_value = array_search($get_cargo_content, $cargo_content_arr);
                        unset($cargo_content_arr[$key_value]);
                    }
                }
                $final_cargo_content_str = implode(',', $cargo_content_arr);
                /* get carrier name */
                $carrier_name = '';
                $truckinfo = $this->db->query("SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id ='" . $order_data['order_id'] . "' AND e.vendor_id=v.id and v.id='" . $order_data['vendor_id'] . "'");
                if ($truckinfo->num_rows() > 0) {
                    $carrier_name = $truckinfo->row()->name;
                }
                $pickup_date      = $order_data['pickup_datetime'];
                $estimate_de_date = $order_data['delivery_datetime'];
                /* Get pickup Date and Estimated Delivered Date */
                $getpickupdateils = $this->FinancialReportModel->getpickupshipdateils($order_data['order_id'], $status_id = 10);
                if ($getpickupdateils->num_rows() > 0) {
                    $date = '0000-00-00 00:00:00';
                    $createdon = $getpickupdateils->row()->createdon;
                    /*$estimate_d_date = $getpickupdateils->row()->estimate_d_date;*/
                    if (($createdon != $date) || (strtotime($createdon) > 0)) {
                        $pickup_date = date("d M Y", strtotime($createdon));
                    } else {
                        $pickup_date = "";
                    }

                } else {
                  //  $pickup_date = $estimate_de_date = '';
                }

                /* Get Delivered STATUS */
                $deliverycons_info = $this->FinancialReportModel->getdeliveryconsigdetails($order_data['order_id'], $status_id = 3, 'D');
                if ($deliverycons_info->num_rows() > 0) {
                    $delivery_status = 'Delivered';
                } else {
                    $delivery_status = 'Not Delivered';
                }
                /* Get delivery date */
                $order_status = 'PENDING';
                $trip_id = $order_data['trip_id'];
               /* $deli_date = $this->common->gettblrowdata(array(
                    'id' => $trip_id
                ), 'etime', 'tb_trips', 0, 0);*/
                $deli_date = $this->common->gettblrowdata(array('order_id'=>$res['order_id'],'status_code'=>'3000','status'=>'1'),"convertToClientTZ(createdon,'".$curtz."') as createdon","tb_stop_status",0,0);
                if (count($deli_date) > 0) {
                    $d_date = $deli_date['createdon'];
                    if (isset($d_date) && $d_date != "") {
                        $date = '0000-00-00 00:00:00';
                        if (($d_date != $date) || (strtotime($d_date) > 0)) {
                            $delivery_date = date("d M Y", strtotime($d_date));
                        } else {
                            $delivery_date = "";
                        }
                    } else {
                        $delivery_date = "";
                    }
                } else {
                    $delivery_date = "";
                }
                /* get last status */
                $get_laststatusinfo = $this->FinancialReportModel->getlaststoptransdetails($order_data['order_id']);
                $last_status_name = $last_loc = "";
                if ($get_laststatusinfo->num_rows() > 0) {
                    $last_status_name = $get_laststatusinfo->row()->status_name;
                    if ($get_laststatusinfo->row()->id == 1) {
                        if ($get_laststatusinfo->row()->stop_type == "P") {
                            $last_status_name = "Pickedup";
                        } else {
                            $last_status_name = "Delivered";
                        }
                    }
                    if ($get_laststatusinfo->row()->loc_name != null) {
                        $last_loc = $get_laststatusinfo->row()->loc_name;
                    } else {
                        $lat = $get_laststatusinfo->row()->latitude;
                        $lng = $get_laststatusinfo->row()->longitude;
                        $last_loc = getLocationName($lat, $lng);
                    }
                }
                $finacial_data[] = array(
                    'id' => $res['id'],
                    'type'=>$res['type'],
                    'recipient_code' => $res['recipient_code'],
                    'recipient_name' => $res['recipient_name'],
                    'customer_cid' =>$order_data['customer_cid'],
                    'customer_name' =>$order_data['customer_name'],
                    'debtor_jfr' => $res['debtor_jfr'],
                    'bu_jfr' => $res['bu_jfr'],
                    'invoice_number' => $res['invoice_number'],
                    'cust_reference_num' => $cust_reference_num,
                    'lr_num' => $lr_num,
                    'finacial_status' => $staus_fin,
                    'goods_value' => $order_data['goods_value'],
                    'transport_mode' => $order_data['transport_mode'],
                    'shipper_address' => $order_data['pickup'],
                    'shipper_city' => $order_data['pickup_city'],
                    'consignee_address' => $order_data['delivery'],
                    'consignee_city' => $order_data['delivery_city'],
                    'goods_desc' => $final_cargo_content_str,
                    'title' => $title,
                    'pieces' => $order_data['totqty'],
                    'weight' => $order_data['totwg'],
                    'volumetric_weight' => $order_data['volumetric_weight'],
                    'carriername' => $carrier_name,
                    'pickup_date' => $pickup_date,
                    'estimate_d_date' => $estimate_de_date,
                    'delivery_status' => $delivery_status,
                    'delivery_date' => $delivery_date,
                    'last_status_name' => $last_status_name,
                    'last_loc' => $last_loc,
                    'order_row_id' => $res['order_id'],
                    'order_id' => $order_data['order_id'],
                    'amount'=>$res['amount'],
                );
                if (! empty($order_data)) {
                    $data['chek'] = $order_data;
                }
            }
        }
        $data["finacialdata"] = $finacial_data;
        $this->newtemplate->dashboard("financialreport/index", $data);
    }

    public function getorderswithnobill($post){
        $orders = $data = array();
        $whr = "";
        $user_id = $this->session->userdata('user_id');
        if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
            $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
            $whr .= " AND DATE_FORMAT(o.createdon,'%Y-%m-%d') >= ".$aqufromdate;
            // createdon
        }
        if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
            $todate = date('Y-m-d', strtotime($post['aqutodate']));
            $whr .= " AND DATE_FORMAT(o.createdon,'%Y-%m-%d') <= ".$todate;
        }
        if (isset($post['cus_id_r']) && $post['cus_id_r'] != "") {
            $whr .= " AND c.code LIKE '".$post['cus_id_r']."'";
        }
        if (isset($post['bookiing_id']) && $post['bookiing_id'] != "") {
            $whr .= " AND o.order_id LIKE '".$post['bookiing_id'];
        }
        $orders = $this->FinancialReportModel->getorderswithnobill($user_id,$whr);

        /* invoice status ='111' means no revenue or cost */
        if(!empty($orders)){
            foreach ($orders as $res) {
                $data[] =  array('order_id'=>$res['order_id'],'recipient_code'=>$res['recipient_code'],'recipient_name'=>$res['recipient_name'],'invoice_status'=>'111','debtor_jfr'=>'-','id'=>'-','bu_jfr'=>'','customer_name'=>'','customer_cid'=>'','type'=>'','amount'=>'');
            }
        }
        return $data;
    }

    public function searchorders($post)
    {
        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata('company_code');

         $whr = array(
            'r.status' => 1,
            /*'type'=>0*/
        );
        $whr['r.order_id >']=0;
        if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
            $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
            $whr["DATE_FORMAT(r.updatedon,'%Y-%m-%d') >="] = $aqufromdate;
            // createdon
        }
        if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
            $todate = date('Y-m-d', strtotime($post['aqutodate']));
            $whr["DATE_FORMAT(r.updatedon,'%Y-%m-%d') <="] = $todate;
        }
        if (isset($post['revene_type']) && $post['revene_type'] != "" && $post['revene_type'] != "ALL") {
            $r_type = $post['revene_type'];
            if ($r_type == 10) {
                $r_type = 0;
            }
            if($r_type == '111'){

            }else{
                $whr['r.invoice_status'] = $r_type;
            }
        }
        if (isset($post['cus_id_r']) && $post['cus_id_r'] != "") {

            $whr['r.recipient_code'] = $post['cus_id_r'];
        }
        if (isset($post['bookiing_id']) && $post['bookiing_id'] != "") {

            $whr['r.order_id'] = $post['bookiing_id'];
        }

        return $whr;
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $whr = "";
        if ($ordid > 0) {
            $whr = " AND ts.order_id=$ordid ";
        }
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(array(
            "id" => $ordid
        ), "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (count($tripinfo) > 0) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type");
            $shift_id = $tripinfo['shift_id'];
            $data['ship_id'] = isset($tripinfo['shift_id']) ? $tripinfo['shift_id'] : 0;
            $data['trip_id'] = isset($tripinfo['trip_id']) ? $tripinfo['trip_id'] : 0;
            $sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.shipment_id = $shift_id $whr AND dt.type_name='POD' GROUP BY ts.id");
            if ($sql1->num_rows() > 0) {
                $i = 1;
                foreach ($sql1->result_array() as $eachRow) {
                    $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];
            echo $this->load->view("financialreport/managedocuments", $data, TRUE);
        }
    }


    /**
     * @throws JsonException
     */
    public function ajaxListing()
    {
        if ($this->session->userdata('user_id') == '') {
            echo 'SessionTimeout';
            return false;
        }
        $draw = $this->input->post('draw', true);
        $postData = $this->input->post('data', true);
        $orderTableCondition = $this->getOrderWhereCondition($postData);
        $getRevenueData = $this->getRevenueReportData($orderTableCondition, $postData);
        if (empty($getRevenueData['data'])) {
            $finalData = '[]';
            echo '{"draw":' . $draw . ',"recordsTotal":' . 0 . ',"recordsFiltered":' . 0 . ',"data":' . $finalData . '}';
            return false;
        }
        $getFinalData = $this->getRevenueDataTableRecords($getRevenueData['data']);
        echo '{"draw":' . $draw . ',"recordsTotal":' . $getRevenueData['ordersCount'] . ',"recordsFiltered":' . $getRevenueData['ordersCount'] . ',"data":' . $getFinalData . '}';
    }

    /**
     * @throws JsonException
     */
    private function getRevenueDataTableRecords(array $RevenueData)
    {
        $i = 0;
        $recordListing = [];
        foreach ($RevenueData as $res) {
            $type = "";
            if (isset($res['type'])) {
                $type = ($res['type'] === "0") ? "Rev." : (($res['type'] === "1") ? "Cost." : "");
            }
            $revenueType = (!empty($res['revenue_id'])) ? $res['revenue_id'] . " ( " . $type . " ) " : '';
            $checkBox = '<div class="checkbox checkbox-info">
                                 <label>
                                    <input type="checkbox" class="chckbox" name="check_box" id="' . $res['id'] . '" data-row-id="' . $res['id'] . '">
                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                 </label>
                              </div>';
            $orderRowId = $res["id"];
            $orderBookingNum = $res["order_id"];
            $label = $this->lang->line('manage_doc');
            $manageDocuments = "<a href='#' onclick='return orddocsdetails($orderRowId ,$orderBookingNum);'
                                                  class='buttonCardIcon' data-action='open'
                                                  data-popup='open-data' data-side='right'
                                                  data-toggle='tooltip'
                                                  title='$label'><span
                                                      class='icon tru-icon-tender-list'></span></span></a>";
            $j = 0;
            $recordListing[$i][0] = $checkBox;
            $recordListing[$i][++$j] = $i + 1;
            $recordListing[$i][++$j] = $res['order_id'] ?? '';
            $recordListing[$i][++$j] = $res['deliveryNote'] ?? '';
            $recordListing[$i][++$j] = $res['customer_cid'] ?? '';
            $recordListing[$i][++$j] = $res['customer_name'] ?? '';
            $recordListing[$i][++$j] = $revenueType;
            $recordListing[$i][++$j] = $res['amount'] ?? '';
            if($res['company_code'] !== "RUKN") {
                $recordListing[$i][++$j] = $res['recipient_code'] ?? '';
                $recordListing[$i][++$j] = $res['recipient_name'] ?? '';
                $recordListing[$i][++$j] = ($res['bu_jfr'] !== "0") ? $res['bu_jfr'] : "";
            }
            $recordListing[$i][++$j] = $res['debtor_jfr'] ?? '';
            $recordListing[$i][++$j] = (!empty($res['invoice_number'])) ? $res['invoice_number'] : "";
            $recordListing[$i][++$j] = $this->getRevenueStatus($res['invoice_status'] ?? '');
            $recordListing[$i][++$j] = $res['lrNumber'] ?? '';
            $recordListing[$i][++$j] = $res['goods_value'] ?? '';
            $recordListing[$i][++$j] = $res['transport_mode'] ?? '';
            $recordListing[$i][++$j] = $res['shipperName'] ?? '';
            $recordListing[$i][++$j] = $res['pickup_city'] ?? '';
            $recordListing[$i][++$j] = $res['ConsigneeName'] ?? '';
            $recordListing[$i][++$j] = $res['delivery_city'] ?? '';
            $recordListing[$i][++$j] = $res['goodsDescription'] ?? '';
            $recordListing[$i][++$j] = $res['totalQuantity'] ?? '';
            $recordListing[$i][++$j] = $res['totalWeight'] ?? '';
            $recordListing[$i][++$j] = $res['volumetricWeight'] ?? '';
            $recordListing[$i][++$j] = $res['vendor_name'] ?? '';
            $recordListing[$i][++$j] = $res['pickup_date'] ?? '';
            $recordListing[$i][++$j] = $res['deliveryDate'] ?? '';
            if($res['company_code'] !== "RUKN") {
                $recordListing[$i][++$j] = $res['estimate_delivery_date'] ?? '';
                $recordListing[$i][++$j] = empty($res['deliveryDate']) ? "Not Delivered" : "Delivered";
                $recordListing[$i][++$j] = empty($res['deliveryDate']) ? "Pickedup" : "Delivered";;
                $recordListing[$i][++$j] = $this->getLastLocation((string)$res['id']);
                $recordListing[$i][++$j] = $manageDocuments;
            }
            $i++;
        }
        return json_encode($recordListing, JSON_THROW_ON_ERROR);
    }

    private function getRevenueStatus(string $invoiceStatus): string
    {
        if ($invoiceStatus === '0') {
            return "To Be Billed";
        }
        if ($invoiceStatus === '1') {
            return "Ready To Billed";
        }
        if ($invoiceStatus === '2') {
            return "Billed";
        }
        return "";
    }

    private function getLastLocation(string $orderId)
    {
        $getLastStatusInfo = $this->FinancialReportModel->getlaststoptransdetails($orderId);
        $getRow = $getLastStatusInfo->row();
        if (empty($getRow)) {
            return "";
        }
        if ($getRow->loc_name !== null) {
            return $getRow->loc_name;
        }
        if (!empty($getRow->latitude) && !empty($getRow->longitude)) {
            return getLocationName($getRow->latitude, $getRow->longitude);
        }
        return "";
    }

    public function getRevenueReportData(array $orderTableCondition, array $postData): array
    {
        $this->load->model('Datatables_model');
        $businessType = $this->session->userdata('business_type');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $orderTableWhere = implode(' AND ', $orderTableCondition);
        $indexColumn = 'o.id';
        $excludeCountQuery = 'Yes';
        $whereCondition = $indexColumn . "!='' and " . $orderTableWhere;
        /* 111 means no revenue or cost */
        $postData['revenueType'] = $postData['revenueType'] ?? '';
        if ('111' === $postData['revenueType']) {
            $groupBy = 'o.id';
            $table_name = 'tb_orders as o';
            $joinsArray[] = ['table_name' => 'tb_reveneus as r', 'condition' => "r.order_id=o.id and r.status='1'", 'join_type' => 'left'];
            $whereCondition .= " and r.order_id IS NULL";
        } else {
            $groupBy = 'r.id';
            $table_name = 'tb_reveneus as r';
            $joinsArray[] = ['table_name' => 'tb_orders as o', 'condition' => "r.order_id=o.id", 'join_type' => 'inner'];
        }
        $joinsArray[] = ['table_name' => 'tb_vendors as v', 'condition' => "o.vendor_id=v.id and v.status='1'", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_customers as c', 'condition' => "c.id=o.customer_id and c.status='1'", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_order_cargodetails as oc', 'condition' => "oc.order_id=o.id and oc.status='1'", 'join_type' => 'left'];
        $joinsArray[] = ['table_name' => 'tb_cargo_details as cd', 'condition' => "oc.cargo_id=cd.id", 'join_type' => 'left'];
        $joinsArray[] = [
            'table_name' => 'tb_order_references as ref_dq',
            'condition' => "ref_dq.order_id=o.id and ref_dq.reference_id='DQ' and ref_dq.status='1'",
            'join_type' => 'left'
        ];
        if ($businessType === "Customer") {
            $joinsArray[] = [
                'table_name' => 'tb_order_references as ref_lr',
                'condition' => "ref_lr.order_id=o.id and ref_lr.reference_id='BN' and ref_lr.status='1'",
                'join_type' => 'left'
            ];
        } else {
            $joinsArray[] = [
                'table_name' => 'tb_order_references as ref_lr',
                'condition' => "ref_lr.order_id=o.id and ref_lr.reference_id='PO' and ref_lr.status='1'",
                'join_type' => 'left'
            ];
        }
        $joinsArray[] = [
            'table_name' => 'tb_stop_status as s',
            'condition' => "s.order_id=o.id and status_code ='3000' and s.status='1' ",
            'join_type' => 'left'
        ];
        $selectColumns = [
            "o.id,r.id as revenue_id,r.type,r.recipient_code,r.recipient_name,r.invoice_status,c.code as customer_cid,
        c.name as customer_name,r.debtor_jfr,r.bu_jfr,r.invoice_number,o.goods_value,
        o.transport_mode,o.pickup_company as shipperName,o.pickup_city,o.delivery_company as ConsigneeName,o.delivery_city,
       v.name as vendor_name,convertToClientTZ(o.pickup_datetime,'" . $curtz . "') as pickup_date,
       convertToClientTZ(o.delivery_datetime,'" . $curtz . "') as estimate_delivery_date,r.amount,o.order_id,
       Sum(Case When oc.status = '1' Then oc.weight Else 0 End) as totalWeight,
       SUM(Case When oc.status = '1' Then oc.quantity Else 0 End) as totalQuantity,
       SUM(Case When oc.status = '1' Then oc.volumetric_weight Else 0 End) as volumetricWeight,
       ref_dq.ref_value as deliveryNote, ref_lr.ref_value as lrNumber,
       convertToClientTZ(s.createdon,'" . $curtz . "') as deliveryDate,
       GROUP_CONCAT(DISTINCT cd.goods_description) goodsDescription,o.company_code"
        ];
        $dataTableSortOrdering = [];
        $getRecordListing = $this->Datatables_model->datatablesQuery(
            $selectColumns,
            $dataTableSortOrdering,
            $table_name,
            $joinsArray,
            $whereCondition,
            $indexColumn,
            'TRUE',
            $groupBy,
            $excludeCountQuery,
            'POST'
        );
        $getOrderCount = $this->FinancialReportModel->getOrderCount($whereCondition, $postData);
        $orderCount = (!empty($getOrderCount)) ? (int)$getOrderCount['count'] : 0;
        return ['data' => $getRecordListing['data'], 'getRecordListing' => $getRecordListing, 'ordersCount' => $orderCount];
    }

    private function getOrderWhereCondition(array $postData): array
    {
        $whereCondition = [];
        $whereCondition[] = "o.status !=0";
        $userIds = $this->getUserIds();
        if (!empty($userIds)) {
            $whereCondition[] = $userIds;
        }
        $alias = ($postData['revenueType'] === "111") ? "o" : "r";
        if (!empty($postData['fromDate'])) {
            $fromDate = date('Y-m-d', strtotime($postData['fromDate']));
            $whereCondition[] = "DATE_FORMAT($alias.createdon,'%Y-%m-%d') >=" . '"' . $fromDate . '"';
        }
        if (!empty($postData['toDate'])) {
            $toDate = date('Y-m-d', strtotime($postData['toDate']));
            $whereCondition[] = "DATE_FORMAT($alias.createdon,'%Y-%m-%d') <=" . '"' . $toDate . '"';
        }
        if ((!empty($postData['revenueType'])) && (!in_array($postData['revenueType'], ['ALL', '111'], true))) {
            $whereCondition[] = ((int)$postData['revenueType'] === 10) ? "r.invoice_status = 0" : "r.invoice_status = " . $postData["revenueType"];
        }
        if (!empty($postData['customerId'])) {
            $whereCondition[] = ($postData['revenueType'] === "111") ? "c.code = " . '"' . $postData['customerId'] . '"' : "r.recipient_code = " . '"' . $postData['customerId'] . '"';
        }
        if (!empty($postData['bookingId'])) {
            $whereCondition[] = "o.id = " . $postData['bookingId'];
        }
        return $whereCondition;
    }

    private function getUserIds(): string
    {
        $company_code = $this->session->userdata('company_code');
        $userId = $this->session->userdata("user_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        if ($userId === '0') {
            return "";
        }
        if (!empty($countryUserIds)) {
            $uIds = implode(',', $countryUserIds);
            if ($uIds !== '') {
                $uIds = $this->db->escape_str($uIds);
                return " o.user_id in ($uIds)";
            }
        }
        $company_code = $this->db->escape_str($company_code);
        if ($company_code === "RUKN") {
            $getUserIds = $this->common->gettbldata(['company_code' => $company_code], 'id', 'tb_users', 0, 0);
            $userIds = array_column($getUserIds, 'id');
            $userIds = implode(',', $userIds);
            if (!empty($userIds)) {
                return " o.user_id in ($userIds)";
            }
        }
        $userId = $this->db->escape_str($userId);
        return "o.user_id = $userId";
    }
}
