<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Forgotpassword extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->model('common');
    }

    public function index()
    {
        if ($this->session->userdata('user_id')) {
            redirect('home');
        }
        $data['page_title'] = 'Forgot Password';
        $this->settemplate->auth('forgot_password', $data);
    }
    
    public function EmailValidation()
    {
        $email = $this->input->get('email') ?? "";
        $parts = explode('-', $email);
        if (count($parts) !== 2) {
            echo json_encode(['status' => false, 'message' => 'Invalid Username format : For Ex CA/CU/AD-Username']);
            return;
        }
        $role = strtoupper($parts[0]);
        $user_code = $parts[1];
        $roleMap = [
            'AD' => ['table' => 'tb_users'],
            'CU' => ['table' => 'tb_customers'],
            'CA' => ['table' => 'tb_vendors'],
        ];
        if (!isset($roleMap[$role])) {
            echo json_encode(['status' => false, 'message' => 'Invalid role']);
            return;
        }
        $table = $roleMap[$role]['table'];
        if (filter_var($user_code, filter: FILTER_VALIDATE_EMAIL)) {
            if ($role === 'CU') {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->where('email_id', $user_code)
                    ->where('status', 1)
                    ->get();
            } elseif ($role === 'CA') {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->where('email', $user_code)
                    ->where('status', 1)
                    ->get();
            } else {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->where('emailid', $user_code)
                    ->where('status', 'Active')
                    ->get();
            }
        } elseif ($user_code) {
            if ($role === 'CU') {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->group_start()
                    ->or_where('phone', $user_code)
                    ->or_where('code', $user_code)
                    ->group_end()
                    ->where('status', 1)
                    ->get();
            } elseif ($role === 'CA') {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->group_start()
                    ->or_where('mobile', $user_code)
                    ->or_where('code', $user_code)
                    ->group_end()
                    ->where('status', 1)
                    ->get();
            } else {
                $sql = $this->db->select('*')
                    ->from($table)
                    ->or_where('mobile_no', $user_code)
                    ->where('status', 'Active')
                    ->get();
            }
        }
        if ($sql->num_rows() > 0) {
            echo json_encode(['status' => true]);
        } else {
            echo json_encode(['status' => false, 'message' => 'No Such User Found']);
        }
    }

    public function checkemail()
    {
        $data = array();
        $post = $this->input->post(null, true);
        $data['username'] = $this->db->escape_str($post['adminlogin_email']);
        // log_message('error', 'message:' . $post['adminlogin_email']);
        $curdt = date("Y-m-d H:i:s");
        $email = $data['username'];
        $parts = explode('-', $email);
        $role = $parts[0];
        $user_code = $parts[1];
        $roleMap = [
            'CU' => ['roles_type' => 2, 'table' => 'tb_customers', 'key' => 'code', 'column' => 'email_id'],
            'CA' => ['roles_type' => 3, 'table' => 'tb_vendors', 'key' => 'code', 'column' => 'email'],
            'AD' => ['roles_type' => 1, 'table' => 'tb_users', 'key' => 'mobile_no', 'column' => 'emailid'],
            'AD' => ['roles_type' => 4, 'table' => 'tb_users', 'key' => 'mobile_no', 'column' => 'emailid']
        ];

        if (isset($roleMap[$role])) {
            $config = $roleMap[$role];
            $post['roles_type'] = $config['roles_type'];
            $data['email_id'] = $user_code;
        } else {
            return;
        }

        $result = array();
        $base_url = base_url();
        /** step 1**/
        /** check email_id is email or not **/
        if (filter_var($data['email_id'], filter: FILTER_VALIDATE_EMAIL)) {
            //log_message('error', 'logine1');
            if (isset($post['roles_type'])) {
                if ($post['roles_type'] == "3") {
                    /**step 2 check how much count with the email **/
                    $carrier_info = $this->check_user_info(['email' => $data['email_id'], 'status' => 1], 'tb_vendors');
                    if (count($carrier_info) > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use phone number instead of email'];
                    } elseif (count($carrier_info) == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $carrier_info[0]['email'];
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($carrier_info[0]['mobile']);
                        $id = base64_encode($carrier_info[0]['id']);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;

                        $send_email = ['emailid' => $user_email, 'username' => $carrier_info[0]['name'], 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];

                        $reset_data = array('username' => $carrier_info[0]['mobile'], 'user_type' => 3, 'user_id' => $carrier_info[0]['id'], 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $mdata = array();
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "2") {
                    /**step 2 check how much count with the email **/
                    $cust = $this->check_user_info(['email_id' => $this->db->escape($data['email_id']), 'status' => 1], 'tb_customers');
                    if (count($cust) > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use phone number instead of email'];
                    } elseif (count($cust) == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $cust[0]['email_id'];
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($cust[0]['phone']);
                        $id = base64_encode($cust[0]['id']);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;
                        $send_email = ['emailid' => $cust[0]['email_id'], 'username' => $cust[0]['name'], 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];
                        $reset_data = array('username' => $cust[0]['phone'], 'user_type' => 2, 'user_id' => $cust[0]['id'], 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "1") {
                    /**step 2 check how much count with the email **/

                    $user = $this->check_user_info(['emailid' => $data['email_id'], 'status' => 'Active'], 'tb_users');
                    if (count($user) > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use phone number instead of email'];
                    } elseif (count($user) == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $user[0]['emailid'];
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($user[0]['mobile_no']);
                        $id = base64_encode($user[0]['id']);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;

                        $send_email = ['emailid' => $user[0]['emailid'], 'username' => $user[0]['name'], 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];

                        $reset_data = array('username' => $user[0]['mobile_no'], 'user_type' => 1, 'user_id' => $user[0]['id'], 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "4") {
                    /**step 2 check how much count with the email **/

                    $sub_user = $this->check_user_info(['emailid' => $data['email_id'], 'status' => 1], 'tb_user_logins');
                    if (count($sub_user) > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use phone number instead of email'];
                    } elseif (count($sub_user) == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $sub_user[0]['emailid'];
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($sub_user[0]['mobile_no']);
                        $id = base64_encode($sub_user[0]['id']);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;

                        $send_email = ['emailid' => $sub_user[0]['emailid'], 'username' => $sub_user[0]['name'], 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];

                        $reset_data = array('username' => $sub_user[0]['mobile_no'], 'user_type' => 4, 'user_id' => $sub_user[0]['id'], 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                }
            } else {
                $result = ['status' => 'fail', 'message' => 'Select your role'];
            }
        } elseif ($data['email_id']) {
            if (isset($post['roles_type'])) {
                if ($post['roles_type'] == "3") {
                    /**step 2 check how much count with the mobile **/
                    $carrier_info = $this->db->query("SELECT * FROM tb_vendors WHERE (mobile='" . $data['email_id'] . "' OR code='" . $data['email_id'] . "' OR name ='" . $data['email_id']."') AND status=1 limit 1");
                    if ($carrier_info->num_rows() > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use email instead of phone number'];
                    } elseif ($carrier_info->num_rows() == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $carrier_info->row()->email;
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($carrier_info->row()->mobile);
                        $id = base64_encode($carrier_info->row()->id);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;
                        $send_email = ['emailid' => $user_email, 'username' => $carrier_info->row()->name, 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];
                        $reset_data = array('username' => $carrier_info->row()->mobile, 'user_type' => 3, 'user_id' => $carrier_info->row()->id, 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "2") {
                    /**step 2 check how much count with the email **/
                    $whr = " (phone='" . $data['email_id'] . "' OR code='" . $data['email_id'] . "' OR name='" . $data['email_id']."') AND status=1 ";
                    $cust = $this->common->gettbldata($whr, "*", "tb_customers", 0, 0);
                    if (count($cust) > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use email instead of phone number'];
                    } elseif (count($cust) == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $cust[0]['email_id'];
                        //log_message('error', 'user_email' . $user_email);
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($cust[0]['phone']);
                        $id = base64_encode($cust[0]['id']);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;
                        $send_email = ['emailid' => $cust[0]['email_id'], 'username' => $cust[0]['name'], 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];
                        $reset_data = array('username' => $cust[0]['phone'], 'user_type' => 2, 'user_id' => $cust[0]['id'], 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "1") {
                    /**step 2 check how much count with the email **/
                    // $user = $this->check_user_info(['mobile_no'=>$data['email_id'],'status' => 'Active'],'tb_users');
                    $user = $this->db->get_where("tb_users", array('mobile_no' => $data['email_id'], 'status' => 'Active'));
                    if ($user->num_rows() > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use email instead of phone number'];
                    } elseif ($user->num_rows() == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $user->row()->emailid;
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($user->row()->mobile_no);
                        $id = base64_encode($user->row()->id);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;
                        $send_email = ['emailid' => $user->row()->emailid, 'username' => $user->row()->name, 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];
                        $reset_data = array('username' => $user->row()->mobile_no, 'user_type' => 1, 'user_id' => $user->row()->id, 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                } elseif ($post['roles_type'] == "4") {
                    /**step 2 check how much count with the email **/
                    // $user = $this->check_user_info(['mobile_no'=>$data['email_id'],'status' => 'Active'],'tb_users');
                    $sub_user = $this->db->get_where("tb_user_logins", array('mobile_no' => $data['email_id'], 'status' => '1'));
                    if ($sub_user->num_rows() > 1) {
                        /** step 3 if more than one count **/
                        $result = ['status' => 'fail', 'message' => 'Use email instead of phone number'];
                    } elseif ($sub_user->num_rows() == 1) {
                        /** step 4 if count == 1**/
                        $user_email = $sub_user->row()->emailid;
                        $enc_email = $this->encryptString($user_email);
                        $role = base64_encode($post['roles_type']);
                        $phone_no = base64_encode($sub_user->row()->mobile_no);
                        $id = base64_encode($sub_user->row()->id);
                        $encryptkey = $enc_email . '~' . $role . '~' . $phone_no . '~' . $id;
                        $link = $base_url . "forgotpassword/newpassword/" . $encryptkey;
                        $send_email = ['emailid' => $sub_user->row()->emailid, 'username' => $sub_user->row()->name, 'subject' => 'Forgot Password Notification', 'link' => $link, 'role_type' => $post['roles_type']];
                        $reset_data = array('username' => $sub_user->row()->mobile_no, 'user_type' => 4, 'user_id' => $sub_user->row()->id, 'reset_link' => $link, 'encryptkey' => $encryptkey, 'status' => 1, 'created_on' => $curdt);
                        $ins = $this->db->insert("tb_password_resets", $reset_data);
                        $a = $this->sendforgetpasswordemail($send_email);
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    } else {
                        $result = ['status' => 'success', 'message' => 'If that account exists in our database, we will send you an email to reset your password'];
                    }
                }
            } else {
                $result = ['status' => 'fail', 'message' => 'Select your role'];
            }
        } else {
            //log_message('error', 'logine3');
            $result = ['status' => 'fail', 'message' => 'Invalid email or phone number'];
        }
        echo json_encode($result);
    }


    public function check_user_info($where,$table_name)
    {
        $user_info = $this->common->gettbldata($where, '*', $table_name, 0, 0);
        return $user_info;
    }

    public function sendforgetpasswordemail($data){
        $this->load->library('email');
        $this->email->from('alert-donotreply@elog360.app', 'SVKonekt Support');
        $this->email->to($data['emailid'], $data['username']);
        $this->email->subject($data['subject']);
        $this->email->set_mailtype("html");
        $mdata = array();
        $mdata = ['username' => $data['username'],'page_title' => 'Forget Password Notification','link' => $data['link'],'role_type'=>$data['role_type']];
        $body= $this->load->view('mail_forms/forgetpassword/send_enc_email', $mdata, true);
        $this->email->message($body);
        if(isset($data['attachment']) && !empty($data['attachment'])){
            $this->email->attach($data['attachment']);
        }
        if(!$this->email->send()){
            log_message('error','MailID: '.$data['emailid']);
            log_message("error",$this->email->print_debugger());
        }
        return true;
    }

    public function newpassword($enc_email)
    {
        $a = [];
        $a = explode('~', $enc_email);
        if(!empty($a) && count($a) > 0) {
            if(array_key_exists(0, $a) && array_key_exists(1, $a) && array_key_exists(2, $a) && array_key_exists(3, $a)) {
                $email_id = $a[0];
                $decrypt_email = $this->decryptString($email_id);
                $data['enc_email'] = $enc_email;
                $type_id = $a[1];
                $type_id = base64_decode($type_id);
                $username = base64_decode($a[2]);
                $user_id = base64_decode($a[3]);
                $query = "SELECT * FROM tb_password_resets WHERE encryptkey='".$enc_email."' AND status='1' and user_type='$type_id' and username='$username' and user_id='$user_id' order by id desc limit 1";
                $exe_q = $this->db->query($query);
                $present_date = date("Y-m-d H:i:s");
                $present_time = strtotime($present_date);
                if($exe_q->num_rows() > 0) {
                    $created_on_time = strtotime($exe_q->row()->created_on);
                    $difference = round( ($present_time - $created_on_time)/3600);
                    if($difference < 1) {
                        $data['page_title'] = "Change Password";
                        $this->settemplate->auth('change_password', $data);
                    } else {
                        $this->session->set_flashdata('error_msg', 'Expired link, try again');
                        redirect('forgotpassword');
                    }
                } else {
                    $this->session->set_flashdata('error_msg', 'Expired link, try again');
                    redirect('forgotpassword');
                }
            } else {
                $this->session->set_flashdata('error_msg', 'Invalid token, try again');
                redirect('forgotpassword');
            }
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid token, try again');
            redirect('forgotpassword');
        }
    }

    public function changepassword($enc_email)
    {
        $data = array();
        $new_password = $this->input->post('adminlogin-new-password',true);
        $confirm_password = $this->input->post('adminlogin-confirm-password',true);

        if (empty($new_password)) {
            echo json_encode(['success' => false, 'message' => 'Password is required']);
            return;
        }
        if (strlen($new_password) < 6 or strlen($new_password) > 16) {
            echo json_encode(['success' => false, 'message' => 'Password needs to be between 6 and 16 characters']);
            return;
        }
        if ($new_password !== $confirm_password) {
            echo json_encode(['success' => false, 'message' => 'Passwords doesn\'t match']);
            return;
        }

        $updated_on = date("Y-m-d H:i:s");
        $result = array();
        /* code from acceptance email check*/
        $a = explode('~', $enc_email);
        if(!empty($a) && count($a) > 0) {
            if(array_key_exists(0, $a) && array_key_exists(1, $a) && array_key_exists(2, $a) && array_key_exists(3, $a)) {
                $email_id = $a[0];
                $decrypt_email = $this->decryptString($email_id);
                $type_id = $a[1];
                $type_id = base64_decode($type_id);
                $username = base64_decode($a[2]);
                $user_id = base64_decode($a[3]);
                if(isset($type_id) && !empty($type_id)) {
                    if($type_id == "3") {
                        $carrier_info = $this->db->get_where("tb_vendors",array('id'=>$user_id,'email'=>$decrypt_email,'mobile'=>$username,'status'=>1),1,0);
                        if($carrier_info->num_rows() > 0) {
                            $enc_password = $this->stringEncrypt($new_password);

                            $this->db->where(array("id"=>$carrier_info->row()->id))->update('tb_vendors',array("password"=>$enc_password));
                            $this->db->where(array('username' => $username,'user_type' => $type_id,'user_id' => $user_id,'encryptkey' => $enc_email))->update('tb_password_resets',array('status' => 0));
                            $mobile = $carrier_info->row()->mobile;
                            $code = $carrier_info->row()->code;
                            $user_info = $this->db->query("SELECT * FROM `tbl_party_master` where email='$decrypt_email' and mobile='$mobile' and code='$code' and status=1 order by id desc limit 1");
                            if($user_info->num_rows() > 0) {
                                $table = "tbl_party_master";
                                $data = ['password' => $enc_password];
                                $whr = ['id' => $user_info->row()->id];
                                $result = $this->common->updatetbledata($table, $data, $whr);

                            }
                            $result = ['status' => 'success', 'message' => 'Your password has been updated'];
                        } else {
                            $result = ['status' => 'fail', 'message' => 'User not found'];
                        }
                    } elseif($type_id == "2") {
                        $cust = $this->db->get_where("tb_customers",array('id'=>$user_id,'email_id'=>$decrypt_email,'phone'=>$username,'status'=>1),1,0);
                        if($cust->num_rows() > 0) {
                            $enc_password = $this->stringEncrypt($new_password);
                            $this->db->where(array("id"=>$cust->row()->id))->update('tb_customers',array("password"=>$enc_password));
                            $this->db->where(array('username' => $username,'user_type' => $type_id,'user_id' => $user_id,'encryptkey' => $enc_email))->update('tb_password_resets',array('status' => 0));
                            $mobile = $cust->row()->phone;
                            $code = $cust->row()->code;
                            $user_info = $this->db->query("SELECT * FROM `tbl_party_master` where email='$decrypt_email' and mobile='$mobile' and code='$code' and status=1 limit 1");

                            if($user_info->num_rows() > 0) {
                                $table = "tbl_party_master";
                                $data = ['password' => $enc_password];
                                $whr = ['id' => $user_info->row()->id];
                                $result = $this->common->updatetbledata($table, $data, $whr);
                            }
                            $result = ['status' => 'success', 'message' => 'Your password has been updated'];

                        } else {
                            $result = ['status' => 'fail', 'message' => 'User not found'];
                        }
                    } elseif($type_id == "1") {
                        $user = $this->db->get_where("tb_users",array('id'=>$user_id,'emailid'=>$decrypt_email,'mobile_no'=>$username,'status'=>'Active'),1,0);
                        if($user->num_rows() > 0)
                        {
                            $enc_password = password_hash($new_password, PASSWORD_DEFAULT);
                            $this->db->where(array("id"=>$user->row()->id))->update('tb_users',array("password"=>$enc_password));
                            $this->db->where(array('username' => $username,'user_type' => $type_id,'user_id' => $user_id,'encryptkey' => $enc_email))->update('tb_password_resets',array('status' => 0));
                            $result = ['status' => 'success', 'message' => 'Your password has been updated'];
                        } else {
                            $result = ['status' => 'fail', 'message' => 'User not found'];
                        }
                    } elseif($type_id == "4") {
                        $sub_user = $this->db->get_where("tb_user_logins",array('id'=>$user_id,'emailid'=>$decrypt_email,'mobile_no'=>$username,'status'=>1),1,0);
                        if($sub_user->num_rows() > 0)
                        {
                            $enc_password = password_hash($new_password, PASSWORD_DEFAULT);
                            $this->db->where(array("id"=>$sub_user->row()->id))->update('tb_user_logins',array("password"=>$enc_password));
                            $this->db->where(array('username' => $username,'user_type' => $type_id,'user_id' => $user_id,'encryptkey' => $enc_email))->update('tb_password_resets',array('status' => 0));
                            $result = ['status' => 'success', 'message' => 'Your password has been updated'];
                        } else {
                            $result = ['status' => 'fail', 'message' => 'User not found'];
                        }
                    }
                } else {
                    $result = ['status' => 'fail', 'message' => 'Invalid token, try again'];
                }
            } else {
                $result = ['status' => 'fail', 'message' => 'Invalid token, try again'];
            }
        } else {
            $result = ['status' => 'fail', 'message' => 'Invalid token, try again'];
        }

        echo json_encode($result);
    }

    public function stringEncrypt($str)
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }

    public function stringDecrypt($str)
    {
        return (($str));
    }

    public function encryptString($str){
        return base64_encode($str);
    }

    public function decryptString($str){
        return base64_decode($str);
    }
}
