<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Generatebillinginvoice  extends CI_Controller {

	public function __construct() {
		parent::__construct();
		require_once './vendor/autoload.php';
		$this->load->library('session');
		if($this->session->userdata('user_id') == ''){
			redirect('login');
		}
		$this->load->model('common');
		$this->load->model('truckwaybillmodel');
		$this->load->model('Order');
		$this->load->library("Aconinvoiceduedate");
	}
	public function index(){
		echo "Generating Internal BU billing & External Invoice";
	}
	
	public function internalbubilling($order_id = null){

		$data = $revenues = $charges = $orderdetails = $cargos = $branch_details = $customer_details = array();
		$total_weight = $total_volume = $total_qty = $total_ldm = $total_charges_amount = $total_charge_vat = $shift_id = 0;
		$company_code = $vat_id = $tax_id = $bookingid = "";
		$customer_code = $register_number = $incoterm ="";
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$getbranchdetails = $this->common->gettblrowdata(
			['branch_code' => $this->db->escape($branch_code), 'status' => '1'],
			"branch_name,city,street,zipcode,country,state,phone,fax",
			"tb_branch_details",
			0,
			0
		);
		if(!empty($getbranchdetails)){
			$branch_details = array(
				'branch_name' => $getbranchdetails['branch_name'],
				'city' => $getbranchdetails['city'],
				'street' => $getbranchdetails['street'],
				'zipcode' => $getbranchdetails['zipcode'],
				'country' => strtolower($getbranchdetails['country']),
				'state' => $getbranchdetails['state'],
				'phone' => $getbranchdetails['phone'],
				'fax' => $getbranchdetails['fax']
			);
		}
		$add_info=array();
		$childid=0;
		$user_name = "";
		$user_id=$this->session->userdata('user_id');
		if($this->session->userdata('childid')){
			$childid = $this->session->userdata('childid');
		}
		if($childid > 0){
			$getusername = $this->common->gettblrowdata(
				["id" => $this->db->escape($childid)],
				"name",
				"tb_user_logins",
				0,
				0
			);
			if(!empty($getusername)){
				$user_name= $getusername['name'];
			}
		}else{
			$getusername = $this->common->gettblrowdata(
				["id" => $this->db->escape($user_id)],
				"name",
				"tb_users",
				0,
				0
			);
			if(!empty($getusername)){
				$user_name= $getusername['name'];
			}
		}

		$add_info['user_name'] = $user_name;
		if($order_id >0){
			$getorderdetails = $this->common->gettblrowdata(
				['id' => $this->db->escape($order_id)],
				"order_id,pickup_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,customer_id,shift_id",
				"tb_orders",
				0,
				0
			);
			if(!empty($getorderdetails)){
				$customer_id = $getorderdetails['customer_id'];
				if($customer_id >0){
					$bookingid = $getorderdetails['order_id'];
					$shift_id = $getorderdetails['shift_id'];
					$getcustomerdetails = $this->common->gettblrowdata(
						['id' => $this->db->escape($customer_id)],
						"name,code,country,state,street,location,pincode,user_id,company_code",
						"tb_customers",
						0,
						0
					);
					if(!empty($getcustomerdetails)){
						$customer_code = $getcustomerdetails['code'];
						$customer_company_code = $getcustomerdetails['company_code'];
						$customer_user_id = $getcustomerdetails['user_id'];
						$customer_details = array(
							'name' => $getcustomerdetails['name'],
							'country' => strtolower($getcustomerdetails['country']),
							'state' => $getcustomerdetails['state'],
							'street' => $getcustomerdetails['street'],
							'location' => $getcustomerdetails['location'],
							'pincode' => $getcustomerdetails['pincode']
						);
						$get_taxids = $this->common->gettblrowdata(
							[
								'code' => $this->db->escape($customer_code),
								'user_id' => $this->db->escape($customer_user_id),
								'status' => '1'
							],
							"customeridentifier,acon_debitor_code,vat_reg_no,tax_payer_no",
							"tbl_party_master",
							0,
							0
						);
						if (empty($get_taxids)) {
							$get_ctaxids = $this->common->gettblrowdata(
								[
									'code' => $this->db->escape($customer_code),
									'company_code' => $this->db->escape($customer_company_code),
									'status' => '1'
								],
								"customeridentifier,acon_debitor_code,vat_reg_no,tax_payer_no",
								"tbl_party_master",
								0,
								0
							);
							if (!empty($get_ctaxids)) {
								$vat_id = $get_ctaxids['vat_reg_no'];
								$tax_id = $get_ctaxids['acon_debitor_code'];
								$acon_debitor_code = $get_ctaxids['acon_debitor_code'];
								$customeridentifier = $get_ctaxids['customeridentifier'];
							}
						} else {
							$vat_id = $get_taxids['vat_reg_no'];
							$tax_id = $get_taxids['tax_payer_no'];
							$acon_debitor_code = $get_taxids['acon_debitor_code'];
							$customeridentifier = $get_taxids['customeridentifier'];
						}
					}
				}
				$orderdetails = array(
					'booking_id' => $getorderdetails['order_id'],
					'pickup_datetime' => $getorderdetails['pickup_datetime'],
					'pickup_company' => $getorderdetails['pickup_company'],
					'delivery_company' => $getorderdetails['delivery_company'],
					'pickup_country' => strtolower($getorderdetails['pickup_country']),
					'delivery_country' => strtolower($getorderdetails['delivery_country']),
					'pickup_city' => $getorderdetails['pickup_city'],
					'delivery_city' => $getorderdetails['delivery_city'],
					'pickup_pincode' => $getorderdetails['pickup_pincode'],
					'delivery_pincode' => $getorderdetails['delivery_pincode'],
					'pickup_address1' => $getorderdetails['pickup_address1'],
					'delivery_address1' => $getorderdetails['delivery_address1'],
					'pickup_address2' => $getorderdetails['pickup_address2'],
					'delivery_address2' => $getorderdetails['delivery_address2']
				);
				$getordercargo = $this->common->gettbldata(
					['order_id' => $this->db->escape($order_id), 'status' => '1'],
					"id,cargo_id,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers",
					"tb_order_cargodetails",
					0,
					0
				);
				$cargos = array();
				$total_weight = $total_volume = $total_qty = $total_ldm = 0;
				if (!empty($getordercargo)) {
					foreach ($getordercargo as $ordcargo) {
						$total_weight += $ordcargo['weight'];
						$total_volume += $ordcargo['volume'];
						$total_qty += $ordcargo['quantity'];
						$total_ldm += $ordcargo['ldm'];
						$cargos[] = array(
							'cargo_id' => $ordcargo['cargo_id'],
							'weight' => $ordcargo['weight'],
							'ldm' => $ordcargo['ldm'],
							'volume' => $ordcargo['volume'],
							'quantity' => $ordcargo['quantity'],
							'cargo_content' => $ordcargo['cargo_content'],
							'quantity_type' => $ordcargo['quantity_type'],
							'marks_numbers' => $ordcargo['marks_numbers']
						);
					}
				}
				$total_charges_amount = $total_charge_vat = 0;
				$charges = array();
				$getrevenuedetails = $this->common->gettbldata(
					[
						'type' => '0',
						'order_id' => $this->db->escape($order_id),
						'status' => '1',
						'recipient_role' => 'Internal BU'
					],
					"id,amount",
					"tb_reveneus",
					0,
					0
				);
				if (!empty($getrevenuedetails)) {
					foreach ($getrevenuedetails as $res) {
						$revenue_id = $res['id'];
						$rev_amount = $res['amount'];
						if ($rev_amount > 0) {
							$getcharges = $this->common->gettbldata(
								['revenue_id' => $this->db->escape($revenue_id), 'status' => '1'],
								"id,charge_code,description,amount,currency,vat_percentage,vat_amount,cat_id,cat_val",
								"tb_charges",
								0,
								0
							);
							if (!empty($getcharges)) {
								foreach ($getcharges as $chrg) {
									$total_charges_amount += $chrg['amount'];
									$charges[] = array(
										'charge_code' => $chrg['charge_code'],
										'description' => $chrg['description'],
										'amount' => $chrg['amount'],
										'currency' => $chrg['currency'],
										'vat_percentage' => $chrg['vat_percentage'],
										'vat_amount' => $chrg['vat_amount'],
										'cat_val' => $chrg['cat_val'],
										'cat_id' => $chrg['cat_id']
									);
								}
							}
						}
					}
				}
			}
			if($shift_id >0){
				$getvehicle = $this->common->gettblrowdata(
					['shft_id' => $this->db->escape($shift_id), 'status' => '1'],
					"register_number",
					"tb_shft_veh",
					0,
					0
				);
				if (!empty($getvehicle)) {
					$register_number = $getvehicle['register_number'];
				}
			}
			$incoterm = "";
			$getincoterm = $this->common->gettblrowdata(
				['order_row_id' => $this->db->escape($order_id)],
				"incoterm",
				"tb_order_details",
				0,
				0
			);
			if (!empty($getincoterm)) {
				$incoterm = $getincoterm['incoterm'];
			}
			$inn = "";
			$getinn = $this->common->gettblrowdata(
				['order_id' => $this->db->escape($order_id), 'reference_id' => 'INN', 'status' => '1'],
				"ref_value",
				"tb_order_references",
				0,
				0
			);
			if (!empty($getinn)) {
				$inn = $getinn['incoterm'];
			}
			$donumber = "";
			$getdonumber = $this->common->gettblrowdata(
				['order_id' => $this->db->escape($order_id), 'reference_id' => 'DQ', 'status' => '1'],
				"ref_value",
				"tb_order_references",
				0,
				0
			);
			if (!empty($getdonumber)) {
				$donumber = $getdonumber['ref_value'];
			}
			$ponumber = "";
			$getgetponumber = $this->common->gettblrowdata(
				['order_id' => $this->db->escape($order_id), 'reference_id' => 'PO', 'status' => '1'],
				"ref_value",
				"tb_order_references",
				0,
				0
			);
			if (!empty($getgetponumber)) {
				$ponumber = $getgetponumber['ref_value'];
			}
			$total_rev_amount = 0;
			$currency = $this->session->userdata("usr_tzone")['currency'];
			$gettotalrev = $this->common->gettblrowdata(
				[
					'type' => '0',
					'order_id' => $this->db->escape($order_id),
					'status' => '1',
					'recipient_role' => 'Internal BU'
				],
				"sum(amount) as total_amount,currency",
				"tb_reveneus",
				0,
				0
			);
			if (!empty($gettotalrev)) {
				$total_rev_amount = $gettotalrev['total_amount'];
				$currency = $gettotalrev['currency'];
			}
			$invoice_number = $invoice_date = $debtor_jfr = $bu_jfr = $invoice_due_date = $revenue_id = "";
			$getjfr = $this->common->gettblrowdata(
				['type' => '0', 'order_id' => $this->db->escape($order_id), 'recipient_role' => 'Internal BU'],
				"id,debtor_jfr,bu_jfr,invoice_number,invoice_date",
				"tb_reveneus",
				0,
				0
			);
			if (!empty($getjfr)) {
				$revenue_id = $getjfr['id'];
				$invoice_number = $getjfr['invoice_number'];
				$invoice_date = $getjfr['invoice_date'];
				$debtor_jfr = $getjfr['debtor_jfr'];
				$bu_jfr = $getjfr['bu_jfr'];
			} else {
				$getjfr = $this->common->gettblrowdata(
					['type' => '0', 'order_id' => $this->db->escape($order_id)],
					"id,debtor_jfr,bu_jfr,invoice_number,invoice_date",
					"tb_reveneus",
					0,
					0
				);
				if (!empty($getjfr)) {
					$revenue_id = $getjfr['id'];
					$invoice_number = $getjfr['invoice_number'];
					$invoice_date = $getjfr['invoice_date'];
					$debtor_jfr = $getjfr['debtor_jfr'];
					$bu_jfr = $getjfr['bu_jfr'];
				}
			}
			if($invoice_date != "" && $revenue_id > 0){
				$chkbill = $this->common->gettblrowdata(
					['revenue_id' => $this->db->escape($revenue_id)],
					"id,acon_invoice_due_date_status,acon_invoice_due_date",
					"tbl_bills",
					0,
					0
				);
				if (!empty($chkbill)) {
					$acon_invoice_due_date_status = $chkbill['acon_invoice_due_date_status'];
					$invoice_due_date = $chkbill['acon_invoice_due_date'];
					$bill_id = $chkbill['id'];
					if ($acon_invoice_due_date_status == 0) {
						$returndata = $this->aconinvoiceduedate->getrequest($bill_id);
						$invoice_due_date = $returndata['DueDate'] ?? '';
					}
				} else {
					$total_amount = $total_rev_amount ?? 0;
					if ($total_amount > 0) {
						$total_amount = round($total_amount, 2);
					}
					$bill_data = [
						'revenue_id' => $this->db->escape($revenue_id),
						'tracking_no' => $this->db->escape($bookingid),
						'bill_party' => $customer_details['name'] ?? "",
						'bill_type' => 1,
						'bill_group' => 0,
						'recipient_type' => "Customer",
						'invoice_no' => $debtor_jfr ?? "",
						'invoice_date' => $invoice_date ?? "",
						'invoice_status' => 0,
						'acon_code' => $acon_debitor_code ?? "",
						'total_amount' => $this->db->escape($total_amount),
						'currency' => $this->db->escape($currency),
						'customer_code' => $customeridentifier ?? "",
						'code' => $customer_code ?? "",
						'company_code' => $this->db->escape($company_code),
						'branch_code' => $this->db->escape($branch_code),
						'department_code' => "",
						'user_id' => $this->db->escape($user_id),
						'status' => 0,
						'invoice_description' => ""
					];
					$bill_id = $this->common->insertTableData("tbl_bills", $bill_data);
					if ($bill_id > 0) {
						$returndata = $this->aconinvoiceduedate->getrequest($bill_id);
						$invoice_due_date = $returndata['DueDate'] ?? '';
					}
				}
			}
			$data['total_cargos'] = array('total_ldm'=>$total_ldm,'total_qty'=>$total_qty,'total_volume'=>$total_volume,'total_weight'=>$total_weight,'');
			$data['orderdetails']         = $orderdetails;
			$data['cargos']               = $cargos;
			$data['currency']             = $currency;
			$data['branch_details']       = $branch_details;
			$data['charges']              = $charges;
			$data['customer_details']     = $customer_details;
			$data['total_rev_amount']     = $total_rev_amount;
			$data['total_charges_amount'] = $total_charges_amount;
			$data['invoice_number']       = $invoice_number;
			$data['invoice_date']         = $invoice_date;
			$data['debtor_jfr']           = $debtor_jfr;
			$data['bu_jfr']               = $bu_jfr;
			$data['customer_code']        = $customer_code;
			$data['inn']                  = $inn;
			$data['ponumber']             = $ponumber;
			$data['donumber']             = $donumber;
			$data['register_number']      = $register_number;
			$data['incoterm']             = $incoterm;
			$data['company_code']         = $company_code;
			$data['vat_id']               = $vat_id;
			$data['tax_id']               = $tax_id;
			$data['usercompany_code']     = $company_code;
			$data['add_info']             = $add_info;
			$data['invoice_due_date']     = $invoice_due_date;
			if(!empty($orderdetails)){
				$output = $this->load->view('billinginvoices/internalbubilling', $data, TRUE);
				$mpdf = new \Mpdf\Mpdf([
					'tempDir' => FCPATH .'assets/tmp',
					'mode' => 'utf-8',
					'default_font_size' => 9,
					'format' => 'A4',
					'margin_footer' => 10,
					'orientation' => 'P']);
				$mpdf->setAutoBottomMargin='false';
				$mpdf->defaultfooterline=0;
				$footerdata= $this->load->view('billinginvoices/footer', $data, TRUE);
				$mpdf->setFooter('<table style="padding:100px;" height="100%" width="100%">'.$footerdata.'</table>');
		        $mpdf->WriteHTML($output);
		        if($bookingid == ""){
		        	$mpdf->Output("InternalBilling-". date('YmdHis') . ".pdf", 'D');
		        }else{
		        	$mpdf->Output("InternalBilling-".$bookingid. ".pdf", 'D');
		        }
			}else{
				echo "No Order found";
			}
		}else{
			echo "ORder Not Given";
		}
	}
	
	public function billid_externalinvoice($bill_id = null){
		$order_ids = array();
		if($bill_id != ""){
			$getrev = $this->common->gettbldata(
				['bill_id' => $this->db->escape($bill_id), 'status' => '1'],
				"order_id",
				"tb_reveneus",
				0,
				0
			);
			if (!empty($getrev)) {
				foreach ($getrev as $rev) {
					$order_ids[] = $rev['order_id'];
				}
			}
			if (!empty($order_ids)) {
				$this->externalinvoice($order_ids, $bill_id);
			}
		}
	}
	
	public function externalinvoice($order_ids,$bill_id){
		$data = $orderdetails = array();
		$revenues = $charges = $orderdetails = $cargos = $branch_details = $customer_details = array();
		$total_weight = $total_volume = $total_qty = $total_ldm = $total_charges_amount = $total_charge_vat = $shift_id = $total_rev_amount = 0;
		$company_code = $vat_id = $tax_id = $invoice_number = $invoice_date = $debtor_jfr = $bu_jfr = $inn = $currency = $customer_code = $register_number = $incoterm = $bookingid = $filename = $general_code = $bill_party = "";
		$add_info = array();
		$session_currency = $this->session->userdata("usr_tzone")['currency'];
		$billing_status = 0;
		$returndata = $this->aconinvoiceduedate->getrequest($bill_id);
		$where = ['id' => $this->db->escape($bill_id), 'status!=' => '0'];
		$invoice_date = date('Y-m-d');
		$invoiceinfo = $this->common->gettblrowdata(
			$where,
			'bill_party,invoice_no,invoice_date,invoice_status,acon_code,customer_code,code,branch_code,acon_invoice_due_date',
			'tbl_bills',
			0,
			0
		);
		if (count($invoiceinfo) > 0) {
			$add_info['invoice_no'] = $filename = $invoiceinfo['invoice_no'];
			$add_info['invoice_date'] = $invoice_date = date("Y-m-d", strtotime($invoiceinfo['invoice_date']));
			$add_info['customer_code'] = $invoiceinfo['customer_code'];
			$add_info['general_code'] = $general_code = $invoiceinfo['code'];
			$add_info['acon_code'] = $invoiceinfo['acon_code'];
			$branchcode = $invoiceinfo['branch_code'];
			$add_info['acon_invoice_due_date'] = $invoiceinfo['acon_invoice_due_date'];
			$billing_status = $invoiceinfo['invoice_status'];
			$bill_party = $invoiceinfo['bill_party'];
		}
		if($general_code != ""){
			$get_customerdetails = $this->common->gettblrowdata(
				['code' => $this->db->escape($general_code), 'name' => $this->db->escape($bill_party), 'status' => '1'],
				"name,location_id,country,state,street,pincode,vat_reg_no,tax_payer_no",
				"tbl_party_master",
				0,
				0
			);
			if (!empty($get_customerdetails)) {
				$customer_details = array(
					'name' => $get_customerdetails['name'],
					'country' => strtolower($get_customerdetails['country']),
					'state' => $get_customerdetails['state'],
					'street' => $get_customerdetails['street'],
					'location' => $get_customerdetails['location_id'],
					'pincode' => $get_customerdetails['pincode']
				);
				$vat_id = $get_customerdetails['vat_reg_no'];
				$tax_id = $get_customerdetails['tax_payer_no'];
			} else {
				$getcustomerdetails = $this->common->gettblrowdata(
					[
						'code' => $this->db->escape($general_code),
						'name' => $this->db->escape($bill_party),
						'status' => '1'
					],
					"name,country,state,street,location,pincode",
					"tb_customers",
					0,
					0
				);
				if (!empty($getcustomerdetails)) {
					$customer_details = array(
						'name' => $getcustomerdetails['name'],
						'country' => strtolower($getcustomerdetails['country']),
						'state' => $getcustomerdetails['state'],
						'street' => $getcustomerdetails['street'],
						'location' => $getcustomerdetails['location_id'],
						'pincode' => $getcustomerdetails['pincode']
					);
				}
			}
		}
		$billing_status_name = "";
		if($billing_status >0){
			$chkbilling_status = $this->common->gettblrowdata(
				['id' => $this->db->escape($billing_status)],
				"name",
				"tb_billstatus_master",
				0,
				0
			);
			if (!empty($chkbilling_status)) {
				$billing_status_name = $chkbilling_status['name'];
			}
		}
		$childid=0;
		$user_name = "";
		$user_id=$this->session->userdata('user_id');
		if($this->session->userdata('childid')){
			$childid = $this->session->userdata('childid');
		}
		if($childid > 0){
			$getusername = $this->common->gettblrowdata(
				["id" => $this->db->escape($childid)],
				"name",
				"tb_user_logins",
				0,
				0
			);
			if (!empty($getusername)) {
				$user_name = $getusername['name'];
			}
		} else{
			$getusername = $this->common->gettblrowdata(
				["id" => $this->db->escape($user_id)],
				"name",
				"tb_users",
				0,
				0
			);
			if (!empty($getusername)) {
				$user_name = $getusername['name'];
			}
		}

		$add_info['user_name'] = $user_name;
		if(!empty($order_ids)){
			$company_code = $this->session->userdata('company_code');
			$branch_code = $this->session->userdata('branch_code');
			$getbranchdetails = $this->common->gettblrowdata(
				['branch_code' => $this->db->escape($branch_code), 'status' => '1'],
				"branch_name,city,street,zipcode,country,state,phone,fax",
				"tb_branch_details",
				0,
				0
			);
			if (!empty($getbranchdetails)) {
				$branch_details = array(
					'branch_name' => $getbranchdetails['branch_name'],
					'city' => $getbranchdetails['city'],
					'street' => $getbranchdetails['street'],
					'zipcode' => $getbranchdetails['zipcode'],
					'country' => strtolower($getbranchdetails['country']),
					'state' => $getbranchdetails['state'],
					'phone' => $getbranchdetails['phone'],
					'fax' => $getbranchdetails['fax']
				);
			}
			$order_details = $this->truckwaybillmodel->orderdetails_forbilling($order_ids);
			if (!empty($order_details)) {
				foreach ($order_details as $res) {
					$customer_id = $res['customer_id'];
					$bookingid = $res['order_id'];
					$order_id = $res['id'];
					$shift_id = $res['shift_id'];
					$getordercargo = $this->common->gettbldata(
						['order_id' => $this->db->escape($order_id), 'status' => '1'],
						"id,cargo_id,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers",
						"tb_order_cargodetails",
						0,
						0
					);
					$cargos = array();
					$total_weight = $total_volume = $total_qty = $total_ldm = 0;
					if (!empty($getordercargo)) {
						foreach ($getordercargo as $ordcargo) {
							$total_weight += $ordcargo['weight'];
							$total_volume += $ordcargo['volume'];
							$total_qty += $ordcargo['quantity'];
							$total_ldm += $ordcargo['ldm'];
							$cargos[] = array(
								'cargo_id' => $ordcargo['cargo_id'],
								'weight' => $ordcargo['weight'],
								'ldm' => $ordcargo['ldm'],
								'volume' => $ordcargo['volume'],
								'quantity' => $ordcargo['quantity'],
								'cargo_content' => $ordcargo['cargo_content'],
								'quantity_type' => $ordcargo['quantity_type'],
								'marks_numbers' => $ordcargo['marks_numbers']
							);
						}
					}
					$charges = $vat_arr = $vat_applicable_arr = $revenues = array();
					$vat_applicable_amnt = $vat_notapplicable_amnt = $final_local_vat_amount = $final_local_amount = $exchange_rate = 0;
					$final_currency = $final_local_currency = "";
					$getrevenuedetails = $this->common->gettbldata(
						[
							'type' => '0',
							'order_id' => $this->db->escape($order_id),
							'bill_id' => $this->db->escape($bill_id),
							'status' => '1'
						],
						"id,amount,exchange_rate",
						"tb_reveneus",
						0,
						0
					);
					if (!empty($getrevenuedetails)) {
						foreach ($getrevenuedetails as $rev) {
							$rev_amount = $rev['amount'];
							$exchange_rate = $rev['exchange_rate'];
							if ($rev_amount > 0) {
								$revenues[] = $rev['id'];
							}
						}
					}
					$currency_arr = $this->truckwaybillmodel->checksinglecurrencyexists_inallcharges(
						$revenues,
						$session_currency
					);
					if(!empty($currency_arr)){
						if(count($currency_arr) >1){
							$chk_localcurrency = 0;
						}else{
							if(in_array($session_currency,$currency_arr)){
								$chk_localcurrency = 0;
							}else{
								$chk_localcurrency = 1;
							}
						}
					}
					if(!empty($revenues)){
						foreach ($revenues as $eachid) {
							$revenue_id = $eachid;
							$total_charges_amount = 0;
							$getcharges = $this->common->gettbldata(
								['revenue_id' => $this->db->escape($revenue_id), 'status' => '1'],
								"id,charge_code,description,amount,currency,local_amount,local_currency,local_vat_amount,vat_percentage,vat_amount,cat_id,cat_val",
								"tb_charges",
								0,
								0
							);
							if (!empty($getcharges)) {
								foreach ($getcharges as $chrg) {
									$final_amount = $chrg['amount'];
									$final_currency = $chrg['currency'];
									$vat_percentage = $chrg['vat_percentage'];
									$local_currency = $chrg['local_currency'];
									$local_amount = $chrg['local_amount'];
									if ($chk_localcurrency == "0") {
										if ($local_amount > 0) {
											$final_amount = $local_amount;
											$final_currency = $local_currency;
										}
									}
									$local_vat_amount = $chrg['local_vat_amount'];
									$vat_amount = $chrg['vat_amount'];
									if($chk_localcurrency == "0"){
										if(is_numeric($local_vat_amount)){
											$vat_amount = $chrg['local_vat_amount'];
										}
									}
									$final_local_amount += $local_amount;
									$final_local_vat_amount += $local_vat_amount;
									$final_local_currency = $local_currency;
									$total_charges_amount += $final_amount;
									if(is_numeric($vat_percentage)){
										if($vat_percentage >0){
											if(empty($vat_arr)){
												$vat_arr[] = $vat_percentage;
											}else{
												if(!in_array($vat_percentage, $vat_arr)){
													$vat_arr[] = $vat_percentage;
												}
											}
										}else{
											$vat_percentage = "0.00";
										}
									}else{
										$vat_percentage = "0.00";
									}
									$charges[] = array('charge_code'=>$chrg['charge_code'],'description'=>$chrg['description'],'amount'=>$final_amount,'currency'=>$final_currency,'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$chrg['cat_val'],'cat_id'=>$chrg['cat_id']);
								}
							}
						}
					}
					$zero_percentage = $applied_vat_amount = $total_vat_applicable_amount = $total_vatpercentage_amount =0;
					if(!empty($vat_arr)){
						foreach ($vat_arr as $vat_per) {
							$single_vat = $vat_per;
							if(!empty($charges)){
								foreach ($charges as $chrg) {
									$charge_vat_percentage = $chrg['vat_percentage'];
									if($charge_vat_percentage > 0){
										if($charge_vat_percentage == $single_vat){
											$vat_applicable_amnt   += $chrg['amount'];
											$applied_vat_amount += $chrg['vat_amount'];
											$vat_applicable_arr[$charge_vat_percentage] = array('vat_applicable_amount'=>$vat_applicable_amnt,'vat_percentage'=>$charge_vat_percentage,'vat_amount'=>$applied_vat_amount);
										}else{
											$applied_vat_amount = $vat_applicable_amnt = "0.00";
										}
									}
								}
							}
						}
					}
					if(!empty($charges)){
						foreach ($charges as $chrg) {
							$vat_percentage = $chrg['vat_percentage'];
							if($vat_percentage == 0){
								$vat_notapplicable_amnt += $chrg['amount'];
								$vat_applicable_arr[$zero_percentage] = array('vat_applicable_amount'=>$vat_notapplicable_amnt,'vat_percentage'=>'0.00','vat_amount'=>'0.00');
							}
						}
					}
					if(!empty($vat_applicable_arr)){
						foreach ($vat_applicable_arr as $each) {
							$total_vat_applicable_amount += $each['vat_applicable_amount'];
							$total_vatpercentage_amount  += $each['vat_amount'];
						}
					}
					$final_total_amount       = $total_vat_applicable_amount + $total_vatpercentage_amount;
					$final_local_total_amount = $final_local_amount + $final_local_vat_amount;
					$register_number = "";
					if($shift_id >0){
						$getvehicle = $this->common->gettblrowdata(
							['shft_id' => $this->db->escape($shift_id), 'status' => '1'],
							"register_number",
							"tb_shft_veh",
							0,
							0
						);
						if (!empty($getvehicle)) {
							$register_number = $getvehicle['register_number'];
						}
					}
					$incoterm = "";
					$getincoterm = $this->common->gettblrowdata(
						['order_row_id' => $this->db->escape($order_id)],
						"incoterm",
						"tb_order_details",
						0,
						0
					);
					if (!empty($getincoterm)) {
						$incoterm = $getincoterm['incoterm'];
					}
					$inn = "";
					$getinn = $this->common->gettblrowdata(
						['order_id' => $this->db->escape($order_id), 'reference_id' => 'INN', 'status' => '1'],
						"ref_value",
						"tb_order_references",
						0,
						0
					);
					if (!empty($getinn)) {
						$inn = $getinn['ref_value'];
					}
					$donumber = "";
					$getdonumber = $this->common->gettblrowdata(
						['order_id' => $this->db->escape($order_id), 'reference_id' => 'DQ', 'status' => '1'],
						"ref_value",
						"tb_order_references",
						0,
						0
					);
					if (!empty($getdonumber)) {
						$donumber = $getdonumber['ref_value'];
					}
					$ponumber = "";
					$getgetponumber = $this->common->gettblrowdata(
						['order_id' => $this->db->escape($order_id), 'reference_id' => 'PO', 'status' => '1'],
						"ref_value",
						"tb_order_references",
						0,
						0
					);
					if (!empty($getgetponumber)) {
						$ponumber = $getgetponumber['ref_value'];
					}
					$total_rev_amount = 0;
					$currency = $this->session->userdata("usr_tzone")['currency'];
					$total_rev_amount = 0;
					$gettotalrev = $this->common->gettblrowdata(
						[
							'type' => '0',
							'order_id' => $this->db->escape($order_id),
							'bill_id' => $this->db->escape($bill_id),
							'status' => '1'
						],
						"sum(amount) as total_amount",
						"tb_reveneus",
						0,
						0
					);
					if (!empty($gettotalrev)) {
						$total_rev_amount = $gettotalrev['total_amount'];
					}
					$debtor_jfr = "";
					$getjfr = $this->common->gettblrowdata(
						['type' => '0', 'order_id' => $this->db->escape($order_id)],
						"debtor_jfr",
						"tb_reveneus",
						0,
						0
					);

					if (!empty($getjfr)) {
						$debtor_jfr = $getjfr['debtor_jfr'];
					}
					$total_cargos = array(
						'total_ldm' => $total_ldm,
						'total_qty' => $total_qty,
						'total_volume' => $total_volume,
						'total_weight' => $total_weight
					);
					$orderdata = array(
						'booking_id' => $res['order_id'],
						'pickup_datetime' => $res['pickup_datetime'],
						'pickup_company' => $res['pickup_company'],
						'delivery_company' => $res['delivery_company'],
						'pickup_country' => strtolower($res['pickup_country']),
						'delivery_country' => strtolower($res['delivery_country']),
						'pickup_city' => $res['pickup_city'],
						'delivery_city' => $res['delivery_city'],
						'pickup_pincode' => $res['pickup_pincode'],
						'delivery_pincode' => $res['delivery_pincode'],
						'pickup_address1' => $res['pickup_address1'],
						'delivery_address1' => $res['delivery_address1'],
						'pickup_address2' => $res['pickup_address2'],
						'delivery_address2' => $res['delivery_address2'],
						'tax_id' => $tax_id,
						'vat_id' => $vat_id,
						'company_code' => $company_code,
						'incoterm' => $incoterm,
						'register_number' => $register_number,
						'inn' => $inn,
						'donumber' => $donumber,
						'ponumber' => $ponumber,
						'customer_code' => $customer_code,
						'debtor_jfr' => $debtor_jfr,
						'invoice_date' => $invoice_date,
						'invoice_number' => $filename,
						'total_charges_amount' => $total_charges_amount,
						'total_rev_amount' => $total_rev_amount,
						'currency' => $currency,
						'session_currency' => $session_currency,
						'currency' => $final_currency,
						'final_local_currency' => $final_local_currency
					);

					$orderdetails[] = array(
						'orderdata' => $orderdata,
						'customer_details' => $customer_details,
						'charges' => $charges,
						'branch_details' => $branch_details,
						'total_cargos' => $total_cargos,
						'cargos' => $cargos,
						'add_info' => $add_info,
						'vat_applicable_arr' => $vat_applicable_arr,
						'final_total_amount' => $final_total_amount,
						'total_vat_applicable_amount' => $total_vat_applicable_amount,
						'total_vatpercentage_amount' => $total_vatpercentage_amount,
						'final_local_vat_amount' => $final_local_vat_amount,
						'final_local_amount' => $final_local_amount,
						'final_local_total_amount' => $final_local_total_amount,
						'chk_localcurrency' => $chk_localcurrency,
						'exchange_rate' => $exchange_rate
					);
				}
			}
			$data['orderdetails'] = $orderdetails;
			if(!empty($data['orderdetails'])){
				$html = "";
		        $mpdf = new \Mpdf\Mpdf([
					'tempDir' => FCPATH .'assets/tmp',
					'mode' => 'utf-8',
					'default_font_size' => 9,
					'format' => 'A4',
					'margin_footer' => 10,
					'orientation' => 'P']);
				$mpdf->setAutoBottomMargin='false';
				$mpdf->defaultfooterline=0;
		        $count = count($data['orderdetails'])-1;
				for($i=0;$i<count($data['orderdetails']);$i++){
					if(strtoupper($billing_status_name) == "OPEN"){
						$mpdf->SetWatermarkText('DRAFT');
						$mpdf->showWatermarkText = true;
						$mpdf->watermarkTextAlpha = 0.1;
					}
					$html .= $this->load->view('billinginvoices/externalinvoice', $data['orderdetails'][$i], TRUE);
					$footerdata= $this->load->view('billinginvoices/footer', $data['orderdetails'][$i], TRUE);
					$mpdf->setFooter('<table style="padding:100px;" height="100%" width="100%">'.$footerdata.'</table>');
					if($i<($count)){
						$html .= "<pagebreak/>";
					}
				}
				$mpdf->WriteHTML($html);
				if($filename == ""){
		        	$mpdf->Output("Externalinvoice-". date('YmdHis') . ".pdf", 'D');
		        }else{
		        	$mpdf->Output("Externalinvoice-".$filename. ".pdf", 'D');
		        }
			}else{
				echo "No Order found";
			}

		}
	}

	public function single_externalinvoice($order_ids){
		$data = $revenues = $charges = $orderdetails = $cargos = $branch_details = $customer_details = array();
		/*$order_id ='48099';
		$order_id = '0';*/
		$bookingid = "";
		$total_weight = $total_volume = $total_qty = $total_ldm = $total_charges_amount = $total_charge_vat = $shift_id = 0;
		$company_code = $vat_id = $tax_id = "";
		$customer_code = $register_number = $incoterm = "";
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$getbranchdetails = $this->common->gettblrowdata(
			['branch_code' => $this->db->escape($branch_code), 'status' => '1'],
			"branch_name,city,street,zipcode,country,state,phone,fax",
			"tb_branch_details",
			0,
			0
		);
		if (!empty($getbranchdetails)) {
			$branch_details = array(
				'branch_name' => $getbranchdetails['branch_name'],
				'city' => $getbranchdetails['city'],
				'street' => $getbranchdetails['street'],
				'zipcode' => $getbranchdetails['zipcode'],
				'country' => strtolower($getbranchdetails['country']),
				'state' => $getbranchdetails['state'],
				'phone' => $getbranchdetails['phone'],
				'fax' => $getbranchdetails['fax']
			);
		}
		/*print_r($order_ids);exit;*/
		if (!empty($order_ids)) {
			foreach ($order_ids as $order_id) {
				$getorderdetails = $this->common->gettblrowdata(
					['id' => $this->db->escape($order_id)],
					"order_id,pickup_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,customer_id,shift_id",
					"tb_orders",
					0,
					0
				);
				if (!empty($getorderdetails)) {
					$customer_id = $getorderdetails['customer_id'];
					$bookingid = $getorderdetails['order_id'];
					if ($customer_id > 0) {
						$shift_id = $getorderdetails['shift_id'];
						$getcustomerdetails = $this->common->gettblrowdata(
							['id' => $this->db->escape($customer_id)],
							"name,code,country,state,street,location,pincode,user_id,company_code",
							"tb_customers",
							0,
							0
						);
						if (!empty($getcustomerdetails)) {
							$customer_code = $getcustomerdetails['code'];
							$customer_company_code = $getcustomerdetails['company_code'];
							$customer_user_id = $getcustomerdetails['user_id'];
							$customer_details = array(
								'name' => $getcustomerdetails['name'],
								'country' => strtolower($getcustomerdetails['country']),
								'state' => $getcustomerdetails['state'],
								'street' => $getcustomerdetails['street'],
								'location' => $getcustomerdetails['location'],
								'pincode' => $getcustomerdetails['pincode']
							);
							$get_taxids = $this->common->gettblrowdata(
								[
									'code' => $this->db->escape($customer_code),
									'user_id' => ($customer_user_id),
									'status' => '1'
								],
								"vat_reg_no,tax_payer_no",
								"tbl_party_master",
								0,
								0
							);
							if (empty($get_taxids)) {
								$get_ctaxids = $this->common->gettblrowdata(
									[
										'code' => $this->db->escape($customer_code),
										'company_code' => $this->db->escape($customer_company_code),
										'status' => '1'
									],
									"vat_reg_no,tax_payer_no",
									"tbl_party_master",
									0,
									0
								);
								if (!empty($get_ctaxids)) {
									$vat_id = $get_ctaxids['vat_reg_no'];
									$tax_id = $get_ctaxids['tax_payer_no'];
								}
							} else {
								$vat_id = $get_taxids['vat_reg_no'];
								$tax_id = $get_taxids['tax_payer_no'];
							}
						}
					}
					$orderdetails = array(
						'booking_id' => $getorderdetails['order_id'],
						'pickup_datetime' => $getorderdetails['pickup_datetime'],
						'pickup_company' => $getorderdetails['pickup_company'],
						'delivery_company' => $getorderdetails['delivery_company'],
						'pickup_country' => strtolower($getorderdetails['pickup_country']),
						'delivery_country' => strtolower($getorderdetails['delivery_country']),
						'pickup_city' => $getorderdetails['pickup_city'],
						'delivery_city' => $getorderdetails['delivery_city'],
						'pickup_pincode' => $getorderdetails['pickup_pincode'],
						'delivery_pincode' => $getorderdetails['delivery_pincode'],
						'pickup_address1' => $getorderdetails['pickup_address1'],
						'delivery_address1' => $getorderdetails['delivery_address1'],
						'pickup_address2' => $getorderdetails['pickup_address2'],
						'delivery_address2' => $getorderdetails['delivery_address2']
					);
					$getordercargo = $this->common->gettbldata(
						['order_id' => $this->db->escape($order_id), 'status' => '1'],
						"id,cargo_id,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers",
						"tb_order_cargodetails",
						0,
						0
					);
					$cargos = array();
					$total_weight = $total_volume = $total_qty = $total_ldm = 0;
					if (!empty($getordercargo)) {
						foreach ($getordercargo as $ordcargo) {
							$total_weight += $ordcargo['weight'];
							$total_volume += $ordcargo['volume'];
							$total_qty += $ordcargo['quantity'];
							$total_ldm += $ordcargo['ldm'];
							$cargos[] = array(
								'cargo_id' => $ordcargo['cargo_id'],
								'weight' => $ordcargo['weight'],
								'ldm' => $ordcargo['ldm'],
								'volume' => $ordcargo['volume'],
								'quantity' => $ordcargo['quantity'],
								'cargo_content' => $ordcargo['cargo_content'],
								'quantity_type' => $ordcargo['quantity_type'],
								'marks_numbers' => $ordcargo['marks_numbers']
							);
						}
					}
					$total_charges_amount = $total_charge_vat = 0;
					$charges = array();
					$getrevenuedetails = $this->common->gettbldata(
						[
							'order_id' => $this->db->escape($order_id),
							'type' => '0',
							'recipient_role' => 'Customer',
							'status' => '1'
						],
						"id,invoice_date,amount",
						"tb_reveneus",
						0,
						0
					);
					if (!empty($getrevenuedetails)) {
						foreach ($getrevenuedetails as $res) {
							$revenue_id = $res['id'];
							$rev_amount = $res['amount'];
							if ($rev_amount > 0) {
								$getcharges = $this->common->gettbldata(
									['revenue_id' => $this->db->escape($revenue_id), 'status' => '1'],
									"id,charge_code,description,amount,currency,vat_percentage,vat_amount,cat_id",
									"tb_charges",
									0,
									0
								);
								if (!empty($getcharges)) {
									foreach ($getcharges as $chrg) {
										$amnt = $chrg['amount'];
										if (strpos($amnt, '-') !== false) {
										} else {
											$total_charges_amount += $chrg['amount'];
											$currency = $chrg['currency'];
											$charges[] = array(
												'charge_code' => $chrg['charge_code'],
												'description' => $chrg['description'],
												'amount' => $chrg['amount'],
												'currency' => $chrg['currency'],
												'vat_percentage' => $chrg['vat_percentage'],
												'vat_amount' => $chrg['vat_amount'],
												'cat_id' => $chrg['cat_id']
											);
										}
									}
								}
							/*	$revenues[] = array('revenue_id'=>$revenue_id,'debtor_jfr'=>$res['debtor_jfr'],'bu_jfr'=>$res['bu_jfr'],'invoice_date'=>$res['invoice_date'],'amount'=>$rev_amount,'currency'=>$res['currency'],'charges'=>$charges);*/
							}
						}
					}
				}
				if($shift_id >0){
					$getvehicle = $this->common->gettblrowdata(
						['shft_id' => $this->db->escape($shift_id), 'status' => '1'],
						"register_number",
						"tb_shft_veh",
						0,
						0
					);
					if (!empty($getvehicle)) {
						$register_number = $getvehicle['register_number'];
					}
				}
				$incoterm = "";
				$getincoterm = $this->common->gettblrowdata(
					['order_row_id' => $this->db->escape($order_id)],
					"incoterm",
					"tb_order_details",
					0,
					0
				);
				if (!empty($getincoterm)) {
					$incoterm = $getincoterm['incoterm'];
				}
				$inn = "";
				$getinn = $this->common->gettblrowdata(
					['order_id' => $this->db->escape($order_id), 'reference_id' => 'INN', 'status' => '1'],
					"ref_value",
					"tb_order_references",
					0,
					0
				);
				if (!empty($getinn)) {
					$inn = $getinn['incoterm'];
				}
				$total_rev_amount = 0;
				$currency = $this->session->userdata("usr_tzone")['currency'];
				$gettotalrev = $this->common->gettbldata(
					[
						'type' => '0',
						'order_id' => $this->db->escape($order_id),
						'recipient_role' => 'Customer',
						'status' => '1'
					],
					"amount,currency",
					"tb_reveneus",
					0,
					0
				);
				if (!empty($gettotalrev)) {
					foreach ($gettotalrev as $res) {
						$amnt = $res['amount'];
						if (strpos($amnt, '-') !== false) {
						} else {
							$total_rev_amount += $res['amount'];
							$currency = $res['currency'];
						}
					}
				}
				$invoice_number = $invoice_date = $debtor_jfr = $bu_jfr = "";
				$getjfr = $this->common->gettblrowdata(
					['type' => '0', 'order_id' => $this->db->escape($order_id), 'recipient_role' => 'Customer'],
					"debtor_jfr,invoice_number,invoice_date",
					"tb_reveneus",
					0,
					0
				);
				if (!empty($getjfr)) {
					$invoice_number = $getjfr['invoice_number'];
					$invoice_date = $getjfr['invoice_date'];
					$debtor_jfr = $getjfr['debtor_jfr'];
				}
				$data['total_cargos'] = array(
					'total_ldm' => $total_ldm,
					'total_qty' => $total_qty,
					'total_volume' => $total_volume,
					'total_weight' => $total_weight,
					''
				);
				$data['orderdetails'] = $orderdetails;
				$data['cargos'] = $cargos;
				/*echo count($data['cargos']);exit;*/
				$data['currency'] = $currency;
				$data['branch_details']       = $branch_details;
				$data['charges']              = $charges;
				$data['customer_details']     = $customer_details;
				$data['total_rev_amount']     = $total_rev_amount;
				$data['total_charges_amount'] = $total_charges_amount;
				$data['invoice_number']       = $invoice_number;
				$data['invoice_date']         = $invoice_date;
				$data['debtor_jfr']           = $debtor_jfr;
				$data['customer_code']        = $customer_code;
				$data['inn']                  = $inn;
				$data['register_number']      = $register_number;
				$data['incoterm']             = $incoterm;
				$data['company_code']         = $company_code;
				$data['vat_id']               = $vat_id;
				$data['tax_id']               = $tax_id;
				if(!empty($orderdetails)){
					$output = $this->load->view('billinginvoices/externalinvoice', $data, TRUE);
					$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8',  'default_font_size' => 9, 'format' => 'A4','margin_footer' => 10,'orientation' => 'P']);
					$mpdf->setAutoBottomMargin='false';
					$mpdf->defaultfooterline=0;
					$mpdf->setFooter('<table style="padding:60px;" height="40%" width="100%"><tr><td width="70%"><table style="font-size:8px;padding:60px;border:none;!important;"><tr style="border:none;!important;"><td width="40%" style="border:none;!important;" align="left"> Kuehne + Nagel Pte Ltd<br>Singapore Logistics Hub<br>10 Pioneer Crescent<br>Singapore 628566<br>GST Reg No: M2-0119323 X<br>RCB No. 199400013D </td><td width="35%" align="left" style="border:none;!important;">Tel: +65 63395115<br>Fax: +65 63395225<br>Email:info.singapore@kuehne-nagel.com <br>Internet: www.kn-portal.com</td><td width="30%" style="border:none;!important;" align="left">1)Standard Chartered Bank<br>Swift Code: SCBLSG22<br> SGD: 01-0-232762-9<br>2)Citibank N.A.<br>USD: 0-859297-005</td></tr></table></td><td width="40%" align="left"><p style=""><b>KUEHNE + NAGEL PTE. LTD.</b><br>{PAGENO} / {nb}</p></td></tr></table>');
			        $mpdf->WriteHTML($output);
			        if($bookingid == ""){
			        	$mpdf->Output("Externalbilling"."-".date('YmdHis') . ".pdf", 'D');
			        }else{
			        	$mpdf->Output("Externalbilling-".$bookingid."-".".pdf", 'D');
			        }
			        /*$mpdf->Output("Manifest_" . date('YmdHis') . ".pdf", 'D');*/
				}else{
					echo "No Order found";
				}
			}
		}else{
			echo "ORder Not Given";
		}

	}
	
}

?>
