<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class Generatedailyaucustreport extends CI_Controller
{
    private const MAIL_ATTACHMENT_PATH = 'assets/quote/aucustreports';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Aucustreportmodel');
        $this->load->model('common');
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
    }
    
    public function index(){
        echo "<pre>";
        $cust_ids = $cust_arr = $data = $result  = $info = $chk_customer = array();
        $curtz = "Australia/Sydney";
        $default_timezone ="UTC";
        $getcustomers = $this->common->gettbldata(array('company_code'=>'AUKN','status'=>'1'), "id,name,code,email_id", "tb_customers", 0, 0);
        if(!empty($getcustomers)){
            foreach ($getcustomers as $res) {
                $cust_ids[] =$res['id'];
                $cust_arr[$res['id']] = array('id'=>$res['id'],'name'=>$res['name'],'email_id'=>$res['email_id'],'code'=>$res['code']);
            }
        }
        $orderTableCondition = $whr = array();
        $customerIdCondition = "";
        if(!empty($cust_ids)){
            $selectColumns = array('o.id,o.order_id,o.delivery_datetime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address2,o.delivery_address2,o.goods_value,o.transport_mode,o.customer_id,s.createdon as delivered_date,v.name as vendor_name,pod.doc_type,pod.imgpath,pod.receiver_name,pod.createdon as pod_available');
            $table_name='tb_orders o';
            $indexColumn='o.id';
            $groupBy='o.id';
            $excludeCountQuery='Yes';
            $cdate = date('Y-m-d H:i:s');
            $date  = $cdate;
            if($date != ""){
                $ddate = date( 'Y-m-d', strtotime( $date ) );
                $ydate =  date('Y-m-d',strtotime("-1 days"));
                $whr["DATE_FORMAT(pod.createdon,'%Y-%m-%d') >="] = $ydate;
			    $whr["DATE_FORMAT(pod.createdon,'%Y-%m-%d') <="] = $ddate;

            }
            if(!empty($whr)){
                foreach($whr as $key=>$value){
                    $value="'$value'";
                    $orderTableCondition[]= $key.$value;
                }
            }
            $orderTableCondition[]= "o.status!= 0";
            $orderTableCondition[]= "o.company_code LIKE 'AUKN'";
            $orderTableWhere= implode(' AND ',$orderTableCondition);
            if($orderTableWhere!=''){
                $orderTableWhere=" and $orderTableWhere ";
            }
            if(!empty($cust_ids) && sizeof($cust_ids)>0){
                $customerIdCondition= implode(',',$cust_ids);
                if($customerIdCondition!=''){
                    $orderTableWhere.=" and o.customer_id in ($customerIdCondition)";
                }
            }
            $wherecondition= $indexColumn."!='' ".$orderTableWhere;
            $dataTableSortOrdering=array();
            $joinsArray[]=array('table_name'=>'tb_stop_status as s','condition'=>"s.order_id=o.id AND s.status_code ='3000' AND s.status ='1'",'join_type'=>'left');
            $joinsArray[]=array('table_name'=>'tb_vendors as v','condition'=>"v.id=o.vendor_id AND v.status ='1'",'join_type'=>'left');
            $joinsArray[]=array('table_name'=>'tb_pod_uploads as pod','condition'=>"pod.order_id=o.id AND pod.doc_type ='3' AND pod.stop_type ='D' AND pod.status ='1'",'join_type'=>'inner');
            $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST');
            $reqData=array('id');
            $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
            if(isset($formattedData['commaSeparated']['id'])){
                $codes="'DQ','CTR','COI'";
                $multiple_codes = "'PO','LPC'";
                $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
                $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
                //$formattedData=$this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'],$formattedData);
                $formattedData=$this->DataQueryFormatter_model->getOrderReferenceMultipleData($formattedData['commaSeparated']['id'],$formattedData,$multiple_codes);
            }
            $getRecordListing=array();
            if(isset($formattedData['orders'])){
                $getRecordListing=$formattedData['orders'];
                krsort($getRecordListing);
            }
            $cdate = date('Y-m-d');

            if(!empty($getRecordListing)){
                foreach($getRecordListing as $res){
                    $delivery_date = $delivery_dtime = $est_del_date = $pod_available = $receiver_name = '';
                    if(isset($res['delivered_date'])){
                        $utcdelivery_date = $res['delivered_date'];
                        if ( $utcdelivery_date != "" && $utcdelivery_date != "0000-00-00 00:00:00" ) {
                            $d_date      = getdatetimebytimezone( $curtz, $utcdelivery_date, $default_timezone );
                            $delivery_date =  date('Y-m-d',strtotime($d_date['datetime']));
                            $delivery_dtime = date('Y-m-d H:i:s',strtotime($d_date['datetime']));
                        }
                    }
                    if (isset($res['pod_available'])) {
                        if ($res['pod_available'] != "" && $res['pod_available'] != "0000-00-00 00:00:00") {
                            $podavailable = getdatetimebytimezone($curtz, $res['pod_available'], $default_timezone);
                            $pod_available = date('Y-m-d h:i A', strtotime($podavailable['datetime']));
                            $podDate = date('Y-m-d', strtotime($podavailable['datetime']));
                            $receiver_name = $res['receiver_name'];
                        }
                    }
                    if($cdate == $podDate){
                        $store_code = $delivery_note = $container_no = $referenceData = $carrierservice = $multiple_referenceData = $purchase_order = $load_plan_connote = "";
                        if (isset($res['reference_value'])) {
                            $referenceData = $res['reference_value'];
                        }
                        $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                        if (isset($arrayData['DQ'])) {
                            $delivery_note = $arrayData['DQ'];
                        }
                        if (isset($arrayData['CTR'])) {
                            $container_no = $arrayData['CTR'];
                        }
                        if (isset($arrayData['COI'])) {
                            $store_code = $arrayData['COI'];
                        }
                        if (isset($res['multiple_reference_value'])) {
                            $multiple_referenceData = $res['multiple_reference_value'];
                        }
                        if($multiple_referenceData != ""){
                            $arrayData1 = $this->formatMultipleReferenceParameters($multiple_referenceData);
                            if(isset($arrayData1['PO'])){
                                if(!empty($arrayData1['PO'])){
                                    $purchase_order = implode(",",$arrayData1['PO']);
                                }
                            }
                            if(isset($arrayData1['LPC'])){
                                if(!empty($arrayData1['LPC'])){
                                    $load_plan_connote = implode(",",$arrayData1['LPC']);
                                }
                            }
                        }
                        $scanned_qty  = $res['scanned_quantity'];
                        $total_qty    = $res['totqty'];
                        $total_weight = $res['totwg'];
                        $total_volume = $res['totvolume'];
                        $customer_id = $res['customer_id'];
                        if ( $res['delivery_datetime'] != "" && $res['delivery_datetime'] != "0000-00-00 00:00:00" ) {
                            $estd_date      = getdatetimebytimezone( $curtz, $res['delivery_datetime'], $default_timezone );
                            $est_del_date  =  date('Y-m-d',strtotime($estd_date['datetime']));
                        }
                        $customer_code = isset($cust_arr[$customer_id]['code']) ? $cust_arr[$customer_id]['code'] : "";
                        $customer_name = isset($cust_arr[$customer_id]['name']) ? $cust_arr[$customer_id]['name'] : "";
                        $customer_email = isset($cust_arr[$customer_id]['email_id']) ? $cust_arr[$customer_id]['email_id'] : "";
                        if($load_plan_connote != ""){
                            $info = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'customer_code'=>$customer_code,'customer_email'=>$customer_email,'customer_name'=>$customer_name,'receiver_name'=>$receiver_name);
                            $lpc_data = $this->makesinglerowfor_lpc($info,$load_plan_connote);
                            if(!empty($lpc_data)){
                                $data = array_merge($data,$lpc_data);
                            }
                            $chk_customer[]= $customer_id;
                        }else{
                            if($purchase_order != ""){
                                $info = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'customer_code'=>$customer_code,'customer_email'=>$customer_email,'customer_name'=>$customer_name,'receiver_name'=>$receiver_name);
                                $po_data = $this->makesinglerowfor_porder($info,$purchase_order);
                                if(!empty($po_data)){
                                    $data = array_merge($data,$po_data);
                                }
                                $chk_customer[]= $customer_id;
                            }else{
                                $data[] = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'customer_code'=>$customer_code,'customer_email'=>$customer_email,'customer_name'=>$customer_name,'receiver_name'=>$receiver_name);
                                $chk_customer[]= $customer_id;
                            }
                        }
                    }
                }
            }
            foreach($cust_ids as $custid){
                if(!empty($data)){
                    if(in_array($custid,$chk_customer)){
                        $info = $this->downloadexceldata($data);
                        if($info['attachment'] != ""){
                            $this->sendmailtocust($info);
                        }
                    }else{
                        if(!empty($cust_arr)){
                            $customer_code = isset($cust_arr[$custid]['code']) ? $cust_arr[$custid]['code'] : "";
                            $customer_email = isset($cust_arr[$custid]['email_id']) ? $cust_arr[$custid]['email_id'] : "";
                            $customer_name = isset($cust_arr[$custid]['name']) ? $cust_arr[$custid]['name'] : "";
                            if($customer_email != ""){
                                $info = array('customer_code'=>$customer_code,'customer_email'=>$customer_email,'customer_name'=>$customer_name);
                                $this->sendmailwithnoinfo($info);
                            }

                        }
                    }
                }else{
                    if(!empty($cust_arr)){
                        $customer_code = isset($cust_arr[$custid]['code']) ? $cust_arr[$custid]['code'] : "";
                        $customer_email = isset($cust_arr[$custid]['email_id']) ? $cust_arr[$custid]['email_id'] : "";
                        $customer_name = isset($cust_arr[$custid]['name']) ? $cust_arr[$custid]['name'] : "";
                        if($customer_email != ""){
                            $info = array('customer_code'=>$customer_code,'customer_email'=>$customer_email,'customer_name'=>$customer_name);
                            $this->sendmailwithnoinfo($info);
                        }

                    }
                }
            }
        }
    }
    
    public function formatMultipleReferenceParameters($refData){
        $finalReqArray = array();
        $referenceDataArray = explode('?????', $refData);
        if (! empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            $i = 0;
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveArrayReferenceParameters($eachRefData);
                $key = $reqArray['type'];
                $value = $reqArray['value'];
                $finalReqArray[$key][] = $value;
                $i++;
            }
        }
        return $finalReqArray;
    }
    
    public function giveArrayReferenceParameters($referenceParam)
    {
        $finalArray = array();
        if (! empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (! empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray = array('type'=>trim($requiredArray[0]),'value'=>trim($requiredArray[1]));
            }
        }
        return $finalArray;
    }

    public function makesinglerowfor_lpc($info,$lpc){
        $load_plan_connote = $porder = $result = array();
        $porder_count = $lpc_count = 0;
        $purchase_order = $info['purchase_order'];
        if($purchase_order != ""){
            $porder = explode(',', $purchase_order);
        }
        if($lpc != ""){
            $load_plan_connote = explode(',', $lpc);
        }
        if(!empty($load_plan_connote)){
            $lpc_count = count($load_plan_connote);
        }
        if(!empty($porder)){
            $porder_count = count($porder);
        }
        $last_porder = "";
        if(!empty($load_plan_connote)){
            for ($i=0;$i<count($load_plan_connote);$i++) {

                $po = isset($porder[$i]) ? $porder[$i] : "";
                if($po != ""){
                    $last_porder = $po;
                }
                if($po == ""){
                    $po = $last_porder;
                }
                $result[] = array('order_id'=>$info['order_id'],'purchase_order'=>$po,'container_no'=>$info['container_no'],'load_plan_connote'=>$load_plan_connote[$i],'consignment_note'=>$info['consignment_note'],'goods_value'=>$info['goods_value'],'transport_mode'=>$info['transport_mode'],'shipper_name'=>$info['shipper_name'],'shipper_city'=>$info['shipper_city'],'shipper_state'=>$info['shipper_state'],'shipper_pincode'=>$info['shipper_pincode'],'consignee_name'=>$info['consignee_name'],'consignee_city'=>$info['consignee_city'],'consignee_state'=>$info['consignee_state'],'consignee_postaldate'=>$info['consignee_postaldate'],'store_code'=>$info['store_code'],'service_type'=>$info['service_type'],'goods_desc'=>'','total_pckgs'=>$info['total_pckgs'],'scanned'=>$info['scanned'],'weight'=>$info['weight'],'volume'=>$info['volume'],'vendor_name'=>$info['vendor_name'],'est_del_date'=>$info['est_del_date'],'delivery_date'=>$info['delivery_date'],'pod_available'=>$info['pod_available'],'customer_code'=>$info['customer_code'],'customer_email'=>$info['customer_email'],'customer_name'=>$info['customer_name'],'receiver_name'=>$info['receiver_name']);
            }

        }
        return $result;

    }
    
    public function makesinglerowfor_porder($info,$purchase_order){
        $porder = $result = array();
        if($purchase_order != ""){
            $porder = explode(',', $purchase_order);
        }
        if(!empty($porder)){
            for ($i=0;$i<count($porder);$i++) {
                $result[] = array('order_id'=>$info['order_id'],'purchase_order'=>$porder[$i],'container_no'=>$info['container_no'],'load_plan_connote'=>'','consignment_note'=>$info['consignment_note'],'goods_value'=>$info['goods_value'],'transport_mode'=>$info['transport_mode'],'shipper_name'=>$info['shipper_name'],'shipper_city'=>$info['shipper_city'],'shipper_state'=>$info['shipper_state'],'shipper_pincode'=>$info['shipper_pincode'],'consignee_name'=>$info['consignee_name'],'consignee_city'=>$info['consignee_city'],'consignee_state'=>$info['consignee_state'],'consignee_postaldate'=>$info['consignee_postaldate'],'store_code'=>$info['store_code'],'service_type'=>$info['service_type'],'goods_desc'=>'','total_pckgs'=>$info['total_pckgs'],'scanned'=>$info['scanned'],'weight'=>$info['weight'],'volume'=>$info['volume'],'vendor_name'=>$info['vendor_name'],'est_del_date'=>$info['est_del_date'],'delivery_date'=>$info['delivery_date'],'pod_available'=>$info['pod_available'],'customer_code'=>$info['customer_code'],'customer_email'=>$info['customer_email'],'customer_name'=>$info['customer_name'],'receiver_name'=>$info['receiver_name']);
            }
        }
        return $result;
    }

    public function sendmailwithnoinfo($data){
        $customer_name  = isset($data['customer_name']) ? $data['customer_name'] : "";
        $customer_email = isset($data['customer_email']) ? $data['customer_email'] : "";
        $this->load->library('email');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $rec_mail = $cc_mail = array();
        if(SYS_TYPE == 'TMS'){

            if($customer_name == "SUPER RETAIL GROUP SERVICES PTY LTD"){
                $rec_mail = array("ISRScanPackTeam@superretailgroup.com");
                /*$rec_mail = array("POManagement@superretailgroup.com","KayleenS@superretailgroup.com");*/
            }else{
                $rec_mail = array($customer_email);
            }
            $cc_mail = array("daniel.grote@kuehne-nagel.com","support@auroadlogistics.zendesk.com");
        }else{
            $cc_mail = array("external.gopikrishna.d@kuehne-nagel.com");
            $rec_mail = array("external.gopikrishna.d@kuehne-nagel.com");
        }
      
        echo $customer_name;
        echo "<br>";
        echo "Mail send with No Data : <br>";
        print_r($rec_mail);
        echo "<br>";
        if(!empty($rec_mail)){
            $this->email->to($rec_mail);
            $sub = date('Y-m-d')." : POD Report";
            $message  =  "Hi All,<br>";
            $message .= "No Data Available for - ".date('d-M')."<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            if(!empty($cc_mail)){
                $this->email->cc($cc_mail);
            }
            $this->email->subject($sub);
            $this->email->set_mailtype("html");
            $this->email->message($message);

            if(!$this->email->send()){
                log_message("error",$this->email->print_debugger());
            }

            $this->email->clear(true);
        }
    }
     
    public function sendmailtocust($data){
        $customer_name  = isset($data['customer_name']) ? $data['customer_name'] : "";
        $customer_email = isset($data['customer_email']) ? $data['customer_email'] : "";
        $customer_code  = isset($data['customer_code']) ? $data['customer_code'] : "";
        $this->load->library('email');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $rec_mail = $cc_mail = array();
        if(SYS_TYPE == 'TMS'){
            if($customer_name == "SUPER RETAIL GROUP SERVICES PTY LTD"){
                $rec_mail = array("ISRScanPackTeam@superretailgroup.com");
                /*$rec_mail = array("POManagement@superretailgroup.com","KayleenS@superretailgroup.com");*/
            }else{
                $rec_mail = array($customer_email);
            }
            $cc_mail = array("daniel.grote@kuehne-nagel.com","support@auroadlogistics.zendesk.com");
        }else{
            $rec_mail = array("external.gopikrishna.d@kuehne-nagel.com");
            $cc_mail = array("external.gopikrishna.d@kuehne-nagel.com");
        }
       /* $rec_mail = array("arimandasupriyareddy@gmail.com","veenayakkanti@gmail.com");
        $cc_mail = array("veenamadhuriy@gmail.com","krishnagopiweb@gmail.com");*/
        echo $customer_name;
        echo "<br>";
        echo "Mail send with Data : <br>";
        print_r($rec_mail);
        echo "<br>";
        if(!empty($rec_mail)){
            $this->email->to($rec_mail);
            $sub = date('Y-m-d')." : POD Report";
            $message  =  "Hi All,<br>";
            $message .= "Attached is the POD Report for ".date('d-M')."<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            if(!empty($cc_mail)){
                $this->email->cc($cc_mail);
            }
            $this->email->subject($sub);
            $this->email->set_mailtype("html");
            $this->email->message($message);
            $epodpath = sprintf('%s/%s', self::MAIL_ATTACHMENT_PATH, $data['attachment']);
            $this->email->attach($epodpath);

            if(!$this->email->send()){
                log_message("error",$this->email->print_debugger());
            }

            $this->email->clear(true);
        }
    }
    
    public function downloadexceldata($data){
        $fileName = "";
        if(!empty($data)){
            $customer_code  = isset($data[0]['customer_code']) ?$data[0]['customer_code'] : "";
            $customer_email = isset($data[0]['customer_email']) ?$data[0]['customer_email'] : "";
            $customer_name  = isset($data[0]['customer_name']) ?$data[0]['customer_name'] : "";
            $styleArray = array(
                    'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:Q1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '0c3b81')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Tracking Number');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Order Reference Number');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Container Number');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Load Plan Connote');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Consignment Note');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Goods Value');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Shipper Name');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Shipper State');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Consignee Name');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Consignee State');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Store Code');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Total Pkgs');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'weight');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Vendor Name');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'POD Available');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'Receiver Name');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);

            $rowCount = 2;

            foreach ($data as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['purchase_order']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['container_no']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['load_plan_connote']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['consignment_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['shipper_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['shipper_state']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['consignee_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['consignee_state']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['store_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['total_pckgs']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['delivery_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['pod_available']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['receiver_name']);
                $rowCount++;
            }
            $fileName =strtoupper($customer_name).'-POD-Report-'. date("d-M").'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if(!file_exists(self::MAIL_ATTACHMENT_PATH)){
                mkdir($concurrentDirectory = self::MAIL_ATTACHMENT_PATH, 0710, true);
            }
            $objWriter->save(str_replace(__FILE__,self::MAIL_ATTACHMENT_PATH . '/'.$fileName,__FILE__));
        }
        $attachment = $fileName;
        $info = array('attachment'=>$fileName,'customer_name'=>$customer_name,'customer_email'=>$customer_email,'customer_code'=>$customer_code);
        return $info;
    }

}

?>
