<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Geocity extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->library('form_validation');
        $this->load->model(["Geocitymodel", "common", "Ordertypemodel"]);
        if (!checkUrlAccessForUser('GEOCITY')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
        $data["page_title"] = $this->lang->line('city_info');
        $data["sub_title"] = $this->lang->line('general_search');
        $post = $this->input->post(null, true);

        if (isset($post['searchsubmit']) && $post['searchsubmit'] == "Search") {
            $idInput = $this->input->post('name1');
            $nameInput = $this->input->post('name2');
            $codeInput = $this->input->post('name3');
            $where1 = $whr = [];
            if (isset($idInput) && $idInput != "") {
                $where1['tt.city_id'] = $idInput;
            }
            if (isset($nameInput) && $nameInput != "") {
                $where1['tt.city_name'] = $nameInput;
            }
            if (isset($codeInput) && $codeInput != "") {
                $where1['tt.province_code'] = $codeInput;
            }
            $data['inputList'] = $this->Geocitymodel->getsearchdata($where1, $whr);

            $this->newtemplate->dashboard("geocity/index", $data);
        } elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {
            $idInput2 = $this->input->post('names1');
            $nameInput2 = $this->input->post('names2');
            $codeInput2 = $this->input->post('names3');
            $status = $this->input->post('status2');
            $countryInput2 = $this->input->post('names4');
            $where1 = $whr = [];
            if (isset($idInput2) && $idInput2 != "") {
                $where1['tt.city_id'] = $idInput2;
            }
            if (isset($nameInput2) && $nameInput2 != "") {
                $where1['tt.city_name'] = $nameInput2;
            }
            if (isset($codeInput2) && $codeInput2 != "") {
                $where1['tt.province_code'] = $codeInput2;
            }
            if (isset($status) && $status != "") {
                $where1['tt.status'] = $status;
            }
            if (isset($countryInput2) && $countryInput2 != "") {
                $where1['tt.country_code'] = $countryInput2;
            }
            $data['inputList'] = $this->Geocitymodel->getsearchdata($where1, $whr);
            $this->newtemplate->dashboard("geocity/index", $data);
        } else {
            $whr = $where = [];
            $data['inputList'] = $this->Geocitymodel->getsearchdata($where, $whr);
            $this->newtemplate->dashboard("geocity/index", $data);
        }
    }

    public function add(): void
    {
        $whr = $whr1 = [];
        $data["page_title"] = $this->lang->line('city_info');
        $data["sub_title"] = $this->lang->line('general_add');
        $countryList = $this->Ordertypemodel->selectlist('country_name,country_code', 'tbl_country_master', $whr, 'country_name');
        $data['countryList'] = $countryList;
        $companyCode = $this->Ordertypemodel->selectlist('id,company_code', 'tb_company_master', $whr1, 'company_code');
        $data['companyCode'] = $companyCode;
        $this->newtemplate->dashboard("geocity/add", $data);
    }

    public function save(): void
    {
        $post = $this->input->post(null, true);
        extract($post);
        $cityId = $cityId ?? "";
        $cityName = $cityName ?? "";
        $companyCode = $companyCode ?? "";
        $cityCode = $cityCode ?? "";
        $cityCountry = $cityCountry ?? "";
        $branchCode = $branchCode ?? "";
        $provinceCode = $provinceCode ?? "";
        $status2 = $status2 ?? "";
        $data = [
            'city_name' => $cityName,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'province_code' => $provinceCode,
        ];
        $table = 'tb_geo_cities';
        $result1 = $this->common->gettblrowdata($data, 'id', $table, 0, 0);

        if (!empty($result1)) {
            $result = 0;
            echo json_encode($result);
        } else {
            $data['city_id'] = $cityId;
            $data['city_iso_code'] = $cityCode;
            $data['country_code'] = $cityCountry;
            $data['status'] = $status2;
            $result = $this->common->insertTableData($table, $data);
            echo json_encode($result);
        }
    }

    public function view(int $id): void
    {
        $data["page_title"] = $this->lang->line('city_info');
        $data["sub_title"] = $this->lang->line('general_view');
        $data['cityType'] = $this->Geocitymodel->viewdata($id);
        $this->newtemplate->dashboard('geocity/view', $data);
    }

    public function update(): void
    {
        $id = $this->input->post('id', true);
        if (isset($id)) {
            $post = $this->input->post(null, true);
            extract($post);
            $cityId = $cityId ?? "";
            $cityName = $cityName ?? "";
            $companyCode = $companyCode ?? "";
            $cityCode = $cityCode ?? "";
            $cityCountry = $cityCountry ?? "";
            $branchCode = $branchCode ?? "";
            $provinceCode = $provinceCode ?? "";
            $status2 = $status2 ?? "";

            $data = [
                'city_id' => $cityId,
                'city_name' => $cityName,
                'company_code' => $companyCode,
                'city_iso_code' => $cityCode,
                'country_code' => $cityCountry,
                'branch_code' => $branchCode,
                'province_code' => $provinceCode,
                'status' => $status2
            ];
            $table = 'tb_geo_cities';
            $whr = [
                'id' => $id
            ];
            $result = $this->common->updatetbledata($table, $data, $whr);
            echo json_encode($result);
        }
    }

    public function edit(int $id): void
    {
        $whr = $whr1 = $whr2 = $whr3 = [];
        $data["page_title"] = $this->lang->line('city_info');
        $data["sub_title"] = $this->lang->line('general_edit');
        $data['cityType'] = $this->Geocitymodel->editdata($id);
        $countryList = $this->Ordertypemodel->selectlist('country_name,country_code', 'tbl_country_master', $whr, 'country_name');
        $data['countryList'] = $countryList;
        $provinceCode = $this->Ordertypemodel->selectlist('id,province_iso_code', 'tb_geo_provinces', $whr1, 'province_iso_code');
        $data['provinceCode'] = $provinceCode;
        $companyCode = $this->Ordertypemodel->selectlist('id,company_code', 'tb_company_master', $whr2, 'company_code');
        $data['companyCode'] = $companyCode;
        $branchCode = $this->Ordertypemodel->selectlist('id,branch_code', 'tb_branch_master', $whr3, 'branch_code');
        $data['branchCode'] = $branchCode;
        $this->newtemplate->dashboard('geocity/edit', $data);
    }

    public function delete(int $id): void
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_geo_cities');
            echo $result ? 1 : 0;
        }
    }

    public function fetchProvinceCode(): void
    {
        $post = $this->input->post(null, true);
        $cityCountry = $post['cityCountry'];
        $getProvinceCode = $this->Geocitymodel->selectprovince($cityCountry);
        $option = '';
        foreach ($getProvinceCode as $row) {
            $option .= '<option value="' . $row['province_iso_code'] . '">' . $row['province_iso_code'] . '</option>';
        }
        $result['provinces'] = $option;
        echo json_encode($result);
    }

    public function fetchBranchCode(): void
    {
        $post = $this->input->post(null, true);
        $companyCode = $post['companyCode'];
        $getBranchCode = $this->Geocitymodel->selectBranchCodes($companyCode);
        $option = '';
        foreach ($getBranchCode as $row) {
            $option .= '<option value="' . $row['branch_code'] . '">' . $row['branch_code'] . '</option>';
        }
        $result['branches'] = $option;
        echo json_encode($result);
    }

    public function getRandomId(): void
    {
        $lastGenId = $this->Geocitymodel->generateRandomId();
        $generatedId = "GC" . Date('y') . date("W") . $lastGenId;
        $result['generatedId'] = $generatedId;
        echo json_encode($result);
    }
}
