<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class Inbasicshipmentreport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('inaquaticamodel');
        $this->load->model('common');
        if (!checkUrlAccessForUser('INBASICSHIPMENTREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $this->getsearchresult();
    }

    public function getsearchresult()
    {
        $business_type = $this->session->userdata('business_type');
        if ($business_type == 'Carrier') {
            redirect('/');
        }
        $custid = "";
        $data['page_title'] = $this->lang->line('basic_shipment');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $userid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if (! empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $aquorder = $country_userids = $whr = $post = $where = $other_checks = $wherein = $subcusts = $general_array = array();
        $cntryids = $this->session->userdata("country_user_ids");
        if (! empty($cntryids) && ($cntryids != null) && (count($cntryids) > 0)) {
            $country_userids = $cntryids;
        }
        $status_search = "";
        $where = array(
            "user_id" => $userid,
            "status" => 1
        );
        $select = "id,name";
        $table = "tb_vendors";
        $carrierlist = $this->common->gettbldata($where, $select, $table, 0, 0);
        $data['carrierlist'] = $carrierlist;
        $aqucarrier = isset($_POST['aqucarrier']) ? $_POST['aqucarrier'] : array();
        $data['aqucarrierid'] = $aqucarrier;
        $aqucarrierid_adv = isset($_POST['aqucarrierid_adv']) ? $_POST['aqucarrierid_adv'] : array();
        $data['aqucarrierid_adv'] = $aqucarrierid_adv;
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }
        if (! empty($post)) {
            $whr = $this->searchorders($post);
            $order_status = isset($post['aquordtype']) ? $post['aquordtype'] : "";
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : "";
            if (isset($post['aqucarrier']) && $post['aqucarrier'] != array()) {
                $wherein['vendor_id'] = $post['aqucarrier'];
            }
            if (isset($post['aqucarrierid_adv']) && $post['aqucarrierid_adv'] != array()) {
                $wherein['vendor_id'] = $post['aqucarrierid_adv'];
            }
            if (! empty($order_status)) {
                $status_search = $order_status;
            }
            if (! empty($ad_orderstatus)) {
                $status_search = $ad_orderstatus;
            }
            $other_checks['status_search'] = $status_search;
            if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
                $other_checks['shipper_name'] = $post['shipper_name'];
            }
            if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
                $other_checks['consignee_name'] = $post['consignee_name'];
            }
            if (isset($post['lr_number']) && $post['lr_number'] != "") {
                $other_checks['lr_number'] = $post['lr_number'];
            }
            if (isset($post['customer_reference_number']) && $post['customer_reference_number'] != "") {
                $other_checks['customer_reference_number'] = $post['customer_reference_number'];
            }
            if (isset($post['qbook_pickupdatetime']) && $post['qbook_pickupdatetime'] != "") {
                $other_checks['qbook_pickupdatetime'] = $post['qbook_pickupdatetime'];
            }
            if ($business_type == "Customer") {
                $userid = 0;
            }
            if (! empty($custid)) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (! empty($subcusts)) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = array(
                            $custid
                        );
                    }
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            }
            $general_array = [
                'userid' => $userid,
                'custid' => $custid,
                'business_type' => $business_type,
                'country_userids' => $country_userids,
                'subcusts' => $subcusts
            ];
            $orderdata = $this->inaquaticamodel->getorderdata($whr, $wherein, $other_checks, $general_array);
            if (! empty($orderdata)) {
                foreach ($orderdata as $res) {
                    $qry = $this->db->query("SELECT cargo_content FROM tb_order_cargodetails WHERE order_id ='" . $res['id'] . "' AND status='1'");
                    $cargo_content = '';
                    $title = "";
                    if ($qry->num_rows() > 0) {
                        foreach ($qry->result() as $row) {
                            if ($row->cargo_content != '') {
                                $out = strlen($row->cargo_content) > 10 ? substr($row->cargo_content, 0, 5) . "..." : $row->cargo_content;
                                $cargo_content .= $out . ',';
                                $title .= $row->cargo_content . ',';
                            } else {
                                $cargo_content = '';
                            }
                        }
                    }
                    $cargo_content = rtrim($cargo_content, ',');
                    $title = rtrim($title, ',');
                    $cargo_content_arr = [];
                    $cargo_content_arr = explode(',', $cargo_content);
                    $array_tmp = $array_new = [];
                    foreach ($cargo_content_arr as $k => $v) {
                        $index = $v;
                        $array_tmp[$index][] = $v;
                    }
                    foreach ($array_tmp as $k => $v) {
                        if (count($v) > 1) {
                            foreach ($v as $k2 => $v2) {
                                $array_new[] = $v2;
                            }
                        }
                    }
                    if (count($array_new)) {
                        $get_cargo_content = $array_new[0];
                        if (in_array($get_cargo_content, $cargo_content_arr)) {
                            $key_value = array_search($get_cargo_content, $cargo_content_arr);
                            unset($cargo_content_arr[$key_value]);
                        }
                    }
                    $final_cargo_content_str = implode(',', $cargo_content_arr);
                    $carrier_name = '';
                    if ($res['vendor_id'] != "") {
                        $truckinfo = $this->db->query("SELECT name FROM tb_vendors WHERE id='" . $res['vendor_id'] . "'");
                        if ($truckinfo->num_rows() > 0) {
                            $carrier_name = $truckinfo->row()->name;
                        }
                    }
                    $cust_reference_num = $lr_num = '';

                    $refs = $this->inaquaticamodel->getreferenceorderdetails($res['id'], array(
                        'BN',
                        'PO',
                        'DQ'
                    ));
                    // log_message("error",$this->db->last_query());
                    if ($refs->num_rows() > 0) {
                        foreach ($refs->result() as $rf) {
                            if ($business_type == 'Customer' && $rf->reference_id == 'BN') {
                                $lr_num = $rf->ref_value;
                            } else if ($rf->reference_id == 'PO') {
                                $lr_num = $rf->ref_value;
                            }
                            if ($rf->reference_id == 'DQ') {
                                $cust_reference_num = $rf->ref_value;
                            }
                        }
                    }
                    $getpickupdateils = $this->inaquaticamodel->getpickupshipdateils($res['order_id'], $status_id = 10);
                    if ($getpickupdateils->num_rows() > 0) {
                        $date = '0000-00-00 00:00:00';
                        $createdon = $getpickupdateils->row()->createdon;
                        $estimate_d_date = $getpickupdateils->row()->estimate_d_date;
                        if (($createdon != $date) && ($createdon != null)) {
                            $pickup_date = date("d M Y", strtotime($createdon));
                        } else {
                            $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        }
                        if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                            $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                        } else {
                            $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                        }
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }
                    $shift_id = $res['shift_id'];
                    /**
                     * get last status,delviery date,delivery date,location *
                     */
                    $last_status_name = $last_loc = $delivery_date = $delivery_status = "";
                    if ($shift_id != 0) {
                        $get_laststatusinfo = $this->inaquaticamodel->getlaststoptransdetails($res['order_id'], $shift_id);

                        $delivery_status = "Not Delivered";
                        if ($res['trip_sts'] == 1) {
                            $last_status_name = "Delivered";
                            $delivery_status = "Delivered";
                        }
                        if ($get_laststatusinfo->num_rows() > 0) {
                            $last_status_name = $get_laststatusinfo->row()->status_name;
                            if ($get_laststatusinfo->row()->stop_type == "P") {
                                $last_status_name = "Pickedup";
                            }
                            /*
                             * if (($last_status_name == "Delivered to Consignee") || ($get_laststatusinfo->row()->stop_type = "D")) {
                             * $delivery_date = $get_laststatusinfo->row()->createdon;
                             * $last_status_name = "Delivered";
                             * } else {
                             * if ($get_laststatusinfo->row()->stop_type == "P") {
                             * $last_status_name = "Pickedup";
                             * } else if ($get_laststatusinfo->row()->stop_type == "D") {
                             * $last_status_name = "Delivered";
                             * }
                             * }
                             */
                            if ($company_code == "AUKN") {
                               $last_status_name = $get_laststatusinfo->row()->status_name;
							   $delivery_date="";
                            }
                            if ($delivery_date == "") {
                                $status_code = $get_laststatusinfo->row()->status_code;
                                $stop_type = $get_laststatusinfo->row()->stop_type;
                                $status_id = $get_laststatusinfo->row()->status_id;

                                if ($status_code == '3000' && $stop_type == 'D') {
                                    if ($company_code == "AUKN") {
                                        $last_status_name = "Delivered";
                                    }
                                    $d_time = getEDAofNZShipmentbyord($res['id']);
                                    $d_date = $d_time['time'];
                                    $delivery_status = "Delivered";
                                    if (isset($d_date) && $d_date != "") {
                                        $date = '0000-00-00 00:00:00';
                                        if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                            $delivery_date = date("d M Y", strtotime($d_date));
                                        } else {
                                            $delivery_date = "";
                                        }
                                    }
                                    if ($company_code == "AUKN" && empty($delivery_date)) {

                                        $d_createdon = $get_laststatusinfo->row()->createdon;
                                        if (isset($d_createdon) && ! empty($d_createdon)) {

                                            if (($d_createdon != $date) || (strtotime($d_createdon) > 0)) {
                                                $delivery_date = date("d M Y", strtotime($d_createdon));
                                            } else {
                                                $delivery_date = "";
                                            }
                                        }
                                    }
                                }
                            }
                            if ($get_laststatusinfo->row()->loc_name != null) {
                                $last_loc = $get_laststatusinfo->row()->loc_name;
                            } else {
                                $lat = $get_laststatusinfo->row()->latitude;
                                $lng = $get_laststatusinfo->row()->longitude;
                                $last_loc = getLocationName($lat, $lng);
                            }
                        }
                    }

                    $shipmentid = $res['shipmentid'];
                    $sid = 0;
                    $stops_arr = [];

                    /**
                     * get live track link *
                     */
                    if (! empty($shipmentid)) {
                        $sql3 = $this->db->query("select id from tb_shifts where status = 1 and shipmentid = '$shipmentid' and status='1' and user_id='$userid' GROUP BY id ORDER BY id DESC");
                        // log_message("error",$this->db->last_query());
                        if ($sql3->num_rows() > 0) {
                            $sid = $sql3->row()->id;
                            $stops = $this->db->query("SELECT id from tb_shiporder_stops WHERE status = '1' AND shipment_id=" . $sid . " ORDER BY ordernumber ASC");
                            // log_message("error",$this->db->last_query());
                            if ($stops->num_rows() > 0) {
                                $stops_arr = $stops->result_array();
                            }
                        }
                    }
                    /* get container number */
                    $container_num = $this->getrefnum($res['id'], "CTR");
                    /* get ASN reference order number */
                    $ref_order_num = $this->getrefordernum($res['id']);
                    /* get Store code */
                    $store_code = $this->getrefnum($res['id'], "COI");
                    $carrierservice = "";
                    if ($company_code == "AUKN") {
                        $this->load->helper('border_helper');
                        $vendor_res = checkborderCarrier($res['vendor_id']);
                        if (! empty($vendor_res)) {
                            if ($res['totqty'] < 20) {
                                $carrierservice = "BORDER PALLETS";
                            } else {
                                $carrierservice = "BORDER  BULK";
                            }
                        }
                    }

                    $aquorder[] = array(
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'pieces' => $res['totqty'],
                        'weight' => $res['totwg'],
                        'volumetric_weight' => $res['volumetric_weight'],
                        'goods_desc' => $final_cargo_content_str,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'carriername' => $carrier_name,
                        'shipper_address' => $res['pickup'],
                        'shipper_city' => $res['pickup_city'],
                        'consignee_address' => $res['delivery'],
                        'consignee_city' => $res['delivery_city'],
                        'pickup_date' => $pickup_date,
                        'estimate_d_date' => $estimate_de_date,
                        'delivery_date' => $delivery_date,
                        'cust_reference_num' => $cust_reference_num,
                        'lr_num' => $lr_num,
                        'goods_value' => $res['goods_value'],
                        'transport_mode' => $res['transport_mode'],
                        'delivery_status' => $delivery_status,
                        'last_status_name' => $last_status_name,
                        'last_loc' => $last_loc,
                        'title' => $title,
                        'stops_arr' => $stops_arr,
                        'shipmentid' => $shipmentid,
                        'sid' => $sid,
                        'volume' => $res['totvolume'],
                        'consignment_note' => $res['consignment_note'],
                        'container_num' => $container_num,
                        'ref_order_num' => $ref_order_num,
                        'scanned_quantity' => $res['scanned_quantity'],
                        'shipper_state' => $res['shipper_state'],
                        'consignee_state' => $res['consignee_state'],
                        'delivery_pincode' => $res['delivery_pincode'],
                        'store_code' => $store_code,
                        'service_type' => $carrierservice
                    );
                }
            }
        }
        $data['aquorder'] = $aquorder;
        // print_r($aquorder);die();
        $this->newtemplate->dashboard("inreportshipment/index", $data);
    }

    /* get reference number */
    private function getrefnum($id, $ref_id)
    {
        $ref_num = "";
        $res = $this->common->gettblrowdata(array(
            'order_id' => $id,
            'reference_id' => $ref_id,
            'status' => 1
        ), 'ref_value', 'tb_order_references', 0, 0);
        if (! empty($res)) {
            $ref_num = (! empty($res['ref_value'])) ? $res['ref_value'] : "";
        }
        return $ref_num;
    }

    /* get ASN reference order number */
    public function getrefordernum($id)
    {
        $ref_order_num = "";
        $this->load->model('inaquaticamodel');
        $whr = array(
            'c.order_id' => $id,
            'i.status' => 1,
            'c.status' => 1
        );
        /* log_message('error',"where::->".json_encode($whr)); */
        $res = $this->inaquaticamodel->getaurefnums($whr);
        /*
         * //$this->common->gettbldata(array('order_id'=>$id,'status'=>1),'reference_order_num','tb_order_cargodetails',0,0);
         * log_message('error',$this->db->last_query());
         */
        if (! empty($res)) {
            $res = array_column($res, 'ref_order_num');
            $res = array_unique($res);
            $ref_ordernum = implode(" , ", $res);
            $ref_order_num = (! empty($ref_ordernum)) ? $ref_ordernum : "";
        }
        return $ref_order_num;
    }

    public function searchorders($post)
    {
        $whr = array();
        $user_id = $this->session->userdata('user_id');
        if (isset($post['aqufromdate']) && $post['aqufromdate'] != "") {
            $aqufromdate = date('Y-m-d', strtotime($post['aqufromdate']));
            $whr["DATE(o.createdon) >="] = $aqufromdate;
        }

        if (isset($post['aqutodate']) && $post['aqutodate'] != "") {
            $todate = date('Y-m-d', strtotime($post['aqutodate']));
            $whr["DATE(o.createdon) <="] = $todate;
        }

        if (isset($post['booking_id']) && $post['booking_id'] != "") {
            $whr['o.order_id'] = $post['booking_id'];
        }

        if (isset($post['consignee_name']) && $post['consignee_name'] != "") {
            $c = $post['consignee_name'];
            $getconsinee = $this->db->query("SELECT code,party_type_id from `tbl_party_master` where user_id='$user_id' and status = '1' and (name LIKE '%" . $c . "%' OR mobile LIKE '%" . $c . "%' OR code LIKE '%" . $c . "%')");
            if ($getconsinee->num_rows() > 0) {
                $code = $getconsinee->row()->code;
                $whr['o.pickup_custid'] = $code;
            }
        }

        if (isset($post['shipper_name']) && $post['shipper_name'] != "") {
            $s = $post['shipper_name'];
            $getshipper = $this->db->query("SELECT code,party_type_id from `tbl_party_master` where user_id='$user_id' and status = '1' and (name LIKE '%" . $s . "%' OR mobile LIKE '%" . $s . "%' OR code LIKE '%" . $s . "%')");
            if ($getshipper->num_rows() > 0) {

                $code = $getshipper->row()->code;
                $whr['o.drop_custid'] = $code;
            }
        }

        return $whr;
    }

    public function getbookingid()
    {
        $uid = $this->session->userdata('user_id');
        $custid = "";
        $country_userids = array();
        $cntryids = $this->session->userdata("country_user_ids");
        if (! empty($cntryids) && ($cntryids != null) && (count($cntryids) > 0)) {
            $country_userids = $cntryids;
        }
        $business_type = $this->session->userdata('business_type');
        if (! empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $booking_id = isset($_REQUEST["booking_id"]) ? $_REQUEST["booking_id"] : "";
        $booking_id = trim($booking_id);
        $data = $subcusts = array();
        $where = "";
        if ($business_type == "Customer") {
            $uid = 0;
        }
        if ($uid != '0') {
            if (! empty($country_userids)) {
                $where = "and user_id in ($country_userids)";
            } else {
                $where = "and user_id = '$uid'";
            }
        }
        if (! empty($custid)) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (! empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            } else {
                $subcusts = array(
                    $custid
                );
            }
        }
        if (! empty($subcusts)) {
            $subcusts = implode(',', $subcusts);
            $where = "and customer_id in ($subcusts)";
        } else {
            if ($custid != "") {
                $where = "and customer_id = '$custid'";
            }
        }
        $get_data = $this->db->query("SELECT order_id FROM tb_orders  WHERE order_id like '%$booking_id%' $where and STATUS != 0");
        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->order_id;
            }
        }
        echo json_encode($data);
    }

    public function getrefdetails()
    {
        $uid = $this->session->userdata('user_id');
        $custid = "";
        $country_userids = array();
        $cntryids = $this->session->userdata("country_user_ids");
        if (! empty($cntryids) && ($cntryids != null) && (count($cntryids) > 0)) {
            $country_userids = $cntryids;
        }
        if (! empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $business_type = $this->session->userdata('business_type');
        $lr_number = isset($_REQUEST["lr_number"]) ? $_REQUEST["lr_number"] : "";
        $lr_numer = trim($lr_number);
        $customer_reference_number = isset($_REQUEST["customer_reference_number"]) ? $_REQUEST["customer_reference_number"] : "";
        $customer_reference_number = trim($customer_reference_number);
        $data = $subcusts = array();
        $like = $where = $where1 = "";
        if ($business_type == "Customer") {
            $uid = 0;
        }
        if ($lr_number) {
            $like = $lr_number;
            // customer
            if ($business_type == "Customer") {
                $where = "and r.reference_id = 'BN'";
            } else {
                // admin
                $where = "and r.reference_id = 'PO'";
            }
        }
        if ($customer_reference_number) {
            $like = $customer_reference_number;
            $where = "and r.reference_id = 'DQ'";
        }
        if ($uid != '0') {
            if (! empty($country_userids)) {
                $where1 = "and user_id in ($country_userids)";
            } else {
                $where1 = "and user_id = '$uid'";
            }
        }
        if (! empty($custid)) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (! empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            } else {
                $subcusts = array(
                    $custid
                );
            }
        }
        if (! empty($subcusts)) {
            $subcusts = implode(',', $subcusts);
            $where1 = "and customer_id in ($subcusts)";
        } else {
            if ($custid != "") {
                $where1 = "and customer_id = '$custid'";
            }
        }
        $get_data = $this->db->query("SELECT r.ref_value FROM tb_order_references r,tb_orders o WHERE r.ref_value like '%$like%' $where and r.status='1' AND o.status!=0 and r.order_id=o.id $where1");
        if ($get_data->num_rows() > 0) {
            foreach ($get_data->result() as $get_data_f) {
                $data[] = $get_data_f->ref_value;
            }
        }
        echo json_encode($data);
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $whr = "";
        if ($ordid > 0) {
            $whr = " AND ts.order_id=$ordid ";
        }
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(array(
            "id" => $ordid
        ), "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (count($tripinfo) > 0) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data['ord_type'] = $this->input->post("type");
            $shift_id = $tripinfo['shift_id'];
            $data['ship_id'] = isset($tripinfo['shift_id']) ? $tripinfo['shift_id'] : 0;
            $data['trip_id'] = isset($tripinfo['trip_id']) ? $tripinfo['trip_id'] : 0;
            $sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.shipment_id = $shift_id $whr AND dt.type_name='POD' GROUP BY ts.id");
            $data["pod"] = $sql1;
            echo $this->load->view("inreportshipment/managedocuments", $data, TRUE);
        }
    }

    public function export_excel()
    {
        ini_set("memory_limit", "256M");
        $data['page_title'] = 'Basicshipmentreport';
        $data['sub_title'] = 'Reports';
        $business_type = $this->session->userdata('business_type');
        $inputdt = $this->input->post();

        $custid = $status_search = "";
        $userid = $this->session->userdata("user_id");
        if (! empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $aquorder = $country_userids = $subcusts = $general_array = $other_checks = $post_array = $whr = $wherein = array();
        $cntryids = $this->session->userdata("country_user_ids");
        if (! empty($cntryids) && ($cntryids != null) && (count($cntryids) > 0)) {
            $country_userids = $cntryids;
        }
        if ($business_type == "Customer") {
            $userid = 0;
        }
        if (! empty($custid)) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (! empty($subcusts)) {
                    array_push($subcusts, $custid);
                } else {
                    $subcusts = array(
                        $custid
                    );
                }
            } else {
                $subcusts = array(
                    $custid
                );
            }
        }
        $general_array = [
            'userid' => $userid,
            'custid' => $custid,
            'business_type' => $business_type,
            'country_userids' => $country_userids,
            'subcusts' => $subcusts
        ];
        if (count(array_filter($inputdt)) > 0) {
            if (isset($inputdt['fromDatesearch']) && ! empty($inputdt['fromDatesearch'])) {
                $post_array['aqufromdate'] = $inputdt['fromDatesearch'];
            }
            if (isset($inputdt['toDatesearch']) && ! empty($inputdt['toDatesearch'])) {
                $post_array['aqutodate'] = $inputdt['toDatesearch'];
            }
            if (isset($inputdt['booking_idSearch']) && ! empty($inputdt['booking_idSearch'])) {
                $post_array['booking_id'] = $inputdt['booking_idSearch'];
            }
            $order_status = isset($inputdt['selectstatusSearch']) ? $inputdt['selectstatusSearch'] : "";
            $ad_orderstatus = isset($inputdt['advstatusSearch']) ? $inputdt['advstatusSearch'] : "";
            if (isset($inputdt['carrieridSearch']) && $inputdt['carrieridSearch'] != '') {
                $wherein['vendor_id'] = explode(',', $inputdt['carrieridSearch']);
            }
            if (isset($inputdt['advcarrieridSearch']) && $inputdt['advcarrieridSearch'] != "") {
                $wherein['vendor_id'] = explode(',', $inputdt['advcarrieridSearch']);
            }
            if (! empty($order_status)) {
                $status_search = $order_status;
            }
            if (! empty($ad_orderstatus)) {
                $status_search = $ad_orderstatus;
            }
            $other_checks['status_search'] = $status_search;
            if (isset($inputdt['shipper_name_Search']) && $inputdt['shipper_name_Search'] != "") {
                $other_checks['shipper_name'] = $inputdt['shipper_name_Search'];
            }
            if (isset($inputdt['consignee_name_Search']) && $inputdt['consignee_name_Search'] != "") {
                $other_checks['consignee_name'] = $inputdt['consignee_name_Search'];
            }
            if (isset($inputdt['lr_numberSearch']) && $inputdt['lr_numberSearch'] != "") {
                $other_checks['lr_number'] = $inputdt['lr_numberSearch'];
            }
            if (isset($inputdt['cust_refSearch']) && $inputdt['cust_refSearch'] != "") {
                $other_checks['customer_reference_number'] = $inputdt['cust_refSearch'];
            }
            if (isset($inputdt['pickupdate_Search']) && $inputdt['pickupdate_Search'] != "") {
                $other_checks['qbook_pickupdatetime'] = $inputdt['pickupdate_Search'];
            }
            $whr = $this->searchorders($post_array);
            $orderdata = $this->inaquaticamodel->getorderdata($whr, $wherein, $other_checks, $general_array);
            if (! empty($orderdata)) {
                foreach ($orderdata as $res) {
                    $qry = $this->db->query("SELECT o.cargo_content FROM tb_order_cargodetails o WHERE o.order_id ='" . $res['id'] . "' AND o.status='1'");
                    $cargo_content = '';
                    $title = "";
                    if ($qry->num_rows() > 0) {
                        foreach ($qry->result() as $row) {
                            if ($row->cargo_content != '') {
                                $out = strlen($row->cargo_content) > 10 ? substr($row->cargo_content, 0, 5) . "..." : $row->cargo_content;
                                $cargo_content .= $out . ',';
                                $title .= $row->cargo_content . ',';
                            } else {
                                $cargo_content = '';
                            }
                        }
                    }
                    $cargo_content = rtrim($cargo_content, ',');
                    $title = rtrim($title, ',');
                    $cargo_content_arr = [];
                    $cargo_content_arr = explode(',', $cargo_content);
                    $array_tmp = $array_new = [];
                    foreach ($cargo_content_arr as $k => $v) {
                        $index = $v;
                        $array_tmp[$index][] = $v;
                    }
                    foreach ($array_tmp as $k => $v) {
                        if (count($v) > 1) {
                            foreach ($v as $k2 => $v2) {
                                $array_new[] = $v2;
                            }
                        }
                    }
                    if (count($array_new)) {
                        $get_cargo_content = $array_new[0];
                        if (in_array($get_cargo_content, $cargo_content_arr)) {
                            $key_value = array_search($get_cargo_content, $cargo_content_arr);
                            unset($cargo_content_arr[$key_value]);
                        }
                    }
                    $final_cargo_content_str = implode(',', $cargo_content_arr);
                    $carrier_name = '';
                    $truckinfo = $this->db->query("SELECT v.name FROM tb_vendors v,tb_employee e WHERE e.order_id ='" . $res['order_id'] . "' AND e.vendor_id=v.id and v.id='" . $res['vendor_id'] . "'");
                    if ($truckinfo->num_rows() > 0) {
                        $carrier_name = $truckinfo->row()->name;
                    }
                    $cust_reference_num = $lr_num = '';
                    // customer
                    $refs = $this->inaquaticamodel->getreferenceorderdetails($res['id'], array(
                        'BN',
                        'PO',
                        'DQ'
                    ));
                    if ($refs->num_rows() > 0) {
                        foreach ($refs->result() as $rf) {
                            if ($business_type == 'Customer' && $rf->reference_id == 'BN') {
                                $lr_num = $rf->ref_value;
                            } else if ($rf->reference_id == 'PO') {
                                $lr_num = $rf->ref_value;
                            }
                            if ($rf->reference_id == 'DQ') {
                                $cust_reference_num = $rf->ref_value;
                            }
                        }
                    }
                    $getpickupdateils = $this->inaquaticamodel->getpickupshipdateils($res['order_id'], $status_id = 10);
                    if ($getpickupdateils->num_rows() > 0) {
                        $date = '0000-00-00 00:00:00';
                        $createdon = $getpickupdateils->row()->createdon;

                        $estimate_d_date = $getpickupdateils->row()->estimate_d_date;
                        if (($createdon != $date) && ($createdon != null)) {
                            $pickup_date = date("d M Y", strtotime($createdon));
                        } else {
                            $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        }
                        if (($estimate_d_date != $date) && ($estimate_d_date != null)) {
                            $estimate_de_date = date("d M Y", strtotime($estimate_d_date));
                        } else {
                            $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                        }
                    } else {
                        $pickup_date = date("d M Y", strtotime($res['pickup_datetime']));
                        $estimate_de_date = date("d M Y", strtotime($res['drop_endtime']));
                    }

                    $shift_id = $res['shift_id'];
                    $last_loc = $last_status_name = $delivery_date = $delivery_status = "";
                    if ($shift_id != 0) {
                        $get_laststatusinfo = $this->inaquaticamodel->getlaststoptransdetails($res['order_id'], $shift_id);

                        $delivery_status = "Not Delivered";
                        if ($res['trip_sts'] == 1) {
                            $last_status_name = "Delivered";
                            $delivery_status = "Delivered";
                        }
                        if ($get_laststatusinfo->num_rows() > 0) {
                            $last_status_name = $get_laststatusinfo->row()->status_name;
                            if (($last_status_name == "Delivered to Consignee") || ($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type = "D")) {
                                $delivery_date = $get_laststatusinfo->row()->createdon;
                                $last_status_name = "Delivered";
                            } else {
                                if ($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "P") {
                                    $last_status_name = "Pickedup";
                                } else if ($get_laststatusinfo->row()->id == 1 && $get_laststatusinfo->row()->stop_type == "D") {
                                    $last_status_name = "Delivered";
                                }
                            }
                            if ($delivery_date == "") {
                                $status_code = $get_laststatusinfo->row()->status_code;
                                $stop_type = $get_laststatusinfo->row()->stop_type;
                                $status_id = $get_laststatusinfo->row()->status_id;
                                if ($status_id == '3' && $status_code == '3000' && $stop_type == 'D') {
                                    $d_time = getEDAofNZShipmentbyord($res['id']);
                                    $d_date = $d_time['time'];
                                    $delivery_status = "Delivered";
                                    if (isset($d_date) && $d_date != "") {
                                        $date = '0000-00-00 00:00:00';
                                        if (($d_date != $date) || (strtotime($d_date) > 0)) {
                                            $delivery_date = date("d M Y", strtotime($d_date));
                                        } else {
                                            $delivery_date = "";
                                        }
                                    }
                                }
                            }
                            if ($get_laststatusinfo->row()->loc_name != null) {
                                $last_loc = $get_laststatusinfo->row()->loc_name;
                            } else {
                                $lat = $get_laststatusinfo->row()->latitude;
                                $lng = $get_laststatusinfo->row()->longitude;
                                $last_loc = getLocationName($lat, $lng);
                            }
                        }
                    }
                    /* get epods for order_id */
                    $epods = [];
                    if ($shift_id != 0) {
                        $epod_doc = $this->inaquaticamodel->getEpodDoc($res['id'], $shift_id);
                        if (count($epod_doc) > 0) {
                            $i = 1;
                            foreach ($epod_doc as $epd) {
                                $imglink = checkimageintmsorknlmv($epd['imgpath']);
                                $link1 = '=hyperlink("' . $imglink . '")';
                                $epods[] = $link1;
                                $i ++;
                            }
                        }
                    }

                    $shipmentid = $res['shipmentid'];
                    $sid = 0;
                    $stops_arr = [];

                    if (! empty($shipmentid)) {
                        $sql3 = $this->db->query("select id from tb_shifts where status = 1 and shipmentid = '$shipmentid' GROUP BY id ORDER BY id DESC");
                        if ($sql3->num_rows() > 0) {
                            $sid = $sql3->row()->id;
                            $stops = $this->db->query("SELECT id from tb_shiporder_stops WHERE status = '1' AND shipment_id=" . $sid . " ORDER BY ordernumber ASC");
                            if ($stops->num_rows() > 0) {
                                $stops_arr = $stops->result_array();
                            }
                        }
                    }

                    $oid = "";
                    $livetrack_link = "";
                    if (count($stops_arr) > 0) {
                        $oid = @getOrderIds($stops_arr[0]["id"]);
                    }
                    $parts = explode(",", $oid);
                    if (count($parts) > 0) {
                        $oid = $parts[0];
                    }

                    if ((! empty($shipmentid)) && ($sid != 0)) {
                        $livetrack_link = base_url('livetrack/etnshipment/') . "/" . $res['order_id'] . "?inner";
                        $livetrack_link = '=hyperlink("' . $livetrack_link . '")';
                    }
                    $aquorder[] = array(
                        'order_row_id' => $res['id'],
                        'order_id' => $res['order_id'],
                        'pieces' => $res['totqty'],
                        'weight' => $res['totwg'],
                        'volumetric_weight' => $res['volumetric_weight'],
                        'goods_desc' => $final_cargo_content_str,
                        'pickup' => $res['pickup'],
                        'delivery' => $res['delivery'],
                        'carriername' => $carrier_name,
                        'shipper_address' => $res['pickup'],
                        'shipper_city' => $res['pickup_city'],
                        'consignee_address' => $res['delivery'],
                        'consignee_city' => $res['delivery_city'],
                        'pickup_date' => $pickup_date,
                        'estimate_d_date' => $estimate_de_date,
                        'delivery_date' => $delivery_date,
                        'cust_reference_num' => $cust_reference_num,
                        'lr_num' => $lr_num,
                        'goods_value' => $res['goods_value'],
                        'transport_mode' => $res['transport_mode'],
                        'delivery_status' => $delivery_status,
                        'last_status_name' => $last_status_name,
                        'last_loc' => $last_loc,
                        'title' => $title,
                        'epod' => $epods,
                        'livetrack_link' => $livetrack_link
                    );
                }
            }
        }
        $styleArray = array(
            'font' => array(
                'bold' => true,
                'color' => array(
                    'rgb' => 'FFFFFF'
                ),
                'size' => 10,
                'name' => 'Verdana'
            )
        );
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:AH1')
            ->applyFromArray(array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array(
                    'rgb' => '0c3b81'
                )
            )
        ));
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'TrackingNo');
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Cust RefNo');
        $objPHPExcel->getActiveSheet()
            ->getStyle('B1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'LR Number');
        $objPHPExcel->getActiveSheet()
            ->getStyle('C1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Goods Value');
        $objPHPExcel->getActiveSheet()
            ->getStyle('D1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Mode Of Transport');
        $objPHPExcel->getActiveSheet()
            ->getStyle('E1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Shipper Name');
        $objPHPExcel->getActiveSheet()
            ->getStyle('F1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', ' Shipper City');
        $objPHPExcel->getActiveSheet()
            ->getStyle('G1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Consignee Name');
        $objPHPExcel->getActiveSheet()
            ->getStyle('H1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Consignee City');
        $objPHPExcel->getActiveSheet()
            ->getStyle('I1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Goods Description');
        $objPHPExcel->getActiveSheet()
            ->getStyle('J1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Total Pkgs');
        $objPHPExcel->getActiveSheet()
            ->getStyle('K1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Weight(Kgs)');
        $objPHPExcel->getActiveSheet()
            ->getStyle('L1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('M1', ' Volumetric Weight');
        $objPHPExcel->getActiveSheet()
            ->getStyle('M1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('N1', ' Vendor Name');
        $objPHPExcel->getActiveSheet()
            ->getStyle('N1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('O1', ' Picked Up Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('O1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('P1', ' Estimated Delivery Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('P1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('Q1', ' Delivery Status');
        $objPHPExcel->getActiveSheet()
            ->getStyle('Q1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('R1', ' Delivery Date');
        $objPHPExcel->getActiveSheet()
            ->getStyle('R1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('S1', ' Last Status');
        $objPHPExcel->getActiveSheet()
            ->getStyle('S1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('T1', ' Last location');
        $objPHPExcel->getActiveSheet()
            ->getStyle('T1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'Live Track Link');
        $objPHPExcel->getActiveSheet()
            ->getStyle('U1')
            ->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Managedocuments');
        $objPHPExcel->getActiveSheet()
            ->getStyle('V1')
            ->applyFromArray($styleArray);
        $rowCount = 2;
        if (count($aquorder) > 0) {
            foreach ($aquorder as $order) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $order['order_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $order['cust_reference_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $order['lr_num']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $order['goods_value']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $order['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $order['shipper_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $order['shipper_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $order['consignee_address']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $order['consignee_city']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $order['goods_desc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $order['pieces']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $order['weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $order['volumetric_weight']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $order['carriername']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $order['pickup_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $order['estimate_d_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $order['delivery_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $order['delivery_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $order['last_status_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $order['last_loc']);
                $objPHPExcel->getActiveSheet()->SetCellValue('U' . $rowCount, $order['livetrack_link']);
                if (is_array($order['epod']) && count($order['epod']) >= 1) {
                    $col = 21;
                    foreach ($order['epod'] as $key => $value) {
                        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col, $rowCount, $value);
                        $col ++;
                    }
                }
                $rowCount ++;
            }
        }
        $fileName = 'Basicshipmentreport-' . date("Ymdhis") . '.xlsx';
        header('Content-Type: application/vnd.ms-excel'); /* mime type */
        header('Content-Disposition: attachment;filename="' . $fileName . '"'); /* tell browser what's the file name */
        header('Cache-Control: max-age=0'); /* no cache */
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
    }
}
