<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KNCustBIBasic extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->library('customeramchartslib');
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('chart_dashboard');
        $data['sub_title'] = $this->lang->line('pie_chart');
        $data['piechartdata'] = $this->customeramchartslib->getPieChartData();
        $yearInfo = [
            "currentYear" => DATE("Y"),
            "currentMonth" => DATE("m"),
            "currentweek" => DATE("w")
        ];
        $data['gaugechartdata'] = $this->customeramchartslib->getGaugeChartData($yearInfo);
        $lineAreaOrders = $this->customeramchartslib->getLineAreaChartData($yearInfo);
        foreach ($lineAreaOrders as $orders) {
            $lineAreaOrdersData[$orders['Weeks']]['Week'] = $orders['Weeks'];
            $lineAreaOrdersData[$orders['Weeks']][$orders['orderstatus']] = $orders['ordercount'];
        }
        $data['lineareaorders'] = $lineAreaOrdersData ?? [];
        
        $data['col_classes'] = [
            'col1' => 'col-md-4',
            'col2' => 'col-md-4',
            'col3' => 'col-md-4'
        ];
        
        $this->newtemplate->dashboard("customeramcharts/piecharts", $data);
    }


    public function getPieChartInfo(): void
    {
        $currentYear = $this->input->post('year', true);
        $currentYear = $currentYear ?? DATE("Y");
        $data = $this->customeramchartslib->getPieChartData($currentYear);
        echo json_encode($data);
    }

    public function getBandsGaugeChartDetails(): void
    {
        $yearInfo = [
            "currentYear" => $this->input->post('currentyear', true) ?? 0,
            "currentMonth" => $this->input->post('currentmonth', true) ?? 0,
            "currentweek" => $this->input->post('currentweek', true) ?? 0
        ];
        $data = $this->customeramchartslib->getGaugeChartData($yearInfo);
        echo json_encode($data);
    }

    public function getLineAreaChartDetails(): void
    {
        $yearInfo = [
            "currentYear" => $this->input->post('currentyear', true) ?? 0,
            "currentMonth" => $this->input->post('currentmonth', true) ?? 0
        ];
        $lineAreaOrders = $this->customeramchartslib->getLineAreaChartData($yearInfo);
        if(!empty($lineAreaOrders)){
            foreach ($lineAreaOrders as $orders) {
                $lineAreaOrdersData[$orders['Weeks']]['Week'] = $orders['Weeks'];
                $lineAreaOrdersData[$orders['Weeks']][$orders['orderstatus']] = $orders['ordercount'];
            }
            foreach ($lineAreaOrdersData as $key => $value) {
                $completed = (int)isset($lineAreaOrdersData[$key]['Completed']) ? $lineAreaOrdersData[$key]['Completed'] : 0;
                $pending = (int)isset($lineAreaOrdersData[$key]['Pending']) ? $lineAreaOrdersData[$key]['Pending'] : 0;
                $total = $completed + $pending;
                $data[] = ["date" => "Week " . $lineAreaOrdersData[$key]['Week'], "distance" => $total, "latitude" => $compleed];

            }
        }else{
            $data = [];
        }
        echo json_encode($data);
    }
    
    public function getPieChartView()
    {
        log_message('error', 'message:came here');
        $data['page_title'] = $this->lang->line('chart_dashboard');
        $data['sub_title'] = $this->lang->line('pie_chart');
        $data['piechartdata'] = $this->customeramchartslib->getPieChartData();
        $yearInfo = [
            "currentYear" => DATE("Y"),
            "currentMonth" => DATE("m"),
            "currentweek" => DATE("w")
        ];
        $data['gaugechartdata'] = $this->customeramchartslib->getGaugeChartData($yearInfo);
        $lineAreaOrders = $this->customeramchartslib->getLineAreaChartData($yearInfo);
        foreach ($lineAreaOrders as $orders) {
            $lineAreaOrdersData[$orders['Weeks']]['Week'] = $orders['Weeks'];
            $lineAreaOrdersData[$orders['Weeks']][$orders['orderstatus']] = $orders['ordercount'];
        }
        $data['lineareaorders'] = $lineAreaOrdersData ?? [];
        $data['col_classes'] = [
            'col1' => 'col-md-6',
            'col2' => 'col-md-6',
            'col3' => 'col-md-12'
        ];
        $html = $this->load->view('customeramcharts/piecharts', $data, TRUE);
        echo $html;
    }
}
