<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KNQuickRateSearch extends CI_Controller
{
    private const FRT_CHARGE_ID = '39';

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->userId = $this->session->userdata('user_id');
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->userCurrency = $this->session->userdata("usr_tzone")['currency'];
        $this->load->model(["rateenquirymodel", "common"]);
        $this->crossBorderCountries = $this->rateenquirymodel->checkCrossBorderCountries($this->companyCode);
    }

    public function index(): void
    {
        $postData = $this->input->post(null, true);
        if (!empty($postData)) {
            $rateRecords = $this->getRatesList($postData);
            $ratesArray = $rateRecords['rates'] ?? [];
            $ratesCount = count($ratesArray);
            for ($i = 0; $i < $ratesCount; $i++) {
                $laneNames[] = $ratesArray[$i]['laneRowId'];
                if ($ratesArray[$i]['vendorProfileId'] > 0) {
                    $vendorIds[] = $ratesArray[$i]['vendorProfileId'];
                }
            }
            if (!empty($laneNames)) {
                $laneIds = array_unique($laneNames);
                $laneData = $this->common->gettbldata("id IN (" . implode(",", $laneIds) . ")", "id,lane_id", "tb_lanes_master", 0, 0);
                foreach ($laneData as $data) {
                    $laneMasterId[$data['id']] = $data['lane_id'];
                }
            }
            if (!empty($vendorIds)) {
                $VendorIdData = $this->common->gettbldata("id IN (" . implode(",", $vendorIds) . ")", "id,vend_profile_id", "tb_vendor_profile", 0, 0);
                foreach ($VendorIdData as $vendors) {
                    $vendorsDataIds[$vendors['id']] = $vendors['vend_profile_id'];
                }
            }
            $data['laneMasterId'] = $laneMasterId ?? [];
            $data['vendorsDataIds'] = $vendorsDataIds ?? [];
            $data['rateRecords'] = $rateRecords ?? [];
        }
        $data["page_title"] = $this->lang->line('rate_enquiry');
        $data["sub_title"] = $this->lang->line('general_search');
        $data['companyCode'] = $this->companyCode;
        $data['pickupPartyType'] = $this->companyCode === "SGKN" ? "Pickup" : "Shipper";
        $data['deliveryPartyType'] = $this->companyCode === "SGKN" ? "Delivery" : "Consignee";
        $data['vehicleTypes'] = $this->rateenquirymodel->getVehicleTypeMasterData($this->crossBorderCountries);
        $data['currencies'] = $this->common->gettbldata(['status' => 1], 'currency', 'tbl_country_master', 0, 0);
        $data['userCurrency'] = $this->userCurrency;
        $data['postData'] = $postData;
        $this->newtemplate->dashboard("quickratesearch/index", $data);
    }

    private function getRatesList(array $postData): array
    {
        $geoTypeList = ['1' => 'Region', '2' => 'Country', '3' => 'Province', '4' => 'District', '5' => 'City', '6' => 'Postal Code', '7' => 'Sub District'];
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        $conditions = $this->setWhereConditionsByPostData($postData);
        $addressPairs = $this->generateAddressPairs($conditions['pickupData'], $conditions['deliveryData']);
        $query = $this->rateenquirymodel->getRateCharges(['addressPairs' => $addressPairs, 'userId' => $this->userId, 'conditions' => $conditions['conditions'], 'crossBorder' => $this->crossBorderCountries]);
        $pageCount = $query->num_rows();
        $ratesData = $pageCount > 0 ? $query->result_array() : [];
        if (empty($ratesData)) {
            return [];
        }
        $offeringRowIds = $recordRowIds = $ServiceTypes = $offeringTypes = $rates = $ratesResult = [];
        foreach ($ratesData as $eachLine) {
            $offeringRowIds[] = $eachLine['offeringRowId'];
            $recordRowIds[] = $eachLine['recordRowId'];
            $offeringTypes[] = $eachLine['offering_type'];
            $ServiceTypes[] = $eachLine['service_type'];
            $rates[] = [
                'serviceRowId' => $eachLine['serviceRowId'],
                'product' => $eachLine['product'],
                'rateServiceId' => $eachLine['service_id'],
                'rateServiceType' => $eachLine['service_type'],
                'rateServiceName' => $eachLine['service_name'],
                'laneRowId' => $eachLine['lane_id'],
                'source' => $eachLine['source'],
                'destination' => $eachLine['destination'],
                'transitDays' => $eachLine['transitDays'] ?? "",
                'offeringRowId' => $eachLine['offeringRowId'],
                'rateOfferingId' => $eachLine['offering_id'],
                'rateOfferingName' => $eachLine['offering_name'],
                'rateOfferingType' => $eachLine['offering_type'],
                'offeringTariffType' => $eachLine['offeringTariffType'],
                'effectiveDate' => $eachLine['effectiveDate'],
                'expiryDate' => $eachLine['expiryDate'],
                'recordRowId' => $eachLine['recordRowId'],
                'rateRecordId' => $eachLine['recordId'],
                'rateRecordName' => $eachLine['recordName'],
                'customerProfileId' => $eachLine['cust_profile_id'],
                'vendorProfileId' => $eachLine['vendor_profile_id'],
                'sourceGeo' => $geoTypeList[$eachLine['source_geo']] ?? "",
                'destinationGeo' => $geoTypeList[$eachLine['destination_geo']] ?? "",
            ];
        }
        $offeringRowIds = array_filter($offeringRowIds);
        $recordRowIds = array_filter($recordRowIds);
        $serviceModeMaster = $this->rateenquirymodel->getServiceModeMasterData(array_unique($offeringTypes), array_unique($ServiceTypes));
        $amountDetails = $this->getTotalChargesAmount(array_unique($offeringRowIds), array_unique($recordRowIds), $conditions['geoPickupData'], $conditions['geoDeliveryData'], $postData);
        $offeringData = $amountDetails['offeringData'] ?? [];
        $recordServicesData = $amountDetails['recordServicesData'] ?? [];
        $recordChargesData = $amountDetails['recordChargesData'] ?? [];
        for ($i = 0, $iMax = count($rates); $i < $iMax; $i++) {
            $offeringAmount = $offeringData[$rates[$i]['offeringRowId']] ?? 0;
            $recordServiceAmount = $recordServicesData[$rates[$i]['recordRowId']] ?? 0;
            $recordChargesAmount = $recordChargesData[$rates[$i]['recordRowId']]['amount'] ?? 0;
            $totalAmount = $offeringAmount + $recordServiceAmount + $recordChargesAmount;
            if ($totalAmount > 0) {
                $rates[$i]['totalAmount'] = $totalAmount;
                $rates[$i]['titleNearTotalAmount'] = $recordChargesData[$rates[$i]['recordRowId']]['title'] ?? "";
                $rates[$i]['vehicleTypeTitle'] = $recordChargesData[$rates[$i]['recordRowId']]['vehicleTypeTitle'] ?? "";
                $rates[$i]['fuelSurcharge'] = $recordChargesData[$rates[$i]['recordRowId']]['fuelSurcharge'] ?? 0;
            } else {
                unset($rates[$i]);
            }
        }
        $keys = array_column($rates, 'totalAmount');
        array_multisort($keys, SORT_ASC, $rates);
        $config = [];
        $config["base_url"] = base_url() . "quickratesearch/index";
        $config["total_rows"] = count($rates);
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        $perPage = $page + $config["per_page"];
        for ($page; $page < $perPage; $page++) {
            $serviceRowId = $rates[$page]['serviceRowId'] ?? 0;
            if ($serviceRowId === 0) {
                break;
            }
            $ratesResult[] = $rates[$page] ?? [];
        }
        return ['rates' => $rates ?? [], 'serviceModeMaster' => $serviceModeMaster ?? []];
    }

    private function setWhereConditionsByPostData(array $postData): array
    {
        $pickupData = [$postData['pickupCountry'] ?? "", $postData['pickupState'] ?? "", $postData['pickupDistrict'] ?? "", $postData['pickupCity'] ?? "", $postData['pickupPincode'] ?? "", $postData['pickupSubDistrict'] ?? ""];
        $deliveryData = [$postData['consigneeCountry'] ?? "", $postData['consigneeState'] ?? "", $postData['pickupDistrict'] ?? "", $postData['consigneeCity'] ?? "", $postData['consigneePincode'] ?? "", $postData['consigneeSubDistrict'] ?? ""];
        $geoPickupData = [$postData['pickupPincode'] ?? "", $postData['pickupCity'] ?? "", $postData['pickupState'] ?? "", $postData['pickupCountry']];
        $geoDeliveryData = [$postData['consigneePincode'] ?? "", $postData['consigneeCity'] ?? "", $postData['consigneeState'] ?? "", $postData['consigneeCountry']];
        $modelType = $postData['modelType'] ?? "";
        $tariffType = $postData['tariffType'] ?? "";
        $data = [];
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        if ($ajaxCall > 0) {
            $data['offeringType'] = $modelType;
        } elseif (in_array($modelType, ['FTL', 'LTL'])) {
            $data['offeringType'] = $modelType;
        }
        if ($ajaxCall > 0) {
            $data['service'] = $postData['service'];
        }
        if (in_array($tariffType, ['SELL', 'BUY'])) {
            $data['tarrifType'] = $tariffType;
        }
        $startDate = $postData['searchFromDate'] ?? "";
        $endDate = $postData['searchToDate'] ?? "";
        if (!in_array('', [$startDate, $endDate], true)) {
            $date1 = new DateTime($startDate);
            $date2 = new DateTime($endDate);
            $interval = date_diff($date1, $date2);
            $daysDifference = $interval->format('%a');
            if ($daysDifference > 0) {
                $data['daysCount'] = $daysDifference;
            }
        }
        if (!empty($postData['product'])) {
            $data['product'] = $postData['product'];
        }
        if (!empty($postData['transitDays'])) {
            $data['daysCount'] = $postData['transitDays'];
        }
        if (!empty($postData['vendor_profile_id'])) {
            $vendorId = $this->common->gettblrowdata(['status' => '1', 'vend_profile_id' => $postData['vendor_profile_id']], 'id', 'tb_vendor_profile', 0, 0);
            $data['vendorProfileId'] = $vendorId['id'];
        }
        if (!empty($postData['ratesValidFrom'])) {
            $newFromDate = date("Y-m-d", strtotime($postData['ratesValidFrom']));
            $data['ratesValidFrom'] = $newFromDate;
        }
        if (!empty($postData['ratesValidTo'])) {
            $newToDate = date("Y-m-d", strtotime($postData['ratesValidTo']));
            $data['ratesValidTo'] = $newToDate;
        }

        $vehicleType = $postData['vehicleType'] ?? 0;
        if ($vehicleType > 0) {
            $vehicleProfileIds = $this->rateenquirymodel->getVehicleTypeProfileIds(['companyCodes' => $this->crossBorderCountries['companyCodes'], 'profileId' => $vehicleType]);
            if (!empty($vehicleProfileIds)) {
                $data['vehicleProfileIds'] = $vehicleProfileIds;
            }
            $data['vehicleType'] = $vehicleType;
        }
        $customerRowId = $postData['customerRowId'] ?? 0;
        if ($customerRowId > 0) {
            $customerProfileIds = $this->rateenquirymodel->getCustomerProfilesByCustomerId(['companyCodes' => $this->crossBorderCountries['companyCodes'], 'profileId' => $customerRowId]);
            if (!empty($customerProfileIds)) {
                $data['customerProfileIds'] = $customerProfileIds;
            }
        }
        $vehicleCapacity = $postData['vehicleCapacity'] ?? 0;
        if ($vehicleCapacity > 0) {
            $data['vehicleCapacity'] = $vehicleCapacity;
        }
        return ['pickupData' => $pickupData, 'deliveryData' => $deliveryData, 'geoPickupData' => $geoPickupData, 'geoDeliveryData' => $geoDeliveryData, 'conditions' => $data];
    }

    private function generateAddressPairs(array $pickupDetails, array $deliveryDetails): string
    {
        $geoHierarchy = [2, 3, 4, 5, 6, 7];
        $lanes = [];
        foreach ($pickupDetails as $pickupKey => $pickupvalue) {
            foreach ($deliveryDetails as $deliveryKey => $deliveryValue) {
                if (!in_array("", [$pickupvalue, $deliveryValue])) {
                    $lanes[] = '( lm.source_geo = "' . $geoHierarchy[$pickupKey] . '" AND ' . 'lm.source' . ' = "' . $pickupvalue . '" AND lm.destination_geo="' . $geoHierarchy[$deliveryKey] . '" AND ' . 'lm.destination' . ' = "' . $deliveryValue . '")';
                }
            }
        }
        return implode(' OR ', $lanes);
    }

    private function getTotalChargesAmount(array $offeringIds, array $recordIds, array $pickupData, array $deliveryData, array $postData): array
    {
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        if ($ajaxCall > 0) {
            $amountDetails = $this->rateenquirymodel->getTotalChargesAmountWithCargos($offeringIds, $recordIds, $postData, $this->userCurrency, $this->userId);
        } else {
            $amountDetails = $this->rateenquirymodel->getTotalChargesAmount($offeringIds, $recordIds, $this->userCurrency, $this->userId);
        }
        $offering = $amountDetails['offering'] ?? [];
        $recordServices = $amountDetails['recordServices'] ?? [];
        $recordCharges = $amountDetails['recordCharges'] ?? [];
        $otherCurrencyCharges = $amountDetails['otherCurrencyCharges'] ?? [];
        $tiersData = $amountDetails['tiersData'] ?? [];
        $fafWithRateId = $amountDetails['fafWithRateId'] ?? [];
        $frtRecordChargesAmount = $amountDetails['frtRecordChargesAmount'] ?? [];
        $recordChargesData = $recordChargesInfo = $recordRowIds = [];
        foreach ($offering as $eachLine) {
            $offeringData[$eachLine['rateoffering_id']] = $eachLine['totalOfferingAmount'];
        }
        foreach ($recordServices as $eachLine) {
            $recordServicesData[$eachLine['raterecord_id']] = $eachLine['totalRecordServices'];
        }
        foreach ($recordCharges as $eachLine) {
            $othercharges = $otherCurrencyCharges[$eachLine['raterecord_id']] ?? 0;
            $recordChargesInfo[$eachLine['raterecord_id']] = ($othercharges + $eachLine['totalRecordCharges']);
            $recordRowIds[] = $eachLine['raterecord_id'];
        }
        if (!empty($tiersData)) {
            $tiersAmount = $this->getTiersTotalAmountFromRateRecord($tiersData, ['pickupData' => $pickupData, 'deliveryData' => $deliveryData, 'postData' => $postData]);
            $geoTiersAmount = $tiersAmount['geoTiersAmount'] ?? [];
            $rateTiersAmount = $tiersAmount['rateTiersAmount'] ?? [];
            foreach($tiersData as $data){
                $chargesId2[$data['recordId']][$data['geoTierId']] = $data['chargeId'];
            }
        }
        if ($ajaxCall > 0) {
            if (empty($recordChargesInfo) && !empty($tiersData)) {
                foreach ($tiersData as $eachTier) {
                    $recordChargesInfo[$eachTier['recordId']] = 0;
                }
            }
        } else {
            foreach ($tiersData as $eachRecord) {
                $recordId = $eachRecord['recordId'];
                if (in_array($recordId, $recordRowIds, true)) {
                    continue;
                }
                $recordChargesInfo[$recordId] = 0;
            }
        }
        $dummyGeoTiers = $dummyRateTiers = [];
        foreach ($recordChargesInfo as $key => $value) {
            $frtAmount = $frtRecordChargesAmount[$key] ?? 0;
            $title = $vehicleTypeTitle = "";
            foreach ($tiersData as $eachTier) {
                if ($key == $eachTier['recordId']) {
                    if ($eachTier['geoTierId'] > 0) {
                        $charge = $geoTiersAmount[$eachTier['geoTierId']]['chargeId'] ?? "";
                        $chargeId = $chargesId2[$key][$eachTier['geoTierId']] ?? $charge;
                        if ($chargeId == self::FRT_CHARGE_ID) {
                            $frtAmount += $geoTiersAmount[$eachTier['geoTierId']]['cost'] ?? 0;
                        }
                        $value += $geoTiersAmount[$eachTier['geoTierId']]['cost'] ?? 0;
                        $title .= isset($geoTiersAmount[$eachTier['geoTierId']]['title']) ? $geoTiersAmount[$eachTier['geoTierId']]['title'] . ",&#10;" : "";
                        $displayVehicleName = $geoTiersAmount[$eachTier['geoTierId']]['displayVehicleName'] ?? 0;
                        $vehicleTypeName = $geoTiersAmount[$eachTier['geoTierId']]['vehicleTypeName'] ?? "";
                        $geoTierId = $geoTiersAmount[$eachTier['geoTierId']]['geoTierId'] ?? "";
                        if ($displayVehicleName > 0 && $vehicleTypeName != "") {
                            $vehicleTypeTitle .= "Vehicle Type is empty for " . $geoTierId . ",&#10;";
                        }
                        $dummyGeoTiers[] = $eachTier['geoTierId'];
                    }
                    if ($eachTier['tierId'] > 0) {
                        $value += $rateTiersAmount[$eachTier['tierId']]['cost'] ?? 0;
                        $title .= isset($rateTiersAmount[$eachTier['tierId']]['title']) ? $rateTiersAmount[$eachTier['tierId']]['title'] . ",&#10;" : "";
                        $charge2 = $rateTiersAmount[$eachTier['tierId']]['chargeId'] ?? 0;
                        $chargeId2 = $chargesId2[$key][$eachTier['tierId']] ?? $charge2;
                        if ($chargeId2 == self::FRT_CHARGE_ID) {
                            $frtAmount += $rateTiersAmount[$eachTier['tierId']]['cost'] ?? 0;
                        }
                    }
                    $dummyRateTiers[] = $eachTier['tierId'];
                }
            }
            $fafIds = $fafWithRateId[$key] ?? [];
            $surchargeData = 0;
            if ($frtAmount > 0 && !empty($fafIds)) {
                $fuelSurchargeData = $this->rateenquirymodel->calculateFuelSurchargeData(['ids' => $fafIds, 'amount' => $frtAmount, 'currency' => $this->userCurrency]);
                foreach ($fafIds as $eachId) {
                    $eachIdData = $fuelSurchargeData[$eachId] ?? [];
                    foreach ($eachIdData as $eachSurcharge) {
                        $value += $eachSurcharge['amount'];
                        $surchargeData += $eachSurcharge['amount'];
                    }
                }
            }
            $recordChargesData[$key]['amount'] = $value;
            $recordChargesData[$key]['title'] = $title;
            $recordChargesData[$key]['vehicleTypeTitle'] = $vehicleTypeTitle;
            $recordChargesData[$key]['fuelSurcharge'] = $surchargeData;
        }
        foreach ($tiersData as $singleTier) {
            $tierTitle = $tierVehicleTitle = "";
            $tierValue = 0;
            $checkStatus = 0;
            if ($singleTier['recordId'] > 0 && in_array($singleTier['recordId'], $recordIds, true)) {
                if ($singleTier['geoTierId'] > 0) {
                    if (!in_array($singleTier['geoTierId'], $dummyGeoTiers, true)) {
                        $tierValue += $geoTiersAmount[$singleTier['geoTierId']]['cost'] ?? 0;
                        $tierTitle .= isset($geoTiersAmount[$singleTier['geoTierId']]['title']) ? $geoTiersAmount[$singleTier['geoTierId']]['title'] . ",&#10;" : "";
                        $displayVehicleName = $geoTiersAmount[$singleTier['geoTierId']]['displayVehicleName'] ?? 0;
                        $vehicleTypeName = $geoTiersAmount[$singleTier['geoTierId']]['vehicleTypeName'] ?? "";
                        $geoTierId = $geoTiersAmount[$singleTier['geoTierId']]['geoTierId'] ?? "";
                        if ($displayVehicleName > 0 && $vehicleTypeName != "") {
                            $tierVehicleTitle .= "Vehicle Type is empty for " . $geoTierId . ",&#10;";
                        }
                        $dummyGeoTiers[] = $singleTier['geoTierId'];
                        $checkStatus = 1;
                    }
                }
                if ($singleTier['tierId'] > 0) {
                    if (!in_array($singleTier['tierId'], $dummyRateTiers, true)) {
                        $tierValue += $rateTiersAmount[$singleTier['tierId']]['cost'] ?? 0;
                        $tierTitle .= isset($rateTiersAmount[$eachTier['tierId']]['title']) ? $rateTiersAmount[$singleTier['tierId']]['title'] . ",&#10;" : "";
                        $dummyRateTiers[] = $singleTier['tierId'];
                        $checkStatus = 1;
                    }
                }
            }
            if ($checkStatus > 0) {
                $recordChargesData[$singleTier['recordId']]['amount'] = $tierValue;
                $recordChargesData[$singleTier['recordId']]['title'] = $tierTitle;
                $recordChargesData[$singleTier['recordId']]['vehicleTypeTitle'] = $tierVehicleTitle;
            }
        }
        return ["offeringData" => $offeringData ?? [], "recordServicesData" => $recordServicesData ?? [], "recordChargesData" => $recordChargesData ?? [], "tiersData" => $tiersData ?? []];
    }

    private function getTiersTotalAmountFromRateRecord(array $data, array $info): array
    {
        $rateTiers = $geoTiers = [];
        $postData = $info['postData'];
        $weight = $postData['searchWeight'] ?? 0;
        $vehicleType = $postData['vehicleType'] ?? 0;
        $ajaxCall = $postData['ajaxCall'] ?? 0;
        $orderTotalWeight = $postData['totalWeight'] ?? 0;
        $orderTotalVolume = $postData['totalVolume'] ?? 0;
        $totalKiloMeters = $postData['totalKiloMeters'] ?? 0;
        $totalMiles = $postData['totalMiles'] ?? 0;
        $pickupData = [$postData['pickupPincode'] ?? "", $postData['pickupCity'] ?? "", $postData['pickupState'] ?? "", $postData['pickupCountry']];
        $deliveryData = [$postData['consigneePincode'] ?? "", $postData['consigneeCity'] ?? "", $postData['consigneeState'] ?? "", $postData['consigneeCountry']];
        $geoPairs = $this->generateAddressPairsForGeoTier($info['pickupData'], $info['deliveryData']);
        foreach ($data as $eachLine) {
            if ($eachLine['tierId'] > 0) {
                $rateTiers[] = ['recordId' => $eachLine['recordId'], 'tierId' => $eachLine['tierId'], 'chargeId' => $eachLine['chargeId']];
            }
            if ($eachLine['geoTierId'] > 0) {
                $geoTiers[] = ['recordId' => $eachLine['recordId'], 'geoTierId' => $eachLine['geoTierId'], 'chargeId' => $eachLine['chargeId']];
            }
        }
        if (!empty($geoTiers)) {
            if ($ajaxCall > 0) {
                $geoTierData = $this->getGeoTiersDataWithCargos(['orderTotalWeight' => $orderTotalWeight, 'orderTotalVolume' => $orderTotalVolume, 'totalKiloMeters' => $totalKiloMeters, 'totalMiles' => $totalMiles, 'pickupData' => $pickupData, 'deliveryData' => $deliveryData], $geoTiers);
            } else {
                $geoTierData = $this->rateenquirymodel->getGeoTierDataFromSheet($geoPairs, ['data' => $geoTiers, 'weight' => $weight, 'userCurrency' => $this->userCurrency, 'userId' => $this->userId, 'vehicleType' => $vehicleType]);
            }
            if (!empty($geoTierData)) {
                foreach ($geoTierData as $eachRow) {
                    $message = $eachRow['message'] ?? "";
                    $billingUom = $eachRow['billingUom'] ?? "";
                    $title = $eachRow['geoTierId'] . " - " . $message . " " . $billingUom;
                    $geoTiersAmount[$eachRow['geoTierRowId']] = ['cost' => $eachRow['cost'], 'title' => $title, 'displayVehicleName' => $eachRow['displayVehicleName'] ?? "", 'vehicleTypeName' => $eachRow['vehicleTypeName'] ?? "", 'geoTierId' => $eachRow['geoTierId'], 'chargeId' => $eachLine['chargeId'] ?? ""];
                }
            }
        }
        if (!empty($rateTiers)) {
            if ($ajaxCall > 0) {
                $rateTierData = $this->getRateTiersDataWithCargos(['orderTotalWeight' => $orderTotalWeight, 'orderTotalVolume' => $orderTotalVolume, 'totalKiloMeters' => $totalKiloMeters, 'totalMiles' => $totalMiles], $rateTiers);
            } else {
                $rateTierData = $this->rateenquirymodel->getRateTierDataFromSheet(['data' => $rateTiers, 'weight' => $weight, 'userCurrency' => $this->userCurrency, 'userId' => $this->userId]);
            }
            if (!empty($rateTierData)) {
                foreach ($rateTierData as $eachRow) {
                    $message = $eachRow['message'] ?? "";
                    $billingUom = $eachRow['billingUom'] ?? "";
                    $title = $eachRow['tierId'] . " - " . $message . " " . $billingUom;
                    $rateTiersAmount[$eachRow['tierRowId']] = ['cost' => $eachRow['cost'], 'title' => $title, 'chargeId' => $eachRow['chargeId'] ?? ""];
                }
            }
        }
        return ['geoTiersAmount' => $geoTiersAmount ?? [], 'rateTiersAmount' => $rateTiersAmount ?? []];
    }

    private function generateAddressPairsForGeoTier(array $pickupData, array $deliveryData): array
    {
        $geoHierarchy = ['POSTAL CODE', 'CITY', 'PROVINCE', 'COUNTRY'];
        foreach ($pickupData as $pickupKey => $pickupValue) {
            foreach ($deliveryData as $deliveryKey => $deliveryValue) {
                if ($pickupKey == $deliveryKey) {
                    if (!in_array("", [$pickupValue, $deliveryValue])) {
                        $addressPair1[$geoHierarchy[$deliveryKey]] = '(' . 's.geo_from' . ' = "' . $pickupValue . '" AND ' . 's.geo_to' . ' = "' . $deliveryValue . '")';
                    }
                }
            }
        }
        foreach ($pickupData as $pickupValue) {
            foreach ($deliveryData as $deliveryValue) {
                if (!in_array("", [$pickupValue, $deliveryValue])) {
                    $addressPair2[] = '(' . 's.geo_from' . ' = "' . $pickupValue . '" AND ' . 's.geo_to' . ' = "' . $deliveryValue . '")';
                }
            }
        }
        return ['pair1' => $addressPair1 ?? [], 'pair2' => $addressPair2 ?? []];
    }


}
