<?php
defined('BASEPATH') or exit('No direct script access allowed');

class KNrateexchange extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("Knratemodel");
        if (!checkUrlAccessForUser('KNRATEEXCHANGE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data = $whr = $wher =$getdata= $get_data= $res_data=[];
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('exchange_rate');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["services"] = [];
      $post = $this->input->post(NULL,TRUE);
        $wher = [
            're.status' => 1,'re.company_code'=>$company_code
		];
        $whr = [];
        if (! empty($post)) {

           if (isset($post['cus_id']) && $post['cus_id'] != "") {
                $whr['c.name'] = $post['cus_id'];
            }
            if (isset($post['branch_code']) && $post['branch_code'] != "") {
                $whr['re.branch_code'] = $post['branch_code'];
            }
            if (isset($post['exch_rate_id']) && $post['exch_rate_id'] != "") {
                $whr['re.exchange_rate_id'] = $post['exch_rate_id'];
            }
            if (isset($post['exch_rate_name']) && $post['exch_rate_name'] != "") {
                $whr['re.exchange_rate_name'] = $post['exch_rate_name'];
            }

            if (isset($post['from_date']) && $post['from_date'] != "") {
                $fromdate1 = date('Y-m-d', strtotime($post['from_date']));
                $wher["DATE_FORMAT(re.createdon,'%Y-%m-%d') >="] = $fromdate1;
            }
            if (isset($post['to_date']) && $post['to_date'] != "") {
                $todate1 = date('Y-m-d', strtotime($post['to_date']));
                $wher["DATE_FORMAT(re.createdon,'%Y-%m-%d') <="] = $todate1;
            }
        }
        $data['getdata'] = $this->Knratemodel->getrateexchange($wher, $whr,null);

        $this->newtemplate->dashboard("KNrateexchange/index", $data);
    }
 /* Rate service Add */
    public function add()
    {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
		//$data['currencies']=$cur=array();
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data["page_title"] = $this->lang->line('exchange_rate');
        $data["sub_title"] = $this->lang->line('general_add');
		$data['actual_currency'] = '';
		$data['currencies']=$this->Knratemodel->getcurrency();
		/* log_message('error',$this->db->last_query()); */
		$data['currencies'][]=['currency' => "PLN"];
        //$this->newtemplate->dashboard("KNrateexchange/add", $data);
        $this->load->view("KNrateexchange/add", $data);
    }

    public function insert()
    {
        $data =$ins_data=  $ins_data1= $ins_sheet=$ins_sheet1=[];
		 $user_id = $this->session->userdata('user_id');
		$post = $this->input->post(NULL,TRUE);
	    $ins_data['company_code'] = isset($post['company_code']) ? $post['company_code'] : "";
	    $ins_data['branch_code'] = isset($post['branch_code']) ? $post['branch_code'] : "";
	    $ins_data['exchange_rate_name'] = isset($post['exch_rate_name']) ? $post['exch_rate_name'] : "";
		$ins_data['customer_id'] = isset($post['customerid']) ? $post['customerid'] :0;
		if($ins_data['customer_id']==""){$ins_data['customer_id']=0;}
	    $ins_data['exchange_rate_type'] = isset($post['exchange_rate_type']) ? $post['exchange_rate_type'] : "";
		$ins_data['exchange_rate_id']=$this->exchangeidgen();
		$ins_data['status']=1;
		$ins_data['user_id']=$user_id;
	   // log_message("error","rate exchange data befor:".json_encode($ins_data));
		$res_ex_id = $this->common->insertTableData("tb_rate_exchange", $ins_data);
         if ($res_ex_id) {
				//if(!empty($ins_data) && count($ins_data) > 0){
			   // $res_ex_id=1;
				for($i=1;$i<11;$i++) {
					 $ins_data1['exchange_rate_am_'.$i] = isset($post['exchange_rate_am_'.$i]) ? $post['exchange_rate_am_'.$i] :0;
					if(is_numeric($ins_data1['exchange_rate_am_'.$i]) && $ins_data1['exchange_rate_am_'.$i]!=""){
					$ins_sheet1['exchange_rate_am_'.$i]=$ins_data1['exchange_rate_am_'.$i];
					$ins_sheet1['from_currency_'.$i] = isset($post['from_currency_'.$i]) ? $post['from_currency_'.$i] :"";
					$ins_sheet1['to_currency_'.$i] = isset($post['to_currency_'.$i]) ? $post['to_currency_'.$i] :"";
					$ins_sheet1['effective_date_'.$i] = isset($post['effective_date_'.$i]) ? $post['effective_date_'.$i] :"";
					$ins_sheet1['expiry_date_'.$i] = isset($post['expiry_date_'.$i]) ? $post['expiry_date_'.$i] :"";
					if($ins_sheet1['effective_date_'.$i] != ""){
			         $ins_sheet1['effective_date_'.$i] = date("Y-m-d", strtotime($ins_sheet1['effective_date_'.$i]));
		             }
					 if($ins_sheet1['expiry_date_'.$i] != ""){
			         $ins_sheet1['expiry_date_'.$i] = date("Y-m-d", strtotime($ins_sheet1['expiry_date_'.$i]));
		             }
					$ins_sheet[]=[
					'rate_exchange_id'=>$res_ex_id,
					'exchange_from'=>$ins_sheet1['from_currency_'.$i],
					'exchange_to'=>$ins_sheet1['to_currency_'.$i],
					'exchange_rate'=>$ins_sheet1['exchange_rate_am_'.$i],
					'effective_date'=>$ins_sheet1['effective_date_'.$i],
					'expiry_date'=>$ins_sheet1['expiry_date_'.$i],
					'status'=>1,
					'user_id'=>$user_id
					];
					}
				}
				if(!empty($ins_sheet)){
		        $this->db->insert_batch('tb_rate_exchange_sheet', $ins_sheet);
				}
		       //log_message("error","rate exchange data after:".json_encode($ins_sheet));
        }
		$data=['id'=>$res_ex_id];
		echo $res_ex_id;
    }


	public function edit($id)
    {
		$data=$getdata=$get_data=$getsheet=$get_sheet=[];
        $company_code = $this->session->userdata('company_code');
        $data["page_title"] = $this->lang->line('exchange_rate');
        $data["sub_title"] = $this->lang->line('general_edit');
        $user_id = $this->session->userdata('user_id');
		$country_code = substr($company_code, 0,2);
		$data['actual_currency'] = "";
		$data['currencies']=$this->Knratemodel->getcurrency();
		/* log_message('error',$this->db->last_query()); */
		$data['currencies'][]=['currency' => "PLN"];
		$wher=['re.status' => 1,'re.id'=>$id];
		$whr=[];
		 $data['gen_data'] = $this->Knratemodel->getrateexchange($wher, $whr,1);
        $where_s=['status' => 1,'rate_exchange_id'=>$id];
         $get_sheet1 = $this->common->gettbldata($where_s, '*','tb_rate_exchange_sheet', 0, 0); if(!empty($get_sheet1)){
			 foreach($get_sheet1 as $get_sheet){
				 $expiry_date=$effective_date="";
				 if(($get_sheet['expiry_date']=='0000-00-00')||($get_sheet['expiry_date']=="")){
					 $expiry_date="";
				 }else{
					 $expiry_date=$get_sheet['expiry_date'];
				 }
				 if(($get_sheet['effective_date']=='0000-00-00')||($get_sheet['effective_date']=="")){
					 $effective_date="";
				 }else{
					 $effective_date=$get_sheet['effective_date'];
				 }
			 $getsheet[]=['id'=>$get_sheet['id'],'rate_exchange_id'=>$get_sheet['rate_exchange_id'],'exchange_from'=>$get_sheet['exchange_from'],'exchange_to'=>$get_sheet['exchange_to'],'exchange_rate'=>$get_sheet['exchange_rate'],'effective_date'=>$effective_date,'expiry_date'=>$expiry_date];
			 }
		 }
		  $data['sheet']=$getsheet;
		/* log_message("error","rate exchange data after:".json_encode($data)); */
		  //$this->newtemplate->dashboard("KNrateexchange/edit", $data);
		  $this->load->view("KNrateexchange/edit", $data);
	}


	public function update()
    {
        $data =$ins_data=  $ins_data1= $ins_sheet=$ins_sheet1=$up_sheet1=$up_sheet=$up_data1=[];
		 $user_id = $this->session->userdata('user_id');
		$post = $this->input->post(NULL,TRUE);
	    $id = isset($post['exchid']) ? $post['exchid'] : 0;
	    $ins_data['company_code'] = isset($post['company_code']) ? $post['company_code'] : "";
	    $ins_data['branch_code'] = isset($post['branch_code']) ? $post['branch_code'] : "";
	    $ins_data['exchange_rate_name'] = isset($post['exch_rate_name']) ? $post['exch_rate_name'] : "";
		$ins_data['customer_id'] = isset($post['customerid']) ? $post['customerid'] :0;
		if($ins_data['customer_id']==""){$ins_data['customer_id']=0;}
	    $ins_data['exchange_rate_type'] = isset($post['exchange_rate_type']) ? $post['exchange_rate_type'] : "";
		$ins_data['status']=1;
		$ins_data['user_id']=$user_id;
		$res_ex_id = $this->common->updatetbledata("tb_rate_exchange",$ins_data,['id'=>$id]);
      if ($res_ex_id) {
			//if(!empty($ins_data) && count($ins_data) > 0){
			 // $res_ex_id=1;
				for($i=1;$i<11;$i++) {
					$up_data1['id_'.$i] = isset($post['id_'.$i]) ? $post['id_'.$i] :0;
					//if(is_numeric($up_data1['id'.$i]) && $up_data1['id'.$i]!=""){
						//log_message("error","rate exchange insert data:".json_encode($$up_data1['id_'.$i]));
					if($up_data1['id_'.$i]!=""){

					$up_sheet1['exchange_rate_am_'.$i]= isset($post['exchange_rate_am_'.$i]) ? $post['exchange_rate_am_'.$i] :0;
					$up_sheet1['from_currency_'.$i] = isset($post['from_currency_'.$i]) ? $post['from_currency_'.$i] :"";
					$up_sheet1['to_currency_'.$i] = isset($post['to_currency_'.$i]) ? $post['to_currency_'.$i] :"";
					$up_sheet1['effective_date_'.$i] = isset($post['effective_date_'.$i]) ? $post['effective_date_'.$i] :"";
					$up_sheet1['expiry_date_'.$i] = isset($post['expiry_date_'.$i]) ? $post['expiry_date_'.$i] :"";

					if($up_sheet1['effective_date_'.$i] != ""){
			         $up_sheet1['effective_date_'.$i] = date("Y-m-d", strtotime($up_sheet1['effective_date_'.$i]));
		             }
					 if($up_sheet1['expiry_date_'.$i] != ""){
			         $up_sheet1['expiry_date_'.$i] = date("Y-m-d", strtotime($up_sheet1['expiry_date_'.$i]));
		             }
						$up_sheet[]=[
					'id'=>$up_data1['id_'.$i],
					'rate_exchange_id'=>$id,
					'exchange_from'=>$up_sheet1['from_currency_'.$i],
					'exchange_to'=>$up_sheet1['to_currency_'.$i],
					'exchange_rate'=>$up_sheet1['exchange_rate_am_'.$i],
					'effective_date'=>$up_sheet1['effective_date_'.$i],
					'expiry_date'=>$up_sheet1['expiry_date_'.$i],
					'status'=>1,
					'user_id'=>$user_id
						];
					}else{
					 $ins_data1['exchange_rate_am_'.$i] = isset($post['exchange_rate_am_'.$i]) ? $post['exchange_rate_am_'.$i] :0;
					if(is_numeric($ins_data1['exchange_rate_am_'.$i]) && $ins_data1['exchange_rate_am_'.$i]!=""){


					$ins_sheet1['exchange_rate_am_'.$i]=$ins_data1['exchange_rate_am_'.$i];
					$ins_sheet1['from_currency_'.$i] = isset($post['from_currency_'.$i]) ? $post['from_currency_'.$i] :"";
					$ins_sheet1['to_currency_'.$i] = isset($post['to_currency_'.$i]) ? $post['to_currency_'.$i] :"";
					$ins_sheet1['effective_date_'.$i] = isset($post['effective_date_'.$i]) ? $post['effective_date_'.$i] :"";
					$ins_sheet1['expiry_date_'.$i] = isset($post['expiry_date_'.$i]) ? $post['expiry_date_'.$i] :"";
					if($ins_sheet1['effective_date_'.$i] != ""){
			         $ins_sheet1['effective_date_'.$i] = date("Y-m-d", strtotime($ins_sheet1['effective_date_'.$i]));
		             }
					 if($ins_sheet1['expiry_date_'.$i] != ""){
			         $ins_sheet1['expiry_date_'.$i] = date("Y-m-d", strtotime($ins_sheet1['expiry_date_'.$i]));
		             }
					$ins_sheet[]=[
					'rate_exchange_id'=>$id,
					'exchange_from'=>$ins_sheet1['from_currency_'.$i],
					'exchange_to'=>$ins_sheet1['to_currency_'.$i],
					'exchange_rate'=>$ins_sheet1['exchange_rate_am_'.$i],
					'effective_date'=>$ins_sheet1['effective_date_'.$i],
					'expiry_date'=>$ins_sheet1['expiry_date_'.$i],
					'status'=>1,
					'user_id'=>$user_id
					];
					}
					}
				}
				if(!empty($ins_sheet)){
		     $this->db->insert_batch('tb_rate_exchange_sheet', $ins_sheet);
				}
				if(!empty($up_sheet)){
			   $this->db->update_batch('tb_rate_exchange_sheet', $up_sheet, 'id');
				}
		       /* log_message("error","rate exchange insert data:".json_encode($ins_sheet));
		       log_message("error","rate exchange update data:".json_encode($up_sheet));
		       log_message("error","Post data:".json_encode($post)); */
        }
	    echo $res_ex_id;

    }


	public function view($id)
    {
		$data=$getdata=$get_data=$getsheet=$get_sheet=[];
        $company_code = $this->session->userdata('company_code');
        $data["page_title"] = $this->lang->line('exchange_rate');
        $data["sub_title"] = $this->lang->line('general_view');
        $user_id = $this->session->userdata('user_id');
	    $wher=['re.status' => 1,'re.id'=>$id];
		$whr=[];
		$data['gen_data'] = $this->Knratemodel->getrateexchange($wher, $whr,1);
        $where_s=['status' => 1,'rate_exchange_id'=>$id];
         $get_sheet1 = $this->common->gettbldata($where_s, '*','tb_rate_exchange_sheet', 0, 0); if(!empty($get_sheet1)){

			 foreach($get_sheet1 as $get_sheet){
				 $expiry_date=$effective_date="";
				 if(($get_sheet['expiry_date']=='0000-00-00')||($get_sheet['expiry_date']=="")){
					 $expiry_date="";
				 }else{
					 $expiry_date=$get_sheet['expiry_date'];
				 }
				 if(($get_sheet['effective_date']=='0000-00-00')||($get_sheet['effective_date']=="")){
					 $effective_date="";
				 }else{
					 $effective_date=$get_sheet['effective_date'];
				 }
			 $getsheet[]=['id'=>$get_sheet['id'],'rate_exchange_id'=>$get_sheet['rate_exchange_id'],'exchange_from'=>$get_sheet['exchange_from'],'exchange_to'=>$get_sheet['exchange_to'],'exchange_rate'=>$get_sheet['exchange_rate'],'effective_date'=>$effective_date,'expiry_date'=>$expiry_date];
			 }
		 }
		$data['sheet']=$getsheet;
		/* log_message("error","rate exchange data after:".json_encode($data)); */
		  //$this->newtemplate->dashboard("KNrateexchange/view", $data);
		  $this->load->view("KNrateexchange/view", $data);
	}


	public function exchangeidgen(){
		 $year = date('y');
        $week = date('W');
		$gen_id=0;
        $res = $this->Knratemodel->getlastid([],'exchange_rate_id','tb_rate_exchange','id');
		/*  log_message("error"," last query:".$this->db->last_query()); */
		  if (!empty($res)) {
           $get_id = $res['exchange_rate_id'];
            $get_id_c = strlen($get_id);
            if ($get_id_c > 7) {

                $previous_weeknumber = substr($get_id, 4, 2);
                $get_id1 = substr($get_id, 6);
                $get_id2 = ltrim($get_id1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_id2;
                    $i_id ++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $gen_id = "RE" . $year . $week . $id1;
			 $chk = $this->common->gettblrowdata(['exchange_rate_id'=> $gen_id],'exchange_rate_id','tb_rate_exchange',0,0);
			/*  log_message("error"," last query:".$this->db->last_query()."data".json_encode($chk)); */
            if (!empty($chk)) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $gen_id = "RE" . $year . $week . $ii_d;
            } else {
                $gen_id = $gen_id;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $gen_id = "RE" . $year . $week . $id1;
        }
		return $gen_id;
	}


    public function checkname()
    {
        $post = $this->input->post(NULL,TRUE);
        $id = isset($post['id']) ? $post['id'] : "";
        $exch_rate_name = isset($post['exch_rate_name']) ? $post['exch_rate_name'] : 0;
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        // $id = $this->uri->segment(3);
        $where = [
            'exchange_rate_name' => $exch_rate_name,
            'company_code' => $company_code,
            'branch_code' => $branch_code
		];
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'exchange_rate_name', 'tb_rate_exchange', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }
     public function delete($id)
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_rate_exchange');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }



	//ALTER TABLE `tb_rate_exchange` CHANGE `customer_id` `customer_id` VARCHAR(30) NULL DEFAULT NULL;
}
