<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KPIReportForImportExportOrders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['KPIReportmodel']);

    }

    public function index(): void
    {
        $data["page_title"] = $this->lang->line('kpi_reports');
        $data["sub_title"] = $this->lang->line('general_search');
        $allBranches = $this->KPIReportmodel->getAllBrancCodes();
        $data['allBranches'] = $allBranches;
        $months = ["1" => "Jan", "2" => "Feb", "3" => "Mar", "4" => "Apr", "5" => "May", "6" => "June", "7" => "July", "8" => "Aug", "9" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec"];
        $data['months'] = $months ?? '';
        if (isset($_POST['searchSubmit']) && $_POST['searchSubmit'] == "Search") {
            $fromDate = $this->input->post("fromDate");
            $toDate = $this->input->post("toDate");
            $kpiOrders1 = $this->KPIReportmodel->getBranchWiseSalogAirOrders($fromDate, $toDate);

            foreach ($months as $key => $value) {
                if (!empty($kpiOrders1[$key])) {
                    $kpiOrders[$value] = $kpiOrders1[$key];

                    foreach ($kpiOrders[$value] as $key => $orders) {
                        $kpiOrders[$value][$key]["PUP"] = $pupOrders = $this->KPIReportmodel->getSalogOrders($orders['orders'], "PUP");
                        $kpiOrders[$value][$key]["pickups"] = $this->KPIReportmodel->getStatusOrders($pupOrders, "0500");

                        $kpiOrders[$value][$key]["DEL"] = $delOrders = $this->KPIReportmodel->getSalogOrders($orders['orders'], "DEL");
                        $kpiOrders[$value][$key]["delorders"] = $this->KPIReportmodel->getStatusOrders($delOrders, "3000");
                    }
                }
            }
            $data['kpiOrders'] = $kpiOrders ?? '';
            $getCount = [];
            foreach ($months as $key => $value):
                if (!empty($kpiOrders[$value])) {
                    $getCount[$value]['allOrdersCount'] = $getCount[$value]['allPupCount'] = $getCount[$value]['allDelCount'] = $getCount[$value]['allPickUpsCount'] = $getCount[$value]['allDeliveriesCount']= $getCount[$value]['exportPercentagesCount']= $getCount[$value]['importPercentagesCount']= $getCount[$value]['exportByBranches'] = $getCount[$value]['importByBranches']= 0;
                    $monthWiseData = $monthData[$value] = $kpiOrders[$value];
                    foreach ($allBranches as $branches):
                        $branchData[$branches] = $monthWiseData[$branches] ?? [];
                        if (!empty($branchData[$branches])) {
                            $allOrders[$value][$branches] = count($branchData[$branches]['orders']);
                            $getCount[$value]['allOrdersCount'] +=  $allOrders[$value][$branches];
                            $pupOrders[$value][$branches] = count($branchData[$branches]['PUP']);
                            $getCount[$value]['allPupCount'] +=  $pupOrders[$value][$branches];
                            $delOrders[$value][$branches] = count($branchData[$branches]['DEL']);
                            $getCount[$value]['allDelCount'] +=  $delOrders[$value][$branches];
                            $pupExecutedOrders[$value][$branches] = $branchData[$branches]['pickups'];
                            $getCount[$value]['allPickUpsCount'] +=  $pupExecutedOrders[$value][$branches];
                            $deliveryExecutedOrders[$value][$branches] = $branchData[$branches]['delorders'];
                            $getCount[$value]['allDeliveriesCount'] +=  $deliveryExecutedOrders[$value][$branches];
                        }
                        if (!empty(($branchData[$branches]) && ($branchData[$branches]['pickups']) && count($branchData[$branches]['PUP']))) {
                            $exportPercentage[$value][$branches] = round($branchData[$branches]['pickups'] / count($branchData[$branches]['PUP']) * 100,2);
                            $getCount[$value]['exportPercentagesCount'] +=  $exportPercentage[$value][$branches];
                        }
                        if (!empty(($branchData[$branches]) && ($branchData[$branches]['delorders']) && count($branchData[$branches]['DEL']))) {
                            $importPercentage[$value][$branches] = round($branchData[$branches]['delorders'] / count($branchData[$branches]['DEL']) * 100,2);
                            $getCount[$value]['importPercentagesCount'] +=  $importPercentage[$value][$branches];
                        }
                    endforeach;
                    $getCount[$value]['exportByBranches'] = round((($getCount[$value]['exportPercentagesCount']/(count($allBranches) *100)) *100),2) ?? 0;
                    $getCount[$value]['importByBranches'] = round((($getCount[$value]['importPercentagesCount']/(count($allBranches) *100)) *100),2) ?? 0;
                }
            endforeach;
            $data['getCount'] = $getCount ?? [];
            $data['allOrders'] = $allOrders ?? [];
            $data['pupOrders'] = $pupOrders ?? [];
            $data['delOrders'] = $delOrders ?? [];
            $data['pupExecutedOrders'] = $pupExecutedOrders ?? [];
            $data['deliveryExecutedOrders'] = $deliveryExecutedOrders ?? [];
            $data['exportPercentage'] = $exportPercentage ?? [];
            $data['importPercentage'] = $importPercentage ?? [];
        }
        $this->newtemplate->dashboard("kpireportForImportExportOrders/index", $data);
    }
}




