<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Kninvoice extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library('session');
		if($this->session->userdata('user_id') == ''){
			redirect('login');
		}
		$this->load->library(['form_validation','email','Billingjplfile','Aconinvoiceduedate']);
		$this->load->model(['truckwaybillmodel','common','Order']);

	}
	public function index($invoice,$type){
		$data = $order_types = array();
		require 'vendor/autoload.php';
		$zonecode = $this->session->userdata("usr_tzone");
	 	$curtz = $zonecode['timezone'];
	 	$user_currency = $session_currency = $this->session->userdata("usr_tzone")['currency'];
		$usercompany_code = $this->session->userdata('company_code');
		$data['shipper']=array();
		$data['type']=$type;
		$add_info=array();
		$orderinfo = $orders_data = array();
		$pickup_address=$delivery_address=$shipper_address=$cargo_details=$order_reference=$noity_address=$branch_details=$cargo_info= $truck_num = array();
		$from_loc=$to_loc=$truck_num=$driver_name=$departure_date='';
		$gene_order_id='';
		$total_amount = $total_vat = 0;
        try {
            $this->aconinvoiceduedate->getrequest($invoice);
        } catch (Exception $ex) {
            log_message("error", "aconinvoiceduedate error  ".$ex->getMessage());
        }
		if($invoice!=''){
			$where=array('id'=>$invoice);
			$invoiceinfo=$this->common->gettblrowdata($where,'invoice_no,invoice_date,acon_code,customer_code,code,branch_code,acon_invoice_due_date,acon_invoice_due_payment_term,acon_invoice_due_credit_terms,acon_invoice_isprint_due_date,acon_invoice_due_date_special_text','tbl_bills',0,0);
			if(count($invoiceinfo)>0){
				$add_info['invoice_no']=$invoiceinfo['invoice_no'];
				$add_info['general_customer_code']=$invoiceinfo['code'];
				$add_info['invoice_date']=date("d-m-Y",strtotime($invoiceinfo['invoice_date']));
				$add_info['customer_code']=$invoiceinfo['customer_code'];
				$add_info['acon_code']=$invoiceinfo['acon_code'];
				$branchcode=$invoiceinfo['branch_code'];
				$add_info['acon_invoice_due_date']=$invoiceinfo['acon_invoice_due_date'];
				$add_info['acon_invoice_due_payment_term']=$invoiceinfo['acon_invoice_due_payment_term'];
				$add_info['acon_invoice_due_credit_terms']=$invoiceinfo['acon_invoice_due_credit_terms'];
				$add_info['acon_invoice_isprint_due_date']=$invoiceinfo['acon_invoice_isprint_due_date'];
				$add_info['acon_invoice_due_date_special_text']=$invoiceinfo['acon_invoice_due_date_special_text'];

				$branch_info=$this->truckwaybillmodel->branch_info($branchcode);
				if($branch_info->num_rows()>0){
					$branch_details['branch_name']=$branch_info->row()->branch_name;
					$branch_details['street']=$branch_info->row()->street;
					$branch_details['city']=$branch_info->row()->city;
					$branch_details['state']=$branch_info->row()->state;
					$branch_details['country']=$branch_info->row()->country;
					$branch_details['zipcode']=$branch_info->row()->zipcode;
					$branch_details['phone']=$branch_info->row()->phone;
					$branch_details['fax']=$branch_info->row()->fax;
					$branch_details['email']=$branch_info->row()->email;
					$branch_details['bank_name']=$branch_info->row()->bank_name;
					$branch_details['bank_address']=$branch_info->row()->bank_address;
					$branch_details['bank_code']=$branch_info->row()->bank_code;
					$branch_details['bank_city']=$branch_info->row()->bank_city;
					$branch_details['bank_phone']=$branch_info->row()->bank_phone;
					$branch_details['bank_zipcode']=$branch_info->row()->bank_zipcode;
				}
				$recipient_name = $recipient_code = "";
				$where=array('type'=>'0','bill_id'=>$invoice,'status'=>1);
				$reveninfo=$this->common->gettbldata($where,'id,order_id,recipient_code,recipient_name,debtor_jfr,amount,currency','tb_reveneus',0,0);
				if(count($reveninfo)>0){
					foreach ($reveninfo as $eachreveninfo) {
						$order_id= "";
						$revenue_id = $eachreveninfo['id'];
						$order_id=$eachreveninfo['order_id'];
						$recipient_code = $eachreveninfo['recipient_code'];
						$recipient_name = $eachreveninfo['recipient_name'];
						$add_info['amount']=$eachreveninfo['amount'];
						/*$total_amount += $eachreveninfo['amount'];*/
						$add_info['currency']=$eachreveninfo['currency'];
						$add_info['debtor_jfr']=$eachreveninfo['debtor_jfr'];
						if($order_id != ""){
							$chkorder = $this->Order->getordertoedit($order_id);
							if($chkorder->num_rows() >0){
								$gene_order_id = $chkorder->row()->order_id;
								$add_info['tracking_number']=$chkorder->row()->order_id;
								$pickup_address['pickup_company']=$chkorder->row()->pickup;
								$pickup_address['pickup_country']=$chkorder->row()->pickup_country;
								$pickup_address['pickup_city']=$chkorder->row()->pickup_city;
								$pickup_address['pickup_pincode']=$chkorder->row()->pickup_pincode;
								$pickup_address['pickup_address1']=$chkorder->row()->pickup_address1;
								$delivery_address['delivery_company']=$chkorder->row()->delivery;
								$delivery_address['delivery_country']=$chkorder->row()->delivery_country;
								$delivery_address['delivery_city']=$chkorder->row()->delivery_city;
								$delivery_address['delivery_pincode']=$chkorder->row()->delivery_pincode;
								$delivery_address['delivery_address1']=$chkorder->row()->delivery_address1;
								$customer_id=$chkorder->row()->customer_id;
								if($usercompany_code == "SGKN" || $usercompany_code == "MYKN"){
									$sgmy_where = array('code'=>$recipient_code,'name'=>$recipient_name,'status'=>'1');
									$custdetails = $this->common->gettblrowdata($sgmy_where,"name,phone,code,email_id,location,street,state,country,pincode","tb_customers",0,0);
									if(count($custdetails)>0){
										$shipper_address['name']=$custdetails['name'];
										$shipper_address['location']=$custdetails['location'];
										$shipper_address['street']=$custdetails['street'];
										$shipper_address['state']=$custdetails['state'];
										$shipper_address['country']=$custdetails['country'];
										$shipper_address['pincode']=$custdetails['pincode'];
										$customer_code = $custdetails['code'];
									}
								}else{
									$where = array("id"=>$customer_id);
									$custdetails = $this->common->gettblrowdata($where,"name,phone,code,email_id,location,street,state,country,pincode","tb_customers",0,0);
									if(count($custdetails)>0){
										$shipper_address['name']=$custdetails['name'];
										$shipper_address['location']=$custdetails['location'];
										$shipper_address['street']=$custdetails['street'];
										$shipper_address['state']=$custdetails['state'];
										$shipper_address['country']=$custdetails['country'];
										$shipper_address['pincode']=$custdetails['pincode'];
										$customer_code = $custdetails['code'];
									}
								}
								$ordwhere = array("order_row_id"=>$order_id);
								$order_sub_details = $this->common->gettblrowdata($ordwhere,"delivery_term,incoterm,delivery_note,notify_party,customs_required,lane_reference","tb_order_details",0,0);
								if(count($order_sub_details)>0){
									$add_info['inco_term']=$order_sub_details['incoterm'];
									$delivery_note=$order_sub_details['delivery_note'];
									if($order_sub_details['customs_required']==1){
										$add_info['customs_required']='Y';
									}else{
										$add_info['customs_required']='N';
									}
									$add_info['lane_reference']=$order_sub_details['lane_reference'];
									$where=array("term_id"=>$delivery_note);
									$delivery_incoterms= $this->common->gettblrowdata($where,"name","tb_delivery_terms",0,0);
									if(count($delivery_incoterms)>0){
										$add_info['delivery_term']=$delivery_incoterms['name'];
									}
								}
								$where=array("order_id"=>$order_id);
								$cargo_info = $this->common->gettbldata($where,"cargo_id,handling_unit,quantity_type,length,width,height,weight,volume,quantity,quantity_type,cargo_content","tb_order_cargodetails ",0,0);
								$order_reference=$this->truckwaybillmodel->orderrefernce($gene_order_id);
								$notify_party=$this->truckwaybillmodel->notify_party($gene_order_id);
								if($notify_party->num_rows()>0){
									$noity_address['name']=$notify_party->row()->name;
									$noity_address['location_id']=$notify_party->row()->location_id;
									$noity_address['address']=$notify_party->row()->address;
									$noity_address['country']=$notify_party->row()->country;
									$noity_address['state']=$notify_party->row()->state;
								}
								$tracknum=$chkorder->row()->order_id;
								if($tracknum!=''){
									$tripinfo = getTripinfoByOrder($tracknum);
									if(isset($tripinfo['ship_id'])){
										$shift_id = $tripinfo['ship_id'];
										if(isset($tripinfo['trip_id'])){
											$driver_info = $this->truckwaybillmodel->driverinfo($tripinfo['trip_id']);
											if($driver_info->num_rows()>0){
												$driver_name=$driver_info->row()->name;
											}
										}else{
											$driver_name = $this->truckwaybillmodel->shiftdriverinfo($shift_id);
										}
								//get vehicel information
										$truck_num=$this->truckwaybillmodel->vehicelinfo($shift_id);
									}
								}
							}
							$add_info['driver_name']=$driver_name;
							if(!empty($truck_num)){
							  $add_info['truck_num']=$truck_num['register_number'];
							  $add_info['trailer_no']=$truck_num['truck_number'];
						    }
							 $pickup_datetime = $chkorder->row()->pickup_datetime;
					$delivery_datetime = $chkorder->row()->delivery_datetime;
					$getactual = getdatetimebytimezone($curtz,$pickup_datetime,DFLT_TZ);
					$add_info['departure_date'] = date("d-m-Y", strtotime($getactual['date']));
					$getactual = getdatetimebytimezone($curtz,$delivery_datetime,DFLT_TZ);
				    $add_info['arrival_date'] = date("d-m-Y", strtotime($getactual['date']));
					$charges = $vat_arr = $vat_applicable_arr = $revenues = $thailand_charges = $dummy_array = array();
					$vat_applicable_amnt = $vat_notapplicable_amnt = $final_local_vat_amount = $final_local_amount = $exchange_rate = $total_charges_amount =0;
					$final_currency = $final_local_currency = $charge_currency ="";
				    $getcharges =$this->truckwaybillmodel->getchargesbyrevid($revenue_id);
				    if(!empty($getcharges)){
						if($usercompany_code =="THKN"&& strtolower($type) == "invoice"){
							$getrevenuedetails = $this->common->gettbldata(array('id'=>$revenue_id,'status' => '1'),"id,amount,exchange_rate", "tb_reveneus", 0, 0);
							if(!empty($getrevenuedetails)){
								foreach ($getrevenuedetails as $rev) {
									$rev_amount    = $rev['amount'];
									$exchange_rate = $rev['exchange_rate'];
								}
							}
							$revenues = array($revenue_id);
							$currency_arr = $this->truckwaybillmodel->checksinglecurrencyexists_inallcharges($revenues,$session_currency);
							if(!empty($currency_arr)){
								if(count($currency_arr) >1){
									$chk_localcurrency = 0;
								}else{
									if(in_array($session_currency,$currency_arr)){
										$chk_localcurrency = 0;
									}else{
										$chk_localcurrency = 1;
									}
								}
							}
							foreach ($getcharges as $chrg) {
								$final_amount   = $chrg['amount'];
								$final_currency = $chrg['currency'];
								$vat_percentage = $chrg['vat_percentage'];
								$local_currency = $chrg['local_currency'];
								$local_amount   = $chrg['local_amount'];
								if($chk_localcurrency == "0"){
									if($local_amount > 0){
										$final_amount = $local_amount;
										$final_currency = $local_currency;
									}
								}
								$charge_currency = $final_currency;
								$local_vat_amount = $chrg['local_vat_amount'];
								$vat_amount = $chrg['vat_amount'];
								if($chk_localcurrency == "0"){
									if(is_numeric($local_vat_amount)){
										$vat_amount = $chrg['local_vat_amount'];
									}
								}
								$final_local_amount += $local_amount;
								$final_local_vat_amount += $local_vat_amount;
								$final_local_currency = $local_currency;
								$total_charges_amount += $final_amount;
								if(is_numeric($vat_percentage)){
									if($vat_percentage >0){
										if(empty($vat_arr)){
											$vat_arr[] = $vat_percentage;
										}else{
											if(!in_array($vat_percentage, $vat_arr)){
												$vat_arr[] = $vat_percentage;
											}
										}
									}else{
										$vat_percentage = "0.00";
									}
								}else{
									$vat_percentage = "0.00";
								}
								$thailand_charges[] = array('chargecodename'=>$chrg['chargecodename'],'description'=>$chrg['description'],'amount'=>$final_amount,'currency'=>$final_currency,'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$chrg['cat_val'],'cat_id'=>$chrg['cat_id'],'charge_row_id'=>$chrg['id']);
							}
						}else{
                            foreach ($getcharges as $getcharge) {
								$vat_amount = $vat_percentage = $local_vat_amount = 0;
								$charge_currency = $getcharge['currency'];
								if(is_numeric($getcharge['vat_amount'])){
									$vat_amount = $getcharge['vat_amount'];
								}
								$local_vat_amount = $getcharge['local_vat_amount'];
								if(is_numeric($local_vat_amount)){
									$vat_amount = $local_vat_amount;
								}
								if(is_numeric($getcharge['vat_percentage'])){
									$vat_percentage = $getcharge['vat_percentage'];
								}
								if($getcharge['local_amount'] > 0){
									$charges[] = array('chargecodename'=>$getcharge['chargecodename'],'amount'=>$getcharge['local_amount'],'currency'=>$getcharge['local_currency'],'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$getcharge['cat_val']);
									$total_amount += $getcharge['local_amount'];
									$total_vat += $vat_amount;
								}else{
									$charges[] = array('chargecodename'=>$getcharge['chargecodename'],'amount'=>$getcharge['amount'],'currency'=>$getcharge['currency'],'vat_percentage'=>$vat_percentage,'vat_amount'=>$vat_amount,'cat_val'=>$getcharge['cat_val']);
									$total_amount += $getcharge['amount'];
									$total_vat += $vat_amount;
								}
							}
						}
				    }
					if($usercompany_code == "THKN" && strtolower($type) == "invoice"){
						if(!empty($thailand_charges)){
							for($i=0;$i<count($thailand_charges);$i++){
								$first_vat_percentage = $thailand_charges[$i]['vat_percentage'];
								if(!in_array($thailand_charges[$i]['charge_row_id'],$dummy_array)){
									for($j=0;$j<count($thailand_charges);$j++){
										$current_vat_percentage = $thailand_charges[$j]['vat_percentage'];
										if($current_vat_percentage == $first_vat_percentage){
											$charges[] = $thailand_charges[$j];
											$dummy_array[] = $thailand_charges[$j]['charge_row_id'];
										}
									}
								}
							}
						}
						$zero_percentage = $applied_vat_amount = $total_vat_applicable_amount = $total_vatpercentage_amount =0;
						if(!empty($vat_arr)){
							foreach ($vat_arr as $vat_per) {
								$single_vat = $vat_per;
								if(!empty($charges)){
									foreach ($charges as $chrg) {
										$charge_vat_percentage = $chrg['vat_percentage'];
										if($charge_vat_percentage > 0){
											if($charge_vat_percentage == $single_vat){
												//echo "charge[amount]-".$chrg['amount']."<br>";
												$vat_applicable_amnt   += $chrg['amount'];
												//echo "vat_applicable_amnt-".$charge_vat_percentage."-".$vat_applicable_amnt."<br>";
												$applied_vat_amount += $chrg['vat_amount'];
												$vat_applicable_arr[$charge_vat_percentage] = array('vat_applicable_amount'=>$vat_applicable_amnt,'vat_percentage'=>$charge_vat_percentage,'vat_amount'=>$applied_vat_amount);
											}else{
												$applied_vat_amount = $vat_applicable_amnt = "0.00";
											}
										}
									}
								}
							}
						}
						/* print_r($vat_applicable_arr);exit;  */
						if(!empty($charges)){
							foreach ($charges as $chrg) {
								$vat_percentage = $chrg['vat_percentage'];
								if($vat_percentage == 0){
									$vat_notapplicable_amnt += $chrg['amount'];
									$vat_applicable_arr[$zero_percentage] = array('vat_applicable_amount'=>$vat_notapplicable_amnt,'vat_percentage'=>'0.00','vat_amount'=>'0.00');
								}
							}
						}
						if(!empty($vat_applicable_arr)){
							foreach ($vat_applicable_arr as $each) {
								$total_vat_applicable_amount += $each['vat_applicable_amount'];
								$total_vatpercentage_amount  += $each['vat_amount'];
							}
						}
						$final_total_amount       = $total_vat_applicable_amount + $total_vatpercentage_amount;
						$final_local_total_amount = $final_local_amount + $final_local_vat_amount;
						$orders_data[] = array('pickup_address'=>$pickup_address,'delivery_address'=>$delivery_address,'shipper_address'=>$shipper_address,'cargo_details'=>$cargo_info,'order_reference'=>$order_reference,'noity_address'=>$noity_address,'branch_details'=>$branch_details,'add_info'=>$add_info,'type'=>$type,'charges'=>$charges,'vat_applicable_arr'=>$vat_applicable_arr,'final_total_amount'=>$final_total_amount,'total_vat_applicable_amount'=>$total_vat_applicable_amount,'total_vatpercentage_amount'=>$total_vatpercentage_amount,'final_local_vat_amount'=>$final_local_vat_amount,'final_local_amount'=>$final_local_amount,'final_local_total_amount'=>$final_local_total_amount,'chk_localcurrency'=>$chk_localcurrency,'currency'=>$final_currency,'exchange_rate'=>$exchange_rate,'final_local_currency'=>$final_local_currency);
					}else{
						$orders_data[] = array('pickup_address'=>$pickup_address,'delivery_address'=>$delivery_address,'shipper_address'=>$shipper_address,'cargo_details'=>$cargo_info,'order_reference'=>$order_reference,'noity_address'=>$noity_address,'branch_details'=>$branch_details,'add_info'=>$add_info,'type'=>$type,'charges'=>$charges);
							/*$departure_date=$this->truckwaybillmodel->getvehicledetails($gene_order_id);*/
					}
						}
					}
			    //get orders infornmation
					if($this->session->userdata('company_code')=='NZKN'){
						$local_amount = 0;
                        if (strtolower($type) == "invoice") {
                            $where = ['type' => '0', 'bill_id' => $invoice, 'amount >' => 0, 'invoice_status' => 2, 'status' => 1];
                        } else {
                            $where = ['type' => '0', 'bill_id' => $invoice, 'invoice_status' => 2, 'status' => 1];
                        }
                        $ord_info=$this->common->gettbldata($where,'id,order_id,amount,createdon','tb_reveneus',0,0);
						if(count($ord_info)>0){
							foreach($ord_info as $info){
								$ordinfo=$chargeinfo=array();
								$rev_id=$info['id'];
								$ord_id=$info['order_id'];
								$createdon=date("d-m-Y",strtotime($info['createdon']));
                                $costinfo = $this->common->gettbldata(['revenue_id' => $rev_id, 'status' => '1'], 'charge_code,amount,description,local_amount', 'tb_charges', 0, 0);
								if(!empty($costinfo)){
									foreach($costinfo as $char){
										$cinfo=array();
										$charge_name='Freight';
										$chargecode=$char['charge_code'];
										$local_amount  = $char['local_amount'];
										if($chargecode!=0){
											$where=array('id'=>$chargecode);
											$charref=$this->common->gettblrowdata($where,'name','tb_charge_codes',0,0);
											if(count($charref)>0){
												$charge_name=	$charref['name'];
											}
										}
										$cinfo['charge_name']= $charge_name;
										$cinfo['charge_amount']=  $char['amount'];
										if(is_numeric($local_amount)){
											if($local_amount != '0'){
												$cinfo['charge_amount'] = $local_amount;
											}
										}
										$chargeinfo[]= $cinfo;
									}
								//$ordinfo['service']=$costinfo['charge_code'];
								//$ordinfo['description']=$costinfo['description'];
								}else{
									$cinfo['charge_name']= 'Freight';
									$cinfo['charge_amount']= '0.00' ;
									$chargeinfo[]= $cinfo;
								}
								$ordinfo['amount']=$info['amount'];
								$where=array('id'=>$ord_id);
								$parentorder=$this->common->gettblrowdata($where,'pickup_company,pickup_datetime,order_id,delivery_company,pickup_city,delivery_city,quantity,weight,volume','tb_orders',0,0);
								$where=array('order_id'=>$ord_id,'reference_id'=>'DQ');
								$ref='';
								$orderref=$this->common->gettblrowdata($where,'ref_value','tb_order_references',0,0);
								if(count($orderref)>0){
									$ref=$orderref['ref_value'];
								}
								if(count($parentorder)>0){
									$ordinfo['pickup_company']=$parentorder['pickup_company'];
									$ordinfo['delivery_company']=$parentorder['delivery_company'];
									$ordinfo['pickup_city']=$parentorder['pickup_city'];
									$ordinfo['delivery_city']=$parentorder['delivery_city'];
									$ordinfo['quantity']=$parentorder['quantity'];
									$ordinfo['weight']=$parentorder['weight'];
									$ordinfo['volume']=$parentorder['volume'];
									$ordinfo['creat_date']=$createdon;
									$ordinfo['order_reference']=$ref;
									$ordinfo['track_num']=$parentorder['order_id'];
									$ordinfo['shipment_date']=date("d-m-Y",strtotime($parentorder['pickup_datetime']));
									$ordinfo['charge_info']=$chargeinfo;
								}
								$orderinfo[]=$ordinfo;
							}
						}
					}

				}
			}
		}
		$data['pickup_address']=$pickup_address;
		$data['delivery_address']=$delivery_address;
		$data['shipper_address']=$shipper_address;
		$data['cargo_details']=$cargo_info;
		$data['order_reference']=$order_reference;
		$data['noity_address']=$noity_address;
		$data['branch_details']=$branch_details;
		$add_info['driver_name']=$driver_name;
		$add_info['truck_num']=$truck_num;
		$add_info['departure_date']=$departure_date;
		$data['add_info']=$add_info;
		$data['orderinfo']=$orderinfo;
		$data['company_code'] = $usercompany_code;

		if($this->session->userdata('company_code')=='NZKN'){
			$mpdf = new \Mpdf\Mpdf([
				'mode' => 'utf-8',
				'tempDir' => FCPATH .'assets/tmp',
				'default_font_size' => 8,
				'format' => 'A4-L'
			]);
			$mpdf->setAutoBottomMargin='stretch';

		}else{
			$mpdf = new \Mpdf\Mpdf([
				'mode' => 'utf-8',
				'tempDir' => FCPATH .'assets/tmp',
				'default_font_size' => 9, 'format' => 'A4'
			]);
			$mpdf->setAutoBottomMargin='stretch';
		}
		$footer='';
		$header='';
		if($this->session->userdata('company_code')=='NZKN'){
            $mpdf->WriteHTML($this->load->view('nzinvoice/index',$data,true));
			$footer= $this->load->view('nzinvoice/footer',$data,true);
		}else{
			if($usercompany_code == "THKN" && strtolower($type) == "invoice"){
				$thhtml = '';
				$count = count($orders_data)-1;
				echo $count;
				for($i=0;$i<count($orders_data);$i++){
					if($count == $i){
						/* $orders_data[$i]['total_amount']= $total_amount;
						$orders_data[$i]['total_vat']= $total_vat; */
						$orders_data[$i]['charge_currency'] = $charge_currency;
						$orders_data[$i]['user_currency'] = $user_currency;
					}
					$thhtml .= $this->load->view('kninvoice/thailandinvoice',$orders_data[$i],true);
				 	$footer = $this->load->view('kninvoice/footer', $data, TRUE);
					if($i<($count)){
						$thhtml .= "<pagebreak/>";
					}
					$mpdf->setFooter($footer);
				}
				$mpdf->autoScriptToLang = true;
		    	$mpdf->autoLangToFont = true;
				$mpdf->WriteHTML($thhtml);
			}
			else{
				$html = '';
				$count = count($orders_data)-1;
				for($i=0;$i<count($orders_data);$i++){
					if($count == $i){
						$orders_data[$i]['total_amount']= $total_amount;
						$orders_data[$i]['total_vat']= $total_vat;
						$orders_data[$i]['charge_currency'] = $charge_currency;
						$orders_data[$i]['user_currency'] = $user_currency;
					}
					$mpdf->WriteHTML($this->load->view('kninvoice/index',$orders_data[$i],true));
					if($i<($count)){
						$mpdf->WriteHTML("<pagebreak/>");
					}
				}
			}
		}
		if($usercompany_code != "THKN"){
			$mpdf->SetFooter($footer);
			if(count($orderinfo)>5){
				$mpdf->shrink_tables_to_fit = 1;
			}
		}
		$page_count = count($mpdf->pages);

		$mpdf->Output($gene_order_id."_".date('YmdHis').".pdf",'D');
	}

	public function advisor($invoice,$type){
		$data = $order_types = $add_info = $branch_details = $cargo_info = $orderinfo = array();
		$sub_total=0;
		require 'vendor/autoload.php';
		if($invoice!=''){
			$where=array('id'=>$invoice);
			$invoiceinfo=$this->common->gettblrowdata($where,'invoice_no,invoice_date,customer_code,branch_code,bill_group,code','tbl_bills',0,0);
			if(count($invoiceinfo)>0){
				$add_info['invoice_no']=$invoiceinfo['invoice_no'];
				$add_info['invoice_date']=date("d-m-Y",strtotime($invoiceinfo['invoice_date']));
				$add_info['customer_code']=$invoiceinfo['customer_code'];
				$branchcode=$invoiceinfo['branch_code'];
				$branch_info=$this->truckwaybillmodel->branch_info($branchcode);
				if($branch_info->num_rows()>0){
					$branch_details['branch_name']=$branch_info->row()->branch_name;
					$branch_details['street']=$branch_info->row()->street;
					$branch_details['city']=$branch_info->row()->city;
					$branch_details['state']=$branch_info->row()->state;
					$branch_details['country']=$branch_info->row()->country;
					$branch_details['zipcode']=$branch_info->row()->zipcode;
					$branch_details['phone']=$branch_info->row()->phone;
					$branch_details['fax']=$branch_info->row()->fax;
					$branch_details['email']=$branch_info->row()->email;
					$branch_details['bank_name']=$branch_info->row()->bank_name;
					$branch_details['bank_address']=$branch_info->row()->bank_address;
					$branch_details['bank_code']=$branch_info->row()->bank_code;
					$branch_details['bank_city']=$branch_info->row()->bank_city;
					$branch_details['bank_phone']=$branch_info->row()->bank_phone;
					$branch_details['bank_zipcode']=$branch_info->row()->bank_zipcode;
				}
        //if($invoiceinfo['bill_group']==1 || $invoiceinfo['bill_group']==3){
				$code=$invoiceinfo['code'];
				$where=array('code'=>$code);
				$vend_info=$this->common->gettblrowdata($where,'email,mobile,name','tbl_party_master',0,0);
				if(count($vend_info)>0){
					$add_info['car_email']=$vend_info['email'];
					$add_info['car_mobile']=$vend_info['mobile'];
					$add_info['car_name']=$vend_info['name'];
				}
	     //}
         //get orders infornmation
				$where=array('bill_id'=>$invoice);
				$ord_info=$this->common->gettbldata($where,'id,order_id,amount,createdon','tb_reveneus',0,0);
				if(count($ord_info)>0){
					foreach($ord_info as $info){
						$ordinfo=array();
						$rev_id=$info['id'];
						$ord_id=$info['order_id'];
						$createdon=date("d-m-Y",strtotime($info['createdon']));
						$where=array('revenue_id'=>$rev_id);
						$costinfo=$this->common->gettblrowdata($where,'charge_code,amount','tb_charges',0,0);
						$ordinfo['service']='Freight';
            /*if(count($costinfo)>0){
            	$ccode=$costinfo['charge_code'];
            	 $where=array('id'=>$ccode);
	              $charinfo=$this->common->gettblrowdata($where,'name','tb_charge_codes',1,0);
                if(count($charinfo)>0){
                $ordinfo['service']=$charinfo['name'];
                }

            }*/

            $where=array('revenue_id'=>273);
            $costinfo=$this->common->gettbldata($where,'charge_code,amount,description','tb_charges',0,0);
            if(count($costinfo)>0){
            	foreach($costinfo as $char){
            		$cinfo=array();
            		$charge_name='Freight';
            		$chargecode=$char['charge_code'];
            		if($chargecode!=0){
            			$where=array('id'=>$chargecode);
            			$charref=$this->common->gettblrowdata($where,'name','tb_charge_codes',0,0);
            			if(count($charref)>0){
            				$charge_name=	$charref['name'];
            			}
            		}
            		$cinfo['charge_name']= $charge_name;
            		$cinfo['charge_amount']=  $char['amount'];
            		$chargeinfo[]= $cinfo;
            	}
            }else{
            	$cinfo['charge_name']= 'Freight';
            	$cinfo['charge_amount']= '0.00' ;
            	$chargeinfo[]= $cinfo;
            }

            $ordinfo['amount']=$info['amount'];
            $where=array('id'=>$ord_id);
            $parentorder=$this->common->gettblrowdata($where,'pickup_company,delivery_company,pickup_city,delivery_city,order_id,quantity,weight,volume,pickup_datetime','tb_orders',0,0);
            $where=array('order_id'=>$ord_id,'reference_id'=>'DQ');
            $ref='';
            $orderref=$this->common->gettblrowdata($where,'ref_value','tb_order_references',0,0);
            if(count($orderref)>0){
            	$ref=$orderref['ref_value'];
            }
            if(count($parentorder)>0){
            	$ordinfo['pickup_company']=$parentorder['pickup_company'];
            	$ordinfo['delivery_company']=$parentorder['delivery_company'];
            	$ordinfo['pickup_city']=$parentorder['pickup_city'];
            	$ordinfo['delivery_city']=$parentorder['delivery_city'];
            	$ordinfo['quantity']=$parentorder['quantity'];
            	$ordinfo['weight']=$parentorder['weight'];
            	$ordinfo['volume']=$parentorder['volume'];
            	$ordinfo['creat_date']=$createdon;
            	$ordinfo['order_reference']=$ref;
            	$ordinfo['con_note']=$parentorder['order_id'];
            	$ordinfo['charge_info']=$chargeinfo;
            	$ordinfo['track_num']=$parentorder['order_id'];
            	$ordinfo['shipment_date']=date("d-m-Y",strtotime($parentorder['pickup_datetime']));

            }
            $orderinfo[]=$ordinfo;
        }
    }
}
}
   // $add_info['sub_total']=$sub_total;
$data['branch_details']=$branch_details;
$data['add_info']=$add_info;
$data['orderinfo']=$orderinfo;
$mpdf = new \Mpdf\Mpdf([
	'default_font_size' => 9,
	'format' => 'A4-L',
	'tempDir' => FCPATH .'assets/tmp',
]);
if($type=='adv'){
	$html = $this->load->view('nzinvoice/vendor_advise',$data,true);
}else{
	$html = $this->load->view('nzinvoice/vendor_invoice',$data,true);
}
$footer = $this->load->view('nzinvoice/footer',$data,true);
$mpdf->SetFooter($footer);
$mpdf->WriteHTML($html);
$mpdf->Output('vendor_advise'."_".date('YmdHis').".pdf",'D');
}

public function customeradvise($invoice){
	$data = $order_types = $add_info = $branch_details = $cargo_info = $orderinfo = array();
	$sub_total=0;
	$invoice_num = "";
	require 'vendor/autoload.php';
	if($invoice!=''){
		$where=array('id'=>$invoice);
		$invoiceinfo=$this->common->gettblrowdata($where,'invoice_no,invoice_date,customer_code,branch_code,bill_group,code','tbl_bills',0,0);
		if(count($invoiceinfo)>0){
			$add_info['invoice_no']=$invoiceinfo['invoice_no'];
			$invoice_num = $invoiceinfo['invoice_no'];
			$add_info['invoice_date']=date("d-m-Y",strtotime($invoiceinfo['invoice_date']));
			$add_info['customer_code']=$invoiceinfo['customer_code'];
			$branchcode=$invoiceinfo['branch_code'];
			$branch_info=$this->truckwaybillmodel->branch_info($branchcode);
			if($branch_info->num_rows()>0){
				$branch_details['branch_name']=$branch_info->row()->branch_name;
				$branch_details['street']=$branch_info->row()->street;
				$branch_details['city']=$branch_info->row()->city;
				$branch_details['state']=$branch_info->row()->state;
				$branch_details['country']=$branch_info->row()->country;
				$branch_details['zipcode']=$branch_info->row()->zipcode;
				$branch_details['phone']=$branch_info->row()->phone;
				$branch_details['fax']=$branch_info->row()->fax;
				$branch_details['email']=$branch_info->row()->email;
				$branch_details['bank_name']=$branch_info->row()->bank_name;
				$branch_details['bank_address']=$branch_info->row()->bank_address;
				$branch_details['bank_code']=$branch_info->row()->bank_code;
				$branch_details['bank_city']=$branch_info->row()->bank_city;
				$branch_details['bank_phone']=$branch_info->row()->bank_phone;
				$branch_details['bank_zipcode']=$branch_info->row()->bank_zipcode;
				$branch_details['country']=$branch_info->row()->country;
			}
        //if($invoiceinfo['bill_group']==1 || $invoiceinfo['bill_group']==3){
			$code=$invoiceinfo['code'];
			$where=array('code'=>$code);
			$vend_info=$this->common->gettblrowdata($where,'name,street,location_id,state,country,pincode,email,mobile','tbl_party_master',0,0);
			if(count($vend_info)>0){
				$add_info['car_email']=$vend_info['email'];
				$add_info['car_mobile']=$vend_info['mobile'];
				$add_info['inv_name']=$vend_info['name'];
				$add_info['inv_street']=$vend_info['street'];
				$add_info['inv_loc_id']=$vend_info['location_id'];
				$add_info['inv_state']=$vend_info['state'];
				$add_info['inv_country']=$vend_info['country'];
				$add_info['inv_pin']=$vend_info['pincode'];
			}
	     //}
         //get orders infornmation
			$where=array('type'=>0,'amount >'=>0,'invoice_status'=>2,'bill_id'=>$invoice,'status'=>1);
			/*$ord_info = $this->common->gettbldata($where,'id,order_id,amount,createdon','tb_reveneus',0,0);*/
			$ord_info = array();
			$this->db->select("id,order_id,amount,createdon");
			$this->db->from("tb_reveneus");
			$this->db->where($where);
			$this->db->order_by('order_id','ASC');
			$rev_res = $this->db->get();
			if($rev_res->num_rows() > 0){
				$ord_info = $rev_res->result_array();
			}
			if(count($ord_info)>0){
				foreach($ord_info as $info){
					$ordinfo=array();
					$rev_id=$info['id'];
					$ord_id=$info['order_id'];
					$createdon=date("d-m-Y",strtotime($info['createdon']));
					$ordinfo['service']='Freight';
					$costinfo=$this->truckwaybillmodel->getChargesForRevenueByASCOrder($rev_id);
                    $chargeinfo = [];
                    if(!empty($costinfo)){
						foreach($costinfo as $char){
							$cinfo= array();
							$charge_name='Freight';
							$chargecode=$char['charge_code'];
							if($chargecode!=0){
								$where=array('id'=>$chargecode);
								$charref=$this->common->gettblrowdata($where,'name,charge_code','tb_charge_codes',0,0);
								if(count($charref)>0){
									$charge_name=	$charref['charge_code'];
								}
							}
							$cinfo['charge_name']= $charge_name;
							$cinfo['charge_amount']=  $char['amount'];
							$chargeinfo[]= $cinfo;
						}
					}else{
						$cinfo['charge_name']= 'Freight';
						$cinfo['charge_amount']= '0.00' ;
						$chargeinfo[]= $cinfo;
					}
					$ordinfo['amount']=$info['amount'];
					$where = array('id'=>$ord_id);
					$parentorder=$this->common->gettblrowdata($where,'order_id,pickup_datetime,pickup_company,delivery_company,pickup_city,delivery_city','tb_orders',0,0);

					$where=array('order_id'=>$ord_id,'reference_id'=>'DQ');
					$ref='';
					$orderref=$this->common->gettblrowdata($where,'ref_value','tb_order_references',0,0);
					if(count($orderref)>0){
						$ref=$orderref['ref_value'];
					}
					$volume = $quantity = $weight = 0;
					$getcargos = $this->common->gettbldata(array('order_id'=>$ord_id,'status'=>'1'),"sum(weight) as weight,sum(volume) as volume,sum(quantity) as quantity","tb_order_cargodetails",0,0);
					if(!empty($getcargos)){
						$weight = $getcargos[0]['weight'];
						$quantity = $getcargos[0]['quantity'];
						$volume = $getcargos[0]['volume'];
					}
					if(count($parentorder)>0){
						$ordinfo['pickup_company']=$parentorder['pickup_company'];
						$ordinfo['delivery_company']=$parentorder['delivery_company'];
						$ordinfo['pickup_city']=$parentorder['pickup_city'];
						$ordinfo['delivery_city']=$parentorder['delivery_city'];
						$ordinfo['quantity']=$quantity;
						$ordinfo['weight']=$weight;
						$ordinfo['volume']=$volume;
						$ordinfo['creat_date']= date("d-m-Y",strtotime($parentorder['pickup_datetime']));
						$ordinfo['order_reference']=$ref;
						$ordinfo['con_note']=$parentorder['order_id'];
						$ordinfo['charge_info']=$chargeinfo;
					}
					$orderinfo[]=$ordinfo;
				}
			}



		}
	}
   // $add_info['sub_total']=$sub_total;
	$data['branch_details']=$branch_details;
	$data['add_info']=$add_info;
	$data['orderinfo']=$orderinfo;
	$mpdf = new \Mpdf\Mpdf([
		'default_font_size' => 9,
		'tempDir' => FCPATH .'assets/tmp',
		'format' => 'A4-L'
	]);
	$mpdf->setAutoBottomMargin='stretch';
	$footer = '';
	$header = '';
	$html='<div style="position: absolute; top: 71mm; left: 0mm; width: 130mm; rotate: -90;font-size:8px;">'.$this->lang->line('nz_pdf_left').'</div>';
	$html  .= '<div style="border:1px solid;height: 630px; !important; border-bottom:0px !important;">';
	$html .= $this->load->view('nzinvoice/customeradvise',$data,true);
	$footer = $this->load->view('nzinvoice/footer',$data,true);
	$html.='</div>';
	$mpdf->SetFooter($footer);
	$mpdf->WriteHTML($html);
	$mpdf->Output($invoice_num."_".date('YmdHis').".pdf",'D');
}
}
