<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Knratetier extends CI_Controller{
    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("Ratetiermodel");

        if (!checkUrlAccessForUser('KNRATETIER')) {
            redirect("Forbiddenaccess");
        }

    }

    public function index(){
        $data["page_title"] = "Rate Tier";
        $data["sub_title"] = $this->lang->line('general_search');
        $where = [];
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $data["services"] = [];
        $select = '`id`,`tier_id`,`tier_name`,`company_code`,`branch_code`,`(select currency
            from tbl_country_master where id=k limit 1) as curr_name)`';
        if ($company_code == "RUKN") {
            $where['company_code'] = $this->session->userdata('company_code');
        } else {
            $where['user_id'] = $this->session->userdata('user_id');
        }
        $where['branch_code'] = $this->session->userdata('branch_code');
        $where['status'] = 1;
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == 'search') {
            $from_date = $this->input->post('from_date' ,TRUE);
            if ($from_date != '') {
                $from_date = date('Y-m-d', strtotime($from_date));
            }
            $to_date = $this->input->post('to_date',TRUE);
            if ($to_date != '') {
                $to_date = date('Y-m-d', strtotime($to_date));
            }
            $tier_id = $this->input->post('tier_id',TRUE);
            if ($tier_id != '') {
                $this->db->like('tier_id', $tier_id);
            }
            if (!($from_date == '' && $to_date == '')) {
                if (!($from_date != '' && $to_date != '')) {
                    $date_ = ($from_date == '') ? $to_date : $from_date;
                    $this->db->where(['date(createdon)' => $date_]);
                }
            }
            if ($from_date != '' && $to_date != '') {
                $this->db->where("date(`createdon`) BETWEEN '$from_date' AND '$to_date'");
            }
            $this->db->where($where);
            $this->db->from('tb_tier_master');
            $data['knratetier_list'] = $this->db->select([
                'id',
                'tier_id',
                'tier_name',
                'company_code',
                'branch_code',
                'currency',
                'currency as k',
                '(select currency from tbl_country_master
            where id=k limit 1) as curr_name'
            ])->get()->result_array();
        } else {
            if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "adv_search") {
                $from_date = $this->input->post('from_date',TRUE);
                if ($from_date != '') {
                    $from_date = date('Y-m-d', strtotime($from_date));
                }
                $to_date = $this->input->post('to_date',TRUE);
                if ($to_date != '') {
                    $to_date = date('Y-m-d', strtotime($to_date));
                }
                $tier_id = $this->input->post('tier_id',TRUE);
                if ($tier_id != '') {
                    $this->db->like('tier_id', $tier_id);
                }
                if (!($from_date == '' && $to_date == '')) {
                    if (!($from_date != '' && $to_date != '')) {
                        $date_ = ($from_date == '') ? $to_date : $from_date;
                        $this->db->where(['date(createdon)' => $date_]);
                    }
                }
                if ($from_date != '' && $to_date != '') {
                    $this->db->where("date(`createdon`) BETWEEN '$from_date' AND '$to_date'");
                }
                $company_code = $this->input->post('company_code',TRUE);
                if ($company_code != '') {
                    $this->db->like('company_code', $company_code);
                    unset($where['company_code']);
                }
                $tier_name = $this->input->post('tier_name',TRUE);
                if ($tier_name != '') {
                    $this->db->like('tier_name', $tier_name);
                }
                $this->db->where($where);
                $this->db->from('tb_tier_master');
                $data['knratetier_list'] = $this->db->select(['id', 'tier_id', 'tier_name', 'company_code', 'branch_code', 'currency', 'currency as k', '(select currency from tbl_country_master where id=k limit 1) as curr_name'])->get()->result_array();
            } else {
                $data["knratetier_list"] = $this->common->gettbldata($where, ['id', 'tier_id', 'tier_name', 'company_code', 'branch_code', 'currency', 'currency as k', '(select currency from tbl_country_master where id=k limit 1) as curr_name'], 'tb_tier_master', 0, 0);
            }
        }
        $this->newtemplate->dashboard("knratetier/index", $data);
    }

    public function add(){
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $where = [];
        $table = "tbl_country_master";
        $curr = $this->common->gettbldata($where, 'id,currency', $table, 0, 0);
        $data['curr'] = $curr;
        $data['rate_tier_id'] = $this->generate_rate_tier_id();
        $data["page_title"] = "Rate Tier";
        $data["sub_title"] = $this->lang->line('general_add');
        //$this->newtemplate->dashboard("knratetier/add", $data);
        $this->load->view("knratetier/add", $data);
    }

    public function tierinsert(){
        $user_id = $this->session->userdata('user_id');
        $tier_id = $this->input->post("tier_id",TRUE);
        if ($this->Ratetiermodel->record_exist_or_not(['tier_id'], 'tb_tier_master', ['tier_id' => $tier_id])) {
            $tier_id = $this->generate_rate_tier_id();
            if ($this->Ratetiermodel->record_exist_or_not(['tier_id'], 'tb_tier_master', ['tier_id' => $tier_id])) {
                $tier_id = $this->generate_rate_tier_id();
            }
            if ($this->Ratetiermodel->record_exist_or_not(['tier_id'], 'tb_tier_master', ['tier_id' => $tier_id])) {
                $tier_id = $this->generate_rate_tier_id();
            }
            if ($this->Ratetiermodel->record_exist_or_not(['tier_id'], 'tb_tier_master', ['tier_id' => $tier_id])) {
                $tier_id = $this->generate_rate_tier_id();
            }
        }
        $tier_name = $this->input->post('tier_name',TRUE);
        $uom1 = $this->input->post('uom1',TRUE);
        $uom1_m = $this->input->post('uom1_m',TRUE);
        $company_code = $this->input->post('company_code',TRUE);
        $uom2 = $this->input->post('uom2',TRUE);
        $uom2_m = $this->input->post('uom2_m',TRUE);
        $curr = $this->input->post('curr',TRUE);
        $bill_uom = $this->input->post('bill_uom',TRUE);
        $branch_code = $this->input->post('branch_code',TRUE);
        $mr_cost = $this->input->post('mr_cost',TRUE);
        if ($company_code == '') {
            $company_code = $this->session->userdata('company_code');
        }
        if ($branch_code == '') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $tier = [
            'tier_id' => $tier_id,
            'tier_name' => isset($tier_name) ? $tier_name : "",
            'company_code' => isset($company_code) ? $company_code : "",
            'branch_code' => isset($branch_code) ? $branch_code : "",
            'uom1' => isset($uom1) ? $uom1 : "",
            'unit_measure1' => isset($uom1_m) ? $uom1_m : "",
            'uom2' => isset($uom2) ? $uom2 : "",
            'unit_measure2' => isset($uom2_m) ? $uom2_m : "",
            'currency' => isset($curr) ? $curr : "",
            'billing_uom' => isset($bill_uom) ? $bill_uom : "",
            'minimal_cost' => isset($mr_cost) ? ($mr_cost == 'on') ? '1' : '0' : '0',
            'user_id' => isset($user_id) ? $user_id : 0
        ];
        if ($this->get_min_max_records_count()) {
            if ($this->common->insertTableData('tb_tier_master', $tier)) {
                $rate_tier_last_inserted_id = $this->db->insert_id();
                $min_max_prices = [];
                for ($y = 1; $y <= 10; $y++) {
                    for ($i = 1; $i <= 10; $i++) {
                        $uom1_min = $this->input->post('uom1_' . $y . '_min',TRUE);
                        $uom1_max = $this->input->post('uom1_' . $y . '_max',TRUE);
                        $uom2_min = $this->input->post('uom2_min_c' . $i,TRUE);
                        $uom2_max = $this->input->post('uom2_max_c' . $i,TRUE);
                        $cost = $this->input->post('result_r' . $y . '_c' . $i,TRUE);
                        if (($uom1_max > $uom1_min) && ($uom2_max > $uom2_min) && is_numeric($uom1_min) && is_numeric($uom1_max) && is_numeric($uom2_min) && is_numeric($uom2_max)) {
                            $min_max_prices[] = [
                                "uom1_min" => $uom1_min,
                                'uom1_max' => $uom1_max,
                                'uom2_min' => $uom2_min,
                                'uom2_max' => $uom2_max,
                                'cost' => (is_numeric($cost) && $cost > 0) ? $cost : 0,
                                'tier_master_id' => $rate_tier_last_inserted_id,
                                'user_id' => $user_id,
                                'cost_type' => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
                            ];
                        }
                    }
                }
                if (sizeof($min_max_prices) > 0) {
                    $this->Ratetiermodel->insert_batch_records('tb_tier_rate_sheet', $min_max_prices);
                }
                echo json_encode(["status" => 1, "message" => "Records added successfully"]);
            }
        } else {
            echo json_encode(["status" => 0, "message" => "Please enter atleast one record."]);
        }
    }


    function get_min_max_records_count(){
        $min_max_prices = [];
        for ($y = 1; $y <= 10; $y++) {
            for ($i = 1; $i <= 10; $i++) {
                $uom1_min = $this->input->post('uom1_' . $y . '_min',TRUE);
                $uom1_max = $this->input->post('uom1_' . $y . '_max',TRUE);
                $uom2_min = $this->input->post('uom2_min_c' . $i,TRUE);
                $uom2_max = $this->input->post('uom2_max_c' . $i,TRUE);
                $cost = $this->input->post('result_r' . $y . '_c' . $i);
                if (is_numeric($uom1_min) && is_numeric($uom1_max) && is_numeric($uom2_min) && is_numeric($uom2_max) && is_numeric($cost)) {
                    $min_max_prices[] = [
                        "uom1_min" => $uom1_min,
                        'uom1_max' => $uom1_max,
                        'uom2_min' => $uom2_min,
                        'uom2_max' => $uom2_max,
                        'cost' => $cost
                    ];
                }
            }
        }
        if (sizeof($min_max_prices) > 0) {
            return true;
        }
        return false;
    }

    function generate_rate_tier_id(){
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $country = $this->session->userdata('usr_tzone')['country'];
        $date = date('Y-m-d');
        $current_week = date("W", time());
        $c_month = date('m');
        $c_year = date('Y');
        $query = "SELECT IFNULL(COUNT(*),0) AS records_count FROM `tb_tier_master` where  MONTH(createdon) = '$c_month' AND YEAR(createdon) = '$c_year' limit 1";
        $result = $this->db->query($query)->row_array();
        if (isset($result['records_count'])) {
            $records_count = $result['records_count'] + 1;
            if (strlen($records_count) == "1") {
                $records_count = "000" . $records_count;
            }
            if (strlen($records_count) == "2") {
                $records_count = "00" . $records_count;
            }
            if (strlen($records_count) == "3") {
                $records_count = "0" . $records_count;
            }
            $rt_id = 'RT' . substr(date('Y'), 2) . $current_week . $records_count;
            return $rt_id;
        }
    }


    public function checkname(){
        $post = $this->input->post();
        extract($post);
        $id = isset($id) ? $id : "";
        $tier_name = isset($tier_name) ? $tier_name : 0;
        $company_code = isset($company_code) ? $company_code : "";
        $where = [
            'tier_name' => $tier_name,
            'company_code' => $company_code
        ];
        if ($id) {
            $where['id !='] = $id;
        }
        $get_data = $this->common->gettblrowdata($where, 'tier_name', 'tb_tier_master', 0, 0);
        if (empty($get_data)) {
            echo "2";
        } else {
            echo "1";
        }
    }


    public function edit($id){
        if (is_numeric($id) && $id > 0) {
            $data['id'] = $id;
            $data["page_title"] = "Rate Tier";
            $data["sub_title"] = $this->lang->line('general_edit');
            $table = "tbl_country_master";
            $curr = $this->common->gettbldata([], 'id,currency', $table, 0, 0);
            $data['curr'] = $curr;
            $company_code = $this->session->userdata('company_code');
            $user_id = $this->session->userdata('user_id');
            $where['branch_code'] = $this->session->userdata('branch_code');
            if ($company_code == "RUKN") {
                $where['company_code'] = $company_code;
            } else {
                $where['user_id'] = $user_id;
            }
            $where['id'] = $id;
            $knratetier_data = $this->common->gettblrowdata($where, ['*'], 'tb_tier_master', '1', '1');
            if (sizeof($knratetier_data) > 0) {
                $data['tb_tier_master_id'] = $id;
                $data['knratetier_data'] = $knratetier_data;
                $data['knratetier_sheet'] = $this->Ratetiermodel->get_table_data_with_orderby('*', 'tb_tier_rate_sheet', ['tier_master_id' => $knratetier_data['id'], 'status' => '1'], 'id,uom2_min,uom2_max ASC');
            } else {
                redirect('knratetier/index');
            }
            //$this->newtemplate->dashboard("knratetier/edit", $data);
            $this->load->view("knratetier/edit", $data);
        } else {
            show_error('Please provide valid data.');
        }
    }

    function edit_rate_tier(){
        $tb_tier_master_id = $this->input->post('tb_tier_master_id',TRUE);
        if (!is_numeric($tb_tier_master_id)) {
            redirect('Knratetier/index');
        }
        $user_id = $this->session->userdata('user_id');
        $tier_name = $this->input->post('tier_name',TRUE);
        $uom1 = $this->input->post('uom1',TRUE);
        $uom1_m = $this->input->post('uom1_m',TRUE);
        $company_code = $this->input->post('company_code',TRUE);
        $uom2 = $this->input->post('uom2',TRUE);
        $uom2_m = $this->input->post('uom2_m',TRUE);
        $curr = $this->input->post('curr',TRUE);
        $bill_uom = $this->input->post('bill_uom',TRUE);
        $mr_cost = $this->input->post('mr_cost',TRUE);
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $update_tier = [
            'tier_name' => $tier_name,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'uom1' => $uom1,
            'unit_measure1' => $uom1_m,
            'uom2' => $uom2,
            'unit_measure2' => $uom2_m,
            'currency' => $curr,
            'billing_uom' => $bill_uom,
            'minimal_cost' => ($mr_cost == 'on') ? '1' : '0',
            'user_id' => $user_id
        ];
        $where = ['id' => $tb_tier_master_id];
        $this->common->updatetbledata('tb_tier_master', $update_tier, $where);
        $min_max_prices_insert = [];
        for ($y = 1; $y <= 10; $y++) {
            for ($i = 1; $i <= 10; $i++) {
                $uom1_min = $this->input->post('uom1_' . $y . '_min');
                $uom1_max = $this->input->post('uom1_' . $y . '_max');
                $uom2_min = $this->input->post('uom2_min_c' . $i);
                $uom2_max = $this->input->post('uom2_max_c' . $i);
                $cost = $this->input->post('result_r' . $y . '_c' . $i);
                $hidden_id = $this->input->post('result_r' . $y . '_c' . $i . '_hidden_id');
                if (is_numeric($tb_tier_master_id) && ($uom1_max > $uom1_min) && ($uom2_max > $uom2_min) && is_numeric($uom1_min) && is_numeric($uom1_max) && is_numeric($uom2_min) && is_numeric($uom2_max)) {
                    if (is_numeric($hidden_id) && $hidden_id > 0) {
                        $min_max_prices_update = [
                            "uom1_min" => $uom1_min,
                            'uom1_max' => $uom1_max,
                            'uom2_min' => $uom2_min,
                            'uom2_max' => $uom2_max,
                            'cost' => (is_numeric($cost) ? $cost : 0),
                            'user_id' => $user_id,
                            'cost_type' => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
                        ];
                        $this->common->updatetbledata('tb_tier_rate_sheet', $min_max_prices_update, ["id" => $hidden_id, 'tier_master_id' => $tb_tier_master_id]);
                    } else {
                        $min_max_prices_insert[] = [
                            "uom1_min" => $uom1_min,
                            'uom1_max' => $uom1_max,
                            'uom2_min' => $uom2_min,
                            'uom2_max' => $uom2_max,
                            'cost' => (is_numeric($cost) ? $cost : 0),
                            'tier_master_id' => $tb_tier_master_id,
                            'user_id' => $user_id,
                            'cost_type' => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
                        ];
                    }
                } else {
                    if (is_numeric($hidden_id) && $hidden_id > 0) {
                        $inactive_list_update = [
                            'status' => 0,
                            'user_id' => $user_id
                        ];
                        $this->common->updatetbledata('tb_tier_rate_sheet', $inactive_list_update, ["id" => $hidden_id, 'tier_master_id' => $tb_tier_master_id]);
                    }
                }
            }
        }

        if (sizeof($min_max_prices_insert) > 0) {
            $this->Ratetiermodel->insert_batch_records('tb_tier_rate_sheet', $min_max_prices_insert);
        }
        echo json_encode(["status" => "1", "message" => "Records Updated Successfully"]);
    }


    function generate_drop_down() {
        $type = $this->input->post('type',TRUE);
        $this->load->helper('drop_down_helper');
        $response = get_measurement_units($type, 'SELECT');
        echo $response;
    }

    function view($id){
        if (is_numeric($id) && $id > 0) {
            $data['id'] = $id;
            $data["page_title"] = "Rate Tier";
            $data["sub_title"] = $this->lang->line('general_view');
            $table = "tbl_country_master";
            $curr = $this->common->gettbldata([], 'id,currency', $table, 0, 0);
            $data['curr'] = $curr;
            $where['company_code'] = $this->session->userdata('company_code');
            $where['branch_code'] = $this->session->userdata('branch_code');
            $user_id = $this->session->userdata('user_id');
            $company_code = $this->session->userdata('company_code');
            if ($company_code == "RUKN") {
                $where['company_code'] = $company_code;
            } else {
                $where['user_id'] = $user_id;
            }
            $where['id'] = $id;
            $knratetier_data = $this->common->gettblrowdata($where, ['*'], 'tb_tier_master', '1', '1');
            if (sizeof($knratetier_data) > 0) {
                $data['tb_tier_master_id'] = $id;
                $data['knratetier_data'] = $knratetier_data;
                $data['knratetier_sheet'] = $this->Ratetiermodel->get_table_data_with_orderby('*', 'tb_tier_rate_sheet', ['tier_master_id' => $knratetier_data['id'], 'status' => '1'], 'id,uom2_min,uom2_max ASC');
            } else {
                redirect('Knratetier/index');
            }
            //$this->newtemplate->dashboard("knratetier/view", $data);
            $this->load->view("knratetier/view", $data);
        } else {
            show_error('Please provide valid data.');
        }
    }

    function delete_ratetier_data(){
        $id = $this->input->post('id',TRUE);
        if (is_numeric($id) && $id > 0) {
            $this->common->updatetbledata('tb_tier_master', ['status' => 0], ['id' => $id]);
            echo json_encode(['status' => '1', 'message' => 'Rate tier record has been deleted successfully']);
        } else {
            echo json_encode(['status' => '0', 'message' => 'Rate tier record deletion failed']);
        }
    }

    public function deletebulkrecords(): void{
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids = $this->input->post('deleteids',TRUE);
            $result = true;
            foreach ($ids as $id) {
                $this->db->where('id', $id);
                $this->db->set('status', 0);
                $result = $this->db->update('tb_tier_master');
                if (!$result) {
                    $result = false;
                }
            }
            echo $result ? "success" : "failed";
        }
    }
}
