<?php

//models,helpers,libraries,controllers

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Knruinvoice extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('Order');
        $this->load->library('email');
        $this->load->library('Billingjplfile');
        $this->load->helper('ru_invoice');
        $this->load->helper('ru_invoice_helper');
        $this->load->model('truckwaybillmodel');
    }

    public function index($invoice, $type, $sign = '1', $edoc = '0')
    {
        $data = $order_types = array();
        $data['invoice_id'] = $invoice;
        require 'vendor/autoload.php';
        $zonecode = $this->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $data['shipper'] = array();
        $data['type'] = $type;
        $add_info = array();
        $add_info['invoice_no'] = 0;
        $orderinfo = $orders_data = array();
        $pickup_address = $delivery_address = $shipper_address = $cargo_details = $order_reference = $noity_address = $branch_details = $cargo_info = array();
        $from_loc = $to_loc = $truck_num = $driver_name = $departure_date = '';
        $gene_order_id = '';
        $total_amount = 0;
        $recipient_code = '';
        if ($invoice != '') {
            $where = array('id' => $invoice);
            /*
*  Get Invoice details.
*/
            $payer_code = "";
            $invoiceinfo = $this->common->gettblrowdata($where, 'invoice_no,invoice_date,acon_code,customer_code,code,branch_code', 'tbl_bills', 0, 0);
            if (count($invoiceinfo) > 0) {
                $add_info['invoice_no'] = $invoiceinfo['invoice_no'];
                $add_info['invoice_date'] = date("d-m-Y", strtotime($invoiceinfo['invoice_date']));
                $add_info['customer_code'] = $invoiceinfo['customer_code'];
                $add_info['acon_code'] = $invoiceinfo['acon_code'];
                $branchcode = $invoiceinfo['branch_code'];
                $payer_code = $invoiceinfo['code'];
                /*
*  get Branch Info
*/
                $branch_info = $this->truckwaybillmodel->branch_info($branchcode);
                if ($branch_info->num_rows() > 0) {
                    $branch_details['branch_name'] = $branch_info->row()->branch_name;
                    $branch_details['street'] = $branch_info->row()->street;
                    $branch_details['city'] = $branch_info->row()->city;
                    $branch_details['state'] = $branch_info->row()->state;
                    $branch_details['country'] = $branch_info->row()->country;
                    $branch_details['zipcode'] = $branch_info->row()->zipcode;
                    $branch_details['phone'] = $branch_info->row()->phone;
                    $branch_details['fax'] = $branch_info->row()->fax;
                    $branch_details['email'] = $branch_info->row()->email;
                    $branch_details['bank_name'] = $branch_info->row()->bank_name;
                    $branch_details['bank_address'] = $branch_info->row()->bank_address;
                    $branch_details['bank_code'] = $branch_info->row()->bank_code;
                    $branch_details['bank_city'] = $branch_info->row()->bank_city;
                    $branch_details['bank_phone'] = $branch_info->row()->bank_phone;
                    $branch_details['bank_zipcode'] = $branch_info->row()->bank_zipcode;
                }
                $where = array('bill_id' => $invoice, 'type' => 0, 'status' => 1);
                /*
*  Get revenue Information
*/
                $reveninfo = $this->common->gettbldata($where, 'id,order_id,debtor_jfr,amount,currency,recipient_code', 'tb_reveneus', 0, 0);
                if (count($reveninfo) > 0) {
                    foreach ($reveninfo as $eachreveninfo) {
                        $order_id = "";
                        $revenue_id = $eachreveninfo['id'];
                        $order_id = $eachreveninfo['order_id'];
                        $recipient_code = $eachreveninfo['recipient_code'];
                        $add_info['amount'] = $eachreveninfo['amount'];
                        $total_amount += $eachreveninfo['amount'];
                        $add_info['currency'] = $eachreveninfo['currency'];
                        $add_info['debtor_jfr'] = $eachreveninfo['debtor_jfr'];
                        if ($order_id != "") {
                            /*
*  based on orderid get order info (like source,destionation address)
*/
                            $chkorder = $this->Order->getordertoedit($order_id);
                            if ($chkorder->num_rows() > 0) {
                                $gene_order_id = $chkorder->row()->order_id;
                                /*
*  Pickup Address
*/
                                $add_info['tracking_number'] = $chkorder->row()->order_id;
                                $pickup_address['pickup_company'] = $chkorder->row()->pickup;
                                $pickup_address['pickup_country'] = $chkorder->row()->pickup_country;
                                $pickup_address['pickup_city'] = $chkorder->row()->pickup_city;
                                $pickup_address['pickup_pincode'] = $chkorder->row()->pickup_pincode;
                                $pickup_address['pickup_address1'] = $chkorder->row()->pickup_address1;
                                $pickup_address['pickup_datetime'] = $chkorder->row()->pickup_datetime;
                                $pickup_address['pickup_endtime'] = $chkorder->row()->pickup_endtime;
                                /*
*  Delivery Address i.e consignee
*/
                                $delivery_address['delivery_company'] = $chkorder->row()->delivery;
                                $delivery_address['delivery_country'] = $chkorder->row()->delivery_country;
                                $delivery_address['delivery_city'] = $chkorder->row()->delivery_city;
                                $delivery_address['delivery_pincode'] = $chkorder->row()->delivery_pincode;
                                $delivery_address['delivery_address1'] = $chkorder->row()->delivery_address1;
                                $delivery_address['delivery_datetime'] = $chkorder->row()->delivery_datetime;
                                $delivery_address['drop_endtime'] = $chkorder->row()->drop_endtime;


                                $customer_id = $chkorder->row()->customer_id;
                                $where = array("id" => $customer_id);
                                /*
*  based on customer id get customer information.
*/
                                $custdetails = $this->common->gettblrowdata($where, "name,phone,code,email_id,location,street,state,country,pincode", "tb_customers", 0, 0);
                                if (count($custdetails) > 0) {
                                    $shipper_address['name'] = $custdetails['name'];
                                    $shipper_address['location'] = $custdetails['location'];
                                    $shipper_address['street'] = $custdetails['street'];
                                    $shipper_address['state'] = $custdetails['state'];
                                    $shipper_address['country'] = $custdetails['country'];
                                    $shipper_address['pincode'] = $custdetails['pincode'];
                                }
                                $ordwhere = array("order_row_id" => $order_id);
                                /*
*  tb_order_details based on order_id
*/
                                $order_sub_details = $this->common->gettblrowdata($ordwhere, "delivery_term,incoterm,delivery_note,notify_party,customs_required,lane_reference", "tb_order_details", 0, 0);
                                if (count($order_sub_details) > 0) {
                                    $add_info['inco_term'] = $order_sub_details['incoterm'];
                                    $delivery_note = $order_sub_details['delivery_note'];
                                    if ($order_sub_details['customs_required'] == 1) {
                                        $add_info['customs_required'] = 'Y';
                                    } else {
                                        $add_info['customs_required'] = 'N';
                                    }
                                    $add_info['lane_reference'] = $order_sub_details['lane_reference'];
                                    /*
*  Get tb_delivery_terms
*/
                                    $where = array("term_id" => $delivery_note);
                                    $delivery_incoterms = $this->common->gettblrowdata($where, "name", "tb_delivery_terms", 0, 0);
                                    if (count($delivery_incoterms) > 0) {
                                        $add_info['delivery_term'] = $delivery_incoterms['name'];
                                    }
                                }
                                $where = array("order_id" => $order_id);
                                /*
*      Get cargo details
*/
                                $cargo_info = $this->common->gettbldata($where, "cargo_id,handling_unit,quantity_type,length,width,height,weight,volume,quantity,quantity_type,cargo_content", "tb_order_cargodetails ", 0, 0);
                                /*
*  Order Reference.
*/
                                $order_reference = $this->truckwaybillmodel->orderrefernce($gene_order_id);
                                /*
*  Notificy party details.
*/
                                $notify_party = $this->truckwaybillmodel->notify_party($gene_order_id);
                                if ($notify_party->num_rows() > 0) {
                                    $noity_address['name'] = $notify_party->row()->name;
                                    $noity_address['location_id'] = $notify_party->row()->location_id;
                                    $noity_address['address'] = $notify_party->row()->address;
                                    $noity_address['country'] = $notify_party->row()->country;
                                    $noity_address['state'] = $notify_party->row()->state;
                                }
                                $tracknum = $chkorder->row()->order_id;
                                if ($tracknum != '') {
                                    $tripinfo = getTripinfoByOrder($tracknum);
                                    if (isset($tripinfo['ship_id'])) {
                                        $shift_id = $tripinfo['ship_id'];
                                        if (isset($tripinfo['trip_id'])) {
                                            /*
*     Get Driver Information
*/
                                            $driver_info = $this->truckwaybillmodel->driverinfo($tripinfo['trip_id']);
                                            if ($driver_info->num_rows() > 0) {
                                                $driver_name = $driver_info->row()->name;
                                            }
                                        } else {
                                            /*
*     Get Driver Information
*/
                                            $driver_name = $this->truckwaybillmodel->shiftdriverinfo($shift_id);
                                        }
                                        /*
*  Get Truck Information.
*/
                                        $truck_num = $this->truckwaybillmodel->vehicelinfo($shift_id);
                                    }
                                }
                            }
                            $add_info['driver_name'] = $driver_name;
                            if (!empty($truck_num)) {
                                $add_info['truck_num'] = $truck_num['register_number'];
                                $add_info['truck_num1'] = $truck_num['register_number'];
                                $add_info['trailer_no'] = $truck_num['truck_number'];
                            }
                            $pickup_datetime = $chkorder->row()->pickup_datetime;
                            $delivery_datetime = $chkorder->row()->delivery_datetime;
                            $getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                            $add_info['departure_date'] = date("d-m-Y", strtotime($getactual['date']));
                            $getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
                            $add_info['arrival_date'] = date("d-m-Y", strtotime($getactual['date']));
                            $charges = array();
                            /*
*  Charges Information (like cargecodename , amount and curreny)
*/
                            $getcharges = $this->truckwaybillmodel->getchargesbyrevid($revenue_id);
                            if (!empty($getcharges)) {
                                foreach ($getcharges as $getcharge) {
                                    if ($getcharge['local_amount'] > 0) {
                                        $charges[] = array(
                                            'chargecode' => $getcharge['chargecode'], 'chargecodename' => $getcharge['chargecodename'],
                                            'amount' => $getcharge['local_amount'], 'currency' => $getcharge['local_currency'],
                                            'vat_percentage' => $getcharge['vat_percentage'], 'vat_amount' => $getcharge['vat_amount']
                                        );
                                        $total_amount += $getcharge['local_amount'];
                                    } else {
                                        $charges[] = array(
                                            'chargecode' => $getcharge['chargecode'], 'chargecodename' => $getcharge['chargecodename'],
                                            'amount' => $getcharge['amount'], 'currency' => $getcharge['currency'],
                                            'vat_percentage' => $getcharge['vat_percentage'], 'vat_amount' => $getcharge['vat_amount']
                                        );
                                        $total_amount += $getcharge['amount'];
                                    }
                                }
                            }
                            $orders_data[] = array('pickup_address' => $pickup_address, 'delivery_address' => $delivery_address, 'shipper_address' => $shipper_address, 'cargo_details' => $cargo_info, 'order_reference' => $order_reference, 'noity_address' => $noity_address, 'branch_details' => $branch_details, 'add_info' => $add_info, 'type' => $type, 'charges' => $charges);
                            /* $departure_date=$this->truckwaybillmodel->getvehicledetails($gene_order_id); */
                        }
                    }
                    //get orders infornmation
                    if ($this->session->userdata('company_code') == 'NZKN') {
                        $where = array('bill_id' => $invoice, 'amount >' => 0, 'invoice_status' => 2, 'status' => 1);
                        $ord_info = $this->common->gettbldata($where, 'id,order_id,amount,createdon', 'tb_reveneus', 0, 0);
                        if (count($ord_info) > 0) {
                            foreach ($ord_info as $info) {
                                $ordinfo = $chargeinfo = array();
                                $rev_id = $info['id'];
                                $ord_id = $info['order_id'];
                                $createdon = date("d-m-Y", strtotime($info['createdon']));
                                $where = array('revenue_id' => $rev_id);
                                $costinfo = $this->common->gettbldata($where, 'charge_code,amount,description', 'tb_charges', 0, 0);
                                if (count($costinfo) > 0) {
                                    foreach ($costinfo as $char) {
                                        $cinfo = array();
                                        $charge_name = 'Freight';
                                        $chargecode = $char['charge_code'];
                                        if ($chargecode != 0) {
                                            $where = array('id' => $chargecode);
                                            $charref = $this->common->gettblrowdata($where, 'name', 'tb_charge_codes', 0, 0);
                                            if (count($charref) > 0) {
                                                $charge_name = $charref['name'];
                                            }
                                        }
                                        $cinfo['charge_name'] = $charge_name;
                                        $cinfo['charge_amount'] = $char['amount'];
                                        $chargeinfo[] = $cinfo;
                                    }
                                    //$ordinfo['service']=$costinfo['charge_code'];
                                    //$ordinfo['description']=$costinfo['description'];
                                } else {
                                    $cinfo['charge_name'] = 'Freight';
                                    $cinfo['charge_amount'] = '0.00';
                                    $chargeinfo[] = $cinfo;
                                }
                                $ordinfo['amount'] = $info['amount'];
                                $where = array('id' => $ord_id);
                                $parentorder = $this->common->gettblrowdata($where, 'pickup_company,pickup_datetime,order_id,delivery_company,pickup_city,delivery_city,quantity,weight,volume', 'tb_orders', 0, 0);
                                $where = array('order_id' => $ord_id, 'reference_id' => 'DQ');
                                $ref = '';
                                $orderref = $this->common->gettblrowdata($where, 'ref_value', 'tb_order_references', 0, 0);
                                if (count($orderref) > 0) {
                                    $ref = $orderref['ref_value'];
                                }
                                if (count($parentorder) > 0) {
                                    $ordinfo['pickup_company'] = $parentorder['pickup_company'];
                                    $ordinfo['delivery_company'] = $parentorder['delivery_company'];
                                    $ordinfo['pickup_city'] = $parentorder['pickup_city'];
                                    $ordinfo['delivery_city'] = $parentorder['delivery_city'];
                                    $ordinfo['quantity'] = $parentorder['quantity'];
                                    $ordinfo['weight'] = $parentorder['weight'];
                                    $ordinfo['volume'] = $parentorder['volume'];
                                    $ordinfo['creat_date'] = $createdon;
                                    $ordinfo['order_reference'] = $ref;
                                    $ordinfo['track_num'] = $parentorder['order_id'];
                                    $ordinfo['shipment_date'] = date("d-m-Y", strtotime($parentorder['pickup_datetime']));
                                    $ordinfo['charge_info'] = $chargeinfo;
                                }
                                $orderinfo[] = $ordinfo;
                            }
                        }
                    }
                }
            }
        }

        // get power of auttorney number
        //        Old Logic
        //        $where_power_of_autt = array("id" => $this->session->userdata('user_id'));
        //        $power_of_attorney_info = $this->common->gettblrowdata($where_power_of_autt, 'name,attorney_number,attorney_date', 'tb_users', 0, 0);
        //        $data['power_of_attorney_info'] = $power_of_attorney_info;
        if ($this->session->userdata('childid')) {
            $cid = $this->session->userdata('childid');
            $get_signaturepath = $this->common->gettblrowdata(array("id" => $cid), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_user_logins', 0, 0);
            if (!empty($get_signaturepath)) {
                $signpath = $get_signaturepath['signpath'];
                $attorneyinfo = array('name' => $get_signaturepath['name'], 'attorney_number' => $get_signaturepath['attorney_number'], 'attorney_date' => $get_signaturepath['attorney_date'], 'job_profile' => $get_signaturepath['job_profile']);
                $data['power_of_attorney_info'] = $attorneyinfo;
            }
        } else {
            $get_userdetails = $this->common->gettblrowdata(array("id" => $this->session->userdata('user_id')), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_users', 0, 0);
            if (!empty($get_userdetails)) {
                $signpath = $get_userdetails['signpath'];
                $attorneyinfo = array('name' => $get_userdetails['name'], 'attorney_number' => $get_userdetails['attorney_number'], 'attorney_date' => $get_userdetails['attorney_date'], 'job_profile' => $get_userdetails['job_profile']);
                $data['power_of_attorney_info'] = $attorneyinfo;
            }
        }

        // recepient/payee information
        $where_payee = array("company_code" => $this->session->userdata('company_code'), 'code' => $payer_code, 'status' => 1);
        $data['payee_info'] = $payee_info__ = $this->common->gettblrowdata($where_payee, 'id,name,division_name,street,pincode,country,contract_no,contract_date,house_number,building,state,location_id city', 'tbl_party_master', 0, 0);
        $where_payee = array("partner_id" => $payee_info__['id']);
        $bparty_account_info = $this->common->gettblrowdata($where_payee, 'IFNULL(account_number,"-") account_number', 'tbl_partner_accounts', 0, 0);
        $data['account_number'] = isset($bparty_account_info['account_number']) ? $bparty_account_info['account_number'] : '-';

        $data['pickup_address'] = $pickup_address;
        $data['delivery_address'] = $delivery_address;
        // customer
        $data['shipper_address'] = $shipper_address;
        $data['cargo_details'] = $cargo_info;
        $data['order_reference'] = $order_reference;
        $data['noity_address'] = $noity_address;
        $data['branch_details'] = $branch_details;
        $add_info['driver_name'] = $driver_name;
        $add_info['truck_num'] = $truck_num;
        $add_info['departure_date'] = $departure_date;
        $data['add_info'] = $add_info;
        $data['orderinfo'] = $orderinfo;
        $data['charges'] = $charges;
        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'tempDir' => FCPATH .'assets/tmp',
            'default_font_size' => 9,
            'format' => 'A4'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $footer = '';
        $header = '';
        if ($this->session->userdata('company_code') == 'RUKN') {
            // bulk ru
            $html = '';
            $count = count($orders_data) - 1;
            if ((!empty($orders_data)) && sizeof($orders_data) > 1) {
                // bulk
                /*
for ($i = 0; $i < count($orders_data); $i++) {
if ($count == $i) {
$orders_data[$i]['total_amount'] = $total_amount;
}
$orders_data[$i]['power_of_attorney_info'] = $power_of_attorney_info;
$orders_data[$i]['payee_info'] = $payee_info__;
$html .= $this->load->view('kninvoice/ru_bulk_invoice', $orders_data[$i], true);
if ($i < ($count)) {
$html .= "<pagebreak/>";
}
}
*/
                for ($i = 0; $i < count($orders_data); $i++) {
                    $orders_data[$i]['power_of_attorney_info'] = $attorneyinfo;
                    $orders_data[$i]['payee_info'] = $payee_info__;
                }
                $html .= $this->load->view('kninvoice/ru_bulk_invoice', array("info" => $orders_data, 'sign' => $sign, 'invoice_id' => $invoice), true);
            } else {
                $data['sign'] = $sign;
                $html = $this->load->view('kninvoice/ru_single_invoice', $data, true);
            }
            $mpdf->SetFooter($footer);
            if (count($orderinfo) > 5) {
                $mpdf->shrink_tables_to_fit = 1;
            }
            $mpdf->WriteHTML($html);
            $page_count = count($mpdf->pages);
            if ($edoc == 0) {
                if (strtolower($type) == "credit" || strtolower($type) == "invoice") {
                    /*    $this->billingjplfile->filegeneration($invoice,$page_count,$type);
*/
                }
                $mpdf->Output($add_info['invoice_no'] . "_" . date('YmdHis') . ".pdf", 'D');
            } else {
                $invoicepdfpath = EDOC_PATH . $add_info['invoice_no'] . ".pdf";
                $mpdf->Output($invoicepdfpath, 'F');
                return $invoicepdfpath;
            }
        }
    }

    public function advisor($invoice, $type)
    {
        $data = $order_types = $add_info = $branch_details = $cargo_info = $orderinfo = array();
        $sub_total = 0;
        require 'vendor/autoload.php';
        if ($invoice != '') {
            $where = array('id' => $invoice);
            $invoiceinfo = $this->common->gettblrowdata($where, 'invoice_no,invoice_date,customer_code,branch_code,bill_group,code', 'tbl_bills', 0, 0);
            if (count($invoiceinfo) > 0) {
                $add_info['invoice_no'] = $invoiceinfo['invoice_no'];
                $add_info['invoice_date'] = date("d-m-Y", strtotime($invoiceinfo['invoice_date']));
                $add_info['customer_code'] = $invoiceinfo['customer_code'];
                $branchcode = $invoiceinfo['branch_code'];
                $branch_info = $this->truckwaybillmodel->branch_info($branchcode);
                if ($branch_info->num_rows() > 0) {
                    $branch_details['branch_name'] = $branch_info->row()->branch_name;
                    $branch_details['street'] = $branch_info->row()->street;
                    $branch_details['city'] = $branch_info->row()->city;
                    $branch_details['state'] = $branch_info->row()->state;
                    $branch_details['country'] = $branch_info->row()->country;
                    $branch_details['zipcode'] = $branch_info->row()->zipcode;
                    $branch_details['phone'] = $branch_info->row()->phone;
                    $branch_details['fax'] = $branch_info->row()->fax;
                    $branch_details['email'] = $branch_info->row()->email;
                    $branch_details['bank_name'] = $branch_info->row()->bank_name;
                    $branch_details['bank_address'] = $branch_info->row()->bank_address;
                    $branch_details['bank_code'] = $branch_info->row()->bank_code;
                    $branch_details['bank_city'] = $branch_info->row()->bank_city;
                    $branch_details['bank_phone'] = $branch_info->row()->bank_phone;
                    $branch_details['bank_zipcode'] = $branch_info->row()->bank_zipcode;
                }
                //if($invoiceinfo['bill_group']==1 || $invoiceinfo['bill_group']==3){
                $code = $invoiceinfo['code'];
                $where = array('code' => $code);
                $vend_info = $this->common->gettblrowdata($where, 'email,mobile,name', 'tbl_party_master', 0, 0);
                if (count($vend_info) > 0) {
                    $add_info['car_email'] = $vend_info['email'];
                    $add_info['car_mobile'] = $vend_info['mobile'];
                    $add_info['car_name'] = $vend_info['name'];
                }
                //}
                //get orders infornmation
                $where = array('bill_id' => $invoice);
                $ord_info = $this->common->gettbldata($where, 'id,order_id,amount,createdon', 'tb_reveneus', 0, 0);
                if (count($ord_info) > 0) {
                    foreach ($ord_info as $info) {
                        $ordinfo = array();
                        $rev_id = $info['id'];
                        $ord_id = $info['order_id'];
                        $createdon = date("d-m-Y", strtotime($info['createdon']));
                        $where = array('revenue_id' => $rev_id);
                        $costinfo = $this->common->gettblrowdata($where, 'charge_code,amount', 'tb_charges', 0, 0);
                        $ordinfo['service'] = 'Freight';
                        /* if(count($costinfo)>0){
$ccode=$costinfo['charge_code'];
$where=array('id'=>$ccode);
$charinfo=$this->common->gettblrowdata($where,'name','tb_charge_codes',1,0);
if(count($charinfo)>0){
$ordinfo['service']=$charinfo['name'];
}

} */

                        $where = array('revenue_id' => 273);
                        $costinfo = $this->common->gettbldata($where, 'charge_code,amount,description', 'tb_charges', 0, 0);
                        if (count($costinfo) > 0) {
                            foreach ($costinfo as $char) {
                                $cinfo = array();
                                $charge_name = 'Freight';
                                $chargecode = $char['charge_code'];
                                if ($chargecode != 0) {
                                    $where = array('id' => $chargecode);
                                    $charref = $this->common->gettblrowdata($where, 'name', 'tb_charge_codes', 0, 0);
                                    if (count($charref) > 0) {
                                        $charge_name = $charref['name'];
                                    }
                                }
                                $cinfo['charge_name'] = $charge_name;
                                $cinfo['charge_amount'] = $char['amount'];
                                $chargeinfo[] = $cinfo;
                            }
                        } else {
                            $cinfo['charge_name'] = 'Freight';
                            $cinfo['charge_amount'] = '0.00';
                            $chargeinfo[] = $cinfo;
                        }

                        $ordinfo['amount'] = $info['amount'];
                        $where = array('id' => $ord_id);
                        $parentorder = $this->common->gettblrowdata($where, 'pickup_company,delivery_company,pickup_city,delivery_city,order_id,quantity,weight,volume,pickup_datetime', 'tb_orders', 0, 0);
                        $where = array('order_id' => $ord_id, 'reference_id' => 'DQ');
                        $ref = '';
                        $orderref = $this->common->gettblrowdata($where, 'ref_value', 'tb_order_references', 0, 0);
                        if (count($orderref) > 0) {
                            $ref = $orderref['ref_value'];
                        }
                        if (count($parentorder) > 0) {
                            $ordinfo['pickup_company'] = $parentorder['pickup_company'];
                            $ordinfo['delivery_company'] = $parentorder['delivery_company'];
                            $ordinfo['pickup_city'] = $parentorder['pickup_city'];
                            $ordinfo['delivery_city'] = $parentorder['delivery_city'];
                            $ordinfo['quantity'] = $parentorder['quantity'];
                            $ordinfo['weight'] = $parentorder['weight'];
                            $ordinfo['volume'] = $parentorder['volume'];
                            $ordinfo['creat_date'] = $createdon;
                            $ordinfo['order_reference'] = $ref;
                            $ordinfo['con_note'] = $parentorder['order_id'];
                            $ordinfo['charge_info'] = $chargeinfo;
                            $ordinfo['track_num'] = $parentorder['order_id'];
                            $ordinfo['shipment_date'] = date("d-m-Y", strtotime($parentorder['pickup_datetime']));
                        }
                        $orderinfo[] = $ordinfo;
                    }
                }
            }
        }
        // $add_info['sub_total']=$sub_total;
        $data['branch_details'] = $branch_details;
        $data['add_info'] = $add_info;
        $data['orderinfo'] = $orderinfo;
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4-L'
        ]);
        if ($type == 'adv') {
            $html = $this->load->view('nzinvoice/vendor_advise', $data, true);
        } else {
            $html = $this->load->view('nzinvoice/vendor_invoice', $data, true);
        }
        $footer = $this->load->view('nzinvoice/footer', $data, true);
        $mpdf->SetFooter($footer);
        $mpdf->WriteHTML($html);
        $mpdf->Output('vendor_advise' . "_" . date('YmdHis') . ".pdf", 'D');
    }

    public function customeradvise($invoice)
    {
        $data = $order_types = $add_info = $branch_details = $cargo_info = $orderinfo = array();
        $sub_total = 0;
        $invoice_num = "";
        require 'vendor/autoload.php';
        if ($invoice != '') {
            $where = array('id' => $invoice);
            $invoiceinfo = $this->common->gettblrowdata($where, 'invoice_no,invoice_date,customer_code,branch_code,bill_group,code', 'tbl_bills', 0, 0);
            if (count($invoiceinfo) > 0) {
                $add_info['invoice_no'] = $invoiceinfo['invoice_no'];
                $invoice_num = $invoiceinfo['invoice_no'];
                $add_info['invoice_date'] = date("d-m-Y", strtotime($invoiceinfo['invoice_date']));
                $add_info['customer_code'] = $invoiceinfo['customer_code'];
                $branchcode = $invoiceinfo['branch_code'];
                $branch_info = $this->truckwaybillmodel->branch_info($branchcode);
                if ($branch_info->num_rows() > 0) {
                    $branch_details['branch_name'] = $branch_info->row()->branch_name;
                    $branch_details['street'] = $branch_info->row()->street;
                    $branch_details['city'] = $branch_info->row()->city;
                    $branch_details['state'] = $branch_info->row()->state;
                    $branch_details['country'] = $branch_info->row()->country;
                    $branch_details['zipcode'] = $branch_info->row()->zipcode;
                    $branch_details['phone'] = $branch_info->row()->phone;
                    $branch_details['fax'] = $branch_info->row()->fax;
                    $branch_details['email'] = $branch_info->row()->email;
                    $branch_details['bank_name'] = $branch_info->row()->bank_name;
                    $branch_details['bank_address'] = $branch_info->row()->bank_address;
                    $branch_details['bank_code'] = $branch_info->row()->bank_code;
                    $branch_details['bank_city'] = $branch_info->row()->bank_city;
                    $branch_details['bank_phone'] = $branch_info->row()->bank_phone;
                    $branch_details['bank_zipcode'] = $branch_info->row()->bank_zipcode;
                    $branch_details['country'] = $branch_info->row()->country;
                }
                //if($invoiceinfo['bill_group']==1 || $invoiceinfo['bill_group']==3){
                $code = $invoiceinfo['code'];
                $where = array('code' => $code);
                $vend_info = $this->common->gettblrowdata($where, 'name,street,location_id,state,country,pincode,email,mobile', 'tbl_party_master', 0, 0);
                if (count($vend_info) > 0) {
                    $add_info['car_email'] = $vend_info['email'];
                    $add_info['car_mobile'] = $vend_info['mobile'];
                    $add_info['inv_name'] = $vend_info['name'];
                    $add_info['inv_street'] = $vend_info['street'];
                    $add_info['inv_loc_id'] = $vend_info['location_id'];
                    $add_info['inv_state'] = $vend_info['state'];
                    $add_info['inv_country'] = $vend_info['country'];
                    $add_info['inv_pin'] = $vend_info['pincode'];
                }
                //}
                //get orders infornmation
                $where = array('type' => 0, 'amount >' => 0, 'invoice_status' => 2, 'bill_id' => $invoice, 'status' => 1);
                /* $ord_info = $this->common->gettbldata($where,'id,order_id,amount,createdon','tb_reveneus',0,0); */
                $ord_info = array();
                $this->db->select("id,order_id,amount,createdon");
                $this->db->from("tb_reveneus");
                $this->db->where($where);
                $this->db->order_by('order_id', 'ASC');
                $rev_res = $this->db->get();
                if ($rev_res->num_rows() > 0) {
                    $ord_info = $rev_res->result_array();
                }
                if (count($ord_info) > 0) {
                    foreach ($ord_info as $info) {
                        $ordinfo = array();
                        $rev_id = $info['id'];
                        $ord_id = $info['order_id'];
                        $createdon = date("d-m-Y", strtotime($info['createdon']));
                        $ordinfo['service'] = 'Freight';
                        $where = array('revenue_id' => $rev_id);
                        $costinfo = array();
                        /* $costinfo=$this->common->gettbldata($where,'charge_code,amount,description','tb_charges',0,0); */
                        $this->db->select("charge_code,amount,description");
                        $this->db->from("tb_charges");
                        $this->db->where($where);
                        $this->db->order_by('id', 'ASC');
                        $res = $this->db->get();
                        if ($res->num_rows() > 0) {
                            $costinfo = $res->result_array();
                        }
                        $chargeinfo = array();
                        if (count($costinfo) > 0) {
                            foreach ($costinfo as $char) {
                                $cinfo = array();
                                $charge_name = 'Freight';
                                $chargecode = $char['charge_code'];
                                if ($chargecode != 0) {
                                    $where = array('id' => $chargecode);
                                    $charref = $this->common->gettblrowdata($where, 'name,charge_code', 'tb_charge_codes', 0, 0);
                                    if (count($charref) > 0) {
                                        $charge_name = $charref['charge_code'];
                                    }
                                }
                                $cinfo['charge_name'] = $charge_name;
                                $cinfo['charge_amount'] = $char['amount'];
                                $chargeinfo[] = $cinfo;
                            }
                        } else {
                            $cinfo['charge_name'] = 'Freight';
                            $cinfo['charge_amount'] = '0.00';
                            $chargeinfo[] = $cinfo;
                        }
                        $ordinfo['amount'] = $info['amount'];
                        $where = array('id' => $ord_id);
                        $parentorder = $this->common->gettblrowdata($where, 'order_id,pickup_datetime,pickup_company,delivery_company,pickup_city,delivery_city', 'tb_orders', 0, 0);

                        $where = array('order_id' => $ord_id, 'reference_id' => 'DQ');
                        $ref = '';
                        $orderref = $this->common->gettblrowdata($where, 'ref_value', 'tb_order_references', 0, 0);
                        if (count($orderref) > 0) {
                            $ref = $orderref['ref_value'];
                        }
                        $volume = $quantity = $weight = 0;
                        $getcargos = $this->common->gettbldata(array('order_id' => $ord_id, 'status' => '1'), "sum(weight) as weight,sum(volume) as volume,sum(quantity) as quantity", "tb_order_cargodetails", 0, 0);
                        if (!empty($getcargos)) {
                            $weight = $getcargos[0]['weight'];
                            $quantity = $getcargos[0]['quantity'];
                            $volume = $getcargos[0]['volume'];
                        }
                        if (count($parentorder) > 0) {
                            $ordinfo['pickup_company'] = $parentorder['pickup_company'];
                            $ordinfo['delivery_company'] = $parentorder['delivery_company'];
                            $ordinfo['pickup_city'] = $parentorder['pickup_city'];
                            $ordinfo['delivery_city'] = $parentorder['delivery_city'];
                            $ordinfo['quantity'] = $quantity;
                            $ordinfo['weight'] = $weight;
                            $ordinfo['volume'] = $volume;
                            $ordinfo['creat_date'] = date("d-m-Y", strtotime($parentorder['pickup_datetime']));
                            $ordinfo['order_reference'] = $ref;
                            $ordinfo['con_note'] = $parentorder['order_id'];
                            $ordinfo['charge_info'] = $chargeinfo;
                        }
                        $orderinfo[] = $ordinfo;
                    }
                }
            }
        }
        // $add_info['sub_total']=$sub_total;
        $data['branch_details'] = $branch_details;
        $data['add_info'] = $add_info;
        $data['orderinfo'] = $orderinfo;
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4-L'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $footer = '';
        $header = '';
        $html = '<div style="position: absolute; top: 71mm; left: 0mm; width: 130mm; rotate: -90;font-size:8px;">' . $this->lang->line('nz_pdf_left') . '</div>';
        $html .= '<div style="border:1px solid;height: 630px; !important; border-bottom:0px !important;">';
        $html .= $this->load->view('nzinvoice/customeradvise', $data, true);
        $footer = $this->load->view('nzinvoice/footer', $data, true);
        $html .= '</div>';

        $mpdf->simpleTables = true;
        $mpdf->packTableData = true;
        $keep_table_proportions = TRUE;
        $mpdf->shrink_tables_to_fit = 1;

        $mpdf->SetFooter($footer);
        $mpdf->WriteHTML($html);
        $mpdf->Output($invoice_num . "_" . date('YmdHis') . ".pdf", 'D');
    }

    function ru_bulk_invoice_pdf()
    {
        require 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4-L'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $html = $this->load->view('kninvoice/ru_bulk_invoice', array(), true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('ru_bulk_invoice' . "_" . date('YmdHis') . ".pdf", 'D');
    }

    function ru_single_invoice_pdf()
    {
        require 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4-L'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $html = $this->load->view('kninvoice/ru_single_invoice', array(), true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('ru_single_invoice' . "_" . date('YmdHis') . ".pdf", 'D');
    }

    function ru_bulk_invoice1()
    {
        $this->load->view('kninvoice/ru_bulk_invoice');
    }

    public function getfakturabulkdata($invoiceinfo, $invoice, $sign)
    {
        $data = $order_types = [];
        $zonecode = $this->session->userdata("usr_tzone");
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $curtz = $zonecode['timezone'];
        $data['shipper'] = [];
        $add_info = [];
        $orderinfo = $orders_data = [];
        $gene_order_id = $bulkact_chargename = '';
        $total_amount = 0;
        if (!empty($invoiceinfo)) {
            $signpath = "";
            $attorneyinfo = [];
            $attorneyinfo = ['name' => "", 'attorney_number' => "", 'attorney_date' => ""];
            if (isset($_SESSION["childid"])) {
                $cid = $this->session->userdata('childid');
                $get_signaturepath = $this->common->gettblrowdata(
                    ["id" => $cid],
                    'name,attorney_number,attorney_date,signpath,job_profile',
                    'tb_user_logins',
                    0,
                    0
                );
                if (!empty($get_signaturepath)) {
                    $signpath = $get_signaturepath['signpath'];
                    $attorney_date = $get_signaturepath['attorney_date'];
                    if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                        $attorney_date = date("d.m.Y", strtotime($attorney_date));
                    } else {
                        $attorney_date = "";
                    }
                    $attorneyinfo = [
                        'name' => $get_signaturepath['name'],
                        'attorney_number' => $get_signaturepath['attorney_number'],
                        'attorney_date' => $attorney_date,
                        'job_profile' => $get_signaturepath['job_profile']
                    ];
                }
            } else {
                $get_userdetails = $this->common->gettblrowdata(
                    ["id" => $user_id],
                    'name,attorney_number,attorney_date,signpath,job_profile',
                    'tb_users',
                    0,
                    0
                );
                if (!empty($get_userdetails)) {
                    $signpath = $get_userdetails['signpath'];
                    $attorney_date = $get_userdetails['attorney_date'];
                    if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                        $attorney_date = date("d.m.Y", strtotime($attorney_date));
                    } else {
                        $attorney_date = "";
                    }
                    $attorneyinfo = [
                        'name' => $get_userdetails['name'],
                        'attorney_number' => $get_userdetails['attorney_number'],
                        'attorney_date' => $attorney_date,
                        'job_profile' => $get_userdetails['job_profile']
                    ];
                }
            }
            $add_info['invoice_no'] = $invoice_no = $invoiceinfo['invoice_no'];
            $add_info['invoice_date'] = date("d-m-Y", strtotime($invoiceinfo['invoice_date']));
            $invoice_date = date("d.m.Y", strtotime($invoiceinfo['invoice_date']));
            $add_info['customer_code'] = $invoiceinfo['customer_code'];
            $add_info['acon_code'] = $invoiceinfo['acon_code'];
            $branchcode = $invoiceinfo['branch_code'];
            $code = $invoiceinfo['code'];
            $invoice_description = $invoiceinfo['invoice_description'];
            $where_payee = ["company_code" => $company_code, 'code' => $code, 'status' => 1];
            $getpayeeinfo = $this->common->gettblrowdata(
                $where_payee,
                'name,location_id,state,street,pincode,building,house_number,country,vat_reg_no,tax_payer_no,contract_no,contract_date',
                'tbl_party_master',
                0,
                0
            );
            $payeraddress = "";
            $pay_contract_date = $pay_contract_no = "";
            if (!empty($getpayeeinfo)) {
                if ($getpayeeinfo['pincode'] != "") {
                    $payeraddress .= $getpayeeinfo['pincode'] . ", ";
                }
                if ($getpayeeinfo['country'] != "") {
                    $payeraddress .= $getpayeeinfo['country'] . ", ";
                }
                if ($getpayeeinfo['state'] != "") {
                    $payeraddress .= $getpayeeinfo['state'] . ", ";
                }
                if ($getpayeeinfo['location_id'] != "") {
                    $payeraddress .= $getpayeeinfo['location_id'] . ", ";
                }
                if ($getpayeeinfo['street'] != "") {
                    $payeraddress .= $getpayeeinfo['street'] . ", ";
                }
                if ($getpayeeinfo['house_number'] != "") {
                    $payeraddress .= $getpayeeinfo['house_number'] . ", ";
                }
                if ($getpayeeinfo['building'] != "") {
                    $payeraddress .= $getpayeeinfo['building'];
                }
                $add_info['payee_info'] = [
                    'name' => $getpayeeinfo['name'],
                    'vat_reg_no' => $getpayeeinfo['vat_reg_no'],
                    'tax_payer_no' => $getpayeeinfo['tax_payer_no'],
                    'contract_no' => $getpayeeinfo['contract_no'],
                    'contract_date' => $getpayeeinfo['contract_date'],
                    'payeraddress' => $payeraddress
                ];
                $pay_contract_date = $getpayeeinfo['contract_date'];
                if ($pay_contract_date != "" && $pay_contract_date != "0000-00-00") {
                    $pay_contract_date = date("d.m.Y", strtotime($pay_contract_date));
                } else {
                    $pay_contract_date = "";
                }
                $pay_contract_no = $getpayeeinfo['contract_no'];
            }
            $earliestpickup = $latestpickup = "";
            $getpickupdaterange = $this->truckwaybillmodel->getpickupdaterange($invoice);
            if (!empty($getpickupdaterange)) {
                $earliestpickup = $getpickupdaterange['earliestpickup'];
                if ($earliestpickup != "") {
                    $earliestpickup = date("d.m.Y", strtotime($earliestpickup));
                }
                $latestpickup = $getpickupdaterange['latestpickup'];
                if ($latestpickup != "") {
                    $latestpickup = date("d.m.Y", strtotime($latestpickup));
                }
            }
            $frtchargedesc = "";
            $where = ['bill_id' => $invoice, 'type' => 0, 'status' => 1];
            $reveninfo = $this->common->gettbldata(
                $where,
                'id,order_id,recipient_code,debtor_jfr,amount,currency',
                'tb_reveneus',
                0,
                0
            );
            if (!empty($reveninfo)) {
                $tot_chargeamount = $tot_vatamount = $total_amount = 0;
                $charges = $chargeby_vat = [];
                foreach ($reveninfo as $eachreveninfo) {
                    $order_id = "";
                    $revenue_id = $eachreveninfo['id'];
                    $order_id = $eachreveninfo['order_id'];
                    $add_info['amount'] = $eachreveninfo['amount'];
                    $add_info['currency'] = $eachreveninfo['currency'];
                    $add_info['debtor_jfr'] = $eachreveninfo['debtor_jfr'];
                    $recipient_code = $eachreveninfo['recipient_code'];
                    $pickup_city = $delivery_city = $driver_name = $vehicleno = "";
                    $trip_id = $shift_id = 0;
                    if ($order_id != "") {
                        $chkorder = $this->Order->getordertoedit($order_id);
                        if ($chkorder->num_rows() > 0) {
                            $gene_order_id = $chkorder->row()->order_id;
                            $trip_id = $chkorder->row()->trip_id;
                            $shift_id = $chkorder->row()->shift_id;
                            $pickup_city = $chkorder->row()->pickup_city;
                            $delivery_city = $chkorder->row()->delivery_city;
                            $pickup_datetime = $chkorder->row()->pickup_datetime;
                            if ($pickup_datetime != "") {
                                $getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                                $pickup_datetime = $getactual['datetime'];
                                $pickup_datetime = date("d.m.Y", strtotime($pickup_datetime));
                            }
                            $delivery_datetime = $chkorder->row()->delivery_datetime;

                            if ($delivery_datetime != "") {
                                $getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
                                $delivery_datetime = $getactual['datetime'];
                                $delivery_datetime = date("d.m.Y", strtotime($delivery_datetime));
                            }
                            $actual_pickup_dt = $pickup_datetime;
                            $actual_delivery_dt = $delivery_datetime;
                            $getstatusdates = $this->getstatusdates($gene_order_id);
                            if ($getstatusdates['statuspickupdate'] != "") {
                                $actual_pickup_dt = $getstatusdates['statuspickupdate'];
                            }
                            if ($getstatusdates['statusdeliverydate'] != "") {
                                $actual_delivery_dt = $getstatusdates['statusdeliverydate'];
                            }
                            if ($trip_id > 0) {
                                $getdriverinfo = $this->truckwaybillmodel->driverinfo($trip_id);
                                if ($getdriverinfo->num_rows() > 0) {
                                    $driver_name = $getdriverinfo->row()->name;
                                }
                            }
                            if ($shift_id > 0) {
                                $getvehicleinfo = $this->truckwaybillmodel->vehicelinfo($shift_id);
                                if (!empty($getvehicleinfo)) {
                                    $vehicleno = $getvehicleinfo['register_number'];
                                }
                            }
                        }
                        $actual_pickup_dt = $pickup_datetime;
                        $bulkact_chargename = "Транспортно-экспедиционные услуги";
                        $bulkact_chargename .= " за период с " . $earliestpickup . " по ";
                        $bulkact_chargename .= $latestpickup;
                        $bulkact_chargename .= " по договору № " . $pay_contract_no . " ";
                        $bulkact_chargename .= "от " . $pay_contract_date . " ";
                        $bulkact_chargename .= "согласно реестру № " . $invoice_no . " от " . $invoice_date;
                        $getcharges = $this->truckwaybillmodel->getchargesbyrevid($revenue_id);
                        $eachtot = 0;
                        if (!empty($getcharges)) {
                            foreach ($getcharges as $getcharge) {
                                $chargecodename = $getcharge['chargecodename'];
                                if ($getcharge['amount'] > 0) {
                                    if ("RUFRT" === $getcharge['chargecode']) {
                                        $frtchargedesc = $getcharge['chargecodename'];
                                        $frtchargedesc .= " за период с " . $earliestpickup . " по ";
                                        $frtchargedesc .= $latestpickup;
                                        $frtchargedesc .= " по договору № " . $pay_contract_no . " ";
                                        $frtchargedesc .= "от " . $pay_contract_date . " ";
                                        $frtchargedesc .= "согласно реестру № " . $invoice_no . " от " . $invoice_date;
                                    }
                                    $vat_percentage = $getcharge['vat_percentage'];
                                    if ($vat_percentage == "") {
                                        $vat_percentage = 0;
                                    }
                                    $amount = $getcharge['amount'];
                                    $vat_amount = $getcharge['vat_amount'];
                                    $eachtot = $getcharge['amount'] + $getcharge['vat_amount'];
                                    $chargeby_vat[$vat_percentage][] = [
                                        'chargecode' => $getcharge['chargecode'],
                                        'chargecodename' => $chargecodename,
                                        'amount' => $amount,
                                        'currency' => $getcharge['currency'],
                                        'vat_percentage' => $vat_percentage,
                                        'vat_amount' => $vat_amount,
                                        'eachtot' => $eachtot,
                                        'cat_val'=>$getcharge['cat_val']
                                    ];
                                }
                            }
                        }
                    }
                }
                if (!empty($chargeby_vat)) {
                    foreach ($chargeby_vat as $chargebyvat) {
                        $new_charge = $this->getChargeByVat($chargebyvat, $frtchargedesc, $invoice_description);
                        $tot_chargeamount += $new_charge['amount_int'];
                        $tot_vatamount += $new_charge['vat_amount_int'];
                        $charges[] = $new_charge;
                    }
                    $orders_data = [
                        'add_info' => $add_info,
                        'charges' => $charges,
                        'attorneyinfo' => $attorneyinfo,
                        'sign' => $sign,
                        'signpath' => $signpath
                    ];
                    $total_amount = $tot_chargeamount + $tot_vatamount;
                    if (class_exists('NumberFormatter')) {
                        $tot_amt = number_format((float)$total_amount, 2, '.', '');
                        $totalinwords = num2str($tot_amt);
                        $vat_amt = number_format((float)$tot_vatamount, 2, '.', '');
                        $vatinwords = num2str($vat_amt);
                        /* $vatinwords = $f->format($tot_vatamount)." рублей"; */
                        $decimal = new NumberFormatter("ru", NumberFormatter::DECIMAL);
                        $decimal->setAttribute($decimal::FRACTION_DIGITS, 2);
                        $total_amount = $decimal->format($total_amount);
                        $tot_vatamount = $decimal->format($tot_vatamount);
                        $tot_chargeamount = $decimal->format($tot_chargeamount);
                    } else {
                        $totalinwords = $total_amount;
                        $vatinwords = $tot_vatamount;
                    }
                    $orders_data['tot_chargeamount'] = $tot_chargeamount;
                    $orders_data['total_amount'] = $total_amount;
                    $orders_data['vat_amount'] = $tot_vatamount;
                    $orders_data['totalinwords'] = $totalinwords;
                    $orders_data['vatinwords'] = $vatinwords;
                    $orders_data['doc_type'] = "bulk";
                    $orders_data['code'] = $code;
                    $orders_data['bookingid'] = $gene_order_id;
                    $orders_data['order_id'] = $order_id;
                    if ($invoice_description != '' && $invoice_description != 'NULL') {
                        $orders_data['bulkact_chargename'] = $invoice_description;
                    } else {
                        $orders_data['bulkact_chargename'] = $bulkact_chargename;
                    }
                }
            }
            return $orders_data;
        }
    }

    public function faktura($invoice, $sign, $edoc = '0')
    {
        $data = $order_types = array();
        $zonecode = $this->session->userdata("usr_tzone");
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $curtz = $zonecode['timezone'];
        $data['shipper'] = array();
        $add_info = array();
        $orderinfo = $orders_data = array();
        $pickup_address = $delivery_address = $shipper_address = $cargo_details = $order_reference = $noity_address = $branch_details = $cargo_info = array();
        $from_loc = $to_loc = $truck_num = $driver_name = $departure_date = '';
        $gene_order_id = $invoice_no = $bulkact_chargename = '';
        $total_amount = 0;
        if ($invoice != '') {
            $where = array('id' => $invoice);
            $invoiceinfo = $this->common->gettblrowdata($where, 'bill_type,invoice_no,invoice_date,acon_code,customer_code,code,branch_code,invoice_description', 'tbl_bills', 0, 0);
            $code = "";
            if (!empty($invoiceinfo)) {
                $invoice_no = $invoiceinfo['invoice_no'];
                $bill_type = $invoiceinfo['bill_type'];
                $invoice_description = $invoiceinfo['invoice_description'];
                $branch_code = $invoiceinfo['branch_code'];
                if ($bill_type == 2) {
                    $orders_data = $this->getfakturabulkdata($invoiceinfo, $invoice, $sign);
                } else {
                    $signpath = "";
                    $attorneyinfo = array();
                    $attorneyinfo = array('name' => "", 'attorney_number' => "", 'attorney_date' => "");
                    if ($this->session->userdata('childid')) {
                        $cid = $this->session->userdata('childid');
                        $get_signaturepath = $this->common->gettblrowdata(array("id" => $cid), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_user_logins', 0, 0);
                        if (!empty($get_signaturepath)) {
                            $signpath = $get_signaturepath['signpath'];
                            $attorney_date = $get_signaturepath['attorney_date'];
                            if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                                $attorney_date = date("d.m.Y", strtotime($attorney_date));
                            } else {
                                $attorney_date = "";
                            }
                            $attorneyinfo = array('name' => $get_signaturepath['name'], 'attorney_number' => $get_signaturepath['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_signaturepath['job_profile']);
                        }
                    } else {
                        $get_userdetails = $this->common->gettblrowdata(array("id" => $user_id), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_users', 0, 0);
                        if (!empty($get_userdetails)) {
                            $signpath = $get_userdetails['signpath'];
                            $attorney_date = $get_userdetails['attorney_date'];
                            if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                                $attorney_date = date("d.m.Y", strtotime($attorney_date));
                            } else {
                                $attorney_date = "";
                            }
                            $attorneyinfo = array('name' => $get_userdetails['name'], 'attorney_number' => $get_userdetails['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_userdetails['job_profile']);
                        }
                    }
                    $add_info['invoice_no'] = $invoiceinfo['invoice_no'];
                    $add_info['invoice_date'] = date("d-m-Y", strtotime($invoiceinfo['invoice_date']));
                    $add_info['customer_code'] = $invoiceinfo['customer_code'];
                    $add_info['acon_code'] = $invoiceinfo['acon_code'];
                    $branchcode = $invoiceinfo['branch_code'];
                    $code = $invoiceinfo['code'];
                    $invoice_description = $invoiceinfo['invoice_description'];
                    $where_payee = array("company_code" => $company_code, 'code' => $code, 'status' => 1);
                    $getpayeeinfo = $this->common->gettblrowdata($where_payee, 'name,location_id,state,street,pincode,building,house_number,country,vat_reg_no,tax_payer_no,contract_no,contract_date', 'tbl_party_master', 0, 0);
                    $payeraddress = "";
                    if (!empty($getpayeeinfo)) {
                        if ($getpayeeinfo['pincode'] != "") {
                            $payeraddress .= $getpayeeinfo['pincode'] . ", ";
                        }
                        if ($getpayeeinfo['country'] != "") {
                            $payeraddress .= $getpayeeinfo['country'] . ", ";
                        }
                        if ($getpayeeinfo['state'] != "") {
                            $payeraddress .= $getpayeeinfo['state'] . ", ";
                        }
                        if ($getpayeeinfo['location_id'] != "") {
                            $payeraddress .= $getpayeeinfo['location_id'] . ", ";
                        }
                        if ($getpayeeinfo['street'] != "") {
                            $payeraddress .= $getpayeeinfo['street'] . ", ";
                        }
                        if ($getpayeeinfo['house_number'] != "") {
                            $payeraddress .= $getpayeeinfo['house_number'] . ", ";
                        }
                        if ($getpayeeinfo['building'] != "") {
                            $payeraddress .= $getpayeeinfo['building'];
                        }
                        $add_info['payee_info'] = array('name' => $getpayeeinfo['name'], 'vat_reg_no' => $getpayeeinfo['vat_reg_no'], 'tax_payer_no' => $getpayeeinfo['tax_payer_no'], 'contract_no' => $getpayeeinfo['contract_no'], 'contract_date' => $getpayeeinfo['contract_date'], 'payeraddress' => $payeraddress);
                    }
                    $where = array('bill_id' => $invoice, 'type' => 0, 'status' => 1);
                    $reveninfo = $this->common->gettbldata($where, 'id,order_id,recipient_code,debtor_jfr,amount,currency', 'tb_reveneus', 0, 0);
                    if (!empty($reveninfo)) {
                        $tot_chargeamount = $tot_vatamount = $total_amount = 0;
                        $charges = array();
                        foreach ($reveninfo as $eachreveninfo) {
                            $order_id = "";
                            $revenue_id = $eachreveninfo['id'];
                            $order_id = $eachreveninfo['order_id'];
                            $add_info['amount'] = $eachreveninfo['amount'];
                            $add_info['currency'] = $eachreveninfo['currency'];
                            $add_info['debtor_jfr'] = $eachreveninfo['debtor_jfr'];
                            $recipient_code = $eachreveninfo['recipient_code'];
                            $pickup_city = $delivery_city = $driver_name = $vehicleno = "";
                            $trip_id = $shift_id = 0;
                            if ($order_id != "") {
                                $chkorder = $this->Order->getordertoedit($order_id);
                                if ($chkorder->num_rows() > 0) {
                                    $gene_order_id = $chkorder->row()->order_id;
                                    $trip_id = $chkorder->row()->trip_id;
                                    $shift_id = $chkorder->row()->shift_id;
                                    $pickup_city = $chkorder->row()->pickup_city;
                                    $delivery_city = $chkorder->row()->delivery_city;
                                    $pickup_datetime = $chkorder->row()->pickup_datetime;
                                    if ($pickup_datetime != "") {
                                        $getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                                        $pickup_datetime = $getactual['datetime'];
                                        $pickup_datetime = date("d.m.Y", strtotime($pickup_datetime));
                                    }
                                    $delivery_datetime = $chkorder->row()->delivery_datetime;

                                    if ($delivery_datetime != "") {
                                        $getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
                                        $delivery_datetime = $getactual['datetime'];
                                        $delivery_datetime = date("d.m.Y", strtotime($delivery_datetime));
                                    }
                                }
                                $actual_pickup_dt = $pickup_datetime;
                                $actual_delivery_dt = $delivery_datetime;
                                $getstatusdates = $this->getstatusdates($gene_order_id);
                                if ($getstatusdates['statuspickupdate'] != "") {
                                    $actual_pickup_dt = $getstatusdates['statuspickupdate'];
                                }
                                if ($getstatusdates['statusdeliverydate'] != "") {
                                    $actual_delivery_dt = $getstatusdates['statusdeliverydate'];
                                }
                                if ($trip_id > 0) {
                                    $getdriverinfo = $this->truckwaybillmodel->driverinfo($trip_id);
                                    if ($getdriverinfo->num_rows() > 0) {
                                        $driver_name = $getdriverinfo->row()->name;
                                    }
                                }
                                if ($shift_id > 0) {
                                    $getvehicleinfo = $this->truckwaybillmodel->vehicelinfo($shift_id);
                                    if (!empty($getvehicleinfo)) {
                                        $vehicleno = $getvehicleinfo['register_number'];
                                    }
                                }
                                $getcharges = $this->truckwaybillmodel->getchargesbyrevid($revenue_id);
                                $eachtot = 0;
                                if (!empty($getcharges)) {
                                    foreach ($getcharges as $getcharge) {
                                        $chargecodename = $getcharge['chargecodename'];
                                        if ("RUFRT" === $getcharge['chargecode']) {
                                            if ($invoice_description != '' && $invoice_description != 'NULL') {
                                                $chargecodename = $invoice_description;
                                            } else {
                                                $chargecodename .= " (" . "по маршруту " . $pickup_city . " - ";
                                                $chargecodename .= $delivery_city . ", ";
                                                $chargecodename .= $pickup_datetime . " - " . $delivery_datetime . ", ";
                                                $chargecodename .= "машина " . $vehicleno . ", ";
                                                $chargecodename .= "водитель " . $driver_name . ")";
                                            }
                                        }
                                        if ($getcharge['amount'] > 0) {
                                            $eachtot = $getcharge['amount'] + $getcharge['vat_amount'];
                                            if (class_exists('NumberFormatter')) {
                                                $f = new NumberFormatter("ru", NumberFormatter::DECIMAL);
                                                $f->setAttribute($f::FRACTION_DIGITS, 2);
                                                $amount = $f->format($getcharge['amount']);
                                                $vat_amount = $f->format($getcharge['vat_amount']);
                                                $eachtot = $f->format($eachtot);
                                            } else {
                                                $amount = $getcharge['amount'];
                                                $vat_amount = $getcharge['vat_amount'];
                                            }
                                            $charges[] = array('chargecodename' => $chargecodename, 'amount' => $amount, 'currency' => $getcharge['currency'], 'vat_percentage' => $getcharge['vat_percentage'], 'vat_amount' => $vat_amount, 'eachtot' => $eachtot, 'cat_val' => $getcharge['cat_val'], 'new_amount' => $getcharge['amount'], 'new_vat_amount' => $getcharge['vat_amount']);
                                            $tot_chargeamount += $getcharge['amount'];
                                            $tot_vatamount += $getcharge['vat_amount'];
                                        }
                                    }
                                }
                                $orders_data = array('add_info' => $add_info, 'charges' => $charges, 'attorneyinfo' => $attorneyinfo, 'sign' => $sign, 'signpath' => $signpath, 'order_id' => $order_id);
                            }
                        }
                        $total_amount = $tot_chargeamount + $tot_vatamount;
                        if (class_exists('NumberFormatter')) {
                            $tot_amt = number_format((float) $total_amount, 2, '.', '');
                            $totalinwords = num2str($tot_amt);

                            $vat_amt = number_format((float) $tot_vatamount, 2, '.', '');
                            $vatinwords = num2str($vat_amt);

                            $decimal = new NumberFormatter("ru", NumberFormatter::DECIMAL);
                            $decimal->setAttribute($decimal::FRACTION_DIGITS, 2);
                            $total_amount = $decimal->format($total_amount);
                            $tot_vatamount = $decimal->format($tot_vatamount);
                            $tot_chargeamount = $decimal->format($tot_chargeamount);
                        } else {
                            $totalinwords = $total_amount;
                            $vatinwords = $tot_vatamount;
                        }
                        $orders_data['tot_chargeamount'] = $tot_chargeamount;
                        $orders_data['total_amount'] = $total_amount;
                        $orders_data['vat_amount'] = $tot_vatamount;
                        $orders_data['totalinwords'] = $totalinwords;
                        $orders_data['vatinwords'] = $vatinwords;
                        $orders_data['doc_type'] = "single";
                        $orders_data['bulkact_chargename'] = $bulkact_chargename;
                        $orders_data['code'] = $code;
                        $orders_data['bookingid'] = $gene_order_id;
                    }
                }
            }
        }
        if (!empty($orders_data)) {
            if ($edoc == 0) {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH .'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4-L'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html = '';
                $html .= $this->load->view('kninvoice/ru_faktura', $orders_data, true);
                $html .= "<pagebreak/>";
                $html .= $this->load->view('kninvoice/ru_act', $orders_data, true);
                $mpdf->WriteHTML($html);
                $mpdf->Output($invoice_no . "_" . date('YmdHis') . ".pdf", 'D');
            } else if ($edoc == 1) {
                $orders_data['branch_code'] = $branch_code;
                $orders_data['department_code'] = '';
                if (isset($orders_data['order_id'])) {
                    $getdepartmentcode = $this->common->gettblrowdata(array('order_row_id' => $orders_data['order_id']), 'department_code', 'tb_order_details', 0, 0);
                    if (!empty($getdepartmentcode)) {
                        $orders_data['department_code'] = $getdepartmentcode['department_code'];
                    }
                }
                $return_data = array();
                $return_data['status'] = 0;
                $invoicepdfpath = $this->index($invoice, 'invoice', 1, 1);
                $invoicexml = $this->invoicexml($orders_data);
                $storeinvoicepdf = $this->uploadKNFile($invoicepdfpath);
                $storeinvoicexml = $this->uploadKNFile($invoicexml);
                if ($storeinvoicepdf == 1 && $storeinvoicexml == 1) {
                    $okfilepath = $this->saveokfile($invoice_no);
                    if ($okfilepath != "") {
                        $storeokfile = $this->uploadKNFile($okfilepath);
                        if ($storeokfile == 1) {
                            $return_data['status'] = 1;
                        }
                    }
                }
                echo json_encode($return_data);
            }
        }
    }

    public function getstatusdates($gene_order_id)
    {
        $zonecode = $this->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $data = array('statuspickupdate' => "", 'statusdeliverydate' => "");
        $getpicanddeldates = $this->truckwaybillmodel->getpicanddeldates($gene_order_id);
        if (!empty($getpicanddeldates)) {
            foreach ($getpicanddeldates as $getpicanddeldate) {
                if ($getpicanddeldate['stop_type'] == "P") {
                    if ($getpicanddeldate['createdon'] != "") {
                        $getactual = getdatetimebytimezone($curtz, $getpicanddeldate['createdon'], DFLT_TZ);
                        $data['statuspickupdate'] = date("d.m.Y", strtotime($getactual['datetime']));
                    }
                }
                if ($getpicanddeldate['stop_type'] == "D") {
                    if ($getpicanddeldate['createdon'] != "") {
                        $getactual = getdatetimebytimezone($curtz, $getpicanddeldate['createdon'], DFLT_TZ);
                        $data['statusdeliverydate'] = date("d.m.Y", strtotime($getactual['datetime']));
                    }
                }
            }
        }
        return $data;
    }

    function getChargeByVat(array $chargeByVat, string $ruFrtChargeDescription, string $invoiceDescription): array
    {
        $chargeNames = [];
        $amount = $vatAmount = $eachTotal = $vatPercentage = $categoryValue = 0;
        foreach ($chargeByVat as $res) {
            $chargeNames[] = $res['chargecodename'];
            $amount += $res['amount'];
            $vatAmount += $res['vat_amount'];
            $eachTotal += $res['eachtot'];
            $vatPercentage = $res['vat_percentage'];
            $currency = $res['currency'];
            $categoryValue = $res['cat_val'];
        }
        $chargeNames = array_unique($chargeNames);
        $chargeCodeName = implode(",", $chargeNames);
        if (20 == $vatPercentage) {
            if ($invoiceDescription != '' && $invoiceDescription != 'NULL') {
                $chargeCodeName = $invoiceDescription;
            } else {
                $chargeCodeName = $ruFrtChargeDescription;
            }
        }
        $amountInt = $amount;
        $vatAmountInt = $vatAmount;
        if (class_exists('NumberFormatter')) {
            $format = new NumberFormatter("ru", NumberFormatter::DECIMAL);
            $format->setAttribute($format::FRACTION_DIGITS, 2);
            $amount = $format->format($amount);
            $vatAmount = $format->format($vatAmount);
            $eachTotal = $format->format($eachTotal);
        }
        return [
            'chargecodename' => $chargeCodeName,
            'amount' => $amount,
            'currency' => $currency ?? "",
            'vat_percentage' => $vatPercentage,
            'vat_amount' => $vatAmount,
            'eachtot' => $eachTotal,
            'amount_int' => $amountInt,
            'vat_amount_int' => $vatAmountInt,
            'cat_val' => $categoryValue,
            'new_amount' => $amountInt,
            'new_vat_amount' => $vatAmountInt
        ];
    }

     /**
     * To save invoice XMl and return xml file path
     * @change    Russia
     * @param     array  (invoice data)
     * @return    string (file path)
     */
    public function invoicexml(array $data): string
    {
        $currentDate = date('Y-m-d H:i:s');
        $timeZoneCode = $this->session->userdata("usr_tzone");
        $currentTimeZone = $timeZoneCode['timezone'];
        $getActual = getdatetimebytimezone($currentTimeZone, $currentDate, DFLT_TZ);
        $timeStamp = date("Y-m-d\TH:i:s\Z", strtotime($getActual['datetime']));
        $this->load->library('uuid');
        $uuid = $this->uuid->v4();
        $charges = $data['charges'];
        $docType = $data['doc_type'];
        $edocXml = '';
        $edocXml .= '<?xml version="1.0" encoding="UTF-8"?>';
        $edocXml .= '<edoc-fi-upd>';
        $edocXml .= '<Meta>';
        $edocXml .= '<AppID>ETN</AppID>';
        $edocXml .= '<ExtRef>RUKN' . $data['branch_code'] . $data['department_code'] . '</ExtRef>';
        $edocXml .= '<TransactionID>' . $uuid . '</TransactionID>';
        $edocXml .= '<Timestamp>' . $timeStamp . '</Timestamp>';
        $edocXml .= '<Branch>' . $data['department_code'] . '</Branch>';
        $edocXml .= '<Department>' . $data['branch_code'] . '</Department>';
        $edocXml .= '<UserID>' . $data['attorneyinfo']['name'] . '</UserID>';
        $edocXml .= '</Meta>';
        $edocXml .= '<Document>';
        $edocXml .= '<docHeader>';
        $edocXml .= '<invoiceNumber>' . $data['add_info']['invoice_no'] . '</invoiceNumber>';
        $edocXml .= '<invoiceDate>' . date('d.m.Y', strtotime($data['add_info']['invoice_date'])) . '</invoiceDate>';
        $edocXml .= '<iFNumber>' . $data['add_info']['invoice_no'] . '</iFNumber>';
        $edocXml .= '<iFDate>' . date('d.m.Y', strtotime($data['add_info']['invoice_date'])) . '</iFDate>';
        if ($docType == "single") {
            $edocXml .= '<trackingNumber>' . $data['bookingid'] . '</trackingNumber>';
        } else {
            $edocXml .= '<trackingNumber></trackingNumber>';
        }
        $edocXml .= '<currency>';
        $edocXml .= '<currencyName>RUB</currencyName>';
        $edocXml .= '<rate>1</rate>';
        $edocXml .= '<rateDate></rateDate>';
        $edocXml .= '</currency>';
        $edocXml .= '<customer>';
        if (isset($data['add_info']['payee_info'])) {
            $edocXml .= '<vatRegistrationNumber>' . $data['add_info']['payee_info']['tax_payer_no'] . "/" . $data['add_info']['payee_info']['vat_reg_no'] . '</vatRegistrationNumber>';
        } else {
            $edocXml .= '<vatRegistrationNumber></vatRegistrationNumber>';
        }
        $edocXml .= '<clientID>' . $data['code'] . '</clientID>';
        $edocXml .= '</customer>';
        $edocXml .= '<supplier>';
        $edocXml .= '<vatRegistrationNumber>7710431565/771001001</vatRegistrationNumber>';
        $edocXml .= '</supplier>';
        $edocXml .= '<contractDetails>';
        $edocXml .= '<contractType>Договор</contractType>';
        $edocXml .= '<contractNumber>' . $data['add_info']['payee_info']['contract_no'] . '</contractNumber>';
        $contract_date = $data['add_info']['payee_info']['contract_date'];
        if ($contract_date != '') {
            $edocXml .= '<contractDate>' . date('d.m.Y', strtotime($contract_date)) . '</contractDate>';
            $edocXml .= '<contractData1>Договор №  ' . $data['add_info']['payee_info']['contract_no'] . ' от ' . date('d.m.Y', strtotime($contract_date)) . '</contractData1>';
        } else {
            $edocXml .= '<contractDate></contractDate>';
            $edocXml .= '<contractData1>Договор №  ' . $data['add_info']['payee_info']['contract_no'] . ' от</contractData1>';
        }
        $edocXml .= '</contractDetails>';
        $edocXml .= '</docHeader>';
        $edocXml .= '<docDetails>';
            foreach ($charges as $charge) {
                $newAmount = number_format($charge['new_amount'], 2, ',', '');
                $newVatAmount = number_format($charge['new_vat_amount'], 2, ',', '');
                $vatPercentage = number_format($charge['vat_percentage'], 2, '.', '');
                $edocXml .= '<line>';
                $edocXml .= '<count>1</count>';
                $edocXml .= '<price>' . $newAmount . '</price>';
                $edocXml .= '<sum>' . $newAmount . '</sum>';
                $edocXml .= '<sumVat>' . $newVatAmount . '</sumVat>';
                if ((0 == $vatPercentage) && ('' == $charge['cat_val'])) {
                    $edocXml .= '<vatRateCode>3</vatRateCode>';
                } else {
                    $edocXml .= '<vatRateCode>' . $charge['cat_val'] . '</vatRateCode>';
                }
                $edocXml .= '<vatRateValue>' . $vatPercentage . '</vatRateValue>';
                if ($docType == "single") {
                    $edocXml .= '<chargeName>' . str_replace("&", "&amp;", $charge['chargecodename']) . '</chargeName>';
                } else {
                    $edocXml .= '<chargeName>' . str_replace("&", "&amp;", $data['bulkact_chargename']) . '</chargeName>';
                }
                $edocXml .= '</line>';
            }
        $edocXml .= '</docDetails>';
        $edocXml .= '</Document>';
        $edocXml .= '</edoc-fi-upd>';
        $fileName = $data['add_info']['invoice_no'] . ".xml";
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = FALSE;
        $dom->loadXML($edocXml);
        $dom->save(EDOC_PATH . $fileName);
        return EDOC_PATH . $fileName;
    }
       /**
     * To save empty file with .OK extension for acknowledgement
     * @change    Russia
     * @param     int (invoice no)
     * @return    string (file path)
     */
    public function saveokfile($invoiceno)
    {
        $content = '';
        $file_path = EDOC_PATH."$invoiceno.ok";
        $fp        = file_put_contents($file_path, $content);
        return $file_path;
    }
     /**
     * To Upload invoice files to Russia customer FTP location
     * @change    Russia
     * @param     string (file path)
     * @return    boolean
     */
    public function uploadKNFile($localfile)
    {
        $result = 0;
        $remotefile = basename($localfile);
        $ftp = ftp_connect(EDOC_URL);
        if (false === $ftp) {
            log_message("error", "Knruinvoice FTP failed ");
        } else {
            $loggedIn = ftp_login($ftp, EDOC_USERNAME, EDOC_PWD);
            if (true === $loggedIn) {
                try {
                    $ftp_pasv =  ftp_pasv($ftp, true);
                    $chk_upload  = @ftp_put($ftp, EDOC_FTP.$remotefile, $localfile, FTP_BINARY);
                    if ($chk_upload) {
                        $result = 1;
                    } else {
                        log_message("error", "Knruinvoice file upload failed- " . $localfile);
                    }
                    ftp_close($ftp);
                } catch (Exception $ex) {
                    log_message("error", "Knruinvoice Passive mode failed");
                    return false;
                }
            } else {
                log_message("error", "Knruinvoice FTP Login failed ");
            }
        }
        return $result;
    }
    /**
     * To generate Power of Authority Document (specific to Russia)
     * @change    Russia
     * @param     int (order id)
     * @return    PDF
     */
    public function rupoa($order_id,$shiftid=0,$sign=1,$sendemail=0,$customerid=0)
    {
        require 'vendor/autoload.php';
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $customer_name = "";
        $whr = array("id" => $order_id);
        if($shiftid >0){
            $whr = array("shift_id" => $shiftid);
        }
        $driver_info = array('name' => '', 'shipmentid' => '');
        $get_orderdetails = $this->common->gettblrowdata($whr, 'customer_id,shift_id,trip_id', 'tb_orders', 0, 0);
        if (!empty($get_orderdetails)) {
            $trip_id = $get_orderdetails['trip_id'];
            $shift_id = $get_orderdetails['shift_id'];
            if($customerid>0){
                $customer_id = $customerid;
            }else{
                $customer_id = $get_orderdetails['customer_id'];
            }
            if ($customer_id > 0) {
                $get_custname = $this->common->gettblrowdata(array("id" => $customer_id), 'name', 'tb_customers', 0, 0);
                if (!empty($get_custname)) {
                    $customer_name = $get_custname['name'];
                }
            }
            if ($shift_id > 0) {
                if($customerid > 0){
                    $get_pickupdate = $this->common->gettblrowdata(array("customer_id" => $customerid,"shift_id" => $shift_id), 'MIN(pickup_datetime) as pickup_datetime', 'tb_orders', 0, 0);
                }else{
                    $get_pickupdate = $this->common->gettblrowdata(array("shift_id" => $shift_id), 'MIN(pickup_datetime) as pickup_datetime', 'tb_orders', 0, 0);
                }
                $data['early_pickup_date'] = $data['pickupdate_new'] = "";
                if (!empty($get_pickupdate)) {
                    $early_pickup_date = $get_pickupdate['pickup_datetime'];
                    if ($early_pickup_date != "") {
                        $data['early_pickup_date'] = date("d.m.Y", strtotime($early_pickup_date));
                        $data['pickupdate_new'] = date("d.m.Y", strtotime($early_pickup_date . " +10 days"));
                    }
                }
                $get_driver_info = $this->truckwaybillmodel->get_driver_info($shift_id);
                
                if (!empty($get_driver_info)) {
                    $driver_info = array('name' => $get_driver_info['name'], 'shipmentid' => $get_driver_info['shipmentid']);
                }
            }
        }
        $userinfo = array('name' => "", 'attorney_number' => "", 'attorney_date' => "", 'job_profile' => "", 'signpath' => "");
        if ($this->session->userdata('childid')) {
            $cid = $this->session->userdata('childid');
            $get_signaturepath = $this->common->gettblrowdata(array("id" => $cid), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_user_logins', 0, 0);
            if (!empty($get_signaturepath)) {
                $signpath = $get_signaturepath['signpath'];
                $attorney_date = $get_signaturepath['attorney_date'];
                if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                    $attorney_date = date("d.m.Y", strtotime($attorney_date));
                } else {
                    $attorney_date = "";
                }
                $userinfo = array('name' => $get_signaturepath['name'], 'attorney_number' => $get_signaturepath['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_signaturepath['job_profile'], 'signpath' => $signpath);
            }
        } else {
            $get_userdetails = $this->common->gettblrowdata(array("id" => $user_id), 'name,attorney_number,attorney_date,signpath,job_profile', 'tb_users', 0, 0);
            if (!empty($get_userdetails)) {
                $signpath = $get_userdetails['signpath'];
                $attorney_date = $get_userdetails['attorney_date'];
                if ($attorney_date != "" && $attorney_date != "0000-00-00") {
                    $attorney_date = date("d.m.Y", strtotime($attorney_date));
                } else {
                    $attorney_date = "";
                }
                $userinfo = array('name' => $get_userdetails['name'], 'attorney_number' => $get_userdetails['attorney_number'], 'attorney_date' => $attorney_date, 'job_profile' => $get_userdetails['job_profile'], 'signpath' => $signpath);
            }
        }
        $get_cargos = $this->truckwaybillmodel->get_cargos($shift_id,$customerid);
        $cargo_list = $cargo_finallist = array();
        if (!empty($get_cargos)) {
            foreach ($get_cargos as $cargos) {
                $orderid = $cargos['id'];
                $cargo_list[$orderid][] = $cargos['cargo_content'];
            }
            if (!empty($cargo_list)) {
                $i = 1;
                foreach ($cargo_list as $cargos) {
                    $j = 1;
                    foreach ($cargos as $cargo) {
                        $cargo_finallist[] = array("sno" => $i . "." . $j, "cargo_type" => $cargo);
                        $j++;
                    }
                    $i++;
                }
            }
        }
        $data['customer_name'] = $customer_name;
        if($sign == 0){
            $userinfo['signpath']="";
        }
        $cargosplit = array_chunk($cargo_finallist, 4);
        $data['userinfo'] = $userinfo;
        $data['driver_info'] = $driver_info;
        $mpdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $html = "";
        if (!empty($cargosplit)) {
            $i = 1;
            $count = count($cargosplit) - 1;
            for ($i = 0; $i < count($cargosplit); $i++) {
                $data['pageno'] = ($i+1)."/".($count+1);
                $data['cargo_finallist'] = $cargosplit[$i];
                $html .= $this->load->view('kninvoice/rupoa', $data, true);
                if ($i < ($count)) {
                    $html .= "<pagebreak/>";
                }
            }
        }
        $mpdf->WriteHTML($html);
        if($sendemail == 0){
            $mpdf->Output('POA' . "_" . date('YmdHis') . ".pdf", 'D');
        }else{
            $post   = $this->input->post(NULL,TRUE);
            $email_id   = isset($post['email_id']) ? $post['email_id'] : "";
            $subject   = isset($post['subject']) ? $post['subject'] : "";
            $pdfpath = EDOC_PATH . 'POA' . "_" . date('Ymd') . ".pdf";
            $mpdf->Output($pdfpath, 'F');
            $this->load->helper('ruemaildocuments_helper');
		    $data = array('documentno'=>$driver_info['shipmentid'],'customer_email'=>$email_id,'subject'=>$subject,'attachment'=>$pdfpath,'drivername'=>$driver_info['name']);
		    $status = senddocument($data);
            echo $status;
        }
    }
}
