<?php

if (! defined('BASEPATH'))exit('No direct script access allowed');

 class Knuniqloshipment extends CI_Controller{

    public function __Construct()
    {
        parent::__Construct();
    }


    public function index()
    {
        $postData = file_get_contents('php://input');
        if(!empty($postData)){
            $xml = new SimpleXMLElement($postData);
            $userid = 1;
            $response = array();
            $statusmsg = "";
            $preceiver = $lreceiver = $psender = $lsender = $shipmentid = $sendertransmode = $pickup_city = $company_code = $branch_code = "";
            if ($xml === false) {
                $statusmsg = "Invalid request,Please try again!";
            }else{
                $shipdata11 = $this->read_shipmentdata($xml);
                if(!empty($shipdata11)){
                   $response = $this->insertShipmentData($shipdata11,$curdt);
                }
                if(!empty($response)){
                    $shipid = $response[0];
                    /* update status */
                    $chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$shipid,"status_id"=>9),1,0);
                    if($chk->num_rows() == 0){
                        $ins = array("shipment_id"=>$shipid,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status_code"=>"0100","status"=>1,"reason"=>"Coming from E-Booking","createdon"=>$curdt);
                        $insqry = $this->db->insert("tb_stop_status",$ins);
                        $ordid = isset($shipdata11['shipdata'][0]['orderid']) ? $shipdata11['shipdata'][0]['orderid'] : "";
                        $sendertransmode = isset($shipdata11['shipdata'][0]['sendertransmode']) ? $shipdata11['shipdata'][0]['sendertransmode'] : "";
                        $company_code = isset($shipdata11['shipdata'][0]['sendercmpcode']) ? $shipdata11['shipdata'][0]['sendercmpcode'] : "";
                        $branch_code = isset($shipdata11['shipdata'][0]['senderbranchcode']) ? $shipdata11['shipdata'][0]['senderbranchcode'] : "";
                        $pickup_city = isset($shipdata11['shipdata'][0]['pickdrops'][0]['pickup_city']) ? $shipdata11['shipdata'][0]['pickdrops'][0]['pickup_city'] : "";
                        $pdatefromtime = isset($shipdata11['shipdata'][0]['pickdrops'][0]['pickup_datefromtime']) ? $shipdata11['shipdata'][0]['pickdrops'][0]['pickup_datefromtime'] : "";
                        $preceiver = isset($shipdata11['header']['preceiver']) ? $shipdata11['header']['preceiver'] : "";
                        $lreceiver = isset($shipdata11['header']['lreceiver']) ? $shipdata11['header']['lreceiver'] : "";
                        $psender = isset($shipdata11['header']['psender']) ? $shipdata11['header']['psender'] : "";
                        $lsender = isset($shipdata11['header']['lsender']) ? $shipdata11['header']['lsender'] : "";
                        $shipmentid = isset($shipdata11['truck']['shipment_id']) ? $shipdata11['truck']['shipment_id'] : "";
                        $lstchars = "+05:30";
                        if($pdatefromtime != ""){
                            $lstchars = substr($pdatefromtime, -6);
                        }
                        if($lstchars == ""){
                            $lstchars = "+08:00";
                        }
                        $curtzs = gettimezonebygmtplusval($lstchars);
                        if($ordid != ""){
                            $postdata = array(
                                "shipment_id" => $shipid,
                                "preceiver"     => $preceiver,
                                "lreceiver"   => $lreceiver,
                                "order_id"    => $ordid,
                                "psender"     => $psender,
                                "lsender"     => $lsender,
                                "latitude"    => '',
                                "longitude"   => '',
                                "curtz" => $curtzs,
                                "shipmentid"   => $shipmentid,
                                "modeoftransport"   => $sendertransmode,
                                "pickup_city"   => $pickup_city,
                                "company_code"   => $company_code,
                                "branch_code"   => $branch_code,
                                "hrs"   => $lstchars
                            );
                            $ins = array("shipment_id"=>$shipid,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>11,"status_code"=>"2400","status"=>1,"reason"=>"Planned Delivery Date","createdon"=>$curdt);
                            $insqry = $this->db->insert("tb_stop_status",$ins);
                            $this->load->library("statusintigration");
                            $sts = $this->statusintigration->roadlogshipbookedbysupplier($postdata);
                            $sts = $this->statusintigration->roadlogshipplandeliverdate($postdata);
                        }
                    }
                    $statusmsg = "Success";
                }else{
                    $statusmsg = "Failed for unformatted request,Please try again!";
                }
            }
        }else{
            $statusmsg = "Invalid request,Please try again!";
        }
        echo $statusmsg;
    }

    public function read_shipmentdata($xml){
        $res = array();
        $xml->registerXPathNamespace('ns3', 'http://knie4.int.kn/com/lhdr/0200');
        $data = $xml->xpath('ns3:MessageHeader');
        $physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
        $logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
        $physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
        $logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
        $lreceiver = $preceiver = $psender = $lsender = $triptype = "";
        $loadcapacity = 0;
        $driver = $carrier = array();
        $preceiver = $physicalreceiver;
        $lreceiver = $logicalreceiver;
        $psender = $physicalsender;
        $lsender = $logicalsender;
        $sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
        $msgtype = (string)($data[0]->xpath('MessageType')[0]);
        $version = (string)($data[0]->xpath('VersionNumber')[0]);
        $createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
        if($createdtime != ""){
         $createdtime = date("Y-m-d H:i:s",strtotime($createdtime));
        }else{
         $createdtime = date("Y-m-d H:i:s");
        }
        $res['header'] = array("preceiver"=>$preceiver,"lreceiver"=>$lreceiver,"psender"=>$psender,"lsender"=>$lsender,"sendapp"=>$sendapp,"msgtype"=>$msgtype,"version"=>$version,"createdtime"=>$createdtime);
        /* truck and trailer info */
        $arr = array();
        $xml->registerXPathNamespace('ns4', 'http://knie4.int.kn/com/ltru/0200');
        $titledata = $xml->xpath('//ns4:TruckAndTrailer');
        if(isset($titledata)){
            if(isset($titledata[0])){
            $veh_number = isset($titledata[0]->xpath('TruckLicenseNumber')[0]) ? $titledata[0]->xpath('TruckLicenseNumber')[0] : "";
            $arr['veh_number'] = (string)($veh_number);
            $veh_type = isset($titledata[0]->xpath('VehicleType')[0]) ? $titledata[0]->xpath('VehicleType')[0] : "";
            $arr['veh_type'] = (string)($veh_type);
            $arr['ordernum'] = (string)($titledata[0]->xpath('VoyageNumber')[0]);
            $arr['shipment_id'] = (string)($titledata[0]->xpath('TourNumber')[0]);
            $arr['origin'] = (string)($titledata[0]->xpath('Origin')[0]->Location[0]);
            $arr['originloc2'] = (string)($titledata[0]->xpath('Origin')[0]->Location[1]);
            $arr['origindate'] = (string)($titledata[0]->xpath('Origin')[0]->Date);
            $arr['noofshipments'] = (string)($titledata[0]->xpath('NumberOfShipments')[0]);
            $address = $triptype = $loadcapacity = "";
            if(null !== $titledata[0]->xpath('Address')){
                if(!empty($titledata[0]->xpath('Address'))){
                $address = (string)($titledata[0]->xpath('Address')[0]->attributes('ns2', TRUE)->AddressType);
                if($address == "CA"){
                    $carrier['name'] = (string)($titledata[0]->xpath('Address')[0]->Name);
                    $carrier['street'] = (string)($titledata[0]->xpath('Address')[0]->Street[0]);
                    $carrier['street1'] = (string)($titledata[0]->xpath('Address')[0]->Street[1]);
                    $carrier['city'] = (string)($titledata[0]->xpath('Address')[0]->City);
                    $carrier['country'] = (string)($titledata[0]->xpath('Address')[0]->CountryCode);
                    $carrier['zip'] = (string)($titledata[0]->xpath('Address')[0]->ZipCode);
                    $carrier['custid'] = (string)($titledata[0]->xpath('Address')[0]->CustomerIdentifier);
                    $carrier['partyid'] = (string)($titledata[0]->xpath('Address')[0]->PartyIdentifier);
                    if(null !== (string)$titledata[0]->xpath('Address')[0]->ContactDetails){
                        $contacttype = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->ContactType);
                        if($contacttype == "Driver"){
                        $driver['contacttype'] = $contacttype;
                        $driver['lastname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->LastName);
                        $driver['firstname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->FirstName);
                        $driver['commtype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication['ns2:CommunicationType']);
                        }
                        $driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication);
                        if(null !== $titledata[0]->xpath('DriverID')){
                            if(!empty($titledata[0]->xpath('DriverID'))){
                                $driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
                            }
                        }
                    }
                    if(null !== $titledata[0]->xpath('Address')[0]->ContactDetails[1]){
                        if(null !== (string)$titledata[0]->xpath('Address')[0]->ContactDetails[1]){
                            $contacttype = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->ContactType);
                            if($contacttype == "Driver"){
                            $driver['contacttype'] = $contacttype;
                            $driver['lastname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->LastName);
                            $driver['firstname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->FirstName);
                            $driver['commtype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->Communication['ns2:CommunicationType']);
                            }
                            $driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->Communication);
                            if(null !== $titledata[0]->xpath('DriverID')){
                                if(!empty($titledata[0]->xpath('DriverID'))){
                                    $driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
                                }
                            }
                        }
                    }
                    }
                } }
                if(null !== $titledata[0]->xpath('TripType')){
                    if(!empty($titledata[0]->xpath('TripType'))){
                    $triptype = (string)($titledata[0]->xpath('TripType')[0]);
                }
                }
                if(null !== $titledata[0]->xpath('LoadingCapacity')){
                    if(!empty($titledata[0]->xpath('LoadingCapacity'))){
                    $loadcapacity = (string)($titledata[0]->xpath('LoadingCapacity')[0]);
                    }
                }
            }
        }
        $res['carrier'] = $carrier;
        $res['driver'] = $driver;
        $arr['triptype'] = $triptype;
        $arr['loadcapacity'] = $loadcapacity;
        $res['truck'] = $arr;
        $res['shipdata'] = array();
        $xml->registerXPathNamespace('ns20', 'http://knie4.int.kn/msg/roadshipment/0100');
        $mdata = $xml->xpath('//ns20:RoadShipment');
        $shinfo = $mdata[0]->xpath('Message')[0]->Shipment;
        foreach($shinfo as $key=>$cships){
            $res['shipdata'][] = $this->generateshipmentdata($cships,$key);
        }
        return $res;
    }
}
