<?php defined('BASEPATH') or exit('No direct script access allowed');
class Live extends CI_Controller
{
    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata("user_id") == "") {
            redirect("login");
        }
    }
    public function index()
    {
        $id                 = $this->session->userdata('user_id');
        $data["page_title"] = "Live";
        $data["sub_title"]  = "View Vehicles";
        $data["vehicles"]   = $this->db->query("select t.start_imei as id,td.register_number from tb_trucks_data td,tb_trips t where td.status=1 and td.user_id=$id and t.vehicle_id=td.id and t.status=1");
        $this->settemplate->dashboardtemp('live/view', $data);
    }
    public function sendLiveData()
    {
        $data = [];
        if (count($imei = $this->input->post("imei")) > 0) {
            $i = implode("','", $imei);
            foreach ($imei as $i) {
                $rec = $this->db->query("select td.register_number,td.latitude,td.longitude,td.speed,td.bearing,td.receivedon,s.splace,s.eplace,s.startdate,s.enddate,s.shipment_name from tb_trucks_data td,tb_trips t,tb_shifts s where t.start_imei='".$i."' and t.status=1 and t.vehicle_id=td.id and t.shift_id=s.id order by td.receivedon desc limit 1");
                if($rec->num_rows()>0){
                    $lat       = $rec->row()->latitude;
                    $lng       = $rec->row()->longitude;
                    $speed     = $rec->row()->speed;
                    $accuracy  = 100;
                    $bearing   = $rec->row()->bearing;
                    $timestamp = $rec->row()->receivedon;
                    $loc       = getLocationName($lat, $lng);
                    $data[]    = array(
                        "register_number" => $rec->row()->register_number,
                        "splace"          => $rec->row()->splace,
                        "eplace"          => $rec->row()->eplace,
                        "shipment"        => $rec->row()->shipment_name,
                        "stime"           => date("d M Y, h:i A", strtotime($rec->row()->startdate)),
                        "etime"           => date("d M Y, h:i A", strtotime($rec->row()->enddate)),
                        "latitude"        => $lat,
                        "longitude"       => $lng,
                        "speed"           => $speed,
                        "accuracy"        => $accuracy,
                        "bearing"         => $bearing,
                        "timestamp"       => date("Y M d,h:i A", strtotime($timestamp)),
                        "location"        => $loc);
                }
            }
        }
        echo json_encode($data);
    }

    public function getcovidstatusbypincode(){
        $pincode = $this->input->post("pincode",true);
        $res2 = array();
        $res = "";
        $res = json_encode($res2);
        if($pincode != ""){
            $authkey = COVID_AUTHKEY;
            $latlng = $this->getlatlongbypincode($pincode);
            if(count($latlng)>0){
                $latlngs[] = [floatval($latlng['latitude']),floatval($latlng['longitude'])];
                $jsoninput = array("latlngs"=>$latlngs,"key"=>$authkey);
                $serviceurl = COVID_URL;
                $headers  = array('Content-Type: application/json');
                $postdata = json_encode($jsoninput);
                $res2 = covidservicecurl($serviceurl,$headers,$postdata);
                /*$res3 = $res1;
                if(empty($res2)){
                    $string = str_replace('\n', '', $res3);
                    $string = rtrim($string, ',');
                    $res3 = "[" . trim($string) . "]";
                    $res3 = str_replace("NaN", "null", $res3);
                    log_message("error","2nd ".$res3);
                    $res2 = json_decode($res3,true);
                }*/
                if($res2['status'] == 200){
                    $res2['lat'] = $latlng['latitude'];
                    $res2['lng'] = $latlng['longitude'];
                }
                $res = json_encode($res2);
            }
        }
        echo $res;
    }

    function getlatlongbypincode($address){
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }

    public function covid19map($lat,$lng,$type){
        $data['page_title'] = "Location Map View";
        $data['sub_title']= "Map";
        if($lat != "" && $lng != ""){
            $data['latitude']= $lat;
            $data['longitude']= $lng;
            $data['zone_type']= urldecode($type);
            $this->newtemplate->dashboard("orders/covidmap",$data);
        }else{
            redirect("orders");
        }
    }
}
