<?php
use App\Time\Timer;
use App\Time\TimerInterface;
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class LiveLocationUpdate extends CI_Controller
{
    private $timer;

    public function __construct()
    {
        parent::__construct();
        $this->load->library('WheelsEye');
        $this->load->model(['WheelseyeModel', 'wheelseyeModel', 'order']);
        $this->load->helper('log_helper');
        $this->timer = new Timer();
    }
    
    public function updateVehicleLocation(){
        $rtdriveLocations = [];
        $this->benchmark->mark('wheelseye_start');
        $allVehicles = $this->wheelseye->getAllVehicles();
        //log_message("error","Innn:".json_encode($allVehicles));
        if (empty($allVehicles)) {
            log_message('error', 'Wheelseye Live Location Update - no data received from API');
            return;
        }
        $registerNumbers = array_keys($allVehicles);
       
        $orders = $this->order->getOrders($registerNumbers);
//log_message("error","orders:".json_encode($orders));
        if (count($orders) < count($registerNumbers)) {
            $unknownRegisterNumbersFromApi = $this->wheelseye->getUnknownRegisterNumbers($orders, $registerNumbers);
            log_message(
                'error',
                sprintf(
                    'Wheelseye Live Location Update: Unknown vehicle numbers received from API: %s',
                    implode(', ', $unknownRegisterNumbersFromApi)
                )
            );
        }
        $this->load->model('common');
        foreach ($orders as $order) {
            $statusResult = $this->order->getStatusResult($order['shift_id'], $order['trip_id']);
            /*log_message("error","gatein:".$statusResult['gatein']);
            log_message("error","gateout:".$statusResult['gateout']);*/
            if (!empty($statusResult) && (int)$statusResult['gatein'] > 0 && (int)$statusResult['gateout'] === 0) {
                $registerNumber = $order['register_number'];
                $info = (object)$allVehicles[$registerNumber];
                $rtdriveLocations[] = [
                    'driver_id' => $order['driver_id'],
                    'vehicle_id' => $order['vehicle_id'],
                    'trip_id' => $order['trip_id'],
                    'latitude' => $info->latitude,
                    'longitude' => $info->longitude,
                    'speed' => (int)$info->speed,
                    'timestamp' => $this->timer->getLocalDateTimeForTimestamp($info->dttimeInEpoch, new DateTimeZone('Asia/Calcutta')),
                    'createdon' => date('Y-m-d H:i:s'),
                ];
                $updateOrderData = [
                    'wlatitude' => $info->latitude,
                    'wlongitude' => $info->longitude,
                ];
                $this->db->update('tb_orders', $updateOrderData, [
                    'trip_id' => $order['trip_id'],
                    'shift_id' => $order['shift_id']
                ]);
                $updateVehicleLocation = [
                    'latitude' => $info->latitude,
                    'longitude' => $info->longitude,
                ];
                $this->common->updatetbledata('tb_trucks_data', $updateVehicleLocation, ['truck_number' => $order['register_number']]);
            }
        }
        if ($rtdriveLocations) {
            $this->db->insert_batch('tb_rtdrive_locations', $rtdriveLocations);
        }
        $this->benchmark->mark('wheelseye_end');
        $timeTaken = $this->benchmark->elapsed_time('wheelseye_start', 'wheelseye_end');
        log_message(
            'error',
            sprintf(
                'Wheelseye Live Location Update complete in %ss and processed %d orders, %d inserts were made into tb_rtdrive_locations',
                $timeTaken,
                count($orders),
                count($rtdriveLocations)
            )
        );
    }
}