<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Livetrack extends CI_Controller
{

public function __construct()
{
    parent::__construct();
    $this->load->model(["common","Order"]);
}

    public function index()
    {
        echo "Welcome!";
    }

    public function etnshipment($ordr = "")
    {
        if ($ordr != "") {
            $ordResults = $this->getIdByOrderId($ordr);
            if ($ordResults) {
                $data["id"] = $ordResults->id;
                $ord = $ordResults;
                $data["order"] = $ord;
                $shipmentid = $ord->shipmentid;
                $data["order_id"] = $ord->order_id;
                $data["order_status"] = $ord->status;
                $data["trip_sts"] = $ord->trip_sts;
                $data['customerRowId'] = $ord->customer_id;
                $oid = $ord->id;
                $data['lguid'] = $uid = $ord->user_id;
                $user = $this->db->select("id,country_code")->get_where(
                    "tb_users",
                    array("id" => $uid),
                    1,
                    0
                )->row_array();
                $tz = $this->getUserTimeZone($user['id'], $user['country_code']);
                $curtz = $tz['timezone'];
                $data["timezone"] = $curtz;
                $data["trip"] = array();
                $currentdate = date("Y-m-d");

                $carrier_ins = "";
                $get_carrier_ins = $this->common->gettblrowdata(
                    array("shipmentid" => $shipmentid),
                    "id,carrier_instructions",
                    "tb_shifts",
                    0,
                    0
                );
                if (count($get_carrier_ins) > 0) {
                    $carrier_ins = $get_carrier_ins['carrier_instructions'];
                }
                $data["carrier_ins"] = $carrier_ins;

                $tripinfo = chkTripinfoByOrdertrip($ord->trip_id, $curtz);
                $tripinfo_gateoutdate = $this->common->chkOrderinfoBygateoutdate($ord->id, $curtz);
                $data["tripinfo_gateoutdate"] = $tripinfo_gateoutdate;
                $locationsWhereCondition = "";
                if($tripinfo_gateoutdate != ""){
                    $locationsWhereCondition = " and timestamp <='".$tripinfo_gateoutdate."' ";
                }
                if (count($tripinfo) > 0) {
                    $getPickupGateIn = $this->common->gettblrowdata(['order_id'=>$ord->id,'status_code'=>'0420','status'=>'1'], "createdon", "tb_stop_status", 0, 0);
                    if(!empty($getPickupGateIn)){
                        $locationsWhereCondition .= " and timestamp >='".$getPickupGateIn['createdon']."' ";
                    }
                    $tripgps = $this->common->chkTripGPSByOrdertrip($tripinfo['vehicle_id'], $currentdate);
                    $data["trip_id"] = $trip_id = $tripinfo['id'];
                    $data["trip"] = $trip = $tripinfo;
                    $data["driver"] = $driver_row = array();
                    $drivdetail = $this->db->select("id,name,contact_num,track_type")->get_where(
                        "tb_truck_drivers",
                        array("id" => $trip['driver_id']),
                        1,
                        0
                    );
                    if ($drivdetail->num_rows() > 0) {
                        $data["driver"] = $driver_row = $drivdetail->row_array();
                    }
                    $data["vehicle"] = $data["record"] = array();
                    
                    $select = "td.register_number,td.latitude,td.longitude,td.speed,td.battery,td.receivedon as timestamp, o.shipmentid as shipmentid";
                    $table = "tb_trips tr";
                    $where = "td.id='" . $trip['vehicle_id'] . "' AND tr.id='" . $data["trip_id"] . "' AND o.order_id='" . $data["order_id"] . "'";
                    $vehicle = $this->common->getvehicledata($select, $table, $where);
                    $data["vehicles"] = [];
                    if (!empty($vehicle)) {
                        $data["vehicle"] = $data["record"] = $vehicle;
                        
                        $vehicle_id = $trip['vehicle_id'];
                        $data["records"] = $this->db->query(
                            "SELECT register_number,latitude,longitude,speed,battery,azimuth,key_exist,inouts,receivedon as `timestamp` FROM tb_trucks_data WHERE id=$vehicle_id"
                        );
                        if ($data["records"]->num_rows() > 0) {
                            $data["vehicles"] = $data["records"]->result_array();

                        }
                    }

                    $data["ref"] = "";
                    $refs = $this->db->query(
                        "SELECT GROUP_CONCAT(ref_value) as ref from tb_order_references where order_id=$oid AND status=1"
                    );
                    if ($refs->num_rows() > 0) {
                        $data['ref'] = $refs->row()->ref;
                    }
                    $flag = $lat = $lng = $dist = 0;
                    if ($tripinfo['status'] == 1 && $tripgps && $tripgps['order_id'] == $ord->order_id) {
                        $records = $data["records"] = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where trip_id =? ".$locationsWhereCondition." ORDER BY id,`timestamp` ASC",[$trip_id]);
                        if ($records->num_rows() > 0) {
                            foreach ($records->result() as $row) {
                                if ($flag == 0) {
                                    $flag = 1;
                                    $lat = $row->latitude;
                                    $lng = $row->longitude;
                                    $tstamp = $row->timestamp;
                                } else {
                                    $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                                    if ($tstamp != 0) {
                                        $datetime1 = new DateTime($tstamp);//start time
                                        $datetime2 = new DateTime($row->timestamp);//end time
                                        $interval = $datetime1->diff($datetime2);
                                        $time = $interval->format('%s');
                                        if ($time > 0) {
                                            $ratio = ($a * 1000) / $time;
                                        } else {
                                            $ratio = 0;
                                        }
                                        if ($ratio < 30 || $time < 300) { // 30 is max allowed spped 30 MPS equelent to 108 KMPH
                                            $dist = $dist + $a;
                                            $lat = $row->latitude;
                                            $lng = $row->longitude;
                                            $tstamp = $row->timestamp;
                                        }
                                    } else {
                                        $dist = $dist + $a;
                                    }
                                }
                            }
                        }
                    } else {
                        $data["records"] = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where trip_id = ? ".$locationsWhereCondition." ORDER BY id, `timestamp` ASC",[$trip_id]);
                        $tripdist = $this->db->select("trip_distance")->get_where("tb_trip_summary", array("trip_id" => $trip_id), 1, 0);
                        if ($tripdist->num_rows() > 0) {
                            $dist = $tripdist->row()->trip_distance;
                        }
                    }
                    $data["travel_dist"] = round($dist, 2);
                    $data["isSimBased"] = "false";
                    $data["drivers"] = array();
                    $drivers = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon,d.track_type,td.travelled_km FROM tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC");
                    if ($drivers->num_rows() > 0) {
                        $data["drivers"] = $drivers->result_array();
                    }
                    if (count($driver_row) > 0) {
                        $data["drivers"][] = array("id" => $driver_row['id'], "name" => $driver_row['name'], "contact_num" => $driver_row['name'], "createdon" => null, "track_type" => $driver_row['track_type'], "travelled_km" => $dist);
                    }
                    if (count($data["drivers"]) > 0) {
                        if (isset($data["drivers"][count($data["drivers"]) - 1]["track_type"])) {
                            if ($data["drivers"][count($data["drivers"]) - 1]["track_type"] == "1") {
                                $data["isSimBased"] = "true";
                            }
                        }
                    }
                    $data["pings"] = $data["records"]->num_rows();
                    $data = $this->getOrderStatusDetails($data);
                    $data = $this->getOrderLastLocation($data);
                    if ($this->session->userdata('company_code') == "CNKN") {
                        $this->load->view('livetrack/view_china', $data);
                    }elseif ($this->session->userdata('company_code') == "TWKN") {
                        $this->load->view('livetrack/view_taiwan', $data);
                    }elseif ($this->session->userdata('map_type')) {
                        if ($this->session->userdata('map_type') == 0) {
                            $this->load->view('livetrack/view', $data);
                        } else if ($this->session->userdata('map_type') == 1) {
                            $this->load->view('livetrack/view_eu', $data);
                        } else {
                            $this->load->view('livetrack/view', $data);
                        }
                    } else {
                        $this->load->view('livetrack/view', $data);
                    }
                } else {
                    $data["trip_id"] = 0;
                    $data["travel_dist"] = 0.00;
                    $data["isSimBased"] = "false";
                    $data["drivers"] = $data["driver"] = $data["vehicle"] = $data["record"] = $data["vehicles"] = $data["records"] = [];
                    $data["ref"] = "";
                    $order_id = $ord->order_id;
                    $recs = $this->db->query("SELECT shift_id FROM tb_employee WHERE order_id = '$ordr' GROUP BY order_id");
                    if ($recs->num_rows() > 0) {
                        $shift_id = $recs->row()->shift_id;
                        $shft_vehs = $this->db->query("SELECT vehicle_id FROM tb_shft_veh WHERE shft_id=$shift_id AND status=1 LIMIT 1");
                        if ($shft_vehs->num_rows() > 0) {
                            $vehicle_id = $shft_vehs->row()->vehicle_id;
                            $trip = $this->db->select("driver_id")->order_by("updated_on", "DESC")->get_where("tbl_assigned_drivers", array("vehicle_id" => $vehicle_id, "status" => 1), 1, 0);
                            if ($trip->num_rows() > 0) {
                                $driver_id = $trip->row()->driver_id;
                                $dist = 0;
                                $data["travel_dist"] = 0.00;
                                $data["isSimBased"] = "false";
                                $data["drivers"] = array();
                                $data["driver"] = $driver_row = array();
                                $drivdetail = $this->db->select("id,name,contact_num,track_type")->get_where("tb_truck_drivers", array("id" => $driver_id), 1, 0);
                                if ($drivdetail->num_rows() > 0) {
                                    $data["driver"] = $driver_row = $drivdetail->row_array();
                                }
                                $data["vehicle"] = $data["record"] = array();
                                $data["records"] = $this->db->query("SELECT register_number,latitude,longitude,speed,battery,azimuth,key_exist,inouts,receivedon as `timestamp` FROM tb_trucks_data WHERE id=$vehicle_id");
                                if ($data["records"]->num_rows() > 0) {
                                    $data["vehicles"] = $data["records"]->result_array();

                                }
                                $data["ref"] = "";
                                $refs = $this->db->query("SELECT GROUP_CONCAT(ref_value) as ref from tb_order_references where order_id=$oid AND status=1");
                                if ($refs->num_rows() > 0) {
                                    $data['ref'] = $refs->row()->ref;
                                }
                                if (count($driver_row) > 0) {
                                    $data["drivers"][] = array(
                                        "id" => $driver_row['id'],
                                        "name" => $driver_row['name'],
                                        "contact_num" => $driver_row['name'],
                                        "createdon" => null,
                                        "track_type" => $driver_row['track_type'],
                                        "travelled_km" => $dist
                                    );
                                }
                                if (count($data["drivers"]) > 0) {
                                    if (isset($data["drivers"][count($data["drivers"]) - 1]["track_type"])) {
                                        if ($data["drivers"][count($data["drivers"]) - 1]["track_type"] == "1") {
                                            $data["isSimBased"] = "true";
                                        }
                                    }
                                }
                                $data["pings"] = $data["records"]->num_rows();
                                $data = $this->getOrderStatusDetails($data);
                                $data = $this->getOrderLastLocation($data);
                                if ($this->session->userdata('company_code') === "CNKN") {
                                    $this->load->view('livetrack/view_china', $data);
                                } elseif ($this->session->userdata('company_code') === "TWKN") {
                                    $this->load->view('livetrack/view_taiwan', $data);
                                } elseif ($this->session->userdata('map_type')) {
                                    if ($this->session->userdata('map_type') == 0) {
                                        $this->load->view('livetrack/view', $data);
                                    } elseif ($this->session->userdata('map_type') == 1) {
                                        $this->load->view('livetrack/view_eu', $data);
                                    } else {
                                        $this->load->view('livetrack/view', $data);
                                    }
                                } else {
                                    $this->load->view('livetrack/view', $data);
                                }
                            }
                        } elseif ($this->session->userdata('map_type') == 0) {
                            $data["pings"] = 0;
                            $this->load->view('livetrack/view', $data);
                        }
                    }
                }
            } else {
                echo "No order info found!";
            }
        } else {
            echo "No order info found!";
        }
    }

    public function getUserTimeZone($uid, $cmpcode)
    {
        $getqry = $this->db->query(
            "SELECT country_code,cntry_timezone,cntry_hrs,currency FROM tbl_country_master WHERE (country_code='" . $cmpcode . "' OR country_name='" . $cmpcode . "') AND status=1 LIMIT 1"
        );
        $res = array("currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG");
        if ($getqry->num_rows() > 0) {
            $res = array(
                "currency" => $getqry->row()->currency,
                "timezone" => $getqry->row()->cntry_timezone,
                "hrs" => $getqry->row()->cntry_hrs,
                'country' => $getqry->row()->country_code
            );
        }
        return $res;
    }

    public function getTripLocation($trip_id = null, $receivedon = 0)
    {
        $response = [];
        $curtz = isset($_REQUEST["timezone"]) ? $_REQUEST["timezone"] : "";
        if ($curtz == "") {
            $curtz = "Asia/Singapore";
        }
        if ($trip_id != null) {
            $speedval = 1.60934;
            if ($receivedon == 0 || $receivedon == "") {
                $query = $this->db->query("SELECT * FROM (SELECT id,latitude,longitude,round(speed*$speedval,2) as speed,battery,bearing as course,convertToClientTZ(`timestamp`,'" . $curtz . "') as `timestamp` from tb_rtdrive_locations where trip_id = '$trip_id'  ORDER BY id,`timestamp` DESC limit 3) T ORDER BY id,`timestamp` ASC");
            } else {
                $receivedon = date("Y-m-d H:i:s", ($receivedon));
                $query = $this->db->query("SELECT * FROM (SELECT id,latitude,longitude,round(speed*$speedval,2) as speed,battery,bearing as course, convertToClientTZ(`timestamp`,'" . $curtz . "') as `timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' AND `timestamp`>'$receivedon' ORDER BY id,`timestamp` DESC limit 3) T ORDER BY id,`timestamp` ASC");
                //echo $this->db->last_query();
            }
            foreach ($query->result() as $row) {
                $response[] = array(
                    "lat" => $row->latitude,
                    "lng" => $row->longitude,
                    "speed" => uom_string($row->speed, 'km'),
                    "course" => $row->course,
                    "battery" => $row->battery,
                    "receivedon" => date("Y m,d h:i:s", strtotime($row->timestamp)),
                    "timestamp" => strtotime($row->timestamp)
                );
            }

            if (count($response) > 0) {
                echo json_encode(array(
                    "status" => "1",
                    "data" => $response,
                    "message" => ""
                ));
            } else {
                echo json_encode(array(
                    "status" => "0",
                    "data" => $response,
                    "message" => "No data Found!"
                ));
            }
        } else {
            echo json_encode(array(
                "status" => "0",
                "data" => $response,
                "message" => "Vehicle sent empty!"
            ));
        }
    }

    /* new function to optimize query */
    private function getIdByOrderId($ord = "")
    {
        $ordCnt = $this->db->query(
            "SELECT id,order_id,company_code,user_id,shipmentid,trip_id,pickup_address1,pickup_address2,
                    pickup_city,pickup_country,pickup_pincode,pickup_datetime,delivery_address1,
                    delivery_address2,delivery_city,delivery_country,delivery_pincode,drop_endtime,customer_id,plat,plng,dlat,dlng,status,trip_sts
             FROM tb_orders
             WHERE (id='" . $ord . "' OR order_id='" . $ord . "')
             AND status!=0"
        );

        if ($ordCnt->num_rows() > 0) {
            return $ordCnt->row();
        } else {
            $qr = $this->db->query("SELECT order_id from tb_order_references where ref_value='$ord' AND status=1");

            if ($qr->num_rows() > 0) {
                $ord = $qr->row()->order_id;
                $ordCnt = $this->db->query(
                    "SELECT id,order_id,company_code,user_id,shipmentid,trip_id,pickup_address1,pickup_address2,
                            pickup_city,pickup_country,pickup_pincode,pickup_datetime,delivery_address1,
                            delivery_address2,delivery_city,delivery_country,delivery_pincode,drop_endtime,customer_id,plat,plng,dlat,dlng
                     FROM tb_orders
                     WHERE (id='" . $ord . "' OR order_id='" . $ord . "')
                     AND status!=0"
                );

                if ($ordCnt->num_rows() > 0) {
                    return $ordCnt->row();
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    private function getOrderId($ord = "")
    {
        $ordcnt = $this->db->select("id")->get_where("tb_orders", array("id" => $ord), 1, 0)->num_rows();

        if ($ordcnt > 0) {
            return $ord;
        } else {
            $ors = $this->db->select("id")->get_where("tb_orders", array("order_id" => $ord), 1, 0);

            if ($ors->num_rows() > 0) {
                return $ors->row()->id;
            } else {
                $qr = $this->db->query("SELECT order_id from tb_order_references where ref_value='$ord' AND status=1");

                if ($qr->num_rows() > 0) {
                    return $qr->row()->order_id;
                } else {
                    return false;
                }
            }
        }
    }

    public function getCrossBorderStopDetails($shiftId, $currentTimeZone)
    {
        $shiftIds = $finalTripsArray = [];
        $trips = 0;
        if ($shiftId > 0) {
            $trips = 1;
            $getLegIds = $this->common->gettbldata(['shift_leg_id' => $shiftId], "id", "tb_shifts", 0, 0);
            foreach ($getLegIds as $eachId) {
                $shiftIds[] = $eachId['id'];
            }
            if (!empty($shiftIds)) {
                $getTripIds = $this->common->gettbldata("shift_id IN (" . implode(",", $shiftIds) . ") AND status ='1'", "trip_id", "tb_employee", 0, 0);
                foreach ($getTripIds as $eachId) {
                    $tripId = $eachId['trip_id'];
                    if ($tripId > 0) {
                        $tripIds[] = ['tripId' => $tripId, 'shiftId' => $eachId['shift_id']];
                    } else {
                        $trips = 0;
                        break;
                    }
                }
            }
        }
        if ($trips > 0 && !empty($tripIds)) {
            $tripDetails = $this->common->gettbldata("id IN ( " . implode(",", $tripIds) . ") ANd status ='1'", "id,shift_id,driver_id,vehicle_id,convertToClientTZ(stime,'" . $currentTimeZone . "') as stime,convertToClientTZ(etime,'" . $currentTimeZone . "') as etime,status,dlat as latitude,dlng as longitude", "tb_trips", 0, 0);
            foreach ($tripDetails as $eachTrip) {
                $finalTripsArray[] = ['id' => $eachTrip['id'], 'shift_id' => $eachTrip['shift_id'], 'driver_id' => $eachTrip['driver_id'], 'vehicle_id' => $eachTrip['vehicle_id'], 'stime' => $eachTrip['stime'], 'etime' => $eachTrip['etime'], 'status' => $eachTrip['status'], 'latitude' => $eachTrip['latitude'], 'longitude' => $eachTrip['longitude']];
            }
        }
        return $finalTripsArray;
    }

    public function shipmentView($ord = "")
    {
        if ($ord != "") {
            $curtz = isset($_REQUEST["timezone"]) ? $_REQUEST["timezone"] : "";
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            $ord = $this->getOrderId($ord);
            if ($ord) {
                $ordchkqry = $this->db->query("SELECT order_id,shift_id,trip_id,plat,plng,dlat,dlng FROM tb_orders where id = ? LIMIT 1", [$ord]);
                if ($ordchkqry->num_rows() > 0) {
                    $tripid = $ordchkqry->row()->trip_id;
                    $data['plat'] = $ordchkqry->row()->plat;
                    $data['plng'] = $ordchkqry->row()->plng;
                    $data['dlat'] = $ordchkqry->row()->dlat;
                    $data['dlng'] = $ordchkqry->row()->dlng;
                    $ship_id = $ordchkqry->row()->shift_id;
                    if ($tripid > 0) {
                        $tripArray[] = chkTripinfoByOrdertrip($tripid, $curtz);
                    } else {
                        $tripArray = $this->getCrossBorderStopDetails($ship_id, $curtz);
                    }
                    if (!empty($tripArray)) {
                        foreach ($tripArray as $tripinfo) {
                            $data["trip_id"] = $trip_id = $tripinfo['id'];
                            $data["trip"] = $trip = $tripinfo;
                            $driver_id = $tripinfo['driver_id'];
                            $ship_id = $tripinfo['shift_id'];
                            $data["stops"] = $this->db->query("SELECT id, stopname,plat,plng, stopcity, address, stoptype, convertToClientTZ(startdate,'" . $curtz . "') as startdate,weight,volume,ship_units from tb_shiporder_stops where shipment_id = ? AND status=? ORDER BY ordernumber ASC",[$ship_id,'1']);
                            $data["details"] = $stoplocations = [];
                            if ($data["stops"]->num_rows() > 0) {
                                foreach ($data["stops"]->result() as $stop) {
                                    $stoplocations[] = ['lat' => $stop->plat, 'lng' => $stop->plng];
                                    $det = $this->db->query("SELECT id,plat,plng,pickup,stop_id,convertToClientTZ(pickup_datetime,'" . $curtz . "') as pickup_datetime, dlat, dlng, `drop`, convertToClientTZ(drop_datetime,'" . $curtz . "') as drop_datetime, shipment_weight, shipment_volume,order_id from tb_employee where (stop_id = ? OR drop_stopid = ?) AND status = ?",[$stop->id,$stop->id,'1']);
                                    if ($det->num_rows() > 0) {
                                        foreach ($det->result() as $row) {
                                            $details = [];
                                            if ($row->stop_id == $stop->id) {
                                                $details["lat"] = $row->plat;
                                                $details["lng"] = $row->plng;
                                                $details["name"] = $row->pickup;
                                                $details["time"] = $row->pickup_datetime;
                                                $details["type"] = "P";
                                            } else {
                                                $details["lat"] = $row->dlat;
                                                $details["lng"] = $row->dlng;
                                                $details["name"] = $row->drop;
                                                $details["time"] = $row->drop_datetime;
                                                $details["type"] = "D";
                                            }
                                            $details["weight"] = $row->shipment_weight;
                                            $details["volume"] = $row->shipment_volume;

                                            $details["stop_id"] = $stop->id;
                                            $details["id"] = $row->id;
                                            $details["order_id"] = $row->order_id;
                                            $details["alphabet"] = getColName(count($data["details"]) + 1);
                                            $details["status"] = "0";
                                            $qdone = $this->db->query("SELECT ss.stop_detail_id,ss.status_id,ss.latitude,ss.longitude,ss.loc_name,convertToClientTZ(ss.createdon,'" . $curtz . "') as createdon, sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id= ? AND ss.stop_id = ? AND ss.stop_detail_id = ? AND ss.status=? ORDER BY ss.createdon ASC",[$ship_id,$stop->id,$row->id,1]);
                                            $status_row = [];
                                            if ($qdone->num_rows() > 0) {
                                                foreach ($qdone->result() as $sts) {
                                                    $status_row["detail_id"] = $sts->stop_detail_id;
                                                    $status_row["status_id"] = $sts->status_id;
                                                    $status_row["status_name"] = $sts->status_name;
                                                    $status_row["in_lat"] = $sts->latitude;
                                                    $status_row["in_lng"] = $sts->longitude;
                                                    $status_row["in_time"] = $sts->createdon;
                                                    $status_row["loc_name"] = $sts->loc_name;
                                                    $details["statuses"][] = (object)$status_row;
                                                }
                                                $details["status"] = "1";
                                            } else {
                                                $details["statuses"][] = (object)$status_row;
                                            }
                                            $data["details"][] = (object)$details;
                                        }
                                    }
                                }
                            }
                            $data["drivers"] = [];
                            $drivers = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon,d.track_type,td.travelled_km from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id = ? AND td.status =? GROUP BY d.id ORDER BY td.createdon ASC",[$trip_id,'1']);
                            if ($drivers->num_rows() > 0) {
                                $data["drivers"] = $drivers->result_array();
                            } else {
                                $stime = $tripinfo['stime'];
                                $drivers1 = $this->db->query("SELECT id,name,contact_num,'" . $stime . "' as createdon,track_type,'0' as travelled_km FROM tb_truck_drivers WHERE id = ? LIMIT 1",[$driver_id]);
                                if ($drivers1->num_rows() > 0) {
                                    $data["drivers"] = $drivers1->result_array();
                                }
                            }
                        }
                        $data['stoplocations'] = $stoplocations ?? [];
                        if ($this->session->userdata('company_code') == "CNKN") {
                            $this->load->view('livetrack/shipmentViewChina', $data);
                        } elseif ($this->session->userdata('company_code') == "TWKN") {
                            $this->load->view('livetrack/shipmentViewChina', $data);
                        } else {
                            $this->load->view('livetrack/shipmentView', $data);
                        }
                    } else {
                        echo "";
                    }
                } else {
                    echo "";
                }
            } else {
                echo "";
            }
        } else {
            echo "";
        }
    }

    public function orderdetails()
    {
        $data['ord_type'] = "done";
        if ($this->input->post("order_id")) {
            $order_id = $this->input->post("order_id");
            $userid = $company_code = $branch_code = "";
            $data['ord_type'] = $this->input->post("type");
            $data["orderCargo"] = $this->Order->getTotalMeasurementData($order_id);
            $curtz = $_REQUEST["timezone"];
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $ordchk = $this->db->where(array("id" => $order_id))->get("tb_orders");
            if ($ordchk->num_rows() > 0) {
                $data["order"] = $order = $ordchk->row();
                if ($this->session->userdata('user_id')) {
                    $company_code = $this->session->userdata('company_code');
                    $branch_code = $this->session->userdata('branch_code');
                }
                $userid = $order->user_id;
                $user = $this->db->select("company_code,branch_code")->where("id", $userid)->get("tb_users");
                if ($user->num_rows() > 0) {
                    $company_code = $user->row()->company_code;
                    $branch_code = $user->row()->branch_code;
                }
                $data['userid'] = $userid;
                $party_types = array();
                $partytypes = $this->db->select("id,name")->get_where("tbl_party_types", array("user_id" => $userid, 'company_code' => $company_code));
                if ($partytypes->num_rows() == 0) {
                    $chk = $this->db->select("name,description")->get_where("tbl_party_types", array("user_id" => 1));
                    if ($chk->num_rows() > 0) {
                        foreach ($chk->result_array() as $res) {
                            $ins = array('name' => $res['name'], 'description' => $res['description'], 'user_id' => $userid, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1, 'created_on' => $curdt);
                            $insqry = $this->db->insert("tbl_party_types", $ins);
                        }
                    }
                    $partytypes = $this->db->select("id,name")->get_where("tbl_party_types", array("user_id" => $userid, 'company_code' => $company_code));
                    $party_types = $partytypes->result_array();
                } else {
                    $party_types = $partytypes->result_array();
                }
                $data['party_types'] = $party_types;
                $data["orderref"] = $this->db->query("SELECT r.reference_id,r.ref_value,t.description FROM tb_order_references r,tb_reference_master t WHERE r.reference_id=t.name AND r.order_id=$order_id AND r.status=1 GROUP BY r.id");
                $data['curtz'] = $curtz;
                echo $this->load->view("livetrack/vieworderdetails", $data, TRUE);
            }
        }
    }

    public function statusviewdetails()
    {
        $ord = $this->input->post("order_id");
        $tripinfo = $this->common->gettblrowdata(array("order_id" => $ord), "plat,plng,dlat,dlng,shift_id,trip_id", "tb_orders", 0, 0);
        if (count($tripinfo) > 0) {
            $curtz = isset($_REQUEST["timezone"]) ? $_REQUEST["timezone"] : "";
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $shift_id = $tripinfo['shift_id'];
            $whr = " AND status = 1";
            $dlat = $tripinfo['dlat'];
            $dlng = $tripinfo['dlng'];
            $slat = $tripinfo['plat'];
            $slng = $tripinfo['plng'];
            $data["drivers"] = array();
            $trip_id = $tripinfo['trip_id'];
            if ($trip_id != 0) {
                $qry = $this->db->query("SELECT id,vehicle_id,start_imei FROM tb_trips WHERE id='$trip_id' ORDER BY id DESC LIMIT 1");
                if ($qry->num_rows() > 0) {
                    if ($slat == '' && $slng == '') {
                        $rec = $this->db->query("SELECT latitude,longitude from tb_trucks_data WHERE id = '" . $qry->row()->vehicle_id . "' and latitude!='' and longitude!='' LIMIT 1");
                        if ($rec->num_rows() > 0) {
                            $slat = $rec->row()->latitude;
                            $slng = $rec->row()->longitude;
                        }
                    }
                    $drivers = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status =1 GROUP BY d.id ORDER BY td.createdon ASC");
                    if ($drivers->num_rows() > 0) {
                        $data["drivers"] = $drivers->result_array();
                    }
                }
            }
            $sql = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,sm.status_name,ss.startdate,ss.enddate
                from tb_stop_status ts
                LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                WHERE ts.shipment_id = '$shift_id'
                GROUP BY ts.id ORDER BY ts.createdon ASC");
            $data["history"] = $sql;
            $data["slat"] = @$slat;
            $data["slng"] = @$slng;
            $data["dlat"] = @$dlat;
            $data["dlng"] = @$dlng;
            $data['epod'] = array();
            $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", array("shipment_id" => $shift_id, "doc_type" => 3, "status" => 1), 1, 0);
            if ($docs->num_rows() > 0) {
                $data['epod'] = array("status_code" => "3060", "status_name" => "ePOD Available", "stop_id" => $docs->row()->stop_id, "stop_type" => $docs->row()->stop_type, "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude), "createdon" => $docs->row()->createdon);
            }
            $data['curtz'] = $curtz;
            echo $this->load->view("livetrack/statusview", $data, TRUE);
        }
    }

    public function orddocsdetails()
    {
        $ord = $this->input->post("order_id");
        $ordid = $this->input->post("id");
        $data['ord_type'] = "done";
        $whr = "";
        if ($ordid > 0) {
            $whr = " AND ts.order_id=$ordid ";
        }
        $data['ord_type'] = "done";
        $tripinfo = $this->common->gettblrowdata(array("order_id" => $ord), "id,order_id,company_code,branch_code,shift_id,trip_id", "tb_orders", 0, 0);
        if (count($tripinfo) > 0) {
            $curtz = $_REQUEST["timezone"];
            $data['ord_type'] = $this->input->post("type");
            $shift_id = $tripinfo['shift_id'];
            $data['ship_id'] = $tripinfo['shift_id'];
            $data['trip_id'] = $tripinfo['trip_id'];
            $sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.shipment_id = $shift_id GROUP BY ts.id");
            if ($sql1->num_rows() > 0) {
                $i = 1;
                foreach ($sql1->result_array() as $eachRow) {
                    //$base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    if (!empty($eachRow['imgpath'])) {
                        $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                    } else {
                        $base64DocumentData = [
                            'extention' => '',
                            'file_content' => ''
                        ];
                    }
                    $pods[] = [
                        'sno' => $i,
                        'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                        'type_name' => $eachRow['type_name'],
                        'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                        'stop_id' => $eachRow['stop_id'],
                        'stop_type' => $eachRow['stop_type'],
                        'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                        'extention' => $base64DocumentData['extention'],
                        'file_content' => $base64DocumentData['file_content'],
                    ];
                    $i++;
                }
            }
            $data["pods"] = $pods ?? [];
            $data['order_id'] = $ord;
            $data['document_types'] = $this->db->select("id,type_name")->get_where("tb_document_types", array("status" => 1))->result_array();
            $data['stops'] = array();
            $sql = "SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e WHERE o.shipment_id=e.shift_id AND e.order_id='" . $ord . "' AND o.status=1 AND e.status=1 ORDER BY o.ordernumber ASC";
            $stops = $this->db->query($sql);
            if ($stops->num_rows() > 0) {
                $data['stops'] = $stops->result_array();
            }
            $data['order'] = (object)$tripinfo;
            echo $this->load->view("livetrack/managedocuments", $data, TRUE);
        }
    }

    public function hosdetails()
    {
        $ord = $this->input->post("order_id");
        $curtz = $_REQUEST["timezone"];
        $data["order"] = $ord;
        if (isset($ord)) {
            echo $this->load->view('livetrack/hosdetails', $data, TRUE);
        }
    }

    public function alarmdetails()
    {
        $ord = $this->input->post("order_id");
        $curtz = $_REQUEST["timezone"];

        $whr1 = array('id' => $ord);
        $ordchkqry = $this->common->gettbldata($whr1, '*', 'tb_orders', 1, 0);
        if (count($ordchkqry) > 0) {
            $data["order"] = $order = $ordchkqry;

            $tripinfo = chkTripinfoByOrdertrip($order[0]['trip_id'], $curtz);

            if (count($tripinfo) > 0) {
                $data["trip"] = $trip = $tripinfo;
                $data["vehicle"] = $data["record"] = array();
                $whr = array('id' => $trip['vehicle_id'], 'user_id' => $order[0]['user_id']);

                $data["vehicle"] = $data["records"] = $this->common->gettbldata($whr, 'register_number,latitude,longitude,speed,battery,azimuth,inouts,key_exist,receivedon as `timestamp`', 'tb_trucks_data', 0, 0);
            }
        }

        $data["order"] = $ord;
        if (isset($ord)) {
            echo $this->load->view('livetrack/alarmdetails', $data, TRUE);
        }
    }

    public function newview()
    {
        $this->load->view('livetrack/newview');
    }

    public function offStreetParking()
    {
        $app_id = HERE_OFFSTREET_APP_ID;
        $app_code = HERE_OFFSTREET_APP_CODE;
        $lat = $_POST['latitude'];
        $long = $_POST['longitude'];
        $radius = $_POST['radius'];
        $serviceurl = "https://parking-v2.cit.cc.api.here.com/parking/facilities.json?app_id=$app_id&app_code=$app_code&prox=$lat,$long,$radius";
        $response = offStreetParkingApi($serviceurl);
        echo $response;
    }

    /**
     * unknown function, without effect on anything
     * @deprecated
     */
    public function hereCredentails()
    {
        $string = $secret = '';
        $oauth_signature = hash_hmac('sha256', $string, $secret);
        $oauth_consumer_key = "uUrhZF-XURzvJvQYxRCByA";
        $oauth_nonce = password_hash(uniqid(rand(), true), PASSWORD_DEFAULT);
        $oauth_signature_method = "HMAC-SHA256";
        $oauth_timestamp = strtotime(date("Y-m-d H:i:s"));
        $oauth_version = "1.0";
    }
    /**
     * @param array $data
     * @return array
     */
    private function getOrderStatusDetails(array $data): array
    {
        if (checkAccessConditions('RELATED_2_TW_CN', $this->session->userdata('company_code'))) {
            $this->load->model('Order');
            $orderStatusCodes = $this->Order->getOrderStatusCodes($data["id"]);
            $statusCodes = [];
            $isPickUpDone = 'No';
            $isOrderDelivered = 'No';
            $isOrderHasIntransitPoint = 'No';
            if (!empty($orderStatusCodes)) {
                foreach ($orderStatusCodes as $code) {
                    $statusCodes[] = $code['status_code'];
                }
                if (in_array('0500', $statusCodes)) {
                    $isPickUpDone = 'Yes';
                }
                if (in_array('3000', $statusCodes)) {
                    $isOrderDelivered = 'Yes';
                }
                if (in_array('1550', $statusCodes)) {
                    $isOrderHasIntransitPoint = 'Yes';
                }
            }
            $data['isPickUpDone'] = $isPickUpDone;
            $data['isOrderDelivered'] = $isOrderDelivered;
            $data['isOrderHasIntransitPoint'] = $isOrderHasIntransitPoint;
        }
        return $data;
    }
    
    private function getOrderLastLocation(array $data): array
    {

        $orderId = $data["id"];
        $this->db->select('loc_name,latitude,longitude,createdon');
        $this->db->where(array('order_id'=>$orderId,'status_code'=>1550,'STATUS'=>1));
        $this->db->order_by('id','DESC');
        $this->db->limit(1);
        $result = $this->db->get('tb_stop_status');
        $lastLocationData = $result->result_array();
        if(!empty($lastLocationData)){
            $lastLocationData = $lastLocationData[0];
            $lastIntransitName = getLocationName($lastLocationData['latitude'],$lastLocationData['longitude']);
            $data['lastLocName'] = $lastLocationData['loc_name'];
            $data['lastIntransitName'] = $lastIntransitName;
            $data['lastLocDateTime'] = $lastLocationData['createdon'];
        }

        return $data;
    }
}