<?php
error_reporting(E_ALL);
defined('BASEPATH') or exit('No direct script access allowed');
class Logs extends CI_Controller
{

  public function __construct()
  {
      parent::__construct();
      /*if (!$this->session->has_userdata('user_id')) {
          redirect("./");
      }*/
  }
  /* sending epods for knlogin from Medtronic customer orders*/
  public function sendknloginepod($fromdate=null,$todate=null,$custid=null){
    $current_dt = date('Y-m-d',strtotime($fromdate));
    $to_dt = date('Y-m-d',strtotime($todate));
    if((strpos($current_dt, "1970-01-01") === false) && (strpos($to_dt, "1970-01-01") === false) && $custid>0){
      $getpodsqry = "SELECT p.imgpath,o.order_id,o.company_code,o.branch_code FROM tb_pod_uploads p,tb_orders o WHERE p.order_id=o.id AND p.doc_type=3 AND p.imgpath != '' AND o.customer_id=$custid AND DATE(o.createdon) >='".$current_dt."' AND DATE(o.createdon) <='".$to_dt."' AND o.status!=0";
      $getepod = $this->db->query($getpodsqry);
      if($getepod->num_rows()>0){
        foreach($getepod->result_array() as $res){
          $fileName = $res['imgpath'];
          $company_code = $res['company_code'];
          $branch_code = $res['branch_code'];
          $order_number = $res['order_id'];
          $filePath = NEW_POD_PATH.$fileName;
          $newpdfpath = NEW_POD_PATH.'RL'.$order_number.'.pdf';
          $ext = pathinfo($fileName, PATHINFO_EXTENSION);
          if(file_exists($filePath)){
            if($ext != "pdf"){
              /*convert into PDF*/
              /*try {
                $im = new Imagick();
                $im->setResolution(300,300);
                $im->readImage($filePath);
                $im->setFormat('pdf');
                $im->writeImage($newimgpath);
                $im->clear();
                $im->destroy();
                $filePath = $newimgpath;
              } catch (\Exception $e) {
                log_message("error","convert pdf failed".$e->getMessage());
              }*/
              $filePath = $this->imageToPdf($filePath,$ext,$newpdfpath);
            }
            $pages = $this->getNumPagesPdf($filePath);
            $unique_id = "RL".$order_number.".".date("Ymd").".".date("his");
            $jplData = array("country"=>substr($company_code,0,-2),"branch"=>substr($branch_code,2),"order_id"=>$order_number,"time"=>date("hi"),"unique_id"=>$unique_id,"date"=>date("d.m.Y"),"pages"=>$pages);
            $jplFilePath = $this->saveJPF($jplData);
            $storeftipjpl = $this->uploadKNFile($jplFilePath);
            $storeftippdf = $this->uploadKNFile($filePath);
          }
        }
      }
    }
    echo "success";
  }

  /*
   *  Purpose : To convert image into pdf
   */
  function imageToPdf($source_file, $ext, $destination_file_name) {
      require 'vendor/autoload.php';
      $mpdf = new \Mpdf\Mpdf([
          'tempDir' => FCPATH . 'assets/tmp'
      ]);
      $size = getimagesize($source_file);
      $width = $size[0];
      $height = $size[1];
      $mpdf->WriteHTML('');
      $mpdf->Image($source_file, 5, 5, $width, $height, strtolower($ext), '', true, true);
      $mpdf->Output($destination_file_name, 'F');
      return $destination_file_name;
  }

  /* get the number of pages in epod pod */
  function getNumPagesPdf($filepath) {
    $fp = @fopen(preg_replace("/\[(.*?)\]/i", "", $filepath), "r");
    $max = 0;
    if (!$fp) {
        return "Could not open file: $filepath";
    } else {
        while (!@feof($fp)) {
            $line = @fgets($fp, 255);
            if (preg_match('/\/Count [0-9]+/', $line, $matches)) {
                preg_match('/[0-9]+/', $matches[0], $matches2);
                if ($max < $matches2[0]) {
                    $max = trim($matches2[0]);
                    break;
                }
            }
        }
        @fclose($fp);
    }
    return $max;
  }
  /* save jpl file in jpl_files */
  public function saveJPF($jplData){
    $content = $this->load->view("jpl_template",$jplData,TRUE);
    $order_id = $jplData["order_id"];
    $file_path = "./assets/jpl_files/RL$order_id.jpl";
    $fp = fopen($file_path,"wb");
    fwrite($fp,$content);
    fclose($fp);
    return $file_path;
  }
  /* send jpl and epod files to KN FTP */
  public function uploadKNFile($localfile){
    $remotefile = basename($localfile);
    $ftp = @ftp_connect(KN_FTP_URL);
    if (false === $ftp) {
    }else{
      $loggedIn = @ftp_login($ftp,KN_FTP_USER,KN_FTP_PASSWORD);
      if(true === $loggedIn){
        ftp_pasv($ftp, true);
        $ret = @ftp_nb_put($ftp, "./pub/inbound/$remotefile", $localfile, FTP_BINARY, FTP_AUTORESUME);
        while (FTP_MOREDATA == $ret)
        {
          $ret = ftp_nb_continue($ftp);
        }
      }
      ftp_close($ftp);
    }
  }

  public function view(){
      echo <<<EOT
<!DOCTYPE html>
<html lang="en">
<head>
  <title>Logs</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <style>
        #footer {
            position: fixed;
            height: 50px;
            background: #fff;
            padding: 10px;
            bottom: 0px;
            left: 0px;
            right: 0px;
            margin-bottom: 0px;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <h1>Codeigniter Logs</h1>
  <pre class="logs" style="margin-bottom: 50px;font-size: smaller;">
  </pre>
</div>
<footer class="footer" id="footer">
  <div class="container-fluid">
    <div class="row">
        <div class="col-md-6" style="padding-top: 7px;">Codeigniter Logs</div>
        <div class="col-md-6" style="text-align: right;padding-top: 7px;"><div class="btn btn-default btn-xs" onclick="getLogs(true)">Refresh</div> | <div class="btn btn-danger btn-xs" onclick="clearLogs()">Clear Logs</div></div>
    </div>
  </div>
</footer>
</body>
<script type="text/javascript">
    getLogs(true);
    function getLogs(bool){
        $.ajax({
            url:"/logs/log",
            success:function(data){
                $(".logs").html(escapeHtml(data));
                if(bool)
                    $('html, body').scrollTop( $(document).height() );
                setTimeout(function(){getLogs(false);}, 30000);
            }
        });
    }
    function clearLogs(){
        $.ajax({
            url:"/logs/clearLogs",
            success:function(data){
                $(".logs").html(data);
                $('html, body').scrollTop( $(document).height() );
            }
        });
    }
    function escapeHtml(text) {
      return text
          .replace(/&/g, "&amp;")
          .replace(/</g, "&lt;")
          .replace(/>/g, "&gt;")
          .replace(/"/g, "&quot;")
          .replace(/'/g, "&#039;");
    }
</script>
</html>
EOT;
    }

  public function log($date = null) {
      if (empty(ENABLE_CONTROLLER_LOGS)) {
          echo "Logs are disabled";
          return;
      }

      if($date === null){
          $date = date("Y-m-d");
      }

      echo htmlspecialchars(readFile(sprintf('%slogs/log-%s.php', APPPATH, $date), $date));
  }

    public function clearLogs(){
        $date=date("Y-m-d");
        $file = "./application/logs/log-".$date.".php";
        $f = @fopen($file, "r+");
        if ($f !== false) {
            ftruncate($f, 0);
            fclose($f);
        }
        echo htmlspecialchars(readFile($file,$date));
    }
    private function readFile($file,$date){

        $file = fopen($file,"r");

        if(!$file) {
            echo "$date --> Log not found till now.\n";    //getting this error everytime.
            exit;
        }

        $size = filesize($file);

        if(!$size) {
            echo "$date --> File is empty.\n";
            exit;
        }

        $content = fread($file,$size);

        fclose($file);
        return $content;
    }

  public function senduat(){
    $request="<?xml version='1.0' encoding='UTF-8' ?>
<Transmission>
  <TransmissionHeader>
    <Version>1.0</Version>
    <UserName>xlog</UserName>
    <Password>iWDol5WHpP</Password>
    <SenderTransmissionNo>8806541124118830_TH1702200005</SenderTransmissionNo>
    <AckSpec>
      <ComMethodGid>transmission</ComMethodGid>
      <ComType>
        <Url>https://elog360.app/svkonekt_test/api/v1/edi</Url>
        <EmailAddress>dummy@email.com</EmailAddress>
      </ComType>
      <AckOption>SUCCESS</AckOption>
    </AckSpec>
    <Source>XLOG</Source>
    <Destination>ETN</Destination>
    <ReferenceId>TH1702200005</ReferenceId>
    <ModeOfTransport>FTL</ModeOfTransport>
    <Action>ReceiveCarrierDetails</Action>
  </TransmissionHeader>
  <TransmissionBody>
    <InvolvedParties>
      <Carrier>
        <ID>THCA00064</ID>
        <FirstName>Nawapong</FirstName>
        <LastName>Singprem</LastName>
        <FullName>Nawapong Singprem</FullName>
        <ContactNo>
          <CountryCode>66</CountryCode>
          <AreaCode>02</AreaCode>
          <ContactNo>0813494454</ContactNo>
        </ContactNo>
        <Company>
          <Name>Tensai Trans and Service Co., Ltd.</Name>
          <ContactNo>+66020813494454</ContactNo>
          <RegistrationNumber>0115561018255</RegistrationNumber>
          <EmailAddress>cs.tensaitran@gmail.com</EmailAddress>
        </Company>
        <Address></Address>
      </Carrier>
    </InvolvedParties>
    <Rate>
      <Freights>
        <Freight>
          <FreightBuyRate>3200</FreightBuyRate>
          <RateUnit>trip</RateUnit>
          <Currency>THB</Currency>
          <RevisedFreightBuyRate></RevisedFreightBuyRate>
        </Freight>
      </Freights>
    </Rate>
    <Status>
      <Carrier>
        <StatusCode>CARRIER_ACCEPTED</StatusCode>
        <StatusValue>Pending</StatusValue>
        <DateTime>2020-02-17 09:16:01</DateTime>
      </Carrier>
    </Status>
    <VehicleDetails>
      <VehicleTypeCode>SIX_WHEELER</VehicleTypeCode>
    </VehicleDetails>
  </TransmissionBody>
</Transmission>";

    $serviceurl = "https://elog360.app/svkonekt_test/api/v1/edi/handle";  //th uat
     //$serviceurl = "https://elog360.app/svkonekt_test/api/v1/edi/handle"; //sg uat
         $ch         = curl_init($serviceurl);
         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
         curl_setopt($ch, CURLOPT_POST, 1);
         curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
         curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            if (ENVIRONMENT !== "development") {
                curl_setopt($ch, CURLOPT_PROXY, PROXY_CONSTANT_HERE);
            }
         $output = curl_exec($ch);
         curl_close($ch);
         $response = json_decode(json_encode(simplexml_load_string($output)), true);

         log_message('error', "responsefromthem " . $output);
         log_message('error', "responsefromthem " . json_encode($response));
      print_r($output);
  }
}
