<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Lrgenerate extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('common');
        $this->load->library(['uuid','m_pdf','zip']);
    }

    public function index($order_id = "")
    {
        if (isset($order_id) && strlen($order_id) > 0) {
            $orders = $this->db->where(["id" => $order_id])->get("tb_orders");
            if ($orders->num_rows() > 0) {
                $user_id = $this->session->userdata("user_id");
                $data["page_title"] = "LR Genaration";
                $data["order"] = $order = $orders->row();
                $data["pickup"] = [$order->pickup_company, $order->pickup_address1, $order->pickup_city, $order->pickup_country, $order->pickup_pincode];
                $data["delivery"] = [$order->delivery_company, $order->delivery_address1, $order->delivery_city, $order->delivery_country, $order->delivery_pincode];
                $consignees = $this->db->query("SELECT pm.name,pm.address,pm.country,pm.pincode FROM tbl_party_master pm,tb_order_parties op,tbl_party_types pt WHERE pm.id = op.party_id AND op.party_type = pt.id AND op.order_id = '$order_id' AND pt.name='Consignee' AND pm.status=1");
                if ($consignees->num_rows() > 0) {
                    $data["consignee"] = $consignees->row();
                }
                $consignors = $this->db->query("SELECT pm.name,pm.address,pm.country,pm.pincode FROM tbl_party_master pm,tb_order_parties op,tbl_party_types pt WHERE pm.id = op.party_id AND op.party_type = pt.id AND op.order_id = '$order_id' AND pt.name='CUSTOMER' AND pm.status=1");
                if ($consignors->num_rows() > 0) {
                    $data["consignor"] = $consignors->row();
                }
                $data["user"] = @$this->db->query("SELECT name,domain_name,head_office,gstin FROM tb_users WHERE id='$user_id'")->row();
                $docs_data = [];
                $docs_data["order_id"] = $order_id;
                $docs_data_records = $this->db->select("metadata")->where($docs_data)->get("tb_docs_data");
                if ($docs_data_records->num_rows() > 0) {
                    $data["doc_data"] = json_decode($docs_data_records->row()->metadata);
                }
                $getBranchAddress = $this->getBranchAddress();
                $data["branch_details"]['branch_address'] = $getBranchAddress['branch_address'];
                $data["branch_details"]['branch_gst'] = $getBranchAddress['branch_gst'];
                $data["qr"] = $this->db->query("SELECT qr.path FROM tb_order_cargodetails cd,tb_order_cargo_qrdetails qr WHERE cd.order_id='$order_id' AND qr.order_cargo_details_id = cd.id AND cd.status='1' AND qr.status='1'");
                $this->settemplate->dashboard("lr_report", $data);
            } else {
                show_error("No order found with order id '$order_id'. Please choose appropriate order to generate LR", 406, $heading = "Order Not found");
            }
        } else {
            show_error("No order found with order id '$order_id'. Please choose appropriate order to generate LR", 406, $heading = "Order Not found");
        }
    }

    public function saveInvoice($order_id = "")
    {
        $pdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH . 'assets/tmp'
        ]);
        $data = $this->input->post(null, true);
        if ($order_id != "") {
            $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE id='" . $order_id . "' LIMIT 1");
        } else {
            $order = $data["order_id"];
            $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE order_id='" . $order . "' group by order_id");
        }
        if ($tb_orders->num_rows() > 0) {
            $data["order"] = $order1 = $tb_orders->row();
            $docs_data = [];
            $docs_data["order_id"] = $order1->id;
            $docs_data_records = $this->db->get_where("tb_docs_data", $docs_data, 1, 0);
            if ($docs_data_records->num_rows() > 0) {
                $docs_data["metadata"] = json_encode($data);
                $docid = $docs_data_records->row()->id;
                $upd = $this->db->where(["id" => $docid])->update("tb_docs_data", $docs_data);
            } else {
                $docs_data["metadata"] = json_encode($data);
                $docs_data["document_type"] = "1";
                $ins = $this->db->insert("tb_docs_data", $docs_data);
            }
            $getBranchAddress = $this->getBranchAddress();
            $data["branch_details"]['branch_address'] = $getBranchAddress['branch_address'];
            $data["branch_details"]['branch_gst'] = $getBranchAddress['branch_gst'];
            $file_name = "LRReport" . $order1->order_id . "_" . date("YmdHis");
            $file_path = "./assets/lr_orders/" . $file_name;
            $pdf_path = $file_path . ".pdf";
            /*$this->load->library('m_pdf');*/
            $data["qr"] = $this->db->query("SELECT qr.path FROM tb_order_cargodetails cd,tb_order_cargo_qrdetails qr WHERE cd.order_id='$order_id' AND qr.order_cargo_details_id = cd.id AND cd.status=1 AND qr.status=1");
            $html = $this->load->view("lr_report_print", $data, true);
            /*$this->m_pdf->pdf->AddPage*/
            $pdf->AddPage(
                'L', // L - landscape, P - portrait
                '',
                '',
                '',
                '',
                8, // margin_left
                8, // margin right
                8, // margin top
                8, // margin bottom
                8, // margin header
                8
            );
            $pdf->WriteHTML(
                preg_replace([ '/<script.*<\/script>/smU', '/<.link rel.*>/'], '', $html)
            );
            $pdf->Output($pdf_path, 'F');
            echo json_encode(["status" => "1", "url" => base_url("lrgenerate/printInvoice/" . $order_id)]);
        }
    }

    public function saveAllInvoice($data, $i)
    {
        $pdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH . 'assets/tmp'
        ]);
        $order_id = $data["order_id"];
        $chk = 0;
        $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE id='" . $order_id . "'");
        if ($tb_orders->num_rows() > 0) {
            $chk = 1;
            $data["order"] = $order1 = $tb_orders->row();
        } else {
            $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE order_id='" . $order_id . "'");
            if ($tb_orders->num_rows() > 0) {
                $chk = 1;
                $data["order"] = $order1 = $tb_orders->row();
            }
        }
        if ($chk == 1) {
            $metadata = $data;
            $data["order"] = $order1 = $tb_orders->row();
            $data["doc_data"] = (object)$metadata;
            $file_name = "LRReport" . $order1->order_id . "_" . $i . "_" . date("YmdHis");
            if (!file_exists('./assets/lr_orders/lr_all_pdfs')) {
                mkdir('./assets/lr_orders/lr_all_pdfs', 0710, true);
            }
            $file_path = "./assets/lr_orders/lr_all_pdfs/" . $file_name;
            $pdf_path = $file_path . ".pdf";
            $user_id = $this->session->userdata("user_id");
            $getBranchAddress = $this->getBranchAddress();
            $data["branch_details"]['branch_address'] = $getBranchAddress['branch_address'];
            $data["branch_details"]['branch_gst'] = $getBranchAddress['branch_gst'];
            $data['download'] = 1;
            $data["user"] = @$this->db->query("SELECT name,domain_name,head_office,gstin FROM tb_users WHERE id='$user_id'")->row();
            $data["qr"] = $this->db->query("SELECT qr.path FROM tb_order_cargodetails cd,tb_order_cargo_qrdetails qr WHERE cd.order_id='$order_id' AND qr.order_cargo_details_id = cd.id AND cd.status=1 AND qr.status=1");
            $html = $this->load->view("lr_report_print", $data, true);
            $pdf->AddPage(
                'L', // L - landscape, P - portrait
                '',
                '',
                '',
                '',
                8, // margin_left
                8, // margin right
                8, // margin top
                8, // margin bottom
                8, // margin header
                8
            );
            $pdf->WriteHTML(
                preg_replace([ '/<script.*<\/script>/smU', '/<.link rel.*>/'], '', $html)
            );
            $pdf->Output($pdf_path, 'F');
            $this->zip->read_file($pdf_path);
        }
    }

    public function multiplepdfs($data)
    {
        $pdfs = ["OFFICE COPY", "CONSIGNOR COPY", "CONSIGNEE COPY", "TRANSPORTER COPY", "P.O.D COPY"];
        $i = 0;
        foreach ($pdfs as $val) {
            $i++;
            $data['document_copy_type'] = $val;
            $this->saveAllInvoice($data, $i);
        }
        $del = $this->filedel();
        $this->zip->download('invoicepdf.zip');
    }

    public function filedel()
    {
        $deletepath = "./assets/lr_orders/lr_all_pdfs/";
        $this->load->helper("file");
        delete_files($deletepath, true);
        return true;
    }

    public function download($order_id = "")
    {
        $docs_data = $data = [];
        $docs_data["order_id"] = $order_id;
        $doc_type = "";
        $docs_data_records = $this->db->get_where("tb_docs_data", $docs_data, 1, 0);
        if ($docs_data_records->num_rows() > 0) {
            $metdata = $docs_data_records->row()->metadata;
            $data = json_decode($metdata, true);
            $doc_type = isset($data["document_copy_type"]) ?? "";
        }
        if ($doc_type == "ALL") {
            $data['order_id'] = $order_id;
            $this->multiplepdfs($data);
        } else {
            if ($order_id != "") {
                $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE id='" . $order_id . "'");
            } else {
                $order = $data["order_id"];
                $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE order_id='" . $order . "'");
            }
            if ($tb_orders->num_rows() > 0) {
                $data['order'] = $order1 = $tb_orders->row();
                $docs_data = [];
                $docs_data["order_id"] = $order_id = $order1->id;
                $docs_data_records = $this->db->where($docs_data)->get("tb_docs_data");
                if ($docs_data_records->num_rows() > 0) {
                    $docs_data["metadata"] = json_encode($data);
                    $oid = $docs_data_records->row()->id;
                    $upd = $this->db->where(["id" => $oid])->update("tb_docs_data", $docs_data);
                } else {
                    $docs_data["metadata"] = json_encode($data);
                    $docs_data["document_type"] = "1";
                    $ins = $this->db->insert("tb_docs_data", $docs_data);
                }
                $file_name = "LRReport" . $order1->order_id . "_" . date("YmdHis");
                $user_id = $this->session->userdata("user_id");
                $data["user"] = @$this->db->query("SELECT name,domain_name,head_office,gstin FROM tb_users WHERE id='$user_id'")->row();
                $data["qr"] = $this->db->query("SELECT qr.path FROM tb_order_cargodetails cd,tb_order_cargo_qrdetails qr WHERE cd.order_id='$order_id' AND qr.order_cargo_details_id = cd.id AND cd.status='1' AND qr.status='1'");
                $data["doc_data"] = json_decode($metdata);
                $data['download'] = 1;
                $getBranchAddress = $this->getBranchAddress();
                $data["branch_details"]['branch_address'] = $getBranchAddress['branch_address'];
                $data["branch_details"]['branch_gst'] = $getBranchAddress['branch_gst'];
                $this->load->library('m_pdf');
                $html = $this->load->view("lr_report_print", $data, true);
                $this->m_pdf->pdf->AddPage(
                    'L', // L - landscape, P - portrait
                    '',
                    '',
                    '',
                    '',
                    8, // margin_left
                    8, // margin right
                    8, // margin top
                    8, // margin bottom
                    8, // margin header
                    8
                );
                $this->m_pdf->pdf->WriteHTML(
                    preg_replace([ '/<script.*<\/script>/smU', '/<.link rel.*>/'], '', $html)
                );
                $this->m_pdf->pdf->SetTitle($file_name . ".pdf");
                $this->m_pdf->pdf->Output();
            }
        }
    }

    public function printInvoice($order_id = "")
    {
        $docs_data = [];
        if ($order_id != "") {
            $docs_data["order_id"] = $order_id;
            $docs_data_records = $this->db->where($docs_data)->get("tb_docs_data");
            if ($docs_data_records->num_rows() > 0) {
                $metdata = $docs_data_records->row()->metadata;
                $data = json_decode($metdata, true);
                if ($order_id != "") {
                    $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE id='" . $order_id . "' LIMIT 1");
                } else {
                    $order = $data["order_id"];
                    $tb_orders = $this->db->query("SELECT * FROM tb_orders WHERE order_id='" . $order . "' LIMIT 1");
                }
                if ($tb_orders->num_rows() > 0) {
                    $data["order"] = $order1 = $tb_orders->row();
                    $docs_data = [];
                    $docs_data["order_id"] = $order1->id;
                    $docs_data_records = $this->db->where($docs_data)->get("tb_docs_data");
                    if ($docs_data_records->num_rows() > 0) {
                        $docs_data["metadata"] = json_encode($data);
                        $this->db->where("id", $docs_data_records->row()->id)->update("tb_docs_data", $docs_data);
                    } else {
                        $docs_data["metadata"] = json_encode($data);
                        $docs_data["document_type"] = "1";
                        $this->db->insert("tb_docs_data", $docs_data);
                    }
                    $getBranchAddress = $this->getBranchAddress();
                    $data["branch_details"]['branch_address'] = $getBranchAddress['branch_address'];
                    $data["branch_details"]['branch_gst'] = $getBranchAddress['branch_gst'];
                    $file_name = "LRReport" . $order1->order_id . "_" . date("YmdHis");
                    $this->load->library('m_pdf');
                    $data["qr"] = $this->db->query("SELECT qr.path FROM tb_order_cargodetails cd,tb_order_cargo_qrdetails qr WHERE cd.order_id='$order_id' AND qr.order_cargo_details_id = cd.id AND cd.status='1' AND qr.status='1'");
                    $this->load->view('lr_report_print', $data);
                }
            }
        }
    }

    public function savePdfImage($order_id = "")
    {
        $tb_orders = $this->db->query("SELECT shift_id,trip_id FROM tb_orders WHERE id='$order_id'");
        $post = $this->input->post(null, true);
        if ($tb_orders->num_rows() > 0) {
            $order = $tb_orders->row();
            $shift_id = $order->shift_id;
            if ($shift_id != 0) {
                $trip_id = $order->trip_id;
                $image = isset($post['image']) ? $post['image'] : "";
                if ($image != "") {
                    $image_parts = explode("[removed]", $image);
                    $image_base64 = base64_decode($image_parts[1]);
                    $filename = "screenshot_" . uniqid() . '.png';
                    $file = NEW_POD_PATH. $filename;
                    file_put_contents($file, $image_base64);
                    $insert = ["trip_id" => $trip_id, "shipment_id" => $shift_id, "doc_type" => "4"];
                    $q = $this->db->where($insert)->get("tb_pod_uploads");
                    if ($q->num_rows() > 0) {
                        $upd = $this->db->where("id", $q->row()->id)->update("tb_pod_uploads", ["imgpath" => $filename]);
                    } else {
                        $imageSize = filesize($file);
                        $newUuid = $this->uuid->v4();
                        $ins = $this->db->insert("tb_pod_uploads", ["trip_id" => $trip_id, "shipment_id" => $shift_id, "stop_type" => "D", "doc_type" => "4", "imgpath" => $filename, "createdon" => date("Y-m-d H:i:s"),'filesize'=>$imageSize,'hash'=>$newUuid]);
                    }
                }
                echo json_encode(["status" => "1"]);
            } else {
                echo json_encode(["status" => "1"]);
            }
        }
    }

    public function getBranchAddress(): array
    {
        $data = ['branch_address' => '', 'branch_gst' => ''];
        $getBranchAddress = $this->common->gettblrowdata(['branch_code' => $this->session->userdata("branch_code")], '*', 'tb_branch_details', 0, 0);
        if (!empty($getBranchAddress)) {
            $branchAddress = '';
            if ($getBranchAddress['branch_name'] != '') {
                $branchAddress .= $getBranchAddress['branch_name'] . ", " . "<br>";
            }
            if ($getBranchAddress['street'] != '') {
                $branchAddress .= $getBranchAddress['street'] . ", ";
            }
            if ($getBranchAddress['city'] != '') {
                $branchAddress .= $getBranchAddress['city'] . ", ";
            }
            if ($getBranchAddress['state'] != '') {
                $branchAddress .= $getBranchAddress['state'] . ", ";
            }
            if ($getBranchAddress['zipcode'] != '') {
                $branchAddress .= $getBranchAddress['zipcode'];
            }
            $data["branch_details"]['branch_address'] = $branchAddress;
            $data["branch_details"]['branch_gst'] = $getBranchAddress['gst'] ?? '';
            $data = ['branch_address' => $branchAddress, 'branch_gst' => $getBranchAddress['gst'] ?? ''];
        }
        return $data;
    }
}

?>
