<?php if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Macpacexcelimport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
        $this->load->model('aureportsmodel');
        $this->load->model('bpartners');
        $this->load->library('altovaordercreation');
    }

    public function index()
    {
        echo "Upload AU Orders Data";
    }

    public function orderbooking()
    {
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $curtz        = $this->session->userdata("usr_tzone")['timezone'];
        $data         = $error_line         = $message         = $order_details         = [];

        /***********************************
		 *------ Get all master data-------*
		 * ********************************/

        $get_company_codes                   = getCompanyCodes();
        $get_branch_codes                    = getBranchCodes();
        $branches                            = $get_branch_codes['branches'];
        $c_branches                          = $get_branch_codes['c_branch'];
        $cust_ids                            = getCustomerIDs($user_id, $company_code, $branch_code);
        $vendor_company_code                 = "AUKN";
        $vendor_ids                          = getAUVendorIDs($vendor_company_code);
        $data['master']['get_company_codes'] = $get_company_codes;
        $data['master']['get_branch_codes']  = $get_branch_codes;
        $data['master']['cust_ids']          = $cust_ids;
        $data['master']['vendor_ids']        = $vendor_ids;
        $data['master']['company_code']      = $company_code;
        $user_role_id                        = $this->session->userdata('user_role_id');
        $subcustomer_id                      = $this->session->userdata('subcustomer');
        $data['master']['user_role_id']      = $user_role_id;
        $data['master']['subcustomer_id']    = $subcustomer_id;
        //$data['master']['branches']=$branches;
        /**
         * General info  branchs
         */
        $logged_branchcode = [];
        if (! empty($c_branches)) {
            foreach ($c_branches as $res) {
                if ($res['ccode'] == $company_code) {
                    $logged_branchcode[] = $res['bcode'];
                }
            }
        }
        $data['master']['logged_branchcode'] = $logged_branchcode;
        /**
         * General info  porduct
         */
        $productsmaster = getProductMasterData();
        $products       = [];
        if (! empty($productsmaster)) {
            foreach ($productsmaster as $pro) {
                $products[] = trim(strtoupper($pro['name']));
            }
        }
        $data['master']['products'] = $products;
        /**
         * General info  service
         */
        $service       = [];
        $servicemaster = getServiceMasterData();

        if (! empty($servicemaster)) {
            foreach ($servicemaster as $ser) {
                $service[] = trim(strtoupper($ser['name']));
            }
        }
        $data['master']['service'] = $service;
        /**
         * General info mode of transport
         */
        $transport_id  = [];
        $transportmode = gettransportmode();
        if (! empty($transportmode)) {
            foreach ($transportmode as $trans) {
                $transport_id[]   = trim(strtoupper($trans['code']));
                $transport_name[] = trim(strtoupper($trans['name']));
            }
        }

        $transport                   = array_merge($transport_id, $transport_name);
        $data['master']['transport'] = $transport;
        /**
         * General info Department code
         */
        $departments                   = getDepartmentMasterData();
        $data['master']['departments'] = $departments;
        /**
         * General  info Booking Type
         */
        $order_types        = [];
        $custid             = "0";
        $order_types_master = getOrderTypes($custid, $company_code);
        if (! empty($order_types_master)) {
            foreach ($order_types_master as $get_order_type) {
                $order_types[] = trim(strtoupper($get_order_type['type_name']));
            }
        }
        $data['master']['order_types'] = $order_types;
        /* master data completed */

        $all_data = [];

        $data['order_details'] = [];
        if (isset($_FILES['import_file'])) {
            $path            = $_FILES['import_file']['tmp_name'];
            $objPHPExcel     = PHPExcel_IOFactory::load($path);
            $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();

            $data["sheet_data"] = [];
            foreach ($cell_collection as $cell) {
                $column     = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                $row        = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                $newdtat[]  = $column;
                if ($row == 2) {
                    $data["header"][$row][$column] = $data_value;
                } else if ($row > 2) {
                    $data["sheet_data"][$row][$column] = $data_value;
                }
            }
            $row      = 3;
            $row_data = [];
            $sno      = "";
            foreach ($data["sheet_data"] as $value[$row]) {
                $branchcode = isset($value[$row]['G']) ? $value[$row]['G'] : "";
                $dnote      = $row;
                if ($branchcode != "") {
                    $delivery_note = $dnote . $row;
                    if ($sno != $delivery_note) {
                        if ($delivery_note != "") {
                            $sno                = $delivery_note;
                            $value[$row]['row'] = $row;
                            $row_data[$sno][]   = $value[$row];
                            $row++;
                        } else {
                            $value[$row]['row'] = $row;
                            $row_data[$sno][]   = $value[$row];
                            $row++;
                        }
                    } else {
                        $value[$row]['row'] = $row;
                        $row_data[$sno][]   = $value[$row];
                        $row++;
                    }
                }
            }
            $final_data = [];
            if (! empty($row_data)) {
                foreach ($row_data as $row_data_pro) {
                    $final_data[] = $row_data_pro;
                }
            }

            /**
             * Get excel data
             */
            if (! empty($final_data)) {

                for ($i = 0; $i < sizeof($final_data); $i++) {
                    $rowno     = isset($final_data[$i]['0']['row']) ? trim($final_data[$i]['0']['row']) : "";
                    $mainrowno = $rowno;
                    $product   = isset($final_data[$i]['0']['A']) ? trim($final_data[$i]['0']['A']) : "";
                    if ($product == "") {
                        $message[]    = "product empty on line: " . $rowno;
                        $error_line[] = "product" . $rowno;
                    }
                    $service = isset($final_data[$i]['0']['B']) ? trim($final_data[$i]['0']['B']) : "";
                    if ($service == "") {
                        $message[]    = "service empty on line: " . $rowno;
                        $error_line[] = "service" . $rowno;
                    }
                    $order_type = isset($final_data[$i]['0']['C']) ? trim($final_data[$i]['0']['C']) : "";
                    if ($order_type == "") {
                        $message[]    = "Booking Type empty on line: " . $rowno;
                        $error_line[] = "order_type" . $rowno;
                    }
                    $mode_Of_transport = isset($final_data[$i]['0']['D']) ? trim($final_data[$i]['0']['D']) : "";
                    if ($mode_Of_transport == "") {
                        $message[]    = "Mode Of Transport empty on line: " . $rowno;
                        $error_line[] = "mode_Of_transport" . $rowno;
                    }
                    $department_code = isset($final_data[$i]['0']['E']) ? trim($final_data[$i]['0']['E']) : "";
                    if ($department_code == "") {
                        $message[]    = "Department Code empty on line: " . $rowno;
                        $error_line[] = "department_code" . $rowno;
                    }
                    $company_code = isset($final_data[$i]['0']['F']) ? trim($final_data[$i]['0']['F']) : "";
                    if ($company_code == "") {
                        $message[]    = "Company Code empty on line: " . $rowno;
                        $error_line[] = "company_code" . $rowno;
                    }
                    $branch_code = isset($final_data[$i]['0']['G']) ? trim($final_data[$i]['0']['G']) : "";
                    if ($branch_code == "") {
                        $message[]    = "Branch Code empty on line: " . $rowno;
                        $error_line[] = "branch_code" . $rowno;
                    }
                    $customer_id = isset($final_data[$i]['0']['H']) ? trim($final_data[$i]['0']['H']) : "";
                    if ($customer_id == "") {
                        $message[]    = "Customer ID empty on line: " . $rowno;
                        $error_line[] = "customer_id" . $rowno;
                    }
                    $pickup_id = isset($final_data[$i]['0']['I']) ? trim($final_data[$i]['0']['I']) : "";
                    if ($pickup_id == "") {
                        $message[]    = "Pickup ID empty on line: " . $rowno;
                        $error_line[] = "pickup_id" . $rowno;
                    }
                    $pickup_name = isset($final_data[$i]['0']['J']) ? trim($final_data[$i]['0']['J']) : "";
                    if ($pickup_name == "") {
                        $message[]    = "Pickup Name empty on line: " . $rowno;
                        $error_line[] = "pickup_name" . $rowno;
                    }
                    $pickup_street = isset($final_data[$i]['0']['K']) ? trim($final_data[$i]['0']['K']) : "";
                    if ($pickup_street == "") {
                        $message[]    = "Pickup Street empty on line: " . $rowno;
                        $error_line[] = "pickup_street" . $rowno;
                    }
                    $pickup_city = isset($final_data[$i]['0']['L']) ? trim($final_data[$i]['0']['L']) : "";
                    if ($pickup_city == "") {
                        $message[]    = "Pickup City empty on line: " . $rowno;
                        $error_line[] = "pickup_city" . $rowno;
                    }
                    $pickup_state = isset($final_data[$i]['0']['M']) ? trim($final_data[$i]['0']['M']) : "";
                    if ($pickup_state == "") {
                        $message[]    = "Pickup State empty on line: " . $rowno;
                        $error_line[] = "pickup_state" . $rowno;
                    }
                    $pickup_country = isset($final_data[$i]['0']['N']) ? trim($final_data[$i]['0']['N']) : "";
                    if ($pickup_country == "") {
                        $message[]    = "Pickup Country empty on line: " . $rowno;
                        $error_line[] = "pickup_country" . $rowno;
                    }
                    $pickup_zipcode = isset($final_data[$i]['0']['O']) ? trim($final_data[$i]['0']['O']) : "";
                    if ($pickup_zipcode == "") {
                        $message[]    = "Pickup Zipcode empty on line: " . $rowno;
                        $error_line[] = "pickup_zipcode" . $rowno;
                    }
                    $pickup_phone = isset($final_data[$i]['0']['P']) ? trim($final_data[$i]['0']['P']) : "";
                    if ($pickup_phone == "") {
                        $message[]    = "Pickup Phone empty on line: " . $rowno;
                        $error_line[] = "pickup_phone" . $rowno;
                    }
                    $drop_id = isset($final_data[$i]['0']['Q']) ? trim($final_data[$i]['0']['Q']) : "";
                    if ($drop_id == "") {
                        $message[]    = "Drop ID empty on line: " . $rowno;
                        $error_line[] = "drop_id" . $rowno;
                    }
                    $drop_name = isset($final_data[$i]['0']['R']) ? trim($final_data[$i]['0']['R']) : "";
                    if ($drop_name == "") {
                        $message[]    = "Drop Name empty on line: " . $rowno;
                        $error_line[] = "drop_name" . $rowno;
                    }
                    $drop_street = isset($final_data[$i]['0']['S']) ? trim($final_data[$i]['0']['S']) : "";
                    if ($drop_street == "") {
                        $message[]    = "Drop Street empty on line: " . $rowno;
                        $error_line[] = "drop_street" . $rowno;
                    }
                    $drop_city = isset($final_data[$i]['0']['T']) ? trim($final_data[$i]['0']['T']) : "";
                    if ($drop_street == "") {
                        $message[]    = "Drop City empty on line: " . $rowno;
                        $error_line[] = "drop_street" . $rowno;
                    }
                    $drop_state = isset($final_data[$i]['0']['U']) ? trim($final_data[$i]['0']['U']) : "";
                    if ($drop_state == "") {
                        $message[]    = "Drop State empty on line: " . $rowno;
                        $error_line[] = "drop_state" . $rowno;
                    }
                    $drop_country = isset($final_data[$i]['0']['V']) ? trim($final_data[$i]['0']['V']) : "";
                    if ($drop_country == "") {
                        $message[]    = "Drop Country empty on line: " . $rowno;
                        $error_line[] = "drop_country" . $rowno;
                    }
                    $drop_zipcode = isset($final_data[$i]['0']['W']) ? trim($final_data[$i]['0']['W']) : "";
                    if ($drop_zipcode == "") {
                        $message[]    = "Drop Zipcode empty on line: " . $rowno;
                        $error_line[] = "drop_zipcode" . $rowno;
                    }
                    $drop_phone = isset($final_data[$i]['0']['X']) ? trim($final_data[$i]['0']['X']) : "";
                    if ($drop_phone == "") {
                        $message[]    = "Drop Phone empty on line: " . $rowno;
                        $error_line[] = "drop_phone" . $rowno;
                    }
                    $carrier = isset($final_data[$i]['0']['Y']) ? trim($final_data[$i]['0']['Y']) : "";
                    if ($carrier == "") {
                        $message[]    = "Carrier empty on line: " . $rowno;
                        $error_line[] = "carrier" . $rowno;
                    }
                    $purchase_order = isset($final_data[$i]['0']['Z']) ? trim($final_data[$i]['0']['Z']) : "";
                    if ($purchase_order == "") {
                        $message[]    = "Purchase Order empty on line: " . $rowno;
                        $error_line[] = "purchase_order" . $rowno;
                    }
                    $container_number = isset($final_data[$i]['0']['AA']) ? trim($final_data[$i]['0']['AA']) : "";
                    if ($container_number == "") {
                        $message[]    = "Container Number empty on line: " . $rowno;
                        $error_line[] = "container_number" . $rowno;
                    }
                    $cargo_type = isset($final_data[$i]['0']['AB']) ? trim($final_data[$i]['0']['AB']) : "";
                    if ($cargo_type == "") {
                        $message[]    = "Cargo Type empty on line: " . $rowno;
                        $error_line[] = "cargo_type" . $rowno;
                    }
                    $quantity = isset($final_data[$i]['0']['AC']) ? trim($final_data[$i]['0']['AC']) : "";
                    if ($quantity == "") {
                        $message[]    = "Quantity empty on line: " . $rowno;
                        $error_line[] = "quantity" . $rowno;
                    }
                    $palletised = isset($final_data[$i]['0']['AD']) ? trim($final_data[$i]['0']['AD']) : "";
                    if ($palletised == "") {
                        $message[]    = "Palletised empty on line: " . $rowno;
                        $error_line[] = "palletised" . $rowno;
                    }
                    $weight = isset($final_data[$i]['0']['AE']) ? trim($final_data[$i]['0']['AE']) : "";
                    if ($weight == "") {
                        $message[]    = "Weight empty on line: " . $rowno;
                        $error_line[] = "weight" . $rowno;
                    }
                    $volume = isset($final_data[$i]['0']['AF']) ? trim($final_data[$i]['0']['AF']) : "";
                    if ($volume == "") {
                        $message[]    = "Volume empty on line: " . $rowno;
                        $error_line[] = "volume" . $rowno;
                    }
                    $data['order_details'][] = ['rowno' => $mainrowno, 'product' => $product, 'service' => $service, 'order_type' => $order_type, 'transport_mode' => $mode_Of_transport, 'department_code' => $department_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'pickup_id' => $pickup_id, 'pickup_name' => $pickup_name, 'pickup_street' => $pickup_street, 'pickup_city' => $pickup_city, 'pickup_state' => $pickup_state, 'pickup_country' => $pickup_country, 'pickup_pincode' => $pickup_zipcode, 'pickup_phone' => $pickup_phone, 'drop_id' => $drop_id, 'drop_name' => $drop_name, 'drop_street' => $drop_street, 'drop_city' => $drop_city, 'drop_state' => $drop_state, 'drop_country' => $drop_country, 'drop_pincode' => $drop_zipcode, 'drop_phone' => $drop_phone, 'carrier' => $carrier, 'purchase_order' => $purchase_order, 'container_number' => $container_number, 'cargo_type' => $cargo_type, 'quantity' => $quantity, 'palletised' => $palletised, 'weight' => $weight, 'volume' => $volume, 'customer_id' => $customer_id];
                }
            }

        }

        $data['error_line'] = $error_line;
        $data["message"]    = $message;
        $data["page_title"] = "Import Orders";
        $this->settemplate->dashboard("orders/auimport", $data);
    }

    public function insertordersdata()
    {

        $orderslist   = $nobooking_ids   = $excel_forders   = $excel_sorders   = [];
        $cdate        = date('Y-m-d H:i:s');
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $curtz        = $this->session->userdata("usr_tzone")['timezone'];
        $post         = $this->input->post(null, true);
        $childid      = 0;
        if ($this->session->userdata('childid')) {
            $childid = $this->session->userdata('childid');
        }
        if (! empty($post)) {
            if (! empty($post['orders'])) {
                $row_num = 0;
                foreach ($post['orders'] as $row) {
                    $row_num++;

                    $product         = isset($row['product']) ? mb_strtoupper(trim($row['product'])) : "";
                    $service         = isset($row['service']) ? mb_strtoupper(trim($row['service'])) : "";
                    $order_type      = isset($row['order_type']) ? mb_strtoupper(trim($row['order_type'])) : "";
                    $transport_mode  = isset($row['transport_mode']) ? mb_strtoupper(trim($row['transport_mode'])) : "";
                    $department_code = isset($row['department_code']) ? mb_strtoupper(trim($row['department_code'])) : "";

                    $service_name = explode('-', $service);
                    if (! empty($service_name)) {
                        $service = isset($service_name[1]) ? trim($service_name[1]) : "";
                    } else {
                        $service = "";
                    }
                    $product_id        = $this->get_master_ids("tb_products_master", $product, 1);
                    $service_id        = $this->bpartners->getServiceForMDTExcel($service, $company_code, $branch_code);
                    $order_type_id     = $this->get_master_ids("tb_order_types", $order_type, 3);
                    $transport_mode_id = $this->get_master_ids("tb_transportmode", $transport_mode, 5);

                    $company_code     = isset($row['company_code']) ? mb_strtoupper(trim($row['company_code'])) : "";
                    $branch_code      = isset($row['branch_code']) ? mb_strtoupper(trim($row['branch_code'])) : "";
                    $customer_id      = isset($row['customer_id']) ? mb_strtoupper(trim($row['customer_id'])) : "";
                    $pickup_id        = isset($row['pickup_id']) ? mb_strtoupper(trim($row['pickup_id'])) : "";
                    $pickup_name      = isset($row['pickup_name']) ? mb_strtoupper(trim($row['pickup_name'])) : "";
                    $pickup_street    = isset($row['pickup_street']) ? mb_strtoupper(trim($row['pickup_street'])) : "";
                    $pickup_city      = isset($row['pickup_city']) ? mb_strtoupper(trim($row['pickup_city'])) : "";
                    $pickup_state     = isset($row['pickup_state']) ? mb_strtoupper(trim($row['pickup_state'])) : "";
                    $pickup_country   = isset($row['pickup_country']) ? mb_strtoupper(trim($row['pickup_country'])) : "";
                    $pickup_pincode   = isset($row['pickup_pincode']) ? mb_strtoupper(trim($row['pickup_pincode'])) : "";
                    $pickup_phone     = isset($row['pickup_phone']) ? mb_strtoupper(trim($row['pickup_phone'])) : "";
                    $drop_id          = isset($row['drop_id']) ? mb_strtoupper(trim($row['drop_id'])) : "";
                    $drop_name        = isset($row['drop_name']) ? mb_strtoupper(trim($row['drop_name'])) : "";
                    $drop_street      = isset($row['drop_street']) ? mb_strtoupper(trim($row['drop_street'])) : "";
                    $drop_city        = isset($row['drop_city']) ? mb_strtoupper(trim($row['drop_city'])) : "";
                    $drop_state       = isset($row['drop_state']) ? mb_strtoupper(trim($row['drop_state'])) : "";
                    $drop_country     = isset($row['drop_country']) ? mb_strtoupper(trim($row['drop_country'])) : "";
                    $drop_pincode     = isset($row['drop_pincode']) ? mb_strtoupper(trim($row['drop_pincode'])) : "";
                    $drop_phone       = isset($row['drop_phone']) ? mb_strtoupper(trim($row['drop_phone'])) : "";
                    $carrier          = isset($row['carrier']) ? mb_strtoupper(trim($row['carrier'])) : "";
                    $purchase_order   = isset($row['purchase_order']) ? mb_strtoupper(trim($row['purchase_order'])) : "";
                    $container_number = isset($row['container_number']) ? mb_strtoupper(trim($row['container_number'])) : "";
                    $quantity         = isset($row['quantity']) ? mb_strtoupper(trim($row['quantity'])) : "";
                    $cargo_type       = isset($row['cargo_type']) ? mb_strtoupper(trim($row['cargo_type'])) : "";
                    $weight           = isset($row['weight']) ? mb_strtoupper(trim($row['weight'])) : "";
                    $volume           = isset($row['volume']) ? mb_strtoupper(trim($row['volume'])) : "";
                    $palletised       = isset($row['palletised']) ? mb_strtoupper(trim($row['palletised'])) : "";
                    $palletised       = (int) filter_var($palletised, FILTER_SANITIZE_NUMBER_INT);
                    $quantity         = (int) filter_var($quantity, FILTER_SANITIZE_NUMBER_INT);
                    $weight           = (int) filter_var($weight, FILTER_SANITIZE_NUMBER_INT);
                    $customer_row_id  = "";
                    $getuserid        = $this->common->gettblrowdata(['company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 'Active'], "id", "tb_users", 0, 0);
                    if (! empty($getuserid)) {
                        $user_id = $getuserid['id'];
                    }
                    if ($customer_id != "") {

                        $customer_row_id   = $customer_id;
                        $getcustomer_rowid = $this->common->gettblrowdata(['code' => $customer_id, 'company_code' => $company_code, 'status' => '1'], "id", "tb_customers", 0, 0);
                        if (! empty($getcustomer_rowid)) {
                            $customer_row_id = $getcustomer_rowid['id'];
                        }
                        $vendor_id        = 0;
                        $aukncompany_code = "AUKN";
                        if ($carrier != "") {
                            $chkvendor = $this->common->gettblrowdata(['name' => $carrier, 'company_code' => $aukncompany_code, 'status' => '1'], "id", "tb_vendors", 0, 0);
                            if (! empty($chkvendor)) {
                                $vendor_id = $chkvendor['id'];
                            }
                        }
                        $ship_row_id = 0;
                        if ($customer_row_id != "" && ! empty($company_code) && ! empty($branch_code) && ! empty($quantity) && ! empty($weight) && ! empty($volume)) {
                            $shipment_number = $shipid = "SVK" . time();
                            $enddate         = $cdate;
                            $ship_arr        = ['unitspec' => $cargo_type, 'shipid' => $shipid, 'txnid' => $shipment_number, 'trucktype' => '', 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_id, 'carrier' => $vendor_id, 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => '', 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => '', 'modeoftransport' => $transport_mode_id];
                            $chk_shipid      = $this->common->gettblrowdata(['shipid' => $shipid, 'status' => '1'], "id", "tb_shipments", 0, 0);
                            /**
                             * shipments table insert or update
                             */
                            if (! empty($chk_shipid)) {
                                $ship_row_id = $chk_shipid['id'];
                                $up_shipid   = $this->common->updatetbledata("tb_shipments", $ship_arr, ['id' => $ship_row_id]);
                            } else {
                                $ship_arr['createdon'] = $cdate;

                                $ship_row_id = $this->common->insertTableData("tb_shipments", $ship_arr);
                            }
                            if ($ship_row_id == 0) {
                                $nobooking_ids[] = $customer_id . $row_num;
                                $excel_forders[] = ['booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $row_num, 'status' => 'Fail'];
                            } else {
                                $pickup         = ['code' => $pickup_id, 'name' => $pickup_name, 'street' => $pickup_street, 'city' => $pickup_city, 'state' => $pickup_state, 'country' => $pickup_country, 'pincode' => $pickup_pincode, 'phone' => $pickup_phone, 'user_id' => $user_id, 'company_code' => $company_code, 'branch_code' => $branch_code];
                                $shipper_row_id = $this->chkpartymaster($pickup, 'SHIPPER');
                                if ($shipper_row_id == 0) {
                                    $nobooking_ids[] = $customer_id . $row_num;
                                    $excel_forders[] = ['booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $row_num, 'status' => 'Fail'];
                                }
                                $drop        = ['code' => $drop_id, 'name' => $drop_name, 'street' => $drop_street, 'city' => $drop_city, 'state' => $drop_state, 'country' => $drop_country, 'pincode' => $drop_pincode, 'phone' => $drop_phone, 'user_id' => $user_id, 'company_code' => $company_code, 'branch_code' => $branch_code];
                                $drop_row_id = $this->chkpartymaster($drop, 'CONSIGNEE');
                                if ($drop_row_id == 0) {
                                    $nobooking_ids[] = $customer_id . $row_num;
                                    $excel_forders[] = ['booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $row_num, 'status' => 'Fail'];
                                }
                                $loc  = [];
                                $lat1 = $lng1 = $lat2 = $lng2 = "";
                                /*  $add1 = implode(",",[$pickup_street,$pickup_city,$pickup_country,$pickup_pincode]);
							    $add2 = implode(",",[$drop_street,$drop_city,$drop_country,$drop_pincode]);
							    $loc = getlatlngsbyplace($add1);
							    $lat1 = @$loc[0];
							    $lng1 = @$loc[1];
							    $loc = [];
							    $loc = getlatlngsbyplace($add2);
							    $lat2 = @$loc[0];
						    	$lng2 = @$loc[1];  */
                                $order_ins = ['product' => $product, 'transport_mode' => $transport_mode_id, 'modeoftransport' => '0', 'pickup_company' => $pickup_name, 'delivery_company' => $drop_name, 'pickup_country' => $pickup_country, 'delivery_country' => $drop_country, 'pickup_city' => $pickup_city, 'delivery_city' => $drop_city, 'pickup_pincode' => $pickup_pincode, 'delivery_pincode' => $drop_pincode, 'pickup_address1' => $pickup_street, 'delivery_address1' => $drop_street, 'pickup_address2' => $pickup_state, 'delivery_address2' => $drop_state, 'quantity' => $quantity, 'weight' => $weight, 'volume' => $volume, 'user_id' => $user_id, 'sub_uid' => $childid, 'customer_id' => $customer_row_id, 'vendor_id' => $vendor_id, 'plat' => $lat1, 'plng' => $lng1, 'dlat' => $lat2, 'dlng' => $lng2, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => '1', 'is_created' => '1', 'createdon' => $cdate, 'created_source' => '4'];
                                /**
                                 * Order table insertion
                                 */
                                $order_id     = $this->common->insertTableData("tb_orders", $order_ins);
                                $country_code = $this->session->userdata("usr_tzone")['phone_code'];
                                $company_code = $this->session->userdata("company_code");
                                if ($order_id > 0) {
                                    $get_country = $this->common->gettblrowdata(['id' => $user_id], "country_code,company_code", "tb_users", 0, 0);
                                    if (! empty($get_country)) {
                                        $country_code = $get_country['country_code'];
                                        $company_code = $get_country['company_code'];
                                    }
                                    $genord     = ["user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code];
                                    $booking_id = generatebookingid($genord);
                                    /* if (in_array($customer_id . $row_num, $nobooking_ids)) {
									} else {
										$excel_sorders[] = array('booking_id' => $booking_id, 'customer_id' => $customer_id, 'delivery_note' => $booking_id, 'status' => 'Success');
									} */
                                    $upd      = $this->common->updatetbledata("tb_orders", ['order_id' => $booking_id], ['id' => $order_id]);
                                    $invtypes = makeorderinvolvedpartiestype($customer_row_id, $order_id, "CUSTOMER", $user_id, $company_code);
                                    $details  = ['service' => $service_id, 'order_type' => $order_type_id, 'department_code' => $department_code, 'delivery_term' => '0', 'incoterm' => '', 'purchase_order' => '', 'notify_party' => '', 'lane_reference' => '', 'distance' => '', 'temperature_control' => '0', 'valorance_insurance' => '0', 'high_cargo_value' => '0', 'customs_required' => '0', 'order_id' => $booking_id, 'order_row_id' => $order_id, 'createdon' => $cdate, 'shipper_id' => '0', 'consignment_note' => $booking_id, 'num_of_pallets' => $palletised, 'mail_notify' => '0'];
                                    /**
                                     * Order details table insertion
                                     */
                                    $this->common->insertTableData("tb_order_details", $details);

                                    /**
                                     * AU delivery note
                                     */

                                    $this->load->helper('aumacpac_helper');
                                    au_deliverynote_customer_specific($order_id, $booking_id);

                                    $consignment_note = "";
                                    if (in_array($customer_id . $row_num, $nobooking_ids)) {
                                    } else {
                                        $getconnote = $this->common->gettblrowdata(['order_row_id' => $order_id], "consignment_note", "tb_order_details", 0, 0);
                                        if (! empty($getconnote)) {
                                            $consignment_note = $getconnote['consignment_note'];
                                        }
                                        $excel_sorders[] = ['booking_id' => $booking_id, 'customer_id' => $customer_id, 'delivery_note' => $consignment_note, 'status' => 'Success'];
                                    }

                                    $shipper_type_id = $drop_type_id = '1';
                                    $chkpartytype    = $this->common->gettblrowdata(['name' => 'SHIPPER', 'user_id' => $user_id, 'status' => '1'], "id", "tbl_party_types", 0, 0);
                                    if (! empty($chkpartytype)) {
                                        $shipper_type_id = $chkpartytype['id'];
                                    }
                                    $chkpartytype1 = $this->common->gettblrowdata(['name' => 'CONSIGNEE', 'user_id' => $user_id, 'status' => '1'], "id", "tbl_party_types", 0, 0);
                                    if (! empty($chkpartytype1)) {
                                        $drop_type_id = $chkpartytype1['id'];
                                    }
                                    if ($shipper_row_id != 0) {
                                        $order_parties = ['order_id' => $order_id, 'party_id' => $shipper_row_id, 'status' => '1', 'createdon' => $cdate, 'party_type' => $shipper_type_id];
                                        /**
                                         * Order parties table insertion
                                         */
                                        $ins_order_parties  = $this->common->insertTableData("tb_order_parties", $order_parties);
                                        $address            = $pickup_street . "," . $pickup_city . "," . $pickup_state . "," . $pickup_country;
                                        $shipper_address    = ['order_id' => $order_id, 'party_master_id' => $shipper_row_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
                                        $chk_shipperaddress = $this->common->gettblrowdata(['order_id' => $order_id, 'party_master_id' => $shipper_row_id], "id", "tbl_orderparty_address", 0, 0);
                                        if (! empty($chk_shipperaddress)) {
                                            $shipperadd_id = $chk_shipperaddress['id'];
                                            $upd_add       = $this->common->updatetbledata("tbl_orderparty_address", $shipper_address, ['id' => $shipperadd_id]);
                                        } else {
                                            $shipper_address['createdon'] = $cdate;
                                            /**
                                             * Order party address table insertion
                                             */
                                            $shipperadd_id = $this->common->insertTableData("tbl_orderparty_address", $shipper_address);
                                        }
                                    }
                                    if ($drop_row_id != 0) {
                                        $order_parties = ['order_id' => $order_id, 'party_id' => $drop_row_id, 'status' => '1', 'createdon' => $cdate, 'party_type' => $drop_type_id];
                                        /**
                                         * Order parties table insertion
                                         */
                                        $ins_order_parties = $this->common->insertTableData("tb_order_parties", $order_parties);
                                        $daddress          = $drop_street . "," . $drop_city . "," . $drop_state . "," . $drop_country;
                                        $drop_address      = ['order_id' => $order_id, 'party_master_id' => $drop_row_id, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $daddress, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
                                        $chk_dropaddress   = $this->common->gettblrowdata(['order_id' => $order_id, 'party_master_id' => $drop_row_id], "id", "tbl_orderparty_address", 0, 0);
                                        if (! empty($chk_dropaddress)) {
                                            $dropadd_id = $chk_dropaddress['id'];
                                            $upd_add    = $this->common->updatetbledata("tbl_orderparty_address", $drop_address, ['id' => $dropadd_id]);
                                        } else {
                                            $drop_address['createdon'] = $cdate;
                                            /**
                                             * Order party address table insertion
                                             */
                                            $dropadd_id = $this->common->insertTableData("tbl_orderparty_address", $drop_address);
                                        }
                                    }

                                    $length_uom      = $width_uom      = $height_uom      = "M";
                                    $volume_uom      = "CBM";
                                    $weight_uom      = "KG";
                                    $single_quantity = $length = $width = $height = '1';
                                    /**
                                     * Cargo details insert
                                     */
                                    $cargo_details = ['cargo_type' => $cargo_type, 'goods_description' => '', 'quantity' => $quantity, 'length' => $length, 'length_unit' => $length_uom, 'width' => $width, 'width_unit' => $width_uom, 'height' => $height, 'height_unit' => $height_uom, 'weight' => $weight, 'weight_unit' => $weight_uom, 'volume' => $volume, 'volume_unit' => $volume_uom, 'createdby' => $user_id, 'createdon' => $cdate];
                                    $cargo_row_id  = $this->common->insertTableData("tb_cargo_details", $cargo_details);
                                    /**
                                     * Shipunit types insert
                                     */
                                    $gethandling_unit = $this->common->gettblrowdata(['unit_name' => $cargo_type, 'status' => '1'], "id", "tbl_shipunit_types", 0, 0);
                                    $handling_unit    = "";
                                    if (! empty($gethandling_unit)) {
                                        $handling_unit = $gethandling_unit['id'];
                                    } else {
                                        $handlingunit_ar = ['unit_name' => $cargo_type, 'description' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1'];
                                        $handling_unit   = $this->common->insertTableData("tbl_shipunit_types", $handlingunit_ar);
                                    }
                                    /**
                                     * order cagro details insert
                                     */
                                    $length             = $width             = $height             = 0;
                                    $order_cargo        = ['order_id' => $order_id, 'quantity' => $quantity, 'cargo_id' => $cargo_row_id, 'status' => '1', 'createdon' => $cdate, 'cargo_content' => '', 'quantity_type' => $cargo_type, 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'handling_unit' => $handling_unit];
                                    $insert_cargo_order = $this->common->insertTableData("tb_order_cargodetails", $order_cargo);

                                    if ($purchase_order != "") {
                                        $ref_ins = ['reference_id' => 'PO', 'ref_value' => $purchase_order, 'order_id' => $order_id, 'createdon' => $cdate];
                                        $this->common->insertTableData("tb_order_references", $ref_ins);
                                    }
                                    if ($container_number != "") {
                                        $refc_ins = ['reference_id' => 'CTR', 'ref_value' => $container_number, 'order_id' => $order_id, 'createdon' => $cdate];
                                        $this->common->insertTableData("tb_order_references", $refc_ins);
                                    }
                                    try {
                                        $this->altovaordercreation->sendOrderToAltova($order_id);
                                    } catch (Exception $ex) {
                                        log_message("error", "Some Problem occured!, While Sending Order to Altova " . $ex->getMessage());
                                    }
                                } else {
                                    $nobooking_ids[] = $customer_id . $row_num;
                                    $excel_forders[] = ['booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $row_num, 'status' => 'Fail'];
                                }
                            }
                        } else {
                            $nobooking_ids[] = $customer_id . $row_num;
                            $excel_forders[] = ['booking_id' => '-', 'customer_id' => $customer_id, 'delivery_note' => $row_num, 'status' => 'Fail'];
                        }
                    }
                }
            }
        }
        $excel_orders = array_merge($excel_forders, $excel_sorders);
        if (! empty($excel_orders)) {
            @file_put_contents("assets/ordertemplate/excelauuploaddata.txt", json_encode($excel_orders));
        }
        $user_role_id   = $this->session->userdata('user_role_id');
        $subcustomer_id = $this->session->userdata('subcustomer');
        if ($user_role_id == '4') {
            if ($subcustomer_id == '1') {
                redirect('KNSubcustorders/orderslist/01');
            } else {
                redirect('KNCustorders/orderslist/01');
            }
        } else {
            redirect('orders/orderslist/01');
        }
    }

    public function get_master_ids($table, $input, $s_no)
    {
        $id           = 0;
        $user_id      = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $where        = [];
        /**
         * 1 -> products master
         * 2 -> service master
         * 3 -> Booking Type master
         * 4 -> Department master
         * 5 -> Transportmode master
         */
        if ($s_no == 1) {
            $where = "name='$input' AND status=1 AND  (company_code='$company_code' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
        } elseif ($s_no == 2) {
            $service = explode('-', $input);
            if (! empty($service)) {
                $input = isset($service[1]) ? trim($service[1]) : "";
            } else {
                $input = "";
            }
            $where = "name='$input' AND status=1 AND  (company_code='$company_code' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
        } elseif ($s_no == 3) {
            $where = "type_name='$input' AND status=1 AND  (company_code='$company_code' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
        } elseif ($s_no == 4) {
            $where = "department_name='$input' AND status=1 AND  (company_code='$company_code' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
        } elseif ($s_no == 5) {
            $where = "name='$input' AND status=1 AND  (company_code='$company_code' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))";
        }

        if ($s_no == 5) {
            $data = $this->common->gettblrowdata($where, "code", $table, 0, 0);
        } else {
            $data = $this->common->gettblrowdata($where, "id", $table, 0, 0);
        }

        if (! empty($data)) {
            if ($s_no == 5) {
                $id = $data['code'];
            } else {
                $id = $data['id'];
            }
        }
        return $id;
    }

    private function chkpartymaster($info, $type)
    {
        $party_type_id = 1;
        $ins_id        = 0;
        $company_code  = $this->session->userdata('company_code');
        if (! empty($info)) {
            $code         = $info['code'];
            $user_id      = $info['user_id'];
            $chkpartytype = $this->common->gettblrowdata(['name' => $type, 'company_code' => $company_code, 'status' => '1'], "id", "tbl_party_types", 0, 0);
            if (! empty($chkpartytype)) {
                $party_type_id = $chkpartytype['id'];
            }
            $address = $info['street'] . "," . $info['city'] . "," . $info['state'] . "," . $info['country'];
            $ins     = ['party_type_id' => $party_type_id, 'name' => $info['name'], 'mobile' => $info['phone'], 'company_code' => $company_code, 'company_code' => $info['company_code'], 'branch_code' => $info['branch_code'], 'location_id' => $info['city'], 'address' => $address, 'country' => $info['country'], 'state' => $info['state'], 'street' => $info['street'], 'pincode' => $info['pincode'], 'status' => '1'];
            if ($code == "") {
                $chkaddress = $this->common->gettblrowdata(['name' => $info['name'], 'location_id' => $info['city'], 'country' => $info['country'], 'state' => $info['state'], 'street' => $info['street'], 'pincode' => $info['pincode'], 'company_code' => $company_code, 'status' => '1'], "id", "tbl_party_master", 0, 0);
                if (! empty($chkaddress)) {
                    $ins_id = $chkaddress['id'];
                } else {
                    $ins_id       = $this->common->insertTableData("tbl_party_master", $ins);
                    $country_code = $this->session->userdata("usr_tzone")['phone_code'];
                    $year         = date('y');
                    $week         = date('W');
                    $code         = $country_code . $year . $week . $ins_id;
                    $this->common->updatetbledata("tbl_party_master", ['code' => $code], ['id' => $ins_id]);
                }
            } else {
                $ins['code'] = $code;
                $chkcode     = $this->common->gettblrowdata(['code' => $code, 'company_code' => $company_code, 'status' => '1'], "id", "tbl_party_master", 0, 0);
                if (empty($chkcode)) {
                    $chkaddress = $this->common->gettblrowdata(['name' => $info['name'], 'location_id' => $info['city'], 'country' => $info['country'], 'state' => $info['state'], 'street' => $info['street'], 'pincode' => $info['pincode'], 'company_code' => $company_code, 'status' => '1'], "id", "tbl_party_master", 0, 0);
                    if (! empty($chkaddress)) {
                        $ins_id = $chkaddress['id'];
                    } else {
                        $ins_id = $this->common->insertTableData("tbl_party_master", $ins);
                    }
                } else {
                    $ins_id = $chkcode['id'];
                }
            }
        }
        return $ins_id;
    }
}
