<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MailReciever extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('apis/FlipkartEDIServices');
        $this->load->model('Order');
    }


    public function index()
    {
        $this->MailReader();
    }

    public function MailReader()
    {
        $hostname = '{imap.gmail.com:993/imap/ssl}INBOX';
        $username = 'svkonekt5@gmail.com';
        $password = 'tnpx crby kuvy yoky';
        $x = 0;
        while ($x == 0) {
            //log_message('error', 'send mail:' . $x);
            $inbox = imap_open($hostname, $username, $password) or die('Cannot connect to mailbox: ' . imap_last_error());
            echo "✅ Connected successfully!";
            $emails = imap_search($inbox, 'UNSEEN');
            //log_message('error', 'all mails:' . json_encode($emails));
            if ($emails) {
                foreach ($emails as $email_number) {
                    $overview = imap_fetch_overview($inbox, $email_number, 0);
                    $subject = $overview[0]->subject ?? '';
                    
                    $from = $overview[0]->from ?? '';
                    preg_match('/<(.+)>/', $from, $matches);
                    $from_email = $matches[1] ?? $from;
                    // CC
                    $cc_emails = [];
                    $rawHeader = imap_fetchheader($inbox, $email_number);
                    $header = imap_rfc822_parse_headers($rawHeader);
                    if (!empty($header->cc)) {
                        foreach ($header->cc as $cc) {
                            $cc_emails[] = $cc->mailbox . '@' . $cc->host;
                        }
                    }
                    
                    $decodedParts = imap_mime_header_decode($subject);
                    $subject = '';
                    foreach ($decodedParts as $part) {
                        $subject .= $part->text;
                    }


                    //log_message('error', 'subject: ' . $subject);
                    $message = imap_fetchbody($inbox, $email_number, 1.1);
                    if (preg_match('/(\w+):(\w+):(\w+)/', $subject, $matches)) {
                        $orderId = $matches[1];
                        $customerCode = $matches[2];
                        $statusCode = $matches[3];

                        $xmldata = $this->buildXML($orderId, $customerCode, $statusCode);
                        //log_message('error', 'xml:' . print_r($xmldata, true));
                        if ($xmldata === false) {
                            echo "Invalid request,Please try again!";
                        } else {
                            $header       = $xmldata->xpath('SVKEDITransmissionHeader');
                            $orderIdNodes = $xmldata->xpath('SVKEDITransmissionBody/Order/OrderID');
                            $orderId      = isset($orderIdNodes[0]) ? (string) $orderIdNodes[0] : null;
                            $sourceApp    = isset($header[0]->SourceApp) ? (string) ($header[0]->SourceApp) : "";
                            $response     = [];
                            $orderDetails = $this->Order->getOrderDetails($orderId);
                            //log_message('error', 'order details:' . print_r($orderDetails, true));
                            if ($orderDetails && isset($orderDetails->id)) {
                                $order_id = $orderDetails->order_id;
                                $external_order_id = $orderDetails->external_order_id;
                                $id = (int)$orderDetails->id;
                                //log_message('error', 'data is goining xmldata:' . print_r($xmldata, true));
                                /*$this->flipkartediservices->getStatus($xmldata, $id, $sourceApp);*/
                                $this->flipkartediservices->getStatus($xmldata, $id, $sourceApp, $from_email, $cc_emails, $statusCode);
                            } else {
                                //log_message("error", "Order not found for ID: " . $orderId);
                            }
                            // $resp = sendToApi($xmlData, $apiUrl);
                        }
                    }
                    imap_setflag_full($inbox, $email_number, "\\Seen");
                }
                imap_close($inbox);
            }
            $x = 1;
        }
    }

    public function buildXML($orderId, $customerCode, $statusCode)
    {
        date_default_timezone_set('Asia/Kolkata');
        $dateTime = date('c');

        $xml = new SimpleXMLElement('<SVKEDIResponseMessage/>');

        // Transmission Header
        $header = $xml->addChild('SVKEDITransmissionHeader');
        $header->addChild('EDIVersion', 'SVK2.0');
        $ackSpec = $header->addChild('AckSpec');
        $ackSpec->addChild('AckOption', 'SUCCESS');
        $header->addChild('SourceApp', 'COLLINS');
        $header->addChild('DestinationApp', 'SVKONEKT');
        $header->addChild('ClientIdentifier', $customerCode);
        $header->addChild('CarrierIdentifier', 'TCI CARRIER ID');
        $header->addChild('Action', 'Status');

        // Transmission Body
        $body = $xml->addChild('SVKEDITransmissionBody');
        $order = $body->addChild('Order');
        $order->addChild('OrderID', $orderId);

        // Transmission Status
        $status1 = $order->addChild('Status');
        $status1->addChild('StatusCode', $statusCode);
        $status1->addChild('StatusValue', 'CPP CLEARANCE');
        $status1->addChild('StatusType', $statusCode);
        $status1->addChild('DateTime', $dateTime);
        $status1->addChild('TimeZone', '+00:00');
        $status1->addChild('Lat', '');
        $status1->addChild('Lng', '');
        $status1->addChild('Location', '');

        return $xml;
    }
}
