<?php

if(!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Map extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_id')) {
			redirect('login');
		}
	}

	public function trip($id=null)
    {
		if($id!=null){
			$data["emps"]=$this->db->query(
                "SELECT e.name,e.plat,e.plng,e.ship_type,e.stop_order,e.pickup,e.`drop`,t.trip_type,te.check_in
                        FROM tb_trips t,tb_trip_employee te,tb_employee e
                        WHERE t.id= ? and te.trip_id=t.id and e.id=te.employee_id and te.check_in is not NULL
                        ORDER BY te.id ASC",
                [ $id ]
            );
			$data["pod"]=$this->db
                ->where(["trip_id"=>$id])
                ->get("tb_pod_uploads");
			$data["status"]=$this->db->query(
                "SELECT ss.id,ss.stop_id,ss.status_id,sm.status_name,ss.createdon
                        FROM `tb_stop_status` ss JOIN tb_status_master sm ON sm.id=ss.status_id
                        WHERE ss.trip_id= ?
                        order by ss.stop_id",
                [ $id ]
            );
			$address=$this->db
                ->where("id",$this->session->userdata("user_id"))
                ->where("status","Active")
                ->get("tb_users")
                ->row()->address;

            $geo = getlatlngsbyplace($address);
			$data["company"]=array($address,$geo[0],$geo[1]);
			$this->load->view("map/trip",$data);

		}
	}
}
