<?php defined('BASEPATH') OR exit('No direct script access allowed');
header('Content-Type: application/json');
class Mycontroller extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if (isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400');    // cache for 1 day
    	}
    // Access-Control headers are received during OPTIONS requests
    	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
            header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

        }

		// decoding the json array
	    $post = json_decode(file_get_contents("php://input"), true);

		//Codiginite helpers
		$this->load->helper('date');

		//Load data base model
		//$this->load->model('Android_model', 'adb', TRUE);
	}

	public function index()
	{
		//$this->load->view('welcome_message');
		echo "Welcome to Track247 Android services";
		//echo "getServices<br>";
		$data['user'] = "";
	}

	/*===============*/
	/*==============Receiving Requestes from Android Devices===========*/
	/*================================*/

	public function sendnotfication($phonenum,$msg){
		$params = array('wk' => '115948kz7517216zm1sl', 'apiurl' => 'alerts.sinfini.com/api/','sd'=>'RTRUCK');
		$this->load->library('sendsms', $params);
		$this->sendsms->send_sms($phonenum, $msg, "https://elog360.app/svkonekt_test", "xml");
	}

	public function setintrest($mid,$type){
		$this->db = $this->load->database('default', TRUE);
		if($type == 1)
		  $q = $this->db->query("update tb_user_notifications set bintrest='1' where id='$mid'");
		else
		  $q = $this->db->query("update tb_user_notifications set bdeleted='1' where id='$mid'");

		echo $this->db->affected_rows();
	}

    public function dologin($mobilenum,$pwd){

		$passwd = $pwd;
        $pwd = $this->passwordEncrypt($pwd);
		$result = $this->db->query("select id,name,emailid,gcm_id,address from tb_users where mobile_no='$mobilenum' and password='$pwd'");
        if($result->num_rows() > 0){

            foreach ($result->result() as $row)
            {
				$res = array("Response"=>array("Userid"=>$row->id,"name"=>$row->name,"emailid"=>$row->emailid,"gcmid"=>$row->gcm_id,"address"=>$row->address,"Login"=>"Success","empid"=>0));

				echo json_encode($res);
            }

        }
        else
		{

			$empres = $this->db->query("SELECT * FROM tb_employee where phone='$mobilenum' and password='$passwd'");
			if($empres->num_rows > 0){
				foreach ($empres->result() as $row){
					$res = array("Response"=>array("Userid"=>$row->user_id,"name"=>$row->name,"emailid"=>$row->emailid,"gcmid"=>$row->gcm_id,"address"=>$row->address,"Login"=>"Success","empid"=>$row->id));
					echo json_encode($res);
				}
			}
			else{
				$res = array("Response"=>array("Userid"=>0,"Login"=>"Failed"));
				echo json_encode($res);
			}

        }
    }

	function getregister_number($imei)
	{
		$sql="select register_number from tb_trucks_data where imei='".$imei."'";
		$query=$this->db->query($sql);
		if($query->num_rows()>0)
		{
			return $register_number=$query->row()->register_number;
		}
	}

	public function gettrucknum($imei)
	{
		$trucknum = "";
		$trucksobj = $this->getroutesRET();
		foreach($trucksobj as $truck)
		{
			if($truck->imei == $imei)
			{
			    $trucknum = $truck->register_number;
				break;
			}
		}
		return $trucknum;
	}
	function getroutesRET()
	{

		/*$imei = $this->session->userdata('trucks');
		echo json_encode($imei);*/
		$user_id = $this->session->userdata('user_id');
		$trucks = $this->db->query("select register_number,imei from tb_trucks_data where gpsstatus = 1 and user_id = ".$user_id);

		foreach($trucks->result() as $row)
		{
			$imei[] = $row;
		}
		$this->load->database('default',TRUE);
		return $imei;
	}

    function getLocationName($lat,$lng)
    {
		return getLocationName($lat, $lng);
    }

	function getdatafromlocaldb($lat,$lng)
	{
	   $qry=$this->db->query("select name1 from tb_location_data where (((3959 * acos(cos(radians(".$lat.")) * cos(radians(lat)) * cos(radians(lng) - radians(".$lng.")) + sin(radians(".$lat.")) * sin(radians(lat)))))) < 0.30");

		if($qry->num_rows()>0)
		{
			return $qry->row()->name1;
		}
		else
			return '';
 	}

    public function secondsToTime($seconds)
    {
        // extract hours
        $hours = floor($seconds / (60 * 60));

        // extract minutes
        $divisor_for_minutes = $seconds % (60 * 60);
        $minutes = floor($divisor_for_minutes / 60);

        // extract the remaining seconds
        $divisor_for_seconds = $divisor_for_minutes % 60;
        $seconds = ceil($divisor_for_seconds);

        // return the final array
        $obj = array(
            "h" => (int) $hours,
            "m" => (int) $minutes,
            "s" => (int) $seconds,
        );
        return $obj;
    }

    function distance($lat1, $lon1, $lat2, $lon2, $unit) {

        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);

        if ($unit == "K") {
            return ($miles * 1.609344);
        } else if ($unit == "N") {
            return ($miles * 0.8684);
        } else {
            return $miles;
        }
    }

    function calculateDistance($latitude1, $longitude1, $latitude2, $longitude2)
    {
        $theta = $longitude1 - $longitude2;
        //echo "theta = ".$theta."<br>";
        $miles = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2))) + (cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
        if($miles<=1 && $miles>=-1){
            $miles = acos($miles);
            $miles = rad2deg($miles);
            $kmts = $miles * 60 * 1.1515 * 1.609344;
        }else{$kmts = 0; }
        return $kmts;
    }

    public function checkAuthorKey($authkey){
	    return ($authkey == MYCONTROLLER_AUTH_KEY);
    }

    function passwordEncrypt($str)
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }

	function send_user($imei)
	{
		$gcm_id=array();
		$sql="select gcm_id from tb_users,tb_trucks_data where tb_users.id=tb_trucks_data.user_id and imei=".$imei;
		$query=$this->db->query($sql);
		//echo $sql."\n\n";
		$gcm_id=$query->row()->gcm_id;

		return $gcm_id;

	}
	function push_alert($registatoin_id,$message)
	{
		$registatoin_ids = array();

		array_push($registatoin_ids, $registatoin_id);
		$messages = array("notificationresponse"=>$message);
		/*$registration and $message must send as arrays to GCM*/
		$this->load->library('trackgcm');
		$result = $this->trackgcm->send_notification($registatoin_ids,$messages);
		echo json_encode($result);
	}
	/*
	 * This getGoogleShortenerUrl will help to get the shorturl from the Google Shortener Server
	 * @params long Url
	 * */
	function getGoogleShortenerUrl($url, $reqFor)
	{
		$this->load->library('googleshortener');
		if($reqFor == "short"){
			$googleresponce = $this->googleshortener->shorten($url, false);
		}else if($reqFor == "long"){
			$googleresponce = $this->googleshortener->expand($url, false);
		}else{
			$googleresponce = "";
		}
		return $googleresponce;
	}

	function sendempvehalerts($emp_id='',$imei='',$lat='',$lng='',$distance='')
		{
		$gsmsend  = array();
		/*$emp_id=63;
		$imei='0359710049382212';
		$lat='17.799188';
		$lng='83.353047';
		$distance=5;8*/
		$sid = 0;
		$main_gcm='';
		$sql="SELECT distinct c.name,c.address,c.phone, c.id,c.gcm_id,e.register_number,f.gcm_id as supergcm,f.id as user_id,f.company_indv_name FROM `tb_sch_emp` a,tb_veh_sch b,tb_employee c,tb_trucks_data e,tb_users f where
		b.sch_id= a.sch_id and c.id=a.emp_id and b.truck='$imei' and  e.imei=b.truck and f.id=e.user_id and  c.id=$emp_id and a.status=1 and b.status=1";
		$query=$this->db->query($sql);
		if($query->num_rows()>0)
		{
			foreach($query->result() as $row)
			{
				$phoneno=$row->phone;
				$emp_gcm=$row->gcm_id;
				$main_gcm=$row->supergcm;
				$emp_name=$row->name;
				$reg_number=$row->register_number;
				if($emp_gcm!='')
				{
					$r['snid']=1;//Server notification id/Auto increment value
					$r['alert_type_id']="0";
					$r['alert_type']="info";
					$r['userid']=$emp_id;
					$r['lat'] = $lat;
					$r['lng'] = $lng;
					$r['imei']=$imei;
					$r['location']=$location=$this->getLocationName($lat,$lng);
					$r['receivedon'] =date('Y-m-d h:i:s a ');
					$r['register_number']=$reg_number;
					$r['speed'] = 0;
					$r['course'] = 0;
					$r['distance']=0;
					$gsmsend=$emp_gcm;
					$mainusergcm=$main_gcm;
					//$this->send_user($imei);
					//$msg="Dear  ".$emp_name." Your Vehicle ".$reg_number." at ".$location." on ".$c_date." \n";
					$distance=$distance*10;
					$msg="Hello ".$row->name."<br> Your Vehcile ".$reg_number." is ".$distance." mts from  your place, Current Location:".$location;
					$r['alert_message']=$msg;
					$json_data = array("locationresponse"=>$r);

					$insert_Array=array('alert_type'=>$r['alert_type_id'],'message'=>$r['alert_message'],'lat'=>$r['lat'],'lng'=>$r['lng'],'speed'=>$r['speed'],'location'=>$r['location'],'receiveddate'=>$r['receivedon'],'imei'=>$r['imei'],'distance'=>$r['distance'],'emp_id'=>$emp_id);
					//print_r($json_data);
				//print_r($insert_Array);
				//print_r($json_data);

				//$this->db->insert("tb_alerts",$insert_Array);
				//$this->push_alert($gsmsend,$json_data);
				}

			}

			//For main user
				//print_r($json_data);

					/*$r['snid']=1;//Server notification id/Auto increment value
					$r['alert_type_id']="1";
					$r['alert_type']="info";
					$r['userid']=$query->row()->user_id;
					$r['lat'] = $lat;
					$r['lng'] = $lng;
					$r['imei']=$imei;
					$r['location']=$location=$this->getLocationName($lat,$lng);
					$r['receivedon'] =date('Y-m-d h:i:s a ');
					$r['register_number']=$query->row()->register_number;
					$r['speed'] = 0;
					$r['course'] = 0;
					$r['distance']=0;
					//echo $this->getLocationName($lat,$lng);
					$gsmsend=$query->row()->supergcm;
					if($gsmsend!='')
					{

						$msg="Your Cab is ".$distance." mts from  your place ";//"Dear  ".$query->row()->company_indv_name." Your//

						$r['alert_message']=$msg;
						$json_data = array("locationresponse"=>$r);

						$insert_Array=array('alert_type'=>$r['alert_type'],'message'=>$r['alert_message'],'lat'=>$r['lat'],'lng'=>$r['lng'],'speed'=>$r['speed'],'location'=>$r['location'],'receiveddate'=>$r['receivedon'],'imei'=>$r['imei'],'distance'=>$r['distance'],'emp_id'=>$r['userid']);
						$this->db->insert("tb_alerts",$insert_Array);
						$this->push_alert($gsmsend,$json_data);
					//print_r($json_data);
					//print_r($gsmsend);
					}*/
				//end
	}
	}

	function getvehiclealerts($imei,$lat,$lng)
	{

		$gsmsend  = array();
		$sid = 0;
		$imei=isset($_REQUEST['imei']) ?? $imei;
		$lat=isset($_REQUEST['lat']) ?? $lat;
		$lng=isset($_REQUEST['lng']) ?? $lng;
		$c_date=date('d-m-Y H:i:s');
		$main_gcm='';
		$sql="SELECT distinct c.name,c.address,c.phone, c.id,c.gcm_id,e.register_number,f.gcm_id as supergcm,f.id as user_id,f.company_indv_name FROM `tb_sch_emp` a,tb_veh_sch b,tb_employee c,tb_trucks_data e,tb_users f where
	b.sch_id= a.sch_id and c.id=a.emp_id and b.truck='$imei' and  e.imei=b.truck and f.id=e.user_id and a.status=1 and b.status=1";
	$query=$this->db->query($sql);
	if($query->num_rows()>0)
	{
		foreach($query->result() as $row)
		{
			$phoneno=$row->phone;
			$emp_gcm=$row->gcm_id;
			$main_gcm=$row->supergcm;
			$emp_name=$row->name;
			$reg_number=$row->register_number;
			if($emp_gcm!='')
			{
				$r['snid']=1;//Server notification id/Auto increment value
				$r['alert_type_id']="1";
				$r['alert_type']="info";
				$r['userid']=$row->user_id;
				$r['lat'] = $lat;
				$r['lng'] = $lng;
				$r['imei']=$imei;
				$r['location']=$location=$this->getLocationName($lat,$lng);
				$r['receivedon'] =date('Y-m-d h:i:s a ');
				$r['register_number']=$reg_number;
				$r['speed'] = 0;
				$r['course'] = 0;
				$r['distance']=0;
				$gsmsend=$emp_gcm;
				$mainusergcm=$main_gcm;
				//$this->send_user($imei);
				//$msg="Dear  ".$emp_name." Your Vehicle ".$reg_number." at ".$location." on ".$c_date." \n";
				$msg="Vehicle ".$reg_number." at ".$location." \n";
				$r['alert_message']=$msg;
				$json_data = array("locationresponse"=>$r);

				$insert_Array=array('alert_type'=>$r['alert_type'],'message'=>$r['alert_message'],'lat'=>$r['lat'],'lng'=>$r['lng'],'speed'=>$r['speed'],'location'=>$r['location'],'receiveddate'=>$r['receivedon'],'imei'=>$r['imei'],'distance'=>$r['distance']);
				//print_r($json_data);
			//$this->db->insert("tb_alerts",$insert_Array);
			//$this->push_alert($gsmsend,$json_data);
			}

		}

		//For main user

			$r['snid']=1;
				$r['alert_type_id']="1";
				$r['alert_type']="info";
				$r['userid']=$query->row()->user_id;
				$r['lat'] = $lat;
				$r['lng'] = $lng;
				$r['imei']=$imei;
				$r['location']=$location=$this->getLocationName($lat,$lng);
				$r['receivedon'] =date('Y-m-d h:i:s a ');
				$r['register_number']=$query->row()->register_number;
				$r['speed'] = 0;
				$r['course'] = 0;
				$r['distance']=0;
				//echo $this->getLocationName($lat,$lng);
				$gsmsend=$query->row()->supergcm;
				if($gsmsend!='')
				{

					$msg="Vehicle ".$reg_number." at ".$location." \n";
					$r['alert_message']=$msg;
					$json_data = array("locationresponse"=>$r);

					$insert_Array=array('alert_type'=>$r['alert_type'],'message'=>$r['alert_message'],'lat'=>$r['lat'],'lng'=>$r['lng'],'speed'=>$r['speed'],'location'=>$r['location'],'receiveddate'=>$r['receivedon'],'imei'=>$r['imei'],'distance'=>$r['distance']);
					//$this->db->insert("tb_alerts",$insert_Array);
					//$this->push_alert($gsmsend,$json_data);
				print_r($json_data);
				}
			//end
		}
	}

	function jsonRemoveUnicodeSequences($struct) {
	   return preg_replace("/\\\\u([a-f0-9]{4})/e", "", json_encode($struct),JSON_PRETTY_PRINT);
	   //iconv('UCS-4LE','UTF-16',pack('V', hexdec('U$1')))
	}

	public function locate()
	{
		$imei=$_REQUEST['imei'];
		//echo $imei."error";
		$truckid=isset($_REQUEST['truckid'])?$_REQUEST['truckid']:$truckid=0;
		$sql="select lat,lng,receivedon from tb_gps_devices where imei='".$imei."' order by id desc limit 0,1 ";
		$query=$this->db->query($sql);
		$data=array();
		if($query->num_rows()>0)
		{
			$location=$this->getLocationName($query->row()->lat,$query->row()->lng);
			//$location='';
			$data['location']=$location;
			$data['receivedon']=date('Y-m-d h:i:s a ',strtotime($query->row()->receivedon));
			$sql_reg="select  register_number from tb_trucks_data where imei='".$imei."'";
			$query_re=$this->db->query($sql_reg);
			$register_number=$query_re->row()->register_number;
			$data['register_number']=$register_number;
			$data['truckid']=$truckid;
		}
		echo json_encode($data);
	}
	public function locate_dev()
	{
		$imei=$_REQUEST['imei'];
		//echo $imei."error";
		$truckid=isset($_REQUEST['truckid'])?$_REQUEST['truckid']:$truckid=0;
		$sql="select lat,lng,receivedon from tb_gps_devices where imei='".$imei."' order by id desc limit 0,1 ";
		$query=$this->db->query($sql);
		$data=array();
		if($query->num_rows()>0)
		{
			$location=$this->getLocationName($query->row()->lat,$query->row()->lng);
			//$location='';
			$data['location']=$location;
			$data['receivedon']=date('Y-m-d h:i:s a ',strtotime($query->row()->receivedon));
			$sql_reg="select  register_number from tb_trucks_data where imei='".$imei."'";
			$query_re=$this->db->query($sql_reg);
			$register_number=$query_re->row()->register_number;
			$data['register_number']=$register_number;
			//$data['imei']=$imei;
			//$sql="select * from tb_trucks where ";
			$data['truckid']=$truckid;
		}
		echo json_encode($data);
	}
	public function locatetruck()
	{
		$imei=$_REQUEST['imei'];
		$truckid=isset($_REQUEST['truckid'])?$_REQUEST['truckid']:$truckid=0;
		$sql="select lat,lng,receivedon from tb_gps_devices where imei='".$imei."' order by id desc limit 0,1 ";
		$query=$this->db->query($sql);
		$location='';
		if($query->num_rows()>0)
		{
			$location=$this->getLocationName($query->row()->lat,$query->row()->lng);
			$data['location']=$location;
		}
		echo $location;
	}

	public function getemployees()
	{
		$sql="select tb_veh_sch.truck as imei from tb_veh_sch,tb_schedule where tb_veh_sch.sch_id=tb_schedule.id";
	}

	public function addrtdrivelocations()
	{
		//$resdata='{"locations":"[{\"latitude\":17.7385047,\"longitude\":83.3048814,\"mobileimei\":\"911380451135879\",\"timestamp\":\"2016-03-29 19:22:41\"},{\"latitude\":17.7385047,\"longitude\":83.3048814,\"mobileimei\":\"911380451135879\",\"timestamp\":\"2016-03-29 19:22:41\"}]"}';
		/*Below json_decode statement is requied to decode the android request with params(in json)*/
		$post = json_decode(file_get_contents("php://input"), true);
		$resdata = $post["locations"];
		$resdata = json_decode($resdata,TRUE);
		if(is_array($resdata))
		{
			foreach($resdata as $arrindex)
			{
				$speed=$arrindex["speed"]*3.6;
				$r=array();
				$r['timestamp']=$arrindex['timestamp'];
				$r['mobileimei']=$arrindex['mobileimei'];
				$q=$this->db->order_by("timestamp","desc")->get_where("tb_rtdrive_locations",array("mobileimei"=>$r["mobileimei"]),1,0);
				$time=$lat=$lng="";
				if($q->num_rows()>0){
					$time=$q->row()->timestamp;
					$lat=$q->row()->latitude;
					$lng=$q->row()->longitude;
					$mt=calculateDistance12($lat,$lng,$arrindex["latitude"],$arrindex["longitude"])*1000;
					$diff=round(abs(strtotime($r["timestamp"]) - strtotime($time)),2);
					if($diff*35>=$mt){
						$this->db->insert("tb_rtdrive_locations", $arrindex);
						$id=$this->db->insert_id();
						if($speed>60){
							$this->sendOverSpeed($arrindex);
						}
						$json_data = array("locationresponse"=>$r);
						$josn=json_encode($json_data);
					}else{
						$josn=json_encode(array());
					}
				}else{
					$this->db->insert("tb_rtdrive_locations", $arrindex);
					$id=$this->db->insert_id();
					if($speed>60){
						$this->sendOverSpeed($arrindex);
					}
					$json_data = array("locationresponse"=>$r);
					$josn=json_encode($json_data);
				}
				echo $josn;

			}
		}else{
			echo "Not Array";
		}
	}
	public function sendOverSpeed($arrindex){
		if($arrindex["accuracy"]<200){
			$this->db->select("receivedon");
			$this->db->where("mobileimei", $arrindex["mobileimei"]);
			$this->db->from("tb_over_speed");
			$this->db->order_by("receivedon","desc");
			$this->db->limit("1");
			$prev = $this->db->get();
			if($prev->num_rows()>0){
				$t=$prev->row()->receivedon;
				$d=round(abs(strtotime($arrindex["timestamp"]) - strtotime($t))/60,2);
				//log_message("error","diff time".$d);
				if($d>=15){
					$arrindex["receivedon"]=$arrindex["timestamp"];
					unset($arrindex["timestamp"]);
					$this->db->insert("tb_over_speed", $arrindex);
					$this->sendOverSpeedMail($arrindex);
				}
			}else{
				$arrindex["receivedon"]=$arrindex["timestamp"];
				unset($arrindex["timestamp"]);
				$this->db->insert("tb_over_speed", $arrindex);
				$this->sendOverSpeedMail($arrindex);
			}
		}
	}
	public function sendOverSpeedMail($arrindex){
		//log_message("error",json_encode($arrindex));
		$dr=$this->db->query("select t.register_number,d.name,d.contact_num,d.user_id from tb_truck_drivers d,tbl_assigned_drivers a,tb_trucks_data t where a.imei='".$arrindex["mobileimei"]."' and d.status='Active' and a.driver_id=d.id and a.status='1' and t.id=a.vehicle_id limit 1");
		if($dr->num_rows()>0){
			$kms = $arrindex['speed']*3.6;
			$row=$dr->row();
			$txt = "";
			$txt.="<tr><td>".$row->name."</td><td>".$row->contact_num."</td><td>".$row->register_number."</td><td>".getLocationname($arrindex['latitude'],$arrindex['longitude'])."</td><td>".$kms." KM</td><td>".$arrindex["receivedon"]."</td></tr>";
			$this->sendOSMail($row->user_id,$txt);
		}
	}

	public function sendOSMail($uid,$txt){
		$this->load->library('email');
		$getusermail = $this->db->select("name,emailid")->get_where("tb_users",array("id"=>$uid,"emailid !="=>""),1,0);
		if($getusermail->num_rows() > 0){
			$receivemail = $getusermail->row()->emailid;
			$receivename = $getusermail->row()->name;
		}/*else{
			$receivemail = 'kambhamramachandra@gmail.com';
			$receivename = 'RCREDDY K';
		}*/
		$html="Dear $receivename,<br><br><br><strong>Cab Over Speed Alert</strong><br><br><table border='0'><tr style='background-color: #14A3E1;color: white;'><td>Driver Name</td><td>Driver No</td><td>Vehicle</td><td>Location</td><td>Speed</td><td>Time</td></tr>".$txt."</table><br><br>Thanks,<br><b>Return Trucks</b><br>";
		//$this->email->to('kambhamramachandra@gmail.com');
		$this->email->to($receivemail,$receivename);
		$this->email->from('svkonekt@kuehne-nagel.com','RT Cabs');
		$this->email->subject('Over Speed Alarm ');
		$this->email->set_mailtype('html');
		$this->email->message($html);
		$this->email->send();
	}
}
?>
