<?php

use App\Order\Models\OrderReference;

if (!defined('BASEPATH')) exit('No direct script access allowed');

class NZGENorders extends CI_Controller
{
    const STATUSES = [
        'SALOG PENDING',
        'SALOG ACTIVE',
        'SALOG CLOSED',
        'SALOG TO BE BILLED'
    ];

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session','form_validation','email','ratemanagement']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['Order','common']);
        $this->load->library('altovaordercreation');
        if (!checkUrlAccessForUser('NZGENORDERS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index($id = null)
    {
        $data['page_title'] = "Order List";
        $data['sub_title'] = "Orders";
        $order = [];
        $custid = $this->session->userdata("cust_id");
        $companyCode = $this->session->userdata('company_code');
        $post = $this->input->post();

        if ($this->session->userdata('sub_cust') !== FALSE) {
            $subcusts = $this->session->userdata('sub_cust');

            if (!empty($subcusts)) {
                array_push($subcusts, $custid);
                $data['subcust'] = $subcusts;
            }
        }

        if ($id != '') {
            $post['bookingid'] = array();
            $getbooking_id = $this->common->gettblrowdata(array('id' => $id), "order_id", "tb_orders", 0, 0);

            if (!empty($getbooking_id)) {
                $post['bookingid'] = array($getbooking_id['order_id']);
            }
            $data['getbookingid'] = $post['bookingid'];
        }
        $data['order'] = $order_row_ids = [];
        $data['checkNZPGCondition'] = checkAccessConditions('RELATED_2_NZPG', $companyCode);
        if (!empty($post)) {
            $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            $whr = $this->searchorders($post);
            $order_status = isset($post['status']) ? $post['status'] : '';
            $ad_orderstatus = isset($post['order_status']) ? $post['order_status'] : '';
            $status_search = $order_status;

            if ($status_search == '') {
                $status_search = $ad_orderstatus;
            }

            $referenceid = isset($post['referenceid']) ? $post['referenceid'] : array();

            if (!empty($referenceid)) {
                $getdeliverynotes = $this->db->query("SELECT order_id FROM tb_order_references WHERE reference_id='DQ' AND ref_value IN ('" . implode("','", $referenceid) . "') and status='1'");

                if ($getdeliverynotes->num_rows() > 0) {
                    foreach ($getdeliverynotes->result() as $res) {
                        $order_row_ids[] = $res->order_id;
                    }
                }
            }
            $getorderdetails = $this->Order->getNZCustomerOrders($subcusts ?? [],$custid,$order_row_ids,$status_search,$searchids,$whr);
            if ($getorderdetails->num_rows() > 0) {
                foreach ($getorderdetails->result() as $res) {
                    $orderRowIds[] = $res->id;
                    $costCenter = $res->costCenter;
                    $trip_id = $res->trip_id;
                    $order_id = $res->id;
                    $city = $res->delivery_city;
                    $street = $res->delivery_address1;
                    $state = $res->delivery_address2;
                    $order_type = '';

                    $getordertype = $this->db->query("SELECT t.type_name FROM tb_order_types t,tb_order_details d WHERE d.order_row_id='" . $res->id . "' AND d.order_type IS NOT NULL AND d.order_type != '' AND d.order_type=t.id");
                    if ($getordertype->num_rows() > 0) {
                        $order_type = $getordertype->row()->type_name;
                    }

                    $tripstatus = $res->status;
                    $trip_sts = $res->trip_sts;
                    $shipmentid = $res->shipmentid;
                    $order_status = "PENDING";
                    $otherStatus = '';
                    if ($trip_id != 0 && $trip_sts == 0) {
                        $order_status = 'ACTIVE';
                    }
                    if ($trip_id != 0 && $trip_sts == 1) {
                        $order_status = 'CLOSED';
                    }
                    if ($order_status == 'PENDING') {
                        $otherStatus = strtoupper($res->order_status);
                        if ($otherStatus == '') {
                            $getstatus = $this->db->select('order_status')->get_where("tb_order_details", array('order_row_id' => $res->id));
                            if ($getstatus->num_rows() > 0) {
                                $otherStatus = strtoupper($getstatus->row()->order_status);
                            }
                        }
                        if ($otherStatus != 'READY') {
                            $otherStatus = '';
                        }
                    }

                    if ($shipmentid == "0") {
                        $shipmentid = '';
                    }
                    $shipid = '';
                    $order_row_id = $res->id;
                    if ($order_row_id > 0) {
                        $getdqnote = $this->db->select("ref_value")->order_by("id", "DESC")
                            ->get_where("tb_order_references", array('order_id' => $order_row_id, 'reference_id' => 'DQ', 'status' => '1') );
                        if ($getdqnote->num_rows() > 0) {
                            $shipid = $getdqnote->row()->ref_value;
                        }
                    }
                    $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
                    $pickupDatetime = $res->pickup_datetime;
                    $deliveryDatetime = $res->delivery_datetime;
                    if ($pickupDatetime != "" && $pickupDatetime != "0000-00-00 00:00:00") {
                        $pickUpTimeZone = getdatetimebytimezone($userTimeZone, $pickupDatetime, DFLT_TZ);
                        $pickupDatetime = $pickUpTimeZone['datetime'];
                    }
                    if ($deliveryDatetime != "" && $deliveryDatetime != "0000-00-00 00:00:00") {
                        $deliveryTimeZone = getdatetimebytimezone($userTimeZone, $deliveryDatetime, DFLT_TZ);
                        $deliveryDatetime = $deliveryTimeZone['datetime'];
                    }
                    $order[] = [
                        'bookingid' => $res->order_id,
                        'order_row_id' => $res->id,
                        'shipid' => $shipid,
                        'name' => $res->master_name,
                        'street' => $street,
                        'state' => $state,
                        'city' => $city,
                        'pickup_date' => $pickupDatetime,
                        'delivery_date' => $deliveryDatetime,
                        'status' => $order_status,
                        'order_type' => $order_type,
                        'trip_id' => $shipmentid,
                        'tripstatus' => $tripstatus,
                        'otherStatus'=> $otherStatus,
                        'costCenter' => $costCenter
                    ];
                }
            }
            if (!$data['checkNZPGCondition']) {
                $invoice = $this->Order->getNZCustomerOrderRevenues($orderRowIds ?? [], $this->session->userdata("usr_tzone")['currency']);
            }
            $data['invoice'] = $invoice ?? [];
            $data['order'] = $order;
        }
        $this->newtemplate->dashboard("custorders/order", $data);

    }

    public function searchorders($post)
    {
        $whr = array();
        $cdate = date('Y-m-d H:i:s');
        $session_user_id = $this->session->userdata('user_id');
        if (isset($post['fromdate']) && $post['fromdate'] != '') {
            $fromdate = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
            if (isset($post['todate'])) {
                if ($post['todate'] == '') {
                    $todate = date('Y-m-d', strtotime($cdate));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
                }
            } else {
                $todate = date('Y-m-d', strtotime($cdate));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }

        }
        if (isset($post['todate']) && $post['todate'] != '') {
            $todate = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }

        if (isset($post['order_id']) && $post['order_id'] != '') {
            $whr['o.order_id'] = $post['order_id'];

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != '') {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers", array('code' => $post['searchcustomer_id']));
            if ($getcustomer_id->num_rows() > 0) {
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }
        }
        if (isset($post['service']) && $post['service'] != '') {
            $whr['d.service'] = $post['service'];

        }

        if (isset($post['order_type']) && $post['order_type'] != '') {
            $whr['d.order_type'] = $post['order_type'];

        }
        if (isset($post['product']) && $post['product'] != '') {
            $whr['o.product'] = $post['product'];

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != '') {
            $whr['o.transport_mode'] = $post['modeof_trasnport'];

        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != '') {
            $whr['o.pickup_custid'] = $post['searchshipper_id'];

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != '') {
            $whr['o.drop_custid'] = $post['searchconsignee_id'];

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != '') {
            $getdelivery_noteid = $this->db->select("order_id")->get_where("tb_order_references", array('ref_value' => $post['delivery_note'], 'status' => '1', 'reference_id' => 'DQ'));
            if ($getdelivery_noteid->num_rows() > 0) {
                $order_id = $getdelivery_noteid->row()->order_id;
                $whr['o.id'] = $order_id;
            }

        }
        if (isset($post['trip_id']) && $post['trip_id'] != '') {
            $whr['o.shipmentid'] = $post['trip_id'];
        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != '') {
            $getpo = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.user_id LIKE '" . $session_user_id . "' AND o.status !=0 AND r.reference_id LIKE 'PO' AND r.ref_value ='" . $post['purchase_order'] . "' AND r.status ='1'");
            if ($getpo->num_rows() > 0) {
                $order_id = $getpo->row()->id;
                $whr['o.id'] = $order_id;
            } else {
                $whr['o.id'] = '0';

            }
        }
        if (isset($post['company_code']) && $post['company_code'] != '') {
            $whr['o.company_code'] = $post['company_code'];

        }
        if (isset($post['branch_code']) && $post['branch_code'] != '') {
            $whr['o.branch_code'] = $post['branch_code'];

        }
        if (isset($post['from_date']) && $post['from_date'] != '') {
            $from_date = date('Y-m-d', strtotime($post['from_date']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $from_date;

        }
        if (isset($post['todate']) && $post['todate'] != '') {
            $todate = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }
        return $whr;

    }


    public function neworder()
    {
        $data = $transport = array();
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $getuserdata = $this->db->select("company_code,branch_code")->get_where("tb_users", array('id' => $user_id));
        $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
        if ($gettrasnportmode->num_rows() > 0) {
            foreach ($gettrasnportmode->result() as $res) {
                $transport[] = array('code' => $res->code, 'name' => $res->name);
            }
        }
        $data['transport'] = $transport;
        $data['company_code'] = $data['branch_code'] = '';
        if ($getuserdata->num_rows() > 0) {
            $data['company_code'] = $getuserdata->row()->company_code;
            $data['branch_code'] = $getuserdata->row()->branch_code;
        }
        $pickup_details = array();
        $custid = $this->session->userdata('cust_id');
        if ($this->session->userdata('sub_cust') !== FALSE) {
            $subcusts = $this->session->userdata('sub_cust');
            if (!empty($subcusts)) {
                array_push($subcusts, $custid);
                $data['subcust'] = $subcusts;
            }
        }

        if ($custid != '') {
            $getpickupdetails = $this->Order->getpickupdetails($custid);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
        }


        $ordertypes = array();
        $custid = $this->session->userdata('cust_id');
        $ordertypes = array();
        if ($custid != '') {
            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('customer_id' => $custid));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, "status" => 1));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                    }
                } else {
                    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => "SGKN", "status" => 1));
                    if ($getorders->num_rows() > 0) {
                        foreach ($getorders->result() as $res) {
                            $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                        }
                    }
                }
            }
        } else {

            $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, "status" => 1));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            } else {
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => "SGKN", "status" => 1));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                    }
                }
            }

        }
        $cargoes = array();
        $getcargodetails = $this->db->query("SELECT id,item_id FROM tb_items WHERE status='1' AND description LIKE 'APPLIANCES' GROUP BY id ORDER BY id DESC");
        if ($getcargodetails->num_rows() > 0) {
            foreach ($getcargodetails->result() as $row) {
                $cargoes[] = array('id' => $row->id, 'item_id' => $row->item_id);
            }
        }
        $roles = [];
        $qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
        if ($qyery->num_rows() > 0) {
            foreach ($qyery->result() as $res) {
                $roles[] = ['id' => $res->id, 'name' => $res->name];
            }
        }
        $arrCostCenter = [];
        if ($company_code == 'NZPG') {
            $getCostCenter = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_cost_center", array('company_code' => $company_code, 'status' => 1));
            if ($getCostCenter->num_rows() > 0) {
                foreach ($getCostCenter->result() as $res) {
                    $arrCostCenter[] = ['type_name' => $res->type_name, 'type_id' => $res->id];
                }
            }
        }
        $data['roles'] = $roles;
        $data['pickup_details'] = $pickup_details;
        $data['ordertypes'] = $ordertypes;
        $data['costcenter'] = $arrCostCenter;
        $data['cargoes'] = $cargoes;
        $this->newtemplate->dashboard('custorders/neworder', $data);
    }


    public function getdeliverytermvalue()
    {
        $incoterm = $this->input->post('incoterm');
        $terms = array();
        if ($incoterm != '') {
            $terms = getDeliverytermsbyIncoterm($incoterm);
        }
        echo json_encode($terms);
    }

    public function editorder($id)
    {
        $user_id = $this->session->userdata('user_id');
        $data = $order_types = array();
        $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = $delivery_array = array();

        $order_details['type_name'] = $order_details['ordtype_code'] = '';
        if ($id != '') {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $trip_id = $chkorder->row()->trip_id;
                $trip_sts = $chkorder->row()->trip_sts;
                $order_status = "PENDING";

                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'CLOSED';
                }
                if ($order_status != 'PENDING') {
                    redirect("Forbiddenaccess");
                }
                $incoterm = $chkorder->row()->incoterm;
                $shipment_id = $chkorder->row()->shipment_id;
                if ($shipment_id != '' && $shipment_id != 0) {

                    $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $shipment_id));
                    if ($getshipment_number->num_rows() > 0) {
                        $shipment_id = $getshipment_number->row()->shipid;
                    }
                }
                $status = $chkorder->row()->status;
                $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
                $pickupDatetime = $chkorder->row()->pickup_datetime;
                $deliveryDatetime = $chkorder->row()->delivery_datetime;
                $latePickup = $chkorder->row()->pickup_endtime;
                $lateDelivery = $chkorder->row()->drop_endtime;
                if ($pickupDatetime != "" && $pickupDatetime != "0000-00-00 00:00:00") {
                    $pickUpTimeZone = getdatetimebytimezone($userTimeZone, $pickupDatetime, DFLT_TZ);
                    $pickupDatetime = $pickUpTimeZone['datetime'];
                }
                if ($deliveryDatetime != "" && $deliveryDatetime != "0000-00-00 00:00:00") {
                    $deliveryTimeZone = getdatetimebytimezone($userTimeZone, $deliveryDatetime, DFLT_TZ);
                    $deliveryDatetime = $deliveryTimeZone['datetime'];
                }
                if ($latePickup != "" && $latePickup != "0000-00-00 00:00:00") {
                    $latePickupTimeZone = getdatetimebytimezone($userTimeZone, $latePickup, DFLT_TZ);
                    $latePickup = $latePickupTimeZone['datetime'];
                }
                if ($lateDelivery != "" && $lateDelivery != "0000-00-00 00:00:00") {
                    $lateDeliveryTimeZone = getdatetimebytimezone($userTimeZone, $lateDelivery, DFLT_TZ);
                    $lateDelivery = $lateDeliveryTimeZone['datetime'];
                }

                $refData = $this->getOrderReferenceData($id);
                $delivery_inst = $refData['ORD_DLVINST'];
                $pickup_inst = $refData['ORD_PIKINST'];

                $order_details = ['id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'order_status' => $chkorder->row()->order_status,
                    'early_pickup' => $pickupDatetime,
                    'early_delivery' => $deliveryDatetime,
                    'late_pickup' => $latePickup,
                    'late_delivery' => $lateDelivery,
                    'product' => $chkorder->row()->product,
                    'service' => $chkorder->row()->service,
                    'delivery_term' => $chkorder->row()->delivery_term,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'order_type' => $chkorder->row()->order_type,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'cost_center' => $chkorder->row()->cost_center_id,
                    'shipmentid' => $chkorder->row()->shipmentid,
                    'order_remarks' => $chkorder->row()->order_remarks,
                    'order_status' => $order_status,
                    'pickup_inst'  => $pickup_inst,
					'delivery_inst' => $delivery_inst,
                ];
                if ($incoterm != '') {
                    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
                }
                $pickup_id = $chkorder->row()->customer_id;
                $company_code = $this->session->userdata('company_code');
                if ($company_code != '') {
                    $company_code = $chkorder->row()->company_code;
                }
                $getorder_types = $this->db->select("id,type_name")->group_by('type_name')->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
                if ($getorder_types->num_rows() > 0) {
                    foreach ($getorder_types->result() as $res) {
                        $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                    }
                }
                $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = array('id' => $rr->id, 'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code);
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = array('id' => $rr->id, 'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code);
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
            }

        }
        $chargecodes = array();
        $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
        if ($getchargecodes->num_rows() > 0) {
            foreach ($getchargecodes->result() as $res) {
                $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
            }
        }

        $cargoes = array();
        $getcargodetails = $this->db->query("SELECT id,item_id FROM tb_items WHERE status='1' AND description LIKE 'APPLIANCES' GROUP BY id ORDER BY id DESC");
        if ($getcargodetails->num_rows() > 0) {
            foreach ($getcargodetails->result() as $row) {
                $cargoes[] = array('id' => $row->id, 'item_id' => $row->item_id);
            }
        }

        $roles = array();
        $qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
        if ($qyery->num_rows() > 0) {
            foreach ($qyery->result() as $res) {
                $roles[] = array('id' => $res->id, 'name' => $res->name);
            }
        }
        $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
        if ($gettrasnportmode->num_rows() > 0) {
            foreach ($gettrasnportmode->result() as $res) {
                $transport[] = array('code' => $res->code, 'name' => $res->name);
            }
        }
        $arrCostCenter = [];
        if (in_array($this->session->userdata('company_code'), array('NZPG'))) {
            $getCostCenter = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_cost_center", array('company_code' => $company_code, 'status' => 1));
            if ($getCostCenter->num_rows() > 0) {
                foreach ($getCostCenter->result() as $res) {
                    $arrCostCenter[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                }
            }
        }
        $data['transport'] = $transport;
        $data['order_details'] = $order_details;
        $data['roles'] = $roles;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['shipper_details'] = $shipper_details;
        $data['reference_details'] = $reference_details;
        $data['order_types'] = $order_types;
        $data['cost_center'] = $arrCostCenter;
        $data['cargoes'] = $cargoes;
        $data['delivery_array'] = $delivery_array;
        $data['chargecodes'] = $chargecodes;
        $data['deliveryNote'] = $this->getDeliveryNote($id);

        $this->load->model('Quickbook_model');
        $data['service'] = $this->Quickbook_model->getServicesData();

        $this->newtemplate->dashboard('custorders/editorder', $data);

    }

    public function vieworder($id)
    {

        $data = array();
        $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = array();
        if ($id != '') {
            $chkorder = $this->Order->getordertoedit($id);
            if ($chkorder->num_rows() > 0) {
                $transport = $chkorder->row()->transport_mode;
                $transport_mode = '';
                if ($transport != '') {

                    $getmode = $this->db->select("name")->get_where("tb_transportmode", array('code' => $transport));
                    if ($getmode->num_rows() > 0) {
                        $transport_mode = $getmode->row()->name;
                    }
                }
                $shipment_id = $chkorder->row()->shipment_id;
                if ($shipment_id != '' && $shipment_id != 0) {

                    $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $shipment_id));
                    if ($getshipment_number->num_rows() > 0) {
                        $shipment_id = $getshipment_number->row()->shipid;
                    }
                }
                $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
                $pickupDatetime = $chkorder->row()->pickup_datetime;
                $deliveryDatetime = $chkorder->row()->delivery_datetime;
                $latePickup = $chkorder->row()->pickup_endtime;
                $lateDelivery = $chkorder->row()->drop_endtime;
                if ($pickupDatetime != "" && $pickupDatetime != "0000-00-00 00:00:00") {
                    $pickUpTimeZone = getdatetimebytimezone($userTimeZone, $pickupDatetime, DFLT_TZ);
                    $pickupDatetime = $pickUpTimeZone['datetime'];
                }
                if ($deliveryDatetime != "" && $deliveryDatetime != "0000-00-00 00:00:00") {
                    $deliveryTimeZone = getdatetimebytimezone($userTimeZone, $deliveryDatetime, DFLT_TZ);
                    $deliveryDatetime = $deliveryTimeZone['datetime'];
                }
                if ($latePickup != "" && $latePickup != "0000-00-00 00:00:00") {
                    $latePickupTimeZone = getdatetimebytimezone($userTimeZone, $latePickup, DFLT_TZ);
                    $latePickup = $latePickupTimeZone['datetime'];
                }
                if ($lateDelivery != "" && $lateDelivery != "0000-00-00 00:00:00") {
                    $lateDeliveryTimeZone = getdatetimebytimezone($userTimeZone, $lateDelivery, DFLT_TZ);
                    $lateDelivery = $lateDeliveryTimeZone['datetime'];
                }

                $refData = $this->getOrderReferenceData($id);
                $delivery_inst = $refData['ORD_DLVINST'];
                $pickup_inst = $refData['ORD_PIKINST'];

                $order_details = ['id' => $chkorder->row()->id,
                    'order_id' => $chkorder->row()->order_id,
                    'shipment_id' => $shipment_id,
                    'order_status' => $chkorder->row()->order_status,
                    'early_pickup' => $pickupDatetime,
                    'early_delivery' => $deliveryDatetime,
                    'late_pickup' => $latePickup,
                    'late_delivery' => $lateDelivery,
                    'product' => $chkorder->row()->product,
                    'incoterm' => $chkorder->row()->incoterm,
                    'delivery_note' => $chkorder->row()->delivery_note,
                    'purchase_order' => $chkorder->row()->purchase_order,
                    'notify_party' => $chkorder->row()->notify_party,
                    'goods_value' => $chkorder->row()->goods_value,
                    'lane_reference' => $chkorder->row()->lane_reference,
                    'distance' => $chkorder->row()->distance,
                    'customs_required' => $chkorder->row()->customs_required,
                    'high_cargo_value' => $chkorder->row()->high_cargo_value,
                    'valorance_insurance' => $chkorder->row()->valorance_insurance,
                    'temperature_control' => $chkorder->row()->temperature_control,
                    'company_code' => $chkorder->row()->company_code,
                    'branch_code' => $chkorder->row()->branch_code,
                    'department_code' => $chkorder->row()->department_code,
                    'createdon' => $chkorder->row()->createdon,
                    'transport_mode' => $transport_mode,
                    'shipmentid' => $chkorder->row()->shipmentid,
                    'order_remarks' => $chkorder->row()->order_remarks,
                    'pickup_inst'            => $pickup_inst,
					'delivery_inst'          => $delivery_inst,
                ];
                $delivery_term = '';
                $pickup_id = $chkorder->row()->customer_id;
                $ord_type = $chkorder->row()->order_type;
                $order_details['order_type'] = '';

                $getordertype = $this->db->select("type_name")->get_where("tb_order_types", array('id' => $ord_type, 'status' => '1'));
                if ($getordertype->num_rows() > 0) {
                    $order_details['order_type'] = $getordertype->row()->type_name;
                }
                $cost_center_id = $chkorder->row()->cost_center_id;
                $order_details['cost_center'] = '';
                $getCostCenter = $this->db->select("type_name")->get_where("tb_cost_center", array('id' => $cost_center_id, 'status' => '1', 'company_code' => $chkorder->row()->company_code));
                if ($getCostCenter->num_rows() > 0) {
                    $order_details['cost_center'] = $getordertype->row()->type_name;
                }
                $delivery_term_id = $chkorder->row()->delivery_term;
                if ($delivery_term_id != '') {
                    $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", array('term_id' => $delivery_term_id));
                    if ($getdelivery_term->num_rows() > 0) {
                        $delivery_term = $getdelivery_term->row()->term_id . "-" . $getdelivery_term->row()->name;
                    }
                }
                $service = '';
                $service_id = $chkorder->row()->service;
                if ($service_id != '') {

                    $getservice = $this->db->select("service_id,name")->get_where("tb_service_master", array('id' => $service_id));
                    if ($getservice->num_rows() > 0) {
                        $service = $getservice->row()->service_id . "-" . $getservice->row()->name;
                    }
                }
                $order_details['service'] = $service;
                $order_details['delivery_term'] = $delivery_term;

                $getpickupdetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", array('status' => 1, 'id' => $pickup_id));
                if ($getpickupdetails->num_rows() > 0) {
                    $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
                }
                $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code);
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email, 'fax' => $rr->fax, 'party_id' => $rr->code);
                            }
                        }
                    }
                }
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $drop_id = $chkorder->row()->drop_custid;

            }
            $getreference = $this->db->query("SELECT o.ref_value,r.id,r.name FROM tb_order_references o,tb_reference_master r WHERE o.order_id='" . $id . "' AND o.reference_id=r.name AND o.status='1' AND r.status='1' ORDER BY o.id DESC");
            if ($getreference->num_rows() > 0) {
                foreach ($getreference->result() as $ref) {
                    if ($ref->name == 'INN') {
                        $order_details['INN'] = $ref->ref_value;
                    } else if ($ref->name == 'Z15') {
                        $order_details['Z15'] = $ref->ref_value;
                    } else if ($ref->name == 'BRN') {
                        $order_details['BRN'] = $ref->ref_value;
                    } else if ($ref->name == 'SD') {
                        $order_details['SD'] = $ref->ref_value;
                    } else if ($ref->name == 'CMP') {
                        $order_details['CMP'] = $ref->ref_value;
                    } else if ($ref->name == 'TRN') {
                        $order_details['TRN'] = $ref->ref_value;
                    } else if ($ref->name == 'XSR') {
                        $order_details['XSR'] = $ref->ref_value;
                    } else {
                        $reference_details[] = $ref->id;
                    }

                }
            }

        }
        $data['order_details'] = $order_details;
        $data['pickup_details'] = $pickup_details;
        $data['drop_details'] = $drop_details;
        $data['reference_details'] = $reference_details;
        $data['shipper_details'] = $shipper_details;
        $data['deliveryNote'] = $this->getDeliveryNote($id);

        $this->load->model('Quickbook_model');
        $data['service'] = $this->Quickbook_model->getServicesData();

        $this->newtemplate->dashboard('custorders/vieworder', $data);

    }

    public function updateorder()
    {
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : '0';
        if ($order_id != "0") {
            $cdate = date('Y-m-d H:i:s');
            $user_id = $this->session->userdata('user_id');
            $company_code = isset($_POST['company_code']) ? $_POST['company_code'] : '';
            $branch_code = isset($_POST['branch_code']) ? $_POST['branch_code'] : '';
            $department_code = isset($_POST['department_code']) ? $_POST['department_code'] : '';
            $product = isset($_POST['product']) ? $_POST['product'] : '';
            $service = isset($_POST['service']) ? $_POST['service'] : '';
            $order_status = isset($_POST['order_status']) ? $_POST['order_status'] : '';
            $delivery_terms = isset($_POST['delivery_terms']) ? $_POST['delivery_terms'] : '';
            $modeof_trasnport = isset($_POST['modeof_trasnport']) ? $_POST['modeof_trasnport'] : "TL";
            $order_type = isset($_POST['order_type']) ? $_POST['order_type'] : '';
            $cost_center = isset($_POST['cost_center']) ? $_POST['cost_center'] : '';
            $incoterm = isset($_POST['incoterm']) ? $_POST['incoterm'] : '';
            $shipment_id = isset($_POST['delivery_note']) ? $_POST['delivery_note'] : '';
            $porder = isset($_POST['purchase_order']) ? $_POST['purchase_order'] : '';
            $order_remarks = isset($_POST['order_remarks']) ? $_POST['order_remarks'] : '';

            $driver_pickup_instructions   = isset( $_POST['driver_pickup_instructions'] ) ? $_POST['driver_pickup_instructions'] : "";
			$driver_delivery_instructions = isset( $_POST['driver_delivery_instructions'] ) ? $_POST['driver_delivery_instructions'] : "";

            $notify_party = isset($_POST['notify_party']) ? $_POST['notify_party'] : '';
            if ($shipment_id != '') {
                $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'DQ' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                if ($upddq->num_rows() > 0) {
                    $this->db->where(array('id' => $upddq->row()->id))->update('tb_order_references', array('ref_value' => $shipment_id));
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id);
                    $this->db->insert('tb_order_references', $arr);
                }
            }

            if ( $driver_pickup_instructions != "" ) {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "ORD_PIKINST" AND r.name=o.reference_id AND o.order_id=?';
				$updporder = $this->db->query($sql, [$order_id] );
				if ( $updporder->num_rows() > 0 ) {
					$this->db->where( [ 'id' => $updporder->row()->id ] )->update( 'tb_order_references', [ 'ref_value' => $driver_pickup_instructions ] );
				} else {
					$arr = [ 'order_id' => $order_id, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $driver_pickup_instructions, 'createdon' => $cdate ];
					$this->db->insert( 'tb_order_references', $arr );
				}
			}
			if ( $driver_delivery_instructions != "" ) {
                $sql = 'SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE "ORD_DLVINST" AND r.name=o.reference_id AND o.order_id=?';
				$updporder = $this->db->query($sql, [$order_id] );
				if ( $updporder->num_rows() > 0 ) {
					$this->db->where( [ 'id' => $updporder->row()->id ] )->update( 'tb_order_references', [ 'ref_value' => $driver_delivery_instructions ] );
				} else {
					$arr = [ 'order_id' => $order_id, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $driver_delivery_instructions, 'createdon' => $cdate ];
					$this->db->insert( 'tb_order_references', $arr );
				}
			}

            if ($porder != '') {
                $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'PO' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                if ($updporder->num_rows() > 0) {
                    $this->db->where(array('id' => $updporder->row()->id))->update('tb_order_references', array('ref_value' => $porder));
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder);
                    $this->db->insert('tb_order_references', $arr);
                }
            }

            $goods_value = isset($_POST['goods_value']) ? $_POST['goods_value'] : "0.00";
            if ($goods_value == '') {
                $goods_value = 0.00;
            }
            $lane_reference = isset($_POST['lane_reference']) ? $_POST['lane_reference'] : '';
            $distance = isset($_POST['distance']) ? $_POST['distance'] : '';
            $booking_id = isset($_POST['booking_id']) ? $_POST['booking_id'] : '';
            $party_row_id = isset($_POST['order_party_row_id']) ? $_POST['order_party_row_id'] : "0";
            $reference_ids = isset($_POST['reference_ids']) ? $_POST['reference_ids'] : "0";
            $order_inv_row_id = isset($_POST['order_inv_row_id']) ? $_POST['order_inv_row_id'] : '0';
            $order_cargo_id = isset($_POST['order_cargo_id']) ? $_POST['order_cargo_id'] : '';
            $pickup = isset($_POST['order_pickup_id']) ? $_POST['order_pickup_id'] : '';
            $delivery = isset($_POST['order_drop_id']) ? $_POST['order_drop_id'] : '';
            $customs_required = isset($_POST['customs_required']) ? $_POST['customs_required'] : "0";
            $high_value_cargo = isset($_POST['high_value_cargo']) ? $_POST['high_value_cargo'] : "0";
            $ad_valorence_ins = isset($_POST['ad_valorence_ins']) ? $_POST['ad_valorence_ins'] : "0";
            $temp_control = isset($_POST['temp_control']) ? $_POST['temp_control'] : "0";
            $early_pickup = isset($_POST['early_pickup']) ? $_POST['early_pickup'] : '';
            $late_pickup = isset($_POST['late_pickup']) ? $_POST['late_pickup'] : '';
            $early_delivery = isset($_POST['early_delivery']) ? $_POST['early_delivery'] : '';
            $late_delivery = isset($_POST['late_delivery']) ? $_POST['late_delivery'] : '';
            $order_shipper_id = isset($_POST['order_shipper_id']) ? $_POST['order_shipper_id'] : "0";
            $e_pickup = date('Y-m-d H:i:s');
            if ($early_pickup != '') {
                $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
            }
            if ($late_pickup != '') {
                $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
            } else {
                $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
            }
            $e_delivery = date('Y-m-d H:i:s');
            if ($early_delivery != '') {
                $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
            }
            if ($late_delivery != '') {
                $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
            } else {
                $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
            }
            $getbookingid = $this->common->gettblrowdata(array('id' => $order_id), "order_id", "tb_orders", 0, 0);
            if (!empty($getbookingid)) {
                $booking_id = $getbookingid['order_id'];
            }
            $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = '';
            $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $drop_state = $drop_address = $pickup_state = $pickup_address = '';
            $pickup_custid = $drop_custid = $pickup_id = $drop_id = $drop_row_id = $consignee_party_id = $shipper_party_id = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name,p.code,o.id as order_party_id,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if ($chktype->row()->name == "Consignee") {
                            $drop_row_id = $rr->id;
                            $drop_id = $rr->code;
                            $drop_name = $rr->name;
                            $drop_custid = $rr->code;
                            $consignee_party_id = $rr->order_party_id;
                        } else if ($chktype->row()->name == "Shipper") {
                            $pickup_id = $rr->id;
                            $pickup_custid = $rr->code;
                            $pickup_name = $rr->name;
                            $shipper_party_id = $rr->order_party_id;
                        }
                    }
                }
            }
            if ($pickup_id != $order_shipper_id) {
                if ($order_shipper_id != "0") {
                    $getshippercustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $order_shipper_id . "'");
                    if ($getshippercustid->num_rows() > 0) {
                        $pickup_custid = $getshippercustid->row()->code;
                        $pickup_name = $getshippercustid->row()->name;
                        $pickup_state = $getshippercustid->row()->state;
                        $pickup_address = $getshippercustid->row()->address;
                        $pickup_country = $getshippercustid->row()->country;
                        $pickup_street = $getshippercustid->row()->street;
                        $pickup_pincode = $getshippercustid->row()->pincode;
                        $pickup_city = $getshippercustid->row()->city;
                        if ($pickup_id != 0) {
                            if ($shipper_party_id != 0) {
                                $chkorder_sparty = $this->db->select("id")->get_where("tb_order_parties", array('id' => $shipper_party_id));
                                if ($chkorder_sparty->num_rows() > 0) {
                                    $upd_sparty_address = $this->db->where(array('id' => $shipper_party_id))->update("tb_order_parties", array('status' => '0'));
                                }
                            }
                            $chkprevious_shipperaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $pickup_id, 'status' => '1'));
                            if ($chkprevious_shipperaddress->num_rows() > 0) {
                                $upd_oldsaddress = $this->db->where(array('id' => $chkprevious_shipperaddress->row()->id))->update("tbl_orderparty_address", array('status' => '0'));
                            }
                        }
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1'));
                        $shipper_address = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id, 'status' => '1');
                        if ($chkpartyaddress->num_rows() > 0) {
                            $pickup_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(array('id' => $pickup_addressid))->update("tbl_orderparty_address", $shipper_address);
                        } else {
                            $shipper_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address", $shipper_address);
                        }
                    }
                }
            } else if ($order_shipper_id == $pickup_id) {
                if ($order_shipper_id != 0) {
                    $chk_shipperaddress = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1'));
                    if ($chk_shipperaddress->num_rows() > 0) {
                        $pickup_city = $chk_shipperaddress->row()->location_id;
                        $pickup_country = $chk_shipperaddress->row()->country;
                        $pickup_street = $chk_shipperaddress->row()->street;
                        $pickup_pincode = $chk_shipperaddress->row()->pincode;
                        $pickup_state = $chk_shipperaddress->row()->state;
                        $pickup_address = $chk_shipperaddress->row()->address;
                    }
                }
            }

            if ($drop_row_id != $delivery) {
                if ($delivery != "0") {
                    $getdropcustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
                    if ($getdropcustid->num_rows() > 0) {
                        $drop_id = $delivery;
                        $drop_custid = $getdropcustid->row()->code;
                        $drop_name = $getdropcustid->row()->name;
                        $drop_state = $getdropcustid->row()->state;
                        $drop_address = $getdropcustid->row()->address;
                        $drop_country = $getdropcustid->row()->country;
                        $drop_street = $getdropcustid->row()->street;
                        $drop_pincode = $getdropcustid->row()->pincode;
                        $drop_city = $getdropcustid->row()->city;
                        if ($drop_row_id != 0) {
                            $chkprevious_dropaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $drop_row_id, 'status' => '1'));
                            if ($chkprevious_dropaddress->num_rows() > 0) {
                                $upd_olddaddress = $this->db->where(array('id' => $chkprevious_dropaddress->row()->id))->update("tbl_orderparty_address", array('status' => '0'));
                            }
                        }
                        if ($consignee_party_id != '0') {
                            $chkorder_cparty = $this->db->select("id")->get_where("tb_order_parties", array('id' => $shipper_party_id));
                            if ($chkorder_cparty->num_rows() > 0) {
                                $upd_cparty_address = $this->db->where(array('id' => $consignee_party_id))->update("tb_order_parties", array('status' => '0'));
                            }
                        }
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1'));
                        $drop_address = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id, 'status' => '1');
                        if ($chkpartyaddress->num_rows() > 0) {
                            $drop_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(array('id' => $drop_addressid))->update("tbl_orderparty_address", $drop_address);
                        } else {
                            $drop_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address", $drop_address);
                        }
                    }
                }
            } else if ($drop_row_id == $delivery) {
                if ($delivery != 0) {
                    $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1'));
                    if ($chkdrop->num_rows() > 0) {
                        $drop_city = $chkdrop->row()->location_id;
                        $drop_state = $chkdrop->row()->state;
                        $drop_country = $chkdrop->row()->country;
                        $drop_street = $chkdrop->row()->street;
                        $drop_pincode = $chkdrop->row()->pincode;
                        $drop_address = $chkdrop->row()->address;
                    }
                }
            }
            if ($order_shipper_id != '' || $order_shipper_id != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id));
                    if ($chk1->num_rows() > 0)
                        $party_type = $chk1->row()->id;
                }
                $chkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $order_id, 'party_type' => $party_type, 'party_id' => $order_shipper_id, 'status' => '1'));
                if ($chkparty->num_rows() == 0) {
                    $party = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
                    $ins_party = $this->db->insert("tb_order_parties", $party);
                }
            }
            if ($delivery != '' || $delivery != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id));
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $chkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $order_id, 'party_type' => $party_type, 'party_id' => $delivery, 'status' => '1'));
                if ($chkparty->num_rows() == 0) {
                    $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
                    $ins_party = $this->db->insert("tb_order_parties", $party);
                }
            }
            $ship_row_id = 0;
            $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
            $tid = 1;
            $tname = '';
            $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
            if ($gettrasnportmode->num_rows() > 0) {
                $tid = $gettrasnportmode->row()->id;
                $tname = $gettrasnportmode->row()->name;
            }
            $ship_arr = array('unitspec' => 1, 'shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $modeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid);
            $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");
            if ($chk_shipid->num_rows() > 0) {
                $ship_row_id = $chk_shipid->row()->id;
                $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
            } else {

                $ship_arr['createdon'] = $cdate;
                $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
                $ship_row_id = $this->db->insert_id();
            }

            if ($this->session->userdata('company_code') == 'NZKN') {
                if ($product == '') {
                    $product = "KN AsiaLink";
                }
                if ($modeof_trasnport == '') {
                    $modeof_trasnport = "LTL";
                }
                if ($service == '') {
                    $service = "19";
                }
            }
            $ins = [
                'shipment_id' => $ship_row_id,
                'product' => $product,
                'pickup_datetime' => $e_pickup,
                'delivery_datetime' => $e_delivery,
                'pickup_endtime' => $l_pickup,
                'drop_endtime' => $l_delivery,
                'goods_value' => $goods_value,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'transport_mode' => $modeof_trasnport,
                'modeoftransport' => $tid,
                'updatedon' => date('Y-m-d H:i:s')
            ];
            if ($pickup_name != '') {
                $ins['pickup_company'] = $pickup_name;
            }
            if ($pickup_country != '') {
                $ins['pickup_country'] = $pickup_country;
            }
            if ($drop_name != '') {
                $ins['delivery_company'] = $drop_name;
            }
            if ($drop_country != '') {
                $ins['delivery_country'] = $drop_country;
            }
            if ($pickup_street != '') {
                $ins['pickup_address1'] = $pickup_street;
            }
            if ($pickup_city != '') {
                $ins['pickup_city'] = $pickup_city;
            }
            if ($pickup_pincode != '') {
                $loc = [];
                $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                $loc = getlatlngsbyplace($add1);
                if ($loc[0] != '') {
                    $ins['plat'] = @$loc[0];
                }
                if ($loc[1] != '') {
                    $ins['plng'] = @$loc[1];
                }
                $ins['pickup_pincode'] = $pickup_pincode;
            }
            if ($pickup_state != '') {
                $ins['pickup_address2'] = $pickup_state;
            }
            if ($drop_street != '') {
                $ins['delivery_address1'] = $drop_street;
            }
            if ($drop_state != '') {
                $ins['delivery_address2'] = $drop_state;
            }
            if ($drop_city != '') {
                $ins['delivery_city'] = $drop_city;
            }
            if ($drop_pincode != '') {
                $loc = [];
                $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
                $loc = getlatlngsbyplace($add2);
                if ($loc[0] != '') {
                    $ins['dlat'] = @$loc[0];
                }
                if ($loc[1] != '') {
                    $ins['dlng'] = @$loc[1];
                }
                $ins['delivery_pincode'] = $drop_pincode;
            }
            $this->db->where(array('id' => $order_id))->update('tb_orders', $ins);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $cdate]);
            $details_ins = ['order_status' => $order_status,
                'service' => $service,
                'delivery_term' => $delivery_terms,
                'incoterm' => $incoterm,
                'purchase_order' => $porder,
                'notify_party' => $notify_party,
                'lane_reference' => $lane_reference,
                'distance' => $distance,
                'department_code' => $department_code,
                'temperature_control' => $temp_control,
                'valorance_insurance' => $ad_valorence_ins,
                'high_cargo_value' => $high_value_cargo,
                'customs_required' => $customs_required,
                'order_type' => $order_type,
                'order_remarks' => $order_remarks,
                'cost_center_id' => $cost_center];
            $upd_details = $this->db->where(array('order_row_id' => $order_id))->update("tb_order_details", $details_ins);
            $total_weight = $total_volume = $total_quantity = 0;
            $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
            if ($gettotal->num_rows() > 0) {
                $total_volume = $gettotal->row()->total_volume;
                $total_weight = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
            $this->ordernotify('booking_edit', $order_id);
        }
        if ($order_id != '' && $order_id != '0') {

            $this->session->set_flashdata('success_msg', 'Order Updated Successfully - ' . $booking_id);
            redirect('NZGENorders/index/' . $order_id);
        } else {
            redirect("NZGENorders");
        }


    }

    public function deleteorder($id)
    {
        if ($id != '' || $id != 0) {
            $chk = $this->db->select('id,trip_id,trip_sts')->get_where("tb_orders", array('id' => $id));
            if ($chk->num_rows() > 0) {
                $trip_id = $chk->row()->trip_id;
                $trip_sts = $chk->row()->trip_sts;
                $order_status = "PENDING";
                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'CLOSED';
                }
                if ($order_status != 'PENDING') {
                    redirect("Forbiddenaccess");
                }
                $upd = $this->db->where(array('id' => $id))->update('tb_orders', array('status' => 0));

                if ($upd) {
                    $refs = new OrderReference();
                    $refs->deleteForOrder($id, ['DQ']);

                    $this->ordernotify('booking_delete', $id);
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

    public function insertorder()
    {


        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post();
        $company_code = $post['company_code'] ?? '';
        $customer_code = $post['customer_id'] ?? '';
        $branch_code = $post['branch_code'] ?? '';
        $department_code = $post['department_code'] ?? '';
        $product = $post['product'] ?? '';
        $service = $post['service'] ?? '';
        $order_shipper_id = $post['order_shipper_id'] ?? "0";
        $order_status = $post['order_status'] ?? '';
        if ($order_status == '') {
            $order_status = "Pending";
        }
        $delivery_terms = $post['delivery_terms'] ?? '';
        $incoterm = $post['incoterm'] ?? '';
        $shipment_id = $post['delivery_note'] ?? '';
        $porder = $post['purchase_order'] ?? '';
        $order_remarks = $post['order_remarks'] ?? '';
        $trn = $post['trn'] ?? '';
        $notify_party = $post['notify_party'] ?? '';
        $xsr = $post['xsr'] ?? '';
        $inn = $post['inn'] ?? '';
        $z15 = $post['z15'] ?? '';
        $brn = $post['brn'] ?? '';
        $sd = $post['sd'] ?? '';
        $cmp = $post['cmp'] ?? '';
        $goods_value = $post['goods_value'] ?? "0.00";
        if ($goods_value == '') {
            $goods_value = 0.00;
        }
        $lane_reference = $post['lane_reference'] ?? '';
        $distance = $post['distance'] ?? '';
        $party_row_id = $post['order_party_row_id'] ?? "0";
        $reference_ids = $post['reference_ids'] ?? "0";
        $order_inv_row_id = $post['order_inv_row_id'] ?? '0';
        $order_cargo_id = $post['order_cargo_id'] ?? '';
        $pickup = $post['order_pickup_id'] ?? '';
        $delivery = $post['order_drop_id'] ?? '0';
        $customs_required = $post['customs_required'] ?? "0";
        $high_value_cargo = $post['high_value_cargo'] ?? "0";
        $ad_valorence_ins = $post['ad_valorence_ins'] ?? "0";
        $temp_control = $post['temp_control'] ?? "0";
        $early_pickup = $post['early_pickup'] ?? '';
        $late_pickup = $post['late_pickup'] ?? '';
        $early_delivery = $post['early_delivery'] ?? '';
        $late_delivery = $post['late_delivery'] ?? '';
        $modeof_trasnport = $post['modeof_trasnport'] ?? "LTL";
        $order_type = $post['order_type'] ?? '';
        $cost_center = $post['cost_center'] ?? null;
        $e_pickup = date('Y-m-d H:i:s');
        if ($early_pickup != '') {
            $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
        }
        if ($late_pickup != '') {
            $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
        } else {
            $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
        }
        $e_delivery = date('Y-m-d H:i:s');
        if ($early_delivery != '') {
            $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
        }
        if ($late_delivery != '') {
            $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
        } else {
            $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
        }
        $same_porder = "0";
        if ($porder != '') {

            $chkporder = $this->db->query("SELECT id FROM tb_order_details WHERE purchase_order='" . $porder . "' AND status='1'");
            if ($chkporder->num_rows() > 0) {
                $same_porder = "1";

            }
        }
        if ($same_porder == 1) {
            $this->session->set_flashdata('error_msg', 'Purchase Order "' . $porder . '" already exists with One ORDER');
        } else {
            $drop_id = $pickup_custid = 0;
            $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $pickup_address = $pickup_state = $drop_address = $drop_state = '';
            if ($delivery != 0) {
                $getdrop_custid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
                if ($getdrop_custid->num_rows() > 0) {
                    $drop_id = $getdrop_custid->row()->customeridentifier;
                    $drop_name = $getdrop_custid->row()->name;
                    $drop_state = $getdrop_custid->row()->state;
                    $drop_address = $getdrop_custid->row()->address;
                    $drop_country = $getdrop_custid->row()->country;
                    $drop_street = $getdrop_custid->row()->street;
                    $drop_pincode = $getdrop_custid->row()->pincode;
                    $drop_city = $getdrop_custid->row()->city;
                }
            }

            if ($order_shipper_id == '') {
                $order_shipper_id = 0;
            }
            if ($order_shipper_id != 0) {
                $getshippercustid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id='" . $order_shipper_id . "'");
                if ($getshippercustid->num_rows() > 0) {
                    $pickup_custid = $getshippercustid->row()->customeridentifier;
                    $pickup_name = $getshippercustid->row()->name;
                    $pickup_state = $getshippercustid->row()->state;
                    $pickup_address = $getshippercustid->row()->address;
                    $pickup_country = $getshippercustid->row()->country;
                    $pickup_street = $getshippercustid->row()->street;
                    $pickup_pincode = $getshippercustid->row()->pincode;
                    $pickup_city = $getshippercustid->row()->city;
                }
            }

            $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
            $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
            $data = getlatlngsbyplace($add1);
            $lat1 = @$data[0];
            $lng1 = @$data[1];
            $data = [];
            $data = getlatlngsbyplace($add2);
            $lat2 = @$data[0];
            $lng2 = @$data[1];
            $ship_row_id = 0;
            $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
            $tid = 1;
            $tname = '';
            $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
            if ($gettrasnportmode->num_rows() > 0) {
                $tid = $gettrasnportmode->row()->id;
                $tname = $gettrasnportmode->row()->name;
            }
            if ($shipment_id == '') {
                $shipment_id = "SVK" . time();
            }

            $ship_arr = array('unitspec' => 1, 'shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $modeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid);
            $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");

            if ($chk_shipid->num_rows() > 0) {
                $ship_row_id = $chk_shipid->row()->id;
                $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
            } else {

                $ship_arr['createdon'] = $cdate;
                $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
                $ship_row_id = $this->db->insert_id();
            }
            $customer_id = 0;
            $cust_id = $this->session->userdata('cust_id');
            if ($cust_id == '') {
                $customer_id = $pickup;
            } else {
                $customer_id = $cust_id;
            }
            if ($this->session->userdata('company_code') == 'NZKN') {
                if ($product == '') {
                    $product = "KN AsiaLink";
                }
                if ($modeof_trasnport == '') {
                    $modeof_trasnport = "LTL";
                }
                if ($service == '') {
                    $service = "19";
                }
            }
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $logdate = $getactual['datetime'];
            $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $curtz);
            $e_pickup = $getpickup['datetime'];
            $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $curtz);
            $l_pickup = $getlpickup['datetime'];
            $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $curtz);
            $e_delivery = $getdelivery['datetime'];
            $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $curtz);
            $l_delivery = $getldelivery['datetime'];

            $ins = array('shipment_id' => $ship_row_id, 'customer_id' => $customer_id, 'product' => $product, 'pickup_datetime' => $e_pickup, 'delivery_datetime' => $e_delivery, 'pickup_endtime' => $l_pickup, 'drop_endtime' => $l_delivery, 'goods_value' => $goods_value, 'company_code' => $company_code, 'branch_code' => $branch_code, 'drop_custid' => $drop_id, 'drop_partyid' => $drop_id, 'user_id' => $user_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_custid, 'pickup_country' => $pickup_country, 'pickup_city' => $pickup_city, 'pickup_pincode' => $pickup_pincode, 'pickup_company' => $pickup_name, 'pickup_address1' => $pickup_street, 'delivery_country' => $drop_country, 'delivery_city' => $drop_city, 'delivery_pincode' => $drop_pincode, 'delivery_company' => $drop_name, 'delivery_address1' => $drop_street, 'plat' => $lat1, 'plng' => $lng1, 'dlat' => $lat2, 'dlng' => $lng2, 'transport_mode' => $modeof_trasnport, 'modeoftransport' => $tid, 'created_source' => '4', 'createdon' => $logdate);
            $ins_order = $this->db->insert("tb_orders", $ins);
            $order_id = $this->db->insert_id();

            $user_id = $this->session->userdata('user_id');
            if ($user_id != '') {
                $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array('id' => $user_id));
                $country_code = $get_country->row()->country_code;
                $company_code = $get_country->row()->company_code;
                $genord = array("user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code);
                $booking_id = generatebookingid($genord);
                $upd = $this->db->where(array('id' => $order_id))->update("tb_orders", array('order_id' => $booking_id));
                $invtypes = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
                insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $logdate]);
                $details = array('service' => $service, 'delivery_term' => $delivery_terms, 'incoterm' => $incoterm, 'purchase_order' => $porder, 'notify_party' => $notify_party, 'lane_reference' => $lane_reference, 'distance' => $distance, 'department_code' => $department_code, 'temperature_control' => $temp_control, 'valorance_insurance' => $ad_valorence_ins, 'high_cargo_value' => $high_value_cargo, 'customs_required' => $customs_required, 'order_row_id' => $order_id, 'order_id' => $booking_id, 'createdon' => $logdate, 'order_status' => $order_status, 'shipper_id' => $order_shipper_id, 'order_type' => $order_type, 'cost_center_id' => $cost_center, 'order_remarks' => $order_remarks);
                $ins = $this->db->insert("tb_order_details", $details);
            }
            if ($order_shipper_id != 0) {
                $shipper_address = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
                $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
                if ($chk_shipperaddress->num_rows() > 0) {
                    $shipperadd_id = $chk_shipperaddress->row()->id;
                    $upd_add = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
                } else {
                    $shipper_address['createdon'] = $cdate;
                    $this->db->insert("tbl_orderparty_address", $shipper_address);
                    $shipperadd_id = $this->db->insert_id();
                }
            }
            if ($delivery != 0) {
                $delivery_address = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
                $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
                if ($chk_deliveryaddress->num_rows() > 0) {
                    $dropadd_id = $chk_deliveryaddress->row()->id;
                    $upd_add = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
                } else {
                    $delivery_address['createdon'] = $cdate;
                    $this->db->insert("tbl_orderparty_address", $delivery_address);
                    $dropadd_id = $this->db->insert_id();
                }
            }

            $cargo_forship = array();
            if ($order_cargo_id != '') {
                $cargo_ids = array();
                $cargo_ids = explode(',', $order_cargo_id);
                $length = $width = $height = $weight = $volume = $ldm = $volumetric_weight = $second_weight = $second_volume = 0;
                for ($i = 0; $i < sizeof($cargo_ids); $i++) {
                    $getcargo_details = $this->db->query("SELECT cargo_type,length,width,height,weight,volumetric_weight,ldm,volume,second_weight,second_volume,quantity,goods_description FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
                    $quantity = $cargo_type = $description = '';
                    $length = $width = $height = $weight = $volume = 0.00;
                    if ($getcargo_details->num_rows() > 0) {
                        $length = $getcargo_details->row()->length;
                        $width = $getcargo_details->row()->width;
                        $height = $getcargo_details->row()->height;
                        $weight = $getcargo_details->row()->weight;
                        $volume = $getcargo_details->row()->volume;
                        $quantity = $getcargo_details->row()->quantity;
                        $cargo_type = $getcargo_details->row()->cargo_type;
                        $description = $getcargo_details->row()->goods_description;
                        $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                        $ldm = $getcargo_details->row()->ldm;
                        $second_weight = $getcargo_details->row()->second_weight;
                        $second_volume = $getcargo_details->row()->second_volume;
                        $cargo_forship[$i] = $getcargo_details->row()->cargo_type;
                    }
                    $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
                    $handling_unit = '';
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = array('unit_name' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1');
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = array('order_id' => $order_id, 'cargo_id' => $cargo_ids[$i], 'status' => '1', 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $quantity, 'cargo_content' => $description, 'quantity_type' => $cargo_type, 'volumetric_weight' => $volumetric_weight, 'ldm' => $ldm, 'volweight_uom' => 'kg', 'handling_unit' => $handling_unit, 'second_weight' => $second_weight, 'second_volume' => $second_volume);
                    $ins_cargo = $this->db->insert("tb_order_cargodetails", $cargo);
                }
            }
            $unitspec = "1";
            if (!empty($cargo_forship)) {
                $unitspec = implode(',', $cargo_forship);
            }
            $updship = $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", array('unitspec' => $unitspec, 'txncode' => $booking_id));
            $total_weight = $total_volume = $total_quantity = 0;
            $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
            if ($gettotal->num_rows() > 0) {
                $total_volume = $gettotal->row()->total_volume;
                $total_weight = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
            $ids = array();
            if ($reference_ids != "0") {
                $refids = explode(',', $reference_ids);
            }
            if (!empty($refids)) {
                for ($i = 0; $i < sizeof($refids); $i++) {
                    if ($refids[$i] != '') {
                        $chk = $this->db->query("SELECT o.id FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $refids[$i] . "' AND r.name=o.reference_id");
                        if ($chk->num_rows() > 0) {
                            $upd = $this->db->where(array('id' => $chk->row()->id))->update("tb_order_references", array('order_id' => $order_id));
                        }
                    }

                }
            }
            if ($shipment_id != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($porder != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);

            }
            if ($trn != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'TRN', 'ref_value' => $trn, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($xsr != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'XSR', 'ref_value' => $xsr, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($inn != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'INN', 'ref_value' => $inn, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($z15 != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'Z15', 'ref_value' => $z15, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($brn != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'BRN', 'ref_value' => $brn, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($sd != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'SD', 'ref_value' => $sd, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }
            if ($cmp != '') {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'CMP', 'ref_value' => $cmp, 'createdon' => $cdate);
                $ins = $this->db->insert('tb_order_references', $ins_ref);
            }

            if ($party_row_id != "0") {
                $ids = explode(',', $party_row_id);
            }
            if ($order_inv_row_id != 0 || $order_inv_row_id != '') {
                array_push($ids, $order_inv_row_id);
            }
            $getorder_number = $this->db->select('order_id')->get_where("tb_orders", array('id' => $order_id));
            $order_number = $getorder_number->row()->order_id;
            if ($order_shipper_id != '' || $order_shipper_id != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id));
                    if ($chk1->num_rows() > 0)
                        $party_type = $chk1->row()->id;
                }

                $party = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $order_number);
                $ins_party = $this->db->insert("tb_order_parties", $party);
            }
            if ($delivery != '' || $delivery != 0) {
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
                if ($chk->num_rows() > 0) {
                    $party_type = $chk->row()->id;
                } else {
                    $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id));
                    if ($chk1->num_rows() > 0) {
                        $party_type = $chk1->row()->id;
                    }
                }
                $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $order_number);
                $ins_party = $this->db->insert("tb_order_parties", $party);
            }
            if (!empty($ids)) {
                for ($i = 0; $i < sizeof($ids); $i++) {
                    if ($ids[$i] != '') {
                        $getpartytype = $this->db->query("SELECT party_type_id FROM tbl_party_master WHERE id='" . $ids[$i] . "'");
                        $party_type = 1;
                        if ($getpartytype->num_rows() > 0) {
                            $party_type = $getpartytype->row()->party_type_id;
                        }
                        $party = array('order_id' => $order_id, 'party_id' => $ids[$i], 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $order_number);
                        $ins_party = $this->db->insert("tb_order_parties", $party);
                    }
                }
            }
            $this->ordernotify('booking_create', $order_id);
            if(!checkAccessConditions('RELATED_2_NZPG', $company_code)){
                $preferenceArray = [
                    'pickup' => strtoupper($pickup_country),
                    'pickup_state' => strtoupper($pickup_state),
                    'pickup_city' => strtoupper($pickup_city),
                    'pickup_pincode' => $pickup_pincode,
                    'drop' => strtoupper($drop_country),
                    'drop_state' => strtoupper($drop_state),
                    'drop_city' => strtoupper($drop_city),
                    'drop_pincode' => $drop_pincode,
                    'customer_id' => $customer_code,
                    'service' => $service,
                    'product' => $product,
                    'user_id' => $user_id,
                    'company_code' => $company_code,
                    'order_type' => $order_type,
                    'order_id' => $order_id,
                    'customer_row_id' => $customer_id,
                ];
                $this->ratemanagement->addrecodfororderinsertion($preferenceArray);
            }
        }
        if ($order_id != '' && $order_id != '0') {
            try {
                $this->altovaordercreation->sendOrderToAltova($order_id);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
            }
            $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
            redirect('NZGENorders/index/' . $order_id);
        } else {
            redirect("NZGENorders");
        }

    }

    public function savequickbook()
    {

        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $cust_id = $this->session->userdata('cust_id');
        $post = $this->input->post();
        $company_code = $post['popupcompany_code'] ?? '';
        $branch_code = $post['popupbranch_code'] ?? '';
        $department_code = $post['popupdepartment_code'] ?? '';
        $product = $post['productpopup'] ?? '';
        $service = $post['servicepopup'] ?? '';
        $delivery_terms = $post['popupdelivery_terms'] ?? '';
        $incoterm = $post['incoterm_popup'] ?? '';
        $shipment_id = $post['popupdelivery_note'] ?? '';
        $porder = $post['purchaseorder_popup'] ?? '';
        $notify_party = $post['popupnotifyparty'] ?? '';
        $popuppickup = $post['popuppickup'] ?? '';
        $popupdelivery = $post['popupdelivery'] ?? '';
        $popuporder_remarks = $post['popuporder_remarks'] ?? '';
        $popupcustomer_id = $post['popupcustomer_id'] ?? '';
        $popuporder_type = $post['popuporder_type'] ?? '';
        $popupmodeof_trasnport = $post['popupmodeof_trasnport'] ?? "LTL";
        $reference_ids = $post['quickbookreference_ids'] ?? "0";
        $quickbook_order_reference_ids = $post['quickbook_order_reference_ids'] ?? "0";
        $order_cargo_id = $post['quickbookorder_cargo_id'] ?? '';
        $pickup = $post['quickbookpickup_id'] ?? "";
        $delivery = $post['quickboookconsignee_id'] ?? "";

        $earlyquickbook_delivery = $latequickbook_delivery = '';
        if ($popupdelivery != '') {
            $earlyquickbook_delivery = date('Y-m-d H:i:s', strtotime($popupdelivery));
            $latequickbook_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_delivery)));
        }
        $earlyquickbook_pickup = $latequickbook_pickup = '';
        if ($popuppickup != '') {
            $earlyquickbook_pickup = date('Y-m-d H:i:s', strtotime($popuppickup));
            $latequickbook_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_pickup)));
        }
        $drop_id = $pickup_custid = 0;
        $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $pickup_state = $drop_state = '';
        $getdrop_custid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='" . $delivery . "'");
        if ($getdrop_custid->num_rows() > 0) {
            $drop_id = $getdrop_custid->row()->customeridentifier;
            $drop_name = $getdrop_custid->row()->name;
            $drop_country = $getdrop_custid->row()->country;
            $drop_street = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city = $getdrop_custid->row()->city;
            $drop_state = $getdrop_custid->row()->state;
        }
        $getshippercustid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='" . $_POST['quickbookshipper_id'] . "'");
        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid = $getshippercustid->row()->customeridentifier;
            $pickup_name = $getshippercustid->row()->name;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_street = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city = $getshippercustid->row()->city;
            $pickup_state = $getshippercustid->row()->state;
        }
        $tname = "Full Truck Load";
        $tid = "FTL";
        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = 1;
        $tname = '';
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $popupmodeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == '') {
            $shipment_id = "SVK" . time();
        }
        $ship_row_id = 0;
        $ship_arr = array('shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $popupmodeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid, 'unitspec' => 1);
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }
        $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
        $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $data = [];
        $data = getlatlngsbyplace($add2);
        $lat2 = @$data[0];
        $lng2 = @$data[1];
        $customer_id = 0;
        if ($cust_id == '') {
            $customer_id = $pickup;
        } else {
            $customer_id = $cust_id;
        }
        if ($this->session->userdata('company_code') == 'NZKN') {
            if ($product == '') {
                $product = "KN AsiaLink";
            }
            if ($popupmodeof_trasnport == '') {
                $popupmodeof_trasnport = "LTL";
            }
            if ($service == '') {
                $service = "19";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_pickup, $curtz);
        $earlyquickbook_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $latequickbook_pickup, $curtz);
        $latequickbook_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_delivery, $curtz);
        $earlyquickbook_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $latequickbook_delivery, $curtz);
        $latequickbook_delivery = $getldelivery['datetime'];
        $ins = array('goods_value' => '0.00', 'shipment_id' => $ship_row_id, 'customer_id' => $customer_id, 'product' => $product, 'company_code' => $company_code, 'branch_code' => $branch_code, 'pickup_datetime' => $earlyquickbook_pickup, 'delivery_datetime' => $earlyquickbook_delivery, 'pickup_endtime' => $latequickbook_pickup, 'drop_endtime' => $latequickbook_delivery, 'drop_custid' => $drop_id, 'drop_partyid' => $drop_id, 'user_id' => $user_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_custid, 'pickup_country' => $pickup_country, 'pickup_city' => $pickup_city, 'pickup_pincode' => $pickup_pincode, 'pickup_company' => $pickup_name, 'pickup_address1' => $pickup_street, 'delivery_country' => $drop_country, 'delivery_city' => $drop_city, 'delivery_pincode' => $drop_pincode, 'delivery_company' => $drop_name, 'delivery_address1' => $drop_street, 'transport_mode' => $popupmodeof_trasnport, 'plat' => $lat1, 'plng' => $lng1, 'dlat' => $lat2, 'dlng' => $lng2, 'modeoftransport' => $tid, 'created_source' => '3', 'delivery_address2' => $drop_state, 'pickup_address2' => $pickup_state, 'createdon' => $logdate);
        $ins_order = $this->db->insert("tb_orders", $ins);
        $order_id = $this->db->insert_id();
        $user_id = $this->session->userdata('user_id');
        if ($user_id != '') {
            $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array('id' => $user_id));
            $country_code = $get_country->row()->country_code;
            $company_code = $get_country->row()->company_code;
            $genord = array("user_id" => $user_id, "order_id" => $order_id, "country_code" => $country_code, "company_code" => $company_code);
            $booking_id = generatebookingid($genord);
            $upd = $this->db->where(array('id' => $order_id))->update("tb_orders", array('order_id' => $booking_id));
            $invtypes = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $logdate]);
            $details = ['shipper_id' => $_POST['quickbookshipper_id'],
                'service' => $service,
                'delivery_term' => $delivery_terms,
                'incoterm' => $incoterm,
                'purchase_order' => $porder,
                'notify_party' => $notify_party,
                'department_code' => $department_code,
                'createdon' => $logdate,
                'order_row_id' => $order_id,
                'order_id' => $booking_id,
                'order_status' => 'Pending',
                'order_type' => $popuporder_type,
                'order_remarks' => $popuporder_remarks];
            $this->db->insert('tb_order_details', $details);
        }
        $order_shipper_id = isset($_POST['quickbookshipper_id']) ? $_POST['quickbookshipper_id'] : '';
        $pickup_address = $pickup_street . "," . $pickup_city . "," . $pickup_state;
        $shipper_address = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $upd_add = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
            $shipperadd_id = $this->db->insert_id();
        }
        $drop_address = $drop_street . "," . $drop_city . "," . $drop_state;
        $delivery_address = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $upd_add = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
            $dropadd_id = $this->db->insert_id();
        }
        $length = $width = $height = $weight = $volume = $ldm = $volumetric_weight = $second_weight = $second_volume = 0;
        if ($order_cargo_id != '') {
            $cargo_ids = array();
            $cargo_ids = explode(',', $order_cargo_id);
            for ($i = 0; $i < sizeof($cargo_ids); $i++) {
                if ($cargo_ids[$i] != '') {
                    $getcargo_details = $this->db->query("SELECT cargo_type,goods_description,length,width,height,weight,volumetric_weight,ldm,volume,second_weight,second_volume,quantity FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
                    $quantity = $cargo_type = $description = '';
                    $length = $width = $height = $weight = $volume = 0.00;
                    if ($getcargo_details->num_rows() > 0) {
                        $length = $getcargo_details->row()->length;
                        $width = $getcargo_details->row()->width;
                        $height = $getcargo_details->row()->height;
                        $weight = $getcargo_details->row()->weight;
                        $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                        $volume = $getcargo_details->row()->volume;
                        $quantity = $getcargo_details->row()->quantity;
                        $cargo_type = $getcargo_details->row()->cargo_type;
                        $ldm = $getcargo_details->row()->ldm;
                        $second_weight = $getcargo_details->row()->second_weight;
                        $second_volume = $getcargo_details->row()->second_volume;
                        $description = $getcargo_details->row()->goods_description;
                    }
                    $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
                    $handling_unit = '';
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = array('unit_name' => $cargo_type, 'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1');
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = array('order_id' => $order_id, 'cargo_id' => $cargo_ids[$i], 'status' => '1', 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight, 'volume' => $volume, 'quantity' => $quantity, 'cargo_content' => $description, 'quantity_type' => $cargo_type, 'handling_unit' => $handling_unit, 'volumetric_weight' => $volumetric_weight, 'volweight_uom' => 'kg', 'ldm' => $ldm, 'second_weight' => $second_weight, 'second_volume' => $second_volume);
                    $this->db->insert("tb_order_cargodetails", $cargo);
                }
            }
        }
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $cargo_forship = array();
        $getcargos = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "'");
        if ($getcargos->num_rows() > 0) {
            foreach ($getcargos->result() as $res) {
                $cargo_forship[] = $res->quantity_type;
            }
        }
        $unitspec = '';
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }
        $updship = $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", array('unitspec' => $unitspec, 'txncode' => $booking_id));
        $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
        $ids = array();
        if ($reference_ids != "0") {
            $refids = explode(',', $reference_ids);
        }
        $order_ref_ids = array();
        if ($quickbook_order_reference_ids != "0") {
            $order_ref_ids = explode(',', $quickbook_order_reference_ids);
        }
        if (!empty($order_ref_ids)) {
            for ($i = 0; $i < sizeof($order_ref_ids); $i++) {
                if ($order_ref_ids[$i] != '') {
                    $upd = $this->db->where(array('id' => $order_ref_ids[$i]))->update("tb_order_references", array('order_id' => $order_id));
                }
            }
        }
        if ($shipment_id != '') {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate);
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($porder != '') {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate);
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($order_shipper_id != '' || $order_shipper_id != 0) {

            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Shipper', 'company_code' => $company_code, 'user_id' => $user_id));
                if ($chk1->num_rows() > 0)
                    $party_type = $chk1->row()->id;
            }

            $party = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
            $ins_party = $this->db->insert("tb_order_parties", $party);

        }
        if ($delivery != '' || $delivery != 0) {
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'branch_code' => $branch_code, 'user_id' => $user_id));
            if ($chk->num_rows() > 0) {
                $party_type = $chk->row()->id;
            } else {
                $chk1 = $this->db->select("id")->get_where("tbl_party_types", array('name' => 'Consignee', 'company_code' => $company_code, 'user_id' => $user_id));
                if ($chk1->num_rows() > 0) {
                    $party_type = $chk1->row()->id;
                }
            }
            $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
            $ins_party = $this->db->insert("tb_order_parties", $party);
        }
        $this->ordernotify('booking_create', $order_id);
        if (!checkAccessConditions('RELATED_2_NZPG', $company_code)) {
            $preferenceArray = [
                'pickup' => strtoupper($pickup_country),
                'pickup_state' => strtoupper($pickup_state),
                'pickup_city' => strtoupper($pickup_city),
                'pickup_pincode' => $pickup_pincode,
                'drop' => strtoupper($drop_country),
                'drop_state' => strtoupper($drop_state),
                'drop_city' => strtoupper($drop_city),
                'drop_pincode' => $drop_pincode,
                'customer_id' => $popupcustomer_id,
                'service' => $service,
                'product' => $product,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'order_id' => $order_id,
                'order_type' => $popuporder_type,
                'customer_row_id' => $customer_id,
            ];
            $this->ratemanagement->addrecodfororderinsertion($preferenceArray);
        }
        if ($order_id != '' && $order_id != '0') {
            try {
                $this->altovaordercreation->sendOrderToAltova($order_id);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
            }
            $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
            redirect('NZGENorders/index/' . $order_id);
        } else {
            redirect("NZGENorders");
        }

    }

    public function orderglobalsearch()
    {

        $data['page_title'] = $this->lang->line('menu_orders');
        $data['sub_title'] = $this->lang->line('global_search');
        $data['ord_type'] = '';
        $data['orders'] = array();
        $inp = 0;
        $cid = $this->session->userdata("cust_id");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $input = $this->input->post();
        $whr = '';
        if (!empty($input)) {
            if (!empty($input['bookingid'])) {
                $bookids = implode("','", $input['bookingid']);
                $inp = 1;
                $whr .= " AND o.order_id IN('" . $bookids . "')";
            }
            if (isset($input['pickup']) && !empty($input['pickup'])) {
                $inp = 1;
                $whr .= " AND (o.pickup_country LIKE '%" . $input['pickup'] . "%' OR o.pickup_city LIKE '%" . $input['pickup'] . "%') ";
            }
            if (isset($input['drop']) && !empty($input['drop'])) {
                $inp = 1;
                $whr .= " AND (o.delivery_country LIKE '%" . $input['drop'] . "%' OR o.delivery_city LIKE '%" . $input['drop'] . "%') ";
            }
            if (isset($input['fromdate_search'])) {
                if ($input['fromdate_search'] != '') {
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['fromdate_search'], $curtz);
                    $input['fromdate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.pickup_datetime)>='" . $input['fromdate_search'] . "' ";
                }
            }
            if (isset($input['status'])) {
                if ($input['status'] != '') {
                    $searchsts = $input['status'];
                    if ($searchsts == 'PENDING') {
                        $whr .= " AND o.trip_id =0 ";
                    }
                    if ($searchsts == 'ACTIVE') {
                        $whr .= " AND o.trip_id != 0 AND o.trip_sts =0 ";
                    }
                    if ($searchsts == 'CLOSED') {
                        $whr .= " AND o.trip_id != 0 AND o.trip_sts =1 ";
                    }
                }
            }
            if (isset($input['todate_search'])) {
                if ($input['todate_search'] != '') {
                    $getactual = getdatetimebytimezone(DFLT_TZ, $input['todate_search'], $curtz);
                    $input['todate_search'] = $getactual['date'];
                    $inp = 1;
                    $whr .= " AND DATE(o.delivery_datetime)<='" . $input['todate_search'] . "' ";
                }
            }

            $getords = array();
            if (isset($input['reference'])) {
                if (!empty($input['reference'])) {
                    $inp = 1;
                    $reference = implode("','", $input['reference']);
                    $getords = $this->getOrdersbyRef($reference);
                }
            }
            if (isset($input['order_type'])) {
                if (!empty($input['order_type'])) {
                    $inp = 1;
                    $ordtye = implode("','", $input['order_type']);
                    $getords1 = $this->getOrdersbyRefOT("OT", $ordtye);
                    if (!empty($getords1)) {
                        $getords = array_merge($getords, $getords1);
                    } else {
                        $getords2 = $this->getOrdersdetailsType($ordtye);
                        if (!empty($getords2)) {
                            $getords = array_merge($getords, $getords2);
                        }
                    }
                }
            }
            if (!empty($getords)) {
                $gords = implode("','", $getords);
                $whr .= " AND o.id IN('$gords') ";
            }
        }
        if ($inp == 1 && $whr == '') {
            $whr .= " AND o.id IN(0) ";
        }
        $subcusts = array();
        if ($this->session->userdata('sub_cust') !== FALSE) {
            $subcusts = $this->session->userdata('sub_cust');
            if (!empty($subcusts)) {
                array_push($subcusts, $cid);
            }
        }
        $whr1 = $whr2 = '';
        if (!empty($subcusts)) {
            $whr1 .= " AND e.customer_id IN (" . implode(',', $subcusts) . ") ";
            $whr2 .= " o.customer_id IN (" . implode(',', $subcusts) . ") ";
        } else {
            $whr1 = " AND e.customer_id=" . $cid;
            $whr2 = " o.customer_id=" . $cid . " ";
        }
        $mainqry = "SELECT count(o.id) as cnt FROM tb_orders o WHERE o.status !=0 AND $whr2 $whr";
        $custord1 = $this->db->query($mainqry);
        $pgcnt = $custord1->row()->cnt;
        $config = array();
        $config["base_url"] = base_url() . "NZGENorders/orderglobalsearch";
        $config["total_rows"] = $pgcnt;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = TRUE;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $mainqry = "SELECT o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.plat,o.plng,o.status,o.trip_sts,o.shift_id,o.trip_id FROM tb_orders o WHERE $whr2 AND o.status != 0 $whr GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $qry = $mainqry . ' LIMIT ' . $page . ',' . $config["per_page"];
        $custord = $this->db->query($qry);
        if ($custord->num_rows() > 0) {
            $data['orders'] = $custord->result_array();
        }
        $this->newtemplate->dashboard('custorders/globalsearch', $data);

    }

    public function getOrdersdetailsType($otype)
    {
        $res = array();
        $cid = $this->session->userdata("user_id");
        $company_code = $this->session->userdata("company_code");
        if (!empty($otype)) {
            $ordertype_id = 0;
            $getordertype_id = $this->db->select('id')->get_where("tb_order_types", array('ordtype_code' => $otype, 'company_code' => $company_code, 'status' => '1'));
            if ($getordertype_id->num_rows() > 0) {
                $ordertype_id = $getordertype_id->row()->id;
            } else {
                $getordertype = $this->db->select('id')->get_where("tb_order_types", array('ordtype_code' => $otype, 'company_code' => 'SGKN', 'status' => '1'));
                if ($getordertype->num_rows() > 0) {
                    $ordertype_id = $getordertype->row()->id;
                }
            }
            if ($ordertype_id != 0) {
                $order_qry = $this->db->query("select o.id FROM tb_orders o, tb_order_details d where d.order_type='" . $ordertype_id . "' AND o.user_id= '" . $cid . "' AND o.id=d.order_row_id");
                if ($order_qry->num_rows() > 0) {
                    foreach ($order_qry->result() as $res1) {
                        $res[] = $res1->id;
                    }
                }
            }

        }

        return $res;
    }

    function getOrdersbyRefOT($refnum, $refval)
    {
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if (!empty($refval)) {
            $subcusts = array();
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if (!empty($subcusts)) {
                $whr = " AND o.customer_id IN (" . implode(',', $subcusts) . ") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND r.reference_id='" . $refnum . "' AND r.ref_value IN('" . $refval . "') $whr AND r.status=1");
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    function getOrdersbyRef($refid)
    {
        $res = array();
        $cid = $this->session->userdata("cust_id");
        if (!empty($refid)) {
            $subcusts = array();
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if (!empty($subcusts)) {
                    array_push($subcusts, $cid);
                }
            }
            $whr = " AND o.customer_id=$cid ";
            if (!empty($subcusts)) {
                $whr = " AND o.customer_id IN (" . implode(',', $subcusts) . ") ";
            }
            $qry = $this->db->query("select r.order_id FROM tb_order_references r, tb_orders o WHERE r.order_id=o.id AND  r.ref_value IN('" . $refid . "') $whr AND r.status=1");
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res1) {
                    $res[] = $res1->order_id;
                }
            }
        }
        return $res;
    }

    public function ordernotify($action, $orderid)
    {
        $this->load->library('notifytrigger');
        $this->load->model('common');
        $info['page_title'] = 'Booking Notification';
        $info['subject'] = 'Booking Notification';
        $info['order_id'] = $orderid;
        $info['action'] = $action;
        $orderinfo = $this->common->gettblrowdata(array('id' => $orderid), 'order_id', 'tb_orders', 0, 0);
        if ($orderinfo) {
            $info['orderid'] = $orderinfo['order_id'];
            $info['cargos'] = $this->common->gettbldata(array('order_id' => $orderid), 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
            $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
            $this->notifytrigger->sendordernotify($info);
        }
    }

    public function getOrderReferenceData($id) {
        $referenceArray = [
            'ORD_DLVINST' => '',
            'ORD_PIKINST' => ''
        ];
        $sql = "SELECT MIN(CASE WHEN reference_id = 'ORD_DLVINST' THEN ref_value END)  AS 'delivery_instructions',
                    MIN(CASE WHEN reference_id = 'ORD_PIKINST' THEN ref_value END) AS 'pickup_instructions'
                    FROM tb_order_references ordRef
                    WHERE order_id = ?
                    AND reference_id IN ('ORD_DLVINST','ORD_PIKINST')
                    GROUP BY order_id";
        $getReferenceQuery = $this->db->query($sql, [$id] );
        if ( $getReferenceQuery->num_rows() > 0 ) {
            $result = $getReferenceQuery->result_array();
            if (count($result)>0) {
                $referenceArray['ORD_DLVINST'] = $result[0]['delivery_instructions'];
                $referenceArray['ORD_PIKINST'] = $result[0]['pickup_instructions'];
            }
        }
        return $referenceArray;
    }

    public function getDeliveryNote(int $id): string
    {
        $this->db->select("ref_value");
        $this->db->from("tb_order_references");
        $this->db->where("order_id", $id);
        $this->db->where("reference_id", 'DQ');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row()->ref_value;
        } else {
            return "";
        }
    }

}

