<?php

if (! defined('BASEPATH')) {
  exit('No direct script access allowed');
}

class Nicplace extends CI_Controller
{
  private const ALARM_EXCEPTION_RULE = 'Truck_Trailer_Backup_Powerloss_ATROM';
  private const ALARM_EXCEPTION_CARRIER_RULE = ['kktrans', 'kustrans'];

  public function __construct()
  {
    parent::__construct();
    $this->load->library(['nicplace_l','Country_master_data_validator','edi/EdiStatusProcess'] );
    $this->load->model(['nicplacemodel', 'common']);
    $this->load->helper(['log', 'generic']);
  }

  public function get_asset()
  {
    echo json_encode($this->nicplace_l->get_assets());
  }

  public function get_alarms_db($for_truck_trail = 'for_truck')
  {
    echo json_encode($this->nicplace_l->get_alarms_db($for_truck_trail));
  }

  public function get_all_alarms_db()
  {
    $alarmsData = $this->nicplace_l->get_all_alarms_db();
    foreach ($alarmsData as $key => $alarm) {
      $alarmsData[$key]['forTruck']  = self::htmlSelect((string)$alarm['forTruck'], 'for_truck', $alarm['alarm_id']);
      $alarmsData[$key]['forTrailer'] = self::htmlSelect((string)$alarm['forTrailer'], 'for_trailer', $alarm['alarm_id']);
      $alarmsData[$key]['ActiveStatus'] = self::htmlSelect((string)$alarm['status'], 'status', $alarm['alarm_id'], 'A-IN');
    }
    echo json_encode($alarmsData, JSON_THROW_ON_ERROR);
  }

    public static function htmlSelect(string $selected, string $setFor, int $alarmId, string $optionLabelType = 'Y-N'): string
    {
        $trueSelected['sel'] = $falseSelected['sel'] = '';
        $trueLabel = $optionLabelType === 'Y-N' ? 'Yes' : 'Active';
        $falseLabel = $optionLabelType === 'Y-N' ? 'No' : 'InActive';
        if ($selected === '1') {
            $trueSelected['sel'] = 'selected';
        } elseif ($selected === '0' || $selected === '-') {
            $falseSelected['sel'] = 'selected';
        }
        return '<select class="form-control alarmStatusChange" data-set_for="' . $setFor . '" data-alarm_id="' . $alarmId . '">
               <option value="1" ' . $trueSelected["sel"] . '>' . $trueLabel . '</option>
                <option value="0" ' . $falseSelected["sel"] . '>' . $falseLabel . '</option>
            </select>';
    }

  public function get_asset_db($truckNumber)
  {
    $where = ['name' => $truckNumber, 'status' => 1];
    $res   = $this->common->gettbldata($where, '*', 'tb_nic_assets', 0, 0);
    echo json_encode($res);
  }

  public function get_all_asset_db()
  {
    $where = ['status' => 1];
    $res   = $this->common->gettbldata($where, '*, IF(status=1, "Active", "Inactive") as ActiveStatus', 'tb_nic_assets', 0, 0);
    echo json_encode($res);
  }

  public function get_pois()
  {
    echo json_encode($this->nicplace_l->get_pois());
  }

  public function get_pois_db()
  {
    $res = $this->common->gettbldata(['status' => 1], '*', 'tb_nic_poi', 0, 0);
    echo json_encode($res);
  }

  public function get_tours_db()
  {
    $res = $this->common->gettbldata(['status' => 1], '*', 'tb_nic_tour', 0, 0);
    echo json_encode($res);
  }

  public function create_pois()
  {
    $order_id   = rand(5, 1000);
    $input_post = [
      "order_id"        => $order_id,
      "poi_name"        => $order_id . " HYD",
      "poi_street"      => "Gachibowli ramky towers",
      "poi_city"        => "hyderabad",
      "poi_country"     => "IN", // alpha-2
      "poi_postal_code" => "500032"
    ];

    $res = $this->nicplace_l->create_pois($input_post);
    echo json_encode($res);
  }

  public function create_tour($order_id)
  {
    $this->load->helper('string');
    if (isset($_REQUEST['v_id'])) {
      $vehnumchk = 'KE-KE 456';
    }

    log_error( "Roadlog driverid " . $vehnumchk);

    $assetdata = $this->nicplace_l->get_asset_db($vehnumchk);
    log_error( "Nicplace asserts " . json_encode($assetdata, 128));
    $asset_id    = $assetdata['asset_id']??null;
    $order_ordid = 569999;
    $p_ci        = 543;//random_string( 'numeric', 3 );
    $d_ci        = 217;//random_string( 'numeric', 3 );
    $alarms_data = $this->nicplace_l->get_alarms_db('for_trailer');
    $alarm_ids   = array_column($alarms_data, 'alarm_id');
    $input_post  = [
      'START_POI' => [
        "order_id"                => 'SPOI_' . $order_id,
        "poi_name"                => $p_ci . " HYD",
        "poi_customer_identifier" => $p_ci,
        "poi_street"              => "Gachibowli ramky towers",
        "poi_city"                => "hyderabad",
        "poi_country"             => "IN", // alpha-2
        "poi_postal_code"         => "500032"
      ],
      'END_POI'   => [
        "order_id"                => 'EPOI_' . $order_id,
        "poi_name"                => $d_ci . " VIZ",
        "poi_customer_identifier" => $d_ci,
        "poi_street"              => "RK Beach",
        "poi_city"                => "Vishakapatanam",
        "poi_country"             => "IN", // alpha-2
        "poi_postal_code"         => "530045"
      ],
      'TOUR_DATA' => [
        "order_id"                => $order_id,
        "tour_name"               => "SVK" . " HYD TO VIZ test 3",
        "asset_id"                => $asset_id,
        "pickup_late_datetime"    => date('Y-m-d\TH:i:s\Z', strtotime('+2 hour', strtotime(date('Y-m-d H:i:s')))),
        "pickup_early_datetime"   => date('Y-m-d\TH:i:s\Z'),
        "delivery_early_datetime" => date('Y-m-d\TH:i:s\Z', strtotime('+4 hour', strtotime(date('Y-m-d H:i:s')))),
        "ALARMS"                  => $alarm_ids,
        "request_for"             => "truck"
      ]
    ];

    log_error( "Nicplace input array " . json_encode($input_post, 128));
    $return = $this->nicplace_l->create_tour($input_post);
    log_error( "Nicplace return array " . json_encode($return, 128));
    $data_x = [
      'order_id'     => $order_ordid,
      'reference_id' => 'ORD_NICPLACE_TOUR_ID',
      'ref_value'    => $return['tour_id']??0,
      'status'       => 1,
      'createdon'    => date('Y-m-d H:i:s'),
      'updatedon'    => date('Y-m-d H:i:s'),
    ];
    $this->common->insertTableData('tb_order_references', $data_x);
//    log_error( "Nicplace tb_order_references " . $this->db->last_query());

    echo json_encode(array_merge(["order_id" => $order_id], $return));
    exit;
  }

  public function update_tour($order_id, $nicplace_ref_id)
  {
    $this->load->helper('string');
    if (isset($_REQUEST['v_id'])) {
      $vehnumchk = 'KE-KE 456';
    }

    log_error( "Roadlog driverid " . $vehnumchk);

    $assetdata = $this->nicplace_l->get_asset_db($vehnumchk);
    log_error( "Nicplace asserts " . json_encode($assetdata, 128));
    $asset_id    = $assetdata['asset_id']??null;
    $order_ordid = 569999;
    $p_ci        = 543;//random_string( 'numeric', 3 );
    $d_ci        = 217;//random_string( 'numeric', 3 );
    $alarms_data = $this->nicplace_l->get_alarms_db('for_truck');
    $alarm_ids   = array_column($alarms_data, 'alarm_id');
    $input_post  = [
      'START_POI' => [
        "order_id"                => 'SPOI_' . $order_id,
        "poi_name"                => $p_ci . " HYD",
        "poi_customer_identifier" => $p_ci,
        "poi_street"              => "Gachibowli ramky towers",
        "poi_city"                => "hyderabad",
        "poi_country"             => "IN", // alpha-2
        "poi_postal_code"         => "500032"
      ],
      'END_POI'   => [
        "order_id"                => 'EPOI_' . $order_id,
        "poi_name"                => $d_ci . " VIJZ",
        "poi_customer_identifier" => $d_ci,
        "poi_street"              => "RK Beach road",
        "poi_city"                => "Vishakapatanam",
        "poi_country"             => "IN", // alpha-2
        "poi_postal_code"         => "530045"
      ],
      'TOUR_DATA' => [
        "order_id"                => $order_id,
        "tour_name"               => "SVK" . " HYD TO VIZYY",
        "asset_id"                => $asset_id,
        "pickup_late_datetime"    => date('Y-m-d\TH:i:s\Z', strtotime('+2 hour', strtotime(date('Y-m-d H:i:s')))),
        "pickup_early_datetime"   => date('Y-m-d\TH:i:s\Z'),
        "delivery_early_datetime" => date('Y-m-d\TH:i:s\Z', strtotime('+4 hour', strtotime(date('Y-m-d H:i:s')))),
        "ALARMS"                  => $alarm_ids,
      ]
    ];

    log_error( "Nicplace input array " . json_encode($input_post, 128));
    $return = $this->nicplace_l->update_tour($input_post, $nicplace_ref_id);
    log_error( "Nicplace return array " . json_encode($return, 128));
    $data_x = [
      'order_id'     => $order_ordid,
      'reference_id' => 'ORD_NICPLACE_TOUR_ID',
      'ref_value'    => $return['tour_id']??0,
      'status'       => 1,
      'createdon'    => date('Y-m-d H:i:s'),
      'updatedon'    => date('Y-m-d H:i:s'),
    ];
    $this->common->insertTableData('tb_order_references', $data_x);
//    log_error( "Nicplace tb_order_references " . $this->db->last_query());

    echo json_encode(array_merge(["order_id" => $order_id], $return));
  }


  public function calledi($shift_id)
  {
    ini_set('max_execution_time', 1300);
   /* echo '{
    "status":1,
    "data":{
      "54439": [
                  {"status":1,"start_tour":1,"order_id":"5006072119_TRUCK","tour_id":"60f00c8b620f8f4d4cc9e21f","message":""},
                  {"status":1,"start_tour":1,"order_id":"5006072119_TRAILER","tour_id":"60f00cab620f8f4d4cc9e3bf","message":""}
                ],
      "54440": [
                  {"status":1,"start_tour":1,"order_id":"5006072120_TRUCK","tour_id":"60f00c8b620f8f4d4cc9e21f","message":"SUCCESS"},
                  {"status":1,"start_tour":1,"order_id":"5006072120_TRAILER","tour_id":"60f00cab620f8f4d4cc9e3bf","message":"SUCCESS"}
                ]
          },
    "message":"Transmission completed successfully"
    }';*/
    echo json_encode($this->getShipmentData($shift_id));
  }


  public function getShipmentData(int $shift_id)
  {
//    $res = ['status' => 0, 'message' => null];
    if ($shift_id != "") {
      $getOrderIds = $this->nicplacemodel->getOrderIds($shift_id);
      if ($getOrderIds) {
        $i = 0;
        do {
          $order_id = $getOrderIds[$i]['id'];
          $alreadyTriggered_rows = $this->nicplacemodel->checkOrderTriggerOrNot($getOrderIds[$i]['order_id'], $getOrderIds[$i]['user_id']);
          $nicplace_ref_row = $this->nicplacemodel->orderNicplaceRef($order_id);
          if ($alreadyTriggered_rows && count($alreadyTriggered_rows) >= count($nicplace_ref_row)) {
            foreach ($alreadyTriggered_rows as $alreadyTriggered) {
              $tour_status = $alreadyTriggered['tour_status'] ?: 'WAITING';
                $api_message[] = [
                  "status"     => 1,
                  "start_tour" => "<span class='" . nicplace_status_class($tour_status) . "'>" . $tour_status . "</span>",
                  "order_id"   => $alreadyTriggered['trip_id'].'_'.strtoupper($alreadyTriggered['request_for']), //$getOrderIds[$i]['order_id'].'_'.strtoupper($alreadyTriggered['request_for'])
                  "tour_id"    => $alreadyTriggered['tour_id'],
                  "message"    => "<span class=\"text-warning\">Already Triggered</span>"
                ];
            }
            $api_messages[$order_id] = $api_message;
            $success_flag = 2;
          } else {
            log_error("*************** order transmission to @Nicplace ***************" . $order_id);
            $nicplace_api_response = $this->triggerEdi($order_id);
            $success_flag = array_product(array_column($nicplace_api_response, 'status'));
            $api_messages[$order_id] = $nicplace_api_response;
          }
          $i++;
        } while ($i < count($getOrderIds));

        switch ($success_flag) {
          case 1 :
            $message = 'Transmission completed successfully';
            break;
          case 0:
            $message = 'Transmission Failed';
            break;
          case 2:
            $message = 'Transmission already triggered';
            break;
          default:
            $message = 'Something went wrong';
        }
        return ['status' => $success_flag, 'data' => $api_messages, 'message' => $message];
      } else {
        return ['status' => 0, 'message' => 'No orders found.'];
      }
    } else {
      return ['status' => 0, 'message' => 'invalid shipment id'];
    }
  }

  public function triggerEdi($order_id_pk):array
  {
    $order_details = $this->nicplacemodel->getOrderDetails($order_id_pk);
    $vehicle_driver_ids = $this->edistatusprocess->get_vehicle_info($order_details['shift_id']);
    $truck_vehicle_number = $trailer_vehicle_number = '';
    if (!empty($vehicle_driver_ids)) {
      $vehicle_info = $this->common->gettblrowdata(['id' => $vehicle_driver_ids['vehicle_id']], 'id, truck_number as trailer_num, register_number as truck_num', 'tb_trucks_data', 0, 0);
      if(!empty($vehicle_info)){
        $truck_vehicle_number = $vehicle_info['truck_num'];
        $trailer_vehicle_number = $vehicle_info['trailer_num'];
      }
    }
    //return 0;

    $nicplace_data = [
      'nic_vehical_num'        => $truck_vehicle_number,
      'nic_orderid'            => $order_details['order_id'], // order generated id
      'nic_pickup_ci'          => $order_details['pickup_custid'],
      'nic_pickup_company'     => $order_details['pickup'],
      'nic_pickup_address'     => $order_details['pickup_address1'],
      'nic_pickup_address1'    => $order_details['pickup_address2'],
      'nic_pickup_city'        => $order_details['pickup_city'],
      'nic_pickup_countrycode' => $this->country_master_data_validator->validate_country((string)$order_details['pickup_country'], true),
      'nic_pickup_postal'      => $order_details['pickup_pincode'],
      'nic_drop_ci'            => $order_details['drop_custid'],
      'nic_drop_company'       => $order_details['delivery'],
      'nic_drop_address'       => $order_details['delivery_address1'],
      'nic_drop_address1'      => $order_details['delivery_address2'],
      'nic_drop_city'          => $order_details['delivery_city'],
      'nic_drop_countrycode'   => $this->country_master_data_validator->validate_country((string)$order_details['delivery_country'], true),
      'nic_drop_postal'        => $order_details['delivery_pincode'],
      'nic_pickup_datetime'    => $order_details['pickup_datetime'],
      'nic_delivery_datetime'  => $order_details['delivery_datetime'],
      'nic_ord_id'             => $order_details['id'], //Order primary key
      'nic_ship_id'            => $order_details['shift_id'],
      'nic_sendercmpcode'      => $order_details['company_code'],
      'nic_serviceproduct'     => $order_details['product'],
      'nic_carrier_code'       => $order_details['carrier_code']
    ];

//    log_error('Nicplace details :: ' . beautifyJSON(json_encode($nicplace_data)));

    $nicplace_ref_row = $this->nicplacemodel->orderNicplaceRef($nicplace_data['nic_ord_id']);
    if (! empty($nicplace_ref_row)) {
      $nicplace_update_flag = 1;
    } else {
      log_error('order existed but not existed in nicplace');
      $nicplace_update_flag = 0;
    }
    if ($nicplace_update_flag == 1) {
      log_error('nicplace_ref_row '.PHP_EOL.json_encode($nicplace_ref_row,128));
      foreach ($nicplace_ref_row as $row) {
        log_error('ref form update ' . $row['ref_value']);
        $ref_belongs_to = $row['ref_belongs_to'];
        log_error(PHP_EOL.'ref_belongs_to'. $ref_belongs_to);
        $nicplace_data['ref_pk_id'] = $row['ref_pk_id'];
        if($row['ref_value']) {
          $nicplace_data['nic_vehical_num'] = ($ref_belongs_to == 'trailer' && $truck_vehicle_number != "" && $trailer_vehicle_number != "" && $truck_vehicle_number != $trailer_vehicle_number) ? $trailer_vehicle_number : $truck_vehicle_number;
          log_error('nicplace data '.json_encode($nicplace_data,128));
          $response[] = $this->nicplaceRequest('UPDATE', $nicplace_data, $ref_belongs_to, $row['ref_value']);
        }else{
          $response[] = $this->nicplaceRequest('CREATE', $nicplace_data, $ref_belongs_to);
        }
      }
    } else {
      $response[] = $this->nicplaceRequest('CREATE', $nicplace_data);
      if ($truck_vehicle_number != $trailer_vehicle_number && $truck_vehicle_number != '' && $trailer_vehicle_number != '') {
        $nicplace_data['nic_vehical_num'] = $trailer_vehicle_number;
        $response[] = $this->nicplaceRequest('CREATE', $nicplace_data, 'trailer');
      }
    }
    return $response;
  }

  public function get_tour(string $id)
  {
    echo json_encode($this->nicplace_l->get_tour($id));
  }

  public function sync_assets()
  {
    $assets_in = $asset_existed_ids = [];
    $assets_data       = $this->nicplace_l->get_assets();
    $asset_ids         = array_column($assets_data, 'id');
    if (empty($asset_ids)) {
      echo "<span class='toast-body'> Error No response form nicplace </span>" . PHP_EOL;
    } else {
      $asset_existed_ids = array_column($this->common->gettbldata_where_in([],["col" => "asset_id", "arr" => $asset_ids],'asset_id','tb_nic_assets'),'asset_id');
    }

    $obj = [];
    foreach (array_diff($asset_ids, $asset_existed_ids) as $not_existed_id) {
      $obj[$not_existed_id] = true;
    }

    foreach ($assets_data as $asset) {
      if ($obj[$asset['id']]) {
        $assets_in[] = [
          "asset_id"            => $asset['id'],
          "name"                => $asset['name'],
          "service_provider_id" => $asset['serviceProviderId']??0
        ];
      }
    }

    $alarm_existed_ids = [];
    $alarms_data       = $this->nicplace_l->get_alarms();
    $alarm_ids         = array_column($alarms_data, 'id');
    if (empty($alarm_ids)) {
       echo "<span class='toast-body'> Error No response form nicplace </span>" . PHP_EOL;
    } else {
      $alarm_existed_ids = array_column($this->common->gettbldata_where_in([], ["col" => "alarm_id", "arr" => $alarm_ids], 'alarm_id', 'tb_nic_alarms'), 'alarm_id');
    }
    $alarms_in         = [];

    $obj_ala = [];
    foreach (array_diff($alarm_ids, $alarm_existed_ids) as $not_existed_id_ala) {
      $obj_ala[$not_existed_id_ala] = true;
    }

    foreach ($alarms_data as $ala) {
      if ($obj_ala[$ala['id']]) {
        $alarms_in[] = [
          "alarm_id" => $ala['id'],
          "name"     => $ala['name']
        ];
      }
    }


    log_error( 'Error Message assets_in ' . json_encode($assets_in, 128));
    log_error( 'Error Message alarms_in ' . json_encode($alarms_in, 128));
    if (! empty($assets_in)) {
      $this->common->insertbulk("tb_nic_assets", $assets_in);
      echo "<span class='toast-body'>" . count($assets_in) . " newly added by sync assets </span>" . PHP_EOL;
      log_error( 'Nicplace -> sync_assets (215) -> ' . count($assets_in) . ' newly added by sync assets');
    } else {
      echo "<span class='toast-body'>no new assets...</span>" . PHP_EOL;
    }

    if (! empty($alarms_in)) {
      $this->common->insertbulk("tb_nic_alarms", $alarms_in);
      echo "<span class='toast-body'>" . count($alarms_in) . " newly added by sync alarms " . PHP_EOL;
      log_error( 'Nicplace -> sync_alarms (215) -> ' . count($alarms_in) . ' newly added by sync alarms');
    } else {
      echo "<span class='toast-body'>no new alarms... </span>" . PHP_EOL;
    }
  }

  public function configAlarms()
  {
    $alarmDBData = $this->common->gettbldata(['status' => 1], '*', 'tb_nic_alarms', 0, 0);

    $keyword = 'test';
    // we will set test mode and prod mode note: this is only configuration for alarms not use anywhere
    if ($_GET['env'] !== 'development') {
      $alarmNamePreFix = '';
      $testAlarms = 0;
      $liveAlarms = 1;
    } else {
      $alarmNamePreFix = 'Test_';
      $testAlarms = 1;
      $liveAlarms = 0;
    }
    $this->common->updatetbledata('tb_nic_alarms', ['status' => $testAlarms], "name LIKE '%$keyword%'");
    $this->common->updatetbledata('tb_nic_alarms', ['status' => $liveAlarms], "name not LIKE '%$keyword%'");

    $alarmConfigArr = [
      ['alarmName' => $alarmNamePreFix.'Trailer_Powerloss', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Trailer_unarmed', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Truck_Trailer_BackupPowerloss', 'for_trailer' => 1, 'for_truck' => 1],
      ['alarmName' => $alarmNamePreFix.'Truck_PanicButton', 'for_trailer' => 0, 'for_truck' => 1],
      ['alarmName' => $alarmNamePreFix.'Trailer_DoorStatus', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Trailer_DoorCloseEvent', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Truck_Trailer_NoMovement', 'for_trailer' => 1, 'for_truck' => 1],
      ['alarmName' => $alarmNamePreFix.'Trailer_DoorOpenEvent', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Truck_Powerloss', 'for_trailer' => 0, 'for_truck' => 1],
      ['alarmName' => $alarmNamePreFix.'Truck_Trailer_NoData', 'for_trailer' => 1, 'for_truck' => 1],
      ['alarmName' => $alarmNamePreFix.'Trailer_Armed', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Trailer_Intrusion', 'for_trailer' => 1, 'for_truck' => 0],
      ['alarmName' => $alarmNamePreFix.'Truck_CoupledUncoupled', 'for_trailer' => 0, 'for_truck' => 1],
    ];

    foreach ($alarmDBData as $alarmDBDatum) {
      $alarmDBDataConfigFlag[$alarmDBDatum['name']] = $alarmDBDatum['alarm_id'];
    }
    foreach ($alarmConfigArr as $alarmConfig) {
      if ($alarmConfig['for_trailer']) {
        $trailerArray[] = array('alarmID' => $alarmDBDataConfigFlag[$alarmConfig['alarmName']], 'alarmName' => $alarmConfig['alarmName']);
      }
      if ($alarmConfig['for_truck']) {
        $truckArray[] = array('alarmID' => $alarmDBDataConfigFlag[$alarmConfig['alarmName']], 'alarmName' => $alarmConfig['alarmName']);
      }
    }

    $trailerWhereIn = ['col' => 'alarm_id', 'arr' => array_column($trailerArray, 'alarmID')];
    $truckWhereIn = ['col' => 'alarm_id', 'arr' => array_column($truckArray, 'alarmID')];
    $this->common->updatetbledata_where_in('tb_nic_alarms', ['for_trailer' => 1], $trailerWhereIn, ['status' => 1]);
    $this->common->updatetbledata_where_in('tb_nic_alarms', ['for_truck' => 1], $truckWhereIn, ['status' => 1]);

    echo 'Alarms has been configured';
  }

  public function updateAlarm($alarmId, $forAlarm, $setFlag)
  {
    $set   = [$forAlarm => $setFlag];
    if ($this->common->updatetbledata('tb_nic_alarms', $set, ['alarm_id' => $alarmId])) {
      echo "<span class='toast-body'><i>" .
                $alarmId . "</i> Alarm ID was set to <b>". str_replace('_', ' ', $forAlarm).'</b>
            </span>';
    }
  }

  public function nicplaceRequest(
    string $actionType,
    array $inputPost,
    string $vehicleType = 'truck',
    string $nicplaceRefId = null
  ): array
  {
    $return = ['status' => 0, 'message' => 'Something went wrong'];
    $chkaccept = $this->common->gettblrowdata([
        'order_id' => $inputPost['nic_ord_id'],
        'shipment_id' => $inputPost['nic_ship_id'],
        'status_code' => '0212',
        'status' => '1'
    ], 'id', 'tb_stop_status', 0, 0);
    if (count($chkaccept) !== 0
        && $inputPost['nic_serviceproduct'] === 'KN Secure Chain'
        && $inputPost['nic_sendercmpcode'] === 'PLKN' ) {
      $this->load->library("nicplace_l");
      $assetdata = $this->nicplace_l->get_asset_db($inputPost['nic_vehical_num']);
      $asset_id = $assetdata['asset_id'] ?? null;
      $alarms_data = $this->nicplace_l->get_alarms_db('for_' . $vehicleType);
      if (empty($this->nicplacemodel->checkAtromAlarm((int)$inputPost['nic_carrier_code'], $inputPost['nic_sendercmpcode'], self::ALARM_EXCEPTION_CARRIER_RULE))) {
        foreach ($alarms_data as $key => $alarm) {
          if ($alarm['name'] === self::ALARM_EXCEPTION_RULE) {
            unset($alarms_data[$key]);
          }
        }
        log_error('\n alarm data after remove =>' . json_encode($alarms_data, 128));
      }
      $alarm_ids = array_column($alarms_data, 'alarm_id');
      $input_post = [
        'START_POI' => [
          "order_id"                => 'SPOI_' . $inputPost['nic_orderid'],
          "poi_name"                => $inputPost['nic_pickup_company'],
          "poi_customer_identifier" => $inputPost['nic_pickup_ci'],
          "poi_street"              => $inputPost['nic_pickup_address1'],
          "poi_city"                => $inputPost['nic_pickup_city'],
          "poi_country"             => $inputPost['nic_pickup_countrycode'], // alpha-2
          "poi_postal_code"         => $inputPost['nic_pickup_postal']
        ],
        'END_POI'   => [
          "order_id"                => 'EPOI_' . $inputPost['nic_orderid'],
          "poi_name"                => $inputPost['nic_drop_company'],
          "poi_customer_identifier" => $inputPost['nic_drop_ci'],
          "poi_street"              => $inputPost['nic_drop_address1'],
          "poi_city"                => $inputPost['nic_drop_city'],
          "poi_country"             => $inputPost['nic_drop_city'], // alpha-2
          "poi_postal_code"         => $inputPost['nic_drop_postal']
        ],
        'TOUR_DATA' => [
          "order_id"                => $inputPost['nic_orderid'],
          "tour_name"               => 'KN ' . $inputPost['nic_pickup_address'] . " TO " . $inputPost['nic_drop_address'],
          "asset_id"                => $asset_id,
          "pickup_late_datetime"    => date('Y-m-d\TH:i:s\Z', strtotime($inputPost['nic_pickup_datetime'])),
          "pickup_early_datetime"   => date('Y-m-d\TH:i:s\Z', strtotime($inputPost['nic_pickup_datetime'])),
          "delivery_early_datetime" => date('Y-m-d\TH:i:s\Z', strtotime($inputPost['nic_delivery_datetime'])),
          "ALARMS"                  => $alarm_ids,
          "request_for"             => $vehicleType,
          "ref_pk_id"               => $inputPost['ref_pk_id'] ?? null,
          "carrier_code"            => $inputPost['nic_carrier_code']
        ]
      ];

      if ($actionType === 'CREATE') {
        $params = array('externalId' => $inputPost['nic_orderid'].'_'. strtoupper($vehicleType));
        $nicplaceOrderExisted = $return = $this->nicplace_l->checkTourByOrderId($params, true);
        log_error('nicplace checkTourOrder '.json_encode(count($nicplaceOrderExisted),128));
        if (!empty($nicplaceOrderExisted)) {
          log_error('Order existed in nicplace-server');
          $ref_input_data = ['nic_ord_id' => $inputPost['nic_ord_id'], 'request_for' => $vehicleType, 'tour_id' => $nicplaceOrderExisted['tour_id']];

          $this->nicplace_l->refOrderTours( $ref_input_data, 'insertTableData', $inputPost['ref_pk_id']);
        }else{
          $return = $this->nicplace_l->create_tour($input_post);
        }
        log_error("Nic-place return array create" . json_encode($return, 128));
      } elseif ($actionType === 'UPDATE') {
        $return = $this->nicplace_l->update_tour($input_post, $nicplaceRefId);
        log_error('nic-place update returns' . json_encode($return, 128));
      }
    } else {
      $tour_status = 'N/A';
      $return = [
        "status"     => 0,
        "start_tour" => "<span class='" . nicplace_status_class($tour_status) . "'>" . $tour_status . "</span>",
        "order_id"   => $inputPost['nic_orderid'] . '_' . strtoupper($vehicleType) ?? 'N/A',
        "tour_id"    => 'N/A',
        "message"    => "<span class=\"text-danger\">Condition for NicPlace transmission not met</span>"
      ];
      log_error('Trip not accepted for this order => ' . $inputPost['nic_ord_id']);
    }
    return $return;
  }

  public function getTour($order_id)
  {
    $params = array('externalId' => $order_id);
    $tourData = $this->nicplace_l->checkTourByOrderId($params);
    echo json_encode($tourData, 128);
  }

  public function deleteTour($order_id)
  {
    $params = array('externalId' => $order_id);
    $tourData = $this->nicplace_l->checkTourByOrderId($params);
    $i = 0;
    foreach ($tourData as $tourDatum) {
      echo $i . ' -> ' . $tourDatum['id'] . ' => ' . $tourDatum['externalId'] . '<br>';
      $this->nicplace_l->deleteTour($tourDatum['id']);
      $i++;
    }
  }

  public function tourAction($order_id, $action = 'start')
  {
    $params = array('externalId' => $order_id);
    $tourData = $this->nicplace_l->checkTourByOrderId($params);
    $i = 0;
    foreach ($tourData as $tourDatum) {
      echo $i . ' -> ' . $tourDatum['id'] . ' => ' . $tourDatum['externalId'] . '<br>';
      $this->nicplace_l->tourAction($tourDatum['id'], $action);
      $i++;
    }
  }

}
