<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Nicplacetransactions extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    if ($this->session->userdata('user_id') == "") {
      redirect("login");
    }
    $this->load->model("common");
    $this->load->model("Editransactionsmodel");
    $this->load->model("Nicplacetransactionsmodel");
  }

  public function index()
  {
    $data         = $whr = $wher = $getdata = $object_types = [];
    $company_code = $this->session->userdata('company_code');
    $user_id      = $this->session->userdata('user_id');

    $data["page_title"] = "Nicplace Transaction";
    $data["sub_title"]  = $this->lang->line('general_search');
    $data["services"]   = [];
    $post               = $this->input->post();
    $whr                = [];
    if (! empty($post)) {
      $bounded_type = $this->input->post('bound_type', true);
      if (isset($post['obj_type']) && $post['obj_type'] != "") {
        $wher['ee.edi_id'] = $post['obj_type'];
      }
      if (isset($post['status']) && $post['status'] != "") {
        $wher['ee.status'] = $post['status'];
      }
      if (isset($post['txn_obj_id']) && $post['txn_obj_id'] != "") {
        $whr['ee.txn_obj_id'] = $post['txn_obj_id'];
      }

      if (isset($post['from_date']) && $post['from_date'] != "") {
        $fromdate1                                        = date('Y-m-d', strtotime($post['from_date']));
        $wher["DATE_FORMAT(ee.created_on,'%Y-%m-%d') >="] = $fromdate1;
      }
      if (isset($post['to_date']) && $post['to_date'] != "") {
        $todate1                                          = date('Y-m-d', strtotime($post['to_date']));
        $wher["DATE_FORMAT(ee.created_on,'%Y-%m-%d') <="] = $todate1;
      }
      if ($bounded_type != 0) {
        $wher['ee.bounded_type'] = $bounded_type;
      }
      $wher['edi_name'] = 'NICPLACE'; // only for nicplace
      $country_userids = $this->session->userdata("country_user_ids");
      $getdata         = $this->Nicplacetransactionsmodel->getedidata($wher, $whr, $country_userids, $company_code, $user_id);
    }

    $object_types = $this->common->gettbldata(['edi_name' => 'NICPLACE', 'status' => 1], 'id,edi_name', 'tb_edi_types', 0, 0);

    $data['object_types'] = $object_types;
    $data['getdata']      = $getdata;
    $data['company_code'] = $company_code;
    $this->newtemplate->dashboard("nicplacetransactions/index", $data);
  }

  public function getbounddata()
  {
    $post    = $this->input->post();
    $id      = $post['id']??0;
    $poiFlag = $post['poiFlag'];
    if ($poiFlag == true) {
      $where   = ['poi_id' => $id];
      $getdata = $this->common->gettblrowdata($where, 'poi_request as request, poi_response as response', 'tb_nic_poi', 0, 0);
    } else {
      $where   = ['id' => $id];
      $getdata = $this->common->gettblrowdata($where, 'tour_request as request, tour_response as response', 'tb_nic_tour', 0, 0);
    }
    echo json_encode($getdata, JSON_PRETTY_PRINT);
  }

  public function getalarms(): void
  {
    $ids = $this->input->post('ids', true);
    if (! empty($ids)) {
      $where_in = [
        'col' => 'alarm_id',
        'arr' => json_decode($ids, true)
      ];
      $getdata  = $this->common->gettbldata_where_in(['status !=' => ''], $where_in, 'alarm_id, name, IF(status=1, "Active", "Inactive") as status', 'tb_nic_alarms');
    }
    echo json_encode($getdata, JSON_PRETTY_PRINT);
  }
}
