<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Orderlistspecification extends CI_Controller {
 
    public function __Construct() {
        parent::__Construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("smtcorder");
        $this->load->model("customerprofilemodel");
    }

    public function index() {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cust_search');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;

        $data['cust_apl_cols'] = $this->common->getorderlistspecs();
        $this->newtemplate->dashboard("orderlistspecs/index", $data);
    }

    public function add()
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('general_add');
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');
        if (checkAccessConditions('RELATED_2_SG_MY', $data['company_code'])) {
            $data["selected_columns"] = [
                'Booking ID',
                'Delivery Note',
                /*'SALOG Ref',*/
                'Customer Name',
                'Pickup',
                'Delivery',
                'Trip No',
                'Status',
                'Other Status',
                'Created Date',
                'Pickup Date',
                'Estimated Delivery Date',
                'Delivery Date',
                'Mode Of Transport',
                'Vehicle Type',
                'Vehicle Number',
                'Total Packages',
                'JFR',
                'Billing Status',
                'Actual Weight',
                'Weight',
                'Actual Volume',
                'Volume',
                'Company Code',
                'Branch Code',
                'From Source',
                'Booking Updated',
                "Payment Ref",
                "External Customer"
            ];
            $data["columns"] = [
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'trip_no' => "Trip No",
                'status' => "Status",
                'other_status' => "Other Status",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'vehicle_type' => "Vehicle Type",
                'vehicle_number' => "Vehicle Number",
                'total_packages' => "Total Packages",
                'order_jfr' => 'JFR',
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        } else {
            $data["selected_columns"] = [
                'S.No',
                'Booking ID',
                'Delivery Note',
                'Booking Created By',
                /*'SALOG Ref',*/
                'Customer Name',
                'Vendor Name',
                'Container no',
                'KN origin reference',
                'Load plan connot',
                'Pickup',
                'Delivery',
                'Delivery city',
                'Trip No',
                'Status',
                'Manifest no',
                'Other Status',
                'Stoppage',
                'Created Date',
                'Pickup Date',
                'Estimated Delivery Date',
                'Delivery Date',
                'Mode Of Transport',
                'Department',
                'Total Packages',
                'Scanned Quantity',
                'Number of pallets',
                'Billing Status',
                'Actual Weight',
                'Weight',
                'Actual Volume',
                'Volume',
                'POD',
                'JFR',
                'Company Code',
                'Branch Code',
                'From Source',
                'booking_updated_date',
                "Payment Ref",
                "External Customer"
            ];
            $data["columns"] = [
                's_no' => "S.No",
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                'booking_creat_by' => "Booking Created By",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'vendor_name' => "Vendor Name",
                'container_no' => "Container no",
                'pos_ref' => "KN origin reference",
                'loadplanconnote' => "Load plan connot",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'deliverycity' => "Delivery city",
                'trip_no' => "Trip No",
                'status' => "Status",
                'manifest_no' => "Manifest no",
                'other_status' => "Other Status",
                'Stoppage' => "Stoppage",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'department' => "Department",
                'total_packages' => "Total Packages",
                'scanned_quantity' => "Scanned Quantity",
                'no_of_pallets' => "Number of pallets",
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'pod' => "POD",
                'order_jfr' => 'JFR',
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        }
        //$this->newtemplate->dashboard("orderlistspecs/add", $data);
        $this->load->view("orderlistspecs/add", $data);
    }


    public function edit(int $id)
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');
        $data['code'] = $data['name'] = "";
        $data["custaprlcols"] = [];
        $getcustaprlcols = $this->common->gettblrowdata(['id' => $id], '*', 'tb_orderlist_spec_cols', 0, 0);
        if (!empty($getcustaprlcols)) {
            $data['custaprlcols'] = $getcustaprlcols;
        }
        if (checkAccessConditions('RELATED_2_SG_MY', $data['company_code'])) {
            $data["columns"] = [
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'trip_no' => "Trip No",
                'status' => "Status",
                'other_status' => "Other Status",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'vehicle_type' => "Vehicle Type",
                'vehicle_number' => "Vehicle Number",
                'total_packages' => "Total Packages",
                'order_jfr' => "JFR",
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        } else {
            $data["columns"] = [
                's_no' => "S.No",
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                'booking_creat_by' => "Booking Created By",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'vendor_name' => "Vendor Name",
                'container_no' => "Container no",
                'pos_ref' => "KN origin reference",
                'loadplanconnote' => "Load plan connot",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'deliverycity' => "Delivery city",
                'trip_no' => "Trip No",
                'status' => "Status",
                'manifest_no' => "Manifest no",
                'other_status' => "Other Status",
                'Stoppage' => "Stoppage",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'department' => "Department",
                'total_packages' => "Total Packages",
                'scanned_quantity' => "Scanned Quantity",
                'no_of_pallets' => "Number of pallets",
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'pod' => "POD",
                'order_jfr' => 'JFR',
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        }
        //$this->newtemplate->dashboard("orderlistspecs/edit", $data);
        $this->load->view("orderlistspecs/edit", $data);
    }

    public function view(int $id)
    {
        $data["page_title"] = $this->lang->line('order_list_spec');
        $data["sub_title"] = $this->lang->line('cutomer_edit');
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');
        $data['code'] = $data['name'] = "";
        $data["custaprlcols"] = [];
        $getcustaprlcols = $this->common->gettblrowdata(['id' => $id], '*', 'tb_orderlist_spec_cols', 0, 0);
        if (!empty($getcustaprlcols)) {
            $data['custaprlcols'] = $getcustaprlcols;
        }
        if (checkAccessConditions('RELATED_2_SG_MY', $data['company_code'])) {
            $data["columns"] = [
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'trip_no' => "Trip No",
                'status' => "Status",
                'other_status' => "Other Status",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'vehicle_type' => "Vehicle Type",
                'vehicle_number' => "Vehicle Number",
                'total_packages' => "Total Packages",
                'order_jfr' => 'JFR',
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        } else {
            $data["columns"] = [
                's_no' => "S.No",
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                'booking_creat_by' => "Booking Created By",
                /*'salog_ref' => "SALOG Ref",*/

                'customer_name' => "Customer Name",
                'vendor_name' => "Vendor Name",
                'container_no' => "Container no",
                'pos_ref' => "KN origin reference",
                'loadplanconnote' => "Load plan connot",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'deliverycity' => "Delivery city",
                'trip_no' => "Trip No",
                'status' => "Status",
                'manifest_no' => "Manifest no",
                'other_status' => "Other Status",
                'Stoppage' => "Stoppage",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'department' => "Department",
                'total_packages' => "Total Packages",
                'scanned_quantity' => "Scanned Quantity",
                'no_of_pallets' => "Number of pallets",
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'pod' => "POD",
                'order_jfr' => 'JFR',
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref' => "Payment Ref",
                'external_customer' => "External Customer"
            ];
        }
        //$this->newtemplate->dashboard("orderlistspecs/view", $data);
        $this->load->view("orderlistspecs/view", $data);
    }

    public function delete($id) {
        if ($id != '' && is_numeric($id)) {
            $update = $this->db->where(array('id' => $id))->update('tb_orderlist_spec_cols', array('is_active' => 0));
            if ($update) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save() {
        //$post = $this->input->post();
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $company_code =  $session_company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $curdt = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $childid = $this->session->userdata('childid');
        if($childid == ''){
            $childid=0;
        }
        $custaprl_id = (isset($post['custaprl_id']) && !empty($post['custaprl_id'])) ? ($post['custaprl_id']) : 0;
        $ord_id = (isset($post['ord_id']) && !empty($post['ord_id'])) ? ($post['ord_id']) : 0;
        $s_no = (isset($post['s_no']) && !empty($post['s_no'])) ? ($post['s_no']) : 0;
        $Stoppage = (isset($post['Stoppage']) && !empty($post['Stoppage'])) ? ($post['Stoppage']) : 0;
        $delivery_note = (isset($post['delivery_note']) && !empty($post['delivery_note'])) ? ($post['delivery_note']) : 0;
        $salog_ref = (isset($post['salog_ref']) && !empty($post['salog_ref'])) ? ($post['salog_ref']) : 0;
        $pickup = (isset($post['pickup']) && !empty($post['pickup'])) ? ($post['pickup']) : 0;
        $delivery = (isset($post['delivery']) && !empty($post['delivery'])) ? ($post['delivery']) : 0;
        $status = (isset($post['status']) && !empty($post['status'])) ? ($post['status']) : 0;
        $trip_no = (isset($post['trip_no']) && !empty($post['trip_no'])) ? ($post['trip_no']) : 0;
        $other_status = (isset($post['other_status']) && !empty($post['other_status'])) ? ($post['other_status']) : 0;
        $created_date = (isset($post['created_date']) && !empty($post['created_date'])) ? ($post['created_date']) : 0;
        $pickup_date = (isset($post['pickup_date']) && !empty($post['pickup_date'])) ? ($post['pickup_date']) : 0;
        $estimated_delivery_date = (isset($post['estimated_delivery_date']) && !empty($post['estimated_delivery_date'])) ? ($post['estimated_delivery_date']) : 0;
        $delivery_date = (isset($post['delivery_date']) && !empty($post['delivery_date'])) ? ($post['delivery_date']) : 0;
        $mode_of_transport = (isset($post['mode_of_transport']) && !empty($post['mode_of_transport'])) ? ($post['mode_of_transport']) : 0;
        $total_packages = (isset($post['total_packages']) && !empty($post['total_packages'])) ? ($post['total_packages']) : 0;
        $billing_status = (isset($post['billing_status']) && !empty($post['billing_status'])) ? ($post['billing_status']) : 0;
        $actual_weight = (isset($post['actual_weight']) && !empty($post['actual_weight'])) ? ($post['actual_weight']) : 0;
        $jfr = (isset($post['order_jfr']) && !empty($post['order_jfr'])) ? ($post['order_jfr']) : 0;
        $weight = (isset($post['weight']) && !empty($post['weight'])) ? ($post['weight']) : 0;
        $actual_volume = (isset($post['actual_volume']) && !empty($post['actual_volume'])) ? ($post['actual_volume']) : 0;
        $volume = (isset($post['volume']) && !empty($post['volume'])) ? ($post['volume']) : 0;
        $assigned_to = (isset($post['assigned_to']) && !empty($post['assigned_to'])) ? ($post['assigned_to']) : 0;
        $company_code=(isset($post['company_code']) && !empty($post['company_code'])) ? ($post['company_code']) : 0;
        $branch_code=(isset($post['branch_code']) && !empty($post['branch_code'])) ? ($post['branch_code']) : 0;
        $from_source=(isset($post['from_source']) && !empty($post['from_source'])) ? ($post['from_source']) : 0;
        $manifest_no=(isset($post['manifest_no']) && !empty($post['manifest_no'])) ? ($post['manifest_no']) : 0;
        $scanned_quantity=(isset($post['scanned_quantity']) && !empty($post['scanned_quantity'])) ? ($post['scanned_quantity']) : 0;
        $no_of_pallets=(isset($post['no_of_pallets']) && !empty($post['no_of_pallets'])) ? ($post['no_of_pallets']) : 0;
        $pod=(isset($post['pod']) && !empty($post['pod'])) ? ($post['pod']) : 0;
        $department=(isset($post['department']) && !empty($post['department'])) ? ($post['department']) : 0;
        $pq_ref = (isset($post['pq_ref']) && !empty($post['pq_ref'])) ? ($post['pq_ref']) : 0;
        $external_customer = (isset($post['external_customer']) && !empty($post['external_customer'])) ? ($post['external_customer']) : 0;
        $booking_creat_by = $post['booking_creat_by'] ?? 0;
        $customer_name = $post['customer_name'] ?? 0;
        $deliverycity = $post['deliverycity'] ?? 0;
        $vendor_name = $post['vendor_name'] ?? 0;
        $pos_ref = $post['pos_ref'] ?? 0;
        $container_no = $post['container_no'] ?? 0;
        $loadplanconnote = $post['loadplanconnote'] ?? 0;
        $bookingUpdatedDate = $post['booking_updated_date'] ?? 0;
        $vehicleNumber = $post['vehicle_number'] ?? 0;
        $vehicleType = $post['vehicle_type'] ?? 0;
        $customerName = $post['customer_name'] ?? 0;

        /******* Sequence  *********/
        $ord_id_seq = (isset($post['ord_id_seq']) && !empty($post['ord_id_seq'])) ? ($post['ord_id_seq']) : 0;
        $s_no_seq = (isset($post['s_no_seq']) && !empty($post['s_no_seq'])) ? ($post['s_no_seq']) : 0;
        $order_jfr_seq = (isset($post['order_jfr_seq']) && !empty($post['order_jfr_seq'])) ? ($post['order_jfr_seq']) : 0;
        $Stoppage_seq = (isset($post['Stoppage_seq']) && !empty($post['Stoppage_seq'])) ? ($post['Stoppage_seq']) : 0;
        $delivery_note_seq = (isset($post['delivery_note_seq']) && !empty($post['delivery_note_seq'])) ? ($post['delivery_note_seq']) : 0;
        $salog_ref_seq = (isset($post['salog_ref_seq']) && !empty($post['salog_ref_seq'])) ? ($post['salog_ref_seq']) : 0;

        $pickup_seq = (isset($post['pickup_seq']) && !empty($post['pickup_seq'])) ? ($post['pickup_seq']) : 0;
        $delivery_seq = (isset($post['delivery_seq']) && !empty($post['delivery_seq'])) ? ($post['delivery_seq']) : 0;
        $trip_no_seq = (isset($post['trip_no_seq']) && !empty($post['trip_no_seq'])) ? ($post['trip_no_seq']) : 0;
        $status_seq = (isset($post['status_seq']) && !empty($post['status_seq'])) ? ($post['status_seq']) : 0;
        $other_status_seq = (isset($post['other_status_seq']) && !empty($post['other_status_seq'])) ? ($post['other_status_seq']) : 0;
        $created_date_seq = (isset($post['created_date_seq']) && !empty($post['created_date_seq'])) ? ($post['created_date_seq']) : 0;
        $pickup_date_seq = (isset($post['pickup_date_seq']) && !empty($post['pickup_date_seq'])) ? ($post['pickup_date_seq']) : 0;
        $estimated_delivery_date_seq = (isset($post['estimated_delivery_date_seq']) && !empty($post['estimated_delivery_date_seq'])) ? ($post['estimated_delivery_date_seq']) : 0;
        $delivery_date_seq = (isset($post['delivery_date_seq']) && !empty($post['delivery_date_seq'])) ? ($post['delivery_date_seq']) : 0;
        $mode_of_transport_seq = (isset($post['mode_of_transport_seq']) && !empty($post['mode_of_transport_seq'])) ? ($post['mode_of_transport_seq']) : 0;
        $total_packages_seq = (isset($post['total_packages_seq']) && !empty($post['total_packages_seq'])) ? ($post['total_packages_seq']) : 0;
        $billing_status_seq = (isset($post['billing_status_seq']) && !empty($post['billing_status_seq'])) ? ($post['billing_status_seq']) : 0;
        $actual_weight_seq = (isset($post['actual_weight_seq']) && !empty($post['actual_weight_seq'])) ? ($post['actual_weight_seq']) : 0;
        $weight_seq = (isset($post['weight_seq']) && !empty($post['weight_seq'])) ? ($post['weight_seq']) : 0;
        $actual_volume_seq = (isset($post['actual_volume_seq']) && !empty($post['actual_volume_seq'])) ? ($post['actual_volume_seq']) : 0;
        $volume_seq = (isset($post['volume_seq']) && !empty($post['volume_seq'])) ? ($post['volume_seq']) : 0;
        $assigned_to_seq = (isset($post['assigned_to_seq']) && !empty($post['assigned_to_seq'])) ? ($post['assigned_to_seq']) : 0;
        $company_code_seq=(isset($post['company_code_seq']) && !empty($post['company_code_seq'])) ? ($post['company_code_seq']) : 0;
        $branch_code_seq=(isset($post['branch_code_seq']) && !empty($post['branch_code_seq'])) ? ($post['branch_code_seq']) : 0;
        $from_source_seq=(isset($post['from_source_seq']) && !empty($post['from_source_seq'])) ? ($post['from_source_seq']) : 0;
        $manifest_no_seq = (isset($post['manifest_no_seq']) && !empty($post['manifest_no_seq'])) ? ($post['manifest_no_seq']) : 0;
        $scanned_quantity_seq = (isset($post['scanned_quantity_seq']) && !empty($post['scanned_quantity_seq'])) ? ($post['scanned_quantity_seq']) : 0;
        $no_of_pallets_seq = (isset($post['no_of_pallets_seq']) && !empty($post['no_of_pallets_seq'])) ? ($post['no_of_pallets_seq']) : 0;
        $pq_ref_seq = (isset($post['pq_ref_seq']) && !empty($post['pq_ref_seq'])) ? ($post['pq_ref_seq']) : 0;
        $external_customer_seq = (isset($post['external_customer_seq']) && !empty($post['external_customer_seq'])) ? ($post['external_customer_seq']) : 0;
        $booking_creat_by_seq =  $post['booking_creat_by_seq'] ?? 0;
        $deliverycity_seq = $post['deliverycity_seq'] ?? 0;
        $customer_name_seq =  $post['customer_name_seq'] ?? 0;
        $vendor_name_seq =  $post['vendor_name_seq'] ?? 0;
        $pos_ref_seq = $post['pos_ref_seq'] ?? 0;
        $container_no_seq = $post['container_no_seq'] ?? 0;
        $loadplanconnote_seq = $post['loadplanconnote_seq'] ?? 0;
        $bookingUpdatedDateSequence = $post['booking_updated_date_seq'] ?? 0;
        $vehicleNumberSequence = $post['vehicle_number_seq'] ?? 0;
        $vehicleTypeSequence = $post['vehicle_type_seq'] ?? 0;
        $customerNameSequence = $post['customer_name_seq'] ?? 0;


        $department_seq = (isset($post['department_seq']) && !empty($post['department_seq'])) ? ($post['department_seq']) : 0;
        $jfr_seq = (isset($post['jfr_seq']) && !empty($post['jfr_seq'])) ? ($post['jfr_seq']) : 0;
        $pod_seq = (isset($post['pod_seq']) && !empty($post['pod_seq'])) ? ($post['pod_seq']) : 0;
        if (checkAccessConditions('RELATED_2_SG_MY', $session_company_code)) {
            $insdata = [
                'childid' => $childid,
                'ord_id' => $ord_id . "_" . $ord_id_seq . '_2',
                'delivery_note' => $delivery_note . "_" . $delivery_note_seq . '_3',
                'salog_ref' => $salog_ref . "_" . $salog_ref_seq . '_4',
                'customer_name' => $customerName . "_" . $customerNameSequence . '_5',
                'pickup' => $pickup . "_" . $pickup_seq . '_6',
                'delivery' => $delivery . "_" . $delivery_seq . '_7',
                'trip_no' => $trip_no . "_" . $trip_no_seq . '_8',
                'status' => $status . "_" . $status_seq . '_9',
                'other_status' => $other_status . "_" . $other_status_seq . '_10',
                'created_date' => $created_date . "_" . $created_date_seq . '_11',
                'pickup_date' => $pickup_date . "_" . $pickup_date_seq . '_12',
                'estimated_delivery_date' => $estimated_delivery_date . "_" . $estimated_delivery_date_seq . '_13',
                'delivery_date' => $delivery_date . "_" . $delivery_date_seq . '_14',
                'mode_of_transport' => $mode_of_transport . "_" . $mode_of_transport_seq . '_15',
                'vehicle_type' => $vehicleType . "_" . $vehicleTypeSequence . '_16',
                'vehicle_number' => $vehicleNumber . "_" . $vehicleNumberSequence . '_17',
                'total_packages' => $total_packages . "_" . $total_packages_seq . '_18',
                'order_jfr' => $jfr . "_" . $order_jfr_seq . '_19',
                'billing_status' => $billing_status . "_" . $billing_status_seq . '_20',
                'actual_weight' => $actual_weight . "_" . $actual_weight_seq . '_21',
                'weight' => $weight . "_" . $weight_seq . '_22',
                'actual_volume' => $actual_volume . "_" . $actual_volume_seq . '_23',
                'volume' => $volume . "_" . $volume_seq . '_24',
                'company_code' => $company_code . "_" . $company_code_seq . '_25',
                'branch_code' => $branch_code . "_" . $branch_code_seq . '_26',
                'from_source' => $from_source . "_" . $from_source_seq . '_27',
                'booking_updated_date' => $bookingUpdatedDate . "_" . $bookingUpdatedDateSequence . '_28',
                'pq_ref' => $pq_ref . "_" . $pq_ref_seq . '_29',
                'external_customer' => $external_customer . "_" . $external_customer_seq . '_30',
                'user_id' => $user_id,
                'is_active' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
        } else {
            $insdata = [
                'childid' => $childid,
                's_no' => $s_no . "_" . $s_no_seq . '_2',
                'ord_id' => $ord_id . "_" . $ord_id_seq . '_3',
                'delivery_note' => $delivery_note . "_" . $delivery_note_seq . '_4',
                'booking_creat_by' => $booking_creat_by . "_" . $booking_creat_by_seq . '_5',
                'salog_ref' => $salog_ref . "_" . $salog_ref_seq . '_6',
                'customer_name' => $customer_name . "_" . $customer_name_seq . '_7',
                'vendor_name' => $vendor_name . "_" . $vendor_name_seq . '_8',
                'container_no' => $container_no . "_" . $container_no_seq . '_9',
                'pos_ref' => $pos_ref . "_" . $pos_ref_seq . '_10',
                'loadplanconnote' => $loadplanconnote . "_" . $loadplanconnote_seq . '_11',
                'pickup' => $pickup . "_" . $pickup_seq . '_12',
                'delivery' => $delivery . "_" . $delivery_seq . '_13',
                'deliverycity' => $deliverycity . "_" . $deliverycity_seq . '_14',
                'trip_no' => $trip_no . "_" . $trip_no_seq . '_15',
                'status' => $status . "_" . $status_seq . '_16',
                'manifest_no' => $manifest_no . "_" . $manifest_no_seq . '_17',
                'other_status' => $other_status . "_" . $other_status_seq . '_18',
                'Stoppage' => $Stoppage . "_" . $Stoppage_seq . '_19',
                'created_date' => $created_date . "_" . $created_date_seq . '_20',
                'pickup_date' => $pickup_date . "_" . $pickup_date_seq . '_21',
                'estimated_delivery_date' => $estimated_delivery_date . "_" . $estimated_delivery_date_seq . '_22',
                'delivery_date' => $delivery_date . "_" . $delivery_date_seq . '_23',
                'mode_of_transport' => $mode_of_transport . "_" . $mode_of_transport_seq . '_24',
                'department' => $department . "_" . $department_seq . '_25',
                'total_packages' => $total_packages . "_" . $total_packages_seq . '_26',
                'scanned_quantity' => $scanned_quantity . "_" . $scanned_quantity_seq . '_27',
                'no_of_pallets' => $no_of_pallets . "_" . $no_of_pallets_seq . '_28',
                'billing_status' => $billing_status . "_" . $billing_status_seq . '_29',
                'actual_weight' => $actual_weight . "_" . $actual_weight_seq . '_30',
                'weight' => $weight . "_" . $weight_seq . '_31',
                'actual_volume' => $actual_volume . "_" . $actual_volume_seq . '_32',
                'volume' => $volume . "_" . $volume_seq . '_33',
                'pod' => $pod . "_" . $pod_seq . '_34',
                'order_jfr' => $jfr . "_" . $order_jfr_seq . '_35',
                'company_code' => $company_code . "_" . $company_code_seq . '_36',
                'branch_code' => $branch_code . "_" . $branch_code_seq . '_37',
                'from_source' => $from_source . "_" . $from_source_seq . '_38',
                'booking_updated_date' => $bookingUpdatedDate . "_" . $bookingUpdatedDateSequence . '_39',
                'pq_ref' => $pq_ref . "_" . $pq_ref_seq . '_40',
                'external_customer' => $external_customer . "_" . $external_customer_seq . '_41',
                'user_id' => $user_id,
                'is_active' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt
            ];
        }
        if($custaprl_id > 0){
            $update = $this->common->updatetbledata("tb_orderlist_spec_cols", $insdata, array('id'=>$custaprl_id));
            $caprl_id = $custaprl_id;
        }else{
            $chkqry = $this->db->select('user_id')->get_where("tb_orderlist_spec_cols","user_id=$user_id and is_active=1 and childid=$childid");
            if ($chkqry->num_rows() == 0) {
                $caprl_id = $this->common->insertTableData("tb_orderlist_spec_cols", $insdata);
                $caprl_id = 'inserted';
            }else{
                $caprl_id = 'already_exist';

            }
        }
        echo json_encode($caprl_id);
    }

    /**
     * Action for AJAX calls to return order columns visibility
     */
    public function getorderlistspec(): void
    {
        $userRoleId = $this->session->userdata('user_role_id');
        if (in_array($userRoleId, [3, 4])) {
            echo json_encode([
                'selected_colum' => [],
                'not_selected_colum' => [],
            ]);
            return;
        }
        $user_id = $this->session->userdata('user_id');
        $childid = $this->session->userdata('childid');
        $company_code = $this->session->userdata('company_code');

        if ($childid == '') {
            $childid = 0;
        }

        if (checkAccessConditions('RELATED_2_SG_MY', $company_code)) {
            $result = $this->smtcorder->getsmtcorderlistcolumns(
                $user_id,
                $childid
            );
            $columns = [
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'trip_no' => "Trip No",
                'status' => "Status",
                'other_status' => "Other Status",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'vehicle_type' => "Vehicle Type",
                'vehicle_number' => "Vehicle Number",
                'total_packages' => "Total Packages",
                'order_jfr' => 'JFR',
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref'=>"Payment Ref",
                'external_customer' => "External Customer"
            ];
        } else {
            $result = $this->smtcorder->getsmtcorderlistcolumns(
                $user_id,
                $childid
            );
            $columns = [
                's_no' => "S.No",
                'ord_id' => "Booking ID",
                'delivery_note' => "Delivery Note",
                'booking_creat_by' => "Booking Created By",
                /*'salog_ref' => "SALOG Ref",*/
                'customer_name' => "Customer Name",
                'vendor_name' => "Vendor Name",
                'container_no' => "Container no",
                'pos_ref' => "KN origin reference",
                'loadplanconnote' => "Load plan connot",
                'pickup' => "Pickup",
                'delivery' => "Delivery",
                'deliverycity' => "Delivery city",
                'trip_no' => "Trip No",
                'status' => "Status",
                'manifest_no' => "Manifest no",
                'other_status' => "Other Status",
                'Stoppage' => "Stoppage",
                'created_date' => "Created Date",
                'pickup_date' => "Pickup Date",
                'estimated_delivery_date' => "Estimated Delivery Date",
                'delivery_date' => "Delivery Date",
                'mode_of_transport' => "Mode Of Transport",
                'department' => "Department",
                'total_packages' => "Total Packages",
                'scanned_quantity' => "Scanned Quantity",
                'no_of_pallets' => "Number of pallets",
                'billing_status' => "Billing Status",
                'actual_weight' => "Actual Weight",
                'weight' => "Weight",
                'actual_volume' => "Actual Volume",
                'volume' => "Volume",
                'pod' => "POD",
                'order_jfr' => 'JFR',
                'company_code' => "Company Code",
                'branch_code' => "Branch Code",
                'from_source' => "From Source",
                'booking_updated_date' => "Booking Updated",
                'pq_ref'=>"Payment Ref",
                'external_customer' => "External Customer"
            ];
        }

        $not_selected_colum = $selected_colum = [];

        if (!empty($result)) {
            foreach ($columns as $key => $value) {
                $col_val = explode("_", $result[$key]);
                if (isset($col_val[0])) {
                    if ($col_val[0] == 0) {
                        if (isset($col_val[2])) {
                            $not_selected_colum[$col_val[1]] = $col_val[2];
                        }
                    }else{
                        if (isset($col_val[2])) {
                            $selected_colum[$col_val[1]] = ($col_val[2]);
                        }
                    }
                }
            }
        }

        ksort($selected_colum);
        ksort($not_selected_colum);
        $selected_columId = $not_selected_columId = [];

        foreach ($selected_colum as $values) {
            $selected_columId[] = $values;
        }

        foreach ($not_selected_colum as $values) {
            $not_selected_columId[] = $values;
        }

        $obj['selected_colum'] = $selected_columId;
        $obj['not_selected_colum'] = $not_selected_columId;
        echo json_encode($obj);
    }
}
