<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Customer\Models\Reference\DeliveryNote;

class Orderrevenues extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session', 'Ratemanagement', 'Exchangerate', 'newjfrlogic_sgmy', 'SearchService']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['Order', 'common','Order_details']);
    }
    public function updatebulkcargo(){
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_ids = isset($post['order_ids']) ? $post['order_ids'] : "";
        $cargo_type = isset($post['cargo_type']) ? $post['cargo_type'] : "";
        if($order_ids != ""){
            $getcargos = $this->db->query("SELECT id,cargo_id from tb_order_cargodetails where order_id IN (".$order_ids.") AND status='1'");
            if($getcargos->num_rows() >0){
                foreach ($getcargos->result() as $res) {
                    $cargo_id = $res->cargo_id;
                    $row_id   = $res->id;
                    $upd = $this->db->where(array('id'=>$row_id))->update("tb_order_cargodetails",array('quantity_type'=>$cargo_type));
                    if($cargo_id >0){
                        $upd_cargo = $this->db->where(array('id'=>$cargo_id))->update("tb_cargo_details",array('cargo_type'=>$cargo_type));
                    }
                }
            }
        }
        echo "1";
    }

    public function getservicefororder(){
        $getorderids = $this->db->query("SELECT id,company_code FROM tb_orders WHERE company_code IN ('RUKN','VNKN') AND status !='0'");
        if($getorderids->num_rows() >0){
            foreach ($getorderids->result() as $orders) {
                $order_id = $orders->id;
                $company_code = $orders->company_code;
                if($order_id >0){
                    $getorder_details = $this->db->query("SELECT id,service FROM tb_order_details where order_row_id ='".$order_id."' ");
                    if($getorder_details->num_rows()>0){
                        foreach ($getorder_details->result() as $details) {
                            $service_id = $details->service;
                            if($service_id >0){
                                $detail_id = $details->id;
                                if($detail_id >0){
                                    $getsrevice_name = $this->db->query("SELECT id,name FROM tb_service_master WHERE id ='".$service_id."'");
                                    if($getsrevice_name->num_rows() >0){
                                        $service_name = $getsrevice_name->row()->name;
                                        $getruserviceid = $this->db->query("SELECT id from tb_service_master WHERE name LIKE '".$service_name."' AND company_code='".$company_code."'");
                                        if($getruserviceid->num_rows()>0){
                                            $company_serviceid = $getruserviceid->row()->id;
                                            $updordeer = $this->db->where(array('id'=>$detail_id))->update("tb_order_details",array('service'=>$company_serviceid));
                                            echo $this->db->last_query();
                                            echo "<br>";
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

    }

    public function maketripclosedfororder(){
        $order_id = array();
        if(!empty($order_id)){
            $getordertrips = $this->db->query("SELECT id,shift_id,trip_id FROM tb_orders WHERE order_id IN (".implode(',', $order_id).") and trip_sts ='0' order by id DESC");
            if($getordertrips->num_rows() >0){
                foreach($getordertrips->result() as $res){
                    $order_row_id = $res->id;
                    $trip_id = $res->trip_id;
                    $shift_id = $res->shift_id;
                    echo "order_row_id ".$order_row_id;echo "<br>";
                    if($shift_id!= "0" && $shift_id !=""){
                        echo "shift_id ".$shift_id;echo "<br>";
                        /* $upd_shiftstatus = $this->db->where(array('id'=>$shift_id))->update("tb_shifts",array('status'=>'0'));*/
                    }
                    if($trip_id!= '0' && $trip_id != ""){
                        echo "trip_id ".$trip_id;echo "<br>";
                        /*   $upd_tripstatus = $this->db->where(array('id'=>$trip_id))->update("tb_trips",array('status'=>'0'));*/
                    }
                    /* $upd_tripsts = $this->db->where(array('id'=>$order_row_id))->update("tb_orders",array('trip_sts'=>'1'));*/
                }
            }
        }
    }

    public function checkdqnotevalue(){
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $dq_note = isset($post['dq_note']) ? $post['dq_note']: "0";
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $whr = "";
        if($company_code == 'RUKN'){
            $whr = " AND o.company_code LIKE '".$company_code."'";
        }else{
            $whr = " AND o.user_id='".$user_id."' ";
        }
        if($dq_note != '0' && $dq_note != ""){
            $sql = $this->db->query("SELECT r.id FROM tb_order_references r,tb_orders o WHERE r.reference_id  LIKE 'DQ' AND r.order_id=o.id AND r.status='1' AND r.ref_value LIKE '".$dq_note."' AND o.status !='0'".$whr);
            if($sql->num_rows()>0){
                echo "1";
            }else{
                echo "0";
            }
        }
    }
    public function checkdqnotevaluewithcustomer()
    {
        $cust_id = 0;
        $post = $this->input->post(null,true);

        $dq_note = $post['dq_note'] ?? 0;
        $customer = $post['customer_id'] ?? "";
        $company_code = $this->session->userdata('company_code');

        $note = new DeliveryNote();

        if($customer != "") {
            $cust_id = $note->getCustomerIdByCustomerCode($customer, $company_code);
        }

        if($cust_id > 0) {
            $deliveryNoteExists = $note->exists($cust_id, $dq_note, $company_code);
            echo ($deliveryNoteExists ? "1" : "0");
        } else {
            echo "0";
        }
    }


    public function getchargesforrevenue()
    {
    $post = array();
    $post = $this->input->post(NULL,TRUE);
    $revenue_id = isset($post['revenue_id']) ? $post['revenue_id'] : "";
    $charges    = array();
    if ($revenue_id != "") {
        $inv_status = $bill_id = $type =0;
        $bill_status = 1;
        $foreign_currency = $recipient_role = "";
        $getcharges =  $this->Order->getchargesforrevenuemodel($revenue_id);
        $get_invstatus = $this->db->select("type,recipient_role,foreign_currency,invoice_status,bill_id")->get_where("tb_reveneus",array('id'=>$revenue_id));
        if($get_invstatus->num_rows()>0){
            $inv_status = $get_invstatus->row()->invoice_status;
            $recipient_role = $get_invstatus->row()->recipient_role;
            $foreign_currency = $get_invstatus->row()->foreign_currency;
            $bill_id = $get_invstatus->row()->bill_id;
            $type = $get_invstatus->row()->type;
        }
        if($bill_id >0){
             $get_bill_status = $this->db->select("status")->get_where("tbl_bills",array('id'=>$bill_id));
               if($get_bill_status->num_rows()>0){
                $bill_status = $get_bill_status->row()->status;
               }
        }
            if ($getcharges->num_rows() > 0) {
                foreach ($getcharges->result() as $res) {
                    $action    = "";
                    $vat_desc  = "";
                    $cat_id = $res->cat_id;
                    $source_created = $res->source_created;
                    if($cat_id >0){
                     $getvatdesc = $this->common->gettblrowdata(array('id'=>$cat_id,'status'=>'1'),"description","tb_vat_category",0,0);
                        if(!empty($getvatdesc)){
                            $vat_desc= $getvatdesc['description'];
                        }
                    }else{
                      $cat_id = 0;
                    }
                    $local_vat_amount = $local_total_amount = "";
                    if(is_numeric($res->local_vat_amount)){
                        $local_vat_amount = $res->local_vat_amount;
                    }
                    if(is_numeric($res->local_total_amount)){
                        $local_total_amount = $res->local_total_amount;
                    }
                    $charges[] = array('revenue_id' => $res->revenue_id, 'charge_id' => $res->id, 'charge_code' => $res->chargecode, 'description' => $res->description, 'quantity_unit' => $res->quantity_unit, 'value' => $res->value, 'rate_id' => $res->rate_id, 'amount' => $res->amount, 'currency' => $res->currency, 'local_amount' => $res->local_amount, 'local_currency' => $res->local_currency, 'action' => $action, 'chargecode_id' => $res->charge_code,'inv_status'=>$inv_status,'recipient_role'=>$recipient_role,'foreign_currency'=>$foreign_currency,'vat_percentage' => $res->vat_percentage,'vat_amount' => $res->vat_amount,'total_amount' => $res->total_amount,'cat_id'=>$cat_id,'cat_val'=>$res->cat_val,'bill_status'=>$bill_status,'vat_desc'=>$vat_desc,'type'=>$type, 'source_created'=>$source_created,'local_vat_amount'=>$local_vat_amount,'local_total_amount'=>$local_total_amount);
                }
            }
        }
        echo json_encode($charges);
    }

    public function savecharge($charge_id = null)
    {
        $charge_ar         =  $post = array();
        $post = $this->input->post(NULL,TRUE);
        $session_companycode = $this->session->userdata('company_code');
        $user_id           = $this->session->userdata('user_id');
        $session_currency = $this->session->userdata("usr_tzone")['currency'];
        $company_code = $this->session->userdata('company_code');
        if($company_code == 'PLKN'){
            $session_currency = 'PLN';
        }
        $cdate             = date('Y-m-d H:i:s');
        $charge_code       = isset($post['charge_code']) ? $post['charge_code'] : "";
        $description       = isset($post['charge_description']) ? $post['charge_description'] : "";
        $quantity_unit     = isset($post['charge_qty']) ? $post['charge_qty'] : "1";
        $value             = isset($post['charge_value']) ? $post['charge_value'] : "";
        $rate_id           = isset($post['charge_rateid']) ? $post['charge_rateid'] : "1";
        $amount            = isset($post['charge_amount']) ? $post['charge_amount'] : "0.0000";
        $currency          = isset($post['charge_currency']) ? $post['charge_currency'] : "";
        $vat_percentage    = isset($post['vat_percentage']) ? $post['vat_percentage'] : "0.0000";
        if($vat_percentage == ""){ $vat_percentage="0.0000";}
        $vat_amount        = isset($post['vat_amount']) ? $post['vat_amount'] : "0.0000";
        if($vat_amount == ""){ $vat_amount="0.0000";}
        $total_amount      = isset($post['total_amount']) ? $post['total_amount'] : "0.0000";
        if($total_amount == ""){ $total_amount="0.0000";}
        $local_amount      = isset($post['local_amount']) ? $post['local_amount'] : "0.0000";
        $local_currency    = isset($post['local_currency']) ? $post['local_currency'] : "";
        $charge_revenue_id = isset($post['charge_revenue_id']) ? $post['charge_revenue_id'] : "0";
        $cat_id = (isset($post['cat_id']) && !empty($post['cat_id'])) ? $post['cat_id'] : "0";
        $cat_val = (isset($post['cat_val']) && !empty($post['cat_val'])) ? $post['cat_val'] : "";
        $vat_category = (isset($post['vat_category']) && !empty($post['vat_category'])) ? $post['vat_category'] : "0";
        if($local_amount == "" || !(is_numeric($local_amount))){
            $local_amount = "0.0000";
        }
        if($amount == "" || !(is_numeric($amount))){
            $amount = "0.0000";
        }
        if($quantity_unit == ''){
            $quantity_unit = 1;
        }
        if($rate_id == ""){
            $rate_id = 1;
        }
        if($value == ""){
            if($quantity_unit == 1){
                $value = $amount;
            }
        }
        $charge_amount = $amount;
        $charge_totalamount = $total_amount;
        $charge_vatamount = $vat_amount;

        $charge_amount = round($amount,4);
        $charge_totalamount = round($total_amount,4);
        $charge_vatamount = round($vat_amount,4);

        if($session_companycode == "VNKN"){
            if($session_currency == $currency){
                $charge_amount = round($amount);
                $charge_totalamount = round($total_amount);
            }
        }
        if($charge_revenue_id != "0"){
            $charge_ar         = array('revenue_id' => $charge_revenue_id, 'charge_code' => $charge_code, 'description' => $description, 'quantity_unit' => $quantity_unit, 'value' => $value, 'rate_id' => $rate_id, 'amount' =>$charge_amount, 'currency' => $currency,'vat_percentage' => $vat_percentage,'vat_amount' => $charge_vatamount,'total_amount' => $charge_totalamount,'cat_id'=>$vat_category,'cat_val'=>$cat_val, 'source_created'=>'MI - Manual Input');

            if($session_currency == $currency){
                if($session_companycode == "VNKN"){
                    $charge_ar['local_amount'] = round($amount);
                }else{
                    $charge_ar['local_amount'] = round($amount,4);
                }
                $charge_ar['local_currency'] = $currency;
                $charge_ar['local_vat_amount'] = $charge_vatamount;
                $charge_ar['local_total_amount'] = $charge_totalamount;
            }else{
                $charge_ar['local_amount'] = 0;
                $charge_ar['local_vat_amount'] = 0;
                $charge_ar['local_total_amount'] = 0;
            }
            if ($charge_id != "") {
                $updwhr = array("id"=>$charge_id);
                $upd = $this->common->updatetbledata("tb_charges",$charge_ar,$updwhr);
            } else {
                $charge_ar['amount'] = round($amount,4);
                $charge_ar['local_amount'] = 0;
                $charge_ar['local_vat_amount'] = 0;
                $charge_ar['local_total_amount'] = 0;
                if($session_currency == $currency){
                    $charge_ar['local_vat_amount'] = $charge_vatamount;
                    $charge_ar['local_total_amount'] = $charge_totalamount;
                    if($session_companycode == "VNKN"){
                        $charge_ar['local_amount'] = round($amount);
                    }else{
                        $charge_ar['local_amount'] = round($amount,4);
                    }
                }
                $charge_ar['createdon'] = $cdate;
                $charge_ar['status']    = '1';
                $charge_ar['user_id']   = $user_id;
                $charge_id = $this->common->insertTableData("tb_charges",$charge_ar);
            }
            $total_amount = $this->gettotalamount_ofrevenue($charge_revenue_id);
        }
        echo json_encode($charge_revenue_id);
    }


    public function deleterevenuecharge()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $id         = isset($post['charge_id']) ? $post['charge_id'] : "";
        $revenue_id = 0;
        if ($id != "") {
            $where = array('id'=>$id);
            $select = "revenue_id";
            $charges = $this->common->gettblrowdata($where,$select,'tb_charges',0,0);
            if (!empty($charges)) {
                $revenue_id = $charges['revenue_id'];
                $upd = $this->common->updatetbledata("tb_charges",array('status'=>'0'),array('id'=>$id));
                $total_amount = $this->gettotalamount_ofrevenue($revenue_id);
            }
        }
        echo json_encode($revenue_id);
    }

    public function deleterevenue()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $revenue_id = isset($post['row_id']) ? $post['row_id'] : "";
        if ($revenue_id != "") {
            $where = array('id'=>$revenue_id);
            $select = "id";
            $revenues = $this->common->gettblrowdata($where,$select,'tb_reveneus',0,0);
            if (!empty($revenues)) {
                $upd = $this->common->updatetbledata("tb_reveneus",array('status' => 0),$where);
                if ($upd) {
                    echo "1";
                }
            }
        }
    }

    public function getrefnamebyid(){
        $name  = "";
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $code = isset($post['item_id']) ? $post['item_id'] : "";
        if($code != ""){
            $getname = $this->db->select("description")->get_where("tb_reference_master",array('name'=>$code,'status'=>'1'));
            if($getname->num_rows() >0){
                $name= $getname->row()->description;
            }
        }
        echo json_encode($name);
    }

    public function getchargecode()
    {
        $codes =  $post = array();
        $post = $this->input->post(NULL,TRUE);
        $code  = isset($post['term']) ? $post['term'] : "";
        $charges = $this->Order->getchargecodes($code);
        if ($charges->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $codes[] = array('id' => $res->id, 'name' => $res->name);
            }
        }
        echo json_encode($codes);
    }

    public function getchargecodebyname()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $description = "";
        $name        = isset($post['item_id']) ? $post['item_id'] : "";
        $select = "description";
        $names = $this->common->gettblrowdata(array('name'=>$name),$select,'tb_charge_codes',0,0);
        if (!empty($names)) {
            $description = $names['description'];
        }
        echo json_encode($description);
    }

    public function saverevenue($revenue_id = null)
    {
        $revenue_ar         = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $session_companycode = $this->session->userdata("company_code");
        $date = date('Y-m-d H:i:s');
        $order_id           = isset($post['revenue_orderid']) ? $post['revenue_orderid'] : "";
        if($order_id == ""){
            $order_id = 0;
        }
        $role               = isset($post['roletype_rebenue']) ? $post['roletype_rebenue'] : "";
        $bu_jfr             = isset($post['revenue_bujfr']) ? $post['revenue_bujfr'] : "";
        $code               = isset($post['revenue_codeid']) ? $post['revenue_codeid'] : "";
        $name               = isset($post['revenue_name']) ? $post['revenue_name'] : "";
        $debtor_jfr         = isset($post['revenue_debtor']) ? $post['revenue_debtor'] : "";
        $invoice_number     = isset($post['invoice_number']) ? $post['invoice_number'] : "";
        $credit_note_number = isset($post['credit_note_number']) ? $post['credit_note_number'] : "";
        $invoice_date       = isset($post['invoice_date']) ? $post['invoice_date'] : "";
        $inv_createddate    = isset($post['inv_createddate']) ? $post['inv_createddate'] : "";
        $inv_receiveddate   = isset($post['inv_receiveddate']) ? $post['inv_receiveddate'] : "";
        $amount             = isset($post['revenue_amount']) ? $post['revenue_amount'] : "0.0000";
        $currency           = isset($post['revenue_currency']) ? $post['revenue_currency'] : "";
        $foreign_currency   = isset($post['revenue_foreigncurcy']) ? $post['revenue_foreigncurcy'] : "";
        $exchange_rate      = isset($post['exchange_rate']) ? $post['exchange_rate'] : "";
        $invoice_status     = isset($post['invoice_status']) ? $post['invoice_status'] : "0";
        $user_id            = $this->session->userdata('user_id');
        $input_invoice_status = $invoice_status;
        $cdate              = date('Y-m-d H:i:s');
        if ($invoice_date != "") {
            $invoice_date = date('Y-m-d', strtotime($invoice_date));
        }
        if ($inv_createddate != "") {
            $inv_createddate = date('Y-m-d', strtotime($inv_createddate));
        }
        if ($inv_receiveddate != "") {
            $inv_receiveddate = date('Y-m-d', strtotime($inv_receiveddate));
        }
        $debtor_jfr = "";
        if($amount == ""){
            $amount = "0.0000";
        }
        if($bu_jfr == ""){
            $bu_jfr = "0";
        }

        $charge_amount = round($amount,4);
        $invoice_date = '0000-00-00 00:00:00';
        $inv_createddate = '0000-00-00 00:00:00';
        $inv_receiveddate = '0000-00-00 00:00:00';
        $db_invoice_status = 0;
        if ($revenue_id == "") {
            $revenue_ar           = array('order_id' => $order_id, 'type' => '0', 'recipient_role' => $role, 'recipient_code' => $code, 'recipient_name' => $name,'amount' => $charge_amount, 'currency' => $currency,  'status' => 1, 'user_id' => $user_id, 'createdon' => $cdate, 'bu_jfr'=>$bu_jfr, 'updatedon'=>$date);

            $table = "tb_reveneus";
            $revenue_id = $this->common->insertTableData($table,$revenue_ar);
        } else {
            $select = "invoice_status";
            $inv_status = $this->common->gettblrowdata(array('id'=>$revenue_id),$select,'tb_reveneus',0,0);
            if(!empty($inv_status)){
                $db_invoice_status = $inv_status['invoice_status'];
            }
            if($amount == ""){
                $amount = "0.0000";
            }
            $revenue_ar           = array('order_id' => $order_id, 'type' => '0', 'recipient_role' => $role, 'recipient_code' => $code, 'recipient_name' => $name, 'amount' => $amount, 'currency' => $currency,  'bu_jfr'=>$bu_jfr, 'status' => 1, 'updatedon'=>$date);
            $upd = $this->common->updatetbledata("tb_reveneus",$revenue_ar,array('id'=>$revenue_id));
        }
        $total_amount = 0;
        if($revenue_id != "" && $revenue_id != "0"){
            $chk_exchange = $this->exchangerate->checkordersinglerevenuecurrency($revenue_id);
            $this->gettotalamount_ofrevenue($revenue_id);
            /**  CHECK MULTI CARRIER EXISTS OR NOT  */
            if($db_invoice_status == "0"){
                if($input_invoice_status == "1"){
                    $debtor_jfr =  $this->getdebitorcode_revenue($order_id,$revenue_id);
                }
            }
            if($debtor_jfr == ""){
                $invoice_status =0;
            }
            $upd_ar = array();
            if($debtor_jfr != ""){
                $upd_ar['invoice_status'] = $invoice_status;
                $upd_ar['debtor_jfr']     = $debtor_jfr;
                $upd = $this->common->updatetbledata("tb_reveneus",$upd_ar,array('id'=>$revenue_id));
            }
            /** END OF MULTI CARRIER */
        }
        if($order_id != '0'){
            echo json_encode($order_id);
        }else{
            echo json_encode($revenue_id);
        }

    }
    /* Generate debitor code if invoice status has set 1 from traffic codes*/
    public function getdebitorcode_revenue($order_id,$row_id){
        $debtor_jfr = "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata("company_code");
        $trip_id = $shift_id = 0;
        $exchange_rate = $this->exchangerate->checkexchangerateexistsornot($order_id,$row_id);
        if($exchange_rate > 0){
            if($order_id != ""){
                $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
                $country_code  = $get_country->row()->country_code;
                $company_code  = $get_country->row()->company_code;
                $cdate     = date( 'Y-m-d H:i:s' );
                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                $getactual = getdatetimebytimezone( DFLT_TZ, $cdate, $curtz );
                $cdate     = $getactual['datetime'];
                $gettripid = $this->common->gettblrowdata(array('id'=>$order_id),"shift_id,trip_id",'tb_orders',0,0);
                if(!empty($gettripid)){
                    $trip_id = $gettripid['trip_id'];
                    $shift_id = $gettripid['shift_id'];
                }
                if (checkAccessConditions('RELATED_2_SG_MY', $company_code)) {
                    $info = array('country_code'=>$country_code,'user_id'=>$user_id,'revnue_id'=>$row_id,'order_id'=>$order_id,'trip_id'=>$shift_id, 'sts_createdon' => $cdate);
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    $debtor_jfr = $this->newjfrlogic_sgmy->generatedebitro_jfrcode_sgmyorders($info);
                }else{
                    $info = array('country_code'=>$country_code,'user_id'=>$user_id,'revnue_id'=>$row_id,'order_id'=>$order_id,'trip_id'=>$trip_id, 'sts_createdon' => $cdate);
                    if($trip_id > 0){
                        $debtor_jfr = generatedebitro_jfrcode($info);
                    }
                }
            }
        }
        return $debtor_jfr;
    }
    public function savecost($costid = null)
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $cdate    = date('Y-m-d H:i:s');
        $codeid                = isset($post['cost_codeid']) ? $post['cost_codeid'] : "";
        $order_id              = isset($post['cost_order_id']) ? $post['cost_order_id'] : "";
        if($order_id == ""){
            $order_id = 0;
        }
        $role                  = isset($post['costtype_role']) ? $post['costtype_role'] : "";
        $bu_jfr        = isset($post['cost_bujfr']) ? $post['cost_bujfr'] : "0";
        $name                  = isset($post['cost_name']) ? $post['cost_name'] : "";
        $accrual_amount        = isset($post['cost_accamount']) ? $post['cost_accamount'] : "0.0000";
        $total_amount          = isset($post['cost_totamount']) ? $post['cost_totamount'] : "0.0000";
        $currency              = isset($post['cost_currency']) ? $post['cost_currency'] : "";
        $creditor_jfr          = isset($post['cost_creditor']) ? $post['cost_creditor'] : "";
        $foreign_currency      = isset($post['cost_foreigncurcy']) ? $post['cost_foreigncurcy'] : "";
        $exchange_rate         = isset($post['cost_exrate']) ? $post['cost_exrate'] : "0.0000";
        $foreign_accuralamount = isset($post['cost_exaccamt']) ? $post['cost_exaccamt'] : "0.0000";
        $actual_amount         = isset($post['cost_exactamt']) ? $post['cost_exactamt'] : "0.0000";
        $invoice_number        = isset($post['cost_invno']) ? $post['cost_invno'] : "";
        $credit_note_number    = isset($post['cost_creditnoteno']) ? $post['cost_creditnoteno'] : "";
        $invoice_date          = isset($post['cost_invdate']) ? $post['cost_invdate'] : "";
        $invoice_creation_date = isset($post['cost_invcreateddate']) ? $post['cost_invcreateddate'] : "";
        $invoice_received_date = isset($post['cost_invreceviedddate']) ? $post['cost_invreceviedddate'] : "";
        $invoice_status        = isset($post['cost_invoice_status']) ? $post['cost_invoice_status'] : "0";
        $input_invoice_status = $invoice_status;
        if($bu_jfr == ""){
            $bu_jfr = 0;
        }
        $creditor_jfr = "";
        if ($invoice_date != "") {
            $invoice_date = date('Y-m-d', strtotime($invoice_date));
        }
        if ($invoice_creation_date != "") {
            $invoice_creation_date = date('Y-m-d', strtotime($invoice_creation_date));
        }
        if ($invoice_received_date != "") {
            $invoice_received_date = date('Y-m-d', strtotime($invoice_received_date));
        }
        if($accrual_amount == "" || !(is_numeric($accrual_amount))){
            $accrual_amount = "0.0000";
        }

        if($actual_amount == "" || !(is_numeric($actual_amount))){
            $actual_amount = "0.0000";
        }
        if($foreign_accuralamount == "" || !(is_numeric($foreign_accuralamount))){
            $foreign_accuralamount = "0.0000";
        }
        if($total_amount == "" || !(is_numeric($total_amount))){
            $total_amount = "0.0000";
        }
        $invoice_received_date = $invoice_creation_date = $invoice_date = "0000-00-00 00:00:00";
         $db_invoice_status = 0;
        if ($costid != "") {
            $chkinv_status = $this->db->select("invoice_status")->get_where("tb_reveneus",array('id'=>$costid));
            if($chkinv_status->num_rows() >0){
                $db_invoice_status = $chkinv_status->row()->invoice_status;
            }

            if($total_amount == ""){
                $total_amount = 0;
            }
            $cost_ar = array('order_id' => $order_id, 'type' => '1', 'recipient_role' => $role, 'recipient_code' => $codeid, 'recipient_name' => $name, 'invoice_number' => $invoice_number, 'credit_note_number' => $credit_note_number, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $invoice_creation_date, 'invoice_receivdon_date' => $invoice_received_date, 'amount' => $total_amount, 'accrual_amount' => $accrual_amount, 'currency' => $currency, 'exchange_rate' => $exchange_rate, 'actual_foreign_amount' => $actual_amount, 'foreign_currency' => $foreign_currency, 'accrual_foreign_amount' => $foreign_accuralamount,'bu_jfr'=>$bu_jfr,  'status' => 1,'updatedon'=>$cdate);
            $ins     = $this->common->updatetbledata('tb_reveneus',$cost_ar,array('id'=>$costid));
        } else {

            $urder_id = $this->session->userdata('user_id');
            $cost_ar  = array('order_id' => $order_id, 'type' => '1', 'recipient_role' => $role, 'recipient_code' => $codeid, 'recipient_name' => $name, 'invoice_number' => $invoice_number, 'credit_note_number' => $credit_note_number, 'invoice_date' => $invoice_date, 'invoice_creation_date' => $invoice_creation_date, 'invoice_receivdon_date' => $invoice_received_date, 'amount' => $total_amount, 'accrual_amount' => $accrual_amount, 'currency' => $currency, 'exchange_rate' => $exchange_rate, 'actual_foreign_amount' => $actual_amount, 'foreign_currency' => $foreign_currency, 'accrual_foreign_amount' => $foreign_accuralamount, 'status' => 1, 'bu_jfr'=>$bu_jfr, 'createdon' => $cdate, 'user_id' => $urder_id,'updatedon'=>$cdate);
            $costid = $this->common->insertTableData("tb_reveneus",$cost_ar);
        }
        $total_amount = 0;
        if($costid != "" && $costid != "0"){
            $chk_exchange = $this->exchangerate->checkordersinglerevenuecurrency($costid);
            $this->gettotalamount_ofrevenue($costid);
            if($db_invoice_status == "0"){
                if($input_invoice_status == "1"){
                    $creditor_jfr =  $this->getdebitorcode_revenue($order_id,$costid);
                }
            }
            if($creditor_jfr == ""){
                $invoice_status =0;
            }
            $upd_ar = array();
            if($creditor_jfr != ""){
                $upd_ar['debtor_jfr'] = $creditor_jfr;
                $upd_ar['invoice_status'] = $invoice_status;
                $ins     = $this->common->updatetbledata('tb_reveneus',$upd_ar,array('id'=>$costid));
            }

        }
        if($order_id != "0"){
            echo json_encode($order_id);
        }else{
            echo json_encode($costid);
        }
    }

    public function getrevenuebyid(): void
    {
        $post = $this->input->post(NULL, TRUE);
        $id = $post['id'] ?? 0;
        $type = $post['type'] ?? 0;
        $revenueDetails = [];
        if ($id > 0) {
            $revenue = $this->common->gettblrowdata(['id' => $id, 'status' => 1, 'type' => $type], '*', 'tb_reveneus', 0, 0);
            if (!empty($revenue)) {
                $invoice_receivdon_date = $revenue['invoice_receivdon_date'];
                if ('0000-00-00 00:00:00' == $invoice_receivdon_date) {
                    $invoice_receivdon_date = "";
                }
                $invoice_creation_date = $revenue['invoice_creation_date'];
                if ('0000-00-00 00:00:00' == $invoice_creation_date) {
                    $invoice_creation_date = "";
                }
                $invoice_date = $revenue['invoice_date'];
                if ('0000-00-00 00:00:00' == $invoice_date) {
                    $invoice_date = "";
                }
                if ('0' == $revenue['bu_jfr']) {
                    $revenue['bu_jfr'] = '';
                }
                $revenueDetails = [
                    'id' => $revenue['id'],
                    'order_id' => $revenue['order_id'],
                    'recipient_role' => $revenue['recipient_role'],
                    'recipient_code' => $revenue['recipient_code'],
                    'recipient_name' => htmlentities($revenue['recipient_name'], ENT_COMPAT, 'UTF-8'),
                    'debtor_jfr' => $revenue['debtor_jfr'],
                    'amount' => $revenue['amount'],
                    'currency' => $revenue['currency'],
                    'foreign_currency' => $revenue['foreign_currency'],
                    'exchange_rate' => $revenue['exchange_rate'],
                    'invoice_number' => $revenue['invoice_number'],
                    'credit_note_number' => $revenue['credit_note_number'],
                    'invoice_date' => $invoice_date,
                    'invoice_creation_date' => $invoice_creation_date,
                    'invoice_receivdon_date' => $invoice_receivdon_date,
                    'invoice_status' => $revenue['invoice_status'],
                    'accrual_amount' => $revenue['accrual_amount'],
                    'actual_amount' => $revenue['actual_amount'],
                    'accrual_foreign_amount' => $revenue['accrual_foreign_amount'],
                    'actual_foreign_amount' => $revenue['actual_foreign_amount'],
                    'bu_jfr' => $revenue['bu_jfr']
                ];
            }
        }
        echo json_encode($revenueDetails);
    }

    public function deleteorderevenue()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $id       = isset($post['id']) ? $post['id'] : "0";
        $order_id = 0;
        if ($id != "0") {
            $select ="id,order_id";
            $revenues = $this->common->gettblrowdata(array('id' => $id),$select,'tb_reveneus',0,0);
            if (!empty($revenues)) {
                $order_id = $revenues['order_id'];
                $upd_ar = array('status'=>'0');
                $upd     = $this->common->updatetbledata('tb_reveneus',$upd_ar,array('id'=>$id));
            }
        }
        echo json_encode($order_id);
    }

    public function getcostbyorder()
    {
        $costs    = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $shift_id = isset($post['shift_id']) ? $post['shift_id'] : "";
        $cost_ids = isset($post['cost_ids']) ? $post['cost_ids'] : array();
        if ($order_id != "0" && !empty($order_id)) {
            $revenue = $this->common->gettbldata(array('order_id' => $order_id, 'status' => 1, 'type' => '1'), '*', 'tb_reveneus', 0, 0);
        } else if ($shift_id != "0" && !empty($shift_id)) {
            $revenue = $this->common->gettbldata(array('shift_id' => $shift_id, 'status' => 1, 'type' => '1'), '*', 'trip_reveneus', 0, 0);
        } else {
            if (!empty($cost_ids)) {
                $getreveneus = $this->db->query("SELECT * FROM tb_reveneus WHERE id IN (" . implode(',', $cost_ids) . ") ");
                if ($getreveneus->num_rows() > 0) {
                    $revenue = $getreveneus->result_array();
                }
            }
        }
        if (!empty($revenue)) {
            foreach ($revenue as $res) {
                $inv_status = $res['invoice_status'];
                $bill_id = $res['bill_id'];
                $bill_status = 0;
                $invoice_status = $res['invoice_status'];
                if($bill_id >0){
                    $get_bill_status = $this->common->gettblrowdata(array('id' => $bill_id),"status",'tbl_bills',0,0);
                    if(!empty($get_bill_status)){
                        $bill_status = $get_bill_status['status'];
                    }
                }
                $action_buttons = $filetranfer_button = $accrual_button = "";
                if($invoice_status == 1){
                    if($res['recipient_role'] == "Internal BU"){
                        $accrual_button = "<li><a id='bElim' type='button' class=' btn btn-sm btn-default'  onclick='sendfiletoacon(" . $res['id'] . ",0)'><span class='glyphicon glyphicon-pencil' > </span>Send File to ACON</a></li>";
                    }else{
                        $accrual_button = "<li><a id='bElim' type='button' class=' btn btn-sm btn-default'  onclick='sendfiletoacon(" . $res['id'] . ",1)'><span class='glyphicon glyphicon-pencil' > </span>Send Accrual</a></li>";
                    }
                }
                if($invoice_status !=2){
                    if($res['recipient_role'] == "Internal BU" && $invoice_status >1 ){
                    }else{
                        $action_buttons = "<li><a id='bEdit'  type='button' class=' btn btn-sm btn-default'  onclick='rowEditcost(this," . $res['id'] . ")'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class=' btn btn-sm btn-default'  onclick='deleteordecost(" . $res['id'] . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li>" . $accrual_button;
                    }
                }
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . $action_buttons . "<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='costrowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cost Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  title='Add charges' onclick='getchargesbyrevenue(this," . $res['id'] . ")''><span class='fa fa-archive' > </span> Get charges</a></li></ul></li></ul>";
                if($bill_status > 0){
                    if ($bill_status == '1') {
                        $inv_status = "Ready for Invocie";
                    }else{
                        $inv_status = "Invoiced";
                    }
                }else{
                    if ($res['invoice_status'] == '1') {
                        $inv_status = "Ready for Invocie";
                    }
                    if ( $res['invoice_status'] == '2') {
                        $inv_status = "Invoiced";
                    }
                }
                $invoice_creation_date = $res['invoice_creation_date'];
                if ($invoice_creation_date != "0000-00-00 00:00:00" && $invoice_creation_date != "") {
                    $invoice_creation_date = $invoice_creation_date;
                } else {
                    $invoice_creation_date = "";
                }
                $invoice_receivdon_date = $res['invoice_receivdon_date'];
                if ($invoice_receivdon_date != "0000-00-00 00:00:00" && $invoice_receivdon_date != "") {
                    $invoice_receivdon_date = $invoice_receivdon_date;
                } else {
                    $invoice_receivdon_date = "";
                }
                $invoice_date = $res['invoice_date'];
                if ($invoice_date != "0000-00-00 00:00:00" && $invoice_date != "") {
                    $invoice_date = $invoice_date;
                } else {
                    $invoice_date = "";
                }
                if($res['bu_jfr'] == null || $res['bu_jfr'] == 0){
                    $res['bu_jfr'] = '';
                }
                $costs[] = array('id' => $res['id'], 'order_id' => $order_id, 'recipient_role' => $res['recipient_role'], 'recipient_code' => $res['recipient_code'], 'recipient_name' => $res['recipient_name'], 'debtor_jfr' => $res['debtor_jfr'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'foreign_currency' => $res['foreign_currency'], 'exchange_rate' => $res['exchange_rate'], 'invoice_number' => $res['invoice_number'], 'credit_note_number' => $res['credit_note_number'], 'invoice_date' => $invoice_date, 'invoice_creation_date' => $invoice_creation_date, 'invoice_receivdon_date' => $invoice_receivdon_date, 'invoice_status' => $inv_status, 'action' => $action, 'accural_amount' => $res['accrual_amount'], 'actual_amount' => $res['actual_amount'], 'foreign_accuralamount' => $res['accrual_foreign_amount'], 'bu_jfr' => $res['bu_jfr']);
            }
        }
        echo json_encode($costs);
    }


    public function getorderrevenueparties()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id  = isset($post['order_id']) ? $post['order_id'] : "";
        $shift_id  = isset($post['shift_id']) ? $post['shift_id'] : "";
        $rev_ids = isset($post['rev_ids']) ? $post['rev_ids'] : "";
        $type      = $this->input->post('type');
        $revenues  = array();
        if ($order_id != "" && $order_id != '0') {
            $revenue = $this->common->gettbldata(array('order_id' => $order_id, 'status' => 1, 'type' => '0'), '*', 'tb_reveneus', 0, 0);
        } else if ($shift_id != "" && $shift_id != '0') {
            $revenue = $this->common->gettbldata(array('shift_id' => $shift_id, 'status' => 1, 'type' => '0'), '*', 'trip_reveneus', 0, 0);
        } else {
            if (!empty($rev_ids)) {
                $getreveneus = $this->db->query("SELECT * FROM tb_reveneus WHERE id IN (" . implode(',', $rev_ids) . ") ");
                if ($getreveneus->num_rows() > 0) {
                    $revenue = $getreveneus->result_array();
                }
            }
        }
        if (!empty($revenue)) {
            foreach ($revenue as $res) {
                $invoice_status = $res['invoice_status'];
                $bill_id = $res['bill_id'];
                $bill_status = 0;
                if($bill_id >0){
                    $get_bill_status = $this->db->select("status")->get_where("tbl_bills",array('id'=>$bill_id));
                    if($get_bill_status->num_rows()>0){
                        $bill_status = $get_bill_status->row()->status;
                    }
                }
                $action_buttons =  $filetranfer_button = "";
                if($res['recipient_role'] == "Internal BU" && $res['invoice_status'] == '1'){
                    $filetranfer_button = "<li><a id='bElim' type='button' class=' btn btn-sm btn-default'  onclick='sendfiletoacon(" . $res['id'] . ",0)'><span class='glyphicon glyphicon-pencil' > </span>Send File to ACON</a></li>";
                }
                if($bill_status == 1 || $bill_status == 0){
                    if($res['recipient_role'] == "Internal BU" && $res['invoice_status'] >1 ){
                    }else{
                        $action_buttons = "<li><a id='bEdit'  type='button' class=' btn btn-sm btn-default'  onclick='rowEditrevenue(this," . $res['id'] . ")'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim'  type='button' class=' btn btn-sm btn-default' onclick='deleteorderevenue(" . $res['id'] . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li>" . $filetranfer_button;
                    }
                }
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . $action_buttons . "<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='revenuerowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add revenue</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  title='Add charges' onclick='getchargesbyrevenue(this," . $res['id'] . ")''><span class='fa fa-archive' > </span> Get charges</a></li></li></ul>";
                $inv_status = "";
                if($bill_status > 0){
                    if ($bill_status == '1') {
                        $inv_status = "Ready for Invocie";
                    }else{
                        $inv_status = "Billed";
                    }
                }else{
                    if ($res['invoice_status'] == '1' || $res['invoice_status'] == '2') {
                        $inv_status = "Ready for Invocie";
                    }else{
                        $inv_status = "";
                    }
                }
                $invoice_creation_date = $res['invoice_creation_date'];
                if ($invoice_creation_date != "0000-00-00 00:00:00" && $invoice_creation_date != "") {
                    $invoice_creation_date = $invoice_creation_date;
                } else {
                    $invoice_creation_date = "";
                }
                $invoice_receivdon_date = $res['invoice_receivdon_date'];
                if ($invoice_receivdon_date != "0000-00-00 00:00:00" && $invoice_receivdon_date != "") {
                    $invoice_receivdon_date = $invoice_receivdon_date;
                } else {
                    $invoice_receivdon_date = "";
                }
                $invoice_date = $res['invoice_date'];
                if ($invoice_date != "0000-00-00 00:00:00" && $invoice_date != "") {
                    $invoice_date = $invoice_date;
                } else {
                    $invoice_date = "";
                }
                if($res['bu_jfr'] == 0){
                    $res['bu_jfr'] = '';
                }
                $revenues[] = array('id' => $res['id'], 'order_id' => $order_id, 'recipient_role' => $res['recipient_role'], 'recipient_code' => $res['recipient_code'], 'recipient_name' => $res['recipient_name'], 'debtor_jfr' => $res['debtor_jfr'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'foreign_currency' => $res['foreign_currency'], 'exchange_rate' => $res['exchange_rate'], 'invoice_number' => $res['invoice_number'], 'credit_note_number' => $res['credit_note_number'], 'invoice_date' => $invoice_date, 'invoice_creation_date' => $invoice_creation_date, 'invoice_receivdon_date' => $invoice_receivdon_date, 'invoice_status' => $inv_status, 'action' => $action, 'accural_amount' => $res['accrual_amount'], 'actual_amount' => $res['actual_amount'], 'foreign_accuralamount' => $res['accrual_foreign_amount'], 'bu_jfr' => $res['bu_jfr']);
            }
        }
        echo json_encode($revenues);
    }

    public function getallcostrevenues()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $session_companycode = $this->session->userdata('company_code');
        $order_id        = isset($post['order_id']) ? $post['order_id'] : "0";
        $shift_id        = isset($post['shift_id']) ? $post['shift_id'] : "0";
        if($order_id == ""){
            $order_id = '0';
        }
        $rev_id = isset($post['rev_id']) ? $post['rev_id'] : "";
        $cost_id = isset($post['cost_id']) ? $post['cost_id'] : "";
        $reveneus        = $costs        = array();
        $totrevenue      = $totcost      = 0;
        $revenuecurrency = "";
        if ($order_id != "" && $order_id != '0') {
            $revenueresult = $this->common->gettbldata(array('order_id' => $order_id, 'status' => 1, 'type' => '0'), 'id,recipient_role,recipient_name,amount,currency', 'tb_reveneus', 0, 0);
        } else if ($shift_id != "" && $shift_id != "0") {
            $revenueresult = $this->common->gettbldata(array('shift_id' => $shift_id, 'status' => 1, 'type' => '0'), 'id,recipient_role,recipient_name,amount,currency', 'trip_reveneus', 0, 0);
        } else {
            if ($rev_id != '') {
                $rev_row_ids = array();
                $rev_row_ids = explode(',', $rev_id);
                $getrevenue = $this->db->query("SELECT * FROM tb_reveneus WHERE id IN (" . implode(',', $rev_row_ids) . ") AND status='1'");
                if ($getrevenue->num_rows() > 0) {
                    $revenueresult = $getrevenue->result_array();
                }
            }
        }
        $totalcharge = $totalbreakuprev = $tot_charge_rev = $totrevenue = 0;
        if (!empty($revenueresult)) {
            foreach ($revenueresult as $res) {
                $revenuecurrency = $res['currency'];
                if($this->session->userdata('company_code') == 'RUKN'){
                    if ($shift_id != "" && $shift_id != '0') {
                        $chargeresult = $this->common->gettblrowdata(array('revenue_id' => $res['id'], 'status' => '1'), 'sum(amount) as amount', 'trip_charges', 0, 0);
                    } else {
                        $chargeresult = $this->common->gettblrowdata(array('revenue_id' => $res['id'], 'status' => '1'), 'sum(amount) as amount', 'tb_charges', 0, 0);
                    }
                    if (!empty($chargeresult)) {
                        $totalcharge = $chargeresult['amount'];
                    }
                    $totrevenue += $totalcharge;
                }else{
                    $totrevenue += $res['amount'];
                }
                $totalbreakuprev += $res['amount'];
                $reveneus[] = array('id' => $res['id'], 'recipient_role' => $res['recipient_role'], 'name' => $res['recipient_name'], 'amount' => $res['amount'], 'currency' => $res['currency']);
            }
        }
        $revenuees_list = array();
        if (!empty($reveneus)) {
            foreach ($reveneus as $res) {
                $revenuees_list[] = "<li class='revenuelist-modal' id='revenue_" . $res['id'] . "' onclick='getcostlistbyrevenue(" . $res['id'] . ")' data-modalnav='" . $res['currency'] . "'><label>" . $res['name'] . "</label> <span class='amount'>" . floatval($res['amount']) . " " . $res['currency'] . "</span></li>";

            }
        }

        $data['reveneus']        = $reveneus;
        $data['revenuecurrency'] = $revenuecurrency;
        $data['totrevenue']      = $totrevenue;
        $data['revenuees_list']  = $revenuees_list;
        $totcost = 0;
        $costcurrency = "";
        $costs = array();
        if ($order_id != "" && $order_id != '0') {
            $costsresult = $this->common->gettbldata(array('order_id' => $order_id, 'status' => 1, 'type' => '1'), 'id,recipient_role,recipient_name,amount,currency', 'tb_reveneus', 0, 0);
        } else if ($shift_id != "" && $shift_id != '0') {
            $costsresult = $this->common->gettbldata(array('shift_id' => $shift_id, 'status' => 1, 'type' => '1'), 'id,recipient_role,recipient_name,amount,currency', 'trip_reveneus', 0, 0);
        } else {
            if ($cost_id != '') {
                $cost_row_ids = array();
                $cost_row_ids = explode(',', $cost_id);
                $getrevenue = $this->db->query("SELECT * FROM tb_reveneus WHERE id IN (" . implode(',', $cost_row_ids) . ") AND status='1'");
                if ($getrevenue->num_rows() > 0) {
                    $costsresult = $getrevenue->result_array();
                }
            }
        }
        $tot_charge_cost = $totcost = $total_cstcharge = $totalbreakupcost = 0;
        if (!empty($costsresult)) {
            foreach ($costsresult as $res) {
                $amount = $res['amount'];
                if($amount == ""){
                    $amount = 0.00;
                }
                $costcurrency = $res['currency'];
                if($this->session->userdata('company_code') == 'RUKN'){
                    if ($shift_id != "" && $shift_id != '0') {
                        $chargeresult = $this->common->gettblrowdata(array('revenue_id' => $res['id'], 'status' => '1'), 'sum(amount) as amount', 'trip_charges', 0, 0);
                    } else {
                        $chargeresult = $this->common->gettblrowdata(array('revenue_id' => $res['id'], 'status' => '1'), 'sum(amount) as amount', 'tb_charges', 0, 0);
                    }
                    if (!empty($chargeresult)) {
                        $total_cstcharge = $chargeresult['amount'];
                    }
                    $totcost += $total_cstcharge;
                }else{
                    $totcost += $amount;
                }
                $totalbreakupcost += $amount;
                $costs[] = '<li class="costlist-modal" id="cost_' . $res['id'] . '" onclick="getcostlistbycost(' . $res['id'] . ')" data-modalnav="dtdc"><label>' . $res['recipient_name'] . '</label> <span class="amount">' . floatval($amount) . ' ' . $res['currency'] . '</span></li>';
            }
        }
        $data['costs']                 = $costs;
        $data['costcurrency']          = $costcurrency;
        $data['totcost']               = $totcost;
        $data['totalbreakuprev']       = $totalbreakuprev;
        $data['totalbreakupcost']      = $totalbreakupcost;
        $data['profit']                = 0;
        if ($totrevenue > 0) {
            $profit = ($totrevenue - $totcost);
            if($session_companycode == "VNKN"){
                $data['profit'] = round($profit);
            }else{
                $data['profit'] = round($profit,2);
            }
        }

        echo json_encode($data);
    }
    public function getallchargesbyid()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $session_companycode = $this->session->userdata("company_code");
        $id   = isset($post['id']) ? $post['id'] : "";
        $shift_id   = isset($post['shift_id']) ? $post['shift_id'] : "";
        $list = array();
        if ($id != "") {
            if (!empty($shift_id)) {
                $chargesresult = $this->common->gettbldata(array('revenue_id' => $id, 'status' => '1'), 'description,amount,currency,vat_percentage,vat_amount', 'trip_charges', 0, 0);
            } else {
                $chargesresult = $this->common->gettbldata(array('revenue_id' => $id, 'status' => '1'), 'description,amount,currency,vat_percentage,vat_amount', 'tb_charges', 0, 0);
            }
            if (!empty($chargesresult)) {
                foreach ($chargesresult as $res) {
                    if($res['amount'] >0){
                        $list[] = "<li><label>" . $res['description'] . " </label> <span class='amount'>" . floatval($res['amount']) . " " . $res['currency'] . "</span></li>";
                    }
                    if(($res['vat_percentage'] > 0) && ($res['vat_amount']  > 0)){
                        $vat_name = "VAT";
                        if($session_companycode == "SGKN"){
                            $vat_name = "GST";
                        }
                        $list[] = "<li><label>" .$vat_name." ". $res['vat_percentage']." %". " </label> <span class='amount'>" . floatval($res['vat_amount']) . " " . $res['currency'] . "</span></li>";
                    }
                }
            }
        }
        echo json_encode($list);
    }

    public function getratecalendar(){
        $dates = $data = array();
        $order_id= $this->input->post('order_id');
        $date =date('Y-m-d');
        for($i=0;$i<=15;$i++){
            $dates[$i] = date('d',strtotime($date. '+'.$i.' days'));
        }
        $data['dates'] = $dates;
        $data['order_id'] = $order_id;
        echo $this->load->view('orders/getcalendar',$data,TRUE);
    }

    public function getcostbytat(){
        $dates = $data = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id       = isset($post['order_id']) ? $post['order_id'] : "0";
        $user_id        = $this->session->userdata('user_id');
        $company_code   = $this->session->userdata('company_code');
        $branch_code    = $this->session->userdata('branch_code');
        $data['user_id'] = $user_id;
        $carrier = array();
        if($company_code == 'RUKN'){
            $carrier = $this->common->gettbldata(array('company_code'=>$company_code,'status' => '1'),"id,name,code","tb_vendors",0,0);
        }else{
            $carrier = $this->common->gettbldata(array('user_id'=>$user_id,'status' => '1'),"id,name,code","tb_vendors",0,0);
        }
        $result = array();
        if(!empty($carrier)){
            foreach ($carrier as $car) {
                if($car['code'] != ""){
                    $first = rand(11,222);
                    $second = $first * 0.95;
                    $third = $second * 0.98;
                    $fourth = $third * 0.9;
                    $result[] = array('id'=>$car['id'],'name'=>$car['name'],'code'=>$car['code'],'first'=>$first,'second'=>$second,'third'=>$third,'fourth'=>$fourth);
                }
            }
        }
        $data['order_id'] = $order_id;
        $data['carriers']  = $result;
        echo $this->load->view('orders/cost_bytat',$data,TRUE);
    }

    public function getcost_bytatfororder(){
        $cdate = date('Y-m-d H:i:s');
        $post = array();
        $session_companycode = $this->session->userdata('company_code');
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $cid = isset($post['cid']) ? $post['cid'] : "0";
        $amount = isset($post['amount']) ? $post['amount'] : "0";
        $cname = isset($post['cname']) ? $post['cname'] : "0";
        $currency = $this->session->userdata("usr_tzone")['currency'];
        $user_id =  $this->session->userdata('user_id');
        if($amount >0){
            $debtor_jfr ="";
            $charge_amount = $amount;
            $charge_amount = round($amount,2);
            $rev_ar = array('type'=>'1','order_id'=>$order_id,'recipient_role'=>'Carrier','recipient_code'=>$cid,'recipient_name'=>$cname,'debtor_jfr'=>$debtor_jfr,'amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $re_qry = $this->db->insert("tb_reveneus",$rev_ar);
            $revenue_id = $this->db->insert_id();
            $charges_ar = array('revenue_id'=>$revenue_id,'charge_code'=>'38','description'=>'Freight Charges','quantity_unit'=>'1','value'=>'1','rate_id'=>'1','amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'local_amount'=>$charge_amount,'local_currency'=>$currency,'createdon'=>$cdate);
            $ins = $this->db->insert("tb_charges",$charges_ar);
            if($ins){
                echo "1";
            }else{
                echo "0";
            }
        }else{
            echo "1";
        }

    }


    public function addrevenuebycalendar(){
        $cdate = date('Y-m-d H:i:s');
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $session_companycode = $this->session->userdata('company_code');
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $amount = isset($post['amount']) ? $post['amount'] : "0";
        if($order_id != '0'){
            $currency = $this->session->userdata("usr_tzone")['currency'];
            $user_id = $this->session->userdata('user_id');
            $customer_name ="Customer";
            $customer_code = "0";
            $getcustomer_id = $this->db->query("select c.name,c.code  from tb_customers c,tb_orders o where c.id=o.customer_id and o.id='".$order_id."'");
            if($getcustomer_id->num_rows()>0){
                $customer_name = $getcustomer_id->row()->name;
                $customer_code = $getcustomer_id->row()->code;
            }
            $debtor_jfr = "";
            $charge_amount = $amount;
            $charge_amount = round($amount,2);
            $rev_ar = array('type'=>'0','order_id'=>$order_id,'recipient_role'=>'Customer','recipient_code'=>$customer_code,'recipient_name'=>$customer_name,'debtor_jfr'=>$debtor_jfr,'amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate,);
            $re_qry = $this->db->insert("tb_reveneus",$rev_ar);
            $revenue_id = $this->db->insert_id();
            $charges_ar = array('revenue_id'=>$revenue_id,'charge_code'=>'38','description'=>'Freight Charges','quantity_unit'=>'1','value'=>'1','rate_id'=>'1','amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'local_amount'=>'0.0000','createdon'=>$cdate);
            $ins = $this->db->insert("tb_charges",$charges_ar);
            if($ins){
                echo "1";
            }else{
                echo "0";
            }

        }
    }

    public function addcostbycalendar(){
        $cdate = date('Y-m-d H:i:s');
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $amount = isset($post['amount']) ? $post['amount'] : "0";
        $company_code  = $session_companycode = $this->session->userdata('company_code');
        $user_whr = "m.user_id ='".$user_id."'";
        if($company_code == "RUKN"){
            $user_whr = "m.company_code LIKE '".$company_code."' ";
        }else{
            $user_whr = "m.user_id ='".$user_id."'";
        }
        if($order_id != '0'){
            $currency = $this->session->userdata("usr_tzone")['currency'];
            $user_id = $this->session->userdata('user_id');
            $customer_name ="Carrier";
            $customer_code = "0";
            $this->db->select("m.name,m.code");
            $this->db->from("tbl_party_master m");
            $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
            $this->db->like("p.name", 'Carrier');
            $this->db->where($user_whr);
            $where = "m.acon_debitor_code is  NOT NULL";
            $this->db->where($where);
            $this->db->order_by('m.id', 'DESC');
            $getroles = $this->db->get();
            if($getroles->num_rows() >0){
                $customer_name = $getroles->row()->name;
                $customer_code = $getroles->row()->code;
            }
            $debtor_jfr ="";
            $charge_amount = $amount;
            $charge_amount = round($amount,2);
            $rev_ar = array('type'=>'1','order_id'=>$order_id,'recipient_role'=>'Carrier','recipient_code'=>$customer_code,'recipient_name'=>$customer_name,'debtor_jfr'=>$debtor_jfr,'amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'createdon'=>$cdate);
            $re_qry = $this->db->insert("tb_reveneus",$rev_ar);
            $revenue_id = $this->db->insert_id();
            $charges_ar = array('revenue_id'=>$revenue_id,'charge_code'=>'38','description'=>'Freight Charges','quantity_unit'=>'1','value'=>'1','rate_id'=>'1','amount'=>$charge_amount,'currency'=>$currency,'status'=>'1','user_id'=>$user_id,'local_amount'=>$charge_amount,'local_currency'=>$currency,'createdon'=>$cdate);
            $ins = $this->db->insert("tb_charges",$charges_ar);
            if($ins){
                echo "1";
            }else{
                echo "0";
            }

        }
    }

    public function gettotalamount_ofrevenue($revenue_id){
    $total_amount    = 0;
    $order_id = 0;
    $session_currency = $this->session->userdata("usr_tzone")['currency'];
    $company_code = $this->session->userdata('company_code');
    if($company_code == "PLKN"){
        $session_currency = 'PLN';
    }

    $exchange_rate = 0;
    $getorderid = $this->common->gettblrowdata(array('id'=>$revenue_id),"order_id,exchange_rate",'tb_reveneus',0,0);
    if(!empty($getorderid)){
        $order_id= $getorderid['order_id'];
        $exchange_rate= $getorderid['exchange_rate'];
    }
    $foreign_currency = "";
    $getcurrency  =$this->db->query("SELECT currency FROM tb_charges WHERE revenue_id ='".$revenue_id."' AND currency NOT LIKE '".$session_currency."'");
    if($getcurrency->num_rows() >0){
        $foreign_currency = $getcurrency->row()->currency;
    }

    if($order_id == ""){
        $order_id = 0;
    }
    if($foreign_currency != ""){
        $user_id = $this->session->userdata('user_id');
        $info = array('exchange_rate_id'=>'0','from_currency'=>$foreign_currency,'to_currency'=>$session_currency,'user_id'=>$user_id,'order_id'=>$order_id,'revenue_id'=>$revenue_id);
        $exchange_rate_amount = $exchange_rate;
        if($exchange_rate == "0" || $exchange_rate == ""){
            $exchange_rate_amount = $this->ratemanagement->getexchnageamountfromcurrency($info);
        }else{
            $exchange_rate_amount = $exchange_rate;
        }
       if($exchange_rate_amount > 0){
            $this->exchangerate->updatelocalamout_byexchangerate($revenue_id,$exchange_rate_amount,$foreign_currency);
        }else{
            $upd_examount = $this->common->updatetbledata("tb_reveneus",array('foreign_currency'=>$foreign_currency),array('id'=>$revenue_id));
        }
    }
    $upd_revenue = $this->exchangerate->updatetotal_amountforrev($revenue_id);

    $chck_limit = $this->ratemanagement->updateutilizedamount_fororder($order_id);

    return $total_amount;
}
    public function makeselectedasinvoice(){
        ini_set('max_execution_time', 300);
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $from_date = isset($post['fromdate']) ? $post['fromdate'] : date('Y-m-d H:i:s');
        $order_ids = isset($post['order_ids']) ? $post['order_ids'] : array();
        $user_id = $this->session->userdata("user_id");
        $upd = array();
        if(!empty($order_ids)){
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $info = array('order_ids'=>$order_ids,'curtz'=>$curtz,'user_id'=>$user_id);
            $chk_exchange = $this->exchangerate->checkorderrevenuecurrency($order_ids);
            $upd = makeselectedordersasinvoice($info);
        }

        echo json_encode($upd,128);
    }

    public function getorderids()
    {
        $post = $this->input->post(null, true);
        echo json_encode(
            $this->searchservice->searchForBookingIds(
                $post['searchTerm'] ?? ''
            )
        );
    }

    public function getorderids_xborder(){
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $company_code = $this->session->userdata('company_code');
        $orderids = array();
        if($company_code != ""){
            $getxborder = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$company_code,'status'=>'1','reference_id'=>'XBRDR'));
            if($getxborder->num_rows() >0){
                foreach($getxborder->result() as $row){
                    $orderids[] = $row->order_id;
                }
            }
        }
        $getorderids = $this->Order->getorderids_xborder($orderids,$searchTerm);
        if($getorderids->num_rows()>0){
            foreach ($getorderids->result() as $res) {
                $data[] = array("id"=>$res->order_id, "text"=>$res->order_id);
            }
        }
        echo json_encode($data);
    }

    public function getreferencedeliverynote(){
        $cid = $this->session->userdata("cust_id");
        $subcusts = $post = array();
        $post = $this->input->post(NULL,TRUE);
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $cid);
            }
        }
        $data = array();
        $whr1 = "";
        if(!empty($subcusts)){
            $whr1 .= " AND o.customer_id IN (".implode(',', $subcusts).") ";
        }else{
            $whr1 .= " AND o.customer_id=".$cid." ";
        }
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        if($searchTerm != ""){
            $whr1 .= " AND r.ref_value LIKE '%".$searchTerm."%' ";
        }
        $orderref = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE r.order_id=o.id $whr1 AND r.status=1 GROUP BY r.id");
        if($orderref->num_rows() >0){
            foreach($orderref->result_array() as $ores){
                $data[] = array("id"=>$ores['ref_value'], "text"=>$ores['ref_value']);
            }
        }
        echo json_encode($data);
    }

    public function getorderidsbycustid(){
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $subcusts = array();
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $custid = $this->session->userdata("cust_id");
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $custid);
            }else{
                $subcusts = array($custid);
            }
        }else{
            $subcusts = array($custid);
        }
        $getorderids = $this->Order->getorderids($user_id,$subcusts,$searchTerm);
        if($getorderids->num_rows()>0){
            foreach ($getorderids->result() as $res) {
                $data[] = array("id"=>$res->order_id, "text"=>$res->order_id);
            }
        }
        echo json_encode($data);
    }

    public function getorderidsbyvendorid(){
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $subcusts = array();
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $vendor_id = $this->session->userdata("id");
        $where = array('vendor_id'=>$vendor_id,'status !='=>'0');
        $select = "order_id";
        $table = "tb_orders";
        $getorderids = $this->common->gettbldata($where,$select,$table,0,0);
        if(!empty($getorderids)){
            foreach ($getorderids as $res) {
                $data[] = array("id"=>$res['order_id'], "text"=>$res['order_id']);
            }
        }
        echo json_encode($data);
    }
    public function getlaneids_byservice(){
        $lanes = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $service_id = isset($post['service_id']) ?$post['service_id'] : "";
        $order_id = isset($post['order_id']) ?$post['order_id'] : "";
        $consignee_country = isset($post['consignee_country']) ?$post['consignee_country'] : "";
        $shipper_country = isset($post['shipper_country']) ?$post['shipper_country'] : "";
        $shipper_city = isset($post['shipper_city']) ?$post['shipper_city'] : "";
        $consignee_city = isset($post['consignee_city']) ?$post['consignee_city'] : "";
        $shipper_zipcode = isset($post['shipper_zipcode']) ?$post['shipper_zipcode'] : "";
        $consignee_zipcode = isset($post['consignee_zipcode']) ?$post['consignee_zipcode'] : "";
        $source = array('consignee_country'=>$consignee_country,'shipper_country'=>$shipper_country,'shipper_city'=>$shipper_city,'consignee_city'=>$consignee_city,'shipper_zipcode'=>$shipper_zipcode,'consignee_zipcode'=>$consignee_zipcode);
        $lanes = $this->ratemanagement->getlaneids_byservice($service_id,$order_id,$source);
        echo json_encode($lanes);
    }
    public function getoffering_bylane(){
        $offering = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $lane_id =  isset($post['lane_id']) ? $post['lane_id'] : "";
        $type =  isset($post['type']) ? $post['type'] : "0";
        $service_id =  isset($post['service_id']) ? $post['service_id'] : "0";
        $rate_service =  isset($post['rate_service']) ? $post['rate_service'] : "0";
        $order_id =  isset($post['order_id']) ? $post['order_id'] : "0";
        if($lane_id != '' && $lane_id != '0'){
            $offering = $this->ratemanagement->getoffering_bylane($lane_id,$type,$service_id,$rate_service,$order_id);
        }
        echo json_encode($offering);

    }
    public function getrecord_byoffering(){
        $record = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $offering_id =  isset($post['offering_id']) ? $post['offering_id'] : "";
        $order_id =  isset($post['order_id']) ? $post['order_id'] : "";
        if($offering_id != '' && $offering_id != '0'){
            $record = $this->ratemanagement->getrecord_byoffering($offering_id,$order_id);
        }
        echo json_encode($record);

    }
    public function addrevchargesbyrecord(){

        $cdate = date('Y-m-d H:i:s');
        $response = array();
        $sts = 0;
        $rr_tier_id = $geo_tier_id = null;
        $geo_sts = $rate_sts= $stsid = 1;
        $charge_type = $base_uom ="";
        $user_id = $this->session->userdata('user_id');
        $currency = $this->session->userdata("usr_tzone")['currency'];
        $post = $this->input->post();
        $addrecord = $this->ratemanagement->addrevchargesbyrecord($post,$user_id,$currency);
        $offering = isset($post['rate_offering']) ? $post['rate_offering'] : "";
        $rate_service = isset($post['rate_service']) ? $post['rate_service'] : "";
        $order_id = isset($post['order_id']) ? $post['order_id'] : "";
        $record = isset($post['record']) ? $post['record'] : "";
        $type = isset($post['type']) ? $post['type'] : "";
        if($type == '0'){
            $type = "SELL";
        }else{
            $type = "BUY";
        }
        $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
        if($record != "" && !is_null($record)){

            $where = array('raterecord_id'=>$record,'status'=>'1');
            $select = "rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,exchange_rate_id,min_amount,amount,currency";
            $table = "tb_raterecord_charges";
            $getcharges = $this->common->gettbldata($where,$select,$table,0,0);
            if(!empty($getcharges)){
                foreach ($getcharges as $row) {
                    $base_uom = "";
                    $rr_tier_id = $geo_tier_id = null;
                    $charge_basis = strtoupper($row['charge_basis']);
                    $charge_type = strtoupper($row['rr_charge_type']);
                    $amount = $row['amount'];
                    if($charge_type == 'FIXED'){
                        if($charge_basis == 'PER KG' || $charge_basis == 'KG' || $charge_basis == 'PER CBM' || $charge_basis == 'CBM'){
                            $base_uom = $charge_basis;
                            if($charge_basis == 'PER KG' || $charge_basis == 'KG'){
                                $base_uom = 'KG';
                            }
                            if($charge_basis == 'PER CBM' || $charge_basis == 'CBM'){
                                $base_uom = 'CBM';
                            }
                        }
                        $stsid = $this->chekconversion_baseuom($offering,$base_uom,$order_id,$type);
                    }
                    if($charge_type == 'TIER'){
                        $uom = "";
                        $rr_tier_id = $row['rr_tier_id'];
                        $getratetier = $this->common->gettblrowdata(array('id'=>$rr_tier_id,'user_id'=>$user_id,'status'=>'1'),"billing_uom","tb_tier_master",0,0);
                        if(!empty($getratetier)){
                            $billing_uom = $getratetier['billing_uom'];
                            if($billing_uom != ""){
                                if($billing_uom == 'WEIGHT' || $billing_uom == 'ACTUAL WEIGHT'){
                                    $uom = 'KG';
                                }
                                if($billing_uom == 'VOLUME' || $billing_uom == 'ACTUAL VOLUME'){
                                    $uom = 'CBM';
                                }
                                if($billing_uom == 'LDM'){
                                    $uom = 'LDM';
                                }
                            }
                            if($uom != ""){
                                $rate_sts = $this->chekconversion_baseuom($offering,$uom,$order_id,$type);
                            }
                        }

                    }if($charge_type == 'GEO TIER'){
                        $geo_tier_id = $row['geo_tier_id'];
                        $getgeotier = $this->common->gettblrowdata(array('id'=>$geo_tier_id,'status'=>'1'),"unit_measure1","tb_geo_tier",0,0);
                        if(!empty($getgeotier)){
                            $unit_measure1 = $getgeotier['unit_measure1'];
                            $geo_sts = $this->chekconversion_baseuom($offering,$unit_measure1,$order_id,$type);
                        }

                    }

                }
                if($stsid == "0"){
                    $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
                }
            }
            $response = array('sts'=>$sts,'rate_sts'=>$rate_sts,'geo_sts'=>$geo_sts,'stsid'=>$stsid);

        }
        echo json_encode($response);

    }

    public function chekconversion_baseuom($offering,$base_uom,$order_id,$type){
        $stsid = 0;
        $user_id = $this->session->userdata('user_id');
        $getconversion_id = $this->common->gettblrowdata(array('id'=>$offering,'status'=>'1'),"uom_conversion_id","tb_rate_offerings",0,0);
        if(!empty($getconversion_id)){
            $conversion_id = $getconversion_id['uom_conversion_id'];
            if($conversion_id != "" && $conversion_id != "0"){
                $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
                $country_code  = $get_country->row()->country_code;
                $company_code  = $get_country->row()->company_code;
                $getchargeable_weight = $this->common->gettblrowdata(array('id'=>$conversion_id,'country'=>$country_code,'type'=>$type,'base_uom'=>$base_uom,'status'=>'1'),"uom_type1,uom1,uom1_conversion,uom_type2,uom2,uom2_conversion,uom_type3,uom3,uom3_conversion,uom_type4,uom4,uom4_conversion,customer_id","tb_knuom_conversion",0,0);
                if(!empty($getchargeable_weight)){
                    $customer_id = $getchargeable_weight['customer_id'];
                    if($customer_id != "0" && $customer_id != ""){
                        $chkordercustomer = $this->common->gettblrowdata(array('id'=>$order_id),"customer_id","tb_orders",0,0);
                        if(!empty($chkordercustomer)){
                            $order_customer_id = $chkordercustomer['customer_id'];
                            if($order_customer_id == $customer_id){
                                $stsid = 1;
                            }else{
                                $stsid =0;
                            }
                        }
                    }else{
                        $stsid = 1;
                    }
                    $total_conversion1 = $total_conversion2 = $total_conversion3 = $total_conversion4 = array('sts'=>'0','total_amount'=>'1');
                    if($stsid == '1'){
                        $uom1 = $getchargeable_weight['uom1'];
                        if($uom1 != ""){
                            $uom1_conversion = $getchargeable_weight['uom1_conversion'];
                            $uom_type1 = $getchargeable_weight['uom_type1'];
                            $total_conversion1 = $this->ratemanagement->getconversionableamount($uom1,$uom_type1,$uom1_conversion,$order_id);
                        }
                        $uom2 = $getchargeable_weight['uom2'];
                        if($uom2 != ""){
                            $uom2_conversion = $getchargeable_weight['uom2_conversion'];
                            $uom_type2 = $getchargeable_weight['uom_type2'];
                            $total_conversion2 = $this->ratemanagement->getconversionableamount($uom2,$uom_type2,$uom2_conversion,$order_id);
                        }
                        $uom3 = $getchargeable_weight['uom3'];
                        if($uom3 != ""){
                            $uom3_conversion = $getchargeable_weight['uom3_conversion'];
                            $uom_type3 = $getchargeable_weight['uom_type3'];
                            $total_conversion3 = $this->ratemanagement->getconversionableamount($uom3,$uom_type3,$uom3_conversion,$order_id);
                        }
                        $uom4 = $getchargeable_weight['uom4'];
                        if($uom4 != ""){
                            $uom4_conversion = $getchargeable_weight['uom4_conversion'];
                            $uom_type4 = $getchargeable_weight['uom_type4'];
                            $total_conversion4 = $this->ratemanagement->getconversionableamount($uom4,$uom_type4,$uom4_conversion,$order_id);
                        }
                        $final_conversion1 = $final_conversion2 = $final_conversion3 = $final_conversion4 = "0";
                        if($total_conversion1['sts'] == '1'){
                            $final_conversion1 = $total_conversion1['total_amount'];
                        }
                        if($total_conversion2['sts'] == '1'){
                            $final_conversion2 = $total_conversion2['total_amount'];
                        }
                        if($total_conversion3['sts'] == '1'){
                            $final_conversion3 = $total_conversion3['total_amount'];
                        }
                        if($total_conversion4['sts'] == '1'){
                            $final_conversion4 = $total_conversion4['total_amount'];
                        }
                        $final_conversion = max($final_conversion1,$final_conversion2,$final_conversion3,$final_conversion4);
                    }
                }else{
                    $stsid == "0";
                    $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
                }
            }else{
                $stsid = 1;
            }
        }
        return $stsid;
    }
    public function getordervasdetails(){
        $result = $getvasname = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        $company_code = $this->session->userdata('company_code');
        if($order_id != "" && $order_id != '0'){
            $getvas = $this->common->gettbldata(array('order_id'=>$order_id,'status'=>'1'),'id,vas_id,quantity',"tb_order_vas",0,0);
            if(!empty($getvas)){
                foreach($getvas as $res){
                    $vas_id = $vas_name = $vas_row_id = $res['vas_id'];
                    if($company_code == 'RUKN'){
                        $getvasname = $this->common->gettblrowdata(array('id'=>$vas_id,'company_code'=>$company_code),'id,vas_id,vas_name',"tb_vas_master",0,0);
                    }else{
                        $getvasname = $this->common->gettblrowdata(array('id'=>$vas_id,'company_code!='=>$company_code),'id,vas_id,vas_name',"tb_vas_master",0,0);
                    }
                    if(!empty($getvasname)){
                        $vas_name = $getvasname['vas_name'];
                        $vas_id = $getvasname['vas_id'];
                        $vas_row_id = $getvasname['id'];
                    }
                    $vasname = '"' . $vas_name . '"';
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='editvasorderedetails(this," . $res['id'] . "," . $vas_row_id . "," . $res['quantity'] . "," . $vasname . ")'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletevasdetailsbyorder(" . $res['id'] . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='vasrowadd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Row</a></li>";
                    $result[] = array(
                        'id' => $res['id'],
                        'vas_id' => $vas_id,
                        'vas_name' => $vas_name,
                        'quantity' => $res['quantity'],
                        'action' => $action
                    );
                }
            }
        }
        echo json_encode($result);
    }

    public function deletevasdetailsbyorder(){
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $row_id = isset($post['vas_id']) ? $post['vas_id'] : "0";
        if($row_id != "" && $row_id != '0'){
            $upd = $this->common->updatetbledata("tb_order_vas",array('status'=>'0'),array('id'=>$row_id));
        }
        echo "1";
    }

    public function addvasorderdetails(){
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post();
        $order_id = isset($post['vas_order_id']) ? $post['vas_order_id']: 0;
        $vas_id = isset($post['vas_id']) ? $post['vas_id']: 0;
        $quantity = isset($post['vas_quantity']) ? $post['vas_quantity'] : '1';
        $row_id = isset($post['vasrow_id']) ? $post['vasrow_id'] : '0';
        if($row_id == ""){
            $row_id =0;
        }
        if($row_id == '0'){
            $ins = array('order_id'=>$order_id,'vas_id'=>$vas_id,'quantity'=>$quantity,'user_id'=>$user_id,'status'=>'1','createdon'=>$cdate);
            $chkvas = $this->common->gettblrowdata(array('vas_id'=>$vas_id,'order_id'=>$order_id,'status'=>'1'),"id,quantity","tb_order_vas",0,0);
            if(!empty($chkvas)){
                $present_quantity = $chkvas['quantity'];
                $vas_row_id = $chkvas['id'];
                if($vas_row_id != "0"){
                    $total_quantity = $quantity + $present_quantity;
                    $newupd = $this->common->updatetbledata("tb_order_vas",array('quantity'=>$total_quantity),array('id'=>$vas_row_id));
                }
            }else{
                $this->common->insertTableData("tb_order_vas",$ins);
            }
        }else{
            $upd = array('vas_id'=>$vas_id,'quantity'=>$quantity);
            $this->common->updatetbledata("tb_order_vas",$upd,array('id'=>$row_id));
        }
        echo "1";
    }
    public function getservicefor_neworder(){
        $services = $post = array();
        $post = $this->input->post(NULL,TRUE);
        $user_id = $this->session->userdata('user_id');
        $customer_id = isset($post['customer_id']) ? $post['customer_id'] : "";
        $pickup_country = isset($post['shipper_country']) ? $post['shipper_country'] : "";
        $delivery_country = isset($post['consignee_country']) ? $post['consignee_country'] : "";
        $pickup_pincode = isset($post['shipper_zipcode']) ? $post['shipper_zipcode'] : "";
        $delivery_pincode = isset($post['consignee_zipcode']) ? $post['consignee_zipcode'] : "";
        $service_id = isset($post['service_id']) ? $post['service_id'] : "";
        $product = isset($post['product']) ? $post['product'] : "";
        $pickup_location =  array('country'=>$pickup_country,'zipcode'=>$pickup_pincode,'user_id'=>$user_id);
        $delivery_location = array('country'=>$delivery_country,'zipcode'=>$delivery_pincode,'user_id'=>$user_id);
        $info = array('order_id'=>'0','product'=>$product);
        $services =$this->ratemanagement->getcustomerprofiledetailsbyid($customer_id,$service_id,$pickup_location,$delivery_location,$info);
        echo json_encode($services);

    }
    public function checkorderexceededornot(){

        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        if($order_id == ""){
            $order_id = '0';
        }
        $credit_utilized_amount = $credit_limit_amount = 0;
        $hold_type = 0;
        if($order_id != "0"){
            $chkexceed = $this->common->gettblrowdata(array('id'=>$order_id),"user_id,customer_id,hold_type,credit_approval","tb_orders",0,0);
            if(!empty($chkexceed)){
                $hold_type = $chkexceed['hold_type'];
                $user_id = $chkexceed['user_id'];
                $credit_approval = $chkexceed['credit_approval'];
                if($credit_approval == '0'){
                    if($hold_type == '2' || $hold_type == '3'){
                        $customer_id = $chkexceed['customer_id'];
                        if($customer_id != 0 && $customer_id != ""){
                            $getamount= $this->db->query("SELECT m.credit_limit_amount,m.credit_utilized_amount FROM tbl_party_master m,tb_customers c WHERE m.code =c.code AND m.user_id='".$user_id."' AND c.id='".$customer_id."'");
                            if($getamount->num_rows() >0){
                                $credit_limit_amount = $getamount->row()->credit_limit_amount;
                                $credit_utilized_amount = $getamount->row()->credit_utilized_amount;
                            }
                        }
                        if($credit_limit_amount >$credit_utilized_amount){
                            $hold_type = '0';
                        }
                    }
                }
            }
        }
        echo json_encode($hold_type);


    }
    public function getchargedescnvat(){
        $post = $this->input->post();
        $chargecodeid = isset($post['chargecodeid']) ? $post['chargecodeid'] : '0';
        $revenue_id = isset($post['revenue_id']) ? $post['revenue_id'] : '0';
        $shipper_city = isset($post['shipper_city']) ? $post['shipper_city'] : "";
        $shipper_state = isset($post['shipper_state']) ? $post['shipper_state'] : "";
        $shipper_country = isset($post['shipper_country']) ? $post['shipper_country'] : "";
        $consignee_city = isset($post['consignee_city']) ? $post['consignee_city'] : "";
        $consignee_state = isset($post['consignee_state']) ? $post['consignee_state'] : "";
        $consignee_country = isset($post['consignee_country']) ? $post['consignee_country'] : "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $session_companycode =$this->session->userdata('company_code');
        $source = array('1'=>ltrim($shipper_country),'2'=>ltrim($shipper_state),'3'=>ltrim($shipper_city));
        $destination = array('1'=>ltrim($consignee_country),'2'=>ltrim($consignee_state),'3'=>ltrim($consignee_city));
        $vatdetails = $result = array();
        $result['vat_percentage'] = $result['cat_id'] = $result['cat_val'] ="";
        $result['desc'] = "";
        if ($chargecodeid != "") {
            $getdesc = $this->db->query("SELECT description FROM tb_charge_codes WHERE id=$chargecodeid AND status=1");
            if ($getdesc->num_rows() > 0) {
                $result['desc'] = $getdesc->row()->description;
            }
        }
        $custcode = $type = 0;
        if ($revenue_id != "") {
            $getcodetype = $this->db->query("SELECT recipient_code,type FROM tb_reveneus WHERE id=$revenue_id AND status=1");
            if ($getcodetype->num_rows() > 0) {
                $custcode = $getcodetype->row()->recipient_code;
                $type = $getcodetype->row()->type;
            }
        }
        $data = array('custcode'=>$custcode,'chargecodeid'=>$chargecodeid,'user_id'=>$user_id,'company_code'=>$company_code,'type'=>$type);
        $vatdetails = $this->Order->getvatdetails($data);
        if(!empty($vatdetails)){
            foreach($vatdetails as $res){
                $source_geo = $res['source_geo'];
                $destination_geo = $res['destination_geo'];
                $source_country = ltrim($res['source_country']);
                $destination_country = ltrim($res['destination_country']);
                if(strcasecmp($source[$source_geo],$source_country) == 0 && strcasecmp($destination[$destination_geo],$destination_country) == 0 ){
                    $final_vat = $res['vat'];
                    if($session_companycode == "VNKN"){
                        $final_vat = round($res['vat']);
                    }else{
                        $final_vat = round($res['vat'],2);
                    }
                    $result['vat_percentage'] = $final_vat;
                    $result['cat_id'] = $res['cat_id'];
                    $result['cat_val'] = $res['cat_val'];
                }
            }
        }else{
            $vatgeneric = $this->Order->getvatgeneric($data);
            if(!empty($vatgeneric)){
                foreach($vatgeneric as $res){
                    $source_geo = $res['source_geo'];
                    $destination_geo = $res['destination_geo'];
                    $source_country = ltrim($res['source_country']);
                    $destination_country = ltrim($res['destination_country']);
                    if(strcasecmp($source[$source_geo],$source_country) == 0 && strcasecmp($destination[$destination_geo],$destination_country) == 0 ){
                        $final_vat = $res['vat'];
                        if($session_companycode == "VNKN"){
                            $final_vat = round($res['vat']);
                        }else{
                            $final_vat = round($res['vat'],2);
                        }
                        $result['vat_percentage'] =$final_vat;
                        $result['cat_id'] = $res['cat_id'];
                        $result['cat_val'] = $res['cat_val'];
                    }
                }
            }
        }
        echo json_encode($result);
    }
    public function getvatcatgeorydetails(){
        $post = $this->input->post();
        $data = array('vat_category'=>0,'vat_percentage'=>0,'cat_val'=>"");
        $cat_id = (isset($post['vat_category']) && !empty($post['vat_category'])) ? $post['vat_category'] : "0";
        if($cat_id >0){
            $getvatcat = $this->common->gettblrowdata(array('id'=>$cat_id,'status'=>'1'),"vat_category,vat_percentage","tb_vat_category",0,0);
            if(!empty($getvatcat)){
                $data = array('cat_id'=>$cat_id,'vat_percentage'=>$getvatcat['vat_percentage'],'cat_val'=>$getvatcat['vat_category']);
            }
        }
        echo json_encode($data);
    }
    public function getallloadplanconnote(){
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $orderid = isset($post['orderid']) ? $post['orderid'] : "0";
        $refvals = " ";
        $refs = array();
        if($orderid != "0"){
            $getrefs = $this->common->gettbldata(array('order_id'=>$orderid,'reference_id'=>'LPC','status' => '1'),"ref_value","tb_order_references",0,0);
            if(!empty($getrefs)){
                foreach ($getrefs as $res) {
                    $refs[] = $res['ref_value'];
                }
                $refvals  = implode(" , ", $refs);
            }
        }
        echo json_encode($refvals);
    }
    public function getbu_jfrfrompq(){
        $post = array();
        $ref_value = "";
        $post = $this->input->post(null, true);
        $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
        if ($order_id > 0) {
            $getrefs = $this->common->gettblrowdata(
                array('order_id' => $order_id, 'reference_id' => 'PQ', 'status' => '1'),
                "ref_value",
                "tb_order_references",
                0,
                0
            );
            if (!empty($getrefs)) {
                $ref_value = $getrefs['ref_value'];
            }
        }
        echo json_encode($ref_value);
    }

    public function getVehicleDetailsByCarrierInfo(): void
    {
        $data = [];
        $post = $this->input->post();
        $carrierId = $post['carrierId'] ?? 0;
        $vehicleType = $post['vehicleType'] ?? 0;
        $carrierCode = "";
        if ($vehicleType > 0) {
            $getVehicleType = $this->common->gettblrowdata(['id' => $vehicleType], "trucktype", "tb_trucktypes", 0, 0);
            if (!empty($getVehicleType)) {
                $vehicleTypeName = $getVehicleType['trucktype'];
            }
        }
        if ($carrierId > 0) {
            $getCarrierName = $this->common->gettblrowdata(
                ['id' => $carrierId, 'status' => '1'],
                "name, code",
                "tb_vendors",
                0,
                0
            );
            if (!empty($getCarrierName)) {
                $carrierName = $getCarrierName['name'];
                $carrierCode = $getCarrierName['code'];
            }
            $company_code = $this->session->userdata('company_code');
            if (checkAccessConditions('CID_BASED_VEHICLES_DRIVERS', $company_code))
            {
                $user_role_id      = (int) $this->session->userdata('user_role_id');
                if($user_role_id===3) {
                    $userId = $this->session->userdata('id');
                    $vendor = $this->db->query("SELECT code FROM tb_vendors WHERE id = ? AND status=?",[$userId,1]);
                    if($vendor->num_rows() > 0)
                    {
                        $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE code = ? AND company_code = ? AND status=?",[$vendor->row()->code, $company_code, 1]);
                    }
                }
                else {
                    $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE company_code = ? AND status=?",[$company_code, 1]);
                }
                $vendorIds = [];
                if($vendorsList->num_rows() > 0)
                {
                    $vendorIds = array_column($vendorsList->result_array(), 'id');
                }

                $vehicles = $this->Order->getVehicleByAccessCondition($vendorIds, $vehicleType);
            }
            else
            {
                $vehicles = $this->Order->getVehicleByCarrierInfo($carrierId, $vehicleType);
            }
        }
        $data['vehicles'] = $vehicles ?? [];
        $data['carrierName'] = $carrierName ?? "";
        $data['carrierCode'] = $carrierCode ?? "";
        $data['vehicleTypeName'] = $vehicleTypeName ?? "";
        echo json_encode($data);
    }

    public function getDriversByVehicle(): void
    {
        $driverIds = $drivers = [];
        $post = $this->input->post();
        $vehicleNum = $post['vehicleNum'] ?? 0;
        if ($vehicleNum > 0) {
            $vehicleWhereCondition = [
                'vehicle_id' => $vehicleNum,
                'status' => '1'
            ];
            $getPrimaryDriver = $this->common->gettblrowdata(
                ['vehicle_id' => $vehicleNum, 'status' => '1'],
                "driver_id",
                "tbl_assigned_drivers",
                0,
                0
            );
            if (count($getPrimaryDriver) > 0) {
                $driverIds[] = $getPrimaryDriver['driver_id'];
                $vehicleWhereCondition = [
                    'vehicle_id' => $vehicleNum,
                    'driver_id <>' => $getPrimaryDriver['driver_id'],
                    'status' => '1'
                ];
            }
            $getSecondaryDriver = $this->common->gettbldata(
                $vehicleWhereCondition,
                "driver_id",
                "tb_vehicles_drivers",
                0,
                0
            );
            foreach ($getSecondaryDriver as $drivers) {
                $driverIds[] = $drivers['driver_id'];
            }
            if (!empty($driverIds)) {
                $drivers = $this->Order->getDriverDetailsFromIds($driverIds);
            }
        }
        echo json_encode(['drivers' => $drivers]);
    }

    public function searchOrderReferences(): void
    {
        $userIds = [];
        $userIds[] = $this->session->userdata("user_id");
        $countryUserIds = $this->session->userdata("country_user_ids");
        if (!empty($countryUserIds)) {
            $userIds = array_merge($userIds, $countryUserIds);
        }
        $searchTerm = $_POST['searchTerm'] ?? "";
        if ((empty($userIds) || strlen($searchTerm) < 4) && ($this->session->userdata("user_role_id") != 3)) {
            echo json_encode([]);
            return;
        }
        $referenceValues = $this->Order_details->getUserReferencesBySearchTerm($userIds, $searchTerm);
        echo json_encode($referenceValues);
    }

    public function dangerousGoodsPopup(): void
    {
        $post = $this->input->post(null, true);
        $data = [];
        $data['cargoRowId'] = $post['cargoRowId'] ?? 0;
        $data['orderRowId'] = $post['orderRowId'] ?? 0;
        $data['popup'] = $post['popup'] ?? 0;
        if ($data['cargoRowId'] > 0) {
            $data['getGoodsDetails'] = $this->common->gettbldata(['order_cargo_id' => $data['cargoRowId'], 'status' => '1'], "id,num_pkgs,pkg_qty_type,quantity,org_number,org_name,quantity_type,db_class,description,limited_quantity,excepted_quantity,status,createdon,tunnel_restriction_code,environment_hazardous,nos,packing_group,gross_weight,net_weight,netexplosive_mass,liters,fire_works", "tb_order_dg_goods", 0, 0);
        }
        echo $this->load->view('orders/addDangerousGoodsPopup', $data, true);
    }

    public function getUnCodeListForDangerousGoods(): void
    {
        $data = [];
        $getUnData = $this->common->gettbldata(['status' => 1], 'id,un_code,name,class,packing_group,main_risk,sub_level1,sub_level2,sub_level3,sub_level4,nos,adr_multiplicator,tunnel_code,transport_category,classification_code', 'dg_uncode', 0, 0);
        foreach ($getUnData as $eachLine) {
            $inputField = "<input type='radio' name='uncodeList' data-uncode='" . $eachLine['un_code'] . "' data-name='" . $eachLine['name'] . "' data-class='" . $eachLine['class'] . "' data-packing_group='" . $eachLine['packing_group'] . "' data-tunnel_code='" . $eachLine['tunnel_code'] . "' data-transport_category='" . $eachLine['transport_category'] . "' data-nos='" . $eachLine['nos'] . "' data-adr_multiplicator='" . $eachLine['adr_multiplicator'] . "' id='unCode_" . $eachLine['id'] . "' class='unCodeList' value='" . $eachLine['un_code'] . "' onchange='selectUnCodeData(" . $eachLine['id'] . ")'>";
            $data[] = [
                'inputField' => $inputField,
                'unCode' => $eachLine['un_code'],
                'name' => $eachLine['name'],
                'class' => $eachLine['class'],
                'packingGroup' => $eachLine['packing_group'],
                'mainRisk' => $eachLine['main_risk'],
                'subLevel1' => $eachLine['sub_level1'],
                'subLevel2' => $eachLine['sub_level2'],
                'subLevel3' => $eachLine['sub_level3'],
                'subLevel4' => $eachLine['sub_level4'],
                'classificationCode' => $eachLine['classification_code'],
                'nos' => $eachLine['nos'],
                'tunnelCode' => $eachLine['tunnel_code'],
            ];
        }
        echo json_encode($data);
    }

    public function saveDgGoodsForCargo(): void
    {
        $post = $this->input->post(null, true);
        $orderCargoRowId = $post['orderCargoRowId'] ?? 0;
        $orderRowId = $post['orderRowId'] ?? 0;
        $popup = $post['popup'] ?? 0;
        $dgGoodsIds = insertDgGoodsForOrderCargos($post);
        if (!empty($dgGoodsIds)) {
            if ($orderCargoRowId > 0) {
                $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $orderCargoRowId, 'order_id' => $orderRowId], "id IN (" . implode(',', $dgGoodsIds) . ") ");
                $getCargoId = $this->common->gettblrowdata(['id' => $orderCargoRowId], "cargo_id", "tb_order_cargodetails", 0, 0);
                if (!empty($getCargoId)) {
                    $this->common->updatetbledata("tb_cargo_details", ['dg_goods' => '1'], ['id' => $getCargoId['cargo_id']]);
                }
            } else {
                foreach ($dgGoodsIds as $eachId) {
                    if ($popup > 0) {
                        $dgRowInputIds[] = '<input type="hidden" name="dgRowIds[]" value ="' . $eachId . '">';
                    } else {
                        $dgRowInputIds[] = '<input type="hidden" form="cargo_form" name="dgRowIds[]" value ="' . $eachId . '">';
                    }
                }
            }
        }
        echo json_encode(['cargoId' => $orderCargoRowId, 'dgRowInputIds' => $dgRowInputIds ?? []]);
    }

    public function deleteDgGoodsRow(): void
    {
        $post = $this->input->post(null, true);
        $rowId = $post['dgRowId'] ?? 0;
        if ($rowId > 0) {
            $checkRow = $this->common->gettblrowdata(['id' => $rowId], "order_cargo_id", "tb_order_dg_goods", 0, 0);
            if (!empty($checkRow)) {
                $this->common->updatetbledata("tb_order_dg_goods", ['status' => '0'], ['id' => $rowId]);
                $checkOtherRows = $this->common->gettblrowdata(['order_cargo_id' => $checkRow['order_cargo_id'], 'status' => '1'], "id", "tb_order_dg_goods", 0, 0);
                if (empty($checkOtherRows)) {
                    $getCargoId = $this->common->gettblrowdata(['id' => $checkRow['order_cargo_id']], "cargo_id", "tb_order_cargodetails", 0, 0);
                    if (!empty($getCargoId)) {
                        $this->common->updatetbledata("tb_cargo_details", ['dg_goods' => '0'], ['id' => $getCargoId['cargo_id']]);
                    }
                }
            }
        }
        echo 1;
    }
}

?>
