<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class PODCustomerreport extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->model('Aucustreportmodel');
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
        if (!checkUrlAccessForUser('PODCUSTOMERREPORT')) {
            redirect("Forbiddenaccess");
        }

    }
    
    public function index(){
        $data   = $post = $whr= $searchids = $result = array();
        $custid = $this->session->userdata('cust_id');
        $curtz  = $this->session->userdata("usr_tzone")['timezone'];
        $result['page_title'] = $this->lang->line('pod_report');
        $result['sub_title'] = $this->lang->line('leftmenu_reports');
        if($custid != "" && $custid >0){
            $status_search = "";
            if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
                $post = $_POST;
            }
        }
        $whr = $orderTableCondition = array();
        if(!empty($post)){
            $orderTableWhere = "";
            $selectColumns = array('o.id,o.order_id,o.delivery_datetime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address2,o.delivery_address2,o.goods_value,o.transport_mode,o.customer_id,s.createdon as delivered_date,v.name as vendor_name');
            $table_name='tb_orders o';
            $indexColumn='o.id';
            $groupBy='o.id';
            $excludeCountQuery='Yes';
            $whr = $this->searchorders($post);
            $chkdate = 0;
            $fromdate = $todate = "";
            if (isset($post['fromdate'])) {
                if ($post['todate'] != "") {
                    $fromdate = date('Y-m-d', strtotime($post['fromdate']));
                    if (isset($post['todate'])) {
                        if ($post['todate'] != "") {
                            $todate = date('Y-m-d', strtotime($post['todate']));
                        }
                    } else {
                        $todate = date('Y-m-d', strtotime($cdate));
                        $whr["DATE_FORMAT(s.createdon,'%Y-%m-%d') <="] = $todate;
                    }
                    $chkdate = 1;
                }
            }
            if(!empty($whr)){
                foreach($whr as $key=>$value){
                    $value="'$value'";
                    $orderTableCondition[]= $key.$value;
                }
            }
            $orderTableCondition[]= "o.status!= 0";
            $orderTableCondition[]= "o.customer_id = '".$custid."'";
            $orderTableCondition[]= "o.trip_sts= '1'";
            $orderTableWhere= implode(' AND ',$orderTableCondition);
            if($orderTableWhere!=''){
                $orderTableWhere=" and $orderTableWhere ";
            }
            $searchids = isset($post['bookingid']) ? $post['bookingid'] : array();
            if (empty($searchids) && isset($post['container_num']) && ! empty($post['container_num'])) {
                $searchids = $this->GetContainernum($post);
            } elseif (! empty($searchids) && isset($post['container_num']) && ! empty($post['container_num'])) {
                $container_num_arr = $this->GetContainernum($post);
                $searchids = array_intersect($container_num_arr, $searchids);
            }
            if(!empty($searchids) || !empty($whr) ){
                if(!empty($searchids) && sizeof($searchids)>0){
                    $orderIdCondition= implode( "','", $searchids );
                    if($orderIdCondition!=''){
                        $orderTableWhere.=" and o.order_id in ($orderIdCondition)";
                    }
                }
                $wherecondition= $indexColumn."!='' ".$orderTableWhere;
                $dataTableSortOrdering=array();
                $joinsArray[]=array('table_name'=>'tb_stop_status as s','condition'=>"s.order_id=o.id AND s.status_code ='3000' AND s.status ='1'",'join_type'=>'left');
                $joinsArray[]=array('table_name'=>'tb_vendors as v','condition'=>"v.id=o.vendor_id AND v.status ='1'",'join_type'=>'left');
                $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST');
                $reqData=array('id');
                $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
                if(isset($formattedData['commaSeparated']['id'])){
                    $codes="'DQ','CTR','COI'";
                    $multiple_codes = "'PO','LPC'";
                    $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
                    $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
                    $formattedData=$this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'],$formattedData);
                    $formattedData=$this->DataQueryFormatter_model->getOrderReferenceMultipleData($formattedData['commaSeparated']['id'],$formattedData,$multiple_codes);
                    $getRecordListing=array();
                }
                if(isset($formattedData['orders'])){
                    $getRecordListing=$formattedData['orders'];
                    krsort($getRecordListing);
                }
                if(!empty($getRecordListing)){
                    foreach($getRecordListing as $res){
                        $delivery_date = $delivery_dtime = "";
                        if(isset($res['delivered_date'])){
                            $utcdelivery_date = $res['delivered_date'];
                            if ( $utcdelivery_date != "" && $utcdelivery_date != "0000-00-00 00:00:00" ) {
                                $d_date      = getdatetimebytimezone( $curtz, $utcdelivery_date, DFLT_TZ );
                                $delivery_date =  date('Y-m-d',strtotime($d_date['datetime']));
                                $delivery_dtime = date('Y-m-d H:i:s',strtotime($d_date['datetime']));
                            }
                            $sts = 1;
                            if($chkdate == '1'){
                                if($delivery_date >= $fromdate && $delivery_date <= $todate){
                                    $sts = 1;
                                }  else{
                                    $sts = 0;
                                }
                            }else{
                                $sts = 1;
                            }
                            if($sts == '1'){
                                $store_code = $delivery_note = $container_no = $referenceData = $carrierservice = $multiple_referenceData = $purchase_order = $load_plan_connote = "";
                                if (isset($res['reference_value'])) {
                                    $referenceData = $res['reference_value'];
                                }
                                $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                                if (isset($arrayData['DQ'])) {
                                    $delivery_note = $arrayData['DQ'];
                                }
                                if (isset($arrayData['CTR'])) {
                                    $container_no = $arrayData['CTR'];
                                }
                                if (isset($arrayData['COI'])) {
                                    $store_code = $arrayData['COI'];
                                }
                                if (isset($res['multiple_reference_value'])) {
                                    $multiple_referenceData = $res['multiple_reference_value'];
                                }
                                if($multiple_referenceData != ""){
                                    $arrayData1 = $this->formatMultipleReferenceParameters($multiple_referenceData);
                                    if(isset($arrayData1['PO'])){
                                        if(!empty($arrayData1['PO'])){
                                            $purchase_order = implode(",",$arrayData1['PO']);
                                        }
                                    }
                                    if(isset($arrayData1['LPC'])){
                                        if(!empty($arrayData1['LPC'])){
                                            $load_plan_connote = implode(",",$arrayData1['LPC']);
                                        }
                                    }
                                }
                                $scanned_qty  = $res['scanned_quantity'];
                                $total_qty    = $res['totqty'];
                                $total_weight = $res['totwg'];
                                $total_volume = $res['totvolume'];
                                $customer_id = $res['customer_id'];
                                $est_del_date = $pod_available = $receiver_name = "";
                                if ( $res['delivery_datetime'] != "" && $res['delivery_datetime'] != "0000-00-00 00:00:00" ) {
                                    $estd_date      = getdatetimebytimezone( $curtz, $res['delivery_datetime'], DFLT_TZ );
                                    $est_del_date  =  date('Y-m-d',strtotime($estd_date['datetime']));
                                }
                                if(isset($res['pod_available'])){
                                    if ( $res['pod_available'] != "" && $res['pod_available'] != "0000-00-00 00:00:00" ) {
                                        $podavailable = getdatetimebytimezone( $curtz, $res['pod_available'], DFLT_TZ );
                                        $pod_available = date('Y-m-d h:i A',strtotime($podavailable['datetime']));
                                        $receiver_name = $res['receiver_name'];
                                    }
                                }
                                if($load_plan_connote != ""){
                                    $info = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'receiver_name'=>$receiver_name);
                                    $lpc_data = $this->makesinglerowfor_lpc($info,$load_plan_connote);
                                    if(!empty($lpc_data)){
                                        $data = array_merge($data,$lpc_data);
                                    }
                                }else{
                                    if($purchase_order != ""){
                                        $info = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'receiver_name'=>$receiver_name);
                                        $po_data = $this->makesinglerowfor_porder($info,$purchase_order);
                                        if(!empty($po_data)){
                                            $data = array_merge($data,$po_data);
                                        }
                                    }else{
                                        $data[] = array('order_id'=>$res['order_id'],'purchase_order'=>$purchase_order,'container_no'=>$container_no,'load_plan_connote'=>$load_plan_connote,'consignment_note'=>$delivery_note,'goods_value'=>$res['goods_value'],'transport_mode'=>$res['transport_mode'],'shipper_name'=>$res['pickup_company'],'shipper_city'=>$res['pickup_city'],'shipper_state'=>$res['pickup_address2'],'shipper_pincode'=>$res['pickup_pincode'],'consignee_name'=>$res['delivery_company'],'consignee_city'=>$res['delivery_city'],'consignee_state'=>$res['delivery_address2'],'consignee_postaldate'=>$res['delivery_pincode'],'store_code'=>$store_code,'service_type'=>$carrierservice,'goods_desc'=>'','total_pckgs'=>$total_qty,'scanned'=>$scanned_qty,'weight'=>$total_weight,'volume'=>$total_volume,'vendor_name'=>$res['vendor_name'],'est_del_date'=>$est_del_date,'delivery_date'=>$delivery_date,'pod_available'=>$pod_available,'receiver_name'=>$receiver_name);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $result['data'] = $data;
        $this->newtemplate->dashboard('custpodreport/index', $result);
    }
    
    public function getcompletedorderidsbycustid(){
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $subcusts = array();
        $post = $this->input->post();
        $searchTerm = isset($post['searchTerm']) ? $post['searchTerm'] : "";
        $custid = $this->session->userdata("cust_id");
        if($this->session->userdata('sub_cust') !== FALSE){
            $subcusts = $this->session->userdata('sub_cust');
            if(!empty($subcusts)){
                array_push($subcusts, $custid);
            }else{
                $subcusts = array($custid);
            }
        }else{
           $subcusts = array($custid);
        }
        $whr = " trip_sts ='1'";
        $getorderids = $this->Aucustreportmodel->getcompletedorderids($user_id,$subcusts,$searchTerm,$whr);
        if($getorderids->num_rows()>0){
            foreach ($getorderids->result() as $res) {
                $data[] = array("id"=>$res->order_id, "text"=>$res->order_id);
            }
        }
        echo json_encode($data);
    }
    
    private function GetContainernum($post)
    {
        $result = $res = array();

        if (isset($post['container_num']) && $post['container_num'] != "") {
            $user_id = $this->session->userdata('user_id');
            $country_userids = $this->session->userdata("country_user_ids");
            $ref_val = trim($post['container_num']);
            $where_like = array(
                'r.ref_value' => $ref_val
            );
            $whr = array(
                'o.status!=' => '0',
                'o.trip_sts'=>'1',
                'r.reference_id' => 'CTR',
                'r.status' => 1
            );
            $result = $this->Order->getrefvals($whr, $where_like, $user_id, $country_userids);
            if (! empty($result)) {
                $res = array_column($result, "order_id");
            }
        }

        return $res;
    }

    public function makesinglerowfor_lpc($info,$lpc){
        $load_plan_connote = $porder = $result = array();
        $porder_count = $lpc_count = 0;
        $purchase_order = $info['purchase_order'];
        if($purchase_order != ""){
            $porder = explode(',', $purchase_order);
        }
        if($lpc != ""){
            $load_plan_connote = explode(',', $lpc);
        }
        if(!empty($load_plan_connote)){
            $lpc_count = count($load_plan_connote);
        }
        if(!empty($porder)){
            $porder_count = count($porder);
        }
        $last_porder = "";
        if(!empty($load_plan_connote)){
            for ($i=0;$i<count($load_plan_connote);$i++) {

                $po = isset($porder[$i]) ? $porder[$i] : "";
                if($po != ""){
                    $last_porder = $po;
                }
                if($po == ""){
                    $po = $last_porder;
                }
                $result[] = array('order_id'=>$info['order_id'],'purchase_order'=>$po,'container_no'=>$info['container_no'],'load_plan_connote'=>$load_plan_connote[$i],'consignment_note'=>$info['consignment_note'],'goods_value'=>$info['goods_value'],'transport_mode'=>$info['transport_mode'],'shipper_name'=>$info['shipper_name'],'shipper_city'=>$info['shipper_city'],'shipper_state'=>$info['shipper_state'],'shipper_pincode'=>$info['shipper_pincode'],'consignee_name'=>$info['consignee_name'],'consignee_city'=>$info['consignee_city'],'consignee_state'=>$info['consignee_state'],'consignee_postaldate'=>$info['consignee_postaldate'],'store_code'=>$info['store_code'],'service_type'=>$info['service_type'],'goods_desc'=>'','total_pckgs'=>$info['total_pckgs'],'weight'=>$info['weight'],'volume'=>$info['volume'],'vendor_name'=>$info['vendor_name'],'est_del_date'=>$info['est_del_date'],'delivery_date'=>$info['delivery_date'],'pod_available'=>$info['pod_available'],'receiver_name'=>$info['receiver_name']);
            }

        }
        return $result;

    }
 
    public function makesinglerowfor_porder($info,$purchase_order){
        $porder = $result = array();
        if($purchase_order != ""){
            $porder = explode(',', $purchase_order);
        }
        if(!empty($porder)){
            for ($i=0;$i<count($porder);$i++) {
                $result[] = array('order_id'=>$info['order_id'],'purchase_order'=>$porder[$i],'container_no'=>$info['container_no'],'load_plan_connote'=>'','consignment_note'=>$info['consignment_note'],'goods_value'=>$info['goods_value'],'transport_mode'=>$info['transport_mode'],'shipper_name'=>$info['shipper_name'],'shipper_city'=>$info['shipper_city'],'shipper_state'=>$info['shipper_state'],'shipper_pincode'=>$info['shipper_pincode'],'consignee_name'=>$info['consignee_name'],'consignee_city'=>$info['consignee_city'],'consignee_state'=>$info['consignee_state'],'consignee_postaldate'=>$info['consignee_postaldate'],'store_code'=>$info['store_code'],'service_type'=>$info['service_type'],'goods_desc'=>'','total_pckgs'=>$info['total_pckgs'],'weight'=>$info['weight'],'volume'=>$info['volume'],'vendor_name'=>$info['vendor_name'],'est_del_date'=>$info['est_del_date'],'delivery_date'=>$info['delivery_date'],'pod_available'=>$info['pod_available'],'receiver_name'=>$info['receiver_name']);
            }
        }
        return $result;
    }

    public function formatMultipleReferenceParameters($refData){
        $finalReqArray = array();
        $referenceDataArray = explode('?????', $refData);
        if (! empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            $i = 0;
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveArrayReferenceParameters($eachRefData);
                $key = $reqArray['type'];
                $value = $reqArray['value'];
                $finalReqArray[$key][] = $value;
                $i++;
            }
        }
        return $finalReqArray;
    }
 
    public function giveArrayReferenceParameters($referenceParam)
    {
        $finalArray = array();
        if (! empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (! empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray = array('type'=>trim($requiredArray[0]),'value'=>trim($requiredArray[1]));
            }
        }
        return $finalArray;
    }

    public function searchorders($post){
        $whr = array();
        $cdate = date('Y-m-d H:i:s');
        $curtz  = $this->session->userdata("usr_tzone")['timezone'];
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $getactual = getdatetimebytimezone($curtz, $post['fromdate'], DFLT_TZ);
            $logdate = $getactual['datetime'];
            $fromdate = date('Y-m-d', strtotime($logdate));
            $fromdate = date('Y-m-d', strtotime('-1 day', strtotime($fromdate)));
            $whr["DATE_FORMAT(s.createdon,'%Y-%m-%d') >="] = $fromdate;
            if (isset($post['todate'])) {
                if ($post['todate'] != "") {
                    $getactual1 = getdatetimebytimezone($curtz, $post['todate'], DFLT_TZ);
                    $logdate1 = $getactual1['datetime'];
                    $todate = date('Y-m-d', strtotime($logdate1));
                    $todate = date('Y-m-d', strtotime('+1 day', strtotime($todate)));
                    $whr["DATE_FORMAT(s.createdon,'%Y-%m-%d') <="] = $todate;
                }
            } else {
                $todate = date('Y-m-d', strtotime($cdate));
                $whr["DATE_FORMAT(s.createdon,'%Y-%m-%d') <="] = $todate;
            }
        }
        return $whr;
    }
}

?>
